## Example 1
- Language: Ruby
- CI: TravisCI
- Coverage Tool: 
- File: travis.yml
- Single/Parallel: 
- OSS Repo: https://github.com/noahd1/brakeman

```
before_install:
  - gem update bundler

script:
  - "bundle exec ruby test/test.rb"
  - "bundle exec codeclimate-test-reporter"

branches:
  only:
    - master

rvm:
  - "1.9.3"
  - "2.2.7"
  - "2.3.4"
  - "2.4.1"

addons:
  code_climate:
    repo_token: token

sudo: false
```

## Example 2
- Language: Ruby
- CI: TravisCI
- Coverage Tool: RSpec
- File: travis.yml
- Single/Parallel: Parallel
- OSS Repo: https://github.com/cloudfoundry/cloud_controller_ng

```
# The secure URLs below are generated using the following command:
#
# $> gem install travis
# $> travis -v
# $> travis login
# $> travis encrypt --org ENV_VAR_TO_ENCRYPT_NAME=env_var_to_encrypt_value -r cloudfoundry/cloud_controller_ng

language: ruby
bundler_args: --deployment --without development
cache: bundler
sudo: required

rvm:
  - 2.4.2

before_install:
  - gem update --system
  - wget https://github.com/nats-io/gnatsd/releases/download/v0.9.4/gnatsd-v0.9.4-linux-amd64.zip -O /tmp/gnatsd.zip
  - unzip /tmp/gnatsd.zip
  - export PATH=$PATH:$PWD/gnatsd-v0.9.4-linux-amd64

before_script:
  - bundle exec rake db:create
  - DB=mysql bundle exec rake parallel:create
  - DB=postgres bundle exec rake parallel:create
  - curl -L https://codeclimate.com/downloads/test-reporter/test-reporter-latest-linux-amd64 > ./cc-test-reporter
  - chmod +x ./cc-test-reporter
  - ./cc-test-reporter before-build

script:
  - bundle exec rake $TASKS

after_script:
  - ./cc-test-reporter after-build --exit-code $TRAVIS_TEST_RESULT

services:
  - mysql
  - postgresql

env:
  global:
    - CC_TEST_REPORTER_ID=301facccb751b8f202e8a382e9f74bda51055f738691cf2ee9a9b853ac807304
    - CF_RUN_PERM_SPECS=false

  matrix:
    - COVERAGE=true DB=postgres TASKS=spec:all
    - DB=mysql TASKS=spec:all
    - TASKS=rubocop
```

