#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
**pointer_gamut.py**

**Platform:**
    Windows, Linux, Mac Os X.

**Description:**
    Defines **Color** package *Pointer Gamut* data.

**Others:**

"""

from __future__ import unicode_literals

import color.verbose

__author__ = "Thomas Mansencal"
__copyright__ = "Copyright (C) 2013 - 2014 - Thomas Mansencal"
__license__ = "GPL V3.0 - http://www.gnu.org/licenses/"
__maintainer__ = "Thomas Mansencal"
__email__ = "thomas.mansencal@gmail.com"
__status__ = "Production"

__all__ = ["LOGGER",
           "POINTER_GAMUT_DATA"]

LOGGER = color.verbose.install_logger()

# http://www.cis.rit.edu/research/mcsl2/online/PointerData.xls
POINTER_GAMUT_DATA = ((0.659, 0.316),
                      (0.634, 0.351),
                      (0.594, 0.391),
                      (0.557, 0.427),
                      (0.523, 0.462),
                      (0.482, 0.491),
                      (0.444, 0.515),
                      (0.409, 0.546),
                      (0.371, 0.558),
                      (0.332, 0.573),
                      (0.288, 0.584),
                      (0.242, 0.576),
                      (0.202, 0.530),
                      (0.177, 0.454),
                      (0.151, 0.389),
                      (0.151, 0.330),
                      (0.162, 0.295),
                      (0.157, 0.266),
                      (0.159, 0.245),
                      (0.142, 0.214),
                      (0.141, 0.195),
                      (0.129, 0.168),
                      (0.138, 0.141),
                      (0.145, 0.129),
                      (0.145, 0.106),
                      (0.161, 0.094),
                      (0.188, 0.084),
                      (0.252, 0.104),
                      (0.324, 0.127),
                      (0.393, 0.165),
                      (0.451, 0.199),
                      (0.508, 0.226))
