#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
**luminosity.py**

**Platform:**
    Windows, Linux, Mac Os X.

**Description:**
    Defines **Color** package *luminous efficiency functions*.

**Others:**

"""

from __future__ import unicode_literals

import color.spectral
import color.verbose

from color.spectral.spd import SpectralPowerDistribution

__author__ = "Thomas Mansencal"
__copyright__ = "Copyright (C) 2013 - 2014 - Thomas Mansencal"
__license__ = "GPL V3.0 - http://www.gnu.org/licenses/"
__maintainer__ = "Thomas Mansencal"
__email__ = "thomas.mansencal@gmail.com"
__status__ = "Production"

__all__ = ["LOGGER",
           "PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA",
           "PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS",
           "SCOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA",
           "SCOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS"]

LOGGER = color.verbose.install_logger()

# http://www.cvrl.org/lumindex.htm
PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA = {
    "CIE 1924 2 Degree Observer":
        {360: 0.0000039170000,
         361: 0.0000043935810,
         362: 0.0000049296040,
         363: 0.0000055321360,
         364: 0.0000062082450,
         365: 0.0000069650000,
         366: 0.0000078132190,
         367: 0.0000087673360,
         368: 0.0000098398440,
         369: 0.0000110432300,
         370: 0.0000123900000,
         371: 0.0000138864100,
         372: 0.0000155572800,
         373: 0.0000174429600,
         374: 0.0000195837500,
         375: 0.0000220200000,
         376: 0.0000248396500,
         377: 0.0000280412600,
         378: 0.0000315310400,
         379: 0.0000352152100,
         380: 0.0000390000000,
         381: 0.0000428264000,
         382: 0.0000469146000,
         383: 0.0000515896000,
         384: 0.0000571764000,
         385: 0.0000640000000,
         386: 0.0000723442100,
         387: 0.0000822122400,
         388: 0.0000935081600,
         389: 0.0001061361000,
         390: 0.0001200000000,
         391: 0.0001349840000,
         392: 0.0001514920000,
         393: 0.0001702080000,
         394: 0.0001918160000,
         395: 0.0002170000000,
         396: 0.0002469067000,
         397: 0.0002812400000,
         398: 0.0003185200000,
         399: 0.0003572667000,
         400: 0.0003960000000,
         401: 0.0004337147000,
         402: 0.0004730240000,
         403: 0.0005178760000,
         404: 0.0005722187000,
         405: 0.0006400000000,
         406: 0.0007245600000,
         407: 0.0008255000000,
         408: 0.0009411600000,
         409: 0.0010698800000,
         410: 0.0012100000000,
         411: 0.0013620910000,
         412: 0.0015307520000,
         413: 0.0017203680000,
         414: 0.0019353230000,
         415: 0.0021800000000,
         416: 0.0024548000000,
         417: 0.0027640000000,
         418: 0.0031178000000,
         419: 0.0035264000000,
         420: 0.0040000000000,
         421: 0.0045462400000,
         422: 0.0051593200000,
         423: 0.0058292800000,
         424: 0.0065461600000,
         425: 0.0073000000000,
         426: 0.0080865070000,
         427: 0.0089087200000,
         428: 0.0097676800000,
         429: 0.0106644300000,
         430: 0.0116000000000,
         431: 0.0125731700000,
         432: 0.0135827200000,
         433: 0.0146296800000,
         434: 0.0157150900000,
         435: 0.0168400000000,
         436: 0.0180073600000,
         437: 0.0192144800000,
         438: 0.0204539200000,
         439: 0.0217182400000,
         440: 0.0230000000000,
         441: 0.0242946100000,
         442: 0.0256102400000,
         443: 0.0269585700000,
         444: 0.0283512500000,
         445: 0.0298000000000,
         446: 0.0313108300000,
         447: 0.0328836800000,
         448: 0.0345211200000,
         449: 0.0362257100000,
         450: 0.0380000000000,
         451: 0.0398466700000,
         452: 0.0417680000000,
         453: 0.0437660000000,
         454: 0.0458426700000,
         455: 0.0480000000000,
         456: 0.0502436800000,
         457: 0.0525730400000,
         458: 0.0549805600000,
         459: 0.0574587200000,
         460: 0.0600000000000,
         461: 0.0626019700000,
         462: 0.0652775200000,
         463: 0.0680420800000,
         464: 0.0709110900000,
         465: 0.0739000000000,
         466: 0.0770160000000,
         467: 0.0802664000000,
         468: 0.0836668000000,
         469: 0.0872328000000,
         470: 0.0909800000000,
         471: 0.0949175500000,
         472: 0.0990458400000,
         473: 0.1033674000000,
         474: 0.1078846000000,
         475: 0.1126000000000,
         476: 0.1175320000000,
         477: 0.1226744000000,
         478: 0.1279928000000,
         479: 0.1334528000000,
         480: 0.1390200000000,
         481: 0.1446764000000,
         482: 0.1504693000000,
         483: 0.1564619000000,
         484: 0.1627177000000,
         485: 0.1693000000000,
         486: 0.1762431000000,
         487: 0.1835581000000,
         488: 0.1912735000000,
         489: 0.1994180000000,
         490: 0.2080200000000,
         491: 0.2171199000000,
         492: 0.2267345000000,
         493: 0.2368571000000,
         494: 0.2474812000000,
         495: 0.2586000000000,
         496: 0.2701849000000,
         497: 0.2822939000000,
         498: 0.2950505000000,
         499: 0.3085780000000,
         500: 0.3230000000000,
         501: 0.3384021000000,
         502: 0.3546858000000,
         503: 0.3716986000000,
         504: 0.3892875000000,
         505: 0.4073000000000,
         506: 0.4256299000000,
         507: 0.4443096000000,
         508: 0.4633944000000,
         509: 0.4829395000000,
         510: 0.5030000000000,
         511: 0.5235693000000,
         512: 0.5445120000000,
         513: 0.5656900000000,
         514: 0.5869653000000,
         515: 0.6082000000000,
         516: 0.6293456000000,
         517: 0.6503068000000,
         518: 0.6708752000000,
         519: 0.6908424000000,
         520: 0.7100000000000,
         521: 0.7281852000000,
         522: 0.7454636000000,
         523: 0.7619694000000,
         524: 0.7778368000000,
         525: 0.7932000000000,
         526: 0.8081104000000,
         527: 0.8224962000000,
         528: 0.8363068000000,
         529: 0.8494916000000,
         530: 0.8620000000000,
         531: 0.8738108000000,
         532: 0.8849624000000,
         533: 0.8954936000000,
         534: 0.9054432000000,
         535: 0.9148501000000,
         536: 0.9237348000000,
         537: 0.9320924000000,
         538: 0.9399226000000,
         539: 0.9472252000000,
         540: 0.9540000000000,
         541: 0.9602561000000,
         542: 0.9660074000000,
         543: 0.9712606000000,
         544: 0.9760225000000,
         545: 0.9803000000000,
         546: 0.9840924000000,
         547: 0.9874182000000,
         548: 0.9903128000000,
         549: 0.9928116000000,
         550: 0.9949501000000,
         551: 0.9967108000000,
         552: 0.9980983000000,
         553: 0.9991120000000,
         554: 0.9997482000000,
         555: 1.0000000000000,
         556: 0.9998567000000,
         557: 0.9993046000000,
         558: 0.9983255000000,
         559: 0.9968987000000,
         560: 0.9950000000000,
         561: 0.9926005000000,
         562: 0.9897426000000,
         563: 0.9864444000000,
         564: 0.9827241000000,
         565: 0.9786000000000,
         566: 0.9740837000000,
         567: 0.9691712000000,
         568: 0.9638568000000,
         569: 0.9581349000000,
         570: 0.9520000000000,
         571: 0.9454504000000,
         572: 0.9384992000000,
         573: 0.9311628000000,
         574: 0.9234576000000,
         575: 0.9154000000000,
         576: 0.9070064000000,
         577: 0.8982772000000,
         578: 0.8892048000000,
         579: 0.8797816000000,
         580: 0.8700000000000,
         581: 0.8598613000000,
         582: 0.8493920000000,
         583: 0.8386220000000,
         584: 0.8275813000000,
         585: 0.8163000000000,
         586: 0.8047947000000,
         587: 0.7930820000000,
         588: 0.7811920000000,
         589: 0.7691547000000,
         590: 0.7570000000000,
         591: 0.7447541000000,
         592: 0.7324224000000,
         593: 0.7200036000000,
         594: 0.7074965000000,
         595: 0.6949000000000,
         596: 0.6822192000000,
         597: 0.6694716000000,
         598: 0.6566744000000,
         599: 0.6438448000000,
         600: 0.6310000000000,
         601: 0.6181555000000,
         602: 0.6053144000000,
         603: 0.5924756000000,
         604: 0.5796379000000,
         605: 0.5668000000000,
         606: 0.5539611000000,
         607: 0.5411372000000,
         608: 0.5283528000000,
         609: 0.5156323000000,
         610: 0.5030000000000,
         611: 0.4904688000000,
         612: 0.4780304000000,
         613: 0.4656776000000,
         614: 0.4534032000000,
         615: 0.4412000000000,
         616: 0.4290800000000,
         617: 0.4170360000000,
         618: 0.4050320000000,
         619: 0.3930320000000,
         620: 0.3810000000000,
         621: 0.3689184000000,
         622: 0.3568272000000,
         623: 0.3447768000000,
         624: 0.3328176000000,
         625: 0.3210000000000,
         626: 0.3093381000000,
         627: 0.2978504000000,
         628: 0.2865936000000,
         629: 0.2756245000000,
         630: 0.2650000000000,
         631: 0.2547632000000,
         632: 0.2448896000000,
         633: 0.2353344000000,
         634: 0.2260528000000,
         635: 0.2170000000000,
         636: 0.2081616000000,
         637: 0.1995488000000,
         638: 0.1911552000000,
         639: 0.1829744000000,
         640: 0.1750000000000,
         641: 0.1672235000000,
         642: 0.1596464000000,
         643: 0.1522776000000,
         644: 0.1451259000000,
         645: 0.1382000000000,
         646: 0.1315003000000,
         647: 0.1250248000000,
         648: 0.1187792000000,
         649: 0.1127691000000,
         650: 0.1070000000000,
         651: 0.1014762000000,
         652: 0.0961886400000,
         653: 0.0911229600000,
         654: 0.0862648500000,
         655: 0.0816000000000,
         656: 0.0771206400000,
         657: 0.0728255200000,
         658: 0.0687100800000,
         659: 0.0647697600000,
         660: 0.0610000000000,
         661: 0.0573962100000,
         662: 0.0539550400000,
         663: 0.0506737600000,
         664: 0.0475496500000,
         665: 0.0445800000000,
         666: 0.0417587200000,
         667: 0.0390849600000,
         668: 0.0365638400000,
         669: 0.0342004800000,
         670: 0.0320000000000,
         671: 0.0299626100000,
         672: 0.0280766400000,
         673: 0.0263293600000,
         674: 0.0247080500000,
         675: 0.0232000000000,
         676: 0.0218007700000,
         677: 0.0205011200000,
         678: 0.0192810800000,
         679: 0.0181206900000,
         680: 0.0170000000000,
         681: 0.0159037900000,
         682: 0.0148371800000,
         683: 0.0138106800000,
         684: 0.0128347800000,
         685: 0.0119200000000,
         686: 0.0110683100000,
         687: 0.0102733900000,
         688: 0.0095333110000,
         689: 0.0088461570000,
         690: 0.0082100000000,
         691: 0.0076237810000,
         692: 0.0070854240000,
         693: 0.0065914760000,
         694: 0.0061384850000,
         695: 0.0057230000000,
         696: 0.0053430590000,
         697: 0.0049957960000,
         698: 0.0046764040000,
         699: 0.0043800750000,
         700: 0.0041020000000,
         701: 0.0038384530000,
         702: 0.0035890990000,
         703: 0.0033542190000,
         704: 0.0031340930000,
         705: 0.0029290000000,
         706: 0.0027381390000,
         707: 0.0025598760000,
         708: 0.0023932440000,
         709: 0.0022372750000,
         710: 0.0020910000000,
         711: 0.0019535870000,
         712: 0.0018245800000,
         713: 0.0017035800000,
         714: 0.0015901870000,
         715: 0.0014840000000,
         716: 0.0013844960000,
         717: 0.0012912680000,
         718: 0.0012040920000,
         719: 0.0011227440000,
         720: 0.0010470000000,
         721: 0.0009765896000,
         722: 0.0009111088000,
         723: 0.0008501332000,
         724: 0.0007932384000,
         725: 0.0007400000000,
         726: 0.0006900827000,
         727: 0.0006433100000,
         728: 0.0005994960000,
         729: 0.0005584547000,
         730: 0.0005200000000,
         731: 0.0004839136000,
         732: 0.0004500528000,
         733: 0.0004183452000,
         734: 0.0003887184000,
         735: 0.0003611000000,
         736: 0.0003353835000,
         737: 0.0003114404000,
         738: 0.0002891656000,
         739: 0.0002684539000,
         740: 0.0002492000000,
         741: 0.0002313019000,
         742: 0.0002146856000,
         743: 0.0001992884000,
         744: 0.0001850475000,
         745: 0.0001719000000,
         746: 0.0001597781000,
         747: 0.0001486044000,
         748: 0.0001383016000,
         749: 0.0001287925000,
         750: 0.0001200000000,
         751: 0.0001118595000,
         752: 0.0001043224000,
         753: 0.0000973356000,
         754: 0.0000908458700,
         755: 0.0000848000000,
         756: 0.0000791466700,
         757: 0.0000738580000,
         758: 0.0000689160000,
         759: 0.0000643026700,
         760: 0.0000600000000,
         761: 0.0000559818700,
         762: 0.0000522256000,
         763: 0.0000487184000,
         764: 0.0000454474700,
         765: 0.0000424000000,
         766: 0.0000395610400,
         767: 0.0000369151200,
         768: 0.0000344486800,
         769: 0.0000321481600,
         770: 0.0000300000000,
         771: 0.0000279912500,
         772: 0.0000261135600,
         773: 0.0000243602400,
         774: 0.0000227246100,
         775: 0.0000212000000,
         776: 0.0000197785500,
         777: 0.0000184528500,
         778: 0.0000172168700,
         779: 0.0000160645900,
         780: 0.0000149900000,
         781: 0.0000139872800,
         782: 0.0000130515500,
         783: 0.0000121781800,
         784: 0.0000113625400,
         785: 0.0000106000000,
         786: 0.0000098858770,
         787: 0.0000092173040,
         788: 0.0000085923620,
         789: 0.0000080091330,
         790: 0.0000074657000,
         791: 0.0000069595670,
         792: 0.0000064879950,
         793: 0.0000060486990,
         794: 0.0000056393960,
         795: 0.0000052578000,
         796: 0.0000049017710,
         797: 0.0000045697200,
         798: 0.0000042601940,
         799: 0.0000039717390,
         800: 0.0000037029000,
         801: 0.0000034521630,
         802: 0.0000032183020,
         803: 0.0000030003000,
         804: 0.0000027971390,
         805: 0.0000026078000,
         806: 0.0000024312200,
         807: 0.0000022665310,
         808: 0.0000021130130,
         809: 0.0000019699430,
         810: 0.0000018366000,
         811: 0.0000017122300,
         812: 0.0000015962280,
         813: 0.0000014880900,
         814: 0.0000013873140,
         815: 0.0000012934000,
         816: 0.0000012058200,
         817: 0.0000011241430,
         818: 0.0000010480090,
         819: 0.0000009770578,
         820: 0.0000009109300,
         821: 0.0000008492513,
         822: 0.0000007917212,
         823: 0.0000007380904,
         824: 0.0000006881098,
         825: 0.0000006415300,
         826: 0.0000005980895,
         827: 0.0000005575746,
         828: 0.0000005198080,
         829: 0.0000004846123,
         830: 0.0000004518100,
        },
    "Judd Modified CIE 1951 2 Degree Observer":
        {370: 0.0001,
         380: 0.0004,
         390: 0.0015,
         400: 0.0045,
         410: 0.0093,
         420: 0.0175,
         430: 0.0273,
         440: 0.0379,
         450: 0.0468,
         460: 0.0600,
         470: 0.0910,
         480: 0.1390,
         490: 0.2080,
         500: 0.3230,
         510: 0.5030,
         520: 0.7100,
         530: 0.8620,
         540: 0.9540,
         550: 0.9950,
         560: 0.9950,
         570: 0.9520,
         580: 0.8700,
         590: 0.7570,
         600: 0.6310,
         610: 0.5030,
         620: 0.3810,
         630: 0.2650,
         640: 0.1750,
         650: 0.1070,
         660: 0.0610,
         670: 0.0320,
         680: 0.0170,
         690: 0.0082,
         700: 0.0041,
         710: 0.0021,
         720: 0.0011,
         730: 0.0005,
         740: 0.0002,
         750: 0.0001,
         760: 0.0001,
         770: 0.0000,
        },
    "Judd-Vos Modified CIE 1978 2 Degree Observer":
        {380: 0.0002000000,
         381: 0.0002282100,
         382: 0.0002610900,
         383: 0.0002993600,
         384: 0.0003438700,
         385: 0.0003955600,
         386: 0.0004554400,
         387: 0.0005246200,
         388: 0.0006042800,
         389: 0.0006956500,
         390: 0.0008000000,
         391: 0.0009163500,
         392: 0.0010477000,
         393: 0.0011955000,
         394: 0.0013611000,
         395: 0.0015457000,
         396: 0.0017508000,
         397: 0.0018776000,
         398: 0.0022273000,
         399: 0.0025011000,
         400: 0.0028000000,
         401: 0.0031159000,
         402: 0.0034576000,
         403: 0.0038268000,
         404: 0.0042256000,
         405: 0.0046562000,
         406: 0.0051216000,
         407: 0.0056248000,
         408: 0.0061695000,
         409: 0.0067597000,
         410: 0.0074000000,
         411: 0.0081451000,
         412: 0.0089555000,
         413: 0.0098322000,
         414: 0.0107740000,
         415: 0.0117790000,
         416: 0.0128420000,
         417: 0.0139560000,
         418: 0.0151110000,
         419: 0.0162970000,
         420: 0.0175000000,
         421: 0.0185820000,
         422: 0.0196450000,
         423: 0.0206830000,
         424: 0.0216940000,
         425: 0.0226780000,
         426: 0.0236360000,
         427: 0.0245720000,
         428: 0.0254900000,
         429: 0.0263970000,
         430: 0.0273000000,
         431: 0.0283350000,
         432: 0.0293830000,
         433: 0.0304420000,
         434: 0.0315100000,
         435: 0.0325840000,
         436: 0.0336610000,
         437: 0.0347350000,
         438: 0.0358030000,
         439: 0.0368600000,
         440: 0.0379000000,
         441: 0.0388380000,
         442: 0.0397520000,
         443: 0.0406460000,
         444: 0.0415240000,
         445: 0.0423910000,
         446: 0.0432520000,
         447: 0.0441160000,
         448: 0.0449900000,
         449: 0.0458810000,
         450: 0.0468000000,
         451: 0.0477430000,
         452: 0.0487330000,
         453: 0.0497850000,
         454: 0.0509100000,
         455: 0.0521220000,
         456: 0.0534350000,
         457: 0.0548640000,
         458: 0.0564240000,
         459: 0.0581310000,
         460: 0.0600000000,
         461: 0.0626019700,
         462: 0.0652775200,
         463: 0.0680420800,
         464: 0.0709110900,
         465: 0.0739000000,
         466: 0.0770160000,
         467: 0.0802664000,
         468: 0.0836668000,
         469: 0.0872328000,
         470: 0.0909800000,
         471: 0.0949175500,
         472: 0.0990458400,
         473: 0.1033674000,
         474: 0.1078846000,
         475: 0.1126000000,
         476: 0.1175320000,
         477: 0.1226744000,
         478: 0.1279928000,
         479: 0.1334528000,
         480: 0.1390200000,
         481: 0.1446764000,
         482: 0.1504693000,
         483: 0.1564619000,
         484: 0.1627177000,
         485: 0.1693000000,
         486: 0.1762431000,
         487: 0.1835581000,
         488: 0.1912735000,
         489: 0.1994180000,
         490: 0.2080200000,
         491: 0.2171199000,
         492: 0.2267345000,
         493: 0.2368571000,
         494: 0.2474812000,
         495: 0.2586000000,
         496: 0.2701849000,
         497: 0.2822939000,
         498: 0.2950505000,
         499: 0.3085780000,
         500: 0.3230000000,
         501: 0.3384021000,
         502: 0.3546858000,
         503: 0.3716986000,
         504: 0.3892875000,
         505: 0.4073000000,
         506: 0.4256299000,
         507: 0.4443096000,
         508: 0.4633944000,
         509: 0.4829395000,
         510: 0.5030000000,
         511: 0.5235693000,
         512: 0.5445120000,
         513: 0.5656900000,
         514: 0.5869653000,
         515: 0.6082000000,
         516: 0.6293456000,
         517: 0.6503068000,
         518: 0.6708752000,
         519: 0.6908424000,
         520: 0.7100000000,
         521: 0.7281852000,
         522: 0.7454636000,
         523: 0.7619694000,
         524: 0.7778368000,
         525: 0.7932000000,
         526: 0.8081104000,
         527: 0.8224962000,
         528: 0.8363068000,
         529: 0.8494916000,
         530: 0.8620000000,
         531: 0.8738108000,
         532: 0.8849624000,
         533: 0.8954936000,
         534: 0.9054432000,
         535: 0.9148501000,
         536: 0.9237348000,
         537: 0.9320924000,
         538: 0.9399226000,
         539: 0.9472252000,
         540: 0.9540000000,
         541: 0.9602561000,
         542: 0.9660074000,
         543: 0.9712606000,
         544: 0.9760225000,
         545: 0.9803000000,
         546: 0.9840924000,
         547: 0.9874182000,
         548: 0.9903128000,
         549: 0.9928116000,
         550: 0.9949501000,
         551: 0.9967108000,
         552: 0.9980983000,
         553: 0.9991120000,
         554: 0.9997482000,
         555: 1.0000000000,
         556: 0.9998567000,
         557: 0.9993046000,
         558: 0.9983255000,
         559: 0.9968987000,
         560: 0.9950000000,
         561: 0.9926005000,
         562: 0.9897426000,
         563: 0.9864444000,
         564: 0.9827241000,
         565: 0.9786000000,
         566: 0.9740837000,
         567: 0.9691712000,
         568: 0.9638568000,
         569: 0.9581349000,
         570: 0.9520000000,
         571: 0.9454504000,
         572: 0.9384992000,
         573: 0.9311628000,
         574: 0.9234576000,
         575: 0.9154000000,
         576: 0.9070064000,
         577: 0.8982772000,
         578: 0.8892048000,
         579: 0.8797816000,
         580: 0.8700000000,
         581: 0.8598613000,
         582: 0.8493920000,
         583: 0.8386220000,
         584: 0.8275813000,
         585: 0.8163000000,
         586: 0.8047947000,
         587: 0.7930820000,
         588: 0.7811920000,
         589: 0.7691547000,
         590: 0.7570000000,
         591: 0.7447541000,
         592: 0.7324224000,
         593: 0.7200036000,
         594: 0.7074965000,
         595: 0.6949000000,
         596: 0.6822192000,
         597: 0.6694716000,
         598: 0.6566744000,
         599: 0.6438448000,
         600: 0.6310000000,
         601: 0.6181555000,
         602: 0.6053144000,
         603: 0.5924756000,
         604: 0.5796379000,
         605: 0.5668000000,
         606: 0.5539611000,
         607: 0.5411372000,
         608: 0.5283528000,
         609: 0.5156323000,
         610: 0.5030000000,
         611: 0.4904688000,
         612: 0.4780304000,
         613: 0.4656776000,
         614: 0.4534032000,
         615: 0.4412000000,
         616: 0.4290800000,
         617: 0.4170360000,
         618: 0.4050320000,
         619: 0.3930320000,
         620: 0.3810000000,
         621: 0.3689184000,
         622: 0.3568272000,
         623: 0.3447768000,
         624: 0.3328176000,
         625: 0.3210000000,
         626: 0.3093381000,
         627: 0.2978504000,
         628: 0.2865936000,
         629: 0.2756245000,
         630: 0.2650000000,
         631: 0.2547632000,
         632: 0.2448896000,
         633: 0.2353344000,
         634: 0.2260528000,
         635: 0.2170000000,
         636: 0.2081616000,
         637: 0.1995488000,
         638: 0.1911552000,
         639: 0.1829744000,
         640: 0.1750000000,
         641: 0.1672235000,
         642: 0.1596464000,
         643: 0.1522776000,
         644: 0.1451259000,
         645: 0.1382000000,
         646: 0.1315003000,
         647: 0.1250248000,
         648: 0.1187792000,
         649: 0.1127691000,
         650: 0.1070000000,
         651: 0.1014762000,
         652: 0.0961886400,
         653: 0.0911229600,
         654: 0.0862648500,
         655: 0.0816000000,
         656: 0.0771206400,
         657: 0.0728255200,
         658: 0.0687100800,
         659: 0.0647697600,
         660: 0.0610000000,
         661: 0.0573962100,
         662: 0.0539550400,
         663: 0.0506737600,
         664: 0.0475496500,
         665: 0.0445800000,
         666: 0.0417587200,
         667: 0.0390849600,
         668: 0.0365638400,
         669: 0.0342004800,
         670: 0.0320000000,
         671: 0.0299626100,
         672: 0.0280766400,
         673: 0.0263293600,
         674: 0.0247080500,
         675: 0.0232000000,
         676: 0.0218007700,
         677: 0.0205011200,
         678: 0.0192810800,
         679: 0.0181206900,
         680: 0.0170000000,
         681: 0.0159037900,
         682: 0.0148371800,
         683: 0.0138106800,
         684: 0.0128347800,
         685: 0.0119200000,
         686: 0.0110683100,
         687: 0.0102733900,
         688: 0.0095333110,
         689: 0.0088461570,
         690: 0.0082100000,
         691: 0.0076237810,
         692: 0.0070854240,
         693: 0.0065914760,
         694: 0.0061384850,
         695: 0.0057230000,
         696: 0.0053430590,
         697: 0.0049957960,
         698: 0.0046764040,
         699: 0.0043800750,
         700: 0.0041020000,
         701: 0.0038384530,
         702: 0.0035890990,
         703: 0.0033542190,
         704: 0.0031340930,
         705: 0.0029290000,
         706: 0.0027381390,
         707: 0.0025598760,
         708: 0.0023932440,
         709: 0.0022372750,
         710: 0.0020910000,
         711: 0.0019535870,
         712: 0.0018245800,
         713: 0.0017035800,
         714: 0.0015901870,
         715: 0.0014840000,
         716: 0.0013844960,
         717: 0.0012912680,
         718: 0.0012040920,
         719: 0.0011227440,
         720: 0.0010470000,
         721: 0.0009765896,
         722: 0.0009111088,
         723: 0.0008501332,
         724: 0.0007932384,
         725: 0.0007400000,
         726: 0.0006900827,
         727: 0.0006433100,
         728: 0.0005994960,
         729: 0.0005584547,
         730: 0.0005200000,
         731: 0.0004839136,
         732: 0.0004500528,
         733: 0.0004183452,
         734: 0.0003887184,
         735: 0.0003611000,
         736: 0.0003353835,
         737: 0.0003114404,
         738: 0.0002891656,
         739: 0.0002684539,
         740: 0.0002492000,
         741: 0.0002313019,
         742: 0.0002146856,
         743: 0.0001992884,
         744: 0.0001850475,
         745: 0.0001719000,
         746: 0.0001597781,
         747: 0.0001486044,
         748: 0.0001383016,
         749: 0.0001287925,
         750: 0.0001200000,
         751: 0.0001118595,
         752: 0.0001043224,
         753: 0.0000973356,
         754: 0.0000908459,
         755: 0.0000848000,
         756: 0.0000791467,
         757: 0.0000738580,
         758: 0.0000689160,
         759: 0.0000643027,
         760: 0.0000600000,
         761: 0.0000559819,
         762: 0.0000522256,
         763: 0.0000487184,
         764: 0.0000454475,
         765: 0.0000424000,
         766: 0.0000395610,
         767: 0.0000369151,
         768: 0.0000344487,
         769: 0.0000321482,
         770: 0.0000300000,
         771: 0.0000279913,
         772: 0.0000261136,
         773: 0.0000243602,
         774: 0.0000227246,
         775: 0.0000212000,
         776: 0.0000197786,
         777: 0.0000184529,
         778: 0.0000172169,
         779: 0.0000160646,
         780: 0.0000149900,
        },
    "Stockman, Jagle, Pirzer & Sharpe CIE 2008 2 Degree Observer":
        {390: 4.14616E-04,
         391: 5.02833E-04,
         392: 6.08499E-04,
         393: 7.34444E-04,
         394: 8.83739E-04,
         395: 1.05965E-03,
         396: 1.26553E-03,
         397: 1.50475E-03,
         398: 1.78049E-03,
         399: 2.09557E-03,
         400: 2.45219E-03,
         401: 2.85222E-03,
         402: 3.29912E-03,
         403: 3.79747E-03,
         404: 4.35277E-03,
         405: 4.97172E-03,
         406: 5.66101E-03,
         407: 6.42161E-03,
         408: 7.25031E-03,
         409: 8.14017E-03,
         410: 9.07986E-03,
         411: 1.00561E-02,
         412: 1.10646E-02,
         413: 1.21052E-02,
         414: 1.31801E-02,
         415: 1.42938E-02,
         416: 1.54500E-02,
         417: 1.66409E-02,
         418: 1.78530E-02,
         419: 1.90702E-02,
         420: 2.02737E-02,
         421: 2.14481E-02,
         422: 2.26004E-02,
         423: 2.37479E-02,
         424: 2.49125E-02,
         425: 2.61211E-02,
         426: 2.73992E-02,
         427: 2.87499E-02,
         428: 3.01691E-02,
         429: 3.16514E-02,
         430: 3.31904E-02,
         431: 3.47791E-02,
         432: 3.64149E-02,
         433: 3.80957E-02,
         434: 3.98184E-02,
         435: 4.15794E-02,
         436: 4.33710E-02,
         437: 4.51718E-02,
         438: 4.69542E-02,
         439: 4.86872E-02,
         440: 5.03366E-02,
         441: 5.18761E-02,
         442: 5.33222E-02,
         443: 5.47060E-02,
         444: 5.60634E-02,
         445: 5.74339E-02,
         446: 5.88511E-02,
         447: 6.03081E-02,
         448: 6.17864E-02,
         449: 6.32657E-02,
         450: 6.47235E-02,
         451: 6.61475E-02,
         452: 6.75726E-02,
         453: 6.90493E-02,
         454: 7.06328E-02,
         455: 7.23834E-02,
         456: 7.43596E-02,
         457: 7.65938E-02,
         458: 7.91144E-02,
         459: 8.19535E-02,
         460: 8.51482E-02,
         461: 8.87266E-02,
         462: 9.26601E-02,
         463: 9.68972E-02,
         464: 1.01375E-01,
         465: 1.06014E-01,
         466: 1.10738E-01,
         467: 1.15511E-01,
         468: 1.20312E-01,
         469: 1.25116E-01,
         470: 1.29896E-01,
         471: 1.34630E-01,
         472: 1.39331E-01,
         473: 1.44023E-01,
         474: 1.48737E-01,
         475: 1.53507E-01,
         476: 1.58364E-01,
         477: 1.63320E-01,
         478: 1.68376E-01,
         479: 1.73537E-01,
         480: 1.78805E-01,
         481: 1.84182E-01,
         482: 1.89656E-01,
         483: 1.95210E-01,
         484: 2.00826E-01,
         485: 2.06483E-01,
         486: 2.12183E-01,
         487: 2.18028E-01,
         488: 2.24159E-01,
         489: 2.30730E-01,
         490: 2.37916E-01,
         491: 2.45871E-01,
         492: 2.54602E-01,
         493: 2.64076E-01,
         494: 2.74249E-01,
         495: 2.85068E-01,
         496: 2.96484E-01,
         497: 3.08501E-01,
         498: 3.21139E-01,
         499: 3.34418E-01,
         500: 3.48354E-01,
         501: 3.62960E-01,
         502: 3.78228E-01,
         503: 3.94136E-01,
         504: 4.10658E-01,
         505: 4.27760E-01,
         506: 4.45399E-01,
         507: 4.63540E-01,
         508: 4.82138E-01,
         509: 5.01143E-01,
         510: 5.20497E-01,
         511: 5.40139E-01,
         512: 5.60021E-01,
         513: 5.80097E-01,
         514: 6.00317E-01,
         515: 6.20626E-01,
         516: 6.40940E-01,
         517: 6.61077E-01,
         518: 6.80813E-01,
         519: 6.99904E-01,
         520: 7.18089E-01,
         521: 7.35159E-01,
         522: 7.51182E-01,
         523: 7.66314E-01,
         524: 7.80735E-01,
         525: 7.94645E-01,
         526: 8.08207E-01,
         527: 8.21382E-01,
         528: 8.34070E-01,
         529: 8.46171E-01,
         530: 8.57580E-01,
         531: 8.68241E-01,
         532: 8.78306E-01,
         533: 8.87991E-01,
         534: 8.97521E-01,
         535: 9.07135E-01,
         536: 9.16995E-01,
         537: 9.26929E-01,
         538: 9.36673E-01,
         539: 9.45948E-01,
         540: 9.54468E-01,
         541: 9.61983E-01,
         542: 9.68439E-01,
         543: 9.73829E-01,
         544: 9.78152E-01,
         545: 9.81411E-01,
         546: 9.83667E-01,
         547: 9.85208E-01,
         548: 9.86381E-01,
         549: 9.87536E-01,
         550: 9.89023E-01,
         551: 9.91081E-01,
         552: 9.93491E-01,
         553: 9.95917E-01,
         554: 9.98021E-01,
         555: 9.99461E-01,
         556: 9.99993E-01,
         557: 9.99756E-01,
         558: 9.98984E-01,
         559: 9.97912E-01,
         560: 9.96774E-01,
         561: 9.95736E-01,
         562: 9.94711E-01,
         563: 9.93553E-01,
         564: 9.92116E-01,
         565: 9.90255E-01,
         566: 9.87860E-01,
         567: 9.84932E-01,
         568: 9.81504E-01,
         569: 9.77603E-01,
         570: 9.73261E-01,
         571: 9.68476E-01,
         572: 9.63137E-01,
         573: 9.57106E-01,
         574: 9.50254E-01,
         575: 9.42457E-01,
         576: 9.33690E-01,
         577: 9.24289E-01,
         578: 9.14671E-01,
         579: 9.05233E-01,
         580: 8.96361E-01,
         581: 8.88307E-01,
         582: 8.80846E-01,
         583: 8.73645E-01,
         584: 8.66376E-01,
         585: 8.58720E-01,
         586: 8.50430E-01,
         587: 8.41505E-01,
         588: 8.32011E-01,
         589: 8.22015E-01,
         590: 8.11587E-01,
         591: 8.00787E-01,
         592: 7.89652E-01,
         593: 7.78205E-01,
         594: 7.66473E-01,
         595: 7.54479E-01,
         596: 7.42247E-01,
         597: 7.29823E-01,
         598: 7.17252E-01,
         599: 7.04582E-01,
         600: 6.91855E-01,
         601: 6.79101E-01,
         602: 6.66285E-01,
         603: 6.53359E-01,
         604: 6.40281E-01,
         605: 6.27007E-01,
         606: 6.13515E-01,
         607: 5.99849E-01,
         608: 5.86068E-01,
         609: 5.72226E-01,
         610: 5.58375E-01,
         611: 5.44554E-01,
         612: 5.30767E-01,
         613: 5.17013E-01,
         614: 5.03289E-01,
         615: 4.89595E-01,
         616: 4.75944E-01,
         617: 4.62396E-01,
         618: 4.49015E-01,
         619: 4.35862E-01,
         620: 4.22990E-01,
         621: 4.10415E-01,
         622: 3.98036E-01,
         623: 3.85730E-01,
         624: 3.73391E-01,
         625: 3.60924E-01,
         626: 3.48286E-01,
         627: 3.35570E-01,
         628: 3.22896E-01,
         629: 3.10370E-01,
         630: 2.98086E-01,
         631: 2.86116E-01,
         632: 2.74482E-01,
         633: 2.63195E-01,
         634: 2.52263E-01,
         635: 2.41690E-01,
         636: 2.31481E-01,
         637: 2.21638E-01,
         638: 2.12162E-01,
         639: 2.03054E-01,
         640: 1.94312E-01,
         641: 1.85923E-01,
         642: 1.77827E-01,
         643: 1.69965E-01,
         644: 1.62284E-01,
         645: 1.54740E-01,
         646: 1.47308E-01,
         647: 1.40017E-01,
         648: 1.32901E-01,
         649: 1.25991E-01,
         650: 1.19312E-01,
         651: 1.12882E-01,
         652: 1.06711E-01,
         653: 1.00805E-01,
         654: 9.51665E-02,
         655: 8.97959E-02,
         656: 8.46904E-02,
         657: 7.98401E-02,
         658: 7.52337E-02,
         659: 7.08606E-02,
         660: 6.67104E-02,
         661: 6.27736E-02,
         662: 5.90418E-02,
         663: 5.55070E-02,
         664: 5.21614E-02,
         665: 4.89970E-02,
         666: 4.60058E-02,
         667: 4.31788E-02,
         668: 4.05075E-02,
         669: 3.79838E-02,
         670: 3.55998E-02,
         671: 3.33486E-02,
         672: 3.12233E-02,
         673: 2.92178E-02,
         674: 2.73260E-02,
         675: 2.55422E-02,
         676: 2.38612E-02,
         677: 2.22786E-02,
         678: 2.07902E-02,
         679: 1.93919E-02,
         680: 1.80794E-02,
         681: 1.68482E-02,
         682: 1.56919E-02,
         683: 1.46045E-02,
         684: 1.35806E-02,
         685: 1.26157E-02,
         686: 1.17070E-02,
         687: 1.08561E-02,
         688: 1.00648E-02,
         689: 9.33338E-03,
         690: 8.66128E-03,
         691: 8.04605E-03,
         692: 7.48113E-03,
         693: 6.95999E-03,
         694: 6.47707E-03,
         695: 6.02768E-03,
         696: 5.60817E-03,
         697: 5.21669E-03,
         698: 4.85179E-03,
         699: 4.51201E-03,
         700: 4.19594E-03,
         701: 3.90206E-03,
         702: 3.62837E-03,
         703: 3.37301E-03,
         704: 3.13432E-03,
         705: 2.91086E-03,
         706: 2.70153E-03,
         707: 2.50580E-03,
         708: 2.32323E-03,
         709: 2.15333E-03,
         710: 1.99556E-03,
         711: 1.84932E-03,
         712: 1.71398E-03,
         713: 1.58890E-03,
         714: 1.47345E-03,
         715: 1.36702E-03,
         716: 1.26895E-03,
         717: 1.17842E-03,
         718: 1.09464E-03,
         719: 1.01694E-03,
         720: 9.44727E-04,
         721: 8.77517E-04,
         722: 8.15044E-04,
         723: 7.57076E-04,
         724: 7.03376E-04,
         725: 6.53705E-04,
         726: 6.07805E-04,
         727: 5.65344E-04,
         728: 5.26005E-04,
         729: 4.89506E-04,
         730: 4.55597E-04,
         731: 4.24055E-04,
         732: 3.94686E-04,
         733: 3.67318E-04,
         734: 3.41794E-04,
         735: 3.17974E-04,
         736: 2.95744E-04,
         737: 2.75056E-04,
         738: 2.55864E-04,
         739: 2.38114E-04,
         740: 2.21745E-04,
         741: 2.06671E-04,
         742: 1.92747E-04,
         743: 1.79831E-04,
         744: 1.67802E-04,
         745: 1.56557E-04,
         746: 1.46017E-04,
         747: 1.36153E-04,
         748: 1.26945E-04,
         749: 1.18367E-04,
         750: 1.10393E-04,
         751: 1.02991E-04,
         752: 9.61184E-05,
         753: 8.97332E-05,
         754: 8.37969E-05,
         755: 7.82744E-05,
         756: 7.31331E-05,
         757: 6.83414E-05,
         758: 6.38704E-05,
         759: 5.96939E-05,
         760: 5.57886E-05,
         761: 5.21351E-05,
         762: 4.87218E-05,
         763: 4.55385E-05,
         764: 4.25744E-05,
         765: 3.98188E-05,
         766: 3.72588E-05,
         767: 3.48747E-05,
         768: 3.26477E-05,
         769: 3.05614E-05,
         770: 2.86018E-05,
         771: 2.67584E-05,
         772: 2.50294E-05,
         773: 2.34137E-05,
         774: 2.19091E-05,
         775: 2.05126E-05,
         776: 1.92190E-05,
         777: 1.80180E-05,
         778: 1.68990E-05,
         779: 1.58531E-05,
         780: 1.48724E-05,
         781: 1.39509E-05,
         782: 1.30853E-05,
         783: 1.22733E-05,
         784: 1.15123E-05,
         785: 1.08000E-05,
         786: 1.01336E-05,
         787: 9.50992E-06,
         788: 8.92563E-06,
         789: 8.37785E-06,
         790: 7.86392E-06,
         791: 7.38154E-06,
         792: 6.92910E-06,
         793: 6.50514E-06,
         794: 6.10822E-06,
         795: 5.73694E-06,
         796: 5.38983E-06,
         797: 5.06527E-06,
         798: 4.76167E-06,
         799: 4.47756E-06,
         800: 4.21160E-06,
         801: 3.96246E-06,
         802: 3.72867E-06,
         803: 3.50888E-06,
         804: 3.30187E-06,
         805: 3.10656E-06,
         806: 2.92212E-06,
         807: 2.74821E-06,
         808: 2.58456E-06,
         809: 2.43087E-06,
         810: 2.28679E-06,
         811: 2.15191E-06,
         812: 2.02566E-06,
         813: 1.90746E-06,
         814: 1.79679E-06,
         815: 1.69315E-06,
         816: 1.59603E-06,
         817: 1.50490E-06,
         818: 1.41925E-06,
         819: 1.33860E-06,
         820: 1.26256E-06,
         821: 1.19077E-06,
         822: 1.12303E-06,
         823: 1.05915E-06,
         824: 9.98951E-07,
         825: 9.42251E-07,
         826: 8.88880E-07,
         827: 8.38669E-07,
         828: 7.91454E-07,
         829: 7.47077E-07,
         830: 7.05386E-07},
    "Stockman, Jagle, Pirzer & Sharpe CIE 2008 10 Degree Observer":
        {390: 4.07678E-04,
         391: 4.97777E-04,
         392: 6.06475E-04,
         393: 7.37004E-04,
         394: 8.92939E-04,
         395: 1.07817E-03,
         396: 1.29682E-03,
         397: 1.55316E-03,
         398: 1.85146E-03,
         399: 2.19579E-03,
         400: 2.58977E-03,
         401: 3.03680E-03,
         402: 3.54193E-03,
         403: 4.11142E-03,
         404: 4.75262E-03,
         405: 5.47421E-03,
         406: 6.28503E-03,
         407: 7.18807E-03,
         408: 8.18179E-03,
         409: 9.26042E-03,
         410: 1.04130E-02,
         411: 1.16264E-02,
         412: 1.28988E-02,
         413: 1.42344E-02,
         414: 1.56408E-02,
         415: 1.71297E-02,
         416: 1.87127E-02,
         417: 2.03839E-02,
         418: 2.21294E-02,
         419: 2.39299E-02,
         420: 2.57613E-02,
         421: 2.76016E-02,
         422: 2.94551E-02,
         423: 3.13388E-02,
         424: 3.32758E-02,
         425: 3.52955E-02,
         426: 3.74271E-02,
         427: 3.96714E-02,
         428: 4.20200E-02,
         429: 4.44617E-02,
         430: 4.69823E-02,
         431: 4.95674E-02,
         432: 5.22122E-02,
         433: 5.49139E-02,
         434: 5.76692E-02,
         435: 6.04743E-02,
         436: 6.33220E-02,
         437: 6.61927E-02,
         438: 6.90619E-02,
         439: 7.19019E-02,
         440: 7.46829E-02,
         441: 7.73845E-02,
         442: 8.00360E-02,
         443: 8.26852E-02,
         444: 8.53875E-02,
         445: 8.82054E-02,
         446: 9.11893E-02,
         447: 9.43104E-02,
         448: 9.75135E-02,
         449: 1.00735E-01,
         450: 1.03903E-01,
         451: 1.06964E-01,
         452: 1.09968E-01,
         453: 1.12999E-01,
         454: 1.16154E-01,
         455: 1.19539E-01,
         456: 1.23250E-01,
         457: 1.27305E-01,
         458: 1.31696E-01,
         459: 1.36418E-01,
         460: 1.41459E-01,
         461: 1.46800E-01,
         462: 1.52400E-01,
         463: 1.58202E-01,
         464: 1.64140E-01,
         465: 1.70137E-01,
         466: 1.76123E-01,
         467: 1.82090E-01,
         468: 1.88046E-01,
         469: 1.94006E-01,
         470: 1.99986E-01,
         471: 2.06005E-01,
         472: 2.12098E-01,
         473: 2.18304E-01,
         474: 2.24669E-01,
         475: 2.31243E-01,
         476: 2.38074E-01,
         477: 2.45180E-01,
         478: 2.52568E-01,
         479: 2.60248E-01,
         480: 2.68227E-01,
         481: 2.76501E-01,
         482: 2.85004E-01,
         483: 2.93647E-01,
         484: 3.02332E-01,
         485: 3.10944E-01,
         486: 3.19410E-01,
         487: 3.27868E-01,
         488: 3.36526E-01,
         489: 3.45618E-01,
         490: 3.55402E-01,
         491: 3.66089E-01,
         492: 3.77586E-01,
         493: 3.89696E-01,
         494: 4.02195E-01,
         495: 4.14823E-01,
         496: 4.27354E-01,
         497: 4.39821E-01,
         498: 4.52336E-01,
         499: 4.65030E-01,
         500: 4.78048E-01,
         501: 4.91517E-01,
         502: 5.05422E-01,
         503: 5.19706E-01,
         504: 5.34301E-01,
         505: 5.49134E-01,
         506: 5.64130E-01,
         507: 5.79242E-01,
         508: 5.94426E-01,
         509: 6.09639E-01,
         510: 6.24830E-01,
         511: 6.39966E-01,
         512: 6.55094E-01,
         513: 6.70290E-01,
         514: 6.85638E-01,
         515: 7.01229E-01,
         516: 7.17110E-01,
         517: 7.33092E-01,
         518: 7.48904E-01,
         519: 7.64253E-01,
         520: 7.78820E-01,
         521: 7.92341E-01,
         522: 8.04851E-01,
         523: 8.16475E-01,
         524: 8.27352E-01,
         525: 8.37636E-01,
         526: 8.47465E-01,
         527: 8.56887E-01,
         528: 8.65924E-01,
         529: 8.74604E-01,
         530: 8.82955E-01,
         531: 8.91027E-01,
         532: 8.98949E-01,
         533: 9.06875E-01,
         534: 9.14965E-01,
         535: 9.23386E-01,
         536: 9.32232E-01,
         537: 9.41286E-01,
         538: 9.50238E-01,
         539: 9.58765E-01,
         540: 9.66532E-01,
         541: 9.73250E-01,
         542: 9.78842E-01,
         543: 9.83287E-01,
         544: 9.86572E-01,
         545: 9.88689E-01,
         546: 9.89706E-01,
         547: 9.89985E-01,
         548: 9.89962E-01,
         549: 9.90073E-01,
         550: 9.90750E-01,
         551: 9.92283E-01,
         552: 9.94384E-01,
         553: 9.96622E-01,
         554: 9.98565E-01,
         555: 9.99778E-01,
         556: 9.99944E-01,
         557: 9.99220E-01,
         558: 9.97879E-01,
         559: 9.96193E-01,
         560: 9.94430E-01,
         561: 9.92783E-01,
         562: 9.91158E-01,
         563: 9.89392E-01,
         564: 9.87329E-01,
         565: 9.84813E-01,
         566: 9.81725E-01,
         567: 9.78071E-01,
         568: 9.73886E-01,
         569: 9.69203E-01,
         570: 9.64055E-01,
         571: 9.58441E-01,
         572: 9.52238E-01,
         573: 9.45297E-01,
         574: 9.37477E-01,
         575: 9.28649E-01,
         576: 9.18795E-01,
         577: 9.08301E-01,
         578: 8.97635E-01,
         579: 8.87240E-01,
         580: 8.77536E-01,
         581: 8.68792E-01,
         582: 8.60747E-01,
         583: 8.53023E-01,
         584: 8.45253E-01,
         585: 8.37084E-01,
         586: 8.28241E-01,
         587: 8.18732E-01,
         588: 8.08635E-01,
         589: 7.98030E-01,
         590: 7.86995E-01,
         591: 7.75604E-01,
         592: 7.63900E-01,
         593: 7.51916E-01,
         594: 7.39683E-01,
         595: 7.27231E-01,
         596: 7.14588E-01,
         597: 7.01793E-01,
         598: 6.88887E-01,
         599: 6.75910E-01,
         600: 6.62904E-01,
         601: 6.49891E-01,
         602: 6.36841E-01,
         603: 6.23709E-01,
         604: 6.10454E-01,
         605: 5.97037E-01,
         606: 5.83440E-01,
         607: 5.69704E-01,
         608: 5.55889E-01,
         609: 5.42047E-01,
         610: 5.28230E-01,
         611: 5.14475E-01,
         612: 5.00788E-01,
         613: 4.87169E-01,
         614: 4.73616E-01,
         615: 4.60131E-01,
         616: 4.46726E-01,
         617: 4.33459E-01,
         618: 4.20392E-01,
         619: 4.07581E-01,
         620: 3.95076E-01,
         621: 3.82889E-01,
         622: 3.70919E-01,
         623: 3.59045E-01,
         624: 3.47162E-01,
         625: 3.35179E-01,
         626: 3.23056E-01,
         627: 3.10886E-01,
         628: 2.98784E-01,
         629: 2.86853E-01,
         630: 2.75181E-01,
         631: 2.63834E-01,
         632: 2.52833E-01,
         633: 2.42183E-01,
         634: 2.31890E-01,
         635: 2.21956E-01,
         636: 2.12383E-01,
         637: 2.03170E-01,
         638: 1.94318E-01,
         639: 1.85825E-01,
         640: 1.77688E-01,
         641: 1.69893E-01,
         642: 1.62382E-01,
         643: 1.55099E-01,
         644: 1.47992E-01,
         645: 1.41020E-01,
         646: 1.34161E-01,
         647: 1.27440E-01,
         648: 1.20889E-01,
         649: 1.14534E-01,
         650: 1.08400E-01,
         651: 1.02501E-01,
         652: 9.68459E-02,
         653: 9.14394E-02,
         654: 8.62832E-02,
         655: 8.13769E-02,
         656: 7.67171E-02,
         657: 7.22940E-02,
         658: 6.80970E-02,
         659: 6.41155E-02,
         660: 6.03398E-02,
         661: 5.67605E-02,
         662: 5.33699E-02,
         663: 5.01603E-02,
         664: 4.71241E-02,
         665: 4.42538E-02,
         666: 4.15421E-02,
         667: 3.89804E-02,
         668: 3.65609E-02,
         669: 3.42760E-02,
         670: 3.21185E-02,
         671: 3.00819E-02,
         672: 2.81600E-02,
         673: 2.63470E-02,
         674: 2.46373E-02,
         675: 2.30257E-02,
         676: 2.15074E-02,
         677: 2.00784E-02,
         678: 1.87347E-02,
         679: 1.74727E-02,
         680: 1.62884E-02,
         681: 1.51777E-02,
         682: 1.41347E-02,
         683: 1.31541E-02,
         684: 1.22309E-02,
         685: 1.13611E-02,
         686: 1.05419E-02,
         687: 9.77505E-03,
         688: 9.06196E-03,
         689: 8.40296E-03,
         690: 7.79746E-03,
         691: 7.24323E-03,
         692: 6.73438E-03,
         693: 6.26500E-03,
         694: 5.83009E-03,
         695: 5.42539E-03,
         696: 5.04763E-03,
         697: 4.69514E-03,
         698: 4.36659E-03,
         699: 4.06069E-03,
         700: 3.77614E-03,
         701: 3.51158E-03,
         702: 3.26521E-03,
         703: 3.03534E-03,
         704: 2.82050E-03,
         705: 2.61937E-03,
         706: 2.43096E-03,
         707: 2.25480E-03,
         708: 2.09049E-03,
         709: 1.93759E-03,
         710: 1.79560E-03,
         711: 1.66399E-03,
         712: 1.54220E-03,
         713: 1.42964E-03,
         714: 1.32575E-03,
         715: 1.22998E-03,
         716: 1.14173E-03,
         717: 1.06027E-03,
         718: 9.84885E-04,
         719: 9.14970E-04,
         720: 8.49990E-04,
         721: 7.89516E-04,
         722: 7.33304E-04,
         723: 6.81146E-04,
         724: 6.32829E-04,
         725: 5.88138E-04,
         726: 5.46839E-04,
         727: 5.08635E-04,
         728: 4.73240E-04,
         729: 4.40402E-04,
         730: 4.09893E-04,
         731: 3.81514E-04,
         732: 3.55090E-04,
         733: 3.30467E-04,
         734: 3.07503E-04,
         735: 2.86072E-04,
         736: 2.66072E-04,
         737: 2.47459E-04,
         738: 2.30192E-04,
         739: 2.14223E-04,
         740: 1.99495E-04,
         741: 1.85934E-04,
         742: 1.73407E-04,
         743: 1.61786E-04,
         744: 1.50964E-04,
         745: 1.40847E-04,
         746: 1.31364E-04,
         747: 1.22490E-04,
         748: 1.14206E-04,
         749: 1.06489E-04,
         750: 9.93144E-05,
         751: 9.26551E-05,
         752: 8.64722E-05,
         753: 8.07278E-05,
         754: 7.53872E-05,
         755: 7.04188E-05,
         756: 6.57934E-05,
         757: 6.14825E-05,
         758: 5.74601E-05,
         759: 5.37027E-05,
         760: 5.01893E-05,
         761: 4.69024E-05,
         762: 4.38317E-05,
         763: 4.09678E-05,
         764: 3.83012E-05,
         765: 3.58222E-05,
         766: 3.35190E-05,
         767: 3.13742E-05,
         768: 2.93707E-05,
         769: 2.74938E-05,
         770: 2.57308E-05,
         771: 2.40725E-05,
         772: 2.25170E-05,
         773: 2.10635E-05,
         774: 1.97099E-05,
         775: 1.84535E-05,
         776: 1.72898E-05,
         777: 1.62093E-05,
         778: 1.52026E-05,
         779: 1.42617E-05,
         780: 1.33795E-05,
         781: 1.25504E-05,
         782: 1.17717E-05,
         783: 1.10412E-05,
         784: 1.03566E-05,
         785: 9.71580E-06,
         786: 9.11632E-06,
         787: 8.55520E-06,
         788: 8.02956E-06,
         789: 7.53677E-06,
         790: 7.07442E-06,
         791: 6.64046E-06,
         792: 6.23344E-06,
         793: 5.85204E-06,
         794: 5.49496E-06,
         795: 5.16095E-06,
         796: 4.84869E-06,
         797: 4.55671E-06,
         798: 4.28358E-06,
         799: 4.02799E-06,
         800: 3.78873E-06,
         801: 3.56460E-06,
         802: 3.35428E-06,
         803: 3.15656E-06,
         804: 2.97033E-06,
         805: 2.79463E-06,
         806: 2.62870E-06,
         807: 2.47225E-06,
         808: 2.32503E-06,
         809: 2.18677E-06,
         810: 2.05715E-06,
         811: 1.93581E-06,
         812: 1.82224E-06,
         813: 1.71591E-06,
         814: 1.61636E-06,
         815: 1.52311E-06,
         816: 1.43575E-06,
         817: 1.35377E-06,
         818: 1.27671E-06,
         819: 1.20417E-06,
         820: 1.13576E-06,
         821: 1.07118E-06,
         822: 1.01024E-06,
         823: 9.52778E-07,
         824: 8.98622E-07,
         825: 8.47617E-07,
         826: 7.99605E-07,
         827: 7.54436E-07,
         828: 7.11962E-07,
         829: 6.72042E-07,
         830: 6.34538E-07,
        }
}

PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS = {
    "CIE 1924 2 Degree Observer":
        SpectralPowerDistribution("CIE 1924 2 Degree Observer",
                                                     PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA.get(
                                                         "CIE 1924 2 Degree Observer")),
    "Judd Modified CIE 1951 2 Degree Observer":
        SpectralPowerDistribution("Judd Modified CIE 1951 2 Degree Observer",
                                                     PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA.get(
                                                         "Judd Modified CIE 1951 2 Degree Observer")),
    "Judd-Vos Modified CIE 1978 2 Degree Observer":
        SpectralPowerDistribution("Judd-Vos Modified CIE 1978 2 Degree Observer",
                                                     PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA.get(
                                                         "Judd-Vos Modified CIE 1978 2 Degree Observer")),
    "Stockman, Jagle, Pirzer & Sharpe CIE 2008 2 Degree Observer":
        SpectralPowerDistribution("Stockman, Jagle, Pirzer & Sharpe CIE 2008 2 Degree Observer",
                                                     PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA.get(
                                                         "Stockman, Jagle, Pirzer & Sharpe CIE 2008 2 Degree Observer")),
    "Stockman, Jagle, Pirzer & Sharpe CIE 2008 10 Degree Observer":
        SpectralPowerDistribution("Stockman, Jagle, Pirzer & Sharpe CIE 2008 10 Degree Observer",
                                                     PHOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA.get(
                                                         "Stockman, Jagle, Pirzer & Sharpe CIE 2008 10 Degree Observer"))
}

SCOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA = {
    "Wald & Crawford CIE 1951 2 Degree Observer":
        {380: 0.0005890000,
         381: 0.0006650000,
         382: 0.0007520000,
         383: 0.0008540000,
         384: 0.0009720000,
         385: 0.0011080000,
         386: 0.0012680000,
         387: 0.0014530000,
         388: 0.0016680000,
         389: 0.0019180000,
         390: 0.0022090000,
         391: 0.0025470000,
         392: 0.0029390000,
         393: 0.0033940000,
         394: 0.0039210000,
         395: 0.0045300000,
         396: 0.0052400000,
         397: 0.0060500000,
         398: 0.0069800000,
         399: 0.0080600000,
         400: 0.0092900000,
         401: 0.0107000000,
         402: 0.0123100000,
         403: 0.0141300000,
         404: 0.0161900000,
         405: 0.0185200000,
         406: 0.0211300000,
         407: 0.0240500000,
         408: 0.0273000000,
         409: 0.0308900000,
         410: 0.0348400000,
         411: 0.0391600000,
         412: 0.0439000000,
         413: 0.0490000000,
         414: 0.0545000000,
         415: 0.0604000000,
         416: 0.0668000000,
         417: 0.0736000000,
         418: 0.0808000000,
         419: 0.0885000000,
         420: 0.0966000000,
         421: 0.1052000000,
         422: 0.1141000000,
         423: 0.1235000000,
         424: 0.1334000000,
         425: 0.1436000000,
         426: 0.1541000000,
         427: 0.1651000000,
         428: 0.1764000000,
         429: 0.1879000000,
         430: 0.1998000000,
         431: 0.2119000000,
         432: 0.2243000000,
         433: 0.2369000000,
         434: 0.2496000000,
         435: 0.2625000000,
         436: 0.2755000000,
         437: 0.2886000000,
         438: 0.3017000000,
         439: 0.3149000000,
         440: 0.3281000000,
         441: 0.3412000000,
         442: 0.3543000000,
         443: 0.3673000000,
         444: 0.3803000000,
         445: 0.3931000000,
         446: 0.4060000000,
         447: 0.4180000000,
         448: 0.4310000000,
         449: 0.4430000000,
         450: 0.4550000000,
         451: 0.4670000000,
         452: 0.4790000000,
         453: 0.4900000000,
         454: 0.5020000000,
         455: 0.5130000000,
         456: 0.5240000000,
         457: 0.5350000000,
         458: 0.5460000000,
         459: 0.5570000000,
         460: 0.5670000000,
         461: 0.5780000000,
         462: 0.5880000000,
         463: 0.5990000000,
         464: 0.6100000000,
         465: 0.6200000000,
         466: 0.6310000000,
         467: 0.6420000000,
         468: 0.6530000000,
         469: 0.6640000000,
         470: 0.6760000000,
         471: 0.6870000000,
         472: 0.6990000000,
         473: 0.7100000000,
         474: 0.7220000000,
         475: 0.7340000000,
         476: 0.7450000000,
         477: 0.7570000000,
         478: 0.7690000000,
         479: 0.7810000000,
         480: 0.7930000000,
         481: 0.8050000000,
         482: 0.8170000000,
         483: 0.8280000000,
         484: 0.8400000000,
         485: 0.8510000000,
         486: 0.8620000000,
         487: 0.8730000000,
         488: 0.8840000000,
         489: 0.8940000000,
         490: 0.9040000000,
         491: 0.9140000000,
         492: 0.9230000000,
         493: 0.9320000000,
         494: 0.9410000000,
         495: 0.9490000000,
         496: 0.9570000000,
         497: 0.9640000000,
         498: 0.9700000000,
         499: 0.9760000000,
         500: 0.9820000000,
         501: 0.9860000000,
         502: 0.9900000000,
         503: 0.9940000000,
         504: 0.9970000000,
         505: 0.9980000000,
         506: 1.0000000000,
         507: 1.0000000000,
         508: 1.0000000000,
         509: 0.9980000000,
         510: 0.9970000000,
         511: 0.9940000000,
         512: 0.9900000000,
         513: 0.9860000000,
         514: 0.9810000000,
         515: 0.9750000000,
         516: 0.9680000000,
         517: 0.9610000000,
         518: 0.9530000000,
         519: 0.9440000000,
         520: 0.9350000000,
         521: 0.9250000000,
         522: 0.9150000000,
         523: 0.9040000000,
         524: 0.8920000000,
         525: 0.8800000000,
         526: 0.8670000000,
         527: 0.8540000000,
         528: 0.8400000000,
         529: 0.8260000000,
         530: 0.8110000000,
         531: 0.7960000000,
         532: 0.7810000000,
         533: 0.7650000000,
         534: 0.7490000000,
         535: 0.7330000000,
         536: 0.7170000000,
         537: 0.7000000000,
         538: 0.6830000000,
         539: 0.6670000000,
         540: 0.6500000000,
         541: 0.6330000000,
         542: 0.6160000000,
         543: 0.5990000000,
         544: 0.5810000000,
         545: 0.5640000000,
         546: 0.5480000000,
         547: 0.5310000000,
         548: 0.5140000000,
         549: 0.4970000000,
         550: 0.4810000000,
         551: 0.4650000000,
         552: 0.4480000000,
         553: 0.4330000000,
         554: 0.4170000000,
         555: 0.4020000000,
         556: 0.3864000000,
         557: 0.3715000000,
         558: 0.3569000000,
         559: 0.3427000000,
         560: 0.3288000000,
         561: 0.3151000000,
         562: 0.3018000000,
         563: 0.2888000000,
         564: 0.2762000000,
         565: 0.2639000000,
         566: 0.2519000000,
         567: 0.2403000000,
         568: 0.2291000000,
         569: 0.2182000000,
         570: 0.2076000000,
         571: 0.1974000000,
         572: 0.1876000000,
         573: 0.1782000000,
         574: 0.1690000000,
         575: 0.1602000000,
         576: 0.1517000000,
         577: 0.1436000000,
         578: 0.1358000000,
         579: 0.1284000000,
         580: 0.1212000000,
         581: 0.1143000000,
         582: 0.1078000000,
         583: 0.1015000000,
         584: 0.0956000000,
         585: 0.0899000000,
         586: 0.0845000000,
         587: 0.0793000000,
         588: 0.0745000000,
         589: 0.0699000000,
         590: 0.0655000000,
         591: 0.0613000000,
         592: 0.0574000000,
         593: 0.0537000000,
         594: 0.0502000000,
         595: 0.0469000000,
         596: 0.0438000000,
         597: 0.0409000000,
         598: 0.0381600000,
         599: 0.0355800000,
         600: 0.0331500000,
         601: 0.0308700000,
         602: 0.0287400000,
         603: 0.0267400000,
         604: 0.0248700000,
         605: 0.0231200000,
         606: 0.0214700000,
         607: 0.0199400000,
         608: 0.0185100000,
         609: 0.0171800000,
         610: 0.0159300000,
         611: 0.0147700000,
         612: 0.0136900000,
         613: 0.0126900000,
         614: 0.0117500000,
         615: 0.0108800000,
         616: 0.0100700000,
         617: 0.0093200000,
         618: 0.0086200000,
         619: 0.0079700000,
         620: 0.0073700000,
         621: 0.0068200000,
         622: 0.0063000000,
         623: 0.0058200000,
         624: 0.0053800000,
         625: 0.0049700000,
         626: 0.0045900000,
         627: 0.0042400000,
         628: 0.0039130000,
         629: 0.0036130000,
         630: 0.0033350000,
         631: 0.0030790000,
         632: 0.0028420000,
         633: 0.0026230000,
         634: 0.0024210000,
         635: 0.0022350000,
         636: 0.0020620000,
         637: 0.0019030000,
         638: 0.0017570000,
         639: 0.0016210000,
         640: 0.0014970000,
         641: 0.0013820000,
         642: 0.0012760000,
         643: 0.0011780000,
         644: 0.0010880000,
         645: 0.0010050000,
         646: 0.0009280000,
         647: 0.0008570000,
         648: 0.0007920000,
         649: 0.0007320000,
         650: 0.0006770000,
         651: 0.0006260000,
         652: 0.0005790000,
         653: 0.0005360000,
         654: 0.0004960000,
         655: 0.0004590000,
         656: 0.0004250000,
         657: 0.0003935000,
         658: 0.0003645000,
         659: 0.0003377000,
         660: 0.0003129000,
         661: 0.0002901000,
         662: 0.0002689000,
         663: 0.0002493000,
         664: 0.0002313000,
         665: 0.0002146000,
         666: 0.0001991000,
         667: 0.0001848000,
         668: 0.0001716000,
         669: 0.0001593000,
         670: 0.0001480000,
         671: 0.0001375000,
         672: 0.0001277000,
         673: 0.0001187000,
         674: 0.0001104000,
         675: 0.0001026000,
         676: 0.0000954000,
         677: 0.0000888000,
         678: 0.0000826000,
         679: 0.0000769000,
         680: 0.0000715000,
         681: 0.0000666000,
         682: 0.0000620000,
         683: 0.0000578000,
         684: 0.0000538000,
         685: 0.0000501000,
         686: 0.0000467000,
         687: 0.0000436000,
         688: 0.0000406000,
         689: 0.0000378900,
         690: 0.0000353300,
         691: 0.0000329500,
         692: 0.0000307500,
         693: 0.0000287000,
         694: 0.0000267900,
         695: 0.0000250100,
         696: 0.0000233600,
         697: 0.0000218200,
         698: 0.0000203800,
         699: 0.0000190500,
         700: 0.0000178000,
         701: 0.0000166400,
         702: 0.0000155600,
         703: 0.0000145400,
         704: 0.0000136000,
         705: 0.0000127300,
         706: 0.0000119100,
         707: 0.0000111400,
         708: 0.0000104300,
         709: 0.0000097600,
         710: 0.0000091400,
         711: 0.0000085600,
         712: 0.0000080200,
         713: 0.0000075100,
         714: 0.0000070400,
         715: 0.0000066000,
         716: 0.0000061800,
         717: 0.0000058000,
         718: 0.0000054400,
         719: 0.0000051000,
         720: 0.0000047800,
         721: 0.0000044900,
         722: 0.0000042100,
         723: 0.0000039510,
         724: 0.0000037090,
         725: 0.0000034820,
         726: 0.0000032700,
         727: 0.0000030700,
         728: 0.0000028840,
         729: 0.0000027100,
         730: 0.0000025460,
         731: 0.0000023930,
         732: 0.0000022500,
         733: 0.0000021150,
         734: 0.0000019890,
         735: 0.0000018700,
         736: 0.0000017590,
         737: 0.0000016550,
         738: 0.0000015570,
         739: 0.0000014660,
         740: 0.0000013790,
         741: 0.0000012990,
         742: 0.0000012230,
         743: 0.0000011510,
         744: 0.0000010840,
         745: 0.0000010220,
         746: 0.0000009620,
         747: 0.0000009070,
         748: 0.0000008550,
         749: 0.0000008060,
         750: 0.0000007600,
         751: 0.0000007160,
         752: 0.0000006750,
         753: 0.0000006370,
         754: 0.0000006010,
         755: 0.0000005670,
         756: 0.0000005350,
         757: 0.0000005050,
         758: 0.0000004770,
         759: 0.0000004500,
         760: 0.0000004250,
         761: 0.0000004010,
         762: 0.0000003790,
         763: 0.0000003580,
         764: 0.0000003382,
         765: 0.0000003196,
         766: 0.0000003021,
         767: 0.0000002855,
         768: 0.0000002699,
         769: 0.0000002552,
         770: 0.0000002413,
         771: 0.0000002282,
         772: 0.0000002159,
         773: 0.0000002042,
         774: 0.0000001932,
         775: 0.0000001829,
         776: 0.0000001731,
         777: 0.0000001638,
         778: 0.0000001551,
         779: 0.0000001468,
         780: 0.0000001390,
        }
}

SCOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS = {
    "Wald & Crawford CIE 1951 2 Degree Observer":
        SpectralPowerDistribution("Wald & Crawford CIE 1951 2 Degree Observer",
                                                     SCOTOPIC_LUMINOUS_EFFICIENCY_FUNCTIONS_DATA.get(
                                                         "Wald & Crawford CIE 1951 2 Degree Observer")),
}
