#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
**tests_blackbody.py**

**Platform:**
    Windows, Linux, Mac Os X.

**Description:**
    Defines units tests for :mod:`color.spectral.blackbody` module.

**Others:**

"""

from __future__ import unicode_literals

import numpy
import sys

if sys.version_info[:2] <= (2, 6):
    import unittest2 as unittest
else:
    import unittest

import color.spectral.blackbody

__author__ = "Thomas Mansencal"
__copyright__ = "Copyright (C) 2013 - 2014 - Thomas Mansencal"
__license__ = "GPL V3.0 - http://www.gnu.org/licenses/"
__maintainer__ = "Thomas Mansencal"
__email__ = "thomas.mansencal@gmail.com"
__status__ = "Production"

__all__ = ["PLANCK_LAW_DATA",
           "BLACKBODY_SPD_DATA",
           "TestPlanckLaw",
           "TestBlackbodySpectralPowerDistribution"]

PLANCK_LAW_DATA = {1667: {10: 0.0,
                          20: 1.4208346175621505e-165,
                          30: 5.556890925061967e-104,
                          40: 2.272534619814655e-73,
                          50: 4.109451263489077e-55,
                          60: 5.157349121710203e-43,
                          70: 2.0061822738489817e-34,
                          80: 5.080646841500839e-28,
                          90: 4.531254433259136e-23,
                          100: 3.910935364855866e-19,
                          110: 6.207567714439615e-16,
                          120: 2.777466772356486e-13,
                          130: 4.7058297548468816e-11,
                          140: 3.7260941692883886e-09,
                          150: 1.6083229930119022e-07,
                          160: 4.246667599899245e-06,
                          170: 7.489948377807927e-05,
                          180: 0.0009447495267748815,
                          190: 0.008993407405969787,
                          200: 0.06744566661888682,
                          210: 0.41254880806575633,
                          220: 2.1173504823828853,
                          230: 9.333628467784775,
                          240: 36.031724909253775,
                          250: 123.8136893505376,
                          260: 383.9489260827852,
                          270: 1087.1174292071275,
                          280: 2838.70691922834,
                          290: 6895.1225478917695,
                          300: 15695.393919199129,
                          310: 33699.2309399215,
                          320: 68633.7786847282,
                          330: 133252.96416174475,
                          340: 247702.7573435883,
                          350: 442561.70636506955,
                          360: 762589.482076315,
                          370: 1271169.471190539,
                          380: 2055378.757411563,
                          390: 3231565.0564877572,
                          400: 4951260.41571922,
                          410: 7407220.346497745,
                          420: 10839348.115372391,
                          430: 15540249.434079167,
                          440: 21860163.58689407,
                          450: 30211032.58131809,
                          460: 41069498.5286767,
                          470: 54978658.63359997,
                          480: 72548453.86197355,
                          490: 94454618.34085305,
                          500: 121436168.68393987,
                          510: 154291462.9019783,
                          520: 193872904.97632918,
                          530: 241080411.71642795,
                          540: 296853791.929032,
                          550: 362164213.4909127,
                          560: 438004951.426143,
                          570: 525381619.7547634,
                          580: 625302092.2463018,
                          590: 738766313.069305,
                          600: 866756188.62691,
                          610: 1010225737.6426312,
                          620: 1170091658.8638704,
                          630: 1347224455.6046717,
                          640: 1542440234.7041836,
                          650: 1756493275.1853666,
                          660: 1990069439.6966524,
                          670: 2243780480.321833,
                          680: 2518159270.0421877,
                          690: 2813655972.402005,
                          700: 3130635145.029295,
                          710: 3469373757.7616425,
                          720: 3830060093.3057337,
                          730: 4212793487.6253324,
                          740: 4617584858.558892,
                          750: 5044357964.417966,
                          760: 5492951329.383795,
                          770: 5963120769.246055,
                          780: 6454542449.248621,
                          790: 6966816405.344493,
                          800: 7499470460.839263,
                          810: 8051964472.044799,
                          820: 8623694839.00635,
                          830: 9213999220.450361,
                          840: 9822161395.681984,
                          850: 10447416220.111528,
                          860: 11088954625.28754,
                          870: 11745928618.662657,
                          880: 12417456242.72339,
                          890: 13102626457.503294,
                          900: 13800503914.805819,
                          910: 14510133596.638834,
                          920: 15230545294.362274,
                          930: 15960757908.846075,
                          940: 16699783555.500265,
                          950: 17446631461.35982,
                          960: 18200311644.470783,
                          970: 18959838368.63047,
                          980: 19724233369.08074,
                          990: 20492528847.043186,
                          1000: 21263770233.02943,
                          1010: 22037018720.664284,
                          1020: 22811353574.33512,
                          1030: 23585874215.34518,
                          1040: 24359702092.4096,
                          1050: 25131982343.3085,
                          1060: 25901885255.312737,
                          1070: 26668607532.645332,
                          1080: 27431373379.74004,
                          1090: 28189435409.431763,
                          1100: 28942075385.467655,
                          1110: 29688604808.87836,
                          1120: 30428365357.808865,
                          1130: 31160729190.387054,
                          1140: 31885099120.116135,
                          1150: 32600908673.12751,
                          1160: 33307622036.42701,
                          1170: 34004733906.022778,
                          1180: 34691769243.54348,
                          1190: 35368282949.645164,
                          1200: 36033859462.17493,
                          1210: 36688112286.71227,
                          1220: 37330683466.74555,
                          1230: 37961243000.378624,
                          1240: 38579488210.08555,
                          1250: 39185143071.6629,
                          1260: 39777957508.15804,
                          1270: 40357706654.186264,
                          1280: 40924190095.6913,
                          1290: 41477231089.85549,
                          1300: 42016675769.522964,
                          1310: 42542392336.17418,
                          1320: 43054270245.16987,
                          1330: 43552219386.68088,
                          1340: 44036169265.429474,
                          1350: 44506068182.08853,
                          1360: 44961882418.923546,
                          1370: 45403595432.01291,
                          1380: 45831207052.14387,
                          1390: 46244732696.26139,
                          1400: 46644202591.13727,
                          1410: 47029661010.73158,
                          1420: 47401165528.53429,
                          1430: 47758786286.00543,
                          1440: 48102605278.07329,
                          1450: 48432715656.50055,
                          1460: 48749221051.79656,
                          1470: 49052234914.22224,
                          1480: 49341879874.322876,
                          1490: 49618287123.31662,
                          1500: 49881595813.56711,
                          1510: 50131952479.28286,
                          1520: 50369510477.5041,
                          1530: 50594429449.363625,
                          1540: 50806874801.54471,
                          1550: 51007017207.79744,
                          1560: 51195032130.32285,
                          1570: 51371099360.78809,
                          1580: 51535402580.691414,
                          1590: 51688128940.76146,
                          1600: 51829468659.04289,
                          1610: 51959614637.29104,
                          1620: 52078762095.27637,
                          1630: 52187108222.57967,
                          1640: 52284851847.439026,
                          1650: 52372193122.2017,
                          1660: 52449333224.91721,
                          1670: 52516474076.60439,
                          1680: 52573818073.71836,
                          1690: 52621567835.33627,
                          1700: 52659925964.58614,
                          1710: 52689094823.835655,
                          1720: 52709276323.16414,
                          1730: 52720671721.643456,
                          1740: 52723481440.95575,
                          1750: 52717904890.88346,
                          1760: 52704140306.21371,
                          1770: 52682384594.60366,
                          1780: 52652833194.96533,
                          1790: 52615679945.93379,
                          1800: 52571116963.99386,
                          1810: 52519334530.84914,
                          1820: 52460520989.627716,
                          1830: 52394862649.528725,
                          1840: 52322543698.52589,
                          1850: 52243746123.75266,
                          1860: 52158649639.20736,
                          1870: 52067431620.42468,
                          1880: 51970267045.77399,
                          1890: 51867328444.05362,
                          1900: 51758785848.061485,
                          1910: 51644806753.836044,
                          1920: 51525556085.26768,
                          1930: 51401196163.79568,
                          1940: 51271886682.9146,
                          1950: 51137784687.22343,
                          1960: 50999044555.76254,
                          1970: 50855817989.39413,
                          1980: 50708254001.98739,
                          1990: 50556498915.18589,
                          2000: 50400696356.537796,
                          2010: 50240987260.78193,
                          2020: 50077509874.09109,
                          2030: 49910399761.08202,
                          2040: 49739789814.410164,
                          2050: 49565810266.77533,
                          2060: 49388588705.1726,
                          2070: 49208250087.229904,
                          2080: 49024916759.481476,
                          2090: 48838708477.43278,
                          2100: 48649742427.281136,
                          2110: 48458133249.16043,
                          2120: 48263993061.78675,
                          2130: 48067431488.38712,
                          2140: 47868555683.79895,
                          2150: 47667470362.63514,
                          2160: 47464277828.41284,
                          2170: 47259078003.551926,
                          2180: 47051968460.15189,
                          2190: 46843044451.462234,
                          2200: 46632398943.96531,
                          2210: 46420122649.99582,
                          2220: 46206304060.824356,
                          2230: 45991029480.13761,
                          2240: 45774383057.85084,
                          2250: 45556446824.19294,
                          2260: 45337300724.006775,
                          2270: 45117022651.212204,
                          2280: 44895688483.38142,
                          2290: 44673372116.380264,
                          2300: 44450145499.03104,
                          2310: 44226078667.75628,
                          2320: 44001239781.16529,
                          2330: 43775695154.54731,
                          2340: 43549509294.23829,
                          2350: 43322744931.83044,
                          2360: 43095463058.19558,
                          2370: 42867722957.295845,
                          2380: 42639582239.75709,
                          2390: 42411096876.18229,
                          2400: 42182321230.184265,
                          2410: 41953308091.117874,
                          2420: 41724108706.494774,
                          2430: 41494772814.06433,
                          2440: 41265348673.54641,
                          2450: 41035883098.002426,
                          2460: 40806421484.83266,
                          2470: 40577007846.389915,
                          2480: 40347684840.19897,
                          2490: 40118493798.77388,
                          2500: 39889474759.026,
                          2510: 39660666491.25533,
                          2520: 39432106527.720856,
                          2530: 39203831190.783844,
                          2540: 38975875620.621605,
                          2550: 38748273802.50744,
                          2560: 38521058593.65505,
                          2570: 38294261749.62529,
                          2580: 38067913950.29438,
                          2590: 37842044825.3828,
                          2600: 37616682979.54511,
                          2610: 37391856017.02106,
                          2620: 37167590565.84869,
                          2630: 36943912301.64163,
                          2640: 36720845970.9314,
                          2650: 36498415414.07758,
                          2660: 36276643587.748535,
                          2670: 36055552586.97477,
                          2680: 35835163666.778915,
                          2690: 35615497263.385376,
                          2700: 35396573015.01336,
                          2710: 35178409782.25735,
                          2720: 34961025668.059235,
                          2730: 34744438037.2758,
                          2740: 34528663535.84733,
                          2750: 34313718109.570316,
                          2760: 34099617022.48087,
                          2770: 33886374874.852142,
                          2780: 33674005620.811996,
                          2790: 33462522585.585308,
                          2800: 33251938482.366623,
                          2810: 33042265428.82794,
                          2820: 32833514963.267548,
                          2830: 32625698060.404835,
                          2840: 32418825146.82682,
                          2850: 32212906116.091805,
                          2860: 32007950343.495476,
                          2870: 31803966700.505352,
                          2880: 31600963568.8686,
                          2890: 31398948854.39929,
                          2900: 31197930000.450165,
                          2910: 30997914001.074734,
                          2920: 30798907413.884903,
                          2930: 30600916372.610012,
                          2940: 30403946599.36218,
                          2950: 30208003416.61397,
                          2960: 30013091758.893364,
                          2970: 29819216184.201267,
                          2980: 29626380885.157455,
                          2990: 29434589699.87941,
                          3000: 29243846122.59987,
                          3010: 29054153314.02798,
                          3020: 28865514111.459114,
                          3030: 28677931038.638504,
                          3040: 28491406315.383514,
                          3050: 28305941866.969784,
                          3060: 28121539333.28558,
                          3070: 27938200077.759827,
                          3080: 27755925196.06786,
                          3090: 27574715524.61996,
                          3100: 27394571648.83732,
                          3110: 27215493911.219685,
                          3120: 27037482419.20937,
                          3130: 26860537052.85589,
                          3140: 26684657472.28571,
                          3150: 26509843124.981094,
                          3160: 26336093252.872566,
                          3170: 26163406899.248833,
                          3180: 25991782915.48842,
                          3190: 25821219967.616756,
                          3200: 25651716542.692944,
                          3210: 25483270955.02971,
                          3220: 25315881352.250546,
                          3230: 25149545721.187695,
                          3240: 24984261893.62456,
                          3250: 24820027551.886196,
                          3260: 24656840234.28111,
                          3270: 24494697340.398354,
                          3280: 24333596136.26267,
                          3290: 24173533759.351494,
                          3300: 24014507223.476593,
                          3310: 23856513423.53396,
                          3320: 23699549140.12471,
                          3330: 23543611044.050346,
                          3340: 23388695700.68512,
                          3350: 23234799574.22854,
                          3360: 23081919031.840847,
                          3370: 22930050347.66434,
                          3380: 22779189706.733307,
                          3390: 22629333208.775055,
                          3400: 22480476871.90495,
                          3410: 22332616636.21785,
                          3420: 22185748367.27855,
                          3430: 22039867859.51368,
                          3440: 21894970839.50746,
                          3450: 21751052969.203754,
                          3460: 21608109849.01657,
                          3470: 21466137020.851475,
                          3480: 21325129971.039955,
                          3490: 21185084133.189003,
                          3500: 21045994890.94807,
                          3510: 20907857580.695255,
                          3520: 20770667494.144993,
                          3530: 20634419880.879078,
                          3540: 20499109950.802998,
                          3550: 20364732876.529465,
                          3560: 20231283795.690945,
                          3570: 20098757813.183064,
                          3580: 19967150003.34063,
                          3590: 19836455412.047855,
                          3600: 19706669058.784775,
                          3610: 19577785938.611115,
                          3620: 19449801024.08952,
                          3630: 19322709267.149544,
                          3640: 19196505600.89402,
                          3650: 19071184941.349174,
                          3660: 18946742189.16018,
                          3670: 18823172231.233257,
                          3680: 18700469942.32603,
                          3690: 18578630186.587227,
                          3700: 18457647819.047226,
                          3710: 18337517687.0607,
                          3720: 18218234631.70251,
                          3730: 18099793489.1183,
                          3740: 17982189091.83079,
                          3750: 17865416270.002937,
                          3760: 17749469852.659416,
                          3770: 17634344668.867092,
                          3780: 17520035548.87589,
                          3790: 17406537325.22095,
                          3800: 17293844833.787357,
                          3810: 17181952914.83806,
                          3820: 17070856414.006378,
                          3830: 16960550183.253672,
                          3840: 16851029081.793531,
                          3850: 16742287976.982996,
                          3860: 16634321745.182041,
                          3870: 16527125272.581865,
                          3880: 16420693456.003178,
                          3890: 16315021203.665037,
                          3900: 16210103435.9252,
                          3910: 16105935085.992676,
                          3920: 16002511100.613384,
                          3930: 15899826440.72956,
                          3940: 15797876082.113495,
                          3950: 15696655015.976778,
                          3960: 15596158249.555193,
                          3970: 15496380806.670326,
                          3980: 15397317728.268375,
                          3990: 15298964072.93682,
                          4000: 15201314917.399647,
                          4010: 15104365356.991642,
                          4020: 15008110506.11244,
                          4030: 14912545498.660805,
                          4040: 14817665488.449827,
                          4050: 14723465649.603527,
                          4060: 14629941176.935316,
                          4070: 14537087286.309036,
                          4080: 14444899214.982885,
                          4090: 14353372221.936834,
                          4100: 14262501588.184052,
                          4110: 14172282617.066645,
                          4120: 14082710634.536383,
                          4130: 13993780989.420673,
                          4140: 13905489053.674366,
                          4150: 13817830222.61766,
                          4160: 13730799915.16068,
                          4170: 13644393574.015043,
                          4180: 13558606665.892757,
                          4190: 13473434681.692991,
                          4200: 13388873136.676884,
                          4210: 13304917570.630913,
                          4220: 13221563548.019127,
                          4230: 13138806658.124552,
                          4240: 13056642515.180141,
                          4250: 12975066758.489576,
                          4260: 12894075052.538244,
                          4270: 12813663087.094679,
                          4280: 12733826577.30284,
                          4290: 12654561263.7654,
                          4300: 12575862912.618357,
                          4310: 12497727315.597425,
                          4320: 12420150290.096178,
                          4330: 12343127679.216393,
                          4340: 12266655351.810848,
                          4350: 12190729202.51878,
                          4360: 12115345151.794186,
                          4370: 12040499145.927357,
                          4380: 11966187157.05968,
                          4390: 11892405183.192118,
                          4400: 11819149248.18746,
                          4410: 11746415401.766558,
                          4420: 11674199719.49886,
                          4430: 11602498302.78726,
                          4440: 11531307278.847681,
                          4450: 11460622800.683361,
                          4460: 11390441047.05415,
                          4470: 11320758222.441006,
                          4480: 11251570557.005777,
                          4490: 11182874306.546545,
                          4500: 11114665752.448534,
                          4510: 11046941201.63097,
                          4520: 10979696986.489841,
                          4530: 10912929464.83678,
                          4540: 10846635019.834333,
                          4550: 10780810059.927443,
                          4560: 10715451018.771734,
                          4570: 10650554355.158283,
                          4580: 10586116552.935333,
                          4590: 10522134120.926918,
                          4600: 10458603592.848524,
                          4610: 10395521527.220022,
                          4620: 10332884507.275799,
                          4630: 10270689140.872444,
                          4640: 10208932060.393831,
                          4650: 10147609922.653881,
                          4660: 10086719408.797142,
                          4670: 10026257224.197067,
                          4680: 9966220098.352377,
                          4690: 9906604784.781305,
                          4700: 9847408060.914091,
                          4710: 9788626727.983633,
                          4720: 9730257610.914423,
                          4730: 9672297558.209888,
                          4740: 9614743441.838196,
                          4750: 9557592157.116598,
                          4760: 9500840622.594412,
                          4770: 9444485779.93463,
                          4780: 9388524593.794418,
                          4790: 9332954051.704311,
                          4800: 9277771163.946415,
                          4810: 9222972963.431566,
                          4820: 9168556505.575428,
                          4830: 9114518868.173857,
                          4840: 9060857151.27726,
                          4850: 9007568477.064249,
                          4860: 8954649989.714588,
                          4870: 8902098855.281368,
                          4880: 8849912261.562685,
                          4890: 8798087417.972647,
                          4900: 8746621555.411915,
                          4910: 8695511926.137741,
                          4920: 8644755803.633604,
                          4930: 8594350482.478474,
                          4940: 8544293278.21568,
                          4950: 8494581527.22156,
                          4960: 8445212586.5737915,
                          4970: 8396183833.919549,
                          4980: 8347492667.343496,
                          4990: 8299136505.2355585,
                          5000: 8251112786.158687,
                          5010: 8203418968.716497,
                          5020: 8156052531.420895,
                          5030: 8109010972.559695,
                          5040: 8062291810.064228,
                          5050: 8015892581.377083,
                          5060: 7969810843.319864,
                          5070: 7924044171.961092,
                          5080: 7878590162.484263,
                          5090: 7833446429.056007,
                          5100: 7788610604.694545,
                          5110: 7744080341.13826,
                          5120: 7699853308.714571,
                          5130: 7655927196.209047,
                          5140: 7612299710.734801,
                          5150: 7568968577.602207,
                          5160: 7525931540.188921,
                          5170: 7483186359.810249,
                          5180: 7440730815.589905,
                          5190: 7398562704.331097,
                          5200: 7356679840.388071,
                          5210: 7315080055.538025,
                          5220: 7273761198.853465,
                          5230: 7232721136.575008,
                          5240: 7191957751.984655,
                          5250: 7151468945.279521,
                          5260: 7111252633.446045,
                          5270: 7071306750.134732,
                          5280: 7031629245.535366,
                          5290: 6992218086.252779,
                          5300: 6953071255.183149,
                          5310: 6914186751.39081,
                          5320: 6875562589.985668,
                          5330: 6837196802.001144,
                          5340: 6799087434.272709,
                          5350: 6761232549.316987,
                          5360: 6723630225.211468,
                          5370: 6686278555.474801,
                          5380: 6649175648.947718,
                          5390: 6612319629.674532,
                          5400: 6575708636.785303,
                          5410: 6539340824.37858,
                          5420: 6503214361.404837,
                          5430: 6467327431.550471,
                          5440: 6431678233.122517,
                          5450: 6396264978.933947,
                          5460: 6361085896.189678,
                          5470: 6326139226.373203,
                          5480: 6291423225.133886,
                          5490: 6256936162.174918,
                          5500: 6222676321.141965,
                          5510: 6188641999.512479,
                          5520: 6154831508.485642,
                          5530: 6121243172.873053,
                          5540: 6087875330.99003,
                          5550: 6054726334.547654,
                          5560: 6021794548.545445,
                          5570: 5989078351.16474,
                          5580: 5956576133.662781,
                          5590: 5924286300.267437,
                          5600: 5892207268.072675,
                          5610: 5860337466.934669,
                          5620: 5828675339.368632,
                          5630: 5797219340.446315,
                          5640: 5765967937.694218,
                          5650: 5734919610.992474,
                          5660: 5704072852.474419,
                          5670: 5673426166.426882,
                          5680: 5642978069.191139,
                          5690: 5612727089.064543,
                          5700: 5582671766.202883,
                          5710: 5552810652.523392,
                          5720: 5523142311.608469,
                          5730: 5493665318.610068,
                          5740: 5464378260.154781,
                          5750: 5435279734.249595,
                          5760: 5406368350.188333,
                          5770: 5377642728.458796,
                          5780: 5349101500.650548,
                          5790: 5320743309.363381,
                          5800: 5292566808.116507,
                          5810: 5264570661.258336,
                          5820: 5236753543.877002,
                          5830: 5209114141.711509,
                          5840: 5181651151.063564,
                          5850: 5154363278.710077,
                          5860: 5127249241.816299,
                          5870: 5100307767.849636,
                          5880: 5073537594.494129,
                          5890: 5046937469.565554,
                          5900: 5020506150.927215,
                          5910: 4994242406.406344,
                          5920: 4968145013.71118,
                          5930: 4942212760.348668,
                          5940: 4916444443.542798,
                          5950: 4890838870.153613,
                          5960: 4865394856.596793,
                          5970: 4840111228.763921,
                          5980: 4814986821.943346,
                          5990: 4790020480.741687,
                          6000: 4765211059.00595,
                          6010: 4740557419.746255,
                          6020: 4716058435.059199,
                          6030: 4691712986.051803,
                          6040: 4667519962.766089,
                          6050: 4643478264.104255,
                          6060: 4619586797.754433,
                          6070: 4595844480.117077,
                          6080: 4572250236.231917,
                          6090: 4548802999.70552,
                          6100: 4525501712.639428,
                          6110: 4502345325.558883,
                          6120: 4479332797.342142,
                          6130: 4456463095.150347,
                          6140: 4433735194.3579855,
                          6150: 4411148078.483914,
                          6160: 4388700739.12295,
                          6170: 4366392175.8780155,
                          6180: 4344221396.292864,
                          6190: 4322187415.785324,
                          6200: 4300289257.581138,
                          6210: 4278525952.6483054,
                          6220: 4256896539.632011,
                          6230: 4235400064.790052,
                          6240: 4214035581.928842,
                          6250: 4192802152.3399177,
                          6260: 4171698844.7369866,
                          6270: 4150724735.1935105,
                          6280: 4129878907.080782,
                          6290: 4109160451.0065565,
                          6300: 4088568464.7541738,
                          6310: 4068102053.2221856,
                          6320: 4047760328.3645296,
                          6330: 4027542409.131144,
                          6340: 4007447421.4091525,
                          6350: 3987474497.96449,
                          6360: 3967622778.3840504,
                          6370: 3947891409.018317,
                          6380: 3928279542.9244704,
                          6390: 3908786339.810003,
                          6400: 3889410965.9767737,
                          6410: 3870152594.2655725,
                          6420: 3851010404.001144,
                          6430: 3831983580.937661,
                          6440: 3813071317.204707,
                          6450: 3794272811.2536607,
                          6460: 3775587267.8045955,
                          6470: 3757013897.7935834,
                          6480: 3738551918.3204913,
                          6490: 3720200552.5971947,
                          6500: 3701959029.8962345,
                          6510: 3683826585.4999433,
                          6520: 3665802460.649977,
                          6530: 3647885902.497287,
                          6540: 3630076164.052539,
                          6550: 3612372504.1369233,
                          6560: 3594774187.333438,
                          6570: 3577280483.938538,
                          6580: 3559890669.9142303,
                          6590: 3542604026.8405886,
                          6600: 3525419841.868645,
                          6610: 3508337407.6737337,
                          6620: 3491356022.4091835,
                          6630: 3474474989.6604605,
                          6640: 3457693618.399677,
                          6650: 3441011222.940496,
                          6660: 3424427122.893444,
                          6670: 3407940643.121585,
                          6680: 3391551113.6965923,
                          6690: 3375257869.855213,
                          6700: 3359060251.956073,
                          6710: 3342957605.4369006,
                          6720: 3326949280.7720814,
                          6730: 3311034633.430611,
                          6740: 3295213023.834403,
                          6750: 3279483817.3169374,
                          6760: 3263846384.0823145,
                          6770: 3248300099.1646123,
                          6780: 3232844342.3876348,
                          6790: 3217478498.324998,
                          6800: 3202201956.260551,
                          6810: 3187014110.1491656,
                          6820: 3171914358.5778384,
                          6830: 3156902104.7271624,
                          6840: 3141976756.3331013,
                          6850: 3127137725.6491213,
                          6860: 3112384429.4086456,
                          6870: 3097716288.7878246,
                          6880: 3083132729.3686485,
                          6890: 3068633181.1023674,
                          6900: 3054217078.273233,
                          6910: 3039883859.4625645,
                          6920: 3025632967.51311,
                          6930: 3011463849.4937425,
                          6940: 2997375956.664436,
                          6950: 2983368744.4415684,
                          6960: 2969441672.3635235,
                          6970: 2955594204.0565743,
                          6980: 2941825807.2010937,
                          6990: 2928135953.498032,
                          7000: 2914524118.6357055,
                          7010: 2900989782.256865,
                          7020: 2887532427.9260507,
                          7030: 2874151543.097241,
                          7040: 2860846619.081769,
                          7050: 2847617151.016536,
                          7060: 2834462637.832488,
                          7070: 2821382582.223367,
                          7080: 2808376490.614748,
                          7090: 2795443873.133333,
                          7100: 2782584243.5765157,
                          7110: 2769797119.3822165,
                          7120: 2757082021.5989704,
                          7130: 2744438474.8562884,
                          7140: 2731866007.3352633,
                          7150: 2719364150.7394457,
                          7160: 2706932440.2659626,
                          7170: 2694570414.5768867,
                          7180: 2682277615.7708735,
                          7190: 2670053589.355016,
                          7200: 2657897884.21697,
                          7210: 2645810052.597308,
                          7220: 2633789650.06212,
                          7230: 2621836235.4758515,
                          7240: 2609949370.9743714,
                          7250: 2598128621.9382877,
                          7260: 2586373556.9664783,
                          7270: 2574683747.8498745,
                          7280: 2563058769.545442,
                          7290: 2551498200.150418,
                          7300: 2540001620.876755,
                          7310: 2528568616.0257893,
                          7320: 2517198772.9631343,
                          7330: 2505891682.0937877,
                          7340: 2494646936.8374553,
                          7350: 2483464133.604091,
                          7360: 2472342871.7696486,
                          7370: 2461282753.6520367,
                          7380: 2450283384.4872994,
                          7390: 2439344372.405985,
                          7400: 2428465328.4097295,
                          7410: 2417645866.3480444,
                          7420: 2406885602.8952956,
                          7430: 2396184157.527896,
                          7440: 2385541152.501685,
                          7450: 2374956212.8295054,
                          7460: 2364428966.258978,
                          7470: 2353959043.250466,
                          7480: 2343546076.955233,
                          7490: 2333189703.193781,
                          7500: 2322889560.434393,
                          7510: 2312645289.7718368,
                          7520: 2302456534.9062796,
                          7530: 2292322942.122363,
                          7540: 2282244160.268469,
                          7550: 2272219840.7361627,
                          7560: 2262249637.4398165,
                          7570: 2252333206.796397,
                          7580: 2242470207.70545,
                          7590: 2232660301.5292277,
                          7600: 2222903152.073014,
                          7610: 2213198425.565603,
                          7620: 2203545790.6399546,
                          7630: 2193944918.314011,
                          7640: 2184395481.971671,
                          7650: 2174897157.343954,
                          7660: 2165449622.490299,
                          7670: 2156052557.7800317,
                          7680: 2146705645.8739994,
                          7690: 2137408571.7063518,
                          7700: 2128161022.466491,
                          7710: 2118962687.5811627,
                          7720: 2109813258.696708,
                          7730: 2100712429.6614711,
                          7740: 2091659896.5083504,
                          7750: 2082655357.4375024,
                          7760: 2073698512.7991912,
                          7770: 2064789065.076794,
                          7780: 2055926718.869937,
                          7790: 2047111180.8777878,
                          7800: 2038342159.8824863,
                          7810: 2029619366.7327123,
                          7820: 2020942514.3274083,
                          7830: 2012311317.5996172,
                          7840: 2003725493.5004895,
                          7850: 1995184760.9833918,
                          7860: 1986688840.9881785,
                          7870: 1978237456.4255817,
                          7880: 1969830332.1617484,
                          7890: 1961467195.0028887,
                          7900: 1953147773.6800776,
                          7910: 1944871798.834164,
                          7920: 1936639003.0008292,
                          7930: 1928449120.595753,
                          7940: 1920301887.8999245,
                          7950: 1912197043.0450578,
                          7960: 1904134325.999147,
                          7970: 1896113478.5521371,
                          7980: 1888134244.3017194,
                          7990: 1880196368.6392424,
                          8000: 1872299598.735742,
                          8010: 1864443683.5281038,
                          8020: 1856628373.7053192,
                          8030: 1848853421.6948755,
                          8040: 1841118581.6492555,
                          8050: 1833423609.43255,
                          8060: 1825768262.6071851,
                          8070: 1818152300.4207594,
                          8080: 1810575483.7929957,
                          8090: 1803037575.3027992,
                          8100: 1795538339.1754246,
                          8110: 1788077541.2697551,
                          8120: 1780654949.0656853,
                          8130: 1773270331.651611,
                          8140: 1765923459.7120237,
                          8150: 1758614105.51521,
                          8160: 1751342042.9010525,
                          8170: 1744107047.2689369,
                          8180: 1736908895.5657585,
                          8190: 1729747366.2740278,
                          8200: 1722622239.4000757,
                          8210: 1715533296.46236,
                          8220: 1708480320.4798713,
                          8230: 1701463095.960628,
                          8240: 1694481408.8902752,
                          8250: 1687535046.720778,
                          8260: 1680623798.359202,
                          8270: 1673747454.1566029,
                          8280: 1666905805.896985,
                          8290: 1660098646.7863803,
                          8300: 1653325771.4419916,
                          8310: 1646586975.8814442,
                          8320: 1639882057.5121248,
                          8330: 1633210815.1205952,
                          8340: 1626573048.8621154,
                          8350: 1619968560.250233,
                          8360: 1613397152.146475,
                          8370: 1606858628.7501206,
                          8380: 1600352795.5880473,
                          8390: 1593879459.5046825,
                          8400: 1587438428.652018,
                          8410: 1581029512.4797204,
                          8420: 1574652521.7253203,
                          8430: 1568307268.4044747,
                          8440: 1561993565.8013263,
                          8450: 1555711228.4589229,
                          8460: 1549460072.1697311,
                          8470: 1543239913.966223,
                          8480: 1537050572.1115377,
                          8490: 1530891866.0902252,
                          8500: 1524763616.5990589,
                          8510: 1518665645.5379357,
                          8520: 1512597776.0008388,
                          8530: 1506559832.2668786,
                          8540: 1500551639.7914162,
                          8550: 1494573025.1972425,
                          8560: 1488623816.265845,
                          8570: 1482703841.9287398,
                          8580: 1476812932.2588742,
                          8590: 1470950918.4620996,
                          8600: 1465117632.8687193,
                          8610: 1459312908.9250998,
                          8620: 1453536581.1853514,
                          8630: 1447788485.3030791,
                          8640: 1442068458.023199,
                          8650: 1436376337.173823,
                          8660: 1430711961.6582096,
                          8670: 1425075171.446777,
                          8680: 1419465807.5691867,
                          8690: 1413883712.1064875,
                          8700: 1408328728.1833248,
                          8710: 1402800699.960211,
                          8720: 1397299472.625869,
                          8730: 1391824892.3896172,
                          8740: 1386376806.4738388,
                          8750: 1380955063.1064982,
                          8760: 1375559511.5137236,
                          8770: 1370190001.9124455,
                          8780: 1364846385.5031016,
                          8790: 1359528514.4623947,
                          8800: 1354236241.9361088,
                          8810: 1348969422.031989,
                          8820: 1343727909.8126762,
                          8830: 1338511561.2886925,
                          8840: 1333320233.4114943,
                          8850: 1328153784.0665746,
                          8860: 1323012072.0666206,
                          8870: 1317894957.1447291,
                          8880: 1312802299.9476755,
                          8890: 1307733962.029237,
                          8900: 1302689805.8435671,
                          8910: 1297669694.738628,
                          8920: 1292673492.9496715,
                          8930: 1287701065.592775,
                          8940: 1282752278.6584272,
                          8950: 1277826999.0051653,
                          8960: 1272925094.353267,
                          8970: 1268046433.2784865,
                          8980: 1263190885.2058446,
                          8990: 1258358320.4034703,
                          9000: 1253548609.976486,
                          9010: 1248761625.8609457,
                          9020: 1243997240.817821,
                          9030: 1239255328.4270334,
                          9040: 1234535763.0815346,
                          9050: 1229838419.9814365,
                          9060: 1225163175.1281831,
                          9070: 1220509905.3187766,
                          9080: 1215878488.1400352,
                          9090: 1211268801.9629133,
                          9100: 1206680725.9368575,
                          9110: 1202114139.9842055,
                          9120: 1197568924.794635,
                          9130: 1193044961.819655,
                          9140: 1188542133.2671368,
                          9150: 1184060322.095895,
                          9160: 1179599412.0103045,
                          9170: 1175159287.454966,
                          9180: 1170739833.609406,
                          9190: 1166340936.38283,
                          9200: 1161962482.4089038,
                          9210: 1157604359.0405874,
                          9220: 1153266454.3450015,
                          9230: 1148948657.098337,
                          9240: 1144650856.7808099,
                          9250: 1140372943.5716455,
                          9260: 1136114808.3441083,
                          9270: 1131876342.660574,
                          9280: 1127657438.7676296,
                          9290: 1123457989.5912235,
                          9300: 1119277888.731848,
                          9310: 1115117030.459756,
                          9320: 1110975309.7102244,
                          9330: 1106852622.078844,
                          9340: 1102748863.816856,
                          9350: 1098663931.8265166,
                          9360: 1094597723.6565027,
                          9370: 1090550137.497352,
                          9380: 1086521072.1769392,
                          9390: 1082510427.1559854,
                          9400: 1078518102.5236053,
                          9410: 1074543998.992887,
                          9420: 1070588017.8965063,
                          9430: 1066650061.1823761,
                          9440: 1062730031.409328,
                          9450: 1058827831.7428293,
                          9460: 1054943365.9507313,
                          9470: 1051076538.399051,
                          9480: 1047227254.0477873,
                          9490: 1043395418.4467661,
                          9500: 1039580937.7315204,
                          9510: 1035783718.6192029,
                          9520: 1032003668.4045227,
                          9530: 1028240694.9557257,
                          9540: 1024494706.710596,
                          9550: 1020765612.6724917,
                          9560: 1017053322.4064102,
                          9570: 1013357746.0350862,
                          9580: 1009678794.2351154,
                          9590: 1006016378.2331133,
                          9600: 1002370409.8019,
                          9610: 998740801.2567126,
                          9620: 995127465.4514501,
                          9630: 991530315.7749469,
                          9640: 987949266.1472739,
                          9650: 984384231.0160663,
                          9660: 980835125.3528807,
                          9670: 977301864.6495824,
                          9680: 973784364.9147556,
                          9690: 970282542.670145,
                          9700: 966796314.9471229,
                          9710: 963325599.2831838,
                          9720: 959870313.7184622,
                          9730: 956430376.7922834,
                          9740: 953005707.5397366,
                          9750: 949596225.4882712,
                          9760: 946201850.6543261,
                          9770: 942822503.5399779,
                          9780: 939458105.129619,
                          9790: 936108576.8866574,
                          9800: 932773840.7502443,
                          9810: 929453819.132024,
                          9820: 926148434.9129122,
                          9830: 922857611.4398934,
                          9840: 919581272.5228465,
                          9850: 916319342.4313934,
                          9860: 913071745.8917683,
                          9870: 909838408.0837178,
                          9880: 906619254.637416,
                          9890: 903414211.630408,
                          9900: 900223205.5845747,
                          9910: 897046163.4631212,
                          9920: 893883012.6675867,
                          9930: 890733681.0348772,
                          9940: 887598096.834321,
                          9950: 884476188.764749,
                          9960: 881367885.9515864,
                          9970: 878273117.9439805,
                          9980: 875191814.7119396,
                          9990: 872123906.6434983},
                   5000: {10: 1.2748205273882118e-101,
                          20: 1.2176942525992887e-40,
                          30: 1.0801772423417112e-20,
                          40: 6.6528521377381e-11,
                          50: 3.8635071900035695e-05,
                          60: 0.22738306016558876,
                          70: 99.42869495953511,
                          80: 8692.960165289966,
                          90: 262486.0127175525,
                          100: 3792098.274410668,
                          110: 32211534.620581146,
                          120: 184422820.54757902,
                          130: 781802290.8573575,
                          140: 2623158315.1525397,
                          150: 7313173939.594436,
                          160: 17565989395.471916,
                          170: 37366138859.55629,
                          180: 71905248428.27806,
                          190: 127281689884.60089,
                          200: 210016670541.71973,
                          210: 326479767899.73364,
                          220: 482323734725.67316,
                          230: 682010061837.8922,
                          240: 928475915672.721,
                          250: 1222960971667.4116,
                          260: 1564986518817.0935,
                          270: 1952461952803.6494,
                          280: 2381885283636.6904,
                          290: 2848602791319.0244,
                          300: 3347096173909.918,
                          310: 3871271308994.308,
                          320: 4414729428799.488,
                          330: 4971007970926.325,
                          340: 5533783969553.667,
                          350: 6097037317642.332,
                          360: 6655174524134.173,
                          370: 7203115819458.929,
                          380: 7736349804615.289,
                          390: 8250960489714.368,
                          400: 8743631712926.459,
                          410: 9211633730688.062,
                          420: 9652796354428.621,
                          430: 10065472477045.97,
                          440: 10448495255763.043,
                          450: 10801131646086.932,
                          460: 11123034445794.395,
                          470: 11414194526203.836,
                          480: 11674894508819.562,
                          490: 11905664790474.758,
                          500: 12107242526786.244,
                          510: 12280533946941.018,
                          520: 12426580186127.242,
                          530: 12546526678408.822,
                          540: 12641596045739.225,
                          550: 12713064341774.738,
                          560: 12762240456477.08,
                          570: 12790448454194.264,
                          580: 12799012599708.049,
                          590: 12789244820053.37,
                          600: 12762434351793.43,
                          610: 12719839331477.541,
                          620: 12662680099301.81,
                          630: 12592134001026.537,
                          640: 12509331489816.504,
                          650: 12415353346976.025,
                          660: 12311228857896.232,
                          670: 12197934796443.549,
                          680: 12076395087171.115,
                          690: 11947481029913.07,
                          700: 11812011985398.203,
                          710: 11670756433433.53,
                          720: 11524433326945.53,
                          730: 11373713675749.645,
                          740: 11219222303392.836,
                          750: 11061539728842.098,
                          760: 10901204132245.348,
                          770: 10738713370548.006,
                          780: 10574527014486.188,
                          790: 10409068383474.797,
                          800: 10242726559239.709,
                          810: 10075858362779.236,
                          820: 9908790282447.21,
                          830: 9741820343689.54,
                          840: 9575219913294.404,
                          850: 9409235432983.068,
                          860: 9244090078821.504,
                          870: 9079985344311.098,
                          880: 8917102546158.955,
                          890: 8755604252665.206,
                          900: 8595635635425.899,
                          910: 8437325745661.1045,
                          920: 8280788716960.04,
                          930: 8126124896608.343,
                          940: 7973421907944.186,
                          950: 7822755646393.496,
                          960: 7674191211973.774,
                          970: 7527783781141.296,
                          980: 7383579420897.369,
                          990: 7241615848074.007,
                          1000: 7101923136694.38,
                          1010: 6964524376255.499,
                          1020: 6829436283713.39,
                          1030: 6696669771870.137,
                          1040: 6566230476770.305,
                          1050: 6438119246614.526,
                          1060: 6312332594593.256,
                          1070: 6188863117935.44,
                          1080: 6067699885357.28,
                          1090: 5948828794986.296,
                          1100: 5832232904727.117,
                          1110: 5717892736928.135,
                          1120: 5605786559103.98,
                          1130: 5495890642366.822,
                          1140: 5388179499121.883,
                          1150: 5282626101488.127,
                          1160: 5179202081814.743,
                          1170: 5077877916577.875,
                          1180: 4978623094859.976,
                          1190: 4881406272536.047,
                          1200: 4786195413217.254,
                          1210: 4692957916932.545,
                          1220: 4601660737462.781,
                          1230: 4512270489180.001,
                          1240: 4424753544185.736,
                          1250: 4339076120487.4873,
                          1260: 4255204361900.913,
                          1270: 4173104410316.865,
                          1280: 4092742470927.27,
                          1290: 4014084870961.4395,
                          1300: 3937098112444.872,
                          1310: 3861748919455.606,
                          1320: 3788004280318.774,
                          1330: 3715831485147.758,
                          1340: 3645198159110.449,
                          1350: 3576072291771.154,
                          1360: 3508422262832.6924,
                          1370: 3442216864579.1104,
                          1380: 3377425321296.8315,
                          1390: 3314017305931.3203,
                          1400: 3251962954216.7217,
                          1410: 3191232876498.095,
                          1420: 3131798167448.9155,
                          1430: 3073630413871.1396,
                          1440: 3016701700750.5903,
                          1450: 2960984615727.0977,
                          1460: 2906452252126.4043,
                          1470: 2853078210689.3467,
                          1480: 2800836600123.1987,
                          1490: 2749702036590.128,
                          1500: 2699649642238.6543,
                          1510: 2650655042875.481,
                          1520: 2602694364867.25,
                          1530: 2555744231354.5186,
                          1540: 2509781757853.5854,
                          1550: 2464784547315.503,
                          1560: 2420730684705.997,
                          1570: 2377598731164.5903,
                          1580: 2335367717796.424,
                          1590: 2294017139145.6865,
                          1600: 2253526946395.392,
                          1610: 2213877540334.4014,
                          1620: 2175049764128.9873,
                          1630: 2137024895933.0068,
                          1640: 2099784641367.6133,
                          1650: 2063311125898.7817,
                          1660: 2027586887138.1848,
                          1670: 1992594867090.713,
                          1680: 1958318404369.6448,
                          1690: 1924741226398.5178,
                          1700: 1891847441616.8635,
                          1710: 1859621531705.2595,
                          1720: 1828048343843.5923,
                          1730: 1797113083014.9792,
                          1740: 1766801304366.463,
                          1750: 1737098905636.3591,
                          1760: 1707992119657.0764,
                          1770: 1679467506941.106,
                          1780: 1651511948357.0366,
                          1790: 1624112637901.5298,
                          1800: 1597257075572.4023,
                          1810: 1570933060347.2854,
                          1820: 1545128683271.6145,
                          1830: 1519832320659.1514,
                          1840: 1495032627407.6538,
                          1850: 1470718530431.8408,
                          1860: 1446879222215.3228,
                          1870: 1423504154482.7607,
                          1880: 1400583031993.1597,
                          1890: 1378105806454.834,
                          1900: 1356062670562.2954,
                          1910: 1334444052155.038,
                          1920: 1313240608497.936,
                          1930: 1292443220682.7498,
                          1940: 1272042988150.0386,
                          1950: 1252031223330.5957,
                          1960: 1232399446405.3606,
                          1970: 1213139380182.635,
                          1980: 1194242945091.2686,
                          1990: 1175702254288.4255,
                          2000: 1157509608880.393,
                          2010: 1139657493254.8494,
                          2020: 1122138570522.904,
                          2030: 1104945678069.2,
                          2040: 1088071823208.273,
                          2050: 1071510178945.3628,
                          2060: 1055254079839.8043,
                          2070: 1039297017969.1105,
                          2080: 1023632638991.8551,
                          2090: 1008254738307.4102,
                          2100: 993157257310.6333,
                          2110: 978334279739.545,
                          2120: 963780028114.0819,
                          2130: 949488860263.9835,
                          2140: 935455265943.8954,
                          2150: 921673863533.7797,
                          2160: 908139396822.7283,
                          2170: 894846731874.3121,
                          2180: 881790853971.5927,
                          2190: 868966864639.9655,
                          2200: 856369978746.0106,
                          2210: 843995521670.5658,
                          2220: 831838926554.2505,
                          2230: 819895731613.7015,
                          2240: 808161577526.8037,
                          2250: 796632204885.2462,
                          2260: 785303451712.7284,
                          2270: 774171251047.2137,
                          2280: 763231628585.6196,
                          2290: 752480700389.3894,
                          2300: 741914670649.4121,
                          2310: 731529829508.7854,
                          2320: 721322550941.9587,
                          2330: 711289290688.8038,
                          2340: 701426584242.2228,
                          2350: 691731044887.8976,
                          2360: 682199361794.8478,
                          2370: 672828298155.4729,
                          2380: 663614689373.7943,
                          2390: 654555441300.6449,
                          2400: 645647528514.5707,
                          2410: 636887992647.2599,
                          2420: 628273940752.3125,
                          2430: 619802543716.2283,
                          2440: 611471034710.4886,
                          2450: 603276707683.652,
                          2460: 595216915892.3997,
                          2470: 587289070470.5094,
                          2480: 579490639034.7397,
                          2490: 571819144326.6527,
                          2500: 564272162889.4197,
                          2510: 556847323778.6708,
                          2520: 549542307306.49603,
                          2530: 542354843817.69824,
                          2540: 535282712497.45355,
                          2550: 528323740209.52893,
                          2560: 521475800364.2481,
                          2570: 514736811815.4122,
                          2580: 508104737785.39514,
                          2590: 501577584817.67206,
                          2600: 495153401756.0351,
                          2610: 488830278749.79724,
                          2620: 482606346284.2772,
                          2630: 476479774235.9038,
                          2640: 470448770951.267,
                          2650: 464511582349.4912,
                          2660: 458666491047.29913,
                          2670: 452911815506.16473,
                          2680: 447245909200.965,
                          2690: 441667159809.5586,
                          2700: 436173988422.7343,
                          2710: 430764848773.9843,
                          2720: 425438226488.58044,
                          2730: 420192638351.4349,
                          2740: 415026631593.24896,
                          2750: 409938783194.46387,
                          2760: 404927699206.5448,
                          2770: 399992014090.131,
                          2780: 395130390069.61523,
                          2790: 390341516503.71027,
                          2800: 385624109271.5867,
                          2810: 380976910174.1632,
                          2820: 376398686350.15765,
                          2830: 371888229706.50586,
                          2840: 367444356362.77026,
                          2850: 363065906109.1735,
                          2860: 358751741877.8953,
                          2870: 354500749227.28876,
                          2880: 350311835838.6753,
                          2890: 346183931025.3914,
                          2900: 342115985253.764,
                          2910: 338106969675.7073,
                          2920: 334155875672.63513,
                          2930: 330261714410.3963,
                          2940: 326423516404.946,
                          2950: 322640331098.4741,
                          2960: 318911226445.7217,
                          2970: 315235288510.2179,
                          2980: 311611621070.18713,
                          2990: 308039345233.8705,
                          3000: 304517599064.0239,
                          3010: 301045537211.35535,
                          3020: 297622330556.6698,
                          3030: 294247165861.50256,
                          3040: 290919245427.0196,
                          3050: 287637786760.976,
                          3060: 284402022252.52655,
                          3070: 281211198854.6889,
                          3080: 278064577774.2611,
                          3090: 274961434169.01086,
                          3100: 271901056851.9447,
                          3110: 268882748002.48413,
                          3120: 265905822884.3691,
                          3130: 262969609570.12335,
                          3140: 260073448671.91324,
                          3150: 257216693078.64038,
                          3160: 254398707699.11282,
                          3170: 251618869211.13928,
                          3180: 248876565816.40237,
                          3190: 246171197000.96222,
                          3200: 243502173301.2542,
                          3210: 240868916075.4401,
                          3220: 238270857279.98273,
                          3230: 235707439251.31332,
                          3240: 233178114492.4651,
                          3250: 230682345464.55127,
                          3260: 228219604382.9664,
                          3270: 225789373018.19717,
                          3280: 223391142501.12698,
                          3290: 221024413132.72562,
                          3300: 218688694198.01508,
                          3310: 216383503784.20856,
                          3320: 214108368602.9198,
                          3330: 211862823816.34433,
                          3340: 209646412867.31403,
                          3350: 207458687313.1347,
                          3360: 205299206663.11084,
                          3370: 203167538219.67093,
                          3380: 201063256923.00705,
                          3390: 198985945199.1398,
                          3400: 196935192811.3325,
                          3410: 194910596714.76865,
                          3420: 192911760914.41733,
                          3430: 190938296326.00998,
                          3440: 188989820640.0527,
                          3450: 187065958188.80524,
                          3460: 185166339816.15094,
                          3470: 183290602750.29407,
                          3480: 181438390479.2141,
                          3490: 179609352628.8135,
                          3500: 177803144843.69446,
                          3510: 176019428670.5037,
                          3520: 174257871443.783,
                          3530: 172518146174.26917,
                          3540: 170799931439.58383,
                          3550: 169102911277.25864,
                          3560: 167426775080.04053,
                          3570: 165771217493.42398,
                          3580: 164135938315.35883,
                          3590: 162520642398.08325,
                          3600: 160925039552.03195,
                          3610: 159348844451.77182,
                          3620: 157791776543.91907,
                          3630: 156253559956.99103,
                          3640: 154733923413.1489,
                          3650: 153232600141.78757,
                          3660: 151749327794.93036,
                          3670: 150283848364.388,
                          3680: 148835908100.6404,
                          3690: 147405257433.40277,
                          3700: 145991650893.83792,
                          3710: 144594847038.37683,
                          3720: 143214608374.1112,
                          3730: 141850701285.72305,
                          3740: 140502895963.9158,
                          3750: 139170966335.31335,
                          3760: 137854689993.79456,
                          3770: 136553848133.23058,
                          3780: 135268225481.59329,
                          3790: 133997610236.4048,
                          3800: 132741794001.49776,
                          3810: 131500571725.05753,
                          3820: 130273741638.9175,
                          3830: 129061105199.07916,
                          3840: 127862467027.43216,
                          3850: 126677634854.64397,
                          3860: 125506419464.19724,
                          3870: 124348634637.54716,
                          3880: 123204097100.37497,
                          3890: 122072626469.91357,
                          3900: 120954045203.32184,
                          3910: 119848178547.08452,
                          3920: 118754854487.41547,
                          3930: 117673903701.64276,
                          3940: 116605159510.55275,
                          3950: 115548457831.67534,
                          3960: 114503637133.48636,
                          3970: 113470538390.51079,
                          3980: 112449005039.3043,
                          3990: 111438882935.29672,
                          4000: 110440020310.4773,
                          4010: 109452267731.90443,
                          4020: 108475478061.02188,
                          4030: 107509506413.76472,
                          4040: 106554210121.43756,
                          4050: 105609448692.34918,
                          4060: 104675083774.18687,
                          4070: 103750979117.11588,
                          4080: 102837000537.58707,
                          4090: 101933015882.83914,
                          4100: 101038894996.08078,
                          4110: 100154509682.33676,
                          4120: 99279733674.94646,
                          4130: 98414442602.69899,
                          4140: 97558513957.59348,
                          4150: 96711827063.20978,
                          4160: 95874263043.67763,
                          4170: 95045704793.23232,
                          4180: 94226036946.34367,
                          4190: 93415145848.4074,
                          4200: 92612919526.98611,
                          4210: 91819247663.5897,
                          4220: 91034021565.9837,
                          4230: 90257134141.01393,
                          4240: 89488479867.93828,
                          4250: 88727954772.25388,
                          4260: 87975456400.01015,
                          4270: 87230883792.59798,
                          4280: 86494137462.00496,
                          4290: 85765119366.52724,
                          4300: 85043732886.92873,
                          4310: 84329882803.03885,
                          4320: 83623475270.77989,
                          4330: 82924417799.6145,
                          4340: 82232619230.40637,
                          4350: 81547989713.68416,
                          4360: 80870440688.30179,
                          4370: 80199884860.48674,
                          4380: 79536236183.26796,
                          4390: 78879409836.27693,
                          4400: 78229322205.9139,
                          4410: 77585890865.87148,
                          4420: 76949034558.0097,
                          4430: 76318673173.57436,
                          4440: 75694727734.75253,
                          4450: 75077120376.55876,
                          4460: 74465774329.04442,
                          4470: 73860613899.8251,
                          4480: 73261564456.9191,
                          4490: 72668552411.89082,
                          4500: 72081505203.29335,
                          4510: 71500351280.4046,
                          4520: 70925020087.25063,
                          4530: 70355442046.91113,
                          4540: 69791548546.10147,
                          4550: 69233271920.02545,
                          4560: 68680545437.49451,
                          4570: 68133303286.306984,
                          4580: 67591480558.8836,
                          4590: 67055013238.15343,
                          4600: 66523838183.68574,
                          4610: 65997893118.06322,
                          4620: 65477116613.49155,
                          4630: 64961448078.641426,
                          4640: 64450827745.71759,
                          4650: 63945196657.75156,
                          4660: 63444496656.113525,
                          4670: 62948670368.238495,
                          4680: 62457661195.56388,
                          4690: 61971413301.67344,
                          4700: 61489871600.64428,
                          4710: 61012981745.592926,
                          4720: 60540690117.41665,
                          4730: 60072943813.72638,
                          4740: 59609690637.96768,
                          4750: 59150879088.72637,
                          4760: 58696458349.21499,
                          4770: 58246378276.9371,
                          4780: 57800589393.525894,
                          4790: 57359042874.7538,
                          4800: 56921690540.71039,
                          4810: 56488484846.144775,
                          4820: 56059378870.969666,
                          4830: 55634326310.924805,
                          4840: 55213281468.39564,
                          4850: 54796199243.38528,
                          4860: 54383035124.6366,
                          4870: 53973745180.901726,
                          4880: 53568286052.35623,
                          4890: 53166614942.15544,
                          4900: 52768689608.13022,
                          4910: 52374468354.61948,
                          4920: 51983910024.43752,
                          4930: 51596973990.97312,
                          4940: 51213620150.4181,
                          4950: 50833808914.12354,
                          4960: 50457501201.08056,
                          4970: 50084658430.523964,
                          4980: 49715242514.65664,
                          4990: 49349215851.491554,
                          5000: 48986541317.81093,
                          5010: 48627182262.23861,
                          5020: 48271102498.42523,
                          5030: 47918266298.34305,
                          5040: 47568638385.6889,
                          5050: 47222183929.39364,
                          5060: 46878868537.23546,
                          5070: 46538658249.5561,
                          5080: 46201519533.07744,
                          5090: 45867419274.81676,
                          5100: 45536324776.09966,
                          5110: 45208203746.667816,
                          5120: 44883024298.880875,
                          5130: 44560754942.01009,
                          5140: 44241364576.62273,
                          5150: 43924822489.05505,
                          5160: 43611098345.97298,
                          5170: 43300162189.0181,
                          5180: 42991984429.538414,
                          5190: 42686535843.40165,
                          5200: 42383787565.89005,
                          5210: 42083711086.67529,
                          5220: 41786278244.87172,
                          5230: 41491461224.16698,
                          5240: 41199232548.028854,
                          5250: 40909565074.986046,
                          5260: 40622431993.98289,
                          5270: 40337806819.80589,
                          5280: 40055663388.58102,
                          5290: 39775975853.34079,
                          5300: 39498718679.659706,
                          5310: 39223866641.35688,
                          5320: 38951394816.26491,
                          5330: 38681278582.06366,
                          5340: 38413493612.17797,
                          5350: 38148015871.73814,
                          5360: 37884821613.602196,
                          5370: 37623887374.43882,
                          5380: 37365189970.870026,
                          5390: 37108706495.67244,
                          5400: 36854414314.036285,
                          5410: 36602291059.881065,
                          5420: 36352314632.227196,
                          5430: 36104463191.62208,
                          5440: 35858715156.62056,
                          5450: 35615049200.31811,
                          5460: 35373444246.93618,
                          5470: 35133879468.45896,
                          5480: 34896334281.320435,
                          5490: 34660788343.14108,
                          5500: 34427221549.51319,
                          5510: 34195614030.834583,
                          5520: 33965946149.188828,
                          5530: 33738198495.272438,
                          5540: 33512351885.367382,
                          5550: 33288387358.358624,
                          5560: 33066286172.795677,
                          5570: 32846029803.99768,
                          5580: 32627599941.201225,
                          5590: 32410978484.750046,
                          5600: 32196147543.326202,
                          5610: 31983089431.22179,
                          5620: 31771786665.650803,
                          5630: 31562221964.100143,
                          5640: 31354378241.719604,
                          5650: 31148238608.749687,
                          5660: 30943786367.98707,
                          5670: 30741005012.286873,
                          5680: 30539878222.10128,
                          5690: 30340389863.053677,
                          5700: 30142523983.54808,
                          5710: 29946264812.41317,
                          5720: 29751596756.580082,
                          5730: 29558504398.793953,
                          5740: 29366972495.358215,
                          5750: 29176985973.911343,
                          5760: 28988529931.23552,
                          5770: 28801589631.096733,
                          5780: 28616150502.11559,
                          5790: 28432198135.66873,
                          5800: 28249718283.820087,
                          5810: 28068696857.281517,
                          5820: 27889119923.402584,
                          5830: 27710973704.18874,
                          5840: 27534244574.347584,
                          5850: 27358919059.36288,
                          5860: 27184983833.59572,
                          5870: 27012425718.412388,
                          5880: 26841231680.338764,
                          5890: 26671388829.24052,
                          5900: 26502884416.528973,
                          5910: 26335705833.392075,
                          5920: 26169840609.05011,
                          5930: 26005276409.035892,
                          5940: 25842001033.49877,
                          5950: 25680002415.532578,
                          5960: 25519268619.5265,
                          5970: 25359787839.539078,
                          5980: 25201548397.694744,
                          5990: 25044538742.6025,
                          6000: 24888747447.79655,
                          6010: 24734163210.198418,
                          6020: 24580774848.60026,
                          6030: 24428571302.169125,
                          6040: 24277541628.971775,
                          6050: 24127675004.519684,
                          6060: 23978960720.334023,
                          6070: 23831388182.530376,
                          6080: 23684946910.42267,
                          6090: 23539626535.146236,
                          6100: 23395416798.299644,
                          6110: 23252307550.60491,
                          6120: 23110288750.58616,
                          6130: 22969350463.265846,
                          6140: 22829482858.879032,
                          6150: 22690676211.604767,
                          6160: 22552920898.31476,
                          6170: 22416207397.33888,
                          6180: 22280526287.24732,
                          6190: 22145868245.64904,
                          6200: 22012224048.006523,
                          6210: 21879584566.46626,
                          6220: 21747940768.70501,
                          6230: 21617283716.79139,
                          6240: 21487604566.062775,
                          6250: 21358894564.017113,
                          6260: 21231145049.219467,
                          6270: 21104347450.22319,
                          6280: 20978493284.5053,
                          6290: 20853574157.41607,
                          6300: 20729581761.142532,
                          6310: 20606507873.685547,
                          6320: 20484344357.850563,
                          6330: 20363083160.251495,
                          6340: 20242716310.327923,
                          6350: 20123235919.374966,
                          6360: 20004634179.586132,
                          6370: 19886903363.108524,
                          6380: 19770035821.1105,
                          6390: 19654023982.861572,
                          6400: 19538860354.82415,
                          6410: 19424537519.757267,
                          6420: 19311048135.831955,
                          6430: 19198384935.75802,
                          6440: 19086540725.92226,
                          6450: 18975508385.537815,
                          6460: 18865280865.804493,
                          6470: 18755851189.079956,
                          6480: 18647212448.0617,
                          6490: 18539357804.979412,
                          6500: 18432280490.79782,
                          6510: 18325973804.42981,
                          6520: 18220431111.959583,
                          6530: 18115645845.875786,
                          6540: 18011611504.314476,
                          6550: 17908321650.311695,
                          6560: 17805769911.065742,
                          6570: 17703949977.208603,
                          6580: 17602855602.08689,
                          6590: 17502480601.05176,
                          6600: 17402818850.757942,
                          6610: 17303864288.471584,
                          6620: 17205610911.386898,
                          6630: 17108052775.951448,
                          6640: 17011183997.199903,
                          6650: 16914998748.096264,
                          6660: 16819491258.884314,
                          6670: 16724655816.44622,
                          6680: 16630486763.669254,
                          6690: 16536978498.820438,
                          6700: 16444125474.928932,
                          6710: 16351922199.176252,
                          6720: 16260363232.294064,
                          6730: 16169443187.969437,
                          6740: 16079156732.2576,
                          6750: 15989498583.001904,
                          6760: 15900463509.261047,
                          6770: 15812046330.74338,
                          6780: 15724241917.248219,
                          6790: 15637045188.114098,
                          6800: 15550451111.673763,
                          6810: 15464454704.715982,
                          6820: 15379051031.953896,
                          6830: 15294235205.499996,
                          6840: 15210002384.34746,
                          6850: 15126347773.85795,
                          6860: 15043266625.255596,
                          6870: 14960754235.1272,
                          6880: 14878805944.928616,
                          6890: 14797417140.497034,
                          6900: 14716583251.569304,
                          6910: 14636299751.30608,
                          6920: 14556562155.821762,
                          6930: 14477366023.720116,
                          6940: 14398706955.635567,
                          6950: 14320580593.780037,
                          6960: 14242982621.495216,
                          6970: 14165908762.810295,
                          6980: 14089354782.005022,
                          6990: 14013316483.177967,
                          7000: 13937789709.820084,
                          7010: 13862770344.39329,
                          7020: 13788254307.914139,
                          7030: 13714237559.542528,
                          7040: 13640716096.175245,
                          7050: 13567685952.044426,
                          7060: 13495143198.320818,
                          7070: 13423083942.72169,
                          7080: 13351504329.12352,
                          7090: 13280400537.179195,
                          7100: 13209768781.939806,
                          7110: 13139605313.480917,
                          7120: 13069906416.53324,
                          7130: 13000668410.117718,
                          7140: 12931887647.184853,
                          7150: 12863560514.258387,
                          7160: 12795683431.083073,
                          7170: 12728252850.276659,
                          7180: 12661265256.985947,
                          7190: 12594717168.546888,
                          7200: 12528605134.148628,
                          7210: 12462925734.501526,
                          7220: 12397675581.509077,
                          7230: 12332851317.943596,
                          7240: 12268449617.125704,
                          7250: 12204467182.607609,
                          7260: 12140900747.859974,
                          7270: 12077747075.962517,
                          7280: 12015002959.298119,
                          7290: 11952665219.250517,
                          7300: 11890730705.905521,
                          7310: 11829196297.755602,
                          7320: 11768058901.407991,
                          7330: 11707315451.296083,
                          7340: 11646962909.39414,
                          7350: 11586998264.935368,
                          7360: 11527418534.13312,
                          7370: 11468220759.905384,
                          7380: 11409402011.602379,
                          7390: 11350959384.737299,
                          7400: 11292890000.720106,
                          7410: 11235191006.594383,
                          7420: 11177859574.777147,
                          7430: 11120892902.80171,
                          7440: 11064288213.063364,
                          7450: 11008042752.568007,
                          7460: 10952153792.68365,
                          7470: 10896618628.894638,
                          7480: 10841434580.558771,
                          7490: 10786598990.667078,
                          7500: 10732109225.606369,
                          7510: 10677962674.92441,
                          7520: 10624156751.097775,
                          7530: 10570688889.302309,
                          7540: 10517556547.186142,
                          7550: 10464757204.645267,
                          7560: 10412288363.601667,
                          7570: 10360147547.783833,
                          7580: 10308332302.509838,
                          7590: 10256840194.472769,
                          7600: 10205668811.528564,
                          7610: 10154815762.486237,
                          7620: 10104278676.900396,
                          7630: 10054055204.866096,
                          7640: 10004143016.815947,
                          7650: 9954539803.319485,
                          7660: 9905243274.884783,
                          7670: 9856251161.762207,
                          7680: 9807561213.750362,
                          7690: 9759171200.004194,
                          7700: 9711078908.845188,
                          7710: 9663282147.573645,
                          7720: 9615778742.283072,
                          7730: 9568566537.676517,
                          7740: 9521643396.885042,
                          7750: 9475007201.288036,
                          7760: 9428655850.335627,
                          7770: 9382587261.372967,
                          7780: 9336799369.466434,
                          7790: 9291290127.231737,
                          7800: 9246057504.663921,
                          7810: 9201099488.969149,
                          7820: 9156414084.398401,
                          7830: 9111999312.08288,
                          7840: 9067853209.871319,
                          7850: 9023973832.168907,
                          7860: 8980359249.778069,
                          7870: 8937007549.740915,
                          7880: 8893916835.183403,
                          7890: 8851085225.161175,
                          7900: 8808510854.507038,
                          7910: 8766191873.680098,
                          7920: 8724126448.616524,
                          7930: 8682312760.581886,
                          7940: 8640749006.025099,
                          7950: 8599433396.433891,
                          7960: 8558364158.191864,
                          7970: 8517539532.437042,
                          7980: 8476957774.921948,
                          7990: 8436617155.875153,
                          8000: 8396515959.864306,
                          8010: 8356652485.660639,
                          8020: 8317025046.104841,
                          8030: 8277631967.974452,
                          8040: 8238471591.8525715,
                          8050: 8199542271.998006,
                          8060: 8160842376.21678,
                          8070: 8122370285.7349615,
                          8080: 8084124395.072902,
                          8090: 8046103111.920737,
                          8100: 8008304857.0152,
                          8110: 7970728064.017765,
                          8120: 7933371179.394051,
                          8130: 7896232662.294455,
                          8140: 7859310984.436091,
                          8150: 7822604629.985925,
                          8160: 7786112095.445137,
                          8170: 7749831889.534683,
                          8180: 7713762533.082065,
                          8190: 7677902558.909291,
                          8200: 7642250511.721925,
                          8210: 7606804947.999378,
                          8220: 7571564435.886305,
                          8230: 7536527555.085092,
                          8240: 7501692896.749501,
                          8250: 7467059063.37939,
                          8260: 7432624668.716523,
                          8270: 7398388337.641473,
                          8280: 7364348706.071537,
                          8290: 7330504420.85977,
                          8300: 7296854139.694979,
                          8310: 7263396531.002813,
                          8320: 7230130273.847835,
                          8330: 7197054057.836575,
                          8340: 7164166583.021619,
                          8350: 7131466559.806643,
                          8360: 7098952708.852444,
                          8370: 7066623760.983899,
                          8380: 7034478457.097893,
                          8390: 7002515548.072169,
                          8400: 6970733794.675112,
                          8410: 6939131967.476455,
                          8420: 6907708846.758876,
                          8430: 6876463222.430493,
                          8440: 6845393893.938254,
                          8450: 6814499670.182188,
                          8460: 6783779369.430517,
                          8470: 6753231819.235672,
                          8480: 6722855856.351067,
                          8490: 6692650326.648797,
                          8500: 6662614085.038099,
                          8510: 6632745995.384686,
                          8520: 6603044930.430831,
                          8530: 6573509771.716297,
                          8540: 6544139409.500049,
                          8550: 6514932742.682719,
                          8560: 6485888678.7298765,
                          8570: 6457006133.596068,
                          8580: 6428284031.649579,
                          8590: 6399721305.597968,
                          8600: 6371316896.414344,
                          8610: 6343069753.264368,
                          8620: 6314978833.433958,
                          8630: 6287043102.257767,
                          8640: 6259261533.048298,
                          8650: 6231633107.025764,
                          8660: 6204156813.248637,
                          8670: 6176831648.5448675,
                          8680: 6149656617.443783,
                          8690: 6122630732.10868,
                          8700: 6095753012.270038,
                          8710: 6069022485.159415,
                          8720: 6042438185.4440155,
                          8730: 6015999155.16183,
                          8740: 5989704443.657484,
                          8750: 5963553107.518656,
                          8760: 5937544210.513163,
                          8770: 5911676823.526621,
                          8780: 5885950024.50074,
                          8790: 5860362898.372217,
                          8800: 5834914537.012188,
                          8810: 5809604039.166324,
                          8820: 5784430510.395468,
                          8830: 5759393063.016857,
                          8840: 5734490816.045926,
                          8850: 5709722895.138654,
                          8860: 5685088432.534479,
                          8870: 5660586566.999764,
                          8880: 5636216443.77181,
                          8890: 5611977214.503404,
                          8900: 5587868037.207886,
                          8910: 5563888076.204782,
                          8920: 5540036502.065918,
                          8930: 5516312491.5620775,
                          8940: 5492715227.610156,
                          8950: 5469243899.220831,
                          8960: 5445897701.446721,
                          8970: 5422675835.331061,
                          8980: 5399577507.856833,
                          8990: 5376601931.896403,
                          9000: 5353748326.16166,
                          9010: 5331015915.154573,
                          9020: 5308403929.11827,
                          9030: 5285911603.988547,
                          9040: 5263538181.345868,
                          9050: 5241282908.367773,
                          9060: 5219145037.781802,
                          9070: 5197123827.818796,
                          9080: 5175218542.166685,
                          9090: 5153428449.92469,
                          9100: 5131752825.55797,
                          9110: 5110190948.85268,
                          9120: 5088742104.871468,
                          9130: 5067405583.909376,
                          9140: 5046180681.450174,
                          9150: 5025066698.12307,
                          9160: 5004062939.6598625,
                          9170: 4983168716.852469,
                          9180: 4962383345.510866,
                          9190: 4941706146.4214,
                          9200: 4921136445.305525,
                          9210: 4900673572.778877,
                          9220: 4880316864.310779,
                          9230: 4860065660.184064,
                          9240: 4839919305.455347,
                          9250: 4819877149.915589,
                          9260: 4799938548.051069,
                          9270: 4780102859.004713,
                          9280: 4760369446.537778,
                          9290: 4740737678.991874,
                          9300: 4721206929.251373,
                          9310: 4701776574.706131,
                          9320: 4682445997.214556,
                          9330: 4663214583.0670395,
                          9340: 4644081722.9496975,
                          9350: 4625046811.908473,
                          9360: 4606109249.313521,
                          9370: 4587268438.823993,
                          9380: 4568523788.353054,
                          9390: 4549874710.033306,
                          9400: 4531320620.182463,
                          9410: 4512860939.269369,
                          9420: 4494495091.880334,
                          9430: 4476222506.685745,
                          9440: 4458042616.407013,
                          9450: 4439954857.783796,
                          9460: 4421958671.541547,
                          9470: 4404053502.359315,
                          9480: 4386238798.8378935,
                          9490: 4368514013.468197,
                          9500: 4350878602.599977,
                          9510: 4333332026.410787,
                          9520: 4315873748.87523,
                          9530: 4298503237.734506,
                          9540: 4281219964.466214,
                          9550: 4264023404.254427,
                          9560: 4246913035.960043,
                          9570: 4229888342.091398,
                          9580: 4212948808.775138,
                          9590: 4196093925.7273774,
                          9600: 4179323186.2250776,
                          9610: 4162636087.07771,
                          9620: 4146032128.5991545,
                          9630: 4129510814.5798645,
                          9640: 4113071652.2592726,
                          9650: 4096714152.2984424,
                          9660: 4080437828.752966,
                          9670: 4064242199.046086,
                          9680: 4048126783.942098,
                          9690: 4032091107.5199385,
                          9700: 4016134697.147042,
                          9710: 4000257083.4534187,
                          9720: 3984457800.305952,
                          9730: 3968736384.7829537,
                          9740: 3953092377.148894,
                          9750: 3937525320.8294096,
                          9760: 3922034762.3864913,
                          9770: 3906620251.493917,
                          9780: 3891281340.9128766,
                          9790: 3876017586.467828,
                          9800: 3860828547.022563,
                          9810: 3845713784.4564843,
                          9820: 3830672863.641075,
                          9830: 3815705352.4166007,
                          9840: 3800810821.568992,
                          9850: 3785988844.806947,
                          9860: 3771238998.7392106,
                          9870: 3756560862.85208,
                          9880: 3741954019.487081,
                          9890: 3727418053.8188667,
                          9900: 3712952553.8332787,
                          9910: 3698557110.305613,
                          9920: 3684231316.7790766,
                          9930: 3669974769.5434356,
                          9940: 3655787067.613822,
                          9950: 3641667812.7097745,
                          9960: 3627616609.234396,
                          9970: 3613633064.253735,
                          9980: 3599716787.4763527,
                          9990: 3585867391.2330194},
                   10000: {10: 3.896621608317724e-39,
                           20: 2.128912684076192e-09,
                           30: 7.27625792529884,
                           40: 278174.7252892789,
                           50: 121347144.78114137,
                           60: 5901530257.522529,
                           70: 83941066084.88127,
                           80: 562111660655.1013,
                           90: 2300967949704.898,
                           100: 6720533457335.031,
                           110: 15434359511221.541,
                           120: 29711229301527.07,
                           130: 50079568602146.99,
                           140: 76220329076374.1,
                           150: 107107077565117.38,
                           160: 141271341721583.62,
                           170: 177081087025717.34,
                           180: 212965584772293.53,
                           190: 247563193747689.25,
                           200: 279796214813646.7,
                           210: 308889483341715.9,
                           220: 334351848184417.4,
                           230: 355937102265420.6,
                           240: 373596624282226.0,
                           250: 387431760857159.8,
                           260: 397650565956071.75,
                           270: 404531073463655.2,
                           280: 408391694607266.56,
                           290: 409568403190657.56,
                           300: 408397899257389.75,
                           310: 405205763177657.94,
                           320: 400298607674128.1,
                           330: 393959323452679.44,
                           340: 386444642789475.7,
                           350: 377984383532742.5,
                           360: 368781866462256.94,
                           370: 359015113708570.75,
                           380: 348838532231851.1,
                           390: 338384864463558.0,
                           400: 327767249895670.7,
                           410: 317081289038310.75,
                           420: 306407037225420.94,
                           430: 295810882522288.1,
                           440: 285347281477086.56,
                           450: 275060340333628.78,
                           460: 264985238942721.28,
                           470: 255149501054213.94,
                           480: 245574118783160.78,
                           490: 236274541468715.8,
                           500: 227261540374220.16,
                           510: 218541961078828.47,
                           520: 210119375256649.75,
                           530: 201994643026984.2,
                           540: 194166396331432.97,
                           550: 186631452951267.75,
                           560: 179385169891327.38,
                           570: 172421743971900.25,
                           580: 165734466618071.78,
                           590: 159315939035519.22,
                           600: 153158253222952.12,
                           610: 147253143598809.0,
                           620: 141592113413943.56,
                           630: 136166539580829.22,
                           640: 130967759069672.64,
                           650: 125987139598235.9,
                           660: 121216136970200.77,
                           670: 116646341091534.38,
                           680: 112269512410646.16,
                           690: 108077610281498.61,
                           700: 104062814534935.1,
                           710: 100217541358365.3,
                           720: 96534454424018.89,
                           730: 93006472068044.94,
                           740: 89626771203942.36,
                           750: 86388788551636.94,
                           760: 83286219675752.0,
                           770: 80313016251314.73,
                           780: 77463381910591.9,
                           790: 74731766969485.56,
                           800: 72112862284652.55,
                           810: 69601592452127.59,
                           820: 67193108523763.625,
                           830: 64882780388421.914,
                           840: 62666188939828.63,
                           850: 60539118131739.63,
                           860: 58497547002994.95,
                           870: 56537641739726.81,
                           880: 54655747829026.445,
                           890: 52848382347425.17,
                           900: 51112226418316.875,
                           910: 49444117864691.664,
                           920: 47841044077044.92,
                           930: 46300135110890.33,
                           940: 44818657023781.11,
                           950: 43394005457993.45,
                           960: 42023699471933.95,
                           970: 40705375620801.234,
                           980: 39436782284971.54,
                           990: 38215774242920.59,
                           1000: 37040307484172.58,
                           1010: 35908434256732.93,
                           1020: 34818298342664.734,
                           1030: 33768130554873.74,
                           1040: 32756244447739.363,
                           1050: 31781032233940.266,
                           1060: 30840960899650.62,
                           1070: 29934568510204.652,
                           1080: 29060460698327.305,
                           1090: 28217307327090.965,
                           1100: 27403839319872.34,
                           1110: 26618845649736.016,
                           1120: 25861170480857.72,
                           1130: 25129710454807.31,
                           1140: 24423412114739.83,
                           1150: 23741269460781.188,
                           1160: 23082321630142.68,
                           1170: 22445650695751.13,
                           1180: 21830379577435.13,
                           1190: 21235670059961.418,
                           1200: 20660720912466.26,
                           1210: 20104766104074.0,
                           1220: 19567073110735.637,
                           1230: 19046941308556.79,
                           1240: 18543700449111.67,
                           1250: 18056709212461.43,
                           1260: 17585353833807.873,
                           1270: 17129046799918.514,
                           1280: 16687225611655.94,
                           1290: 16259351609132.645,
                           1300: 15844908856193.123,
                           1310: 15443403081096.871,
                           1320: 15054360670440.545,
                           1330: 14677327713513.572,
                           1340: 14311869094430.88,
                           1350: 13957567629527.498,
                           1360: 13614023247634.574,
                           1370: 13280852210983.967,
                           1380: 12957686374609.434,
                           1390: 12644172482227.688,
                           1400: 12339971496690.773,
                           1410: 12044757963205.045,
                           1420: 11758219403608.648,
                           1430: 11480055740092.65,
                           1440: 11209978746837.61,
                           1450: 10947711528120.447,
                           1460: 10692988021524.324,
                           1470: 10445552524958.271,
                           1480: 10205159246263.094,
                           1490: 9971571874245.988,
                           1500: 9744563170048.766,
                           1510: 9523914577813.434,
                           1520: 9309415853664.627,
                           1530: 9100864712080.85,
                           1540: 8898066488776.355,
                           1550: 8700833819262.23,
                           1560: 8508986332299.812,
                           1570: 8322350357501.224,
                           1580: 8140758646371.61,
                           1590: 7964050106124.876,
                           1600: 7792069545640.135,
                           1610: 7624667432959.447,
                           1620: 7461699663758.883,
                           1630: 7303027340254.925,
                           1640: 7148516560036.063,
                           1650: 6998038214336.482,
                           1660: 6851467795293.434,
                           1670: 6708685211754.049,
                           1680: 6569574613219.547,
                           1690: 6434024221536.226,
                           1700: 6301926169962.64,
                           1710: 6173176349261.3545,
                           1720: 6047674260481.687,
                           1730: 5925322874116.83,
                           1740: 5806028495334.852,
                           1750: 5689700634998.223,
                           1760: 5576251886201.056,
                           1770: 5465597806066.683,
                           1780: 5357656802561.297,
                           1790: 5252350026091.482,
                           1800: 5149601265665.022,
                           1810: 5049336849405.41,
                           1820: 4951485549220.765,
                           1830: 4855978489437.771,
                           1840: 4762749059220.493,
                           1850: 4671732828602.813,
                           1860: 4582867467971.559,
                           1870: 4496092670845.306,
                           1880: 4411350079801.426,
                           1890: 4328583215410.9854,
                           1900: 4247737408047.928,
                           1910: 4168759732445.36,
                           1920: 4091598944877.829,
                           1930: 4016205422854.3115,
                           1940: 3942531107211.999,
                           1950: 3870529446506.299,
                           1960: 3800155343597.295,
                           1970: 3731365104337.688,
                           1980: 3664116388271.5635,
                           1990: 3598368161257.738,
                           2000: 3534080649935.2734,
                           2010: 3471215297952.7,
                           2020: 3409734723886.002,
                           2030: 3349602680773.98,
                           2040: 3290784017202.786,
                           2050: 3233244639874.585,
                           2060: 3176951477598.2866,
                           2070: 3121872446642.991,
                           2080: 3067976417397.684,
                           2090: 3015233182282.9976,
                           2100: 2963613424863.5557,
                           2110: 2913088690111.4785,
                           2120: 2863631355774.025,
                           2130: 2815214604800.3247,
                           2140: 2767812398784.1587,
                           2150: 2721399452381.719,
                           2160: 2675951208664.9565,
                           2170: 2631443815373.004,
                           2180: 2587854102025.657,
                           2190: 2545159557864.5747,
                           2200: 2503338310589.2446,
                           2210: 2462369105856.3105,
                           2220: 2422231287512.081,
                           2230: 2382904778529.4214,
                           2240: 2344370062621.411,
                           2250: 2306608166505.387,
                           2260: 2269600642792.02,
                           2270: 2233329553475.247,
                           2280: 2197777453999.8242,
                           2290: 2162927377884.2751,
                           2300: 2128762821877.9436,
                           2310: 2095267731631.7295,
                           2320: 2062426487862.963,
                           2330: 2030223892995.6328,
                           2340: 1998645158258.0442,
                           2350: 1967675891220.617,
                           2360: 1937302083757.3328,
                           2370: 1907510100414.9658,
                           2380: 1878286667174.8796,
                           2390: 1849618860592.8286,
                           2400: 1821494097302.7324,
                           2410: 1793900123871.0293,
                           2420: 1766825006988.6604,
                           2430: 1740257123988.371,
                           2440: 1714185153675.3994,
                           2450: 1688598067460.167,
                           2460: 1663485120782.0007,
                           2470: 1638835844813.3792,
                           2480: 1614640038434.578,
                           2490: 1590887760469.0125,
                           2500: 1567569322169.9497,
                           2510: 1544675279949.6074,
                           2520: 1522196428342.045,
                           2530: 1500123793191.5347,
                           2540: 1478448625058.478,
                           2550: 1457162392835.1892,
                           2560: 1436256777564.188,
                           2570: 1415723666451.9272,
                           2580: 1395555147071.1353,
                           2590: 1375743501745.2292,
                           2600: 1356281202108.4817,
                           2610: 1337160903835.895,
                           2620: 1318375441536.9233,
                           2630: 1299917823807.4524,
                           2640: 1281781228434.5925,
                           2650: 1263958997749.1106,
                           2660: 1246444634120.477,
                           2670: 1229231795589.695,
                           2680: 1212314291635.2703,
                           2690: 1195686079067.8408,
                           2700: 1179341258049.1611,
                           2710: 1163274068231.2703,
                           2720: 1147478885011.858,
                           2730: 1131950215901.9578,
                           2740: 1116682697002.254,
                           2750: 1101671089584.422,
                           2760: 1086910276774.0425,
                           2770: 1072395260331.7562,
                           2780: 1058121157529.4617,
                           2790: 1044083198118.4392,
                           2800: 1030276721386.4385,
                           2810: 1016697173300.8257,
                           2820: 1003340103735.0273,
                           2830: 990201163775.5862,
                           2840: 977276103107.241,
                           2850: 964560767473.5386,
                           2860: 952051096210.5626,
                           2870: 939743119851.4629,
                           2880: 927632957799.5366,
                           2890: 915716816067.6989,
                           2900: 903990985082.2428,
                           2910: 892451837548.8827,
                           2920: 881095826379.1227,
                           2930: 869919482675.063,
                           2940: 858919413770.8405,
                           2950: 848092301328.9271,
                           2960: 837434899489.6035,
                           2970: 826944033071.9607,
                           2980: 816616595824.848,
                           2990: 806449548726.2318,
                           3000: 796439918329.4896,
                           3010: 786584795155.2084,
                           3020: 776881332127.0968,
                           3030: 767326743050.6887,
                           3040: 757918301133.5254,
                           3050: 748653337545.5886,
                           3060: 739529240018.7571,
                           3070: 730543451484.129,
                           3080: 721693468746.0723,
                           3090: 712976841191.9142,
                           3100: 704391169536.2087,
                           3110: 695934104598.5603,
                           3120: 687603346114.0088,
                           3130: 679396641575.023,
                           3140: 671311785104.1696,
                           3150: 663346616356.561,
                           3160: 655499019451.218,
                           3170: 647766921930.4935,
                           3180: 640148293746.7562,
                           3190: 632641146275.536,
                           3200: 625243531354.3728,
                           3210: 617953540346.6226,
                           3220: 610769303229.5123,
                           3230: 603688987705.7438,
                           3240: 596710798337.9744,
                           3250: 589832975705.5303,
                           3260: 583053795582.7067,
                           3270: 576371568138.0632,
                           3280: 569784637154.1038,
                           3290: 563291379266.7805,
                           3300: 556890203224.2542,
                           3310: 550579549164.3807,
                           3320: 544357887910.3969,
                           3330: 538223720284.29803,
                           3340: 532175576437.41614,
                           3350: 526212015197.7258,
                           3360: 520331623433.41003,
                           3370: 514533015432.2432,
                           3380: 508814832296.3535,
                           3390: 503175741351.943,
                           3400: 497614435573.5604,
                           3410: 492129633022.52466,
                           3420: 486720076299.1187,
                           3430: 481384532008.1791,
                           3440: 476121790237.7157,
                           3450: 470930664050.2177,
                           3460: 465809988986.2964,
                           3470: 460758622580.33813,
                           3480: 455775443887.8469,
                           3490: 450859353024.1607,
                           3500: 446009270714.2427,
                           3510: 441224137853.25244,
                           3520: 436502915077.60785,
                           3530: 431844582346.2662,
                           3540: 427248138531.95264,
                           3550: 422712601022.0738,
                           3560: 418237005329.06366,
                           3570: 413820404709.9153,
                           3580: 409461869794.6583,
                           3590: 405160488223.5503,
                           3600: 400915364292.7561,
                           3610: 396725618608.29047,
                           3620: 392590387748.0225,
                           3630: 388508823931.51917,
                           3640: 384480094697.5398,
                           3650: 380503382588.9767,
                           3660: 376577884845.0557,
                           3670: 372702813100.6125,
                           3680: 368877393092.2598,
                           3690: 365100864371.2761,
                           3700: 361372480023.0434,
                           3710: 357691506392.8687,
                           3720: 354057222818.02765,
                           3730: 350468921365.8768,
                           3740: 346925906577.8807,
                           3750: 343427495219.4038,
                           3760: 339973016035.1288,
                           3770: 336561809509.95654,
                           3780: 333193227635.25336,
                           3790: 329866633680.3148,
                           3800: 326581401968.91406,
                           3810: 323336917660.8127,
                           3820: 320132576538.1103,
                           3830: 316967784796.31305,
                           3840: 313841958840.0116,
                           3850: 310754525083.046,
                           3860: 307704919753.0583,
                           3870: 304692588700.32135,
                           3880: 301716987210.74005,
                           3890: 298777579822.9259,
                           3900: 295873840149.2455,
                           3910: 293005250700.74884,
                           3920: 290171302715.8822,
                           3930: 287371495992.8982,
                           3940: 284605338725.8689,
                           3950: 281872347344.2252,
                           3960: 279172046355.72876,
                           3970: 276503968192.80316,
                           3980: 273867653062.13965,
                           3990: 271262648797.50235,
                           4000: 268688510715.6578,
                           4010: 266144801475.35492,
                           4020: 263631090939.2823,
                           4030: 261146956038.93695,
                           4040: 258691980642.33286,
                           4050: 256265755424.4864,
                           4060: 253867877740.60962,
                           4070: 251497951501.95493,
                           4080: 249155587054.2444,
                           4090: 246840401058.62607,
                           4100: 244552016375.1016,
                           4110: 242290061948.36176,
                           4120: 240054172695.98404,
                           4130: 237843989398.92874,
                           4140: 235659158594.28918,
                           4150: 233499332470.23932,
                           4160: 231364168763.1307,
                           4170: 229253330656.6918,
                           4180: 227166486683.2782,
                           4190: 225103310627.13257,
                           4200: 223063481429.60358,
                           4210: 221046683096.28403,
                           4220: 219052604606.02414,
                           4230: 217080939821.77655,
                           4240: 215131387403.23413,
                           4250: 213203650721.21918,
                           4260: 211297437773.7866,
                           4270: 209412461104.00156,
                           4280: 207548437719.35605,
                           4290: 205705089012.78653,
                           4300: 203882140685.259,
                           4310: 202079322669.88666,
                           4320: 200296369057.54553,
                           4330: 198533018023.9564,
                           4340: 196789011758.20105,
                           4350: 195064096392.6412,
                           4360: 193358021934.2085,
                           4370: 191670542197.0395,
                           4380: 190001414736.4212,
                           4390: 188350400784.02368,
                           4400: 186717265184.39,
                           4410: 185101776332.65497,
                           4420: 183503706113.46964,
                           4430: 181922829841.10333,
                           4440: 180358926200.6979,
                           4450: 178811777190.65234,
                           4460: 177281168066.10938,
                           4470: 175766887283.525,
                           4480: 174268726446.29507,
                           4490: 172786480251.41867,
                           4500: 171319946437.17313,
                           4510: 169868925731.78464,
                           4520: 168433221803.06778,
                           4530: 167012641209.01767,
                           4540: 165606993349.33392,
                           4550: 164216090417.85504,
                           4560: 162839747355.88696,
                           4570: 161477781806.40558,
                           4580: 160130014069.1156,
                           4590: 158796267056.34772,
                           4600: 157476366249.7768,
                           4610: 156170139657.94492,
                           4620: 154877417774.5711,
                           4630: 153598033537.63422,
                           4640: 152331822289.2089,
                           4650: 151078621736.04395,
                           4660: 149838271910.86578,
                           4670: 148610615134.39032,
                           4680: 147395495978.03268,
                           4690: 146192761227.29773,
                           4700: 145002259845.8388,
                           4710: 143823842940.1707,
                           4720: 142657363725.0244,
                           4730: 141502677489.3295,
                           4740: 140359641562.8126,
                           4750: 139228115283.19925,
                           4760: 138107959964.00735,
                           4770: 136999038862.91885,
                           4780: 135901217150.72137,
                           4790: 134814361880.80441,
                           4800: 133738341959.20248,
                           4810: 132673028115.17294,
                           4820: 131618292872.29672,
                           4830: 130574010520.09491,
                           4840: 129540057086.14714,
                           4850: 128516310308.70534,
                           4860: 127502649609.79047,
                           4870: 126498956068.7646,
                           4880: 125505112396.36772,
                           4890: 124521002909.21205,
                           4900: 123546513504.72202,
                           4910: 122581531636.5144,
                           4920: 121625946290.20775,
                           4930: 120679647959.65474,
                           4940: 119742528623.5866,
                           4950: 118814481722.66492,
                           4960: 117895402136.93045,
                           4970: 116985186163.6423,
                           4980: 116083731495.50067,
                           4990: 115190937199.24329,
                           5000: 114306703694.6124,
                           5010: 113430932733.68124,
                           5020: 112563527380.53596,
                           5030: 111704391991.3047,
                           5040: 110853432194.52779,
                           5050: 110010554871.86264,
                           5060: 109175668139.11707,
                           5070: 108348681327.60477,
                           5080: 107529504965.81633,
                           5090: 106718050761.4006,
                           5100: 105914231583.45107,
                           5110: 105117961445.08945,
                           5120: 104329155486.34366,
                           5130: 103547729957.3123,
                           5140: 102773602201.61224,
                           5150: 102006690640.1023,
                           5160: 101246914754.87947,
                           5170: 100494195073.54147,
                           5180: 99748453153.71141,
                           5190: 99009611567.81949,
                           5200: 98277593888.13675,
                           5210: 97552324672.05692,
                           5220: 96833729447.62103,
                           5230: 96121734699.28055,
                           5240: 95416267853.89598,
                           5250: 94717257266.96356,
                           5260: 94024632209.06966,
                           5270: 93338322852.56584,
                           5280: 92658260258.46194,
                           5290: 91984376363.53317,
                           5300: 91316603967.63681,
                           5310: 90654876721.2349,
                           5320: 89999129113.12009,
                           5330: 89349296458.3394,
                           5340: 88705314886.31367,
                           5350: 88067121329.14854,
                           5360: 87434653510.13399,
                           5370: 86807849932.42825,
                           5380: 86186649867.9242,
                           5390: 85570993346.293,
                           5400: 84960821144.2042,
                           5410: 84356074774.71689,
                           5420: 83756696476.84091,
                           5430: 83162629205.26303,
                           5440: 82573816620.23747,
                           5450: 81990203077.63562,
                           5460: 81411733619.15424,
                           5470: 80838353962.67749,
                           5480: 80270010492.79152,
                           5490: 79706650251.44824,
                           5500: 79148220928.77551,
                           5510: 78594670854.03253,
                           5520: 78045948986.70515,
                           5530: 77502004907.74237,
                           5540: 76962788810.928,
                           5550: 76428251494.38794,
                           5560: 75898344352.22858,
                           5570: 75373019366.306,
                           5580: 74852229098.12202,
                           5590: 74335926680.84587,
                           5600: 73824065811.45941,
                           5610: 73316600743.02303,
                           5620: 72813486277.06091,
                           5630: 72314677756.06325,
                           5640: 71820131056.10365,
                           5650: 71329802579.56924,
                           5660: 70843649248.00249,
                           5670: 70361628495.0517,
                           5680: 69883698259.5297,
                           5690: 69409816978.57721,
                           5700: 68939943580.93092,
                           5710: 68474037480.29317,
                           5720: 68012058568.80204,
                           5730: 67553967210.60031,
                           5740: 67099724235.50143,
                           5750: 66649290932.75055,
                           5760: 66202629044.87978,
                           5770: 65759700761.655846,
                           5780: 65320468714.11774,
                           5790: 64884895968.70426,
                           5800: 64452946021.469055,
                           5810: 64024582792.381805,
                           5820: 63599770619.71468,
                           5830: 63178474254.511635,
                           5840: 62760658855.14016,
                           5850: 62346289981.92401,
                           5860: 61935333591.85466,
                           5870: 61527756033.38141,
                           5880: 61123524041.27808,
                           5890: 60722604731.585335,
                           5900: 60324965596.627266,
                           5910: 59930574500.10122,
                           5920: 59539399672.23935,
                           5930: 59151409705.041306,
                           5940: 58766573547.575874,
                           5950: 58384860501.352066,
                           5960: 58006240215.75648,
                           5970: 57630682683.557915,
                           5980: 57258158236.4766,
                           5990: 56888637540.81797,
                           6000: 56522091593.16916,
                           6010: 56158491716.15825,
                           6020: 55797809554.27397,
                           6030: 55440017069.746086,
                           6040: 55085086538.48469,
                           6050: 54732990546.07795,
                           6060: 54383701983.846886,
                           6070: 54037194044.956985,
                           6080: 53693440220.58503,
                           6090: 53352414296.1406,
                           6100: 53014090347.54152,
                           6110: 52678442737.54208,
                           6120: 52345446112.11355,
                           6130: 52015075396.87554,
                           6140: 51687305793.578545,
                           6150: 51362112776.63535,
                           6160: 51039472089.70205,
                           6170: 50719359742.30675,
                           6180: 50401752006.525986,
                           6190: 50086625413.707405,
                           6200: 49773956751.23868,
                           6210: 49463723059.36172,
                           6220: 49155901628.03087,
                           6230: 48850469993.81548,
                           6240: 48547405936.845535,
                           6250: 48246687477.79931,
                           6260: 47948292874.93343,
                           6270: 47652200621.15373,
                           6280: 47358389441.12682,
                           6290: 47066838288.431404,
                           6300: 46777526342.74925,
                           6310: 46490433007.09451,
                           6320: 46205537905.08129,
                           6330: 45922820878.228676,
                           6340: 45642261983.303085,
                           6350: 45363841489.69636,
                           6360: 45087539876.84047,
                           6370: 44813337831.656815,
                           6380: 44541216246.04082,
                           6390: 44271156214.3805,
                           6400: 44003139031.10881,
                           6410: 43737146188.28929,
                           6420: 43473159373.23437,
                           6430: 43211160466.1557,
                           6440: 42951131537.846794,
                           6450: 42693054847.396194,
                           6460: 42436912839.93222,
                           6470: 42182688144.39711,
                           6480: 41930363571.35222,
                           6490: 41679922110.81151,
                           6500: 41431346930.10487,
                           6510: 41184621371.769615,
                           6520: 40939728951.47018,
                           6530: 40696653355.94571,
                           6540: 40455378440.984795,
                           6550: 40215888229.42714,
                           6560: 39978166909.19198,
                           6570: 39742198831.33215,
                           6580: 39507968508.11464,
                           6590: 39275460611.12561,
                           6600: 39044659969.401306,
                           6610: 38815551567.58293,
                           6620: 38588120544.09607,
                           6630: 38362352189.35419,
                           6640: 38138231943.98526,
                           6650: 37915745397.082115,
                           6660: 37694878284.47537,
                           6670: 37475616487.0288,
                           6680: 37257946028.95753,
                           6690: 37041853076.167435,
                           6700: 36827323934.61646,
                           6710: 36614345048.69737,
                           6720: 36402902999.641174,
                           6730: 36192984503.941345,
                           6740: 35984576411.79853,
                           6750: 35777665705.5852,
                           6760: 35572239498.330055,
                           6770: 35368285032.22214,
                           6780: 35165789677.13393,
                           6790: 34964740929.16381,
                           6800: 34765126409.19665,
                           6810: 34566933861.48326,
                           6820: 34370151152.23793,
                           6830: 34174766268.25372,
                           6840: 33980767315.535408,
                           6850: 33788142517.950222,
                           6860: 33596880215.895065,
                           6870: 33406968864.981304,
                           6880: 33218397034.73587,
                           6890: 33031153407.318798,
                           6900: 32845226776.257195,
                           6910: 32660606045.19499,
                           6920: 32477280226.658592,
                           6930: 32295238440.837852,
                           6940: 32114469914.38271,
                           6950: 31934963979.214634,
                           6960: 31756710071.353043,
                           6970: 31579697729.756615,
                           6980: 31403916595.178715,
                           6990: 31229356409.03749,
                           7000: 31056007012.29979,
                           7010: 30883858344.379078,
                           7020: 30712900442.047085,
                           7030: 30543123438.358833,
                           7040: 30374517561.591198,
                           7050: 30207073134.194435,
                           7060: 30040780571.75678,
                           7070: 29875630381.981697,
                           7080: 29711613163.67795,
                           7090: 29548719605.76192,
                           7100: 29386940486.272297,
                           7110: 29226266671.396786,
                           7120: 29066689114.51084,
                           7130: 28908198855.22821,
                           7140: 28750787018.46278,
                           7150: 28594444813.502445,
                           7160: 28439163533.09366,
                           7170: 28284934552.537594,
                           7180: 28131749328.7971,
                           7190: 27979599399.614426,
                           7200: 27828476382.639885,
                           7210: 27678371974.570942,
                           7220: 27529277950.30161,
                           7230: 27381186162.08239,
                           7240: 27234088538.690113,
                           7250: 27087977084.607895,
                           7260: 26942843879.21491,
                           7270: 26798681075.985966,
                           7280: 26655480901.700672,
                           7290: 26513235655.662018,
                           7300: 26371937708.924374,
                           7310: 26231579503.530697,
                           7320: 26092153551.75889,
                           7330: 25953652435.377098,
                           7340: 25816068804.907818,
                           7350: 25679395378.900967,
                           7360: 25543624943.215275,
                           7370: 25408750350.30847,
                           7380: 25274764518.535774,
                           7390: 25141660431.456726,
                           7400: 25009431137.149998,
                           7410: 24878069747.53667,
                           7420: 24747569437.71121,
                           7430: 24617923445.280235,
                           7440: 24489125069.7095,
                           7450: 24361167671.67796,
                           7460: 24234044672.439888,
                           7470: 24107749553.194126,
                           7480: 23982275854.461,
                           7490: 23857617175.46624,
                           7500: 23733767173.532284,
                           7510: 23610719563.47659,
                           7520: 23488468117.016907,
                           7530: 23367006662.18357,
                           7540: 23246329082.7385,
                           7550: 23126429317.600983,
                           7560: 23007301360.28012,
                           7570: 22888939258.313824,
                           7580: 22771337112.714214,
                           7590: 22654489077.41954,
                           7600: 22538389358.752304,
                           7610: 22423032214.883675,
                           7620: 22308411955.304028,
                           7630: 22194522940.2996,
                           7640: 22081359580.43497,
                           7650: 21968916336.041786,
                           7660: 21857187716.713047,
                           7670: 21746168280.8032,
                           7680: 21635852634.93409,
                           7690: 21526235433.50629,
                           7700: 21417311378.216312,
                           7710: 21309075217.57897,
                           7720: 21201521746.455357,
                           7730: 21094645805.586094,
                           7740: 20988442281.12989,
                           7750: 20882906104.207302,
                           7760: 20778032250.449673,
                           7770: 20673815739.55308,
                           7780: 20570251634.837376,
                           7790: 20467335042.810116,
                           7800: 20365061112.735504,
                           7810: 20263425036.20804,
                           7820: 20162422046.730995,
                           7830: 20062047419.299587,
                           7840: 19962296469.988922,
                           7850: 19863164555.546326,
                           7860: 19764647072.988323,
                           7870: 19666739459.202232,
                           7880: 19569437190.551983,
                           7890: 19472735782.48838,
                           7900: 19376630789.163788,
                           7910: 19281117803.050877,
                           7920: 19186192454.565823,
                           7930: 19091850411.695503,
                           7940: 18998087379.628876,
                           7950: 18904899100.392338,
                           7960: 18812281352.48934,
                           7970: 18720229950.543545,
                           7980: 18628740744.946396,
                           7990: 18537809621.5081,
                           8000: 18447432501.112743,
                           8010: 18357605339.377098,
                           8020: 18268324126.313057,
                           8030: 18179584885.99385,
                           8040: 18091383676.22392,
                           8050: 18003716588.212345,
                           8060: 17916579746.24975,
                           8070: 17829969307.38889,
                           8080: 17743881461.12859,
                           8090: 17658312429.10105,
                           8100: 17573258464.762707,
                           8110: 17488715853.0883,
                           8120: 17404680910.268272,
                           8130: 17321149983.40948,
                           8140: 17238119450.23906,
                           8150: 17155585718.811554,
                           8160: 17073545227.219053,
                           8170: 16991994443.30466,
                           8180: 16910929864.378817,
                           8190: 16830348016.93881,
                           8200: 16750245456.391201,
                           8210: 16670618766.777195,
                           8220: 16591464560.501118,
                           8230: 16512779478.061533,
                           8240: 16434560187.785395,
                           8250: 16356803385.564962,
                           8260: 16279505794.597582,
                           8270: 16202664165.128078,
                           8280: 16126275274.19406,
                           8290: 16050335925.373766,
                           8300: 15974842948.536646,
                           8310: 15899793199.596611,
                           8320: 15825183560.26782,
                           8330: 15751010937.823036,
                           8340: 15677272264.854568,
                           8350: 15603964499.037746,
                           8360: 15531084622.896753,
                           8370: 15458629643.573105,
                           8380: 15386596592.59637,
                           8390: 15314982525.6574,
                           8400: 15243784522.38387,
                           8410: 15172999686.118196,
                           8420: 15102625143.697817,
                           8430: 15032658045.23761,
                           8440: 14963095563.914705,
                           8450: 14893934895.75551,
                           8460: 14825173259.424944,
                           8470: 14756807896.017735,
                           8480: 14688836068.85216,
                           8490: 14621255063.265524,
                           8500: 14554062186.412191,
                           8510: 14487254767.0633,
                           8520: 14420830155.408792,
                           8530: 14354785722.861418,
                           8540: 14289118861.862743,
                           8550: 14223826985.691109,
                           8560: 14158907528.271605,
                           8570: 14094357943.988037,
                           8580: 14030175707.496717,
                           8590: 13966358313.542238,
                           8600: 13902903276.775108,
                           8610: 13839808131.571161,
                           8620: 13777070431.853003,
                           8630: 13714687750.913061,
                           8640: 13652657681.238537,
                           8650: 13590977834.33819,
                           8660: 13529645840.570711,
                           8670: 13468659348.975029,
                           8680: 13408016027.102205,
                           8690: 13347713560.849035,
                           8700: 13287749654.293436,
                           8710: 13228122029.531298,
                           8720: 13168828426.515247,
                           8730: 13109866602.894787,
                           8740: 13051234333.85812,
                           8750: 12992929411.975653,
                           8760: 12934949647.044966,
                           8770: 12877292865.937378,
                           8780: 12819956912.445997,
                           8790: 12762939647.135406,
                           8800: 12706238947.192673,
                           8810: 12649852706.280018,
                           8820: 12593778834.388918,
                           8830: 12538015257.69549,
                           8840: 12482559918.41755,
                           8850: 12427410774.672941,
                           8860: 12372565800.33935,
                           8870: 12318022984.915451,
                           8880: 12263780333.383392,
                           8890: 12209835866.07285,
                           8900: 12156187618.526093,
                           8910: 12102833641.364647,
                           8920: 12049772000.157225,
                           8930: 11997000775.288795,
                           8940: 11944518061.831198,
                           8950: 11892321969.41474,
                           8960: 11840410622.101385,
                           8970: 11788782158.2588,
                           8980: 11737434730.436007,
                           8990: 11686366505.23998,
                           9000: 11635575663.2136,
                           9010: 11585060398.714722,
                           9020: 11534818919.79645,
                           9030: 11484849448.088625,
                           9040: 11435150218.680346,
                           9050: 11385719480.003714,
                           9060: 11336555493.718771,
                           9070: 11287656534.599398,
                           9080: 11239020890.420399,
                           9090: 11190646861.845716,
                           9100: 11142532762.3177,
                           9110: 11094676917.947361,
                           9120: 11047077667.405796,
                           9130: 10999733361.816639,
                           9140: 10952642364.649479,
                           9150: 10905803051.614378,
                           9160: 10859213810.557348,
                           9170: 10812873041.356901,
                           9180: 10766779155.821487,
                           9190: 10720930577.587982,
                           9200: 10675325742.02119,
                           9210: 10629963096.114187,
                           9220: 10584841098.389677,
                           9230: 10539958218.802353,
                           9240: 10495312938.64207,
                           9250: 10450903750.437992,
                           9260: 10406729157.863697,
                           9270: 10362787675.643093,
                           9280: 10319077829.457287,
                           9290: 10275598155.852293,
                           9300: 10232347202.14772,
                           9310: 10189323526.346127,
                           9320: 10146525697.04345,
                           9330: 10103952293.34011,
                           9340: 10061601904.753029,
                           9350: 10019473131.128521,
                           9360: 9977564582.55587,
                           9370: 9935874879.281858,
                           9380: 9894402651.625984,
                           9390: 9853146539.896572,
                           9400: 9812105194.307623,
                           9410: 9771277274.89636,
                           9420: 9730661451.441746,
                           9430: 9690256403.383556,
                           9440: 9650060819.74234,
                           9450: 9610073399.040012,
                           9460: 9570292849.22134,
                           9470: 9530717887.576004,
                           9480: 9491347240.661469,
                           9490: 9452179644.226547,
                           9500: 9413213843.13568,
                           9510: 9374448591.293936,
                           9520: 9335882651.572598,
                           9530: 9297514795.735619,
                           9540: 9259343804.366602,
                           9550: 9221368466.796509,
                           9560: 9183587581.032074,
                           9570: 9145999953.684753,
                           9580: 9108604399.900526,
                           9590: 9071399743.290134,
                           9600: 9034384815.86008,
                           9610: 8997558457.944248,
                           9620: 8960919518.1361,
                           9630: 8924466853.221563,
                           9640: 8888199328.112442,
                           9650: 8852115815.780539,
                           9660: 8816215197.192287,
                           9670: 8780496361.24405,
                           9680: 8744958204.69791,
                           9690: 8709599632.118196,
                           9700: 8674419555.80844,
                           9710: 8639416895.74897,
                           9720: 8604590579.535065,
                           9730: 8569939542.315671,
                           9740: 8535462726.73267,
                           9750: 8501159082.860693,
                           9760: 8467027568.14744,
                           9770: 8433067147.354659,
                           9780: 8399276792.499475,
                           9790: 8365655482.796425,
                           9800: 8332202204.599885,
                           9810: 8298915951.34708,
                           9820: 8265795723.501609,
                           9830: 8232840528.497407,
                           9840: 8200049380.683303,
                           9850: 8167421301.268013,
                           9860: 8134955318.265625,
                           9870: 8102650466.441625,
                           9880: 8070505787.259317,
                           9890: 8038520328.826787,
                           9900: 8006693145.844355,
                           9910: 7975023299.552416,
                           9920: 7943509857.679765,
                           9930: 7912151894.392502,
                           9940: 7880948490.243193,
                           9950: 7849898732.120626,
                           9960: 7819001713.199952,
                           9970: 7788256532.893295,
                           9980: 7757662296.800775,
                           9990: 7727218116.661949},
                   100000: {10: 6.720533457335034e+17,
                            20: 2.7979621481364677e+19,
                            30: 4.083978992573899e+19,
                            40: 3.2776724989567082e+19,
                            50: 2.272615403742201e+19,
                            60: 1.5315825322295218e+19,
                            70: 1.040628145349351e+19,
                            80: 7.211286228465257e+18,
                            90: 5.111222641831686e+18,
                            100: 3.704030748417258e+18,
                            110: 2.740383931987234e+18,
                            120: 2.0660720912466268e+18,
                            130: 1.584490885619313e+18,
                            140: 1.2339971496690775e+18,
                            150: 9.744563170048759e+17,
                            160: 7.792069545640137e+17,
                            170: 6.301926169962641e+17,
                            180: 5.1496012656650214e+17,
                            190: 4.247737408047928e+17,
                            200: 3.534080649935274e+17,
                            210: 2.9636134248635565e+17,
                            220: 2.503338310589244e+17,
                            230: 2.1287628218779434e+17,
                            240: 1.821494097302733e+17,
                            250: 1.5675693221699494e+17,
                            260: 1.3562812021084822e+17,
                            270: 1.1793412580491608e+17,
                            280: 1.0302767213864386e+17,
                            290: 9.039909850822427e+16,
                            300: 7.964399183294891e+16,
                            310: 7.043911695362089e+16,
                            320: 6.25243531354373e+16,
                            330: 5.568902032242542e+16,
                            340: 4.976144355735604e+16,
                            350: 4.460092707142427e+16,
                            360: 4.00915364292756e+16,
                            370: 3.6137248002304344e+16,
                            380: 3.2658140196891404e+16,
                            390: 2.9587384014924532e+16,
                            400: 2.686885107156579e+16,
                            410: 2.445520163751016e+16,
                            420: 2.230634814296036e+16,
                            430: 2.0388214068525904e+16,
                            440: 1.8671726518439e+16,
                            450: 1.7131994643717318e+16,
                            460: 1.574763662497767e+16,
                            470: 1.4500225984583874e+16,
                            480: 1.3373834195920252e+16,
                            490: 1.2354651350472198e+16,
                            500: 1.1430670369461234e+16,
                            510: 1.059142315834511e+16,
                            520: 9827759388813678.0,
                            530: 9131660396763682.0,
                            540: 8496082114420417.0,
                            550: 7914822092877555.0,
                            560: 7382406581145943.0,
                            570: 6893994358093094.0,
                            580: 6445294602146905.0,
                            590: 6032496559662725.0,
                            600: 5652209159316912.0,
                            610: 5301409034754149.0,
                            620: 4977395675123871.0,
                            630: 4677752634274929.0,
                            640: 4400313903110882.5,
                            650: 4143134693010487.5,
                            660: 3904465996940131.0,
                            670: 3682732393461646.0,
                            680: 3476512640919664.0,
                            690: 3284522677625720.0,
                            700: 3105600701229979.0,
                            710: 2938694048627229.5,
                            720: 2782847638263987.5,
                            730: 2637193770892434.5,
                            740: 2500943113715000.0,
                            750: 2373376717353228.5,
                            760: 2253838935875230.5,
                            770: 2141731137821631.8,
                            780: 2036506111273549.2,
                            790: 1937663078916378.8,
                            800: 1844743250111274.8,
                            810: 1757325846476270.0,
                            820: 1675024545639120.2,
                            830: 1597484294853663.5,
                            840: 1524378452238386.0,
                            850: 1455406218641218.8,
                            860: 1390290327677511.0,
                            870: 1328774965429343.0,
                            880: 1270623894719267.0,
                            890: 1215618761852609.8,
                            900: 1163557566321359.8,
                            910: 1114253276231770.0,
                            920: 1067532574202120.0,
                            930: 1023234720214772.0,
                            940: 981210519430761.8,
                            950: 941321384313568.0,
                            960: 903438481586008.4,
                            970: 867441955580844.0,
                            980: 833220220459988.2,
                            990: 800669314584435.4,
                            1000: 769692311030775.9,
                            1010: 740198778881981.9,
                            1020: 712104290480120.0,
                            1030: 685329970325567.5,
                            1040: 659802081748788.8,
                            1050: 635451647873388.2,
                            1060: 612214103738813.9,
                            1070: 590028976762757.0,
                            1080: 568839593001498.6,
                            1090: 548592806914899.4,
                            1100: 529238752565001.9,
                            1110: 510730614376136.9,
                            1120: 493024415762727.2,
                            1130: 476078824090895.8,
                            1140: 459854970583575.4,
                            1150: 444316283907891.4,
                            1160: 429428336299651.75,
                            1170: 415158701184368.7,
                            1180: 401476821348389.25,
                            1190: 388353886798751.5,
                            1200: 375762721527081.2,
                            1210: 363677678462192.9,
                            1220: 352074541958742.0,
                            1230: 340930437226079.06,
                            1240: 330223746152805.8,
                            1250: 319934029029206.8,
                            1260: 310041951711991.7,
                            1270: 300529217814191.6,
                            1280: 291378505537970.2,
                            1290: 282573408799824.44,
                            1300: 274098382326560.88,
                            1310: 265938690426721.7,
                            1320: 258080359166133.2,
                            1330: 250510131698096.6,
                            1340: 243215426518730.47,
                            1350: 236184298436177.28,
                            1360: 229405402059077.03,
                            1370: 222867957624927.03,
                            1380: 216561719002912.5,
                            1390: 210476943718557.1,
                            1400: 204604364859244.2,
                            1410: 198935164730401.06,
                            1420: 193460950141977.8,
                            1430: 188173729213894.6,
                            1440: 183065889597436.75,
                            1450: 178130178017210.9,
                            1460: 173359681045295.22,
                            1470: 168747807025676.25,
                            1480: 164288269073016.06,
                            1490: 159975069075272.47,
                            1500: 155802482634747.94,
                            1510: 151765044886801.0,
                            1520: 147857537139758.44,
                            1530: 144074974283528.03,
                            1540: 140412592918088.47,
                            1550: 136865840156417.64,
                            1560: 133430363059556.66,
                            1570: 130101998664404.38,
                            1580: 126876764567530.33,
                            1590: 123750850030769.61,
                            1600: 120720607576671.38,
                            1610: 117782545044016.28,
                            1620: 114933318075582.83,
                            1630: 112169723012197.19,
                            1640: 109488690168793.06,
                            1650: 106887277469808.92,
                            1660: 104362664422702.34,
                            1670: 101912146409750.47,
                            1680: 99533129279563.86,
                            1690: 97223124220933.39,
                            1700: 94979742902728.84,
                            1710: 92800692864593.98,
                            1720: 90683773144147.03,
                            1730: 88626870127270.14,
                            1740: 86627953608926.11,
                            1750: 84685073052690.23,
                            1760: 82796354037932.22,
                            1770: 80959994884238.3,
                            1780: 79174263443309.66,
                            1790: 77437494049154.66,
                            1800: 75748084617939.89,
                            1810: 74104493889393.7,
                            1820: 72505238802116.19,
                            1830: 70948891995623.9,
                            1840: 69434079432356.836,
                            1850: 67959478133286.89,
                            1860: 66523814021128.82,
                            1870: 65125859865499.75,
                            1880: 63764433324704.57,
                            1890: 62438395079123.03,
                            1900: 61146647051463.836,
                            1910: 59888130709415.18,
                            1920: 58661825446477.81,
                            1930: 57466747036997.016,
                            1940: 56301946161637.92,
                            1950: 55166506999750.34,
                            1960: 54059545885271.13,
                            1970: 52980210022992.75,
                            1980: 51927676262200.33,
                            1990: 50901149924842.62,
                            2000: 49899863685557.49,
                            2010: 48923076501013.27,
                            2020: 47970072586164.4,
                            2030: 47040160435151.29,
                            2040: 46132671884688.97,
                            2050: 45246961217906.875,
                            2060: 44382404306707.77,
                            2070: 43538397790815.5,
                            2080: 42714358291774.96,
                            2090: 41909721660259.71,
                            2100: 41123942255126.19,
                            2110: 40356492252733.0,
                            2120: 39606860985121.36,
                            2130: 38874554305721.61,
                            2140: 38159093981321.34,
                            2150: 37460017109090.555,
                            2160: 36776875557523.88,
                            2170: 36109235430212.58,
                            2180: 35456676551417.14,
                            2190: 34818791972458.625,
                            2200: 34195187497997.305,
                            2210: 33585481231312.96,
                            2220: 32989303137742.4,
                            2230: 32406294625474.33,
                            2240: 31836108142934.953,
                            2250: 31278406792042.125,
                            2260: 30732863956631.582,
                            2270: 30199162945401.258,
                            2280: 29676996648742.605,
                            2290: 29166067208863.465,
                            2300: 28666085702632.336,
                            2310: 28176771836601.03,
                            2320: 27697853653688.77,
                            2330: 27229067251034.42,
                            2340: 26770156508545.562,
                            2350: 26320872827696.99,
                            2360: 25880974880149.78,
                            2370: 25450228365781.53,
                            2380: 25028405779740.074,
                            2390: 24615286188146.207,
                            2400: 24210655012091.14,
                            2410: 23814303819589.008,
                            2420: 23426030125160.527,
                            2430: 23045637196737.867,
                            2440: 22672933869594.043,
                            2450: 22307734367015.95,
                            2460: 21949858127448.184,
                            2470: 21599129637851.45,
                            2480: 21255378273026.402,
                            2490: 20918438140668.32,
                            2500: 20588147931925.156,
                            2510: 20264350777242.86,
                            2520: 19946894107291.586,
                            2530: 19635629518773.785,
                            2540: 19330412644925.246,
                            2550: 19031103030526.664,
                            2560: 18737564011252.418,
                            2570: 18449662597189.71,
                            2580: 18167269360369.184,
                            2590: 17890258326152.516,
                            2600: 17618506868332.695,
                            2610: 17351895607804.467,
                            2620: 17090308314672.201,
                            2630: 16833631813664.863,
                            2640: 16581755892734.918,
                            2650: 16334573214722.49,
                            2660: 16091979231971.291,
                            2670: 15853872103786.336,
                            2680: 15620152616629.219,
                            2690: 15390724106951.248,
                            2700: 15165492386565.893,
                            2710: 14944365670470.373,
                            2720: 14727254507025.562,
                            2730: 14514071710409.873,
                            2740: 14304732295265.197,
                            2750: 14099153413455.176,
                            2760: 13897254292861.674,
                            2770: 13698956178145.164,
                            2780: 13504182273400.635,
                            2790: 13312857686640.943,
                            2800: 13124909376043.531,
                            2810: 12940266097898.629,
                            2820: 12758858356198.434,
                            2830: 12580618353811.584,
                            2840: 12405479945186.123,
                            2850: 12233378590528.803,
                            2860: 12064251311409.777,
                            2870: 11898036647743.01,
                            2880: 11734674616095.803,
                            2890: 11574106669281.633,
                            2900: 11416275657192.44,
                            2910: 11261125788828.965,
                            2920: 11108602595487.502,
                            2930: 10958652895064.96,
                            2940: 10811224757444.13,
                            2950: 10666267470923.256,
                            2960: 10523731509654.516,
                            2970: 10383568502058.824,
                            2980: 10245731200183.078,
                            2990: 10110173449970.383,
                            3000: 9976850162411.592,
                            3010: 9845717285550.182,
                            3020: 9716731777312.424,
                            3030: 9589851579135.504,
                            3040: 9465035590367.828,
                            3050: 9342243643416.566,
                            3060: 9221436479618.447,
                            3070: 9102575725809.777,
                            3080: 8985623871574.324,
                            3090: 8870544247146.123,
                            3100: 8757301001947.444,
                            3110: 8645859083741.105,
                            3120: 8536184218377.412,
                            3130: 8428242890117.87,
                            3140: 8322002322516.358,
                            3150: 8217430459841.124,
                            3160: 8114495949020.258,
                            3170: 8013168122094.225,
                            3180: 7913416979160.213,
                            3190: 7815213171792.158,
                            3200: 7718527986922.828,
                            3210: 7623333331172.584,
                            3220: 7529601715611.872,
                            3230: 7437306240944.204,
                            3240: 7346420583095.995,
                            3250: 7256918979201.635,
                            3260: 7168776213971.685,
                            3270: 7081967606432.086,
                            3280: 6996468997023.913,
                            3290: 6912256735052.179,
                            3300: 6829307666473.743,
                            3310: 6747599122013.704,
                            3320: 6667108905600.847,
                            3330: 6587815283112.551,
                            3340: 6509696971420.013,
                            3350: 6432733127724.624,
                            3360: 6356903339177.323,
                            3370: 6282187612772.545,
                            3380: 6208566365508.522,
                            3390: 6136020414806.071,
                            3400: 6064530969178.892,
                            3410: 5994079619147.409,
                            3420: 5924648328389.605,
                            3430: 5856219425121.641,
                            3440: 5788775593701.883,
                            3450: 5722299866451.836,
                            3460: 5656775615687.903,
                            3470: 5592186545957.515,
                            3480: 5528516686474.6,
                            3490: 5465750383747.83,
                            3500: 5403872294396.85,
                            3510: 5342867378151.033,
                            3520: 5282720891025.347,
                            3530: 5223418378668.7705,
                            3540: 5164945669880.062,
                            3550: 5107288870286.551,
                            3560: 5050434356181.091,
                            3570: 4994368768513.053,
                            3580: 4939079007028.921,
                            3590: 4884552224558.389,
                            3600: 4830775821442.151,
                            3610: 4777737440097.174,
                            3620: 4725424959715.823,
                            3630: 4673826491095.404,
                            3640: 4622930371594.204,
                            3650: 4572725160210.85,
                            3660: 4523199632783.568,
                            3670: 4474342777306.069,
                            3680: 4426143789356.993,
                            3690: 4378592067639.844,
                            3700: 4331677209630.37,
                            3710: 4285389007328.7114,
                            3720: 4239717443113.232,
                            3730: 4194652685693.6626,
                            3740: 4150185086160.71,
                            3750: 4106305174129.5537,
                            3760: 4063003653974.9863,
                            3770: 4020271401155.536,
                            3780: 3978099458624.3306,
                            3790: 3936479033324.572,
                            3800: 3895401492767.151,
                            3810: 3854858361688.4595,
                            3820: 3814841318786.201,
                            3830: 3775342193531.4487,
                            3840: 3736352963054.4507,
                            3850: 3697865749102.877,
                            3860: 3659872815070.265,
                            3870: 3622366563092.978,
                            3880: 3585339531213.988,
                            3890: 3548784390611.584,
                            3900: 3512693942891.6807,
                            3910: 3477061117441.8,
                            3920: 3441878968845.237,
                            3930: 3407140674354.132,
                            3940: 3372839531419.5615,
                            3950: 3338968955277.616,
                            3960: 3305522476589.7456,
                            3970: 3272493739136.2847,
                            3980: 3239876497561.516,
                            3990: 3207664615169.3525,
                            4000: 3175852061768.1367,
                            4010: 3144432911563.3823,
                            4020: 3113401341097.3237,
                            4030: 3082751627234.14,
                            4040: 3052478145189.6333,
                            4050: 3022575366604.3955,
                            4060: 2993037857659.274,
                            4070: 2963860277232.212,
                            4080: 2935037375095.441,
                            4090: 2906563990151.9077,
                            4100: 2878435048710.3115,
                            4110: 2850645562797.3438,
                            4120: 2823190628506.731,
                            4130: 2796065424383.832,
                            4140: 2769265209845.0864,
                            4150: 2742785323631.6016,
                            4160: 2716621182295.6343,
                            4170: 2690768278719.8604,
                            4180: 2665222180667.923,
                            4190: 2639978529366.109,
                            4200: 2615033038115.0566,
                            4210: 2590381490930.9155,
                            4220: 2566019741215.376,
                            4230: 2541943710453.551,
                            4240: 2518149386939.538,
                            4250: 2494632824528.5605,
                            4260: 2471390141415.3613,
                            4270: 2448417518938.112,
                            4280: 2425711200407.3086,
                            4290: 2403267489959.015,
                            4300: 2381082751431.933,
                            4310: 2359153407267.791,
                            4320: 2337475937434.326,
                            4330: 2316046878370.6616,
                            4340: 2294862821954.2275,
                            4350: 2273920414489.0327,
                            4360: 2253216355714.545,
                            4370: 2232747397834.919,
                            4380: 2212510344567.9033,
                            4390: 2192502050213.256,
                            4400: 2172719418739.9429,
                            4410: 2153159402891.9114,
                            4420: 2133819003311.844,
                            4430: 2114695267682.6648,
                            4440: 2095785289886.2876,
                            4450: 2077086209179.235,
                            4460: 2058595209384.8245,
                            4470: 2040309518101.3577,
                            4480: 2022226405926.3276,
                            4490: 2004343185695.8508,
                            4500: 1986657211739.3193,
                            4510: 1969165879148.7268,
                            4520: 1951866623062.5771,
                            4530: 1934756917963.72,
                            4540: 1917834276991.2263,
                            4550: 1901096251265.58,
                            4560: 1884540429227.191,
                            4570: 1868164435987.8447,
                            4580: 1851965932694.7578,
                            4590: 1835942615907.078,
                            4600: 1820092216984.3958,
                            4610: 1804412501487.217,
                            4620: 1788901268588.9648,
                            4630: 1773556350499.3274,
                            4640: 1758375611898.7603,
                            4650: 1743356949383.8254,
                            4660: 1728498290923.143,
                            4670: 1713797595323.7644,
                            4680: 1699252851707.7896,
                            4690: 1684862078998.9255,
                            4700: 1670623325418.7034,
                            4710: 1656534667992.4539,
                            4720: 1642594212064.477,
                            4730: 1628800090822.4158,
                            4740: 1615150464830.6614,
                            4750: 1601643521572.4258,
                            4760: 1588277475000.4783,
                            4770: 1575050565096.3198,
                            4780: 1561961057437.55,
                            4790: 1549007242773.3542,
                            4800: 1536187436607.8267,
                            4810: 1523499978791.0947,
                            4820: 1510943233118.0398,
                            4830: 1498515586934.3794,
                            4840: 1486215450750.0588,
                            4850: 1474041257859.7844,
                            4860: 1461991463970.5208,
                            4870: 1450064546835.818,
                            4880: 1438259005896.8042,
                            4890: 1426573361929.8752,
                            4900: 1415006156700.591,
                            4910: 1403555952624.12,
                            4920: 1392221332431.6282,
                            4930: 1381000898842.9036,
                            4940: 1369893274244.7585,
                            4950: 1358897100375.3354,
                            4960: 1348011038014.0776,
                            4970: 1337233766677.2407,
                            4980: 1326563984318.9182,
                            4990: 1316000407037.4077,
                            5000: 1305541768786.8237,
                            5010: 1295186821093.8413,
                            5020: 1284934332779.5127,
                            5030: 1274783089686.0234,
                            5040: 1264731894408.2798,
                            5050: 1254779566030.2651,
                            5060: 1244924939866.0376,
                            5070: 1235166867205.3184,
                            5080: 1225504215063.5234,
                            5090: 1215935865936.2363,
                            5100: 1206460717557.9375,
                            5110: 1197077682664.9712,
                            5120: 1187785688762.6826,
                            5130: 1178583677896.5596,
                            5140: 1169470606427.4023,
                            5150: 1160445444810.3457,
                            5160: 1151507177377.803,
                            5170: 1142654802126.0366,
                            5180: 1133887330505.5403,
                            5190: 1125203787214.9268,
                            5200: 1116603209998.4285,
                            5210: 1108084649446.874,
                            5220: 1099647168802.0037,
                            5230: 1091289843764.2206,
                            5240: 1083011762303.579,
                            5250: 1074812024473.9686,
                            5260: 1066689742230.5233,
                            5270: 1058644039250.0552,
                            5280: 1050674050754.5945,
                            5290: 1042778923337.876,
                            5300: 1034957814794.7434,
                            5310: 1027209893953.4867,
                            5320: 1019534340510.9113,
                            5330: 1011930344870.2466,
                            5340: 1004397107981.7587,
                            5350: 996933841185.9521,
                            5360: 989539766059.5345,
                            5370: 982214114263.7867,
                            5380: 974956127395.575,
                            5390: 967765056840.756,
                            5400: 960640163630.0729,
                            5410: 953580718297.3866,
                            5420: 946586000740.2712,
                            5430: 939655300082.8903,
                            5440: 932787914541.1432,
                            5450: 925983151290.0299,
                            5460: 919240326333.1455,
                            5470: 912558764374.3798,
                            5480: 905937798691.6486,
                            5490: 899376771012.7009,
                            5500: 892875031392.9646,
                            5510: 886431938095.375,
                            5520: 880046857472.1008,
                            5530: 873719163848.262,
                            5540: 867448239407.4409,
                            5550: 861233474079.1243,
                            5560: 855074265427.8904,
                            5570: 848970018544.4082,
                            5580: 842920145938.1696,
                            5590: 836924067431.954,
                            5600: 830981210057.952,
                            5610: 825091007955.593,
                            5620: 819252902270.9447,
                            5630: 813466341057.7325,
                            5640: 807730779179.9758,
                            5650: 802045678216.0625,
                            5660: 796410506364.4414,
                            5670: 790824738350.7673,
                            5680: 785287855336.4622,
                            5690: 779799344828.8077,
                            5700: 774358700592.3535,
                            5710: 768965422561.7872,
                            5720: 763619016756.1196,
                            5730: 758318995194.2344,
                            5740: 753064875811.764,
                            5750: 747856182379.211,
                            5760: 742692444421.3945,
                            5770: 737573197138.1218,
                            5780: 732497981326.091,
                            5790: 727466343302.0002,
                            5800: 722477834826.8354,
                            5810: 717532013031.3585,
                            5820: 712628440342.6857,
                            5830: 707766684412.0294,
                            5840: 702946318043.5629,
                            5850: 698166919124.3114,
                            5860: 693428070555.2046,
                            5870: 688729360183.0715,
                            5880: 684070380733.7692,
                            5890: 679450729746.27,
                            5900: 674870009507.7806,
                            5910: 670327826989.8018,
                            5920: 665823793785.191,
                            5930: 661357526046.1763,
                            5940: 656928644423.2832,
                            5950: 652536774005.1923,
                            5960: 648181544259.4916,
                            5970: 643862588974.3179,
                            5980: 639579546200.9083,
                            5990: 635332058196.9293,
                            6000: 631119771370.7435,
                            6010: 626942336226.4349,
                            6020: 622799407309.6986,
                            6030: 618690643154.5012,
                            6040: 614615706230.5465,
                            6050: 610574262891.5386,
                            6060: 606565983324.141,
                            6070: 602590541497.7957,
                            6080: 598647615115.1677,
                            6090: 594736885563.4014,
                            6100: 590858037866.044,
                            6110: 587010760635.7108,
                            6120: 583194746027.3989,
                            6130: 579409689692.5298,
                            6140: 575655290733.617,
                            6150: 571931251659.6249,
                            6160: 568237278341.9816,
                            6170: 564573079971.1831,
                            6180: 560938369014.0831,
                            6190: 557332861171.7708,
                            6200: 553756275338.054,
                            6210: 550208333558.5454,
                            6220: 546688760990.3618,
                            6230: 543197285862.357,
                            6240: 539733639435.9557,
                            6250: 536297555966.5574,
                            6260: 532888772665.4519,
                            6270: 529507029662.3223,
                            6280: 526152069968.2529,
                            6290: 522823639439.28125,
                            6300: 519521486740.4654,
                            6310: 516245363310.44006,
                            6320: 512995023326.50934,
                            6330: 509770223670.20184,
                            6340: 506570723893.34125,
                            6350: 503396286184.5643,
                            6360: 500246675336.33765,
                            6370: 497121658712.41846,
                            6380: 494021006215.7786,
                            6390: 490944490256.99445,
                            6400: 487891885723.04297,
                            6410: 484862969946.57153,
                            6420: 481857522675.56195,
                            6430: 478875326043.4556,
                            6440: 475916164539.653,
                            6450: 472979824980.45496,
                            6460: 470066096480.3805,
                            6470: 467174770423.9172,
                            6480: 464305640437.62,
                            6490: 461458502362.6176,
                            6500: 458633154227.5109,
                            6510: 455829396221.5979,
                            6520: 453047030668.5298,
                            6530: 450285862000.27374,
                            6540: 447545696731.4652,
                            6550: 444826343434.08154,
                            6560: 442127612712.5011,
                            6570: 439449317178.8654,
                            6580: 436791271428.80396,
                            6590: 434153292017.45044,
                            6600: 431535197435.8508,
                            6610: 428936808087.60815,
                            6620: 426357946265.91583,
                            6630: 423798436130.8546,
                            6640: 421258103687.01556,
                            6650: 418736776761.4342,
                            6660: 416234284981.78,
                            6670: 413750459754.8915,
                            6680: 411285134245.5637,
                            6690: 408838143355.6364,
                            6700: 406409323703.3438,
                            6710: 403998513602.96045,
                            6720: 401605553044.7176,
                            6730: 399230283674.9573,
                            6740: 396872548776.58734,
                            6750: 394532193249.7842,
                            6760: 392209063592.925,
                            6770: 389903007883.82153,
                            6780: 387613875761.1586,
                            6790: 385341518406.1911,
                            6800: 383085788524.6979,
                            6810: 380846540329.14355,
                            6820: 378623629521.1024,
                            6830: 376416913273.8995,
                            6840: 374226250215.4762,
                            6850: 372051500411.4744,
                            6860: 369892525348.58057,
                            6870: 367749187918.0248,
                            6880: 365621352399.3513,
                            6890: 363508884444.3532,
                            6900: 361411651061.2707,
                            6910: 359329520599.1225,
                            6920: 357262362732.31635,
                            6930: 355210048445.39813,
                            6940: 353172450018.02686,
                            6950: 351149441010.1443,
                            6960: 349140896247.32495,
                            6970: 347146691806.31134,
                            6980: 345166705000.75635,
                            6990: 343200814367.11786,
                            7000: 341248899650.76544,
                            7010: 339310841792.2291,
                            7020: 337386522913.6714,
                            7030: 335475826305.47784,
                            7040: 333578636413.05414,
                            7050: 331694838823.7851,
                            7060: 329824320254.15106,
                            7070: 327966968537.0019,
                            7080: 326122672609.0262,
                            7090: 324291322498.3288,
                            7100: 322472809312.1968,
                            7110: 320667025225.03033,
                            7120: 318873863466.38446,
                            7130: 317093218309.1982,
                            7140: 315324985058.1558,
                            7150: 313569060038.1924,
                            7160: 311825340583.15875,
                            7170: 310093725024.5951,
                            7180: 308374112680.6923,
                            7190: 306666403845.3396,
                            7200: 304970499777.3486,
                            7210: 303286302689.7962,
                            7220: 301613715739.4846,
                            7230: 299952643016.5628,
                            7240: 298302989534.2591,
                            7250: 296664661218.72864,
                            7260: 295037564899.0507,
                            7270: 293421608297.34174,
                            7280: 291816700018.96686,
                            7290: 290222749542.918,
                            7300: 288639667212.26135,
                            7310: 287067364224.7356,
                            7320: 285505752623.44244,
                            7330: 283954745287.6827,
                            7340: 282414255923.85535,
                            7350: 280884199056.5177,
                            7360: 279364490019.5244,
                            7370: 277855044947.282,
                            7380: 276355780766.10547,
                            7390: 274866615185.69815,
                            7400: 273387466690.70044,
                            7410: 271918254532.3774,
                            7420: 270458898720.3794,
                            7430: 269009320014.62488,
                            7440: 267569439917.24957,
                            7450: 266139180664.69467,
                            7460: 264718465219.847,
                            7470: 263307217264.30743,
                            7480: 261905361190.7294,
                            7490: 260512822095.26166,
                            7500: 259129525770.08292,
                            7510: 257755398696.0056,
                            7520: 256390368035.1925,
                            7530: 255034361623.95328,
                            7540: 253687307965.61102,
                            7550: 252349136223.47998,
                            7560: 251019776213.8915,
                            7570: 249699158399.35022,
                            7580: 248387213881.72025,
                            7590: 247083874395.52728,
                            7600: 245789072301.32632,
                            7610: 244502740579.14874,
                            7620: 243224812822.02438,
                            7630: 241955223229.58606,
                            7640: 240693906601.74142,
                            7650: 239440798332.42697,
                            7660: 238195834403.4291,
                            7670: 236958951378.27228,
                            7680: 235730086396.19742,
                            7690: 234509177166.19373,
                            7700: 233296161961.1019,
                            7710: 232090979611.7826,
                            7720: 230893569501.37674,
                            7730: 229703871559.602,
                            7740: 228521826257.12262,
                            7750: 227347374600.00058,
                            7760: 226180458124.19342,
                            7770: 225021018890.12674,
                            7780: 223868999477.31653,
                            7790: 222724342979.06512,
                            7800: 221586992997.21606,
                            7810: 220456893636.95645,
                            7820: 219333989501.71194,
                            7830: 218218225688.0498,
                            7840: 217109547780.69006,
                            7850: 216007901847.53516,
                            7860: 214913234434.79037,
                            7870: 213825492562.10608,
                            7880: 212744623717.79898,
                            7890: 211670575854.11844,
                            7900: 210603297382.57184,
                            7910: 209542737169.28885,
                            7920: 208488844530.46356,
                            7930: 207441569227.81665,
                            7940: 206400861464.14157,
                            7950: 205366671878.8714,
                            7960: 204338951543.7146,
                            7970: 203317651958.33194,
                            7980: 202302725046.0657,
                            7990: 201294123149.7173,
                            8000: 200291799027.36005,
                            8010: 199295705848.2254,
                            8020: 198305797188.6037,
                            8030: 197322027027.80865,
                            8040: 196344349744.19058,
                            8050: 195372720111.17834,
                            8060: 194407093293.38,
                            8070: 193447424842.72015,
                            8080: 192493670694.6186,
                            8090: 191545787164.21133,
                            8100: 190603730942.62173,
                            8110: 189667459093.26294,
                            8120: 188736929048.18762,
                            8130: 187812098604.4703,
                            8140: 186892925920.64014,
                            8150: 185979369513.14114,
                            8160: 185071388252.84418,
                            8170: 184168941361.58517,
                            8180: 183271988408.7541,
                            8190: 182380489307.89877,
                            8200: 181494404313.3974,
                            8210: 180613694017.14133,
                            8220: 179738319345.26804,
                            8230: 178868241554.91864,
                            8240: 178003422231.04453,
                            8250: 177143823283.2382,
                            8260: 176289406942.601,
                            8270: 175440135758.64536,
                            8280: 174595972596.2349,
                            8290: 173756880632.54147,
                            8300: 172922823354.06723,
                            8310: 172093764553.65625,
                            8320: 171269668327.57343,
                            8330: 170450499072.60632,
                            8340: 169636221483.17932,
                            8350: 168826800548.52283,
                            8360: 168022201549.8643,
                            8370: 167222390057.64215,
                            8380: 166427331928.76312,
                            8390: 165636993303.87607,
                            8400: 164851340604.67838,
                            8410: 164070340531.26053,
                            8420: 163293960059.46848,
                            8430: 162522166438.2921,
                            8440: 161754927187.2909,
                            8450: 160992210094.04422,
                            8460: 160233983211.62134,
                            8470: 159480214856.0846,
                            8480: 158730873604.0273,
                            8490: 157985928290.11172,
                            8500: 157245348004.6655,
                            8510: 156509102091.2758,
                            8520: 155777160144.429,
                            8530: 155049492007.1632,
                            8540: 154326067768.74677,
                            8550: 153606857762.38763,
                            8560: 152891832562.95673,
                            8570: 152180962984.7465,
                            8580: 151474220079.2475,
                            8590: 150771575132.94046,
                            8600: 150072999665.12354,
                            8610: 149378465425.76242,
                            8620: 148687944393.34555,
                            8630: 148001408772.78732,
                            8640: 147318830993.32755,
                            8650: 146640183706.47522,
                            8660: 145965439783.95337,
                            8670: 145294572315.68384,
                            8680: 144627554607.777,
                            8690: 143964360180.55255,
                            8700: 143304962766.57663,
                            8710: 142649336308.71796,
                            8720: 141997454958.2302,
                            8730: 141349293072.84338,
                            8740: 140704825214.88818,
                            8750: 140064026149.4255,
                            8760: 139426870842.40686,
                            8770: 138793334458.84476,
                            8780: 138163392361.0127,
                            8790: 137537020106.64758,
                            8800: 136914193447.18674,
                            8810: 136294888326.00885,
                            8820: 135679080876.70767,
                            8830: 135066747421.36826,
                            8840: 134457864468.87268,
                            8850: 133852408713.20985,
                            8860: 133250357031.82262,
                            8870: 132651686483.94688,
                            8880: 132056374308.98677,
                            8890: 131464397924.9023,
                            8900: 130875734926.5992,
                            8910: 130290363084.35802,
                            8920: 129708260342.25908,
                            8930: 129129404816.63588,
                            8940: 128553774794.53711,
                            8950: 127981348732.2061,
                            8960: 127412105253.57935,
                            8970: 126846023148.78752,
                            8980: 126283081372.69482,
                            8990: 125723259043.4215,
                            9000: 125166535440.91257,
                            9010: 124612890005.49837,
                            9020: 124062302336.47849,
                            9030: 123514752190.71965,
                            9040: 122970219481.26607,
                            9050: 122428684275.96385,
                            9060: 121890126796.09714,
                            9070: 121354527415.04561,
                            9080: 120821866656.94193,
                            9090: 120292125195.35277,
                            9100: 119765283851.97362,
                            9110: 119241323595.32681,
                            9120: 118720225539.47942,
                            9130: 118201970942.77684,
                            9140: 117686541206.57932,
                            9150: 117173917874.0208,
                            9160: 116664082628.77025,
                            9170: 116157017293.8149,
                            9180: 115652703830.24445,
                            9190: 115151124336.06007,
                            9200: 114652261044.98369,
                            9210: 114156096325.28572,
                            9220: 113662612678.61792,
                            9230: 113171792738.86693,
                            9240: 112683619271.01033,
                            9250: 112198075169.98598,
                            9260: 111715143459.5734,
                            9270: 111234807291.292,
                            9280: 110757049943.29445,
                            9290: 110281854819.28487,
                            9300: 109809205447.44461,
                            9310: 109339085479.36072,
                            9320: 108871478688.97704,
                            9330: 108406368971.54187,
                            9340: 107943740342.58112,
                            9350: 107483576936.86307,
                            9360: 107025863007.38988,
                            9370: 106570582924.38994,
                            9380: 106117721174.31984,
                            9390: 105667262358.88046,
                            9400: 105219191194.03667,
                            9410: 104773492509.05092,
                            9420: 104330151245.52489,
                            9430: 103889152456.44823,
                            9440: 103450481305.26021,
                            9450: 103014123064.9154,
                            9460: 102580063116.96161,
                            9470: 102148286950.6278,
                            9480: 101718780161.91519,
                            9490: 101291528452.70122,
                            9500: 100866517629.85365,
                            9510: 100443733604.34882,
                            9520: 100023162390.39653,
                            9530: 99604790104.58249,
                            9540: 99188602965.00826,
                            9550: 98774587290.44556,
                            9560: 98362729499.49551,
                            9570: 97953016109.76164,
                            9580: 97545433737.01784,
                            9590: 97139969094.39702,
                            9600: 96736608991.58784,
                            9610: 96335340334.02107,
                            9620: 95936150122.0858,
                            9630: 95539025450.34273,
                            9640: 95143953506.74208,
                            9650: 94750921571.85037,
                            9660: 94359917018.0927,
                            9670: 93970927308.99115,
                            9680: 93583939998.4117,
                            9690: 93198942729.8277,
                            9700: 92815923235.57817,
                            9710: 92434869336.13954,
                            9720: 92055768939.4044,
                            9730: 91678610039.96161,
                            9740: 91303380718.39102,
                            9750: 90930069140.55544,
                            9760: 90558663556.90857,
                            9770: 90189152301.80164,
                            9780: 89821523792.80247,
                            9790: 89455766530.0108,
                            9800: 89091869095.39842,
                            9810: 88729820152.13132,
                            9820: 88369608443.91963,
                            9830: 88011222794.3601,
                            9840: 87654652106.28867,
                            9850: 87299885361.14163,
                            9860: 86946911618.3162,
                            9870: 86595720014.5473,
                            9880: 86246299763.27325,
                            9890: 85898640154.02669,
                            9900: 85552730551.81941,
                            9910: 85208560396.53041,
                            9920: 84866119202.30956,
                            9930: 84525396556.98065,
                            9940: 84186382121.44562,
                            9950: 83849065629.10777,
                            9960: 83513436885.2786,
                            9970: 83179485766.61801,
                            9980: 82847202220.54973,
                            9990: 82516576264.70872}}

BLACKBODY_SPD_DATA = numpy.array([6.655174524134172851562500e+12,
                                  6.710506491757857421875000e+12,
                                  6.765731251574289062500000e+12,
                                  6.820844084496201171875000e+12,
                                  6.875840329458190429687500e+12,
                                  6.930715383740981445312500e+12,
                                  6.985464703269613281250000e+12,
                                  7.040083802885991210937500e+12,
                                  7.094568256596352539062500e+12,
                                  7.148913697794154296875000e+12,
                                  7.203115819458928710937500e+12,
                                  7.257170374331501953125000e+12,
                                  7.311073175066180664062500e+12,
                                  7.364820094360382812500000e+12,
                                  7.418407065062228515625000e+12,
                                  7.471830080256480468750000e+12,
                                  7.525085193329490234375000e+12,
                                  7.578168518013500000000000e+12,
                                  7.631076228410972656250000e+12,
                                  7.683804558999084960937500e+12,
                                  7.736349804615289062500000e+12,
                                  7.788708320424145507812500e+12,
                                  7.840876521865927734375000e+12,
                                  7.892850884587587890625000e+12,
                                  7.944627944356369140625000e+12,
                                  7.996204296956686523437500e+12,
                                  8.047576598070678710937500e+12,
                                  8.098741563142791015625000e+12,
                                  8.149695967228894531250000e+12,
                                  8.200436644830525390625000e+12,
                                  8.250960489714368164062500e+12,
                                  8.301264454717685546875000e+12,
                                  8.351345551539963867187500e+12,
                                  8.401200850521328125000000e+12,
                                  8.450827480407858398437500e+12,
                                  8.500222628104724609375000e+12,
                                  8.549383538416786132812500e+12,
                                  8.598307513777910156250000e+12,
                                  8.646991913968744140625000e+12,
                                  8.695434155823514648437500e+12,
                                  8.743631712926458984375000e+12,
                                  8.791582115297842773437500e+12,
                                  8.839282949070353515625000e+12,
                                  8.886731856155896484375000e+12,
                                  8.933926533903294921875000e+12,
                                  8.980864734747324218750000e+12,
                                  9.027544265849214843750000e+12,
                                  9.073962988729080078125000e+12,
                                  9.120118818890632812500000e+12,
                                  9.166009725438433593750000e+12,
                                  9.211633730688062500000000e+12,
                                  9.256988909769369140625000e+12,
                                  9.302073390223419921875000e+12,
                                  9.346885351593019531250000e+12,
                                  9.391423025007500000000000e+12,
                                  9.435684692761863281250000e+12,
                                  9.479668687890427734375000e+12,
                                  9.523373393735666015625000e+12,
                                  9.566797243512054687500000e+12,
                                  9.609938719865544921875000e+12,
                                  9.652796354428621093750000e+12,
                                  9.695368727371517578125000e+12,
                                  9.737654466949539062500000e+12,
                                  9.779652249046949218750000e+12,
                                  9.821360796717531250000000e+12,
                                  9.862778879722166015625000e+12,
                                  9.903905314063529296875000e+12,
                                  9.944738961518148437500000e+12,
                                  9.985278729166292968750000e+12,
                                  1.002552356891946093750000e+13,
                                  1.006547247704597070312500e+13,
                                  1.010512449369493164062500e+13,
                                  1.014447870241840820312500e+13,
                                  1.018353422969247265625000e+13,
                                  1.022229024443689453125000e+13,
                                  1.026074595753382421875000e+13,
                                  1.029890062134582031250000e+13,
                                  1.033675352923307812500000e+13,
                                  1.037430401507018750000000e+13,
                                  1.041155145276262304687500e+13,
                                  1.044849525576304296875000e+13,
                                  1.048513487658758789062500e+13,
                                  1.052146980633236914062500e+13,
                                  1.055749957419008984375000e+13,
                                  1.059322374696734960937500e+13,
                                  1.062864192860229101562500e+13,
                                  1.066375375968312109375000e+13,
                                  1.069855891696729296875000e+13,
                                  1.073305711290183984375000e+13,
                                  1.076724809514462109375000e+13,
                                  1.080113164608693164062500e+13,
                                  1.083470758237722656250000e+13,
                                  1.086797575444650781250000e+13,
                                  1.090093604603501171875000e+13,
                                  1.093358837372073828125000e+13,
                                  1.096593268644952148437500e+13,
                                  1.099796896506712695312500e+13,
                                  1.102969722185314648437500e+13,
                                  1.106111750005689648437500e+13,
                                  1.109222987343556054687500e+13,
                                  1.112303444579439453125000e+13,
                                  1.115353135052916015625000e+13,
                                  1.118372075017111914062500e+13,
                                  1.121360283593419921875000e+13,
                                  1.124317782726483984375000e+13,
                                  1.127244597139424218750000e+13,
                                  1.130140754289333203125000e+13,
                                  1.133006284323053710937500e+13,
                                  1.135841220033206054687500e+13,
                                  1.138645596814504882812500e+13,
                                  1.141419452620383593750000e+13,
                                  1.144162827919879296875000e+13,
                                  1.146875765654834179687500e+13,
                                  1.149558311197391015625000e+13,
                                  1.152210512307801171875000e+13,
                                  1.154832419092535156250000e+13,
                                  1.157424083962715039062500e+13,
                                  1.159985561592856250000000e+13,
                                  1.162516908879945898437500e+13,
                                  1.165018184902832812500000e+13,
                                  1.167489450881956250000000e+13,
                                  1.169930770139397851562500e+13,
                                  1.172342208059282031250000e+13,
                                  1.174723832048498242187500e+13,
                                  1.177075711497770312500000e+13,
                                  1.179397917743076171875000e+13,
                                  1.181690524027401757812500e+13,
                                  1.183953605462845703125000e+13,
                                  1.186187238993065429687500e+13,
                                  1.188391503356093164062500e+13,
                                  1.190566479047475781250000e+13,
                                  1.192712248283795117187500e+13,
                                  1.194828894966516406250000e+13,
                                  1.196916504646220507812500e+13,
                                  1.198975164487162890625000e+13,
                                  1.201004963232213281250000e+13,
                                  1.203005991168139843750000e+13,
                                  1.204978340091255078125000e+13,
                                  1.206922103273418750000000e+13,
                                  1.208837375428408789062500e+13,
                                  1.210724252678624414062500e+13,
                                  1.212582832522192382812500e+13,
                                  1.214413213800390625000000e+13,
                                  1.216215496665446875000000e+13,
                                  1.217989782548701953125000e+13,
                                  1.219736174129123046875000e+13,
                                  1.221454775302172070312500e+13,
                                  1.223145691149039062500000e+13,
                                  1.224809027906222070312500e+13,
                                  1.226444892935476367187500e+13,
                                  1.228053394694101757812500e+13,
                                  1.229634642705596679687500e+13,
                                  1.231188747530657421875000e+13,
                                  1.232715820738531250000000e+13,
                                  1.234215974878719531250000e+13,
                                  1.235689323453033593750000e+13,
                                  1.237135980887986523437500e+13,
                                  1.238556062507549218750000e+13,
                                  1.239949684506237304687500e+13,
                                  1.241316963922545312500000e+13,
                                  1.242658018612724218750000e+13,
                                  1.243972967224899609375000e+13,
                                  1.245261929173525195312500e+13,
                                  1.246525024614174023437500e+13,
                                  1.247762374418668359375000e+13,
                                  1.248974100150537109375000e+13,
                                  1.250160324040809570312500e+13,
                                  1.251321168964133398437500e+13,
                                  1.252456758415224804687500e+13,
                                  1.253567216485642578125000e+13,
                                  1.254652667840882226562500e+13,
                                  1.255713237697795703125000e+13,
                                  1.256749051802323046875000e+13,
                                  1.257760236407555468750000e+13,
                                  1.258746918252097265625000e+13,
                                  1.259709224538748046875000e+13,
                                  1.260647282913492187500000e+13,
                                  1.261561221444801562500000e+13,
                                  1.262451168603236523437500e+13,
                                  1.263317253241355468750000e+13,
                                  1.264159604573922460937500e+13,
                                  1.264978352158417578125000e+13,
                                  1.265773625875839843750000e+13,
                                  1.266545555911798242187500e+13,
                                  1.267294272737911523437500e+13,
                                  1.268019907093477539062500e+13,
                                  1.268722589967439648437500e+13,
                                  1.269402452580634375000000e+13,
                                  1.270059626368322656250000e+13,
                                  1.270694242962999609375000e+13,
                                  1.271306434177473828125000e+13,
                                  1.271896331988232226562500e+13,
                                  1.272464068519067968750000e+13,
                                  1.273009776024983398437500e+13,
                                  1.273533586876350585937500e+13,
                                  1.274035633543342382812500e+13,
                                  1.274516048580628906250000e+13,
                                  1.274974964612321289062500e+13,
                                  1.275412514317182226562500e+13,
                                  1.275828830414080078125000e+13,
                                  1.276224045647708007812500e+13,
                                  1.276598292774538671875000e+13,
                                  1.276951704549028125000000e+13,
                                  1.277284413710068945312500e+13,
                                  1.277596552967679882812500e+13,
                                  1.277888254989934570312500e+13,
                                  1.278159652390123242187500e+13,
                                  1.278410877714154101562500e+13,
                                  1.278642063428179101562500e+13,
                                  1.278853341906456054687500e+13,
                                  1.279044845419426367187500e+13,
                                  1.279216706122022460937500e+13,
                                  1.279369056042195507812500e+13,
                                  1.279502027069663867187500e+13,
                                  1.279615750944868554687500e+13,
                                  1.279710359248152929687500e+13,
                                  1.279785983389145898437500e+13,
                                  1.279842754596356445312500e+13,
                                  1.279880803906973437500000e+13,
                                  1.279900262156868164062500e+13,
                                  1.279901259970804882812500e+13,
                                  1.279883927752834179687500e+13,
                                  1.279848395676906054687500e+13,
                                  1.279794793677654492187500e+13,
                                  1.279723251441384375000000e+13,
                                  1.279633898397249414062500e+13,
                                  1.279526863708614257812500e+13,
                                  1.279402276264595312500000e+13,
                                  1.279260264671798046875000e+13,
                                  1.279100957246219140625000e+13,
                                  1.278924482005336914062500e+13,
                                  1.278730966660373632812500e+13,
                                  1.278520538608723632812500e+13,
                                  1.278293324926571093750000e+13,
                                  1.278049452361651953125000e+13,
                                  1.277789047326210156250000e+13,
                                  1.277512235890087500000000e+13,
                                  1.277219143774002734375000e+13,
                                  1.276909896342974414062500e+13,
                                  1.276584618599910546875000e+13,
                                  1.276243435179342968750000e+13,
                                  1.275886470341329492187500e+13,
                                  1.275513847965494335937500e+13,
                                  1.275125691545228515625000e+13,
                                  1.274722124182031250000000e+13,
                                  1.274303268579996679687500e+13,
                                  1.273869247040449218750000e+13,
                                  1.273420181456712695312500e+13,
                                  1.272956193309027148437500e+13,
                                  1.272477403659591015625000e+13,
                                  1.271983933147754101562500e+13,
                                  1.271475901985330273437500e+13,
                                  1.270953429952051562500000e+13,
                                  1.270416636391142382812500e+13,
                                  1.269865640205032226562500e+13,
                                  1.269300559851180078125000e+13,
                                  1.268721513338042578125000e+13,
                                  1.268128618221144726562500e+13,
                                  1.267521991599276953125000e+13,
                                  1.266901750110822656250000e+13,
                                  1.266268009930181054687500e+13,
                                  1.265620886764325195312500e+13,
                                  1.264960495849460156250000e+13,
                                  1.264286951947798046875000e+13,
                                  1.263600369344441601562500e+13,
                                  1.262900861844375390625000e+13,
                                  1.262188542769560937500000e+13,
                                  1.261463524956148632812500e+13,
                                  1.260725920751770117187500e+13,
                                  1.259975842012960937500000e+13,
                                  1.259213400102653710937500e+13,
                                  1.258438705887792382812500e+13,
                                  1.257651869737027539062500e+13,
                                  1.256853001518520898437500e+13,
                                  1.256042210597829296875000e+13,
                                  1.255219605835893164062500e+13,
                                  1.254385295587102539062500e+13,
                                  1.253539387697466210937500e+13,
                                  1.252681989502857812500000e+13,
                                  1.251813207827353906250000e+13,
                                  1.250933148981650390625000e+13,
                                  1.250041918761570898437500e+13,
                                  1.249139622446651953125000e+13,
                                  1.248226364798804296875000e+13,
                                  1.247302250061066015625000e+13,
                                  1.246367381956415625000000e+13,
                                  1.245421863686680078125000e+13,
                                  1.244465797931506835937500e+13,
                                  1.243499286847407226562500e+13,
                                  1.242522432066878320312500e+13,
                                  1.241535334697602539062500e+13,
                                  1.240538095321699414062500e+13,
                                  1.239530813995058593750000e+13,
                                  1.238513590246739062500000e+13,
                                  1.237486523078431445312500e+13,
                                  1.236449710963986523437500e+13,
                                  1.235403251849010742187500e+13,
                                  1.234347243150515625000000e+13,
                                  1.233281781756635742187500e+13,
                                  1.232206964026413671875000e+13,
                                  1.231122885789623242187500e+13,
                                  1.230029642346674609375000e+13,
                                  1.228927328468559570312500e+13,
                                  1.227816038396858398437500e+13,
                                  1.226695865843805078125000e+13,
                                  1.225566903992400195312500e+13,
                                  1.224429245496578906250000e+13,
                                  1.223282982481435156250000e+13,
                                  1.222128206543487500000000e+13,
                                  1.220965008750999414062500e+13,
                                  1.219793479644354882812500e+13,
                                  1.218613709236463867187500e+13,
                                  1.217425787013239257812500e+13,
                                  1.216229801934092382812500e+13,
                                  1.215025842432498632812500e+13,
                                  1.213813996416588281250000e+13,
                                  1.212594351269788281250000e+13,
                                  1.211366993851510742187500e+13,
                                  1.210132010497869335937500e+13,
                                  1.208889487022449023437500e+13,
                                  1.207639508717111523437500e+13,
                                  1.206382160352831640625000e+13,
                                  1.205117526180583007812500e+13,
                                  1.203845689932256250000000e+13,
                                  1.202566734821608593750000e+13,
                                  1.201280743545256054687500e+13,
                                  1.199987798283695703125000e+13,
                                  1.198687980702364843750000e+13,
                                  1.197381371952728125000000e+13,
                                  1.196068052673400195312500e+13,
                                  1.194748102991307031250000e+13,
                                  1.193421602522860351562500e+13,
                                  1.192088630375180078125000e+13,
                                  1.190749265147334179687500e+13,
                                  1.189403584931615820312500e+13,
                                  1.188051667314841210937500e+13,
                                  1.186693589379673046875000e+13,
                                  1.185329427705989062500000e+13,
                                  1.183959258372246484375000e+13,
                                  1.182583156956898828125000e+13,
                                  1.181201198539820312500000e+13,
                                  1.179813457703763867187500e+13,
                                  1.178420008535837695312500e+13,
                                  1.177020924629001757812500e+13,
                                  1.175616279083597460937500e+13,
                                  1.174206144508886718750000e+13,
                                  1.172790593024620507812500e+13,
                                  1.171369696262618359375000e+13,
                                  1.169943525368380468750000e+13,
                                  1.168512151002710351562500e+13,
                                  1.167075643343352929687500e+13,
                                  1.165634072086664062500000e+13,
                                  1.164187506449281445312500e+13,
                                  1.162736015169827539062500e+13,
                                  1.161279666510618945312500e+13,
                                  1.159818528259393554687500e+13,
                                  1.158352667731059375000000e+13,
                                  1.156882151769449023437500e+13,
                                  1.155407046749096093750000e+13,
                                  1.153927418577026757812500e+13,
                                  1.152443332694552929687500e+13,
                                  1.150954854079095117187500e+13,
                                  1.149462047246006250000000e+13,
                                  1.147964976250414257812500e+13,
                                  1.146463704689069921875000e+13,
                                  1.144958295702215820312500e+13,
                                  1.143448811975455273437500e+13,
                                  1.141935315741639648437500e+13,
                                  1.140417868782763476562500e+13,
                                  1.138896532431870117187500e+13,
                                  1.137371367574964453125000e+13,
                                  1.135842434652935937500000e+13,
                                  1.134309793663493554687500e+13,
                                  1.132773504163102148437500e+13,
                                  1.131233625268932226562500e+13,
                                  1.129690215660816210937500e+13,
                                  1.128143333583208984375000e+13,
                                  1.126593036847158984375000e+13,
                                  1.125039382832285351562500e+13,
                                  1.123482428488757421875000e+13,
                                  1.121922230339283593750000e+13,
                                  1.120358844481104882812500e+13,
                                  1.118792326587995703125000e+13,
                                  1.117222731912260742187500e+13,
                                  1.115650115286751367187500e+13,
                                  1.114074531126870898437500e+13,
                                  1.112496033432594531250000e+13,
                                  1.110914675790488671875000e+13,
                                  1.109330511375731250000000e+13,
                                  1.107743592954142187500000e+13,
                                  1.106153972884209765625000e+13,
                                  1.104561703119121289062500e+13,
                                  1.102966835208798437500000e+13,
                                  1.101369420301932617187500e+13,
                                  1.099769509148026757812500e+13,
                                  1.098167152099425000000000e+13,
                                  1.096562399113361132812500e+13,
                                  1.094955299753996679687500e+13,
                                  1.093345903194464843750000e+13,
                                  1.091734258218909765625000e+13,
                                  1.090120413224534765625000e+13,
                                  1.088504416223640234375000e+13,
                                  1.086886314845671289062500e+13,
                                  1.085266156339256250000000e+13,
                                  1.083643987574253320312500e+13,
                                  1.082019855043787500000000e+13,
                                  1.080393804866297460937500e+13,
                                  1.078765882787565234375000e+13,
                                  1.077136134182764648437500e+13,
                                  1.075504604058491601562500e+13,
                                  1.073871337054800585937500e+13,
                                  1.072236377447239453125000e+13,
                                  1.070599769148878320312500e+13,
                                  1.068961555712338867187500e+13,
                                  1.067321780331820898437500e+13,
                                  1.065680485845124804687500e+13,
                                  1.064037714735677539062500e+13,
                                  1.062393509134544726562500e+13,
                                  1.060747910822449804687500e+13,
                                  1.059100961231784375000000e+13,
                                  1.057452701448618750000000e+13,
                                  1.055803172214704101562500e+13,
                                  1.054152413929479296875000e+13,
                                  1.052500466652061914062500e+13,
                                  1.050847370103248632812500e+13,
                                  1.049193163667502343750000e+13,
                                  1.047537886394937695312500e+13,
                                  1.045881577003303515625000e+13,
                                  1.044224273879959570312500e+13,
                                  1.042566015083854101562500e+13,
                                  1.040906838347479687500000e+13,
                                  1.039246781078850781250000e+13,
                                  1.037585880363453710937500e+13,
                                  1.035924172966202148437500e+13,
                                  1.034261695333388085937500e+13,
                                  1.032598483594621289062500e+13,
                                  1.030934573564769335937500e+13,
                                  1.029270000745890820312500e+13,
                                  1.027604800329161523437500e+13,
                                  1.025939007196798242187500e+13,
                                  1.024272655923970898437500e+13,
                                  1.022605780780716992187500e+13,
                                  1.020938415733844531250000e+13,
                                  1.019270594448829687500000e+13,
                                  1.017602350291711132812500e+13,
                                  1.015933716330976562500000e+13,
                                  1.014264725339441796875000e+13,
                                  1.012595409796125781250000e+13,
                                  1.010925801888120312500000e+13,
                                  1.009255933512448828125000e+13,
                                  1.007585836277923632812500e+13,
                                  1.005915541506995312500000e+13,
                                  1.004245080237592773437500e+13,
                                  1.002574483224960156250000e+13,
                                  1.000903780943485937500000e+13,
                                  9.992330035885263671875000e+12,
                                  9.975621810782177734375000e+12,
                                  9.958913430552892578125000e+12,
                                  9.942205188888615234375000e+12,
                                  9.925497376762439453125000e+12,
                                  9.908790282447210937500000e+12,
                                  9.892084191533335937500000e+12,
                                  9.875379386946525390625000e+12,
                                  9.858676148965472656250000e+12,
                                  9.841974755239441406250000e+12,
                                  9.825275480805767578125000e+12,
                                  9.808578598107363281250000e+12,
                                  9.791884377010027343750000e+12,
                                  9.775193084819832031250000e+12,
                                  9.758504986300298828125000e+12,
                                  9.741820343689539062500000e+12])


class TestPlanckLaw(unittest.TestCase):
    """
    Defines :func:`color.spectral.blackbody.planck_law` definition units tests methods.
    """

    def test_planck_law(self):
        """
        Tests :func:`color.spectral.blackbody.planck_law` definition.
        """

        for temperature, wavelengths in sorted(PLANCK_LAW_DATA.iteritems()):
            for wavelength, radiance in sorted(wavelengths.iteritems()):
                numpy.testing.assert_almost_equal(color.spectral.blackbody.planck_law(wavelength * 1e-9, temperature),
                                                  radiance,
                                                  decimal=7)


class TestBlackbodySpectralPowerDistribution(unittest.TestCase):
    """
    Defines :func:`color.spectral.blackbody.blackbody_spectral_power_distribution` definition units tests methods.
    """

    def test_blackbody_power_spectral_distribution(self):
        """
        Tests :func:`color.spectral.blackbody.blackbody_spectral_power_distribution` definition.
        """

        numpy.testing.assert_almost_equal(
            color.spectral.blackbody.blackbody_spectral_power_distribution(5000, 360, 830, 1).values,
            BLACKBODY_SPD_DATA,
            decimal=7)


if __name__ == "__main__":
    unittest.main()
