
## Setup New Node
---


### Initializing the default genesis and validator files

Initialize the `commitBlockchain` validator and set the moniker. *Moniker* is a name that you set to your validator. It will generate genesis.json and config files.

`maind init <moniker of validator>`

For example, if `Commit Network` is the moniker to be set, the below command is to be used

`maind init "Commit Network" --chain-id crust-2`

![](https://i.imgur.com/6tDy4pX.png)

### Create an Account

Run the following command to create a new commit account in local database.

`maincli keys add <account name>`

**Note: Please write the mnemonic phrase in a safe place**

![](https://i.imgur.com/EyRJERQ.png)


### Add a genesis account

Run the following command to add an account as genesis account.

**Note:** Add only amount `100000000ucommit`.

`maind add-genesis-account <account name> <amount to be add>`

![](https://i.imgur.com/NR53QaL.png)


### Create an offine genesis transaction

**Note:** Add only amount `100000000ucommit`

Create an offline genesis transaction by running the following command. The `gentx-xxx.json` file is generated in the directory `$HOME/.maind/config/gentx/`.

`maind gentx --name <account name> \`

`--amount <amount to be stake in ucommit> \`

`--commission-rate 0.1 \`

`--commission-max-rate 0.2 \`

`--commission-max-change-rate 0.01`

![](https://i.imgur.com/PulnFgW.png)

### Collect genesis transactions

`maind collect-gentxs`

- start the chain (local)

    `maind start`

- It will start the local chain, if you want to connect to our testnet [Crust-X](https://github.com/commitHub/genesisTransactions/tree/master/crust-2)