/*
Copyright 2021 Cortex Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package archive

import (
	"fmt"

	"github.com/cortexlabs/cortex/pkg/lib/errors"
	s "github.com/cortexlabs/cortex/pkg/lib/strings"
)

const (
	_errStrCreateArchive = "unable to create archive"
	_errStrCreateZip     = "unable to create zip file"
	_errStrCreateTar     = "unable to create tar file"
	_errStrUnzip         = "unable to unzip file"
	_errStrUntar         = "unable to extract tar file"
)

const (
	ErrDuplicatePath = "archive.duplicate_path"
)

func ErrorDuplicatePath(path string) error {
	return errors.WithStack(&errors.Error{
		Kind:    ErrDuplicatePath,
		Message: fmt.Sprintf("duplicate path was provided (%s)", s.UserStr(path)),
	})
}
