/*
Copyright 2021 Cortex Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by go generate; DO NOT EDIT

package aws

import (
	kresource "k8s.io/apimachinery/pkg/api/resource"
)

type InstanceMetadata struct {
	Region string             `json:"region"`
	Type   string             `json:"type"`
	Memory kresource.Quantity `json:"memory"`
	CPU    kresource.Quantity `json:"cpu"`
	GPU    int64              `json:"gpu"`
	Inf    int64              `json:"inf"`
	Price  float64            `json:"price"`
}

type NLBMetadata struct {
	Region string  `json:"region"`
	Price  float64 `json:"price"`
}

type NATMetadata struct {
	Region string  `json:"region"`
	Price  float64 `json:"price"`
}

type EBSMetadata struct {
	Region           string  `json:"region"`
	PriceGB          float64 `json:"price_gb"`
	PriceIOPS        float64 `json:"price_iops"`
	IOPSConfigurable bool    `json:"iops_configurable"`
	Type             string  `json:"type"`
}

// region -> instance type -> instance metadata
var InstanceMetadatas = map[string]map[string]InstanceMetadata{
	"af-south-1": {
		"c5.12xlarge":   {Region: "af-south-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.736},
		"c5.18xlarge":   {Region: "af-south-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.104},
		"c5.24xlarge":   {Region: "af-south-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.472},
		"c5.2xlarge":    {Region: "af-south-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.456},
		"c5.4xlarge":    {Region: "af-south-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.912},
		"c5.9xlarge":    {Region: "af-south-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.052},
		"c5.large":      {Region: "af-south-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.114},
		"c5.metal":      {Region: "af-south-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.472},
		"c5.xlarge":     {Region: "af-south-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.228},
		"c5d.12xlarge":  {Region: "af-south-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.12},
		"c5d.18xlarge":  {Region: "af-south-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.68},
		"c5d.24xlarge":  {Region: "af-south-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.24},
		"c5d.2xlarge":   {Region: "af-south-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.52},
		"c5d.4xlarge":   {Region: "af-south-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.04},
		"c5d.9xlarge":   {Region: "af-south-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.34},
		"c5d.large":     {Region: "af-south-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"c5d.metal":     {Region: "af-south-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.24},
		"c5d.xlarge":    {Region: "af-south-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.26},
		"d2.2xlarge":    {Region: "af-south-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.75},
		"d2.4xlarge":    {Region: "af-south-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.5},
		"d2.8xlarge":    {Region: "af-south-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 7.0},
		"d2.xlarge":     {Region: "af-south-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.875},
		"g4dn.12xlarge": {Region: "af-south-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 5.19},
		"g4dn.16xlarge": {Region: "af-south-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.774},
		"g4dn.2xlarge":  {Region: "af-south-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.998},
		"g4dn.4xlarge":  {Region: "af-south-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.597},
		"g4dn.8xlarge":  {Region: "af-south-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.887},
		"g4dn.metal":    {Region: "af-south-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 10.381},
		"g4dn.xlarge":   {Region: "af-south-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.698},
		"i3.16xlarge":   {Region: "af-south-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.56},
		"i3.2xlarge":    {Region: "af-south-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.82},
		"i3.4xlarge":    {Region: "af-south-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.64},
		"i3.8xlarge":    {Region: "af-south-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.28},
		"i3.large":      {Region: "af-south-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.205},
		"i3.metal":      {Region: "af-south-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.56},
		"i3.xlarge":     {Region: "af-south-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.41},
		"m5.12xlarge":   {Region: "af-south-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.048},
		"m5.16xlarge":   {Region: "af-south-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.064},
		"m5.24xlarge":   {Region: "af-south-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.096},
		"m5.2xlarge":    {Region: "af-south-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.508},
		"m5.4xlarge":    {Region: "af-south-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.016},
		"m5.8xlarge":    {Region: "af-south-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.032},
		"m5.large":      {Region: "af-south-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.127},
		"m5.metal":      {Region: "af-south-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.096},
		"m5.xlarge":     {Region: "af-south-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.254},
		"m5d.12xlarge":  {Region: "af-south-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.6},
		"m5d.16xlarge":  {Region: "af-south-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.8},
		"m5d.24xlarge":  {Region: "af-south-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.2},
		"m5d.2xlarge":   {Region: "af-south-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6},
		"m5d.4xlarge":   {Region: "af-south-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.2},
		"m5d.8xlarge":   {Region: "af-south-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.4},
		"m5d.large":     {Region: "af-south-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.15},
		"m5d.metal":     {Region: "af-south-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.2},
		"m5d.xlarge":    {Region: "af-south-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3},
		"r5.12xlarge":   {Region: "af-south-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.032},
		"r5.16xlarge":   {Region: "af-south-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.376},
		"r5.24xlarge":   {Region: "af-south-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.064},
		"r5.2xlarge":    {Region: "af-south-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.672},
		"r5.4xlarge":    {Region: "af-south-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.344},
		"r5.8xlarge":    {Region: "af-south-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.688},
		"r5.large":      {Region: "af-south-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.168},
		"r5.metal":      {Region: "af-south-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.064},
		"r5.xlarge":     {Region: "af-south-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.336},
		"r5d.12xlarge":  {Region: "af-south-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.56},
		"r5d.16xlarge":  {Region: "af-south-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.08},
		"r5d.24xlarge":  {Region: "af-south-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.12},
		"r5d.2xlarge":   {Region: "af-south-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.76},
		"r5d.4xlarge":   {Region: "af-south-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.52},
		"r5d.8xlarge":   {Region: "af-south-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.04},
		"r5d.large":     {Region: "af-south-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.19},
		"r5d.metal":     {Region: "af-south-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.12},
		"r5d.xlarge":    {Region: "af-south-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.38},
		"t3.2xlarge":    {Region: "af-south-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4339},
		"t3.large":      {Region: "af-south-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1085},
		"t3.medium":     {Region: "af-south-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0542},
		"t3.micro":      {Region: "af-south-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0136},
		"t3.nano":       {Region: "af-south-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0068},
		"t3.small":      {Region: "af-south-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0271},
		"t3.xlarge":     {Region: "af-south-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.217},
		"x1.16xlarge":   {Region: "af-south-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.524},
		"x1.32xlarge":   {Region: "af-south-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 19.048},
		"x1e.16xlarge":  {Region: "af-south-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 19.04},
		"x1e.2xlarge":   {Region: "af-south-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.38},
		"x1e.32xlarge":  {Region: "af-south-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 38.08},
		"x1e.4xlarge":   {Region: "af-south-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.76},
		"x1e.8xlarge":   {Region: "af-south-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.52},
		"x1e.xlarge":    {Region: "af-south-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.19},
	},
	"ap-east-1": {
		"c5.12xlarge":   {Region: "ap-east-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.592},
		"c5.18xlarge":   {Region: "ap-east-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5.24xlarge":   {Region: "ap-east-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.184},
		"c5.2xlarge":    {Region: "ap-east-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"c5.4xlarge":    {Region: "ap-east-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"c5.9xlarge":    {Region: "ap-east-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.944},
		"c5.large":      {Region: "ap-east-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"c5.metal":      {Region: "ap-east-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.184},
		"c5.xlarge":     {Region: "ap-east-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"c5a.12xlarge":  {Region: "ap-east-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.328},
		"c5a.16xlarge":  {Region: "ap-east-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.104},
		"c5a.24xlarge":  {Region: "ap-east-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.656},
		"c5a.2xlarge":   {Region: "ap-east-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.388},
		"c5a.4xlarge":   {Region: "ap-east-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.776},
		"c5a.8xlarge":   {Region: "ap-east-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.552},
		"c5a.large":     {Region: "ap-east-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.097},
		"c5a.xlarge":    {Region: "ap-east-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.194},
		"c5d.18xlarge":  {Region: "ap-east-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.428},
		"c5d.2xlarge":   {Region: "ap-east-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.492},
		"c5d.4xlarge":   {Region: "ap-east-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.984},
		"c5d.9xlarge":   {Region: "ap-east-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.214},
		"c5d.large":     {Region: "ap-east-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.123},
		"c5d.xlarge":    {Region: "ap-east-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.246},
		"c5n.18xlarge":  {Region: "ap-east-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.148},
		"c5n.2xlarge":   {Region: "ap-east-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.572},
		"c5n.4xlarge":   {Region: "ap-east-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.144},
		"c5n.9xlarge":   {Region: "ap-east-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.574},
		"c5n.large":     {Region: "ap-east-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.143},
		"c5n.metal":     {Region: "ap-east-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.148},
		"c5n.xlarge":    {Region: "ap-east-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.286},
		"c6g.12xlarge":  {Region: "ap-east-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"c6g.16xlarge":  {Region: "ap-east-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"c6g.2xlarge":   {Region: "ap-east-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"c6g.4xlarge":   {Region: "ap-east-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"c6g.8xlarge":   {Region: "ap-east-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"c6g.large":     {Region: "ap-east-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"c6g.medium":    {Region: "ap-east-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.043},
		"c6g.metal":     {Region: "ap-east-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"c6g.xlarge":    {Region: "ap-east-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"d2.2xlarge":    {Region: "ap-east-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.914},
		"d2.4xlarge":    {Region: "ap-east-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.828},
		"d2.8xlarge":    {Region: "ap-east-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 7.656},
		"d2.xlarge":     {Region: "ap-east-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.957},
		"g4dn.12xlarge": {Region: "ap-east-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 6.024},
		"g4dn.16xlarge": {Region: "ap-east-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 6.702},
		"g4dn.2xlarge":  {Region: "ap-east-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 1.158},
		"g4dn.4xlarge":  {Region: "ap-east-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.854},
		"g4dn.8xlarge":  {Region: "ap-east-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 3.351},
		"g4dn.metal":    {Region: "ap-east-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 12.048},
		"g4dn.xlarge":   {Region: "ap-east-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.81},
		"i3.16xlarge":   {Region: "ap-east-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.592},
		"i3.2xlarge":    {Region: "ap-east-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.824},
		"i3.4xlarge":    {Region: "ap-east-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.648},
		"i3.8xlarge":    {Region: "ap-east-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.296},
		"i3.large":      {Region: "ap-east-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.206},
		"i3.metal":      {Region: "ap-east-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.592},
		"i3.xlarge":     {Region: "ap-east-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.412},
		"i3en.12xlarge": {Region: "ap-east-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 7.16},
		"i3en.24xlarge": {Region: "ap-east-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 14.319},
		"i3en.2xlarge":  {Region: "ap-east-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.193},
		"i3en.3xlarge":  {Region: "ap-east-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.79},
		"i3en.6xlarge":  {Region: "ap-east-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.58},
		"i3en.large":    {Region: "ap-east-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.298},
		"i3en.metal":    {Region: "ap-east-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 14.319},
		"i3en.xlarge":   {Region: "ap-east-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.597},
		"inf1.24xlarge": {Region: "ap-east-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 11.733},
		"inf1.2xlarge":  {Region: "ap-east-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.9},
		"inf1.6xlarge":  {Region: "ap-east-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.933},
		"inf1.xlarge":   {Region: "ap-east-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.567},
		"m5.12xlarge":   {Region: "ap-east-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.168},
		"m5.16xlarge":   {Region: "ap-east-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.224},
		"m5.24xlarge":   {Region: "ap-east-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.336},
		"m5.2xlarge":    {Region: "ap-east-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.528},
		"m5.4xlarge":    {Region: "ap-east-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.056},
		"m5.8xlarge":    {Region: "ap-east-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.112},
		"m5.large":      {Region: "ap-east-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.132},
		"m5.metal":      {Region: "ap-east-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.336},
		"m5.xlarge":     {Region: "ap-east-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.264},
		"m5d.12xlarge":  {Region: "ap-east-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.72},
		"m5d.16xlarge":  {Region: "ap-east-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.96},
		"m5d.24xlarge":  {Region: "ap-east-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.44},
		"m5d.2xlarge":   {Region: "ap-east-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.62},
		"m5d.4xlarge":   {Region: "ap-east-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.24},
		"m5d.8xlarge":   {Region: "ap-east-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.48},
		"m5d.large":     {Region: "ap-east-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.155},
		"m5d.metal":     {Region: "ap-east-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.44},
		"m5d.xlarge":    {Region: "ap-east-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.31},
		"m6g.12xlarge":  {Region: "ap-east-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.544},
		"m6g.16xlarge":  {Region: "ap-east-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.392},
		"m6g.2xlarge":   {Region: "ap-east-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.424},
		"m6g.4xlarge":   {Region: "ap-east-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.848},
		"m6g.8xlarge":   {Region: "ap-east-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.696},
		"m6g.large":     {Region: "ap-east-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.106},
		"m6g.medium":    {Region: "ap-east-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.053},
		"m6g.metal":     {Region: "ap-east-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.392},
		"m6g.xlarge":    {Region: "ap-east-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.212},
		"r5.12xlarge":   {Region: "ap-east-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.008},
		"r5.16xlarge":   {Region: "ap-east-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.344},
		"r5.24xlarge":   {Region: "ap-east-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5.2xlarge":    {Region: "ap-east-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.668},
		"r5.4xlarge":    {Region: "ap-east-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.336},
		"r5.8xlarge":    {Region: "ap-east-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.672},
		"r5.large":      {Region: "ap-east-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.167},
		"r5.metal":      {Region: "ap-east-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5.xlarge":     {Region: "ap-east-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.334},
		"r5d.12xlarge":  {Region: "ap-east-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.2},
		"r5d.16xlarge":  {Region: "ap-east-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.6},
		"r5d.24xlarge":  {Region: "ap-east-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.4},
		"r5d.2xlarge":   {Region: "ap-east-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.7},
		"r5d.4xlarge":   {Region: "ap-east-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.4},
		"r5d.8xlarge":   {Region: "ap-east-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.8},
		"r5d.large":     {Region: "ap-east-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.175},
		"r5d.metal":     {Region: "ap-east-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.4},
		"r5d.xlarge":    {Region: "ap-east-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.35},
		"r6g.12xlarge":  {Region: "ap-east-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.216},
		"r6g.16xlarge":  {Region: "ap-east-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.288},
		"r6g.2xlarge":   {Region: "ap-east-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.536},
		"r6g.4xlarge":   {Region: "ap-east-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.072},
		"r6g.8xlarge":   {Region: "ap-east-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.144},
		"r6g.large":     {Region: "ap-east-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.134},
		"r6g.medium":    {Region: "ap-east-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.067},
		"r6g.metal":     {Region: "ap-east-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.288},
		"r6g.xlarge":    {Region: "ap-east-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.268},
		"t3.2xlarge":    {Region: "ap-east-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4672},
		"t3.large":      {Region: "ap-east-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1168},
		"t3.medium":     {Region: "ap-east-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0584},
		"t3.micro":      {Region: "ap-east-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0146},
		"t3.nano":       {Region: "ap-east-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0073},
		"t3.small":      {Region: "ap-east-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0292},
		"t3.xlarge":     {Region: "ap-east-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2336},
		"t4g.2xlarge":   {Region: "ap-east-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3712},
		"t4g.large":     {Region: "ap-east-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0928},
		"t4g.medium":    {Region: "ap-east-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0464},
		"t4g.micro":     {Region: "ap-east-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0116},
		"t4g.nano":      {Region: "ap-east-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0058},
		"t4g.small":     {Region: "ap-east-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0232},
		"t4g.xlarge":    {Region: "ap-east-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1856},
		"x1.16xlarge":   {Region: "ap-east-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 10.638},
		"x1.32xlarge":   {Region: "ap-east-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 21.276},
	},
	"ap-northeast-1": {
		"a1.4xlarge":    {Region: "ap-northeast-1", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.5136},
		"a1.large":      {Region: "ap-northeast-1", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0642},
		"a1.medium":     {Region: "ap-northeast-1", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0321},
		"a1.metal":      {Region: "ap-northeast-1", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.514},
		"a1.xlarge":     {Region: "ap-northeast-1", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1284},
		"c1.medium":     {Region: "ap-northeast-1", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.158},
		"c1.xlarge":     {Region: "ap-northeast-1", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.632},
		"c3.2xlarge":    {Region: "ap-northeast-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.511},
		"c3.4xlarge":    {Region: "ap-northeast-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.021},
		"c3.8xlarge":    {Region: "ap-northeast-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.043},
		"c3.large":      {Region: "ap-northeast-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.128},
		"c3.xlarge":     {Region: "ap-northeast-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.255},
		"c4.2xlarge":    {Region: "ap-northeast-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"c4.4xlarge":    {Region: "ap-northeast-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"c4.8xlarge":    {Region: "ap-northeast-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.016},
		"c4.large":      {Region: "ap-northeast-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"c4.xlarge":     {Region: "ap-northeast-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"c5.12xlarge":   {Region: "ap-northeast-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.568},
		"c5.18xlarge":   {Region: "ap-northeast-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.852},
		"c5.24xlarge":   {Region: "ap-northeast-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"c5.2xlarge":    {Region: "ap-northeast-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.428},
		"c5.4xlarge":    {Region: "ap-northeast-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.856},
		"c5.9xlarge":    {Region: "ap-northeast-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.926},
		"c5.large":      {Region: "ap-northeast-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.107},
		"c5.metal":      {Region: "ap-northeast-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"c5.xlarge":     {Region: "ap-northeast-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.214},
		"c5a.12xlarge":  {Region: "ap-northeast-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c5a.16xlarge":  {Region: "ap-northeast-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"c5a.24xlarge":  {Region: "ap-northeast-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5a.2xlarge":   {Region: "ap-northeast-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c5a.4xlarge":   {Region: "ap-northeast-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c5a.8xlarge":   {Region: "ap-northeast-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"c5a.large":     {Region: "ap-northeast-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c5a.xlarge":    {Region: "ap-northeast-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"c5d.12xlarge":  {Region: "ap-northeast-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.928},
		"c5d.18xlarge":  {Region: "ap-northeast-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.392},
		"c5d.24xlarge":  {Region: "ap-northeast-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"c5d.2xlarge":   {Region: "ap-northeast-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"c5d.4xlarge":   {Region: "ap-northeast-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"c5d.9xlarge":   {Region: "ap-northeast-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.196},
		"c5d.large":     {Region: "ap-northeast-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"c5d.metal":     {Region: "ap-northeast-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"c5d.xlarge":    {Region: "ap-northeast-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"c5n.18xlarge":  {Region: "ap-northeast-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.896},
		"c5n.2xlarge":   {Region: "ap-northeast-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"c5n.4xlarge":   {Region: "ap-northeast-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"c5n.9xlarge":   {Region: "ap-northeast-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.448},
		"c5n.large":     {Region: "ap-northeast-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"c5n.metal":     {Region: "ap-northeast-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.896},
		"c5n.xlarge":    {Region: "ap-northeast-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"c6g.12xlarge":  {Region: "ap-northeast-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0544},
		"c6g.16xlarge":  {Region: "ap-northeast-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7392},
		"c6g.2xlarge":   {Region: "ap-northeast-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3424},
		"c6g.4xlarge":   {Region: "ap-northeast-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6848},
		"c6g.8xlarge":   {Region: "ap-northeast-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3696},
		"c6g.large":     {Region: "ap-northeast-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0856},
		"c6g.medium":    {Region: "ap-northeast-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0428},
		"c6g.metal":     {Region: "ap-northeast-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7392},
		"c6g.xlarge":    {Region: "ap-northeast-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1712},
		"c6gd.12xlarge": {Region: "ap-northeast-1", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.352},
		"c6gd.16xlarge": {Region: "ap-northeast-1", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.136},
		"c6gd.2xlarge":  {Region: "ap-northeast-1", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.392},
		"c6gd.4xlarge":  {Region: "ap-northeast-1", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.784},
		"c6gd.8xlarge":  {Region: "ap-northeast-1", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.568},
		"c6gd.large":    {Region: "ap-northeast-1", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.098},
		"c6gd.medium":   {Region: "ap-northeast-1", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.049},
		"c6gd.metal":    {Region: "ap-northeast-1", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.136},
		"c6gd.xlarge":   {Region: "ap-northeast-1", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.196},
		"cc2.8xlarge":   {Region: "ap-northeast-1", Type: "cc2.8xlarge", Memory: kresource.MustParse("61952Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.349},
		"cr1.8xlarge":   {Region: "ap-northeast-1", Type: "cr1.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 4.105},
		"d2.2xlarge":    {Region: "ap-northeast-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.688},
		"d2.4xlarge":    {Region: "ap-northeast-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.376},
		"d2.8xlarge":    {Region: "ap-northeast-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.752},
		"d2.xlarge":     {Region: "ap-northeast-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.844},
		"g2.2xlarge":    {Region: "ap-northeast-1", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.898},
		"g2.8xlarge":    {Region: "ap-northeast-1", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 3.592},
		"g3.16xlarge":   {Region: "ap-northeast-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 6.32},
		"g3.4xlarge":    {Region: "ap-northeast-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.58},
		"g3.8xlarge":    {Region: "ap-northeast-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 3.16},
		"g3s.xlarge":    {Region: "ap-northeast-1", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.04},
		"g4dn.12xlarge": {Region: "ap-northeast-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 5.281},
		"g4dn.16xlarge": {Region: "ap-northeast-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.875},
		"g4dn.2xlarge":  {Region: "ap-northeast-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 1.015},
		"g4dn.4xlarge":  {Region: "ap-northeast-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.625},
		"g4dn.8xlarge":  {Region: "ap-northeast-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.938},
		"g4dn.metal":    {Region: "ap-northeast-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 10.562},
		"g4dn.xlarge":   {Region: "ap-northeast-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.71},
		"hs1.8xlarge":   {Region: "ap-northeast-1", Type: "hs1.8xlarge", Memory: kresource.MustParse("119808Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 5.4},
		"i2.2xlarge":    {Region: "ap-northeast-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.001},
		"i2.4xlarge":    {Region: "ap-northeast-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.002},
		"i2.8xlarge":    {Region: "ap-northeast-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 8.004},
		"i2.xlarge":     {Region: "ap-northeast-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.001},
		"i3.16xlarge":   {Region: "ap-northeast-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.856},
		"i3.2xlarge":    {Region: "ap-northeast-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.732},
		"i3.4xlarge":    {Region: "ap-northeast-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.464},
		"i3.8xlarge":    {Region: "ap-northeast-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.928},
		"i3.large":      {Region: "ap-northeast-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.183},
		"i3.metal":      {Region: "ap-northeast-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.856},
		"i3.xlarge":     {Region: "ap-northeast-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.366},
		"i3en.12xlarge": {Region: "ap-northeast-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.384},
		"i3en.24xlarge": {Region: "ap-northeast-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.768},
		"i3en.2xlarge":  {Region: "ap-northeast-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.064},
		"i3en.3xlarge":  {Region: "ap-northeast-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.596},
		"i3en.6xlarge":  {Region: "ap-northeast-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.192},
		"i3en.large":    {Region: "ap-northeast-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.266},
		"i3en.metal":    {Region: "ap-northeast-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.768},
		"i3en.xlarge":   {Region: "ap-northeast-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.532},
		"inf1.24xlarge": {Region: "ap-northeast-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 10.284},
		"inf1.2xlarge":  {Region: "ap-northeast-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.789},
		"inf1.6xlarge":  {Region: "ap-northeast-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.571},
		"inf1.xlarge":   {Region: "ap-northeast-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.497},
		"m1.large":      {Region: "ap-northeast-1", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.243},
		"m1.medium":     {Region: "ap-northeast-1", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.122},
		"m1.small":      {Region: "ap-northeast-1", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.061},
		"m1.xlarge":     {Region: "ap-northeast-1", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.486},
		"m2.2xlarge":    {Region: "ap-northeast-1", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.575},
		"m2.4xlarge":    {Region: "ap-northeast-1", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.15},
		"m2.xlarge":     {Region: "ap-northeast-1", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.287},
		"m3.2xlarge":    {Region: "ap-northeast-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.77},
		"m3.large":      {Region: "ap-northeast-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.193},
		"m3.medium":     {Region: "ap-northeast-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.096},
		"m3.xlarge":     {Region: "ap-northeast-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.385},
		"m4.10xlarge":   {Region: "ap-northeast-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.58},
		"m4.16xlarge":   {Region: "ap-northeast-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.128},
		"m4.2xlarge":    {Region: "ap-northeast-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.516},
		"m4.4xlarge":    {Region: "ap-northeast-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.032},
		"m4.large":      {Region: "ap-northeast-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.129},
		"m4.xlarge":     {Region: "ap-northeast-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.258},
		"m5.12xlarge":   {Region: "ap-northeast-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.976},
		"m5.16xlarge":   {Region: "ap-northeast-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.968},
		"m5.24xlarge":   {Region: "ap-northeast-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.952},
		"m5.2xlarge":    {Region: "ap-northeast-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.496},
		"m5.4xlarge":    {Region: "ap-northeast-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.992},
		"m5.8xlarge":    {Region: "ap-northeast-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.984},
		"m5.large":      {Region: "ap-northeast-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.124},
		"m5.metal":      {Region: "ap-northeast-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.952},
		"m5.xlarge":     {Region: "ap-northeast-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.248},
		"m5a.12xlarge":  {Region: "ap-northeast-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.688},
		"m5a.16xlarge":  {Region: "ap-northeast-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.584},
		"m5a.24xlarge":  {Region: "ap-northeast-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5a.2xlarge":   {Region: "ap-northeast-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.448},
		"m5a.4xlarge":   {Region: "ap-northeast-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.896},
		"m5a.8xlarge":   {Region: "ap-northeast-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.792},
		"m5a.large":     {Region: "ap-northeast-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.112},
		"m5a.xlarge":    {Region: "ap-northeast-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.224},
		"m5ad.12xlarge": {Region: "ap-northeast-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.216},
		"m5ad.16xlarge": {Region: "ap-northeast-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.288},
		"m5ad.24xlarge": {Region: "ap-northeast-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.432},
		"m5ad.2xlarge":  {Region: "ap-northeast-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.536},
		"m5ad.4xlarge":  {Region: "ap-northeast-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.072},
		"m5ad.8xlarge":  {Region: "ap-northeast-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.144},
		"m5ad.large":    {Region: "ap-northeast-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.134},
		"m5ad.xlarge":   {Region: "ap-northeast-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.268},
		"m5d.12xlarge":  {Region: "ap-northeast-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.504},
		"m5d.16xlarge":  {Region: "ap-northeast-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.672},
		"m5d.24xlarge":  {Region: "ap-northeast-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"m5d.2xlarge":   {Region: "ap-northeast-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.584},
		"m5d.4xlarge":   {Region: "ap-northeast-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.168},
		"m5d.8xlarge":   {Region: "ap-northeast-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.336},
		"m5d.large":     {Region: "ap-northeast-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.146},
		"m5d.metal":     {Region: "ap-northeast-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"m5d.xlarge":    {Region: "ap-northeast-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.292},
		"m5dn.12xlarge": {Region: "ap-northeast-1", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.2},
		"m5dn.16xlarge": {Region: "ap-northeast-1", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.6},
		"m5dn.24xlarge": {Region: "ap-northeast-1", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.4},
		"m5dn.2xlarge":  {Region: "ap-northeast-1", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.7},
		"m5dn.4xlarge":  {Region: "ap-northeast-1", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.4},
		"m5dn.8xlarge":  {Region: "ap-northeast-1", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.8},
		"m5dn.large":    {Region: "ap-northeast-1", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.175},
		"m5dn.metal":    {Region: "ap-northeast-1", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.4},
		"m5dn.xlarge":   {Region: "ap-northeast-1", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.35},
		"m5n.12xlarge":  {Region: "ap-northeast-1", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.672},
		"m5n.16xlarge":  {Region: "ap-northeast-1", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.896},
		"m5n.24xlarge":  {Region: "ap-northeast-1", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.344},
		"m5n.2xlarge":   {Region: "ap-northeast-1", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.612},
		"m5n.4xlarge":   {Region: "ap-northeast-1", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.224},
		"m5n.8xlarge":   {Region: "ap-northeast-1", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.448},
		"m5n.large":     {Region: "ap-northeast-1", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.153},
		"m5n.metal":     {Region: "ap-northeast-1", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.344},
		"m5n.xlarge":    {Region: "ap-northeast-1", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.306},
		"m5zn.12xlarge": {Region: "ap-northeast-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.1204},
		"m5zn.2xlarge":  {Region: "ap-northeast-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.8534},
		"m5zn.3xlarge":  {Region: "ap-northeast-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.2801},
		"m5zn.6xlarge":  {Region: "ap-northeast-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.5602},
		"m5zn.large":    {Region: "ap-northeast-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2134},
		"m5zn.metal":    {Region: "ap-northeast-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.1204},
		"m5zn.xlarge":   {Region: "ap-northeast-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.4267},
		"m6g.12xlarge":  {Region: "ap-northeast-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.376},
		"m6g.16xlarge":  {Region: "ap-northeast-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.168},
		"m6g.2xlarge":   {Region: "ap-northeast-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.396},
		"m6g.4xlarge":   {Region: "ap-northeast-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.792},
		"m6g.8xlarge":   {Region: "ap-northeast-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.584},
		"m6g.large":     {Region: "ap-northeast-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.099},
		"m6g.medium":    {Region: "ap-northeast-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0495},
		"m6g.metal":     {Region: "ap-northeast-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.168},
		"m6g.xlarge":    {Region: "ap-northeast-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.198},
		"m6gd.12xlarge": {Region: "ap-northeast-1", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.808},
		"m6gd.16xlarge": {Region: "ap-northeast-1", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.744},
		"m6gd.2xlarge":  {Region: "ap-northeast-1", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.468},
		"m6gd.4xlarge":  {Region: "ap-northeast-1", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.936},
		"m6gd.8xlarge":  {Region: "ap-northeast-1", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.872},
		"m6gd.large":    {Region: "ap-northeast-1", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.117},
		"m6gd.medium":   {Region: "ap-northeast-1", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0585},
		"m6gd.metal":    {Region: "ap-northeast-1", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.744},
		"m6gd.xlarge":   {Region: "ap-northeast-1", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.234},
		"p2.16xlarge":   {Region: "ap-northeast-1", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 24.672},
		"p2.8xlarge":    {Region: "ap-northeast-1", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 12.336},
		"p2.xlarge":     {Region: "ap-northeast-1", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.542},
		"p3.16xlarge":   {Region: "ap-northeast-1", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 33.552},
		"p3.2xlarge":    {Region: "ap-northeast-1", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 4.194},
		"p3.8xlarge":    {Region: "ap-northeast-1", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 16.776},
		"p3dn.24xlarge": {Region: "ap-northeast-1", Type: "p3dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 42.783},
		"r3.2xlarge":    {Region: "ap-northeast-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.798},
		"r3.4xlarge":    {Region: "ap-northeast-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.596},
		"r3.8xlarge":    {Region: "ap-northeast-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.192},
		"r3.large":      {Region: "ap-northeast-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r3.xlarge":     {Region: "ap-northeast-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.399},
		"r4.16xlarge":   {Region: "ap-northeast-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.12},
		"r4.2xlarge":    {Region: "ap-northeast-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.64},
		"r4.4xlarge":    {Region: "ap-northeast-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.28},
		"r4.8xlarge":    {Region: "ap-northeast-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.56},
		"r4.large":      {Region: "ap-northeast-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.16},
		"r4.xlarge":     {Region: "ap-northeast-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.32},
		"r5.12xlarge":   {Region: "ap-northeast-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"r5.16xlarge":   {Region: "ap-northeast-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"r5.24xlarge":   {Region: "ap-northeast-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.2xlarge":    {Region: "ap-northeast-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"r5.4xlarge":    {Region: "ap-northeast-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"r5.8xlarge":    {Region: "ap-northeast-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"r5.large":      {Region: "ap-northeast-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"r5.metal":      {Region: "ap-northeast-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.xlarge":     {Region: "ap-northeast-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"r5a.12xlarge":  {Region: "ap-northeast-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.288},
		"r5a.16xlarge":  {Region: "ap-northeast-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.384},
		"r5a.24xlarge":  {Region: "ap-northeast-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.576},
		"r5a.2xlarge":   {Region: "ap-northeast-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.548},
		"r5a.4xlarge":   {Region: "ap-northeast-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.096},
		"r5a.8xlarge":   {Region: "ap-northeast-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.192},
		"r5a.large":     {Region: "ap-northeast-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.137},
		"r5a.xlarge":    {Region: "ap-northeast-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.274},
		"r5ad.12xlarge": {Region: "ap-northeast-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.816},
		"r5ad.16xlarge": {Region: "ap-northeast-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.088},
		"r5ad.24xlarge": {Region: "ap-northeast-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.632},
		"r5ad.2xlarge":  {Region: "ap-northeast-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.636},
		"r5ad.4xlarge":  {Region: "ap-northeast-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.272},
		"r5ad.8xlarge":  {Region: "ap-northeast-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.544},
		"r5ad.large":    {Region: "ap-northeast-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.159},
		"r5ad.xlarge":   {Region: "ap-northeast-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.318},
		"r5b.12xlarge":  {Region: "ap-northeast-1", Type: "r5b.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.344},
		"r5b.16xlarge":  {Region: "ap-northeast-1", Type: "r5b.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"r5b.24xlarge":  {Region: "ap-northeast-1", Type: "r5b.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.688},
		"r5b.2xlarge":   {Region: "ap-northeast-1", Type: "r5b.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.724},
		"r5b.4xlarge":   {Region: "ap-northeast-1", Type: "r5b.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.448},
		"r5b.8xlarge":   {Region: "ap-northeast-1", Type: "r5b.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.896},
		"r5b.large":     {Region: "ap-northeast-1", Type: "r5b.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.181},
		"r5b.metal":     {Region: "ap-northeast-1", Type: "r5b.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.688},
		"r5b.xlarge":    {Region: "ap-northeast-1", Type: "r5b.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.362},
		"r5d.12xlarge":  {Region: "ap-northeast-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.176},
		"r5d.16xlarge":  {Region: "ap-northeast-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.568},
		"r5d.24xlarge":  {Region: "ap-northeast-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.2xlarge":   {Region: "ap-northeast-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.696},
		"r5d.4xlarge":   {Region: "ap-northeast-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.392},
		"r5d.8xlarge":   {Region: "ap-northeast-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.784},
		"r5d.large":     {Region: "ap-northeast-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.174},
		"r5d.metal":     {Region: "ap-northeast-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.xlarge":    {Region: "ap-northeast-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.348},
		"r5dn.12xlarge": {Region: "ap-northeast-1", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.872},
		"r5dn.16xlarge": {Region: "ap-northeast-1", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.496},
		"r5dn.24xlarge": {Region: "ap-northeast-1", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.744},
		"r5dn.2xlarge":  {Region: "ap-northeast-1", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.812},
		"r5dn.4xlarge":  {Region: "ap-northeast-1", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.624},
		"r5dn.8xlarge":  {Region: "ap-northeast-1", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.248},
		"r5dn.large":    {Region: "ap-northeast-1", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.203},
		"r5dn.metal":    {Region: "ap-northeast-1", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.744},
		"r5dn.xlarge":   {Region: "ap-northeast-1", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.406},
		"r5n.12xlarge":  {Region: "ap-northeast-1", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.344},
		"r5n.16xlarge":  {Region: "ap-northeast-1", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"r5n.24xlarge":  {Region: "ap-northeast-1", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.688},
		"r5n.2xlarge":   {Region: "ap-northeast-1", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.724},
		"r5n.4xlarge":   {Region: "ap-northeast-1", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.448},
		"r5n.8xlarge":   {Region: "ap-northeast-1", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.896},
		"r5n.large":     {Region: "ap-northeast-1", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.181},
		"r5n.metal":     {Region: "ap-northeast-1", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.688},
		"r5n.xlarge":    {Region: "ap-northeast-1", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.362},
		"r6g.12xlarge":  {Region: "ap-northeast-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.9184},
		"r6g.16xlarge":  {Region: "ap-northeast-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8912},
		"r6g.2xlarge":   {Region: "ap-northeast-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4864},
		"r6g.4xlarge":   {Region: "ap-northeast-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9728},
		"r6g.8xlarge":   {Region: "ap-northeast-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.9456},
		"r6g.large":     {Region: "ap-northeast-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1216},
		"r6g.medium":    {Region: "ap-northeast-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0608},
		"r6g.metal":     {Region: "ap-northeast-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8912},
		"r6g.xlarge":    {Region: "ap-northeast-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2432},
		"r6gd.12xlarge": {Region: "ap-northeast-1", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.336},
		"r6gd.16xlarge": {Region: "ap-northeast-1", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"r6gd.2xlarge":  {Region: "ap-northeast-1", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.556},
		"r6gd.4xlarge":  {Region: "ap-northeast-1", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.112},
		"r6gd.8xlarge":  {Region: "ap-northeast-1", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.224},
		"r6gd.large":    {Region: "ap-northeast-1", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.139},
		"r6gd.medium":   {Region: "ap-northeast-1", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0695},
		"r6gd.metal":    {Region: "ap-northeast-1", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"r6gd.xlarge":   {Region: "ap-northeast-1", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.278},
		"t1.micro":      {Region: "ap-northeast-1", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.026},
		"t2.2xlarge":    {Region: "ap-northeast-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4864},
		"t2.large":      {Region: "ap-northeast-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1216},
		"t2.medium":     {Region: "ap-northeast-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0608},
		"t2.micro":      {Region: "ap-northeast-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0152},
		"t2.nano":       {Region: "ap-northeast-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0076},
		"t2.small":      {Region: "ap-northeast-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0304},
		"t2.xlarge":     {Region: "ap-northeast-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2432},
		"t3.2xlarge":    {Region: "ap-northeast-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4352},
		"t3.large":      {Region: "ap-northeast-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1088},
		"t3.medium":     {Region: "ap-northeast-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0544},
		"t3.micro":      {Region: "ap-northeast-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0136},
		"t3.nano":       {Region: "ap-northeast-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0068},
		"t3.small":      {Region: "ap-northeast-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0272},
		"t3.xlarge":     {Region: "ap-northeast-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2176},
		"t3a.2xlarge":   {Region: "ap-northeast-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3917},
		"t3a.large":     {Region: "ap-northeast-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0979},
		"t3a.medium":    {Region: "ap-northeast-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.049},
		"t3a.micro":     {Region: "ap-northeast-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0122},
		"t3a.small":     {Region: "ap-northeast-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0245},
		"t3a.xlarge":    {Region: "ap-northeast-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1958},
		"t4g.2xlarge":   {Region: "ap-northeast-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3456},
		"t4g.large":     {Region: "ap-northeast-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0864},
		"t4g.medium":    {Region: "ap-northeast-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0432},
		"t4g.micro":     {Region: "ap-northeast-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0108},
		"t4g.nano":      {Region: "ap-northeast-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0054},
		"t4g.small":     {Region: "ap-northeast-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0216},
		"t4g.xlarge":    {Region: "ap-northeast-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1728},
		"x1.16xlarge":   {Region: "ap-northeast-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.671},
		"x1.32xlarge":   {Region: "ap-northeast-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 19.341},
		"x1e.16xlarge":  {Region: "ap-northeast-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 19.344},
		"x1e.2xlarge":   {Region: "ap-northeast-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.418},
		"x1e.32xlarge":  {Region: "ap-northeast-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 38.688},
		"x1e.4xlarge":   {Region: "ap-northeast-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.836},
		"x1e.8xlarge":   {Region: "ap-northeast-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.672},
		"x1e.xlarge":    {Region: "ap-northeast-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.209},
		"z1d.12xlarge":  {Region: "ap-northeast-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.448},
		"z1d.2xlarge":   {Region: "ap-northeast-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.908},
		"z1d.3xlarge":   {Region: "ap-northeast-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.362},
		"z1d.6xlarge":   {Region: "ap-northeast-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.724},
		"z1d.large":     {Region: "ap-northeast-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.227},
		"z1d.metal":     {Region: "ap-northeast-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.448},
		"z1d.xlarge":    {Region: "ap-northeast-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.454},
	},
	"ap-northeast-2": {
		"c3.2xlarge":    {Region: "ap-northeast-2", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.46},
		"c3.4xlarge":    {Region: "ap-northeast-2", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.919},
		"c3.8xlarge":    {Region: "ap-northeast-2", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.839},
		"c3.large":      {Region: "ap-northeast-2", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"c3.xlarge":     {Region: "ap-northeast-2", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.23},
		"c4.2xlarge":    {Region: "ap-northeast-2", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.454},
		"c4.4xlarge":    {Region: "ap-northeast-2", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.907},
		"c4.8xlarge":    {Region: "ap-northeast-2", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.815},
		"c4.large":      {Region: "ap-northeast-2", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.114},
		"c4.xlarge":     {Region: "ap-northeast-2", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.227},
		"c5.12xlarge":   {Region: "ap-northeast-2", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c5.18xlarge":   {Region: "ap-northeast-2", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.456},
		"c5.24xlarge":   {Region: "ap-northeast-2", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5.2xlarge":    {Region: "ap-northeast-2", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c5.4xlarge":    {Region: "ap-northeast-2", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c5.9xlarge":    {Region: "ap-northeast-2", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.728},
		"c5.large":      {Region: "ap-northeast-2", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c5.metal":      {Region: "ap-northeast-2", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5.xlarge":     {Region: "ap-northeast-2", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"c5a.12xlarge":  {Region: "ap-northeast-2", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"c5a.16xlarge":  {Region: "ap-northeast-2", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"c5a.24xlarge":  {Region: "ap-northeast-2", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"c5a.2xlarge":   {Region: "ap-northeast-2", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"c5a.4xlarge":   {Region: "ap-northeast-2", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"c5a.8xlarge":   {Region: "ap-northeast-2", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"c5a.large":     {Region: "ap-northeast-2", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"c5a.xlarge":    {Region: "ap-northeast-2", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"c5d.12xlarge":  {Region: "ap-northeast-2", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.64},
		"c5d.18xlarge":  {Region: "ap-northeast-2", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.96},
		"c5d.24xlarge":  {Region: "ap-northeast-2", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.28},
		"c5d.2xlarge":   {Region: "ap-northeast-2", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.44},
		"c5d.4xlarge":   {Region: "ap-northeast-2", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.88},
		"c5d.9xlarge":   {Region: "ap-northeast-2", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.98},
		"c5d.large":     {Region: "ap-northeast-2", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.11},
		"c5d.metal":     {Region: "ap-northeast-2", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.28},
		"c5d.xlarge":    {Region: "ap-northeast-2", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.22},
		"c5n.18xlarge":  {Region: "ap-northeast-2", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.392},
		"c5n.2xlarge":   {Region: "ap-northeast-2", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"c5n.4xlarge":   {Region: "ap-northeast-2", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"c5n.9xlarge":   {Region: "ap-northeast-2", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.196},
		"c5n.large":     {Region: "ap-northeast-2", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"c5n.metal":     {Region: "ap-northeast-2", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.392},
		"c5n.xlarge":    {Region: "ap-northeast-2", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"c6g.12xlarge":  {Region: "ap-northeast-2", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"c6g.16xlarge":  {Region: "ap-northeast-2", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"c6g.2xlarge":   {Region: "ap-northeast-2", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"c6g.4xlarge":   {Region: "ap-northeast-2", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"c6g.8xlarge":   {Region: "ap-northeast-2", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"c6g.large":     {Region: "ap-northeast-2", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"c6g.medium":    {Region: "ap-northeast-2", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0385},
		"c6g.metal":     {Region: "ap-northeast-2", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"c6g.xlarge":    {Region: "ap-northeast-2", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"d2.2xlarge":    {Region: "ap-northeast-2", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.688},
		"d2.4xlarge":    {Region: "ap-northeast-2", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.376},
		"d2.8xlarge":    {Region: "ap-northeast-2", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.752},
		"d2.xlarge":     {Region: "ap-northeast-2", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.844},
		"g2.2xlarge":    {Region: "ap-northeast-2", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.898},
		"g2.8xlarge":    {Region: "ap-northeast-2", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 3.592},
		"g3.16xlarge":   {Region: "ap-northeast-2", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 5.68},
		"g3.4xlarge":    {Region: "ap-northeast-2", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.42},
		"g3.8xlarge":    {Region: "ap-northeast-2", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.84},
		"g3s.xlarge":    {Region: "ap-northeast-2", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.934},
		"g4dn.12xlarge": {Region: "ap-northeast-2", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.812},
		"g4dn.16xlarge": {Region: "ap-northeast-2", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.353},
		"g4dn.2xlarge":  {Region: "ap-northeast-2", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.925},
		"g4dn.4xlarge":  {Region: "ap-northeast-2", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.481},
		"g4dn.8xlarge":  {Region: "ap-northeast-2", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.677},
		"g4dn.metal":    {Region: "ap-northeast-2", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.624},
		"g4dn.xlarge":   {Region: "ap-northeast-2", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.647},
		"i2.2xlarge":    {Region: "ap-northeast-2", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.001},
		"i2.4xlarge":    {Region: "ap-northeast-2", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.002},
		"i2.8xlarge":    {Region: "ap-northeast-2", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 8.004},
		"i2.xlarge":     {Region: "ap-northeast-2", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.001},
		"i3.16xlarge":   {Region: "ap-northeast-2", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.856},
		"i3.2xlarge":    {Region: "ap-northeast-2", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.732},
		"i3.4xlarge":    {Region: "ap-northeast-2", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.464},
		"i3.8xlarge":    {Region: "ap-northeast-2", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.928},
		"i3.large":      {Region: "ap-northeast-2", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.183},
		"i3.xlarge":     {Region: "ap-northeast-2", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.366},
		"i3en.12xlarge": {Region: "ap-northeast-2", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.384},
		"i3en.24xlarge": {Region: "ap-northeast-2", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.768},
		"i3en.2xlarge":  {Region: "ap-northeast-2", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.064},
		"i3en.3xlarge":  {Region: "ap-northeast-2", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.596},
		"i3en.6xlarge":  {Region: "ap-northeast-2", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.192},
		"i3en.large":    {Region: "ap-northeast-2", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.266},
		"i3en.metal":    {Region: "ap-northeast-2", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.768},
		"i3en.xlarge":   {Region: "ap-northeast-2", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.532},
		"inf1.24xlarge": {Region: "ap-northeast-2", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 9.374},
		"inf1.2xlarge":  {Region: "ap-northeast-2", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.719},
		"inf1.6xlarge":  {Region: "ap-northeast-2", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.343},
		"inf1.xlarge":   {Region: "ap-northeast-2", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.453},
		"m3.2xlarge":    {Region: "ap-northeast-2", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.732},
		"m3.large":      {Region: "ap-northeast-2", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.183},
		"m3.medium":     {Region: "ap-northeast-2", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.091},
		"m3.xlarge":     {Region: "ap-northeast-2", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.366},
		"m4.10xlarge":   {Region: "ap-northeast-2", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.46},
		"m4.16xlarge":   {Region: "ap-northeast-2", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.936},
		"m4.2xlarge":    {Region: "ap-northeast-2", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.492},
		"m4.4xlarge":    {Region: "ap-northeast-2", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.984},
		"m4.large":      {Region: "ap-northeast-2", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.123},
		"m4.xlarge":     {Region: "ap-northeast-2", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.246},
		"m5.12xlarge":   {Region: "ap-northeast-2", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.832},
		"m5.16xlarge":   {Region: "ap-northeast-2", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.776},
		"m5.24xlarge":   {Region: "ap-northeast-2", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.664},
		"m5.2xlarge":    {Region: "ap-northeast-2", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.472},
		"m5.4xlarge":    {Region: "ap-northeast-2", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.944},
		"m5.8xlarge":    {Region: "ap-northeast-2", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.888},
		"m5.large":      {Region: "ap-northeast-2", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.118},
		"m5.metal":      {Region: "ap-northeast-2", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.664},
		"m5.xlarge":     {Region: "ap-northeast-2", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.236},
		"m5a.12xlarge":  {Region: "ap-northeast-2", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.544},
		"m5a.16xlarge":  {Region: "ap-northeast-2", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.392},
		"m5a.24xlarge":  {Region: "ap-northeast-2", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.088},
		"m5a.2xlarge":   {Region: "ap-northeast-2", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.424},
		"m5a.4xlarge":   {Region: "ap-northeast-2", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.848},
		"m5a.8xlarge":   {Region: "ap-northeast-2", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.696},
		"m5a.large":     {Region: "ap-northeast-2", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.106},
		"m5a.xlarge":    {Region: "ap-northeast-2", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.212},
		"m5ad.12xlarge": {Region: "ap-northeast-2", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.048},
		"m5ad.16xlarge": {Region: "ap-northeast-2", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.064},
		"m5ad.24xlarge": {Region: "ap-northeast-2", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.096},
		"m5ad.2xlarge":  {Region: "ap-northeast-2", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.508},
		"m5ad.4xlarge":  {Region: "ap-northeast-2", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.016},
		"m5ad.8xlarge":  {Region: "ap-northeast-2", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.032},
		"m5ad.large":    {Region: "ap-northeast-2", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.127},
		"m5ad.xlarge":   {Region: "ap-northeast-2", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.254},
		"m5d.12xlarge":  {Region: "ap-northeast-2", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.336},
		"m5d.16xlarge":  {Region: "ap-northeast-2", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"m5d.24xlarge":  {Region: "ap-northeast-2", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.672},
		"m5d.2xlarge":   {Region: "ap-northeast-2", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.556},
		"m5d.4xlarge":   {Region: "ap-northeast-2", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.112},
		"m5d.8xlarge":   {Region: "ap-northeast-2", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.224},
		"m5d.large":     {Region: "ap-northeast-2", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.139},
		"m5d.metal":     {Region: "ap-northeast-2", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.672},
		"m5d.xlarge":    {Region: "ap-northeast-2", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.278},
		"m6g.12xlarge":  {Region: "ap-northeast-2", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.256},
		"m6g.16xlarge":  {Region: "ap-northeast-2", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.008},
		"m6g.2xlarge":   {Region: "ap-northeast-2", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.376},
		"m6g.4xlarge":   {Region: "ap-northeast-2", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.752},
		"m6g.8xlarge":   {Region: "ap-northeast-2", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.504},
		"m6g.large":     {Region: "ap-northeast-2", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.094},
		"m6g.medium":    {Region: "ap-northeast-2", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.047},
		"m6g.metal":     {Region: "ap-northeast-2", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.008},
		"m6g.xlarge":    {Region: "ap-northeast-2", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.188},
		"p2.16xlarge":   {Region: "ap-northeast-2", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 23.44},
		"p2.8xlarge":    {Region: "ap-northeast-2", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 11.72},
		"p2.xlarge":     {Region: "ap-northeast-2", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.465},
		"p3.16xlarge":   {Region: "ap-northeast-2", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 33.872},
		"p3.2xlarge":    {Region: "ap-northeast-2", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 4.234},
		"p3.8xlarge":    {Region: "ap-northeast-2", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 16.936},
		"r3.2xlarge":    {Region: "ap-northeast-2", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.798},
		"r3.4xlarge":    {Region: "ap-northeast-2", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.596},
		"r3.8xlarge":    {Region: "ap-northeast-2", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.192},
		"r3.large":      {Region: "ap-northeast-2", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r3.xlarge":     {Region: "ap-northeast-2", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.399},
		"r4.16xlarge":   {Region: "ap-northeast-2", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.12},
		"r4.2xlarge":    {Region: "ap-northeast-2", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.64},
		"r4.4xlarge":    {Region: "ap-northeast-2", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.28},
		"r4.8xlarge":    {Region: "ap-northeast-2", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.56},
		"r4.large":      {Region: "ap-northeast-2", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.16},
		"r4.xlarge":     {Region: "ap-northeast-2", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.32},
		"r5.12xlarge":   {Region: "ap-northeast-2", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"r5.16xlarge":   {Region: "ap-northeast-2", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"r5.24xlarge":   {Region: "ap-northeast-2", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.2xlarge":    {Region: "ap-northeast-2", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"r5.4xlarge":    {Region: "ap-northeast-2", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"r5.8xlarge":    {Region: "ap-northeast-2", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"r5.large":      {Region: "ap-northeast-2", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"r5.metal":      {Region: "ap-northeast-2", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.xlarge":     {Region: "ap-northeast-2", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"r5a.12xlarge":  {Region: "ap-northeast-2", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"r5a.16xlarge":  {Region: "ap-northeast-2", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"r5a.24xlarge":  {Region: "ap-northeast-2", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"r5a.2xlarge":   {Region: "ap-northeast-2", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"r5a.4xlarge":   {Region: "ap-northeast-2", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"r5a.8xlarge":   {Region: "ap-northeast-2", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"r5a.large":     {Region: "ap-northeast-2", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"r5a.xlarge":    {Region: "ap-northeast-2", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"r5ad.12xlarge": {Region: "ap-northeast-2", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.792},
		"r5ad.16xlarge": {Region: "ap-northeast-2", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.056},
		"r5ad.24xlarge": {Region: "ap-northeast-2", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.584},
		"r5ad.2xlarge":  {Region: "ap-northeast-2", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.632},
		"r5ad.4xlarge":  {Region: "ap-northeast-2", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.264},
		"r5ad.8xlarge":  {Region: "ap-northeast-2", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.528},
		"r5ad.large":    {Region: "ap-northeast-2", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.158},
		"r5ad.xlarge":   {Region: "ap-northeast-2", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.316},
		"r5d.12xlarge":  {Region: "ap-northeast-2", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.152},
		"r5d.16xlarge":  {Region: "ap-northeast-2", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.536},
		"r5d.24xlarge":  {Region: "ap-northeast-2", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.304},
		"r5d.2xlarge":   {Region: "ap-northeast-2", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.692},
		"r5d.4xlarge":   {Region: "ap-northeast-2", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.384},
		"r5d.8xlarge":   {Region: "ap-northeast-2", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.768},
		"r5d.large":     {Region: "ap-northeast-2", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.173},
		"r5d.metal":     {Region: "ap-northeast-2", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.304},
		"r5d.xlarge":    {Region: "ap-northeast-2", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.346},
		"r6g.12xlarge":  {Region: "ap-northeast-2", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.928},
		"r6g.16xlarge":  {Region: "ap-northeast-2", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.904},
		"r6g.2xlarge":   {Region: "ap-northeast-2", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"r6g.4xlarge":   {Region: "ap-northeast-2", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"r6g.8xlarge":   {Region: "ap-northeast-2", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.952},
		"r6g.large":     {Region: "ap-northeast-2", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"r6g.medium":    {Region: "ap-northeast-2", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.061},
		"r6g.metal":     {Region: "ap-northeast-2", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.904},
		"r6g.xlarge":    {Region: "ap-northeast-2", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"t2.2xlarge":    {Region: "ap-northeast-2", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4608},
		"t2.large":      {Region: "ap-northeast-2", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1152},
		"t2.medium":     {Region: "ap-northeast-2", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0576},
		"t2.micro":      {Region: "ap-northeast-2", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0144},
		"t2.nano":       {Region: "ap-northeast-2", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0072},
		"t2.small":      {Region: "ap-northeast-2", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0288},
		"t2.xlarge":     {Region: "ap-northeast-2", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2304},
		"t3.2xlarge":    {Region: "ap-northeast-2", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.416},
		"t3.large":      {Region: "ap-northeast-2", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.104},
		"t3.medium":     {Region: "ap-northeast-2", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.052},
		"t3.micro":      {Region: "ap-northeast-2", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.013},
		"t3.nano":       {Region: "ap-northeast-2", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0065},
		"t3.small":      {Region: "ap-northeast-2", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.026},
		"t3.xlarge":     {Region: "ap-northeast-2", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.208},
		"t3a.2xlarge":   {Region: "ap-northeast-2", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3744},
		"t3a.large":     {Region: "ap-northeast-2", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0936},
		"t3a.medium":    {Region: "ap-northeast-2", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0468},
		"t3a.micro":     {Region: "ap-northeast-2", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0117},
		"t3a.small":     {Region: "ap-northeast-2", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0234},
		"t3a.xlarge":    {Region: "ap-northeast-2", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1872},
		"t4g.2xlarge":   {Region: "ap-northeast-2", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3328},
		"t4g.large":     {Region: "ap-northeast-2", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0832},
		"t4g.medium":    {Region: "ap-northeast-2", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0416},
		"t4g.micro":     {Region: "ap-northeast-2", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0104},
		"t4g.nano":      {Region: "ap-northeast-2", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0052},
		"t4g.small":     {Region: "ap-northeast-2", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0208},
		"t4g.xlarge":    {Region: "ap-northeast-2", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1664},
		"x1.16xlarge":   {Region: "ap-northeast-2", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.671},
		"x1.32xlarge":   {Region: "ap-northeast-2", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 19.341},
		"x1e.16xlarge":  {Region: "ap-northeast-2", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 19.344},
		"x1e.2xlarge":   {Region: "ap-northeast-2", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.418},
		"x1e.32xlarge":  {Region: "ap-northeast-2", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 38.688},
		"x1e.4xlarge":   {Region: "ap-northeast-2", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.836},
		"x1e.8xlarge":   {Region: "ap-northeast-2", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.672},
		"x1e.xlarge":    {Region: "ap-northeast-2", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.209},
		"z1d.12xlarge":  {Region: "ap-northeast-2", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.4},
		"z1d.2xlarge":   {Region: "ap-northeast-2", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.9},
		"z1d.3xlarge":   {Region: "ap-northeast-2", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.35},
		"z1d.6xlarge":   {Region: "ap-northeast-2", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.7},
		"z1d.large":     {Region: "ap-northeast-2", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.225},
		"z1d.metal":     {Region: "ap-northeast-2", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.4},
		"z1d.xlarge":    {Region: "ap-northeast-2", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.45},
	},
	"ap-northeast-3": {
		"c3.2xlarge":    {Region: "ap-northeast-3", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.512},
		"c3.4xlarge":    {Region: "ap-northeast-3", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.024},
		"c3.8xlarge":    {Region: "ap-northeast-3", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.048},
		"c3.large":      {Region: "ap-northeast-3", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.128},
		"c3.xlarge":     {Region: "ap-northeast-3", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.256},
		"c4.2xlarge":    {Region: "ap-northeast-3", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"c4.4xlarge":    {Region: "ap-northeast-3", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"c4.8xlarge":    {Region: "ap-northeast-3", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.016},
		"c4.large":      {Region: "ap-northeast-3", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"c4.xlarge":     {Region: "ap-northeast-3", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"c5.12xlarge":   {Region: "ap-northeast-3", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.568},
		"c5.18xlarge":   {Region: "ap-northeast-3", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.852},
		"c5.24xlarge":   {Region: "ap-northeast-3", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"c5.2xlarge":    {Region: "ap-northeast-3", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.428},
		"c5.4xlarge":    {Region: "ap-northeast-3", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.856},
		"c5.9xlarge":    {Region: "ap-northeast-3", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.926},
		"c5.large":      {Region: "ap-northeast-3", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.107},
		"c5.metal":      {Region: "ap-northeast-3", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"c5.xlarge":     {Region: "ap-northeast-3", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.214},
		"c5d.12xlarge":  {Region: "ap-northeast-3", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.928},
		"c5d.18xlarge":  {Region: "ap-northeast-3", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.392},
		"c5d.24xlarge":  {Region: "ap-northeast-3", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"c5d.2xlarge":   {Region: "ap-northeast-3", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"c5d.4xlarge":   {Region: "ap-northeast-3", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"c5d.9xlarge":   {Region: "ap-northeast-3", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.196},
		"c5d.large":     {Region: "ap-northeast-3", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"c5d.metal":     {Region: "ap-northeast-3", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"c5d.xlarge":    {Region: "ap-northeast-3", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"d2.2xlarge":    {Region: "ap-northeast-3", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.688},
		"d2.4xlarge":    {Region: "ap-northeast-3", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.376},
		"d2.8xlarge":    {Region: "ap-northeast-3", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.752},
		"d2.xlarge":     {Region: "ap-northeast-3", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.844},
		"i3.16xlarge":   {Region: "ap-northeast-3", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.856},
		"i3.2xlarge":    {Region: "ap-northeast-3", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.732},
		"i3.4xlarge":    {Region: "ap-northeast-3", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.464},
		"i3.8xlarge":    {Region: "ap-northeast-3", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.928},
		"i3.large":      {Region: "ap-northeast-3", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.183},
		"i3.xlarge":     {Region: "ap-northeast-3", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.366},
		"i3en.12xlarge": {Region: "ap-northeast-3", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.384},
		"i3en.24xlarge": {Region: "ap-northeast-3", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.768},
		"i3en.2xlarge":  {Region: "ap-northeast-3", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.064},
		"i3en.3xlarge":  {Region: "ap-northeast-3", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.596},
		"i3en.6xlarge":  {Region: "ap-northeast-3", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.192},
		"i3en.large":    {Region: "ap-northeast-3", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.266},
		"i3en.metal":    {Region: "ap-northeast-3", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.768},
		"i3en.xlarge":   {Region: "ap-northeast-3", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.532},
		"m3.2xlarge":    {Region: "ap-northeast-3", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.768},
		"m3.large":      {Region: "ap-northeast-3", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.192},
		"m3.medium":     {Region: "ap-northeast-3", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.096},
		"m3.xlarge":     {Region: "ap-northeast-3", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.384},
		"m4.10xlarge":   {Region: "ap-northeast-3", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.58},
		"m4.16xlarge":   {Region: "ap-northeast-3", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.128},
		"m4.2xlarge":    {Region: "ap-northeast-3", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.516},
		"m4.4xlarge":    {Region: "ap-northeast-3", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.032},
		"m4.large":      {Region: "ap-northeast-3", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.129},
		"m4.xlarge":     {Region: "ap-northeast-3", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.258},
		"m5.12xlarge":   {Region: "ap-northeast-3", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.976},
		"m5.16xlarge":   {Region: "ap-northeast-3", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.968},
		"m5.24xlarge":   {Region: "ap-northeast-3", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.952},
		"m5.2xlarge":    {Region: "ap-northeast-3", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.496},
		"m5.4xlarge":    {Region: "ap-northeast-3", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.992},
		"m5.8xlarge":    {Region: "ap-northeast-3", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.984},
		"m5.large":      {Region: "ap-northeast-3", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.124},
		"m5.metal":      {Region: "ap-northeast-3", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.952},
		"m5.xlarge":     {Region: "ap-northeast-3", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.248},
		"m5d.12xlarge":  {Region: "ap-northeast-3", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.504},
		"m5d.16xlarge":  {Region: "ap-northeast-3", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.672},
		"m5d.24xlarge":  {Region: "ap-northeast-3", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"m5d.2xlarge":   {Region: "ap-northeast-3", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.584},
		"m5d.4xlarge":   {Region: "ap-northeast-3", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.168},
		"m5d.8xlarge":   {Region: "ap-northeast-3", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.336},
		"m5d.large":     {Region: "ap-northeast-3", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.146},
		"m5d.metal":     {Region: "ap-northeast-3", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"m5d.xlarge":    {Region: "ap-northeast-3", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.292},
		"r3.2xlarge":    {Region: "ap-northeast-3", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.8},
		"r3.4xlarge":    {Region: "ap-northeast-3", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.6},
		"r3.8xlarge":    {Region: "ap-northeast-3", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.2},
		"r3.large":      {Region: "ap-northeast-3", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r3.xlarge":     {Region: "ap-northeast-3", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.4},
		"r4.16xlarge":   {Region: "ap-northeast-3", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.12},
		"r4.2xlarge":    {Region: "ap-northeast-3", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.64},
		"r4.4xlarge":    {Region: "ap-northeast-3", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.28},
		"r4.8xlarge":    {Region: "ap-northeast-3", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.56},
		"r4.large":      {Region: "ap-northeast-3", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.16},
		"r4.xlarge":     {Region: "ap-northeast-3", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.32},
		"r5.12xlarge":   {Region: "ap-northeast-3", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"r5.16xlarge":   {Region: "ap-northeast-3", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"r5.24xlarge":   {Region: "ap-northeast-3", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.2xlarge":    {Region: "ap-northeast-3", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"r5.4xlarge":    {Region: "ap-northeast-3", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"r5.8xlarge":    {Region: "ap-northeast-3", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"r5.large":      {Region: "ap-northeast-3", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"r5.metal":      {Region: "ap-northeast-3", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.xlarge":     {Region: "ap-northeast-3", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"r5d.12xlarge":  {Region: "ap-northeast-3", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.176},
		"r5d.16xlarge":  {Region: "ap-northeast-3", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.568},
		"r5d.24xlarge":  {Region: "ap-northeast-3", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.2xlarge":   {Region: "ap-northeast-3", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.696},
		"r5d.4xlarge":   {Region: "ap-northeast-3", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.392},
		"r5d.8xlarge":   {Region: "ap-northeast-3", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.784},
		"r5d.large":     {Region: "ap-northeast-3", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.174},
		"r5d.metal":     {Region: "ap-northeast-3", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.xlarge":    {Region: "ap-northeast-3", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.348},
		"t2.2xlarge":    {Region: "ap-northeast-3", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4864},
		"t2.large":      {Region: "ap-northeast-3", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1216},
		"t2.medium":     {Region: "ap-northeast-3", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0608},
		"t2.micro":      {Region: "ap-northeast-3", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0152},
		"t2.nano":       {Region: "ap-northeast-3", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0076},
		"t2.small":      {Region: "ap-northeast-3", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0304},
		"t2.xlarge":     {Region: "ap-northeast-3", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2432},
		"t3.2xlarge":    {Region: "ap-northeast-3", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4352},
		"t3.large":      {Region: "ap-northeast-3", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1088},
		"t3.medium":     {Region: "ap-northeast-3", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0544},
		"t3.micro":      {Region: "ap-northeast-3", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0136},
		"t3.nano":       {Region: "ap-northeast-3", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0068},
		"t3.small":      {Region: "ap-northeast-3", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0272},
		"t3.xlarge":     {Region: "ap-northeast-3", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2176},
		"x1.16xlarge":   {Region: "ap-northeast-3", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.671},
		"x1.32xlarge":   {Region: "ap-northeast-3", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 19.342},
		"x1e.16xlarge":  {Region: "ap-northeast-3", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 19.344},
		"x1e.2xlarge":   {Region: "ap-northeast-3", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.418},
		"x1e.32xlarge":  {Region: "ap-northeast-3", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 38.688},
		"x1e.4xlarge":   {Region: "ap-northeast-3", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.836},
		"x1e.8xlarge":   {Region: "ap-northeast-3", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.672},
		"x1e.xlarge":    {Region: "ap-northeast-3", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.209},
	},
	"ap-south-1": {
		"a1.4xlarge":    {Region: "ap-south-1", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.large":      {Region: "ap-south-1", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.051},
		"a1.medium":     {Region: "ap-south-1", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0255},
		"a1.metal":      {Region: "ap-south-1", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.xlarge":     {Region: "ap-south-1", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.102},
		"c4.2xlarge":    {Region: "ap-south-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"c4.4xlarge":    {Region: "ap-south-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"c4.8xlarge":    {Region: "ap-south-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.6},
		"c4.large":      {Region: "ap-south-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"c4.xlarge":     {Region: "ap-south-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"c5.12xlarge":   {Region: "ap-south-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.04},
		"c5.18xlarge":   {Region: "ap-south-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.06},
		"c5.24xlarge":   {Region: "ap-south-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.2xlarge":    {Region: "ap-south-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.34},
		"c5.4xlarge":    {Region: "ap-south-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.68},
		"c5.9xlarge":    {Region: "ap-south-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.53},
		"c5.large":      {Region: "ap-south-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.085},
		"c5.metal":      {Region: "ap-south-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.xlarge":     {Region: "ap-south-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.17},
		"c5a.12xlarge":  {Region: "ap-south-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.128},
		"c5a.16xlarge":  {Region: "ap-south-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 1.504},
		"c5a.24xlarge":  {Region: "ap-south-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 2.256},
		"c5a.2xlarge":   {Region: "ap-south-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.188},
		"c5a.4xlarge":   {Region: "ap-south-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.376},
		"c5a.8xlarge":   {Region: "ap-south-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 0.752},
		"c5a.large":     {Region: "ap-south-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.047},
		"c5a.xlarge":    {Region: "ap-south-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.094},
		"c5d.12xlarge":  {Region: "ap-south-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.376},
		"c5d.18xlarge":  {Region: "ap-south-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.564},
		"c5d.24xlarge":  {Region: "ap-south-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.752},
		"c5d.2xlarge":   {Region: "ap-south-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.396},
		"c5d.4xlarge":   {Region: "ap-south-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.792},
		"c5d.9xlarge":   {Region: "ap-south-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.782},
		"c5d.large":     {Region: "ap-south-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.099},
		"c5d.metal":     {Region: "ap-south-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.752},
		"c5d.xlarge":    {Region: "ap-south-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.198},
		"c5n.18xlarge":  {Region: "ap-south-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.2xlarge":   {Region: "ap-south-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"c5n.4xlarge":   {Region: "ap-south-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"c5n.9xlarge":   {Region: "ap-south-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.944},
		"c5n.large":     {Region: "ap-south-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"c5n.metal":     {Region: "ap-south-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.xlarge":    {Region: "ap-south-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"c6g.12xlarge":  {Region: "ap-south-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.0224},
		"c6g.16xlarge":  {Region: "ap-south-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 1.3632},
		"c6g.2xlarge":   {Region: "ap-south-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.1704},
		"c6g.4xlarge":   {Region: "ap-south-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.3408},
		"c6g.8xlarge":   {Region: "ap-south-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 0.6816},
		"c6g.large":     {Region: "ap-south-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0426},
		"c6g.medium":    {Region: "ap-south-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0213},
		"c6g.metal":     {Region: "ap-south-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 1.3632},
		"c6g.xlarge":    {Region: "ap-south-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.0852},
		"d2.2xlarge":    {Region: "ap-south-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.653},
		"d2.4xlarge":    {Region: "ap-south-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.306},
		"d2.8xlarge":    {Region: "ap-south-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.612},
		"d2.xlarge":     {Region: "ap-south-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.827},
		"g4dn.12xlarge": {Region: "ap-south-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.306},
		"g4dn.16xlarge": {Region: "ap-south-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.791},
		"g4dn.2xlarge":  {Region: "ap-south-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.828},
		"g4dn.4xlarge":  {Region: "ap-south-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.325},
		"g4dn.8xlarge":  {Region: "ap-south-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.395},
		"g4dn.metal":    {Region: "ap-south-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 8.612},
		"g4dn.xlarge":   {Region: "ap-south-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.579},
		"i2.2xlarge":    {Region: "ap-south-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.933},
		"i2.4xlarge":    {Region: "ap-south-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.867},
		"i2.8xlarge":    {Region: "ap-south-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 7.733},
		"i2.xlarge":     {Region: "ap-south-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.967},
		"i3.16xlarge":   {Region: "ap-south-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.664},
		"i3.2xlarge":    {Region: "ap-south-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.708},
		"i3.4xlarge":    {Region: "ap-south-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.416},
		"i3.8xlarge":    {Region: "ap-south-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.832},
		"i3.large":      {Region: "ap-south-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.177},
		"i3.xlarge":     {Region: "ap-south-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.354},
		"i3en.12xlarge": {Region: "ap-south-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.168},
		"i3en.24xlarge": {Region: "ap-south-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.336},
		"i3en.2xlarge":  {Region: "ap-south-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.028},
		"i3en.3xlarge":  {Region: "ap-south-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.542},
		"i3en.6xlarge":  {Region: "ap-south-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.084},
		"i3en.large":    {Region: "ap-south-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.257},
		"i3en.metal":    {Region: "ap-south-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.336},
		"i3en.xlarge":   {Region: "ap-south-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.514},
		"inf1.24xlarge": {Region: "ap-south-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 8.008},
		"inf1.2xlarge":  {Region: "ap-south-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.614},
		"inf1.6xlarge":  {Region: "ap-south-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.002},
		"inf1.xlarge":   {Region: "ap-south-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.387},
		"m4.10xlarge":   {Region: "ap-south-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.1},
		"m4.16xlarge":   {Region: "ap-south-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.36},
		"m4.2xlarge":    {Region: "ap-south-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.42},
		"m4.4xlarge":    {Region: "ap-south-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.84},
		"m4.large":      {Region: "ap-south-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.105},
		"m4.xlarge":     {Region: "ap-south-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.21},
		"m5.12xlarge":   {Region: "ap-south-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"m5.16xlarge":   {Region: "ap-south-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.232},
		"m5.24xlarge":   {Region: "ap-south-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"m5.2xlarge":    {Region: "ap-south-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"m5.4xlarge":    {Region: "ap-south-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"m5.8xlarge":    {Region: "ap-south-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.616},
		"m5.large":      {Region: "ap-south-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"m5.metal":      {Region: "ap-south-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"m5.xlarge":     {Region: "ap-south-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"m5a.12xlarge":  {Region: "ap-south-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.333},
		"m5a.16xlarge":  {Region: "ap-south-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 1.778},
		"m5a.24xlarge":  {Region: "ap-south-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 2.666},
		"m5a.2xlarge":   {Region: "ap-south-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.222},
		"m5a.4xlarge":   {Region: "ap-south-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.444},
		"m5a.8xlarge":   {Region: "ap-south-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 0.889},
		"m5a.large":     {Region: "ap-south-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.056},
		"m5a.xlarge":    {Region: "ap-south-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.111},
		"m5ad.12xlarge": {Region: "ap-south-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.61},
		"m5ad.16xlarge": {Region: "ap-south-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.147},
		"m5ad.24xlarge": {Region: "ap-south-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.221},
		"m5ad.2xlarge":  {Region: "ap-south-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.268},
		"m5ad.4xlarge":  {Region: "ap-south-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.537},
		"m5ad.8xlarge":  {Region: "ap-south-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.074},
		"m5ad.large":    {Region: "ap-south-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.067},
		"m5ad.xlarge":   {Region: "ap-south-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.134},
		"m5d.12xlarge":  {Region: "ap-south-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.928},
		"m5d.16xlarge":  {Region: "ap-south-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.904},
		"m5d.24xlarge":  {Region: "ap-south-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"m5d.2xlarge":   {Region: "ap-south-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"m5d.4xlarge":   {Region: "ap-south-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"m5d.8xlarge":   {Region: "ap-south-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.952},
		"m5d.large":     {Region: "ap-south-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"m5d.metal":     {Region: "ap-south-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"m5d.xlarge":    {Region: "ap-south-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"m6g.12xlarge":  {Region: "ap-south-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.2144},
		"m6g.16xlarge":  {Region: "ap-south-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 1.6192},
		"m6g.2xlarge":   {Region: "ap-south-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2024},
		"m6g.4xlarge":   {Region: "ap-south-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.4048},
		"m6g.8xlarge":   {Region: "ap-south-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 0.8096},
		"m6g.large":     {Region: "ap-south-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0506},
		"m6g.medium":    {Region: "ap-south-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0253},
		"m6g.metal":     {Region: "ap-south-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 1.6192},
		"m6g.xlarge":    {Region: "ap-south-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1012},
		"p2.16xlarge":   {Region: "ap-south-1", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 27.488},
		"p2.8xlarge":    {Region: "ap-south-1", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 13.744},
		"p2.xlarge":     {Region: "ap-south-1", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.718},
		"r3.2xlarge":    {Region: "ap-south-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.758},
		"r3.4xlarge":    {Region: "ap-south-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.516},
		"r3.8xlarge":    {Region: "ap-south-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.032},
		"r3.large":      {Region: "ap-south-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.19},
		"r3.xlarge":     {Region: "ap-south-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.379},
		"r4.16xlarge":   {Region: "ap-south-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.384},
		"r4.2xlarge":    {Region: "ap-south-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.548},
		"r4.4xlarge":    {Region: "ap-south-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.096},
		"r4.8xlarge":    {Region: "ap-south-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.192},
		"r4.large":      {Region: "ap-south-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.137},
		"r4.xlarge":     {Region: "ap-south-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.274},
		"r5.12xlarge":   {Region: "ap-south-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.12},
		"r5.16xlarge":   {Region: "ap-south-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.16},
		"r5.24xlarge":   {Region: "ap-south-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.24},
		"r5.2xlarge":    {Region: "ap-south-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.52},
		"r5.4xlarge":    {Region: "ap-south-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.04},
		"r5.8xlarge":    {Region: "ap-south-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.08},
		"r5.large":      {Region: "ap-south-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"r5.metal":      {Region: "ap-south-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.24},
		"r5.xlarge":     {Region: "ap-south-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.26},
		"r5a.12xlarge":  {Region: "ap-south-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.716},
		"r5a.16xlarge":  {Region: "ap-south-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.288},
		"r5a.24xlarge":  {Region: "ap-south-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.432},
		"r5a.2xlarge":   {Region: "ap-south-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.286},
		"r5a.4xlarge":   {Region: "ap-south-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.572},
		"r5a.8xlarge":   {Region: "ap-south-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.144},
		"r5a.large":     {Region: "ap-south-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.072},
		"r5a.xlarge":    {Region: "ap-south-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.143},
		"r5ad.12xlarge": {Region: "ap-south-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.993},
		"r5ad.16xlarge": {Region: "ap-south-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.658},
		"r5ad.24xlarge": {Region: "ap-south-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.986},
		"r5ad.2xlarge":  {Region: "ap-south-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.332},
		"r5ad.4xlarge":  {Region: "ap-south-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.664},
		"r5ad.8xlarge":  {Region: "ap-south-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.329},
		"r5ad.large":    {Region: "ap-south-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.083},
		"r5ad.xlarge":   {Region: "ap-south-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.166},
		"r5d.12xlarge":  {Region: "ap-south-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.624},
		"r5d.16xlarge":  {Region: "ap-south-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.832},
		"r5d.24xlarge":  {Region: "ap-south-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.248},
		"r5d.2xlarge":   {Region: "ap-south-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.604},
		"r5d.4xlarge":   {Region: "ap-south-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.208},
		"r5d.8xlarge":   {Region: "ap-south-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.416},
		"r5d.large":     {Region: "ap-south-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.151},
		"r5d.metal":     {Region: "ap-south-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.248},
		"r5d.xlarge":    {Region: "ap-south-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.302},
		"r6g.12xlarge":  {Region: "ap-south-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.56},
		"r6g.16xlarge":  {Region: "ap-south-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.08},
		"r6g.2xlarge":   {Region: "ap-south-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.26},
		"r6g.4xlarge":   {Region: "ap-south-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.52},
		"r6g.8xlarge":   {Region: "ap-south-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.04},
		"r6g.large":     {Region: "ap-south-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.065},
		"r6g.medium":    {Region: "ap-south-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0325},
		"r6g.metal":     {Region: "ap-south-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.08},
		"r6g.xlarge":    {Region: "ap-south-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.13},
		"t2.2xlarge":    {Region: "ap-south-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3968},
		"t2.large":      {Region: "ap-south-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0992},
		"t2.medium":     {Region: "ap-south-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0496},
		"t2.micro":      {Region: "ap-south-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0124},
		"t2.nano":       {Region: "ap-south-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0062},
		"t2.small":      {Region: "ap-south-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0248},
		"t2.xlarge":     {Region: "ap-south-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1984},
		"t3.2xlarge":    {Region: "ap-south-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3584},
		"t3.large":      {Region: "ap-south-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0896},
		"t3.medium":     {Region: "ap-south-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0448},
		"t3.micro":      {Region: "ap-south-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0112},
		"t3.nano":       {Region: "ap-south-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0056},
		"t3.small":      {Region: "ap-south-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0224},
		"t3.xlarge":     {Region: "ap-south-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1792},
		"t3a.2xlarge":   {Region: "ap-south-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.1971},
		"t3a.large":     {Region: "ap-south-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0493},
		"t3a.medium":    {Region: "ap-south-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0246},
		"t3a.micro":     {Region: "ap-south-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0062},
		"t3a.small":     {Region: "ap-south-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0123},
		"t3a.xlarge":    {Region: "ap-south-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.0986},
		"t4g.2xlarge":   {Region: "ap-south-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.1792},
		"t4g.large":     {Region: "ap-south-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0448},
		"t4g.medium":    {Region: "ap-south-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0224},
		"t4g.micro":     {Region: "ap-south-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0056},
		"t4g.nano":      {Region: "ap-south-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0028},
		"t4g.small":     {Region: "ap-south-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0112},
		"t4g.xlarge":    {Region: "ap-south-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.0896},
		"x1.16xlarge":   {Region: "ap-south-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.881},
		"x1.32xlarge":   {Region: "ap-south-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 13.762},
		"x1e.16xlarge":  {Region: "ap-south-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.76},
		"x1e.2xlarge":   {Region: "ap-south-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.72},
		"x1e.32xlarge":  {Region: "ap-south-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 27.52},
		"x1e.4xlarge":   {Region: "ap-south-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.44},
		"x1e.8xlarge":   {Region: "ap-south-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.88},
		"x1e.xlarge":    {Region: "ap-south-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.86},
		"z1d.12xlarge":  {Region: "ap-south-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.704},
		"z1d.2xlarge":   {Region: "ap-south-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.784},
		"z1d.3xlarge":   {Region: "ap-south-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.176},
		"z1d.6xlarge":   {Region: "ap-south-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.352},
		"z1d.large":     {Region: "ap-south-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.196},
		"z1d.metal":     {Region: "ap-south-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.704},
		"z1d.xlarge":    {Region: "ap-south-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.392},
	},
	"ap-southeast-1": {
		"a1.4xlarge":    {Region: "ap-southeast-1", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.4704},
		"a1.large":      {Region: "ap-southeast-1", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0588},
		"a1.medium":     {Region: "ap-southeast-1", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0294},
		"a1.metal":      {Region: "ap-southeast-1", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.47},
		"a1.xlarge":     {Region: "ap-southeast-1", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1176},
		"c1.medium":     {Region: "ap-southeast-1", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.164},
		"c1.xlarge":     {Region: "ap-southeast-1", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.655},
		"c3.2xlarge":    {Region: "ap-southeast-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.529},
		"c3.4xlarge":    {Region: "ap-southeast-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.058},
		"c3.8xlarge":    {Region: "ap-southeast-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.117},
		"c3.large":      {Region: "ap-southeast-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.132},
		"c3.xlarge":     {Region: "ap-southeast-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.265},
		"c4.2xlarge":    {Region: "ap-southeast-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.462},
		"c4.4xlarge":    {Region: "ap-southeast-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.924},
		"c4.8xlarge":    {Region: "ap-southeast-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.848},
		"c4.large":      {Region: "ap-southeast-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"c4.xlarge":     {Region: "ap-southeast-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.231},
		"c5.12xlarge":   {Region: "ap-southeast-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.352},
		"c5.18xlarge":   {Region: "ap-southeast-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.528},
		"c5.24xlarge":   {Region: "ap-southeast-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.704},
		"c5.2xlarge":    {Region: "ap-southeast-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.392},
		"c5.4xlarge":    {Region: "ap-southeast-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.784},
		"c5.9xlarge":    {Region: "ap-southeast-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.764},
		"c5.large":      {Region: "ap-southeast-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.098},
		"c5.metal":      {Region: "ap-southeast-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.704},
		"c5.xlarge":     {Region: "ap-southeast-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.196},
		"c5a.12xlarge":  {Region: "ap-southeast-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.112},
		"c5a.16xlarge":  {Region: "ap-southeast-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.816},
		"c5a.24xlarge":  {Region: "ap-southeast-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.224},
		"c5a.2xlarge":   {Region: "ap-southeast-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.352},
		"c5a.4xlarge":   {Region: "ap-southeast-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.704},
		"c5a.8xlarge":   {Region: "ap-southeast-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.408},
		"c5a.large":     {Region: "ap-southeast-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.088},
		"c5a.xlarge":    {Region: "ap-southeast-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.176},
		"c5ad.12xlarge": {Region: "ap-southeast-1", Type: "c5ad.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"c5ad.16xlarge": {Region: "ap-southeast-1", Type: "c5ad.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.232},
		"c5ad.24xlarge": {Region: "ap-southeast-1", Type: "c5ad.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5ad.2xlarge":  {Region: "ap-southeast-1", Type: "c5ad.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"c5ad.4xlarge":  {Region: "ap-southeast-1", Type: "c5ad.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"c5ad.8xlarge":  {Region: "ap-southeast-1", Type: "c5ad.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.616},
		"c5ad.large":    {Region: "ap-southeast-1", Type: "c5ad.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"c5ad.xlarge":   {Region: "ap-southeast-1", Type: "c5ad.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"c5d.12xlarge":  {Region: "ap-southeast-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.688},
		"c5d.18xlarge":  {Region: "ap-southeast-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.032},
		"c5d.24xlarge":  {Region: "ap-southeast-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"c5d.2xlarge":   {Region: "ap-southeast-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.448},
		"c5d.4xlarge":   {Region: "ap-southeast-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.896},
		"c5d.9xlarge":   {Region: "ap-southeast-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.016},
		"c5d.large":     {Region: "ap-southeast-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.112},
		"c5d.metal":     {Region: "ap-southeast-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"c5d.xlarge":    {Region: "ap-southeast-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.224},
		"c5n.18xlarge":  {Region: "ap-southeast-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.464},
		"c5n.2xlarge":   {Region: "ap-southeast-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.496},
		"c5n.4xlarge":   {Region: "ap-southeast-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.992},
		"c5n.9xlarge":   {Region: "ap-southeast-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.232},
		"c5n.large":     {Region: "ap-southeast-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.124},
		"c5n.metal":     {Region: "ap-southeast-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.464},
		"c5n.xlarge":    {Region: "ap-southeast-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.248},
		"c6g.12xlarge":  {Region: "ap-southeast-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.8816},
		"c6g.16xlarge":  {Region: "ap-southeast-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.5088},
		"c6g.2xlarge":   {Region: "ap-southeast-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3136},
		"c6g.4xlarge":   {Region: "ap-southeast-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6272},
		"c6g.8xlarge":   {Region: "ap-southeast-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2544},
		"c6g.large":     {Region: "ap-southeast-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0784},
		"c6g.medium":    {Region: "ap-southeast-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0392},
		"c6g.metal":     {Region: "ap-southeast-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.5088},
		"c6g.xlarge":    {Region: "ap-southeast-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1568},
		"c6gd.12xlarge": {Region: "ap-southeast-1", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.16},
		"c6gd.16xlarge": {Region: "ap-southeast-1", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.88},
		"c6gd.2xlarge":  {Region: "ap-southeast-1", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.36},
		"c6gd.4xlarge":  {Region: "ap-southeast-1", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.72},
		"c6gd.8xlarge":  {Region: "ap-southeast-1", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.44},
		"c6gd.large":    {Region: "ap-southeast-1", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.09},
		"c6gd.medium":   {Region: "ap-southeast-1", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.045},
		"c6gd.metal":    {Region: "ap-southeast-1", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.88},
		"c6gd.xlarge":   {Region: "ap-southeast-1", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.18},
		"d2.2xlarge":    {Region: "ap-southeast-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.74},
		"d2.4xlarge":    {Region: "ap-southeast-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.48},
		"d2.8xlarge":    {Region: "ap-southeast-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.96},
		"d2.xlarge":     {Region: "ap-southeast-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.87},
		"g2.2xlarge":    {Region: "ap-southeast-1", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 1.0},
		"g2.8xlarge":    {Region: "ap-southeast-1", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 4.0},
		"g3.16xlarge":   {Region: "ap-southeast-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 6.68},
		"g3.4xlarge":    {Region: "ap-southeast-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.67},
		"g3.8xlarge":    {Region: "ap-southeast-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 3.34},
		"g4dn.12xlarge": {Region: "ap-southeast-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 5.474},
		"g4dn.16xlarge": {Region: "ap-southeast-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 6.089},
		"g4dn.2xlarge":  {Region: "ap-southeast-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 1.052},
		"g4dn.4xlarge":  {Region: "ap-southeast-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.685},
		"g4dn.8xlarge":  {Region: "ap-southeast-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 3.045},
		"g4dn.metal":    {Region: "ap-southeast-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 10.948},
		"g4dn.xlarge":   {Region: "ap-southeast-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.736},
		"hs1.8xlarge":   {Region: "ap-southeast-1", Type: "hs1.8xlarge", Memory: kresource.MustParse("119808Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 5.57},
		"i2.2xlarge":    {Region: "ap-southeast-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.035},
		"i2.4xlarge":    {Region: "ap-southeast-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.07},
		"i2.8xlarge":    {Region: "ap-southeast-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 8.14},
		"i2.xlarge":     {Region: "ap-southeast-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.018},
		"i3.16xlarge":   {Region: "ap-southeast-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.984},
		"i3.2xlarge":    {Region: "ap-southeast-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.748},
		"i3.4xlarge":    {Region: "ap-southeast-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.496},
		"i3.8xlarge":    {Region: "ap-southeast-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.992},
		"i3.large":      {Region: "ap-southeast-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.187},
		"i3.xlarge":     {Region: "ap-southeast-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.374},
		"i3en.12xlarge": {Region: "ap-southeast-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.504},
		"i3en.24xlarge": {Region: "ap-southeast-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 13.008},
		"i3en.2xlarge":  {Region: "ap-southeast-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.084},
		"i3en.3xlarge":  {Region: "ap-southeast-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.626},
		"i3en.6xlarge":  {Region: "ap-southeast-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.252},
		"i3en.large":    {Region: "ap-southeast-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.271},
		"i3en.xlarge":   {Region: "ap-southeast-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.542},
		"inf1.24xlarge": {Region: "ap-southeast-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 10.284},
		"inf1.2xlarge":  {Region: "ap-southeast-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.789},
		"inf1.6xlarge":  {Region: "ap-southeast-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.571},
		"inf1.xlarge":   {Region: "ap-southeast-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.497},
		"m1.large":      {Region: "ap-southeast-1", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.233},
		"m1.medium":     {Region: "ap-southeast-1", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.117},
		"m1.small":      {Region: "ap-southeast-1", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.058},
		"m1.xlarge":     {Region: "ap-southeast-1", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.467},
		"m2.2xlarge":    {Region: "ap-southeast-1", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.592},
		"m2.4xlarge":    {Region: "ap-southeast-1", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.183},
		"m2.xlarge":     {Region: "ap-southeast-1", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.296},
		"m3.2xlarge":    {Region: "ap-southeast-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.784},
		"m3.large":      {Region: "ap-southeast-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.196},
		"m3.medium":     {Region: "ap-southeast-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.098},
		"m3.xlarge":     {Region: "ap-southeast-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.392},
		"m4.10xlarge":   {Region: "ap-southeast-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.5},
		"m4.16xlarge":   {Region: "ap-southeast-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.0},
		"m4.2xlarge":    {Region: "ap-southeast-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5},
		"m4.4xlarge":    {Region: "ap-southeast-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.0},
		"m4.large":      {Region: "ap-southeast-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.125},
		"m4.xlarge":     {Region: "ap-southeast-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.25},
		"m5.12xlarge":   {Region: "ap-southeast-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.88},
		"m5.16xlarge":   {Region: "ap-southeast-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.84},
		"m5.24xlarge":   {Region: "ap-southeast-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5.2xlarge":    {Region: "ap-southeast-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"m5.4xlarge":    {Region: "ap-southeast-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.96},
		"m5.8xlarge":    {Region: "ap-southeast-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.92},
		"m5.large":      {Region: "ap-southeast-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"m5.metal":      {Region: "ap-southeast-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5.xlarge":     {Region: "ap-southeast-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"m5a.12xlarge":  {Region: "ap-southeast-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.592},
		"m5a.16xlarge":  {Region: "ap-southeast-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.456},
		"m5a.24xlarge":  {Region: "ap-southeast-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.184},
		"m5a.2xlarge":   {Region: "ap-southeast-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"m5a.4xlarge":   {Region: "ap-southeast-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"m5a.8xlarge":   {Region: "ap-southeast-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.728},
		"m5a.large":     {Region: "ap-southeast-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"m5a.xlarge":    {Region: "ap-southeast-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"m5ad.12xlarge": {Region: "ap-southeast-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.096},
		"m5ad.16xlarge": {Region: "ap-southeast-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.128},
		"m5ad.24xlarge": {Region: "ap-southeast-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.192},
		"m5ad.2xlarge":  {Region: "ap-southeast-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.516},
		"m5ad.4xlarge":  {Region: "ap-southeast-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.032},
		"m5ad.8xlarge":  {Region: "ap-southeast-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.064},
		"m5ad.large":    {Region: "ap-southeast-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.129},
		"m5ad.xlarge":   {Region: "ap-southeast-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.258},
		"m5d.12xlarge":  {Region: "ap-southeast-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.384},
		"m5d.16xlarge":  {Region: "ap-southeast-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.512},
		"m5d.24xlarge":  {Region: "ap-southeast-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.768},
		"m5d.2xlarge":   {Region: "ap-southeast-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.564},
		"m5d.4xlarge":   {Region: "ap-southeast-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.128},
		"m5d.8xlarge":   {Region: "ap-southeast-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.256},
		"m5d.large":     {Region: "ap-southeast-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.141},
		"m5d.metal":     {Region: "ap-southeast-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.768},
		"m5d.xlarge":    {Region: "ap-southeast-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.282},
		"m5dn.12xlarge": {Region: "ap-southeast-1", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.008},
		"m5dn.16xlarge": {Region: "ap-southeast-1", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.344},
		"m5dn.24xlarge": {Region: "ap-southeast-1", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"m5dn.2xlarge":  {Region: "ap-southeast-1", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.668},
		"m5dn.4xlarge":  {Region: "ap-southeast-1", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.336},
		"m5dn.8xlarge":  {Region: "ap-southeast-1", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.672},
		"m5dn.large":    {Region: "ap-southeast-1", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.167},
		"m5dn.metal":    {Region: "ap-southeast-1", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"m5dn.xlarge":   {Region: "ap-southeast-1", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.334},
		"m5n.12xlarge":  {Region: "ap-southeast-1", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.504},
		"m5n.16xlarge":  {Region: "ap-southeast-1", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.672},
		"m5n.24xlarge":  {Region: "ap-southeast-1", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"m5n.2xlarge":   {Region: "ap-southeast-1", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.584},
		"m5n.4xlarge":   {Region: "ap-southeast-1", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.168},
		"m5n.8xlarge":   {Region: "ap-southeast-1", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.336},
		"m5n.large":     {Region: "ap-southeast-1", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.146},
		"m5n.metal":     {Region: "ap-southeast-1", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"m5n.xlarge":    {Region: "ap-southeast-1", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.292},
		"m5zn.12xlarge": {Region: "ap-southeast-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.956},
		"m5zn.2xlarge":  {Region: "ap-southeast-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.826},
		"m5zn.3xlarge":  {Region: "ap-southeast-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.239},
		"m5zn.6xlarge":  {Region: "ap-southeast-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.478},
		"m5zn.large":    {Region: "ap-southeast-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2065},
		"m5zn.metal":    {Region: "ap-southeast-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.956},
		"m5zn.xlarge":   {Region: "ap-southeast-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.413},
		"m6g.12xlarge":  {Region: "ap-southeast-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m6g.16xlarge":  {Region: "ap-southeast-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m6g.2xlarge":   {Region: "ap-southeast-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m6g.4xlarge":   {Region: "ap-southeast-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m6g.8xlarge":   {Region: "ap-southeast-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m6g.large":     {Region: "ap-southeast-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m6g.medium":    {Region: "ap-southeast-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.048},
		"m6g.metal":     {Region: "ap-southeast-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m6g.xlarge":    {Region: "ap-southeast-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m6gd.12xlarge": {Region: "ap-southeast-1", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"m6gd.16xlarge": {Region: "ap-southeast-1", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"m6gd.2xlarge":  {Region: "ap-southeast-1", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"m6gd.4xlarge":  {Region: "ap-southeast-1", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"m6gd.8xlarge":  {Region: "ap-southeast-1", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"m6gd.large":    {Region: "ap-southeast-1", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"m6gd.medium":   {Region: "ap-southeast-1", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0565},
		"m6gd.metal":    {Region: "ap-southeast-1", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"m6gd.xlarge":   {Region: "ap-southeast-1", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"p2.16xlarge":   {Region: "ap-southeast-1", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 27.488},
		"p2.8xlarge":    {Region: "ap-southeast-1", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 13.744},
		"p2.xlarge":     {Region: "ap-southeast-1", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.718},
		"p3.16xlarge":   {Region: "ap-southeast-1", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 33.872},
		"p3.2xlarge":    {Region: "ap-southeast-1", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 4.234},
		"p3.8xlarge":    {Region: "ap-southeast-1", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 16.936},
		"r3.2xlarge":    {Region: "ap-southeast-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.798},
		"r3.4xlarge":    {Region: "ap-southeast-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.596},
		"r3.8xlarge":    {Region: "ap-southeast-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.192},
		"r3.large":      {Region: "ap-southeast-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r3.xlarge":     {Region: "ap-southeast-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.399},
		"r4.16xlarge":   {Region: "ap-southeast-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.12},
		"r4.2xlarge":    {Region: "ap-southeast-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.64},
		"r4.4xlarge":    {Region: "ap-southeast-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.28},
		"r4.8xlarge":    {Region: "ap-southeast-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.56},
		"r4.large":      {Region: "ap-southeast-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.16},
		"r4.xlarge":     {Region: "ap-southeast-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.32},
		"r5.12xlarge":   {Region: "ap-southeast-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"r5.16xlarge":   {Region: "ap-southeast-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"r5.24xlarge":   {Region: "ap-southeast-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.2xlarge":    {Region: "ap-southeast-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"r5.4xlarge":    {Region: "ap-southeast-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"r5.8xlarge":    {Region: "ap-southeast-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"r5.large":      {Region: "ap-southeast-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"r5.metal":      {Region: "ap-southeast-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.xlarge":     {Region: "ap-southeast-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"r5a.12xlarge":  {Region: "ap-southeast-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"r5a.16xlarge":  {Region: "ap-southeast-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"r5a.24xlarge":  {Region: "ap-southeast-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"r5a.2xlarge":   {Region: "ap-southeast-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"r5a.4xlarge":   {Region: "ap-southeast-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"r5a.8xlarge":   {Region: "ap-southeast-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"r5a.large":     {Region: "ap-southeast-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"r5a.xlarge":    {Region: "ap-southeast-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"r5ad.12xlarge": {Region: "ap-southeast-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.816},
		"r5ad.16xlarge": {Region: "ap-southeast-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.088},
		"r5ad.24xlarge": {Region: "ap-southeast-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.632},
		"r5ad.2xlarge":  {Region: "ap-southeast-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.636},
		"r5ad.4xlarge":  {Region: "ap-southeast-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.272},
		"r5ad.8xlarge":  {Region: "ap-southeast-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.544},
		"r5ad.large":    {Region: "ap-southeast-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.159},
		"r5ad.xlarge":   {Region: "ap-southeast-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.318},
		"r5b.12xlarge":  {Region: "ap-southeast-1", Type: "r5b.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.272},
		"r5b.16xlarge":  {Region: "ap-southeast-1", Type: "r5b.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.696},
		"r5b.24xlarge":  {Region: "ap-southeast-1", Type: "r5b.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5b.2xlarge":   {Region: "ap-southeast-1", Type: "r5b.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.712},
		"r5b.4xlarge":   {Region: "ap-southeast-1", Type: "r5b.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.424},
		"r5b.8xlarge":   {Region: "ap-southeast-1", Type: "r5b.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.848},
		"r5b.large":     {Region: "ap-southeast-1", Type: "r5b.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.178},
		"r5b.metal":     {Region: "ap-southeast-1", Type: "r5b.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5b.xlarge":    {Region: "ap-southeast-1", Type: "r5b.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.356},
		"r5d.12xlarge":  {Region: "ap-southeast-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.176},
		"r5d.16xlarge":  {Region: "ap-southeast-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.568},
		"r5d.24xlarge":  {Region: "ap-southeast-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.2xlarge":   {Region: "ap-southeast-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.696},
		"r5d.4xlarge":   {Region: "ap-southeast-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.392},
		"r5d.8xlarge":   {Region: "ap-southeast-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.784},
		"r5d.large":     {Region: "ap-southeast-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.174},
		"r5d.metal":     {Region: "ap-southeast-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.xlarge":    {Region: "ap-southeast-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.348},
		"r5dn.12xlarge": {Region: "ap-southeast-1", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.8},
		"r5dn.16xlarge": {Region: "ap-southeast-1", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.4},
		"r5dn.24xlarge": {Region: "ap-southeast-1", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.6},
		"r5dn.2xlarge":  {Region: "ap-southeast-1", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.8},
		"r5dn.4xlarge":  {Region: "ap-southeast-1", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.6},
		"r5dn.8xlarge":  {Region: "ap-southeast-1", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.2},
		"r5dn.large":    {Region: "ap-southeast-1", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r5dn.metal":    {Region: "ap-southeast-1", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.6},
		"r5dn.xlarge":   {Region: "ap-southeast-1", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.4},
		"r5n.12xlarge":  {Region: "ap-southeast-1", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.272},
		"r5n.16xlarge":  {Region: "ap-southeast-1", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.696},
		"r5n.24xlarge":  {Region: "ap-southeast-1", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5n.2xlarge":   {Region: "ap-southeast-1", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.712},
		"r5n.4xlarge":   {Region: "ap-southeast-1", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.424},
		"r5n.8xlarge":   {Region: "ap-southeast-1", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.848},
		"r5n.large":     {Region: "ap-southeast-1", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.178},
		"r5n.metal":     {Region: "ap-southeast-1", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5n.xlarge":    {Region: "ap-southeast-1", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.356},
		"r6g.12xlarge":  {Region: "ap-southeast-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.9184},
		"r6g.16xlarge":  {Region: "ap-southeast-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8912},
		"r6g.2xlarge":   {Region: "ap-southeast-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4864},
		"r6g.4xlarge":   {Region: "ap-southeast-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9728},
		"r6g.8xlarge":   {Region: "ap-southeast-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.9456},
		"r6g.large":     {Region: "ap-southeast-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1216},
		"r6g.medium":    {Region: "ap-southeast-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0608},
		"r6g.metal":     {Region: "ap-southeast-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8912},
		"r6g.xlarge":    {Region: "ap-southeast-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2432},
		"r6gd.12xlarge": {Region: "ap-southeast-1", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.336},
		"r6gd.16xlarge": {Region: "ap-southeast-1", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"r6gd.2xlarge":  {Region: "ap-southeast-1", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.556},
		"r6gd.4xlarge":  {Region: "ap-southeast-1", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.112},
		"r6gd.8xlarge":  {Region: "ap-southeast-1", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.224},
		"r6gd.large":    {Region: "ap-southeast-1", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.139},
		"r6gd.medium":   {Region: "ap-southeast-1", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0695},
		"r6gd.metal":    {Region: "ap-southeast-1", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"r6gd.xlarge":   {Region: "ap-southeast-1", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.278},
		"t1.micro":      {Region: "ap-southeast-1", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.02},
		"t2.2xlarge":    {Region: "ap-southeast-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4672},
		"t2.large":      {Region: "ap-southeast-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1168},
		"t2.medium":     {Region: "ap-southeast-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0584},
		"t2.micro":      {Region: "ap-southeast-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0146},
		"t2.nano":       {Region: "ap-southeast-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0073},
		"t2.small":      {Region: "ap-southeast-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0292},
		"t2.xlarge":     {Region: "ap-southeast-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2336},
		"t3.2xlarge":    {Region: "ap-southeast-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4224},
		"t3.large":      {Region: "ap-southeast-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1056},
		"t3.medium":     {Region: "ap-southeast-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0528},
		"t3.micro":      {Region: "ap-southeast-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0132},
		"t3.nano":       {Region: "ap-southeast-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0066},
		"t3.small":      {Region: "ap-southeast-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0264},
		"t3.xlarge":     {Region: "ap-southeast-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2112},
		"t3a.2xlarge":   {Region: "ap-southeast-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3776},
		"t3a.large":     {Region: "ap-southeast-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0944},
		"t3a.medium":    {Region: "ap-southeast-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0472},
		"t3a.micro":     {Region: "ap-southeast-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0118},
		"t3a.small":     {Region: "ap-southeast-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0236},
		"t3a.xlarge":    {Region: "ap-southeast-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1888},
		"t4g.2xlarge":   {Region: "ap-southeast-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3392},
		"t4g.large":     {Region: "ap-southeast-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0848},
		"t4g.medium":    {Region: "ap-southeast-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0424},
		"t4g.micro":     {Region: "ap-southeast-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0106},
		"t4g.nano":      {Region: "ap-southeast-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0053},
		"t4g.small":     {Region: "ap-southeast-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0212},
		"t4g.xlarge":    {Region: "ap-southeast-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1696},
		"x1.16xlarge":   {Region: "ap-southeast-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.671},
		"x1.32xlarge":   {Region: "ap-southeast-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 19.341},
		"x1e.16xlarge":  {Region: "ap-southeast-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 19.344},
		"x1e.2xlarge":   {Region: "ap-southeast-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.418},
		"x1e.32xlarge":  {Region: "ap-southeast-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 38.688},
		"x1e.4xlarge":   {Region: "ap-southeast-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.836},
		"x1e.8xlarge":   {Region: "ap-southeast-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.672},
		"x1e.xlarge":    {Region: "ap-southeast-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.209},
		"z1d.12xlarge":  {Region: "ap-southeast-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"z1d.2xlarge":   {Region: "ap-southeast-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.904},
		"z1d.3xlarge":   {Region: "ap-southeast-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.356},
		"z1d.6xlarge":   {Region: "ap-southeast-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.712},
		"z1d.large":     {Region: "ap-southeast-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.226},
		"z1d.metal":     {Region: "ap-southeast-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"z1d.xlarge":    {Region: "ap-southeast-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.452},
	},
	"ap-southeast-2": {
		"a1.4xlarge":    {Region: "ap-southeast-2", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.5328},
		"a1.large":      {Region: "ap-southeast-2", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0666},
		"a1.medium":     {Region: "ap-southeast-2", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0333},
		"a1.metal":      {Region: "ap-southeast-2", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.533},
		"a1.xlarge":     {Region: "ap-southeast-2", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1332},
		"c1.medium":     {Region: "ap-southeast-2", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.164},
		"c1.xlarge":     {Region: "ap-southeast-2", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.655},
		"c3.2xlarge":    {Region: "ap-southeast-2", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.529},
		"c3.4xlarge":    {Region: "ap-southeast-2", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.058},
		"c3.8xlarge":    {Region: "ap-southeast-2", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.117},
		"c3.large":      {Region: "ap-southeast-2", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.132},
		"c3.xlarge":     {Region: "ap-southeast-2", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.265},
		"c4.2xlarge":    {Region: "ap-southeast-2", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.522},
		"c4.4xlarge":    {Region: "ap-southeast-2", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.042},
		"c4.8xlarge":    {Region: "ap-southeast-2", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.085},
		"c4.large":      {Region: "ap-southeast-2", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"c4.xlarge":     {Region: "ap-southeast-2", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.261},
		"c5.12xlarge":   {Region: "ap-southeast-2", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.664},
		"c5.18xlarge":   {Region: "ap-southeast-2", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.996},
		"c5.24xlarge":   {Region: "ap-southeast-2", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.328},
		"c5.2xlarge":    {Region: "ap-southeast-2", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.444},
		"c5.4xlarge":    {Region: "ap-southeast-2", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.888},
		"c5.9xlarge":    {Region: "ap-southeast-2", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.998},
		"c5.large":      {Region: "ap-southeast-2", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.111},
		"c5.metal":      {Region: "ap-southeast-2", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.328},
		"c5.xlarge":     {Region: "ap-southeast-2", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.222},
		"c5a.12xlarge":  {Region: "ap-southeast-2", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4},
		"c5a.16xlarge":  {Region: "ap-southeast-2", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2},
		"c5a.24xlarge":  {Region: "ap-southeast-2", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.8},
		"c5a.2xlarge":   {Region: "ap-southeast-2", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"c5a.4xlarge":   {Region: "ap-southeast-2", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"c5a.8xlarge":   {Region: "ap-southeast-2", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6},
		"c5a.large":     {Region: "ap-southeast-2", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"c5a.xlarge":    {Region: "ap-southeast-2", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"c5ad.12xlarge": {Region: "ap-southeast-2", Type: "c5ad.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"c5ad.16xlarge": {Region: "ap-southeast-2", Type: "c5ad.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"c5ad.24xlarge": {Region: "ap-southeast-2", Type: "c5ad.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"c5ad.2xlarge":  {Region: "ap-southeast-2", Type: "c5ad.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"c5ad.4xlarge":  {Region: "ap-southeast-2", Type: "c5ad.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"c5ad.8xlarge":  {Region: "ap-southeast-2", Type: "c5ad.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"c5ad.large":    {Region: "ap-southeast-2", Type: "c5ad.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"c5ad.xlarge":   {Region: "ap-southeast-2", Type: "c5ad.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"c5d.12xlarge":  {Region: "ap-southeast-2", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"c5d.18xlarge":  {Region: "ap-southeast-2", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.536},
		"c5d.24xlarge":  {Region: "ap-southeast-2", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"c5d.2xlarge":   {Region: "ap-southeast-2", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"c5d.4xlarge":   {Region: "ap-southeast-2", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"c5d.9xlarge":   {Region: "ap-southeast-2", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.268},
		"c5d.large":     {Region: "ap-southeast-2", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"c5d.metal":     {Region: "ap-southeast-2", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"c5d.xlarge":    {Region: "ap-southeast-2", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"c5n.18xlarge":  {Region: "ap-southeast-2", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.076},
		"c5n.2xlarge":   {Region: "ap-southeast-2", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.564},
		"c5n.4xlarge":   {Region: "ap-southeast-2", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.128},
		"c5n.9xlarge":   {Region: "ap-southeast-2", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.538},
		"c5n.large":     {Region: "ap-southeast-2", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.141},
		"c5n.metal":     {Region: "ap-southeast-2", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.076},
		"c5n.xlarge":    {Region: "ap-southeast-2", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.282},
		"c6g.12xlarge":  {Region: "ap-southeast-2", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.1312},
		"c6g.16xlarge":  {Region: "ap-southeast-2", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8416},
		"c6g.2xlarge":   {Region: "ap-southeast-2", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3552},
		"c6g.4xlarge":   {Region: "ap-southeast-2", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7104},
		"c6g.8xlarge":   {Region: "ap-southeast-2", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.4208},
		"c6g.large":     {Region: "ap-southeast-2", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0888},
		"c6g.medium":    {Region: "ap-southeast-2", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0444},
		"c6g.metal":     {Region: "ap-southeast-2", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8416},
		"c6g.xlarge":    {Region: "ap-southeast-2", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1776},
		"c6gd.12xlarge": {Region: "ap-southeast-2", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"c6gd.16xlarge": {Region: "ap-southeast-2", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.232},
		"c6gd.2xlarge":  {Region: "ap-southeast-2", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"c6gd.4xlarge":  {Region: "ap-southeast-2", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"c6gd.8xlarge":  {Region: "ap-southeast-2", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.616},
		"c6gd.large":    {Region: "ap-southeast-2", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"c6gd.medium":   {Region: "ap-southeast-2", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0505},
		"c6gd.metal":    {Region: "ap-southeast-2", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.232},
		"c6gd.xlarge":   {Region: "ap-southeast-2", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"d2.2xlarge":    {Region: "ap-southeast-2", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.74},
		"d2.4xlarge":    {Region: "ap-southeast-2", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.48},
		"d2.8xlarge":    {Region: "ap-southeast-2", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.96},
		"d2.xlarge":     {Region: "ap-southeast-2", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.87},
		"f1.16xlarge":   {Region: "ap-southeast-2", Type: "f1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 15.848},
		"f1.2xlarge":    {Region: "ap-southeast-2", Type: "f1.2xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.981},
		"f1.4xlarge":    {Region: "ap-southeast-2", Type: "f1.4xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.962},
		"g2.2xlarge":    {Region: "ap-southeast-2", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.898},
		"g2.8xlarge":    {Region: "ap-southeast-2", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 3.592},
		"g3.16xlarge":   {Region: "ap-southeast-2", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 7.016},
		"g3.4xlarge":    {Region: "ap-southeast-2", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.754},
		"g3.8xlarge":    {Region: "ap-southeast-2", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 3.508},
		"g3s.xlarge":    {Region: "ap-southeast-2", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.154},
		"g4dn.12xlarge": {Region: "ap-southeast-2", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 5.087},
		"g4dn.16xlarge": {Region: "ap-southeast-2", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.659},
		"g4dn.2xlarge":  {Region: "ap-southeast-2", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.978},
		"g4dn.4xlarge":  {Region: "ap-southeast-2", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.566},
		"g4dn.8xlarge":  {Region: "ap-southeast-2", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.83},
		"g4dn.metal":    {Region: "ap-southeast-2", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 10.174},
		"g4dn.xlarge":   {Region: "ap-southeast-2", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.684},
		"hs1.8xlarge":   {Region: "ap-southeast-2", Type: "hs1.8xlarge", Memory: kresource.MustParse("119808Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 5.57},
		"i2.2xlarge":    {Region: "ap-southeast-2", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.035},
		"i2.4xlarge":    {Region: "ap-southeast-2", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.07},
		"i2.8xlarge":    {Region: "ap-southeast-2", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 8.14},
		"i2.xlarge":     {Region: "ap-southeast-2", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.018},
		"i3.16xlarge":   {Region: "ap-southeast-2", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.984},
		"i3.2xlarge":    {Region: "ap-southeast-2", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.748},
		"i3.4xlarge":    {Region: "ap-southeast-2", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.496},
		"i3.8xlarge":    {Region: "ap-southeast-2", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.992},
		"i3.large":      {Region: "ap-southeast-2", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.187},
		"i3.xlarge":     {Region: "ap-southeast-2", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.374},
		"i3en.12xlarge": {Region: "ap-southeast-2", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.504},
		"i3en.24xlarge": {Region: "ap-southeast-2", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 13.008},
		"i3en.2xlarge":  {Region: "ap-southeast-2", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.084},
		"i3en.3xlarge":  {Region: "ap-southeast-2", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.626},
		"i3en.6xlarge":  {Region: "ap-southeast-2", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.252},
		"i3en.large":    {Region: "ap-southeast-2", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.271},
		"i3en.metal":    {Region: "ap-southeast-2", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 13.008},
		"i3en.xlarge":   {Region: "ap-southeast-2", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.542},
		"inf1.24xlarge": {Region: "ap-southeast-2", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 9.519},
		"inf1.2xlarge":  {Region: "ap-southeast-2", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.73},
		"inf1.6xlarge":  {Region: "ap-southeast-2", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.38},
		"inf1.xlarge":   {Region: "ap-southeast-2", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.46},
		"m1.large":      {Region: "ap-southeast-2", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.233},
		"m1.medium":     {Region: "ap-southeast-2", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.117},
		"m1.small":      {Region: "ap-southeast-2", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.058},
		"m1.xlarge":     {Region: "ap-southeast-2", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.467},
		"m2.2xlarge":    {Region: "ap-southeast-2", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.592},
		"m2.4xlarge":    {Region: "ap-southeast-2", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.183},
		"m2.xlarge":     {Region: "ap-southeast-2", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.296},
		"m3.2xlarge":    {Region: "ap-southeast-2", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.745},
		"m3.large":      {Region: "ap-southeast-2", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.186},
		"m3.medium":     {Region: "ap-southeast-2", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.093},
		"m3.xlarge":     {Region: "ap-southeast-2", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.372},
		"m4.10xlarge":   {Region: "ap-southeast-2", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.5},
		"m4.16xlarge":   {Region: "ap-southeast-2", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.0},
		"m4.2xlarge":    {Region: "ap-southeast-2", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5},
		"m4.4xlarge":    {Region: "ap-southeast-2", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.0},
		"m4.large":      {Region: "ap-southeast-2", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.125},
		"m4.xlarge":     {Region: "ap-southeast-2", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.25},
		"m5.12xlarge":   {Region: "ap-southeast-2", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.88},
		"m5.16xlarge":   {Region: "ap-southeast-2", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.84},
		"m5.24xlarge":   {Region: "ap-southeast-2", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5.2xlarge":    {Region: "ap-southeast-2", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"m5.4xlarge":    {Region: "ap-southeast-2", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.96},
		"m5.8xlarge":    {Region: "ap-southeast-2", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.92},
		"m5.large":      {Region: "ap-southeast-2", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"m5.metal":      {Region: "ap-southeast-2", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5.xlarge":     {Region: "ap-southeast-2", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"m5a.12xlarge":  {Region: "ap-southeast-2", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.592},
		"m5a.16xlarge":  {Region: "ap-southeast-2", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.456},
		"m5a.24xlarge":  {Region: "ap-southeast-2", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.184},
		"m5a.2xlarge":   {Region: "ap-southeast-2", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"m5a.4xlarge":   {Region: "ap-southeast-2", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"m5a.8xlarge":   {Region: "ap-southeast-2", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.728},
		"m5a.large":     {Region: "ap-southeast-2", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"m5a.xlarge":    {Region: "ap-southeast-2", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"m5ad.12xlarge": {Region: "ap-southeast-2", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.12},
		"m5ad.16xlarge": {Region: "ap-southeast-2", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.16},
		"m5ad.24xlarge": {Region: "ap-southeast-2", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.24},
		"m5ad.2xlarge":  {Region: "ap-southeast-2", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.52},
		"m5ad.4xlarge":  {Region: "ap-southeast-2", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.04},
		"m5ad.8xlarge":  {Region: "ap-southeast-2", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.08},
		"m5ad.large":    {Region: "ap-southeast-2", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"m5ad.xlarge":   {Region: "ap-southeast-2", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.26},
		"m5d.12xlarge":  {Region: "ap-southeast-2", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.408},
		"m5d.16xlarge":  {Region: "ap-southeast-2", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.544},
		"m5d.24xlarge":  {Region: "ap-southeast-2", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.816},
		"m5d.2xlarge":   {Region: "ap-southeast-2", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.568},
		"m5d.4xlarge":   {Region: "ap-southeast-2", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.136},
		"m5d.8xlarge":   {Region: "ap-southeast-2", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.272},
		"m5d.large":     {Region: "ap-southeast-2", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.142},
		"m5d.metal":     {Region: "ap-southeast-2", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.816},
		"m5d.xlarge":    {Region: "ap-southeast-2", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.284},
		"m5zn.12xlarge": {Region: "ap-southeast-2", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.956},
		"m5zn.2xlarge":  {Region: "ap-southeast-2", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.826},
		"m5zn.3xlarge":  {Region: "ap-southeast-2", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.239},
		"m5zn.6xlarge":  {Region: "ap-southeast-2", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.478},
		"m5zn.large":    {Region: "ap-southeast-2", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2065},
		"m5zn.metal":    {Region: "ap-southeast-2", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.956},
		"m5zn.xlarge":   {Region: "ap-southeast-2", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.413},
		"m6g.12xlarge":  {Region: "ap-southeast-2", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m6g.16xlarge":  {Region: "ap-southeast-2", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m6g.2xlarge":   {Region: "ap-southeast-2", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m6g.4xlarge":   {Region: "ap-southeast-2", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m6g.8xlarge":   {Region: "ap-southeast-2", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m6g.large":     {Region: "ap-southeast-2", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m6g.medium":    {Region: "ap-southeast-2", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.048},
		"m6g.metal":     {Region: "ap-southeast-2", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m6g.xlarge":    {Region: "ap-southeast-2", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m6gd.12xlarge": {Region: "ap-southeast-2", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.736},
		"m6gd.16xlarge": {Region: "ap-southeast-2", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.648},
		"m6gd.2xlarge":  {Region: "ap-southeast-2", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.456},
		"m6gd.4xlarge":  {Region: "ap-southeast-2", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.912},
		"m6gd.8xlarge":  {Region: "ap-southeast-2", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.824},
		"m6gd.large":    {Region: "ap-southeast-2", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.114},
		"m6gd.medium":   {Region: "ap-southeast-2", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.057},
		"m6gd.metal":    {Region: "ap-southeast-2", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.648},
		"m6gd.xlarge":   {Region: "ap-southeast-2", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.228},
		"p2.16xlarge":   {Region: "ap-southeast-2", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 24.672},
		"p2.8xlarge":    {Region: "ap-southeast-2", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 12.336},
		"p2.xlarge":     {Region: "ap-southeast-2", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.542},
		"p3.16xlarge":   {Region: "ap-southeast-2", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 33.872},
		"p3.2xlarge":    {Region: "ap-southeast-2", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 4.234},
		"p3.8xlarge":    {Region: "ap-southeast-2", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 16.936},
		"r3.2xlarge":    {Region: "ap-southeast-2", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.798},
		"r3.4xlarge":    {Region: "ap-southeast-2", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.596},
		"r3.8xlarge":    {Region: "ap-southeast-2", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.192},
		"r3.large":      {Region: "ap-southeast-2", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r3.xlarge":     {Region: "ap-southeast-2", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.399},
		"r4.16xlarge":   {Region: "ap-southeast-2", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.1072},
		"r4.2xlarge":    {Region: "ap-southeast-2", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6384},
		"r4.4xlarge":    {Region: "ap-southeast-2", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.2768},
		"r4.8xlarge":    {Region: "ap-southeast-2", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.5536},
		"r4.large":      {Region: "ap-southeast-2", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1596},
		"r4.xlarge":     {Region: "ap-southeast-2", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3192},
		"r5.12xlarge":   {Region: "ap-southeast-2", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.624},
		"r5.16xlarge":   {Region: "ap-southeast-2", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.832},
		"r5.24xlarge":   {Region: "ap-southeast-2", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.248},
		"r5.2xlarge":    {Region: "ap-southeast-2", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.604},
		"r5.4xlarge":    {Region: "ap-southeast-2", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.208},
		"r5.8xlarge":    {Region: "ap-southeast-2", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.416},
		"r5.large":      {Region: "ap-southeast-2", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.151},
		"r5.metal":      {Region: "ap-southeast-2", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.248},
		"r5.xlarge":     {Region: "ap-southeast-2", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.302},
		"r5a.12xlarge":  {Region: "ap-southeast-2", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"r5a.16xlarge":  {Region: "ap-southeast-2", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"r5a.24xlarge":  {Region: "ap-southeast-2", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"r5a.2xlarge":   {Region: "ap-southeast-2", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"r5a.4xlarge":   {Region: "ap-southeast-2", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"r5a.8xlarge":   {Region: "ap-southeast-2", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"r5a.large":     {Region: "ap-southeast-2", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"r5a.xlarge":    {Region: "ap-southeast-2", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"r5ad.12xlarge": {Region: "ap-southeast-2", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.816},
		"r5ad.16xlarge": {Region: "ap-southeast-2", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.088},
		"r5ad.24xlarge": {Region: "ap-southeast-2", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.632},
		"r5ad.2xlarge":  {Region: "ap-southeast-2", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.636},
		"r5ad.4xlarge":  {Region: "ap-southeast-2", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.272},
		"r5ad.8xlarge":  {Region: "ap-southeast-2", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.544},
		"r5ad.large":    {Region: "ap-southeast-2", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.159},
		"r5ad.xlarge":   {Region: "ap-southeast-2", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.318},
		"r5d.12xlarge":  {Region: "ap-southeast-2", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.176},
		"r5d.16xlarge":  {Region: "ap-southeast-2", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.568},
		"r5d.24xlarge":  {Region: "ap-southeast-2", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.2xlarge":   {Region: "ap-southeast-2", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.696},
		"r5d.4xlarge":   {Region: "ap-southeast-2", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.392},
		"r5d.8xlarge":   {Region: "ap-southeast-2", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.784},
		"r5d.large":     {Region: "ap-southeast-2", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.174},
		"r5d.metal":     {Region: "ap-southeast-2", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.352},
		"r5d.xlarge":    {Region: "ap-southeast-2", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.348},
		"r6g.12xlarge":  {Region: "ap-southeast-2", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.8992},
		"r6g.16xlarge":  {Region: "ap-southeast-2", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8656},
		"r6g.2xlarge":   {Region: "ap-southeast-2", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4832},
		"r6g.4xlarge":   {Region: "ap-southeast-2", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9664},
		"r6g.8xlarge":   {Region: "ap-southeast-2", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.9328},
		"r6g.large":     {Region: "ap-southeast-2", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1208},
		"r6g.medium":    {Region: "ap-southeast-2", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0604},
		"r6g.metal":     {Region: "ap-southeast-2", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8656},
		"r6g.xlarge":    {Region: "ap-southeast-2", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2416},
		"r6gd.12xlarge": {Region: "ap-southeast-2", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.336},
		"r6gd.16xlarge": {Region: "ap-southeast-2", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"r6gd.2xlarge":  {Region: "ap-southeast-2", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.556},
		"r6gd.4xlarge":  {Region: "ap-southeast-2", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.112},
		"r6gd.8xlarge":  {Region: "ap-southeast-2", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.224},
		"r6gd.large":    {Region: "ap-southeast-2", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.139},
		"r6gd.medium":   {Region: "ap-southeast-2", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0695},
		"r6gd.metal":    {Region: "ap-southeast-2", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.448},
		"r6gd.xlarge":   {Region: "ap-southeast-2", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.278},
		"t1.micro":      {Region: "ap-southeast-2", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.02},
		"t2.2xlarge":    {Region: "ap-southeast-2", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4672},
		"t2.large":      {Region: "ap-southeast-2", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1168},
		"t2.medium":     {Region: "ap-southeast-2", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0584},
		"t2.micro":      {Region: "ap-southeast-2", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0146},
		"t2.nano":       {Region: "ap-southeast-2", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0073},
		"t2.small":      {Region: "ap-southeast-2", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0292},
		"t2.xlarge":     {Region: "ap-southeast-2", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2336},
		"t3.2xlarge":    {Region: "ap-southeast-2", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4224},
		"t3.large":      {Region: "ap-southeast-2", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1056},
		"t3.medium":     {Region: "ap-southeast-2", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0528},
		"t3.micro":      {Region: "ap-southeast-2", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0132},
		"t3.nano":       {Region: "ap-southeast-2", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0066},
		"t3.small":      {Region: "ap-southeast-2", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0264},
		"t3.xlarge":     {Region: "ap-southeast-2", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2112},
		"t3a.2xlarge":   {Region: "ap-southeast-2", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3802},
		"t3a.large":     {Region: "ap-southeast-2", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.095},
		"t3a.medium":    {Region: "ap-southeast-2", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0475},
		"t3a.micro":     {Region: "ap-southeast-2", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0119},
		"t3a.small":     {Region: "ap-southeast-2", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0238},
		"t3a.xlarge":    {Region: "ap-southeast-2", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1901},
		"t4g.2xlarge":   {Region: "ap-southeast-2", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3392},
		"t4g.large":     {Region: "ap-southeast-2", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0848},
		"t4g.medium":    {Region: "ap-southeast-2", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0424},
		"t4g.micro":     {Region: "ap-southeast-2", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0106},
		"t4g.nano":      {Region: "ap-southeast-2", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0053},
		"t4g.small":     {Region: "ap-southeast-2", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0212},
		"t4g.xlarge":    {Region: "ap-southeast-2", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1696},
		"x1.16xlarge":   {Region: "ap-southeast-2", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.671},
		"x1.32xlarge":   {Region: "ap-southeast-2", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 19.341},
		"x1e.16xlarge":  {Region: "ap-southeast-2", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 19.344},
		"x1e.2xlarge":   {Region: "ap-southeast-2", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.418},
		"x1e.32xlarge":  {Region: "ap-southeast-2", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 38.688},
		"x1e.4xlarge":   {Region: "ap-southeast-2", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.836},
		"x1e.8xlarge":   {Region: "ap-southeast-2", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.672},
		"x1e.xlarge":    {Region: "ap-southeast-2", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.209},
		"z1d.12xlarge":  {Region: "ap-southeast-2", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"z1d.2xlarge":   {Region: "ap-southeast-2", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.904},
		"z1d.3xlarge":   {Region: "ap-southeast-2", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.356},
		"z1d.6xlarge":   {Region: "ap-southeast-2", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.712},
		"z1d.large":     {Region: "ap-southeast-2", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.226},
		"z1d.metal":     {Region: "ap-southeast-2", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"z1d.xlarge":    {Region: "ap-southeast-2", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.452},
	},
	"ca-central-1": {
		"c4.2xlarge":    {Region: "ca-central-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.438},
		"c4.4xlarge":    {Region: "ca-central-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.876},
		"c4.8xlarge":    {Region: "ca-central-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.75},
		"c4.large":      {Region: "ca-central-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.11},
		"c4.xlarge":     {Region: "ca-central-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.218},
		"c5.12xlarge":   {Region: "ca-central-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.232},
		"c5.18xlarge":   {Region: "ca-central-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.348},
		"c5.24xlarge":   {Region: "ca-central-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.464},
		"c5.2xlarge":    {Region: "ca-central-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.372},
		"c5.4xlarge":    {Region: "ca-central-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.744},
		"c5.9xlarge":    {Region: "ca-central-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.674},
		"c5.large":      {Region: "ca-central-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.093},
		"c5.metal":      {Region: "ca-central-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.464},
		"c5.xlarge":     {Region: "ca-central-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.186},
		"c5a.12xlarge":  {Region: "ca-central-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.016},
		"c5a.16xlarge":  {Region: "ca-central-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.688},
		"c5a.24xlarge":  {Region: "ca-central-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.032},
		"c5a.2xlarge":   {Region: "ca-central-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.336},
		"c5a.4xlarge":   {Region: "ca-central-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.672},
		"c5a.8xlarge":   {Region: "ca-central-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.344},
		"c5a.large":     {Region: "ca-central-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.084},
		"c5a.xlarge":    {Region: "ca-central-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.168},
		"c5d.12xlarge":  {Region: "ca-central-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.544},
		"c5d.18xlarge":  {Region: "ca-central-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.816},
		"c5d.24xlarge":  {Region: "ca-central-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.088},
		"c5d.2xlarge":   {Region: "ca-central-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.424},
		"c5d.4xlarge":   {Region: "ca-central-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.848},
		"c5d.9xlarge":   {Region: "ca-central-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.908},
		"c5d.large":     {Region: "ca-central-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.106},
		"c5d.metal":     {Region: "ca-central-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.088},
		"c5d.xlarge":    {Region: "ca-central-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.212},
		"c5n.18xlarge":  {Region: "ca-central-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.248},
		"c5n.2xlarge":   {Region: "ca-central-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.472},
		"c5n.4xlarge":   {Region: "ca-central-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.944},
		"c5n.9xlarge":   {Region: "ca-central-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.124},
		"c5n.large":     {Region: "ca-central-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.118},
		"c5n.metal":     {Region: "ca-central-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.248},
		"c5n.xlarge":    {Region: "ca-central-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.236},
		"c6g.12xlarge":  {Region: "ca-central-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.7856},
		"c6g.16xlarge":  {Region: "ca-central-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.3808},
		"c6g.2xlarge":   {Region: "ca-central-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2976},
		"c6g.4xlarge":   {Region: "ca-central-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.5952},
		"c6g.8xlarge":   {Region: "ca-central-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.1904},
		"c6g.large":     {Region: "ca-central-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0744},
		"c6g.medium":    {Region: "ca-central-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0372},
		"c6g.metal":     {Region: "ca-central-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.3808},
		"c6g.xlarge":    {Region: "ca-central-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1488},
		"d2.2xlarge":    {Region: "ca-central-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.518},
		"d2.4xlarge":    {Region: "ca-central-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.036},
		"d2.8xlarge":    {Region: "ca-central-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.072},
		"d2.xlarge":     {Region: "ca-central-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.759},
		"g3.16xlarge":   {Region: "ca-central-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 5.664},
		"g3.4xlarge":    {Region: "ca-central-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.416},
		"g3.8xlarge":    {Region: "ca-central-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.832},
		"g4dn.12xlarge": {Region: "ca-central-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.343},
		"g4dn.16xlarge": {Region: "ca-central-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.832},
		"g4dn.2xlarge":  {Region: "ca-central-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.835},
		"g4dn.4xlarge":  {Region: "ca-central-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.337},
		"g4dn.8xlarge":  {Region: "ca-central-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.416},
		"g4dn.metal":    {Region: "ca-central-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 8.687},
		"g4dn.xlarge":   {Region: "ca-central-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.584},
		"i3.16xlarge":   {Region: "ca-central-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.504},
		"i3.2xlarge":    {Region: "ca-central-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.688},
		"i3.4xlarge":    {Region: "ca-central-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.376},
		"i3.8xlarge":    {Region: "ca-central-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.752},
		"i3.large":      {Region: "ca-central-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.172},
		"i3.xlarge":     {Region: "ca-central-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.344},
		"i3en.12xlarge": {Region: "ca-central-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.0},
		"i3en.24xlarge": {Region: "ca-central-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.0},
		"i3en.2xlarge":  {Region: "ca-central-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.0},
		"i3en.3xlarge":  {Region: "ca-central-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.5},
		"i3en.6xlarge":  {Region: "ca-central-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.0},
		"i3en.large":    {Region: "ca-central-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.25},
		"i3en.metal":    {Region: "ca-central-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.0},
		"i3en.xlarge":   {Region: "ca-central-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.5},
		"inf1.24xlarge": {Region: "ca-central-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 8.484},
		"inf1.2xlarge":  {Region: "ca-central-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.651},
		"inf1.6xlarge":  {Region: "ca-central-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.121},
		"inf1.xlarge":   {Region: "ca-central-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.41},
		"m4.10xlarge":   {Region: "ca-central-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.22},
		"m4.16xlarge":   {Region: "ca-central-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.552},
		"m4.2xlarge":    {Region: "ca-central-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.444},
		"m4.4xlarge":    {Region: "ca-central-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.888},
		"m4.large":      {Region: "ca-central-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.111},
		"m4.xlarge":     {Region: "ca-central-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.222},
		"m5.12xlarge":   {Region: "ca-central-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.568},
		"m5.16xlarge":   {Region: "ca-central-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.424},
		"m5.24xlarge":   {Region: "ca-central-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"m5.2xlarge":    {Region: "ca-central-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.428},
		"m5.4xlarge":    {Region: "ca-central-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.856},
		"m5.8xlarge":    {Region: "ca-central-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.712},
		"m5.large":      {Region: "ca-central-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.107},
		"m5.metal":      {Region: "ca-central-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"m5.xlarge":     {Region: "ca-central-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.214},
		"m5a.12xlarge":  {Region: "ca-central-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m5a.16xlarge":  {Region: "ca-central-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m5a.24xlarge":  {Region: "ca-central-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5a.2xlarge":   {Region: "ca-central-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m5a.4xlarge":   {Region: "ca-central-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m5a.8xlarge":   {Region: "ca-central-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m5a.large":     {Region: "ca-central-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m5a.xlarge":    {Region: "ca-central-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m5ad.12xlarge": {Region: "ca-central-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.76},
		"m5ad.16xlarge": {Region: "ca-central-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.68},
		"m5ad.24xlarge": {Region: "ca-central-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.52},
		"m5ad.2xlarge":  {Region: "ca-central-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.46},
		"m5ad.4xlarge":  {Region: "ca-central-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.92},
		"m5ad.8xlarge":  {Region: "ca-central-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.84},
		"m5ad.large":    {Region: "ca-central-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"m5ad.xlarge":   {Region: "ca-central-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.23},
		"m5d.12xlarge":  {Region: "ca-central-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"m5d.16xlarge":  {Region: "ca-central-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.032},
		"m5d.24xlarge":  {Region: "ca-central-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"m5d.2xlarge":   {Region: "ca-central-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"m5d.4xlarge":   {Region: "ca-central-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"m5d.8xlarge":   {Region: "ca-central-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.016},
		"m5d.large":     {Region: "ca-central-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"m5d.metal":     {Region: "ca-central-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"m5d.xlarge":    {Region: "ca-central-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"m6g.12xlarge":  {Region: "ca-central-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0544},
		"m6g.16xlarge":  {Region: "ca-central-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7392},
		"m6g.2xlarge":   {Region: "ca-central-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3424},
		"m6g.4xlarge":   {Region: "ca-central-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6848},
		"m6g.8xlarge":   {Region: "ca-central-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3696},
		"m6g.large":     {Region: "ca-central-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0856},
		"m6g.medium":    {Region: "ca-central-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0428},
		"m6g.metal":     {Region: "ca-central-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7392},
		"m6g.xlarge":    {Region: "ca-central-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1712},
		"p3.16xlarge":   {Region: "ca-central-1", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 26.928},
		"p3.2xlarge":    {Region: "ca-central-1", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.366},
		"p3.8xlarge":    {Region: "ca-central-1", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 13.464},
		"r4.16xlarge":   {Region: "ca-central-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.672},
		"r4.2xlarge":    {Region: "ca-central-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.584},
		"r4.4xlarge":    {Region: "ca-central-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.168},
		"r4.8xlarge":    {Region: "ca-central-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.336},
		"r4.large":      {Region: "ca-central-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.146},
		"r4.xlarge":     {Region: "ca-central-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.292},
		"r5.12xlarge":   {Region: "ca-central-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.312},
		"r5.16xlarge":   {Region: "ca-central-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.416},
		"r5.24xlarge":   {Region: "ca-central-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.624},
		"r5.2xlarge":    {Region: "ca-central-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.552},
		"r5.4xlarge":    {Region: "ca-central-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.104},
		"r5.8xlarge":    {Region: "ca-central-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.208},
		"r5.large":      {Region: "ca-central-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.138},
		"r5.metal":      {Region: "ca-central-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.624},
		"r5.xlarge":     {Region: "ca-central-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.276},
		"r5a.12xlarge":  {Region: "ca-central-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.976},
		"r5a.16xlarge":  {Region: "ca-central-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.968},
		"r5a.24xlarge":  {Region: "ca-central-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.952},
		"r5a.2xlarge":   {Region: "ca-central-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.496},
		"r5a.4xlarge":   {Region: "ca-central-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.992},
		"r5a.8xlarge":   {Region: "ca-central-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.984},
		"r5a.large":     {Region: "ca-central-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.124},
		"r5a.xlarge":    {Region: "ca-central-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.248},
		"r5ad.12xlarge": {Region: "ca-central-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.456},
		"r5ad.16xlarge": {Region: "ca-central-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.608},
		"r5ad.24xlarge": {Region: "ca-central-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5ad.2xlarge":  {Region: "ca-central-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.576},
		"r5ad.4xlarge":  {Region: "ca-central-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.152},
		"r5ad.8xlarge":  {Region: "ca-central-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.304},
		"r5ad.large":    {Region: "ca-central-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.144},
		"r5ad.xlarge":   {Region: "ca-central-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.288},
		"r5d.12xlarge":  {Region: "ca-central-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.792},
		"r5d.16xlarge":  {Region: "ca-central-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.056},
		"r5d.24xlarge":  {Region: "ca-central-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.584},
		"r5d.2xlarge":   {Region: "ca-central-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.632},
		"r5d.4xlarge":   {Region: "ca-central-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.264},
		"r5d.8xlarge":   {Region: "ca-central-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.528},
		"r5d.large":     {Region: "ca-central-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.158},
		"r5d.metal":     {Region: "ca-central-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.584},
		"r5d.xlarge":    {Region: "ca-central-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.316},
		"r6g.12xlarge":  {Region: "ca-central-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.6496},
		"r6g.16xlarge":  {Region: "ca-central-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.5328},
		"r6g.2xlarge":   {Region: "ca-central-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4416},
		"r6g.4xlarge":   {Region: "ca-central-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8832},
		"r6g.8xlarge":   {Region: "ca-central-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.7664},
		"r6g.large":     {Region: "ca-central-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1104},
		"r6g.medium":    {Region: "ca-central-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0552},
		"r6g.metal":     {Region: "ca-central-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.5328},
		"r6g.xlarge":    {Region: "ca-central-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2208},
		"t2.2xlarge":    {Region: "ca-central-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4096},
		"t2.large":      {Region: "ca-central-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1024},
		"t2.medium":     {Region: "ca-central-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0512},
		"t2.micro":      {Region: "ca-central-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0128},
		"t2.nano":       {Region: "ca-central-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0064},
		"t2.small":      {Region: "ca-central-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0256},
		"t2.xlarge":     {Region: "ca-central-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2048},
		"t3.2xlarge":    {Region: "ca-central-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3712},
		"t3.large":      {Region: "ca-central-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0928},
		"t3.medium":     {Region: "ca-central-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0464},
		"t3.micro":      {Region: "ca-central-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0116},
		"t3.nano":       {Region: "ca-central-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0058},
		"t3.small":      {Region: "ca-central-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0232},
		"t3.xlarge":     {Region: "ca-central-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1856},
		"t3a.2xlarge":   {Region: "ca-central-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3341},
		"t3a.large":     {Region: "ca-central-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0835},
		"t3a.medium":    {Region: "ca-central-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0418},
		"t3a.micro":     {Region: "ca-central-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0104},
		"t3a.small":     {Region: "ca-central-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0209},
		"t3a.xlarge":    {Region: "ca-central-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.167},
		"t4g.2xlarge":   {Region: "ca-central-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2944},
		"t4g.large":     {Region: "ca-central-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0736},
		"t4g.medium":    {Region: "ca-central-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0368},
		"t4g.micro":     {Region: "ca-central-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0092},
		"t4g.nano":      {Region: "ca-central-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0046},
		"t4g.small":     {Region: "ca-central-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0184},
		"t4g.xlarge":    {Region: "ca-central-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1472},
		"x1.16xlarge":   {Region: "ca-central-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 7.336},
		"x1.32xlarge":   {Region: "ca-central-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 14.672},
		"x1e.16xlarge":  {Region: "ca-central-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 14.669},
		"x1e.2xlarge":   {Region: "ca-central-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.834},
		"x1e.32xlarge":  {Region: "ca-central-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 29.338},
		"x1e.4xlarge":   {Region: "ca-central-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.667},
		"x1e.8xlarge":   {Region: "ca-central-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 7.334},
		"x1e.xlarge":    {Region: "ca-central-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.917},
	},
	"eu-central-1": {
		"a1.4xlarge":    {Region: "eu-central-1", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.4656},
		"a1.large":      {Region: "eu-central-1", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0582},
		"a1.medium":     {Region: "eu-central-1", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0291},
		"a1.metal":      {Region: "eu-central-1", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.466},
		"a1.xlarge":     {Region: "eu-central-1", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1164},
		"c3.2xlarge":    {Region: "eu-central-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.516},
		"c3.4xlarge":    {Region: "eu-central-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.032},
		"c3.8xlarge":    {Region: "eu-central-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.064},
		"c3.large":      {Region: "eu-central-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.129},
		"c3.xlarge":     {Region: "eu-central-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.258},
		"c4.2xlarge":    {Region: "eu-central-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.454},
		"c4.4xlarge":    {Region: "eu-central-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.909},
		"c4.8xlarge":    {Region: "eu-central-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.817},
		"c4.large":      {Region: "eu-central-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.114},
		"c4.xlarge":     {Region: "eu-central-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.227},
		"c5.12xlarge":   {Region: "eu-central-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.328},
		"c5.18xlarge":   {Region: "eu-central-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.492},
		"c5.24xlarge":   {Region: "eu-central-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.656},
		"c5.2xlarge":    {Region: "eu-central-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.388},
		"c5.4xlarge":    {Region: "eu-central-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.776},
		"c5.9xlarge":    {Region: "eu-central-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.746},
		"c5.large":      {Region: "eu-central-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.097},
		"c5.metal":      {Region: "eu-central-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.656},
		"c5.xlarge":     {Region: "eu-central-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.194},
		"c5a.12xlarge":  {Region: "eu-central-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.088},
		"c5a.16xlarge":  {Region: "eu-central-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.784},
		"c5a.24xlarge":  {Region: "eu-central-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.176},
		"c5a.2xlarge":   {Region: "eu-central-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.348},
		"c5a.4xlarge":   {Region: "eu-central-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.696},
		"c5a.8xlarge":   {Region: "eu-central-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.392},
		"c5a.large":     {Region: "eu-central-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.087},
		"c5a.xlarge":    {Region: "eu-central-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.174},
		"c5ad.12xlarge": {Region: "eu-central-1", Type: "c5ad.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4},
		"c5ad.16xlarge": {Region: "eu-central-1", Type: "c5ad.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2},
		"c5ad.24xlarge": {Region: "eu-central-1", Type: "c5ad.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.8},
		"c5ad.2xlarge":  {Region: "eu-central-1", Type: "c5ad.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"c5ad.4xlarge":  {Region: "eu-central-1", Type: "c5ad.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"c5ad.8xlarge":  {Region: "eu-central-1", Type: "c5ad.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6},
		"c5ad.large":    {Region: "eu-central-1", Type: "c5ad.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"c5ad.xlarge":   {Region: "eu-central-1", Type: "c5ad.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"c5d.12xlarge":  {Region: "eu-central-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.664},
		"c5d.18xlarge":  {Region: "eu-central-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.996},
		"c5d.24xlarge":  {Region: "eu-central-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.328},
		"c5d.2xlarge":   {Region: "eu-central-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.444},
		"c5d.4xlarge":   {Region: "eu-central-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.888},
		"c5d.9xlarge":   {Region: "eu-central-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.998},
		"c5d.large":     {Region: "eu-central-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.111},
		"c5d.metal":     {Region: "eu-central-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.328},
		"c5d.xlarge":    {Region: "eu-central-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.222},
		"c5n.18xlarge":  {Region: "eu-central-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.428},
		"c5n.2xlarge":   {Region: "eu-central-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.492},
		"c5n.4xlarge":   {Region: "eu-central-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.984},
		"c5n.9xlarge":   {Region: "eu-central-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.214},
		"c5n.large":     {Region: "eu-central-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.123},
		"c5n.metal":     {Region: "eu-central-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.428},
		"c5n.xlarge":    {Region: "eu-central-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.246},
		"c6g.12xlarge":  {Region: "eu-central-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.8624},
		"c6g.16xlarge":  {Region: "eu-central-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4832},
		"c6g.2xlarge":   {Region: "eu-central-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3104},
		"c6g.4xlarge":   {Region: "eu-central-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6208},
		"c6g.8xlarge":   {Region: "eu-central-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2416},
		"c6g.large":     {Region: "eu-central-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0776},
		"c6g.medium":    {Region: "eu-central-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0388},
		"c6g.metal":     {Region: "eu-central-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4832},
		"c6g.xlarge":    {Region: "eu-central-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1552},
		"c6gd.12xlarge": {Region: "eu-central-1", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.136},
		"c6gd.16xlarge": {Region: "eu-central-1", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.848},
		"c6gd.2xlarge":  {Region: "eu-central-1", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.356},
		"c6gd.4xlarge":  {Region: "eu-central-1", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.712},
		"c6gd.8xlarge":  {Region: "eu-central-1", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.424},
		"c6gd.large":    {Region: "eu-central-1", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.089},
		"c6gd.medium":   {Region: "eu-central-1", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0445},
		"c6gd.metal":    {Region: "eu-central-1", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.848},
		"c6gd.xlarge":   {Region: "eu-central-1", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.178},
		"d2.2xlarge":    {Region: "eu-central-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.588},
		"d2.4xlarge":    {Region: "eu-central-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.176},
		"d2.8xlarge":    {Region: "eu-central-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.352},
		"d2.xlarge":     {Region: "eu-central-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.794},
		"g2.2xlarge":    {Region: "eu-central-1", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.772},
		"g2.8xlarge":    {Region: "eu-central-1", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 3.088},
		"g3.16xlarge":   {Region: "eu-central-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 5.7},
		"g3.4xlarge":    {Region: "eu-central-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.425},
		"g3.8xlarge":    {Region: "eu-central-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.85},
		"g3s.xlarge":    {Region: "eu-central-1", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.938},
		"g4dn.12xlarge": {Region: "eu-central-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.89},
		"g4dn.16xlarge": {Region: "eu-central-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.44},
		"g4dn.2xlarge":  {Region: "eu-central-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.94},
		"g4dn.4xlarge":  {Region: "eu-central-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.505},
		"g4dn.8xlarge":  {Region: "eu-central-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.72},
		"g4dn.metal":    {Region: "eu-central-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.78},
		"g4dn.xlarge":   {Region: "eu-central-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.658},
		"i2.2xlarge":    {Region: "eu-central-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.026},
		"i2.4xlarge":    {Region: "eu-central-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.051},
		"i2.8xlarge":    {Region: "eu-central-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 8.102},
		"i2.xlarge":     {Region: "eu-central-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.013},
		"i3.16xlarge":   {Region: "eu-central-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.952},
		"i3.2xlarge":    {Region: "eu-central-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.744},
		"i3.4xlarge":    {Region: "eu-central-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.488},
		"i3.8xlarge":    {Region: "eu-central-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.976},
		"i3.large":      {Region: "eu-central-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.186},
		"i3.metal":      {Region: "eu-central-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.952},
		"i3.xlarge":     {Region: "eu-central-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.372},
		"i3en.12xlarge": {Region: "eu-central-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.48},
		"i3en.24xlarge": {Region: "eu-central-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.96},
		"i3en.2xlarge":  {Region: "eu-central-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.08},
		"i3en.3xlarge":  {Region: "eu-central-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.62},
		"i3en.6xlarge":  {Region: "eu-central-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.24},
		"i3en.large":    {Region: "eu-central-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.27},
		"i3en.metal":    {Region: "eu-central-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.96},
		"i3en.xlarge":   {Region: "eu-central-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.54},
		"inf1.24xlarge": {Region: "eu-central-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 9.519},
		"inf1.2xlarge":  {Region: "eu-central-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.73},
		"inf1.6xlarge":  {Region: "eu-central-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.38},
		"inf1.xlarge":   {Region: "eu-central-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.46},
		"m3.2xlarge":    {Region: "eu-central-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.632},
		"m3.large":      {Region: "eu-central-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.158},
		"m3.medium":     {Region: "eu-central-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.079},
		"m3.xlarge":     {Region: "eu-central-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.315},
		"m4.10xlarge":   {Region: "eu-central-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.4},
		"m4.16xlarge":   {Region: "eu-central-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.84},
		"m4.2xlarge":    {Region: "eu-central-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"m4.4xlarge":    {Region: "eu-central-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.96},
		"m4.large":      {Region: "eu-central-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"m4.xlarge":     {Region: "eu-central-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"m5.12xlarge":   {Region: "eu-central-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.76},
		"m5.16xlarge":   {Region: "eu-central-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.68},
		"m5.24xlarge":   {Region: "eu-central-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.52},
		"m5.2xlarge":    {Region: "eu-central-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.46},
		"m5.4xlarge":    {Region: "eu-central-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.92},
		"m5.8xlarge":    {Region: "eu-central-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.84},
		"m5.large":      {Region: "eu-central-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"m5.metal":      {Region: "eu-central-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.52},
		"m5.xlarge":     {Region: "eu-central-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.23},
		"m5a.12xlarge":  {Region: "eu-central-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.496},
		"m5a.16xlarge":  {Region: "eu-central-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.328},
		"m5a.24xlarge":  {Region: "eu-central-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.992},
		"m5a.2xlarge":   {Region: "eu-central-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.416},
		"m5a.4xlarge":   {Region: "eu-central-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.832},
		"m5a.8xlarge":   {Region: "eu-central-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.664},
		"m5a.large":     {Region: "eu-central-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.104},
		"m5a.xlarge":    {Region: "eu-central-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.208},
		"m5ad.12xlarge": {Region: "eu-central-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.0},
		"m5ad.16xlarge": {Region: "eu-central-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.0},
		"m5ad.24xlarge": {Region: "eu-central-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.0},
		"m5ad.2xlarge":  {Region: "eu-central-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5},
		"m5ad.4xlarge":  {Region: "eu-central-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.0},
		"m5ad.8xlarge":  {Region: "eu-central-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.0},
		"m5ad.large":    {Region: "eu-central-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.125},
		"m5ad.xlarge":   {Region: "eu-central-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.25},
		"m5d.12xlarge":  {Region: "eu-central-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"m5d.16xlarge":  {Region: "eu-central-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"m5d.24xlarge":  {Region: "eu-central-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5d.2xlarge":   {Region: "eu-central-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"m5d.4xlarge":   {Region: "eu-central-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"m5d.8xlarge":   {Region: "eu-central-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"m5d.large":     {Region: "eu-central-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"m5d.metal":     {Region: "eu-central-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5d.xlarge":    {Region: "eu-central-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"m5dn.12xlarge": {Region: "eu-central-1", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.888},
		"m5dn.16xlarge": {Region: "eu-central-1", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.184},
		"m5dn.24xlarge": {Region: "eu-central-1", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.776},
		"m5dn.2xlarge":  {Region: "eu-central-1", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.648},
		"m5dn.4xlarge":  {Region: "eu-central-1", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.296},
		"m5dn.8xlarge":  {Region: "eu-central-1", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.592},
		"m5dn.large":    {Region: "eu-central-1", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.162},
		"m5dn.metal":    {Region: "eu-central-1", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.776},
		"m5dn.xlarge":   {Region: "eu-central-1", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.324},
		"m5n.12xlarge":  {Region: "eu-central-1", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.384},
		"m5n.16xlarge":  {Region: "eu-central-1", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.512},
		"m5n.24xlarge":  {Region: "eu-central-1", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.768},
		"m5n.2xlarge":   {Region: "eu-central-1", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.564},
		"m5n.4xlarge":   {Region: "eu-central-1", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.128},
		"m5n.8xlarge":   {Region: "eu-central-1", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.256},
		"m5n.large":     {Region: "eu-central-1", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.141},
		"m5n.metal":     {Region: "eu-central-1", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.768},
		"m5n.xlarge":    {Region: "eu-central-1", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.282},
		"m5zn.12xlarge": {Region: "eu-central-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.7486},
		"m5zn.2xlarge":  {Region: "eu-central-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.7914},
		"m5zn.3xlarge":  {Region: "eu-central-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.1872},
		"m5zn.6xlarge":  {Region: "eu-central-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.3743},
		"m5zn.large":    {Region: "eu-central-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1979},
		"m5zn.metal":    {Region: "eu-central-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.7486},
		"m5zn.xlarge":   {Region: "eu-central-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3957},
		"m6g.12xlarge":  {Region: "eu-central-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.208},
		"m6g.16xlarge":  {Region: "eu-central-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.944},
		"m6g.2xlarge":   {Region: "eu-central-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.368},
		"m6g.4xlarge":   {Region: "eu-central-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.736},
		"m6g.8xlarge":   {Region: "eu-central-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.472},
		"m6g.large":     {Region: "eu-central-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.092},
		"m6g.medium":    {Region: "eu-central-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.046},
		"m6g.metal":     {Region: "eu-central-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.944},
		"m6g.xlarge":    {Region: "eu-central-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.184},
		"m6gd.12xlarge": {Region: "eu-central-1", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.616},
		"m6gd.16xlarge": {Region: "eu-central-1", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.488},
		"m6gd.2xlarge":  {Region: "eu-central-1", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.436},
		"m6gd.4xlarge":  {Region: "eu-central-1", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.872},
		"m6gd.8xlarge":  {Region: "eu-central-1", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.744},
		"m6gd.large":    {Region: "eu-central-1", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.109},
		"m6gd.medium":   {Region: "eu-central-1", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0545},
		"m6gd.metal":    {Region: "eu-central-1", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.488},
		"m6gd.xlarge":   {Region: "eu-central-1", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.218},
		"p2.16xlarge":   {Region: "eu-central-1", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 21.216},
		"p2.8xlarge":    {Region: "eu-central-1", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 10.608},
		"p2.xlarge":     {Region: "eu-central-1", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.326},
		"p3.16xlarge":   {Region: "eu-central-1", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 30.584},
		"p3.2xlarge":    {Region: "eu-central-1", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.823},
		"p3.8xlarge":    {Region: "eu-central-1", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 15.292},
		"r3.2xlarge":    {Region: "eu-central-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.8},
		"r3.4xlarge":    {Region: "eu-central-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.6},
		"r3.8xlarge":    {Region: "eu-central-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.201},
		"r3.large":      {Region: "eu-central-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2},
		"r3.xlarge":     {Region: "eu-central-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.4},
		"r4.16xlarge":   {Region: "eu-central-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.1216},
		"r4.2xlarge":    {Region: "eu-central-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6402},
		"r4.4xlarge":    {Region: "eu-central-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.2804},
		"r4.8xlarge":    {Region: "eu-central-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.5608},
		"r4.large":      {Region: "eu-central-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.16005},
		"r4.xlarge":     {Region: "eu-central-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3201},
		"r5.12xlarge":   {Region: "eu-central-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"r5.16xlarge":   {Region: "eu-central-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"r5.24xlarge":   {Region: "eu-central-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.2xlarge":    {Region: "eu-central-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"r5.4xlarge":    {Region: "eu-central-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"r5.8xlarge":    {Region: "eu-central-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"r5.large":      {Region: "eu-central-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"r5.metal":      {Region: "eu-central-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5.xlarge":     {Region: "eu-central-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"r5a.12xlarge":  {Region: "eu-central-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.288},
		"r5a.16xlarge":  {Region: "eu-central-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.384},
		"r5a.24xlarge":  {Region: "eu-central-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.576},
		"r5a.2xlarge":   {Region: "eu-central-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.548},
		"r5a.4xlarge":   {Region: "eu-central-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.096},
		"r5a.8xlarge":   {Region: "eu-central-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.192},
		"r5a.large":     {Region: "eu-central-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.137},
		"r5a.xlarge":    {Region: "eu-central-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.274},
		"r5ad.12xlarge": {Region: "eu-central-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.792},
		"r5ad.16xlarge": {Region: "eu-central-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.056},
		"r5ad.24xlarge": {Region: "eu-central-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.584},
		"r5ad.2xlarge":  {Region: "eu-central-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.632},
		"r5ad.4xlarge":  {Region: "eu-central-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.264},
		"r5ad.8xlarge":  {Region: "eu-central-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.528},
		"r5ad.large":    {Region: "eu-central-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.158},
		"r5ad.xlarge":   {Region: "eu-central-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.316},
		"r5b.12xlarge":  {Region: "eu-central-1", Type: "r5b.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.272},
		"r5b.16xlarge":  {Region: "eu-central-1", Type: "r5b.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.696},
		"r5b.24xlarge":  {Region: "eu-central-1", Type: "r5b.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5b.2xlarge":   {Region: "eu-central-1", Type: "r5b.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.712},
		"r5b.4xlarge":   {Region: "eu-central-1", Type: "r5b.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.424},
		"r5b.8xlarge":   {Region: "eu-central-1", Type: "r5b.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.848},
		"r5b.large":     {Region: "eu-central-1", Type: "r5b.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.178},
		"r5b.metal":     {Region: "eu-central-1", Type: "r5b.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5b.xlarge":    {Region: "eu-central-1", Type: "r5b.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.356},
		"r5d.12xlarge":  {Region: "eu-central-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.152},
		"r5d.16xlarge":  {Region: "eu-central-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.536},
		"r5d.24xlarge":  {Region: "eu-central-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.304},
		"r5d.2xlarge":   {Region: "eu-central-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.692},
		"r5d.4xlarge":   {Region: "eu-central-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.384},
		"r5d.8xlarge":   {Region: "eu-central-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.768},
		"r5d.large":     {Region: "eu-central-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.173},
		"r5d.metal":     {Region: "eu-central-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.304},
		"r5d.xlarge":    {Region: "eu-central-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.346},
		"r5dn.12xlarge": {Region: "eu-central-1", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.776},
		"r5dn.16xlarge": {Region: "eu-central-1", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.368},
		"r5dn.24xlarge": {Region: "eu-central-1", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.552},
		"r5dn.2xlarge":  {Region: "eu-central-1", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.796},
		"r5dn.4xlarge":  {Region: "eu-central-1", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.592},
		"r5dn.8xlarge":  {Region: "eu-central-1", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.184},
		"r5dn.large":    {Region: "eu-central-1", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.199},
		"r5dn.metal":    {Region: "eu-central-1", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.552},
		"r5dn.xlarge":   {Region: "eu-central-1", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.398},
		"r5n.12xlarge":  {Region: "eu-central-1", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.272},
		"r5n.16xlarge":  {Region: "eu-central-1", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.696},
		"r5n.24xlarge":  {Region: "eu-central-1", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5n.2xlarge":   {Region: "eu-central-1", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.712},
		"r5n.4xlarge":   {Region: "eu-central-1", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.424},
		"r5n.8xlarge":   {Region: "eu-central-1", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.848},
		"r5n.large":     {Region: "eu-central-1", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.178},
		"r5n.metal":     {Region: "eu-central-1", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.544},
		"r5n.xlarge":    {Region: "eu-central-1", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.356},
		"r6g.12xlarge":  {Region: "eu-central-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.9184},
		"r6g.16xlarge":  {Region: "eu-central-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8912},
		"r6g.2xlarge":   {Region: "eu-central-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4864},
		"r6g.4xlarge":   {Region: "eu-central-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9728},
		"r6g.8xlarge":   {Region: "eu-central-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.9456},
		"r6g.large":     {Region: "eu-central-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1216},
		"r6g.medium":    {Region: "eu-central-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0608},
		"r6g.metal":     {Region: "eu-central-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.8912},
		"r6g.xlarge":    {Region: "eu-central-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2432},
		"r6gd.12xlarge": {Region: "eu-central-1", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.312},
		"r6gd.16xlarge": {Region: "eu-central-1", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.416},
		"r6gd.2xlarge":  {Region: "eu-central-1", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.552},
		"r6gd.4xlarge":  {Region: "eu-central-1", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.104},
		"r6gd.8xlarge":  {Region: "eu-central-1", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.208},
		"r6gd.large":    {Region: "eu-central-1", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.138},
		"r6gd.medium":   {Region: "eu-central-1", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.069},
		"r6gd.metal":    {Region: "eu-central-1", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.416},
		"r6gd.xlarge":   {Region: "eu-central-1", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.276},
		"t2.2xlarge":    {Region: "eu-central-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4288},
		"t2.large":      {Region: "eu-central-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1072},
		"t2.medium":     {Region: "eu-central-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0536},
		"t2.micro":      {Region: "eu-central-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0134},
		"t2.nano":       {Region: "eu-central-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0067},
		"t2.small":      {Region: "eu-central-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0268},
		"t2.xlarge":     {Region: "eu-central-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2144},
		"t3.2xlarge":    {Region: "eu-central-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"t3.large":      {Region: "eu-central-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"t3.medium":     {Region: "eu-central-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.048},
		"t3.micro":      {Region: "eu-central-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.012},
		"t3.nano":       {Region: "eu-central-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.006},
		"t3.small":      {Region: "eu-central-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.024},
		"t3.xlarge":     {Region: "eu-central-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"t3a.2xlarge":   {Region: "eu-central-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3456},
		"t3a.large":     {Region: "eu-central-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0864},
		"t3a.medium":    {Region: "eu-central-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0432},
		"t3a.micro":     {Region: "eu-central-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0108},
		"t3a.small":     {Region: "eu-central-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0216},
		"t3a.xlarge":    {Region: "eu-central-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1728},
		"t4g.2xlarge":   {Region: "eu-central-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3072},
		"t4g.large":     {Region: "eu-central-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0768},
		"t4g.medium":    {Region: "eu-central-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0384},
		"t4g.micro":     {Region: "eu-central-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0096},
		"t4g.nano":      {Region: "eu-central-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0048},
		"t4g.small":     {Region: "eu-central-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0192},
		"t4g.xlarge":    {Region: "eu-central-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1536},
		"x1.16xlarge":   {Region: "eu-central-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 9.337},
		"x1.32xlarge":   {Region: "eu-central-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 18.674},
		"x1e.16xlarge":  {Region: "eu-central-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 18.672},
		"x1e.2xlarge":   {Region: "eu-central-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.334},
		"x1e.32xlarge":  {Region: "eu-central-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 37.344},
		"x1e.4xlarge":   {Region: "eu-central-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.668},
		"x1e.8xlarge":   {Region: "eu-central-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 9.336},
		"x1e.xlarge":    {Region: "eu-central-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.167},
		"z1d.12xlarge":  {Region: "eu-central-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.4},
		"z1d.2xlarge":   {Region: "eu-central-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.9},
		"z1d.3xlarge":   {Region: "eu-central-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.35},
		"z1d.6xlarge":   {Region: "eu-central-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.7},
		"z1d.large":     {Region: "eu-central-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.225},
		"z1d.metal":     {Region: "eu-central-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.4},
		"z1d.xlarge":    {Region: "eu-central-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.45},
	},
	"eu-north-1": {
		"c5.12xlarge":   {Region: "eu-north-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.184},
		"c5.18xlarge":   {Region: "eu-north-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.276},
		"c5.24xlarge":   {Region: "eu-north-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.368},
		"c5.2xlarge":    {Region: "eu-north-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.364},
		"c5.4xlarge":    {Region: "eu-north-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.728},
		"c5.9xlarge":    {Region: "eu-north-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.638},
		"c5.large":      {Region: "eu-north-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.091},
		"c5.metal":      {Region: "eu-north-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.368},
		"c5.xlarge":     {Region: "eu-north-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.182},
		"c5a.12xlarge":  {Region: "eu-north-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.968},
		"c5a.16xlarge":  {Region: "eu-north-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.624},
		"c5a.24xlarge":  {Region: "eu-north-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.936},
		"c5a.2xlarge":   {Region: "eu-north-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.328},
		"c5a.4xlarge":   {Region: "eu-north-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.656},
		"c5a.8xlarge":   {Region: "eu-north-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.312},
		"c5a.large":     {Region: "eu-north-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.082},
		"c5a.xlarge":    {Region: "eu-north-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.164},
		"c5d.12xlarge":  {Region: "eu-north-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.496},
		"c5d.18xlarge":  {Region: "eu-north-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.744},
		"c5d.24xlarge":  {Region: "eu-north-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.992},
		"c5d.2xlarge":   {Region: "eu-north-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.416},
		"c5d.4xlarge":   {Region: "eu-north-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.832},
		"c5d.9xlarge":   {Region: "eu-north-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.872},
		"c5d.large":     {Region: "eu-north-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.104},
		"c5d.metal":     {Region: "eu-north-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.992},
		"c5d.xlarge":    {Region: "eu-north-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.208},
		"c5n.18xlarge":  {Region: "eu-north-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.176},
		"c5n.2xlarge":   {Region: "eu-north-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.464},
		"c5n.4xlarge":   {Region: "eu-north-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.928},
		"c5n.9xlarge":   {Region: "eu-north-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.088},
		"c5n.large":     {Region: "eu-north-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.116},
		"c5n.metal":     {Region: "eu-north-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.176},
		"c5n.xlarge":    {Region: "eu-north-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.232},
		"c6g.12xlarge":  {Region: "eu-north-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.752},
		"c6g.16xlarge":  {Region: "eu-north-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.336},
		"c6g.2xlarge":   {Region: "eu-north-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.292},
		"c6g.4xlarge":   {Region: "eu-north-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.584},
		"c6g.8xlarge":   {Region: "eu-north-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.168},
		"c6g.large":     {Region: "eu-north-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.073},
		"c6g.medium":    {Region: "eu-north-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0365},
		"c6g.metal":     {Region: "eu-north-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.336},
		"c6g.xlarge":    {Region: "eu-north-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.146},
		"d2.2xlarge":    {Region: "eu-north-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.396},
		"d2.4xlarge":    {Region: "eu-north-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.792},
		"d2.8xlarge":    {Region: "eu-north-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 5.584},
		"d2.xlarge":     {Region: "eu-north-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.698},
		"g4dn.12xlarge": {Region: "eu-north-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.15},
		"g4dn.16xlarge": {Region: "eu-north-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.617},
		"g4dn.2xlarge":  {Region: "eu-north-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.798},
		"g4dn.4xlarge":  {Region: "eu-north-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.277},
		"g4dn.8xlarge":  {Region: "eu-north-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.308},
		"g4dn.metal":    {Region: "eu-north-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 8.3},
		"g4dn.xlarge":   {Region: "eu-north-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.558},
		"i3.16xlarge":   {Region: "eu-north-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.216},
		"i3.2xlarge":    {Region: "eu-north-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.652},
		"i3.4xlarge":    {Region: "eu-north-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.304},
		"i3.8xlarge":    {Region: "eu-north-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.608},
		"i3.large":      {Region: "eu-north-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.163},
		"i3.xlarge":     {Region: "eu-north-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.326},
		"i3en.12xlarge": {Region: "eu-north-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.688},
		"i3en.24xlarge": {Region: "eu-north-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 11.376},
		"i3en.2xlarge":  {Region: "eu-north-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.948},
		"i3en.3xlarge":  {Region: "eu-north-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.422},
		"i3en.6xlarge":  {Region: "eu-north-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.844},
		"i3en.large":    {Region: "eu-north-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.237},
		"i3en.metal":    {Region: "eu-north-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 11.376},
		"i3en.xlarge":   {Region: "eu-north-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.474},
		"m5.12xlarge":   {Region: "eu-north-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.448},
		"m5.16xlarge":   {Region: "eu-north-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.264},
		"m5.24xlarge":   {Region: "eu-north-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.896},
		"m5.2xlarge":    {Region: "eu-north-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.408},
		"m5.4xlarge":    {Region: "eu-north-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.816},
		"m5.8xlarge":    {Region: "eu-north-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.632},
		"m5.large":      {Region: "eu-north-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.102},
		"m5.metal":      {Region: "eu-north-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.896},
		"m5.xlarge":     {Region: "eu-north-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.204},
		"m5d.12xlarge":  {Region: "eu-north-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.88},
		"m5d.16xlarge":  {Region: "eu-north-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.84},
		"m5d.24xlarge":  {Region: "eu-north-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5d.2xlarge":   {Region: "eu-north-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"m5d.4xlarge":   {Region: "eu-north-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.96},
		"m5d.8xlarge":   {Region: "eu-north-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.92},
		"m5d.large":     {Region: "eu-north-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"m5d.metal":     {Region: "eu-north-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5d.xlarge":    {Region: "eu-north-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"m6g.12xlarge":  {Region: "eu-north-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.968},
		"m6g.16xlarge":  {Region: "eu-north-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.624},
		"m6g.2xlarge":   {Region: "eu-north-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.328},
		"m6g.4xlarge":   {Region: "eu-north-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.656},
		"m6g.8xlarge":   {Region: "eu-north-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.312},
		"m6g.large":     {Region: "eu-north-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.082},
		"m6g.medium":    {Region: "eu-north-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.041},
		"m6g.metal":     {Region: "eu-north-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.624},
		"m6g.xlarge":    {Region: "eu-north-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.164},
		"r5.12xlarge":   {Region: "eu-north-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.216},
		"r5.16xlarge":   {Region: "eu-north-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.288},
		"r5.24xlarge":   {Region: "eu-north-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.432},
		"r5.2xlarge":    {Region: "eu-north-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.536},
		"r5.4xlarge":    {Region: "eu-north-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.072},
		"r5.8xlarge":    {Region: "eu-north-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.144},
		"r5.large":      {Region: "eu-north-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.134},
		"r5.metal":      {Region: "eu-north-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.432},
		"r5.xlarge":     {Region: "eu-north-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.268},
		"r5d.12xlarge":  {Region: "eu-north-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"r5d.16xlarge":  {Region: "eu-north-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"r5d.24xlarge":  {Region: "eu-north-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5d.2xlarge":   {Region: "eu-north-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"r5d.4xlarge":   {Region: "eu-north-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"r5d.8xlarge":   {Region: "eu-north-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"r5d.large":     {Region: "eu-north-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"r5d.metal":     {Region: "eu-north-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"r5d.xlarge":    {Region: "eu-north-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"r6g.12xlarge":  {Region: "eu-north-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.568},
		"r6g.16xlarge":  {Region: "eu-north-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.424},
		"r6g.2xlarge":   {Region: "eu-north-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.428},
		"r6g.4xlarge":   {Region: "eu-north-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.856},
		"r6g.8xlarge":   {Region: "eu-north-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.712},
		"r6g.large":     {Region: "eu-north-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.107},
		"r6g.medium":    {Region: "eu-north-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0535},
		"r6g.metal":     {Region: "eu-north-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.424},
		"r6g.xlarge":    {Region: "eu-north-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.214},
		"t3.2xlarge":    {Region: "eu-north-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3456},
		"t3.large":      {Region: "eu-north-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0864},
		"t3.medium":     {Region: "eu-north-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0432},
		"t3.micro":      {Region: "eu-north-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0108},
		"t3.nano":       {Region: "eu-north-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0054},
		"t3.small":      {Region: "eu-north-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0216},
		"t3.xlarge":     {Region: "eu-north-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1728},
		"t4g.2xlarge":   {Region: "eu-north-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2752},
		"t4g.large":     {Region: "eu-north-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0688},
		"t4g.medium":    {Region: "eu-north-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0344},
		"t4g.micro":     {Region: "eu-north-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0086},
		"t4g.nano":      {Region: "eu-north-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0043},
		"t4g.small":     {Region: "eu-north-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0172},
		"t4g.xlarge":    {Region: "eu-north-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1376},
	},
	"eu-south-1": {
		"c5.12xlarge":   {Region: "eu-south-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"c5.18xlarge":   {Region: "eu-south-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.636},
		"c5.24xlarge":   {Region: "eu-south-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5.2xlarge":    {Region: "eu-south-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"c5.4xlarge":    {Region: "eu-south-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"c5.9xlarge":    {Region: "eu-south-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.818},
		"c5.large":      {Region: "eu-south-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"c5.metal":      {Region: "eu-south-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5.xlarge":     {Region: "eu-south-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"c5d.12xlarge":  {Region: "eu-south-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.736},
		"c5d.18xlarge":  {Region: "eu-south-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.104},
		"c5d.24xlarge":  {Region: "eu-south-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.472},
		"c5d.2xlarge":   {Region: "eu-south-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.456},
		"c5d.4xlarge":   {Region: "eu-south-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.912},
		"c5d.9xlarge":   {Region: "eu-south-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.052},
		"c5d.large":     {Region: "eu-south-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.114},
		"c5d.metal":     {Region: "eu-south-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.472},
		"c5d.xlarge":    {Region: "eu-south-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.228},
		"d2.2xlarge":    {Region: "eu-south-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.544},
		"d2.4xlarge":    {Region: "eu-south-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.088},
		"d2.8xlarge":    {Region: "eu-south-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.176},
		"d2.xlarge":     {Region: "eu-south-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.772},
		"g4dn.12xlarge": {Region: "eu-south-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.58},
		"g4dn.16xlarge": {Region: "eu-south-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.095},
		"g4dn.2xlarge":  {Region: "eu-south-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.88},
		"g4dn.4xlarge":  {Region: "eu-south-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.41},
		"g4dn.8xlarge":  {Region: "eu-south-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.547},
		"g4dn.metal":    {Region: "eu-south-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.16},
		"g4dn.xlarge":   {Region: "eu-south-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.616},
		"i3.16xlarge":   {Region: "eu-south-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"i3.2xlarge":    {Region: "eu-south-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.724},
		"i3.4xlarge":    {Region: "eu-south-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.448},
		"i3.8xlarge":    {Region: "eu-south-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.896},
		"i3.large":      {Region: "eu-south-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.181},
		"i3.metal":      {Region: "eu-south-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"i3.xlarge":     {Region: "eu-south-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.362},
		"m5.12xlarge":   {Region: "eu-south-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.688},
		"m5.16xlarge":   {Region: "eu-south-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.584},
		"m5.24xlarge":   {Region: "eu-south-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5.2xlarge":    {Region: "eu-south-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.448},
		"m5.4xlarge":    {Region: "eu-south-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.896},
		"m5.8xlarge":    {Region: "eu-south-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.792},
		"m5.large":      {Region: "eu-south-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.112},
		"m5.metal":      {Region: "eu-south-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5.xlarge":     {Region: "eu-south-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.224},
		"m5d.12xlarge":  {Region: "eu-south-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.168},
		"m5d.16xlarge":  {Region: "eu-south-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.224},
		"m5d.24xlarge":  {Region: "eu-south-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.336},
		"m5d.2xlarge":   {Region: "eu-south-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.528},
		"m5d.4xlarge":   {Region: "eu-south-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.056},
		"m5d.8xlarge":   {Region: "eu-south-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.112},
		"m5d.large":     {Region: "eu-south-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.132},
		"m5d.metal":     {Region: "eu-south-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.336},
		"m5d.xlarge":    {Region: "eu-south-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.264},
		"r5.12xlarge":   {Region: "eu-south-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.552},
		"r5.16xlarge":   {Region: "eu-south-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.736},
		"r5.24xlarge":   {Region: "eu-south-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5.2xlarge":    {Region: "eu-south-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.592},
		"r5.4xlarge":    {Region: "eu-south-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.184},
		"r5.8xlarge":    {Region: "eu-south-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.368},
		"r5.large":      {Region: "eu-south-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.148},
		"r5.metal":      {Region: "eu-south-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5.xlarge":     {Region: "eu-south-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.296},
		"r5d.12xlarge":  {Region: "eu-south-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.032},
		"r5d.16xlarge":  {Region: "eu-south-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.376},
		"r5d.24xlarge":  {Region: "eu-south-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.064},
		"r5d.2xlarge":   {Region: "eu-south-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.672},
		"r5d.4xlarge":   {Region: "eu-south-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.344},
		"r5d.8xlarge":   {Region: "eu-south-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.688},
		"r5d.large":     {Region: "eu-south-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.168},
		"r5d.metal":     {Region: "eu-south-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.064},
		"r5d.xlarge":    {Region: "eu-south-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.336},
		"t3.2xlarge":    {Region: "eu-south-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3834},
		"t3.large":      {Region: "eu-south-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0958},
		"t3.medium":     {Region: "eu-south-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0479},
		"t3.micro":      {Region: "eu-south-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.012},
		"t3.nano":       {Region: "eu-south-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.006},
		"t3.small":      {Region: "eu-south-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.024},
		"t3.xlarge":     {Region: "eu-south-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1917},
	},
	"eu-west-1": {
		"a1.4xlarge":    {Region: "eu-west-1", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.4608},
		"a1.large":      {Region: "eu-west-1", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0576},
		"a1.medium":     {Region: "eu-west-1", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0288},
		"a1.metal":      {Region: "eu-west-1", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.461},
		"a1.xlarge":     {Region: "eu-west-1", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1152},
		"c1.medium":     {Region: "eu-west-1", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.148},
		"c1.xlarge":     {Region: "eu-west-1", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.592},
		"c3.2xlarge":    {Region: "eu-west-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.478},
		"c3.4xlarge":    {Region: "eu-west-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.956},
		"c3.8xlarge":    {Region: "eu-west-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.912},
		"c3.large":      {Region: "eu-west-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"c3.xlarge":     {Region: "eu-west-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.239},
		"c4.2xlarge":    {Region: "eu-west-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.453},
		"c4.4xlarge":    {Region: "eu-west-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.905},
		"c4.8xlarge":    {Region: "eu-west-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.811},
		"c4.large":      {Region: "eu-west-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"c4.xlarge":     {Region: "eu-west-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"c5.12xlarge":   {Region: "eu-west-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c5.18xlarge":   {Region: "eu-west-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.456},
		"c5.24xlarge":   {Region: "eu-west-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5.2xlarge":    {Region: "eu-west-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c5.4xlarge":    {Region: "eu-west-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c5.9xlarge":    {Region: "eu-west-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.728},
		"c5.large":      {Region: "eu-west-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c5.metal":      {Region: "eu-west-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5.xlarge":     {Region: "eu-west-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"c5a.12xlarge":  {Region: "eu-west-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"c5a.16xlarge":  {Region: "eu-west-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"c5a.24xlarge":  {Region: "eu-west-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"c5a.2xlarge":   {Region: "eu-west-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"c5a.4xlarge":   {Region: "eu-west-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"c5a.8xlarge":   {Region: "eu-west-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"c5a.large":     {Region: "eu-west-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"c5a.xlarge":    {Region: "eu-west-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"c5ad.12xlarge": {Region: "eu-west-1", Type: "c5ad.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.352},
		"c5ad.16xlarge": {Region: "eu-west-1", Type: "c5ad.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.136},
		"c5ad.24xlarge": {Region: "eu-west-1", Type: "c5ad.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.704},
		"c5ad.2xlarge":  {Region: "eu-west-1", Type: "c5ad.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.392},
		"c5ad.4xlarge":  {Region: "eu-west-1", Type: "c5ad.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.784},
		"c5ad.8xlarge":  {Region: "eu-west-1", Type: "c5ad.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.568},
		"c5ad.large":    {Region: "eu-west-1", Type: "c5ad.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.098},
		"c5ad.xlarge":   {Region: "eu-west-1", Type: "c5ad.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.196},
		"c5d.12xlarge":  {Region: "eu-west-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.616},
		"c5d.18xlarge":  {Region: "eu-west-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.924},
		"c5d.24xlarge":  {Region: "eu-west-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.232},
		"c5d.2xlarge":   {Region: "eu-west-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.436},
		"c5d.4xlarge":   {Region: "eu-west-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.872},
		"c5d.9xlarge":   {Region: "eu-west-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.962},
		"c5d.large":     {Region: "eu-west-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.109},
		"c5d.metal":     {Region: "eu-west-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.232},
		"c5d.xlarge":    {Region: "eu-west-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.218},
		"c5n.18xlarge":  {Region: "eu-west-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.392},
		"c5n.2xlarge":   {Region: "eu-west-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"c5n.4xlarge":   {Region: "eu-west-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"c5n.9xlarge":   {Region: "eu-west-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.196},
		"c5n.large":     {Region: "eu-west-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"c5n.metal":     {Region: "eu-west-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.392},
		"c5n.xlarge":    {Region: "eu-west-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"c6g.12xlarge":  {Region: "eu-west-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.8432},
		"c6g.16xlarge":  {Region: "eu-west-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6g.2xlarge":   {Region: "eu-west-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3072},
		"c6g.4xlarge":   {Region: "eu-west-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6144},
		"c6g.8xlarge":   {Region: "eu-west-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2288},
		"c6g.large":     {Region: "eu-west-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0768},
		"c6g.medium":    {Region: "eu-west-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0384},
		"c6g.metal":     {Region: "eu-west-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6g.xlarge":    {Region: "eu-west-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1536},
		"c6gd.12xlarge": {Region: "eu-west-1", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0928},
		"c6gd.16xlarge": {Region: "eu-west-1", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7904},
		"c6gd.2xlarge":  {Region: "eu-west-1", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3488},
		"c6gd.4xlarge":  {Region: "eu-west-1", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6976},
		"c6gd.8xlarge":  {Region: "eu-west-1", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3952},
		"c6gd.large":    {Region: "eu-west-1", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0872},
		"c6gd.medium":   {Region: "eu-west-1", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0436},
		"c6gd.metal":    {Region: "eu-west-1", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7904},
		"c6gd.xlarge":   {Region: "eu-west-1", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1744},
		"c6gn.12xlarge": {Region: "eu-west-1", Type: "c6gn.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.3424},
		"c6gn.16xlarge": {Region: "eu-west-1", Type: "c6gn.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.1232},
		"c6gn.2xlarge":  {Region: "eu-west-1", Type: "c6gn.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3904},
		"c6gn.4xlarge":  {Region: "eu-west-1", Type: "c6gn.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7808},
		"c6gn.8xlarge":  {Region: "eu-west-1", Type: "c6gn.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.5616},
		"c6gn.large":    {Region: "eu-west-1", Type: "c6gn.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0976},
		"c6gn.medium":   {Region: "eu-west-1", Type: "c6gn.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0488},
		"c6gn.xlarge":   {Region: "eu-west-1", Type: "c6gn.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1952},
		"cc2.8xlarge":   {Region: "eu-west-1", Type: "cc2.8xlarge", Memory: kresource.MustParse("61952Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.25},
		"cr1.8xlarge":   {Region: "eu-west-1", Type: "cr1.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.75},
		"d2.2xlarge":    {Region: "eu-west-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.47},
		"d2.4xlarge":    {Region: "eu-west-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.94},
		"d2.8xlarge":    {Region: "eu-west-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 5.88},
		"d2.xlarge":     {Region: "eu-west-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.735},
		"d3.2xlarge":    {Region: "eu-west-1", Type: "d3.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.219},
		"d3.4xlarge":    {Region: "eu-west-1", Type: "d3.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.437},
		"d3.8xlarge":    {Region: "eu-west-1", Type: "d3.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 4.87448},
		"d3.xlarge":     {Region: "eu-west-1", Type: "d3.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.609},
		"d3en.12xlarge": {Region: "eu-west-1", Type: "d3en.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 7.69656},
		"d3en.2xlarge":  {Region: "eu-west-1", Type: "d3en.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.283},
		"d3en.4xlarge":  {Region: "eu-west-1", Type: "d3en.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.566},
		"d3en.6xlarge":  {Region: "eu-west-1", Type: "d3en.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.848},
		"d3en.8xlarge":  {Region: "eu-west-1", Type: "d3en.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 5.13104},
		"d3en.xlarge":   {Region: "eu-west-1", Type: "d3en.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.641},
		"f1.16xlarge":   {Region: "eu-west-1", Type: "f1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 14.52},
		"f1.2xlarge":    {Region: "eu-west-1", Type: "f1.2xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.815},
		"f1.4xlarge":    {Region: "eu-west-1", Type: "f1.4xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.63},
		"g2.2xlarge":    {Region: "eu-west-1", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.702},
		"g2.8xlarge":    {Region: "eu-west-1", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 2.808},
		"g3.16xlarge":   {Region: "eu-west-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 4.84},
		"g3.4xlarge":    {Region: "eu-west-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.21},
		"g3.8xlarge":    {Region: "eu-west-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.42},
		"g3s.xlarge":    {Region: "eu-west-1", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.796},
		"g4ad.16xlarge": {Region: "eu-west-1", Type: "g4ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 3.872},
		"g4ad.4xlarge":  {Region: "eu-west-1", Type: "g4ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 0.968},
		"g4ad.8xlarge":  {Region: "eu-west-1", Type: "g4ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 1.936},
		"g4dn.12xlarge": {Region: "eu-west-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.362},
		"g4dn.16xlarge": {Region: "eu-west-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.853},
		"g4dn.2xlarge":  {Region: "eu-west-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.838},
		"g4dn.4xlarge":  {Region: "eu-west-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.342},
		"g4dn.8xlarge":  {Region: "eu-west-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.426},
		"g4dn.metal":    {Region: "eu-west-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 8.724},
		"g4dn.xlarge":   {Region: "eu-west-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.587},
		"h1.16xlarge":   {Region: "eu-west-1", Type: "h1.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.152},
		"h1.2xlarge":    {Region: "eu-west-1", Type: "h1.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.519},
		"h1.4xlarge":    {Region: "eu-west-1", Type: "h1.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.038},
		"h1.8xlarge":    {Region: "eu-west-1", Type: "h1.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.076},
		"hs1.8xlarge":   {Region: "eu-west-1", Type: "hs1.8xlarge", Memory: kresource.MustParse("119808Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.9},
		"i2.2xlarge":    {Region: "eu-west-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.876},
		"i2.4xlarge":    {Region: "eu-west-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.751},
		"i2.8xlarge":    {Region: "eu-west-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 7.502},
		"i2.xlarge":     {Region: "eu-west-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.938},
		"i3.16xlarge":   {Region: "eu-west-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.504},
		"i3.2xlarge":    {Region: "eu-west-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.688},
		"i3.4xlarge":    {Region: "eu-west-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.376},
		"i3.8xlarge":    {Region: "eu-west-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.752},
		"i3.large":      {Region: "eu-west-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.172},
		"i3.metal":      {Region: "eu-west-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.504},
		"i3.xlarge":     {Region: "eu-west-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.344},
		"i3en.12xlarge": {Region: "eu-west-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.0},
		"i3en.24xlarge": {Region: "eu-west-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.0},
		"i3en.2xlarge":  {Region: "eu-west-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.0},
		"i3en.3xlarge":  {Region: "eu-west-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.5},
		"i3en.6xlarge":  {Region: "eu-west-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.0},
		"i3en.large":    {Region: "eu-west-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.25},
		"i3en.metal":    {Region: "eu-west-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.0},
		"i3en.xlarge":   {Region: "eu-west-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.5},
		"inf1.24xlarge": {Region: "eu-west-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 8.484},
		"inf1.2xlarge":  {Region: "eu-west-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.651},
		"inf1.6xlarge":  {Region: "eu-west-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.121},
		"inf1.xlarge":   {Region: "eu-west-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.41},
		"m1.large":      {Region: "eu-west-1", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.19},
		"m1.medium":     {Region: "eu-west-1", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.095},
		"m1.small":      {Region: "eu-west-1", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.047},
		"m1.xlarge":     {Region: "eu-west-1", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.379},
		"m2.2xlarge":    {Region: "eu-west-1", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.55},
		"m2.4xlarge":    {Region: "eu-west-1", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.1},
		"m2.xlarge":     {Region: "eu-west-1", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.275},
		"m3.2xlarge":    {Region: "eu-west-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.585},
		"m3.large":      {Region: "eu-west-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.146},
		"m3.medium":     {Region: "eu-west-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.073},
		"m3.xlarge":     {Region: "eu-west-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.293},
		"m4.10xlarge":   {Region: "eu-west-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.22},
		"m4.16xlarge":   {Region: "eu-west-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.552},
		"m4.2xlarge":    {Region: "eu-west-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.444},
		"m4.4xlarge":    {Region: "eu-west-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.888},
		"m4.large":      {Region: "eu-west-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.111},
		"m4.xlarge":     {Region: "eu-west-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.222},
		"m5.12xlarge":   {Region: "eu-west-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.568},
		"m5.16xlarge":   {Region: "eu-west-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.424},
		"m5.24xlarge":   {Region: "eu-west-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"m5.2xlarge":    {Region: "eu-west-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.428},
		"m5.4xlarge":    {Region: "eu-west-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.856},
		"m5.8xlarge":    {Region: "eu-west-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.712},
		"m5.large":      {Region: "eu-west-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.107},
		"m5.metal":      {Region: "eu-west-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.136},
		"m5.xlarge":     {Region: "eu-west-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.214},
		"m5a.12xlarge":  {Region: "eu-west-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m5a.16xlarge":  {Region: "eu-west-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m5a.24xlarge":  {Region: "eu-west-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5a.2xlarge":   {Region: "eu-west-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m5a.4xlarge":   {Region: "eu-west-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m5a.8xlarge":   {Region: "eu-west-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m5a.large":     {Region: "eu-west-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m5a.xlarge":    {Region: "eu-west-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m5ad.12xlarge": {Region: "eu-west-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.76},
		"m5ad.16xlarge": {Region: "eu-west-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.68},
		"m5ad.24xlarge": {Region: "eu-west-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.52},
		"m5ad.2xlarge":  {Region: "eu-west-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.46},
		"m5ad.4xlarge":  {Region: "eu-west-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.92},
		"m5ad.8xlarge":  {Region: "eu-west-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.84},
		"m5ad.large":    {Region: "eu-west-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"m5ad.xlarge":   {Region: "eu-west-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.23},
		"m5d.12xlarge":  {Region: "eu-west-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"m5d.16xlarge":  {Region: "eu-west-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.032},
		"m5d.24xlarge":  {Region: "eu-west-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"m5d.2xlarge":   {Region: "eu-west-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"m5d.4xlarge":   {Region: "eu-west-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"m5d.8xlarge":   {Region: "eu-west-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.016},
		"m5d.large":     {Region: "eu-west-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"m5d.metal":     {Region: "eu-west-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"m5d.xlarge":    {Region: "eu-west-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"m5dn.12xlarge": {Region: "eu-west-1", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.648},
		"m5dn.16xlarge": {Region: "eu-west-1", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.864},
		"m5dn.24xlarge": {Region: "eu-west-1", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"m5dn.2xlarge":  {Region: "eu-west-1", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.608},
		"m5dn.4xlarge":  {Region: "eu-west-1", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.216},
		"m5dn.8xlarge":  {Region: "eu-west-1", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.432},
		"m5dn.large":    {Region: "eu-west-1", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.152},
		"m5dn.metal":    {Region: "eu-west-1", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.296},
		"m5dn.xlarge":   {Region: "eu-west-1", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.304},
		"m5n.12xlarge":  {Region: "eu-west-1", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.192},
		"m5n.16xlarge":  {Region: "eu-west-1", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"m5n.24xlarge":  {Region: "eu-west-1", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.384},
		"m5n.2xlarge":   {Region: "eu-west-1", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"m5n.4xlarge":   {Region: "eu-west-1", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"m5n.8xlarge":   {Region: "eu-west-1", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"m5n.large":     {Region: "eu-west-1", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"m5n.metal":     {Region: "eu-west-1", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.384},
		"m5n.xlarge":    {Region: "eu-west-1", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"m5zn.12xlarge": {Region: "eu-west-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.4184},
		"m5zn.2xlarge":  {Region: "eu-west-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.7364},
		"m5zn.3xlarge":  {Region: "eu-west-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.1046},
		"m5zn.6xlarge":  {Region: "eu-west-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.2092},
		"m5zn.large":    {Region: "eu-west-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1841},
		"m5zn.metal":    {Region: "eu-west-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.4184},
		"m5zn.xlarge":   {Region: "eu-west-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3682},
		"m6g.12xlarge":  {Region: "eu-west-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"m6g.16xlarge":  {Region: "eu-west-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"m6g.2xlarge":   {Region: "eu-west-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"m6g.4xlarge":   {Region: "eu-west-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"m6g.8xlarge":   {Region: "eu-west-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"m6g.large":     {Region: "eu-west-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"m6g.medium":    {Region: "eu-west-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.043},
		"m6g.metal":     {Region: "eu-west-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"m6g.xlarge":    {Region: "eu-west-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"m6gd.12xlarge": {Region: "eu-west-1", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4192},
		"m6gd.16xlarge": {Region: "eu-west-1", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"m6gd.2xlarge":  {Region: "eu-west-1", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4032},
		"m6gd.4xlarge":  {Region: "eu-west-1", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8064},
		"m6gd.8xlarge":  {Region: "eu-west-1", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6128},
		"m6gd.large":    {Region: "eu-west-1", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1008},
		"m6gd.medium":   {Region: "eu-west-1", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0504},
		"m6gd.metal":    {Region: "eu-west-1", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"m6gd.xlarge":   {Region: "eu-west-1", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2016},
		"p2.16xlarge":   {Region: "eu-west-1", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 15.552},
		"p2.8xlarge":    {Region: "eu-west-1", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 7.776},
		"p2.xlarge":     {Region: "eu-west-1", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.972},
		"p3.16xlarge":   {Region: "eu-west-1", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 26.44},
		"p3.2xlarge":    {Region: "eu-west-1", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.305},
		"p3.8xlarge":    {Region: "eu-west-1", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 13.22},
		"p3dn.24xlarge": {Region: "eu-west-1", Type: "p3dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 33.711},
		"p4d.24xlarge":  {Region: "eu-west-1", Type: "p4d.24xlarge", Memory: kresource.MustParse("1179648Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 35.39655},
		"r3.2xlarge":    {Region: "eu-west-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.741},
		"r3.4xlarge":    {Region: "eu-west-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.482},
		"r3.8xlarge":    {Region: "eu-west-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.964},
		"r3.large":      {Region: "eu-west-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.185},
		"r3.xlarge":     {Region: "eu-west-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.371},
		"r4.16xlarge":   {Region: "eu-west-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.7424},
		"r4.2xlarge":    {Region: "eu-west-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5928},
		"r4.4xlarge":    {Region: "eu-west-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.1856},
		"r4.8xlarge":    {Region: "eu-west-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.3712},
		"r4.large":      {Region: "eu-west-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1482},
		"r4.xlarge":     {Region: "eu-west-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2964},
		"r5.12xlarge":   {Region: "eu-west-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.384},
		"r5.16xlarge":   {Region: "eu-west-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.512},
		"r5.24xlarge":   {Region: "eu-west-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.768},
		"r5.2xlarge":    {Region: "eu-west-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.564},
		"r5.4xlarge":    {Region: "eu-west-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.128},
		"r5.8xlarge":    {Region: "eu-west-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.256},
		"r5.large":      {Region: "eu-west-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.141},
		"r5.metal":      {Region: "eu-west-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.768},
		"r5.xlarge":     {Region: "eu-west-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.282},
		"r5a.12xlarge":  {Region: "eu-west-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.048},
		"r5a.16xlarge":  {Region: "eu-west-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.064},
		"r5a.24xlarge":  {Region: "eu-west-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.096},
		"r5a.2xlarge":   {Region: "eu-west-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.508},
		"r5a.4xlarge":   {Region: "eu-west-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.016},
		"r5a.8xlarge":   {Region: "eu-west-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.032},
		"r5a.large":     {Region: "eu-west-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.127},
		"r5a.xlarge":    {Region: "eu-west-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.254},
		"r5ad.12xlarge": {Region: "eu-west-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.504},
		"r5ad.16xlarge": {Region: "eu-west-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.672},
		"r5ad.24xlarge": {Region: "eu-west-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.008},
		"r5ad.2xlarge":  {Region: "eu-west-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.584},
		"r5ad.4xlarge":  {Region: "eu-west-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.168},
		"r5ad.8xlarge":  {Region: "eu-west-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.336},
		"r5ad.large":    {Region: "eu-west-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.146},
		"r5ad.xlarge":   {Region: "eu-west-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.292},
		"r5d.12xlarge":  {Region: "eu-west-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.84},
		"r5d.16xlarge":  {Region: "eu-west-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.12},
		"r5d.24xlarge":  {Region: "eu-west-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.68},
		"r5d.2xlarge":   {Region: "eu-west-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.64},
		"r5d.4xlarge":   {Region: "eu-west-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.28},
		"r5d.8xlarge":   {Region: "eu-west-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.56},
		"r5d.large":     {Region: "eu-west-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.16},
		"r5d.metal":     {Region: "eu-west-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.68},
		"r5d.xlarge":    {Region: "eu-west-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.32},
		"r5dn.12xlarge": {Region: "eu-west-1", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"r5dn.16xlarge": {Region: "eu-west-1", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.952},
		"r5dn.24xlarge": {Region: "eu-west-1", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.928},
		"r5dn.2xlarge":  {Region: "eu-west-1", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.744},
		"r5dn.4xlarge":  {Region: "eu-west-1", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.488},
		"r5dn.8xlarge":  {Region: "eu-west-1", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.976},
		"r5dn.large":    {Region: "eu-west-1", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.186},
		"r5dn.metal":    {Region: "eu-west-1", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.928},
		"r5dn.xlarge":   {Region: "eu-west-1", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.372},
		"r5n.12xlarge":  {Region: "eu-west-1", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.008},
		"r5n.16xlarge":  {Region: "eu-west-1", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.344},
		"r5n.24xlarge":  {Region: "eu-west-1", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5n.2xlarge":   {Region: "eu-west-1", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.668},
		"r5n.4xlarge":   {Region: "eu-west-1", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.336},
		"r5n.8xlarge":   {Region: "eu-west-1", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.672},
		"r5n.large":     {Region: "eu-west-1", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.167},
		"r5n.metal":     {Region: "eu-west-1", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5n.xlarge":    {Region: "eu-west-1", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.334},
		"r6g.12xlarge":  {Region: "eu-west-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.7072},
		"r6g.16xlarge":  {Region: "eu-west-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6096},
		"r6g.2xlarge":   {Region: "eu-west-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4512},
		"r6g.4xlarge":   {Region: "eu-west-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9024},
		"r6g.8xlarge":   {Region: "eu-west-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.8048},
		"r6g.large":     {Region: "eu-west-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1128},
		"r6g.medium":    {Region: "eu-west-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0564},
		"r6g.metal":     {Region: "eu-west-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6096},
		"r6g.xlarge":    {Region: "eu-west-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2256},
		"r6gd.12xlarge": {Region: "eu-west-1", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.072},
		"r6gd.16xlarge": {Region: "eu-west-1", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.096},
		"r6gd.2xlarge":  {Region: "eu-west-1", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.512},
		"r6gd.4xlarge":  {Region: "eu-west-1", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.024},
		"r6gd.8xlarge":  {Region: "eu-west-1", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.048},
		"r6gd.large":    {Region: "eu-west-1", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.128},
		"r6gd.medium":   {Region: "eu-west-1", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.064},
		"r6gd.metal":    {Region: "eu-west-1", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.096},
		"r6gd.xlarge":   {Region: "eu-west-1", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.256},
		"t1.micro":      {Region: "eu-west-1", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.02},
		"t2.2xlarge":    {Region: "eu-west-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4032},
		"t2.large":      {Region: "eu-west-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1008},
		"t2.medium":     {Region: "eu-west-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.05},
		"t2.micro":      {Region: "eu-west-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0126},
		"t2.nano":       {Region: "eu-west-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0063},
		"t2.small":      {Region: "eu-west-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.025},
		"t2.xlarge":     {Region: "eu-west-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2016},
		"t3.2xlarge":    {Region: "eu-west-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3648},
		"t3.large":      {Region: "eu-west-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0912},
		"t3.medium":     {Region: "eu-west-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0456},
		"t3.micro":      {Region: "eu-west-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0114},
		"t3.nano":       {Region: "eu-west-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0057},
		"t3.small":      {Region: "eu-west-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0228},
		"t3.xlarge":     {Region: "eu-west-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1824},
		"t3a.2xlarge":   {Region: "eu-west-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3264},
		"t3a.large":     {Region: "eu-west-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0816},
		"t3a.medium":    {Region: "eu-west-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0408},
		"t3a.micro":     {Region: "eu-west-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0102},
		"t3a.small":     {Region: "eu-west-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0204},
		"t3a.xlarge":    {Region: "eu-west-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1632},
		"t4g.2xlarge":   {Region: "eu-west-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2944},
		"t4g.large":     {Region: "eu-west-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0736},
		"t4g.medium":    {Region: "eu-west-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0368},
		"t4g.micro":     {Region: "eu-west-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0092},
		"t4g.nano":      {Region: "eu-west-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0046},
		"t4g.small":     {Region: "eu-west-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0184},
		"t4g.xlarge":    {Region: "eu-west-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1472},
		"x1.16xlarge":   {Region: "eu-west-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 8.003},
		"x1.32xlarge":   {Region: "eu-west-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 16.006},
		"x1e.16xlarge":  {Region: "eu-west-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 16.0},
		"x1e.2xlarge":   {Region: "eu-west-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 2.0},
		"x1e.32xlarge":  {Region: "eu-west-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 32.0},
		"x1e.4xlarge":   {Region: "eu-west-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.0},
		"x1e.8xlarge":   {Region: "eu-west-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 8.0},
		"x1e.xlarge":    {Region: "eu-west-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.0},
		"z1d.12xlarge":  {Region: "eu-west-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.992},
		"z1d.2xlarge":   {Region: "eu-west-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.832},
		"z1d.3xlarge":   {Region: "eu-west-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.248},
		"z1d.6xlarge":   {Region: "eu-west-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.496},
		"z1d.large":     {Region: "eu-west-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.208},
		"z1d.metal":     {Region: "eu-west-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.992},
		"z1d.xlarge":    {Region: "eu-west-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.416},
	},
	"eu-west-2": {
		"c4.2xlarge":    {Region: "eu-west-2", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.476},
		"c4.4xlarge":    {Region: "eu-west-2", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.95},
		"c4.8xlarge":    {Region: "eu-west-2", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.902},
		"c4.large":      {Region: "eu-west-2", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.119},
		"c4.xlarge":     {Region: "eu-west-2", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.237},
		"c5.12xlarge":   {Region: "eu-west-2", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"c5.18xlarge":   {Region: "eu-west-2", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.636},
		"c5.24xlarge":   {Region: "eu-west-2", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5.2xlarge":    {Region: "eu-west-2", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"c5.4xlarge":    {Region: "eu-west-2", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"c5.9xlarge":    {Region: "eu-west-2", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.818},
		"c5.large":      {Region: "eu-west-2", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"c5.metal":      {Region: "eu-west-2", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5.xlarge":     {Region: "eu-west-2", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"c5a.12xlarge":  {Region: "eu-west-2", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.184},
		"c5a.16xlarge":  {Region: "eu-west-2", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.912},
		"c5a.24xlarge":  {Region: "eu-west-2", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.368},
		"c5a.2xlarge":   {Region: "eu-west-2", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.364},
		"c5a.4xlarge":   {Region: "eu-west-2", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.728},
		"c5a.8xlarge":   {Region: "eu-west-2", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.456},
		"c5a.large":     {Region: "eu-west-2", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.091},
		"c5a.xlarge":    {Region: "eu-west-2", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.182},
		"c5d.12xlarge":  {Region: "eu-west-2", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.76},
		"c5d.18xlarge":  {Region: "eu-west-2", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.14},
		"c5d.24xlarge":  {Region: "eu-west-2", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.52},
		"c5d.2xlarge":   {Region: "eu-west-2", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.46},
		"c5d.4xlarge":   {Region: "eu-west-2", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.92},
		"c5d.9xlarge":   {Region: "eu-west-2", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.07},
		"c5d.large":     {Region: "eu-west-2", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"c5d.metal":     {Region: "eu-west-2", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.52},
		"c5d.xlarge":    {Region: "eu-west-2", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.23},
		"c5n.18xlarge":  {Region: "eu-west-2", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.608},
		"c5n.2xlarge":   {Region: "eu-west-2", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.512},
		"c5n.4xlarge":   {Region: "eu-west-2", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.024},
		"c5n.9xlarge":   {Region: "eu-west-2", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.304},
		"c5n.large":     {Region: "eu-west-2", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.128},
		"c5n.metal":     {Region: "eu-west-2", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.608},
		"c5n.xlarge":    {Region: "eu-west-2", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.256},
		"c6g.12xlarge":  {Region: "eu-west-2", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.9392},
		"c6g.16xlarge":  {Region: "eu-west-2", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.5856},
		"c6g.2xlarge":   {Region: "eu-west-2", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3232},
		"c6g.4xlarge":   {Region: "eu-west-2", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6464},
		"c6g.8xlarge":   {Region: "eu-west-2", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2928},
		"c6g.large":     {Region: "eu-west-2", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0808},
		"c6g.medium":    {Region: "eu-west-2", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0404},
		"c6g.metal":     {Region: "eu-west-2", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.5856},
		"c6g.xlarge":    {Region: "eu-west-2", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1616},
		"d2.2xlarge":    {Region: "eu-west-2", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.544},
		"d2.4xlarge":    {Region: "eu-west-2", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.087},
		"d2.8xlarge":    {Region: "eu-west-2", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.174},
		"d2.xlarge":     {Region: "eu-west-2", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.772},
		"g3.16xlarge":   {Region: "eu-west-2", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 5.716},
		"g3.4xlarge":    {Region: "eu-west-2", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.429},
		"g3.8xlarge":    {Region: "eu-west-2", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.858},
		"g3s.xlarge":    {Region: "eu-west-2", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.94},
		"g4dn.12xlarge": {Region: "eu-west-2", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.577},
		"g4dn.16xlarge": {Region: "eu-west-2", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.092},
		"g4dn.2xlarge":  {Region: "eu-west-2", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.88},
		"g4dn.4xlarge":  {Region: "eu-west-2", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.409},
		"g4dn.8xlarge":  {Region: "eu-west-2", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.546},
		"g4dn.metal":    {Region: "eu-west-2", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.154},
		"g4dn.xlarge":   {Region: "eu-west-2", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.615},
		"i3.16xlarge":   {Region: "eu-west-2", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"i3.2xlarge":    {Region: "eu-west-2", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.724},
		"i3.4xlarge":    {Region: "eu-west-2", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.448},
		"i3.8xlarge":    {Region: "eu-west-2", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.896},
		"i3.large":      {Region: "eu-west-2", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.181},
		"i3.xlarge":     {Region: "eu-west-2", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.362},
		"i3en.12xlarge": {Region: "eu-west-2", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.312},
		"i3en.24xlarge": {Region: "eu-west-2", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.624},
		"i3en.2xlarge":  {Region: "eu-west-2", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.052},
		"i3en.3xlarge":  {Region: "eu-west-2", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.578},
		"i3en.6xlarge":  {Region: "eu-west-2", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.156},
		"i3en.large":    {Region: "eu-west-2", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.263},
		"i3en.metal":    {Region: "eu-west-2", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.624},
		"i3en.xlarge":   {Region: "eu-west-2", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.526},
		"inf1.24xlarge": {Region: "eu-west-2", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 8.919},
		"inf1.2xlarge":  {Region: "eu-west-2", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.684},
		"inf1.6xlarge":  {Region: "eu-west-2", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.23},
		"inf1.xlarge":   {Region: "eu-west-2", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.431},
		"m4.10xlarge":   {Region: "eu-west-2", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.32},
		"m4.16xlarge":   {Region: "eu-west-2", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.712},
		"m4.2xlarge":    {Region: "eu-west-2", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.464},
		"m4.4xlarge":    {Region: "eu-west-2", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.928},
		"m4.large":      {Region: "eu-west-2", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.116},
		"m4.xlarge":     {Region: "eu-west-2", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.232},
		"m5.12xlarge":   {Region: "eu-west-2", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.664},
		"m5.16xlarge":   {Region: "eu-west-2", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.552},
		"m5.24xlarge":   {Region: "eu-west-2", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.328},
		"m5.2xlarge":    {Region: "eu-west-2", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.444},
		"m5.4xlarge":    {Region: "eu-west-2", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.888},
		"m5.8xlarge":    {Region: "eu-west-2", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.776},
		"m5.large":      {Region: "eu-west-2", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.111},
		"m5.metal":      {Region: "eu-west-2", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.328},
		"m5.xlarge":     {Region: "eu-west-2", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.222},
		"m5a.12xlarge":  {Region: "eu-west-2", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4},
		"m5a.16xlarge":  {Region: "eu-west-2", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2},
		"m5a.24xlarge":  {Region: "eu-west-2", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.8},
		"m5a.2xlarge":   {Region: "eu-west-2", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"m5a.4xlarge":   {Region: "eu-west-2", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"m5a.8xlarge":   {Region: "eu-west-2", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6},
		"m5a.large":     {Region: "eu-west-2", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"m5a.xlarge":    {Region: "eu-west-2", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"m5ad.12xlarge": {Region: "eu-west-2", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.88},
		"m5ad.16xlarge": {Region: "eu-west-2", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.84},
		"m5ad.24xlarge": {Region: "eu-west-2", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"m5ad.2xlarge":  {Region: "eu-west-2", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"m5ad.4xlarge":  {Region: "eu-west-2", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.96},
		"m5ad.8xlarge":  {Region: "eu-west-2", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.92},
		"m5ad.large":    {Region: "eu-west-2", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"m5ad.xlarge":   {Region: "eu-west-2", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"m5d.12xlarge":  {Region: "eu-west-2", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.144},
		"m5d.16xlarge":  {Region: "eu-west-2", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.192},
		"m5d.24xlarge":  {Region: "eu-west-2", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"m5d.2xlarge":   {Region: "eu-west-2", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.524},
		"m5d.4xlarge":   {Region: "eu-west-2", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.048},
		"m5d.8xlarge":   {Region: "eu-west-2", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.096},
		"m5d.large":     {Region: "eu-west-2", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.131},
		"m5d.metal":     {Region: "eu-west-2", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"m5d.xlarge":    {Region: "eu-west-2", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.262},
		"m6g.12xlarge":  {Region: "eu-west-2", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.1312},
		"m6g.16xlarge":  {Region: "eu-west-2", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8416},
		"m6g.2xlarge":   {Region: "eu-west-2", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3552},
		"m6g.4xlarge":   {Region: "eu-west-2", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7104},
		"m6g.8xlarge":   {Region: "eu-west-2", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.4208},
		"m6g.large":     {Region: "eu-west-2", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0888},
		"m6g.medium":    {Region: "eu-west-2", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0444},
		"m6g.metal":     {Region: "eu-west-2", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8416},
		"m6g.xlarge":    {Region: "eu-west-2", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1776},
		"p3.16xlarge":   {Region: "eu-west-2", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 28.712},
		"p3.2xlarge":    {Region: "eu-west-2", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.589},
		"p3.8xlarge":    {Region: "eu-west-2", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 14.356},
		"r4.16xlarge":   {Region: "eu-west-2", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"r4.2xlarge":    {Region: "eu-west-2", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.624},
		"r4.4xlarge":    {Region: "eu-west-2", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.248},
		"r4.8xlarge":    {Region: "eu-west-2", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.496},
		"r4.large":      {Region: "eu-west-2", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.156},
		"r4.xlarge":     {Region: "eu-west-2", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.312},
		"r5.12xlarge":   {Region: "eu-west-2", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.552},
		"r5.16xlarge":   {Region: "eu-west-2", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.736},
		"r5.24xlarge":   {Region: "eu-west-2", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5.2xlarge":    {Region: "eu-west-2", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.592},
		"r5.4xlarge":    {Region: "eu-west-2", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.184},
		"r5.8xlarge":    {Region: "eu-west-2", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.368},
		"r5.large":      {Region: "eu-west-2", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.148},
		"r5.metal":      {Region: "eu-west-2", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5.xlarge":     {Region: "eu-west-2", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.296},
		"r5a.12xlarge":  {Region: "eu-west-2", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.192},
		"r5a.16xlarge":  {Region: "eu-west-2", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"r5a.24xlarge":  {Region: "eu-west-2", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.384},
		"r5a.2xlarge":   {Region: "eu-west-2", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"r5a.4xlarge":   {Region: "eu-west-2", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"r5a.8xlarge":   {Region: "eu-west-2", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"r5a.large":     {Region: "eu-west-2", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"r5a.xlarge":    {Region: "eu-west-2", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"r5ad.12xlarge": {Region: "eu-west-2", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.696},
		"r5ad.16xlarge": {Region: "eu-west-2", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.928},
		"r5ad.24xlarge": {Region: "eu-west-2", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.392},
		"r5ad.2xlarge":  {Region: "eu-west-2", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.616},
		"r5ad.4xlarge":  {Region: "eu-west-2", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.232},
		"r5ad.8xlarge":  {Region: "eu-west-2", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.464},
		"r5ad.large":    {Region: "eu-west-2", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.154},
		"r5ad.xlarge":   {Region: "eu-west-2", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.308},
		"r5d.12xlarge":  {Region: "eu-west-2", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.056},
		"r5d.16xlarge":  {Region: "eu-west-2", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.408},
		"r5d.24xlarge":  {Region: "eu-west-2", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.112},
		"r5d.2xlarge":   {Region: "eu-west-2", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.676},
		"r5d.4xlarge":   {Region: "eu-west-2", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.352},
		"r5d.8xlarge":   {Region: "eu-west-2", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.704},
		"r5d.large":     {Region: "eu-west-2", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.169},
		"r5d.metal":     {Region: "eu-west-2", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.112},
		"r5d.xlarge":    {Region: "eu-west-2", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.338},
		"r6g.12xlarge":  {Region: "eu-west-2", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.8416},
		"r6g.16xlarge":  {Region: "eu-west-2", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.7888},
		"r6g.2xlarge":   {Region: "eu-west-2", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4736},
		"r6g.4xlarge":   {Region: "eu-west-2", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9472},
		"r6g.8xlarge":   {Region: "eu-west-2", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.8944},
		"r6g.large":     {Region: "eu-west-2", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1184},
		"r6g.medium":    {Region: "eu-west-2", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0592},
		"r6g.metal":     {Region: "eu-west-2", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.7888},
		"r6g.xlarge":    {Region: "eu-west-2", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2368},
		"t2.2xlarge":    {Region: "eu-west-2", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4224},
		"t2.large":      {Region: "eu-west-2", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1056},
		"t2.medium":     {Region: "eu-west-2", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.052},
		"t2.micro":      {Region: "eu-west-2", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0132},
		"t2.nano":       {Region: "eu-west-2", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0066},
		"t2.small":      {Region: "eu-west-2", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.026},
		"t2.xlarge":     {Region: "eu-west-2", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2112},
		"t3.2xlarge":    {Region: "eu-west-2", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3776},
		"t3.large":      {Region: "eu-west-2", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0944},
		"t3.medium":     {Region: "eu-west-2", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0472},
		"t3.micro":      {Region: "eu-west-2", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0118},
		"t3.nano":       {Region: "eu-west-2", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0059},
		"t3.small":      {Region: "eu-west-2", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0236},
		"t3.xlarge":     {Region: "eu-west-2", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1888},
		"t3a.2xlarge":   {Region: "eu-west-2", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3398},
		"t3a.large":     {Region: "eu-west-2", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.085},
		"t3a.medium":    {Region: "eu-west-2", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0425},
		"t3a.micro":     {Region: "eu-west-2", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0106},
		"t3a.small":     {Region: "eu-west-2", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0212},
		"t3a.xlarge":    {Region: "eu-west-2", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1699},
		"t4g.2xlarge":   {Region: "eu-west-2", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3008},
		"t4g.large":     {Region: "eu-west-2", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0752},
		"t4g.medium":    {Region: "eu-west-2", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0376},
		"t4g.micro":     {Region: "eu-west-2", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0094},
		"t4g.nano":      {Region: "eu-west-2", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0047},
		"t4g.small":     {Region: "eu-west-2", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0188},
		"t4g.xlarge":    {Region: "eu-west-2", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1504},
		"x1.16xlarge":   {Region: "eu-west-2", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 8.403},
		"x1.32xlarge":   {Region: "eu-west-2", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 16.806},
		"z1d.12xlarge":  {Region: "eu-west-2", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.273},
		"z1d.2xlarge":   {Region: "eu-west-2", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.879},
		"z1d.3xlarge":   {Region: "eu-west-2", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.318},
		"z1d.6xlarge":   {Region: "eu-west-2", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.636},
		"z1d.large":     {Region: "eu-west-2", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.22},
		"z1d.metal":     {Region: "eu-west-2", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.273},
		"z1d.xlarge":    {Region: "eu-west-2", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.439},
	},
	"eu-west-3": {
		"c5.12xlarge":   {Region: "eu-west-3", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"c5.18xlarge":   {Region: "eu-west-3", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.636},
		"c5.24xlarge":   {Region: "eu-west-3", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5.2xlarge":    {Region: "eu-west-3", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"c5.4xlarge":    {Region: "eu-west-3", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"c5.9xlarge":    {Region: "eu-west-3", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.818},
		"c5.large":      {Region: "eu-west-3", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"c5.metal":      {Region: "eu-west-3", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"c5.xlarge":     {Region: "eu-west-3", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"c5d.18xlarge":  {Region: "eu-west-3", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.14},
		"c5d.2xlarge":   {Region: "eu-west-3", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.46},
		"c5d.4xlarge":   {Region: "eu-west-3", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.92},
		"c5d.9xlarge":   {Region: "eu-west-3", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.07},
		"c5d.large":     {Region: "eu-west-3", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.115},
		"c5d.xlarge":    {Region: "eu-west-3", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.23},
		"d2.2xlarge":    {Region: "eu-west-3", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.544},
		"d2.4xlarge":    {Region: "eu-west-3", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.088},
		"d2.8xlarge":    {Region: "eu-west-3", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.176},
		"d2.xlarge":     {Region: "eu-west-3", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.772},
		"g4dn.12xlarge": {Region: "eu-west-3", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.574},
		"g4dn.16xlarge": {Region: "eu-west-3", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.088},
		"g4dn.2xlarge":  {Region: "eu-west-3", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.879},
		"g4dn.4xlarge":  {Region: "eu-west-3", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.408},
		"g4dn.8xlarge":  {Region: "eu-west-3", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.544},
		"g4dn.metal":    {Region: "eu-west-3", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.148},
		"g4dn.xlarge":   {Region: "eu-west-3", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.615},
		"i3.16xlarge":   {Region: "eu-west-3", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"i3.2xlarge":    {Region: "eu-west-3", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.724},
		"i3.4xlarge":    {Region: "eu-west-3", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.448},
		"i3.8xlarge":    {Region: "eu-west-3", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.896},
		"i3.large":      {Region: "eu-west-3", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.181},
		"i3.xlarge":     {Region: "eu-west-3", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.362},
		"i3en.12xlarge": {Region: "eu-west-3", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.312},
		"i3en.24xlarge": {Region: "eu-west-3", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.624},
		"i3en.2xlarge":  {Region: "eu-west-3", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.052},
		"i3en.3xlarge":  {Region: "eu-west-3", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.578},
		"i3en.6xlarge":  {Region: "eu-west-3", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.156},
		"i3en.large":    {Region: "eu-west-3", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.263},
		"i3en.metal":    {Region: "eu-west-3", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.624},
		"i3en.xlarge":   {Region: "eu-west-3", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.526},
		"inf1.24xlarge": {Region: "eu-west-3", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 8.898},
		"inf1.2xlarge":  {Region: "eu-west-3", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.682},
		"inf1.6xlarge":  {Region: "eu-west-3", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.225},
		"inf1.xlarge":   {Region: "eu-west-3", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.43},
		"m5.12xlarge":   {Region: "eu-west-3", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.688},
		"m5.16xlarge":   {Region: "eu-west-3", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.584},
		"m5.24xlarge":   {Region: "eu-west-3", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5.2xlarge":    {Region: "eu-west-3", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.448},
		"m5.4xlarge":    {Region: "eu-west-3", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.896},
		"m5.8xlarge":    {Region: "eu-west-3", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.792},
		"m5.large":      {Region: "eu-west-3", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.112},
		"m5.metal":      {Region: "eu-west-3", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5.xlarge":     {Region: "eu-west-3", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.224},
		"m5a.12xlarge":  {Region: "eu-west-3", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"m5a.16xlarge":  {Region: "eu-west-3", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.232},
		"m5a.24xlarge":  {Region: "eu-west-3", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"m5a.2xlarge":   {Region: "eu-west-3", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"m5a.4xlarge":   {Region: "eu-west-3", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"m5a.8xlarge":   {Region: "eu-west-3", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.616},
		"m5a.large":     {Region: "eu-west-3", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"m5a.xlarge":    {Region: "eu-west-3", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"m5ad.12xlarge": {Region: "eu-west-3", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.904},
		"m5ad.16xlarge": {Region: "eu-west-3", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.872},
		"m5ad.24xlarge": {Region: "eu-west-3", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.808},
		"m5ad.2xlarge":  {Region: "eu-west-3", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.484},
		"m5ad.4xlarge":  {Region: "eu-west-3", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.968},
		"m5ad.8xlarge":  {Region: "eu-west-3", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.936},
		"m5ad.large":    {Region: "eu-west-3", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.121},
		"m5ad.xlarge":   {Region: "eu-west-3", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.242},
		"m5d.12xlarge":  {Region: "eu-west-3", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.168},
		"m5d.16xlarge":  {Region: "eu-west-3", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.224},
		"m5d.24xlarge":  {Region: "eu-west-3", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.336},
		"m5d.2xlarge":   {Region: "eu-west-3", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.528},
		"m5d.4xlarge":   {Region: "eu-west-3", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.056},
		"m5d.8xlarge":   {Region: "eu-west-3", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.112},
		"m5d.large":     {Region: "eu-west-3", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.132},
		"m5d.metal":     {Region: "eu-west-3", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.336},
		"m5d.xlarge":    {Region: "eu-west-3", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.264},
		"r4.16xlarge":   {Region: "eu-west-3", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"r4.2xlarge":    {Region: "eu-west-3", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.624},
		"r4.4xlarge":    {Region: "eu-west-3", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.248},
		"r4.8xlarge":    {Region: "eu-west-3", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.496},
		"r4.large":      {Region: "eu-west-3", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.156},
		"r4.xlarge":     {Region: "eu-west-3", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.312},
		"r5.12xlarge":   {Region: "eu-west-3", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.552},
		"r5.16xlarge":   {Region: "eu-west-3", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.736},
		"r5.24xlarge":   {Region: "eu-west-3", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5.2xlarge":    {Region: "eu-west-3", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.592},
		"r5.4xlarge":    {Region: "eu-west-3", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.184},
		"r5.8xlarge":    {Region: "eu-west-3", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.368},
		"r5.large":      {Region: "eu-west-3", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.148},
		"r5.metal":      {Region: "eu-west-3", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5.xlarge":     {Region: "eu-west-3", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.296},
		"r5a.12xlarge":  {Region: "eu-west-3", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.192},
		"r5a.16xlarge":  {Region: "eu-west-3", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"r5a.24xlarge":  {Region: "eu-west-3", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.384},
		"r5a.2xlarge":   {Region: "eu-west-3", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"r5a.4xlarge":   {Region: "eu-west-3", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"r5a.8xlarge":   {Region: "eu-west-3", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"r5a.large":     {Region: "eu-west-3", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"r5a.xlarge":    {Region: "eu-west-3", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"r5ad.12xlarge": {Region: "eu-west-3", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.672},
		"r5ad.16xlarge": {Region: "eu-west-3", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.896},
		"r5ad.24xlarge": {Region: "eu-west-3", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.344},
		"r5ad.2xlarge":  {Region: "eu-west-3", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.612},
		"r5ad.4xlarge":  {Region: "eu-west-3", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.224},
		"r5ad.8xlarge":  {Region: "eu-west-3", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.448},
		"r5ad.large":    {Region: "eu-west-3", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.153},
		"r5ad.xlarge":   {Region: "eu-west-3", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.306},
		"r5d.12xlarge":  {Region: "eu-west-3", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.056},
		"r5d.16xlarge":  {Region: "eu-west-3", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.408},
		"r5d.24xlarge":  {Region: "eu-west-3", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.112},
		"r5d.2xlarge":   {Region: "eu-west-3", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.676},
		"r5d.4xlarge":   {Region: "eu-west-3", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.352},
		"r5d.8xlarge":   {Region: "eu-west-3", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.704},
		"r5d.large":     {Region: "eu-west-3", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.169},
		"r5d.metal":     {Region: "eu-west-3", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.112},
		"r5d.xlarge":    {Region: "eu-west-3", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.338},
		"t2.2xlarge":    {Region: "eu-west-3", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4224},
		"t2.large":      {Region: "eu-west-3", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1056},
		"t2.medium":     {Region: "eu-west-3", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0528},
		"t2.micro":      {Region: "eu-west-3", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0132},
		"t2.nano":       {Region: "eu-west-3", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0066},
		"t2.small":      {Region: "eu-west-3", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0264},
		"t2.xlarge":     {Region: "eu-west-3", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2112},
		"t3.2xlarge":    {Region: "eu-west-3", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3776},
		"t3.large":      {Region: "eu-west-3", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0944},
		"t3.medium":     {Region: "eu-west-3", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0472},
		"t3.micro":      {Region: "eu-west-3", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0118},
		"t3.nano":       {Region: "eu-west-3", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0059},
		"t3.small":      {Region: "eu-west-3", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0236},
		"t3.xlarge":     {Region: "eu-west-3", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1888},
		"t3a.2xlarge":   {Region: "eu-west-3", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3398},
		"t3a.large":     {Region: "eu-west-3", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.085},
		"t3a.medium":    {Region: "eu-west-3", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0425},
		"t3a.micro":     {Region: "eu-west-3", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0106},
		"t3a.small":     {Region: "eu-west-3", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0212},
		"t3a.xlarge":    {Region: "eu-west-3", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1699},
		"x1.16xlarge":   {Region: "eu-west-3", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 8.403},
		"x1.32xlarge":   {Region: "eu-west-3", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 16.806},
	},
	"me-south-1": {
		"c5.12xlarge":   {Region: "me-south-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.534},
		"c5.18xlarge":   {Region: "me-south-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.802},
		"c5.24xlarge":   {Region: "me-south-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.069},
		"c5.2xlarge":    {Region: "me-south-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.422},
		"c5.4xlarge":    {Region: "me-south-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.845},
		"c5.9xlarge":    {Region: "me-south-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.901},
		"c5.large":      {Region: "me-south-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.106},
		"c5.metal":      {Region: "me-south-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.069},
		"c5.xlarge":     {Region: "me-south-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.211},
		"c5d.12xlarge":  {Region: "me-south-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.878},
		"c5d.18xlarge":  {Region: "me-south-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.316},
		"c5d.24xlarge":  {Region: "me-south-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.755},
		"c5d.2xlarge":   {Region: "me-south-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"c5d.4xlarge":   {Region: "me-south-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.959},
		"c5d.9xlarge":   {Region: "me-south-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.158},
		"c5d.large":     {Region: "me-south-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"c5d.metal":     {Region: "me-south-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.755},
		"c5d.xlarge":    {Region: "me-south-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"d2.2xlarge":    {Region: "me-south-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.617},
		"d2.4xlarge":    {Region: "me-south-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.234},
		"d2.8xlarge":    {Region: "me-south-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.468},
		"d2.xlarge":     {Region: "me-south-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.809},
		"g4dn.12xlarge": {Region: "me-south-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.798},
		"g4dn.16xlarge": {Region: "me-south-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.338},
		"g4dn.2xlarge":  {Region: "me-south-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.922},
		"g4dn.4xlarge":  {Region: "me-south-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.477},
		"g4dn.8xlarge":  {Region: "me-south-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.669},
		"g4dn.metal":    {Region: "me-south-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.596},
		"g4dn.xlarge":   {Region: "me-south-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.645},
		"i3.16xlarge":   {Region: "me-south-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.054},
		"i3.2xlarge":    {Region: "me-south-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.757},
		"i3.4xlarge":    {Region: "me-south-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.514},
		"i3.8xlarge":    {Region: "me-south-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.027},
		"i3.large":      {Region: "me-south-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.189},
		"i3.xlarge":     {Region: "me-south-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.378},
		"inf1.24xlarge": {Region: "me-south-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 9.333},
		"inf1.2xlarge":  {Region: "me-south-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.716},
		"inf1.6xlarge":  {Region: "me-south-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.333},
		"inf1.xlarge":   {Region: "me-south-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.451},
		"m5.12xlarge":   {Region: "me-south-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.825},
		"m5.16xlarge":   {Region: "me-south-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.766},
		"m5.24xlarge":   {Region: "me-south-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.65},
		"m5.2xlarge":    {Region: "me-south-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.471},
		"m5.4xlarge":    {Region: "me-south-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.942},
		"m5.8xlarge":    {Region: "me-south-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.883},
		"m5.large":      {Region: "me-south-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.118},
		"m5.metal":      {Region: "me-south-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.65},
		"m5.xlarge":     {Region: "me-south-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.235},
		"m5d.12xlarge":  {Region: "me-south-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.326},
		"m5d.16xlarge":  {Region: "me-south-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.435},
		"m5d.24xlarge":  {Region: "me-south-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.653},
		"m5d.2xlarge":   {Region: "me-south-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.554},
		"m5d.4xlarge":   {Region: "me-south-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.109},
		"m5d.8xlarge":   {Region: "me-south-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.218},
		"m5d.large":     {Region: "me-south-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.139},
		"m5d.metal":     {Region: "me-south-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.653},
		"m5d.xlarge":    {Region: "me-south-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.277},
		"r5.12xlarge":   {Region: "me-south-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.722},
		"r5.16xlarge":   {Region: "me-south-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.963},
		"r5.24xlarge":   {Region: "me-south-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.445},
		"r5.2xlarge":    {Region: "me-south-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.62},
		"r5.4xlarge":    {Region: "me-south-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.241},
		"r5.8xlarge":    {Region: "me-south-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.482},
		"r5.large":      {Region: "me-south-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.155},
		"r5.metal":      {Region: "me-south-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.445},
		"r5.xlarge":     {Region: "me-south-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.31},
		"r5d.12xlarge":  {Region: "me-south-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.224},
		"r5d.16xlarge":  {Region: "me-south-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.632},
		"r5d.24xlarge":  {Region: "me-south-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.448},
		"r5d.2xlarge":   {Region: "me-south-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.704},
		"r5d.4xlarge":   {Region: "me-south-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.408},
		"r5d.8xlarge":   {Region: "me-south-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.816},
		"r5d.large":     {Region: "me-south-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.176},
		"r5d.metal":     {Region: "me-south-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.448},
		"r5d.xlarge":    {Region: "me-south-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.352},
		"t3.2xlarge":    {Region: "me-south-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4013},
		"t3.large":      {Region: "me-south-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1003},
		"t3.medium":     {Region: "me-south-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0502},
		"t3.micro":      {Region: "me-south-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0125},
		"t3.nano":       {Region: "me-south-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0063},
		"t3.small":      {Region: "me-south-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0251},
		"t3.xlarge":     {Region: "me-south-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2006},
	},
	"sa-east-1": {
		"c1.medium":     {Region: "sa-east-1", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.179},
		"c1.xlarge":     {Region: "sa-east-1", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.718},
		"c3.2xlarge":    {Region: "sa-east-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.65},
		"c3.4xlarge":    {Region: "sa-east-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.3},
		"c3.8xlarge":    {Region: "sa-east-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.6},
		"c3.large":      {Region: "sa-east-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.163},
		"c3.xlarge":     {Region: "sa-east-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.325},
		"c4.2xlarge":    {Region: "sa-east-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.618},
		"c4.4xlarge":    {Region: "sa-east-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.235},
		"c4.8xlarge":    {Region: "sa-east-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.47},
		"c4.large":      {Region: "sa-east-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.155},
		"c4.xlarge":     {Region: "sa-east-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.309},
		"c5.12xlarge":   {Region: "sa-east-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.144},
		"c5.18xlarge":   {Region: "sa-east-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.716},
		"c5.24xlarge":   {Region: "sa-east-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"c5.2xlarge":    {Region: "sa-east-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.524},
		"c5.4xlarge":    {Region: "sa-east-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.048},
		"c5.9xlarge":    {Region: "sa-east-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.358},
		"c5.large":      {Region: "sa-east-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.131},
		"c5.metal":      {Region: "sa-east-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"c5.xlarge":     {Region: "sa-east-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.262},
		"c5a.12xlarge":  {Region: "sa-east-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.832},
		"c5a.16xlarge":  {Region: "sa-east-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.776},
		"c5a.24xlarge":  {Region: "sa-east-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.664},
		"c5a.2xlarge":   {Region: "sa-east-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.472},
		"c5a.4xlarge":   {Region: "sa-east-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.944},
		"c5a.8xlarge":   {Region: "sa-east-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.888},
		"c5a.large":     {Region: "sa-east-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.118},
		"c5a.xlarge":    {Region: "sa-east-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.236},
		"c5d.12xlarge":  {Region: "sa-east-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"c5d.18xlarge":  {Region: "sa-east-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.364},
		"c5d.24xlarge":  {Region: "sa-east-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"c5d.2xlarge":   {Region: "sa-east-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"c5d.4xlarge":   {Region: "sa-east-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"c5d.9xlarge":   {Region: "sa-east-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.682},
		"c5d.large":     {Region: "sa-east-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"c5d.metal":     {Region: "sa-east-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"c5d.xlarge":    {Region: "sa-east-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"c5n.18xlarge":  {Region: "sa-east-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.976},
		"c5n.2xlarge":   {Region: "sa-east-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.664},
		"c5n.4xlarge":   {Region: "sa-east-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.328},
		"c5n.9xlarge":   {Region: "sa-east-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.988},
		"c5n.large":     {Region: "sa-east-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.166},
		"c5n.metal":     {Region: "sa-east-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 5.976},
		"c5n.xlarge":    {Region: "sa-east-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.332},
		"c6g.12xlarge":  {Region: "sa-east-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.5152},
		"c6g.16xlarge":  {Region: "sa-east-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.3536},
		"c6g.2xlarge":   {Region: "sa-east-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4192},
		"c6g.4xlarge":   {Region: "sa-east-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8384},
		"c6g.8xlarge":   {Region: "sa-east-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6768},
		"c6g.large":     {Region: "sa-east-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1048},
		"c6g.medium":    {Region: "sa-east-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0524},
		"c6g.metal":     {Region: "sa-east-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.3536},
		"c6g.xlarge":    {Region: "sa-east-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2096},
		"g4dn.12xlarge": {Region: "sa-east-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 6.649},
		"g4dn.16xlarge": {Region: "sa-east-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 7.397},
		"g4dn.2xlarge":  {Region: "sa-east-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 1.278},
		"g4dn.4xlarge":  {Region: "sa-east-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 2.046},
		"g4dn.8xlarge":  {Region: "sa-east-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 3.698},
		"g4dn.metal":    {Region: "sa-east-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 13.298},
		"g4dn.xlarge":   {Region: "sa-east-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.894},
		"i3.16xlarge":   {Region: "sa-east-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 7.968},
		"i3.2xlarge":    {Region: "sa-east-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.996},
		"i3.4xlarge":    {Region: "sa-east-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.992},
		"i3.8xlarge":    {Region: "sa-east-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.984},
		"i3.large":      {Region: "sa-east-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.249},
		"i3.xlarge":     {Region: "sa-east-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.498},
		"i3en.12xlarge": {Region: "sa-east-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 8.64},
		"i3en.24xlarge": {Region: "sa-east-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 17.28},
		"i3en.2xlarge":  {Region: "sa-east-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.44},
		"i3en.3xlarge":  {Region: "sa-east-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 2.16},
		"i3en.6xlarge":  {Region: "sa-east-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 4.32},
		"i3en.large":    {Region: "sa-east-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.36},
		"i3en.metal":    {Region: "sa-east-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 17.28},
		"i3en.xlarge":   {Region: "sa-east-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.72},
		"inf1.24xlarge": {Region: "sa-east-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 12.581},
		"inf1.2xlarge":  {Region: "sa-east-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.965},
		"inf1.6xlarge":  {Region: "sa-east-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 3.145},
		"inf1.xlarge":   {Region: "sa-east-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.608},
		"m1.large":      {Region: "sa-east-1", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.233},
		"m1.medium":     {Region: "sa-east-1", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.117},
		"m1.small":      {Region: "sa-east-1", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.058},
		"m1.xlarge":     {Region: "sa-east-1", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.467},
		"m2.2xlarge":    {Region: "sa-east-1", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.645},
		"m2.4xlarge":    {Region: "sa-east-1", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.291},
		"m2.xlarge":     {Region: "sa-east-1", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.323},
		"m3.2xlarge":    {Region: "sa-east-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.761},
		"m3.large":      {Region: "sa-east-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.19},
		"m3.medium":     {Region: "sa-east-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.095},
		"m3.xlarge":     {Region: "sa-east-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.381},
		"m4.10xlarge":   {Region: "sa-east-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 3.18},
		"m4.16xlarge":   {Region: "sa-east-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.088},
		"m4.2xlarge":    {Region: "sa-east-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.636},
		"m4.4xlarge":    {Region: "sa-east-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.272},
		"m4.large":      {Region: "sa-east-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.159},
		"m4.xlarge":     {Region: "sa-east-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.318},
		"m5.12xlarge":   {Region: "sa-east-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.672},
		"m5.16xlarge":   {Region: "sa-east-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.896},
		"m5.24xlarge":   {Region: "sa-east-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.344},
		"m5.2xlarge":    {Region: "sa-east-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.612},
		"m5.4xlarge":    {Region: "sa-east-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.224},
		"m5.8xlarge":    {Region: "sa-east-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.448},
		"m5.large":      {Region: "sa-east-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.153},
		"m5.metal":      {Region: "sa-east-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.344},
		"m5.xlarge":     {Region: "sa-east-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.306},
		"m5a.12xlarge":  {Region: "sa-east-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.312},
		"m5a.16xlarge":  {Region: "sa-east-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.416},
		"m5a.24xlarge":  {Region: "sa-east-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.624},
		"m5a.2xlarge":   {Region: "sa-east-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.552},
		"m5a.4xlarge":   {Region: "sa-east-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.104},
		"m5a.8xlarge":   {Region: "sa-east-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.208},
		"m5a.large":     {Region: "sa-east-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.138},
		"m5a.xlarge":    {Region: "sa-east-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.276},
		"m5ad.12xlarge": {Region: "sa-east-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.96},
		"m5ad.16xlarge": {Region: "sa-east-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.28},
		"m5ad.24xlarge": {Region: "sa-east-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.92},
		"m5ad.2xlarge":  {Region: "sa-east-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.66},
		"m5ad.4xlarge":  {Region: "sa-east-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.32},
		"m5ad.8xlarge":  {Region: "sa-east-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.64},
		"m5ad.large":    {Region: "sa-east-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.165},
		"m5ad.xlarge":   {Region: "sa-east-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.33},
		"m5d.12xlarge":  {Region: "sa-east-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.32},
		"m5d.16xlarge":  {Region: "sa-east-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.76},
		"m5d.24xlarge":  {Region: "sa-east-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.64},
		"m5d.2xlarge":   {Region: "sa-east-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.72},
		"m5d.4xlarge":   {Region: "sa-east-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.44},
		"m5d.8xlarge":   {Region: "sa-east-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.88},
		"m5d.large":     {Region: "sa-east-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.18},
		"m5d.metal":     {Region: "sa-east-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.64},
		"m5d.xlarge":    {Region: "sa-east-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.36},
		"m5zn.12xlarge": {Region: "sa-east-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.3178},
		"m5zn.2xlarge":  {Region: "sa-east-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.053},
		"m5zn.3xlarge":  {Region: "sa-east-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.5794},
		"m5zn.6xlarge":  {Region: "sa-east-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.1589},
		"m5zn.large":    {Region: "sa-east-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.2632},
		"m5zn.metal":    {Region: "sa-east-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.3178},
		"m5zn.xlarge":   {Region: "sa-east-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.5265},
		"m6g.12xlarge":  {Region: "sa-east-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.9376},
		"m6g.16xlarge":  {Region: "sa-east-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.9168},
		"m6g.2xlarge":   {Region: "sa-east-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4896},
		"m6g.4xlarge":   {Region: "sa-east-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9792},
		"m6g.8xlarge":   {Region: "sa-east-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.9584},
		"m6g.large":     {Region: "sa-east-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1224},
		"m6g.medium":    {Region: "sa-east-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0612},
		"m6g.metal":     {Region: "sa-east-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.9168},
		"m6g.xlarge":    {Region: "sa-east-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2448},
		"r3.2xlarge":    {Region: "sa-east-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.399},
		"r3.4xlarge":    {Region: "sa-east-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.799},
		"r3.8xlarge":    {Region: "sa-east-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 5.597},
		"r3.large":      {Region: "sa-east-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.35},
		"r3.xlarge":     {Region: "sa-east-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.7},
		"r4.16xlarge":   {Region: "sa-east-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 8.96},
		"r4.2xlarge":    {Region: "sa-east-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.12},
		"r4.4xlarge":    {Region: "sa-east-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.24},
		"r4.8xlarge":    {Region: "sa-east-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 4.48},
		"r4.large":      {Region: "sa-east-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.28},
		"r4.xlarge":     {Region: "sa-east-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.56},
		"r5.12xlarge":   {Region: "sa-east-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.824},
		"r5.16xlarge":   {Region: "sa-east-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.432},
		"r5.24xlarge":   {Region: "sa-east-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.648},
		"r5.2xlarge":    {Region: "sa-east-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.804},
		"r5.4xlarge":    {Region: "sa-east-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.608},
		"r5.8xlarge":    {Region: "sa-east-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.216},
		"r5.large":      {Region: "sa-east-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.201},
		"r5.metal":      {Region: "sa-east-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.648},
		"r5.xlarge":     {Region: "sa-east-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.402},
		"r5a.12xlarge":  {Region: "sa-east-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.344},
		"r5a.16xlarge":  {Region: "sa-east-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.792},
		"r5a.24xlarge":  {Region: "sa-east-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.688},
		"r5a.2xlarge":   {Region: "sa-east-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.724},
		"r5a.4xlarge":   {Region: "sa-east-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.448},
		"r5a.8xlarge":   {Region: "sa-east-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.896},
		"r5a.large":     {Region: "sa-east-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.181},
		"r5a.xlarge":    {Region: "sa-east-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.362},
		"r5ad.12xlarge": {Region: "sa-east-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.992},
		"r5ad.16xlarge": {Region: "sa-east-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.656},
		"r5ad.24xlarge": {Region: "sa-east-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 9.984},
		"r5ad.2xlarge":  {Region: "sa-east-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.832},
		"r5ad.4xlarge":  {Region: "sa-east-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.664},
		"r5ad.8xlarge":  {Region: "sa-east-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.328},
		"r5ad.large":    {Region: "sa-east-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.208},
		"r5ad.xlarge":   {Region: "sa-east-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.416},
		"r5d.12xlarge":  {Region: "sa-east-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.472},
		"r5d.16xlarge":  {Region: "sa-east-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 7.296},
		"r5d.24xlarge":  {Region: "sa-east-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.944},
		"r5d.2xlarge":   {Region: "sa-east-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.912},
		"r5d.4xlarge":   {Region: "sa-east-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.824},
		"r5d.8xlarge":   {Region: "sa-east-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.648},
		"r5d.large":     {Region: "sa-east-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.228},
		"r5d.metal":     {Region: "sa-east-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.944},
		"r5d.xlarge":    {Region: "sa-east-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.456},
		"r6g.12xlarge":  {Region: "sa-east-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.8592},
		"r6g.16xlarge":  {Region: "sa-east-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.1456},
		"r6g.2xlarge":   {Region: "sa-east-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6432},
		"r6g.4xlarge":   {Region: "sa-east-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.2864},
		"r6g.8xlarge":   {Region: "sa-east-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.5728},
		"r6g.large":     {Region: "sa-east-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1608},
		"r6g.medium":    {Region: "sa-east-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0804},
		"r6g.metal":     {Region: "sa-east-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.1456},
		"r6g.xlarge":    {Region: "sa-east-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3216},
		"t1.micro":      {Region: "sa-east-1", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.027},
		"t2.2xlarge":    {Region: "sa-east-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5952},
		"t2.large":      {Region: "sa-east-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1488},
		"t2.medium":     {Region: "sa-east-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0744},
		"t2.micro":      {Region: "sa-east-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0186},
		"t2.nano":       {Region: "sa-east-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0093},
		"t2.small":      {Region: "sa-east-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0372},
		"t2.xlarge":     {Region: "sa-east-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2976},
		"t3.2xlarge":    {Region: "sa-east-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5376},
		"t3.large":      {Region: "sa-east-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1344},
		"t3.medium":     {Region: "sa-east-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0672},
		"t3.micro":      {Region: "sa-east-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0168},
		"t3.nano":       {Region: "sa-east-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0084},
		"t3.small":      {Region: "sa-east-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0336},
		"t3.xlarge":     {Region: "sa-east-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2688},
		"t3a.2xlarge":   {Region: "sa-east-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4838},
		"t3a.large":     {Region: "sa-east-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.121},
		"t3a.medium":    {Region: "sa-east-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0605},
		"t3a.micro":     {Region: "sa-east-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0151},
		"t3a.small":     {Region: "sa-east-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0302},
		"t3a.xlarge":    {Region: "sa-east-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2419},
		"t4g.2xlarge":   {Region: "sa-east-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4288},
		"t4g.large":     {Region: "sa-east-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1072},
		"t4g.medium":    {Region: "sa-east-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0536},
		"t4g.micro":     {Region: "sa-east-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0134},
		"t4g.nano":      {Region: "sa-east-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0067},
		"t4g.small":     {Region: "sa-east-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0268},
		"t4g.xlarge":    {Region: "sa-east-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2144},
		"x1.16xlarge":   {Region: "sa-east-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.005},
		"x1.32xlarge":   {Region: "sa-east-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 26.01},
		"x1e.16xlarge":  {Region: "sa-east-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 26.01},
		"x1e.2xlarge":   {Region: "sa-east-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 3.251},
		"x1e.32xlarge":  {Region: "sa-east-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 52.019},
		"x1e.4xlarge":   {Region: "sa-east-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 6.502},
		"x1e.8xlarge":   {Region: "sa-east-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 13.005},
		"x1e.xlarge":    {Region: "sa-east-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 1.626},
	},
	"us-east-1": {
		"a1.4xlarge":    {Region: "us-east-1", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.large":      {Region: "us-east-1", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.051},
		"a1.medium":     {Region: "us-east-1", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0255},
		"a1.metal":      {Region: "us-east-1", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.xlarge":     {Region: "us-east-1", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.102},
		"c1.medium":     {Region: "us-east-1", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"c1.xlarge":     {Region: "us-east-1", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.52},
		"c3.2xlarge":    {Region: "us-east-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.42},
		"c3.4xlarge":    {Region: "us-east-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.84},
		"c3.8xlarge":    {Region: "us-east-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.68},
		"c3.large":      {Region: "us-east-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.105},
		"c3.xlarge":     {Region: "us-east-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.21},
		"c4.2xlarge":    {Region: "us-east-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.398},
		"c4.4xlarge":    {Region: "us-east-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.796},
		"c4.8xlarge":    {Region: "us-east-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.591},
		"c4.large":      {Region: "us-east-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"c4.xlarge":     {Region: "us-east-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.199},
		"c5.12xlarge":   {Region: "us-east-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.04},
		"c5.18xlarge":   {Region: "us-east-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.06},
		"c5.24xlarge":   {Region: "us-east-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.2xlarge":    {Region: "us-east-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.34},
		"c5.4xlarge":    {Region: "us-east-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.68},
		"c5.9xlarge":    {Region: "us-east-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.53},
		"c5.large":      {Region: "us-east-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.085},
		"c5.metal":      {Region: "us-east-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.xlarge":     {Region: "us-east-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.17},
		"c5a.12xlarge":  {Region: "us-east-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"c5a.16xlarge":  {Region: "us-east-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"c5a.24xlarge":  {Region: "us-east-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.696},
		"c5a.2xlarge":   {Region: "us-east-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"c5a.4xlarge":   {Region: "us-east-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"c5a.8xlarge":   {Region: "us-east-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"c5a.large":     {Region: "us-east-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"c5a.xlarge":    {Region: "us-east-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"c5ad.12xlarge": {Region: "us-east-1", Type: "c5ad.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"c5ad.16xlarge": {Region: "us-east-1", Type: "c5ad.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"c5ad.24xlarge": {Region: "us-east-1", Type: "c5ad.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"c5ad.2xlarge":  {Region: "us-east-1", Type: "c5ad.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"c5ad.4xlarge":  {Region: "us-east-1", Type: "c5ad.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"c5ad.8xlarge":  {Region: "us-east-1", Type: "c5ad.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"c5ad.large":    {Region: "us-east-1", Type: "c5ad.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"c5ad.xlarge":   {Region: "us-east-1", Type: "c5ad.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"c5d.12xlarge":  {Region: "us-east-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c5d.18xlarge":  {Region: "us-east-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.456},
		"c5d.24xlarge":  {Region: "us-east-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5d.2xlarge":   {Region: "us-east-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c5d.4xlarge":   {Region: "us-east-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c5d.9xlarge":   {Region: "us-east-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.728},
		"c5d.large":     {Region: "us-east-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c5d.metal":     {Region: "us-east-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5d.xlarge":    {Region: "us-east-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"c5n.18xlarge":  {Region: "us-east-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.2xlarge":   {Region: "us-east-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"c5n.4xlarge":   {Region: "us-east-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"c5n.9xlarge":   {Region: "us-east-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.944},
		"c5n.large":     {Region: "us-east-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"c5n.metal":     {Region: "us-east-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.xlarge":    {Region: "us-east-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"c6g.12xlarge":  {Region: "us-east-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.632},
		"c6g.16xlarge":  {Region: "us-east-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.176},
		"c6g.2xlarge":   {Region: "us-east-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.272},
		"c6g.4xlarge":   {Region: "us-east-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.544},
		"c6g.8xlarge":   {Region: "us-east-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.088},
		"c6g.large":     {Region: "us-east-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.068},
		"c6g.medium":    {Region: "us-east-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.034},
		"c6g.metal":     {Region: "us-east-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.176},
		"c6g.xlarge":    {Region: "us-east-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.136},
		"c6gd.12xlarge": {Region: "us-east-1", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.8432},
		"c6gd.16xlarge": {Region: "us-east-1", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6gd.2xlarge":  {Region: "us-east-1", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3072},
		"c6gd.4xlarge":  {Region: "us-east-1", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6144},
		"c6gd.8xlarge":  {Region: "us-east-1", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2288},
		"c6gd.large":    {Region: "us-east-1", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0768},
		"c6gd.medium":   {Region: "us-east-1", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0384},
		"c6gd.metal":    {Region: "us-east-1", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6gd.xlarge":   {Region: "us-east-1", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1536},
		"c6gn.12xlarge": {Region: "us-east-1", Type: "c6gn.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0736},
		"c6gn.16xlarge": {Region: "us-east-1", Type: "c6gn.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7648},
		"c6gn.2xlarge":  {Region: "us-east-1", Type: "c6gn.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3456},
		"c6gn.4xlarge":  {Region: "us-east-1", Type: "c6gn.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6912},
		"c6gn.8xlarge":  {Region: "us-east-1", Type: "c6gn.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3824},
		"c6gn.large":    {Region: "us-east-1", Type: "c6gn.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0864},
		"c6gn.medium":   {Region: "us-east-1", Type: "c6gn.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0432},
		"c6gn.xlarge":   {Region: "us-east-1", Type: "c6gn.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1728},
		"cc2.8xlarge":   {Region: "us-east-1", Type: "cc2.8xlarge", Memory: kresource.MustParse("61952Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.0},
		"cr1.8xlarge":   {Region: "us-east-1", Type: "cr1.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.5},
		"d2.2xlarge":    {Region: "us-east-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.38},
		"d2.4xlarge":    {Region: "us-east-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.76},
		"d2.8xlarge":    {Region: "us-east-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 5.52},
		"d2.xlarge":     {Region: "us-east-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.69},
		"d3.2xlarge":    {Region: "us-east-1", Type: "d3.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.999},
		"d3.4xlarge":    {Region: "us-east-1", Type: "d3.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.998},
		"d3.8xlarge":    {Region: "us-east-1", Type: "d3.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.99552},
		"d3.xlarge":     {Region: "us-east-1", Type: "d3.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.499},
		"d3en.12xlarge": {Region: "us-east-1", Type: "d3en.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.30864},
		"d3en.2xlarge":  {Region: "us-east-1", Type: "d3en.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.051},
		"d3en.4xlarge":  {Region: "us-east-1", Type: "d3en.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.103},
		"d3en.6xlarge":  {Region: "us-east-1", Type: "d3en.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.154},
		"d3en.8xlarge":  {Region: "us-east-1", Type: "d3en.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 4.20576},
		"d3en.xlarge":   {Region: "us-east-1", Type: "d3en.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.526},
		"f1.16xlarge":   {Region: "us-east-1", Type: "f1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.2},
		"f1.2xlarge":    {Region: "us-east-1", Type: "f1.2xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.65},
		"f1.4xlarge":    {Region: "us-east-1", Type: "f1.4xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.3},
		"g2.2xlarge":    {Region: "us-east-1", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.65},
		"g2.8xlarge":    {Region: "us-east-1", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 2.6},
		"g3.16xlarge":   {Region: "us-east-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 4.56},
		"g3.4xlarge":    {Region: "us-east-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.14},
		"g3.8xlarge":    {Region: "us-east-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.28},
		"g3s.xlarge":    {Region: "us-east-1", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.75},
		"g4ad.16xlarge": {Region: "us-east-1", Type: "g4ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 3.468},
		"g4ad.4xlarge":  {Region: "us-east-1", Type: "g4ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 0.867},
		"g4ad.8xlarge":  {Region: "us-east-1", Type: "g4ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 1.734},
		"g4dn.12xlarge": {Region: "us-east-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 3.912},
		"g4dn.16xlarge": {Region: "us-east-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.352},
		"g4dn.2xlarge":  {Region: "us-east-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.752},
		"g4dn.4xlarge":  {Region: "us-east-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.204},
		"g4dn.8xlarge":  {Region: "us-east-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.176},
		"g4dn.metal":    {Region: "us-east-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 7.824},
		"g4dn.xlarge":   {Region: "us-east-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.526},
		"h1.16xlarge":   {Region: "us-east-1", Type: "h1.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.744},
		"h1.2xlarge":    {Region: "us-east-1", Type: "h1.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.468},
		"h1.4xlarge":    {Region: "us-east-1", Type: "h1.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.936},
		"h1.8xlarge":    {Region: "us-east-1", Type: "h1.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.872},
		"hs1.8xlarge":   {Region: "us-east-1", Type: "hs1.8xlarge", Memory: kresource.MustParse("119808Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.6},
		"i2.2xlarge":    {Region: "us-east-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.705},
		"i2.4xlarge":    {Region: "us-east-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.41},
		"i2.8xlarge":    {Region: "us-east-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.82},
		"i2.xlarge":     {Region: "us-east-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.853},
		"i3.16xlarge":   {Region: "us-east-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"i3.2xlarge":    {Region: "us-east-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.624},
		"i3.4xlarge":    {Region: "us-east-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.248},
		"i3.8xlarge":    {Region: "us-east-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.496},
		"i3.large":      {Region: "us-east-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.156},
		"i3.metal":      {Region: "us-east-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"i3.xlarge":     {Region: "us-east-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.312},
		"i3en.12xlarge": {Region: "us-east-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"i3en.24xlarge": {Region: "us-east-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.848},
		"i3en.2xlarge":  {Region: "us-east-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.904},
		"i3en.3xlarge":  {Region: "us-east-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.356},
		"i3en.6xlarge":  {Region: "us-east-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.712},
		"i3en.large":    {Region: "us-east-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.226},
		"i3en.metal":    {Region: "us-east-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.848},
		"i3en.xlarge":   {Region: "us-east-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.452},
		"inf1.24xlarge": {Region: "us-east-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 7.615},
		"inf1.2xlarge":  {Region: "us-east-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.584},
		"inf1.6xlarge":  {Region: "us-east-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 1.904},
		"inf1.xlarge":   {Region: "us-east-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.368},
		"m1.large":      {Region: "us-east-1", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.175},
		"m1.medium":     {Region: "us-east-1", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.087},
		"m1.small":      {Region: "us-east-1", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.044},
		"m1.xlarge":     {Region: "us-east-1", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.35},
		"m2.2xlarge":    {Region: "us-east-1", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.49},
		"m2.4xlarge":    {Region: "us-east-1", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.98},
		"m2.xlarge":     {Region: "us-east-1", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.245},
		"m3.2xlarge":    {Region: "us-east-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"m3.large":      {Region: "us-east-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"m3.medium":     {Region: "us-east-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.067},
		"m3.xlarge":     {Region: "us-east-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"m4.10xlarge":   {Region: "us-east-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.0},
		"m4.16xlarge":   {Region: "us-east-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2},
		"m4.2xlarge":    {Region: "us-east-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"m4.4xlarge":    {Region: "us-east-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"m4.large":      {Region: "us-east-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"m4.xlarge":     {Region: "us-east-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"m5.12xlarge":   {Region: "us-east-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m5.16xlarge":   {Region: "us-east-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m5.24xlarge":   {Region: "us-east-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5.2xlarge":    {Region: "us-east-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m5.4xlarge":    {Region: "us-east-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m5.8xlarge":    {Region: "us-east-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m5.large":      {Region: "us-east-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m5.metal":      {Region: "us-east-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5.xlarge":     {Region: "us-east-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m5a.12xlarge":  {Region: "us-east-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"m5a.16xlarge":  {Region: "us-east-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"m5a.24xlarge":  {Region: "us-east-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"m5a.2xlarge":   {Region: "us-east-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"m5a.4xlarge":   {Region: "us-east-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"m5a.8xlarge":   {Region: "us-east-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"m5a.large":     {Region: "us-east-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"m5a.xlarge":    {Region: "us-east-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"m5ad.12xlarge": {Region: "us-east-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.472},
		"m5ad.16xlarge": {Region: "us-east-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.296},
		"m5ad.24xlarge": {Region: "us-east-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.944},
		"m5ad.2xlarge":  {Region: "us-east-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.412},
		"m5ad.4xlarge":  {Region: "us-east-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.824},
		"m5ad.8xlarge":  {Region: "us-east-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.648},
		"m5ad.large":    {Region: "us-east-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.103},
		"m5ad.xlarge":   {Region: "us-east-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.206},
		"m5d.12xlarge":  {Region: "us-east-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"m5d.16xlarge":  {Region: "us-east-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"m5d.24xlarge":  {Region: "us-east-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"m5d.2xlarge":   {Region: "us-east-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"m5d.4xlarge":   {Region: "us-east-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"m5d.8xlarge":   {Region: "us-east-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"m5d.large":     {Region: "us-east-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"m5d.metal":     {Region: "us-east-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"m5d.xlarge":    {Region: "us-east-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"m5dn.12xlarge": {Region: "us-east-1", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"m5dn.16xlarge": {Region: "us-east-1", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"m5dn.24xlarge": {Region: "us-east-1", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5dn.2xlarge":  {Region: "us-east-1", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"m5dn.4xlarge":  {Region: "us-east-1", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"m5dn.8xlarge":  {Region: "us-east-1", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"m5dn.large":    {Region: "us-east-1", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"m5dn.metal":    {Region: "us-east-1", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5dn.xlarge":   {Region: "us-east-1", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"m5n.12xlarge":  {Region: "us-east-1", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.856},
		"m5n.16xlarge":  {Region: "us-east-1", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.808},
		"m5n.24xlarge":  {Region: "us-east-1", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.712},
		"m5n.2xlarge":   {Region: "us-east-1", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.476},
		"m5n.4xlarge":   {Region: "us-east-1", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.952},
		"m5n.8xlarge":   {Region: "us-east-1", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.904},
		"m5n.large":     {Region: "us-east-1", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.119},
		"m5n.metal":     {Region: "us-east-1", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.712},
		"m5n.xlarge":    {Region: "us-east-1", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.238},
		"m5zn.12xlarge": {Region: "us-east-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.9641},
		"m5zn.2xlarge":  {Region: "us-east-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6607},
		"m5zn.3xlarge":  {Region: "us-east-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 0.991},
		"m5zn.6xlarge":  {Region: "us-east-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 1.982},
		"m5zn.large":    {Region: "us-east-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1652},
		"m5zn.metal":    {Region: "us-east-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.9641},
		"m5zn.xlarge":   {Region: "us-east-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3303},
		"m6g.12xlarge":  {Region: "us-east-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"m6g.16xlarge":  {Region: "us-east-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"m6g.2xlarge":   {Region: "us-east-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"m6g.4xlarge":   {Region: "us-east-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"m6g.8xlarge":   {Region: "us-east-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"m6g.large":     {Region: "us-east-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"m6g.medium":    {Region: "us-east-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0385},
		"m6g.metal":     {Region: "us-east-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"m6g.xlarge":    {Region: "us-east-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"m6gd.12xlarge": {Region: "us-east-1", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.1696},
		"m6gd.16xlarge": {Region: "us-east-1", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8928},
		"m6gd.2xlarge":  {Region: "us-east-1", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3616},
		"m6gd.4xlarge":  {Region: "us-east-1", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7232},
		"m6gd.8xlarge":  {Region: "us-east-1", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.4464},
		"m6gd.large":    {Region: "us-east-1", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0904},
		"m6gd.medium":   {Region: "us-east-1", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0452},
		"m6gd.metal":    {Region: "us-east-1", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8928},
		"m6gd.xlarge":   {Region: "us-east-1", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1808},
		"p2.16xlarge":   {Region: "us-east-1", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 14.4},
		"p2.8xlarge":    {Region: "us-east-1", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 7.2},
		"p2.xlarge":     {Region: "us-east-1", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.9},
		"p3.16xlarge":   {Region: "us-east-1", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 24.48},
		"p3.2xlarge":    {Region: "us-east-1", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.06},
		"p3.8xlarge":    {Region: "us-east-1", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 12.24},
		"p3dn.24xlarge": {Region: "us-east-1", Type: "p3dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 31.212},
		"p4d.24xlarge":  {Region: "us-east-1", Type: "p4d.24xlarge", Memory: kresource.MustParse("1179648Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 32.7726},
		"r3.2xlarge":    {Region: "us-east-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.665},
		"r3.4xlarge":    {Region: "us-east-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.33},
		"r3.8xlarge":    {Region: "us-east-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.66},
		"r3.large":      {Region: "us-east-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.166},
		"r3.xlarge":     {Region: "us-east-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.333},
		"r4.16xlarge":   {Region: "us-east-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"r4.2xlarge":    {Region: "us-east-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"r4.4xlarge":    {Region: "us-east-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"r4.8xlarge":    {Region: "us-east-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"r4.large":      {Region: "us-east-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"r4.xlarge":     {Region: "us-east-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"r5.12xlarge":   {Region: "us-east-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"r5.16xlarge":   {Region: "us-east-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.032},
		"r5.24xlarge":   {Region: "us-east-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5.2xlarge":    {Region: "us-east-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"r5.4xlarge":    {Region: "us-east-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"r5.8xlarge":    {Region: "us-east-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.016},
		"r5.large":      {Region: "us-east-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"r5.metal":      {Region: "us-east-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5.xlarge":     {Region: "us-east-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"r5a.12xlarge":  {Region: "us-east-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"r5a.16xlarge":  {Region: "us-east-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"r5a.24xlarge":  {Region: "us-east-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"r5a.2xlarge":   {Region: "us-east-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"r5a.4xlarge":   {Region: "us-east-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"r5a.8xlarge":   {Region: "us-east-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"r5a.large":     {Region: "us-east-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"r5a.xlarge":    {Region: "us-east-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"r5ad.12xlarge": {Region: "us-east-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.144},
		"r5ad.16xlarge": {Region: "us-east-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.192},
		"r5ad.24xlarge": {Region: "us-east-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"r5ad.2xlarge":  {Region: "us-east-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.524},
		"r5ad.4xlarge":  {Region: "us-east-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.048},
		"r5ad.8xlarge":  {Region: "us-east-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.096},
		"r5ad.large":    {Region: "us-east-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.131},
		"r5ad.xlarge":   {Region: "us-east-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.262},
		"r5b.12xlarge":  {Region: "us-east-1", Type: "r5b.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"r5b.16xlarge":  {Region: "us-east-1", Type: "r5b.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.768},
		"r5b.24xlarge":  {Region: "us-east-1", Type: "r5b.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5b.2xlarge":   {Region: "us-east-1", Type: "r5b.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"r5b.4xlarge":   {Region: "us-east-1", Type: "r5b.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"r5b.8xlarge":   {Region: "us-east-1", Type: "r5b.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.384},
		"r5b.large":     {Region: "us-east-1", Type: "r5b.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"r5b.metal":     {Region: "us-east-1", Type: "r5b.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5b.xlarge":    {Region: "us-east-1", Type: "r5b.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"r5d.12xlarge":  {Region: "us-east-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.456},
		"r5d.16xlarge":  {Region: "us-east-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.608},
		"r5d.24xlarge":  {Region: "us-east-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5d.2xlarge":   {Region: "us-east-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.576},
		"r5d.4xlarge":   {Region: "us-east-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.152},
		"r5d.8xlarge":   {Region: "us-east-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.304},
		"r5d.large":     {Region: "us-east-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.144},
		"r5d.metal":     {Region: "us-east-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5d.xlarge":    {Region: "us-east-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.288},
		"r5dn.12xlarge": {Region: "us-east-1", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.008},
		"r5dn.16xlarge": {Region: "us-east-1", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.344},
		"r5dn.24xlarge": {Region: "us-east-1", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5dn.2xlarge":  {Region: "us-east-1", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.668},
		"r5dn.4xlarge":  {Region: "us-east-1", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.336},
		"r5dn.8xlarge":  {Region: "us-east-1", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.672},
		"r5dn.large":    {Region: "us-east-1", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.167},
		"r5dn.metal":    {Region: "us-east-1", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5dn.xlarge":   {Region: "us-east-1", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.334},
		"r5n.12xlarge":  {Region: "us-east-1", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"r5n.16xlarge":  {Region: "us-east-1", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.768},
		"r5n.24xlarge":  {Region: "us-east-1", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5n.2xlarge":   {Region: "us-east-1", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"r5n.4xlarge":   {Region: "us-east-1", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"r5n.8xlarge":   {Region: "us-east-1", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.384},
		"r5n.large":     {Region: "us-east-1", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"r5n.metal":     {Region: "us-east-1", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5n.xlarge":    {Region: "us-east-1", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"r6g.12xlarge":  {Region: "us-east-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4192},
		"r6g.16xlarge":  {Region: "us-east-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"r6g.2xlarge":   {Region: "us-east-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4032},
		"r6g.4xlarge":   {Region: "us-east-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8064},
		"r6g.8xlarge":   {Region: "us-east-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6128},
		"r6g.large":     {Region: "us-east-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1008},
		"r6g.medium":    {Region: "us-east-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0504},
		"r6g.metal":     {Region: "us-east-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"r6g.xlarge":    {Region: "us-east-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2016},
		"r6gd.12xlarge": {Region: "us-east-1", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.7648},
		"r6gd.16xlarge": {Region: "us-east-1", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6864},
		"r6gd.2xlarge":  {Region: "us-east-1", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4608},
		"r6gd.4xlarge":  {Region: "us-east-1", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9216},
		"r6gd.8xlarge":  {Region: "us-east-1", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.8432},
		"r6gd.large":    {Region: "us-east-1", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1152},
		"r6gd.medium":   {Region: "us-east-1", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0576},
		"r6gd.metal":    {Region: "us-east-1", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6864},
		"r6gd.xlarge":   {Region: "us-east-1", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2304},
		"t1.micro":      {Region: "us-east-1", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.02},
		"t2.2xlarge":    {Region: "us-east-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3712},
		"t2.large":      {Region: "us-east-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0928},
		"t2.medium":     {Region: "us-east-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0464},
		"t2.micro":      {Region: "us-east-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0116},
		"t2.nano":       {Region: "us-east-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0058},
		"t2.small":      {Region: "us-east-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.023},
		"t2.xlarge":     {Region: "us-east-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1856},
		"t3.2xlarge":    {Region: "us-east-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3328},
		"t3.large":      {Region: "us-east-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0832},
		"t3.medium":     {Region: "us-east-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0416},
		"t3.micro":      {Region: "us-east-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0104},
		"t3.nano":       {Region: "us-east-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0052},
		"t3.small":      {Region: "us-east-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0208},
		"t3.xlarge":     {Region: "us-east-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1664},
		"t3a.2xlarge":   {Region: "us-east-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3008},
		"t3a.large":     {Region: "us-east-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0752},
		"t3a.medium":    {Region: "us-east-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0376},
		"t3a.micro":     {Region: "us-east-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0094},
		"t3a.small":     {Region: "us-east-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0188},
		"t3a.xlarge":    {Region: "us-east-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1504},
		"t4g.2xlarge":   {Region: "us-east-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2688},
		"t4g.large":     {Region: "us-east-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0672},
		"t4g.medium":    {Region: "us-east-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0336},
		"t4g.micro":     {Region: "us-east-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0084},
		"t4g.nano":      {Region: "us-east-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0042},
		"t4g.small":     {Region: "us-east-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0168},
		"t4g.xlarge":    {Region: "us-east-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1344},
		"x1.16xlarge":   {Region: "us-east-1", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.669},
		"x1.32xlarge":   {Region: "us-east-1", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 13.338},
		"x1e.16xlarge":  {Region: "us-east-1", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.344},
		"x1e.2xlarge":   {Region: "us-east-1", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.668},
		"x1e.32xlarge":  {Region: "us-east-1", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 26.688},
		"x1e.4xlarge":   {Region: "us-east-1", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.336},
		"x1e.8xlarge":   {Region: "us-east-1", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.672},
		"x1e.xlarge":    {Region: "us-east-1", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.834},
		"z1d.12xlarge":  {Region: "us-east-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"z1d.2xlarge":   {Region: "us-east-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.744},
		"z1d.3xlarge":   {Region: "us-east-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.116},
		"z1d.6xlarge":   {Region: "us-east-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.232},
		"z1d.large":     {Region: "us-east-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.186},
		"z1d.metal":     {Region: "us-east-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"z1d.xlarge":    {Region: "us-east-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.372},
	},
	"us-east-2": {
		"a1.4xlarge":    {Region: "us-east-2", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.large":      {Region: "us-east-2", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.051},
		"a1.medium":     {Region: "us-east-2", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0255},
		"a1.metal":      {Region: "us-east-2", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.xlarge":     {Region: "us-east-2", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.102},
		"c4.2xlarge":    {Region: "us-east-2", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.398},
		"c4.4xlarge":    {Region: "us-east-2", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.796},
		"c4.8xlarge":    {Region: "us-east-2", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.591},
		"c4.large":      {Region: "us-east-2", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"c4.xlarge":     {Region: "us-east-2", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.199},
		"c5.12xlarge":   {Region: "us-east-2", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.04},
		"c5.18xlarge":   {Region: "us-east-2", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.06},
		"c5.24xlarge":   {Region: "us-east-2", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.2xlarge":    {Region: "us-east-2", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.34},
		"c5.4xlarge":    {Region: "us-east-2", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.68},
		"c5.9xlarge":    {Region: "us-east-2", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.53},
		"c5.large":      {Region: "us-east-2", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.085},
		"c5.metal":      {Region: "us-east-2", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.xlarge":     {Region: "us-east-2", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.17},
		"c5a.12xlarge":  {Region: "us-east-2", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"c5a.16xlarge":  {Region: "us-east-2", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"c5a.24xlarge":  {Region: "us-east-2", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.696},
		"c5a.2xlarge":   {Region: "us-east-2", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"c5a.4xlarge":   {Region: "us-east-2", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"c5a.8xlarge":   {Region: "us-east-2", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"c5a.large":     {Region: "us-east-2", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"c5a.xlarge":    {Region: "us-east-2", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"c5d.12xlarge":  {Region: "us-east-2", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c5d.18xlarge":  {Region: "us-east-2", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.456},
		"c5d.24xlarge":  {Region: "us-east-2", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5d.2xlarge":   {Region: "us-east-2", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c5d.4xlarge":   {Region: "us-east-2", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c5d.9xlarge":   {Region: "us-east-2", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.728},
		"c5d.large":     {Region: "us-east-2", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c5d.metal":     {Region: "us-east-2", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5d.xlarge":    {Region: "us-east-2", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"c5n.18xlarge":  {Region: "us-east-2", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.2xlarge":   {Region: "us-east-2", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"c5n.4xlarge":   {Region: "us-east-2", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"c5n.9xlarge":   {Region: "us-east-2", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.944},
		"c5n.large":     {Region: "us-east-2", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"c5n.metal":     {Region: "us-east-2", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.xlarge":    {Region: "us-east-2", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"c6g.12xlarge":  {Region: "us-east-2", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.632},
		"c6g.16xlarge":  {Region: "us-east-2", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.176},
		"c6g.2xlarge":   {Region: "us-east-2", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.272},
		"c6g.4xlarge":   {Region: "us-east-2", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.544},
		"c6g.8xlarge":   {Region: "us-east-2", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.088},
		"c6g.large":     {Region: "us-east-2", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.068},
		"c6g.medium":    {Region: "us-east-2", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.034},
		"c6g.metal":     {Region: "us-east-2", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.176},
		"c6g.xlarge":    {Region: "us-east-2", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.136},
		"c6gd.12xlarge": {Region: "us-east-2", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.8432},
		"c6gd.16xlarge": {Region: "us-east-2", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6gd.2xlarge":  {Region: "us-east-2", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3072},
		"c6gd.4xlarge":  {Region: "us-east-2", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6144},
		"c6gd.8xlarge":  {Region: "us-east-2", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2288},
		"c6gd.large":    {Region: "us-east-2", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0768},
		"c6gd.medium":   {Region: "us-east-2", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0384},
		"c6gd.metal":    {Region: "us-east-2", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6gd.xlarge":   {Region: "us-east-2", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1536},
		"c6gn.12xlarge": {Region: "us-east-2", Type: "c6gn.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0736},
		"c6gn.16xlarge": {Region: "us-east-2", Type: "c6gn.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7648},
		"c6gn.2xlarge":  {Region: "us-east-2", Type: "c6gn.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3456},
		"c6gn.4xlarge":  {Region: "us-east-2", Type: "c6gn.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6912},
		"c6gn.8xlarge":  {Region: "us-east-2", Type: "c6gn.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3824},
		"c6gn.large":    {Region: "us-east-2", Type: "c6gn.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0864},
		"c6gn.medium":   {Region: "us-east-2", Type: "c6gn.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0432},
		"c6gn.xlarge":   {Region: "us-east-2", Type: "c6gn.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1728},
		"d2.2xlarge":    {Region: "us-east-2", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.38},
		"d2.4xlarge":    {Region: "us-east-2", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.76},
		"d2.8xlarge":    {Region: "us-east-2", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 5.52},
		"d2.xlarge":     {Region: "us-east-2", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.69},
		"d3.2xlarge":    {Region: "us-east-2", Type: "d3.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.999},
		"d3.4xlarge":    {Region: "us-east-2", Type: "d3.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.998},
		"d3.8xlarge":    {Region: "us-east-2", Type: "d3.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.99552},
		"d3.xlarge":     {Region: "us-east-2", Type: "d3.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.499},
		"g3.16xlarge":   {Region: "us-east-2", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 4.56},
		"g3.4xlarge":    {Region: "us-east-2", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.14},
		"g3.8xlarge":    {Region: "us-east-2", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.28},
		"g3s.xlarge":    {Region: "us-east-2", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.75},
		"g4dn.12xlarge": {Region: "us-east-2", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 3.912},
		"g4dn.16xlarge": {Region: "us-east-2", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.352},
		"g4dn.2xlarge":  {Region: "us-east-2", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.752},
		"g4dn.4xlarge":  {Region: "us-east-2", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.204},
		"g4dn.8xlarge":  {Region: "us-east-2", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.176},
		"g4dn.metal":    {Region: "us-east-2", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 7.824},
		"g4dn.xlarge":   {Region: "us-east-2", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.526},
		"h1.16xlarge":   {Region: "us-east-2", Type: "h1.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.744},
		"h1.2xlarge":    {Region: "us-east-2", Type: "h1.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.468},
		"h1.4xlarge":    {Region: "us-east-2", Type: "h1.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.936},
		"h1.8xlarge":    {Region: "us-east-2", Type: "h1.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.872},
		"i2.2xlarge":    {Region: "us-east-2", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.705},
		"i2.4xlarge":    {Region: "us-east-2", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.41},
		"i2.8xlarge":    {Region: "us-east-2", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.82},
		"i2.xlarge":     {Region: "us-east-2", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.853},
		"i3.16xlarge":   {Region: "us-east-2", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"i3.2xlarge":    {Region: "us-east-2", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.624},
		"i3.4xlarge":    {Region: "us-east-2", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.248},
		"i3.8xlarge":    {Region: "us-east-2", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.496},
		"i3.large":      {Region: "us-east-2", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.156},
		"i3.metal":      {Region: "us-east-2", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"i3.xlarge":     {Region: "us-east-2", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.312},
		"i3en.12xlarge": {Region: "us-east-2", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"i3en.24xlarge": {Region: "us-east-2", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.848},
		"i3en.2xlarge":  {Region: "us-east-2", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.904},
		"i3en.3xlarge":  {Region: "us-east-2", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.356},
		"i3en.6xlarge":  {Region: "us-east-2", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.712},
		"i3en.large":    {Region: "us-east-2", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.226},
		"i3en.metal":    {Region: "us-east-2", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.848},
		"i3en.xlarge":   {Region: "us-east-2", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.452},
		"inf1.24xlarge": {Region: "us-east-2", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 7.615},
		"inf1.2xlarge":  {Region: "us-east-2", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.584},
		"inf1.6xlarge":  {Region: "us-east-2", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 1.904},
		"inf1.xlarge":   {Region: "us-east-2", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.368},
		"m4.10xlarge":   {Region: "us-east-2", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.0},
		"m4.16xlarge":   {Region: "us-east-2", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2},
		"m4.2xlarge":    {Region: "us-east-2", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"m4.4xlarge":    {Region: "us-east-2", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"m4.large":      {Region: "us-east-2", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"m4.xlarge":     {Region: "us-east-2", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"m5.12xlarge":   {Region: "us-east-2", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m5.16xlarge":   {Region: "us-east-2", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m5.24xlarge":   {Region: "us-east-2", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5.2xlarge":    {Region: "us-east-2", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m5.4xlarge":    {Region: "us-east-2", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m5.8xlarge":    {Region: "us-east-2", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m5.large":      {Region: "us-east-2", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m5.metal":      {Region: "us-east-2", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5.xlarge":     {Region: "us-east-2", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m5a.12xlarge":  {Region: "us-east-2", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"m5a.16xlarge":  {Region: "us-east-2", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"m5a.24xlarge":  {Region: "us-east-2", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"m5a.2xlarge":   {Region: "us-east-2", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"m5a.4xlarge":   {Region: "us-east-2", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"m5a.8xlarge":   {Region: "us-east-2", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"m5a.large":     {Region: "us-east-2", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"m5a.xlarge":    {Region: "us-east-2", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"m5ad.12xlarge": {Region: "us-east-2", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.472},
		"m5ad.24xlarge": {Region: "us-east-2", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.944},
		"m5ad.2xlarge":  {Region: "us-east-2", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.412},
		"m5ad.4xlarge":  {Region: "us-east-2", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.824},
		"m5ad.large":    {Region: "us-east-2", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.103},
		"m5ad.xlarge":   {Region: "us-east-2", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.206},
		"m5d.12xlarge":  {Region: "us-east-2", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"m5d.16xlarge":  {Region: "us-east-2", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"m5d.24xlarge":  {Region: "us-east-2", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"m5d.2xlarge":   {Region: "us-east-2", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"m5d.4xlarge":   {Region: "us-east-2", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"m5d.8xlarge":   {Region: "us-east-2", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"m5d.large":     {Region: "us-east-2", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"m5d.metal":     {Region: "us-east-2", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"m5d.xlarge":    {Region: "us-east-2", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"m5dn.12xlarge": {Region: "us-east-2", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"m5dn.16xlarge": {Region: "us-east-2", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"m5dn.24xlarge": {Region: "us-east-2", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5dn.2xlarge":  {Region: "us-east-2", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"m5dn.4xlarge":  {Region: "us-east-2", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"m5dn.8xlarge":  {Region: "us-east-2", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"m5dn.large":    {Region: "us-east-2", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"m5dn.metal":    {Region: "us-east-2", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5dn.xlarge":   {Region: "us-east-2", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"m5n.12xlarge":  {Region: "us-east-2", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.856},
		"m5n.16xlarge":  {Region: "us-east-2", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.808},
		"m5n.24xlarge":  {Region: "us-east-2", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.712},
		"m5n.2xlarge":   {Region: "us-east-2", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.476},
		"m5n.4xlarge":   {Region: "us-east-2", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.952},
		"m5n.8xlarge":   {Region: "us-east-2", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.904},
		"m5n.large":     {Region: "us-east-2", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.119},
		"m5n.metal":     {Region: "us-east-2", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.712},
		"m5n.xlarge":    {Region: "us-east-2", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.238},
		"m5zn.12xlarge": {Region: "us-east-2", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.9641},
		"m5zn.2xlarge":  {Region: "us-east-2", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6607},
		"m5zn.3xlarge":  {Region: "us-east-2", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 0.991},
		"m5zn.6xlarge":  {Region: "us-east-2", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 1.982},
		"m5zn.large":    {Region: "us-east-2", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1652},
		"m5zn.metal":    {Region: "us-east-2", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.9641},
		"m5zn.xlarge":   {Region: "us-east-2", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3303},
		"m6g.12xlarge":  {Region: "us-east-2", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"m6g.16xlarge":  {Region: "us-east-2", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"m6g.2xlarge":   {Region: "us-east-2", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"m6g.4xlarge":   {Region: "us-east-2", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"m6g.8xlarge":   {Region: "us-east-2", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"m6g.large":     {Region: "us-east-2", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"m6g.medium":    {Region: "us-east-2", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0385},
		"m6g.metal":     {Region: "us-east-2", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"m6g.xlarge":    {Region: "us-east-2", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"m6gd.12xlarge": {Region: "us-east-2", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.1696},
		"m6gd.16xlarge": {Region: "us-east-2", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8928},
		"m6gd.2xlarge":  {Region: "us-east-2", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3616},
		"m6gd.4xlarge":  {Region: "us-east-2", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7232},
		"m6gd.8xlarge":  {Region: "us-east-2", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.4464},
		"m6gd.large":    {Region: "us-east-2", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0904},
		"m6gd.medium":   {Region: "us-east-2", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0452},
		"m6gd.metal":    {Region: "us-east-2", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8928},
		"m6gd.xlarge":   {Region: "us-east-2", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1808},
		"p2.16xlarge":   {Region: "us-east-2", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 14.4},
		"p2.8xlarge":    {Region: "us-east-2", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 7.2},
		"p2.xlarge":     {Region: "us-east-2", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.9},
		"p3.16xlarge":   {Region: "us-east-2", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 24.48},
		"p3.2xlarge":    {Region: "us-east-2", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.06},
		"p3.8xlarge":    {Region: "us-east-2", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 12.24},
		"r3.2xlarge":    {Region: "us-east-2", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.664},
		"r3.4xlarge":    {Region: "us-east-2", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.328},
		"r3.8xlarge":    {Region: "us-east-2", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.656},
		"r3.large":      {Region: "us-east-2", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.166},
		"r3.xlarge":     {Region: "us-east-2", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.332},
		"r4.16xlarge":   {Region: "us-east-2", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"r4.2xlarge":    {Region: "us-east-2", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"r4.4xlarge":    {Region: "us-east-2", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"r4.8xlarge":    {Region: "us-east-2", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"r4.large":      {Region: "us-east-2", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"r4.xlarge":     {Region: "us-east-2", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"r5.12xlarge":   {Region: "us-east-2", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"r5.16xlarge":   {Region: "us-east-2", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.032},
		"r5.24xlarge":   {Region: "us-east-2", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5.2xlarge":    {Region: "us-east-2", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"r5.4xlarge":    {Region: "us-east-2", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"r5.8xlarge":    {Region: "us-east-2", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.016},
		"r5.large":      {Region: "us-east-2", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"r5.metal":      {Region: "us-east-2", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5.xlarge":     {Region: "us-east-2", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"r5a.12xlarge":  {Region: "us-east-2", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"r5a.16xlarge":  {Region: "us-east-2", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"r5a.24xlarge":  {Region: "us-east-2", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"r5a.2xlarge":   {Region: "us-east-2", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"r5a.4xlarge":   {Region: "us-east-2", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"r5a.8xlarge":   {Region: "us-east-2", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"r5a.large":     {Region: "us-east-2", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"r5a.xlarge":    {Region: "us-east-2", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"r5ad.12xlarge": {Region: "us-east-2", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.144},
		"r5ad.24xlarge": {Region: "us-east-2", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"r5ad.2xlarge":  {Region: "us-east-2", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.524},
		"r5ad.4xlarge":  {Region: "us-east-2", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.048},
		"r5ad.large":    {Region: "us-east-2", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.131},
		"r5ad.xlarge":   {Region: "us-east-2", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.262},
		"r5b.12xlarge":  {Region: "us-east-2", Type: "r5b.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"r5b.16xlarge":  {Region: "us-east-2", Type: "r5b.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.768},
		"r5b.24xlarge":  {Region: "us-east-2", Type: "r5b.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5b.2xlarge":   {Region: "us-east-2", Type: "r5b.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"r5b.4xlarge":   {Region: "us-east-2", Type: "r5b.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"r5b.8xlarge":   {Region: "us-east-2", Type: "r5b.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.384},
		"r5b.large":     {Region: "us-east-2", Type: "r5b.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"r5b.metal":     {Region: "us-east-2", Type: "r5b.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5b.xlarge":    {Region: "us-east-2", Type: "r5b.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"r5d.12xlarge":  {Region: "us-east-2", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.456},
		"r5d.16xlarge":  {Region: "us-east-2", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.608},
		"r5d.24xlarge":  {Region: "us-east-2", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5d.2xlarge":   {Region: "us-east-2", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.576},
		"r5d.4xlarge":   {Region: "us-east-2", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.152},
		"r5d.8xlarge":   {Region: "us-east-2", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.304},
		"r5d.large":     {Region: "us-east-2", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.144},
		"r5d.metal":     {Region: "us-east-2", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5d.xlarge":    {Region: "us-east-2", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.288},
		"r5dn.12xlarge": {Region: "us-east-2", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.008},
		"r5dn.16xlarge": {Region: "us-east-2", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.344},
		"r5dn.24xlarge": {Region: "us-east-2", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5dn.2xlarge":  {Region: "us-east-2", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.668},
		"r5dn.4xlarge":  {Region: "us-east-2", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.336},
		"r5dn.8xlarge":  {Region: "us-east-2", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.672},
		"r5dn.large":    {Region: "us-east-2", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.167},
		"r5dn.metal":    {Region: "us-east-2", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5dn.xlarge":   {Region: "us-east-2", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.334},
		"r5n.12xlarge":  {Region: "us-east-2", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"r5n.16xlarge":  {Region: "us-east-2", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.768},
		"r5n.24xlarge":  {Region: "us-east-2", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5n.2xlarge":   {Region: "us-east-2", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"r5n.4xlarge":   {Region: "us-east-2", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"r5n.8xlarge":   {Region: "us-east-2", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.384},
		"r5n.large":     {Region: "us-east-2", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"r5n.metal":     {Region: "us-east-2", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5n.xlarge":    {Region: "us-east-2", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"r6g.12xlarge":  {Region: "us-east-2", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4192},
		"r6g.16xlarge":  {Region: "us-east-2", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"r6g.2xlarge":   {Region: "us-east-2", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4032},
		"r6g.4xlarge":   {Region: "us-east-2", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8064},
		"r6g.8xlarge":   {Region: "us-east-2", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6128},
		"r6g.large":     {Region: "us-east-2", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1008},
		"r6g.medium":    {Region: "us-east-2", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0504},
		"r6g.metal":     {Region: "us-east-2", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"r6g.xlarge":    {Region: "us-east-2", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2016},
		"r6gd.12xlarge": {Region: "us-east-2", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.7648},
		"r6gd.16xlarge": {Region: "us-east-2", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6864},
		"r6gd.2xlarge":  {Region: "us-east-2", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4608},
		"r6gd.4xlarge":  {Region: "us-east-2", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9216},
		"r6gd.8xlarge":  {Region: "us-east-2", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.8432},
		"r6gd.large":    {Region: "us-east-2", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1152},
		"r6gd.medium":   {Region: "us-east-2", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0576},
		"r6gd.metal":    {Region: "us-east-2", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6864},
		"r6gd.xlarge":   {Region: "us-east-2", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2304},
		"t2.2xlarge":    {Region: "us-east-2", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3712},
		"t2.large":      {Region: "us-east-2", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0928},
		"t2.medium":     {Region: "us-east-2", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0464},
		"t2.micro":      {Region: "us-east-2", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0116},
		"t2.nano":       {Region: "us-east-2", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0058},
		"t2.small":      {Region: "us-east-2", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.023},
		"t2.xlarge":     {Region: "us-east-2", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1856},
		"t3.2xlarge":    {Region: "us-east-2", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3328},
		"t3.large":      {Region: "us-east-2", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0832},
		"t3.medium":     {Region: "us-east-2", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0416},
		"t3.micro":      {Region: "us-east-2", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0104},
		"t3.nano":       {Region: "us-east-2", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0052},
		"t3.small":      {Region: "us-east-2", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0208},
		"t3.xlarge":     {Region: "us-east-2", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1664},
		"t3a.2xlarge":   {Region: "us-east-2", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3008},
		"t3a.large":     {Region: "us-east-2", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0752},
		"t3a.medium":    {Region: "us-east-2", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0376},
		"t3a.micro":     {Region: "us-east-2", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0094},
		"t3a.nano":      {Region: "us-east-2", Type: "t3a.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0047},
		"t3a.small":     {Region: "us-east-2", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0188},
		"t3a.xlarge":    {Region: "us-east-2", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1504},
		"t4g.2xlarge":   {Region: "us-east-2", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2688},
		"t4g.large":     {Region: "us-east-2", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0672},
		"t4g.medium":    {Region: "us-east-2", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0336},
		"t4g.micro":     {Region: "us-east-2", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0084},
		"t4g.nano":      {Region: "us-east-2", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0042},
		"t4g.small":     {Region: "us-east-2", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0168},
		"t4g.xlarge":    {Region: "us-east-2", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1344},
		"x1.16xlarge":   {Region: "us-east-2", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.669},
		"x1.32xlarge":   {Region: "us-east-2", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 13.338},
		"x1e.16xlarge":  {Region: "us-east-2", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.344},
		"x1e.2xlarge":   {Region: "us-east-2", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.668},
		"x1e.32xlarge":  {Region: "us-east-2", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 26.688},
		"x1e.4xlarge":   {Region: "us-east-2", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.336},
		"x1e.8xlarge":   {Region: "us-east-2", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.672},
		"x1e.xlarge":    {Region: "us-east-2", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.834},
		"z1d.12xlarge":  {Region: "us-east-2", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"z1d.2xlarge":   {Region: "us-east-2", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.744},
		"z1d.3xlarge":   {Region: "us-east-2", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.116},
		"z1d.6xlarge":   {Region: "us-east-2", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.232},
		"z1d.large":     {Region: "us-east-2", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.186},
		"z1d.metal":     {Region: "us-east-2", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"z1d.xlarge":    {Region: "us-east-2", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.372},
	},
	"us-west-1": {
		"c1.medium":     {Region: "us-west-1", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.148},
		"c1.xlarge":     {Region: "us-west-1", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.592},
		"c3.2xlarge":    {Region: "us-west-1", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.478},
		"c3.4xlarge":    {Region: "us-west-1", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.956},
		"c3.8xlarge":    {Region: "us-west-1", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.912},
		"c3.large":      {Region: "us-west-1", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"c3.xlarge":     {Region: "us-west-1", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.239},
		"c4.2xlarge":    {Region: "us-west-1", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.498},
		"c4.4xlarge":    {Region: "us-west-1", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.997},
		"c4.8xlarge":    {Region: "us-west-1", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.993},
		"c4.large":      {Region: "us-west-1", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.124},
		"c4.xlarge":     {Region: "us-west-1", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.249},
		"c5.12xlarge":   {Region: "us-west-1", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.544},
		"c5.18xlarge":   {Region: "us-west-1", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.816},
		"c5.24xlarge":   {Region: "us-west-1", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.088},
		"c5.2xlarge":    {Region: "us-west-1", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.424},
		"c5.4xlarge":    {Region: "us-west-1", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.848},
		"c5.9xlarge":    {Region: "us-west-1", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.908},
		"c5.large":      {Region: "us-west-1", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.106},
		"c5.metal":      {Region: "us-west-1", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.088},
		"c5.xlarge":     {Region: "us-west-1", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.212},
		"c5a.12xlarge":  {Region: "us-west-1", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.28},
		"c5a.16xlarge":  {Region: "us-west-1", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.04},
		"c5a.24xlarge":  {Region: "us-west-1", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.56},
		"c5a.2xlarge":   {Region: "us-west-1", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.38},
		"c5a.4xlarge":   {Region: "us-west-1", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.76},
		"c5a.8xlarge":   {Region: "us-west-1", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.52},
		"c5a.large":     {Region: "us-west-1", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.095},
		"c5a.xlarge":    {Region: "us-west-1", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.19},
		"c5d.12xlarge":  {Region: "us-west-1", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.88},
		"c5d.18xlarge":  {Region: "us-west-1", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.32},
		"c5d.24xlarge":  {Region: "us-west-1", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"c5d.2xlarge":   {Region: "us-west-1", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.48},
		"c5d.4xlarge":   {Region: "us-west-1", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.96},
		"c5d.9xlarge":   {Region: "us-west-1", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.16},
		"c5d.large":     {Region: "us-west-1", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.12},
		"c5d.metal":     {Region: "us-west-1", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.76},
		"c5d.xlarge":    {Region: "us-west-1", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.24},
		"c5n.18xlarge":  {Region: "us-west-1", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.86},
		"c5n.2xlarge":   {Region: "us-west-1", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.54},
		"c5n.4xlarge":   {Region: "us-west-1", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.08},
		"c5n.9xlarge":   {Region: "us-west-1", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 2.43},
		"c5n.large":     {Region: "us-west-1", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.135},
		"c5n.metal":     {Region: "us-west-1", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 4.86},
		"c5n.xlarge":    {Region: "us-west-1", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.27},
		"c6g.12xlarge":  {Region: "us-west-1", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0352},
		"c6g.16xlarge":  {Region: "us-west-1", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7136},
		"c6g.2xlarge":   {Region: "us-west-1", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3392},
		"c6g.4xlarge":   {Region: "us-west-1", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6784},
		"c6g.8xlarge":   {Region: "us-west-1", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3568},
		"c6g.large":     {Region: "us-west-1", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0848},
		"c6g.medium":    {Region: "us-west-1", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0424},
		"c6g.metal":     {Region: "us-west-1", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7136},
		"c6g.xlarge":    {Region: "us-west-1", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1696},
		"c6gd.12xlarge": {Region: "us-west-1", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c6gd.16xlarge": {Region: "us-west-1", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"c6gd.2xlarge":  {Region: "us-west-1", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c6gd.4xlarge":  {Region: "us-west-1", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c6gd.8xlarge":  {Region: "us-west-1", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"c6gd.large":    {Region: "us-west-1", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c6gd.medium":   {Region: "us-west-1", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.048},
		"c6gd.metal":    {Region: "us-west-1", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"c6gd.xlarge":   {Region: "us-west-1", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"d2.2xlarge":    {Region: "us-west-1", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.563},
		"d2.4xlarge":    {Region: "us-west-1", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.125},
		"d2.8xlarge":    {Region: "us-west-1", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 6.25},
		"d2.xlarge":     {Region: "us-west-1", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.781},
		"g2.2xlarge":    {Region: "us-west-1", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.702},
		"g2.8xlarge":    {Region: "us-west-1", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 2.808},
		"g3.16xlarge":   {Region: "us-west-1", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 6.136},
		"g3.4xlarge":    {Region: "us-west-1", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.534},
		"g3.8xlarge":    {Region: "us-west-1", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 3.068},
		"g3s.xlarge":    {Region: "us-west-1", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 1.009},
		"g4dn.12xlarge": {Region: "us-west-1", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 4.694},
		"g4dn.16xlarge": {Region: "us-west-1", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 5.222},
		"g4dn.2xlarge":  {Region: "us-west-1", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.902},
		"g4dn.4xlarge":  {Region: "us-west-1", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.445},
		"g4dn.8xlarge":  {Region: "us-west-1", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.611},
		"g4dn.metal":    {Region: "us-west-1", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 9.389},
		"g4dn.xlarge":   {Region: "us-west-1", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.631},
		"i2.2xlarge":    {Region: "us-west-1", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.876},
		"i2.4xlarge":    {Region: "us-west-1", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.751},
		"i2.8xlarge":    {Region: "us-west-1", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 7.502},
		"i2.xlarge":     {Region: "us-west-1", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.938},
		"i3.16xlarge":   {Region: "us-west-1", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.504},
		"i3.2xlarge":    {Region: "us-west-1", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.688},
		"i3.4xlarge":    {Region: "us-west-1", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.376},
		"i3.8xlarge":    {Region: "us-west-1", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.752},
		"i3.large":      {Region: "us-west-1", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.172},
		"i3.metal":      {Region: "us-west-1", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.504},
		"i3.xlarge":     {Region: "us-west-1", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.344},
		"i3en.12xlarge": {Region: "us-west-1", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.0},
		"i3en.24xlarge": {Region: "us-west-1", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.0},
		"i3en.2xlarge":  {Region: "us-west-1", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.0},
		"i3en.3xlarge":  {Region: "us-west-1", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.5},
		"i3en.6xlarge":  {Region: "us-west-1", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.0},
		"i3en.large":    {Region: "us-west-1", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.25},
		"i3en.metal":    {Region: "us-west-1", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 12.0},
		"i3en.xlarge":   {Region: "us-west-1", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.5},
		"inf1.24xlarge": {Region: "us-west-1", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 9.146},
		"inf1.2xlarge":  {Region: "us-west-1", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.701},
		"inf1.6xlarge":  {Region: "us-west-1", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 2.287},
		"inf1.xlarge":   {Region: "us-west-1", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.442},
		"m1.large":      {Region: "us-west-1", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.19},
		"m1.medium":     {Region: "us-west-1", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.095},
		"m1.small":      {Region: "us-west-1", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.047},
		"m1.xlarge":     {Region: "us-west-1", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.379},
		"m2.2xlarge":    {Region: "us-west-1", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.55},
		"m2.4xlarge":    {Region: "us-west-1", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.1},
		"m2.xlarge":     {Region: "us-west-1", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.275},
		"m3.2xlarge":    {Region: "us-west-1", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.616},
		"m3.large":      {Region: "us-west-1", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.154},
		"m3.medium":     {Region: "us-west-1", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.077},
		"m3.xlarge":     {Region: "us-west-1", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.308},
		"m4.10xlarge":   {Region: "us-west-1", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.34},
		"m4.16xlarge":   {Region: "us-west-1", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.744},
		"m4.2xlarge":    {Region: "us-west-1", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.468},
		"m4.4xlarge":    {Region: "us-west-1", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.936},
		"m4.large":      {Region: "us-west-1", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.117},
		"m4.xlarge":     {Region: "us-west-1", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.234},
		"m5.12xlarge":   {Region: "us-west-1", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.688},
		"m5.16xlarge":   {Region: "us-west-1", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.584},
		"m5.24xlarge":   {Region: "us-west-1", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5.2xlarge":    {Region: "us-west-1", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.448},
		"m5.4xlarge":    {Region: "us-west-1", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.896},
		"m5.8xlarge":    {Region: "us-west-1", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.792},
		"m5.large":      {Region: "us-west-1", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.112},
		"m5.metal":      {Region: "us-west-1", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.376},
		"m5.xlarge":     {Region: "us-west-1", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.224},
		"m5a.12xlarge":  {Region: "us-west-1", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.424},
		"m5a.16xlarge":  {Region: "us-west-1", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.232},
		"m5a.24xlarge":  {Region: "us-west-1", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.848},
		"m5a.2xlarge":   {Region: "us-west-1", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.404},
		"m5a.4xlarge":   {Region: "us-west-1", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.808},
		"m5a.8xlarge":   {Region: "us-west-1", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.616},
		"m5a.large":     {Region: "us-west-1", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.101},
		"m5a.xlarge":    {Region: "us-west-1", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.202},
		"m5ad.12xlarge": {Region: "us-west-1", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.928},
		"m5ad.16xlarge": {Region: "us-west-1", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.904},
		"m5ad.24xlarge": {Region: "us-west-1", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.856},
		"m5ad.2xlarge":  {Region: "us-west-1", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.488},
		"m5ad.4xlarge":  {Region: "us-west-1", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.976},
		"m5ad.8xlarge":  {Region: "us-west-1", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.952},
		"m5ad.large":    {Region: "us-west-1", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.122},
		"m5ad.xlarge":   {Region: "us-west-1", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.244},
		"m5d.12xlarge":  {Region: "us-west-1", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.192},
		"m5d.16xlarge":  {Region: "us-west-1", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"m5d.24xlarge":  {Region: "us-west-1", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.384},
		"m5d.2xlarge":   {Region: "us-west-1", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"m5d.4xlarge":   {Region: "us-west-1", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"m5d.8xlarge":   {Region: "us-west-1", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"m5d.large":     {Region: "us-west-1", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"m5d.metal":     {Region: "us-west-1", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.384},
		"m5d.xlarge":    {Region: "us-west-1", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"m5zn.12xlarge": {Region: "us-west-1", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.6248},
		"m5zn.2xlarge":  {Region: "us-west-1", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.7708},
		"m5zn.3xlarge":  {Region: "us-west-1", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.1562},
		"m5zn.6xlarge":  {Region: "us-west-1", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.3124},
		"m5zn.large":    {Region: "us-west-1", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1927},
		"m5zn.metal":    {Region: "us-west-1", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.6248},
		"m5zn.xlarge":   {Region: "us-west-1", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3854},
		"m6g.12xlarge":  {Region: "us-west-1", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.1504},
		"m6g.16xlarge":  {Region: "us-west-1", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8672},
		"m6g.2xlarge":   {Region: "us-west-1", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3584},
		"m6g.4xlarge":   {Region: "us-west-1", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7168},
		"m6g.8xlarge":   {Region: "us-west-1", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.4336},
		"m6g.large":     {Region: "us-west-1", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0896},
		"m6g.medium":    {Region: "us-west-1", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0448},
		"m6g.metal":     {Region: "us-west-1", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8672},
		"m6g.xlarge":    {Region: "us-west-1", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1792},
		"m6gd.12xlarge": {Region: "us-west-1", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.544},
		"m6gd.16xlarge": {Region: "us-west-1", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.392},
		"m6gd.2xlarge":  {Region: "us-west-1", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.424},
		"m6gd.4xlarge":  {Region: "us-west-1", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.848},
		"m6gd.8xlarge":  {Region: "us-west-1", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.696},
		"m6gd.large":    {Region: "us-west-1", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.106},
		"m6gd.medium":   {Region: "us-west-1", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.053},
		"m6gd.metal":    {Region: "us-west-1", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.392},
		"m6gd.xlarge":   {Region: "us-west-1", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.212},
		"r3.2xlarge":    {Region: "us-west-1", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.741},
		"r3.4xlarge":    {Region: "us-west-1", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.482},
		"r3.8xlarge":    {Region: "us-west-1", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.964},
		"r3.large":      {Region: "us-west-1", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.185},
		"r3.xlarge":     {Region: "us-west-1", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.371},
		"r4.16xlarge":   {Region: "us-west-1", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.7424},
		"r4.2xlarge":    {Region: "us-west-1", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.5928},
		"r4.4xlarge":    {Region: "us-west-1", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.1856},
		"r4.8xlarge":    {Region: "us-west-1", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.3712},
		"r4.large":      {Region: "us-west-1", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1482},
		"r4.xlarge":     {Region: "us-west-1", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2964},
		"r5.12xlarge":   {Region: "us-west-1", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.36},
		"r5.16xlarge":   {Region: "us-west-1", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.48},
		"r5.24xlarge":   {Region: "us-west-1", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.72},
		"r5.2xlarge":    {Region: "us-west-1", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.56},
		"r5.4xlarge":    {Region: "us-west-1", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.12},
		"r5.8xlarge":    {Region: "us-west-1", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.24},
		"r5.large":      {Region: "us-west-1", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.14},
		"r5.metal":      {Region: "us-west-1", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.72},
		"r5.xlarge":     {Region: "us-west-1", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.28},
		"r5a.12xlarge":  {Region: "us-west-1", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"r5a.16xlarge":  {Region: "us-west-1", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.032},
		"r5a.24xlarge":  {Region: "us-west-1", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5a.2xlarge":   {Region: "us-west-1", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"r5a.4xlarge":   {Region: "us-west-1", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"r5a.8xlarge":   {Region: "us-west-1", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.016},
		"r5a.large":     {Region: "us-west-1", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"r5a.xlarge":    {Region: "us-west-1", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"r5ad.12xlarge": {Region: "us-west-1", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.552},
		"r5ad.16xlarge": {Region: "us-west-1", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.736},
		"r5ad.24xlarge": {Region: "us-west-1", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.104},
		"r5ad.2xlarge":  {Region: "us-west-1", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.592},
		"r5ad.4xlarge":  {Region: "us-west-1", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.184},
		"r5ad.8xlarge":  {Region: "us-west-1", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.368},
		"r5ad.large":    {Region: "us-west-1", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.148},
		"r5ad.xlarge":   {Region: "us-west-1", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.296},
		"r5d.12xlarge":  {Region: "us-west-1", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.888},
		"r5d.16xlarge":  {Region: "us-west-1", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.184},
		"r5d.24xlarge":  {Region: "us-west-1", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.776},
		"r5d.2xlarge":   {Region: "us-west-1", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.648},
		"r5d.4xlarge":   {Region: "us-west-1", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.296},
		"r5d.8xlarge":   {Region: "us-west-1", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.592},
		"r5d.large":     {Region: "us-west-1", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.162},
		"r5d.metal":     {Region: "us-west-1", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.776},
		"r5d.xlarge":    {Region: "us-west-1", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.324},
		"r6g.12xlarge":  {Region: "us-west-1", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.688},
		"r6g.16xlarge":  {Region: "us-west-1", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.584},
		"r6g.2xlarge":   {Region: "us-west-1", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.448},
		"r6g.4xlarge":   {Region: "us-west-1", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.896},
		"r6g.8xlarge":   {Region: "us-west-1", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.792},
		"r6g.large":     {Region: "us-west-1", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.112},
		"r6g.medium":    {Region: "us-west-1", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.056},
		"r6g.metal":     {Region: "us-west-1", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.584},
		"r6g.xlarge":    {Region: "us-west-1", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.224},
		"r6gd.12xlarge": {Region: "us-west-1", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.12},
		"r6gd.16xlarge": {Region: "us-west-1", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.16},
		"r6gd.2xlarge":  {Region: "us-west-1", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.52},
		"r6gd.4xlarge":  {Region: "us-west-1", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.04},
		"r6gd.8xlarge":  {Region: "us-west-1", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.08},
		"r6gd.large":    {Region: "us-west-1", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"r6gd.medium":   {Region: "us-west-1", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.065},
		"r6gd.metal":    {Region: "us-west-1", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.16},
		"r6gd.xlarge":   {Region: "us-west-1", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.26},
		"t1.micro":      {Region: "us-west-1", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.025},
		"t2.2xlarge":    {Region: "us-west-1", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4416},
		"t2.large":      {Region: "us-west-1", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1104},
		"t2.medium":     {Region: "us-west-1", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0552},
		"t2.micro":      {Region: "us-west-1", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0138},
		"t2.nano":       {Region: "us-west-1", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0069},
		"t2.small":      {Region: "us-west-1", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0276},
		"t2.xlarge":     {Region: "us-west-1", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2208},
		"t3.2xlarge":    {Region: "us-west-1", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3968},
		"t3.large":      {Region: "us-west-1", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0992},
		"t3.medium":     {Region: "us-west-1", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0496},
		"t3.micro":      {Region: "us-west-1", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0124},
		"t3.nano":       {Region: "us-west-1", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0062},
		"t3.small":      {Region: "us-west-1", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0248},
		"t3.xlarge":     {Region: "us-west-1", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1984},
		"t3a.2xlarge":   {Region: "us-west-1", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3571},
		"t3a.large":     {Region: "us-west-1", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0893},
		"t3a.medium":    {Region: "us-west-1", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0446},
		"t3a.micro":     {Region: "us-west-1", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0112},
		"t3a.nano":      {Region: "us-west-1", Type: "t3a.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0056},
		"t3a.small":     {Region: "us-west-1", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0223},
		"t3a.xlarge":    {Region: "us-west-1", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1786},
		"t4g.2xlarge":   {Region: "us-west-1", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.32},
		"t4g.large":     {Region: "us-west-1", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.08},
		"t4g.medium":    {Region: "us-west-1", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.04},
		"t4g.micro":     {Region: "us-west-1", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.01},
		"t4g.nano":      {Region: "us-west-1", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.005},
		"t4g.small":     {Region: "us-west-1", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.02},
		"t4g.xlarge":    {Region: "us-west-1", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.16},
		"z1d.12xlarge":  {Region: "us-west-1", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.064},
		"z1d.2xlarge":   {Region: "us-west-1", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.844},
		"z1d.3xlarge":   {Region: "us-west-1", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.266},
		"z1d.6xlarge":   {Region: "us-west-1", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.532},
		"z1d.large":     {Region: "us-west-1", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.211},
		"z1d.metal":     {Region: "us-west-1", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.064},
		"z1d.xlarge":    {Region: "us-west-1", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.422},
	},
	"us-west-2": {
		"a1.4xlarge":    {Region: "us-west-2", Type: "a1.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.large":      {Region: "us-west-2", Type: "a1.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.051},
		"a1.medium":     {Region: "us-west-2", Type: "a1.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0255},
		"a1.metal":      {Region: "us-west-2", Type: "a1.metal", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.408},
		"a1.xlarge":     {Region: "us-west-2", Type: "a1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.102},
		"c1.medium":     {Region: "us-west-2", Type: "c1.medium", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.13},
		"c1.xlarge":     {Region: "us-west-2", Type: "c1.xlarge", Memory: kresource.MustParse("7168Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.52},
		"c3.2xlarge":    {Region: "us-west-2", Type: "c3.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.42},
		"c3.4xlarge":    {Region: "us-west-2", Type: "c3.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.84},
		"c3.8xlarge":    {Region: "us-west-2", Type: "c3.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.68},
		"c3.large":      {Region: "us-west-2", Type: "c3.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.105},
		"c3.xlarge":     {Region: "us-west-2", Type: "c3.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.21},
		"c4.2xlarge":    {Region: "us-west-2", Type: "c4.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.398},
		"c4.4xlarge":    {Region: "us-west-2", Type: "c4.4xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.796},
		"c4.8xlarge":    {Region: "us-west-2", Type: "c4.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.591},
		"c4.large":      {Region: "us-west-2", Type: "c4.large", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"c4.xlarge":     {Region: "us-west-2", Type: "c4.xlarge", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.199},
		"c5.12xlarge":   {Region: "us-west-2", Type: "c5.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.04},
		"c5.18xlarge":   {Region: "us-west-2", Type: "c5.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.06},
		"c5.24xlarge":   {Region: "us-west-2", Type: "c5.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.2xlarge":    {Region: "us-west-2", Type: "c5.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.34},
		"c5.4xlarge":    {Region: "us-west-2", Type: "c5.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.68},
		"c5.9xlarge":    {Region: "us-west-2", Type: "c5.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.53},
		"c5.large":      {Region: "us-west-2", Type: "c5.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.085},
		"c5.metal":      {Region: "us-west-2", Type: "c5.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.08},
		"c5.xlarge":     {Region: "us-west-2", Type: "c5.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.17},
		"c5a.12xlarge":  {Region: "us-west-2", Type: "c5a.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"c5a.16xlarge":  {Region: "us-west-2", Type: "c5a.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"c5a.24xlarge":  {Region: "us-west-2", Type: "c5a.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 3.696},
		"c5a.2xlarge":   {Region: "us-west-2", Type: "c5a.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"c5a.4xlarge":   {Region: "us-west-2", Type: "c5a.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"c5a.8xlarge":   {Region: "us-west-2", Type: "c5a.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"c5a.large":     {Region: "us-west-2", Type: "c5a.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"c5a.xlarge":    {Region: "us-west-2", Type: "c5a.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"c5ad.12xlarge": {Region: "us-west-2", Type: "c5ad.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"c5ad.16xlarge": {Region: "us-west-2", Type: "c5ad.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"c5ad.24xlarge": {Region: "us-west-2", Type: "c5ad.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"c5ad.2xlarge":  {Region: "us-west-2", Type: "c5ad.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"c5ad.4xlarge":  {Region: "us-west-2", Type: "c5ad.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"c5ad.8xlarge":  {Region: "us-west-2", Type: "c5ad.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"c5ad.large":    {Region: "us-west-2", Type: "c5ad.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"c5ad.xlarge":   {Region: "us-west-2", Type: "c5ad.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"c5d.12xlarge":  {Region: "us-west-2", Type: "c5d.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"c5d.18xlarge":  {Region: "us-west-2", Type: "c5d.18xlarge", Memory: kresource.MustParse("147456Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.456},
		"c5d.24xlarge":  {Region: "us-west-2", Type: "c5d.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5d.2xlarge":   {Region: "us-west-2", Type: "c5d.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"c5d.4xlarge":   {Region: "us-west-2", Type: "c5d.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"c5d.9xlarge":   {Region: "us-west-2", Type: "c5d.9xlarge", Memory: kresource.MustParse("73728Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.728},
		"c5d.large":     {Region: "us-west-2", Type: "c5d.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"c5d.metal":     {Region: "us-west-2", Type: "c5d.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"c5d.xlarge":    {Region: "us-west-2", Type: "c5d.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"c5n.18xlarge":  {Region: "us-west-2", Type: "c5n.18xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.2xlarge":   {Region: "us-west-2", Type: "c5n.2xlarge", Memory: kresource.MustParse("21504Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.432},
		"c5n.4xlarge":   {Region: "us-west-2", Type: "c5n.4xlarge", Memory: kresource.MustParse("43008Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.864},
		"c5n.9xlarge":   {Region: "us-west-2", Type: "c5n.9xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 1.944},
		"c5n.large":     {Region: "us-west-2", Type: "c5n.large", Memory: kresource.MustParse("5376Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.108},
		"c5n.metal":     {Region: "us-west-2", Type: "c5n.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("72"), GPU: 0, Inf: 0, Price: 3.888},
		"c5n.xlarge":    {Region: "us-west-2", Type: "c5n.xlarge", Memory: kresource.MustParse("10752Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.216},
		"c6g.12xlarge":  {Region: "us-west-2", Type: "c6g.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.632},
		"c6g.16xlarge":  {Region: "us-west-2", Type: "c6g.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.176},
		"c6g.2xlarge":   {Region: "us-west-2", Type: "c6g.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.272},
		"c6g.4xlarge":   {Region: "us-west-2", Type: "c6g.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.544},
		"c6g.8xlarge":   {Region: "us-west-2", Type: "c6g.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.088},
		"c6g.large":     {Region: "us-west-2", Type: "c6g.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.068},
		"c6g.medium":    {Region: "us-west-2", Type: "c6g.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.034},
		"c6g.metal":     {Region: "us-west-2", Type: "c6g.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.176},
		"c6g.xlarge":    {Region: "us-west-2", Type: "c6g.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.136},
		"c6gd.12xlarge": {Region: "us-west-2", Type: "c6gd.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.8432},
		"c6gd.16xlarge": {Region: "us-west-2", Type: "c6gd.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6gd.2xlarge":  {Region: "us-west-2", Type: "c6gd.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3072},
		"c6gd.4xlarge":  {Region: "us-west-2", Type: "c6gd.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6144},
		"c6gd.8xlarge":  {Region: "us-west-2", Type: "c6gd.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.2288},
		"c6gd.large":    {Region: "us-west-2", Type: "c6gd.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0768},
		"c6gd.medium":   {Region: "us-west-2", Type: "c6gd.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0384},
		"c6gd.metal":    {Region: "us-west-2", Type: "c6gd.metal", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.4576},
		"c6gd.xlarge":   {Region: "us-west-2", Type: "c6gd.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1536},
		"c6gn.12xlarge": {Region: "us-west-2", Type: "c6gn.12xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.0736},
		"c6gn.16xlarge": {Region: "us-west-2", Type: "c6gn.16xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.7648},
		"c6gn.2xlarge":  {Region: "us-west-2", Type: "c6gn.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3456},
		"c6gn.4xlarge":  {Region: "us-west-2", Type: "c6gn.4xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.6912},
		"c6gn.8xlarge":  {Region: "us-west-2", Type: "c6gn.8xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.3824},
		"c6gn.large":    {Region: "us-west-2", Type: "c6gn.large", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0864},
		"c6gn.medium":   {Region: "us-west-2", Type: "c6gn.medium", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0432},
		"c6gn.xlarge":   {Region: "us-west-2", Type: "c6gn.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1728},
		"cc2.8xlarge":   {Region: "us-west-2", Type: "cc2.8xlarge", Memory: kresource.MustParse("61952Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.0},
		"cr1.8xlarge":   {Region: "us-west-2", Type: "cr1.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.5},
		"d2.2xlarge":    {Region: "us-west-2", Type: "d2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.38},
		"d2.4xlarge":    {Region: "us-west-2", Type: "d2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.76},
		"d2.8xlarge":    {Region: "us-west-2", Type: "d2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("36"), GPU: 0, Inf: 0, Price: 5.52},
		"d2.xlarge":     {Region: "us-west-2", Type: "d2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.69},
		"d3.2xlarge":    {Region: "us-west-2", Type: "d3.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.999},
		"d3.4xlarge":    {Region: "us-west-2", Type: "d3.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.998},
		"d3.8xlarge":    {Region: "us-west-2", Type: "d3.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 3.99552},
		"d3.xlarge":     {Region: "us-west-2", Type: "d3.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.499},
		"d3en.12xlarge": {Region: "us-west-2", Type: "d3en.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 6.30864},
		"d3en.2xlarge":  {Region: "us-west-2", Type: "d3en.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.051},
		"d3en.4xlarge":  {Region: "us-west-2", Type: "d3en.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 2.103},
		"d3en.6xlarge":  {Region: "us-west-2", Type: "d3en.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 3.154},
		"d3en.8xlarge":  {Region: "us-west-2", Type: "d3en.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 4.20576},
		"d3en.xlarge":   {Region: "us-west-2", Type: "d3en.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.526},
		"f1.16xlarge":   {Region: "us-west-2", Type: "f1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.2},
		"f1.2xlarge":    {Region: "us-west-2", Type: "f1.2xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.65},
		"f1.4xlarge":    {Region: "us-west-2", Type: "f1.4xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.3},
		"g2.2xlarge":    {Region: "us-west-2", Type: "g2.2xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.65},
		"g2.8xlarge":    {Region: "us-west-2", Type: "g2.8xlarge", Memory: kresource.MustParse("61440Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 2.6},
		"g3.16xlarge":   {Region: "us-west-2", Type: "g3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 4.56},
		"g3.4xlarge":    {Region: "us-west-2", Type: "g3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.14},
		"g3.8xlarge":    {Region: "us-west-2", Type: "g3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 2.28},
		"g3s.xlarge":    {Region: "us-west-2", Type: "g3s.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.75},
		"g4ad.16xlarge": {Region: "us-west-2", Type: "g4ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 4, Inf: 0, Price: 3.468},
		"g4ad.4xlarge":  {Region: "us-west-2", Type: "g4ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 0.867},
		"g4ad.8xlarge":  {Region: "us-west-2", Type: "g4ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 2, Inf: 0, Price: 1.734},
		"g4dn.12xlarge": {Region: "us-west-2", Type: "g4dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 4, Inf: 0, Price: 3.912},
		"g4dn.16xlarge": {Region: "us-west-2", Type: "g4dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 1, Inf: 0, Price: 4.352},
		"g4dn.2xlarge":  {Region: "us-west-2", Type: "g4dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 0.752},
		"g4dn.4xlarge":  {Region: "us-west-2", Type: "g4dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 1, Inf: 0, Price: 1.204},
		"g4dn.8xlarge":  {Region: "us-west-2", Type: "g4dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 1, Inf: 0, Price: 2.176},
		"g4dn.metal":    {Region: "us-west-2", Type: "g4dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 7.824},
		"g4dn.xlarge":   {Region: "us-west-2", Type: "g4dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.526},
		"h1.16xlarge":   {Region: "us-west-2", Type: "h1.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.744},
		"h1.2xlarge":    {Region: "us-west-2", Type: "h1.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.468},
		"h1.4xlarge":    {Region: "us-west-2", Type: "h1.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.936},
		"h1.8xlarge":    {Region: "us-west-2", Type: "h1.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.872},
		"hs1.8xlarge":   {Region: "us-west-2", Type: "hs1.8xlarge", Memory: kresource.MustParse("119808Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 4.6},
		"i2.2xlarge":    {Region: "us-west-2", Type: "i2.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.705},
		"i2.4xlarge":    {Region: "us-west-2", Type: "i2.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.41},
		"i2.8xlarge":    {Region: "us-west-2", Type: "i2.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.82},
		"i2.xlarge":     {Region: "us-west-2", Type: "i2.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.853},
		"i3.16xlarge":   {Region: "us-west-2", Type: "i3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"i3.2xlarge":    {Region: "us-west-2", Type: "i3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.624},
		"i3.4xlarge":    {Region: "us-west-2", Type: "i3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.248},
		"i3.8xlarge":    {Region: "us-west-2", Type: "i3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.496},
		"i3.large":      {Region: "us-west-2", Type: "i3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.156},
		"i3.metal":      {Region: "us-west-2", Type: "i3.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.992},
		"i3.xlarge":     {Region: "us-west-2", Type: "i3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.312},
		"i3en.12xlarge": {Region: "us-west-2", Type: "i3en.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 5.424},
		"i3en.24xlarge": {Region: "us-west-2", Type: "i3en.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.848},
		"i3en.2xlarge":  {Region: "us-west-2", Type: "i3en.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.904},
		"i3en.3xlarge":  {Region: "us-west-2", Type: "i3en.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.356},
		"i3en.6xlarge":  {Region: "us-west-2", Type: "i3en.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.712},
		"i3en.large":    {Region: "us-west-2", Type: "i3en.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.226},
		"i3en.metal":    {Region: "us-west-2", Type: "i3en.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 10.848},
		"i3en.xlarge":   {Region: "us-west-2", Type: "i3en.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.452},
		"inf1.24xlarge": {Region: "us-west-2", Type: "inf1.24xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 16, Price: 7.615},
		"inf1.2xlarge":  {Region: "us-west-2", Type: "inf1.2xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 1, Price: 0.584},
		"inf1.6xlarge":  {Region: "us-west-2", Type: "inf1.6xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 4, Price: 1.904},
		"inf1.xlarge":   {Region: "us-west-2", Type: "inf1.xlarge", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 1, Price: 0.368},
		"m1.large":      {Region: "us-west-2", Type: "m1.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.175},
		"m1.medium":     {Region: "us-west-2", Type: "m1.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.087},
		"m1.small":      {Region: "us-west-2", Type: "m1.small", Memory: kresource.MustParse("1740Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.044},
		"m1.xlarge":     {Region: "us-west-2", Type: "m1.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.35},
		"m2.2xlarge":    {Region: "us-west-2", Type: "m2.2xlarge", Memory: kresource.MustParse("35020Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.49},
		"m2.4xlarge":    {Region: "us-west-2", Type: "m2.4xlarge", Memory: kresource.MustParse("70041Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.98},
		"m2.xlarge":     {Region: "us-west-2", Type: "m2.xlarge", Memory: kresource.MustParse("17510Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.245},
		"m3.2xlarge":    {Region: "us-west-2", Type: "m3.2xlarge", Memory: kresource.MustParse("30720Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"m3.large":      {Region: "us-west-2", Type: "m3.large", Memory: kresource.MustParse("7680Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"m3.medium":     {Region: "us-west-2", Type: "m3.medium", Memory: kresource.MustParse("3840Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.067},
		"m3.xlarge":     {Region: "us-west-2", Type: "m3.xlarge", Memory: kresource.MustParse("15360Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"m4.10xlarge":   {Region: "us-west-2", Type: "m4.10xlarge", Memory: kresource.MustParse("163840Mi"), CPU: kresource.MustParse("40"), GPU: 0, Inf: 0, Price: 2.0},
		"m4.16xlarge":   {Region: "us-west-2", Type: "m4.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2},
		"m4.2xlarge":    {Region: "us-west-2", Type: "m4.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4},
		"m4.4xlarge":    {Region: "us-west-2", Type: "m4.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8},
		"m4.large":      {Region: "us-west-2", Type: "m4.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1},
		"m4.xlarge":     {Region: "us-west-2", Type: "m4.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2},
		"m5.12xlarge":   {Region: "us-west-2", Type: "m5.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.304},
		"m5.16xlarge":   {Region: "us-west-2", Type: "m5.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.072},
		"m5.24xlarge":   {Region: "us-west-2", Type: "m5.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5.2xlarge":    {Region: "us-west-2", Type: "m5.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.384},
		"m5.4xlarge":    {Region: "us-west-2", Type: "m5.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.768},
		"m5.8xlarge":    {Region: "us-west-2", Type: "m5.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.536},
		"m5.large":      {Region: "us-west-2", Type: "m5.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.096},
		"m5.metal":      {Region: "us-west-2", Type: "m5.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.608},
		"m5.xlarge":     {Region: "us-west-2", Type: "m5.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.192},
		"m5a.12xlarge":  {Region: "us-west-2", Type: "m5a.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.064},
		"m5a.16xlarge":  {Region: "us-west-2", Type: "m5a.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.752},
		"m5a.24xlarge":  {Region: "us-west-2", Type: "m5a.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.128},
		"m5a.2xlarge":   {Region: "us-west-2", Type: "m5a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.344},
		"m5a.4xlarge":   {Region: "us-west-2", Type: "m5a.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.688},
		"m5a.8xlarge":   {Region: "us-west-2", Type: "m5a.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.376},
		"m5a.large":     {Region: "us-west-2", Type: "m5a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.086},
		"m5a.xlarge":    {Region: "us-west-2", Type: "m5a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.172},
		"m5ad.12xlarge": {Region: "us-west-2", Type: "m5ad.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.472},
		"m5ad.16xlarge": {Region: "us-west-2", Type: "m5ad.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.296},
		"m5ad.24xlarge": {Region: "us-west-2", Type: "m5ad.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 4.944},
		"m5ad.2xlarge":  {Region: "us-west-2", Type: "m5ad.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.412},
		"m5ad.4xlarge":  {Region: "us-west-2", Type: "m5ad.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.824},
		"m5ad.8xlarge":  {Region: "us-west-2", Type: "m5ad.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.648},
		"m5ad.large":    {Region: "us-west-2", Type: "m5ad.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.103},
		"m5ad.xlarge":   {Region: "us-west-2", Type: "m5ad.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.206},
		"m5d.12xlarge":  {Region: "us-west-2", Type: "m5d.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"m5d.16xlarge":  {Region: "us-west-2", Type: "m5d.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"m5d.24xlarge":  {Region: "us-west-2", Type: "m5d.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"m5d.2xlarge":   {Region: "us-west-2", Type: "m5d.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"m5d.4xlarge":   {Region: "us-west-2", Type: "m5d.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"m5d.8xlarge":   {Region: "us-west-2", Type: "m5d.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"m5d.large":     {Region: "us-west-2", Type: "m5d.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"m5d.metal":     {Region: "us-west-2", Type: "m5d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"m5d.xlarge":    {Region: "us-west-2", Type: "m5d.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"m5dn.12xlarge": {Region: "us-west-2", Type: "m5dn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.264},
		"m5dn.16xlarge": {Region: "us-west-2", Type: "m5dn.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.352},
		"m5dn.24xlarge": {Region: "us-west-2", Type: "m5dn.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5dn.2xlarge":  {Region: "us-west-2", Type: "m5dn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.544},
		"m5dn.4xlarge":  {Region: "us-west-2", Type: "m5dn.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.088},
		"m5dn.8xlarge":  {Region: "us-west-2", Type: "m5dn.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.176},
		"m5dn.large":    {Region: "us-west-2", Type: "m5dn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.136},
		"m5dn.metal":    {Region: "us-west-2", Type: "m5dn.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.528},
		"m5dn.xlarge":   {Region: "us-west-2", Type: "m5dn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.272},
		"m5n.12xlarge":  {Region: "us-west-2", Type: "m5n.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.856},
		"m5n.16xlarge":  {Region: "us-west-2", Type: "m5n.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.808},
		"m5n.24xlarge":  {Region: "us-west-2", Type: "m5n.24xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.712},
		"m5n.2xlarge":   {Region: "us-west-2", Type: "m5n.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.476},
		"m5n.4xlarge":   {Region: "us-west-2", Type: "m5n.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.952},
		"m5n.8xlarge":   {Region: "us-west-2", Type: "m5n.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.904},
		"m5n.large":     {Region: "us-west-2", Type: "m5n.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.119},
		"m5n.metal":     {Region: "us-west-2", Type: "m5n.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.712},
		"m5n.xlarge":    {Region: "us-west-2", Type: "m5n.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.238},
		"m5zn.12xlarge": {Region: "us-west-2", Type: "m5zn.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.9641},
		"m5zn.2xlarge":  {Region: "us-west-2", Type: "m5zn.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.6607},
		"m5zn.3xlarge":  {Region: "us-west-2", Type: "m5zn.3xlarge", Memory: kresource.MustParse("49152Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 0.991},
		"m5zn.6xlarge":  {Region: "us-west-2", Type: "m5zn.6xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 1.982},
		"m5zn.large":    {Region: "us-west-2", Type: "m5zn.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1652},
		"m5zn.metal":    {Region: "us-west-2", Type: "m5zn.metal", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.9641},
		"m5zn.xlarge":   {Region: "us-west-2", Type: "m5zn.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.3303},
		"m6g.12xlarge":  {Region: "us-west-2", Type: "m6g.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 1.848},
		"m6g.16xlarge":  {Region: "us-west-2", Type: "m6g.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"m6g.2xlarge":   {Region: "us-west-2", Type: "m6g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.308},
		"m6g.4xlarge":   {Region: "us-west-2", Type: "m6g.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.616},
		"m6g.8xlarge":   {Region: "us-west-2", Type: "m6g.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.232},
		"m6g.large":     {Region: "us-west-2", Type: "m6g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.077},
		"m6g.medium":    {Region: "us-west-2", Type: "m6g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0385},
		"m6g.metal":     {Region: "us-west-2", Type: "m6g.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.464},
		"m6g.xlarge":    {Region: "us-west-2", Type: "m6g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.154},
		"m6gd.12xlarge": {Region: "us-west-2", Type: "m6gd.12xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.1696},
		"m6gd.16xlarge": {Region: "us-west-2", Type: "m6gd.16xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8928},
		"m6gd.2xlarge":  {Region: "us-west-2", Type: "m6gd.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3616},
		"m6gd.4xlarge":  {Region: "us-west-2", Type: "m6gd.4xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.7232},
		"m6gd.8xlarge":  {Region: "us-west-2", Type: "m6gd.8xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.4464},
		"m6gd.large":    {Region: "us-west-2", Type: "m6gd.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0904},
		"m6gd.medium":   {Region: "us-west-2", Type: "m6gd.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0452},
		"m6gd.metal":    {Region: "us-west-2", Type: "m6gd.metal", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 2.8928},
		"m6gd.xlarge":   {Region: "us-west-2", Type: "m6gd.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1808},
		"p2.16xlarge":   {Region: "us-west-2", Type: "p2.16xlarge", Memory: kresource.MustParse("749568Mi"), CPU: kresource.MustParse("64"), GPU: 16, Inf: 0, Price: 14.4},
		"p2.8xlarge":    {Region: "us-west-2", Type: "p2.8xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("32"), GPU: 8, Inf: 0, Price: 7.2},
		"p2.xlarge":     {Region: "us-west-2", Type: "p2.xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("4"), GPU: 1, Inf: 0, Price: 0.9},
		"p3.16xlarge":   {Region: "us-west-2", Type: "p3.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 8, Inf: 0, Price: 24.48},
		"p3.2xlarge":    {Region: "us-west-2", Type: "p3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 1, Inf: 0, Price: 3.06},
		"p3.8xlarge":    {Region: "us-west-2", Type: "p3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 4, Inf: 0, Price: 12.24},
		"p3dn.24xlarge": {Region: "us-west-2", Type: "p3dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 31.212},
		"p4d.24xlarge":  {Region: "us-west-2", Type: "p4d.24xlarge", Memory: kresource.MustParse("1179648Mi"), CPU: kresource.MustParse("96"), GPU: 8, Inf: 0, Price: 32.7726},
		"r3.2xlarge":    {Region: "us-west-2", Type: "r3.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.665},
		"r3.4xlarge":    {Region: "us-west-2", Type: "r3.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.33},
		"r3.8xlarge":    {Region: "us-west-2", Type: "r3.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.66},
		"r3.large":      {Region: "us-west-2", Type: "r3.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.166},
		"r3.xlarge":     {Region: "us-west-2", Type: "r3.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.333},
		"r4.16xlarge":   {Region: "us-west-2", Type: "r4.16xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.256},
		"r4.2xlarge":    {Region: "us-west-2", Type: "r4.2xlarge", Memory: kresource.MustParse("62464Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.532},
		"r4.4xlarge":    {Region: "us-west-2", Type: "r4.4xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.064},
		"r4.8xlarge":    {Region: "us-west-2", Type: "r4.8xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.128},
		"r4.large":      {Region: "us-west-2", Type: "r4.large", Memory: kresource.MustParse("15616Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.133},
		"r4.xlarge":     {Region: "us-west-2", Type: "r4.xlarge", Memory: kresource.MustParse("31232Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.266},
		"r5.12xlarge":   {Region: "us-west-2", Type: "r5.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.024},
		"r5.16xlarge":   {Region: "us-west-2", Type: "r5.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.032},
		"r5.24xlarge":   {Region: "us-west-2", Type: "r5.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5.2xlarge":    {Region: "us-west-2", Type: "r5.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.504},
		"r5.4xlarge":    {Region: "us-west-2", Type: "r5.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.008},
		"r5.8xlarge":    {Region: "us-west-2", Type: "r5.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.016},
		"r5.large":      {Region: "us-west-2", Type: "r5.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.126},
		"r5.metal":      {Region: "us-west-2", Type: "r5.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.048},
		"r5.xlarge":     {Region: "us-west-2", Type: "r5.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.252},
		"r5a.12xlarge":  {Region: "us-west-2", Type: "r5a.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.712},
		"r5a.16xlarge":  {Region: "us-west-2", Type: "r5a.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.616},
		"r5a.24xlarge":  {Region: "us-west-2", Type: "r5a.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 5.424},
		"r5a.2xlarge":   {Region: "us-west-2", Type: "r5a.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.452},
		"r5a.4xlarge":   {Region: "us-west-2", Type: "r5a.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.904},
		"r5a.8xlarge":   {Region: "us-west-2", Type: "r5a.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.808},
		"r5a.large":     {Region: "us-west-2", Type: "r5a.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.113},
		"r5a.xlarge":    {Region: "us-west-2", Type: "r5a.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.226},
		"r5ad.12xlarge": {Region: "us-west-2", Type: "r5ad.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.144},
		"r5ad.16xlarge": {Region: "us-west-2", Type: "r5ad.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.192},
		"r5ad.24xlarge": {Region: "us-west-2", Type: "r5ad.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.288},
		"r5ad.2xlarge":  {Region: "us-west-2", Type: "r5ad.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.524},
		"r5ad.4xlarge":  {Region: "us-west-2", Type: "r5ad.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.048},
		"r5ad.8xlarge":  {Region: "us-west-2", Type: "r5ad.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.096},
		"r5ad.large":    {Region: "us-west-2", Type: "r5ad.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.131},
		"r5ad.xlarge":   {Region: "us-west-2", Type: "r5ad.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.262},
		"r5b.12xlarge":  {Region: "us-west-2", Type: "r5b.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"r5b.16xlarge":  {Region: "us-west-2", Type: "r5b.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.768},
		"r5b.24xlarge":  {Region: "us-west-2", Type: "r5b.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5b.2xlarge":   {Region: "us-west-2", Type: "r5b.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"r5b.4xlarge":   {Region: "us-west-2", Type: "r5b.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"r5b.8xlarge":   {Region: "us-west-2", Type: "r5b.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.384},
		"r5b.large":     {Region: "us-west-2", Type: "r5b.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"r5b.metal":     {Region: "us-west-2", Type: "r5b.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5b.xlarge":    {Region: "us-west-2", Type: "r5b.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"r5d.12xlarge":  {Region: "us-west-2", Type: "r5d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.456},
		"r5d.16xlarge":  {Region: "us-west-2", Type: "r5d.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.608},
		"r5d.24xlarge":  {Region: "us-west-2", Type: "r5d.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5d.2xlarge":   {Region: "us-west-2", Type: "r5d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.576},
		"r5d.4xlarge":   {Region: "us-west-2", Type: "r5d.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.152},
		"r5d.8xlarge":   {Region: "us-west-2", Type: "r5d.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.304},
		"r5d.large":     {Region: "us-west-2", Type: "r5d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.144},
		"r5d.metal":     {Region: "us-west-2", Type: "r5d.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 6.912},
		"r5d.xlarge":    {Region: "us-west-2", Type: "r5d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.288},
		"r5dn.12xlarge": {Region: "us-west-2", Type: "r5dn.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.008},
		"r5dn.16xlarge": {Region: "us-west-2", Type: "r5dn.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 5.344},
		"r5dn.24xlarge": {Region: "us-west-2", Type: "r5dn.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5dn.2xlarge":  {Region: "us-west-2", Type: "r5dn.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.668},
		"r5dn.4xlarge":  {Region: "us-west-2", Type: "r5dn.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.336},
		"r5dn.8xlarge":  {Region: "us-west-2", Type: "r5dn.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.672},
		"r5dn.large":    {Region: "us-west-2", Type: "r5dn.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.167},
		"r5dn.metal":    {Region: "us-west-2", Type: "r5dn.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 8.016},
		"r5dn.xlarge":   {Region: "us-west-2", Type: "r5dn.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.334},
		"r5n.12xlarge":  {Region: "us-west-2", Type: "r5n.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 3.576},
		"r5n.16xlarge":  {Region: "us-west-2", Type: "r5n.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 4.768},
		"r5n.24xlarge":  {Region: "us-west-2", Type: "r5n.24xlarge", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5n.2xlarge":   {Region: "us-west-2", Type: "r5n.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.596},
		"r5n.4xlarge":   {Region: "us-west-2", Type: "r5n.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 1.192},
		"r5n.8xlarge":   {Region: "us-west-2", Type: "r5n.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 2.384},
		"r5n.large":     {Region: "us-west-2", Type: "r5n.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.149},
		"r5n.metal":     {Region: "us-west-2", Type: "r5n.metal", Memory: kresource.MustParse("786432Mi"), CPU: kresource.MustParse("96"), GPU: 0, Inf: 0, Price: 7.152},
		"r5n.xlarge":    {Region: "us-west-2", Type: "r5n.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.298},
		"r6g.12xlarge":  {Region: "us-west-2", Type: "r6g.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.4192},
		"r6g.16xlarge":  {Region: "us-west-2", Type: "r6g.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"r6g.2xlarge":   {Region: "us-west-2", Type: "r6g.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4032},
		"r6g.4xlarge":   {Region: "us-west-2", Type: "r6g.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.8064},
		"r6g.8xlarge":   {Region: "us-west-2", Type: "r6g.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.6128},
		"r6g.large":     {Region: "us-west-2", Type: "r6g.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1008},
		"r6g.medium":    {Region: "us-west-2", Type: "r6g.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0504},
		"r6g.metal":     {Region: "us-west-2", Type: "r6g.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.2256},
		"r6g.xlarge":    {Region: "us-west-2", Type: "r6g.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2016},
		"r6gd.12xlarge": {Region: "us-west-2", Type: "r6gd.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 2.7648},
		"r6gd.16xlarge": {Region: "us-west-2", Type: "r6gd.16xlarge", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6864},
		"r6gd.2xlarge":  {Region: "us-west-2", Type: "r6gd.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.4608},
		"r6gd.4xlarge":  {Region: "us-west-2", Type: "r6gd.4xlarge", Memory: kresource.MustParse("131072Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 0.9216},
		"r6gd.8xlarge":  {Region: "us-west-2", Type: "r6gd.8xlarge", Memory: kresource.MustParse("262144Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 1.8432},
		"r6gd.large":    {Region: "us-west-2", Type: "r6gd.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.1152},
		"r6gd.medium":   {Region: "us-west-2", Type: "r6gd.medium", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0576},
		"r6gd.metal":    {Region: "us-west-2", Type: "r6gd.metal", Memory: kresource.MustParse("524288Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 3.6864},
		"r6gd.xlarge":   {Region: "us-west-2", Type: "r6gd.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.2304},
		"t1.micro":      {Region: "us-west-2", Type: "t1.micro", Memory: kresource.MustParse("627Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.02},
		"t2.2xlarge":    {Region: "us-west-2", Type: "t2.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3712},
		"t2.large":      {Region: "us-west-2", Type: "t2.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0928},
		"t2.medium":     {Region: "us-west-2", Type: "t2.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0464},
		"t2.micro":      {Region: "us-west-2", Type: "t2.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0116},
		"t2.nano":       {Region: "us-west-2", Type: "t2.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.0058},
		"t2.small":      {Region: "us-west-2", Type: "t2.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("1"), GPU: 0, Inf: 0, Price: 0.023},
		"t2.xlarge":     {Region: "us-west-2", Type: "t2.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1856},
		"t3.2xlarge":    {Region: "us-west-2", Type: "t3.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3328},
		"t3.large":      {Region: "us-west-2", Type: "t3.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0832},
		"t3.medium":     {Region: "us-west-2", Type: "t3.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0416},
		"t3.micro":      {Region: "us-west-2", Type: "t3.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0104},
		"t3.nano":       {Region: "us-west-2", Type: "t3.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0052},
		"t3.small":      {Region: "us-west-2", Type: "t3.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0208},
		"t3.xlarge":     {Region: "us-west-2", Type: "t3.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1664},
		"t3a.2xlarge":   {Region: "us-west-2", Type: "t3a.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.3008},
		"t3a.large":     {Region: "us-west-2", Type: "t3a.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0752},
		"t3a.medium":    {Region: "us-west-2", Type: "t3a.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0376},
		"t3a.micro":     {Region: "us-west-2", Type: "t3a.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0094},
		"t3a.nano":      {Region: "us-west-2", Type: "t3a.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0047},
		"t3a.small":     {Region: "us-west-2", Type: "t3a.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0188},
		"t3a.xlarge":    {Region: "us-west-2", Type: "t3a.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1504},
		"t4g.2xlarge":   {Region: "us-west-2", Type: "t4g.2xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.2688},
		"t4g.large":     {Region: "us-west-2", Type: "t4g.large", Memory: kresource.MustParse("8192Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0672},
		"t4g.medium":    {Region: "us-west-2", Type: "t4g.medium", Memory: kresource.MustParse("4096Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0336},
		"t4g.micro":     {Region: "us-west-2", Type: "t4g.micro", Memory: kresource.MustParse("1024Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0084},
		"t4g.nano":      {Region: "us-west-2", Type: "t4g.nano", Memory: kresource.MustParse("512Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0042},
		"t4g.small":     {Region: "us-west-2", Type: "t4g.small", Memory: kresource.MustParse("2048Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.0168},
		"t4g.xlarge":    {Region: "us-west-2", Type: "t4g.xlarge", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.1344},
		"x1.16xlarge":   {Region: "us-west-2", Type: "x1.16xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 6.669},
		"x1.32xlarge":   {Region: "us-west-2", Type: "x1.32xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 13.338},
		"x1e.16xlarge":  {Region: "us-west-2", Type: "x1e.16xlarge", Memory: kresource.MustParse("1998848Mi"), CPU: kresource.MustParse("64"), GPU: 0, Inf: 0, Price: 13.344},
		"x1e.2xlarge":   {Region: "us-west-2", Type: "x1e.2xlarge", Memory: kresource.MustParse("249856Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 1.668},
		"x1e.32xlarge":  {Region: "us-west-2", Type: "x1e.32xlarge", Memory: kresource.MustParse("3997696Mi"), CPU: kresource.MustParse("128"), GPU: 0, Inf: 0, Price: 26.688},
		"x1e.4xlarge":   {Region: "us-west-2", Type: "x1e.4xlarge", Memory: kresource.MustParse("499712Mi"), CPU: kresource.MustParse("16"), GPU: 0, Inf: 0, Price: 3.336},
		"x1e.8xlarge":   {Region: "us-west-2", Type: "x1e.8xlarge", Memory: kresource.MustParse("999424Mi"), CPU: kresource.MustParse("32"), GPU: 0, Inf: 0, Price: 6.672},
		"x1e.xlarge":    {Region: "us-west-2", Type: "x1e.xlarge", Memory: kresource.MustParse("124928Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.834},
		"z1d.12xlarge":  {Region: "us-west-2", Type: "z1d.12xlarge", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"z1d.2xlarge":   {Region: "us-west-2", Type: "z1d.2xlarge", Memory: kresource.MustParse("65536Mi"), CPU: kresource.MustParse("8"), GPU: 0, Inf: 0, Price: 0.744},
		"z1d.3xlarge":   {Region: "us-west-2", Type: "z1d.3xlarge", Memory: kresource.MustParse("98304Mi"), CPU: kresource.MustParse("12"), GPU: 0, Inf: 0, Price: 1.116},
		"z1d.6xlarge":   {Region: "us-west-2", Type: "z1d.6xlarge", Memory: kresource.MustParse("196608Mi"), CPU: kresource.MustParse("24"), GPU: 0, Inf: 0, Price: 2.232},
		"z1d.large":     {Region: "us-west-2", Type: "z1d.large", Memory: kresource.MustParse("16384Mi"), CPU: kresource.MustParse("2"), GPU: 0, Inf: 0, Price: 0.186},
		"z1d.metal":     {Region: "us-west-2", Type: "z1d.metal", Memory: kresource.MustParse("393216Mi"), CPU: kresource.MustParse("48"), GPU: 0, Inf: 0, Price: 4.464},
		"z1d.xlarge":    {Region: "us-west-2", Type: "z1d.xlarge", Memory: kresource.MustParse("32768Mi"), CPU: kresource.MustParse("4"), GPU: 0, Inf: 0, Price: 0.372},
	},
}

// region -> NLB metadata
var NLBMetadatas = map[string]NLBMetadata{
	"af-south-1":     {Region: "af-south-1", Price: 0.029988},
	"ap-east-1":      {Region: "ap-east-1", Price: 0.0277},
	"ap-northeast-1": {Region: "ap-northeast-1", Price: 0.0243},
	"ap-northeast-2": {Region: "ap-northeast-2", Price: 0.0225},
	"ap-northeast-3": {Region: "ap-northeast-3", Price: 0.0243},
	"ap-south-1":     {Region: "ap-south-1", Price: 0.0239},
	"ap-southeast-1": {Region: "ap-southeast-1", Price: 0.0252},
	"ap-southeast-2": {Region: "ap-southeast-2", Price: 0.0252},
	"ca-central-1":   {Region: "ca-central-1", Price: 0.02475},
	"eu-central-1":   {Region: "eu-central-1", Price: 0.027},
	"eu-north-1":     {Region: "eu-north-1", Price: 0.02394},
	"eu-south-1":     {Region: "eu-south-1", Price: 0.02646},
	"eu-west-1":      {Region: "eu-west-1", Price: 0.0252},
	"eu-west-2":      {Region: "eu-west-2", Price: 0.02646},
	"eu-west-3":      {Region: "eu-west-3", Price: 0.02646},
	"me-south-1":     {Region: "me-south-1", Price: 0.02772},
	"sa-east-1":      {Region: "sa-east-1", Price: 0.034},
	"us-east-1":      {Region: "us-east-1", Price: 0.0225},
	"us-east-2":      {Region: "us-east-2", Price: 0.0225},
	"us-west-1":      {Region: "us-west-1", Price: 0.0252},
	"us-west-2":      {Region: "us-west-2", Price: 0.0225},
}

// region -> NAT metadata
var NATMetadatas = map[string]NATMetadata{
	"af-south-1":     {Region: "af-south-1", Price: 0.057},
	"ap-east-1":      {Region: "ap-east-1", Price: 0.065},
	"ap-northeast-1": {Region: "ap-northeast-1", Price: 0.062},
	"ap-northeast-2": {Region: "ap-northeast-2", Price: 0.059},
	"ap-northeast-3": {Region: "ap-northeast-3", Price: 0.062},
	"ap-south-1":     {Region: "ap-south-1", Price: 0.056},
	"ap-southeast-1": {Region: "ap-southeast-1", Price: 0.059},
	"ap-southeast-2": {Region: "ap-southeast-2", Price: 0.059},
	"ca-central-1":   {Region: "ca-central-1", Price: 0.05},
	"eu-central-1":   {Region: "eu-central-1", Price: 0.052},
	"eu-north-1":     {Region: "eu-north-1", Price: 0.046},
	"eu-south-1":     {Region: "eu-south-1", Price: 0.05},
	"eu-west-1":      {Region: "eu-west-1", Price: 0.048},
	"eu-west-2":      {Region: "eu-west-2", Price: 0.05},
	"eu-west-3":      {Region: "eu-west-3", Price: 0.05},
	"me-south-1":     {Region: "me-south-1", Price: 0.0528},
	"sa-east-1":      {Region: "sa-east-1", Price: 0.093},
	"us-east-1":      {Region: "us-east-1", Price: 0.045},
	"us-east-2":      {Region: "us-east-2", Price: 0.045},
	"us-west-1":      {Region: "us-west-1", Price: 0.048},
	"us-west-2":      {Region: "us-west-2", Price: 0.045},
}

// region -> EBS metadata
var EBSMetadatas = map[string]map[string]EBSMetadata{
	"af-south-1": {
		"gp2": {Region: "af-south-1", Type: "gp2", PriceGB: 0.1309, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "af-south-1", Type: "gp3", PriceGB: 0.1047, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "af-south-1", Type: "io1", PriceGB: 0.16422, PriceIOPS: 0.0856800000, IOPSConfigurable: true},
		"sc1": {Region: "af-south-1", Type: "sc1", PriceGB: 0.019992, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "af-south-1", Type: "st1", PriceGB: 0.0595, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-east-1": {
		"gp2": {Region: "ap-east-1", Type: "gp2", PriceGB: 0.132, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-east-1", Type: "gp3", PriceGB: 0.1056, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-east-1", Type: "io1", PriceGB: 0.1518, PriceIOPS: 0.0792000000, IOPSConfigurable: true},
		"io2": {Region: "ap-east-1", Type: "io2", PriceGB: 0.1518, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ap-east-1", Type: "sc1", PriceGB: 0.0198, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-east-1", Type: "st1", PriceGB: 0.0594, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-northeast-1": {
		"gp2": {Region: "ap-northeast-1", Type: "gp2", PriceGB: 0.12, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-northeast-1", Type: "gp3", PriceGB: 0.096, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-northeast-1", Type: "io1", PriceGB: 0.142, PriceIOPS: 0.0740000000, IOPSConfigurable: true},
		"io2": {Region: "ap-northeast-1", Type: "io2", PriceGB: 0.142, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ap-northeast-1", Type: "sc1", PriceGB: 0.018, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-northeast-1", Type: "st1", PriceGB: 0.054, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-northeast-2": {
		"gp2": {Region: "ap-northeast-2", Type: "gp2", PriceGB: 0.114, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-northeast-2", Type: "gp3", PriceGB: 0.0912, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-northeast-2", Type: "io1", PriceGB: 0.1278, PriceIOPS: 0.0666000000, IOPSConfigurable: true},
		"io2": {Region: "ap-northeast-2", Type: "io2", PriceGB: 0.1278, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ap-northeast-2", Type: "sc1", PriceGB: 0.0174, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-northeast-2", Type: "st1", PriceGB: 0.051, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-northeast-3": {
		"gp2": {Region: "ap-northeast-3", Type: "gp2", PriceGB: 0.12, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-northeast-3", Type: "gp3", PriceGB: 0.096, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-northeast-3", Type: "io1", PriceGB: 0.142, PriceIOPS: 0.0740000000, IOPSConfigurable: true},
		"sc1": {Region: "ap-northeast-3", Type: "sc1", PriceGB: 0.018, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-northeast-3", Type: "st1", PriceGB: 0.054, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-south-1": {
		"gp2": {Region: "ap-south-1", Type: "gp2", PriceGB: 0.114, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-south-1", Type: "gp3", PriceGB: 0.0912, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-south-1", Type: "io1", PriceGB: 0.131, PriceIOPS: 0.0680000000, IOPSConfigurable: true},
		"io2": {Region: "ap-south-1", Type: "io2", PriceGB: 0.131, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ap-south-1", Type: "sc1", PriceGB: 0.0174, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-south-1", Type: "st1", PriceGB: 0.051, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-southeast-1": {
		"gp2": {Region: "ap-southeast-1", Type: "gp2", PriceGB: 0.12, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-southeast-1", Type: "gp3", PriceGB: 0.096, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-southeast-1", Type: "io1", PriceGB: 0.138, PriceIOPS: 0.0720000000, IOPSConfigurable: true},
		"io2": {Region: "ap-southeast-1", Type: "io2", PriceGB: 0.138, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ap-southeast-1", Type: "sc1", PriceGB: 0.018, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-southeast-1", Type: "st1", PriceGB: 0.054, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ap-southeast-2": {
		"gp2": {Region: "ap-southeast-2", Type: "gp2", PriceGB: 0.12, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ap-southeast-2", Type: "gp3", PriceGB: 0.096, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ap-southeast-2", Type: "io1", PriceGB: 0.138, PriceIOPS: 0.0720000000, IOPSConfigurable: true},
		"io2": {Region: "ap-southeast-2", Type: "io2", PriceGB: 0.138, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ap-southeast-2", Type: "sc1", PriceGB: 0.018, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ap-southeast-2", Type: "st1", PriceGB: 0.054, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"ca-central-1": {
		"gp2": {Region: "ca-central-1", Type: "gp2", PriceGB: 0.11, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "ca-central-1", Type: "gp3", PriceGB: 0.088, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "ca-central-1", Type: "io1", PriceGB: 0.138, PriceIOPS: 0.0720000000, IOPSConfigurable: true},
		"io2": {Region: "ca-central-1", Type: "io2", PriceGB: 0.138, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "ca-central-1", Type: "sc1", PriceGB: 0.0168, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "ca-central-1", Type: "st1", PriceGB: 0.05, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"eu-central-1": {
		"gp2": {Region: "eu-central-1", Type: "gp2", PriceGB: 0.119, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "eu-central-1", Type: "gp3", PriceGB: 0.0952, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "eu-central-1", Type: "io1", PriceGB: 0.149, PriceIOPS: 0.0780000000, IOPSConfigurable: true},
		"io2": {Region: "eu-central-1", Type: "io2", PriceGB: 0.149, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "eu-central-1", Type: "sc1", PriceGB: 0.018, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "eu-central-1", Type: "st1", PriceGB: 0.054, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"eu-north-1": {
		"gp2": {Region: "eu-north-1", Type: "gp2", PriceGB: 0.1045, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "eu-north-1", Type: "gp3", PriceGB: 0.0836, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "eu-north-1", Type: "io1", PriceGB: 0.1311, PriceIOPS: 0.0684000000, IOPSConfigurable: true},
		"io2": {Region: "eu-north-1", Type: "io2", PriceGB: 0.1311, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "eu-north-1", Type: "sc1", PriceGB: 0.01596, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "eu-north-1", Type: "st1", PriceGB: 0.0475, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"eu-south-1": {
		"gp2": {Region: "eu-south-1", Type: "gp2", PriceGB: 0.1155, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "eu-south-1", Type: "gp3", PriceGB: 0.0924, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "eu-south-1", Type: "io1", PriceGB: 0.1449, PriceIOPS: 0.0756000000, IOPSConfigurable: true},
		"sc1": {Region: "eu-south-1", Type: "sc1", PriceGB: 0.01764, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "eu-south-1", Type: "st1", PriceGB: 0.0525, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"eu-west-1": {
		"gp2": {Region: "eu-west-1", Type: "gp2", PriceGB: 0.11, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "eu-west-1", Type: "gp3", PriceGB: 0.088, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "eu-west-1", Type: "io1", PriceGB: 0.138, PriceIOPS: 0.0720000000, IOPSConfigurable: true},
		"io2": {Region: "eu-west-1", Type: "io2", PriceGB: 0.138, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "eu-west-1", Type: "sc1", PriceGB: 0.0168, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "eu-west-1", Type: "st1", PriceGB: 0.05, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"eu-west-2": {
		"gp2": {Region: "eu-west-2", Type: "gp2", PriceGB: 0.116, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "eu-west-2", Type: "gp3", PriceGB: 0.0928, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "eu-west-2", Type: "io1", PriceGB: 0.145, PriceIOPS: 0.0760000000, IOPSConfigurable: true},
		"io2": {Region: "eu-west-2", Type: "io2", PriceGB: 0.145, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "eu-west-2", Type: "sc1", PriceGB: 0.0174, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "eu-west-2", Type: "st1", PriceGB: 0.053, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"eu-west-3": {
		"gp2": {Region: "eu-west-3", Type: "gp2", PriceGB: 0.116, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "eu-west-3", Type: "gp3", PriceGB: 0.0928, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "eu-west-3", Type: "io1", PriceGB: 0.145, PriceIOPS: 0.0760000000, IOPSConfigurable: true},
		"sc1": {Region: "eu-west-3", Type: "sc1", PriceGB: 0.0174, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "eu-west-3", Type: "st1", PriceGB: 0.053, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"me-south-1": {
		"gp2": {Region: "me-south-1", Type: "gp2", PriceGB: 0.121, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "me-south-1", Type: "gp3", PriceGB: 0.0968, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "me-south-1", Type: "io1", PriceGB: 0.1518, PriceIOPS: 0.0792000000, IOPSConfigurable: true},
		"io2": {Region: "me-south-1", Type: "io2", PriceGB: 0.1518, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "me-south-1", Type: "sc1", PriceGB: 0.01848, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "me-south-1", Type: "st1", PriceGB: 0.055, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"sa-east-1": {
		"gp2": {Region: "sa-east-1", Type: "gp2", PriceGB: 0.19, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "sa-east-1", Type: "gp3", PriceGB: 0.152, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "sa-east-1", Type: "io1", PriceGB: 0.238, PriceIOPS: 0.0910000000, IOPSConfigurable: true},
		"sc1": {Region: "sa-east-1", Type: "sc1", PriceGB: 0.0288, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "sa-east-1", Type: "st1", PriceGB: 0.086, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"us-east-1": {
		"gp2": {Region: "us-east-1", Type: "gp2", PriceGB: 0.1, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "us-east-1", Type: "gp3", PriceGB: 0.08, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "us-east-1", Type: "io1", PriceGB: 0.125, PriceIOPS: 0.0650000000, IOPSConfigurable: true},
		"io2": {Region: "us-east-1", Type: "io2", PriceGB: 0.125, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "us-east-1", Type: "sc1", PriceGB: 0.015, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "us-east-1", Type: "st1", PriceGB: 0.045, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"us-east-2": {
		"gp2": {Region: "us-east-2", Type: "gp2", PriceGB: 0.1, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "us-east-2", Type: "gp3", PriceGB: 0.08, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "us-east-2", Type: "io1", PriceGB: 0.125, PriceIOPS: 0.0650000000, IOPSConfigurable: true},
		"io2": {Region: "us-east-2", Type: "io2", PriceGB: 0.125, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "us-east-2", Type: "sc1", PriceGB: 0.015, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "us-east-2", Type: "st1", PriceGB: 0.045, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"us-west-1": {
		"gp2": {Region: "us-west-1", Type: "gp2", PriceGB: 0.12, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "us-west-1", Type: "gp3", PriceGB: 0.096, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "us-west-1", Type: "io1", PriceGB: 0.138, PriceIOPS: 0.0720000000, IOPSConfigurable: true},
		"io2": {Region: "us-west-1", Type: "io2", PriceGB: 0.138, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "us-west-1", Type: "sc1", PriceGB: 0.018, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "us-west-1", Type: "st1", PriceGB: 0.054, PriceIOPS: 0, IOPSConfigurable: false},
	},
	"us-west-2": {
		"gp2": {Region: "us-west-2", Type: "gp2", PriceGB: 0.1, PriceIOPS: 0, IOPSConfigurable: false},
		"gp3": {Region: "us-west-2", Type: "gp3", PriceGB: 0.08, PriceIOPS: 0, IOPSConfigurable: false},
		"io1": {Region: "us-west-2", Type: "io1", PriceGB: 0.125, PriceIOPS: 0.0650000000, IOPSConfigurable: true},
		"io2": {Region: "us-west-2", Type: "io2", PriceGB: 0.125, PriceIOPS: 0, IOPSConfigurable: false},
		"sc1": {Region: "us-west-2", Type: "sc1", PriceGB: 0.015, PriceIOPS: 0, IOPSConfigurable: false},
		"st1": {Region: "us-west-2", Type: "st1", PriceGB: 0.045, PriceIOPS: 0, IOPSConfigurable: false},
	},
}

// region -> EKS price
var EKSPrices = map[string]float64{
	"af-south-1":     0.1,
	"ap-east-1":      0.1,
	"ap-northeast-1": 0.1,
	"ap-northeast-2": 0.1,
	"ap-northeast-3": 0.1,
	"ap-south-1":     0.1,
	"ap-southeast-1": 0.1,
	"ap-southeast-2": 0.1,
	"ca-central-1":   0.1,
	"eu-central-1":   0.1,
	"eu-north-1":     0.1,
	"eu-south-1":     0.1,
	"eu-west-1":      0.1,
	"eu-west-2":      0.1,
	"eu-west-3":      0.1,
	"me-south-1":     0.1,
	"sa-east-1":      0.1,
	"us-east-1":      0.1,
	"us-east-2":      0.1,
	"us-west-1":      0.1,
	"us-west-2":      0.1,
}
