# Examples

## TensorFlow

- [Iris classification](tensorflow/iris-classifier): deploy a model to classify iris flowers.

- [Text generation](tensorflow/text-generator): deploy OpenAI's GPT-2 to generate text.

- [Sentiment analysis](tensorflow/sentiment-analyzer): deploy a BERT model for sentiment analysis.

- [Image classification](tensorflow/image-classifier-inception): deploy an Inception model to classify images.

- [Image classification](tensorflow/image-classifier-resnet50): deploy a ResNet50 model to classify images.

- [License plate reader](tensorflow/license-plate-reader): deploy a YOLOv3 model (and others) to identify license plates in real time.

- [Multi-model classification](tensorflow/multi-model-classifier): deploy 3 models (ResNet50, Iris, Inception) in a single API.

## Keras

- [Denoisify text documents](keras/document-denoiser): deploy an Autoencoder model to clean text document images of noise.

## PyTorch

- [Iris classification](pytorch/iris-classifier): deploy a model to classify iris flowers.

- [Text generation](pytorch/text-generator): deploy Hugging Face's GPT-2 model to generate text.

- [Sentiment analysis](pytorch/sentiment-analyzer): deploy a Hugging Face transformers model for sentiment analysis.

- [Search completion](pytorch/search-completer): deploy a Facebook's RoBERTa model to complete search terms.

- [Answer generation](pytorch/answer-generator): deploy Microsoft's DialoGPT model to answer questions.

- [Text summarization](pytorch/text-summarizer): deploy a BART model (from Hugging Face's transformers library) to summarize text.

- [Reading comprehension](pytorch/reading-comprehender): deploy an AllenNLP model for reading comprehension.

- [Language identification](pytorch/language-identifier): deploy a fastText model to identify languages.

- [Multi-model text analysis](pytorch/multi-model-text-analyzer): deploy 2 models (Sentiment and Summarization analyzers) in a single API.

- [Image classification](pytorch/image-classifier-alexnet): deploy an AlexNet model from TorchVision to classify images.

- [Image classification](pytorch/image-classifier-resnet50): deploy a ResNet50 model from TorchVision to classify images.

- [Object detection](pytorch/object-detector): deploy a Faster R-CNN model from TorchVision to detect objects in images.

- [Question generator](pytorch/question-generator): deploy a transformers model to generate questions given text and the correct answer.

## ONNX

- [Iris classification](onnx/iris-classifier): deploy an XGBoost model (exported in ONNX) to classify iris flowers.

- [YOLOv5 YouTube detection](onnx/yolov5-youtube): deploy a YOLOv5 model trained on COCO val2017 dataset.

- [Multi-model classification](onnx/multi-model-classifier): deploy 3 models (ResNet50, MobileNet, ShuffleNet) in a single API.

## scikit-learn

- [Iris classification](sklearn/iris-classifier): deploy a model to classify iris flowers.

- [MPG estimation](sklearn/mpg-estimator): deploy a linear regression model to estimate MPG.

## spacy

- [Entity recognizer](spacy/entity-recognizer): deploy a spacy model for named entity recognition.
