---
title: "Configuration file"
linkTitle: "Configuration file"
weight: 1
slug: configuration-file
---

<!-- DO NOT EDIT THIS FILE - This file has been automatically generated from its .template -->

Cortex can be configured using a YAML file - specified using the `-config.file` flag - or CLI flags. In case you combine both, CLI flags take precedence over the YAML config file.

The current configuration of any Cortex component can be seen by visiting the `/config` HTTP path.
Passwords are filtered out of this endpoint.

## Reference

To specify which configuration file to load, pass the `-config.file` flag at the command line. The file is written in [YAML format](https://en.wikipedia.org/wiki/YAML), defined by the scheme below. Brackets indicate that a parameter is optional.

### Generic placeholders

* `<boolean>`: a boolean that can take the values `true` or `false`
* `<int>`: any integer matching the regular expression `[1-9]+[0-9]*`
* `<duration>`: a duration matching the regular expression `[0-9]+(ns|us|µs|ms|s|m|h|d|w|y)` where y = 365 days.
* `<string>`: a regular string
* `<url>`: an URL
* `<prefix>`: a CLI flag prefix based on the context (look at the parent configuration block to see which CLI flags prefix should be used)
* `<relabel_config>`: a [Prometheus relabeling configuration](https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config).
* `<time>`: a timestamp, with available formats: `2006-01-20` (midnight, local timezone), `2006-01-20T15:04` (local timezone), and RFC 3339 formats: `2006-01-20T15:04:05Z` (UTC) or `2006-01-20T15:04:05+07:00` (explicit timezone)

### Use environment variables in the configuration

You can use environment variable references in the config file to set values that need to be configurable during deployment by using the `-config.expand-env` flag.
To do this, use:

```
${VAR}
```

Where VAR is the name of the environment variable.

Each variable reference is replaced at startup by the value of the environment variable.
The replacement is case-sensitive and occurs before the YAML file is parsed.
References to undefined variables are replaced by empty strings unless you specify a default value or custom error text.

To specify a default value, use:

```
${VAR:default_value}
```

Where default_value is the value to use if the environment variable is undefined.

### Supported contents and default values of the config file

```yaml
# Comma-separated list of Cortex modules to load. The alias 'all' can be used in
# the list to load a number of core modules and will enable single-binary mode.
# Use '-modules' command line flag to get a list of available modules, and to
# see which modules are included in 'all'.
# CLI flag: -target
[target: <string> | default = "all"]

# Set to false to disable auth.
# CLI flag: -auth.enabled
[auth_enabled: <boolean> | default = true]

# HTTP path prefix for Cortex API.
# CLI flag: -http.prefix
[http_prefix: <string> | default = "/api/prom"]

api:
  # HTTP URL path under which the Alertmanager ui and api will be served.
  # CLI flag: -http.alertmanager-http-prefix
  [alertmanager_http_prefix: <string> | default = "/alertmanager"]

  # HTTP URL path under which the Prometheus api will be served.
  # CLI flag: -http.prometheus-http-prefix
  [prometheus_http_prefix: <string> | default = "/prometheus"]

# The server_config configures the HTTP and gRPC server of the launched
# service(s).
[server: <server_config>]

# The distributor_config configures the Cortex distributor.
[distributor: <distributor_config>]

# The querier_config configures the Cortex querier.
[querier: <querier_config>]

# The ingester_client_config configures how the Cortex distributors connect to
# the ingesters.
[ingester_client: <ingester_client_config>]

# The ingester_config configures the Cortex ingester.
[ingester: <ingester_config>]

# The flusher_config configures the WAL flusher target, used to manually run
# one-time flushes when scaling down ingesters.
[flusher: <flusher_config>]

# The storage_config configures where Cortex stores the data (chunks storage
# engine).
[storage: <storage_config>]

# The chunk_store_config configures how Cortex stores the data (chunks storage
# engine).
[chunk_store: <chunk_store_config>]

# The limits_config configures default and per-tenant limits imposed by Cortex
# services (ie. distributor, ingester, ...).
[limits: <limits_config>]

# The frontend_worker_config configures the worker - running within the Cortex
# querier - picking up and executing queries enqueued by the query-frontend.
[frontend_worker: <frontend_worker_config>]

# The query_frontend_config configures the Cortex query-frontend.
[frontend: <query_frontend_config>]

# The query_range_config configures the query splitting and caching in the
# Cortex query-frontend.
[query_range: <query_range_config>]

# The table_manager_config configures the Cortex table-manager.
[table_manager: <table_manager_config>]

# The blocks_storage_config configures the blocks storage.
[blocks_storage: <blocks_storage_config>]

# The compactor_config configures the compactor for the blocks storage.
[compactor: <compactor_config>]

# The store_gateway_config configures the store-gateway service used by the
# blocks storage.
[store_gateway: <store_gateway_config>]

# The purger_config configures the purger which takes care of delete requests
[purger: <purger_config>]

# The ruler_config configures the Cortex ruler.
[ruler: <ruler_config>]

# The configs_config configures the Cortex Configs DB and API.
[configs: <configs_config>]

# The alertmanager_config configures the Cortex alertmanager.
[alertmanager: <alertmanager_config>]

runtime_config:
  # How often to check runtime config file.
  # CLI flag: -runtime-config.reload-period
  [period: <duration> | default = 10s]

  # File with the configuration that can be updated in runtime.
  # CLI flag: -runtime-config.file
  [file: <string> | default = ""]

# The memberlist_config configures the Gossip memberlist.
[memberlist: <memberlist_config>]
```

### `server_config`

The `server_config` configures the HTTP and gRPC server of the launched service(s).

```yaml
# HTTP server listen address.
# CLI flag: -server.http-listen-address
[http_listen_address: <string> | default = ""]

# HTTP server listen port.
# CLI flag: -server.http-listen-port
[http_listen_port: <int> | default = 80]

# Maximum number of simultaneous http connections, <=0 to disable
# CLI flag: -server.http-conn-limit
[http_listen_conn_limit: <int> | default = 0]

# gRPC server listen address.
# CLI flag: -server.grpc-listen-address
[grpc_listen_address: <string> | default = ""]

# gRPC server listen port.
# CLI flag: -server.grpc-listen-port
[grpc_listen_port: <int> | default = 9095]

# Maximum number of simultaneous grpc connections, <=0 to disable
# CLI flag: -server.grpc-conn-limit
[grpc_listen_conn_limit: <int> | default = 0]

http_tls_config:
  # HTTP server cert path.
  # CLI flag: -server.http-tls-cert-path
  [cert_file: <string> | default = ""]

  # HTTP server key path.
  # CLI flag: -server.http-tls-key-path
  [key_file: <string> | default = ""]

  # HTTP TLS Client Auth type.
  # CLI flag: -server.http-tls-client-auth
  [client_auth_type: <string> | default = ""]

  # HTTP TLS Client CA path.
  # CLI flag: -server.http-tls-ca-path
  [client_ca_file: <string> | default = ""]

grpc_tls_config:
  # GRPC TLS server cert path.
  # CLI flag: -server.grpc-tls-cert-path
  [cert_file: <string> | default = ""]

  # GRPC TLS server key path.
  # CLI flag: -server.grpc-tls-key-path
  [key_file: <string> | default = ""]

  # GRPC TLS Client Auth type.
  # CLI flag: -server.grpc-tls-client-auth
  [client_auth_type: <string> | default = ""]

  # GRPC TLS Client CA path.
  # CLI flag: -server.grpc-tls-ca-path
  [client_ca_file: <string> | default = ""]

# Register the intrumentation handlers (/metrics etc).
# CLI flag: -server.register-instrumentation
[register_instrumentation: <boolean> | default = true]

# Timeout for graceful shutdowns
# CLI flag: -server.graceful-shutdown-timeout
[graceful_shutdown_timeout: <duration> | default = 30s]

# Read timeout for HTTP server
# CLI flag: -server.http-read-timeout
[http_server_read_timeout: <duration> | default = 30s]

# Write timeout for HTTP server
# CLI flag: -server.http-write-timeout
[http_server_write_timeout: <duration> | default = 30s]

# Idle timeout for HTTP server
# CLI flag: -server.http-idle-timeout
[http_server_idle_timeout: <duration> | default = 2m]

# Limit on the size of a gRPC message this server can receive (bytes).
# CLI flag: -server.grpc-max-recv-msg-size-bytes
[grpc_server_max_recv_msg_size: <int> | default = 4194304]

# Limit on the size of a gRPC message this server can send (bytes).
# CLI flag: -server.grpc-max-send-msg-size-bytes
[grpc_server_max_send_msg_size: <int> | default = 4194304]

# Limit on the number of concurrent streams for gRPC calls (0 = unlimited)
# CLI flag: -server.grpc-max-concurrent-streams
[grpc_server_max_concurrent_streams: <int> | default = 100]

# The duration after which an idle connection should be closed. Default:
# infinity
# CLI flag: -server.grpc.keepalive.max-connection-idle
[grpc_server_max_connection_idle: <duration> | default = 2562047h47m16.854775807s]

# The duration for the maximum amount of time a connection may exist before it
# will be closed. Default: infinity
# CLI flag: -server.grpc.keepalive.max-connection-age
[grpc_server_max_connection_age: <duration> | default = 2562047h47m16.854775807s]

# An additive period after max-connection-age after which the connection will be
# forcibly closed. Default: infinity
# CLI flag: -server.grpc.keepalive.max-connection-age-grace
[grpc_server_max_connection_age_grace: <duration> | default = 2562047h47m16.854775807s]

# Duration after which a keepalive probe is sent in case of no activity over the
# connection., Default: 2h
# CLI flag: -server.grpc.keepalive.time
[grpc_server_keepalive_time: <duration> | default = 2h]

# After having pinged for keepalive check, the duration after which an idle
# connection should be closed, Default: 20s
# CLI flag: -server.grpc.keepalive.timeout
[grpc_server_keepalive_timeout: <duration> | default = 20s]

# Output log messages in the given format. Valid formats: [logfmt, json]
# CLI flag: -log.format
[log_format: <string> | default = "logfmt"]

# Only log messages with the given severity or above. Valid levels: [debug,
# info, warn, error]
# CLI flag: -log.level
[log_level: <string> | default = "info"]

# Optionally log the source IPs.
# CLI flag: -server.log-source-ips-enabled
[log_source_ips_enabled: <boolean> | default = false]

# Header field storing the source IPs. Only used if
# server.log-source-ips-enabled is true. If not set the default Forwarded,
# X-Real-IP and X-Forwarded-For headers are used
# CLI flag: -server.log-source-ips-header
[log_source_ips_header: <string> | default = ""]

# Regex for matching the source IPs. Only used if server.log-source-ips-enabled
# is true. If not set the default Forwarded, X-Real-IP and X-Forwarded-For
# headers are used
# CLI flag: -server.log-source-ips-regex
[log_source_ips_regex: <string> | default = ""]

# Base path to serve all API routes from (e.g. /v1/)
# CLI flag: -server.path-prefix
[http_path_prefix: <string> | default = ""]
```

### `distributor_config`

The `distributor_config` configures the Cortex distributor.

```yaml
pool:
  # How frequently to clean up clients for ingesters that have gone away.
  # CLI flag: -distributor.client-cleanup-period
  [client_cleanup_period: <duration> | default = 15s]

  # Run a health check on each ingester client during periodic cleanup.
  # CLI flag: -distributor.health-check-ingesters
  [health_check_ingesters: <boolean> | default = true]

ha_tracker:
  # Enable the distributors HA tracker so that it can accept samples from
  # Prometheus HA replicas gracefully (requires labels).
  # CLI flag: -distributor.ha-tracker.enable
  [enable_ha_tracker: <boolean> | default = false]

  # Update the timestamp in the KV store for a given cluster/replica only after
  # this amount of time has passed since the current stored timestamp.
  # CLI flag: -distributor.ha-tracker.update-timeout
  [ha_tracker_update_timeout: <duration> | default = 15s]

  # Maximum jitter applied to the update timeout, in order to spread the HA
  # heartbeats over time.
  # CLI flag: -distributor.ha-tracker.update-timeout-jitter-max
  [ha_tracker_update_timeout_jitter_max: <duration> | default = 5s]

  # If we don't receive any samples from the accepted replica for a cluster in
  # this amount of time we will failover to the next replica we receive a sample
  # from. This value must be greater than the update timeout
  # CLI flag: -distributor.ha-tracker.failover-timeout
  [ha_tracker_failover_timeout: <duration> | default = 30s]

  # Backend storage to use for the ring. Please be aware that memberlist is not
  # supported by the HA tracker since gossip propagation is too slow for HA
  # purposes.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -distributor.ha-tracker.store
    [store: <string> | default = "consul"]

    # The prefix for the keys in the store. Should end with a /.
    # CLI flag: -distributor.ha-tracker.prefix
    [prefix: <string> | default = "ha-tracker/"]

    # The consul_config configures the consul client.
    # The CLI flags prefix for this block config is: distributor.ha-tracker
    [consul: <consul_config>]

    # The etcd_config configures the etcd client.
    # The CLI flags prefix for this block config is: distributor.ha-tracker
    [etcd: <etcd_config>]

    multi:
      # Primary backend storage used by multi-client.
      # CLI flag: -distributor.ha-tracker.multi.primary
      [primary: <string> | default = ""]

      # Secondary backend storage used by multi-client.
      # CLI flag: -distributor.ha-tracker.multi.secondary
      [secondary: <string> | default = ""]

      # Mirror writes to secondary store.
      # CLI flag: -distributor.ha-tracker.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # Timeout for storing value to secondary store.
      # CLI flag: -distributor.ha-tracker.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

# remote_write API max receive message size (bytes).
# CLI flag: -distributor.max-recv-msg-size
[max_recv_msg_size: <int> | default = 104857600]

# Timeout for downstream ingesters.
# CLI flag: -distributor.remote-timeout
[remote_timeout: <duration> | default = 2s]

# Time to wait before sending more than the minimum successful query requests.
# CLI flag: -distributor.extra-query-delay
[extra_queue_delay: <duration> | default = 0s]

# The sharding strategy to use. Supported values are: default, shuffle-sharding.
# CLI flag: -distributor.sharding-strategy
[sharding_strategy: <string> | default = "default"]

# Distribute samples based on all labels, as opposed to solely by user and
# metric name.
# CLI flag: -distributor.shard-by-all-labels
[shard_by_all_labels: <boolean> | default = false]

ring:
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -distributor.ring.store
    [store: <string> | default = "consul"]

    # The prefix for the keys in the store. Should end with a /.
    # CLI flag: -distributor.ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul_config configures the consul client.
    # The CLI flags prefix for this block config is: distributor.ring
    [consul: <consul_config>]

    # The etcd_config configures the etcd client.
    # The CLI flags prefix for this block config is: distributor.ring
    [etcd: <etcd_config>]

    multi:
      # Primary backend storage used by multi-client.
      # CLI flag: -distributor.ring.multi.primary
      [primary: <string> | default = ""]

      # Secondary backend storage used by multi-client.
      # CLI flag: -distributor.ring.multi.secondary
      [secondary: <string> | default = ""]

      # Mirror writes to secondary store.
      # CLI flag: -distributor.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # Timeout for storing value to secondary store.
      # CLI flag: -distributor.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # Period at which to heartbeat to the ring.
  # CLI flag: -distributor.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 5s]

  # The heartbeat timeout after which distributors are considered unhealthy
  # within the ring.
  # CLI flag: -distributor.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # Name of network interface to read address from.
  # CLI flag: -distributor.ring.instance-interface-names
  [instance_interface_names: <list of string> | default = [eth0 en0]]
```

### `ingester_config`

The `ingester_config` configures the Cortex ingester.

```yaml
walconfig:
  # Enable writing of ingested data into WAL.
  # CLI flag: -ingester.wal-enabled
  [wal_enabled: <boolean> | default = false]

  # Enable checkpointing of in-memory chunks. It should always be true when
  # using normally. Set it to false iff you are doing some small tests as there
  # is no mechanism to delete the old WAL yet if checkpoint is disabled.
  # CLI flag: -ingester.checkpoint-enabled
  [checkpoint_enabled: <boolean> | default = true]

  # Recover data from existing WAL irrespective of WAL enabled/disabled.
  # CLI flag: -ingester.recover-from-wal
  [recover_from_wal: <boolean> | default = false]

  # Directory to store the WAL and/or recover from WAL.
  # CLI flag: -ingester.wal-dir
  [wal_dir: <string> | default = "wal"]

  # Interval at which checkpoints should be created.
  # CLI flag: -ingester.checkpoint-duration
  [checkpoint_duration: <duration> | default = 30m]

  # When WAL is enabled, should chunks be flushed to long-term storage on
  # shutdown. Useful eg. for migration to blocks engine.
  # CLI flag: -ingester.flush-on-shutdown-with-wal-enabled
  [flush_on_shutdown_with_wal_enabled: <boolean> | default = false]

lifecycler:
  ring:
    kvstore:
      # Backend storage to use for the ring. Supported values are: consul, etcd,
      # inmemory, memberlist, multi.
      # CLI flag: -ring.store
      [store: <string> | default = "consul"]

      # The prefix for the keys in the store. Should end with a /.
      # CLI flag: -ring.prefix
      [prefix: <string> | default = "collectors/"]

      # The consul_config configures the consul client.
      [consul: <consul_config>]

      # The etcd_config configures the etcd client.
      [etcd: <etcd_config>]

      multi:
        # Primary backend storage used by multi-client.
        # CLI flag: -multi.primary
        [primary: <string> | default = ""]

        # Secondary backend storage used by multi-client.
        # CLI flag: -multi.secondary
        [secondary: <string> | default = ""]

        # Mirror writes to secondary store.
        # CLI flag: -multi.mirror-enabled
        [mirror_enabled: <boolean> | default = false]

        # Timeout for storing value to secondary store.
        # CLI flag: -multi.mirror-timeout
        [mirror_timeout: <duration> | default = 2s]

    # The heartbeat timeout after which ingesters are skipped for reads/writes.
    # CLI flag: -ring.heartbeat-timeout
    [heartbeat_timeout: <duration> | default = 1m]

    # The number of ingesters to write to and read from.
    # CLI flag: -distributor.replication-factor
    [replication_factor: <int> | default = 3]

    # True to enable the zone-awareness and replicate ingested samples across
    # different availability zones.
    # CLI flag: -distributor.zone-awareness-enabled
    [zone_awareness_enabled: <boolean> | default = false]

  # Number of tokens for each ingester.
  # CLI flag: -ingester.num-tokens
  [num_tokens: <int> | default = 128]

  # Period at which to heartbeat to consul.
  # CLI flag: -ingester.heartbeat-period
  [heartbeat_period: <duration> | default = 5s]

  # Observe tokens after generating to resolve collisions. Useful when using
  # gossiping ring.
  # CLI flag: -ingester.observe-period
  [observe_period: <duration> | default = 0s]

  # Period to wait for a claim from another member; will join automatically
  # after this.
  # CLI flag: -ingester.join-after
  [join_after: <duration> | default = 0s]

  # Minimum duration to wait before becoming ready. This is to work around race
  # conditions with ingesters exiting and updating the ring.
  # CLI flag: -ingester.min-ready-duration
  [min_ready_duration: <duration> | default = 1m]

  # Name of network interface to read address from.
  # CLI flag: -ingester.lifecycler.interface
  [interface_names: <list of string> | default = [eth0 en0]]

  # Duration to sleep for before exiting, to ensure metrics are scraped.
  # CLI flag: -ingester.final-sleep
  [final_sleep: <duration> | default = 30s]

  # File path where tokens are stored. If empty, tokens are not stored at
  # shutdown and restored at startup.
  # CLI flag: -ingester.tokens-file-path
  [tokens_file_path: <string> | default = ""]

  # The availability zone where this instance is running.
  # CLI flag: -ingester.availability-zone
  [availability_zone: <string> | default = ""]

# Number of times to try and transfer chunks before falling back to flushing.
# Negative value or zero disables hand-over. This feature is supported only by
# the chunks storage.
# CLI flag: -ingester.max-transfer-retries
[max_transfer_retries: <int> | default = 10]

# Period with which to attempt to flush chunks.
# CLI flag: -ingester.flush-period
[flush_period: <duration> | default = 1m]

# Period chunks will remain in memory after flushing.
# CLI flag: -ingester.retain-period
[retain_period: <duration> | default = 5m]

# Maximum chunk idle time before flushing.
# CLI flag: -ingester.max-chunk-idle
[max_chunk_idle_time: <duration> | default = 5m]

# Maximum chunk idle time for chunks terminating in stale markers before
# flushing. 0 disables it and a stale series is not flushed until the
# max-chunk-idle timeout is reached.
# CLI flag: -ingester.max-stale-chunk-idle
[max_stale_chunk_idle_time: <duration> | default = 2m]

# Timeout for individual flush operations.
# CLI flag: -ingester.flush-op-timeout
[flush_op_timeout: <duration> | default = 1m]

# Maximum chunk age before flushing.
# CLI flag: -ingester.max-chunk-age
[max_chunk_age: <duration> | default = 12h]

# Range of time to subtract from -ingester.max-chunk-age to spread out flushes
# CLI flag: -ingester.chunk-age-jitter
[chunk_age_jitter: <duration> | default = 0s]

# Number of concurrent goroutines flushing to dynamodb.
# CLI flag: -ingester.concurrent-flushes
[concurrent_flushes: <int> | default = 50]

# If true, spread series flushes across the whole period of
# -ingester.max-chunk-age.
# CLI flag: -ingester.spread-flushes
[spread_flushes: <boolean> | default = true]

# Period at which metadata we have not seen will remain in memory before being
# deleted.
# CLI flag: -ingester.metadata-retain-period
[metadata_retain_period: <duration> | default = 10m]

# Period with which to update the per-user ingestion rates.
# CLI flag: -ingester.rate-update-period
[rate_update_period: <duration> | default = 15s]

# Enable tracking of active series and export them as metrics.
# CLI flag: -ingester.active-series-metrics-enabled
[active_series_metrics_enabled: <boolean> | default = false]

# How often to update active series metrics.
# CLI flag: -ingester.active-series-metrics-update-period
[active_series_metrics_update_period: <duration> | default = 1m]

# After what time a series is considered to be inactive.
# CLI flag: -ingester.active-series-metrics-idle-timeout
[active_series_metrics_idle_timeout: <duration> | default = 10m]
```

### `querier_config`

The `querier_config` configures the Cortex querier.

```yaml
# The maximum number of concurrent queries.
# CLI flag: -querier.max-concurrent
[max_concurrent: <int> | default = 20]

# The timeout for a query.
# CLI flag: -querier.timeout
[timeout: <duration> | default = 2m]

# Use iterators to execute query, as opposed to fully materialising the series
# in memory.
# CLI flag: -querier.iterators
[iterators: <boolean> | default = false]

# Use batch iterators to execute query, as opposed to fully materialising the
# series in memory.  Takes precedent over the -querier.iterators flag.
# CLI flag: -querier.batch-iterators
[batch_iterators: <boolean> | default = true]

# Use streaming RPCs to query ingester.
# CLI flag: -querier.ingester-streaming
[ingester_streaming: <boolean> | default = true]

# Maximum number of samples a single query can load into memory.
# CLI flag: -querier.max-samples
[max_samples: <int> | default = 50000000]

# Maximum lookback beyond which queries are not sent to ingester. 0 means all
# queries are sent to ingester.
# CLI flag: -querier.query-ingesters-within
[query_ingesters_within: <duration> | default = 0s]

# The time after which a metric should only be queried from storage and not just
# ingesters. 0 means all queries are sent to store. When running the blocks
# storage, if this option is enabled, the time range of the query sent to the
# store will be manipulated to ensure the query end is not more recent than 'now
# - query-store-after'.
# CLI flag: -querier.query-store-after
[query_store_after: <duration> | default = 0s]

# Maximum duration into the future you can query. 0 to disable.
# CLI flag: -querier.max-query-into-future
[max_query_into_future: <duration> | default = 10m]

# The default evaluation interval or step size for subqueries.
# CLI flag: -querier.default-evaluation-interval
[default_evaluation_interval: <duration> | default = 1m]

# Active query tracker monitors active queries, and writes them to the file in
# given directory. If Cortex discovers any queries in this log during startup,
# it will log them to the log file. Setting to empty value disables active query
# tracker, which also disables -querier.max-concurrent option.
# CLI flag: -querier.active-query-tracker-dir
[active_query_tracker_dir: <string> | default = "./active-query-tracker"]

# Time since the last sample after which a time series is considered stale and
# ignored by expression evaluations.
# CLI flag: -querier.lookback-delta
[lookback_delta: <duration> | default = 5m]

# Comma separated list of store-gateway addresses in DNS Service Discovery
# format. This option should be set when using the blocks storage and the
# store-gateway sharding is disabled (when enabled, the store-gateway instances
# form a ring and addresses are picked from the ring).
# CLI flag: -querier.store-gateway-addresses
[store_gateway_addresses: <string> | default = ""]

store_gateway_client:
  # Path to the client certificate file, which will be used for authenticating
  # with the server. Also requires the key path to be configured.
  # CLI flag: -querier.store-gateway-client.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # Path to the key file for the client certificate. Also requires the client
  # certificate to be configured.
  # CLI flag: -querier.store-gateway-client.tls-key-path
  [tls_key_path: <string> | default = ""]

  # Path to the CA certificates file to validate server certificate against. If
  # not set, the host's root CA certificates are used.
  # CLI flag: -querier.store-gateway-client.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # Skip validating server certificate.
  # CLI flag: -querier.store-gateway-client.tls-insecure-skip-verify
  [tls_insecure_skip_verify: <boolean> | default = false]

# Second store engine to use for querying. Empty = disabled.
# CLI flag: -querier.second-store-engine
[second_store_engine: <string> | default = ""]

# If specified, second store is only used for queries before this timestamp.
# Default value 0 means secondary store is always queried.
# CLI flag: -querier.use-second-store-before-time
[use_second_store_before_time: <time> | default = 0]

# When distributor's sharding strategy is shuffle-sharding and this setting is >
# 0, queriers fetch in-memory series from the minimum set of required ingesters,
# selecting only ingesters which may have received series since 'now - lookback
# period'. The lookback period should be greater or equal than the configured
# 'query store after'. If this setting is 0, queriers always query all ingesters
# (ingesters shuffle sharding on read path is disabled).
# CLI flag: -querier.shuffle-sharding-ingesters-lookback-period
[shuffle_sharding_ingesters_lookback_period: <duration> | default = 0s]
```

### `query_frontend_config`

The `query_frontend_config` configures the Cortex query-frontend.

```yaml
# Maximum number of outstanding requests per tenant per frontend; requests
# beyond this error with HTTP 429.
# CLI flag: -querier.max-outstanding-requests-per-tenant
[max_outstanding_per_tenant: <int> | default = 100]

# Compress HTTP responses.
# CLI flag: -querier.compress-http-responses
[compress_responses: <boolean> | default = false]

# URL of downstream Prometheus.
# CLI flag: -frontend.downstream-url
[downstream_url: <string> | default = ""]

# Max body size for downstream prometheus.
# CLI flag: -frontend.max-body-size
[max_body_size: <int> | default = 10485760]

# Log queries that are slower than the specified duration. Set to 0 to disable.
# Set to < 0 to enable on all queries.
# CLI flag: -frontend.log-queries-longer-than
[log_queries_longer_than: <duration> | default = 0s]
```

### `query_range_config`

The `query_range_config` configures the query splitting and caching in the Cortex query-frontend.

```yaml
# Split queries by an interval and execute in parallel, 0 disables it. You
# should use an a multiple of 24 hours (same as the storage bucketing scheme),
# to avoid queriers downloading and processing the same chunks. This also
# determines how cache keys are chosen when result caching is enabled
# CLI flag: -querier.split-queries-by-interval
[split_queries_by_interval: <duration> | default = 0s]

# Deprecated: Split queries by day and execute in parallel.
# CLI flag: -querier.split-queries-by-day
[split_queries_by_day: <boolean> | default = false]

# Mutate incoming queries to align their start and end with their step.
# CLI flag: -querier.align-querier-with-step
[align_queries_with_step: <boolean> | default = false]

results_cache:
  cache:
    # Enable in-memory cache.
    # CLI flag: -frontend.cache.enable-fifocache
    [enable_fifocache: <boolean> | default = false]

    # The default validity of entries for caches unless overridden.
    # CLI flag: -frontend.default-validity
    [default_validity: <duration> | default = 0s]

    background:
      # At what concurrency to write back to cache.
      # CLI flag: -frontend.background.write-back-concurrency
      [writeback_goroutines: <int> | default = 10]

      # How many key batches to buffer for background write-back.
      # CLI flag: -frontend.background.write-back-buffer
      [writeback_buffer: <int> | default = 10000]

    # The memcached_config block configures how data is stored in Memcached (ie.
    # expiration).
    # The CLI flags prefix for this block config is: frontend
    [memcached: <memcached_config>]

    # The memcached_client_config configures the client used to connect to
    # Memcached.
    # The CLI flags prefix for this block config is: frontend
    [memcached_client: <memcached_client_config>]

    # The redis_config configures the Redis backend cache.
    # The CLI flags prefix for this block config is: frontend
    [redis: <redis_config>]

    # The fifo_cache_config configures the local in-memory cache.
    # The CLI flags prefix for this block config is: frontend
    [fifocache: <fifo_cache_config>]

  # Use compression in results cache. Supported values are: 'snappy' and ''
  # (disable compression).
  # CLI flag: -frontend.compression
  [compression: <string> | default = ""]

# Cache query results.
# CLI flag: -querier.cache-results
[cache_results: <boolean> | default = false]

# Maximum number of retries for a single request; beyond this, the downstream
# error is returned.
# CLI flag: -querier.max-retries-per-request
[max_retries: <int> | default = 5]

# Perform query parallelisations based on storage sharding configuration and
# query ASTs. This feature is supported only by the chunks storage engine.
# CLI flag: -querier.parallelise-shardable-queries
[parallelise_shardable_queries: <boolean> | default = false]
```

### `ruler_config`

The `ruler_config` configures the Cortex ruler.

```yaml
# URL of alerts return path.
# CLI flag: -ruler.external.url
[external_url: <url> | default = ]

ruler_client:
  # Path to the client certificate file, which will be used for authenticating
  # with the server. Also requires the key path to be configured.
  # CLI flag: -ruler.client.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # Path to the key file for the client certificate. Also requires the client
  # certificate to be configured.
  # CLI flag: -ruler.client.tls-key-path
  [tls_key_path: <string> | default = ""]

  # Path to the CA certificates file to validate server certificate against. If
  # not set, the host's root CA certificates are used.
  # CLI flag: -ruler.client.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # Skip validating server certificate.
  # CLI flag: -ruler.client.tls-insecure-skip-verify
  [tls_insecure_skip_verify: <boolean> | default = false]

# How frequently to evaluate rules
# CLI flag: -ruler.evaluation-interval
[evaluation_interval: <duration> | default = 1m]

# Deprecated. Please use -ruler.evaluation-delay-duration instead.
# CLI flag: -ruler.evaluation-delay-duration-deprecated
[evaluation_delay_duration: <duration> | default = 0s]

# How frequently to poll for rule changes
# CLI flag: -ruler.poll-interval
[poll_interval: <duration> | default = 1m]

storage:
  # Method to use for backend rule storage (configdb, azure, gcs, s3, swift,
  # local)
  # CLI flag: -ruler.storage.type
  [type: <string> | default = "configdb"]

  # The configstore_config configures the config database storing rules and
  # alerts, and is used by the Cortex alertmanager.
  # The CLI flags prefix for this block config is: ruler
  [configdb: <configstore_config>]

  azure:
    # Azure Cloud environment. Supported values are: AzureGlobal,
    # AzureChinaCloud, AzureGermanCloud, AzureUSGovernment.
    # CLI flag: -ruler.storage.azure.environment
    [environment: <string> | default = "AzureGlobal"]

    # Name of the blob container used to store chunks. This container must be
    # created before running cortex.
    # CLI flag: -ruler.storage.azure.container-name
    [container_name: <string> | default = "cortex"]

    # The Microsoft Azure account name to be used
    # CLI flag: -ruler.storage.azure.account-name
    [account_name: <string> | default = ""]

    # The Microsoft Azure account key to use.
    # CLI flag: -ruler.storage.azure.account-key
    [account_key: <string> | default = ""]

    # Preallocated buffer size for downloads.
    # CLI flag: -ruler.storage.azure.download-buffer-size
    [download_buffer_size: <int> | default = 512000]

    # Preallocated buffer size for uploads.
    # CLI flag: -ruler.storage.azure.upload-buffer-size
    [upload_buffer_size: <int> | default = 256000]

    # Number of buffers used to used to upload a chunk.
    # CLI flag: -ruler.storage.azure.download-buffer-count
    [upload_buffer_count: <int> | default = 1]

    # Timeout for requests made against azure blob storage.
    # CLI flag: -ruler.storage.azure.request-timeout
    [request_timeout: <duration> | default = 30s]

    # Number of retries for a request which times out.
    # CLI flag: -ruler.storage.azure.max-retries
    [max_retries: <int> | default = 5]

    # Minimum time to wait before retrying a request.
    # CLI flag: -ruler.storage.azure.min-retry-delay
    [min_retry_delay: <duration> | default = 10ms]

    # Maximum time to wait before retrying a request.
    # CLI flag: -ruler.storage.azure.max-retry-delay
    [max_retry_delay: <duration> | default = 500ms]

  gcs:
    # Name of GCS bucket. Please refer to
    # https://cloud.google.com/docs/authentication/production for more
    # information about how to configure authentication.
    # CLI flag: -ruler.storage.gcs.bucketname
    [bucket_name: <string> | default = ""]

    # The size of the buffer that GCS client for each PUT request. 0 to disable
    # buffering.
    # CLI flag: -ruler.storage.gcs.chunk-buffer-size
    [chunk_buffer_size: <int> | default = 0]

    # The duration after which the requests to GCS should be timed out.
    # CLI flag: -ruler.storage.gcs.request-timeout
    [request_timeout: <duration> | default = 0s]

  s3:
    # S3 endpoint URL with escaped Key and Secret encoded. If only region is
    # specified as a host, proper endpoint will be deduced. Use
    # inmemory:///<bucket-name> to use a mock in-memory implementation.
    # CLI flag: -ruler.storage.s3.url
    [s3: <url> | default = ]

    # Set this to `true` to force the request to use path-style addressing.
    # CLI flag: -ruler.storage.s3.force-path-style
    [s3forcepathstyle: <boolean> | default = false]

    # Comma separated list of bucket names to evenly distribute chunks over.
    # Overrides any buckets specified in s3.url flag
    # CLI flag: -ruler.storage.s3.buckets
    [bucketnames: <string> | default = ""]

    # S3 Endpoint to connect to.
    # CLI flag: -ruler.storage.s3.endpoint
    [endpoint: <string> | default = ""]

    # AWS region to use.
    # CLI flag: -ruler.storage.s3.region
    [region: <string> | default = ""]

    # AWS Access Key ID
    # CLI flag: -ruler.storage.s3.access-key-id
    [access_key_id: <string> | default = ""]

    # AWS Secret Access Key
    # CLI flag: -ruler.storage.s3.secret-access-key
    [secret_access_key: <string> | default = ""]

    # Disable https on s3 connection.
    # CLI flag: -ruler.storage.s3.insecure
    [insecure: <boolean> | default = false]

    # Enable AES256 AWS Server Side Encryption
    # CLI flag: -ruler.storage.s3.sse-encryption
    [sse_encryption: <boolean> | default = false]

    http_config:
      # The maximum amount of time an idle connection will be held open.
      # CLI flag: -ruler.storage.s3.http.idle-conn-timeout
      [idle_conn_timeout: <duration> | default = 1m30s]

      # If non-zero, specifies the amount of time to wait for a server's
      # response headers after fully writing the request.
      # CLI flag: -ruler.storage.s3.http.response-header-timeout
      [response_header_timeout: <duration> | default = 0s]

      # Set to false to skip verifying the certificate chain and hostname.
      # CLI flag: -ruler.storage.s3.http.insecure-skip-verify
      [insecure_skip_verify: <boolean> | default = false]

  swift:
    # Openstack authentication URL.
    # CLI flag: -ruler.storage.swift.auth-url
    [auth_url: <string> | default = ""]

    # Openstack username for the api.
    # CLI flag: -ruler.storage.swift.username
    [username: <string> | default = ""]

    # Openstack user's domain name.
    # CLI flag: -ruler.storage.swift.user-domain-name
    [user_domain_name: <string> | default = ""]

    # Openstack user's domain id.
    # CLI flag: -ruler.storage.swift.user-domain-id
    [user_domain_id: <string> | default = ""]

    # Openstack userid for the api.
    # CLI flag: -ruler.storage.swift.user-id
    [user_id: <string> | default = ""]

    # Openstack api key.
    # CLI flag: -ruler.storage.swift.password
    [password: <string> | default = ""]

    # Openstack user's domain id.
    # CLI flag: -ruler.storage.swift.domain-id
    [domain_id: <string> | default = ""]

    # Openstack user's domain name.
    # CLI flag: -ruler.storage.swift.domain-name
    [domain_name: <string> | default = ""]

    # Openstack project id (v2,v3 auth only).
    # CLI flag: -ruler.storage.swift.project-id
    [project_id: <string> | default = ""]

    # Openstack project name (v2,v3 auth only).
    # CLI flag: -ruler.storage.swift.project-name
    [project_name: <string> | default = ""]

    # Id of the project's domain (v3 auth only), only needed if it differs the
    # from user domain.
    # CLI flag: -ruler.storage.swift.project-domain-id
    [project_domain_id: <string> | default = ""]

    # Name of the project's domain (v3 auth only), only needed if it differs
    # from the user domain.
    # CLI flag: -ruler.storage.swift.project-domain-name
    [project_domain_name: <string> | default = ""]

    # Openstack Region to use eg LON, ORD - default is use first region (v2,v3
    # auth only)
    # CLI flag: -ruler.storage.swift.region-name
    [region_name: <string> | default = ""]

    # Name of the Swift container to put chunks in.
    # CLI flag: -ruler.storage.swift.container-name
    [container_name: <string> | default = "cortex"]

  local:
    # Directory to scan for rules
    # CLI flag: -ruler.storage.local.directory
    [directory: <string> | default = ""]

# file path to store temporary rule files for the prometheus rule managers
# CLI flag: -ruler.rule-path
[rule_path: <string> | default = "/rules"]

# Comma-separated list of URL(s) of the Alertmanager(s) to send notifications
# to. Each Alertmanager URL is treated as a separate group in the configuration.
# Multiple Alertmanagers in HA per group can be supported by using DNS
# resolution via -ruler.alertmanager-discovery.
# CLI flag: -ruler.alertmanager-url
[alertmanager_url: <string> | default = ""]

# Use DNS SRV records to discover Alertmanager hosts.
# CLI flag: -ruler.alertmanager-discovery
[enable_alertmanager_discovery: <boolean> | default = false]

# How long to wait between refreshing DNS resolutions of Alertmanager hosts.
# CLI flag: -ruler.alertmanager-refresh-interval
[alertmanager_refresh_interval: <duration> | default = 1m]

# If enabled requests to Alertmanager will utilize the V2 API.
# CLI flag: -ruler.alertmanager-use-v2
[enable_alertmanager_v2: <boolean> | default = false]

# Capacity of the queue for notifications to be sent to the Alertmanager.
# CLI flag: -ruler.notification-queue-capacity
[notification_queue_capacity: <int> | default = 10000]

# HTTP timeout duration when sending notifications to the Alertmanager.
# CLI flag: -ruler.notification-timeout
[notification_timeout: <duration> | default = 10s]

# Max time to tolerate outage for restoring "for" state of alert.
# CLI flag: -ruler.for-outage-tolerance
[for_outage_tolerance: <duration> | default = 1h]

# Minimum duration between alert and restored "for" state. This is maintained
# only for alerts with configured "for" time greater than grace period.
# CLI flag: -ruler.for-grace-period
[for_grace_period: <duration> | default = 10m]

# Minimum amount of time to wait before resending an alert to Alertmanager.
# CLI flag: -ruler.resend-delay
[resend_delay: <duration> | default = 1m]

# Distribute rule evaluation using ring backend
# CLI flag: -ruler.enable-sharding
[enable_sharding: <boolean> | default = false]

# The sharding strategy to use. Supported values are: default, shuffle-sharding.
# CLI flag: -ruler.sharding-strategy
[sharding_strategy: <string> | default = "default"]

# Time to spend searching for a pending ruler when shutting down.
# CLI flag: -ruler.search-pending-for
[search_pending_for: <duration> | default = 5m]

ring:
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -ruler.ring.store
    [store: <string> | default = "consul"]

    # The prefix for the keys in the store. Should end with a /.
    # CLI flag: -ruler.ring.prefix
    [prefix: <string> | default = "rulers/"]

    # The consul_config configures the consul client.
    # The CLI flags prefix for this block config is: ruler.ring
    [consul: <consul_config>]

    # The etcd_config configures the etcd client.
    # The CLI flags prefix for this block config is: ruler.ring
    [etcd: <etcd_config>]

    multi:
      # Primary backend storage used by multi-client.
      # CLI flag: -ruler.ring.multi.primary
      [primary: <string> | default = ""]

      # Secondary backend storage used by multi-client.
      # CLI flag: -ruler.ring.multi.secondary
      [secondary: <string> | default = ""]

      # Mirror writes to secondary store.
      # CLI flag: -ruler.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # Timeout for storing value to secondary store.
      # CLI flag: -ruler.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # Period at which to heartbeat to the ring.
  # CLI flag: -ruler.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 5s]

  # The heartbeat timeout after which rulers are considered unhealthy within the
  # ring.
  # CLI flag: -ruler.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # Name of network interface to read address from.
  # CLI flag: -ruler.ring.instance-interface-names
  [instance_interface_names: <list of string> | default = [eth0 en0]]

  # Number of tokens for each ingester.
  # CLI flag: -ruler.ring.num-tokens
  [num_tokens: <int> | default = 128]

# Period with which to attempt to flush rule groups.
# CLI flag: -ruler.flush-period
[flush_period: <duration> | default = 1m]

# Enable the ruler api
# CLI flag: -experimental.ruler.enable-api
[enable_api: <boolean> | default = false]
```

### `alertmanager_config`

The `alertmanager_config` configures the Cortex alertmanager.

```yaml
# Base path for data storage.
# CLI flag: -alertmanager.storage.path
[data_dir: <string> | default = "data/"]

# How long to keep data for.
# CLI flag: -alertmanager.storage.retention
[retention: <duration> | default = 120h]

# The URL under which Alertmanager is externally reachable (for example, if
# Alertmanager is served via a reverse proxy). Used for generating relative and
# absolute links back to Alertmanager itself. If the URL has a path portion, it
# will be used to prefix all HTTP endpoints served by Alertmanager. If omitted,
# relevant URL components will be derived automatically.
# CLI flag: -alertmanager.web.external-url
[external_url: <url> | default = ]

# How frequently to poll Cortex configs
# CLI flag: -alertmanager.configs.poll-interval
[poll_interval: <duration> | default = 15s]

# Listen address for cluster.
# CLI flag: -cluster.listen-address
[cluster_bind_address: <string> | default = "0.0.0.0:9094"]

# Explicit address to advertise in cluster.
# CLI flag: -cluster.advertise-address
[cluster_advertise_address: <string> | default = ""]

# Initial peers (may be repeated).
# CLI flag: -cluster.peer
[peers: <list of string> | default = []]

# Time to wait between peers to send notifications.
# CLI flag: -cluster.peer-timeout
[peer_timeout: <duration> | default = 15s]

# Filename of fallback config to use if none specified for instance.
# CLI flag: -alertmanager.configs.fallback
[fallback_config_file: <string> | default = ""]

# Root of URL to generate if config is http://internal.monitor
# CLI flag: -alertmanager.configs.auto-webhook-root
[auto_webhook_root: <string> | default = ""]

storage:
  # Type of backend to use to store alertmanager configs. Supported values are:
  # "configdb", "gcs", "s3", "local".
  # CLI flag: -alertmanager.storage.type
  [type: <string> | default = "configdb"]

  # The configstore_config configures the config database storing rules and
  # alerts, and is used by the Cortex alertmanager.
  # The CLI flags prefix for this block config is: alertmanager
  [configdb: <configstore_config>]

  local:
    # Path at which alertmanager configurations are stored.
    # CLI flag: -alertmanager.storage.local.path
    [path: <string> | default = ""]

  gcs:
    # Name of GCS bucket. Please refer to
    # https://cloud.google.com/docs/authentication/production for more
    # information about how to configure authentication.
    # CLI flag: -alertmanager.storage.gcs.bucketname
    [bucket_name: <string> | default = ""]

    # The size of the buffer that GCS client for each PUT request. 0 to disable
    # buffering.
    # CLI flag: -alertmanager.storage.gcs.chunk-buffer-size
    [chunk_buffer_size: <int> | default = 0]

    # The duration after which the requests to GCS should be timed out.
    # CLI flag: -alertmanager.storage.gcs.request-timeout
    [request_timeout: <duration> | default = 0s]

  s3:
    # S3 endpoint URL with escaped Key and Secret encoded. If only region is
    # specified as a host, proper endpoint will be deduced. Use
    # inmemory:///<bucket-name> to use a mock in-memory implementation.
    # CLI flag: -alertmanager.storage.s3.url
    [s3: <url> | default = ]

    # Set this to `true` to force the request to use path-style addressing.
    # CLI flag: -alertmanager.storage.s3.force-path-style
    [s3forcepathstyle: <boolean> | default = false]

    # Comma separated list of bucket names to evenly distribute chunks over.
    # Overrides any buckets specified in s3.url flag
    # CLI flag: -alertmanager.storage.s3.buckets
    [bucketnames: <string> | default = ""]

    # S3 Endpoint to connect to.
    # CLI flag: -alertmanager.storage.s3.endpoint
    [endpoint: <string> | default = ""]

    # AWS region to use.
    # CLI flag: -alertmanager.storage.s3.region
    [region: <string> | default = ""]

    # AWS Access Key ID
    # CLI flag: -alertmanager.storage.s3.access-key-id
    [access_key_id: <string> | default = ""]

    # AWS Secret Access Key
    # CLI flag: -alertmanager.storage.s3.secret-access-key
    [secret_access_key: <string> | default = ""]

    # Disable https on s3 connection.
    # CLI flag: -alertmanager.storage.s3.insecure
    [insecure: <boolean> | default = false]

    # Enable AES256 AWS Server Side Encryption
    # CLI flag: -alertmanager.storage.s3.sse-encryption
    [sse_encryption: <boolean> | default = false]

    http_config:
      # The maximum amount of time an idle connection will be held open.
      # CLI flag: -alertmanager.storage.s3.http.idle-conn-timeout
      [idle_conn_timeout: <duration> | default = 1m30s]

      # If non-zero, specifies the amount of time to wait for a server's
      # response headers after fully writing the request.
      # CLI flag: -alertmanager.storage.s3.http.response-header-timeout
      [response_header_timeout: <duration> | default = 0s]

      # Set to false to skip verifying the certificate chain and hostname.
      # CLI flag: -alertmanager.storage.s3.http.insecure-skip-verify
      [insecure_skip_verify: <boolean> | default = false]

# Enable the experimental alertmanager config api.
# CLI flag: -experimental.alertmanager.enable-api
[enable_api: <boolean> | default = false]
```

### `table_manager_config`

The `table_manager_config` configures the Cortex table-manager.

```yaml
# If true, disable all changes to DB capacity
# CLI flag: -table-manager.throughput-updates-disabled
[throughput_updates_disabled: <boolean> | default = false]

# If true, enables retention deletes of DB tables
# CLI flag: -table-manager.retention-deletes-enabled
[retention_deletes_enabled: <boolean> | default = false]

# Tables older than this retention period are deleted. Note: This setting is
# destructive to data!(default: 0, which disables deletion)
# CLI flag: -table-manager.retention-period
[retention_period: <duration> | default = 0s]

# How frequently to poll backend to learn our capacity.
# CLI flag: -table-manager.poll-interval
[poll_interval: <duration> | default = 2m]

# Periodic tables grace period (duration which table will be created/deleted
# before/after it's needed).
# CLI flag: -table-manager.periodic-table.grace-period
[creation_grace_period: <duration> | default = 10m]

index_tables_provisioning:
  # Enables on demand throughput provisioning for the storage provider (if
  # supported). Applies only to tables which are not autoscaled. Supported by
  # DynamoDB
  # CLI flag: -table-manager.index-table.enable-ondemand-throughput-mode
  [enable_ondemand_throughput_mode: <boolean> | default = false]

  # Table default write throughput. Supported by DynamoDB
  # CLI flag: -table-manager.index-table.write-throughput
  [provisioned_write_throughput: <int> | default = 1000]

  # Table default read throughput. Supported by DynamoDB
  # CLI flag: -table-manager.index-table.read-throughput
  [provisioned_read_throughput: <int> | default = 300]

  write_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.index-table.write-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.index-table.write-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.index-table.write-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.index-table.write-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.index-table.write-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.index-table.write-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.index-table.write-throughput.scale.target-value
    [target: <float> | default = 80]

  read_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.index-table.read-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.index-table.read-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.index-table.read-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.index-table.read-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.index-table.read-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.index-table.read-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.index-table.read-throughput.scale.target-value
    [target: <float> | default = 80]

  # Enables on demand throughput provisioning for the storage provider (if
  # supported). Applies only to tables which are not autoscaled. Supported by
  # DynamoDB
  # CLI flag: -table-manager.index-table.inactive-enable-ondemand-throughput-mode
  [enable_inactive_throughput_on_demand_mode: <boolean> | default = false]

  # Table write throughput for inactive tables. Supported by DynamoDB
  # CLI flag: -table-manager.index-table.inactive-write-throughput
  [inactive_write_throughput: <int> | default = 1]

  # Table read throughput for inactive tables. Supported by DynamoDB
  # CLI flag: -table-manager.index-table.inactive-read-throughput
  [inactive_read_throughput: <int> | default = 300]

  inactive_write_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.index-table.inactive-write-throughput.scale.target-value
    [target: <float> | default = 80]

  inactive_read_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.index-table.inactive-read-throughput.scale.target-value
    [target: <float> | default = 80]

  # Number of last inactive tables to enable write autoscale.
  # CLI flag: -table-manager.index-table.inactive-write-throughput.scale-last-n
  [inactive_write_scale_lastn: <int> | default = 4]

  # Number of last inactive tables to enable read autoscale.
  # CLI flag: -table-manager.index-table.inactive-read-throughput.scale-last-n
  [inactive_read_scale_lastn: <int> | default = 4]

chunk_tables_provisioning:
  # Enables on demand throughput provisioning for the storage provider (if
  # supported). Applies only to tables which are not autoscaled. Supported by
  # DynamoDB
  # CLI flag: -table-manager.chunk-table.enable-ondemand-throughput-mode
  [enable_ondemand_throughput_mode: <boolean> | default = false]

  # Table default write throughput. Supported by DynamoDB
  # CLI flag: -table-manager.chunk-table.write-throughput
  [provisioned_write_throughput: <int> | default = 1000]

  # Table default read throughput. Supported by DynamoDB
  # CLI flag: -table-manager.chunk-table.read-throughput
  [provisioned_read_throughput: <int> | default = 300]

  write_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.chunk-table.write-throughput.scale.target-value
    [target: <float> | default = 80]

  read_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.chunk-table.read-throughput.scale.target-value
    [target: <float> | default = 80]

  # Enables on demand throughput provisioning for the storage provider (if
  # supported). Applies only to tables which are not autoscaled. Supported by
  # DynamoDB
  # CLI flag: -table-manager.chunk-table.inactive-enable-ondemand-throughput-mode
  [enable_inactive_throughput_on_demand_mode: <boolean> | default = false]

  # Table write throughput for inactive tables. Supported by DynamoDB
  # CLI flag: -table-manager.chunk-table.inactive-write-throughput
  [inactive_write_throughput: <int> | default = 1]

  # Table read throughput for inactive tables. Supported by DynamoDB
  # CLI flag: -table-manager.chunk-table.inactive-read-throughput
  [inactive_read_throughput: <int> | default = 300]

  inactive_write_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale.target-value
    [target: <float> | default = 80]

  inactive_read_scale:
    # Should we enable autoscale for the table.
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.enabled
    [enabled: <boolean> | default = false]

    # AWS AutoScaling role ARN
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.role-arn
    [role_arn: <string> | default = ""]

    # DynamoDB minimum provision capacity.
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.min-capacity
    [min_capacity: <int> | default = 3000]

    # DynamoDB maximum provision capacity.
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.max-capacity
    [max_capacity: <int> | default = 6000]

    # DynamoDB minimum seconds between each autoscale up.
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.out-cooldown
    [out_cooldown: <int> | default = 1800]

    # DynamoDB minimum seconds between each autoscale down.
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.in-cooldown
    [in_cooldown: <int> | default = 1800]

    # DynamoDB target ratio of consumed capacity to provisioned capacity.
    # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale.target-value
    [target: <float> | default = 80]

  # Number of last inactive tables to enable write autoscale.
  # CLI flag: -table-manager.chunk-table.inactive-write-throughput.scale-last-n
  [inactive_write_scale_lastn: <int> | default = 4]

  # Number of last inactive tables to enable read autoscale.
  # CLI flag: -table-manager.chunk-table.inactive-read-throughput.scale-last-n
  [inactive_read_scale_lastn: <int> | default = 4]
```

### `storage_config`

The `storage_config` configures where Cortex stores the data (chunks storage engine).

```yaml
# The storage engine to use: chunks or blocks.
# CLI flag: -store.engine
[engine: <string> | default = "chunks"]

aws:
  dynamodb:
    # DynamoDB endpoint URL with escaped Key and Secret encoded. If only region
    # is specified as a host, proper endpoint will be deduced. Use
    # inmemory:///<table-name> to use a mock in-memory implementation.
    # CLI flag: -dynamodb.url
    [dynamodb_url: <url> | default = ]

    # DynamoDB table management requests per second limit.
    # CLI flag: -dynamodb.api-limit
    [api_limit: <float> | default = 2]

    # DynamoDB rate cap to back off when throttled.
    # CLI flag: -dynamodb.throttle-limit
    [throttle_limit: <float> | default = 10]

    metrics:
      # Use metrics-based autoscaling, via this query URL
      # CLI flag: -metrics.url
      [url: <string> | default = ""]

      # Queue length above which we will scale up capacity
      # CLI flag: -metrics.target-queue-length
      [target_queue_length: <int> | default = 100000]

      # Scale up capacity by this multiple
      # CLI flag: -metrics.scale-up-factor
      [scale_up_factor: <float> | default = 1.3]

      # Ignore throttling below this level (rate per second)
      # CLI flag: -metrics.ignore-throttle-below
      [ignore_throttle_below: <float> | default = 1]

      # query to fetch ingester queue length
      # CLI flag: -metrics.queue-length-query
      [queue_length_query: <string> | default = "sum(avg_over_time(cortex_ingester_flush_queue_length{job=\"cortex/ingester\"}[2m]))"]

      # query to fetch throttle rates per table
      # CLI flag: -metrics.write-throttle-query
      [write_throttle_query: <string> | default = "sum(rate(cortex_dynamo_throttled_total{operation=\"DynamoDB.BatchWriteItem\"}[1m])) by (table) > 0"]

      # query to fetch write capacity usage per table
      # CLI flag: -metrics.usage-query
      [write_usage_query: <string> | default = "sum(rate(cortex_dynamo_consumed_capacity_total{operation=\"DynamoDB.BatchWriteItem\"}[15m])) by (table) > 0"]

      # query to fetch read capacity usage per table
      # CLI flag: -metrics.read-usage-query
      [read_usage_query: <string> | default = "sum(rate(cortex_dynamo_consumed_capacity_total{operation=\"DynamoDB.QueryPages\"}[1h])) by (table) > 0"]

      # query to fetch read errors per table
      # CLI flag: -metrics.read-error-query
      [read_error_query: <string> | default = "sum(increase(cortex_dynamo_failures_total{operation=\"DynamoDB.QueryPages\",error=\"ProvisionedThroughputExceededException\"}[1m])) by (table) > 0"]

    # Number of chunks to group together to parallelise fetches (zero to
    # disable)
    # CLI flag: -dynamodb.chunk-gang-size
    [chunk_gang_size: <int> | default = 10]

    # Max number of chunk-get operations to start in parallel
    # CLI flag: -dynamodb.chunk.get-max-parallelism
    [chunk_get_max_parallelism: <int> | default = 32]

    backoff_config:
      # Minimum backoff time
      # CLI flag: -dynamodb.min-backoff
      [min_period: <duration> | default = 100ms]

      # Maximum backoff time
      # CLI flag: -dynamodb.max-backoff
      [max_period: <duration> | default = 50s]

      # Maximum number of times to retry an operation
      # CLI flag: -dynamodb.max-retries
      [max_retries: <int> | default = 20]

  # S3 endpoint URL with escaped Key and Secret encoded. If only region is
  # specified as a host, proper endpoint will be deduced. Use
  # inmemory:///<bucket-name> to use a mock in-memory implementation.
  # CLI flag: -s3.url
  [s3: <url> | default = ]

  # Set this to `true` to force the request to use path-style addressing.
  # CLI flag: -s3.force-path-style
  [s3forcepathstyle: <boolean> | default = false]

  # Comma separated list of bucket names to evenly distribute chunks over.
  # Overrides any buckets specified in s3.url flag
  # CLI flag: -s3.buckets
  [bucketnames: <string> | default = ""]

  # S3 Endpoint to connect to.
  # CLI flag: -s3.endpoint
  [endpoint: <string> | default = ""]

  # AWS region to use.
  # CLI flag: -s3.region
  [region: <string> | default = ""]

  # AWS Access Key ID
  # CLI flag: -s3.access-key-id
  [access_key_id: <string> | default = ""]

  # AWS Secret Access Key
  # CLI flag: -s3.secret-access-key
  [secret_access_key: <string> | default = ""]

  # Disable https on s3 connection.
  # CLI flag: -s3.insecure
  [insecure: <boolean> | default = false]

  # Enable AES256 AWS Server Side Encryption
  # CLI flag: -s3.sse-encryption
  [sse_encryption: <boolean> | default = false]

  http_config:
    # The maximum amount of time an idle connection will be held open.
    # CLI flag: -s3.http.idle-conn-timeout
    [idle_conn_timeout: <duration> | default = 1m30s]

    # If non-zero, specifies the amount of time to wait for a server's response
    # headers after fully writing the request.
    # CLI flag: -s3.http.response-header-timeout
    [response_header_timeout: <duration> | default = 0s]

    # Set to false to skip verifying the certificate chain and hostname.
    # CLI flag: -s3.http.insecure-skip-verify
    [insecure_skip_verify: <boolean> | default = false]

azure:
  # Azure Cloud environment. Supported values are: AzureGlobal, AzureChinaCloud,
  # AzureGermanCloud, AzureUSGovernment.
  # CLI flag: -azure.environment
  [environment: <string> | default = "AzureGlobal"]

  # Name of the blob container used to store chunks. This container must be
  # created before running cortex.
  # CLI flag: -azure.container-name
  [container_name: <string> | default = "cortex"]

  # The Microsoft Azure account name to be used
  # CLI flag: -azure.account-name
  [account_name: <string> | default = ""]

  # The Microsoft Azure account key to use.
  # CLI flag: -azure.account-key
  [account_key: <string> | default = ""]

  # Preallocated buffer size for downloads.
  # CLI flag: -azure.download-buffer-size
  [download_buffer_size: <int> | default = 512000]

  # Preallocated buffer size for uploads.
  # CLI flag: -azure.upload-buffer-size
  [upload_buffer_size: <int> | default = 256000]

  # Number of buffers used to used to upload a chunk.
  # CLI flag: -azure.download-buffer-count
  [upload_buffer_count: <int> | default = 1]

  # Timeout for requests made against azure blob storage.
  # CLI flag: -azure.request-timeout
  [request_timeout: <duration> | default = 30s]

  # Number of retries for a request which times out.
  # CLI flag: -azure.max-retries
  [max_retries: <int> | default = 5]

  # Minimum time to wait before retrying a request.
  # CLI flag: -azure.min-retry-delay
  [min_retry_delay: <duration> | default = 10ms]

  # Maximum time to wait before retrying a request.
  # CLI flag: -azure.max-retry-delay
  [max_retry_delay: <duration> | default = 500ms]

bigtable:
  # Bigtable project ID.
  # CLI flag: -bigtable.project
  [project: <string> | default = ""]

  # Bigtable instance ID. Please refer to
  # https://cloud.google.com/docs/authentication/production for more information
  # about how to configure authentication.
  # CLI flag: -bigtable.instance
  [instance: <string> | default = ""]

  grpc_client_config:
    # gRPC client max receive message size (bytes).
    # CLI flag: -bigtable.grpc-max-recv-msg-size
    [max_recv_msg_size: <int> | default = 104857600]

    # gRPC client max send message size (bytes).
    # CLI flag: -bigtable.grpc-max-send-msg-size
    [max_send_msg_size: <int> | default = 16777216]

    # Deprecated: Use gzip compression when sending messages.  If true,
    # overrides grpc-compression flag.
    # CLI flag: -bigtable.grpc-use-gzip-compression
    [use_gzip_compression: <boolean> | default = false]

    # Use compression when sending messages. Supported values are: 'gzip',
    # 'snappy' and '' (disable compression)
    # CLI flag: -bigtable.grpc-compression
    [grpc_compression: <string> | default = ""]

    # Rate limit for gRPC client; 0 means disabled.
    # CLI flag: -bigtable.grpc-client-rate-limit
    [rate_limit: <float> | default = 0]

    # Rate limit burst for gRPC client.
    # CLI flag: -bigtable.grpc-client-rate-limit-burst
    [rate_limit_burst: <int> | default = 0]

    # Enable backoff and retry when we hit ratelimits.
    # CLI flag: -bigtable.backoff-on-ratelimits
    [backoff_on_ratelimits: <boolean> | default = false]

    backoff_config:
      # Minimum delay when backing off.
      # CLI flag: -bigtable.backoff-min-period
      [min_period: <duration> | default = 100ms]

      # Maximum delay when backing off.
      # CLI flag: -bigtable.backoff-max-period
      [max_period: <duration> | default = 10s]

      # Number of times to backoff and retry before failing.
      # CLI flag: -bigtable.backoff-retries
      [max_retries: <int> | default = 10]

  # If enabled, once a tables info is fetched, it is cached.
  # CLI flag: -bigtable.table-cache.enabled
  [table_cache_enabled: <boolean> | default = true]

  # Duration to cache tables before checking again.
  # CLI flag: -bigtable.table-cache.expiration
  [table_cache_expiration: <duration> | default = 30m]

gcs:
  # Name of GCS bucket. Please refer to
  # https://cloud.google.com/docs/authentication/production for more information
  # about how to configure authentication.
  # CLI flag: -gcs.bucketname
  [bucket_name: <string> | default = ""]

  # The size of the buffer that GCS client for each PUT request. 0 to disable
  # buffering.
  # CLI flag: -gcs.chunk-buffer-size
  [chunk_buffer_size: <int> | default = 0]

  # The duration after which the requests to GCS should be timed out.
  # CLI flag: -gcs.request-timeout
  [request_timeout: <duration> | default = 0s]

cassandra:
  # Comma-separated hostnames or IPs of Cassandra instances.
  # CLI flag: -cassandra.addresses
  [addresses: <string> | default = ""]

  # Port that Cassandra is running on
  # CLI flag: -cassandra.port
  [port: <int> | default = 9042]

  # Keyspace to use in Cassandra.
  # CLI flag: -cassandra.keyspace
  [keyspace: <string> | default = ""]

  # Consistency level for Cassandra.
  # CLI flag: -cassandra.consistency
  [consistency: <string> | default = "QUORUM"]

  # Replication factor to use in Cassandra.
  # CLI flag: -cassandra.replication-factor
  [replication_factor: <int> | default = 3]

  # Instruct the cassandra driver to not attempt to get host info from the
  # system.peers table.
  # CLI flag: -cassandra.disable-initial-host-lookup
  [disable_initial_host_lookup: <boolean> | default = false]

  # Use SSL when connecting to cassandra instances.
  # CLI flag: -cassandra.ssl
  [SSL: <boolean> | default = false]

  # Require SSL certificate validation.
  # CLI flag: -cassandra.host-verification
  [host_verification: <boolean> | default = true]

  # Path to certificate file to verify the peer.
  # CLI flag: -cassandra.ca-path
  [CA_path: <string> | default = ""]

  # Path to certificate file used by TLS.
  # CLI flag: -cassandra.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # Path to private key file used by TLS.
  # CLI flag: -cassandra.tls-key-path
  [tls_key_path: <string> | default = ""]

  # Enable password authentication when connecting to cassandra.
  # CLI flag: -cassandra.auth
  [auth: <boolean> | default = false]

  # Username to use when connecting to cassandra.
  # CLI flag: -cassandra.username
  [username: <string> | default = ""]

  # Password to use when connecting to cassandra.
  # CLI flag: -cassandra.password
  [password: <string> | default = ""]

  # File containing password to use when connecting to cassandra.
  # CLI flag: -cassandra.password-file
  [password_file: <string> | default = ""]

  # If set, when authenticating with cassandra a custom authenticator will be
  # expected during the handshake. This flag can be set multiple times.
  # CLI flag: -cassandra.custom-authenticator
  [custom_authenticators: <list of string> | default = []]

  # Timeout when connecting to cassandra.
  # CLI flag: -cassandra.timeout
  [timeout: <duration> | default = 2s]

  # Initial connection timeout, used during initial dial to server.
  # CLI flag: -cassandra.connect-timeout
  [connect_timeout: <duration> | default = 5s]

  # Interval to retry connecting to cassandra nodes marked as DOWN.
  # CLI flag: -cassandra.reconnent-interval
  [reconnect_interval: <duration> | default = 1s]

  # Number of retries to perform on a request. Set to 0 to disable retries.
  # CLI flag: -cassandra.max-retries
  [max_retries: <int> | default = 0]

  # Maximum time to wait before retrying a failed request.
  # CLI flag: -cassandra.retry-max-backoff
  [retry_max_backoff: <duration> | default = 10s]

  # Minimum time to wait before retrying a failed request.
  # CLI flag: -cassandra.retry-min-backoff
  [retry_min_backoff: <duration> | default = 100ms]

  # Limit number of concurrent queries to Cassandra. Set to 0 to disable the
  # limit.
  # CLI flag: -cassandra.query-concurrency
  [query_concurrency: <int> | default = 0]

  # Number of TCP connections per host.
  # CLI flag: -cassandra.num-connections
  [num_connections: <int> | default = 2]

  # Convict hosts of being down on failure.
  # CLI flag: -cassandra.convict-hosts-on-failure
  [convict_hosts_on_failure: <boolean> | default = true]

  # Table options used to create index or chunk tables. This value is used as
  # plain text in the table `WITH` like this, "CREATE TABLE
  # <generated_by_cortex> (...) WITH <cassandra.table-options>". For details,
  # see https://cortexmetrics.io/docs/production/cassandra. By default it will
  # use the default table options of your Cassandra cluster.
  # CLI flag: -cassandra.table-options
  [table_options: <string> | default = ""]

boltdb:
  # Location of BoltDB index files.
  # CLI flag: -boltdb.dir
  [directory: <string> | default = ""]

filesystem:
  # Directory to store chunks in.
  # CLI flag: -local.chunk-directory
  [directory: <string> | default = ""]

swift:
  # Openstack authentication URL.
  # CLI flag: -swift.auth-url
  [auth_url: <string> | default = ""]

  # Openstack username for the api.
  # CLI flag: -swift.username
  [username: <string> | default = ""]

  # Openstack user's domain name.
  # CLI flag: -swift.user-domain-name
  [user_domain_name: <string> | default = ""]

  # Openstack user's domain id.
  # CLI flag: -swift.user-domain-id
  [user_domain_id: <string> | default = ""]

  # Openstack userid for the api.
  # CLI flag: -swift.user-id
  [user_id: <string> | default = ""]

  # Openstack api key.
  # CLI flag: -swift.password
  [password: <string> | default = ""]

  # Openstack user's domain id.
  # CLI flag: -swift.domain-id
  [domain_id: <string> | default = ""]

  # Openstack user's domain name.
  # CLI flag: -swift.domain-name
  [domain_name: <string> | default = ""]

  # Openstack project id (v2,v3 auth only).
  # CLI flag: -swift.project-id
  [project_id: <string> | default = ""]

  # Openstack project name (v2,v3 auth only).
  # CLI flag: -swift.project-name
  [project_name: <string> | default = ""]

  # Id of the project's domain (v3 auth only), only needed if it differs the
  # from user domain.
  # CLI flag: -swift.project-domain-id
  [project_domain_id: <string> | default = ""]

  # Name of the project's domain (v3 auth only), only needed if it differs from
  # the user domain.
  # CLI flag: -swift.project-domain-name
  [project_domain_name: <string> | default = ""]

  # Openstack Region to use eg LON, ORD - default is use first region (v2,v3
  # auth only)
  # CLI flag: -swift.region-name
  [region_name: <string> | default = ""]

  # Name of the Swift container to put chunks in.
  # CLI flag: -swift.container-name
  [container_name: <string> | default = "cortex"]

# Cache validity for active index entries. Should be no higher than
# -ingester.max-chunk-idle.
# CLI flag: -store.index-cache-validity
[index_cache_validity: <duration> | default = 5m]

index_queries_cache_config:
  # Cache config for index entry reading. Enable in-memory cache.
  # CLI flag: -store.index-cache-read.cache.enable-fifocache
  [enable_fifocache: <boolean> | default = false]

  # Cache config for index entry reading. The default validity of entries for
  # caches unless overridden.
  # CLI flag: -store.index-cache-read.default-validity
  [default_validity: <duration> | default = 0s]

  background:
    # Cache config for index entry reading. At what concurrency to write back to
    # cache.
    # CLI flag: -store.index-cache-read.background.write-back-concurrency
    [writeback_goroutines: <int> | default = 10]

    # Cache config for index entry reading. How many key batches to buffer for
    # background write-back.
    # CLI flag: -store.index-cache-read.background.write-back-buffer
    [writeback_buffer: <int> | default = 10000]

  # The memcached_config block configures how data is stored in Memcached (ie.
  # expiration).
  # The CLI flags prefix for this block config is: store.index-cache-read
  [memcached: <memcached_config>]

  # The memcached_client_config configures the client used to connect to
  # Memcached.
  # The CLI flags prefix for this block config is: store.index-cache-read
  [memcached_client: <memcached_client_config>]

  # The redis_config configures the Redis backend cache.
  # The CLI flags prefix for this block config is: store.index-cache-read
  [redis: <redis_config>]

  # The fifo_cache_config configures the local in-memory cache.
  # The CLI flags prefix for this block config is: store.index-cache-read
  [fifocache: <fifo_cache_config>]

delete_store:
  # Store for keeping delete request
  # CLI flag: -deletes.store
  [store: <string> | default = ""]

  # Name of the table which stores delete requests
  # CLI flag: -deletes.requests-table-name
  [requests_table_name: <string> | default = "delete_requests"]

  table_provisioning:
    # Enables on demand throughput provisioning for the storage provider (if
    # supported). Applies only to tables which are not autoscaled. Supported by
    # DynamoDB
    # CLI flag: -deletes.table.enable-ondemand-throughput-mode
    [enable_ondemand_throughput_mode: <boolean> | default = false]

    # Table default write throughput. Supported by DynamoDB
    # CLI flag: -deletes.table.write-throughput
    [provisioned_write_throughput: <int> | default = 1]

    # Table default read throughput. Supported by DynamoDB
    # CLI flag: -deletes.table.read-throughput
    [provisioned_read_throughput: <int> | default = 300]

    write_scale:
      # Should we enable autoscale for the table.
      # CLI flag: -deletes.table.write-throughput.scale.enabled
      [enabled: <boolean> | default = false]

      # AWS AutoScaling role ARN
      # CLI flag: -deletes.table.write-throughput.scale.role-arn
      [role_arn: <string> | default = ""]

      # DynamoDB minimum provision capacity.
      # CLI flag: -deletes.table.write-throughput.scale.min-capacity
      [min_capacity: <int> | default = 3000]

      # DynamoDB maximum provision capacity.
      # CLI flag: -deletes.table.write-throughput.scale.max-capacity
      [max_capacity: <int> | default = 6000]

      # DynamoDB minimum seconds between each autoscale up.
      # CLI flag: -deletes.table.write-throughput.scale.out-cooldown
      [out_cooldown: <int> | default = 1800]

      # DynamoDB minimum seconds between each autoscale down.
      # CLI flag: -deletes.table.write-throughput.scale.in-cooldown
      [in_cooldown: <int> | default = 1800]

      # DynamoDB target ratio of consumed capacity to provisioned capacity.
      # CLI flag: -deletes.table.write-throughput.scale.target-value
      [target: <float> | default = 80]

    read_scale:
      # Should we enable autoscale for the table.
      # CLI flag: -deletes.table.read-throughput.scale.enabled
      [enabled: <boolean> | default = false]

      # AWS AutoScaling role ARN
      # CLI flag: -deletes.table.read-throughput.scale.role-arn
      [role_arn: <string> | default = ""]

      # DynamoDB minimum provision capacity.
      # CLI flag: -deletes.table.read-throughput.scale.min-capacity
      [min_capacity: <int> | default = 3000]

      # DynamoDB maximum provision capacity.
      # CLI flag: -deletes.table.read-throughput.scale.max-capacity
      [max_capacity: <int> | default = 6000]

      # DynamoDB minimum seconds between each autoscale up.
      # CLI flag: -deletes.table.read-throughput.scale.out-cooldown
      [out_cooldown: <int> | default = 1800]

      # DynamoDB minimum seconds between each autoscale down.
      # CLI flag: -deletes.table.read-throughput.scale.in-cooldown
      [in_cooldown: <int> | default = 1800]

      # DynamoDB target ratio of consumed capacity to provisioned capacity.
      # CLI flag: -deletes.table.read-throughput.scale.target-value
      [target: <float> | default = 80]

    # Tag (of the form key=value) to be added to the tables. Supported by
    # DynamoDB
    # CLI flag: -deletes.table.tags
    [tags: <map of string to string> | default = ]

grpc_store:
  # Hostname or IP of the gRPC store instance.
  # CLI flag: -grpc-store.server-address
  [server_address: <string> | default = ""]
```

### `flusher_config`

The `flusher_config` configures the WAL flusher target, used to manually run one-time flushes when scaling down ingesters.

```yaml
# Directory to read WAL from (chunks storage engine only).
# CLI flag: -flusher.wal-dir
[wal_dir: <string> | default = "wal"]

# Number of concurrent goroutines flushing to storage (chunks storage engine
# only).
# CLI flag: -flusher.concurrent-flushes
[concurrent_flushes: <int> | default = 50]

# Timeout for individual flush operations (chunks storage engine only).
# CLI flag: -flusher.flush-op-timeout
[flush_op_timeout: <duration> | default = 2m]

# Stop Cortex after flush has finished. If false, Cortex process will keep
# running, doing nothing.
# CLI flag: -flusher.exit-after-flush
[exit_after_flush: <boolean> | default = true]
```

### `chunk_store_config`

The `chunk_store_config` configures how Cortex stores the data (chunks storage engine).

```yaml
chunk_cache_config:
  # Cache config for chunks. Enable in-memory cache.
  # CLI flag: -store.chunks-cache.cache.enable-fifocache
  [enable_fifocache: <boolean> | default = false]

  # Cache config for chunks. The default validity of entries for caches unless
  # overridden.
  # CLI flag: -store.chunks-cache.default-validity
  [default_validity: <duration> | default = 0s]

  background:
    # Cache config for chunks. At what concurrency to write back to cache.
    # CLI flag: -store.chunks-cache.background.write-back-concurrency
    [writeback_goroutines: <int> | default = 10]

    # Cache config for chunks. How many key batches to buffer for background
    # write-back.
    # CLI flag: -store.chunks-cache.background.write-back-buffer
    [writeback_buffer: <int> | default = 10000]

  # The memcached_config block configures how data is stored in Memcached (ie.
  # expiration).
  # The CLI flags prefix for this block config is: store.chunks-cache
  [memcached: <memcached_config>]

  # The memcached_client_config configures the client used to connect to
  # Memcached.
  # The CLI flags prefix for this block config is: store.chunks-cache
  [memcached_client: <memcached_client_config>]

  # The redis_config configures the Redis backend cache.
  # The CLI flags prefix for this block config is: store.chunks-cache
  [redis: <redis_config>]

  # The fifo_cache_config configures the local in-memory cache.
  # The CLI flags prefix for this block config is: store.chunks-cache
  [fifocache: <fifo_cache_config>]

write_dedupe_cache_config:
  # Cache config for index entry writing. Enable in-memory cache.
  # CLI flag: -store.index-cache-write.cache.enable-fifocache
  [enable_fifocache: <boolean> | default = false]

  # Cache config for index entry writing. The default validity of entries for
  # caches unless overridden.
  # CLI flag: -store.index-cache-write.default-validity
  [default_validity: <duration> | default = 0s]

  background:
    # Cache config for index entry writing. At what concurrency to write back to
    # cache.
    # CLI flag: -store.index-cache-write.background.write-back-concurrency
    [writeback_goroutines: <int> | default = 10]

    # Cache config for index entry writing. How many key batches to buffer for
    # background write-back.
    # CLI flag: -store.index-cache-write.background.write-back-buffer
    [writeback_buffer: <int> | default = 10000]

  # The memcached_config block configures how data is stored in Memcached (ie.
  # expiration).
  # The CLI flags prefix for this block config is: store.index-cache-write
  [memcached: <memcached_config>]

  # The memcached_client_config configures the client used to connect to
  # Memcached.
  # The CLI flags prefix for this block config is: store.index-cache-write
  [memcached_client: <memcached_client_config>]

  # The redis_config configures the Redis backend cache.
  # The CLI flags prefix for this block config is: store.index-cache-write
  [redis: <redis_config>]

  # The fifo_cache_config configures the local in-memory cache.
  # The CLI flags prefix for this block config is: store.index-cache-write
  [fifocache: <fifo_cache_config>]

# Cache index entries older than this period. 0 to disable.
# CLI flag: -store.cache-lookups-older-than
[cache_lookups_older_than: <duration> | default = 0s]

# Limit how long back data can be queried
# CLI flag: -store.max-look-back-period
[max_look_back_period: <duration> | default = 0s]
```

### `ingester_client_config`

The `ingester_client_config` configures how the Cortex distributors connect to the ingesters.

```yaml
grpc_client_config:
  # gRPC client max receive message size (bytes).
  # CLI flag: -ingester.client.grpc-max-recv-msg-size
  [max_recv_msg_size: <int> | default = 104857600]

  # gRPC client max send message size (bytes).
  # CLI flag: -ingester.client.grpc-max-send-msg-size
  [max_send_msg_size: <int> | default = 16777216]

  # Deprecated: Use gzip compression when sending messages.  If true, overrides
  # grpc-compression flag.
  # CLI flag: -ingester.client.grpc-use-gzip-compression
  [use_gzip_compression: <boolean> | default = false]

  # Use compression when sending messages. Supported values are: 'gzip',
  # 'snappy' and '' (disable compression)
  # CLI flag: -ingester.client.grpc-compression
  [grpc_compression: <string> | default = ""]

  # Rate limit for gRPC client; 0 means disabled.
  # CLI flag: -ingester.client.grpc-client-rate-limit
  [rate_limit: <float> | default = 0]

  # Rate limit burst for gRPC client.
  # CLI flag: -ingester.client.grpc-client-rate-limit-burst
  [rate_limit_burst: <int> | default = 0]

  # Enable backoff and retry when we hit ratelimits.
  # CLI flag: -ingester.client.backoff-on-ratelimits
  [backoff_on_ratelimits: <boolean> | default = false]

  backoff_config:
    # Minimum delay when backing off.
    # CLI flag: -ingester.client.backoff-min-period
    [min_period: <duration> | default = 100ms]

    # Maximum delay when backing off.
    # CLI flag: -ingester.client.backoff-max-period
    [max_period: <duration> | default = 10s]

    # Number of times to backoff and retry before failing.
    # CLI flag: -ingester.client.backoff-retries
    [max_retries: <int> | default = 10]

  # Path to the client certificate file, which will be used for authenticating
  # with the server. Also requires the key path to be configured.
  # CLI flag: -ingester.client.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # Path to the key file for the client certificate. Also requires the client
  # certificate to be configured.
  # CLI flag: -ingester.client.tls-key-path
  [tls_key_path: <string> | default = ""]

  # Path to the CA certificates file to validate server certificate against. If
  # not set, the host's root CA certificates are used.
  # CLI flag: -ingester.client.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # Skip validating server certificate.
  # CLI flag: -ingester.client.tls-insecure-skip-verify
  [tls_insecure_skip_verify: <boolean> | default = false]
```

### `frontend_worker_config`

The `frontend_worker_config` configures the worker - running within the Cortex querier - picking up and executing queries enqueued by the query-frontend.

```yaml
# Address of query frontend service, in host:port format.
# CLI flag: -querier.frontend-address
[frontend_address: <string> | default = ""]

# Number of simultaneous queries to process per query frontend.
# CLI flag: -querier.worker-parallelism
[parallelism: <int> | default = 10]

# Force worker concurrency to match the -querier.max-concurrent option.
# Overrides querier.worker-parallelism.
# CLI flag: -querier.worker-match-max-concurrent
[match_max_concurrent: <boolean> | default = false]

# How often to query DNS.
# CLI flag: -querier.dns-lookup-period
[dns_lookup_duration: <duration> | default = 10s]

# Querier ID, sent to frontend service to identify requests from the same
# querier. Defaults to hostname.
# CLI flag: -querier.id
[id: <string> | default = ""]

grpc_client_config:
  # gRPC client max receive message size (bytes).
  # CLI flag: -querier.frontend-client.grpc-max-recv-msg-size
  [max_recv_msg_size: <int> | default = 104857600]

  # gRPC client max send message size (bytes).
  # CLI flag: -querier.frontend-client.grpc-max-send-msg-size
  [max_send_msg_size: <int> | default = 16777216]

  # Deprecated: Use gzip compression when sending messages.  If true, overrides
  # grpc-compression flag.
  # CLI flag: -querier.frontend-client.grpc-use-gzip-compression
  [use_gzip_compression: <boolean> | default = false]

  # Use compression when sending messages. Supported values are: 'gzip',
  # 'snappy' and '' (disable compression)
  # CLI flag: -querier.frontend-client.grpc-compression
  [grpc_compression: <string> | default = ""]

  # Rate limit for gRPC client; 0 means disabled.
  # CLI flag: -querier.frontend-client.grpc-client-rate-limit
  [rate_limit: <float> | default = 0]

  # Rate limit burst for gRPC client.
  # CLI flag: -querier.frontend-client.grpc-client-rate-limit-burst
  [rate_limit_burst: <int> | default = 0]

  # Enable backoff and retry when we hit ratelimits.
  # CLI flag: -querier.frontend-client.backoff-on-ratelimits
  [backoff_on_ratelimits: <boolean> | default = false]

  backoff_config:
    # Minimum delay when backing off.
    # CLI flag: -querier.frontend-client.backoff-min-period
    [min_period: <duration> | default = 100ms]

    # Maximum delay when backing off.
    # CLI flag: -querier.frontend-client.backoff-max-period
    [max_period: <duration> | default = 10s]

    # Number of times to backoff and retry before failing.
    # CLI flag: -querier.frontend-client.backoff-retries
    [max_retries: <int> | default = 10]

  # Path to the client certificate file, which will be used for authenticating
  # with the server. Also requires the key path to be configured.
  # CLI flag: -querier.frontend-client.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # Path to the key file for the client certificate. Also requires the client
  # certificate to be configured.
  # CLI flag: -querier.frontend-client.tls-key-path
  [tls_key_path: <string> | default = ""]

  # Path to the CA certificates file to validate server certificate against. If
  # not set, the host's root CA certificates are used.
  # CLI flag: -querier.frontend-client.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # Skip validating server certificate.
  # CLI flag: -querier.frontend-client.tls-insecure-skip-verify
  [tls_insecure_skip_verify: <boolean> | default = false]
```

### `etcd_config`

The `etcd_config` configures the etcd client. The supported CLI flags `<prefix>` used to reference this config block are:

- _no prefix_
- `compactor.ring`
- `distributor.ha-tracker`
- `distributor.ring`
- `ruler.ring`
- `store-gateway.sharding-ring`

&nbsp;

```yaml
# The etcd endpoints to connect to.
# CLI flag: -<prefix>.etcd.endpoints
[endpoints: <list of string> | default = []]

# The dial timeout for the etcd connection.
# CLI flag: -<prefix>.etcd.dial-timeout
[dial_timeout: <duration> | default = 10s]

# The maximum number of retries to do for failed ops.
# CLI flag: -<prefix>.etcd.max-retries
[max_retries: <int> | default = 10]

# Enable TLS.
# CLI flag: -<prefix>.etcd.tls-enabled
[tls_enabled: <boolean> | default = false]

# The TLS certificate file path.
# CLI flag: -<prefix>.etcd.tls-cert-path
[tls_cert_path: <string> | default = ""]

# The TLS private key file path.
# CLI flag: -<prefix>.etcd.tls-key-path
[tls_key_path: <string> | default = ""]

# The trusted CA file path.
# CLI flag: -<prefix>.etcd.tls-ca-path
[tls_ca_path: <string> | default = ""]

# Skip validating server certificate.
# CLI flag: -<prefix>.etcd.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]
```

### `consul_config`

The `consul_config` configures the consul client. The supported CLI flags `<prefix>` used to reference this config block are:

- _no prefix_
- `compactor.ring`
- `distributor.ha-tracker`
- `distributor.ring`
- `ruler.ring`
- `store-gateway.sharding-ring`

&nbsp;

```yaml
# Hostname and port of Consul.
# CLI flag: -<prefix>.consul.hostname
[host: <string> | default = "localhost:8500"]

# ACL Token used to interact with Consul.
# CLI flag: -<prefix>.consul.acl-token
[acl_token: <string> | default = ""]

# HTTP timeout when talking to Consul
# CLI flag: -<prefix>.consul.client-timeout
[http_client_timeout: <duration> | default = 20s]

# Enable consistent reads to Consul.
# CLI flag: -<prefix>.consul.consistent-reads
[consistent_reads: <boolean> | default = false]

# Rate limit when watching key or prefix in Consul, in requests per second. 0
# disables the rate limit.
# CLI flag: -<prefix>.consul.watch-rate-limit
[watch_rate_limit: <float> | default = 1]

# Burst size used in rate limit. Values less than 1 are treated as 1.
# CLI flag: -<prefix>.consul.watch-burst-size
[watch_burst_size: <int> | default = 1]
```

### `memberlist_config`

The `memberlist_config` configures the Gossip memberlist.

```yaml
# Name of the node in memberlist cluster. Defaults to hostname.
# CLI flag: -memberlist.nodename
[node_name: <string> | default = ""]

# Add random suffix to the node name.
# CLI flag: -memberlist.randomize-node-name
[randomize_node_name: <boolean> | default = true]

# The timeout for establishing a connection with a remote node, and for
# read/write operations. Uses memberlist LAN defaults if 0.
# CLI flag: -memberlist.stream-timeout
[stream_timeout: <duration> | default = 0s]

# Multiplication factor used when sending out messages (factor * log(N+1)).
# CLI flag: -memberlist.retransmit-factor
[retransmit_factor: <int> | default = 0]

# How often to use pull/push sync. Uses memberlist LAN defaults if 0.
# CLI flag: -memberlist.pullpush-interval
[pull_push_interval: <duration> | default = 0s]

# How often to gossip. Uses memberlist LAN defaults if 0.
# CLI flag: -memberlist.gossip-interval
[gossip_interval: <duration> | default = 0s]

# How many nodes to gossip to. Uses memberlist LAN defaults if 0.
# CLI flag: -memberlist.gossip-nodes
[gossip_nodes: <int> | default = 0]

# How long to keep gossiping to dead nodes, to give them chance to refute their
# death. Uses memberlist LAN defaults if 0.
# CLI flag: -memberlist.gossip-to-dead-nodes-time
[gossip_to_dead_nodes_time: <duration> | default = 0s]

# How soon can dead node's name be reclaimed with new address. Defaults to 0,
# which is disabled.
# CLI flag: -memberlist.dead-node-reclaim-time
[dead_node_reclaim_time: <duration> | default = 0s]

# Other cluster members to join. Can be specified multiple times. It can be an
# IP, hostname or an entry specified in the DNS Service Discovery format (see
# https://cortexmetrics.io/docs/configuration/arguments/#dns-service-discovery
# for more details).
# CLI flag: -memberlist.join
[join_members: <list of string> | default = []]

# Min backoff duration to join other cluster members.
# CLI flag: -memberlist.min-join-backoff
[min_join_backoff: <duration> | default = 1s]

# Max backoff duration to join other cluster members.
# CLI flag: -memberlist.max-join-backoff
[max_join_backoff: <duration> | default = 1m]

# Max number of retries to join other cluster members.
# CLI flag: -memberlist.max-join-retries
[max_join_retries: <int> | default = 10]

# If this node fails to join memberlist cluster, abort.
# CLI flag: -memberlist.abort-if-join-fails
[abort_if_cluster_join_fails: <boolean> | default = true]

# If not 0, how often to rejoin the cluster. Occasional rejoin can help to fix
# the cluster split issue, and is harmless otherwise. For example when using
# only few components as a seed nodes (via -memberlist.join), then it's
# recommended to use rejoin. If -memberlist.join points to dynamic service that
# resolves to all gossiping nodes (eg. Kubernetes headless service), then rejoin
# is not needed.
# CLI flag: -memberlist.rejoin-interval
[rejoin_interval: <duration> | default = 0s]

# How long to keep LEFT ingesters in the ring.
# CLI flag: -memberlist.left-ingesters-timeout
[left_ingesters_timeout: <duration> | default = 5m]

# Timeout for leaving memberlist cluster.
# CLI flag: -memberlist.leave-timeout
[leave_timeout: <duration> | default = 5s]

# IP address to listen on for gossip messages. Multiple addresses may be
# specified. Defaults to 0.0.0.0
# CLI flag: -memberlist.bind-addr
[bind_addr: <list of string> | default = []]

# Port to listen on for gossip messages.
# CLI flag: -memberlist.bind-port
[bind_port: <int> | default = 7946]

# Timeout used when connecting to other nodes to send packet.
# CLI flag: -memberlist.packet-dial-timeout
[packet_dial_timeout: <duration> | default = 5s]

# Timeout for writing 'packet' data.
# CLI flag: -memberlist.packet-write-timeout
[packet_write_timeout: <duration> | default = 5s]
```

### `limits_config`

The `limits_config` configures default and per-tenant limits imposed by Cortex services (ie. distributor, ingester, ...).

```yaml
# Per-user ingestion rate limit in samples per second.
# CLI flag: -distributor.ingestion-rate-limit
[ingestion_rate: <float> | default = 25000]

# Whether the ingestion rate limit should be applied individually to each
# distributor instance (local), or evenly shared across the cluster (global).
# CLI flag: -distributor.ingestion-rate-limit-strategy
[ingestion_rate_strategy: <string> | default = "local"]

# Per-user allowed ingestion burst size (in number of samples).
# CLI flag: -distributor.ingestion-burst-size
[ingestion_burst_size: <int> | default = 50000]

# Flag to enable, for all users, handling of samples with external labels
# identifying replicas in an HA Prometheus setup.
# CLI flag: -distributor.ha-tracker.enable-for-all-users
[accept_ha_samples: <boolean> | default = false]

# Prometheus label to look for in samples to identify a Prometheus HA cluster.
# CLI flag: -distributor.ha-tracker.cluster
[ha_cluster_label: <string> | default = "cluster"]

# Prometheus label to look for in samples to identify a Prometheus HA replica.
# CLI flag: -distributor.ha-tracker.replica
[ha_replica_label: <string> | default = "__replica__"]

# This flag can be used to specify label names that to drop during sample
# ingestion within the distributor and can be repeated in order to drop multiple
# labels.
# CLI flag: -distributor.drop-label
[drop_labels: <list of string> | default = []]

# Maximum length accepted for label names
# CLI flag: -validation.max-length-label-name
[max_label_name_length: <int> | default = 1024]

# Maximum length accepted for label value. This setting also applies to the
# metric name
# CLI flag: -validation.max-length-label-value
[max_label_value_length: <int> | default = 2048]

# Maximum number of label names per series.
# CLI flag: -validation.max-label-names-per-series
[max_label_names_per_series: <int> | default = 30]

# Maximum length accepted for metric metadata. Metadata refers to Metric Name,
# HELP and UNIT.
# CLI flag: -validation.max-metadata-length
[max_metadata_length: <int> | default = 1024]

# Reject old samples.
# CLI flag: -validation.reject-old-samples
[reject_old_samples: <boolean> | default = false]

# Maximum accepted sample age before rejecting.
# CLI flag: -validation.reject-old-samples.max-age
[reject_old_samples_max_age: <duration> | default = 336h]

# Duration which table will be created/deleted before/after it's needed; we
# won't accept sample from before this time.
# CLI flag: -validation.create-grace-period
[creation_grace_period: <duration> | default = 10m]

# Enforce every metadata has a metric name.
# CLI flag: -validation.enforce-metadata-metric-name
[enforce_metadata_metric_name: <boolean> | default = true]

# Enforce every sample has a metric name.
# CLI flag: -validation.enforce-metric-name
[enforce_metric_name: <boolean> | default = true]

# The default tenant's shard size when the shuffle-sharding strategy is used.
# Must be set both on ingesters and distributors. When this setting is specified
# in the per-tenant overrides, a value of 0 disables shuffle sharding for the
# tenant.
# CLI flag: -distributor.ingestion-tenant-shard-size
[ingestion_tenant_shard_size: <int> | default = 0]

# List of metric relabel configurations. Note that in most situations, it is
# more effective to use metrics relabeling directly in the Prometheus server,
# e.g. remote_write.write_relabel_configs.
[metric_relabel_configs: <relabel_config...> | default = ]

# The maximum number of series for which a query can fetch samples from each
# ingester. This limit is enforced only in the ingesters (when querying samples
# not flushed to the storage yet) and it's a per-instance limit. This limit is
# ignored when running the Cortex blocks storage.
# CLI flag: -ingester.max-series-per-query
[max_series_per_query: <int> | default = 100000]

# The maximum number of samples that a query can return. This limit only applies
# when running the Cortex chunks storage with -querier.ingester-streaming=false.
# CLI flag: -ingester.max-samples-per-query
[max_samples_per_query: <int> | default = 1000000]

# The maximum number of active series per user, per ingester. 0 to disable.
# CLI flag: -ingester.max-series-per-user
[max_series_per_user: <int> | default = 5000000]

# The maximum number of active series per metric name, per ingester. 0 to
# disable.
# CLI flag: -ingester.max-series-per-metric
[max_series_per_metric: <int> | default = 50000]

# The maximum number of active series per user, across the cluster. 0 to
# disable. Supported only if -distributor.shard-by-all-labels is true.
# CLI flag: -ingester.max-global-series-per-user
[max_global_series_per_user: <int> | default = 0]

# The maximum number of active series per metric name, across the cluster. 0 to
# disable.
# CLI flag: -ingester.max-global-series-per-metric
[max_global_series_per_metric: <int> | default = 0]

# Minimum number of samples in an idle chunk to flush it to the store. Use with
# care, if chunks are less than this size they will be discarded. This option is
# ignored when running the Cortex blocks storage. 0 to disable.
# CLI flag: -ingester.min-chunk-length
[min_chunk_length: <int> | default = 0]

# The maximum number of active metrics with metadata per user, per ingester. 0
# to disable.
# CLI flag: -ingester.max-metadata-per-user
[max_metadata_per_user: <int> | default = 8000]

# The maximum number of metadata per metric, per ingester. 0 to disable.
# CLI flag: -ingester.max-metadata-per-metric
[max_metadata_per_metric: <int> | default = 10]

# The maximum number of active metrics with metadata per user, across the
# cluster. 0 to disable. Supported only if -distributor.shard-by-all-labels is
# true.
# CLI flag: -ingester.max-global-metadata-per-user
[max_global_metadata_per_user: <int> | default = 0]

# The maximum number of metadata per metric, across the cluster. 0 to disable.
# CLI flag: -ingester.max-global-metadata-per-metric
[max_global_metadata_per_metric: <int> | default = 0]

# Maximum number of chunks that can be fetched in a single query. This limit is
# enforced when fetching chunks from the long-term storage. When running the
# Cortex chunks storage, this limit is enforced in the querier, while when
# running the Cortex blocks storage this limit is both enforced in the querier
# and store-gateway. 0 to disable.
# CLI flag: -store.query-chunk-limit
[max_chunks_per_query: <int> | default = 2000000]

# Limit the query time range (end - start time). This limit is enforced in the
# query-frontend (on the received query), in the querier (on the query possibly
# split by the query-frontend) and in the chunks storage. 0 to disable.
# CLI flag: -store.max-query-length
[max_query_length: <duration> | default = 0s]

# Maximum number of queries will be scheduled in parallel by the frontend.
# CLI flag: -querier.max-query-parallelism
[max_query_parallelism: <int> | default = 14]

# Cardinality limit for index queries. This limit is ignored when running the
# Cortex blocks storage. 0 to disable.
# CLI flag: -store.cardinality-limit
[cardinality_limit: <int> | default = 100000]

# Most recent allowed cacheable result per-tenant, to prevent caching very
# recent results that might still be in flux.
# CLI flag: -frontend.max-cache-freshness
[max_cache_freshness: <duration> | default = 1m]

# Maximum number of queriers that can handle requests for a single tenant. If
# set to 0 or value higher than number of available queriers, *all* queriers
# will handle requests for the tenant. Each frontend will select the same set of
# queriers for the same tenant (given that all queriers are connected to all
# frontends). This option only works with queriers connecting to the
# query-frontend, not when using downstream URL.
# CLI flag: -frontend.max-queriers-per-tenant
[max_queriers_per_tenant: <int> | default = 0]

# Duration to delay the evaluation of rules to ensure the underlying metrics
# have been pushed to Cortex.
# CLI flag: -ruler.evaluation-delay-duration
[ruler_evaluation_delay_duration: <duration> | default = 0s]

# The default tenant's shard size when the shuffle-sharding strategy is used by
# ruler. When this setting is specified in the per-tenant overrides, a value of
# 0 disables shuffle sharding for the tenant.
# CLI flag: -ruler.tenant-shard-size
[ruler_tenant_shard_size: <int> | default = 0]

# Maximum number of rules per rule group per-tenant. 0 to disable.
# CLI flag: -ruler.max-rules-per-rule-group
[ruler_max_rules_per_rule_group: <int> | default = 0]

# Maximum number of rule groups per-tenant. 0 to disable.
# CLI flag: -ruler.max-rule-groups-per-tenant
[ruler_max_rule_groups_per_tenant: <int> | default = 0]

# The default tenant's shard size when the shuffle-sharding strategy is used.
# Must be set when the store-gateway sharding is enabled with the
# shuffle-sharding strategy. When this setting is specified in the per-tenant
# overrides, a value of 0 disables shuffle sharding for the tenant.
# CLI flag: -store-gateway.tenant-shard-size
[store_gateway_tenant_shard_size: <int> | default = 0]

# File name of per-user overrides. [deprecated, use -runtime-config.file
# instead]
# CLI flag: -limits.per-user-override-config
[per_tenant_override_config: <string> | default = ""]

# Period with which to reload the overrides. [deprecated, use
# -runtime-config.reload-period instead]
# CLI flag: -limits.per-user-override-period
[per_tenant_override_period: <duration> | default = 10s]
```

### `redis_config`

The `redis_config` configures the Redis backend cache. The supported CLI flags `<prefix>` used to reference this config block are:

- `frontend`
- `store.chunks-cache`
- `store.index-cache-read`
- `store.index-cache-write`

&nbsp;

```yaml
# Redis Server endpoint to use for caching. A comma-separated list of endpoints
# for Redis Cluster or Redis Sentinel. If empty, no redis will be used.
# CLI flag: -<prefix>.redis.endpoint
[endpoint: <string> | default = ""]

# Redis Sentinel master name. An empty string for Redis Server or Redis Cluster.
# CLI flag: -<prefix>.redis.master-name
[master_name: <string> | default = ""]

# Maximum time to wait before giving up on redis requests.
# CLI flag: -<prefix>.redis.timeout
[timeout: <duration> | default = 500ms]

# How long keys stay in the redis.
# CLI flag: -<prefix>.redis.expiration
[expiration: <duration> | default = 0s]

# Database index.
# CLI flag: -<prefix>.redis.db
[db: <int> | default = 0]

# Maximum number of connections in the pool.
# CLI flag: -<prefix>.redis.pool-size
[pool_size: <int> | default = 0]

# Password to use when connecting to redis.
# CLI flag: -<prefix>.redis.password
[password: <string> | default = ""]

# Enable connecting to redis with TLS.
# CLI flag: -<prefix>.redis.tls-enabled
[tls_enabled: <boolean> | default = false]

# Skip validating server certificate.
# CLI flag: -<prefix>.redis.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]

# Close connections after remaining idle for this duration. If the value is
# zero, then idle connections are not closed.
# CLI flag: -<prefix>.redis.idle-timeout
[idle_timeout: <duration> | default = 0s]

# Close connections older than this duration. If the value is zero, then the
# pool does not close connections based on age.
# CLI flag: -<prefix>.redis.max-connection-age
[max_connection_age: <duration> | default = 0s]
```

### `memcached_config`

The `memcached_config` block configures how data is stored in Memcached (ie. expiration). The supported CLI flags `<prefix>` used to reference this config block are:

- `frontend`
- `store.chunks-cache`
- `store.index-cache-read`
- `store.index-cache-write`

&nbsp;

```yaml
# How long keys stay in the memcache.
# CLI flag: -<prefix>.memcached.expiration
[expiration: <duration> | default = 0s]

# How many keys to fetch in each batch.
# CLI flag: -<prefix>.memcached.batchsize
[batch_size: <int> | default = 1024]

# Maximum active requests to memcache.
# CLI flag: -<prefix>.memcached.parallelism
[parallelism: <int> | default = 100]
```

### `memcached_client_config`

The `memcached_client_config` configures the client used to connect to Memcached. The supported CLI flags `<prefix>` used to reference this config block are:

- `frontend`
- `store.chunks-cache`
- `store.index-cache-read`
- `store.index-cache-write`

&nbsp;

```yaml
# Hostname for memcached service to use. If empty and if addresses is unset, no
# memcached will be used.
# CLI flag: -<prefix>.memcached.hostname
[host: <string> | default = ""]

# SRV service used to discover memcache servers.
# CLI flag: -<prefix>.memcached.service
[service: <string> | default = "memcached"]

# EXPERIMENTAL: Comma separated addresses list in DNS Service Discovery format:
# https://cortexmetrics.io/docs/configuration/arguments/#dns-service-discovery
# CLI flag: -<prefix>.memcached.addresses
[addresses: <string> | default = ""]

# Maximum time to wait before giving up on memcached requests.
# CLI flag: -<prefix>.memcached.timeout
[timeout: <duration> | default = 100ms]

# Maximum number of idle connections in pool.
# CLI flag: -<prefix>.memcached.max-idle-conns
[max_idle_conns: <int> | default = 16]

# Period with which to poll DNS for memcache servers.
# CLI flag: -<prefix>.memcached.update-interval
[update_interval: <duration> | default = 1m]

# Use consistent hashing to distribute to memcache servers.
# CLI flag: -<prefix>.memcached.consistent-hash
[consistent_hash: <boolean> | default = true]

# Trip circuit-breaker after this number of consecutive dial failures (if zero
# then circuit-breaker is disabled).
# CLI flag: -<prefix>.memcached.circuit-breaker-consecutive-failures
[circuit_breaker_consecutive_failures: <int> | default = 10]

# Duration circuit-breaker remains open after tripping (if zero then 60 seconds
# is used).
# CLI flag: -<prefix>.memcached.circuit-breaker-timeout
[circuit_breaker_timeout: <duration> | default = 10s]

# Reset circuit-breaker counts after this long (if zero then never reset).
# CLI flag: -<prefix>.memcached.circuit-breaker-interval
[circuit_breaker_interval: <duration> | default = 10s]
```

### `fifo_cache_config`

The `fifo_cache_config` configures the local in-memory cache. The supported CLI flags `<prefix>` used to reference this config block are:

- `frontend`
- `store.chunks-cache`
- `store.index-cache-read`
- `store.index-cache-write`

&nbsp;

```yaml
# Maximum memory size of the cache in bytes. A unit suffix (KB, MB, GB) may be
# applied.
# CLI flag: -<prefix>.fifocache.max-size-bytes
[max_size_bytes: <string> | default = ""]

# Maximum number of entries in the cache.
# CLI flag: -<prefix>.fifocache.max-size-items
[max_size_items: <int> | default = 0]

# The expiry duration for the cache.
# CLI flag: -<prefix>.fifocache.duration
[validity: <duration> | default = 0s]

# Deprecated (use max-size-items or max-size-bytes instead): The number of
# entries to cache.
# CLI flag: -<prefix>.fifocache.size
[size: <int> | default = 0]
```

### `configs_config`

The `configs_config` configures the Cortex Configs DB and API.

```yaml
database:
  # URI where the database can be found (for dev you can use memory://)
  # CLI flag: -configs.database.uri
  [uri: <string> | default = "postgres://postgres@configs-db.weave.local/configs?sslmode=disable"]

  # Path where the database migration files can be found
  # CLI flag: -configs.database.migrations-dir
  [migrations_dir: <string> | default = ""]

  # File containing password (username goes in URI)
  # CLI flag: -configs.database.password-file
  [password_file: <string> | default = ""]

api:
  notifications:
    # Disable Email notifications for Alertmanager.
    # CLI flag: -configs.notifications.disable-email
    [disable_email: <boolean> | default = false]

    # Disable WebHook notifications for Alertmanager.
    # CLI flag: -configs.notifications.disable-webhook
    [disable_webhook: <boolean> | default = false]
```

### `configstore_config`

The `configstore_config` configures the config database storing rules and alerts, and is used by the Cortex alertmanager. The supported CLI flags `<prefix>` used to reference this config block are:

- `alertmanager`
- `ruler`

&nbsp;

```yaml
# URL of configs API server.
# CLI flag: -<prefix>.configs.url
[configs_api_url: <url> | default = ]

# Timeout for requests to Weave Cloud configs service.
# CLI flag: -<prefix>.configs.client-timeout
[client_timeout: <duration> | default = 5s]

# Path to the client certificate file, which will be used for authenticating
# with the server. Also requires the key path to be configured.
# CLI flag: -<prefix>.configs.tls-cert-path
[tls_cert_path: <string> | default = ""]

# Path to the key file for the client certificate. Also requires the client
# certificate to be configured.
# CLI flag: -<prefix>.configs.tls-key-path
[tls_key_path: <string> | default = ""]

# Path to the CA certificates file to validate server certificate against. If
# not set, the host's root CA certificates are used.
# CLI flag: -<prefix>.configs.tls-ca-path
[tls_ca_path: <string> | default = ""]

# Skip validating server certificate.
# CLI flag: -<prefix>.configs.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]
```

### `blocks_storage_config`

The `blocks_storage_config` configures the blocks storage.

```yaml
# Backend storage to use. Supported backends are: s3, gcs, azure, swift,
# filesystem.
# CLI flag: -blocks-storage.backend
[backend: <string> | default = "s3"]

s3:
  # The S3 bucket endpoint. It could be an AWS S3 endpoint listed at
  # https://docs.aws.amazon.com/general/latest/gr/s3.html or the address of an
  # S3-compatible service in hostname:port format.
  # CLI flag: -blocks-storage.s3.endpoint
  [endpoint: <string> | default = ""]

  # S3 bucket name
  # CLI flag: -blocks-storage.s3.bucket-name
  [bucket_name: <string> | default = ""]

  # S3 secret access key
  # CLI flag: -blocks-storage.s3.secret-access-key
  [secret_access_key: <string> | default = ""]

  # S3 access key ID
  # CLI flag: -blocks-storage.s3.access-key-id
  [access_key_id: <string> | default = ""]

  # If enabled, use http:// for the S3 endpoint instead of https://. This could
  # be useful in local dev/test environments while using an S3-compatible
  # backend storage, like Minio.
  # CLI flag: -blocks-storage.s3.insecure
  [insecure: <boolean> | default = false]

  http:
    # The time an idle connection will remain idle before closing.
    # CLI flag: -blocks-storage.s3.http.idle-conn-timeout
    [idle_conn_timeout: <duration> | default = 1m30s]

    # The amount of time the client will wait for a servers response headers.
    # CLI flag: -blocks-storage.s3.http.response-header-timeout
    [response_header_timeout: <duration> | default = 2m]

    # If the client connects to S3 via HTTPS and this option is enabled, the
    # client will accept any certificate and hostname.
    # CLI flag: -blocks-storage.s3.http.insecure-skip-verify
    [insecure_skip_verify: <boolean> | default = false]

gcs:
  # GCS bucket name
  # CLI flag: -blocks-storage.gcs.bucket-name
  [bucket_name: <string> | default = ""]

  # JSON representing either a Google Developers Console client_credentials.json
  # file or a Google Developers service account key file. If empty, fallback to
  # Google default logic.
  # CLI flag: -blocks-storage.gcs.service-account
  [service_account: <string> | default = ""]

azure:
  # Azure storage account name
  # CLI flag: -blocks-storage.azure.account-name
  [account_name: <string> | default = ""]

  # Azure storage account key
  # CLI flag: -blocks-storage.azure.account-key
  [account_key: <string> | default = ""]

  # Azure storage container name
  # CLI flag: -blocks-storage.azure.container-name
  [container_name: <string> | default = ""]

  # Azure storage endpoint suffix without schema. The account name will be
  # prefixed to this value to create the FQDN
  # CLI flag: -blocks-storage.azure.endpoint-suffix
  [endpoint_suffix: <string> | default = ""]

  # Number of retries for recoverable errors
  # CLI flag: -blocks-storage.azure.max-retries
  [max_retries: <int> | default = 20]

swift:
  # OpenStack Swift authentication URL
  # CLI flag: -blocks-storage.swift.auth-url
  [auth_url: <string> | default = ""]

  # OpenStack Swift username.
  # CLI flag: -blocks-storage.swift.username
  [username: <string> | default = ""]

  # OpenStack Swift user's domain name.
  # CLI flag: -blocks-storage.swift.user-domain-name
  [user_domain_name: <string> | default = ""]

  # OpenStack Swift user's domain ID.
  # CLI flag: -blocks-storage.swift.user-domain-id
  [user_domain_id: <string> | default = ""]

  # OpenStack Swift user ID.
  # CLI flag: -blocks-storage.swift.user-id
  [user_id: <string> | default = ""]

  # OpenStack Swift API key.
  # CLI flag: -blocks-storage.swift.password
  [password: <string> | default = ""]

  # OpenStack Swift user's domain ID.
  # CLI flag: -blocks-storage.swift.domain-id
  [domain_id: <string> | default = ""]

  # OpenStack Swift user's domain name.
  # CLI flag: -blocks-storage.swift.domain-name
  [domain_name: <string> | default = ""]

  # OpenStack Swift project ID (v2,v3 auth only).
  # CLI flag: -blocks-storage.swift.project-id
  [project_id: <string> | default = ""]

  # OpenStack Swift project name (v2,v3 auth only).
  # CLI flag: -blocks-storage.swift.project-name
  [project_name: <string> | default = ""]

  # ID of the OpenStack Swift project's domain (v3 auth only), only needed if it
  # differs the from user domain.
  # CLI flag: -blocks-storage.swift.project-domain-id
  [project_domain_id: <string> | default = ""]

  # Name of the OpenStack Swift project's domain (v3 auth only), only needed if
  # it differs from the user domain.
  # CLI flag: -blocks-storage.swift.project-domain-name
  [project_domain_name: <string> | default = ""]

  # OpenStack Swift Region to use (v2,v3 auth only).
  # CLI flag: -blocks-storage.swift.region-name
  [region_name: <string> | default = ""]

  # Name of the OpenStack Swift container to put chunks in.
  # CLI flag: -blocks-storage.swift.container-name
  [container_name: <string> | default = ""]

filesystem:
  # Local filesystem storage directory.
  # CLI flag: -blocks-storage.filesystem.dir
  [dir: <string> | default = ""]

# This configures how the store-gateway synchronizes blocks stored in the
# bucket.
bucket_store:
  # Directory to store synchronized TSDB index headers.
  # CLI flag: -blocks-storage.bucket-store.sync-dir
  [sync_dir: <string> | default = "tsdb-sync"]

  # How frequently scan the bucket to look for changes (new blocks shipped by
  # ingesters and blocks removed by retention or compaction). 0 disables it.
  # CLI flag: -blocks-storage.bucket-store.sync-interval
  [sync_interval: <duration> | default = 5m]

  # Max size - in bytes - of a per-tenant chunk pool, used to reduce memory
  # allocations.
  # CLI flag: -blocks-storage.bucket-store.max-chunk-pool-bytes
  [max_chunk_pool_bytes: <int> | default = 2147483648]

  # Max number of concurrent queries to execute against the long-term storage.
  # The limit is shared across all tenants.
  # CLI flag: -blocks-storage.bucket-store.max-concurrent
  [max_concurrent: <int> | default = 100]

  # Maximum number of concurrent tenants synching blocks.
  # CLI flag: -blocks-storage.bucket-store.tenant-sync-concurrency
  [tenant_sync_concurrency: <int> | default = 10]

  # Maximum number of concurrent blocks synching per tenant.
  # CLI flag: -blocks-storage.bucket-store.block-sync-concurrency
  [block_sync_concurrency: <int> | default = 20]

  # Number of Go routines to use when syncing block meta files from object
  # storage per tenant.
  # CLI flag: -blocks-storage.bucket-store.meta-sync-concurrency
  [meta_sync_concurrency: <int> | default = 20]

  # Minimum age of a block before it's being read. Set it to safe value (e.g
  # 30m) if your object storage is eventually consistent. GCS and S3 are
  # (roughly) strongly consistent.
  # CLI flag: -blocks-storage.bucket-store.consistency-delay
  [consistency_delay: <duration> | default = 0s]

  index_cache:
    # The index cache backend type. Supported values: inmemory, memcached.
    # CLI flag: -blocks-storage.bucket-store.index-cache.backend
    [backend: <string> | default = "inmemory"]

    inmemory:
      # Maximum size in bytes of in-memory index cache used to speed up blocks
      # index lookups (shared between all tenants).
      # CLI flag: -blocks-storage.bucket-store.index-cache.inmemory.max-size-bytes
      [max_size_bytes: <int> | default = 1073741824]

    memcached:
      # Comma separated list of memcached addresses. Supported prefixes are:
      # dns+ (looked up as an A/AAAA query), dnssrv+ (looked up as a SRV query,
      # dnssrvnoa+ (looked up as a SRV query, with no A/AAAA lookup made after
      # that).
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.addresses
      [addresses: <string> | default = ""]

      # The socket read/write timeout.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.timeout
      [timeout: <duration> | default = 100ms]

      # The maximum number of idle connections that will be maintained per
      # address.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.max-idle-connections
      [max_idle_connections: <int> | default = 16]

      # The maximum number of concurrent asynchronous operations can occur.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.max-async-concurrency
      [max_async_concurrency: <int> | default = 50]

      # The maximum number of enqueued asynchronous operations allowed.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.max-async-buffer-size
      [max_async_buffer_size: <int> | default = 10000]

      # The maximum number of concurrent connections running get operations. If
      # set to 0, concurrency is unlimited.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.max-get-multi-concurrency
      [max_get_multi_concurrency: <int> | default = 100]

      # The maximum number of keys a single underlying get operation should run.
      # If more keys are specified, internally keys are splitted into multiple
      # batches and fetched concurrently, honoring the max concurrency. If set
      # to 0, the max batch size is unlimited.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.max-get-multi-batch-size
      [max_get_multi_batch_size: <int> | default = 0]

      # The maximum size of an item stored in memcached. Bigger items are not
      # stored. If set to 0, no maximum size is enforced.
      # CLI flag: -blocks-storage.bucket-store.index-cache.memcached.max-item-size
      [max_item_size: <int> | default = 1048576]

    # Compress postings before storing them to postings cache.
    # CLI flag: -blocks-storage.bucket-store.index-cache.postings-compression-enabled
    [postings_compression_enabled: <boolean> | default = false]

  chunks_cache:
    # Backend for chunks cache, if not empty. Supported values: memcached.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.backend
    [backend: <string> | default = ""]

    memcached:
      # Comma separated list of memcached addresses. Supported prefixes are:
      # dns+ (looked up as an A/AAAA query), dnssrv+ (looked up as a SRV query,
      # dnssrvnoa+ (looked up as a SRV query, with no A/AAAA lookup made after
      # that).
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.addresses
      [addresses: <string> | default = ""]

      # The socket read/write timeout.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.timeout
      [timeout: <duration> | default = 100ms]

      # The maximum number of idle connections that will be maintained per
      # address.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.max-idle-connections
      [max_idle_connections: <int> | default = 16]

      # The maximum number of concurrent asynchronous operations can occur.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.max-async-concurrency
      [max_async_concurrency: <int> | default = 50]

      # The maximum number of enqueued asynchronous operations allowed.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.max-async-buffer-size
      [max_async_buffer_size: <int> | default = 10000]

      # The maximum number of concurrent connections running get operations. If
      # set to 0, concurrency is unlimited.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.max-get-multi-concurrency
      [max_get_multi_concurrency: <int> | default = 100]

      # The maximum number of keys a single underlying get operation should run.
      # If more keys are specified, internally keys are splitted into multiple
      # batches and fetched concurrently, honoring the max concurrency. If set
      # to 0, the max batch size is unlimited.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.max-get-multi-batch-size
      [max_get_multi_batch_size: <int> | default = 0]

      # The maximum size of an item stored in memcached. Bigger items are not
      # stored. If set to 0, no maximum size is enforced.
      # CLI flag: -blocks-storage.bucket-store.chunks-cache.memcached.max-item-size
      [max_item_size: <int> | default = 1048576]

    # Size of each subrange that bucket object is split into for better caching.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.subrange-size
    [subrange_size: <int> | default = 16000]

    # Maximum number of sub-GetRange requests that a single GetRange request can
    # be split into when fetching chunks. Zero or negative value = unlimited
    # number of sub-requests.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.max-get-range-requests
    [max_get_range_requests: <int> | default = 3]

    # TTL for caching object attributes for chunks.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.attributes-ttl
    [attributes_ttl: <duration> | default = 24h]

    # TTL for caching individual chunks subranges.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.subrange-ttl
    [subrange_ttl: <duration> | default = 24h]

  metadata_cache:
    # Backend for metadata cache, if not empty. Supported values: memcached.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.backend
    [backend: <string> | default = ""]

    memcached:
      # Comma separated list of memcached addresses. Supported prefixes are:
      # dns+ (looked up as an A/AAAA query), dnssrv+ (looked up as a SRV query,
      # dnssrvnoa+ (looked up as a SRV query, with no A/AAAA lookup made after
      # that).
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.addresses
      [addresses: <string> | default = ""]

      # The socket read/write timeout.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.timeout
      [timeout: <duration> | default = 100ms]

      # The maximum number of idle connections that will be maintained per
      # address.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.max-idle-connections
      [max_idle_connections: <int> | default = 16]

      # The maximum number of concurrent asynchronous operations can occur.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.max-async-concurrency
      [max_async_concurrency: <int> | default = 50]

      # The maximum number of enqueued asynchronous operations allowed.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.max-async-buffer-size
      [max_async_buffer_size: <int> | default = 10000]

      # The maximum number of concurrent connections running get operations. If
      # set to 0, concurrency is unlimited.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.max-get-multi-concurrency
      [max_get_multi_concurrency: <int> | default = 100]

      # The maximum number of keys a single underlying get operation should run.
      # If more keys are specified, internally keys are splitted into multiple
      # batches and fetched concurrently, honoring the max concurrency. If set
      # to 0, the max batch size is unlimited.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.max-get-multi-batch-size
      [max_get_multi_batch_size: <int> | default = 0]

      # The maximum size of an item stored in memcached. Bigger items are not
      # stored. If set to 0, no maximum size is enforced.
      # CLI flag: -blocks-storage.bucket-store.metadata-cache.memcached.max-item-size
      [max_item_size: <int> | default = 1048576]

    # How long to cache list of tenants in the bucket.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.tenants-list-ttl
    [tenants_list_ttl: <duration> | default = 15m]

    # How long to cache list of blocks for each tenant.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.tenant-blocks-list-ttl
    [tenant_blocks_list_ttl: <duration> | default = 5m]

    # How long to cache list of chunks for a block.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.chunks-list-ttl
    [chunks_list_ttl: <duration> | default = 24h]

    # How long to cache information that block metafile exists.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-exists-ttl
    [metafile_exists_ttl: <duration> | default = 2h]

    # How long to cache information that block metafile doesn't exist.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-doesnt-exist-ttl
    [metafile_doesnt_exist_ttl: <duration> | default = 5m]

    # How long to cache content of the metafile.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-content-ttl
    [metafile_content_ttl: <duration> | default = 24h]

    # Maximum size of metafile content to cache in bytes.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-max-size-bytes
    [metafile_max_size_bytes: <int> | default = 1048576]

  # Duration after which the blocks marked for deletion will be filtered out
  # while fetching blocks. The idea of ignore-deletion-marks-delay is to ignore
  # blocks that are marked for deletion with some delay. This ensures store can
  # still serve blocks that are meant to be deleted but do not have a
  # replacement yet. Default is 6h, half of the default value for
  # -compactor.deletion-delay.
  # CLI flag: -blocks-storage.bucket-store.ignore-deletion-marks-delay
  [ignore_deletion_mark_delay: <duration> | default = 6h]

tsdb:
  # Local directory to store TSDBs in the ingesters.
  # CLI flag: -blocks-storage.tsdb.dir
  [dir: <string> | default = "tsdb"]

  # TSDB blocks range period.
  # CLI flag: -blocks-storage.tsdb.block-ranges-period
  [block_ranges_period: <list of duration> | default = 2h0m0s]

  # TSDB blocks retention in the ingester before a block is removed. This should
  # be larger than the block_ranges_period and large enough to give
  # store-gateways and queriers enough time to discover newly uploaded blocks.
  # CLI flag: -blocks-storage.tsdb.retention-period
  [retention_period: <duration> | default = 6h]

  # How frequently the TSDB blocks are scanned and new ones are shipped to the
  # storage. 0 means shipping is disabled.
  # CLI flag: -blocks-storage.tsdb.ship-interval
  [ship_interval: <duration> | default = 1m]

  # Maximum number of tenants concurrently shipping blocks to the storage.
  # CLI flag: -blocks-storage.tsdb.ship-concurrency
  [ship_concurrency: <int> | default = 10]

  # How frequently does Cortex try to compact TSDB head. Block is only created
  # if data covers smallest block range. Must be greater than 0 and max 5
  # minutes.
  # CLI flag: -blocks-storage.tsdb.head-compaction-interval
  [head_compaction_interval: <duration> | default = 1m]

  # Maximum number of tenants concurrently compacting TSDB head into a new block
  # CLI flag: -blocks-storage.tsdb.head-compaction-concurrency
  [head_compaction_concurrency: <int> | default = 5]

  # If TSDB head is idle for this duration, it is compacted. 0 means disabled.
  # CLI flag: -blocks-storage.tsdb.head-compaction-idle-timeout
  [head_compaction_idle_timeout: <duration> | default = 1h]

  # The number of shards of series to use in TSDB (must be a power of 2).
  # Reducing this will decrease memory footprint, but can negatively impact
  # performance.
  # CLI flag: -blocks-storage.tsdb.stripe-size
  [stripe_size: <int> | default = 16384]

  # True to enable TSDB WAL compression.
  # CLI flag: -blocks-storage.tsdb.wal-compression-enabled
  [wal_compression_enabled: <boolean> | default = false]

  # True to flush blocks to storage on shutdown. If false, incomplete blocks
  # will be reused after restart.
  # CLI flag: -blocks-storage.tsdb.flush-blocks-on-shutdown
  [flush_blocks_on_shutdown: <boolean> | default = false]

  # limit the number of concurrently opening TSDB's on startup
  # CLI flag: -blocks-storage.tsdb.max-tsdb-opening-concurrency-on-startup
  [max_tsdb_opening_concurrency_on_startup: <int> | default = 10]
```

### `compactor_config`

The `compactor_config` configures the compactor for the blocks storage.

```yaml
# List of compaction time ranges.
# CLI flag: -compactor.block-ranges
[block_ranges: <list of duration> | default = 2h0m0s,12h0m0s,24h0m0s]

# Number of Go routines to use when syncing block index and chunks files from
# the long term storage.
# CLI flag: -compactor.block-sync-concurrency
[block_sync_concurrency: <int> | default = 20]

# Number of Go routines to use when syncing block meta files from the long term
# storage.
# CLI flag: -compactor.meta-sync-concurrency
[meta_sync_concurrency: <int> | default = 20]

# Minimum age of fresh (non-compacted) blocks before they are being processed.
# Malformed blocks older than the maximum of consistency-delay and 48h0m0s will
# be removed.
# CLI flag: -compactor.consistency-delay
[consistency_delay: <duration> | default = 0s]

# Data directory in which to cache blocks and process compactions
# CLI flag: -compactor.data-dir
[data_dir: <string> | default = "./data"]

# The frequency at which the compaction runs
# CLI flag: -compactor.compaction-interval
[compaction_interval: <duration> | default = 1h]

# How many times to retry a failed compaction during a single compaction
# interval
# CLI flag: -compactor.compaction-retries
[compaction_retries: <int> | default = 3]

# Max number of concurrent compactions running.
# CLI flag: -compactor.compaction-concurrency
[compaction_concurrency: <int> | default = 1]

# Time before a block marked for deletion is deleted from bucket. If not 0,
# blocks will be marked for deletion and compactor component will delete blocks
# marked for deletion from the bucket. If delete-delay is 0, blocks will be
# deleted straight away. Note that deleting blocks immediately can cause query
# failures, if store gateway still has the block loaded, or compactor is
# ignoring the deletion because it's compacting the block at the same time.
# CLI flag: -compactor.deletion-delay
[deletion_delay: <duration> | default = 12h]

# Comma separated list of tenants that can be compacted. If specified, only
# these tenants will be compacted by compactor, otherwise all tenants can be
# compacted. Subject to sharding.
# CLI flag: -compactor.enabled-tenants
[enabled_tenants: <string> | default = ""]

# Comma separated list of tenants that cannot be compacted by this compactor. If
# specified, and compactor would normally pick given tenant for compaction (via
# -compactor.enabled-tenants or sharding), it will be ignored instead.
# CLI flag: -compactor.disabled-tenants
[disabled_tenants: <string> | default = ""]

# Shard tenants across multiple compactor instances. Sharding is required if you
# run multiple compactor instances, in order to coordinate compactions and avoid
# race conditions leading to the same tenant blocks simultaneously compacted by
# different instances.
# CLI flag: -compactor.sharding-enabled
[sharding_enabled: <boolean> | default = false]

sharding_ring:
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -compactor.ring.store
    [store: <string> | default = "consul"]

    # The prefix for the keys in the store. Should end with a /.
    # CLI flag: -compactor.ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul_config configures the consul client.
    # The CLI flags prefix for this block config is: compactor.ring
    [consul: <consul_config>]

    # The etcd_config configures the etcd client.
    # The CLI flags prefix for this block config is: compactor.ring
    [etcd: <etcd_config>]

    multi:
      # Primary backend storage used by multi-client.
      # CLI flag: -compactor.ring.multi.primary
      [primary: <string> | default = ""]

      # Secondary backend storage used by multi-client.
      # CLI flag: -compactor.ring.multi.secondary
      [secondary: <string> | default = ""]

      # Mirror writes to secondary store.
      # CLI flag: -compactor.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # Timeout for storing value to secondary store.
      # CLI flag: -compactor.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # Period at which to heartbeat to the ring.
  # CLI flag: -compactor.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 5s]

  # The heartbeat timeout after which compactors are considered unhealthy within
  # the ring.
  # CLI flag: -compactor.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # Name of network interface to read address from.
  # CLI flag: -compactor.ring.instance-interface-names
  [instance_interface_names: <list of string> | default = [eth0 en0]]
```

### `store_gateway_config`

The `store_gateway_config` configures the store-gateway service used by the blocks storage.

```yaml
# Shard blocks across multiple store gateway instances. This option needs be set
# both on the store-gateway and querier when running in microservices mode.
# CLI flag: -store-gateway.sharding-enabled
[sharding_enabled: <boolean> | default = false]

# The hash ring configuration. This option is required only if blocks sharding
# is enabled.
sharding_ring:
  # The key-value store used to share the hash ring across multiple instances.
  # This option needs be set both on the store-gateway and querier when running
  # in microservices mode.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -store-gateway.sharding-ring.store
    [store: <string> | default = "consul"]

    # The prefix for the keys in the store. Should end with a /.
    # CLI flag: -store-gateway.sharding-ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul_config configures the consul client.
    # The CLI flags prefix for this block config is: store-gateway.sharding-ring
    [consul: <consul_config>]

    # The etcd_config configures the etcd client.
    # The CLI flags prefix for this block config is: store-gateway.sharding-ring
    [etcd: <etcd_config>]

    multi:
      # Primary backend storage used by multi-client.
      # CLI flag: -store-gateway.sharding-ring.multi.primary
      [primary: <string> | default = ""]

      # Secondary backend storage used by multi-client.
      # CLI flag: -store-gateway.sharding-ring.multi.secondary
      [secondary: <string> | default = ""]

      # Mirror writes to secondary store.
      # CLI flag: -store-gateway.sharding-ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # Timeout for storing value to secondary store.
      # CLI flag: -store-gateway.sharding-ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # Period at which to heartbeat to the ring.
  # CLI flag: -store-gateway.sharding-ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # The heartbeat timeout after which store gateways are considered unhealthy
  # within the ring. This option needs be set both on the store-gateway and
  # querier when running in microservices mode.
  # CLI flag: -store-gateway.sharding-ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # The replication factor to use when sharding blocks. This option needs be set
  # both on the store-gateway and querier when running in microservices mode.
  # CLI flag: -store-gateway.sharding-ring.replication-factor
  [replication_factor: <int> | default = 3]

  # File path where tokens are stored. If empty, tokens are not stored at
  # shutdown and restored at startup.
  # CLI flag: -store-gateway.sharding-ring.tokens-file-path
  [tokens_file_path: <string> | default = ""]

  # True to enable zone-awareness and replicate blocks across different
  # availability zones.
  # CLI flag: -store-gateway.sharding-ring.zone-awareness-enabled
  [zone_awareness_enabled: <boolean> | default = false]

  # Name of network interface to read address from.
  # CLI flag: -store-gateway.sharding-ring.instance-interface-names
  [instance_interface_names: <list of string> | default = [eth0 en0]]

  # The availability zone where this instance is running. Required if
  # zone-awareness is enabled.
  # CLI flag: -store-gateway.sharding-ring.instance-availability-zone
  [instance_availability_zone: <string> | default = ""]

# The sharding strategy to use. Supported values are: default, shuffle-sharding.
# CLI flag: -store-gateway.sharding-strategy
[sharding_strategy: <string> | default = "default"]
```

### `purger_config`

The `purger_config` configures the purger which takes care of delete requests

```yaml
# Enable purger to allow deletion of series. Be aware that Delete series feature
# is still experimental
# CLI flag: -purger.enable
[enable: <boolean> | default = false]

# Number of workers executing delete plans in parallel
# CLI flag: -purger.num-workers
[num_workers: <int> | default = 2]

# Name of the object store to use for storing delete plans
# CLI flag: -purger.object-store-type
[object_store_type: <string> | default = ""]

# Allow cancellation of delete request until duration after they are created.
# Data would be deleted only after delete requests have been older than this
# duration. Ideally this should be set to at least 24h.
# CLI flag: -purger.delete-request-cancel-period
[delete_request_cancel_period: <duration> | default = 24h]
```
