// Package api provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package api

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"io"
	"io/ioutil"
	"net/http"
	"strings"
)

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example.
	Server string

	// HTTP client with any customized settings, such as certificate chains.
	Client http.Client

	// A callback for modifying requests which are generated before sending over
	// the network.
	RequestEditor func(req *http.Request, ctx context.Context) error
}

// The interface specification for the client above.
type ClientInterface interface {

	// FindPets request
	FindPets(ctx context.Context, params *FindPetsParams) (*http.Response, error)

	// AddPet request with JSON body
	AddPet(ctx context.Context, body NewPet) (*http.Response, error)

	// DeletePet request
	DeletePet(ctx context.Context, id int64) (*http.Response, error)

	// FindPetById request
	FindPetById(ctx context.Context, id int64) (*http.Response, error)
}

// FindPets request
func (c *Client) FindPets(ctx context.Context, params *FindPetsParams) (*http.Response, error) {
	req, err := NewFindPetsRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// AddPet request with JSON body
func (c *Client) AddPet(ctx context.Context, body NewPet) (*http.Response, error) {
	req, err := NewAddPetRequest(c.Server, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// DeletePet request
func (c *Client) DeletePet(ctx context.Context, id int64) (*http.Response, error) {
	req, err := NewDeletePetRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// FindPetById request
func (c *Client) FindPetById(ctx context.Context, id int64) (*http.Response, error) {
	req, err := NewFindPetByIdRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses returns a ClientWithResponses with a default Client:
func NewClientWithResponses(server string) *ClientWithResponses {
	return &ClientWithResponses{
		ClientInterface: &Client{
			Client: http.Client{},
			Server: server,
		},
	}
}

// findPetsResponse is returned by Client.FindPets()
type findPetsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *[]struct {
		// Embedded struct due to allOf(#/components/schemas/NewPet)
		NewPet
		// Embedded fields due to inline allOf schema
		Id int64 `json:"id"`
	}
	JSONDefault *Error
}

// Status returns HTTPResponse.Status
func (r *findPetsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *findPetsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsefindPetsResponse parses an HTTP response from a FindPetsWithResponse call
func ParsefindPetsResponse(rsp *http.Response) (*findPetsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &findPetsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		response.JSON200 = &[]struct {
			// Embedded struct due to allOf(#/components/schemas/NewPet)
			NewPet
			// Embedded fields due to inline allOf schema
			Id int64 `json:"id"`
		}{}
		if err := json.Unmarshal(bodyBytes, response.JSON200); err != nil {
			return nil, err
		}
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		response.JSONDefault = &Error{}
		if err := json.Unmarshal(bodyBytes, response.JSONDefault); err != nil {
			return nil, err
		}
	}

	return response, nil
}

// FindPets request returning *FindPetsResponse
func (c *ClientWithResponses) FindPetsWithResponse(ctx context.Context, params *FindPetsParams) (*findPetsResponse, error) {
	rsp, err := c.FindPets(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsefindPetsResponse(rsp)
}

// addPetResponse is returned by Client.AddPet()
type addPetResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		// Embedded struct due to allOf(#/components/schemas/NewPet)
		NewPet
		// Embedded fields due to inline allOf schema
		Id int64 `json:"id"`
	}
	JSONDefault *Error
}

// Status returns HTTPResponse.Status
func (r *addPetResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *addPetResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParseaddPetResponse parses an HTTP response from a AddPetWithResponse call
func ParseaddPetResponse(rsp *http.Response) (*addPetResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &addPetResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		response.JSON200 = &struct {
			// Embedded struct due to allOf(#/components/schemas/NewPet)
			NewPet
			// Embedded fields due to inline allOf schema
			Id int64 `json:"id"`
		}{}
		if err := json.Unmarshal(bodyBytes, response.JSON200); err != nil {
			return nil, err
		}
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		response.JSONDefault = &Error{}
		if err := json.Unmarshal(bodyBytes, response.JSONDefault); err != nil {
			return nil, err
		}
	}

	return response, nil
}

// AddPet request with JSON body returning *AddPetResponse
func (c *ClientWithResponses) AddPetWithResponse(ctx context.Context, body NewPet) (*addPetResponse, error) {
	rsp, err := c.AddPet(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseaddPetResponse(rsp)
}

// deletePetResponse is returned by Client.DeletePet()
type deletePetResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r *deletePetResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *deletePetResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsedeletePetResponse parses an HTTP response from a DeletePetWithResponse call
func ParsedeletePetResponse(rsp *http.Response) (*deletePetResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deletePetResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 204:
		break // No content-type
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		response.JSONDefault = &Error{}
		if err := json.Unmarshal(bodyBytes, response.JSONDefault); err != nil {
			return nil, err
		}
	}

	return response, nil
}

// DeletePet request returning *DeletePetResponse
func (c *ClientWithResponses) DeletePetWithResponse(ctx context.Context, id int64) (*deletePetResponse, error) {
	rsp, err := c.DeletePet(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParsedeletePetResponse(rsp)
}

// findPetByIdResponse is returned by Client.FindPetById()
type findPetByIdResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		// Embedded struct due to allOf(#/components/schemas/NewPet)
		NewPet
		// Embedded fields due to inline allOf schema
		Id int64 `json:"id"`
	}
	JSONDefault *Error
}

// Status returns HTTPResponse.Status
func (r *findPetByIdResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *findPetByIdResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsefindPetByIdResponse parses an HTTP response from a FindPetByIdWithResponse call
func ParsefindPetByIdResponse(rsp *http.Response) (*findPetByIdResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &findPetByIdResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		response.JSON200 = &struct {
			// Embedded struct due to allOf(#/components/schemas/NewPet)
			NewPet
			// Embedded fields due to inline allOf schema
			Id int64 `json:"id"`
		}{}
		if err := json.Unmarshal(bodyBytes, response.JSON200); err != nil {
			return nil, err
		}
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		response.JSONDefault = &Error{}
		if err := json.Unmarshal(bodyBytes, response.JSONDefault); err != nil {
			return nil, err
		}
	}

	return response, nil
}

// FindPetById request returning *FindPetByIdResponse
func (c *ClientWithResponses) FindPetByIdWithResponse(ctx context.Context, id int64) (*findPetByIdResponse, error) {
	rsp, err := c.FindPetById(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParsefindPetByIdResponse(rsp)
}

// NewFindPetsRequest generates requests for FindPets
func NewFindPetsRequest(server string, params *FindPetsParams) (*http.Request, error) {
	var err error

	queryUrl := fmt.Sprintf("%s/pets", server)

	var queryStrings []string

	var queryParam0 string
	if params.Tags != nil {

		queryParam0, err = runtime.StyleParam("form", true, "tags", *params.Tags)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam0)
	}

	var queryParam1 string
	if params.Limit != nil {

		queryParam1, err = runtime.StyleParam("form", true, "limit", *params.Limit)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam1)
	}

	if len(queryStrings) != 0 {
		queryUrl += "?" + strings.Join(queryStrings, "&")
	}

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewAddPetRequest generates requests for AddPet with JSON body
func NewAddPetRequest(server string, body NewPet) (*http.Request, error) {
	var bodyReader io.Reader

	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)

	return NewAddPetRequestWithBody(server, "application/json", bodyReader)
}

// NewAddPetRequestWithBody generates requests for AddPet with non-JSON body
func NewAddPetRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryUrl := fmt.Sprintf("%s/pets", server)

	req, err := http.NewRequest("POST", queryUrl, body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeletePetRequest generates requests for DeletePet
func NewDeletePetRequest(server string, id int64) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/pets/%s", server, pathParam0)

	req, err := http.NewRequest("DELETE", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewFindPetByIdRequest generates requests for FindPetById
func NewFindPetByIdRequest(server string, id int64) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/pets/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}
