// Package parameters provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package parameters

import (
	"bytes"
	"compress/gzip"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"
)

// ComplexObject defines component schema for ComplexObject.
type ComplexObject struct {
	Id     string `json:"Id"`
	Object Object `json:"Object"`
}

// Object defines component schema for Object.
type Object struct {
	FirstName string `json:"firstName"`
	Role      string `json:"role"`
}

// GetCookieParams defines parameters for GetCookie.
type GetCookieParams struct {
	P  *int32         `json:"p,omitempty"`
	Ep *int32         `json:"ep,omitempty"`
	Ea *[]int32       `json:"ea,omitempty"`
	A  *[]int32       `json:"a,omitempty"`
	Eo *Object        `json:"eo,omitempty"`
	O  *Object        `json:"o,omitempty"`
	Co *ComplexObject `json:"co,omitempty"`
}

// GetHeaderParams defines parameters for GetHeader.
type GetHeaderParams struct {
	XPrimitive         *int32         `json:"X-Primitive,omitempty"`
	XPrimitiveExploded *int32         `json:"X-Primitive-Exploded,omitempty"`
	XArrayExploded     *[]int32       `json:"X-Array-Exploded,omitempty"`
	XArray             *[]int32       `json:"X-Array,omitempty"`
	XObjectExploded    *Object        `json:"X-Object-Exploded,omitempty"`
	XObject            *Object        `json:"X-Object,omitempty"`
	XComplexObject     *ComplexObject `json:"X-Complex-Object,omitempty"`
}

// GetQueryFormParams defines parameters for GetQueryForm.
type GetQueryFormParams struct {
	Ea *[]int32       `json:"ea,omitempty"`
	A  *[]int32       `json:"a,omitempty"`
	Eo *Object        `json:"eo,omitempty"`
	O  *Object        `json:"o,omitempty"`
	Ep *int32         `json:"ep,omitempty"`
	P  *int32         `json:"p,omitempty"`
	Co *ComplexObject `json:"co,omitempty"`
}

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	// The endpoint of the server conforming to this interface, with scheme,
	// https://api.deepmap.com for example.
	Server string

	// HTTP client with any customized settings, such as certificate chains.
	Client http.Client

	// A callback for modifying requests which are generated before sending over
	// the network.
	RequestEditor func(req *http.Request, ctx context.Context) error
}

// The interface specification for the client above.
type ClientInterface interface {

	// GetContentObject request
	GetContentObject(ctx context.Context, param ComplexObject) (*http.Response, error)

	// GetCookie request
	GetCookie(ctx context.Context, params *GetCookieParams) (*http.Response, error)

	// GetHeader request
	GetHeader(ctx context.Context, params *GetHeaderParams) (*http.Response, error)

	// GetLabelExplodeArray request
	GetLabelExplodeArray(ctx context.Context, param []int32) (*http.Response, error)

	// GetLabelExplodeObject request
	GetLabelExplodeObject(ctx context.Context, param Object) (*http.Response, error)

	// GetLabelNoExplodeArray request
	GetLabelNoExplodeArray(ctx context.Context, param []int32) (*http.Response, error)

	// GetLabelNoExplodeObject request
	GetLabelNoExplodeObject(ctx context.Context, param Object) (*http.Response, error)

	// GetMatrixExplodeArray request
	GetMatrixExplodeArray(ctx context.Context, id []int32) (*http.Response, error)

	// GetMatrixExplodeObject request
	GetMatrixExplodeObject(ctx context.Context, id Object) (*http.Response, error)

	// GetMatrixNoExplodeArray request
	GetMatrixNoExplodeArray(ctx context.Context, id []int32) (*http.Response, error)

	// GetMatrixNoExplodeObject request
	GetMatrixNoExplodeObject(ctx context.Context, id Object) (*http.Response, error)

	// GetPassThrough request
	GetPassThrough(ctx context.Context, param string) (*http.Response, error)

	// GetQueryForm request
	GetQueryForm(ctx context.Context, params *GetQueryFormParams) (*http.Response, error)

	// GetSimpleExplodeArray request
	GetSimpleExplodeArray(ctx context.Context, param []int32) (*http.Response, error)

	// GetSimpleExplodeObject request
	GetSimpleExplodeObject(ctx context.Context, param Object) (*http.Response, error)

	// GetSimpleNoExplodeArray request
	GetSimpleNoExplodeArray(ctx context.Context, param []int32) (*http.Response, error)

	// GetSimpleNoExplodeObject request
	GetSimpleNoExplodeObject(ctx context.Context, param Object) (*http.Response, error)

	// GetSimplePrimitive request
	GetSimplePrimitive(ctx context.Context, param int32) (*http.Response, error)
}

// GetContentObject request
func (c *Client) GetContentObject(ctx context.Context, param ComplexObject) (*http.Response, error) {
	req, err := NewGetContentObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetCookie request
func (c *Client) GetCookie(ctx context.Context, params *GetCookieParams) (*http.Response, error) {
	req, err := NewGetCookieRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetHeader request
func (c *Client) GetHeader(ctx context.Context, params *GetHeaderParams) (*http.Response, error) {
	req, err := NewGetHeaderRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetLabelExplodeArray request
func (c *Client) GetLabelExplodeArray(ctx context.Context, param []int32) (*http.Response, error) {
	req, err := NewGetLabelExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetLabelExplodeObject request
func (c *Client) GetLabelExplodeObject(ctx context.Context, param Object) (*http.Response, error) {
	req, err := NewGetLabelExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetLabelNoExplodeArray request
func (c *Client) GetLabelNoExplodeArray(ctx context.Context, param []int32) (*http.Response, error) {
	req, err := NewGetLabelNoExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetLabelNoExplodeObject request
func (c *Client) GetLabelNoExplodeObject(ctx context.Context, param Object) (*http.Response, error) {
	req, err := NewGetLabelNoExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetMatrixExplodeArray request
func (c *Client) GetMatrixExplodeArray(ctx context.Context, id []int32) (*http.Response, error) {
	req, err := NewGetMatrixExplodeArrayRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetMatrixExplodeObject request
func (c *Client) GetMatrixExplodeObject(ctx context.Context, id Object) (*http.Response, error) {
	req, err := NewGetMatrixExplodeObjectRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetMatrixNoExplodeArray request
func (c *Client) GetMatrixNoExplodeArray(ctx context.Context, id []int32) (*http.Response, error) {
	req, err := NewGetMatrixNoExplodeArrayRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetMatrixNoExplodeObject request
func (c *Client) GetMatrixNoExplodeObject(ctx context.Context, id Object) (*http.Response, error) {
	req, err := NewGetMatrixNoExplodeObjectRequest(c.Server, id)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetPassThrough request
func (c *Client) GetPassThrough(ctx context.Context, param string) (*http.Response, error) {
	req, err := NewGetPassThroughRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetQueryForm request
func (c *Client) GetQueryForm(ctx context.Context, params *GetQueryFormParams) (*http.Response, error) {
	req, err := NewGetQueryFormRequest(c.Server, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetSimpleExplodeArray request
func (c *Client) GetSimpleExplodeArray(ctx context.Context, param []int32) (*http.Response, error) {
	req, err := NewGetSimpleExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetSimpleExplodeObject request
func (c *Client) GetSimpleExplodeObject(ctx context.Context, param Object) (*http.Response, error) {
	req, err := NewGetSimpleExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetSimpleNoExplodeArray request
func (c *Client) GetSimpleNoExplodeArray(ctx context.Context, param []int32) (*http.Response, error) {
	req, err := NewGetSimpleNoExplodeArrayRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetSimpleNoExplodeObject request
func (c *Client) GetSimpleNoExplodeObject(ctx context.Context, param Object) (*http.Response, error) {
	req, err := NewGetSimpleNoExplodeObjectRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// GetSimplePrimitive request
func (c *Client) GetSimplePrimitive(ctx context.Context, param int32) (*http.Response, error) {
	req, err := NewGetSimplePrimitiveRequest(c.Server, param)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if c.RequestEditor != nil {
		err = c.RequestEditor(req, ctx)
		if err != nil {
			return nil, err
		}
	}
	return c.Client.Do(req)
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses returns a ClientWithResponses with a default Client:
func NewClientWithResponses(server string) *ClientWithResponses {
	return &ClientWithResponses{
		ClientInterface: &Client{
			Client: http.Client{},
			Server: server,
		},
	}
}

// getContentObjectResponse is returned by Client.GetContentObject()
type getContentObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getContentObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getContentObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetContentObjectResponse parses an HTTP response from a GetContentObjectWithResponse call
func ParsegetContentObjectResponse(rsp *http.Response) (*getContentObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getContentObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetContentObject request returning *GetContentObjectResponse
func (c *ClientWithResponses) GetContentObjectWithResponse(ctx context.Context, param ComplexObject) (*getContentObjectResponse, error) {
	rsp, err := c.GetContentObject(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetContentObjectResponse(rsp)
}

// getCookieResponse is returned by Client.GetCookie()
type getCookieResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getCookieResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getCookieResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetCookieResponse parses an HTTP response from a GetCookieWithResponse call
func ParsegetCookieResponse(rsp *http.Response) (*getCookieResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getCookieResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	}

	return response, nil
}

// GetCookie request returning *GetCookieResponse
func (c *ClientWithResponses) GetCookieWithResponse(ctx context.Context, params *GetCookieParams) (*getCookieResponse, error) {
	rsp, err := c.GetCookie(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsegetCookieResponse(rsp)
}

// getHeaderResponse is returned by Client.GetHeader()
type getHeaderResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getHeaderResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getHeaderResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetHeaderResponse parses an HTTP response from a GetHeaderWithResponse call
func ParsegetHeaderResponse(rsp *http.Response) (*getHeaderResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getHeaderResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	}

	return response, nil
}

// GetHeader request returning *GetHeaderResponse
func (c *ClientWithResponses) GetHeaderWithResponse(ctx context.Context, params *GetHeaderParams) (*getHeaderResponse, error) {
	rsp, err := c.GetHeader(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsegetHeaderResponse(rsp)
}

// getLabelExplodeArrayResponse is returned by Client.GetLabelExplodeArray()
type getLabelExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getLabelExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getLabelExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetLabelExplodeArrayResponse parses an HTTP response from a GetLabelExplodeArrayWithResponse call
func ParsegetLabelExplodeArrayResponse(rsp *http.Response) (*getLabelExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getLabelExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetLabelExplodeArray request returning *GetLabelExplodeArrayResponse
func (c *ClientWithResponses) GetLabelExplodeArrayWithResponse(ctx context.Context, param []int32) (*getLabelExplodeArrayResponse, error) {
	rsp, err := c.GetLabelExplodeArray(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetLabelExplodeArrayResponse(rsp)
}

// getLabelExplodeObjectResponse is returned by Client.GetLabelExplodeObject()
type getLabelExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getLabelExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getLabelExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetLabelExplodeObjectResponse parses an HTTP response from a GetLabelExplodeObjectWithResponse call
func ParsegetLabelExplodeObjectResponse(rsp *http.Response) (*getLabelExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getLabelExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetLabelExplodeObject request returning *GetLabelExplodeObjectResponse
func (c *ClientWithResponses) GetLabelExplodeObjectWithResponse(ctx context.Context, param Object) (*getLabelExplodeObjectResponse, error) {
	rsp, err := c.GetLabelExplodeObject(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetLabelExplodeObjectResponse(rsp)
}

// getLabelNoExplodeArrayResponse is returned by Client.GetLabelNoExplodeArray()
type getLabelNoExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getLabelNoExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getLabelNoExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetLabelNoExplodeArrayResponse parses an HTTP response from a GetLabelNoExplodeArrayWithResponse call
func ParsegetLabelNoExplodeArrayResponse(rsp *http.Response) (*getLabelNoExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getLabelNoExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetLabelNoExplodeArray request returning *GetLabelNoExplodeArrayResponse
func (c *ClientWithResponses) GetLabelNoExplodeArrayWithResponse(ctx context.Context, param []int32) (*getLabelNoExplodeArrayResponse, error) {
	rsp, err := c.GetLabelNoExplodeArray(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetLabelNoExplodeArrayResponse(rsp)
}

// getLabelNoExplodeObjectResponse is returned by Client.GetLabelNoExplodeObject()
type getLabelNoExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getLabelNoExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getLabelNoExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetLabelNoExplodeObjectResponse parses an HTTP response from a GetLabelNoExplodeObjectWithResponse call
func ParsegetLabelNoExplodeObjectResponse(rsp *http.Response) (*getLabelNoExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getLabelNoExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetLabelNoExplodeObject request returning *GetLabelNoExplodeObjectResponse
func (c *ClientWithResponses) GetLabelNoExplodeObjectWithResponse(ctx context.Context, param Object) (*getLabelNoExplodeObjectResponse, error) {
	rsp, err := c.GetLabelNoExplodeObject(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetLabelNoExplodeObjectResponse(rsp)
}

// getMatrixExplodeArrayResponse is returned by Client.GetMatrixExplodeArray()
type getMatrixExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getMatrixExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getMatrixExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetMatrixExplodeArrayResponse parses an HTTP response from a GetMatrixExplodeArrayWithResponse call
func ParsegetMatrixExplodeArrayResponse(rsp *http.Response) (*getMatrixExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getMatrixExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetMatrixExplodeArray request returning *GetMatrixExplodeArrayResponse
func (c *ClientWithResponses) GetMatrixExplodeArrayWithResponse(ctx context.Context, id []int32) (*getMatrixExplodeArrayResponse, error) {
	rsp, err := c.GetMatrixExplodeArray(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParsegetMatrixExplodeArrayResponse(rsp)
}

// getMatrixExplodeObjectResponse is returned by Client.GetMatrixExplodeObject()
type getMatrixExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getMatrixExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getMatrixExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetMatrixExplodeObjectResponse parses an HTTP response from a GetMatrixExplodeObjectWithResponse call
func ParsegetMatrixExplodeObjectResponse(rsp *http.Response) (*getMatrixExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getMatrixExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetMatrixExplodeObject request returning *GetMatrixExplodeObjectResponse
func (c *ClientWithResponses) GetMatrixExplodeObjectWithResponse(ctx context.Context, id Object) (*getMatrixExplodeObjectResponse, error) {
	rsp, err := c.GetMatrixExplodeObject(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParsegetMatrixExplodeObjectResponse(rsp)
}

// getMatrixNoExplodeArrayResponse is returned by Client.GetMatrixNoExplodeArray()
type getMatrixNoExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getMatrixNoExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getMatrixNoExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetMatrixNoExplodeArrayResponse parses an HTTP response from a GetMatrixNoExplodeArrayWithResponse call
func ParsegetMatrixNoExplodeArrayResponse(rsp *http.Response) (*getMatrixNoExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getMatrixNoExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetMatrixNoExplodeArray request returning *GetMatrixNoExplodeArrayResponse
func (c *ClientWithResponses) GetMatrixNoExplodeArrayWithResponse(ctx context.Context, id []int32) (*getMatrixNoExplodeArrayResponse, error) {
	rsp, err := c.GetMatrixNoExplodeArray(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParsegetMatrixNoExplodeArrayResponse(rsp)
}

// getMatrixNoExplodeObjectResponse is returned by Client.GetMatrixNoExplodeObject()
type getMatrixNoExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getMatrixNoExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getMatrixNoExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetMatrixNoExplodeObjectResponse parses an HTTP response from a GetMatrixNoExplodeObjectWithResponse call
func ParsegetMatrixNoExplodeObjectResponse(rsp *http.Response) (*getMatrixNoExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getMatrixNoExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetMatrixNoExplodeObject request returning *GetMatrixNoExplodeObjectResponse
func (c *ClientWithResponses) GetMatrixNoExplodeObjectWithResponse(ctx context.Context, id Object) (*getMatrixNoExplodeObjectResponse, error) {
	rsp, err := c.GetMatrixNoExplodeObject(ctx, id)
	if err != nil {
		return nil, err
	}
	return ParsegetMatrixNoExplodeObjectResponse(rsp)
}

// getPassThroughResponse is returned by Client.GetPassThrough()
type getPassThroughResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getPassThroughResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getPassThroughResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetPassThroughResponse parses an HTTP response from a GetPassThroughWithResponse call
func ParsegetPassThroughResponse(rsp *http.Response) (*getPassThroughResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getPassThroughResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetPassThrough request returning *GetPassThroughResponse
func (c *ClientWithResponses) GetPassThroughWithResponse(ctx context.Context, param string) (*getPassThroughResponse, error) {
	rsp, err := c.GetPassThrough(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetPassThroughResponse(rsp)
}

// getQueryFormResponse is returned by Client.GetQueryForm()
type getQueryFormResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getQueryFormResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getQueryFormResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetQueryFormResponse parses an HTTP response from a GetQueryFormWithResponse call
func ParsegetQueryFormResponse(rsp *http.Response) (*getQueryFormResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getQueryFormResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetQueryForm request returning *GetQueryFormResponse
func (c *ClientWithResponses) GetQueryFormWithResponse(ctx context.Context, params *GetQueryFormParams) (*getQueryFormResponse, error) {
	rsp, err := c.GetQueryForm(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsegetQueryFormResponse(rsp)
}

// getSimpleExplodeArrayResponse is returned by Client.GetSimpleExplodeArray()
type getSimpleExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getSimpleExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getSimpleExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetSimpleExplodeArrayResponse parses an HTTP response from a GetSimpleExplodeArrayWithResponse call
func ParsegetSimpleExplodeArrayResponse(rsp *http.Response) (*getSimpleExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSimpleExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetSimpleExplodeArray request returning *GetSimpleExplodeArrayResponse
func (c *ClientWithResponses) GetSimpleExplodeArrayWithResponse(ctx context.Context, param []int32) (*getSimpleExplodeArrayResponse, error) {
	rsp, err := c.GetSimpleExplodeArray(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetSimpleExplodeArrayResponse(rsp)
}

// getSimpleExplodeObjectResponse is returned by Client.GetSimpleExplodeObject()
type getSimpleExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getSimpleExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getSimpleExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetSimpleExplodeObjectResponse parses an HTTP response from a GetSimpleExplodeObjectWithResponse call
func ParsegetSimpleExplodeObjectResponse(rsp *http.Response) (*getSimpleExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSimpleExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetSimpleExplodeObject request returning *GetSimpleExplodeObjectResponse
func (c *ClientWithResponses) GetSimpleExplodeObjectWithResponse(ctx context.Context, param Object) (*getSimpleExplodeObjectResponse, error) {
	rsp, err := c.GetSimpleExplodeObject(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetSimpleExplodeObjectResponse(rsp)
}

// getSimpleNoExplodeArrayResponse is returned by Client.GetSimpleNoExplodeArray()
type getSimpleNoExplodeArrayResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getSimpleNoExplodeArrayResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getSimpleNoExplodeArrayResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetSimpleNoExplodeArrayResponse parses an HTTP response from a GetSimpleNoExplodeArrayWithResponse call
func ParsegetSimpleNoExplodeArrayResponse(rsp *http.Response) (*getSimpleNoExplodeArrayResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSimpleNoExplodeArrayResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetSimpleNoExplodeArray request returning *GetSimpleNoExplodeArrayResponse
func (c *ClientWithResponses) GetSimpleNoExplodeArrayWithResponse(ctx context.Context, param []int32) (*getSimpleNoExplodeArrayResponse, error) {
	rsp, err := c.GetSimpleNoExplodeArray(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetSimpleNoExplodeArrayResponse(rsp)
}

// getSimpleNoExplodeObjectResponse is returned by Client.GetSimpleNoExplodeObject()
type getSimpleNoExplodeObjectResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getSimpleNoExplodeObjectResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getSimpleNoExplodeObjectResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetSimpleNoExplodeObjectResponse parses an HTTP response from a GetSimpleNoExplodeObjectWithResponse call
func ParsegetSimpleNoExplodeObjectResponse(rsp *http.Response) (*getSimpleNoExplodeObjectResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSimpleNoExplodeObjectResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetSimpleNoExplodeObject request returning *GetSimpleNoExplodeObjectResponse
func (c *ClientWithResponses) GetSimpleNoExplodeObjectWithResponse(ctx context.Context, param Object) (*getSimpleNoExplodeObjectResponse, error) {
	rsp, err := c.GetSimpleNoExplodeObject(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetSimpleNoExplodeObjectResponse(rsp)
}

// getSimplePrimitiveResponse is returned by Client.GetSimplePrimitive()
type getSimplePrimitiveResponse struct {
	Body         []byte
	HTTPResponse *http.Response
}

// Status returns HTTPResponse.Status
func (r *getSimplePrimitiveResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r *getSimplePrimitiveResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// ParsegetSimplePrimitiveResponse parses an HTTP response from a GetSimplePrimitiveWithResponse call
func ParsegetSimplePrimitiveResponse(rsp *http.Response) (*getSimplePrimitiveResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSimplePrimitiveResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case rsp.StatusCode == 200:
		// Content-type (text/plain) unsupported
	}

	return response, nil
}

// GetSimplePrimitive request returning *GetSimplePrimitiveResponse
func (c *ClientWithResponses) GetSimplePrimitiveWithResponse(ctx context.Context, param int32) (*getSimplePrimitiveResponse, error) {
	rsp, err := c.GetSimplePrimitive(ctx, param)
	if err != nil {
		return nil, err
	}
	return ParsegetSimplePrimitiveResponse(rsp)
}

// NewGetContentObjectRequest generates requests for GetContentObject
func NewGetContentObjectRequest(server string, param ComplexObject) (*http.Request, error) {
	var err error

	var pathParam0 string

	var pathParamBuf0 []byte
	pathParamBuf0, err = json.Marshal(param)
	if err != nil {
		return nil, err
	}
	pathParam0 = string(pathParamBuf0)

	queryUrl := fmt.Sprintf("%s/contentObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetCookieRequest generates requests for GetCookie
func NewGetCookieRequest(server string, params *GetCookieParams) (*http.Request, error) {
	var err error

	queryUrl := fmt.Sprintf("%s/cookie", server)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	if params.P != nil {
		var cookieParam0 string

		cookieParam0, err = runtime.StyleParam("simple", false, "p", *params.P)
		if err != nil {
			return nil, err
		}

		cookie0 := &http.Cookie{
			Name:  "p",
			Value: cookieParam0,
		}
		req.AddCookie(cookie0)
	}

	if params.Ep != nil {
		var cookieParam1 string

		cookieParam1, err = runtime.StyleParam("simple", true, "ep", *params.Ep)
		if err != nil {
			return nil, err
		}

		cookie1 := &http.Cookie{
			Name:  "ep",
			Value: cookieParam1,
		}
		req.AddCookie(cookie1)
	}

	if params.Ea != nil {
		var cookieParam2 string

		cookieParam2, err = runtime.StyleParam("simple", true, "ea", *params.Ea)
		if err != nil {
			return nil, err
		}

		cookie2 := &http.Cookie{
			Name:  "ea",
			Value: cookieParam2,
		}
		req.AddCookie(cookie2)
	}

	if params.A != nil {
		var cookieParam3 string

		cookieParam3, err = runtime.StyleParam("simple", false, "a", *params.A)
		if err != nil {
			return nil, err
		}

		cookie3 := &http.Cookie{
			Name:  "a",
			Value: cookieParam3,
		}
		req.AddCookie(cookie3)
	}

	if params.Eo != nil {
		var cookieParam4 string

		cookieParam4, err = runtime.StyleParam("simple", true, "eo", *params.Eo)
		if err != nil {
			return nil, err
		}

		cookie4 := &http.Cookie{
			Name:  "eo",
			Value: cookieParam4,
		}
		req.AddCookie(cookie4)
	}

	if params.O != nil {
		var cookieParam5 string

		cookieParam5, err = runtime.StyleParam("simple", false, "o", *params.O)
		if err != nil {
			return nil, err
		}

		cookie5 := &http.Cookie{
			Name:  "o",
			Value: cookieParam5,
		}
		req.AddCookie(cookie5)
	}

	if params.Co != nil {
		var cookieParam6 string

		var cookieParamBuf6 []byte
		cookieParamBuf6, err = json.Marshal(*params.Co)
		if err != nil {
			return nil, err
		}
		cookieParam6 = url.QueryEscape(string(cookieParamBuf6))

		cookie6 := &http.Cookie{
			Name:  "co",
			Value: cookieParam6,
		}
		req.AddCookie(cookie6)
	}

	return req, nil
}

// NewGetHeaderRequest generates requests for GetHeader
func NewGetHeaderRequest(server string, params *GetHeaderParams) (*http.Request, error) {
	var err error

	queryUrl := fmt.Sprintf("%s/header", server)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	if params.XPrimitive != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "X-Primitive", *params.XPrimitive)
		if err != nil {
			return nil, err
		}

		req.Header.Add("X-Primitive", headerParam0)
	}

	if params.XPrimitiveExploded != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", true, "X-Primitive-Exploded", *params.XPrimitiveExploded)
		if err != nil {
			return nil, err
		}

		req.Header.Add("X-Primitive-Exploded", headerParam1)
	}

	if params.XArrayExploded != nil {
		var headerParam2 string

		headerParam2, err = runtime.StyleParam("simple", true, "X-Array-Exploded", *params.XArrayExploded)
		if err != nil {
			return nil, err
		}

		req.Header.Add("X-Array-Exploded", headerParam2)
	}

	if params.XArray != nil {
		var headerParam3 string

		headerParam3, err = runtime.StyleParam("simple", false, "X-Array", *params.XArray)
		if err != nil {
			return nil, err
		}

		req.Header.Add("X-Array", headerParam3)
	}

	if params.XObjectExploded != nil {
		var headerParam4 string

		headerParam4, err = runtime.StyleParam("simple", true, "X-Object-Exploded", *params.XObjectExploded)
		if err != nil {
			return nil, err
		}

		req.Header.Add("X-Object-Exploded", headerParam4)
	}

	if params.XObject != nil {
		var headerParam5 string

		headerParam5, err = runtime.StyleParam("simple", false, "X-Object", *params.XObject)
		if err != nil {
			return nil, err
		}

		req.Header.Add("X-Object", headerParam5)
	}

	if params.XComplexObject != nil {
		var headerParam6 string

		var headerParamBuf6 []byte
		headerParamBuf6, err = json.Marshal(*params.XComplexObject)
		if err != nil {
			return nil, err
		}
		headerParam6 = string(headerParamBuf6)

		req.Header.Add("X-Complex-Object", headerParam6)
	}

	return req, nil
}

// NewGetLabelExplodeArrayRequest generates requests for GetLabelExplodeArray
func NewGetLabelExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("label", true, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/labelExplodeArray/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLabelExplodeObjectRequest generates requests for GetLabelExplodeObject
func NewGetLabelExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("label", true, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/labelExplodeObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLabelNoExplodeArrayRequest generates requests for GetLabelNoExplodeArray
func NewGetLabelNoExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("label", false, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/labelNoExplodeArray/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetLabelNoExplodeObjectRequest generates requests for GetLabelNoExplodeObject
func NewGetLabelNoExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("label", false, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/labelNoExplodeObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixExplodeArrayRequest generates requests for GetMatrixExplodeArray
func NewGetMatrixExplodeArrayRequest(server string, id []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("matrix", true, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/matrixExplodeArray/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixExplodeObjectRequest generates requests for GetMatrixExplodeObject
func NewGetMatrixExplodeObjectRequest(server string, id Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("matrix", true, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/matrixExplodeObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixNoExplodeArrayRequest generates requests for GetMatrixNoExplodeArray
func NewGetMatrixNoExplodeArrayRequest(server string, id []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("matrix", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/matrixNoExplodeArray/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetMatrixNoExplodeObjectRequest generates requests for GetMatrixNoExplodeObject
func NewGetMatrixNoExplodeObjectRequest(server string, id Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("matrix", false, "id", id)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/matrixNoExplodeObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetPassThroughRequest generates requests for GetPassThrough
func NewGetPassThroughRequest(server string, param string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0 = param

	queryUrl := fmt.Sprintf("%s/passThrough/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetQueryFormRequest generates requests for GetQueryForm
func NewGetQueryFormRequest(server string, params *GetQueryFormParams) (*http.Request, error) {
	var err error

	queryUrl := fmt.Sprintf("%s/queryForm", server)

	var queryStrings []string

	var queryParam0 string
	if params.Ea != nil {

		queryParam0, err = runtime.StyleParam("form", true, "ea", *params.Ea)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam0)
	}

	var queryParam1 string
	if params.A != nil {

		queryParam1, err = runtime.StyleParam("form", false, "a", *params.A)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam1)
	}

	var queryParam2 string
	if params.Eo != nil {

		queryParam2, err = runtime.StyleParam("form", true, "eo", *params.Eo)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam2)
	}

	var queryParam3 string
	if params.O != nil {

		queryParam3, err = runtime.StyleParam("form", false, "o", *params.O)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam3)
	}

	var queryParam4 string
	if params.Ep != nil {

		queryParam4, err = runtime.StyleParam("form", true, "ep", *params.Ep)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam4)
	}

	var queryParam5 string
	if params.P != nil {

		queryParam5, err = runtime.StyleParam("form", false, "p", *params.P)
		if err != nil {
			return nil, err
		}

		queryStrings = append(queryStrings, queryParam5)
	}

	var queryParam6 string
	if params.Co != nil {

		var queryParamBuf6 []byte
		queryParamBuf6, err = json.Marshal(*params.Co)
		if err != nil {
			return nil, err
		}
		queryParam6 = "co=" + string(queryParamBuf6)

		queryStrings = append(queryStrings, queryParam6)
	}

	if len(queryStrings) != 0 {
		queryUrl += "?" + strings.Join(queryStrings, "&")
	}

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleExplodeArrayRequest generates requests for GetSimpleExplodeArray
func NewGetSimpleExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", true, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/simpleExplodeArray/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleExplodeObjectRequest generates requests for GetSimpleExplodeObject
func NewGetSimpleExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", true, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/simpleExplodeObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleNoExplodeArrayRequest generates requests for GetSimpleNoExplodeArray
func NewGetSimpleNoExplodeArrayRequest(server string, param []int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/simpleNoExplodeArray/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimpleNoExplodeObjectRequest generates requests for GetSimpleNoExplodeObject
func NewGetSimpleNoExplodeObjectRequest(server string, param Object) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/simpleNoExplodeObject/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetSimplePrimitiveRequest generates requests for GetSimplePrimitive
func NewGetSimplePrimitiveRequest(server string, param int32) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "param", param)
	if err != nil {
		return nil, err
	}

	queryUrl := fmt.Sprintf("%s/simplePrimitive/%s", server, pathParam0)

	req, err := http.NewRequest("GET", queryUrl, nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// ServerInterface represents all server handlers.
type ServerInterface interface {
	//  (GET /contentObject/{param})
	GetContentObject(ctx echo.Context, param ComplexObject) error
	//  (GET /cookie)
	GetCookie(ctx echo.Context, params GetCookieParams) error
	//  (GET /header)
	GetHeader(ctx echo.Context, params GetHeaderParams) error
	//  (GET /labelExplodeArray/{.param*})
	GetLabelExplodeArray(ctx echo.Context, param []int32) error
	//  (GET /labelExplodeObject/{.param*})
	GetLabelExplodeObject(ctx echo.Context, param Object) error
	//  (GET /labelNoExplodeArray/{.param})
	GetLabelNoExplodeArray(ctx echo.Context, param []int32) error
	//  (GET /labelNoExplodeObject/{.param})
	GetLabelNoExplodeObject(ctx echo.Context, param Object) error
	//  (GET /matrixExplodeArray/{.id*})
	GetMatrixExplodeArray(ctx echo.Context, id []int32) error
	//  (GET /matrixExplodeObject/{.id*})
	GetMatrixExplodeObject(ctx echo.Context, id Object) error
	//  (GET /matrixNoExplodeArray/{.id})
	GetMatrixNoExplodeArray(ctx echo.Context, id []int32) error
	//  (GET /matrixNoExplodeObject/{.id})
	GetMatrixNoExplodeObject(ctx echo.Context, id Object) error
	//  (GET /passThrough/{param})
	GetPassThrough(ctx echo.Context, param string) error
	//  (GET /queryForm)
	GetQueryForm(ctx echo.Context, params GetQueryFormParams) error
	//  (GET /simpleExplodeArray/{param*})
	GetSimpleExplodeArray(ctx echo.Context, param []int32) error
	//  (GET /simpleExplodeObject/{param*})
	GetSimpleExplodeObject(ctx echo.Context, param Object) error
	//  (GET /simpleNoExplodeArray/{param})
	GetSimpleNoExplodeArray(ctx echo.Context, param []int32) error
	//  (GET /simpleNoExplodeObject/{param})
	GetSimpleNoExplodeObject(ctx echo.Context, param Object) error
	//  (GET /simplePrimitive/{param})
	GetSimplePrimitive(ctx echo.Context, param int32) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetContentObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetContentObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param ComplexObject

	err = json.Unmarshal([]byte(ctx.Param("param")), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'param' as JSON")
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetContentObject(ctx, param)
	return err
}

// GetCookie converts echo context to params.
func (w *ServerInterfaceWrapper) GetCookie(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetCookieParams

	if cookie, err := ctx.Cookie("p"); err == nil {

		var value int32
		err = runtime.BindStyledParameter("simple", false, "p", cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter p: %s", err))
		}
		params.P = &value

	}

	if cookie, err := ctx.Cookie("ep"); err == nil {

		var value int32
		err = runtime.BindStyledParameter("simple", true, "ep", cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ep: %s", err))
		}
		params.Ep = &value

	}

	if cookie, err := ctx.Cookie("ea"); err == nil {

		var value []int32
		err = runtime.BindStyledParameter("simple", true, "ea", cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ea: %s", err))
		}
		params.Ea = &value

	}

	if cookie, err := ctx.Cookie("a"); err == nil {

		var value []int32
		err = runtime.BindStyledParameter("simple", false, "a", cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter a: %s", err))
		}
		params.A = &value

	}

	if cookie, err := ctx.Cookie("eo"); err == nil {

		var value Object
		err = runtime.BindStyledParameter("simple", true, "eo", cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter eo: %s", err))
		}
		params.Eo = &value

	}

	if cookie, err := ctx.Cookie("o"); err == nil {

		var value Object
		err = runtime.BindStyledParameter("simple", false, "o", cookie.Value, &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter o: %s", err))
		}
		params.O = &value

	}

	if cookie, err := ctx.Cookie("co"); err == nil {

		var value ComplexObject
		var decoded string
		decoded, err := url.QueryUnescape(cookie.Value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unescaping cookie parameter 'co'")
		}
		err = json.Unmarshal([]byte(decoded), &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'co' as JSON")
		}
		params.Co = &value

	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCookie(ctx, params)
	return err
}

// GetHeader converts echo context to params.
func (w *ServerInterfaceWrapper) GetHeader(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetHeaderParams

	headers := ctx.Request().Header
	// ------------- Optional header parameter "X-Primitive" -------------
	if valueList, found := headers["X-Primitive"]; found {
		var XPrimitive int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Primitive, got %d", n))
		}

		err = runtime.BindStyledParameter("simple", false, "X-Primitive", valueList[0], &XPrimitive)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Primitive: %s", err))
		}

		params.XPrimitive = &XPrimitive
	}
	// ------------- Optional header parameter "X-Primitive-Exploded" -------------
	if valueList, found := headers["X-Primitive-Exploded"]; found {
		var XPrimitiveExploded int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Primitive-Exploded, got %d", n))
		}

		err = runtime.BindStyledParameter("simple", true, "X-Primitive-Exploded", valueList[0], &XPrimitiveExploded)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Primitive-Exploded: %s", err))
		}

		params.XPrimitiveExploded = &XPrimitiveExploded
	}
	// ------------- Optional header parameter "X-Array-Exploded" -------------
	if valueList, found := headers["X-Array-Exploded"]; found {
		var XArrayExploded []int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Array-Exploded, got %d", n))
		}

		err = runtime.BindStyledParameter("simple", true, "X-Array-Exploded", valueList[0], &XArrayExploded)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Array-Exploded: %s", err))
		}

		params.XArrayExploded = &XArrayExploded
	}
	// ------------- Optional header parameter "X-Array" -------------
	if valueList, found := headers["X-Array"]; found {
		var XArray []int32
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Array, got %d", n))
		}

		err = runtime.BindStyledParameter("simple", false, "X-Array", valueList[0], &XArray)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Array: %s", err))
		}

		params.XArray = &XArray
	}
	// ------------- Optional header parameter "X-Object-Exploded" -------------
	if valueList, found := headers["X-Object-Exploded"]; found {
		var XObjectExploded Object
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Object-Exploded, got %d", n))
		}

		err = runtime.BindStyledParameter("simple", true, "X-Object-Exploded", valueList[0], &XObjectExploded)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Object-Exploded: %s", err))
		}

		params.XObjectExploded = &XObjectExploded
	}
	// ------------- Optional header parameter "X-Object" -------------
	if valueList, found := headers["X-Object"]; found {
		var XObject Object
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Object, got %d", n))
		}

		err = runtime.BindStyledParameter("simple", false, "X-Object", valueList[0], &XObject)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter X-Object: %s", err))
		}

		params.XObject = &XObject
	}
	// ------------- Optional header parameter "X-Complex-Object" -------------
	if valueList, found := headers["X-Complex-Object"]; found {
		var XComplexObject ComplexObject
		n := len(valueList)
		if n != 1 {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Expected one value for X-Complex-Object, got %d", n))
		}

		err = json.Unmarshal([]byte(valueList[0]), &XComplexObject)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'X-Complex-Object' as JSON")
		}

		params.XComplexObject = &XComplexObject
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetHeader(ctx, params)
	return err
}

// GetLabelExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameter("label", true, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelExplodeArray(ctx, param)
	return err
}

// GetLabelExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameter("label", true, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelExplodeObject(ctx, param)
	return err
}

// GetLabelNoExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelNoExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameter("label", false, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelNoExplodeArray(ctx, param)
	return err
}

// GetLabelNoExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetLabelNoExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameter("label", false, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLabelNoExplodeObject(ctx, param)
	return err
}

// GetMatrixExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id []int32

	err = runtime.BindStyledParameter("matrix", true, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixExplodeArray(ctx, id)
	return err
}

// GetMatrixExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id Object

	err = runtime.BindStyledParameter("matrix", true, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixExplodeObject(ctx, id)
	return err
}

// GetMatrixNoExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixNoExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id []int32

	err = runtime.BindStyledParameter("matrix", false, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixNoExplodeArray(ctx, id)
	return err
}

// GetMatrixNoExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetMatrixNoExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id Object

	err = runtime.BindStyledParameter("matrix", false, "id", ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetMatrixNoExplodeObject(ctx, id)
	return err
}

// GetPassThrough converts echo context to params.
func (w *ServerInterfaceWrapper) GetPassThrough(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param string

	param = ctx.Param("param")

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetPassThrough(ctx, param)
	return err
}

// GetQueryForm converts echo context to params.
func (w *ServerInterfaceWrapper) GetQueryForm(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetQueryFormParams
	// ------------- Optional query parameter "ea" -------------
	if paramValue := ctx.QueryParam("ea"); paramValue != "" {

	}

	err = runtime.BindQueryParameter("form", true, false, "ea", ctx.QueryParams(), &params.Ea)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ea: %s", err))
	}

	// ------------- Optional query parameter "a" -------------
	if paramValue := ctx.QueryParam("a"); paramValue != "" {

	}

	err = runtime.BindQueryParameter("form", false, false, "a", ctx.QueryParams(), &params.A)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter a: %s", err))
	}

	// ------------- Optional query parameter "eo" -------------
	if paramValue := ctx.QueryParam("eo"); paramValue != "" {

	}

	err = runtime.BindQueryParameter("form", true, false, "eo", ctx.QueryParams(), &params.Eo)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter eo: %s", err))
	}

	// ------------- Optional query parameter "o" -------------
	if paramValue := ctx.QueryParam("o"); paramValue != "" {

	}

	err = runtime.BindQueryParameter("form", false, false, "o", ctx.QueryParams(), &params.O)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter o: %s", err))
	}

	// ------------- Optional query parameter "ep" -------------
	if paramValue := ctx.QueryParam("ep"); paramValue != "" {

	}

	err = runtime.BindQueryParameter("form", true, false, "ep", ctx.QueryParams(), &params.Ep)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter ep: %s", err))
	}

	// ------------- Optional query parameter "p" -------------
	if paramValue := ctx.QueryParam("p"); paramValue != "" {

	}

	err = runtime.BindQueryParameter("form", false, false, "p", ctx.QueryParams(), &params.P)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter p: %s", err))
	}

	// ------------- Optional query parameter "co" -------------
	if paramValue := ctx.QueryParam("co"); paramValue != "" {

		var value ComplexObject
		err = json.Unmarshal([]byte(paramValue), &value)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, "Error unmarshaling parameter 'co' as JSON")
		}
		params.Co = &value

	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetQueryForm(ctx, params)
	return err
}

// GetSimpleExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameter("simple", true, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleExplodeArray(ctx, param)
	return err
}

// GetSimpleExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameter("simple", true, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleExplodeObject(ctx, param)
	return err
}

// GetSimpleNoExplodeArray converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleNoExplodeArray(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param []int32

	err = runtime.BindStyledParameter("simple", false, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleNoExplodeArray(ctx, param)
	return err
}

// GetSimpleNoExplodeObject converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimpleNoExplodeObject(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param Object

	err = runtime.BindStyledParameter("simple", false, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimpleNoExplodeObject(ctx, param)
	return err
}

// GetSimplePrimitive converts echo context to params.
func (w *ServerInterfaceWrapper) GetSimplePrimitive(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "param" -------------
	var param int32

	err = runtime.BindStyledParameter("simple", false, "param", ctx.Param("param"), &param)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter param: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSimplePrimitive(ctx, param)
	return err
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router runtime.EchoRouter, si ServerInterface) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET("/contentObject/:param", wrapper.GetContentObject)
	router.GET("/cookie", wrapper.GetCookie)
	router.GET("/header", wrapper.GetHeader)
	router.GET("/labelExplodeArray/:param", wrapper.GetLabelExplodeArray)
	router.GET("/labelExplodeObject/:param", wrapper.GetLabelExplodeObject)
	router.GET("/labelNoExplodeArray/:param", wrapper.GetLabelNoExplodeArray)
	router.GET("/labelNoExplodeObject/:param", wrapper.GetLabelNoExplodeObject)
	router.GET("/matrixExplodeArray/:id", wrapper.GetMatrixExplodeArray)
	router.GET("/matrixExplodeObject/:id", wrapper.GetMatrixExplodeObject)
	router.GET("/matrixNoExplodeArray/:id", wrapper.GetMatrixNoExplodeArray)
	router.GET("/matrixNoExplodeObject/:id", wrapper.GetMatrixNoExplodeObject)
	router.GET("/passThrough/:param", wrapper.GetPassThrough)
	router.GET("/queryForm", wrapper.GetQueryForm)
	router.GET("/simpleExplodeArray/:param", wrapper.GetSimpleExplodeArray)
	router.GET("/simpleExplodeObject/:param", wrapper.GetSimpleExplodeObject)
	router.GET("/simpleNoExplodeArray/:param", wrapper.GetSimpleNoExplodeArray)
	router.GET("/simpleNoExplodeObject/:param", wrapper.GetSimpleNoExplodeObject)
	router.GET("/simplePrimitive/:param", wrapper.GetSimplePrimitive)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/9xZTW/iPBD+K2je97RKCW1vuVXVrrbS9mOXHlaqOLjJAO4msWubCoTy31d2EiAfhARI",
	"oHuDZD6eefJ4Yk+W4LKAsxBDJcFZgkDJWSjR/BnSgPv4K7mkr7gsVBgq/VPhXNncJzTU/6Q7xYCY6wuO",
	"4IBUgoYTiKLIAg+lKyhXlIXgwE1Pmri9NFePvb6hq0CbxnFM9lumreaP8U1nCVwwjkLRGNydV5LNgrX5",
	"/wLH4MB/9rpCOwlvP64zCnyfUYEeOC+ps6WDjzLBsrnHVEj1QAIshSCYX3Yjl8tYWRuhRoYrGo6Zdvap",
	"iwnpoUkE93fPOrqiSoeHZ5SqN0TxgQIs+EAhY3ov+4P+QBsyjiHhFBy47g/6l2ABJ2pq8NvJc4zrs5ec",
	"CBJE+s4ETbm6WKKfl2ZZX7zddDChBAlQoZDgvGR0QTj3qWuc7TfJcuqoeijZB56wAY6BDVZKg8kMm1wq",
	"McNoZGW1ezUYbMu3srNzAo9MTttl7A/FajaMRYGGrNC5oAFV9EMb4pz7zENwxsSXmBTmpmHS0jJlJZaF",
	"lUVDhRMUWlC1Mmp6tiTEgzMmWbweEYIs6qYl1WmpwkCW5bfSK3G2EjwFGFV8twdjRQtLF0wtXlg1oHod",
	"LY+lCKGKkyNBaKshZEtzY4M1y6UluSU1RSOz1KdIPBRVS/17bHHoUp+mYRJMvy+eNlxaXfQVqS++Jjrt",
	"pA0Ugdxo65og2moKW1CduDUUUcWroCZZbXSKbZA+f8MoVpYE2lph0j588op+8kSMauxl3/SJL5WbqR95",
	"t2J7KdNEnX3QXiK1QKqF2VSaguBImykL5CwIiFiAE858v8BYuvtsStm2TegxOKsj167pemBlEttNV9av",
	"gq/NVf7PiGxVfVZmDWjbqbNDeDszoQVECTrP6Yx61YvyvuC0z6Kk3rEFFhfTGV0rgTXia/8utoOwZsrq",
	"iqtCE6NeDa6O0MI+r7yKHawZZwf0r08mMU6kfJ4KNptM6wyzntbmlaOsBiPOkwyq3mcoFt+YCKqK/bky",
	"2nGGrXWGMylbmOSs1TLWUBue4XKoOgNV7yyX5+wEU54chFYQrMjYNZDI89HO2LOi/D0SnvJ4mkNfPs46",
	"XleJv85k39Y1TmjDgtvZnGrjitp8AWU4y3xVaUDa+ZxruyIsvync/eoelvidz8m2c97qf8Abljmexdm2",
	"K9JWU+/6dG3O6HNE7UWM3kYQFWvp+gqsEmm1w4rp7NJ8LI7hz4QPDkyV4o5tJ1+KFUrV9xB5QHifUIhG",
	"0d8AAAD//z8tDE4fIAAA",
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file.
func GetSwagger() (*openapi3.Swagger, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	swagger, err := openapi3.NewSwaggerLoader().LoadSwaggerFromData(buf.Bytes())
	if err != nil {
		return nil, fmt.Errorf("error loading Swagger: %s", err)
	}
	return swagger, nil
}

