// Code generated by ffjson <https://github.com/pquerna/ffjson>. DO NOT EDIT.
// source: fillorderoperation.go

package operations

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	fflib "github.com/pquerna/ffjson/fflib/v1"
)

// MarshalJSON marshal bytes to json - template
func (j *FillOrderOperation) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *FillOrderOperation) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "order_id":`)

	{

		obj, err = j.OrderID.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteString(`,"account_id":`)

	{

		obj, err = j.AccountID.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	/* Struct fall back. type=types.AssetAmount kind=struct */
	buf.WriteString(`,"pays":`)
	err = buf.Encode(&j.Pays)
	if err != nil {
		return err
	}
	/* Struct fall back. type=types.AssetAmount kind=struct */
	buf.WriteString(`,"receives":`)
	err = buf.Encode(&j.Receives)
	if err != nil {
		return err
	}
	if j.IsMaker {
		buf.WriteString(`,"is_maker":true`)
	} else {
		buf.WriteString(`,"is_maker":false`)
	}
	/* Struct fall back. type=types.Price kind=struct */
	buf.WriteString(`,"fill_price":`)
	err = buf.Encode(&j.FillPrice)
	if err != nil {
		return err
	}
	buf.WriteByte(',')
	if j.Fee != nil {
		if true {
			/* Struct fall back. type=types.AssetAmount kind=struct */
			buf.WriteString(`"fee":`)
			err = buf.Encode(j.Fee)
			if err != nil {
				return err
			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffjtFillOrderOperationbase = iota
	ffjtFillOrderOperationnosuchkey

	ffjtFillOrderOperationOrderID

	ffjtFillOrderOperationAccountID

	ffjtFillOrderOperationPays

	ffjtFillOrderOperationReceives

	ffjtFillOrderOperationIsMaker

	ffjtFillOrderOperationFillPrice

	ffjtFillOrderOperationFee
)

var ffjKeyFillOrderOperationOrderID = []byte("order_id")

var ffjKeyFillOrderOperationAccountID = []byte("account_id")

var ffjKeyFillOrderOperationPays = []byte("pays")

var ffjKeyFillOrderOperationReceives = []byte("receives")

var ffjKeyFillOrderOperationIsMaker = []byte("is_maker")

var ffjKeyFillOrderOperationFillPrice = []byte("fill_price")

var ffjKeyFillOrderOperationFee = []byte("fee")

// UnmarshalJSON umarshall json - template of ffjson
func (j *FillOrderOperation) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *FillOrderOperation) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtFillOrderOperationbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtFillOrderOperationnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffjKeyFillOrderOperationAccountID, kn) {
						currentKey = ffjtFillOrderOperationAccountID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffjKeyFillOrderOperationFillPrice, kn) {
						currentKey = ffjtFillOrderOperationFillPrice
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyFillOrderOperationFee, kn) {
						currentKey = ffjtFillOrderOperationFee
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffjKeyFillOrderOperationIsMaker, kn) {
						currentKey = ffjtFillOrderOperationIsMaker
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'o':

					if bytes.Equal(ffjKeyFillOrderOperationOrderID, kn) {
						currentKey = ffjtFillOrderOperationOrderID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffjKeyFillOrderOperationPays, kn) {
						currentKey = ffjtFillOrderOperationPays
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffjKeyFillOrderOperationReceives, kn) {
						currentKey = ffjtFillOrderOperationReceives
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffjKeyFillOrderOperationFee, kn) {
					currentKey = ffjtFillOrderOperationFee
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyFillOrderOperationFillPrice, kn) {
					currentKey = ffjtFillOrderOperationFillPrice
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyFillOrderOperationIsMaker, kn) {
					currentKey = ffjtFillOrderOperationIsMaker
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyFillOrderOperationReceives, kn) {
					currentKey = ffjtFillOrderOperationReceives
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyFillOrderOperationPays, kn) {
					currentKey = ffjtFillOrderOperationPays
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyFillOrderOperationAccountID, kn) {
					currentKey = ffjtFillOrderOperationAccountID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyFillOrderOperationOrderID, kn) {
					currentKey = ffjtFillOrderOperationOrderID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtFillOrderOperationnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtFillOrderOperationOrderID:
					goto handle_OrderID

				case ffjtFillOrderOperationAccountID:
					goto handle_AccountID

				case ffjtFillOrderOperationPays:
					goto handle_Pays

				case ffjtFillOrderOperationReceives:
					goto handle_Receives

				case ffjtFillOrderOperationIsMaker:
					goto handle_IsMaker

				case ffjtFillOrderOperationFillPrice:
					goto handle_FillPrice

				case ffjtFillOrderOperationFee:
					goto handle_Fee

				case ffjtFillOrderOperationnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_OrderID:

	/* handler: j.OrderID type=types.GrapheneID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.OrderID.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AccountID:

	/* handler: j.AccountID type=types.GrapheneID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.AccountID.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Pays:

	/* handler: j.Pays type=types.AssetAmount kind=struct quoted=false*/

	{
		/* Falling back. type=types.AssetAmount kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.Pays)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Receives:

	/* handler: j.Receives type=types.AssetAmount kind=struct quoted=false*/

	{
		/* Falling back. type=types.AssetAmount kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.Receives)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IsMaker:

	/* handler: j.IsMaker type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.IsMaker = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.IsMaker = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FillPrice:

	/* handler: j.FillPrice type=types.Price kind=struct quoted=false*/

	{
		/* Falling back. type=types.Price kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.FillPrice)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Fee:

	/* handler: j.Fee type=types.AssetAmount kind=struct quoted=false*/

	{
		/* Falling back. type=types.AssetAmount kind=struct */
		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = json.Unmarshal(tbuf, &j.Fee)
		if err != nil {
			return fs.WrapErr(err)
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}
