// Code generated by ffjson <https://github.com/pquerna/ffjson>. DO NOT EDIT.
// source: accountstatistics.go

package types

import (
	"bytes"
	"fmt"
	fflib "github.com/pquerna/ffjson/fflib/v1"
)

// MarshalJSON marshal bytes to json - template
func (j *AccountStatistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *AccountStatistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"id":`)

	{

		obj, err = j.ID.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteString(`,"most_recent_op":`)

	{

		obj, err = j.MostRecentOp.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteString(`,"owner":`)

	{

		obj, err = j.Owner.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteString(`,"lifetime_fees_paid":`)
	fflib.FormatBits2(buf, uint64(j.LifetimeFeesPaid), 10, false)
	buf.WriteString(`,"pending_fees":`)
	fflib.FormatBits2(buf, uint64(j.PendingFees), 10, false)
	buf.WriteString(`,"pending_vested_fees":`)
	fflib.FormatBits2(buf, uint64(j.PendingVestedFees), 10, false)
	buf.WriteString(`,"removed_ops":`)
	fflib.FormatBits2(buf, uint64(j.RemovedOps), 10, false)
	buf.WriteString(`,"total_ops":`)
	fflib.FormatBits2(buf, uint64(j.TotalOps), 10, false)
	buf.WriteString(`,"total_core_in_orders":`)
	fflib.FormatBits2(buf, uint64(j.TotalCoreInOrders), 10, false)
	buf.WriteByte('}')
	return nil
}

const (
	ffjtAccountStatisticsbase = iota
	ffjtAccountStatisticsnosuchkey

	ffjtAccountStatisticsID

	ffjtAccountStatisticsMostRecentOp

	ffjtAccountStatisticsOwner

	ffjtAccountStatisticsLifetimeFeesPaid

	ffjtAccountStatisticsPendingFees

	ffjtAccountStatisticsPendingVestedFees

	ffjtAccountStatisticsRemovedOps

	ffjtAccountStatisticsTotalOps

	ffjtAccountStatisticsTotalCoreInOrders
)

var ffjKeyAccountStatisticsID = []byte("id")

var ffjKeyAccountStatisticsMostRecentOp = []byte("most_recent_op")

var ffjKeyAccountStatisticsOwner = []byte("owner")

var ffjKeyAccountStatisticsLifetimeFeesPaid = []byte("lifetime_fees_paid")

var ffjKeyAccountStatisticsPendingFees = []byte("pending_fees")

var ffjKeyAccountStatisticsPendingVestedFees = []byte("pending_vested_fees")

var ffjKeyAccountStatisticsRemovedOps = []byte("removed_ops")

var ffjKeyAccountStatisticsTotalOps = []byte("total_ops")

var ffjKeyAccountStatisticsTotalCoreInOrders = []byte("total_core_in_orders")

// UnmarshalJSON umarshall json - template of ffjson
func (j *AccountStatistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *AccountStatistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtAccountStatisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtAccountStatisticsnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffjKeyAccountStatisticsID, kn) {
						currentKey = ffjtAccountStatisticsID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffjKeyAccountStatisticsLifetimeFeesPaid, kn) {
						currentKey = ffjtAccountStatisticsLifetimeFeesPaid
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffjKeyAccountStatisticsMostRecentOp, kn) {
						currentKey = ffjtAccountStatisticsMostRecentOp
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'o':

					if bytes.Equal(ffjKeyAccountStatisticsOwner, kn) {
						currentKey = ffjtAccountStatisticsOwner
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffjKeyAccountStatisticsPendingFees, kn) {
						currentKey = ffjtAccountStatisticsPendingFees
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyAccountStatisticsPendingVestedFees, kn) {
						currentKey = ffjtAccountStatisticsPendingVestedFees
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffjKeyAccountStatisticsRemovedOps, kn) {
						currentKey = ffjtAccountStatisticsRemovedOps
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffjKeyAccountStatisticsTotalOps, kn) {
						currentKey = ffjtAccountStatisticsTotalOps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyAccountStatisticsTotalCoreInOrders, kn) {
						currentKey = ffjtAccountStatisticsTotalCoreInOrders
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsTotalCoreInOrders, kn) {
					currentKey = ffjtAccountStatisticsTotalCoreInOrders
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsTotalOps, kn) {
					currentKey = ffjtAccountStatisticsTotalOps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsRemovedOps, kn) {
					currentKey = ffjtAccountStatisticsRemovedOps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsPendingVestedFees, kn) {
					currentKey = ffjtAccountStatisticsPendingVestedFees
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsPendingFees, kn) {
					currentKey = ffjtAccountStatisticsPendingFees
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsLifetimeFeesPaid, kn) {
					currentKey = ffjtAccountStatisticsLifetimeFeesPaid
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyAccountStatisticsOwner, kn) {
					currentKey = ffjtAccountStatisticsOwner
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyAccountStatisticsMostRecentOp, kn) {
					currentKey = ffjtAccountStatisticsMostRecentOp
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyAccountStatisticsID, kn) {
					currentKey = ffjtAccountStatisticsID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtAccountStatisticsnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtAccountStatisticsID:
					goto handle_ID

				case ffjtAccountStatisticsMostRecentOp:
					goto handle_MostRecentOp

				case ffjtAccountStatisticsOwner:
					goto handle_Owner

				case ffjtAccountStatisticsLifetimeFeesPaid:
					goto handle_LifetimeFeesPaid

				case ffjtAccountStatisticsPendingFees:
					goto handle_PendingFees

				case ffjtAccountStatisticsPendingVestedFees:
					goto handle_PendingVestedFees

				case ffjtAccountStatisticsRemovedOps:
					goto handle_RemovedOps

				case ffjtAccountStatisticsTotalOps:
					goto handle_TotalOps

				case ffjtAccountStatisticsTotalCoreInOrders:
					goto handle_TotalCoreInOrders

				case ffjtAccountStatisticsnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ID:

	/* handler: j.ID type=types.GrapheneID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.ID.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MostRecentOp:

	/* handler: j.MostRecentOp type=types.GrapheneID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.MostRecentOp.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Owner:

	/* handler: j.Owner type=types.GrapheneID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.Owner.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LifetimeFeesPaid:

	/* handler: j.LifetimeFeesPaid type=types.UInt64 kind=uint64 quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.LifetimeFeesPaid.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_PendingFees:

	/* handler: j.PendingFees type=types.UInt64 kind=uint64 quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.PendingFees.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_PendingVestedFees:

	/* handler: j.PendingVestedFees type=types.UInt64 kind=uint64 quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.PendingVestedFees.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RemovedOps:

	/* handler: j.RemovedOps type=types.UInt64 kind=uint64 quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.RemovedOps.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TotalOps:

	/* handler: j.TotalOps type=types.UInt64 kind=uint64 quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.TotalOps.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TotalCoreInOrders:

	/* handler: j.TotalCoreInOrders type=types.UInt64 kind=uint64 quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			tbuf, err := fs.CaptureField(tok)
			if err != nil {
				return fs.WrapErr(err)
			}

			err = j.TotalCoreInOrders.UnmarshalJSON(tbuf)
			if err != nil {
				return fs.WrapErr(err)
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}
