# ast-viewer

[![CircleCI](https://circleci.com/gh/datacamp/ast-viewer.svg?style=svg&circle-token=79a78a39ce7228326c9fa458833aee242eb0322a)](https://circleci.com/gh/datacamp/ast-viewer)

Hosted at https://ast-viewer.datacamp.com, the ast viewer allows users to quickly parse Python, SQL (Postgres + Transact) and Shell code and inspect the resulting parse trees and abstract syntax trees. This makes development of parsing grammars ([example]) easier, but can also help when writing SCTs to figure out which ASTs are being generated for different submissions.

The AST viewer features 2 modes:

- Editor, where you can add commands in the editor. When clicking 'Submit', your code will be parsed and the corresponding trees are displayed. Mostly for interactive usage and figuring out how to write SCTs.
- Gallery, where you can drop in YAML files with a format like [this one](https://github.com/datacamp/antlr-plsql/blob/master/tests/v0.2.yml). The app will parse all the commands in the YAML file with the specified parser, and generate and display all trees. Mostly for development purposes (visually verify that all parsing still happens correctly after a change is made).

## Run locally

The `ast-viewer` has a front-end in JS (Vue) and a back-end in Python. Both use the grammars generated by [antlr-plsql](https://github.com/datacamp/antlr-plsql) and [antlr-tsql](https://github.com/datacamp/antlr-tsql); the back-end also depends on Osh and `shellwhat`. Because of the myriad dependencies and intricacies with grammar files needing to be in certain places, it is advised to use Docker to run the app.

```bash
docker build -t ast-viewer .
docker run -p 3000:3000 ast-viewer python3 run.py
```

You can now visit http://localhost:3000.

## Deployment

The app is deployed to CircleCI on DataCamp's ECS cluster. The `master` branch builds and deploys to https://ast-viewer.datacamp-staging.com. If you tag the master with tags that start with `v`, the app will be deployed to https://ast-viewer.datacamp.com.
