<p align="center">
  <img src="ios/devhub/Images.xcassets/iTunesArtwork@1x.png" height="100" /><br/>
  <span><b>DevHub</b>: <span>GitHub native client for Android, iOS & Web</span><br/>
  <span>with <b>95%+ code sharing</b> between them</span>
</p>

## Why

If you have one or more repositories on GitHub that you work on or that you really like, the `watch` feature on GitHub is great to follow all their activities.
It's like Dan said:

<a href="https://twitter.com/dan_abramov/status/819555257055322112" target="_blank">
  <img src="https://cloud.githubusercontent.com/assets/619186/23582032/035a42a8-0100-11e7-8065-8ba1462bf157.png" height="180" />
</a>


The problem is that your notifications on GitHub may get **really** cluttered.
And I believe the notifications should be only for important things, like `@mentions` and issues `assigned to you`.

<br/>

## Features

Current implementations:

- [x] **GitHub watcher**: Follow GitHub activity without needing to `watch` a repository neither `follow` the user
  - [x] **User feed**: See the exact content the user see on their home page
  - [x] **User events**: See all activity made by an user _(starred a repo, ...)_
  - [x] **Repository events**: See all activity happening on a single repo _(released a new version, ...)_
  - [x] **Organization events**: See all activity happening on the whole organization _(merged a pull request, ...)_
- [x] **Notifications manager**
  - [x] **TweetDeck column-style**: Overview all your notifications with easy
  - [x] **Mark as read/unread**: Differently than GitHub, the notification doesn't disappear after opening it

Other features:

- [x] **Inbox Zero**: Keep your mind clean by archiving all seem items
- [x] **Theme**: Light, Dark or Dark-Blue

Next features:

- [ ] **Notifications content**: See the relevant notification content before opening it
- [ ] **More complete GitHub client**: Native views for `Issues`, `Pull Requests`, `User Profiles`, etc
- [ ] **Push Notifications**

> Pull Requests more than welcome!

<br/>

## Screenshots

### Android

<div>
  <img src="https://cloud.githubusercontent.com/assets/619186/23582517/d9627f46-010a-11e7-8117-66e6c2219091.png" height="600" />
  <img src="https://cloud.githubusercontent.com/assets/619186/23582531/0d06d716-010b-11e7-9555-e41cbbe8ca6e.png" height="600" />
</div>

### iOS

<div>
  <img src="https://cloud.githubusercontent.com/assets/619186/23582307/8f1935f0-0106-11e7-954a-38d3002870fe.png" height="600" />
  <img src="https://cloud.githubusercontent.com/assets/619186/23582300/3f10e8be-0106-11e7-8b72-463f56eeee90.png" height="600" />
</div>

<br/>

### Web

<div>
  <img src="https://cloud.githubusercontent.com/assets/619186/23582571/1397607c-010c-11e7-82ac-7dec19781db8.png" />
</div>

<br/>

## Author

🇧🇷 Bruno Lemos, Remote Software Engineer<br/>
🐦 Follow me on Twitter ([@brunolemos](https://twitter.com/brunolemos))

<br/>

## Inspired by

Similar projects:

- [DevSpace](https://devspace.io/) by [@zenorocha](https://github.com/zenorocha)
- [Octobox](https://github.com/octobox/octobox) by [@andrew](https://github.com/andrew)

<br/>

## License

Copyright (c) 2017 [Bruno Lemos](https://twitter.com/brunolemos), licensed under the AGPL-3.0 license.

> ✅ This project is 100% free to use and provided  as is without any warranties.
You are encouraged to use, share and submit pull requests with improvements.

> ⚠️ If you create a fork or project based on it, is must also be free, open source, under the same license and give credits to this repository and author.

> 🚫 You are not allowed to distribute this application anywhere, including but not limited to Apple Store, Google Play or any web hosts.

See [LICENSE.md](LICENSE.md) for a super long, detailed and serious information.
