// Code generated by protoc-gen-gogo.
// source: graphresponse.proto
// DO NOT EDIT!

/*
	Package graph is a generated protocol buffer package.

	It is generated from these files:
		graphresponse.proto

	It has these top-level messages:
		NQuad
		Value
		Mutation
		Request
		Latency
		Property
		Node
		Response
*/
package graph

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type NQuad struct {
	Subject     string `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	Predicate   string `protobuf:"bytes,2,opt,name=predicate,proto3" json:"predicate,omitempty"`
	ObjectId    string `protobuf:"bytes,3,opt,name=objectId,proto3" json:"objectId,omitempty"`
	ObjectValue *Value `protobuf:"bytes,4,opt,name=objectValue" json:"objectValue,omitempty"`
	Label       string `protobuf:"bytes,5,opt,name=label,proto3" json:"label,omitempty"`
	ObjectType  int32  `protobuf:"zigzag32,6,opt,name=objectType,proto3" json:"objectType,omitempty"`
}

func (m *NQuad) Reset()                    { *m = NQuad{} }
func (m *NQuad) String() string            { return proto.CompactTextString(m) }
func (*NQuad) ProtoMessage()               {}
func (*NQuad) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{0} }

func (m *NQuad) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *NQuad) GetPredicate() string {
	if m != nil {
		return m.Predicate
	}
	return ""
}

func (m *NQuad) GetObjectId() string {
	if m != nil {
		return m.ObjectId
	}
	return ""
}

func (m *NQuad) GetObjectValue() *Value {
	if m != nil {
		return m.ObjectValue
	}
	return nil
}

func (m *NQuad) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *NQuad) GetObjectType() int32 {
	if m != nil {
		return m.ObjectType
	}
	return 0
}

type Value struct {
	// Types that are valid to be assigned to Val:
	//	*Value_BytesVal
	//	*Value_IntVal
	//	*Value_BoolVal
	//	*Value_StrVal
	//	*Value_DoubleVal
	//	*Value_GeoVal
	//	*Value_DateVal
	//	*Value_DatetimeVal
	Val isValue_Val `protobuf_oneof:"val"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{1} }

type isValue_Val interface {
	isValue_Val()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Value_BytesVal struct {
	BytesVal []byte `protobuf:"bytes,1,opt,name=bytes_val,json=bytesVal,proto3,oneof"`
}
type Value_IntVal struct {
	IntVal int32 `protobuf:"varint,2,opt,name=int_val,json=intVal,proto3,oneof"`
}
type Value_BoolVal struct {
	BoolVal bool `protobuf:"varint,3,opt,name=bool_val,json=boolVal,proto3,oneof"`
}
type Value_StrVal struct {
	StrVal string `protobuf:"bytes,4,opt,name=str_val,json=strVal,proto3,oneof"`
}
type Value_DoubleVal struct {
	DoubleVal float64 `protobuf:"fixed64,5,opt,name=double_val,json=doubleVal,proto3,oneof"`
}
type Value_GeoVal struct {
	GeoVal []byte `protobuf:"bytes,6,opt,name=geo_val,json=geoVal,proto3,oneof"`
}
type Value_DateVal struct {
	DateVal []byte `protobuf:"bytes,7,opt,name=date_val,json=dateVal,proto3,oneof"`
}
type Value_DatetimeVal struct {
	DatetimeVal []byte `protobuf:"bytes,8,opt,name=datetime_val,json=datetimeVal,proto3,oneof"`
}

func (*Value_BytesVal) isValue_Val()    {}
func (*Value_IntVal) isValue_Val()      {}
func (*Value_BoolVal) isValue_Val()     {}
func (*Value_StrVal) isValue_Val()      {}
func (*Value_DoubleVal) isValue_Val()   {}
func (*Value_GeoVal) isValue_Val()      {}
func (*Value_DateVal) isValue_Val()     {}
func (*Value_DatetimeVal) isValue_Val() {}

func (m *Value) GetVal() isValue_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *Value) GetBytesVal() []byte {
	if x, ok := m.GetVal().(*Value_BytesVal); ok {
		return x.BytesVal
	}
	return nil
}

func (m *Value) GetIntVal() int32 {
	if x, ok := m.GetVal().(*Value_IntVal); ok {
		return x.IntVal
	}
	return 0
}

func (m *Value) GetBoolVal() bool {
	if x, ok := m.GetVal().(*Value_BoolVal); ok {
		return x.BoolVal
	}
	return false
}

func (m *Value) GetStrVal() string {
	if x, ok := m.GetVal().(*Value_StrVal); ok {
		return x.StrVal
	}
	return ""
}

func (m *Value) GetDoubleVal() float64 {
	if x, ok := m.GetVal().(*Value_DoubleVal); ok {
		return x.DoubleVal
	}
	return 0
}

func (m *Value) GetGeoVal() []byte {
	if x, ok := m.GetVal().(*Value_GeoVal); ok {
		return x.GeoVal
	}
	return nil
}

func (m *Value) GetDateVal() []byte {
	if x, ok := m.GetVal().(*Value_DateVal); ok {
		return x.DateVal
	}
	return nil
}

func (m *Value) GetDatetimeVal() []byte {
	if x, ok := m.GetVal().(*Value_DatetimeVal); ok {
		return x.DatetimeVal
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_BytesVal)(nil),
		(*Value_IntVal)(nil),
		(*Value_BoolVal)(nil),
		(*Value_StrVal)(nil),
		(*Value_DoubleVal)(nil),
		(*Value_GeoVal)(nil),
		(*Value_DateVal)(nil),
		(*Value_DatetimeVal)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// val
	switch x := m.Val.(type) {
	case *Value_BytesVal:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.BytesVal)
	case *Value_IntVal:
		_ = b.EncodeVarint(2<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.IntVal))
	case *Value_BoolVal:
		t := uint64(0)
		if x.BoolVal {
			t = 1
		}
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Value_StrVal:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.StrVal)
	case *Value_DoubleVal:
		_ = b.EncodeVarint(5<<3 | proto.WireFixed64)
		_ = b.EncodeFixed64(math.Float64bits(x.DoubleVal))
	case *Value_GeoVal:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.GeoVal)
	case *Value_DateVal:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.DateVal)
	case *Value_DatetimeVal:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.DatetimeVal)
	case nil:
	default:
		return fmt.Errorf("Value.Val has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 1: // val.bytes_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Val = &Value_BytesVal{x}
		return true, err
	case 2: // val.int_val
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Val = &Value_IntVal{int32(x)}
		return true, err
	case 3: // val.bool_val
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Val = &Value_BoolVal{x != 0}
		return true, err
	case 4: // val.str_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Val = &Value_StrVal{x}
		return true, err
	case 5: // val.double_val
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Val = &Value_DoubleVal{math.Float64frombits(x)}
		return true, err
	case 6: // val.geo_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Val = &Value_GeoVal{x}
		return true, err
	case 7: // val.date_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Val = &Value_DateVal{x}
		return true, err
	case 8: // val.datetime_val
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Val = &Value_DatetimeVal{x}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// val
	switch x := m.Val.(type) {
	case *Value_BytesVal:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BytesVal)))
		n += len(x.BytesVal)
	case *Value_IntVal:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntVal))
	case *Value_BoolVal:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case *Value_StrVal:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StrVal)))
		n += len(x.StrVal)
	case *Value_DoubleVal:
		n += proto.SizeVarint(5<<3 | proto.WireFixed64)
		n += 8
	case *Value_GeoVal:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.GeoVal)))
		n += len(x.GeoVal)
	case *Value_DateVal:
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.DateVal)))
		n += len(x.DateVal)
	case *Value_DatetimeVal:
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.DatetimeVal)))
		n += len(x.DatetimeVal)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Mutation struct {
	Set []*NQuad `protobuf:"bytes,1,rep,name=set" json:"set,omitempty"`
	Del []*NQuad `protobuf:"bytes,2,rep,name=del" json:"del,omitempty"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{2} }

func (m *Mutation) GetSet() []*NQuad {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Mutation) GetDel() []*NQuad {
	if m != nil {
		return m.Del
	}
	return nil
}

type Request struct {
	Query    string    `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Mutation *Mutation `protobuf:"bytes,2,opt,name=mutation" json:"mutation,omitempty"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{3} }

func (m *Request) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *Request) GetMutation() *Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

type Latency struct {
	Parsing    string `protobuf:"bytes,1,opt,name=parsing,proto3" json:"parsing,omitempty"`
	Processing string `protobuf:"bytes,2,opt,name=processing,proto3" json:"processing,omitempty"`
	Pb         string `protobuf:"bytes,3,opt,name=pb,proto3" json:"pb,omitempty"`
}

func (m *Latency) Reset()                    { *m = Latency{} }
func (m *Latency) String() string            { return proto.CompactTextString(m) }
func (*Latency) ProtoMessage()               {}
func (*Latency) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{4} }

func (m *Latency) GetParsing() string {
	if m != nil {
		return m.Parsing
	}
	return ""
}

func (m *Latency) GetProcessing() string {
	if m != nil {
		return m.Processing
	}
	return ""
}

func (m *Latency) GetPb() string {
	if m != nil {
		return m.Pb
	}
	return ""
}

type Property struct {
	Prop  string `protobuf:"bytes,1,opt,name=prop,proto3" json:"prop,omitempty"`
	Value *Value `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Property) Reset()                    { *m = Property{} }
func (m *Property) String() string            { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()               {}
func (*Property) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{5} }

func (m *Property) GetProp() string {
	if m != nil {
		return m.Prop
	}
	return ""
}

func (m *Property) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

type Node struct {
	Uid        uint64      `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	Xid        string      `protobuf:"bytes,2,opt,name=xid,proto3" json:"xid,omitempty"`
	Attribute  string      `protobuf:"bytes,3,opt,name=attribute,proto3" json:"attribute,omitempty"`
	Properties []*Property `protobuf:"bytes,4,rep,name=properties" json:"properties,omitempty"`
	Children   []*Node     `protobuf:"bytes,5,rep,name=children" json:"children,omitempty"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{6} }

func (m *Node) GetUid() uint64 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *Node) GetXid() string {
	if m != nil {
		return m.Xid
	}
	return ""
}

func (m *Node) GetAttribute() string {
	if m != nil {
		return m.Attribute
	}
	return ""
}

func (m *Node) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *Node) GetChildren() []*Node {
	if m != nil {
		return m.Children
	}
	return nil
}

type Response struct {
	N            []*Node           `protobuf:"bytes,1,rep,name=n" json:"n,omitempty"`
	L            *Latency          `protobuf:"bytes,2,opt,name=l" json:"l,omitempty"`
	AssignedUids map[string]uint64 `protobuf:"bytes,3,rep,name=AssignedUids" json:"AssignedUids,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorGraphresponse, []int{7} }

func (m *Response) GetN() []*Node {
	if m != nil {
		return m.N
	}
	return nil
}

func (m *Response) GetL() *Latency {
	if m != nil {
		return m.L
	}
	return nil
}

func (m *Response) GetAssignedUids() map[string]uint64 {
	if m != nil {
		return m.AssignedUids
	}
	return nil
}

func init() {
	proto.RegisterType((*NQuad)(nil), "graph.NQuad")
	proto.RegisterType((*Value)(nil), "graph.Value")
	proto.RegisterType((*Mutation)(nil), "graph.Mutation")
	proto.RegisterType((*Request)(nil), "graph.Request")
	proto.RegisterType((*Latency)(nil), "graph.Latency")
	proto.RegisterType((*Property)(nil), "graph.Property")
	proto.RegisterType((*Node)(nil), "graph.Node")
	proto.RegisterType((*Response)(nil), "graph.Response")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Dgraph service

type DgraphClient interface {
	Run(ctx context.Context, in *Request, opts ...grpc.CallOption) (*Response, error)
}

type dgraphClient struct {
	cc *grpc.ClientConn
}

func NewDgraphClient(cc *grpc.ClientConn) DgraphClient {
	return &dgraphClient{cc}
}

func (c *dgraphClient) Run(ctx context.Context, in *Request, opts ...grpc.CallOption) (*Response, error) {
	out := new(Response)
	err := grpc.Invoke(ctx, "/graph.Dgraph/Run", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Dgraph service

type DgraphServer interface {
	Run(context.Context, *Request) (*Response, error)
}

func RegisterDgraphServer(s *grpc.Server, srv DgraphServer) {
	s.RegisterService(&_Dgraph_serviceDesc, srv)
}

func _Dgraph_Run_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DgraphServer).Run(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/graph.Dgraph/Run",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DgraphServer).Run(ctx, req.(*Request))
	}
	return interceptor(ctx, in, info, handler)
}

var _Dgraph_serviceDesc = grpc.ServiceDesc{
	ServiceName: "graph.Dgraph",
	HandlerType: (*DgraphServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Run",
			Handler:    _Dgraph_Run_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "graphresponse.proto",
}

func (m *NQuad) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NQuad) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Subject) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Subject)))
		i += copy(dAtA[i:], m.Subject)
	}
	if len(m.Predicate) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Predicate)))
		i += copy(dAtA[i:], m.Predicate)
	}
	if len(m.ObjectId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.ObjectId)))
		i += copy(dAtA[i:], m.ObjectId)
	}
	if m.ObjectValue != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(m.ObjectValue.Size()))
		n1, err := m.ObjectValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Label) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Label)))
		i += copy(dAtA[i:], m.Label)
	}
	if m.ObjectType != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64((uint32(m.ObjectType)<<1)^uint32((m.ObjectType>>31))))
	}
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Val != nil {
		nn2, err := m.Val.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	return i, nil
}

func (m *Value_BytesVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BytesVal != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.BytesVal)))
		i += copy(dAtA[i:], m.BytesVal)
	}
	return i, nil
}
func (m *Value_IntVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x10
	i++
	i = encodeVarintGraphresponse(dAtA, i, uint64(m.IntVal))
	return i, nil
}
func (m *Value_BoolVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	if m.BoolVal {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *Value_StrVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.StrVal)))
	i += copy(dAtA[i:], m.StrVal)
	return i, nil
}
func (m *Value_DoubleVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x29
	i++
	i = encodeFixed64Graphresponse(dAtA, i, uint64(math.Float64bits(float64(m.DoubleVal))))
	return i, nil
}
func (m *Value_GeoVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.GeoVal != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.GeoVal)))
		i += copy(dAtA[i:], m.GeoVal)
	}
	return i, nil
}
func (m *Value_DateVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DateVal != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.DateVal)))
		i += copy(dAtA[i:], m.DateVal)
	}
	return i, nil
}
func (m *Value_DatetimeVal) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DatetimeVal != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.DatetimeVal)))
		i += copy(dAtA[i:], m.DatetimeVal)
	}
	return i, nil
}
func (m *Mutation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mutation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Set) > 0 {
		for _, msg := range m.Set {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Del) > 0 {
		for _, msg := range m.Del {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Query) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Query)))
		i += copy(dAtA[i:], m.Query)
	}
	if m.Mutation != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(m.Mutation.Size()))
		n3, err := m.Mutation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *Latency) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Latency) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Parsing) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Parsing)))
		i += copy(dAtA[i:], m.Parsing)
	}
	if len(m.Processing) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Processing)))
		i += copy(dAtA[i:], m.Processing)
	}
	if len(m.Pb) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Pb)))
		i += copy(dAtA[i:], m.Pb)
	}
	return i, nil
}

func (m *Property) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Property) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Prop) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Prop)))
		i += copy(dAtA[i:], m.Prop)
	}
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(m.Value.Size()))
		n4, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Uid != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(m.Uid))
	}
	if len(m.Xid) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Xid)))
		i += copy(dAtA[i:], m.Xid)
	}
	if len(m.Attribute) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(len(m.Attribute)))
		i += copy(dAtA[i:], m.Attribute)
	}
	if len(m.Properties) > 0 {
		for _, msg := range m.Properties {
			dAtA[i] = 0x22
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Children) > 0 {
		for _, msg := range m.Children {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.N) > 0 {
		for _, msg := range m.N {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.L != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGraphresponse(dAtA, i, uint64(m.L.Size()))
		n5, err := m.L.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.AssignedUids) > 0 {
		for k, _ := range m.AssignedUids {
			dAtA[i] = 0x1a
			i++
			v := m.AssignedUids[k]
			mapSize := 1 + len(k) + sovGraphresponse(uint64(len(k))) + 1 + sovGraphresponse(uint64(v))
			i = encodeVarintGraphresponse(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintGraphresponse(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func encodeFixed64Graphresponse(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Graphresponse(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintGraphresponse(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *NQuad) Size() (n int) {
	var l int
	_ = l
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	l = len(m.Predicate)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	l = len(m.ObjectId)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	if m.ObjectValue != nil {
		l = m.ObjectValue.Size()
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	if m.ObjectType != 0 {
		n += 1 + sozGraphresponse(uint64(m.ObjectType))
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	if m.Val != nil {
		n += m.Val.Size()
	}
	return n
}

func (m *Value_BytesVal) Size() (n int) {
	var l int
	_ = l
	if m.BytesVal != nil {
		l = len(m.BytesVal)
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}
func (m *Value_IntVal) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovGraphresponse(uint64(m.IntVal))
	return n
}
func (m *Value_BoolVal) Size() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *Value_StrVal) Size() (n int) {
	var l int
	_ = l
	l = len(m.StrVal)
	n += 1 + l + sovGraphresponse(uint64(l))
	return n
}
func (m *Value_DoubleVal) Size() (n int) {
	var l int
	_ = l
	n += 9
	return n
}
func (m *Value_GeoVal) Size() (n int) {
	var l int
	_ = l
	if m.GeoVal != nil {
		l = len(m.GeoVal)
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}
func (m *Value_DateVal) Size() (n int) {
	var l int
	_ = l
	if m.DateVal != nil {
		l = len(m.DateVal)
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}
func (m *Value_DatetimeVal) Size() (n int) {
	var l int
	_ = l
	if m.DatetimeVal != nil {
		l = len(m.DatetimeVal)
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}
func (m *Mutation) Size() (n int) {
	var l int
	_ = l
	if len(m.Set) > 0 {
		for _, e := range m.Set {
			l = e.Size()
			n += 1 + l + sovGraphresponse(uint64(l))
		}
	}
	if len(m.Del) > 0 {
		for _, e := range m.Del {
			l = e.Size()
			n += 1 + l + sovGraphresponse(uint64(l))
		}
	}
	return n
}

func (m *Request) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	if m.Mutation != nil {
		l = m.Mutation.Size()
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}

func (m *Latency) Size() (n int) {
	var l int
	_ = l
	l = len(m.Parsing)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	l = len(m.Processing)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	l = len(m.Pb)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}

func (m *Property) Size() (n int) {
	var l int
	_ = l
	l = len(m.Prop)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	return n
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	if m.Uid != 0 {
		n += 1 + sovGraphresponse(uint64(m.Uid))
	}
	l = len(m.Xid)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	l = len(m.Attribute)
	if l > 0 {
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovGraphresponse(uint64(l))
		}
	}
	if len(m.Children) > 0 {
		for _, e := range m.Children {
			l = e.Size()
			n += 1 + l + sovGraphresponse(uint64(l))
		}
	}
	return n
}

func (m *Response) Size() (n int) {
	var l int
	_ = l
	if len(m.N) > 0 {
		for _, e := range m.N {
			l = e.Size()
			n += 1 + l + sovGraphresponse(uint64(l))
		}
	}
	if m.L != nil {
		l = m.L.Size()
		n += 1 + l + sovGraphresponse(uint64(l))
	}
	if len(m.AssignedUids) > 0 {
		for k, v := range m.AssignedUids {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovGraphresponse(uint64(len(k))) + 1 + sovGraphresponse(uint64(v))
			n += mapEntrySize + 1 + sovGraphresponse(uint64(mapEntrySize))
		}
	}
	return n
}

func sovGraphresponse(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGraphresponse(x uint64) (n int) {
	return sovGraphresponse(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *NQuad) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NQuad: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NQuad: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Predicate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Predicate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ObjectValue == nil {
				m.ObjectValue = &Value{}
			}
			if err := m.ObjectValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectType", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.ObjectType = v
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesVal", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Val = &Value_BytesVal{v}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntVal", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Val = &Value_IntVal{v}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolVal", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Val = &Value_BoolVal{b}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StrVal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Val = &Value_StrVal{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleVal", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Val = &Value_DoubleVal{float64(math.Float64frombits(v))}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GeoVal", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Val = &Value_GeoVal{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DateVal", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Val = &Value_DateVal{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatetimeVal", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Val = &Value_DatetimeVal{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mutation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mutation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mutation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Set = append(m.Set, &NQuad{})
			if err := m.Set[len(m.Set)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Del", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Del = append(m.Del, &NQuad{})
			if err := m.Del[len(m.Del)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Mutation == nil {
				m.Mutation = &Mutation{}
			}
			if err := m.Mutation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Latency) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Latency: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Latency: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parsing", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parsing = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processing", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Processing = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pb", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pb = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Property) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Property: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Property: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prop", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prop = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Node) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uid", wireType)
			}
			m.Uid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uid |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Xid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Xid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attribute", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attribute = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &Property{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Children", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Children = append(m.Children, &Node{})
			if err := m.Children[len(m.Children)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field N", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.N = append(m.N, &Node{})
			if err := m.N[len(m.N)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field L", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.L == nil {
				m.L = &Latency{}
			}
			if err := m.L.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssignedUids", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthGraphresponse
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.AssignedUids == nil {
				m.AssignedUids = make(map[string]uint64)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGraphresponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapvalue uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGraphresponse
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapvalue |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AssignedUids[mapkey] = mapvalue
			} else {
				var mapvalue uint64
				m.AssignedUids[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGraphresponse(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGraphresponse
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGraphresponse(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGraphresponse
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGraphresponse
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGraphresponse
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGraphresponse
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGraphresponse(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGraphresponse = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGraphresponse   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("graphresponse.proto", fileDescriptorGraphresponse) }

var fileDescriptorGraphresponse = []byte{
	// 667 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x6c, 0x54, 0xcd, 0x6e, 0xd3, 0x4a,
	0x14, 0xce, 0x24, 0x71, 0xec, 0x9c, 0x44, 0xfd, 0x99, 0x7b, 0x17, 0x6e, 0x6f, 0x6f, 0x28, 0x66,
	0x41, 0x24, 0xa4, 0x20, 0x85, 0x0d, 0x62, 0x83, 0xa8, 0xa8, 0x14, 0x50, 0xa9, 0x60, 0x80, 0x6e,
	0xd1, 0x38, 0x73, 0x94, 0x1a, 0x5c, 0x8f, 0x3b, 0x33, 0xae, 0xc8, 0x9b, 0xb0, 0xe6, 0x4d, 0xd8,
	0x21, 0xb1, 0xe1, 0x11, 0x50, 0x79, 0x0f, 0x84, 0x66, 0x3c, 0x4e, 0x53, 0xe8, 0xee, 0xcc, 0xf7,
	0x7d, 0x67, 0xe6, 0xfc, 0x7c, 0x36, 0xfc, 0xb3, 0x50, 0xbc, 0x3c, 0x55, 0xa8, 0x4b, 0x59, 0x68,
	0x9c, 0x94, 0x4a, 0x1a, 0x49, 0x03, 0x07, 0x26, 0x5f, 0x08, 0x04, 0xc7, 0xaf, 0x2a, 0x2e, 0x68,
	0x0c, 0xa1, 0xae, 0xd2, 0xf7, 0x38, 0x37, 0x31, 0xd9, 0x27, 0xe3, 0x3e, 0x6b, 0x8e, 0x74, 0x0f,
	0xfa, 0xa5, 0x42, 0x91, 0xcd, 0xb9, 0xc1, 0xb8, 0xed, 0xb8, 0x2b, 0x80, 0xee, 0x42, 0x24, 0x9d,
	0xee, 0x99, 0x88, 0x3b, 0x8e, 0x5c, 0x9d, 0xe9, 0x04, 0x06, 0x75, 0x7c, 0xc2, 0xf3, 0x0a, 0xe3,
	0xee, 0x3e, 0x19, 0x0f, 0xa6, 0xc3, 0x89, 0x7b, 0x7a, 0xe2, 0x30, 0xb6, 0x2e, 0xa0, 0xff, 0x42,
	0x90, 0xf3, 0x14, 0xf3, 0x38, 0x70, 0x17, 0xd5, 0x07, 0x3a, 0x02, 0xa8, 0x45, 0x6f, 0x96, 0x25,
	0xc6, 0xbd, 0x7d, 0x32, 0xde, 0x66, 0x6b, 0x48, 0xf2, 0x8b, 0x40, 0x50, 0xe7, 0xff, 0x0f, 0xfd,
	0x74, 0x69, 0x50, 0xbf, 0xbb, 0xe0, 0xb9, 0xeb, 0x62, 0x38, 0x6b, 0xb1, 0xc8, 0x41, 0x27, 0x3c,
	0xa7, 0x3b, 0x10, 0x66, 0x85, 0x71, 0xa4, 0x6d, 0x23, 0x98, 0xb5, 0x58, 0x2f, 0x2b, 0xec, 0xdb,
	0xf4, 0x3f, 0x88, 0x52, 0x29, 0x73, 0xc7, 0xd9, 0x2e, 0xa2, 0x59, 0x8b, 0x85, 0x16, 0xf1, 0x79,
	0xda, 0x28, 0xc7, 0xd9, 0x16, 0xfa, 0x36, 0x4f, 0x1b, 0x65, 0xa9, 0x5b, 0x00, 0x42, 0x56, 0x69,
	0x8e, 0x8e, 0xb5, 0x65, 0x93, 0x59, 0x8b, 0xf5, 0x6b, 0xcc, 0xe7, 0x2e, 0x50, 0x3a, 0xb6, 0xe7,
	0x0b, 0xea, 0x2d, 0x50, 0xfa, 0x37, 0x05, 0x37, 0x75, 0x66, 0xe8, 0xb9, 0xd0, 0x22, 0x96, 0xbc,
	0x03, 0x43, 0x1b, 0x9a, 0xec, 0xac, 0x16, 0x44, 0x5e, 0x30, 0x68, 0xd0, 0x13, 0x9e, 0x1f, 0x04,
	0xd0, 0xb9, 0xe0, 0x79, 0xf2, 0x1c, 0xa2, 0x17, 0x95, 0xe1, 0x26, 0x93, 0x05, 0x1d, 0x41, 0x47,
	0xa3, 0x5d, 0x61, 0x67, 0x6d, 0xd4, 0x6e, 0xc3, 0xcc, 0x12, 0x96, 0x17, 0x68, 0xfb, 0xbf, 0x81,
	0x17, 0x98, 0x27, 0x47, 0x10, 0x32, 0x3c, 0xaf, 0x50, 0x1b, 0xbb, 0x8d, 0xf3, 0x0a, 0xd5, 0xd2,
	0xfb, 0xa1, 0x3e, 0xd0, 0x7b, 0x10, 0x9d, 0xf9, 0xc7, 0xdc, 0x14, 0x07, 0xd3, 0x4d, 0x7f, 0x4b,
	0x53, 0x03, 0x5b, 0x09, 0x92, 0xd7, 0x10, 0x1e, 0x71, 0x83, 0xc5, 0x7c, 0x69, 0xfd, 0x55, 0x72,
	0xa5, 0xb3, 0x62, 0xd1, 0xf8, 0xcb, 0x1f, 0xed, 0x7e, 0x4b, 0x25, 0xe7, 0xa8, 0x1d, 0x59, 0x1b,
	0x6c, 0x0d, 0xa1, 0x1b, 0xd0, 0x2e, 0x53, 0xef, 0xad, 0x76, 0x99, 0x26, 0x07, 0x10, 0xbd, 0x54,
	0xb2, 0x44, 0x65, 0x96, 0x94, 0x42, 0xb7, 0x54, 0xb2, 0xf4, 0x57, 0xba, 0x98, 0x26, 0x10, 0x5c,
	0x38, 0xbf, 0xb5, 0x6f, 0xf0, 0x5b, 0x4d, 0x25, 0x9f, 0x09, 0x74, 0x8f, 0xa5, 0x40, 0xba, 0x05,
	0x9d, 0x2a, 0x13, 0x2e, 0xbf, 0xcb, 0x6c, 0x68, 0x91, 0x8f, 0x99, 0xf0, 0x75, 0xd8, 0xd0, 0x7e,
	0x00, 0xdc, 0x18, 0x95, 0xa5, 0x95, 0x41, 0x5f, 0xc7, 0x15, 0x40, 0xef, 0xbb, 0xf2, 0x6d, 0x39,
	0x19, 0xea, 0xb8, 0xeb, 0x06, 0xdb, 0x8c, 0xa4, 0xa9, 0x93, 0xad, 0x49, 0xe8, 0x5d, 0x88, 0xe6,
	0xa7, 0x59, 0x2e, 0x14, 0x16, 0x71, 0xe0, 0xe4, 0x83, 0x66, 0x0f, 0x52, 0x20, 0x5b, 0x91, 0xc9,
	0x37, 0x02, 0x11, 0xf3, 0x9f, 0x2d, 0xdd, 0x01, 0x52, 0xf8, 0xb5, 0x5e, 0x93, 0x93, 0x82, 0xee,
	0x01, 0xc9, 0x7d, 0xb3, 0x1b, 0x9e, 0xf2, 0x53, 0x67, 0x24, 0xa7, 0x87, 0x30, 0x7c, 0xa2, 0x75,
	0xb6, 0x28, 0x50, 0xbc, 0xcd, 0x84, 0x8e, 0x3b, 0xee, 0x8e, 0xdb, 0x5e, 0xd8, 0xdc, 0x3f, 0x59,
	0xd7, 0x1c, 0x16, 0x46, 0x2d, 0xd9, 0xb5, 0xb4, 0xdd, 0xc7, 0xb0, 0xfd, 0x97, 0xc4, 0xce, 0xea,
	0x03, 0x36, 0x06, 0xb1, 0xa1, 0x35, 0xcd, 0xd5, 0xf0, 0xbb, 0x7e, 0xdc, 0x8f, 0xda, 0x0f, 0xc9,
	0x74, 0x0a, 0xbd, 0xa7, 0xee, 0x4d, 0x3a, 0x86, 0x0e, 0xab, 0x0a, 0xba, 0xb1, 0x2a, 0xc1, 0xf9,
	0x6d, 0x77, 0xf3, 0x8f, 0x92, 0x92, 0xd6, 0xc1, 0xd6, 0xd7, 0xcb, 0x11, 0xf9, 0x7e, 0x39, 0x22,
	0x3f, 0x2e, 0x47, 0xe4, 0xd3, 0xcf, 0x51, 0x2b, 0xed, 0xb9, 0xdf, 0xd7, 0x83, 0xdf, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xfe, 0xbc, 0xab, 0x6a, 0xd5, 0x04, 0x00, 0x00,
}
