// Code generated by protoc-gen-gogo.
// source: task.proto
// DO NOT EDIT!

/*
	Package task is a generated protocol buffer package.

	It is generated from these files:
		task.proto

	It has these top-level messages:
		List
		Value
		Query
		Result
		Sort
		SortResult
		Num
		RaftContext
		Membership
		MembershipUpdate
		DirectedEdge
		Mutations
		RebuildIndex
		Proposal
		KV
		KC
		GroupKeys
*/
package task

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type DirectedEdge_Op int32

const (
	DirectedEdge_SET DirectedEdge_Op = 0
	DirectedEdge_DEL DirectedEdge_Op = 1
)

var DirectedEdge_Op_name = map[int32]string{
	0: "SET",
	1: "DEL",
}
var DirectedEdge_Op_value = map[string]int32{
	"SET": 0,
	"DEL": 1,
}

func (x DirectedEdge_Op) String() string {
	return proto.EnumName(DirectedEdge_Op_name, int32(x))
}
func (DirectedEdge_Op) EnumDescriptor() ([]byte, []int) { return fileDescriptorTask, []int{10, 0} }

type List struct {
	Uids []uint64 `protobuf:"fixed64,1,rep,packed,name=uids" json:"uids,omitempty"`
}

func (m *List) Reset()                    { *m = List{} }
func (m *List) String() string            { return proto.CompactTextString(m) }
func (*List) ProtoMessage()               {}
func (*List) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{0} }

func (m *List) GetUids() []uint64 {
	if m != nil {
		return m.Uids
	}
	return nil
}

type Value struct {
	Val     []byte `protobuf:"bytes,1,opt,name=val,proto3" json:"val,omitempty"`
	ValType int32  `protobuf:"varint,2,opt,name=val_type,json=valType,proto3" json:"val_type,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{1} }

func (m *Value) GetVal() []byte {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *Value) GetValType() int32 {
	if m != nil {
		return m.ValType
	}
	return 0
}

type Query struct {
	Attr     string `protobuf:"bytes,1,opt,name=attr,proto3" json:"attr,omitempty"`
	Count    int32  `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	Offset   int32  `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	AfterUid uint64 `protobuf:"fixed64,4,opt,name=after_uid,json=afterUid,proto3" json:"after_uid,omitempty"`
	DoCount  bool   `protobuf:"varint,5,opt,name=do_count,json=doCount,proto3" json:"do_count,omitempty"`
	// Exactly one of uids and terms is populated.
	Uids []uint64 `protobuf:"fixed64,6,rep,packed,name=uids" json:"uids,omitempty"`
	// Function to generate or filter UIDs.
	SrcFunc []string `protobuf:"bytes,7,rep,name=src_func,json=srcFunc" json:"src_func,omitempty"`
	Reverse bool     `protobuf:"varint,8,opt,name=reverse,proto3" json:"reverse,omitempty"`
}

func (m *Query) Reset()                    { *m = Query{} }
func (m *Query) String() string            { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()               {}
func (*Query) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{2} }

func (m *Query) GetAttr() string {
	if m != nil {
		return m.Attr
	}
	return ""
}

func (m *Query) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Query) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Query) GetAfterUid() uint64 {
	if m != nil {
		return m.AfterUid
	}
	return 0
}

func (m *Query) GetDoCount() bool {
	if m != nil {
		return m.DoCount
	}
	return false
}

func (m *Query) GetUids() []uint64 {
	if m != nil {
		return m.Uids
	}
	return nil
}

func (m *Query) GetSrcFunc() []string {
	if m != nil {
		return m.SrcFunc
	}
	return nil
}

func (m *Query) GetReverse() bool {
	if m != nil {
		return m.Reverse
	}
	return false
}

type Result struct {
	UidMatrix     []*List  `protobuf:"bytes,1,rep,name=uid_matrix,json=uidMatrix" json:"uid_matrix,omitempty"`
	Values        []*Value `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
	Counts        []uint32 `protobuf:"varint,3,rep,packed,name=counts" json:"counts,omitempty"`
	IntersectDest bool     `protobuf:"varint,4,opt,name=intersect_dest,json=intersectDest,proto3" json:"intersect_dest,omitempty"`
}

func (m *Result) Reset()                    { *m = Result{} }
func (m *Result) String() string            { return proto.CompactTextString(m) }
func (*Result) ProtoMessage()               {}
func (*Result) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{3} }

func (m *Result) GetUidMatrix() []*List {
	if m != nil {
		return m.UidMatrix
	}
	return nil
}

func (m *Result) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Result) GetCounts() []uint32 {
	if m != nil {
		return m.Counts
	}
	return nil
}

func (m *Result) GetIntersectDest() bool {
	if m != nil {
		return m.IntersectDest
	}
	return false
}

type Sort struct {
	Attr      string  `protobuf:"bytes,1,opt,name=attr,proto3" json:"attr,omitempty"`
	UidMatrix []*List `protobuf:"bytes,2,rep,name=uid_matrix,json=uidMatrix" json:"uid_matrix,omitempty"`
	Count     int32   `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
	Offset    int32   `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	Desc      bool    `protobuf:"varint,5,opt,name=desc,proto3" json:"desc,omitempty"`
}

func (m *Sort) Reset()                    { *m = Sort{} }
func (m *Sort) String() string            { return proto.CompactTextString(m) }
func (*Sort) ProtoMessage()               {}
func (*Sort) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{4} }

func (m *Sort) GetAttr() string {
	if m != nil {
		return m.Attr
	}
	return ""
}

func (m *Sort) GetUidMatrix() []*List {
	if m != nil {
		return m.UidMatrix
	}
	return nil
}

func (m *Sort) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Sort) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Sort) GetDesc() bool {
	if m != nil {
		return m.Desc
	}
	return false
}

type SortResult struct {
	UidMatrix []*List `protobuf:"bytes,1,rep,name=uid_matrix,json=uidMatrix" json:"uid_matrix,omitempty"`
}

func (m *SortResult) Reset()                    { *m = SortResult{} }
func (m *SortResult) String() string            { return proto.CompactTextString(m) }
func (*SortResult) ProtoMessage()               {}
func (*SortResult) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{5} }

func (m *SortResult) GetUidMatrix() []*List {
	if m != nil {
		return m.UidMatrix
	}
	return nil
}

type Num struct {
	Group uint32   `protobuf:"varint,1,opt,name=group,proto3" json:"group,omitempty"`
	Val   int64    `protobuf:"varint,2,opt,name=val,proto3" json:"val,omitempty"`
	Uids  []uint64 `protobuf:"varint,3,rep,packed,name=uids" json:"uids,omitempty"`
}

func (m *Num) Reset()                    { *m = Num{} }
func (m *Num) String() string            { return proto.CompactTextString(m) }
func (*Num) ProtoMessage()               {}
func (*Num) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{6} }

func (m *Num) GetGroup() uint32 {
	if m != nil {
		return m.Group
	}
	return 0
}

func (m *Num) GetVal() int64 {
	if m != nil {
		return m.Val
	}
	return 0
}

func (m *Num) GetUids() []uint64 {
	if m != nil {
		return m.Uids
	}
	return nil
}

type RaftContext struct {
	Id    uint64 `protobuf:"fixed64,1,opt,name=id,proto3" json:"id,omitempty"`
	Group uint32 `protobuf:"varint,2,opt,name=group,proto3" json:"group,omitempty"`
	Addr  string `protobuf:"bytes,3,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *RaftContext) Reset()                    { *m = RaftContext{} }
func (m *RaftContext) String() string            { return proto.CompactTextString(m) }
func (*RaftContext) ProtoMessage()               {}
func (*RaftContext) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{7} }

func (m *RaftContext) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *RaftContext) GetGroup() uint32 {
	if m != nil {
		return m.Group
	}
	return 0
}

func (m *RaftContext) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

// Membership stores information about RAFT group membership for a single RAFT node.
// Note that each server can be serving multiple RAFT groups. Each group would have
// one RAFT node per server serving that group.
type Membership struct {
	Id         uint64 `protobuf:"fixed64,1,opt,name=id,proto3" json:"id,omitempty"`
	GroupId    uint32 `protobuf:"varint,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Addr       string `protobuf:"bytes,3,opt,name=addr,proto3" json:"addr,omitempty"`
	Leader     bool   `protobuf:"varint,4,opt,name=leader,proto3" json:"leader,omitempty"`
	AmDead     bool   `protobuf:"varint,5,opt,name=am_dead,json=amDead,proto3" json:"am_dead,omitempty"`
	LastUpdate uint64 `protobuf:"varint,6,opt,name=last_update,json=lastUpdate,proto3" json:"last_update,omitempty"`
}

func (m *Membership) Reset()                    { *m = Membership{} }
func (m *Membership) String() string            { return proto.CompactTextString(m) }
func (*Membership) ProtoMessage()               {}
func (*Membership) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{8} }

func (m *Membership) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Membership) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *Membership) GetAddr() string {
	if m != nil {
		return m.Addr
	}
	return ""
}

func (m *Membership) GetLeader() bool {
	if m != nil {
		return m.Leader
	}
	return false
}

func (m *Membership) GetAmDead() bool {
	if m != nil {
		return m.AmDead
	}
	return false
}

func (m *Membership) GetLastUpdate() uint64 {
	if m != nil {
		return m.LastUpdate
	}
	return 0
}

// MembershipUpdate is used to pack together the current membership state of all the nodes
// in the caller server; and the membership updates recorded by the callee server since
// the provided lastUpdate.
type MembershipUpdate struct {
	Members      []*Membership `protobuf:"bytes,1,rep,name=members" json:"members,omitempty"`
	LastUpdate   uint64        `protobuf:"varint,2,opt,name=last_update,json=lastUpdate,proto3" json:"last_update,omitempty"`
	Redirect     bool          `protobuf:"varint,3,opt,name=redirect,proto3" json:"redirect,omitempty"`
	RedirectAddr string        `protobuf:"bytes,4,opt,name=redirect_addr,json=redirectAddr,proto3" json:"redirect_addr,omitempty"`
}

func (m *MembershipUpdate) Reset()                    { *m = MembershipUpdate{} }
func (m *MembershipUpdate) String() string            { return proto.CompactTextString(m) }
func (*MembershipUpdate) ProtoMessage()               {}
func (*MembershipUpdate) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{9} }

func (m *MembershipUpdate) GetMembers() []*Membership {
	if m != nil {
		return m.Members
	}
	return nil
}

func (m *MembershipUpdate) GetLastUpdate() uint64 {
	if m != nil {
		return m.LastUpdate
	}
	return 0
}

func (m *MembershipUpdate) GetRedirect() bool {
	if m != nil {
		return m.Redirect
	}
	return false
}

func (m *MembershipUpdate) GetRedirectAddr() string {
	if m != nil {
		return m.RedirectAddr
	}
	return ""
}

type DirectedEdge struct {
	Entity    uint64          `protobuf:"fixed64,1,opt,name=entity,proto3" json:"entity,omitempty"`
	Attr      string          `protobuf:"bytes,2,opt,name=attr,proto3" json:"attr,omitempty"`
	Value     []byte          `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	ValueType uint32          `protobuf:"varint,4,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
	ValueId   uint64          `protobuf:"fixed64,5,opt,name=value_id,json=valueId,proto3" json:"value_id,omitempty"`
	Label     string          `protobuf:"bytes,6,opt,name=label,proto3" json:"label,omitempty"`
	Op        DirectedEdge_Op `protobuf:"varint,7,opt,name=op,proto3,enum=task.DirectedEdge_Op" json:"op,omitempty"`
}

func (m *DirectedEdge) Reset()                    { *m = DirectedEdge{} }
func (m *DirectedEdge) String() string            { return proto.CompactTextString(m) }
func (*DirectedEdge) ProtoMessage()               {}
func (*DirectedEdge) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{10} }

func (m *DirectedEdge) GetEntity() uint64 {
	if m != nil {
		return m.Entity
	}
	return 0
}

func (m *DirectedEdge) GetAttr() string {
	if m != nil {
		return m.Attr
	}
	return ""
}

func (m *DirectedEdge) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *DirectedEdge) GetValueType() uint32 {
	if m != nil {
		return m.ValueType
	}
	return 0
}

func (m *DirectedEdge) GetValueId() uint64 {
	if m != nil {
		return m.ValueId
	}
	return 0
}

func (m *DirectedEdge) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *DirectedEdge) GetOp() DirectedEdge_Op {
	if m != nil {
		return m.Op
	}
	return DirectedEdge_SET
}

type Mutations struct {
	GroupId uint32          `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Edges   []*DirectedEdge `protobuf:"bytes,2,rep,name=edges" json:"edges,omitempty"`
}

func (m *Mutations) Reset()                    { *m = Mutations{} }
func (m *Mutations) String() string            { return proto.CompactTextString(m) }
func (*Mutations) ProtoMessage()               {}
func (*Mutations) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{11} }

func (m *Mutations) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *Mutations) GetEdges() []*DirectedEdge {
	if m != nil {
		return m.Edges
	}
	return nil
}

type RebuildIndex struct {
	GroupId uint32 `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Attr    string `protobuf:"bytes,2,opt,name=attr,proto3" json:"attr,omitempty"`
}

func (m *RebuildIndex) Reset()                    { *m = RebuildIndex{} }
func (m *RebuildIndex) String() string            { return proto.CompactTextString(m) }
func (*RebuildIndex) ProtoMessage()               {}
func (*RebuildIndex) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{12} }

func (m *RebuildIndex) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *RebuildIndex) GetAttr() string {
	if m != nil {
		return m.Attr
	}
	return ""
}

type Proposal struct {
	Id           uint32        `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Mutations    *Mutations    `protobuf:"bytes,2,opt,name=mutations" json:"mutations,omitempty"`
	Membership   *Membership   `protobuf:"bytes,3,opt,name=membership" json:"membership,omitempty"`
	RebuildIndex *RebuildIndex `protobuf:"bytes,4,opt,name=rebuild_index,json=rebuildIndex" json:"rebuild_index,omitempty"`
}

func (m *Proposal) Reset()                    { *m = Proposal{} }
func (m *Proposal) String() string            { return proto.CompactTextString(m) }
func (*Proposal) ProtoMessage()               {}
func (*Proposal) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{13} }

func (m *Proposal) GetId() uint32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Proposal) GetMutations() *Mutations {
	if m != nil {
		return m.Mutations
	}
	return nil
}

func (m *Proposal) GetMembership() *Membership {
	if m != nil {
		return m.Membership
	}
	return nil
}

func (m *Proposal) GetRebuildIndex() *RebuildIndex {
	if m != nil {
		return m.RebuildIndex
	}
	return nil
}

type KV struct {
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Val []byte `protobuf:"bytes,2,opt,name=val,proto3" json:"val,omitempty"`
}

func (m *KV) Reset()                    { *m = KV{} }
func (m *KV) String() string            { return proto.CompactTextString(m) }
func (*KV) ProtoMessage()               {}
func (*KV) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{14} }

func (m *KV) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *KV) GetVal() []byte {
	if m != nil {
		return m.Val
	}
	return nil
}

type KC struct {
	Key      []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Checksum []byte `protobuf:"bytes,2,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (m *KC) Reset()                    { *m = KC{} }
func (m *KC) String() string            { return proto.CompactTextString(m) }
func (*KC) ProtoMessage()               {}
func (*KC) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{15} }

func (m *KC) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *KC) GetChecksum() []byte {
	if m != nil {
		return m.Checksum
	}
	return nil
}

type GroupKeys struct {
	GroupId uint32 `protobuf:"varint,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Keys    []*KC  `protobuf:"bytes,2,rep,name=keys" json:"keys,omitempty"`
}

func (m *GroupKeys) Reset()                    { *m = GroupKeys{} }
func (m *GroupKeys) String() string            { return proto.CompactTextString(m) }
func (*GroupKeys) ProtoMessage()               {}
func (*GroupKeys) Descriptor() ([]byte, []int) { return fileDescriptorTask, []int{16} }

func (m *GroupKeys) GetGroupId() uint32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *GroupKeys) GetKeys() []*KC {
	if m != nil {
		return m.Keys
	}
	return nil
}

func init() {
	proto.RegisterType((*List)(nil), "task.List")
	proto.RegisterType((*Value)(nil), "task.Value")
	proto.RegisterType((*Query)(nil), "task.Query")
	proto.RegisterType((*Result)(nil), "task.Result")
	proto.RegisterType((*Sort)(nil), "task.Sort")
	proto.RegisterType((*SortResult)(nil), "task.SortResult")
	proto.RegisterType((*Num)(nil), "task.Num")
	proto.RegisterType((*RaftContext)(nil), "task.RaftContext")
	proto.RegisterType((*Membership)(nil), "task.Membership")
	proto.RegisterType((*MembershipUpdate)(nil), "task.MembershipUpdate")
	proto.RegisterType((*DirectedEdge)(nil), "task.DirectedEdge")
	proto.RegisterType((*Mutations)(nil), "task.Mutations")
	proto.RegisterType((*RebuildIndex)(nil), "task.RebuildIndex")
	proto.RegisterType((*Proposal)(nil), "task.Proposal")
	proto.RegisterType((*KV)(nil), "task.KV")
	proto.RegisterType((*KC)(nil), "task.KC")
	proto.RegisterType((*GroupKeys)(nil), "task.GroupKeys")
	proto.RegisterEnum("task.DirectedEdge_Op", DirectedEdge_Op_name, DirectedEdge_Op_value)
}
func (m *List) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *List) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Uids) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Uids)*8))
		for _, num := range m.Uids {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Val) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Val)))
		i += copy(dAtA[i:], m.Val)
	}
	if m.ValType != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.ValType))
	}
	return i, nil
}

func (m *Query) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Query) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attr) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Attr)))
		i += copy(dAtA[i:], m.Attr)
	}
	if m.Count != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Count))
	}
	if m.Offset != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Offset))
	}
	if m.AfterUid != 0 {
		dAtA[i] = 0x21
		i++
		i = encodeFixed64Task(dAtA, i, uint64(m.AfterUid))
	}
	if m.DoCount {
		dAtA[i] = 0x28
		i++
		if m.DoCount {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Uids) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Uids)*8))
		for _, num := range m.Uids {
			dAtA[i] = uint8(num)
			i++
			dAtA[i] = uint8(num >> 8)
			i++
			dAtA[i] = uint8(num >> 16)
			i++
			dAtA[i] = uint8(num >> 24)
			i++
			dAtA[i] = uint8(num >> 32)
			i++
			dAtA[i] = uint8(num >> 40)
			i++
			dAtA[i] = uint8(num >> 48)
			i++
			dAtA[i] = uint8(num >> 56)
			i++
		}
	}
	if len(m.SrcFunc) > 0 {
		for _, s := range m.SrcFunc {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.Reverse {
		dAtA[i] = 0x40
		i++
		if m.Reverse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Result) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UidMatrix) > 0 {
		for _, msg := range m.UidMatrix {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Values) > 0 {
		for _, msg := range m.Values {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Counts) > 0 {
		dAtA2 := make([]byte, len(m.Counts)*10)
		var j1 int
		for _, num := range m.Counts {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTask(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	if m.IntersectDest {
		dAtA[i] = 0x20
		i++
		if m.IntersectDest {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Sort) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sort) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attr) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Attr)))
		i += copy(dAtA[i:], m.Attr)
	}
	if len(m.UidMatrix) > 0 {
		for _, msg := range m.UidMatrix {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Count != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Count))
	}
	if m.Offset != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Offset))
	}
	if m.Desc {
		dAtA[i] = 0x28
		i++
		if m.Desc {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SortResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SortResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UidMatrix) > 0 {
		for _, msg := range m.UidMatrix {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Num) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Num) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Group != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Group))
	}
	if m.Val != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Val))
	}
	if len(m.Uids) > 0 {
		dAtA4 := make([]byte, len(m.Uids)*10)
		var j3 int
		for _, num := range m.Uids {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTask(dAtA, i, uint64(j3))
		i += copy(dAtA[i:], dAtA4[:j3])
	}
	return i, nil
}

func (m *RaftContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Task(dAtA, i, uint64(m.Id))
	}
	if m.Group != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Group))
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	return i, nil
}

func (m *Membership) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Membership) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Task(dAtA, i, uint64(m.Id))
	}
	if m.GroupId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.GroupId))
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	if m.Leader {
		dAtA[i] = 0x20
		i++
		if m.Leader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.AmDead {
		dAtA[i] = 0x28
		i++
		if m.AmDead {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LastUpdate != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.LastUpdate))
	}
	return i, nil
}

func (m *MembershipUpdate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MembershipUpdate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Members) > 0 {
		for _, msg := range m.Members {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LastUpdate != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.LastUpdate))
	}
	if m.Redirect {
		dAtA[i] = 0x18
		i++
		if m.Redirect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.RedirectAddr) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.RedirectAddr)))
		i += copy(dAtA[i:], m.RedirectAddr)
	}
	return i, nil
}

func (m *DirectedEdge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DirectedEdge) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Entity != 0 {
		dAtA[i] = 0x9
		i++
		i = encodeFixed64Task(dAtA, i, uint64(m.Entity))
	}
	if len(m.Attr) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Attr)))
		i += copy(dAtA[i:], m.Attr)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.ValueType != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.ValueType))
	}
	if m.ValueId != 0 {
		dAtA[i] = 0x29
		i++
		i = encodeFixed64Task(dAtA, i, uint64(m.ValueId))
	}
	if len(m.Label) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Label)))
		i += copy(dAtA[i:], m.Label)
	}
	if m.Op != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Op))
	}
	return i, nil
}

func (m *Mutations) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mutations) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GroupId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.GroupId))
	}
	if len(m.Edges) > 0 {
		for _, msg := range m.Edges {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RebuildIndex) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RebuildIndex) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GroupId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.GroupId))
	}
	if len(m.Attr) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Attr)))
		i += copy(dAtA[i:], m.Attr)
	}
	return i, nil
}

func (m *Proposal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Proposal) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Id))
	}
	if m.Mutations != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Mutations.Size()))
		n5, err := m.Mutations.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Membership != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.Membership.Size()))
		n6, err := m.Membership.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.RebuildIndex != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.RebuildIndex.Size()))
		n7, err := m.RebuildIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *KV) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KV) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Val) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Val)))
		i += copy(dAtA[i:], m.Val)
	}
	return i, nil
}

func (m *KC) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KC) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Checksum) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTask(dAtA, i, uint64(len(m.Checksum)))
		i += copy(dAtA[i:], m.Checksum)
	}
	return i, nil
}

func (m *GroupKeys) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupKeys) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.GroupId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTask(dAtA, i, uint64(m.GroupId))
	}
	if len(m.Keys) > 0 {
		for _, msg := range m.Keys {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTask(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Task(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Task(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintTask(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *List) Size() (n int) {
	var l int
	_ = l
	if len(m.Uids) > 0 {
		n += 1 + sovTask(uint64(len(m.Uids)*8)) + len(m.Uids)*8
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	l = len(m.Val)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	if m.ValType != 0 {
		n += 1 + sovTask(uint64(m.ValType))
	}
	return n
}

func (m *Query) Size() (n int) {
	var l int
	_ = l
	l = len(m.Attr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	if m.Count != 0 {
		n += 1 + sovTask(uint64(m.Count))
	}
	if m.Offset != 0 {
		n += 1 + sovTask(uint64(m.Offset))
	}
	if m.AfterUid != 0 {
		n += 9
	}
	if m.DoCount {
		n += 2
	}
	if len(m.Uids) > 0 {
		n += 1 + sovTask(uint64(len(m.Uids)*8)) + len(m.Uids)*8
	}
	if len(m.SrcFunc) > 0 {
		for _, s := range m.SrcFunc {
			l = len(s)
			n += 1 + l + sovTask(uint64(l))
		}
	}
	if m.Reverse {
		n += 2
	}
	return n
}

func (m *Result) Size() (n int) {
	var l int
	_ = l
	if len(m.UidMatrix) > 0 {
		for _, e := range m.UidMatrix {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	if len(m.Counts) > 0 {
		l = 0
		for _, e := range m.Counts {
			l += sovTask(uint64(e))
		}
		n += 1 + sovTask(uint64(l)) + l
	}
	if m.IntersectDest {
		n += 2
	}
	return n
}

func (m *Sort) Size() (n int) {
	var l int
	_ = l
	l = len(m.Attr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	if len(m.UidMatrix) > 0 {
		for _, e := range m.UidMatrix {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	if m.Count != 0 {
		n += 1 + sovTask(uint64(m.Count))
	}
	if m.Offset != 0 {
		n += 1 + sovTask(uint64(m.Offset))
	}
	if m.Desc {
		n += 2
	}
	return n
}

func (m *SortResult) Size() (n int) {
	var l int
	_ = l
	if len(m.UidMatrix) > 0 {
		for _, e := range m.UidMatrix {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	return n
}

func (m *Num) Size() (n int) {
	var l int
	_ = l
	if m.Group != 0 {
		n += 1 + sovTask(uint64(m.Group))
	}
	if m.Val != 0 {
		n += 1 + sovTask(uint64(m.Val))
	}
	if len(m.Uids) > 0 {
		l = 0
		for _, e := range m.Uids {
			l += sovTask(uint64(e))
		}
		n += 1 + sovTask(uint64(l)) + l
	}
	return n
}

func (m *RaftContext) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 9
	}
	if m.Group != 0 {
		n += 1 + sovTask(uint64(m.Group))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	return n
}

func (m *Membership) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 9
	}
	if m.GroupId != 0 {
		n += 1 + sovTask(uint64(m.GroupId))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	if m.Leader {
		n += 2
	}
	if m.AmDead {
		n += 2
	}
	if m.LastUpdate != 0 {
		n += 1 + sovTask(uint64(m.LastUpdate))
	}
	return n
}

func (m *MembershipUpdate) Size() (n int) {
	var l int
	_ = l
	if len(m.Members) > 0 {
		for _, e := range m.Members {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	if m.LastUpdate != 0 {
		n += 1 + sovTask(uint64(m.LastUpdate))
	}
	if m.Redirect {
		n += 2
	}
	l = len(m.RedirectAddr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	return n
}

func (m *DirectedEdge) Size() (n int) {
	var l int
	_ = l
	if m.Entity != 0 {
		n += 9
	}
	l = len(m.Attr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	if m.ValueType != 0 {
		n += 1 + sovTask(uint64(m.ValueType))
	}
	if m.ValueId != 0 {
		n += 9
	}
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	if m.Op != 0 {
		n += 1 + sovTask(uint64(m.Op))
	}
	return n
}

func (m *Mutations) Size() (n int) {
	var l int
	_ = l
	if m.GroupId != 0 {
		n += 1 + sovTask(uint64(m.GroupId))
	}
	if len(m.Edges) > 0 {
		for _, e := range m.Edges {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	return n
}

func (m *RebuildIndex) Size() (n int) {
	var l int
	_ = l
	if m.GroupId != 0 {
		n += 1 + sovTask(uint64(m.GroupId))
	}
	l = len(m.Attr)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	return n
}

func (m *Proposal) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovTask(uint64(m.Id))
	}
	if m.Mutations != nil {
		l = m.Mutations.Size()
		n += 1 + l + sovTask(uint64(l))
	}
	if m.Membership != nil {
		l = m.Membership.Size()
		n += 1 + l + sovTask(uint64(l))
	}
	if m.RebuildIndex != nil {
		l = m.RebuildIndex.Size()
		n += 1 + l + sovTask(uint64(l))
	}
	return n
}

func (m *KV) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	l = len(m.Val)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	return n
}

func (m *KC) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	l = len(m.Checksum)
	if l > 0 {
		n += 1 + l + sovTask(uint64(l))
	}
	return n
}

func (m *GroupKeys) Size() (n int) {
	var l int
	_ = l
	if m.GroupId != 0 {
		n += 1 + sovTask(uint64(m.GroupId))
	}
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovTask(uint64(l))
		}
	}
	return n
}

func sovTask(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTask(x uint64) (n int) {
	return sovTask(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *List) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: List: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: List: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTask
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthTask
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = uint64(dAtA[iNdEx-8])
					v |= uint64(dAtA[iNdEx-7]) << 8
					v |= uint64(dAtA[iNdEx-6]) << 16
					v |= uint64(dAtA[iNdEx-5]) << 24
					v |= uint64(dAtA[iNdEx-4]) << 32
					v |= uint64(dAtA[iNdEx-3]) << 40
					v |= uint64(dAtA[iNdEx-2]) << 48
					v |= uint64(dAtA[iNdEx-1]) << 56
					m.Uids = append(m.Uids, v)
				}
			} else if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = uint64(dAtA[iNdEx-8])
				v |= uint64(dAtA[iNdEx-7]) << 8
				v |= uint64(dAtA[iNdEx-6]) << 16
				v |= uint64(dAtA[iNdEx-5]) << 24
				v |= uint64(dAtA[iNdEx-4]) << 32
				v |= uint64(dAtA[iNdEx-3]) << 40
				v |= uint64(dAtA[iNdEx-2]) << 48
				v |= uint64(dAtA[iNdEx-1]) << 56
				m.Uids = append(m.Uids, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Uids", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Val", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Val = append(m.Val[:0], dAtA[iNdEx:postIndex]...)
			if m.Val == nil {
				m.Val = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValType", wireType)
			}
			m.ValType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValType |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Query) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Query: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Query: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AfterUid", wireType)
			}
			m.AfterUid = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.AfterUid = uint64(dAtA[iNdEx-8])
			m.AfterUid |= uint64(dAtA[iNdEx-7]) << 8
			m.AfterUid |= uint64(dAtA[iNdEx-6]) << 16
			m.AfterUid |= uint64(dAtA[iNdEx-5]) << 24
			m.AfterUid |= uint64(dAtA[iNdEx-4]) << 32
			m.AfterUid |= uint64(dAtA[iNdEx-3]) << 40
			m.AfterUid |= uint64(dAtA[iNdEx-2]) << 48
			m.AfterUid |= uint64(dAtA[iNdEx-1]) << 56
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoCount", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DoCount = bool(v != 0)
		case 6:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTask
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthTask
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = uint64(dAtA[iNdEx-8])
					v |= uint64(dAtA[iNdEx-7]) << 8
					v |= uint64(dAtA[iNdEx-6]) << 16
					v |= uint64(dAtA[iNdEx-5]) << 24
					v |= uint64(dAtA[iNdEx-4]) << 32
					v |= uint64(dAtA[iNdEx-3]) << 40
					v |= uint64(dAtA[iNdEx-2]) << 48
					v |= uint64(dAtA[iNdEx-1]) << 56
					m.Uids = append(m.Uids, v)
				}
			} else if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = uint64(dAtA[iNdEx-8])
				v |= uint64(dAtA[iNdEx-7]) << 8
				v |= uint64(dAtA[iNdEx-6]) << 16
				v |= uint64(dAtA[iNdEx-5]) << 24
				v |= uint64(dAtA[iNdEx-4]) << 32
				v |= uint64(dAtA[iNdEx-3]) << 40
				v |= uint64(dAtA[iNdEx-2]) << 48
				v |= uint64(dAtA[iNdEx-1]) << 56
				m.Uids = append(m.Uids, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Uids", wireType)
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SrcFunc", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SrcFunc = append(m.SrcFunc, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UidMatrix", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UidMatrix = append(m.UidMatrix, &List{})
			if err := m.UidMatrix[len(m.UidMatrix)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &Value{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTask
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthTask
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTask
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Counts = append(m.Counts, v)
				}
			} else if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTask
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Counts = append(m.Counts, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Counts", wireType)
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntersectDest", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntersectDest = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sort) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sort: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sort: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UidMatrix", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UidMatrix = append(m.UidMatrix, &List{})
			if err := m.UidMatrix[len(m.UidMatrix)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Desc = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SortResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SortResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SortResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UidMatrix", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UidMatrix = append(m.UidMatrix, &List{})
			if err := m.UidMatrix[len(m.UidMatrix)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Num) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Num: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Num: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			m.Group = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Group |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Val", wireType)
			}
			m.Val = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Val |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTask
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthTask
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTask
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Uids = append(m.Uids, v)
				}
			} else if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTask
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Uids = append(m.Uids, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Uids", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.Id = uint64(dAtA[iNdEx-8])
			m.Id |= uint64(dAtA[iNdEx-7]) << 8
			m.Id |= uint64(dAtA[iNdEx-6]) << 16
			m.Id |= uint64(dAtA[iNdEx-5]) << 24
			m.Id |= uint64(dAtA[iNdEx-4]) << 32
			m.Id |= uint64(dAtA[iNdEx-3]) << 40
			m.Id |= uint64(dAtA[iNdEx-2]) << 48
			m.Id |= uint64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Group", wireType)
			}
			m.Group = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Group |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Membership) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Membership: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Membership: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.Id = uint64(dAtA[iNdEx-8])
			m.Id |= uint64(dAtA[iNdEx-7]) << 8
			m.Id |= uint64(dAtA[iNdEx-6]) << 16
			m.Id |= uint64(dAtA[iNdEx-5]) << 24
			m.Id |= uint64(dAtA[iNdEx-4]) << 32
			m.Id |= uint64(dAtA[iNdEx-3]) << 40
			m.Id |= uint64(dAtA[iNdEx-2]) << 48
			m.Id |= uint64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leader = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AmDead", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AmDead = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdate", wireType)
			}
			m.LastUpdate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastUpdate |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MembershipUpdate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MembershipUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MembershipUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Members = append(m.Members, &Membership{})
			if err := m.Members[len(m.Members)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdate", wireType)
			}
			m.LastUpdate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastUpdate |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Redirect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Redirect = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RedirectAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RedirectAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DirectedEdge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DirectedEdge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DirectedEdge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entity", wireType)
			}
			m.Entity = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.Entity = uint64(dAtA[iNdEx-8])
			m.Entity |= uint64(dAtA[iNdEx-7]) << 8
			m.Entity |= uint64(dAtA[iNdEx-6]) << 16
			m.Entity |= uint64(dAtA[iNdEx-5]) << 24
			m.Entity |= uint64(dAtA[iNdEx-4]) << 32
			m.Entity |= uint64(dAtA[iNdEx-3]) << 40
			m.Entity |= uint64(dAtA[iNdEx-2]) << 48
			m.Entity |= uint64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueType", wireType)
			}
			m.ValueType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValueType |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValueId", wireType)
			}
			m.ValueId = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.ValueId = uint64(dAtA[iNdEx-8])
			m.ValueId |= uint64(dAtA[iNdEx-7]) << 8
			m.ValueId |= uint64(dAtA[iNdEx-6]) << 16
			m.ValueId |= uint64(dAtA[iNdEx-5]) << 24
			m.ValueId |= uint64(dAtA[iNdEx-4]) << 32
			m.ValueId |= uint64(dAtA[iNdEx-3]) << 40
			m.ValueId |= uint64(dAtA[iNdEx-2]) << 48
			m.ValueId |= uint64(dAtA[iNdEx-1]) << 56
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= (DirectedEdge_Op(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mutations) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mutations: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mutations: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Edges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Edges = append(m.Edges, &DirectedEdge{})
			if err := m.Edges[len(m.Edges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RebuildIndex) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RebuildIndex: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RebuildIndex: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Proposal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Proposal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Proposal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Mutations == nil {
				m.Mutations = &Mutations{}
			}
			if err := m.Mutations.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Membership", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Membership == nil {
				m.Membership = &Membership{}
			}
			if err := m.Membership.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RebuildIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RebuildIndex == nil {
				m.RebuildIndex = &RebuildIndex{}
			}
			if err := m.RebuildIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KV) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KV: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KV: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Val", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Val = append(m.Val[:0], dAtA[iNdEx:postIndex]...)
			if m.Val == nil {
				m.Val = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KC) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KC: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KC: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checksum = append(m.Checksum[:0], dAtA[iNdEx:postIndex]...)
			if m.Checksum == nil {
				m.Checksum = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupKeys) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTask
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupKeys: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupKeys: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTask
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTask
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, &KC{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTask(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTask
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTask(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTask
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTask
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTask
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTask
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTask
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTask(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTask = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTask   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("task.proto", fileDescriptorTask) }

var fileDescriptorTask = []byte{
	// 902 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x55, 0xdd, 0x6e, 0xdc, 0xc4,
	0x17, 0xef, 0xd8, 0x5e, 0xdb, 0x7b, 0x76, 0x37, 0xff, 0xd5, 0xe8, 0x4f, 0x71, 0x03, 0x84, 0x95,
	0xab, 0x4a, 0x06, 0x89, 0x08, 0x05, 0xa4, 0x5e, 0x71, 0x51, 0xb2, 0xa1, 0x8a, 0xd2, 0xd0, 0x32,
	0xfd, 0xb8, 0xb5, 0x26, 0x9e, 0xd9, 0xd4, 0x5a, 0x7b, 0x6d, 0x79, 0xc6, 0xab, 0xec, 0x13, 0xf0,
	0x08, 0x70, 0x83, 0xc4, 0x43, 0xf0, 0x10, 0x88, 0x2b, 0xde, 0x00, 0x14, 0x5e, 0x04, 0xcd, 0xb1,
	0xbd, 0x1f, 0xed, 0x2a, 0x12, 0x77, 0xe7, 0x77, 0x7c, 0xe6, 0x7c, 0xfc, 0xce, 0x6f, 0xc6, 0x00,
	0x9a, 0xab, 0xf9, 0x71, 0x59, 0x15, 0xba, 0xa0, 0x8e, 0xb1, 0xc3, 0x43, 0x70, 0x9e, 0xa5, 0x4a,
	0x53, 0x0a, 0x4e, 0x9d, 0x0a, 0x15, 0x90, 0x89, 0x1d, 0xb9, 0x0c, 0xed, 0xf0, 0x6b, 0xe8, 0xbd,
	0xe1, 0x59, 0x2d, 0xe9, 0x18, 0xec, 0x25, 0xcf, 0x02, 0x32, 0x21, 0xd1, 0x90, 0x19, 0x93, 0x3e,
	0x00, 0x7f, 0xc9, 0xb3, 0x58, 0xaf, 0x4a, 0x19, 0x58, 0x13, 0x12, 0xf5, 0x98, 0xb7, 0xe4, 0xd9,
	0xab, 0x55, 0x29, 0xc3, 0x3f, 0x08, 0xf4, 0x7e, 0xa8, 0x65, 0xb5, 0x32, 0x39, 0xb9, 0xd6, 0x15,
	0x9e, 0xeb, 0x33, 0xb4, 0xe9, 0xff, 0xa1, 0x97, 0x14, 0xf5, 0x42, 0xb7, 0xa7, 0x1a, 0x40, 0xef,
	0x83, 0x5b, 0xcc, 0x66, 0x4a, 0xea, 0xc0, 0x46, 0x77, 0x8b, 0xe8, 0x47, 0xd0, 0xe7, 0x33, 0x2d,
	0xab, 0xb8, 0x4e, 0x45, 0xe0, 0x4c, 0x48, 0xe4, 0x32, 0x1f, 0x1d, 0xaf, 0x53, 0x61, 0x7a, 0x10,
	0x45, 0xdc, 0x64, 0xeb, 0x4d, 0x48, 0xe4, 0x33, 0x4f, 0x14, 0xa7, 0x98, 0xaf, 0x9b, 0xc6, 0xdd,
	0x4c, 0x63, 0xc2, 0x55, 0x95, 0xc4, 0xb3, 0x7a, 0x91, 0x04, 0xde, 0xc4, 0x8e, 0xfa, 0xcc, 0x53,
	0x55, 0xf2, 0x5d, 0xbd, 0x48, 0x68, 0x00, 0x5e, 0x25, 0x97, 0xb2, 0x52, 0x32, 0xf0, 0x9b, 0x44,
	0x2d, 0x0c, 0x7f, 0x22, 0xe0, 0x32, 0xa9, 0xea, 0x4c, 0xd3, 0xcf, 0x00, 0xea, 0x54, 0xc4, 0x39,
	0xd7, 0x55, 0x7a, 0x83, 0x3c, 0x0d, 0x4e, 0xe0, 0x18, 0x09, 0x35, 0x0c, 0xb2, 0x7e, 0x9d, 0x8a,
	0x4b, 0xfc, 0x48, 0x1f, 0x82, 0xbb, 0x34, 0xc4, 0xa9, 0xc0, 0xc2, 0xb0, 0x41, 0x13, 0x86, 0x64,
	0xb2, 0xf6, 0x93, 0x99, 0x19, 0x7b, 0x57, 0x81, 0x3d, 0xb1, 0xa3, 0x11, 0x6b, 0x11, 0x7d, 0x04,
	0x07, 0xe9, 0x42, 0x9b, 0xea, 0x89, 0x8e, 0x85, 0x54, 0x1a, 0x07, 0xf7, 0xd9, 0x68, 0xed, 0x9d,
	0x4a, 0xa5, 0xc3, 0x1f, 0x09, 0x38, 0x2f, 0x8b, 0x4a, 0xef, 0x65, 0x79, 0xb7, 0x57, 0xeb, 0xae,
	0x5e, 0xd7, 0x0b, 0xb1, 0xf7, 0x2f, 0xc4, 0xd9, 0x59, 0x08, 0x05, 0x47, 0x48, 0x95, 0xb4, 0x7c,
	0xa3, 0x1d, 0x3e, 0x06, 0x30, 0x8d, 0xfc, 0x67, 0x9a, 0xc2, 0x27, 0x60, 0x7f, 0x5f, 0xe7, 0xa6,
	0x83, 0xeb, 0xaa, 0xa8, 0x4b, 0x9c, 0x60, 0xc4, 0x1a, 0xd0, 0x69, 0xce, 0xc8, 0xc4, 0x6e, 0x34,
	0xd7, 0x2d, 0xd5, 0xd0, 0xe5, 0xb4, 0x12, 0x7d, 0x0a, 0x03, 0xc6, 0x67, 0xfa, 0xb4, 0x58, 0x68,
	0x79, 0xa3, 0xe9, 0x01, 0x58, 0xa9, 0xc0, 0x3c, 0x2e, 0xb3, 0x52, 0xb1, 0x49, 0x6d, 0x6d, 0xa7,
	0x36, 0x8c, 0x09, 0x51, 0xe1, 0xc4, 0x86, 0x31, 0x21, 0xaa, 0xf0, 0x17, 0x02, 0x70, 0x29, 0xf3,
	0x2b, 0x59, 0xa9, 0xb7, 0x69, 0xf9, 0x5e, 0xa2, 0x07, 0xe0, 0xe3, 0xd9, 0x38, 0x15, 0x6d, 0x2e,
	0x0f, 0xf1, 0xb9, 0xd8, 0x97, 0xcd, 0xd0, 0x97, 0x49, 0x2e, 0x64, 0xd5, 0xee, 0xae, 0x45, 0xf4,
	0x43, 0xf0, 0x78, 0x1e, 0x0b, 0xc9, 0x45, 0xcb, 0xa0, 0xcb, 0xf3, 0xa9, 0xe4, 0x82, 0x7e, 0x0a,
	0x83, 0x8c, 0x2b, 0x1d, 0xd7, 0xa5, 0xe0, 0x5a, 0x06, 0xee, 0x84, 0x44, 0x0e, 0x03, 0xe3, 0x7a,
	0x8d, 0x9e, 0xf0, 0x57, 0x02, 0xe3, 0x4d, 0x7f, 0x8d, 0x93, 0x7e, 0x0e, 0x5e, 0xde, 0xf8, 0x5a,
	0xa2, 0xc7, 0x0d, 0xd1, 0x9b, 0x40, 0xd6, 0x05, 0xbc, 0x5b, 0xc1, 0x7a, 0xb7, 0x02, 0x3d, 0x04,
	0xbf, 0x92, 0x22, 0xad, 0x64, 0xd2, 0x68, 0xc1, 0x67, 0x6b, 0x4c, 0x1f, 0xc2, 0xa8, 0xb3, 0x63,
	0x1c, 0xd6, 0xc1, 0x61, 0x87, 0x9d, 0xf3, 0x89, 0xa1, 0xf0, 0x2f, 0x02, 0xc3, 0x29, 0x42, 0x29,
	0xce, 0xc4, 0xb5, 0x34, 0x2c, 0xc8, 0x85, 0x4e, 0xf5, 0xaa, 0x25, 0xb2, 0x45, 0x6b, 0xc5, 0x5a,
	0xbb, 0xef, 0x02, 0xde, 0x0b, 0x2c, 0x3d, 0x64, 0x0d, 0xa0, 0x9f, 0x00, 0xa0, 0xd1, 0x3c, 0x34,
	0x0e, 0x12, 0xdf, 0x47, 0x8f, 0x79, 0x6a, 0xda, 0x57, 0xa8, 0x96, 0x66, 0x2b, 0x3d, 0x2c, 0xe1,
	0x21, 0x3e, 0xc7, 0xcd, 0x67, 0xfc, 0x4a, 0x66, 0x48, 0x65, 0x9f, 0x35, 0x80, 0x3e, 0x02, 0xab,
	0x28, 0x03, 0x6f, 0x42, 0xa2, 0x83, 0x93, 0x0f, 0x1a, 0xae, 0xb6, 0x3b, 0x3e, 0x7e, 0x5e, 0x32,
	0xab, 0x28, 0xc3, 0xfb, 0x60, 0x3d, 0x2f, 0xa9, 0x07, 0xf6, 0xcb, 0xb3, 0x57, 0xe3, 0x7b, 0xc6,
	0x98, 0x9e, 0x3d, 0x1b, 0x93, 0xf0, 0x05, 0xf4, 0x2f, 0x6b, 0xcd, 0x75, 0x5a, 0x2c, 0xd4, 0x8e,
	0x24, 0xc8, 0xae, 0x24, 0x22, 0xe8, 0x49, 0x71, 0xbd, 0xbe, 0xfe, 0xf4, 0xfd, 0x4a, 0xac, 0x09,
	0x08, 0xbf, 0x81, 0x21, 0x93, 0x57, 0x75, 0x9a, 0x89, 0xf3, 0x85, 0x90, 0x37, 0x77, 0x25, 0xdd,
	0xc3, 0x5a, 0xf8, 0x1b, 0x01, 0xff, 0x45, 0x55, 0x94, 0x85, 0xe2, 0xd9, 0x96, 0x66, 0x47, 0xa8,
	0xd9, 0x2f, 0xa0, 0x9f, 0x77, 0xdd, 0xe2, 0xa9, 0xc1, 0xc9, 0xff, 0x5a, 0x7d, 0x74, 0x6e, 0xb6,
	0x89, 0xa0, 0x5f, 0x02, 0xe4, 0x6b, 0xdd, 0xe0, 0x1a, 0xf6, 0xe9, 0x69, 0x2b, 0x86, 0x3e, 0x36,
	0xaa, 0xc0, 0xe6, 0xe3, 0xd4, 0x74, 0x8f, 0x0b, 0x5a, 0x8f, 0xbb, 0x3d, 0x97, 0x51, 0xca, 0x06,
	0x85, 0x11, 0x58, 0x17, 0x6f, 0xcc, 0x0d, 0x9f, 0xcb, 0x55, 0xf7, 0x57, 0x99, 0xcb, 0xd5, 0xf6,
	0x9d, 0x6f, 0xfe, 0x33, 0xe1, 0x09, 0x58, 0x17, 0xa7, 0x7b, 0x22, 0x0f, 0xc1, 0x4f, 0xde, 0xca,
	0x64, 0xae, 0xea, 0xbc, 0x0d, 0x5f, 0xe3, 0x70, 0x0a, 0xfd, 0xa7, 0x86, 0xb3, 0x0b, 0xb9, 0xba,
	0x73, 0x4b, 0x1f, 0x83, 0x33, 0x97, 0xab, 0x6e, 0x49, 0x7e, 0xd3, 0xf5, 0xc5, 0x29, 0x43, 0xef,
	0xb7, 0xe3, 0xdf, 0x6f, 0x8f, 0xc8, 0x9f, 0xb7, 0x47, 0xe4, 0xef, 0xdb, 0x23, 0xf2, 0xf3, 0x3f,
	0x47, 0xf7, 0xae, 0x5c, 0xfc, 0x6f, 0x7e, 0xf5, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd9, 0x83,
	0x34, 0x72, 0x45, 0x07, 0x00, 0x00,
}
