// This is an autogenerated file, any edits which you make here will be lost!
package api

import (
	"fmt"
	"github.com/deepmap/oapi-codegen/pkg/codegen"
	"github.com/labstack/echo/v4"
	"net/http"
)

// Type definition for component schema "Error"
type Error struct {
	Code    int32  `json:"code"`
	Message string `json:"message"`
}

// Type definition for component schema "NewPet"
type NewPet struct {
	Name string  `json:"name"`
	Tag  *string `json,omitempty:"tag"`
}

// Type definition for component schema "Pet"
type Pet struct {
	// Embedded struct due to allOf(#/components/schemas/NewPet)
	NewPet
	// Embedded fields due to inline allOf schema
	Id int64 `json:"id"`
}

// Parameters object for FindPets
type FindPetsParams struct {
	Tags  *[]string `json:"tags,omitempty"`
	Limit *int32    `json:"limit,omitempty"`
}

type ServerInterface interface {
	//  (GET /pets)
	FindPets(ctx echo.Context, params FindPetsParams) error
	//  (POST /pets)
	AddPet(ctx echo.Context) error
	//  (DELETE /pets/{id})
	DeletePet(ctx echo.Context, id int64) error
	//  (GET /pets/{id})
	FindPetById(ctx echo.Context, id int64) error
}

type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// Wrapper for FindPets
func (w *ServerInterfaceWrapper) FindPets(ctx echo.Context) error {
	var err error

	// Parameter object where we will unmarshal all parameters from the
	// context.
	var params FindPetsParams
	// ------------- Optional query parameter "tags" -------------
	var Tags []string

	if ctx.QueryParam("tags") != "" {
		err = codegen.BindStringToObject(ctx.QueryParam("tags"), &Tags)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter tags: %s", err))
		}
		params.Tags = &Tags
	}
	// ------------- Optional query parameter "limit" -------------
	var Limit int32

	if ctx.QueryParam("limit") != "" {
		err = codegen.BindStringToObject(ctx.QueryParam("limit"), &Limit)
		if err != nil {
			return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter limit: %s", err))
		}
		params.Limit = &Limit
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.FindPets(ctx, params)
	return err
}

// Wrapper for AddPet
func (w *ServerInterfaceWrapper) AddPet(ctx echo.Context) error {
	var err error

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AddPet(ctx)
	return err
}

// Wrapper for DeletePet
func (w *ServerInterfaceWrapper) DeletePet(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var Id int64
	err = codegen.BindStringToObject(ctx.Param("id"), &Id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.DeletePet(ctx, Id)
	return err
}

// Wrapper for FindPetById
func (w *ServerInterfaceWrapper) FindPetById(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var Id int64
	err = codegen.BindStringToObject(ctx.Param("id"), &Id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.FindPetById(ctx, Id)
	return err
}

func RegisterHandlers(router codegen.EchoRouter, si ServerInterface) {
	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}
	router.GET("/pets", wrapper.FindPets)
	router.POST("/pets", wrapper.AddPet)
	router.DELETE("/pets/:id", wrapper.DeletePet)
	router.GET("/pets/:id", wrapper.FindPetById)

}

