# Docker Compose CLI

The general architecture of the CLI is described [here](architecture.md)

# Azure Container Instances integration

The Compose CLI can deploy single containers or Compose applications to ACI. 

* [ACI integration user guide](https://docs.docker.com/engine/context/aci-integration/)
* [Mapping `docker run` options to ACI deployments](aci-container-features.md) (single container) 
* [Mapping Compose file options to ACI deployments](aci-compose-features.md)

# Amazon Elastic Container Service

The Compose CLI can deploy Compose applications to Amazon ECS.
 
* [ECS integration user guide](https://docs.docker.com/engine/context/ecs-integration/)
* [General architecture](ecs-architecture.md) of the ECS integration
* [Compose examples](ecs-compose-examples.md) using various ECS integration features
