---
title: ACI integration container features
description: Reference list of container ACI features
keywords: Docker, Azure, Integration, ACI, container, cli, deploy, cloud
---
# Azure Container Instances: running single containerrs

Single containers can be executed on ACI with the `docker run` command.
A single container is executed in its own ACI container group, that will container only one container.

Containers can be listed with the `docker ps` command, and stopped and removed with `docker stop <CONTAINER>` and `docker rm <CONTAINER>`.

# Docker run options for ACI containers

The table below lists supported `docker run` flags and their ACI counterparts.

__Legend:__

- __✓:__ Implemented
- __n:__ Not yet implemented
- __x:__ Not applicable / no available conversion

| Flag                  |Map|  Notes
|-----------------------|---|---------------------------------|
| --cpus                | ✓ | See [Container Resources](#container-resources).
| -d, --detach          | ✓ | Detach from container logs when container starts. By default, the command line stays attached and follow container logs.
| --domainname          | ✓ | See [Exposing ports](#exposing-ports).
| --e, --env            | ✓ | Sets environment variable.
| --env-file            | ✓ | Sets environment variable from and external file.
| --health-cmd          | ✓ | Specify healthcheck command. See [Healthchecks](#healthchecks).
| --health-interval     | ✓ | Specify healthcheck interval
| --health-retries      | ✓ | Specify healthcheck number of retries
| --health-start-period | ✓ | Specify healthcheck initial delay
| --health-timeout      | ✓ | Specify healthcheck timeout
| -l, --label           | x | Unsupported in Docker ACI integration, due to limitations of ACI Tags.
| -m, --memory          | ✓ | See [Container Resources](#container-resources).
| --name                | ✓ | Provide a name for the container. Name must be unique withing the ACI resource group. a name is generated by default.
| -p, --publish         | ✓ | See [Exposing ports](#exposing-ports). Only symetrical port mapping is supported in ACI.
| --restart             | ✓ | Restart policy, must be one of: `always`, `no`, `on-failure`.
| --rm                  | x | Not supported as [ACI does not support auto-delete containers](https://feedback.azure.com/forums/602224-azure-container-instances/suggestions/34066633-support-auto-delete-of-aci-when-container-exits-no).
| -v, --volume          | ✓ | See [Persistent Volumes](#persistent-volumes).

## Exposing ports

You can expose one or more ports of a container with `docker run -p <PORT>:<PORT>`
If ports are exposed when running a container, the corresponding ACI container group will be exposed with a public IP allocated and the required port(s) accessible.
> Note: [ACI does not support port mapping](https://feedback.azure.com/forums/602224-azure-container-instances/suggestions/34082284-support-for-port-mapping), so the same port number must be specified when using `-p <PORT>:<PORT>`.

When exposing ports, a container can also specify the service `--domainname` flag to set a DNS hostname. `domainname` will be used to specify the ACI DNS Label Name, and the ACI container group will be reachable at `<DOMAINNANE>.<REGION>.azurecontainer.io`.
`domainname` must be unique globally in <REGION>.azurecontainer.io

## Persistent volumes

Docker volumes are mapped to Azure File shares, each file share is part of an Azure Storage Account.
One or more volumes can be specified with `docker run -v <STORAGE-ACCOUNT>/<FILESHARE>:<TARGET-PATH>`.

A run command can use the `--volume` or `-v` flag several times for different volumes. The volumes can use the same or different storage accounts. The target paths for different volume mounts must be different and not overlap.
There is no support for mounting a single file, or mounting a subfolder from an Azure File Share.

Credentials for storage accounts will be automatically fetched at deployment time using the Azure login to retrieve the storage account key for each storage account used.

## Container Resources

CPU and memory reservations can be set when running containers with `docker run --cpus 1.5 --memory 2G`.

It is not possible to set resource limits that differ from resource reservation on single containers.
ACI allows setting resource limits for containers in a container group but these limits must stay within the reserved resources for the entire group. In the case of a single container deployed in a container group, the resource limits must be equal to the resource reservation.

## Logs

You can view container logs with the command `docker logs <CONTAINER-ID>`.

You can follow logs with the `--follow` (`-f`) option.
When running a container with `docker run`, by default the command line stays attached to container logs when the container starts. Use `docker run --detach` to not follow logs once the container starts.
> Note: Following ACI logs may have display issues especially when resizing a terminal that is following container logs. This is due to ACI providing raw log pulling but no streaming of logs. Logs are effectively pulled every 2 seconds when following logs.

## Healthchecks

A health check can be described using the flags prefixed by `--health-`. This is translated into `LivenessProbe` for ACI. If the health check fails then the container is considered unhealthy and terminated.
In order for the container to be restarted automatically, the container needs to be run with a restart policy (set by the `--restart` flag) other than `no`. Note that the default restart policy if one isn't set is `no`.

In order to restart automatically, the container also need to have a restart policy set with `--restart` (`docker run` defaults to no restart policy)
