"use strict";angular.module("jsonForms",["ui.bootstrap","ui.validate","ui.grid","ui.grid.pagination","ui.grid.autoResize","jsonForms.services","jsonForms.directives","jsonForms.label","jsonForms.verticalLayout","jsonForms.horizontalLayout","jsonForms.table","jsonForms.integerControl","jsonForms.booleanControl","jsonForms.stringControl","jsonForms.numberControl","jsonForms.datetimeControl","jsonForms.enumControl"]);var jsonFormsDirectives=angular.module("jsonForms.directives",["jsonForms.services"]),JsonFormsDirectiveController=function(){function a(a,b,c,d,e,f){this.RenderService=a,this.ReferenceResolver=b,this.UISchemaGenerator=c,this.SchemaGenerator=d,this.$scope=e,this.$q=f;var g=f.defer(),h=f.defer();f.all([this.fetchSchema().promise,this.fetchUiSchema().promise]).then(function(a){var b=a[0],d=a[1],e=f.defer();f.when(e.promise).then(function(a){JsonRefs.resolveRefs(b,{},function(b,c,d){g.resolve(c),h.resolve(a)})}),void 0===d||null===d||""===d?JsonRefs.resolveRefs(b,{},function(a,b,d){var f=c.generateDefaultUISchema(b);e.resolve(f)}):e.resolve(d)}),f.all([g.promise,h.promise,this.fetchData()]).then(function(b){var c,d=b[0],g=b[1],h=b[2];c=e.asyncDataProvider?e.asyncDataProvider:new JSONForms.DefaultDataProvider(f,h),a.registerSchema(d),e.elements=[a.render(g,c)]}),e.opened=!1}return a.prototype.fetchSchema=function(){if(this.$scope.schema&&this.$scope.asyncSchema())throw new Error("You cannot specify both the 'schema' and the 'async-schema' attribute at the same time.");if(this.$scope.schema){var a=this.$q.defer();return a.resolve(this.$scope.schema),a}if(this.$scope.asyncSchema())return this.$scope.asyncSchema();if(this.$scope.data){var a=this.$q.defer();return a.resolve(this.SchemaGenerator.generateDefaultSchema(this.$scope.data)),a}throw new Error("Either the 'schema' or the 'async-schema' attribute must be specified.")},a.prototype.fetchUiSchema=function(){if(this.$scope.uiSchema&&this.$scope.asyncUiSchema())throw new Error("You cannot specify both the 'ui-schema' and the 'async-ui-schema' attribute at the same time.");if(this.$scope.uiSchema){var a=this.$q.defer();return a.resolve(this.$scope.uiSchema),a}if(this.$scope.asyncUiSchema())return this.$scope.asyncUiSchema();var a=this.$q.defer();return a.resolve(void 0),a},a.prototype.fetchData=function(){var a=this.$scope.asyncDataProvider,b=this.$scope.data;if(a&&b)throw new Error("You cannot specify both the 'data' and the 'async-data-provider' attribute at the same time.");if(a){var c=a.fetchData();return c}if(this.$scope.data){var d=this.$q.defer();return d.resolve(this.$scope.data),d.promise}throw new Error("Either the 'data' or the 'async-data-provider' attribute must be specified.")},a.$inject=["JSONForms.RenderService","ReferenceResolver","UISchemaGenerator","SchemaGenerator","$scope","$q"],a}(),RecElement=function(){function a(a){var b=this;this.recursionHelper=a,this.restrict="E",this.replace=!0,this.scope={element:"="},this.templateUrl="templates/element.html",this.compile=function(a,c,d){return b.recursionHelper.compile(a,d)}}return a}();jsonFormsDirectives.directive("control",function(){return{restrict:"E",replace:!0,scope:{control:"="},templateUrl:"templates/control.html"}}).directive("jsonforms",function(){return{restrict:"E",replace:!0,scope:{schema:"=",uiSchema:"=",data:"=",asyncSchema:"&",asyncUiSchema:"&",asyncDataProvider:"="},templateUrl:"templates/form.html",controller:JsonFormsDirectiveController}}).directive("recelement",["RecursionHelper",function(a){return new RecElement(a)}]).directive("dynamicWidget",["$compile",function(a){var b=function(a){return a.replace("data-jsonforms-model","ng-model='element.instance[element.path]'").replace("data-jsonforms-validation","ng-change='element.validate()'")};return{restrict:"E",scope:{element:"="},replace:!0,link:function(c,d){if(c.element.templateUrl)$.get(c.element.templateUrl,function(e){var f=b(e),g=a(f)(c);d.replaceWith(g)});else{var e=b(c.element.template),f=a(e)(c);d.replaceWith(f)}}}}]);var ArrayControl=function(){function a(a,b){this.refResolver=a,this.scope=b,this.maxSize=99,this.priority=2}return a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"array"==b.type},a.prototype.render=function(a,b,c,d){var e=this.createTableUIElement(a,d);return e.tableOptions.gridOptions.data=d.data.slice(d.page*d.pageSize,d.page*d.pageSize+d.pageSize),e.tableOptions.gridOptions.paginationPage=d.page,e.tableOptions.gridOptions.paginationPageSize=d.pageSize,{label:a.label,type:"Control",gridOptions:e.tableOptions.gridOptions,size:this.maxSize,template:'<div ui-grid="element[\'gridOptions\']" ui-grid-auto-resize ui-grid-pagination class="grid"></div>'}},a.prototype.createTableUIElement=function(a,b){var c=void 0!==b.fetchPage,d=!1,e={schemaType:"array"},f=this,g=a.columns.map(function(a,b){return{field:f.refResolver.normalize(a.scope.$ref),displayName:a.label}}),h={columns:a.columns,gridOptions:{enableFiltering:d,enablePaginationControls:c,enableColumnResizing:!0,enableAutoResize:!0,columnDefs:g,data:[],useExternalFiltering:!0}};return c&&(h.gridOptions.enablePagination=c,h.gridOptions.useExternalPagination=!0,h.gridOptions.paginationPageSizes=[1,2,3,4,5],h.gridOptions.paginationPageSize=1,h.gridOptions.paginationPage=1),b.totalItems&&(h.gridOptions.totalItems=b.totalItems),e.enablePaginationControls=function(){h.gridOptions.enablePaginationControls=!0},e.disablePaginationControls=function(){h.gridOptions.enablePaginationControls=!1},h.gridOptions.onRegisterApi=function(a){a.pagination.on.paginationChanged(f.scope,function(a,c){h.gridOptions.paginationPage=a,h.gridOptions.paginationPageSize=c,b.setPageSize(c),b.fetchPage(a,c).then(function(a){h.gridOptions.data=a})})},e.tableOptions=h,e},a.prototype.findSearchTerms=function(a){for(var b=[],c=0;c<a.columns.length;c++){var d=a.columns[c].filters[0].term;void 0!==d&&null!==d&&b.push({column:a.columns[c].name,term:d})}return b},a}(),app=angular.module("jsonForms.table",[]);app.run(["JSONForms.RenderService","ReferenceResolver","$rootScope",function(a,b,c){a.register(new ArrayControl(b,c))}]);var BooleanControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,b,c);return e.template='<input type="checkbox" id="'+c+'" class="qb-control qb-control-boolean" ui-validate="\'element.validate($value)\'" data-jsonforms-model/>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"boolean"==b.type},a}(),app=angular.module("jsonForms.booleanControl",[]);app.run(["JSONForms.RenderService",function(a){a.register(new BooleanControl)}]);var DatetimeControl=function(){function a(){this.priority=3}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,b,c);return e.templateUrl="../templates/datetime.html",e.isOpen=!1,e.openDate=function(a){a.preventDefault(),a.stopPropagation(),e.isOpen=!0},e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"string"==b.type&&void 0!=b.format&&"date-time"==b.format},a}(),app=angular.module("jsonForms.datetimeControl",[]);app.run(["JSONForms.RenderService",function(a){a.register(new DatetimeControl)}]);var EnumControl=function(){function a(){this.priority=3}return a.prototype.render=function(a,b,c,d){var e=b["enum"],f=new JSONForms.ControlRenderDescription(d.data,b,c);return f.template='<select ng-options="option as option for option in element.options" id="'+c+'" class="form-control qb-control qb-control-enum" data-jsonforms-model ></select>',f.options=e,f},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&b.hasOwnProperty("enum")},a}(),app=angular.module("jsonForms.enumControl",[]);app.run(["JSONForms.RenderService",function(a){a.register(new EnumControl)}]);var HorizontalLayout=function(){function a(a){var b=this;this.renderServ=a,this.priority=1,this.render=function(a,c,d,e){for(var f=b,g=function(a){return void 0===a||0==a.length?[]:a.reduce(function(a,b,c,d){return a.push(f.renderServ.render(b,e)),a},[])},h=99,i=g(a.elements),j=i.length,k=Math.floor(h/j),l=0;l<i.length;l++)i[l].size=k;return{type:"Layout",elements:i,size:h,template:'<fieldset>\n                  <div class="row">\n                    <recelement ng-repeat="child in element.elements" element="child"></recelement>\n                  </div>\n                </fieldset>'}}}return a.prototype.isApplicable=function(a,b,c){return"HorizontalLayout"==a.type},a}(),app=angular.module("jsonForms.horizontalLayout",[]);app.run(["JSONForms.RenderService",function(a){a.register(new HorizontalLayout(a))}]);var IntegerControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,b,c);return e.template='<input type="number" step="1" id="'+c+'" class="form-control qb-control qb-control-integer" data-jsonforms-validation data-jsonforms-model/>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"integer"==b.type},a}(),app=angular.module("jsonForms.integerControl",[]);app.run(["JSONForms.RenderService",function(a){a.register(new IntegerControl)}]);var NumberControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,b,c);return e.template='<input type="number" step="0.01" id="'+c+'" class="form-control qb-control qb-control-number" data-jsonforms-validation data-jsonforms-model/>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"number"==b.type},a}(),app=angular.module("jsonForms.numberControl",[]);app.run(["JSONForms.RenderService",function(a){a.register(new NumberControl)}]);var StringControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,b,c);return e.template='<input type="text" id="'+c+'" class="form-control qb-control qb-control-string" data-jsonforms-model/>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"string"==b.type},a}(),app=angular.module("jsonForms.stringControl",[]);app.run(["JSONForms.RenderService",function(a){a.register(new StringControl)}]);var VerticalLayout=function(){function a(a){this.renderService=a,this.priority=1}return a.prototype.render=function(a,b,c,d){var e=this,f=function(a){return void 0===a||0==a.length?[]:a.reduce(function(a,b,c,f){return a.push(e.renderService.render(b,d)),a},[])},g=f(a.elements);return{type:"Layout",elements:g,size:99,template:'<fieldset>\n                    <recelement ng-repeat="child in element.elements" element="child">\n                    </recelement>\n                </fieldset>'}},a.prototype.isApplicable=function(a,b,c){return"VerticalLayout"==a.type},a}(),app=angular.module("jsonForms.verticalLayout",["jsonForms.services"]);app.run(["JSONForms.RenderService",function(a){a.register(new VerticalLayout(a))}]);var Label=function(){function a(){this.priority=1}return a.prototype.render=function(a,b,c,d){var e=(a.text,99);return{type:"Widget",size:e,template:' <div class="qb-label">{{text}}</div>'}},a.prototype.isApplicable=function(a){return"Label"==a.type},a}(),app=angular.module("jsonForms.label",["jsonForms.services"]);app.run(["JSONForms.RenderService",function(a){a.register(new Label)}]);var JSONForms;!function(a){var b=function(){function a(a){this.json=a,this.type=a.type,this.elements=a.elements}return a}();a.UISchemaElement=b;var c=function(){function a(a,b){var c=this;this.$q=a,this.data=b,this.currentPage=0,this.currentPageSize=2,this.setPageSize=function(a){c.currentPageSize=a},this.fetchPage=function(a,b){c.currentPage=a,c.currentPageSize=b;var d=c.$q.defer();return c.data instanceof Array?d.resolve(c.data.slice(c.currentPage*c.currentPageSize,c.currentPage*c.currentPageSize+c.currentPageSize)):d.resolve(c.data),d.promise},this.totalItems=this.data.length,this.pageSize=this.currentPageSize,this.page=this.currentPage}return a.prototype.fetchData=function(){var a=this.$q.defer();return a.resolve(this.data),a.promise},a}();a.DefaultDataProvider=c;var d=function(){function a(a,b,c){this.instance=a,this.subSchema=b,this.type="Control",this.size=99,this.alerts=[],this.path=f.normalize(c),this.label=f.beautifiedLastFragment(c)}return a.prototype.validate=function(){var a=this.instance[this.path],b=tv4.validateMultiple(a,this.subSchema);if(b.valid)this.alerts=[];else{this.alerts=[];var c={type:"danger",msg:b.errors[0].message};this.alerts.push(c)}return b.valid},a}();a.ControlRenderDescription=d;var e=function(){function a(a){var b=this;this.refResolver=a,this.renderers=[],this.registerSchema=function(a){b.schema=a},this.render=function(a,c){var d,e,f;a.scope&&(e=a.scope.$ref,f=b.refResolver.resolveSchema(b.schema,e));for(var g=0;g<b.renderers.length;g++)b.renderers[g].isApplicable(a,f,e)&&(void 0==d||b.renderers[g].priority>d.priority)&&(d=b.renderers[g]);if(void 0===d)throw new Error("No applicable renderer found for element "+JSON.stringify(a));var h=d.render(a,f,e,c);return h.validate&&h.validate(),h},this.register=function(a){b.renderers.push(a)}}return a.$inject=["ReferenceResolver"],a}();a.RenderService=e;var f=function(){function a(){}return a.beautifiedLastFragment=function(b){return a.beautify(a.capitalizeFirstLetter(b.substr(b.lastIndexOf("/")+1,b.length)))},a.capitalizeFirstLetter=function(a){return a.charAt(0).toUpperCase()+a.slice(1)},a.Keywords=["items","properties","#"],a.normalize=function(b){return a.filterNonKeywords(a.toPropertyFragments(b)).join("/")},a.toPropertyFragments=function(a){return a.split("/").filter(function(a){return a.length>0})},a.filterNonKeywords=function(b){return b.filter(function(b){return!(-1!==a.Keywords.indexOf(b))})},a.beautify=function(a){if(a&&a.length>0){var b=a.split(/(?=[A-Z])/).map(function(a){return a.toLowerCase()});return b[0]=b[0].charAt(0).toUpperCase()+b[0].slice(1),b.join(" ")}return a},a}(),g=function(){function a(a){var b=this;this.$compile=a,this.pathMapping={},this.addUiPathToSchemaRefMapping=function(a){for(var c in a)a.hasOwnProperty(c)&&(b.pathMapping[c]=a[c])},this.getSchemaRef=function(a){return"#"==a?"#":b.pathMapping[a+"/scope/$ref"]},this.normalize=function(a){return f.normalize(a)},this.resolveUi=function(a,c){var d=c+"/scope/$ref";return void 0!==b.pathMapping&&b.pathMapping.hasOwnProperty(d)&&(d=b.pathMapping[d]),b.resolveInstance(a,d)},this.resolveInstance=function(a,c){var d=f.toPropertyFragments(b.normalize(c));return d.reduce(function(a,b){return a instanceof Array?a.map(function(a){return a[b]}):a[b]},a)},this.resolveSchema=function(a,b){var c=f.toPropertyFragments(b);return c.reduce(function(a,b){return"#"==b?a:a instanceof Array?a.map(function(a){return a[b]}):a[b]},a)}}return a.$inject=["$compile"],a}();a.ReferenceResolver=g;var h=function(){function a(){var a=this;this.generateDefaultSchema=function(b){return a.schemaObject(b,a.allowAdditionalProperties,a.requiredProperties)},this.generateDefaultSchemaWithOptions=function(b,c,d){return a.schemaObject(b,c,d)},this.schemaObject=function(b,c,d){var e=a.properties(b,c,d);return{type:"object",properties:e,additionalProperties:c(e),required:d(a.keys(e))}},this.properties=function(b,c,d){var e={},f=a;return a.keys(b).forEach(function(a){e[a]=f.property(b[a],c,d)}),e},this.keys=function(a){return Object.keys(a)},this.property=function(b,c,d){switch(typeof b){case"string":case"boolean":return{type:typeof b};case"number":return Number(b)%1===0?{type:"integer"}:{type:"number"};case"object":return a.schemaObjectOrNullOrArray(b,c,d);default:return{}}},this.schemaObjectOrNullOrArray=function(b,c,d){return a.isNotNull(b)?a.isArray(b)?a.schemaArray(b,c,d):a.schemaObject(b,c,d):{type:"null"}},this.schemaArray=function(b,c,d){if(b.length){var e=a,f=b.map(function(a){return e.property(a,c,d)}),g=a.distinct(f,function(a){return JSON.stringify(a)});return 1==g.length?{type:"array",items:g[0]}:{type:"array",items:{oneOf:g}}}},this.isArray=function(a){return"[object Array]"===Object.prototype.toString.call(a)},this.isNotNull=function(a){return"undefined"!=typeof a&&null!==a},this.distinct=function(a,b){var c={};return a.filter(function(a){var d=b(a);return c.hasOwnProperty(d)?!1:c[d]=!0})},this.requiredProperties=function(a){return a},this.allowAdditionalProperties=function(a){return!0}}return a}();a.SchemaGenerator=h;var i=function(){function a(){var a=this;this.generateDefaultUISchema=function(b){var c=[];return a.generateUISchema(b,c,"#",""),c[0]},this.generateUISchema=function(b,c,d,e){var g=a.deriveType(b);switch(g){case"object":var h={type:"VerticalLayout",elements:[]};if(c.push(h),e&&""!==e){var i={type:"Label",text:f.beautify(e)};h.elements.push(i)}if(!b.properties)return;var j=d+"/properties";for(var k in b.properties)a.isIgnoredProperty(k,b.properties[k])||a.generateUISchema(b.properties[k],h.elements,j+"/"+k,k);break;case"array":var l={type:"HorizontalLayout",elements:[]};c.push(l);var j=d+"/items";if(!b.items)return;if(b.items instanceof Array)for(var m=0;m<b.items.length;m++)a.generateUISchema(b.items[m],l.elements,j+"["+m+"]","");else a.generateUISchema(b.items,l.elements,j,"");break;case"string":case"number":case"integer":case"boolean":var n=a.getControlObject(f.beautify(e),d);c.push(n);break;case"null":break;default:throw new Error("Unknown type: "+JSON.stringify(b))}},this.isIgnoredProperty=function(a,b){return"id"===a&&"string"==typeof b},this.deriveType=function(a){return a.type?a.type:a.properties||a.additionalProperties?"object":"null"},this.getControlObject=function(a,b){return{type:"Control",label:a,scope:{$ref:b}}}}return a}();a.UISchemaGenerator=i;var j=function(){function a(a){var b=this;this.$compile=a,this.compile=function(a,c){angular.isFunction(c)&&(c={post:c});var d,e=a.contents().remove(),f=b;return{pre:c&&c.pre?c.pre:null,post:function(a,b){d||(d=f.$compile(e)),d(a,function(a){b.append(a)}),c&&c.post&&c.post.apply(null,arguments)}}}}return a.$inject=["$compile"],a}();a.RecursionHelper=j;var k=function(){function a(){}return a.prototype.createControlDescription=function(a,b,c){return new d(a,b,c)},a}();a.RenderDescriptionFactory=k;var l=function(){function a(){this.validate=function(a,b){return tv4.validateMultiple(a,b)}}return a}();a.ValidationService=l}(JSONForms||(JSONForms={})),angular.module("jsonForms.services",[]).service("RecursionHelper",JSONForms.RecursionHelper).service("ReferenceResolver",JSONForms.ReferenceResolver).service("JSONForms.RenderService",JSONForms.RenderService).service("SchemaGenerator",JSONForms.SchemaGenerator).service("UISchemaGenerator",JSONForms.UISchemaGenerator).service("ValidationService",JSONForms.ValidationService).service("JSONForms.RenderDescriptionFactory",JSONForms.RenderDescriptionFactory),angular.module("jsonForms").run(["$templateCache",function(a){a.put("templates/datetime.html",'<div class="input-group"><input type="text" datepicker-popup="dd.MM.yyyy" close-text="Close" is-open="element.isOpen" id="control.id" class="form-control qb-control qb-control-datetime" name="control.displayname" data-jsonforms-model> <span class="input-group-btn"><button type="button" class="btn btn-default" ng-click="element.openDate($event)"><i class="glyphicon glyphicon-calendar"></i></button></span></div>'),a.put("templates/element.html",'<recursive><div ng-if="element.type==\'Widget\'" class="col-sm-{{element.size}} qb-label">{{element.elements[0].text}}</div><div ng-if="element.type==\'Control\'" class="col-sm-{{element.size}} form-group top-buffer"><div class="row"><label ng-if="element.label" for="element.id">{{element.label}}</label></div><div class="row" style="padding-right: 1em"><dynamic-widget element="element"></div><div class="row" style="padding-right: 1em"><alert ng-repeat="alert in element.alerts" type="{{alert.type}}" class="top-buffer-s qb-alert">{{alert.msg}}</alert></div></div><div ng-if="element.type==\'Layout\'" class="col-sm-{{element.size}}"><dynamic-widget element="element"></div></recursive>'),a.put("templates/form.html",'<div><form role="form" class="qb-form rounded"><recelement ng-repeat="child in elements" element="child" bindings="bindings" top-open-date="openDate" top-validate-number="validateNumber" top-validate-integer="validateInteger"></recelement></form></div>')}]);