"use strict";angular.module("jsonforms",["ui.bootstrap","ui.validate","ui.grid","ui.grid.pagination","ui.grid.autoResize","jsonforms.services","jsonforms.directives","jsonforms.label","jsonforms.verticalLayout","jsonforms.horizontalLayout","jsonforms.arrayControl","jsonforms.integerControl","jsonforms.booleanControl","jsonforms.stringControl","jsonforms.numberControl","jsonforms.datetimeControl","jsonforms.enumControl","jsonforms.categorization","jsonforms.autoCompleteControl"]);var jsonFormsDirectives=angular.module("jsonforms.directives",["jsonforms.services"]),JsonFormsDirectiveController=function(){function a(a,b,c,d,e,f){this.RenderService=a,this.PathResolver=b,this.UISchemaGenerator=c,this.SchemaGenerator=d,this.$scope=e,this.$q=f;var g=f.defer(),h=f.defer();f.all([this.fetchSchema().promise,this.fetchUiSchema().promise]).then(function(a){var b=a[0],d=a[1],e=f.defer();f.when(e.promise).then(function(a){JsonRefs.resolveRefs(b,{},function(b,c,d){g.resolve(c),h.resolve(a)})}),void 0===d||null===d||""===d?JsonRefs.resolveRefs(b,{},function(a,b,d){var f=c.generateDefaultUISchema(b);e.resolve(f)}):e.resolve(d)}),f.all([g.promise,h.promise,this.fetchData()]).then(function(b){var c,d=b[0],g=b[1],h=b[2];c=e.asyncDataProvider?e.asyncDataProvider:new JSONForms.DefaultDataProvider(f,h),a.registerSchema(d),e.elements=[a.render(g,c)]}),e.opened=!1}return a.prototype.fetchSchema=function(){if(this.$scope.schema&&this.$scope.asyncSchema())throw new Error("You cannot specify both the 'schema' and the 'async-schema' attribute at the same time.");if(this.$scope.schema){var a=this.$q.defer();return a.resolve(this.$scope.schema),a}if(this.$scope.asyncSchema())return this.$scope.asyncSchema();if(this.$scope.data){var a=this.$q.defer();return a.resolve(this.SchemaGenerator.generateDefaultSchema(this.$scope.data)),a}throw new Error("Either the 'schema' or the 'async-schema' attribute must be specified.")},a.prototype.fetchUiSchema=function(){if(this.$scope.uiSchema&&this.$scope.asyncUiSchema())throw new Error("You cannot specify both the 'ui-schema' and the 'async-ui-schema' attribute at the same time.");if(this.$scope.uiSchema){var a=this.$q.defer();return a.resolve(this.$scope.uiSchema),a}if(this.$scope.asyncUiSchema())return this.$scope.asyncUiSchema();var a=this.$q.defer();return a.resolve(void 0),a},a.prototype.fetchData=function(){var a=this.$scope.asyncDataProvider,b=this.$scope.data;if(a&&b)throw new Error("You cannot specify both the 'data' and the 'async-data-provider' attribute at the same time.");if(a){var c=a.fetchData();return c}if(this.$scope.data){var d=this.$q.defer();return d.resolve(this.$scope.data),d.promise}throw new Error("Either the 'data' or the 'async-data-provider' attribute must be specified.")},a.$inject=["RenderService","PathResolver","UISchemaGenerator","SchemaGenerator","$scope","$q"],a}();jsonFormsDirectives.directive("jsonforms",function(){return{restrict:"E",replace:!0,scope:{schema:"=",uiSchema:"=",data:"=",asyncSchema:"&",asyncUiSchema:"&",asyncDataProvider:"="},templateUrl:"templates/form.html",controller:JsonFormsDirectiveController}}).directive("dynamicWidget",["$compile","$templateRequest",function(a,b){var c=function(a){return a.replace("data-jsonforms-model","ng-model='element.instance[element.path]'").replace("data-jsonforms-validation","ng-change='element.validate()'")};return{restrict:"E",scope:{element:"="},replace:!0,link:function(d,e){if(d.element.templateUrl)b(d.element.templateUrl).then(function(b){var f=c(b),g=a(f)(d);e.replaceWith(g)});else{var f=c(d.element.template),g=a(f)(d);e.replaceWith(g)}}}}]).directive("control",function(){return{restrict:"E",replace:!0,transclude:!0,templateUrl:"templates/control.html"}}).directive("layout",function(){return{restrict:"E",replace:!0,transclude:!0,templateUrl:"templates/layout.html"}}).directive("widget",function(){return{restrict:"E",replace:!0,transclude:!0,template:'<div class="col-sm-{{element.size}} jsf-label ng-transclude"></div>'}});var ArrayControl=function(){function a(a,b){this.pathResolver=a,this.scope=b,this.maxSize=99,this.priority=2}return a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"array"==b.type},a.prototype.render=function(a,b,c,d){var e,f=this.createTableUIElement(a,d,b,c);return e=d.data instanceof Array?d.data:this.pathResolver.resolveInstance(d.data,this.pathResolver.toInstancePath(c)),void 0!=e&&(f.tableOptions.gridOptions.data=e.slice(d.page*d.pageSize,d.page*d.pageSize+d.pageSize)),f.tableOptions.gridOptions.paginationPage=d.page,f.tableOptions.gridOptions.paginationPageSize=d.pageSize,f.tableOptions.gridOptions.enableHorizontalScrollbar=0,f.tableOptions.gridOptions.enableVerticalScrollbar=0,{type:"Control",gridOptions:f.tableOptions.gridOptions,size:this.maxSize,template:'<control><div ui-grid="element[\'gridOptions\']" ui-grid-auto-resize ui-grid-pagination class="grid"></div></control>'}},a.prototype.createTableUIElement=function(a,b,c,d){var e,f=this,g=void 0!==b.fetchPage,h=!1,i={schemaType:"array"};if(a.columns)e=a.columns.map(function(a,b){return{field:f.pathResolver.toInstancePath(a.scope.$ref),displayName:a.label}});else{var j=this.pathResolver.resolveSchema(c,d),k=j.items;if(e=[],"object"==k.type)for(var l in k.properties)e.push({field:l,displayName:JSONForms.PathUtil.beautify(l)})}var m={columns:a.columns,gridOptions:{enableFiltering:h,enablePaginationControls:g,enableColumnResizing:!0,enableAutoResize:!0,columnDefs:e,data:[],useExternalFiltering:!0}};return g&&(m.gridOptions.enablePagination=g,m.gridOptions.useExternalPagination=!0,m.gridOptions.paginationPageSizes=[1,2,3,4,5],m.gridOptions.paginationPageSize=1,m.gridOptions.paginationPage=1),b.totalItems&&(m.gridOptions.totalItems=b.totalItems),i.enablePaginationControls=function(){m.gridOptions.enablePaginationControls=!0},i.disablePaginationControls=function(){m.gridOptions.enablePaginationControls=!1},m.gridOptions.onRegisterApi=function(a){a.pagination.on.paginationChanged(f.scope,function(a,c){m.gridOptions.paginationPage=a,m.gridOptions.paginationPageSize=c,b.setPageSize(c),b.fetchPage(a,c).then(function(a){m.gridOptions.data=a})})},i.tableOptions=m,i},a.prototype.findSearchTerms=function(a){for(var b=[],c=0;c<a.columns.length;c++){var d=a.columns[c].filters[0].term;void 0!==d&&null!==d&&b.push({column:a.columns[c].name,term:d})}return b},a}(),app=angular.module("jsonforms.arrayControl",[]);app.run(["RenderService","PathResolver","$rootScope",function(a,b,c){a.register(new ArrayControl(b,c))}]);var AutoCompleteControl=function(){function a(){this.priority=3}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,c,a.label);return e.template='<control><input type="text" auto-complete id="'+c+'" class="form-control jsf-control jsf-control-string" data-jsonforms-model data-jsonforms-validation/></control>',e.suggestion=a.suggestion,e},a.prototype.isApplicable=function(a,b,c){var d="Control"==a.type&&a.hasOwnProperty("suggestion");return d},a}(),app=angular.module("jsonforms.autoCompleteControl",[]).directive("autoComplete",function(a){return function(b,c,d){$(c).autocomplete({source:b.element.suggestion,select:function(){a(function(){$(c).trigger("input")},0)}}).autocomplete("widget").addClass("jsf-control-autocomplete")}});app.run(["RenderService",function(a){a.register(new AutoCompleteControl)}]);var BooleanControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,c,a.label);return e.template='<control><input type="checkbox" id="'+c+'" class="jsf-control jsf-control-boolean" ui-validate="\'element.validate($value)\'" data-jsonforms-model/></control>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"boolean"==b.type},a}(),app=angular.module("jsonforms.booleanControl",[]);app.run(["RenderService",function(a){a.register(new BooleanControl)}]);var Categorization=function(){function a(a){this.renderService=a,this.priority=1}return a.prototype.render=function(a,b,c,d){var e=this,f=function(a){return void 0===a||0==a.length?[]:a.reduce(function(a,b,c,f){return a.push(e.renderService.render(b,d)),a},[])},g=f(a.elements),h='<layout>\n            <tabset>\n                <dynamic-widget ng-repeat="child in element.elements" element="child"></dynamic-widget>\n            </tabset>\n        </layout>\n        ';return{type:"Layout",elements:g,size:99,template:h}},a.prototype.isApplicable=function(a,b,c){return"Categorization"==a.type},a}(),app=angular.module("jsonforms.categorization",["jsonforms.services"]);app.run(["RenderService",function(a){a.register(new Categorization(a))}]);var Category=function(){function a(a){this.renderService=a,this.priority=1}return a.prototype.render=function(a,b,c,d){var e=this,f=function(a){return void 0===a||0==a.length?[]:a.reduce(function(a,b,c,f){return a.push(e.renderService.render(b,d)),a},[])},g=f(a.elements),h=a.label,i='\n        <tab heading="'+h+'">\n            <layout>\n                <fieldset>\n                    <dynamic-widget ng-repeat="child in element.elements" element="child"></dynamic-widget>\n                </fieldset>\n            </layout>\n        </tab>\n        ';return{type:"Layout",elements:g,size:99,template:i}},a.prototype.isApplicable=function(a,b,c){return"Category"==a.type},a}();app.run(["RenderService",function(a){a.register(new Category(a))}]);var DatetimeControl=function(){function a(){this.priority=3}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,c,a.label);return e.isOpen=!1,e.openDate=function(a){a.preventDefault(),a.stopPropagation(),e.isOpen=!0},e.template='<control><div class="input-group">\n              <input type="text" datepicker-popup="dd.MM.yyyy" close-text="Close" is-open="element.isOpen" id="'+c+'" class="form-control jsf-control jsf-control-datetime" data-jsonforms-model/>\n                 <span class="input-group-btn">\n                   <button type="button" class="btn btn-default" ng-click="element.openDate($event)">\n                     <i class="glyphicon glyphicon-calendar"></i>\n                   </button>\n                 </span>\n            </div></control>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"string"==b.type&&void 0!=b.format&&"date-time"==b.format},a}(),app=angular.module("jsonforms.datetimeControl",[]);app.run(["RenderService",function(a){a.register(new DatetimeControl)}]);var EnumControl=function(){function a(a){this.pathResolver=a,this.priority=3}return a.prototype.render=function(a,b,c,d){var e=this.pathResolver.resolveSchema(b,c),f=e["enum"],g=new JSONForms.ControlRenderDescription(d.data,c,a.label);return g.template='<control><select ng-options="option as option for option in element.options" id="'+c+'" class="form-control jsf-control jsf-control-enum" data-jsonforms-model ></select></control>',g.options=f,g},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&b.hasOwnProperty("enum")},a}(),app=angular.module("jsonforms.enumControl",[]);app.run(["RenderService","PathResolver",function(a,b){a.register(new EnumControl(b))}]);var HorizontalLayout=function(){function a(a){var b=this;this.renderServ=a,this.priority=1,this.render=function(a,c,d,e){for(var f=function(a){return void 0===a||0==a.length?[]:a.reduce(function(a,c,d,f){return a.push(b.renderServ.render(c,e)),a},[])},g=99,h=f(a.elements),i=h.length,j=a.label?a.label:"",k=Math.floor(g/i),l=0;l<h.length;l++)h[l].size=k;var m=j?"<layout><fieldset>\n                   <legend>"+j+'</legend>\n                   <div class="row">\n                     <dynamic-widget ng-repeat="child in element.elements" element="child"></dynamic-widget>\n                   </div>\n                 </fieldset></layout>':'<layout><fieldset>\n                   <div class="row">\n                     <dynamic-widget ng-repeat="child in element.elements" element="child"></dynamic-widget>\n                   </div>\n                 </fieldset></layout>';return{type:"Layout",elements:h,size:g,template:m}}}return a.prototype.isApplicable=function(a,b,c){return"HorizontalLayout"==a.type},a}(),app=angular.module("jsonforms.horizontalLayout",[]);app.run(["RenderService",function(a){a.register(new HorizontalLayout(a))}]);var IntegerControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,c,a.label);return e.template='<control><input type="number" step="1" id="'+c+'" class="form-control jsf-control jsf-control-integer" data-jsonforms-validation data-jsonforms-model/></control>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"integer"==b.type},a}(),app=angular.module("jsonforms.integerControl",[]);app.run(["RenderService",function(a){a.register(new IntegerControl)}]);var NumberControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,c,a.label);return e.template='<control><input type="number" step="0.01" id="'+c+'" class="form-control jsf-control jsf-control-number" data-jsonforms-validation data-jsonforms-model/></control>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"number"==b.type},a}(),app=angular.module("jsonforms.numberControl",[]);app.run(["RenderService",function(a){a.register(new NumberControl)}]);var StringControl=function(){function a(){this.priority=2}return a.prototype.render=function(a,b,c,d){var e=new JSONForms.ControlRenderDescription(d.data,c,a.label);return e.template='<control><input type="text" id="'+c+'" class="form-control jsf-control jsf-control-string" data-jsonforms-model data-jsonforms-validation/></control>',e},a.prototype.isApplicable=function(a,b,c){return"Control"==a.type&&"string"==b.type},a}(),app=angular.module("jsonforms.stringControl",[]);app.run(["RenderService",function(a){a.register(new StringControl)}]);var VerticalLayout=function(){function a(a){this.renderService=a,this.priority=1}return a.prototype.render=function(a,b,c,d){var e=this,f=function(a){return void 0===a||0==a.length?[]:a.reduce(function(a,b,c,f){return a.push(e.renderService.render(b,d)),a},[])},g=f(a.elements),h=a.label?a.label:"",i=h?"<layout><fieldset>\n                    <legend>"+h+'</legend>\n                    <dynamic-widget ng-repeat="child in element.elements" element="child">\n                    </dynamic-widget>\n             </fieldset></layout>':'<layout><fieldset>\n                    <dynamic-widget ng-repeat="child in element.elements" element="child">\n                    </dynamic-widget>\n            </fieldset></layout>';return{type:"Layout",elements:g,size:99,template:i}},a.prototype.isApplicable=function(a,b,c){return"VerticalLayout"==a.type||"Group"==a.type},a}(),app=angular.module("jsonforms.verticalLayout",["jsonforms.services"]);app.run(["RenderService",function(a){a.register(new VerticalLayout(a))}]);var Label=function(){function a(){this.priority=1}return a.prototype.render=function(a,b,c,d){var e=a.text,f=99;return{type:"Widget",size:f,template:' <widget><div class="jsf-label">'+e+"</div></widget>"}},a.prototype.isApplicable=function(a){return"Label"==a.type},a}(),app=angular.module("jsonforms.label",["jsonforms.services"]);app.run(["RenderService",function(a){a.register(new Label)}]);var JSONForms;!function(a){var b,c=function(){function a(a){this.json=a,this.type=a.type,this.elements=a.elements}return a}();a.UISchemaElement=c;var d=function(){function a(a,b){var c=this;this.$q=a,this.data=b,this.currentPage=0,this.currentPageSize=2,this.setPageSize=function(a){c.currentPageSize=a},this.fetchPage=function(a,b){c.currentPage=a,c.currentPageSize=b;var d=c.$q.defer();return c.data instanceof Array?d.resolve(c.data.slice(c.currentPage*c.currentPageSize,c.currentPage*c.currentPageSize+c.currentPageSize)):d.resolve(c.data),d.promise},this.totalItems=this.data.length,this.pageSize=this.currentPageSize,this.page=this.currentPage}return a.prototype.fetchData=function(){var a=this.$q.defer();return a.resolve(this.data),a.promise},a}();a.DefaultDataProvider=d;var e=function(){function a(a,b,c){this.instance=a,this.schemaPath=b,this.type="Control",this.size=99,this.alerts=[],this.path=g.normalize(b);var d;d=c?c:g.beautifiedLastFragment(b),this.label=d}return a.prototype.validate=function(){if(void 0==tv4)return!0;for(var a="/"+g.normalize(this.schemaPath),c=tv4.validateMultiple(this.instance,b),d=void 0,e=0;e<c.errors.length;e++){var f=c.errors[e];if(-1!=f.schemaPath.indexOf("/required")){var h=f.params.key;if(h==a.substr(a.lastIndexOf("/")+1,a.length)){d="Missing property";break}}if(f.dataPath==a){d=f.message;break}}if(void 0==d)return this.alerts=[],!0;this.alerts=[];var i={type:"danger",msg:d};return this.alerts.push(i),!1},a}();a.ControlRenderDescription=e;var f=function(){function a(a){var c=this;this.refResolver=a,this.renderers=[],this.render=function(a,d){var e,f,g;a.scope&&(f=a.scope.$ref,g=c.refResolver.resolveSchema(b,f));for(var h=0;h<c.renderers.length;h++)c.renderers[h].isApplicable(a,g,f)&&(void 0==e||c.renderers[h].priority>e.priority)&&(e=c.renderers[h]);if(void 0===e)throw new Error("No applicable renderer found for element "+JSON.stringify(a));var i=e.render(a,b,f,d);return i.validate&&i.validate(),i},this.register=function(a){c.renderers.push(a)}}return a.prototype.registerSchema=function(a){b=a},a.$inject=["PathResolver"],a}();a.RenderService=f;var g=function(){function a(){}return a.beautifiedLastFragment=function(b){return a.beautify(a.capitalizeFirstLetter(b.substr(b.lastIndexOf("/")+1,b.length)))},a.capitalizeFirstLetter=function(a){return a.charAt(0).toUpperCase()+a.slice(1)},a.Keywords=["items","properties","#"],a.normalize=function(b){return a.filterNonKeywords(a.toPropertyFragments(b)).join("/")},a.toPropertyFragments=function(a){return a.split("/").filter(function(a){return a.length>0})},a.filterNonKeywords=function(b){return b.filter(function(b){return!(-1!==a.Keywords.indexOf(b))})},a.beautify=function(a){if(a&&a.length>0){var b=a.split(/(?=[A-Z])/).map(function(a){return a.toLowerCase()});return b[0]=b[0].charAt(0).toUpperCase()+b[0].slice(1),b.join(" ")}return a},a}();a.PathUtil=g;var h=function(){function a(a){var b=this;this.$compile=a,this.pathMapping={},this.addUiPathToSchemaRefMapping=function(a){for(var c in a)a.hasOwnProperty(c)&&(b.pathMapping[c]=a[c])},this.getSchemaRef=function(a){return"#"==a?"#":b.pathMapping[a+"/scope/$ref"]},this.toInstancePath=function(a){return g.normalize(a)},this.resolveUi=function(a,c){var d=c+"/scope/$ref";return void 0!==b.pathMapping&&b.pathMapping.hasOwnProperty(d)&&(d=b.pathMapping[d]),b.resolveInstance(a,d)},this.resolveInstance=function(a,c){var d=g.toPropertyFragments(b.toInstancePath(c));return d.reduce(function(a,b){return a instanceof Array?a.map(function(a){return a[b]}):a[b]},a)},this.resolveSchema=function(a,b){var c=g.toPropertyFragments(b);return c.reduce(function(a,b){return"#"==b?a:a instanceof Array?a.map(function(a){return a[b]}):a[b]},a)}}return a.$inject=["$compile"],a}();a.PathResolver=h;var i=function(){function a(){var a=this;this.generateDefaultSchema=function(b){return a.schemaObject(b,a.allowAdditionalProperties,a.requiredProperties)},this.generateDefaultSchemaWithOptions=function(b,c,d){return a.schemaObject(b,c,d)},this.schemaObject=function(b,c,d){var e=a.properties(b,c,d);return{type:"object",properties:e,additionalProperties:c(e),required:d(a.keys(e))}},this.properties=function(b,c,d){var e={},f=a;return a.keys(b).forEach(function(a){e[a]=f.property(b[a],c,d)}),e},this.keys=function(a){return Object.keys(a)},this.property=function(b,c,d){switch(typeof b){case"string":case"boolean":return{type:typeof b};case"number":return Number(b)%1===0?{type:"integer"}:{type:"number"};case"object":return a.schemaObjectOrNullOrArray(b,c,d);default:return{}}},this.schemaObjectOrNullOrArray=function(b,c,d){return a.isNotNull(b)?a.isArray(b)?a.schemaArray(b,c,d):a.schemaObject(b,c,d):{type:"null"}},this.schemaArray=function(b,c,d){if(b.length){var e=a,f=b.map(function(a){return e.property(a,c,d)}),g=a.distinct(f,function(a){return JSON.stringify(a)});return 1==g.length?{type:"array",items:g[0]}:{type:"array",items:{oneOf:g}}}},this.isArray=function(a){return"[object Array]"===Object.prototype.toString.call(a)},this.isNotNull=function(a){return"undefined"!=typeof a&&null!==a},this.distinct=function(a,b){var c={};return a.filter(function(a){var d=b(a);return c.hasOwnProperty(d)?!1:c[d]=!0})},this.requiredProperties=function(a){return a},this.allowAdditionalProperties=function(a){return!0}}return a}();a.SchemaGenerator=i;var j=function(){function a(){var a=this;this.generateDefaultUISchema=function(b){var c=[];return a.generateUISchema(b,c,"#",""),c[0]},this.generateUISchema=function(b,c,d,e){var f=a.deriveType(b);switch(f){case"object":var h={type:"VerticalLayout",elements:[]};if(c.push(h),e&&""!==e){var i={type:"Label",text:g.beautify(e)};h.elements.push(i)}if(!b.properties)return;var j=d+"/properties";for(var k in b.properties)a.isIgnoredProperty(k,b.properties[k])||a.generateUISchema(b.properties[k],h.elements,j+"/"+k,k);break;case"array":var l={type:"HorizontalLayout",elements:[]};c.push(l);var j=d+"/items";if(!b.items)return;if(b.items instanceof Array)for(var m=0;m<b.items.length;m++)a.generateUISchema(b.items[m],l.elements,j+"["+m+"]","");else a.generateUISchema(b.items,l.elements,j,"");break;case"string":case"number":case"integer":case"boolean":var n=a.getControlObject(g.beautify(e),d);c.push(n);break;case"null":break;default:throw new Error("Unknown type: "+JSON.stringify(b))}},this.isIgnoredProperty=function(a,b){return"id"===a&&"string"==typeof b},this.deriveType=function(a){return a.type?a.type:a.properties||a.additionalProperties?"object":"null"},this.getControlObject=function(a,b){return{type:"Control",label:a,scope:{$ref:b}}}}return a}();a.UISchemaGenerator=j;var k=function(){function a(){}return a.createControlDescription=function(a,b,c){return new e(a,b,c)},a}();a.RenderDescriptionFactory=k}(JSONForms||(JSONForms={})),angular.module("jsonforms.services",[]).service("PathResolver",JSONForms.PathResolver).service("RenderService",JSONForms.RenderService).service("SchemaGenerator",JSONForms.SchemaGenerator).service("UISchemaGenerator",JSONForms.UISchemaGenerator).service("RenderDescriptionFactory",JSONForms.RenderDescriptionFactory),angular.module("jsonforms").run(["$templateCache",function(a){a.put("templates/control.html",'<div class="col-sm-{{element.size}} form-group top-buffer"><div class="row"><label ng-if="element.label" for="element.id">{{element.label}}</label></div><div class="row" style="padding-right: 1em" ng-transclude></div><div class="row" style="padding-right: 1em"><alert ng-repeat="alert in element.alerts" type="{{alert.type}}" class="top-buffer-s jsf-alert">{{alert.msg}}</alert></div></div>'),a.put("templates/form.html",'<div><form role="form" class="jsf-form rounded"><dynamic-widget ng-repeat="child in elements" element="child" bindings="bindings" top-open-date="openDate" top-validate-number="validateNumber" top-validate-integer="validateInteger"></dynamic-widget></form></div>'),a.put("templates/layout.html",'<div class="col-sm-{{element.size}}" ng-transclude></div>')}]);