## Typography

We create a font convention to ensure the best presentation across different platforms.

### Chinese Font

<div class="demo-typo-box typo-PingFang">
  和畅惠风
  <div class="name">PingFang SC</div>
</div>
<div class="demo-typo-box typo-Hiragino">
  和畅惠风
  <div class="name">Hiragino Sans GB</div>
</div>
<div class="demo-typo-box typo-Microsoft">
  和畅惠风
  <div class="name">Microsoft YaHei</div>
</div>

### English / Numberic Font

<div class="demo-typo-box typo-Helvetica-neue">
  RGag
  <div class="name">Helvetica Neue</div>
</div>
<div class="demo-typo-box typo-Helvetica">
  RGag
  <div class="name">Helvetica</div>
</div>
<div class="demo-typo-box typo-Arial">
  RGag
  <div class="name">Arial</div>
</div>

### Font-family

```css
font-family: "Helvetica Neue",Helvetica,"PingFang SC","Hiragino Sans GB","Microsoft YaHei","微软雅黑",Arial,sans-serif;
```

### Font Convention

<table class="demo-typo-size">
  <tbody>
    <tr>
      <td class="h1">Main Title</td>
      <td class="h1">Build with Element</td>
      <td class="color-dark-light">20px  Extra large</td>
    </tr>
    <tr>
      <td class="h2">Title</td>
      <td class="h2">Build with Element</td>
      <td class="color-dark-light">18px large</td>
    </tr>
    <tr>
      <td class="h3">Small Title</td>
      <td class="h3">Build with Element</td>
      <td class="color-dark-light">16px Medium</td>
    </tr>
    <tr>
      <td class="text-regular">Body</td>
      <td class="text-regular">Build with Element</td>
      <td class="color-dark-light">14px Small</td>
    </tr>
    <tr>
      <td class="text-small">Body (small)</td>
      <td class="text-small">Build with Element</td>
      <td class="color-dark-light">13px Extra Small</td>
    </tr>
    <tr>
      <td class="text-smaller">Supplementary text</td>
      <td class="text-smaller">Build with Element</td>
      <td class="color-dark-light">12px Extra Extra Small</td>
    </tr>
  </tbody>
</table>

