<style>
  ul.language-list {
    color: #5e6d82;
    font-size: 14px;
    padding-left: 20px;
    li {
      line-height: 1.8
    }
  }
</style>
## 国际化

Element 组件内部默认使用中文，若希望使用其他语言，则需要进行多语言设置。以英文为例，在 main.js 中：

```javascript
// 完整引入 Element
import Vue from 'vue'
import ElementUI from 'element-ui'
import locale from 'element-ui/lib/locale/lang/en'

Vue.use(ElementUI, { locale })
```

或

```javascript
// 按需引入 Element
import Vue from 'vue'
import { Button, Select } from 'element-ui'
import lang from 'element-ui/lib/locale/lang/en'
import locale from 'element-ui/lib/locale'

// 设置语言
locale.use(lang)

// 引入组件
Vue.component(Button.name, Button)
Vue.component(Select.name, Select)
```

如果使用其它语言，默认情况下中文语言包依旧是被引入的，可以使用 webpack 的 NormalModuleReplacementPlugin 替换默认语言包。

**webpack.config.js**
```javascript
{
  plugins: [
    new webpack.NormalModuleReplacementPlugin(/element-ui[\/\\]lib[\/\\]locale[\/\\]lang[\/\\]zh-CN/, 'element-ui/lib/locale/lang/en')
  ]
}
```

## 兼容 `vue-i18n`

Element 兼容 [vue-i18n](https://github.com/kazupon/vue-i18n)，搭配使用能更方便地实现多语言切换。

```javascript
import Vue from 'vue'
import VueI18n from 'vue-i18n'
import Element from 'element-ui'
import enLocale from 'element-ui/lib/locale/lang/en'
import zhLocale from 'element-ui/lib/locale/lang/zh-CN'

Vue.use(VueI18n)
Vue.use(Element)

Vue.config.lang = 'zh-cn'
Vue.locale('zh-cn', zhLocale)
Vue.locale('en', enLocale)
```

## 兼容其他 i18n 插件
如果不使用 `vue-i18n`，而是用其他的 i18n 插件，Element 将无法兼容，但是可以自定义 Element 的 i18n 的处理方法。

```javascript
import Vue from 'vue'
import Element from 'element-ui'
import enLocale from 'element-ui/lib/locale/lang/en'
import zhLocale from 'element-ui/lib/locale/lang/zh-CN'

Vue.use(Element, {
  i18n: function (path, options) {
    // ...
  }
})
```

## 通过 CDN 的方式加载语言文件

```html
<script src="//unpkg.com/vue"></script>
<script src="//unpkg.com/element-ui"></script>
<script src="//unpkg.com/element-ui/lib/umd/locale/en.js"></script>

<script>
  ELEMENT.locale(ELEMENT.lang.en)
</script>
```

搭配 `vue-i18n` 使用

```html
<script src="//unpkg.com/vue"></script>
<script src="//unpkg.com/vue-i18n/dist/vue-i18n.js"></script>
<script src="//unpkg.com/element-ui"></script>
<script src="//unpkg.com/element-ui/lib/umd/locale/zh-CN.js"></script>
<script src="//unpkg.com/element-ui/lib/umd/locale/en.js"></script>

<script>
  Vue.locale('en', ELEMENT.lang.en)
  Vue.locale('zh-cn', ELEMENT.lang.zhCN)
</script>
```

目前 Element 内置了以下语言：
<ul class="language-list">
  <li>简体中文（zh-CN）</li>
  <li>英语（en）</li>
  <li>德语（de）</li>
  <li>葡萄牙语（pt）</li>
  <li>西班牙语（es）</li>
  <li>丹麦语（da）</li>
  <li>法语（fr）</li>
  <li>挪威语（nb-NO）</li>
  <li>繁体中文（zh-TW）</li>
  <li>意大利语（it）</li>
  <li>韩语（ko）</li>
  <li>日语（ja）</li>
  <li>荷兰语（nl）</li>
  <li>越南语（vi）</li>
  <li>俄语（ru-RU）</li>
  <li>土耳其语（tr-TR）</li>
  <li>巴西葡萄牙语（pt-br）</li>
  <li>波斯语（fa）</li>
  <li>泰语（th）</li>
  <li>印尼语（id）</li>
  <li>保加利亚语（bg）</li>
  <li>波兰语（pl）</li>
  <li>芬兰语（fi）</li>
  <li>瑞典语（sv-SE）</li>
  <li>希腊语（el）</li>
  <li>斯洛伐克语（sk）</li>
</ul>

如果你需要使用其他的语言，欢迎贡献 PR：只需在 [这里](https://github.com/ElemeFE/element/tree/master/src/locale/lang) 添加一个语言配置文件即可。
