// ** file automatically generated by glgen -- do not edit manually **

package GL

// #cgo CXXFLAGS: -std=c++0x -pedantic-errors -Wall -fno-strict-aliasing
// #cgo LDFLAGS: -lstdc++
// #cgo pkg-config: Qt5Core Qt5OpenGL
//
// #include "funcs.h"
//
// void free(void*);
//
import "C"

import (
	"fmt"
	"reflect"
	"unsafe"

	"gopkg.in/qml.v1/gl/glbase"
)

// API returns a value that offers methods matching the OpenGL version 1.5 API.
//
// The returned API must not be used after the provided OpenGL context becomes invalid.
func API(context glbase.Contexter) *GL {
	gl := &GL{}
	gl.funcs = C.gl1_5_funcs()
	if gl.funcs == nil {
		panic(fmt.Errorf("OpenGL version 1.5 is not available"))
	}
	return gl
}

// GL implements the OpenGL version 1.5 API. Values of this
// type must be created via the API function, and it must not be used after
// the associated OpenGL context becomes invalid.
type GL struct {
	funcs unsafe.Pointer
}

const (
	FALSE = 0
	TRUE  = 1
	NONE  = 0

	BYTE           = 0x1400
	UNSIGNED_BYTE  = 0x1401
	SHORT          = 0x1402
	UNSIGNED_SHORT = 0x1403
	INT            = 0x1404
	UNSIGNED_INT   = 0x1405
	FLOAT          = 0x1406
	N2_BYTES       = 0x1407
	N3_BYTES       = 0x1408
	N4_BYTES       = 0x1409
	DOUBLE         = 0x140A

	ACCUM  = 0x0100
	LOAD   = 0x0101
	RETURN = 0x0102
	MULT   = 0x0103
	ADD    = 0x0104

	ACCUM_BUFFER_BIT    = 0x00000200
	ALL_ATTRIB_BITS     = 0xFFFFFFFF
	COLOR_BUFFER_BIT    = 0x00004000
	CURRENT_BIT         = 0x00000001
	DEPTH_BUFFER_BIT    = 0x00000100
	ENABLE_BIT          = 0x00002000
	EVAL_BIT            = 0x00010000
	FOG_BIT             = 0x00000080
	HINT_BIT            = 0x00008000
	LIGHTING_BIT        = 0x00000040
	LINE_BIT            = 0x00000004
	LIST_BIT            = 0x00020000
	MULTISAMPLE_BIT     = 0x20000000
	PIXEL_MODE_BIT      = 0x00000020
	POINT_BIT           = 0x00000002
	POLYGON_BIT         = 0x00000008
	POLYGON_STIPPLE_BIT = 0x00000010
	SCISSOR_BIT         = 0x00080000
	STENCIL_BUFFER_BIT  = 0x00000400
	TEXTURE_BIT         = 0x00040000
	TRANSFORM_BIT       = 0x00001000
	VIEWPORT_BIT        = 0x00000800

	ALWAYS   = 0x0207
	EQUAL    = 0x0202
	GEQUAL   = 0x0206
	GREATER  = 0x0204
	LEQUAL   = 0x0203
	LESS     = 0x0201
	NEVER    = 0x0200
	NOTEQUAL = 0x0205

	LOGIC_OP = 0x0BF1

	DST_ALPHA           = 0x0304
	ONE                 = 1
	ONE_MINUS_DST_ALPHA = 0x0305
	ONE_MINUS_SRC_ALPHA = 0x0303
	ONE_MINUS_SRC_COLOR = 0x0301
	SRC_ALPHA           = 0x0302
	SRC_COLOR           = 0x0300
	ZERO                = 0

	DST_COLOR           = 0x0306
	ONE_MINUS_DST_COLOR = 0x0307
	SRC_ALPHA_SATURATE  = 0x0308

	CLIENT_ALL_ATTRIB_BITS  = 0xFFFFFFFF
	CLIENT_PIXEL_STORE_BIT  = 0x00000001
	CLIENT_VERTEX_ARRAY_BIT = 0x00000002

	CLIP_PLANE0 = 0x3000
	CLIP_PLANE1 = 0x3001
	CLIP_PLANE2 = 0x3002
	CLIP_PLANE3 = 0x3003
	CLIP_PLANE4 = 0x3004
	CLIP_PLANE5 = 0x3005

	BACK           = 0x0405
	FRONT          = 0x0404
	FRONT_AND_BACK = 0x0408

	AMBIENT             = 0x1200
	AMBIENT_AND_DIFFUSE = 0x1602
	DIFFUSE             = 0x1201
	EMISSION            = 0x1600
	SPECULAR            = 0x1202

	AUX0        = 0x0409
	AUX1        = 0x040A
	AUX2        = 0x040B
	AUX3        = 0x040C
	BACK_LEFT   = 0x0402
	BACK_RIGHT  = 0x0403
	FRONT_LEFT  = 0x0400
	FRONT_RIGHT = 0x0401
	LEFT        = 0x0406
	RIGHT       = 0x0407

	ALPHA_TEST           = 0x0BC0
	AUTO_NORMAL          = 0x0D80
	BLEND                = 0x0BE2
	COLOR_ARRAY          = 0x8076
	COLOR_LOGIC_OP       = 0x0BF2
	COLOR_MATERIAL       = 0x0B57
	CULL_FACE            = 0x0B44
	DEPTH_TEST           = 0x0B71
	DITHER               = 0x0BD0
	EDGE_FLAG_ARRAY      = 0x8079
	FOG                  = 0x0B60
	INDEX_ARRAY          = 0x8077
	INDEX_LOGIC_OP       = 0x0BF1
	LIGHT0               = 0x4000
	LIGHT1               = 0x4001
	LIGHT2               = 0x4002
	LIGHT3               = 0x4003
	LIGHT4               = 0x4004
	LIGHT5               = 0x4005
	LIGHT6               = 0x4006
	LIGHT7               = 0x4007
	LIGHTING             = 0x0B50
	LINE_SMOOTH          = 0x0B20
	LINE_STIPPLE         = 0x0B24
	MAP1_COLOR_4         = 0x0D90
	MAP1_INDEX           = 0x0D91
	MAP1_NORMAL          = 0x0D92
	MAP1_TEXTURE_COORD_1 = 0x0D93
	MAP1_TEXTURE_COORD_2 = 0x0D94
	MAP1_TEXTURE_COORD_3 = 0x0D95
	MAP1_TEXTURE_COORD_4 = 0x0D96
	MAP1_VERTEX_3        = 0x0D97
	MAP1_VERTEX_4        = 0x0D98
	MAP2_COLOR_4         = 0x0DB0
	MAP2_INDEX           = 0x0DB1
	MAP2_NORMAL          = 0x0DB2
	MAP2_TEXTURE_COORD_1 = 0x0DB3
	MAP2_TEXTURE_COORD_2 = 0x0DB4
	MAP2_TEXTURE_COORD_3 = 0x0DB5
	MAP2_TEXTURE_COORD_4 = 0x0DB6
	MAP2_VERTEX_3        = 0x0DB7
	MAP2_VERTEX_4        = 0x0DB8
	NORMALIZE            = 0x0BA1
	NORMAL_ARRAY         = 0x8075
	POINT_SMOOTH         = 0x0B10
	POLYGON_OFFSET_FILL  = 0x8037
	POLYGON_OFFSET_LINE  = 0x2A02
	POLYGON_OFFSET_POINT = 0x2A01
	POLYGON_SMOOTH       = 0x0B41
	POLYGON_STIPPLE      = 0x0B42
	SCISSOR_TEST         = 0x0C11
	STENCIL_TEST         = 0x0B90
	TEXTURE_1D           = 0x0DE0
	TEXTURE_2D           = 0x0DE1
	TEXTURE_COORD_ARRAY  = 0x8078
	TEXTURE_GEN_Q        = 0x0C63
	TEXTURE_GEN_R        = 0x0C62
	TEXTURE_GEN_S        = 0x0C60
	TEXTURE_GEN_T        = 0x0C61
	VERTEX_ARRAY         = 0x8074

	INVALID_ENUM      = 0x0500
	INVALID_OPERATION = 0x0502
	INVALID_VALUE     = 0x0501
	NO_ERROR          = 0
	OUT_OF_MEMORY     = 0x0505
	STACK_OVERFLOW    = 0x0503
	STACK_UNDERFLOW   = 0x0504

	N2D               = 0x0600
	N3D               = 0x0601
	N3D_COLOR         = 0x0602
	N3D_COLOR_TEXTURE = 0x0603
	N4D_COLOR_TEXTURE = 0x0604

	BITMAP_TOKEN       = 0x0704
	COPY_PIXEL_TOKEN   = 0x0706
	DRAW_PIXEL_TOKEN   = 0x0705
	LINE_RESET_TOKEN   = 0x0707
	LINE_TOKEN         = 0x0702
	PASS_THROUGH_TOKEN = 0x0700
	POINT_TOKEN        = 0x0701
	POLYGON_TOKEN      = 0x0703

	EXP    = 0x0800
	EXP2   = 0x0801
	LINEAR = 0x2601

	FOG_COLOR   = 0x0B66
	FOG_DENSITY = 0x0B62
	FOG_END     = 0x0B64
	FOG_INDEX   = 0x0B61
	FOG_MODE    = 0x0B65
	FOG_START   = 0x0B63

	CCW = 0x0901
	CW  = 0x0900

	COEFF  = 0x0A00
	DOMAIN = 0x0A02
	ORDER  = 0x0A01

	PIXEL_MAP_A_TO_A = 0x0C79
	PIXEL_MAP_B_TO_B = 0x0C78
	PIXEL_MAP_G_TO_G = 0x0C77
	PIXEL_MAP_I_TO_A = 0x0C75
	PIXEL_MAP_I_TO_B = 0x0C74
	PIXEL_MAP_I_TO_G = 0x0C73
	PIXEL_MAP_I_TO_I = 0x0C70
	PIXEL_MAP_I_TO_R = 0x0C72
	PIXEL_MAP_R_TO_R = 0x0C76
	PIXEL_MAP_S_TO_S = 0x0C71

	ACCUM_ALPHA_BITS              = 0x0D5B
	ACCUM_BLUE_BITS               = 0x0D5A
	ACCUM_CLEAR_VALUE             = 0x0B80
	ACCUM_GREEN_BITS              = 0x0D59
	ACCUM_RED_BITS                = 0x0D58
	ALIASED_LINE_WIDTH_RANGE      = 0x846E
	ALIASED_POINT_SIZE_RANGE      = 0x846D
	ALPHA_BIAS                    = 0x0D1D
	ALPHA_BITS                    = 0x0D55
	ALPHA_SCALE                   = 0x0D1C
	ALPHA_TEST_FUNC               = 0x0BC1
	ALPHA_TEST_REF                = 0x0BC2
	ATTRIB_STACK_DEPTH            = 0x0BB0
	AUX_BUFFERS                   = 0x0C00
	BLEND_DST                     = 0x0BE0
	BLEND_SRC                     = 0x0BE1
	BLUE_BIAS                     = 0x0D1B
	BLUE_BITS                     = 0x0D54
	BLUE_SCALE                    = 0x0D1A
	CLIENT_ATTRIB_STACK_DEPTH     = 0x0BB1
	COLOR_ARRAY_SIZE              = 0x8081
	COLOR_ARRAY_STRIDE            = 0x8083
	COLOR_ARRAY_TYPE              = 0x8082
	COLOR_CLEAR_VALUE             = 0x0C22
	COLOR_MATERIAL_FACE           = 0x0B55
	COLOR_MATERIAL_PARAMETER      = 0x0B56
	COLOR_WRITEMASK               = 0x0C23
	CULL_FACE_MODE                = 0x0B45
	CURRENT_COLOR                 = 0x0B00
	CURRENT_INDEX                 = 0x0B01
	CURRENT_NORMAL                = 0x0B02
	CURRENT_RASTER_COLOR          = 0x0B04
	CURRENT_RASTER_DISTANCE       = 0x0B09
	CURRENT_RASTER_INDEX          = 0x0B05
	CURRENT_RASTER_POSITION       = 0x0B07
	CURRENT_RASTER_POSITION_VALID = 0x0B08
	CURRENT_RASTER_TEXTURE_COORDS = 0x0B06
	CURRENT_TEXTURE_COORDS        = 0x0B03
	DEPTH_BIAS                    = 0x0D1F
	DEPTH_BITS                    = 0x0D56
	DEPTH_CLEAR_VALUE             = 0x0B73
	DEPTH_FUNC                    = 0x0B74
	DEPTH_RANGE                   = 0x0B70
	DEPTH_SCALE                   = 0x0D1E
	DEPTH_WRITEMASK               = 0x0B72
	DOUBLEBUFFER                  = 0x0C32
	DRAW_BUFFER                   = 0x0C01
	EDGE_FLAG                     = 0x0B43
	EDGE_FLAG_ARRAY_STRIDE        = 0x808C
	FEEDBACK_BUFFER_SIZE          = 0x0DF1
	FEEDBACK_BUFFER_TYPE          = 0x0DF2
	FOG_HINT                      = 0x0C54
	FRONT_FACE                    = 0x0B46
	GREEN_BIAS                    = 0x0D19
	GREEN_BITS                    = 0x0D53
	GREEN_SCALE                   = 0x0D18
	INDEX_ARRAY_STRIDE            = 0x8086
	INDEX_ARRAY_TYPE              = 0x8085
	INDEX_BITS                    = 0x0D51
	INDEX_CLEAR_VALUE             = 0x0C20
	INDEX_MODE                    = 0x0C30
	INDEX_OFFSET                  = 0x0D13
	INDEX_SHIFT                   = 0x0D12
	INDEX_WRITEMASK               = 0x0C21
	LIGHT_MODEL_AMBIENT           = 0x0B53
	LIGHT_MODEL_COLOR_CONTROL     = 0x81F8
	LIGHT_MODEL_LOCAL_VIEWER      = 0x0B51
	LIGHT_MODEL_TWO_SIDE          = 0x0B52
	LINE_SMOOTH_HINT              = 0x0C52
	LINE_STIPPLE_PATTERN          = 0x0B25
	LINE_STIPPLE_REPEAT           = 0x0B26
	LINE_WIDTH                    = 0x0B21
	LINE_WIDTH_GRANULARITY        = 0x0B23
	LINE_WIDTH_RANGE              = 0x0B22
	LIST_BASE                     = 0x0B32
	LIST_INDEX                    = 0x0B33
	LIST_MODE                     = 0x0B30
	LOGIC_OP_MODE                 = 0x0BF0
	MAP1_GRID_DOMAIN              = 0x0DD0
	MAP1_GRID_SEGMENTS            = 0x0DD1
	MAP2_GRID_DOMAIN              = 0x0DD2
	MAP2_GRID_SEGMENTS            = 0x0DD3
	MAP_COLOR                     = 0x0D10
	MAP_STENCIL                   = 0x0D11
	MATRIX_MODE                   = 0x0BA0
	MAX_ATTRIB_STACK_DEPTH        = 0x0D35
	MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B
	MAX_CLIP_PLANES               = 0x0D32
	MAX_EVAL_ORDER                = 0x0D30
	MAX_LIGHTS                    = 0x0D31
	MAX_LIST_NESTING              = 0x0B31
	MAX_MODELVIEW_STACK_DEPTH     = 0x0D36
	MAX_NAME_STACK_DEPTH          = 0x0D37
	MAX_PIXEL_MAP_TABLE           = 0x0D34
	MAX_PROJECTION_STACK_DEPTH    = 0x0D38
	MAX_TEXTURE_SIZE              = 0x0D33
	MAX_TEXTURE_STACK_DEPTH       = 0x0D39
	MAX_VIEWPORT_DIMS             = 0x0D3A
	MODELVIEW_MATRIX              = 0x0BA6
	MODELVIEW_STACK_DEPTH         = 0x0BA3
	NAME_STACK_DEPTH              = 0x0D70
	NORMAL_ARRAY_STRIDE           = 0x807F
	NORMAL_ARRAY_TYPE             = 0x807E
	PACK_ALIGNMENT                = 0x0D05
	PACK_LSB_FIRST                = 0x0D01
	PACK_ROW_LENGTH               = 0x0D02
	PACK_SKIP_PIXELS              = 0x0D04
	PACK_SKIP_ROWS                = 0x0D03
	PACK_SWAP_BYTES               = 0x0D00
	PERSPECTIVE_CORRECTION_HINT   = 0x0C50
	PIXEL_MAP_A_TO_A_SIZE         = 0x0CB9
	PIXEL_MAP_B_TO_B_SIZE         = 0x0CB8
	PIXEL_MAP_G_TO_G_SIZE         = 0x0CB7
	PIXEL_MAP_I_TO_A_SIZE         = 0x0CB5
	PIXEL_MAP_I_TO_B_SIZE         = 0x0CB4
	PIXEL_MAP_I_TO_G_SIZE         = 0x0CB3
	PIXEL_MAP_I_TO_I_SIZE         = 0x0CB0
	PIXEL_MAP_I_TO_R_SIZE         = 0x0CB2
	PIXEL_MAP_R_TO_R_SIZE         = 0x0CB6
	PIXEL_MAP_S_TO_S_SIZE         = 0x0CB1
	POINT_SIZE                    = 0x0B11
	POINT_SIZE_GRANULARITY        = 0x0B13
	POINT_SIZE_RANGE              = 0x0B12
	POINT_SMOOTH_HINT             = 0x0C51
	POLYGON_MODE                  = 0x0B40
	POLYGON_OFFSET_FACTOR         = 0x8038
	POLYGON_OFFSET_UNITS          = 0x2A00
	POLYGON_SMOOTH_HINT           = 0x0C53
	PROJECTION_MATRIX             = 0x0BA7
	PROJECTION_STACK_DEPTH        = 0x0BA4
	READ_BUFFER                   = 0x0C02
	RED_BIAS                      = 0x0D15
	RED_BITS                      = 0x0D52
	RED_SCALE                     = 0x0D14
	RENDER_MODE                   = 0x0C40
	RGBA_MODE                     = 0x0C31
	SCISSOR_BOX                   = 0x0C10
	SELECTION_BUFFER_SIZE         = 0x0DF4
	SHADE_MODEL                   = 0x0B54
	SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23
	SMOOTH_LINE_WIDTH_RANGE       = 0x0B22
	SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13
	SMOOTH_POINT_SIZE_RANGE       = 0x0B12
	STENCIL_BITS                  = 0x0D57
	STENCIL_CLEAR_VALUE           = 0x0B91
	STENCIL_FAIL                  = 0x0B94
	STENCIL_FUNC                  = 0x0B92
	STENCIL_PASS_DEPTH_FAIL       = 0x0B95
	STENCIL_PASS_DEPTH_PASS       = 0x0B96
	STENCIL_REF                   = 0x0B97
	STENCIL_VALUE_MASK            = 0x0B93
	STENCIL_WRITEMASK             = 0x0B98
	STEREO                        = 0x0C33
	SUBPIXEL_BITS                 = 0x0D50
	TEXTURE_BINDING_1D            = 0x8068
	TEXTURE_BINDING_2D            = 0x8069
	TEXTURE_BINDING_3D            = 0x806A
	TEXTURE_COORD_ARRAY_SIZE      = 0x8088
	TEXTURE_COORD_ARRAY_STRIDE    = 0x808A
	TEXTURE_COORD_ARRAY_TYPE      = 0x8089
	TEXTURE_MATRIX                = 0x0BA8
	TEXTURE_STACK_DEPTH           = 0x0BA5
	UNPACK_ALIGNMENT              = 0x0CF5
	UNPACK_LSB_FIRST              = 0x0CF1
	UNPACK_ROW_LENGTH             = 0x0CF2
	UNPACK_SKIP_PIXELS            = 0x0CF4
	UNPACK_SKIP_ROWS              = 0x0CF3
	UNPACK_SWAP_BYTES             = 0x0CF0
	VERTEX_ARRAY_SIZE             = 0x807A
	VERTEX_ARRAY_STRIDE           = 0x807C
	VERTEX_ARRAY_TYPE             = 0x807B
	VIEWPORT                      = 0x0BA2
	ZOOM_X                        = 0x0D16
	ZOOM_Y                        = 0x0D17

	COLOR_ARRAY_POINTER         = 0x8090
	EDGE_FLAG_ARRAY_POINTER     = 0x8093
	FEEDBACK_BUFFER_POINTER     = 0x0DF0
	INDEX_ARRAY_POINTER         = 0x8091
	NORMAL_ARRAY_POINTER        = 0x808F
	SELECTION_BUFFER_POINTER    = 0x0DF3
	TEXTURE_COORD_ARRAY_POINTER = 0x8092
	VERTEX_ARRAY_POINTER        = 0x808E

	TEXTURE_ALPHA_SIZE      = 0x805F
	TEXTURE_BLUE_SIZE       = 0x805E
	TEXTURE_BORDER          = 0x1005
	TEXTURE_BORDER_COLOR    = 0x1004
	TEXTURE_COMPONENTS      = 0x1003
	TEXTURE_GREEN_SIZE      = 0x805D
	TEXTURE_HEIGHT          = 0x1001
	TEXTURE_INTENSITY_SIZE  = 0x8061
	TEXTURE_INTERNAL_FORMAT = 0x1003
	TEXTURE_LUMINANCE_SIZE  = 0x8060
	TEXTURE_MAG_FILTER      = 0x2800
	TEXTURE_MIN_FILTER      = 0x2801
	TEXTURE_PRIORITY        = 0x8066
	TEXTURE_RED_SIZE        = 0x805C
	TEXTURE_RESIDENT        = 0x8067
	TEXTURE_WIDTH           = 0x1000
	TEXTURE_WRAP_S          = 0x2802
	TEXTURE_WRAP_T          = 0x2803

	DONT_CARE = 0x1100
	FASTEST   = 0x1101
	NICEST    = 0x1102

	GENERATE_MIPMAP_HINT     = 0x8192
	TEXTURE_COMPRESSION_HINT = 0x84EF

	C3F_V3F         = 0x2A24
	C4F_N3F_V3F     = 0x2A26
	C4UB_V2F        = 0x2A22
	C4UB_V3F        = 0x2A23
	N3F_V3F         = 0x2A25
	T2F_C3F_V3F     = 0x2A2A
	T2F_C4F_N3F_V3F = 0x2A2C
	T2F_C4UB_V3F    = 0x2A29
	T2F_N3F_V3F     = 0x2A2B
	T2F_V3F         = 0x2A27
	T4F_C4F_N3F_V4F = 0x2A2D
	T4F_V4F         = 0x2A28
	V2F             = 0x2A20
	V3F             = 0x2A21

	MODULATE = 0x2100
	REPLACE  = 0x1E01

	SEPARATE_SPECULAR_COLOR = 0x81FA
	SINGLE_COLOR            = 0x81F9

	CONSTANT_ATTENUATION  = 0x1207
	LINEAR_ATTENUATION    = 0x1208
	POSITION              = 0x1203
	QUADRATIC_ATTENUATION = 0x1209
	SPOT_CUTOFF           = 0x1206
	SPOT_DIRECTION        = 0x1204
	SPOT_EXPONENT         = 0x1205

	COMPILE             = 0x1300
	COMPILE_AND_EXECUTE = 0x1301

	AND           = 0x1501
	AND_INVERTED  = 0x1504
	AND_REVERSE   = 0x1502
	CLEAR         = 0x1500
	COPY          = 0x1503
	COPY_INVERTED = 0x150C
	EQUIV         = 0x1509
	INVERT        = 0x150A
	NAND          = 0x150E
	NOOP          = 0x1505
	NOR           = 0x1508
	OR            = 0x1507
	OR_INVERTED   = 0x150D
	OR_REVERSE    = 0x150B
	SET           = 0x150F
	XOR           = 0x1506

	COLOR_INDEXES = 0x1603
	SHININESS     = 0x1601

	MODELVIEW  = 0x1700
	PROJECTION = 0x1701
	TEXTURE    = 0x1702

	LINE  = 0x1B01
	POINT = 0x1B00

	FILL = 0x1B02

	COLOR   = 0x1800
	DEPTH   = 0x1801
	STENCIL = 0x1802

	ALPHA           = 0x1906
	BLUE            = 0x1905
	COLOR_INDEX     = 0x1900
	DEPTH_COMPONENT = 0x1902
	GREEN           = 0x1904
	LUMINANCE       = 0x1909
	LUMINANCE_ALPHA = 0x190A
	RED             = 0x1903
	RGB             = 0x1907
	RGBA            = 0x1908
	STENCIL_INDEX   = 0x1901

	ALPHA12             = 0x803D
	ALPHA16             = 0x803E
	ALPHA4              = 0x803B
	ALPHA8              = 0x803C
	INTENSITY           = 0x8049
	INTENSITY12         = 0x804C
	INTENSITY16         = 0x804D
	INTENSITY4          = 0x804A
	INTENSITY8          = 0x804B
	LUMINANCE12         = 0x8041
	LUMINANCE12_ALPHA12 = 0x8047
	LUMINANCE12_ALPHA4  = 0x8046
	LUMINANCE16         = 0x8042
	LUMINANCE16_ALPHA16 = 0x8048
	LUMINANCE4          = 0x803F
	LUMINANCE4_ALPHA4   = 0x8043
	LUMINANCE6_ALPHA2   = 0x8044
	LUMINANCE8          = 0x8040
	LUMINANCE8_ALPHA8   = 0x8045
	R3_G3_B2            = 0x2A10
	RGB10               = 0x8052
	RGB10_A2            = 0x8059
	RGB12               = 0x8053
	RGB16               = 0x8054
	RGB4                = 0x804F
	RGB5                = 0x8050
	RGB5_A1             = 0x8057
	RGB8                = 0x8051
	RGBA12              = 0x805A
	RGBA16              = 0x805B
	RGBA2               = 0x8055
	RGBA4               = 0x8056
	RGBA8               = 0x8058

	PACK_IMAGE_HEIGHT   = 0x806C
	PACK_SKIP_IMAGES    = 0x806B
	UNPACK_IMAGE_HEIGHT = 0x806E
	UNPACK_SKIP_IMAGES  = 0x806D

	BITMAP                  = 0x1A00
	UNSIGNED_BYTE_3_3_2     = 0x8032
	UNSIGNED_INT_10_10_10_2 = 0x8036
	UNSIGNED_INT_8_8_8_8    = 0x8035
	UNSIGNED_SHORT_4_4_4_4  = 0x8033
	UNSIGNED_SHORT_5_5_5_1  = 0x8034

	POINT_DISTANCE_ATTENUATION = 0x8129
	POINT_FADE_THRESHOLD_SIZE  = 0x8128
	POINT_SIZE_MAX             = 0x8127
	POINT_SIZE_MIN             = 0x8126

	LINES          = 0x0001
	LINE_LOOP      = 0x0002
	LINE_STRIP     = 0x0003
	POINTS         = 0x0000
	POLYGON        = 0x0009
	QUADS          = 0x0007
	QUAD_STRIP     = 0x0008
	TRIANGLES      = 0x0004
	TRIANGLE_FAN   = 0x0006
	TRIANGLE_STRIP = 0x0005

	FEEDBACK = 0x1C01
	RENDER   = 0x1C00
	SELECT   = 0x1C02

	FLAT   = 0x1D00
	SMOOTH = 0x1D01

	DECR = 0x1E03
	INCR = 0x1E02
	KEEP = 0x1E00

	EXTENSIONS = 0x1F03
	RENDERER   = 0x1F01
	VENDOR     = 0x1F00
	VERSION    = 0x1F02

	S = 0x2000
	T = 0x2001
	R = 0x2002
	Q = 0x2003

	DECAL = 0x2101

	TEXTURE_ENV_COLOR = 0x2201
	TEXTURE_ENV_MODE  = 0x2200

	TEXTURE_ENV = 0x2300

	EYE_LINEAR    = 0x2400
	OBJECT_LINEAR = 0x2401
	SPHERE_MAP    = 0x2402

	EYE_PLANE        = 0x2502
	OBJECT_PLANE     = 0x2501
	TEXTURE_GEN_MODE = 0x2500

	NEAREST = 0x2600

	LINEAR_MIPMAP_LINEAR   = 0x2703
	LINEAR_MIPMAP_NEAREST  = 0x2701
	NEAREST_MIPMAP_LINEAR  = 0x2702
	NEAREST_MIPMAP_NEAREST = 0x2700

	GENERATE_MIPMAP = 0x8191
	TEXTURE_WRAP_R  = 0x8072

	PROXY_TEXTURE_1D   = 0x8063
	PROXY_TEXTURE_2D   = 0x8064
	PROXY_TEXTURE_3D   = 0x8070
	TEXTURE_3D         = 0x806F
	TEXTURE_BASE_LEVEL = 0x813C
	TEXTURE_MAX_LEVEL  = 0x813D
	TEXTURE_MAX_LOD    = 0x813B
	TEXTURE_MIN_LOD    = 0x813A

	CLAMP           = 0x2900
	CLAMP_TO_BORDER = 0x812D
	CLAMP_TO_EDGE   = 0x812F
	REPEAT          = 0x2901

	CONSTANT_COLOR                       = 0x8001
	ONE_MINUS_CONSTANT_COLOR             = 0x8002
	CONSTANT_ALPHA                       = 0x8003
	ONE_MINUS_CONSTANT_ALPHA             = 0x8004
	FUNC_ADD                             = 0x8006
	MIN                                  = 0x8007
	MAX                                  = 0x8008
	FUNC_SUBTRACT                        = 0x800A
	FUNC_REVERSE_SUBTRACT                = 0x800B
	RESCALE_NORMAL                       = 0x803A
	TEXTURE_DEPTH                        = 0x8071
	MAX_3D_TEXTURE_SIZE                  = 0x8073
	MULTISAMPLE                          = 0x809D
	SAMPLE_ALPHA_TO_COVERAGE             = 0x809E
	SAMPLE_ALPHA_TO_ONE                  = 0x809F
	SAMPLE_COVERAGE                      = 0x80A0
	SAMPLE_BUFFERS                       = 0x80A8
	SAMPLES                              = 0x80A9
	SAMPLE_COVERAGE_VALUE                = 0x80AA
	SAMPLE_COVERAGE_INVERT               = 0x80AB
	BLEND_DST_RGB                        = 0x80C8
	BLEND_SRC_RGB                        = 0x80C9
	BLEND_DST_ALPHA                      = 0x80CA
	BLEND_SRC_ALPHA                      = 0x80CB
	BGR                                  = 0x80E0
	BGRA                                 = 0x80E1
	MAX_ELEMENTS_VERTICES                = 0x80E8
	MAX_ELEMENTS_INDICES                 = 0x80E9
	DEPTH_COMPONENT16                    = 0x81A5
	DEPTH_COMPONENT24                    = 0x81A6
	DEPTH_COMPONENT32                    = 0x81A7
	UNSIGNED_BYTE_2_3_3_REV              = 0x8362
	UNSIGNED_SHORT_5_6_5                 = 0x8363
	UNSIGNED_SHORT_5_6_5_REV             = 0x8364
	UNSIGNED_SHORT_4_4_4_4_REV           = 0x8365
	UNSIGNED_SHORT_1_5_5_5_REV           = 0x8366
	UNSIGNED_INT_8_8_8_8_REV             = 0x8367
	UNSIGNED_INT_2_10_10_10_REV          = 0x8368
	MIRRORED_REPEAT                      = 0x8370
	FOG_COORDINATE_SOURCE                = 0x8450
	FOG_COORD_SRC                        = 0x8450
	FOG_COORDINATE                       = 0x8451
	FOG_COORD                            = 0x8451
	FRAGMENT_DEPTH                       = 0x8452
	CURRENT_FOG_COORDINATE               = 0x8453
	CURRENT_FOG_COORD                    = 0x8453
	FOG_COORDINATE_ARRAY_TYPE            = 0x8454
	FOG_COORD_ARRAY_TYPE                 = 0x8454
	FOG_COORDINATE_ARRAY_STRIDE          = 0x8455
	FOG_COORD_ARRAY_STRIDE               = 0x8455
	FOG_COORDINATE_ARRAY_POINTER         = 0x8456
	FOG_COORD_ARRAY_POINTER              = 0x8456
	FOG_COORDINATE_ARRAY                 = 0x8457
	FOG_COORD_ARRAY                      = 0x8457
	COLOR_SUM                            = 0x8458
	CURRENT_SECONDARY_COLOR              = 0x8459
	SECONDARY_COLOR_ARRAY_SIZE           = 0x845A
	SECONDARY_COLOR_ARRAY_TYPE           = 0x845B
	SECONDARY_COLOR_ARRAY_STRIDE         = 0x845C
	SECONDARY_COLOR_ARRAY_POINTER        = 0x845D
	SECONDARY_COLOR_ARRAY                = 0x845E
	TEXTURE0                             = 0x84C0
	TEXTURE1                             = 0x84C1
	TEXTURE2                             = 0x84C2
	TEXTURE3                             = 0x84C3
	TEXTURE4                             = 0x84C4
	TEXTURE5                             = 0x84C5
	TEXTURE6                             = 0x84C6
	TEXTURE7                             = 0x84C7
	TEXTURE8                             = 0x84C8
	TEXTURE9                             = 0x84C9
	TEXTURE10                            = 0x84CA
	TEXTURE11                            = 0x84CB
	TEXTURE12                            = 0x84CC
	TEXTURE13                            = 0x84CD
	TEXTURE14                            = 0x84CE
	TEXTURE15                            = 0x84CF
	TEXTURE16                            = 0x84D0
	TEXTURE17                            = 0x84D1
	TEXTURE18                            = 0x84D2
	TEXTURE19                            = 0x84D3
	TEXTURE20                            = 0x84D4
	TEXTURE21                            = 0x84D5
	TEXTURE22                            = 0x84D6
	TEXTURE23                            = 0x84D7
	TEXTURE24                            = 0x84D8
	TEXTURE25                            = 0x84D9
	TEXTURE26                            = 0x84DA
	TEXTURE27                            = 0x84DB
	TEXTURE28                            = 0x84DC
	TEXTURE29                            = 0x84DD
	TEXTURE30                            = 0x84DE
	TEXTURE31                            = 0x84DF
	ACTIVE_TEXTURE                       = 0x84E0
	CLIENT_ACTIVE_TEXTURE                = 0x84E1
	MAX_TEXTURE_UNITS                    = 0x84E2
	TRANSPOSE_MODELVIEW_MATRIX           = 0x84E3
	TRANSPOSE_PROJECTION_MATRIX          = 0x84E4
	TRANSPOSE_TEXTURE_MATRIX             = 0x84E5
	TRANSPOSE_COLOR_MATRIX               = 0x84E6
	SUBTRACT                             = 0x84E7
	COMPRESSED_ALPHA                     = 0x84E9
	COMPRESSED_LUMINANCE                 = 0x84EA
	COMPRESSED_LUMINANCE_ALPHA           = 0x84EB
	COMPRESSED_INTENSITY                 = 0x84EC
	COMPRESSED_RGB                       = 0x84ED
	COMPRESSED_RGBA                      = 0x84EE
	MAX_TEXTURE_LOD_BIAS                 = 0x84FD
	TEXTURE_FILTER_CONTROL               = 0x8500
	TEXTURE_LOD_BIAS                     = 0x8501
	INCR_WRAP                            = 0x8507
	DECR_WRAP                            = 0x8508
	NORMAL_MAP                           = 0x8511
	REFLECTION_MAP                       = 0x8512
	TEXTURE_CUBE_MAP                     = 0x8513
	TEXTURE_BINDING_CUBE_MAP             = 0x8514
	TEXTURE_CUBE_MAP_POSITIVE_X          = 0x8515
	TEXTURE_CUBE_MAP_NEGATIVE_X          = 0x8516
	TEXTURE_CUBE_MAP_POSITIVE_Y          = 0x8517
	TEXTURE_CUBE_MAP_NEGATIVE_Y          = 0x8518
	TEXTURE_CUBE_MAP_POSITIVE_Z          = 0x8519
	TEXTURE_CUBE_MAP_NEGATIVE_Z          = 0x851A
	PROXY_TEXTURE_CUBE_MAP               = 0x851B
	MAX_CUBE_MAP_TEXTURE_SIZE            = 0x851C
	COMBINE                              = 0x8570
	COMBINE_RGB                          = 0x8571
	COMBINE_ALPHA                        = 0x8572
	RGB_SCALE                            = 0x8573
	ADD_SIGNED                           = 0x8574
	INTERPOLATE                          = 0x8575
	CONSTANT                             = 0x8576
	PRIMARY_COLOR                        = 0x8577
	PREVIOUS                             = 0x8578
	SOURCE0_RGB                          = 0x8580
	SRC0_RGB                             = 0x8580
	SOURCE1_RGB                          = 0x8581
	SRC1_RGB                             = 0x8581
	SOURCE2_RGB                          = 0x8582
	SRC2_RGB                             = 0x8582
	SOURCE0_ALPHA                        = 0x8588
	SRC0_ALPHA                           = 0x8588
	SOURCE1_ALPHA                        = 0x8589
	SRC1_ALPHA                           = 0x8589
	SOURCE2_ALPHA                        = 0x858A
	SRC2_ALPHA                           = 0x858A
	OPERAND0_RGB                         = 0x8590
	OPERAND1_RGB                         = 0x8591
	OPERAND2_RGB                         = 0x8592
	OPERAND0_ALPHA                       = 0x8598
	OPERAND1_ALPHA                       = 0x8599
	OPERAND2_ALPHA                       = 0x859A
	TEXTURE_COMPRESSED_IMAGE_SIZE        = 0x86A0
	TEXTURE_COMPRESSED                   = 0x86A1
	NUM_COMPRESSED_TEXTURE_FORMATS       = 0x86A2
	COMPRESSED_TEXTURE_FORMATS           = 0x86A3
	DOT3_RGB                             = 0x86AE
	DOT3_RGBA                            = 0x86AF
	BUFFER_SIZE                          = 0x8764
	BUFFER_USAGE                         = 0x8765
	TEXTURE_DEPTH_SIZE                   = 0x884A
	DEPTH_TEXTURE_MODE                   = 0x884B
	TEXTURE_COMPARE_MODE                 = 0x884C
	TEXTURE_COMPARE_FUNC                 = 0x884D
	COMPARE_R_TO_TEXTURE                 = 0x884E
	QUERY_COUNTER_BITS                   = 0x8864
	CURRENT_QUERY                        = 0x8865
	QUERY_RESULT                         = 0x8866
	QUERY_RESULT_AVAILABLE               = 0x8867
	ARRAY_BUFFER                         = 0x8892
	ELEMENT_ARRAY_BUFFER                 = 0x8893
	ARRAY_BUFFER_BINDING                 = 0x8894
	ELEMENT_ARRAY_BUFFER_BINDING         = 0x8895
	VERTEX_ARRAY_BUFFER_BINDING          = 0x8896
	NORMAL_ARRAY_BUFFER_BINDING          = 0x8897
	COLOR_ARRAY_BUFFER_BINDING           = 0x8898
	INDEX_ARRAY_BUFFER_BINDING           = 0x8899
	TEXTURE_COORD_ARRAY_BUFFER_BINDING   = 0x889A
	EDGE_FLAG_ARRAY_BUFFER_BINDING       = 0x889B
	SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C
	FOG_COORDINATE_ARRAY_BUFFER_BINDING  = 0x889D
	FOG_COORD_ARRAY_BUFFER_BINDING       = 0x889D
	WEIGHT_ARRAY_BUFFER_BINDING          = 0x889E
	VERTEX_ATTRIB_ARRAY_BUFFER_BINDING   = 0x889F
	READ_ONLY                            = 0x88B8
	WRITE_ONLY                           = 0x88B9
	READ_WRITE                           = 0x88BA
	BUFFER_ACCESS                        = 0x88BB
	BUFFER_MAPPED                        = 0x88BC
	BUFFER_MAP_POINTER                   = 0x88BD
	STREAM_DRAW                          = 0x88E0
	STREAM_READ                          = 0x88E1
	STREAM_COPY                          = 0x88E2
	STATIC_DRAW                          = 0x88E4
	STATIC_READ                          = 0x88E5
	STATIC_COPY                          = 0x88E6
	DYNAMIC_DRAW                         = 0x88E8
	DYNAMIC_READ                         = 0x88E9
	DYNAMIC_COPY                         = 0x88EA
	SAMPLES_PASSED                       = 0x8914
)

// https://www.opengl.org/sdk/docs/man2/xhtml/glViewport.xml
func (gl *GL) Viewport(x, y, width, height int) {
	C.gl1_5_glViewport(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// DepthRange specifies the mapping of depth values from normalized device
// coordinates to window coordinates.
//
// Parameter nearVal specifies the mapping of the near clipping plane to window
// coordinates (defaults to 0), while farVal specifies the mapping of the far
// clipping plane to window coordinates (defaults to 1).
//
// After clipping and division by w, depth coordinates range from -1 to 1,
// corresponding to the near and far clipping planes. DepthRange specifies a
// linear mapping of the normalized depth coordinates in this range to window
// depth coordinates. Regardless of the actual depth buffer implementation,
// window coordinate depth values are treated as though they range from 0 through 1
// (like color components). Thus, the values accepted by DepthRange are both
// clamped to this range before they are accepted.
//
// The default setting of (0, 1) maps the near plane to 0 and the far plane to 1.
// With this mapping, the depth buffer range is fully utilized.
//
// It is not necessary that nearVal be less than farVal. Reverse mappings such as
// nearVal 1, and farVal 0 are acceptable.
//
// GL.INVALID_OPERATION is generated if DepthRange is executed between the
// execution of Begin and the corresponding execution of End.
func (gl *GL) DepthRange(nearVal, farVal float64) {
	C.gl1_5_glDepthRange(gl.funcs, C.GLdouble(nearVal), C.GLdouble(farVal))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsEnabled.xml
func (gl *GL) IsEnabled(cap glbase.Enum) bool {
	glresult := C.gl1_5_glIsEnabled(gl.funcs, C.GLenum(cap))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexLevelParameteriv.xml
func (gl *GL) GetTexLevelParameteriv(target glbase.Enum, level int, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetTexLevelParameteriv(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexLevelParameterfv.xml
func (gl *GL) GetTexLevelParameterfv(target glbase.Enum, level int, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetTexLevelParameterfv(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameteriv.xml
func (gl *GL) GetTexParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetTexParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameterfv.xml
func (gl *GL) GetTexParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetTexParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexImage.xml
func (gl *GL) GetTexImage(target glbase.Enum, level int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetTexImage(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetIntegerv.xml
func (gl *GL) GetIntegerv(pname glbase.Enum, params []int32) {
	C.gl1_5_glGetIntegerv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetFloatv.xml
func (gl *GL) GetFloatv(pname glbase.Enum, params []float32) {
	C.gl1_5_glGetFloatv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetError.xml
func (gl *GL) GetError() glbase.Enum {
	glresult := C.gl1_5_glGetError(gl.funcs)
	return glbase.Enum(glresult)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetDoublev.xml
func (gl *GL) GetDoublev(pname glbase.Enum, params []float64) {
	C.gl1_5_glGetDoublev(gl.funcs, C.GLenum(pname), (*C.GLdouble)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetBooleanv.xml
func (gl *GL) GetBooleanv(pname glbase.Enum, params []bool) {
	C.gl1_5_glGetBooleanv(gl.funcs, C.GLenum(pname), (*C.GLboolean)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glReadPixels.xml
func (gl *GL) ReadPixels(x, y, width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glReadPixels(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glReadBuffer.xml
func (gl *GL) ReadBuffer(mode glbase.Enum) {
	C.gl1_5_glReadBuffer(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelStorei.xml
func (gl *GL) PixelStorei(pname glbase.Enum, param int32) {
	C.gl1_5_glPixelStorei(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelStoref.xml
func (gl *GL) PixelStoref(pname glbase.Enum, param float32) {
	C.gl1_5_glPixelStoref(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDepthFunc.xml
func (gl *GL) DepthFunc(glfunc glbase.Enum) {
	C.gl1_5_glDepthFunc(gl.funcs, C.GLenum(glfunc))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilOp.xml
func (gl *GL) StencilOp(fail, zfail, zpass glbase.Enum) {
	C.gl1_5_glStencilOp(gl.funcs, C.GLenum(fail), C.GLenum(zfail), C.GLenum(zpass))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilFunc.xml
func (gl *GL) StencilFunc(glfunc glbase.Enum, ref int32, mask uint32) {
	C.gl1_5_glStencilFunc(gl.funcs, C.GLenum(glfunc), C.GLint(ref), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLogicOp.xml
func (gl *GL) LogicOp(opcode glbase.Enum) {
	C.gl1_5_glLogicOp(gl.funcs, C.GLenum(opcode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFunc.xml
func (gl *GL) BlendFunc(sfactor, dfactor glbase.Enum) {
	C.gl1_5_glBlendFunc(gl.funcs, C.GLenum(sfactor), C.GLenum(dfactor))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFlush.xml
func (gl *GL) Flush() {
	C.gl1_5_glFlush(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFinish.xml
func (gl *GL) Finish() {
	C.gl1_5_glFinish(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEnable.xml
func (gl *GL) Enable(cap glbase.Enum) {
	C.gl1_5_glEnable(gl.funcs, C.GLenum(cap))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDisable.xml
func (gl *GL) Disable(cap glbase.Enum) {
	C.gl1_5_glDisable(gl.funcs, C.GLenum(cap))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDepthMask.xml
func (gl *GL) DepthMask(flag bool) {
	C.gl1_5_glDepthMask(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&flag)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorMask.xml
func (gl *GL) ColorMask(red, green, blue, alpha bool) {
	C.gl1_5_glColorMask(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&red)), *(*C.GLboolean)(unsafe.Pointer(&green)), *(*C.GLboolean)(unsafe.Pointer(&blue)), *(*C.GLboolean)(unsafe.Pointer(&alpha)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilMask.xml
func (gl *GL) StencilMask(mask uint32) {
	C.gl1_5_glStencilMask(gl.funcs, C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearDepth.xml
func (gl *GL) ClearDepth(depth float64) {
	C.gl1_5_glClearDepth(gl.funcs, C.GLdouble(depth))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearStencil.xml
func (gl *GL) ClearStencil(s int32) {
	C.gl1_5_glClearStencil(gl.funcs, C.GLint(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearColor.xml
func (gl *GL) ClearColor(red, green, blue, alpha float32) {
	C.gl1_5_glClearColor(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue), C.GLfloat(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClear.xml
func (gl *GL) Clear(mask glbase.Bitfield) {
	C.gl1_5_glClear(gl.funcs, C.GLbitfield(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawBuffer.xml
func (gl *GL) DrawBuffer(mode glbase.Enum) {
	C.gl1_5_glDrawBuffer(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexImage2D.xml
func (gl *GL) TexImage2D(target glbase.Enum, level int, internalFormat int32, width, height, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexImage1D.xml
func (gl *GL) TexImage1D(target glbase.Enum, level int, internalFormat int32, width, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameteriv.xml
func (gl *GL) TexParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glTexParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameteri.xml
func (gl *GL) TexParameteri(target, pname glbase.Enum, param int32) {
	C.gl1_5_glTexParameteri(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameterfv.xml
func (gl *GL) TexParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glTexParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameterf.xml
func (gl *GL) TexParameterf(target, pname glbase.Enum, param float32) {
	C.gl1_5_glTexParameterf(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glScissor.xml
func (gl *GL) Scissor(x, y, width, height int) {
	C.gl1_5_glScissor(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPolygonMode.xml
func (gl *GL) PolygonMode(face, mode glbase.Enum) {
	C.gl1_5_glPolygonMode(gl.funcs, C.GLenum(face), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPointSize.xml
func (gl *GL) PointSize(size float32) {
	C.gl1_5_glPointSize(gl.funcs, C.GLfloat(size))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLineWidth.xml
func (gl *GL) LineWidth(width float32) {
	C.gl1_5_glLineWidth(gl.funcs, C.GLfloat(width))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glHint.xml
func (gl *GL) Hint(target, mode glbase.Enum) {
	C.gl1_5_glHint(gl.funcs, C.GLenum(target), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFrontFace.xml
func (gl *GL) FrontFace(mode glbase.Enum) {
	C.gl1_5_glFrontFace(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCullFace.xml
func (gl *GL) CullFace(mode glbase.Enum) {
	C.gl1_5_glCullFace(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexubv.xml
func (gl *GL) Indexubv(c []uint8) {
	C.gl1_5_glIndexubv(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&c[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexub.xml
func (gl *GL) Indexub(c uint8) {
	C.gl1_5_glIndexub(gl.funcs, C.GLubyte(c))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsTexture.xml
func (gl *GL) IsTexture(texture glbase.Texture) bool {
	glresult := C.gl1_5_glIsTexture(gl.funcs, C.GLuint(texture))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// GenTextures returns n texture names in textures. There is no guarantee
// that the names form a contiguous set of integers; however, it is
// guaranteed that none of the returned names was in use immediately before
// the call to GenTextures.
//
// The generated textures have no dimensionality; they assume the
// dimensionality of the texture target to which they are first bound (see
// BindTexture).
//
// Texture names returned by a call to GenTextures are not returned by
// subsequent calls, unless they are first deleted with DeleteTextures.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// GenTextures is available in GL version 2.0 or greater.
func (gl *GL) GenTextures(n int) []glbase.Texture {
	if n == 0 {
		return nil
	}
	textures := make([]glbase.Texture, n)
	C.gl1_5_glGenTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])))
	return textures
}

// DeleteTextures deletes the textures objects whose names are stored
// in the textures slice. After a texture is deleted, it has no contents or
// dimensionality, and its name is free for reuse (for example by
// GenTextures). If a texture that is currently bound is deleted, the binding
// reverts to 0 (the default texture).
//
// DeleteTextures silently ignores 0's and names that do not correspond to
// existing textures.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteTextures is available in GL version 2.0 or greater.
func (gl *GL) DeleteTextures(textures []glbase.Texture) {
	n := len(textures)
	if n == 0 {
		return
	}
	C.gl1_5_glDeleteTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBindTexture.xml
func (gl *GL) BindTexture(target glbase.Enum, texture glbase.Texture) {
	C.gl1_5_glBindTexture(gl.funcs, C.GLenum(target), C.GLuint(texture))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexSubImage2D.xml
func (gl *GL) TexSubImage2D(target glbase.Enum, level, xoffset, yoffset, width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexSubImage1D.xml
func (gl *GL) TexSubImage1D(target glbase.Enum, level, xoffset, width int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexSubImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLsizei(width), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage2D.xml
func (gl *GL) CopyTexSubImage2D(target glbase.Enum, level, xoffset, yoffset, x, y, width, height int) {
	C.gl1_5_glCopyTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage1D.xml
func (gl *GL) CopyTexSubImage1D(target glbase.Enum, level, xoffset, x, y, width int) {
	C.gl1_5_glCopyTexSubImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(x), C.GLint(y), C.GLsizei(width))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage2D.xml
func (gl *GL) CopyTexImage2D(target glbase.Enum, level int, internalFormat glbase.Enum, x, y, width, height, border int) {
	C.gl1_5_glCopyTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLint(border))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage1D.xml
func (gl *GL) CopyTexImage1D(target glbase.Enum, level int, internalFormat glbase.Enum, x, y, width, border int) {
	C.gl1_5_glCopyTexImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLint(border))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPolygonOffset.xml
func (gl *GL) PolygonOffset(factor, units float32) {
	C.gl1_5_glPolygonOffset(gl.funcs, C.GLfloat(factor), C.GLfloat(units))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawElements.xml
func (gl *GL) DrawElements(mode glbase.Enum, count int, gltype glbase.Enum, indices interface{}) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glDrawElements(gl.funcs, C.GLenum(mode), C.GLsizei(count), C.GLenum(gltype), indices_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawArrays.xml
func (gl *GL) DrawArrays(mode glbase.Enum, first, count int) {
	C.gl1_5_glDrawArrays(gl.funcs, C.GLenum(mode), C.GLint(first), C.GLsizei(count))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage3D.xml
func (gl *GL) CopyTexSubImage3D(target glbase.Enum, level, xoffset, yoffset int, zoffset int32, x, y, width, height int) {
	C.gl1_5_glCopyTexSubImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(zoffset), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexSubImage3D.xml
func (gl *GL) TexSubImage3D(target glbase.Enum, level, xoffset, yoffset int, zoffset int32, width, height int, depth int32, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexSubImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(zoffset), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexImage3D.xml
func (gl *GL) TexImage3D(target glbase.Enum, level int, internalFormat int32, width, height int, depth int32, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawRangeElements.xml
func (gl *GL) DrawRangeElements(mode glbase.Enum, start, end uint32, count int, gltype glbase.Enum, indices interface{}) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glDrawRangeElements(gl.funcs, C.GLenum(mode), C.GLuint(start), C.GLuint(end), C.GLsizei(count), C.GLenum(gltype), indices_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquation.xml
func (gl *GL) BlendEquation(mode glbase.Enum) {
	C.gl1_5_glBlendEquation(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendColor.xml
func (gl *GL) BlendColor(red, green, blue, alpha float32) {
	C.gl1_5_glBlendColor(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue), C.GLfloat(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetCompressedTexImage.xml
func (gl *GL) GetCompressedTexImage(target glbase.Enum, level int, img interface{}) {
	var img_ptr unsafe.Pointer
	var img_v = reflect.ValueOf(img)
	if img != nil && img_v.Kind() != reflect.Slice {
		panic("parameter img must be a slice")
	}
	if img != nil {
		img_ptr = unsafe.Pointer(img_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetCompressedTexImage(gl.funcs, C.GLenum(target), C.GLint(level), img_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage1D.xml
func (gl *GL) CompressedTexSubImage1D(target glbase.Enum, level, xoffset, width int, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCompressedTexSubImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLsizei(width), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage2D.xml
func (gl *GL) CompressedTexSubImage2D(target glbase.Enum, level, xoffset, yoffset, width, height int, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCompressedTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage3D.xml
func (gl *GL) CompressedTexSubImage3D(target glbase.Enum, level, xoffset, yoffset int, zoffset int32, width, height int, depth int32, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCompressedTexSubImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(zoffset), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage1D.xml
func (gl *GL) CompressedTexImage1D(target glbase.Enum, level int, internalFormat glbase.Enum, width, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCompressedTexImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage2D.xml
func (gl *GL) CompressedTexImage2D(target glbase.Enum, level int, internalFormat glbase.Enum, width, height, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCompressedTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage3D.xml
func (gl *GL) CompressedTexImage3D(target glbase.Enum, level int, internalFormat glbase.Enum, width, height int, depth int32, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCompressedTexImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSampleCoverage.xml
func (gl *GL) SampleCoverage(value float32, invert bool) {
	C.gl1_5_glSampleCoverage(gl.funcs, C.GLfloat(value), *(*C.GLboolean)(unsafe.Pointer(&invert)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glActiveTexture.xml
func (gl *GL) ActiveTexture(texture glbase.Enum) {
	C.gl1_5_glActiveTexture(gl.funcs, C.GLenum(texture))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPointParameteriv.xml
func (gl *GL) PointParameteriv(pname glbase.Enum, params []int32) {
	C.gl1_5_glPointParameteriv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPointParameteri.xml
func (gl *GL) PointParameteri(pname glbase.Enum, param int32) {
	C.gl1_5_glPointParameteri(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPointParameterfv.xml
func (gl *GL) PointParameterfv(pname glbase.Enum, params []float32) {
	C.gl1_5_glPointParameterfv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPointParameterf.xml
func (gl *GL) PointParameterf(pname glbase.Enum, param float32) {
	C.gl1_5_glPointParameterf(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiDrawArrays.xml
func (gl *GL) MultiDrawArrays(mode glbase.Enum, first, count []int, drawcount int32) {
	C.gl1_5_glMultiDrawArrays(gl.funcs, C.GLenum(mode), (*C.GLint)(unsafe.Pointer(&first[0])), (*C.GLsizei)(unsafe.Pointer(&count[0])), C.GLsizei(drawcount))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFuncSeparate.xml
func (gl *GL) BlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha glbase.Enum) {
	C.gl1_5_glBlendFuncSeparate(gl.funcs, C.GLenum(sfactorRGB), C.GLenum(dfactorRGB), C.GLenum(sfactorAlpha), C.GLenum(dfactorAlpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferParameteriv.xml
func (gl *GL) GetBufferParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetBufferParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glUnmapBuffer.xml
func (gl *GL) UnmapBuffer(target glbase.Enum) bool {
	glresult := C.gl1_5_glUnmapBuffer(gl.funcs, C.GLenum(target))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferSubData.xml
func (gl *GL) GetBufferSubData(target glbase.Enum, offset, size int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetBufferSubData(gl.funcs, C.GLenum(target), C.GLintptr(offset), C.GLsizeiptr(size), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBufferSubData.xml
func (gl *GL) BufferSubData(target glbase.Enum, offset, size int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glBufferSubData(gl.funcs, C.GLenum(target), C.GLintptr(offset), C.GLsizeiptr(size), data_ptr)
}

// BufferData creates a new data store for the buffer object currently
// bound to target. Any pre-existing data store is deleted. The new data
// store is created with the specified size in bytes and usage. If data is
// not nil, it must be a slice that is used to initialize the data store.
// In that case the size parameter is ignored and the store size will match
// the slice data size.
//
// In its initial state, the new data store is not mapped, it has a NULL
// mapped pointer, and its mapped access is GL.READ_WRITE.
//
// The target constant must be one of GL.ARRAY_BUFFER, GL.COPY_READ_BUFFER,
// GL.COPY_WRITE_BUFFER, GL.ELEMENT_ARRAY_BUFFER, GL.PIXEL_PACK_BUFFER,
// GL.PIXEL_UNPACK_BUFFER, GL.TEXTURE_BUFFER, GL.TRANSFORM_FEEDBACK_BUFFER,
// or GL.UNIFORM_BUFFER.
//
// The usage parameter is a hint to the GL implementation as to how a buffer
// object's data store will be accessed. This enables the GL implementation
// to make more intelligent decisions that may significantly impact buffer
// object performance. It does not, however, constrain the actual usage of
// the data store. usage can be broken down into two parts: first, the
// frequency of access (modification and usage), and second, the nature of
// that access.
//
// A usage frequency of STREAM and nature of DRAW is specified via the
// constant GL.STREAM_DRAW, for example.
//
// The usage frequency of access may be one of:
//
//   STREAM
//       The data store contents will be modified once and used at most a few times.
//
//   STATIC
//       The data store contents will be modified once and used many times.
//
//   DYNAMIC
//       The data store contents will be modified repeatedly and used many times.
//
// The usage nature of access may be one of:
//
//   DRAW
//       The data store contents are modified by the application, and used as
//       the source for GL drawing and image specification commands.
//
//   READ
//       The data store contents are modified by reading data from the GL,
//       and used to return that data when queried by the application.
//
//   COPY
//       The data store contents are modified by reading data from the GL,
//       and used as the source for GL drawing and image specification
//       commands.
//
// Clients must align data elements consistent with the requirements of the
// client platform, with an additional base-level requirement that an offset
// within a buffer to a datum comprising N bytes be a multiple of N.
//
// Error GL.INVALID_ENUM is generated if target is not one of the accepted
// buffer targets.  GL.INVALID_ENUM is generated if usage is not
// GL.STREAM_DRAW, GL.STREAM_READ, GL.STREAM_COPY, GL.STATIC_DRAW,
// GL.STATIC_READ, GL.STATIC_COPY, GL.DYNAMIC_DRAW, GL.DYNAMIC_READ, or
// GL.DYNAMIC_COPY.  GL.INVALID_VALUE is generated if size is negative.
// GL.INVALID_OPERATION is generated if the reserved buffer object name 0 is
// bound to target.  GL.OUT_OF_MEMORY is generated if the GL is unable to
// create a data store with the specified size.
func (gl *GL) BufferData(target glbase.Enum, size int, data interface{}, usage glbase.Enum) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	if data != nil {
		size = int(data_v.Type().Size()) * data_v.Len()
	}
	C.gl1_5_glBufferData(gl.funcs, C.GLenum(target), C.GLsizeiptr(size), data_ptr, C.GLenum(usage))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsBuffer.xml
func (gl *GL) IsBuffer(buffer glbase.Buffer) bool {
	glresult := C.gl1_5_glIsBuffer(gl.funcs, C.GLuint(buffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// GenBuffers returns n buffer object names. There is no guarantee that
// the names form a contiguous set of integers; however, it is guaranteed
// that none of the returned names was in use immediately before the call to
// GenBuffers.
//
// Buffer object names returned by a call to GenBuffers are not returned by
// subsequent calls, unless they are first deleted with DeleteBuffers.
//
// No buffer objects are associated with the returned buffer object names
// until they are first bound by calling BindBuffer.
//
// Error GL.INVALID_VALUE is generated if n is negative. GL.INVALID_OPERATION
// is generated if GenBuffers is executed between the execution of Begin
// and the corresponding execution of End.
//
// GenBuffers is available in GL version 1.5 or greater.
func (gl *GL) GenBuffers(n int) []glbase.Buffer {
	if n == 0 {
		return nil
	}
	buffers := make([]glbase.Buffer, n)
	C.gl1_5_glGenBuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&buffers[0])))
	return buffers
}

// DeleteBuffers deletes the buffer objects whose names are stored in the
// buffers slice.
//
// After a buffer object is deleted, it has no contents, and its name is free
// for reuse (for example by GenBuffers). If a buffer object that is
// currently bound is deleted, the binding reverts to 0 (the absence of any
// buffer object, which reverts to client memory usage).
//
// DeleteBuffers silently ignores 0's and names that do not correspond to
// existing buffer objects.
//
// Error GL.INVALID_VALUE is generated if n is negative. GL.INVALID_OPERATION
// is generated if DeleteBuffers is executed between the execution of Begin
// and the corresponding execution of End.
//
// DeleteBuffers is available in GL version 1.5 or greater.
func (gl *GL) DeleteBuffers(buffers []glbase.Buffer) {
	n := len(buffers)
	if n == 0 {
		return
	}
	C.gl1_5_glDeleteBuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&buffers[0])))
}

// BindBuffer creates or puts in use a named buffer object.
// Calling BindBuffer with target set to GL.ARRAY_BUFFER,
// GL.ELEMENT_ARRAY_BUFFER, GL.PIXEL_PACK_BUFFER or GL.PIXEL_UNPACK_BUFFER
// and buffer set to the name of the new buffer object binds the buffer
// object name to the target. When a buffer object is bound to a target, the
// previous binding for that target is automatically broken.
//
// Buffer object names are unsigned integers. The value zero is reserved, but
// there is no default buffer object for each buffer object target. Instead,
// buffer set to zero effectively unbinds any buffer object previously bound,
// and restores client memory usage for that buffer object target. Buffer
// object names and the corresponding buffer object contents are local to the
// shared display-list space (see XCreateContext) of the current GL rendering
// context; two rendering contexts share buffer object names only if they
// also share display lists.
//
// GenBuffers may be called to generate a set of new buffer object names.
//
// The state of a buffer object immediately after it is first bound is an
// unmapped zero-sized memory buffer with GL.READ_WRITE access and
// GL.STATIC_DRAW usage.
//
// While a non-zero buffer object name is bound, GL operations on the target
// to which it is bound affect the bound buffer object, and queries of the
// target to which it is bound return state from the bound buffer object.
// While buffer object name zero is bound, as in the initial state, attempts
// to modify or query state on the target to which it is bound generates an
// GL.INVALID_OPERATION error.
//
// When vertex array pointer state is changed, for example by a call to
// NormalPointer, the current buffer object binding (GL.ARRAY_BUFFER_BINDING)
// is copied into the corresponding client state for the vertex array type
// being changed, for example GL.NORMAL_ARRAY_BUFFER_BINDING. While a
// non-zero buffer object is bound to the GL.ARRAY_BUFFER target, the vertex
// array pointer parameter that is traditionally interpreted as a pointer to
// client-side memory is instead interpreted as an offset within the buffer
// object measured in basic machine units.
//
// While a non-zero buffer object is bound to the GL.ELEMENT_ARRAY_BUFFER
// target, the indices parameter of DrawElements, DrawRangeElements, or
// MultiDrawElements that is traditionally interpreted as a pointer to
// client-side memory is instead interpreted as an offset within the buffer
// object measured in basic machine units.
//
// While a non-zero buffer object is bound to the GL.PIXEL_PACK_BUFFER
// target, the following commands are affected: GetCompressedTexImage,
// GetConvolutionFilter, GetHistogram, GetMinmax, GetPixelMap,
// GetPolygonStipple, GetSeparableFilter, GetTexImage, and ReadPixels. The
// pointer parameter that is traditionally interpreted as a pointer to
// client-side memory where the pixels are to be packed is instead
// interpreted as an offset within the buffer object measured in basic
// machine units.
//
// While a non-zero buffer object is bound to the GL.PIXEL_UNPACK_BUFFER
// target, the following commands are affected: Bitmap, ColorSubTable,
// ColorTable, CompressedTexImage1D, CompressedTexImage2D,
// CompressedTexImage3D, CompressedTexSubImage1D, CompressedTexSubImage2D,
// CompressedTexSubImage3D, ConvolutionFilter1D, ConvolutionFilter2D,
// DrawPixels, PixelMap, PolygonStipple, SeparableFilter2D, TexImage1D,
// TexImage2D, TexImage3D, TexSubImage1D, TexSubImage2D, and TexSubImage3D.
// The pointer parameter that is traditionally interpreted as a pointer to
// client-side memory from which the pixels are to be unpacked is instead
// interpreted as an offset within the buffer object measured in basic
// machine units.
//
// A buffer object binding created with BindBuffer remains active until a
// different buffer object name is bound to the same target, or until the
// bound buffer object is deleted with DeleteBuffers.
//
// Once created, a named buffer object may be re-bound to any target as often
// as needed. However, the GL implementation may make choices about how to
// optimize the storage of a buffer object based on its initial binding
// target.
//
// Error GL.INVALID_ENUM is generated if target is not one of the allowable
// values.  GL.INVALID_OPERATION is generated if BindBuffer is executed
// between the execution of Begin and the corresponding execution of End.
//
// BindBuffer is available in GL version 1.5 or greater.
func (gl *GL) BindBuffer(target glbase.Enum, buffer glbase.Buffer) {
	C.gl1_5_glBindBuffer(gl.funcs, C.GLenum(target), C.GLuint(buffer))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryObjectuiv.xml
func (gl *GL) GetQueryObjectuiv(id uint32, pname glbase.Enum, params []uint32) {
	C.gl1_5_glGetQueryObjectuiv(gl.funcs, C.GLuint(id), C.GLenum(pname), (*C.GLuint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryObjectiv.xml
func (gl *GL) GetQueryObjectiv(id uint32, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetQueryObjectiv(gl.funcs, C.GLuint(id), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryiv.xml
func (gl *GL) GetQueryiv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetQueryiv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEndQuery.xml
func (gl *GL) EndQuery(target glbase.Enum) {
	C.gl1_5_glEndQuery(gl.funcs, C.GLenum(target))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBeginQuery.xml
func (gl *GL) BeginQuery(target glbase.Enum, id uint32) {
	C.gl1_5_glBeginQuery(gl.funcs, C.GLenum(target), C.GLuint(id))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsQuery.xml
func (gl *GL) IsQuery(id uint32) bool {
	glresult := C.gl1_5_glIsQuery(gl.funcs, C.GLuint(id))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteQueries.xml
func (gl *GL) DeleteQueries(n int, ids []uint32) {
	C.gl1_5_glDeleteQueries(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&ids[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGenQueries.xml
func (gl *GL) GenQueries(n int, ids []uint32) {
	C.gl1_5_glGenQueries(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&ids[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTranslatef.xml
func (gl *GL) Translatef(x, y, z float32) {
	C.gl1_5_glTranslatef(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTranslated.xml
func (gl *GL) Translated(x, y, z float64) {
	C.gl1_5_glTranslated(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glScalef.xml
func (gl *GL) Scalef(x, y, z float32) {
	C.gl1_5_glScalef(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glScaled.xml
func (gl *GL) Scaled(x, y, z float64) {
	C.gl1_5_glScaled(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRotatef.xml
func (gl *GL) Rotatef(angle, x, y, z float32) {
	C.gl1_5_glRotatef(gl.funcs, C.GLfloat(angle), C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRotated.xml
func (gl *GL) Rotated(angle, x, y, z float64) {
	C.gl1_5_glRotated(gl.funcs, C.GLdouble(angle), C.GLdouble(x), C.GLdouble(y), C.GLdouble(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPushMatrix.xml
func (gl *GL) PushMatrix() {
	C.gl1_5_glPushMatrix(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPopMatrix.xml
func (gl *GL) PopMatrix() {
	C.gl1_5_glPopMatrix(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glOrtho.xml
func (gl *GL) Ortho(left, right, bottom, top, zNear, zFar float64) {
	C.gl1_5_glOrtho(gl.funcs, C.GLdouble(left), C.GLdouble(right), C.GLdouble(bottom), C.GLdouble(top), C.GLdouble(zNear), C.GLdouble(zFar))
}

// MultMatrixd multiplies the current matrix with the provided matrix.
//
// The m parameter must hold 16 consecutive elements of a 4x4 column-major matrix.
//
// The current matrix is determined by the current matrix mode (see
// MatrixMode). It is either the projection matrix, modelview matrix, or the
// texture matrix.
//
// For example, if the current matrix is C and the coordinates to be transformed
// are v = (v[0], v[1], v[2], v[3]), then the current transformation is C × v, or
//
//     c[0]  c[4]  c[8]  c[12]     v[0]
//     c[1]  c[5]  c[9]  c[13]     v[1]
//     c[2]  c[6]  c[10] c[14]  X  v[2]
//     c[3]  c[7]  c[11] c[15]     v[3]
//
// Calling MultMatrix with an argument of m = m[0], m[1], ..., m[15]
// replaces the current transformation with (C X M) x v, or
//
//     c[0]  c[4]  c[8]  c[12]   m[0]  m[4]  m[8]  m[12]   v[0]
//     c[1]  c[5]  c[9]  c[13]   m[1]  m[5]  m[9]  m[13]   v[1]
//     c[2]  c[6]  c[10] c[14] X m[2]  m[6]  m[10] m[14] X v[2]
//     c[3]  c[7]  c[11] c[15]   m[3]  m[7]  m[11] m[15]   v[3]
//
// Where 'X' denotes matrix multiplication, and v is represented as a 4x1 matrix.
//
// While the elements of the matrix may be specified with single or double
// precision, the GL may store or operate on these values in less-than-single
// precision.
//
// In many computer languages, 4×4 arrays are represented in row-major
// order. The transformations just described represent these matrices in
// column-major order. The order of the multiplication is important. For
// example, if the current transformation is a rotation, and MultMatrix is
// called with a translation matrix, the translation is done directly on the
// coordinates to be transformed, while the rotation is done on the results
// of that translation.
//
// GL.INVALID_OPERATION is generated if MultMatrix is executed between the
// execution of Begin and the corresponding execution of End.
func (gl *GL) MultMatrixd(m []float64) {
	if len(m) != 16 {
		panic("parameter m must have length 16 for the 4x4 matrix")
	}
	C.gl1_5_glMultMatrixd(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&m[0])))
}

// MultMatrixf multiplies the current matrix with the provided matrix.
//
// The m parameter must hold 16 consecutive elements of a 4x4 column-major matrix.
//
// The current matrix is determined by the current matrix mode (see
// MatrixMode). It is either the projection matrix, modelview matrix, or the
// texture matrix.
//
// For example, if the current matrix is C and the coordinates to be transformed
// are v = (v[0], v[1], v[2], v[3]), then the current transformation is C × v, or
//
//     c[0]  c[4]  c[8]  c[12]     v[0]
//     c[1]  c[5]  c[9]  c[13]     v[1]
//     c[2]  c[6]  c[10] c[14]  X  v[2]
//     c[3]  c[7]  c[11] c[15]     v[3]
//
// Calling MultMatrix with an argument of m = m[0], m[1], ..., m[15]
// replaces the current transformation with (C X M) x v, or
//
//     c[0]  c[4]  c[8]  c[12]   m[0]  m[4]  m[8]  m[12]   v[0]
//     c[1]  c[5]  c[9]  c[13]   m[1]  m[5]  m[9]  m[13]   v[1]
//     c[2]  c[6]  c[10] c[14] X m[2]  m[6]  m[10] m[14] X v[2]
//     c[3]  c[7]  c[11] c[15]   m[3]  m[7]  m[11] m[15]   v[3]
//
// Where 'X' denotes matrix multiplication, and v is represented as a 4x1 matrix.
//
// While the elements of the matrix may be specified with single or double
// precision, the GL may store or operate on these values in less-than-single
// precision.
//
// In many computer languages, 4×4 arrays are represented in row-major
// order. The transformations just described represent these matrices in
// column-major order. The order of the multiplication is important. For
// example, if the current transformation is a rotation, and MultMatrix is
// called with a translation matrix, the translation is done directly on the
// coordinates to be transformed, while the rotation is done on the results
// of that translation.
//
// GL.INVALID_OPERATION is generated if MultMatrix is executed between the
// execution of Begin and the corresponding execution of End.
func (gl *GL) MultMatrixf(m []float32) {
	if len(m) != 16 {
		panic("parameter m must have length 16 for the 4x4 matrix")
	}
	C.gl1_5_glMultMatrixf(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMatrixMode.xml
func (gl *GL) MatrixMode(mode glbase.Enum) {
	C.gl1_5_glMatrixMode(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLoadMatrixd.xml
func (gl *GL) LoadMatrixd(m []float64) {
	C.gl1_5_glLoadMatrixd(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLoadMatrixf.xml
func (gl *GL) LoadMatrixf(m []float32) {
	C.gl1_5_glLoadMatrixf(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLoadIdentity.xml
func (gl *GL) LoadIdentity() {
	C.gl1_5_glLoadIdentity(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFrustum.xml
func (gl *GL) Frustum(left, right, bottom, top, zNear, zFar float64) {
	C.gl1_5_glFrustum(gl.funcs, C.GLdouble(left), C.GLdouble(right), C.GLdouble(bottom), C.GLdouble(top), C.GLdouble(zNear), C.GLdouble(zFar))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsList.xml
func (gl *GL) IsList(list uint32) bool {
	glresult := C.gl1_5_glIsList(gl.funcs, C.GLuint(list))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGeniv.xml
func (gl *GL) GetTexGeniv(coord, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetTexGeniv(gl.funcs, C.GLenum(coord), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGenfv.xml
func (gl *GL) GetTexGenfv(coord, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetTexGenfv(gl.funcs, C.GLenum(coord), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGendv.xml
func (gl *GL) GetTexGendv(coord, pname glbase.Enum, params []float64) {
	C.gl1_5_glGetTexGendv(gl.funcs, C.GLenum(coord), C.GLenum(pname), (*C.GLdouble)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexEnviv.xml
func (gl *GL) GetTexEnviv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetTexEnviv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexEnvfv.xml
func (gl *GL) GetTexEnvfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetTexEnvfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetPolygonStipple.xml
func (gl *GL) GetPolygonStipple(mask []uint8) {
	C.gl1_5_glGetPolygonStipple(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&mask[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMapusv.xml
func (gl *GL) GetPixelMapusv(glmap glbase.Enum, values []uint16) {
	C.gl1_5_glGetPixelMapusv(gl.funcs, C.GLenum(glmap), (*C.GLushort)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMapuiv.xml
func (gl *GL) GetPixelMapuiv(glmap glbase.Enum, values []uint32) {
	C.gl1_5_glGetPixelMapuiv(gl.funcs, C.GLenum(glmap), (*C.GLuint)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMapfv.xml
func (gl *GL) GetPixelMapfv(glmap glbase.Enum, values []float32) {
	C.gl1_5_glGetPixelMapfv(gl.funcs, C.GLenum(glmap), (*C.GLfloat)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMaterialiv.xml
func (gl *GL) GetMaterialiv(face, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetMaterialiv(gl.funcs, C.GLenum(face), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMaterialfv.xml
func (gl *GL) GetMaterialfv(face, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetMaterialfv(gl.funcs, C.GLenum(face), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMapiv.xml
func (gl *GL) GetMapiv(target, query glbase.Enum, v []int32) {
	C.gl1_5_glGetMapiv(gl.funcs, C.GLenum(target), C.GLenum(query), (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMapfv.xml
func (gl *GL) GetMapfv(target, query glbase.Enum, v []float32) {
	C.gl1_5_glGetMapfv(gl.funcs, C.GLenum(target), C.GLenum(query), (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMapdv.xml
func (gl *GL) GetMapdv(target, query glbase.Enum, v []float64) {
	C.gl1_5_glGetMapdv(gl.funcs, C.GLenum(target), C.GLenum(query), (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetLightiv.xml
func (gl *GL) GetLightiv(light, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetLightiv(gl.funcs, C.GLenum(light), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetLightfv.xml
func (gl *GL) GetLightfv(light, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetLightfv(gl.funcs, C.GLenum(light), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetClipPlane.xml
func (gl *GL) GetClipPlane(plane glbase.Enum, equation []float64) {
	C.gl1_5_glGetClipPlane(gl.funcs, C.GLenum(plane), (*C.GLdouble)(unsafe.Pointer(&equation[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawPixels.xml
func (gl *GL) DrawPixels(width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glDrawPixels(gl.funcs, C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyPixels.xml
func (gl *GL) CopyPixels(x, y, width, height int, gltype glbase.Enum) {
	C.gl1_5_glCopyPixels(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLenum(gltype))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelMapusv.xml
func (gl *GL) PixelMapusv(glmap glbase.Enum, mapsize int32, values []uint16) {
	C.gl1_5_glPixelMapusv(gl.funcs, C.GLenum(glmap), C.GLint(mapsize), (*C.GLushort)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelMapuiv.xml
func (gl *GL) PixelMapuiv(glmap glbase.Enum, mapsize int32, values []uint32) {
	C.gl1_5_glPixelMapuiv(gl.funcs, C.GLenum(glmap), C.GLint(mapsize), (*C.GLuint)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelMapfv.xml
func (gl *GL) PixelMapfv(glmap glbase.Enum, mapsize int32, values []float32) {
	C.gl1_5_glPixelMapfv(gl.funcs, C.GLenum(glmap), C.GLint(mapsize), (*C.GLfloat)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelTransferi.xml
func (gl *GL) PixelTransferi(pname glbase.Enum, param int32) {
	C.gl1_5_glPixelTransferi(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelTransferf.xml
func (gl *GL) PixelTransferf(pname glbase.Enum, param float32) {
	C.gl1_5_glPixelTransferf(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelZoom.xml
func (gl *GL) PixelZoom(xfactor, yfactor float32) {
	C.gl1_5_glPixelZoom(gl.funcs, C.GLfloat(xfactor), C.GLfloat(yfactor))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glAlphaFunc.xml
func (gl *GL) AlphaFunc(glfunc glbase.Enum, ref float32) {
	C.gl1_5_glAlphaFunc(gl.funcs, C.GLenum(glfunc), C.GLfloat(ref))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalPoint2.xml
func (gl *GL) EvalPoint2(i, j int32) {
	C.gl1_5_glEvalPoint2(gl.funcs, C.GLint(i), C.GLint(j))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalMesh2.xml
func (gl *GL) EvalMesh2(mode glbase.Enum, i1, i2, j1, j2 int32) {
	C.gl1_5_glEvalMesh2(gl.funcs, C.GLenum(mode), C.GLint(i1), C.GLint(i2), C.GLint(j1), C.GLint(j2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalPoint1.xml
func (gl *GL) EvalPoint1(i int32) {
	C.gl1_5_glEvalPoint1(gl.funcs, C.GLint(i))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalMesh1.xml
func (gl *GL) EvalMesh1(mode glbase.Enum, i1, i2 int32) {
	C.gl1_5_glEvalMesh1(gl.funcs, C.GLenum(mode), C.GLint(i1), C.GLint(i2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord2fv.xml
func (gl *GL) EvalCoord2fv(u []float32) {
	if len(u) != 2 {
		panic("parameter u has incorrect length")
	}
	C.gl1_5_glEvalCoord2fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&u[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord2f.xml
func (gl *GL) EvalCoord2f(u, v float32) {
	C.gl1_5_glEvalCoord2f(gl.funcs, C.GLfloat(u), C.GLfloat(v))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord2dv.xml
func (gl *GL) EvalCoord2dv(u []float64) {
	if len(u) != 2 {
		panic("parameter u has incorrect length")
	}
	C.gl1_5_glEvalCoord2dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&u[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord2d.xml
func (gl *GL) EvalCoord2d(u, v float64) {
	C.gl1_5_glEvalCoord2d(gl.funcs, C.GLdouble(u), C.GLdouble(v))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord1fv.xml
func (gl *GL) EvalCoord1fv(u []float32) {
	C.gl1_5_glEvalCoord1fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&u[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord1f.xml
func (gl *GL) EvalCoord1f(u float32) {
	C.gl1_5_glEvalCoord1f(gl.funcs, C.GLfloat(u))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord1dv.xml
func (gl *GL) EvalCoord1dv(u []float64) {
	C.gl1_5_glEvalCoord1dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&u[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord1d.xml
func (gl *GL) EvalCoord1d(u float64) {
	C.gl1_5_glEvalCoord1d(gl.funcs, C.GLdouble(u))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMapGrid2f.xml
func (gl *GL) MapGrid2f(un int32, u1, u2 float32, vn int32, v1, v2 float32) {
	C.gl1_5_glMapGrid2f(gl.funcs, C.GLint(un), C.GLfloat(u1), C.GLfloat(u2), C.GLint(vn), C.GLfloat(v1), C.GLfloat(v2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMapGrid2d.xml
func (gl *GL) MapGrid2d(un int32, u1, u2 float64, vn int32, v1, v2 float64) {
	C.gl1_5_glMapGrid2d(gl.funcs, C.GLint(un), C.GLdouble(u1), C.GLdouble(u2), C.GLint(vn), C.GLdouble(v1), C.GLdouble(v2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMapGrid1f.xml
func (gl *GL) MapGrid1f(un int32, u1, u2 float32) {
	C.gl1_5_glMapGrid1f(gl.funcs, C.GLint(un), C.GLfloat(u1), C.GLfloat(u2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMapGrid1d.xml
func (gl *GL) MapGrid1d(un int32, u1, u2 float64) {
	C.gl1_5_glMapGrid1d(gl.funcs, C.GLint(un), C.GLdouble(u1), C.GLdouble(u2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMap2f.xml
func (gl *GL) Map2f(target glbase.Enum, u1, u2 float32, ustride, uorder int32, v1, v2 float32, vstride, vorder int32, points []float32) {
	C.gl1_5_glMap2f(gl.funcs, C.GLenum(target), C.GLfloat(u1), C.GLfloat(u2), C.GLint(ustride), C.GLint(uorder), C.GLfloat(v1), C.GLfloat(v2), C.GLint(vstride), C.GLint(vorder), (*C.GLfloat)(unsafe.Pointer(&points[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMap2d.xml
func (gl *GL) Map2d(target glbase.Enum, u1, u2 float64, ustride, uorder int32, v1, v2 float64, vstride, vorder int32, points []float64) {
	C.gl1_5_glMap2d(gl.funcs, C.GLenum(target), C.GLdouble(u1), C.GLdouble(u2), C.GLint(ustride), C.GLint(uorder), C.GLdouble(v1), C.GLdouble(v2), C.GLint(vstride), C.GLint(vorder), (*C.GLdouble)(unsafe.Pointer(&points[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMap1f.xml
func (gl *GL) Map1f(target glbase.Enum, u1, u2 float32, stride, order int, points []float32) {
	C.gl1_5_glMap1f(gl.funcs, C.GLenum(target), C.GLfloat(u1), C.GLfloat(u2), C.GLint(stride), C.GLint(order), (*C.GLfloat)(unsafe.Pointer(&points[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMap1d.xml
func (gl *GL) Map1d(target glbase.Enum, u1, u2 float64, stride, order int, points []float64) {
	C.gl1_5_glMap1d(gl.funcs, C.GLenum(target), C.GLdouble(u1), C.GLdouble(u2), C.GLint(stride), C.GLint(order), (*C.GLdouble)(unsafe.Pointer(&points[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPushAttrib.xml
func (gl *GL) PushAttrib(mask glbase.Bitfield) {
	C.gl1_5_glPushAttrib(gl.funcs, C.GLbitfield(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPopAttrib.xml
func (gl *GL) PopAttrib() {
	C.gl1_5_glPopAttrib(gl.funcs)
}

// Accum executes an operation on the accumulation buffer.
//
// Parameter op defines the accumulation buffer operation (GL.ACCUM, GL.LOAD,
// GL.ADD, GL.MULT, or GL.RETURN) and specifies how the value parameter is
// used.
//
// The accumulation buffer is an extended-range color buffer. Images are not
// rendered into it. Rather, images rendered into one of the color buffers
// are added to the contents of the accumulation buffer after rendering.
// Effects such as antialiasing (of points, lines, and polygons), motion
// blur, and depth of field can be created by accumulating images generated
// with different transformation matrices.
//
// Each pixel in the accumulation buffer consists of red, green, blue, and
// alpha values. The number of bits per component in the accumulation buffer
// depends on the implementation. You can examine this number by calling
// GetIntegerv four times, with arguments GL.ACCUM_RED_BITS,
// GL.ACCUM_GREEN_BITS, GL.ACCUM_BLUE_BITS, and GL.ACCUM_ALPHA_BITS.
// Regardless of the number of bits per component, the range of values stored
// by each component is (-1, 1). The accumulation buffer pixels are mapped
// one-to-one with frame buffer pixels.
//
// All accumulation buffer operations are limited to the area of the current
// scissor box and applied identically to the red, green, blue, and alpha
// components of each pixel. If a Accum operation results in a value outside
// the range (-1, 1), the contents of an accumulation buffer pixel component
// are undefined.
//
// The operations are as follows:
//
//   GL.ACCUM
//       Obtains R, G, B, and A values from the buffer currently selected for
//       reading (see ReadBuffer). Each component value is divided by 2 n -
//       1 , where n is the number of bits allocated to each color component
//       in the currently selected buffer. The result is a floating-point
//       value in the range 0 1 , which is multiplied by value and added to
//       the corresponding pixel component in the accumulation buffer,
//       thereby updating the accumulation buffer.
//
//   GL.LOAD
//       Similar to GL.ACCUM, except that the current value in the
//       accumulation buffer is not used in the calculation of the new value.
//       That is, the R, G, B, and A values from the currently selected
//       buffer are divided by 2 n - 1 , multiplied by value, and then stored
//       in the corresponding accumulation buffer cell, overwriting the
//       current value.
//
//   GL.ADD
//       Adds value to each R, G, B, and A in the accumulation buffer.
//
//   GL.MULT
//       Multiplies each R, G, B, and A in the accumulation buffer by value
//       and returns the scaled component to its corresponding accumulation
//       buffer location.
//
//   GL.RETURN
//       Transfers accumulation buffer values to the color buffer or buffers
//       currently selected for writing. Each R, G, B, and A component is
//       multiplied by value, then multiplied by 2 n - 1 , clamped to the
//       range 0 2 n - 1 , and stored in the corresponding display buffer
//       cell. The only fragment operations that are applied to this transfer
//       are pixel ownership, scissor, dithering, and color writemasks.
//
// To clear the accumulation buffer, call ClearAccum with R, G, B, and A
// values to set it to, then call Clear with the accumulation buffer
// enabled.
//
// Error GL.INVALID_ENUM is generated if op is not an accepted value.
// GL.INVALID_OPERATION is generated if there is no accumulation buffer.
// GL.INVALID_OPERATION is generated if Accum is executed between the
// execution of Begin and the corresponding execution of End.
func (gl *GL) Accum(op glbase.Enum, value float32) {
	C.gl1_5_glAccum(gl.funcs, C.GLenum(op), C.GLfloat(value))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexMask.xml
func (gl *GL) IndexMask(mask uint32) {
	C.gl1_5_glIndexMask(gl.funcs, C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearIndex.xml
func (gl *GL) ClearIndex(c float32) {
	C.gl1_5_glClearIndex(gl.funcs, C.GLfloat(c))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearAccum.xml
func (gl *GL) ClearAccum(red, green, blue, alpha float32) {
	C.gl1_5_glClearAccum(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue), C.GLfloat(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPushName.xml
func (gl *GL) PushName(name uint32) {
	C.gl1_5_glPushName(gl.funcs, C.GLuint(name))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPopName.xml
func (gl *GL) PopName() {
	C.gl1_5_glPopName(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPassThrough.xml
func (gl *GL) PassThrough(token float32) {
	C.gl1_5_glPassThrough(gl.funcs, C.GLfloat(token))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLoadName.xml
func (gl *GL) LoadName(name uint32) {
	C.gl1_5_glLoadName(gl.funcs, C.GLuint(name))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glInitNames.xml
func (gl *GL) InitNames() {
	C.gl1_5_glInitNames(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRenderMode.xml
func (gl *GL) RenderMode(mode glbase.Enum) int32 {
	glresult := C.gl1_5_glRenderMode(gl.funcs, C.GLenum(mode))
	return int32(glresult)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSelectBuffer.xml
func (gl *GL) SelectBuffer(size int, buffer []glbase.Buffer) {
	C.gl1_5_glSelectBuffer(gl.funcs, C.GLsizei(size), (*C.GLuint)(unsafe.Pointer(&buffer[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFeedbackBuffer.xml
func (gl *GL) FeedbackBuffer(size int, gltype glbase.Enum, buffer []float32) {
	C.gl1_5_glFeedbackBuffer(gl.funcs, C.GLsizei(size), C.GLenum(gltype), (*C.GLfloat)(unsafe.Pointer(&buffer[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexGeniv.xml
func (gl *GL) TexGeniv(coord, pname glbase.Enum, params []int32) {
	C.gl1_5_glTexGeniv(gl.funcs, C.GLenum(coord), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexGeni.xml
func (gl *GL) TexGeni(coord, pname glbase.Enum, param int32) {
	C.gl1_5_glTexGeni(gl.funcs, C.GLenum(coord), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexGenfv.xml
func (gl *GL) TexGenfv(coord, pname glbase.Enum, params []float32) {
	C.gl1_5_glTexGenfv(gl.funcs, C.GLenum(coord), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexGenf.xml
func (gl *GL) TexGenf(coord, pname glbase.Enum, param float32) {
	C.gl1_5_glTexGenf(gl.funcs, C.GLenum(coord), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexGendv.xml
func (gl *GL) TexGendv(coord, pname glbase.Enum, params []float64) {
	C.gl1_5_glTexGendv(gl.funcs, C.GLenum(coord), C.GLenum(pname), (*C.GLdouble)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexGend.xml
func (gl *GL) TexGend(coord, pname glbase.Enum, param float64) {
	C.gl1_5_glTexGend(gl.funcs, C.GLenum(coord), C.GLenum(pname), C.GLdouble(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexEnviv.xml
func (gl *GL) TexEnviv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glTexEnviv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexEnvi.xml
func (gl *GL) TexEnvi(target, pname glbase.Enum, param int32) {
	C.gl1_5_glTexEnvi(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexEnvfv.xml
func (gl *GL) TexEnvfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glTexEnvfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexEnvf.xml
func (gl *GL) TexEnvf(target, pname glbase.Enum, param float32) {
	C.gl1_5_glTexEnvf(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glShadeModel.xml
func (gl *GL) ShadeModel(mode glbase.Enum) {
	C.gl1_5_glShadeModel(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPolygonStipple.xml
func (gl *GL) PolygonStipple(mask []uint8) {
	C.gl1_5_glPolygonStipple(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&mask[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMaterialiv.xml
func (gl *GL) Materialiv(face, pname glbase.Enum, params []int32) {
	C.gl1_5_glMaterialiv(gl.funcs, C.GLenum(face), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMateriali.xml
func (gl *GL) Materiali(face, pname glbase.Enum, param int32) {
	C.gl1_5_glMateriali(gl.funcs, C.GLenum(face), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMaterialfv.xml
func (gl *GL) Materialfv(face, pname glbase.Enum, params []float32) {
	C.gl1_5_glMaterialfv(gl.funcs, C.GLenum(face), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMaterialf.xml
func (gl *GL) Materialf(face, pname glbase.Enum, param float32) {
	C.gl1_5_glMaterialf(gl.funcs, C.GLenum(face), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLineStipple.xml
func (gl *GL) LineStipple(factor int32, pattern uint16) {
	C.gl1_5_glLineStipple(gl.funcs, C.GLint(factor), C.GLushort(pattern))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightModeliv.xml
func (gl *GL) LightModeliv(pname glbase.Enum, params []int32) {
	C.gl1_5_glLightModeliv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightModeli.xml
func (gl *GL) LightModeli(pname glbase.Enum, param int32) {
	C.gl1_5_glLightModeli(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightModelfv.xml
func (gl *GL) LightModelfv(pname glbase.Enum, params []float32) {
	C.gl1_5_glLightModelfv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightModelf.xml
func (gl *GL) LightModelf(pname glbase.Enum, param float32) {
	C.gl1_5_glLightModelf(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightiv.xml
func (gl *GL) Lightiv(light, pname glbase.Enum, params []int32) {
	C.gl1_5_glLightiv(gl.funcs, C.GLenum(light), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLighti.xml
func (gl *GL) Lighti(light, pname glbase.Enum, param int32) {
	C.gl1_5_glLighti(gl.funcs, C.GLenum(light), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightfv.xml
func (gl *GL) Lightfv(light, pname glbase.Enum, params []float32) {
	C.gl1_5_glLightfv(gl.funcs, C.GLenum(light), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLightf.xml
func (gl *GL) Lightf(light, pname glbase.Enum, param float32) {
	C.gl1_5_glLightf(gl.funcs, C.GLenum(light), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogiv.xml
func (gl *GL) Fogiv(pname glbase.Enum, params []int32) {
	C.gl1_5_glFogiv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogi.xml
func (gl *GL) Fogi(pname glbase.Enum, param int32) {
	C.gl1_5_glFogi(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogfv.xml
func (gl *GL) Fogfv(pname glbase.Enum, params []float32) {
	C.gl1_5_glFogfv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogf.xml
func (gl *GL) Fogf(pname glbase.Enum, param float32) {
	C.gl1_5_glFogf(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorMaterial.xml
func (gl *GL) ColorMaterial(face, mode glbase.Enum) {
	C.gl1_5_glColorMaterial(gl.funcs, C.GLenum(face), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClipPlane.xml
func (gl *GL) ClipPlane(plane glbase.Enum, equation []float64) {
	C.gl1_5_glClipPlane(gl.funcs, C.GLenum(plane), (*C.GLdouble)(unsafe.Pointer(&equation[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4sv.xml
func (gl *GL) Vertex4sv(v []int16) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex4sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4s.xml
func (gl *GL) Vertex4s(x, y, z, w int16) {
	C.gl1_5_glVertex4s(gl.funcs, C.GLshort(x), C.GLshort(y), C.GLshort(z), C.GLshort(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4iv.xml
func (gl *GL) Vertex4iv(v []int32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex4iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4i.xml
func (gl *GL) Vertex4i(x, y, z, w int) {
	C.gl1_5_glVertex4i(gl.funcs, C.GLint(x), C.GLint(y), C.GLint(z), C.GLint(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4fv.xml
func (gl *GL) Vertex4fv(v []float32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex4fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4f.xml
func (gl *GL) Vertex4f(x, y, z, w float32) {
	C.gl1_5_glVertex4f(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z), C.GLfloat(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4dv.xml
func (gl *GL) Vertex4dv(v []float64) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex4dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex4d.xml
func (gl *GL) Vertex4d(x, y, z, w float64) {
	C.gl1_5_glVertex4d(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z), C.GLdouble(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3sv.xml
func (gl *GL) Vertex3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3s.xml
func (gl *GL) Vertex3s(x, y, z int16) {
	C.gl1_5_glVertex3s(gl.funcs, C.GLshort(x), C.GLshort(y), C.GLshort(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3iv.xml
func (gl *GL) Vertex3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3i.xml
func (gl *GL) Vertex3i(x, y, z int) {
	C.gl1_5_glVertex3i(gl.funcs, C.GLint(x), C.GLint(y), C.GLint(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3fv.xml
func (gl *GL) Vertex3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3f.xml
func (gl *GL) Vertex3f(x, y, z float32) {
	C.gl1_5_glVertex3f(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3dv.xml
func (gl *GL) Vertex3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex3d.xml
func (gl *GL) Vertex3d(x, y, z float64) {
	C.gl1_5_glVertex3d(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2sv.xml
func (gl *GL) Vertex2sv(v []int16) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex2sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2s.xml
func (gl *GL) Vertex2s(x, y int16) {
	C.gl1_5_glVertex2s(gl.funcs, C.GLshort(x), C.GLshort(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2iv.xml
func (gl *GL) Vertex2iv(v []int32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex2iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2i.xml
func (gl *GL) Vertex2i(x, y int) {
	C.gl1_5_glVertex2i(gl.funcs, C.GLint(x), C.GLint(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2fv.xml
func (gl *GL) Vertex2fv(v []float32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex2fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2f.xml
func (gl *GL) Vertex2f(x, y float32) {
	C.gl1_5_glVertex2f(gl.funcs, C.GLfloat(x), C.GLfloat(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2dv.xml
func (gl *GL) Vertex2dv(v []float64) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glVertex2dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertex2d.xml
func (gl *GL) Vertex2d(x, y float64) {
	C.gl1_5_glVertex2d(gl.funcs, C.GLdouble(x), C.GLdouble(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4sv.xml
func (gl *GL) TexCoord4sv(v []int16) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord4sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4s.xml
func (gl *GL) TexCoord4s(s, t, r, q int16) {
	C.gl1_5_glTexCoord4s(gl.funcs, C.GLshort(s), C.GLshort(t), C.GLshort(r), C.GLshort(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4iv.xml
func (gl *GL) TexCoord4iv(v []int32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord4iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4i.xml
func (gl *GL) TexCoord4i(s, t, r, q int32) {
	C.gl1_5_glTexCoord4i(gl.funcs, C.GLint(s), C.GLint(t), C.GLint(r), C.GLint(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4fv.xml
func (gl *GL) TexCoord4fv(v []float32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord4fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4f.xml
func (gl *GL) TexCoord4f(s, t, r, q float32) {
	C.gl1_5_glTexCoord4f(gl.funcs, C.GLfloat(s), C.GLfloat(t), C.GLfloat(r), C.GLfloat(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4dv.xml
func (gl *GL) TexCoord4dv(v []float64) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord4dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord4d.xml
func (gl *GL) TexCoord4d(s, t, r, q float64) {
	C.gl1_5_glTexCoord4d(gl.funcs, C.GLdouble(s), C.GLdouble(t), C.GLdouble(r), C.GLdouble(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3sv.xml
func (gl *GL) TexCoord3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3s.xml
func (gl *GL) TexCoord3s(s, t, r int16) {
	C.gl1_5_glTexCoord3s(gl.funcs, C.GLshort(s), C.GLshort(t), C.GLshort(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3iv.xml
func (gl *GL) TexCoord3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3i.xml
func (gl *GL) TexCoord3i(s, t, r int32) {
	C.gl1_5_glTexCoord3i(gl.funcs, C.GLint(s), C.GLint(t), C.GLint(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3fv.xml
func (gl *GL) TexCoord3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3f.xml
func (gl *GL) TexCoord3f(s, t, r float32) {
	C.gl1_5_glTexCoord3f(gl.funcs, C.GLfloat(s), C.GLfloat(t), C.GLfloat(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3dv.xml
func (gl *GL) TexCoord3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord3d.xml
func (gl *GL) TexCoord3d(s, t, r float64) {
	C.gl1_5_glTexCoord3d(gl.funcs, C.GLdouble(s), C.GLdouble(t), C.GLdouble(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2sv.xml
func (gl *GL) TexCoord2sv(v []int16) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord2sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2s.xml
func (gl *GL) TexCoord2s(s, t int16) {
	C.gl1_5_glTexCoord2s(gl.funcs, C.GLshort(s), C.GLshort(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2iv.xml
func (gl *GL) TexCoord2iv(v []int32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord2iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2i.xml
func (gl *GL) TexCoord2i(s, t int32) {
	C.gl1_5_glTexCoord2i(gl.funcs, C.GLint(s), C.GLint(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2fv.xml
func (gl *GL) TexCoord2fv(v []float32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord2fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2f.xml
func (gl *GL) TexCoord2f(s, t float32) {
	C.gl1_5_glTexCoord2f(gl.funcs, C.GLfloat(s), C.GLfloat(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2dv.xml
func (gl *GL) TexCoord2dv(v []float64) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glTexCoord2dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord2d.xml
func (gl *GL) TexCoord2d(s, t float64) {
	C.gl1_5_glTexCoord2d(gl.funcs, C.GLdouble(s), C.GLdouble(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1sv.xml
func (gl *GL) TexCoord1sv(v []int16) {
	C.gl1_5_glTexCoord1sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1s.xml
func (gl *GL) TexCoord1s(s int16) {
	C.gl1_5_glTexCoord1s(gl.funcs, C.GLshort(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1iv.xml
func (gl *GL) TexCoord1iv(v []int32) {
	C.gl1_5_glTexCoord1iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1i.xml
func (gl *GL) TexCoord1i(s int32) {
	C.gl1_5_glTexCoord1i(gl.funcs, C.GLint(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1fv.xml
func (gl *GL) TexCoord1fv(v []float32) {
	C.gl1_5_glTexCoord1fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1f.xml
func (gl *GL) TexCoord1f(s float32) {
	C.gl1_5_glTexCoord1f(gl.funcs, C.GLfloat(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1dv.xml
func (gl *GL) TexCoord1dv(v []float64) {
	C.gl1_5_glTexCoord1dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoord1d.xml
func (gl *GL) TexCoord1d(s float64) {
	C.gl1_5_glTexCoord1d(gl.funcs, C.GLdouble(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRectsv.xml
func (gl *GL) Rectsv(v1, v2 []int16) {
	C.gl1_5_glRectsv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v1[0])), (*C.GLshort)(unsafe.Pointer(&v2[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRects.xml
func (gl *GL) Rects(x1, y1, x2, y2 int16) {
	C.gl1_5_glRects(gl.funcs, C.GLshort(x1), C.GLshort(y1), C.GLshort(x2), C.GLshort(y2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRectiv.xml
func (gl *GL) Rectiv(v1, v2 []int32) {
	C.gl1_5_glRectiv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v1[0])), (*C.GLint)(unsafe.Pointer(&v2[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRecti.xml
func (gl *GL) Recti(x1, y1, x2, y2 int32) {
	C.gl1_5_glRecti(gl.funcs, C.GLint(x1), C.GLint(y1), C.GLint(x2), C.GLint(y2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRectfv.xml
func (gl *GL) Rectfv(v1, v2 []float32) {
	C.gl1_5_glRectfv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v1[0])), (*C.GLfloat)(unsafe.Pointer(&v2[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRectf.xml
func (gl *GL) Rectf(x1, y1, x2, y2 float32) {
	C.gl1_5_glRectf(gl.funcs, C.GLfloat(x1), C.GLfloat(y1), C.GLfloat(x2), C.GLfloat(y2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRectdv.xml
func (gl *GL) Rectdv(v1, v2 []float64) {
	C.gl1_5_glRectdv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v1[0])), (*C.GLdouble)(unsafe.Pointer(&v2[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRectd.xml
func (gl *GL) Rectd(x1, y1, x2, y2 float64) {
	C.gl1_5_glRectd(gl.funcs, C.GLdouble(x1), C.GLdouble(y1), C.GLdouble(x2), C.GLdouble(y2))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4sv.xml
func (gl *GL) RasterPos4sv(v []int16) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos4sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4s.xml
func (gl *GL) RasterPos4s(x, y, z, w int16) {
	C.gl1_5_glRasterPos4s(gl.funcs, C.GLshort(x), C.GLshort(y), C.GLshort(z), C.GLshort(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4iv.xml
func (gl *GL) RasterPos4iv(v []int32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos4iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4i.xml
func (gl *GL) RasterPos4i(x, y, z, w int) {
	C.gl1_5_glRasterPos4i(gl.funcs, C.GLint(x), C.GLint(y), C.GLint(z), C.GLint(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4fv.xml
func (gl *GL) RasterPos4fv(v []float32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos4fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4f.xml
func (gl *GL) RasterPos4f(x, y, z, w float32) {
	C.gl1_5_glRasterPos4f(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z), C.GLfloat(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4dv.xml
func (gl *GL) RasterPos4dv(v []float64) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos4dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos4d.xml
func (gl *GL) RasterPos4d(x, y, z, w float64) {
	C.gl1_5_glRasterPos4d(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z), C.GLdouble(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3sv.xml
func (gl *GL) RasterPos3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3s.xml
func (gl *GL) RasterPos3s(x, y, z int16) {
	C.gl1_5_glRasterPos3s(gl.funcs, C.GLshort(x), C.GLshort(y), C.GLshort(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3iv.xml
func (gl *GL) RasterPos3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3i.xml
func (gl *GL) RasterPos3i(x, y, z int) {
	C.gl1_5_glRasterPos3i(gl.funcs, C.GLint(x), C.GLint(y), C.GLint(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3fv.xml
func (gl *GL) RasterPos3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3f.xml
func (gl *GL) RasterPos3f(x, y, z float32) {
	C.gl1_5_glRasterPos3f(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3dv.xml
func (gl *GL) RasterPos3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos3d.xml
func (gl *GL) RasterPos3d(x, y, z float64) {
	C.gl1_5_glRasterPos3d(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2sv.xml
func (gl *GL) RasterPos2sv(v []int16) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos2sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2s.xml
func (gl *GL) RasterPos2s(x, y int16) {
	C.gl1_5_glRasterPos2s(gl.funcs, C.GLshort(x), C.GLshort(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2iv.xml
func (gl *GL) RasterPos2iv(v []int32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos2iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2i.xml
func (gl *GL) RasterPos2i(x, y int) {
	C.gl1_5_glRasterPos2i(gl.funcs, C.GLint(x), C.GLint(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2fv.xml
func (gl *GL) RasterPos2fv(v []float32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos2fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2f.xml
func (gl *GL) RasterPos2f(x, y float32) {
	C.gl1_5_glRasterPos2f(gl.funcs, C.GLfloat(x), C.GLfloat(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2dv.xml
func (gl *GL) RasterPos2dv(v []float64) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glRasterPos2dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRasterPos2d.xml
func (gl *GL) RasterPos2d(x, y float64) {
	C.gl1_5_glRasterPos2d(gl.funcs, C.GLdouble(x), C.GLdouble(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3sv.xml
func (gl *GL) Normal3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glNormal3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3s.xml
func (gl *GL) Normal3s(nx, ny, nz int16) {
	C.gl1_5_glNormal3s(gl.funcs, C.GLshort(nx), C.GLshort(ny), C.GLshort(nz))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3iv.xml
func (gl *GL) Normal3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glNormal3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3i.xml
func (gl *GL) Normal3i(nx, ny, nz int32) {
	C.gl1_5_glNormal3i(gl.funcs, C.GLint(nx), C.GLint(ny), C.GLint(nz))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3fv.xml
func (gl *GL) Normal3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glNormal3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3f.xml
func (gl *GL) Normal3f(nx, ny, nz float32) {
	C.gl1_5_glNormal3f(gl.funcs, C.GLfloat(nx), C.GLfloat(ny), C.GLfloat(nz))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3dv.xml
func (gl *GL) Normal3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glNormal3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3d.xml
func (gl *GL) Normal3d(nx, ny, nz float64) {
	C.gl1_5_glNormal3d(gl.funcs, C.GLdouble(nx), C.GLdouble(ny), C.GLdouble(nz))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3bv.xml
func (gl *GL) Normal3bv(v []byte) {
	C.gl1_5_glNormal3bv(gl.funcs, (*C.GLbyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormal3b.xml
func (gl *GL) Normal3b(nx, ny, nz byte) {
	C.gl1_5_glNormal3b(gl.funcs, C.GLbyte(nx), C.GLbyte(ny), C.GLbyte(nz))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexsv.xml
func (gl *GL) Indexsv(c []int16) {
	C.gl1_5_glIndexsv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&c[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexs.xml
func (gl *GL) Indexs(c int16) {
	C.gl1_5_glIndexs(gl.funcs, C.GLshort(c))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexiv.xml
func (gl *GL) Indexiv(c []int32) {
	C.gl1_5_glIndexiv(gl.funcs, (*C.GLint)(unsafe.Pointer(&c[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexi.xml
func (gl *GL) Indexi(c int32) {
	C.gl1_5_glIndexi(gl.funcs, C.GLint(c))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexfv.xml
func (gl *GL) Indexfv(c []float32) {
	C.gl1_5_glIndexfv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&c[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexf.xml
func (gl *GL) Indexf(c float32) {
	C.gl1_5_glIndexf(gl.funcs, C.GLfloat(c))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexdv.xml
func (gl *GL) Indexdv(c []float64) {
	C.gl1_5_glIndexdv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&c[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexd.xml
func (gl *GL) Indexd(c float64) {
	C.gl1_5_glIndexd(gl.funcs, C.GLdouble(c))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEnd.xml
func (gl *GL) End() {
	C.gl1_5_glEnd(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlagv.xml
func (gl *GL) EdgeFlagv(flag []bool) {
	C.gl1_5_glEdgeFlagv(gl.funcs, (*C.GLboolean)(unsafe.Pointer(&flag[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlag.xml
func (gl *GL) EdgeFlag(flag bool) {
	C.gl1_5_glEdgeFlag(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&flag)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4usv.xml
func (gl *GL) Color4usv(v []uint16) {
	C.gl1_5_glColor4usv(gl.funcs, (*C.GLushort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4us.xml
func (gl *GL) Color4us(red, green, blue, alpha uint16) {
	C.gl1_5_glColor4us(gl.funcs, C.GLushort(red), C.GLushort(green), C.GLushort(blue), C.GLushort(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4uiv.xml
func (gl *GL) Color4uiv(v []uint32) {
	C.gl1_5_glColor4uiv(gl.funcs, (*C.GLuint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4ui.xml
func (gl *GL) Color4ui(red, green, blue, alpha uint32) {
	C.gl1_5_glColor4ui(gl.funcs, C.GLuint(red), C.GLuint(green), C.GLuint(blue), C.GLuint(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4ubv.xml
func (gl *GL) Color4ubv(v []uint8) {
	C.gl1_5_glColor4ubv(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4ub.xml
func (gl *GL) Color4ub(red, green, blue, alpha uint8) {
	C.gl1_5_glColor4ub(gl.funcs, C.GLubyte(red), C.GLubyte(green), C.GLubyte(blue), C.GLubyte(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4sv.xml
func (gl *GL) Color4sv(v []int16) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor4sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4s.xml
func (gl *GL) Color4s(red, green, blue, alpha int16) {
	C.gl1_5_glColor4s(gl.funcs, C.GLshort(red), C.GLshort(green), C.GLshort(blue), C.GLshort(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4iv.xml
func (gl *GL) Color4iv(v []int32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor4iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4i.xml
func (gl *GL) Color4i(red, green, blue, alpha int32) {
	C.gl1_5_glColor4i(gl.funcs, C.GLint(red), C.GLint(green), C.GLint(blue), C.GLint(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4fv.xml
func (gl *GL) Color4fv(v []float32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor4fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4f.xml
func (gl *GL) Color4f(red, green, blue, alpha float32) {
	C.gl1_5_glColor4f(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue), C.GLfloat(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4dv.xml
func (gl *GL) Color4dv(v []float64) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor4dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4d.xml
func (gl *GL) Color4d(red, green, blue, alpha float64) {
	C.gl1_5_glColor4d(gl.funcs, C.GLdouble(red), C.GLdouble(green), C.GLdouble(blue), C.GLdouble(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4bv.xml
func (gl *GL) Color4bv(v []byte) {
	C.gl1_5_glColor4bv(gl.funcs, (*C.GLbyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor4b.xml
func (gl *GL) Color4b(red, green, blue, alpha byte) {
	C.gl1_5_glColor4b(gl.funcs, C.GLbyte(red), C.GLbyte(green), C.GLbyte(blue), C.GLbyte(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3usv.xml
func (gl *GL) Color3usv(v []uint16) {
	C.gl1_5_glColor3usv(gl.funcs, (*C.GLushort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3us.xml
func (gl *GL) Color3us(red, green, blue uint16) {
	C.gl1_5_glColor3us(gl.funcs, C.GLushort(red), C.GLushort(green), C.GLushort(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3uiv.xml
func (gl *GL) Color3uiv(v []uint32) {
	C.gl1_5_glColor3uiv(gl.funcs, (*C.GLuint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3ui.xml
func (gl *GL) Color3ui(red, green, blue uint32) {
	C.gl1_5_glColor3ui(gl.funcs, C.GLuint(red), C.GLuint(green), C.GLuint(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3ubv.xml
func (gl *GL) Color3ubv(v []uint8) {
	C.gl1_5_glColor3ubv(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3ub.xml
func (gl *GL) Color3ub(red, green, blue uint8) {
	C.gl1_5_glColor3ub(gl.funcs, C.GLubyte(red), C.GLubyte(green), C.GLubyte(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3sv.xml
func (gl *GL) Color3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3s.xml
func (gl *GL) Color3s(red, green, blue int16) {
	C.gl1_5_glColor3s(gl.funcs, C.GLshort(red), C.GLshort(green), C.GLshort(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3iv.xml
func (gl *GL) Color3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3i.xml
func (gl *GL) Color3i(red, green, blue int32) {
	C.gl1_5_glColor3i(gl.funcs, C.GLint(red), C.GLint(green), C.GLint(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3fv.xml
func (gl *GL) Color3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3f.xml
func (gl *GL) Color3f(red, green, blue float32) {
	C.gl1_5_glColor3f(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3dv.xml
func (gl *GL) Color3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glColor3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3d.xml
func (gl *GL) Color3d(red, green, blue float64) {
	C.gl1_5_glColor3d(gl.funcs, C.GLdouble(red), C.GLdouble(green), C.GLdouble(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3bv.xml
func (gl *GL) Color3bv(v []byte) {
	C.gl1_5_glColor3bv(gl.funcs, (*C.GLbyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColor3b.xml
func (gl *GL) Color3b(red, green, blue byte) {
	C.gl1_5_glColor3b(gl.funcs, C.GLbyte(red), C.GLbyte(green), C.GLbyte(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBitmap.xml
func (gl *GL) Bitmap(width, height int, xorig, yorig, xmove, ymove float32, bitmap []uint8) {
	C.gl1_5_glBitmap(gl.funcs, C.GLsizei(width), C.GLsizei(height), C.GLfloat(xorig), C.GLfloat(yorig), C.GLfloat(xmove), C.GLfloat(ymove), (*C.GLubyte)(unsafe.Pointer(&bitmap[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBegin.xml
func (gl *GL) Begin(mode glbase.Enum) {
	C.gl1_5_glBegin(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glListBase.xml
func (gl *GL) ListBase(base uint32) {
	C.gl1_5_glListBase(gl.funcs, C.GLuint(base))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGenLists.xml
func (gl *GL) GenLists(range_ int32) uint32 {
	glresult := C.gl1_5_glGenLists(gl.funcs, C.GLsizei(range_))
	return uint32(glresult)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteLists.xml
func (gl *GL) DeleteLists(list uint32, range_ int32) {
	C.gl1_5_glDeleteLists(gl.funcs, C.GLuint(list), C.GLsizei(range_))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCallLists.xml
func (gl *GL) CallLists(n int, gltype glbase.Enum, lists interface{}) {
	var lists_ptr unsafe.Pointer
	var lists_v = reflect.ValueOf(lists)
	if lists != nil && lists_v.Kind() != reflect.Slice {
		panic("parameter lists must be a slice")
	}
	if lists != nil {
		lists_ptr = unsafe.Pointer(lists_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glCallLists(gl.funcs, C.GLsizei(n), C.GLenum(gltype), lists_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCallList.xml
func (gl *GL) CallList(list uint32) {
	C.gl1_5_glCallList(gl.funcs, C.GLuint(list))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEndList.xml
func (gl *GL) EndList() {
	C.gl1_5_glEndList(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNewList.xml
func (gl *GL) NewList(list uint32, mode glbase.Enum) {
	C.gl1_5_glNewList(gl.funcs, C.GLuint(list), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPushClientAttrib.xml
func (gl *GL) PushClientAttrib(mask glbase.Bitfield) {
	C.gl1_5_glPushClientAttrib(gl.funcs, C.GLbitfield(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPopClientAttrib.xml
func (gl *GL) PopClientAttrib() {
	C.gl1_5_glPopClientAttrib(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPrioritizeTextures.xml
func (gl *GL) PrioritizeTextures(n int, textures []glbase.Texture, priorities []float32) {
	C.gl1_5_glPrioritizeTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])), (*C.GLfloat)(unsafe.Pointer(&priorities[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glAreTexturesResident.xml
func (gl *GL) AreTexturesResident(n int, textures []glbase.Texture, residences []bool) bool {
	glresult := C.gl1_5_glAreTexturesResident(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])), (*C.GLboolean)(unsafe.Pointer(&residences[0])))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexPointer.xml
func (gl *GL) VertexPointer(size int, gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glVertexPointer(gl.funcs, C.GLint(size), C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexCoordPointer.xml
func (gl *GL) TexCoordPointer(size int, gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glTexCoordPointer(gl.funcs, C.GLint(size), C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glNormalPointer.xml
func (gl *GL) NormalPointer(gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glNormalPointer(gl.funcs, C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glInterleavedArrays.xml
func (gl *GL) InterleavedArrays(format glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glInterleavedArrays(gl.funcs, C.GLenum(format), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIndexPointer.xml
func (gl *GL) IndexPointer(gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glIndexPointer(gl.funcs, C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEnableClientState.xml
func (gl *GL) EnableClientState(array glbase.Enum) {
	C.gl1_5_glEnableClientState(gl.funcs, C.GLenum(array))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlagPointer.xml
func (gl *GL) EdgeFlagPointer(stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glEdgeFlagPointer(gl.funcs, C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDisableClientState.xml
func (gl *GL) DisableClientState(array glbase.Enum) {
	C.gl1_5_glDisableClientState(gl.funcs, C.GLenum(array))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorPointer.xml
func (gl *GL) ColorPointer(size int, gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glColorPointer(gl.funcs, C.GLint(size), C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glArrayElement.xml
func (gl *GL) ArrayElement(i int32) {
	C.gl1_5_glArrayElement(gl.funcs, C.GLint(i))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glResetMinmax.xml
func (gl *GL) ResetMinmax(target glbase.Enum) {
	C.gl1_5_glResetMinmax(gl.funcs, C.GLenum(target))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glResetHistogram.xml
func (gl *GL) ResetHistogram(target glbase.Enum) {
	C.gl1_5_glResetHistogram(gl.funcs, C.GLenum(target))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMinmax.xml
func (gl *GL) Minmax(target, internalFormat glbase.Enum, sink bool) {
	C.gl1_5_glMinmax(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), *(*C.GLboolean)(unsafe.Pointer(&sink)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glHistogram.xml
func (gl *GL) Histogram(target glbase.Enum, width int, internalFormat glbase.Enum, sink bool) {
	C.gl1_5_glHistogram(gl.funcs, C.GLenum(target), C.GLsizei(width), C.GLenum(internalFormat), *(*C.GLboolean)(unsafe.Pointer(&sink)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmaxParameteriv.xml
func (gl *GL) GetMinmaxParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetMinmaxParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmaxParameterfv.xml
func (gl *GL) GetMinmaxParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetMinmaxParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmax.xml
func (gl *GL) GetMinmax(target glbase.Enum, reset bool, format, gltype glbase.Enum, values interface{}) {
	var values_ptr unsafe.Pointer
	var values_v = reflect.ValueOf(values)
	if values != nil && values_v.Kind() != reflect.Slice {
		panic("parameter values must be a slice")
	}
	if values != nil {
		values_ptr = unsafe.Pointer(values_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetMinmax(gl.funcs, C.GLenum(target), *(*C.GLboolean)(unsafe.Pointer(&reset)), C.GLenum(format), C.GLenum(gltype), values_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogramParameteriv.xml
func (gl *GL) GetHistogramParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetHistogramParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogramParameterfv.xml
func (gl *GL) GetHistogramParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetHistogramParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogram.xml
func (gl *GL) GetHistogram(target glbase.Enum, reset bool, format, gltype glbase.Enum, values interface{}) {
	var values_ptr unsafe.Pointer
	var values_v = reflect.ValueOf(values)
	if values != nil && values_v.Kind() != reflect.Slice {
		panic("parameter values must be a slice")
	}
	if values != nil {
		values_ptr = unsafe.Pointer(values_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetHistogram(gl.funcs, C.GLenum(target), *(*C.GLboolean)(unsafe.Pointer(&reset)), C.GLenum(format), C.GLenum(gltype), values_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSeparableFilter2D.xml
func (gl *GL) SeparableFilter2D(target, internalFormat glbase.Enum, width, height int, format, gltype glbase.Enum, row, column interface{}) {
	var row_ptr unsafe.Pointer
	var row_v = reflect.ValueOf(row)
	if row != nil && row_v.Kind() != reflect.Slice {
		panic("parameter row must be a slice")
	}
	if row != nil {
		row_ptr = unsafe.Pointer(row_v.Index(0).Addr().Pointer())
	}
	var column_ptr unsafe.Pointer
	var column_v = reflect.ValueOf(column)
	if column != nil && column_v.Kind() != reflect.Slice {
		panic("parameter column must be a slice")
	}
	if column != nil {
		column_ptr = unsafe.Pointer(column_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glSeparableFilter2D(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), row_ptr, column_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetSeparableFilter.xml
func (gl *GL) GetSeparableFilter(target, format, gltype glbase.Enum, row, column, span interface{}) {
	var row_ptr unsafe.Pointer
	var row_v = reflect.ValueOf(row)
	if row != nil && row_v.Kind() != reflect.Slice {
		panic("parameter row must be a slice")
	}
	if row != nil {
		row_ptr = unsafe.Pointer(row_v.Index(0).Addr().Pointer())
	}
	var column_ptr unsafe.Pointer
	var column_v = reflect.ValueOf(column)
	if column != nil && column_v.Kind() != reflect.Slice {
		panic("parameter column must be a slice")
	}
	if column != nil {
		column_ptr = unsafe.Pointer(column_v.Index(0).Addr().Pointer())
	}
	var span_ptr unsafe.Pointer
	var span_v = reflect.ValueOf(span)
	if span != nil && span_v.Kind() != reflect.Slice {
		panic("parameter span must be a slice")
	}
	if span != nil {
		span_ptr = unsafe.Pointer(span_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetSeparableFilter(gl.funcs, C.GLenum(target), C.GLenum(format), C.GLenum(gltype), row_ptr, column_ptr, span_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionParameteriv.xml
func (gl *GL) GetConvolutionParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetConvolutionParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionParameterfv.xml
func (gl *GL) GetConvolutionParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetConvolutionParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionFilter.xml
func (gl *GL) GetConvolutionFilter(target, format, gltype glbase.Enum, image interface{}) {
	var image_ptr unsafe.Pointer
	var image_v = reflect.ValueOf(image)
	if image != nil && image_v.Kind() != reflect.Slice {
		panic("parameter image must be a slice")
	}
	if image != nil {
		image_ptr = unsafe.Pointer(image_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetConvolutionFilter(gl.funcs, C.GLenum(target), C.GLenum(format), C.GLenum(gltype), image_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyConvolutionFilter2D.xml
func (gl *GL) CopyConvolutionFilter2D(target, internalFormat glbase.Enum, x, y, width, height int) {
	C.gl1_5_glCopyConvolutionFilter2D(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyConvolutionFilter1D.xml
func (gl *GL) CopyConvolutionFilter1D(target, internalFormat glbase.Enum, x, y, width int) {
	C.gl1_5_glCopyConvolutionFilter1D(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameteriv.xml
func (gl *GL) ConvolutionParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glConvolutionParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameteri.xml
func (gl *GL) ConvolutionParameteri(target, pname glbase.Enum, params int32) {
	C.gl1_5_glConvolutionParameteri(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLint(params))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameterfv.xml
func (gl *GL) ConvolutionParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glConvolutionParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameterf.xml
func (gl *GL) ConvolutionParameterf(target, pname glbase.Enum, params float32) {
	C.gl1_5_glConvolutionParameterf(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLfloat(params))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionFilter2D.xml
func (gl *GL) ConvolutionFilter2D(target, internalFormat glbase.Enum, width, height int, format, gltype glbase.Enum, image interface{}) {
	var image_ptr unsafe.Pointer
	var image_v = reflect.ValueOf(image)
	if image != nil && image_v.Kind() != reflect.Slice {
		panic("parameter image must be a slice")
	}
	if image != nil {
		image_ptr = unsafe.Pointer(image_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glConvolutionFilter2D(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), image_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionFilter1D.xml
func (gl *GL) ConvolutionFilter1D(target, internalFormat glbase.Enum, width int, format, gltype glbase.Enum, image interface{}) {
	var image_ptr unsafe.Pointer
	var image_v = reflect.ValueOf(image)
	if image != nil && image_v.Kind() != reflect.Slice {
		panic("parameter image must be a slice")
	}
	if image != nil {
		image_ptr = unsafe.Pointer(image_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glConvolutionFilter1D(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLsizei(width), C.GLenum(format), C.GLenum(gltype), image_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyColorSubTable.xml
func (gl *GL) CopyColorSubTable(target glbase.Enum, start int32, x, y, width int) {
	C.gl1_5_glCopyColorSubTable(gl.funcs, C.GLenum(target), C.GLsizei(start), C.GLint(x), C.GLint(y), C.GLsizei(width))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorSubTable.xml
func (gl *GL) ColorSubTable(target glbase.Enum, start int32, count int, format, gltype glbase.Enum, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glColorSubTable(gl.funcs, C.GLenum(target), C.GLsizei(start), C.GLsizei(count), C.GLenum(format), C.GLenum(gltype), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTableParameteriv.xml
func (gl *GL) GetColorTableParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glGetColorTableParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTableParameterfv.xml
func (gl *GL) GetColorTableParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glGetColorTableParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTable.xml
func (gl *GL) GetColorTable(target, format, gltype glbase.Enum, table interface{}) {
	var table_ptr unsafe.Pointer
	var table_v = reflect.ValueOf(table)
	if table != nil && table_v.Kind() != reflect.Slice {
		panic("parameter table must be a slice")
	}
	if table != nil {
		table_ptr = unsafe.Pointer(table_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glGetColorTable(gl.funcs, C.GLenum(target), C.GLenum(format), C.GLenum(gltype), table_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyColorTable.xml
func (gl *GL) CopyColorTable(target, internalFormat glbase.Enum, x, y, width int) {
	C.gl1_5_glCopyColorTable(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorTableParameteriv.xml
func (gl *GL) ColorTableParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl1_5_glColorTableParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorTableParameterfv.xml
func (gl *GL) ColorTableParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl1_5_glColorTableParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorTable.xml
func (gl *GL) ColorTable(target, internalFormat glbase.Enum, width int, format, gltype glbase.Enum, table interface{}) {
	var table_ptr unsafe.Pointer
	var table_v = reflect.ValueOf(table)
	if table != nil && table_v.Kind() != reflect.Slice {
		panic("parameter table must be a slice")
	}
	if table != nil {
		table_ptr = unsafe.Pointer(table_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glColorTable(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLsizei(width), C.GLenum(format), C.GLenum(gltype), table_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultTransposeMatrixd.xml
func (gl *GL) MultTransposeMatrixd(m []float64) {
	C.gl1_5_glMultTransposeMatrixd(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultTransposeMatrixf.xml
func (gl *GL) MultTransposeMatrixf(m []float32) {
	C.gl1_5_glMultTransposeMatrixf(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLoadTransposeMatrixd.xml
func (gl *GL) LoadTransposeMatrixd(m []float64) {
	C.gl1_5_glLoadTransposeMatrixd(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLoadTransposeMatrixf.xml
func (gl *GL) LoadTransposeMatrixf(m []float32) {
	C.gl1_5_glLoadTransposeMatrixf(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&m[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4sv.xml
func (gl *GL) MultiTexCoord4sv(target glbase.Enum, v []int16) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord4sv(gl.funcs, C.GLenum(target), (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4s.xml
func (gl *GL) MultiTexCoord4s(target glbase.Enum, s, t, r, q int16) {
	C.gl1_5_glMultiTexCoord4s(gl.funcs, C.GLenum(target), C.GLshort(s), C.GLshort(t), C.GLshort(r), C.GLshort(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4iv.xml
func (gl *GL) MultiTexCoord4iv(target glbase.Enum, v []int32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord4iv(gl.funcs, C.GLenum(target), (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4i.xml
func (gl *GL) MultiTexCoord4i(target glbase.Enum, s, t, r, q int32) {
	C.gl1_5_glMultiTexCoord4i(gl.funcs, C.GLenum(target), C.GLint(s), C.GLint(t), C.GLint(r), C.GLint(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4fv.xml
func (gl *GL) MultiTexCoord4fv(target glbase.Enum, v []float32) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord4fv(gl.funcs, C.GLenum(target), (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4f.xml
func (gl *GL) MultiTexCoord4f(target glbase.Enum, s, t, r, q float32) {
	C.gl1_5_glMultiTexCoord4f(gl.funcs, C.GLenum(target), C.GLfloat(s), C.GLfloat(t), C.GLfloat(r), C.GLfloat(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4dv.xml
func (gl *GL) MultiTexCoord4dv(target glbase.Enum, v []float64) {
	if len(v) != 4 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord4dv(gl.funcs, C.GLenum(target), (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord4d.xml
func (gl *GL) MultiTexCoord4d(target glbase.Enum, s, t, r, q float64) {
	C.gl1_5_glMultiTexCoord4d(gl.funcs, C.GLenum(target), C.GLdouble(s), C.GLdouble(t), C.GLdouble(r), C.GLdouble(q))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3sv.xml
func (gl *GL) MultiTexCoord3sv(target glbase.Enum, v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord3sv(gl.funcs, C.GLenum(target), (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3s.xml
func (gl *GL) MultiTexCoord3s(target glbase.Enum, s, t, r int16) {
	C.gl1_5_glMultiTexCoord3s(gl.funcs, C.GLenum(target), C.GLshort(s), C.GLshort(t), C.GLshort(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3iv.xml
func (gl *GL) MultiTexCoord3iv(target glbase.Enum, v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord3iv(gl.funcs, C.GLenum(target), (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3i.xml
func (gl *GL) MultiTexCoord3i(target glbase.Enum, s, t, r int32) {
	C.gl1_5_glMultiTexCoord3i(gl.funcs, C.GLenum(target), C.GLint(s), C.GLint(t), C.GLint(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3fv.xml
func (gl *GL) MultiTexCoord3fv(target glbase.Enum, v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord3fv(gl.funcs, C.GLenum(target), (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3f.xml
func (gl *GL) MultiTexCoord3f(target glbase.Enum, s, t, r float32) {
	C.gl1_5_glMultiTexCoord3f(gl.funcs, C.GLenum(target), C.GLfloat(s), C.GLfloat(t), C.GLfloat(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3dv.xml
func (gl *GL) MultiTexCoord3dv(target glbase.Enum, v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord3dv(gl.funcs, C.GLenum(target), (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord3d.xml
func (gl *GL) MultiTexCoord3d(target glbase.Enum, s, t, r float64) {
	C.gl1_5_glMultiTexCoord3d(gl.funcs, C.GLenum(target), C.GLdouble(s), C.GLdouble(t), C.GLdouble(r))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2sv.xml
func (gl *GL) MultiTexCoord2sv(target glbase.Enum, v []int16) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord2sv(gl.funcs, C.GLenum(target), (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2s.xml
func (gl *GL) MultiTexCoord2s(target glbase.Enum, s, t int16) {
	C.gl1_5_glMultiTexCoord2s(gl.funcs, C.GLenum(target), C.GLshort(s), C.GLshort(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2iv.xml
func (gl *GL) MultiTexCoord2iv(target glbase.Enum, v []int32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord2iv(gl.funcs, C.GLenum(target), (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2i.xml
func (gl *GL) MultiTexCoord2i(target glbase.Enum, s, t int32) {
	C.gl1_5_glMultiTexCoord2i(gl.funcs, C.GLenum(target), C.GLint(s), C.GLint(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2fv.xml
func (gl *GL) MultiTexCoord2fv(target glbase.Enum, v []float32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord2fv(gl.funcs, C.GLenum(target), (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2f.xml
func (gl *GL) MultiTexCoord2f(target glbase.Enum, s, t float32) {
	C.gl1_5_glMultiTexCoord2f(gl.funcs, C.GLenum(target), C.GLfloat(s), C.GLfloat(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2dv.xml
func (gl *GL) MultiTexCoord2dv(target glbase.Enum, v []float64) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glMultiTexCoord2dv(gl.funcs, C.GLenum(target), (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord2d.xml
func (gl *GL) MultiTexCoord2d(target glbase.Enum, s, t float64) {
	C.gl1_5_glMultiTexCoord2d(gl.funcs, C.GLenum(target), C.GLdouble(s), C.GLdouble(t))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1sv.xml
func (gl *GL) MultiTexCoord1sv(target glbase.Enum, v []int16) {
	C.gl1_5_glMultiTexCoord1sv(gl.funcs, C.GLenum(target), (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1s.xml
func (gl *GL) MultiTexCoord1s(target glbase.Enum, s int16) {
	C.gl1_5_glMultiTexCoord1s(gl.funcs, C.GLenum(target), C.GLshort(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1iv.xml
func (gl *GL) MultiTexCoord1iv(target glbase.Enum, v []int32) {
	C.gl1_5_glMultiTexCoord1iv(gl.funcs, C.GLenum(target), (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1i.xml
func (gl *GL) MultiTexCoord1i(target glbase.Enum, s int32) {
	C.gl1_5_glMultiTexCoord1i(gl.funcs, C.GLenum(target), C.GLint(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1fv.xml
func (gl *GL) MultiTexCoord1fv(target glbase.Enum, v []float32) {
	C.gl1_5_glMultiTexCoord1fv(gl.funcs, C.GLenum(target), (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1f.xml
func (gl *GL) MultiTexCoord1f(target glbase.Enum, s float32) {
	C.gl1_5_glMultiTexCoord1f(gl.funcs, C.GLenum(target), C.GLfloat(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1dv.xml
func (gl *GL) MultiTexCoord1dv(target glbase.Enum, v []float64) {
	C.gl1_5_glMultiTexCoord1dv(gl.funcs, C.GLenum(target), (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glMultiTexCoord1d.xml
func (gl *GL) MultiTexCoord1d(target glbase.Enum, s float64) {
	C.gl1_5_glMultiTexCoord1d(gl.funcs, C.GLenum(target), C.GLdouble(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClientActiveTexture.xml
func (gl *GL) ClientActiveTexture(texture glbase.Enum) {
	C.gl1_5_glClientActiveTexture(gl.funcs, C.GLenum(texture))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3sv.xml
func (gl *GL) WindowPos3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3s.xml
func (gl *GL) WindowPos3s(x, y, z int16) {
	C.gl1_5_glWindowPos3s(gl.funcs, C.GLshort(x), C.GLshort(y), C.GLshort(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3iv.xml
func (gl *GL) WindowPos3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3i.xml
func (gl *GL) WindowPos3i(x, y, z int) {
	C.gl1_5_glWindowPos3i(gl.funcs, C.GLint(x), C.GLint(y), C.GLint(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3fv.xml
func (gl *GL) WindowPos3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3f.xml
func (gl *GL) WindowPos3f(x, y, z float32) {
	C.gl1_5_glWindowPos3f(gl.funcs, C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3dv.xml
func (gl *GL) WindowPos3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos3d.xml
func (gl *GL) WindowPos3d(x, y, z float64) {
	C.gl1_5_glWindowPos3d(gl.funcs, C.GLdouble(x), C.GLdouble(y), C.GLdouble(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2sv.xml
func (gl *GL) WindowPos2sv(v []int16) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos2sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2s.xml
func (gl *GL) WindowPos2s(x, y int16) {
	C.gl1_5_glWindowPos2s(gl.funcs, C.GLshort(x), C.GLshort(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2iv.xml
func (gl *GL) WindowPos2iv(v []int32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos2iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2i.xml
func (gl *GL) WindowPos2i(x, y int) {
	C.gl1_5_glWindowPos2i(gl.funcs, C.GLint(x), C.GLint(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2fv.xml
func (gl *GL) WindowPos2fv(v []float32) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos2fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2f.xml
func (gl *GL) WindowPos2f(x, y float32) {
	C.gl1_5_glWindowPos2f(gl.funcs, C.GLfloat(x), C.GLfloat(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2dv.xml
func (gl *GL) WindowPos2dv(v []float64) {
	if len(v) != 2 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glWindowPos2dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glWindowPos2d.xml
func (gl *GL) WindowPos2d(x, y float64) {
	C.gl1_5_glWindowPos2d(gl.funcs, C.GLdouble(x), C.GLdouble(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColorPointer.xml
func (gl *GL) SecondaryColorPointer(size int, gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glSecondaryColorPointer(gl.funcs, C.GLint(size), C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3usv.xml
func (gl *GL) SecondaryColor3usv(v []uint16) {
	C.gl1_5_glSecondaryColor3usv(gl.funcs, (*C.GLushort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3us.xml
func (gl *GL) SecondaryColor3us(red, green, blue uint16) {
	C.gl1_5_glSecondaryColor3us(gl.funcs, C.GLushort(red), C.GLushort(green), C.GLushort(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3uiv.xml
func (gl *GL) SecondaryColor3uiv(v []uint32) {
	C.gl1_5_glSecondaryColor3uiv(gl.funcs, (*C.GLuint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3ui.xml
func (gl *GL) SecondaryColor3ui(red, green, blue uint32) {
	C.gl1_5_glSecondaryColor3ui(gl.funcs, C.GLuint(red), C.GLuint(green), C.GLuint(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3ubv.xml
func (gl *GL) SecondaryColor3ubv(v []uint8) {
	C.gl1_5_glSecondaryColor3ubv(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3ub.xml
func (gl *GL) SecondaryColor3ub(red, green, blue uint8) {
	C.gl1_5_glSecondaryColor3ub(gl.funcs, C.GLubyte(red), C.GLubyte(green), C.GLubyte(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3sv.xml
func (gl *GL) SecondaryColor3sv(v []int16) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glSecondaryColor3sv(gl.funcs, (*C.GLshort)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3s.xml
func (gl *GL) SecondaryColor3s(red, green, blue int16) {
	C.gl1_5_glSecondaryColor3s(gl.funcs, C.GLshort(red), C.GLshort(green), C.GLshort(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3iv.xml
func (gl *GL) SecondaryColor3iv(v []int32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glSecondaryColor3iv(gl.funcs, (*C.GLint)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3i.xml
func (gl *GL) SecondaryColor3i(red, green, blue int32) {
	C.gl1_5_glSecondaryColor3i(gl.funcs, C.GLint(red), C.GLint(green), C.GLint(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3fv.xml
func (gl *GL) SecondaryColor3fv(v []float32) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glSecondaryColor3fv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3f.xml
func (gl *GL) SecondaryColor3f(red, green, blue float32) {
	C.gl1_5_glSecondaryColor3f(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3dv.xml
func (gl *GL) SecondaryColor3dv(v []float64) {
	if len(v) != 3 {
		panic("parameter v has incorrect length")
	}
	C.gl1_5_glSecondaryColor3dv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3d.xml
func (gl *GL) SecondaryColor3d(red, green, blue float64) {
	C.gl1_5_glSecondaryColor3d(gl.funcs, C.GLdouble(red), C.GLdouble(green), C.GLdouble(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3bv.xml
func (gl *GL) SecondaryColor3bv(v []byte) {
	C.gl1_5_glSecondaryColor3bv(gl.funcs, (*C.GLbyte)(unsafe.Pointer(&v[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSecondaryColor3b.xml
func (gl *GL) SecondaryColor3b(red, green, blue byte) {
	C.gl1_5_glSecondaryColor3b(gl.funcs, C.GLbyte(red), C.GLbyte(green), C.GLbyte(blue))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoordPointer.xml
func (gl *GL) FogCoordPointer(gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl1_5_glFogCoordPointer(gl.funcs, C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoorddv.xml
func (gl *GL) FogCoorddv(coord []float64) {
	C.gl1_5_glFogCoorddv(gl.funcs, (*C.GLdouble)(unsafe.Pointer(&coord[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoordd.xml
func (gl *GL) FogCoordd(coord float64) {
	C.gl1_5_glFogCoordd(gl.funcs, C.GLdouble(coord))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoordfv.xml
func (gl *GL) FogCoordfv(coord []float32) {
	C.gl1_5_glFogCoordfv(gl.funcs, (*C.GLfloat)(unsafe.Pointer(&coord[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoordf.xml
func (gl *GL) FogCoordf(coord float32) {
	C.gl1_5_glFogCoordf(gl.funcs, C.GLfloat(coord))
}
