// ** file automatically generated by glgen -- do not edit manually **

package GL

// #cgo CXXFLAGS: -std=c++0x -pedantic-errors -Wall -fno-strict-aliasing
// #cgo LDFLAGS: -lstdc++
// #cgo pkg-config: Qt5Core Qt5OpenGL
//
// #include "funcs.h"
//
// void free(void*);
//
import "C"

import (
	"fmt"
	"reflect"
	"unsafe"

	"gopkg.in/qml.v1/gl/glbase"
)

// API returns a value that offers methods matching the OpenGL version 3.2 API.
//
// The returned API must not be used after the provided OpenGL context becomes invalid.
func API(context glbase.Contexter) *GL {
	gl := &GL{}
	gl.funcs = C.gl3_2core_funcs()
	if gl.funcs == nil {
		panic(fmt.Errorf("OpenGL version 3.2 is not available"))
	}
	return gl
}

// GL implements the OpenGL version 3.2 API. Values of this
// type must be created via the API function, and it must not be used after
// the associated OpenGL context becomes invalid.
type GL struct {
	funcs unsafe.Pointer
}

const (
	FALSE = 0
	TRUE  = 1
	NONE  = 0

	BYTE           = 0x1400
	UNSIGNED_BYTE  = 0x1401
	SHORT          = 0x1402
	UNSIGNED_SHORT = 0x1403
	INT            = 0x1404
	UNSIGNED_INT   = 0x1405
	FLOAT          = 0x1406
	DOUBLE         = 0x140A
	HALF_FLOAT     = 0x140B

	COLOR_BUFFER_BIT   = 0x00004000
	DEPTH_BUFFER_BIT   = 0x00000100
	STENCIL_BUFFER_BIT = 0x00000400

	ALWAYS   = 0x0207
	EQUAL    = 0x0202
	GEQUAL   = 0x0206
	GREATER  = 0x0204
	LEQUAL   = 0x0203
	LESS     = 0x0201
	NEVER    = 0x0200
	NOTEQUAL = 0x0205

	DST_ALPHA           = 0x0304
	ONE                 = 1
	ONE_MINUS_DST_ALPHA = 0x0305
	ONE_MINUS_SRC_ALPHA = 0x0303
	ONE_MINUS_SRC_COLOR = 0x0301
	SRC_ALPHA           = 0x0302
	SRC_COLOR           = 0x0300
	ZERO                = 0

	DST_COLOR           = 0x0306
	ONE_MINUS_DST_COLOR = 0x0307
	SRC_ALPHA_SATURATE  = 0x0308

	CLIP_DISTANCE0 = 0x3000
	CLIP_DISTANCE1 = 0x3001
	CLIP_DISTANCE2 = 0x3002
	CLIP_DISTANCE3 = 0x3003
	CLIP_DISTANCE4 = 0x3004
	CLIP_DISTANCE5 = 0x3005
	CLIP_DISTANCE6 = 0x3006
	CLIP_DISTANCE7 = 0x3007

	BACK           = 0x0405
	FRONT          = 0x0404
	FRONT_AND_BACK = 0x0408

	CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x00000001

	CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002
	CONTEXT_CORE_PROFILE_BIT          = 0x00000001

	BACK_LEFT   = 0x0402
	BACK_RIGHT  = 0x0403
	FRONT_LEFT  = 0x0400
	FRONT_RIGHT = 0x0401
	LEFT        = 0x0406
	RIGHT       = 0x0407

	BLEND                = 0x0BE2
	COLOR_LOGIC_OP       = 0x0BF2
	CULL_FACE            = 0x0B44
	DEPTH_TEST           = 0x0B71
	DITHER               = 0x0BD0
	LINE_SMOOTH          = 0x0B20
	POLYGON_OFFSET_FILL  = 0x8037
	POLYGON_OFFSET_LINE  = 0x2A02
	POLYGON_OFFSET_POINT = 0x2A01
	POLYGON_SMOOTH       = 0x0B41
	SCISSOR_TEST         = 0x0C11
	STENCIL_TEST         = 0x0B90
	TEXTURE_1D           = 0x0DE0
	TEXTURE_2D           = 0x0DE1

	INVALID_ENUM                  = 0x0500
	INVALID_FRAMEBUFFER_OPERATION = 0x0506
	INVALID_OPERATION             = 0x0502
	INVALID_VALUE                 = 0x0501
	NO_ERROR                      = 0
	OUT_OF_MEMORY                 = 0x0505

	LINEAR = 0x2601

	CCW = 0x0901
	CW  = 0x0900

	ALIASED_LINE_WIDTH_RANGE      = 0x846E
	BLEND_DST                     = 0x0BE0
	BLEND_SRC                     = 0x0BE1
	COLOR_CLEAR_VALUE             = 0x0C22
	COLOR_WRITEMASK               = 0x0C23
	CULL_FACE_MODE                = 0x0B45
	DEPTH_CLEAR_VALUE             = 0x0B73
	DEPTH_FUNC                    = 0x0B74
	DEPTH_RANGE                   = 0x0B70
	DEPTH_WRITEMASK               = 0x0B72
	DOUBLEBUFFER                  = 0x0C32
	DRAW_BUFFER                   = 0x0C01
	FRONT_FACE                    = 0x0B46
	LINE_SMOOTH_HINT              = 0x0C52
	LINE_WIDTH                    = 0x0B21
	LINE_WIDTH_GRANULARITY        = 0x0B23
	LINE_WIDTH_RANGE              = 0x0B22
	LOGIC_OP_MODE                 = 0x0BF0
	MAX_CLIP_DISTANCES            = 0x0D32
	MAX_TEXTURE_SIZE              = 0x0D33
	MAX_VIEWPORT_DIMS             = 0x0D3A
	PACK_ALIGNMENT                = 0x0D05
	PACK_LSB_FIRST                = 0x0D01
	PACK_ROW_LENGTH               = 0x0D02
	PACK_SKIP_PIXELS              = 0x0D04
	PACK_SKIP_ROWS                = 0x0D03
	PACK_SWAP_BYTES               = 0x0D00
	POINT_SIZE                    = 0x0B11
	POINT_SIZE_GRANULARITY        = 0x0B13
	POINT_SIZE_RANGE              = 0x0B12
	POLYGON_MODE                  = 0x0B40
	POLYGON_OFFSET_FACTOR         = 0x8038
	POLYGON_OFFSET_UNITS          = 0x2A00
	POLYGON_SMOOTH_HINT           = 0x0C53
	READ_BUFFER                   = 0x0C02
	SCISSOR_BOX                   = 0x0C10
	SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23
	SMOOTH_LINE_WIDTH_RANGE       = 0x0B22
	SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13
	SMOOTH_POINT_SIZE_RANGE       = 0x0B12
	STENCIL_CLEAR_VALUE           = 0x0B91
	STENCIL_FAIL                  = 0x0B94
	STENCIL_FUNC                  = 0x0B92
	STENCIL_PASS_DEPTH_FAIL       = 0x0B95
	STENCIL_PASS_DEPTH_PASS       = 0x0B96
	STENCIL_REF                   = 0x0B97
	STENCIL_VALUE_MASK            = 0x0B93
	STENCIL_WRITEMASK             = 0x0B98
	STEREO                        = 0x0C33
	SUBPIXEL_BITS                 = 0x0D50
	TEXTURE_BINDING_1D            = 0x8068
	TEXTURE_BINDING_2D            = 0x8069
	TEXTURE_BINDING_3D            = 0x806A
	UNPACK_ALIGNMENT              = 0x0CF5
	UNPACK_LSB_FIRST              = 0x0CF1
	UNPACK_ROW_LENGTH             = 0x0CF2
	UNPACK_SKIP_PIXELS            = 0x0CF4
	UNPACK_SKIP_ROWS              = 0x0CF3
	UNPACK_SWAP_BYTES             = 0x0CF0
	VIEWPORT                      = 0x0BA2

	TEXTURE_ALPHA_SIZE      = 0x805F
	TEXTURE_BLUE_SIZE       = 0x805E
	TEXTURE_BORDER_COLOR    = 0x1004
	TEXTURE_GREEN_SIZE      = 0x805D
	TEXTURE_HEIGHT          = 0x1001
	TEXTURE_INTERNAL_FORMAT = 0x1003
	TEXTURE_MAG_FILTER      = 0x2800
	TEXTURE_MIN_FILTER      = 0x2801
	TEXTURE_RED_SIZE        = 0x805C
	TEXTURE_WIDTH           = 0x1000
	TEXTURE_WRAP_S          = 0x2802
	TEXTURE_WRAP_T          = 0x2803

	DONT_CARE = 0x1100
	FASTEST   = 0x1101
	NICEST    = 0x1102

	FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B
	TEXTURE_COMPRESSION_HINT        = 0x84EF

	REPLACE = 0x1E01

	AND           = 0x1501
	AND_INVERTED  = 0x1504
	AND_REVERSE   = 0x1502
	CLEAR         = 0x1500
	COPY          = 0x1503
	COPY_INVERTED = 0x150C
	EQUIV         = 0x1509
	INVERT        = 0x150A
	NAND          = 0x150E
	NOOP          = 0x1505
	NOR           = 0x1508
	OR            = 0x1507
	OR_INVERTED   = 0x150D
	OR_REVERSE    = 0x150B
	SET           = 0x150F
	XOR           = 0x1506

	MAP_FLUSH_EXPLICIT_BIT    = 0x0010
	MAP_INVALIDATE_BUFFER_BIT = 0x0008
	MAP_INVALIDATE_RANGE_BIT  = 0x0004
	MAP_READ_BIT              = 0x0001
	MAP_UNSYNCHRONIZED_BIT    = 0x0020
	MAP_WRITE_BIT             = 0x0002

	TEXTURE = 0x1702

	LINE  = 0x1B01
	POINT = 0x1B00

	FILL = 0x1B02

	COLOR   = 0x1800
	DEPTH   = 0x1801
	STENCIL = 0x1802

	ALPHA           = 0x1906
	BLUE            = 0x1905
	DEPTH_COMPONENT = 0x1902
	GREEN           = 0x1904
	RED             = 0x1903
	RGB             = 0x1907
	RGBA            = 0x1908
	STENCIL_INDEX   = 0x1901

	R3_G3_B2 = 0x2A10
	RGB10    = 0x8052
	RGB10_A2 = 0x8059
	RGB12    = 0x8053
	RGB16    = 0x8054
	RGB4     = 0x804F
	RGB5     = 0x8050
	RGB5_A1  = 0x8057
	RGB8     = 0x8051
	RGBA12   = 0x805A
	RGBA16   = 0x805B
	RGBA2    = 0x8055
	RGBA4    = 0x8056
	RGBA8    = 0x8058

	PACK_IMAGE_HEIGHT   = 0x806C
	PACK_SKIP_IMAGES    = 0x806B
	UNPACK_IMAGE_HEIGHT = 0x806E
	UNPACK_SKIP_IMAGES  = 0x806D

	UNSIGNED_BYTE_3_3_2     = 0x8032
	UNSIGNED_INT_10_10_10_2 = 0x8036
	UNSIGNED_INT_8_8_8_8    = 0x8035
	UNSIGNED_SHORT_4_4_4_4  = 0x8033
	UNSIGNED_SHORT_5_5_5_1  = 0x8034

	POINT_FADE_THRESHOLD_SIZE = 0x8128

	LINES                    = 0x0001
	LINES_ADJACENCY          = 0x000A
	LINE_LOOP                = 0x0002
	LINE_STRIP               = 0x0003
	LINE_STRIP_ADJACENCY     = 0x000B
	POINTS                   = 0x0000
	TRIANGLES                = 0x0004
	TRIANGLES_ADJACENCY      = 0x000C
	TRIANGLE_FAN             = 0x0006
	TRIANGLE_STRIP           = 0x0005
	TRIANGLE_STRIP_ADJACENCY = 0x000D

	DECR = 0x1E03
	INCR = 0x1E02
	KEEP = 0x1E00

	EXTENSIONS = 0x1F03
	RENDERER   = 0x1F01
	VENDOR     = 0x1F00
	VERSION    = 0x1F02

	NEAREST = 0x2600

	LINEAR_MIPMAP_LINEAR   = 0x2703
	LINEAR_MIPMAP_NEAREST  = 0x2701
	NEAREST_MIPMAP_LINEAR  = 0x2702
	NEAREST_MIPMAP_NEAREST = 0x2700

	TEXTURE_WRAP_R = 0x8072

	PROXY_TEXTURE_1D   = 0x8063
	PROXY_TEXTURE_2D   = 0x8064
	PROXY_TEXTURE_3D   = 0x8070
	TEXTURE_3D         = 0x806F
	TEXTURE_BASE_LEVEL = 0x813C
	TEXTURE_MAX_LEVEL  = 0x813D
	TEXTURE_MAX_LOD    = 0x813B
	TEXTURE_MIN_LOD    = 0x813A

	CLAMP_TO_BORDER = 0x812D
	CLAMP_TO_EDGE   = 0x812F
	REPEAT          = 0x2901

	SYNC_FLUSH_COMMANDS_BIT                       = 0x00000001
	INVALID_INDEX                                 = 0xFFFFFFFF
	TIMEOUT_IGNORED                               = 0xFFFFFFFFFFFFFFFF
	CONSTANT_COLOR                                = 0x8001
	ONE_MINUS_CONSTANT_COLOR                      = 0x8002
	CONSTANT_ALPHA                                = 0x8003
	ONE_MINUS_CONSTANT_ALPHA                      = 0x8004
	FUNC_ADD                                      = 0x8006
	MIN                                           = 0x8007
	MAX                                           = 0x8008
	BLEND_EQUATION_RGB                            = 0x8009
	FUNC_SUBTRACT                                 = 0x800A
	FUNC_REVERSE_SUBTRACT                         = 0x800B
	TEXTURE_DEPTH                                 = 0x8071
	MAX_3D_TEXTURE_SIZE                           = 0x8073
	MULTISAMPLE                                   = 0x809D
	SAMPLE_ALPHA_TO_COVERAGE                      = 0x809E
	SAMPLE_ALPHA_TO_ONE                           = 0x809F
	SAMPLE_COVERAGE                               = 0x80A0
	SAMPLE_BUFFERS                                = 0x80A8
	SAMPLES                                       = 0x80A9
	SAMPLE_COVERAGE_VALUE                         = 0x80AA
	SAMPLE_COVERAGE_INVERT                        = 0x80AB
	BLEND_DST_RGB                                 = 0x80C8
	BLEND_SRC_RGB                                 = 0x80C9
	BLEND_DST_ALPHA                               = 0x80CA
	BLEND_SRC_ALPHA                               = 0x80CB
	BGR                                           = 0x80E0
	BGRA                                          = 0x80E1
	MAX_ELEMENTS_VERTICES                         = 0x80E8
	MAX_ELEMENTS_INDICES                          = 0x80E9
	DEPTH_COMPONENT16                             = 0x81A5
	DEPTH_COMPONENT24                             = 0x81A6
	DEPTH_COMPONENT32                             = 0x81A7
	FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING         = 0x8210
	FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE         = 0x8211
	FRAMEBUFFER_ATTACHMENT_RED_SIZE               = 0x8212
	FRAMEBUFFER_ATTACHMENT_GREEN_SIZE             = 0x8213
	FRAMEBUFFER_ATTACHMENT_BLUE_SIZE              = 0x8214
	FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE             = 0x8215
	FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE             = 0x8216
	FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE           = 0x8217
	FRAMEBUFFER_DEFAULT                           = 0x8218
	FRAMEBUFFER_UNDEFINED                         = 0x8219
	DEPTH_STENCIL_ATTACHMENT                      = 0x821A
	MAJOR_VERSION                                 = 0x821B
	MINOR_VERSION                                 = 0x821C
	NUM_EXTENSIONS                                = 0x821D
	CONTEXT_FLAGS                                 = 0x821E
	COMPRESSED_RED                                = 0x8225
	COMPRESSED_RG                                 = 0x8226
	RG                                            = 0x8227
	RG_INTEGER                                    = 0x8228
	R8                                            = 0x8229
	R16                                           = 0x822A
	RG8                                           = 0x822B
	RG16                                          = 0x822C
	R16F                                          = 0x822D
	R32F                                          = 0x822E
	RG16F                                         = 0x822F
	RG32F                                         = 0x8230
	R8I                                           = 0x8231
	R8UI                                          = 0x8232
	R16I                                          = 0x8233
	R16UI                                         = 0x8234
	R32I                                          = 0x8235
	R32UI                                         = 0x8236
	RG8I                                          = 0x8237
	RG8UI                                         = 0x8238
	RG16I                                         = 0x8239
	RG16UI                                        = 0x823A
	RG32I                                         = 0x823B
	RG32UI                                        = 0x823C
	UNSIGNED_BYTE_2_3_3_REV                       = 0x8362
	UNSIGNED_SHORT_5_6_5                          = 0x8363
	UNSIGNED_SHORT_5_6_5_REV                      = 0x8364
	UNSIGNED_SHORT_4_4_4_4_REV                    = 0x8365
	UNSIGNED_SHORT_1_5_5_5_REV                    = 0x8366
	UNSIGNED_INT_8_8_8_8_REV                      = 0x8367
	UNSIGNED_INT_2_10_10_10_REV                   = 0x8368
	MIRRORED_REPEAT                               = 0x8370
	TEXTURE0                                      = 0x84C0
	TEXTURE1                                      = 0x84C1
	TEXTURE2                                      = 0x84C2
	TEXTURE3                                      = 0x84C3
	TEXTURE4                                      = 0x84C4
	TEXTURE5                                      = 0x84C5
	TEXTURE6                                      = 0x84C6
	TEXTURE7                                      = 0x84C7
	TEXTURE8                                      = 0x84C8
	TEXTURE9                                      = 0x84C9
	TEXTURE10                                     = 0x84CA
	TEXTURE11                                     = 0x84CB
	TEXTURE12                                     = 0x84CC
	TEXTURE13                                     = 0x84CD
	TEXTURE14                                     = 0x84CE
	TEXTURE15                                     = 0x84CF
	TEXTURE16                                     = 0x84D0
	TEXTURE17                                     = 0x84D1
	TEXTURE18                                     = 0x84D2
	TEXTURE19                                     = 0x84D3
	TEXTURE20                                     = 0x84D4
	TEXTURE21                                     = 0x84D5
	TEXTURE22                                     = 0x84D6
	TEXTURE23                                     = 0x84D7
	TEXTURE24                                     = 0x84D8
	TEXTURE25                                     = 0x84D9
	TEXTURE26                                     = 0x84DA
	TEXTURE27                                     = 0x84DB
	TEXTURE28                                     = 0x84DC
	TEXTURE29                                     = 0x84DD
	TEXTURE30                                     = 0x84DE
	TEXTURE31                                     = 0x84DF
	ACTIVE_TEXTURE                                = 0x84E0
	MAX_RENDERBUFFER_SIZE                         = 0x84E8
	COMPRESSED_RGB                                = 0x84ED
	COMPRESSED_RGBA                               = 0x84EE
	TEXTURE_RECTANGLE                             = 0x84F5
	TEXTURE_BINDING_RECTANGLE                     = 0x84F6
	PROXY_TEXTURE_RECTANGLE                       = 0x84F7
	MAX_RECTANGLE_TEXTURE_SIZE                    = 0x84F8
	DEPTH_STENCIL                                 = 0x84F9
	UNSIGNED_INT_24_8                             = 0x84FA
	MAX_TEXTURE_LOD_BIAS                          = 0x84FD
	TEXTURE_LOD_BIAS                              = 0x8501
	INCR_WRAP                                     = 0x8507
	DECR_WRAP                                     = 0x8508
	TEXTURE_CUBE_MAP                              = 0x8513
	TEXTURE_BINDING_CUBE_MAP                      = 0x8514
	TEXTURE_CUBE_MAP_POSITIVE_X                   = 0x8515
	TEXTURE_CUBE_MAP_NEGATIVE_X                   = 0x8516
	TEXTURE_CUBE_MAP_POSITIVE_Y                   = 0x8517
	TEXTURE_CUBE_MAP_NEGATIVE_Y                   = 0x8518
	TEXTURE_CUBE_MAP_POSITIVE_Z                   = 0x8519
	TEXTURE_CUBE_MAP_NEGATIVE_Z                   = 0x851A
	PROXY_TEXTURE_CUBE_MAP                        = 0x851B
	MAX_CUBE_MAP_TEXTURE_SIZE                     = 0x851C
	SRC1_ALPHA                                    = 0x8589
	VERTEX_ARRAY_BINDING                          = 0x85B5
	VERTEX_ATTRIB_ARRAY_ENABLED                   = 0x8622
	VERTEX_ATTRIB_ARRAY_SIZE                      = 0x8623
	VERTEX_ATTRIB_ARRAY_STRIDE                    = 0x8624
	VERTEX_ATTRIB_ARRAY_TYPE                      = 0x8625
	CURRENT_VERTEX_ATTRIB                         = 0x8626
	VERTEX_PROGRAM_POINT_SIZE                     = 0x8642
	PROGRAM_POINT_SIZE                            = 0x8642
	VERTEX_ATTRIB_ARRAY_POINTER                   = 0x8645
	DEPTH_CLAMP                                   = 0x864F
	TEXTURE_COMPRESSED_IMAGE_SIZE                 = 0x86A0
	TEXTURE_COMPRESSED                            = 0x86A1
	NUM_COMPRESSED_TEXTURE_FORMATS                = 0x86A2
	COMPRESSED_TEXTURE_FORMATS                    = 0x86A3
	BUFFER_SIZE                                   = 0x8764
	BUFFER_USAGE                                  = 0x8765
	STENCIL_BACK_FUNC                             = 0x8800
	STENCIL_BACK_FAIL                             = 0x8801
	STENCIL_BACK_PASS_DEPTH_FAIL                  = 0x8802
	STENCIL_BACK_PASS_DEPTH_PASS                  = 0x8803
	RGBA32F                                       = 0x8814
	RGB32F                                        = 0x8815
	RGBA16F                                       = 0x881A
	RGB16F                                        = 0x881B
	MAX_DRAW_BUFFERS                              = 0x8824
	DRAW_BUFFER0                                  = 0x8825
	DRAW_BUFFER1                                  = 0x8826
	DRAW_BUFFER2                                  = 0x8827
	DRAW_BUFFER3                                  = 0x8828
	DRAW_BUFFER4                                  = 0x8829
	DRAW_BUFFER5                                  = 0x882A
	DRAW_BUFFER6                                  = 0x882B
	DRAW_BUFFER7                                  = 0x882C
	DRAW_BUFFER8                                  = 0x882D
	DRAW_BUFFER9                                  = 0x882E
	DRAW_BUFFER10                                 = 0x882F
	DRAW_BUFFER11                                 = 0x8830
	DRAW_BUFFER12                                 = 0x8831
	DRAW_BUFFER13                                 = 0x8832
	DRAW_BUFFER14                                 = 0x8833
	DRAW_BUFFER15                                 = 0x8834
	BLEND_EQUATION_ALPHA                          = 0x883D
	TEXTURE_DEPTH_SIZE                            = 0x884A
	TEXTURE_COMPARE_MODE                          = 0x884C
	TEXTURE_COMPARE_FUNC                          = 0x884D
	COMPARE_REF_TO_TEXTURE                        = 0x884E
	TEXTURE_CUBE_MAP_SEAMLESS                     = 0x884F
	QUERY_COUNTER_BITS                            = 0x8864
	CURRENT_QUERY                                 = 0x8865
	QUERY_RESULT                                  = 0x8866
	QUERY_RESULT_AVAILABLE                        = 0x8867
	MAX_VERTEX_ATTRIBS                            = 0x8869
	VERTEX_ATTRIB_ARRAY_NORMALIZED                = 0x886A
	MAX_TEXTURE_IMAGE_UNITS                       = 0x8872
	ARRAY_BUFFER                                  = 0x8892
	ELEMENT_ARRAY_BUFFER                          = 0x8893
	ARRAY_BUFFER_BINDING                          = 0x8894
	ELEMENT_ARRAY_BUFFER_BINDING                  = 0x8895
	VERTEX_ATTRIB_ARRAY_BUFFER_BINDING            = 0x889F
	READ_ONLY                                     = 0x88B8
	WRITE_ONLY                                    = 0x88B9
	READ_WRITE                                    = 0x88BA
	BUFFER_ACCESS                                 = 0x88BB
	BUFFER_MAPPED                                 = 0x88BC
	BUFFER_MAP_POINTER                            = 0x88BD
	STREAM_DRAW                                   = 0x88E0
	STREAM_READ                                   = 0x88E1
	STREAM_COPY                                   = 0x88E2
	STATIC_DRAW                                   = 0x88E4
	STATIC_READ                                   = 0x88E5
	STATIC_COPY                                   = 0x88E6
	DYNAMIC_DRAW                                  = 0x88E8
	DYNAMIC_READ                                  = 0x88E9
	DYNAMIC_COPY                                  = 0x88EA
	PIXEL_PACK_BUFFER                             = 0x88EB
	PIXEL_UNPACK_BUFFER                           = 0x88EC
	PIXEL_PACK_BUFFER_BINDING                     = 0x88ED
	PIXEL_UNPACK_BUFFER_BINDING                   = 0x88EF
	DEPTH24_STENCIL8                              = 0x88F0
	TEXTURE_STENCIL_SIZE                          = 0x88F1
	VERTEX_ATTRIB_ARRAY_INTEGER                   = 0x88FD
	MAX_ARRAY_TEXTURE_LAYERS                      = 0x88FF
	MIN_PROGRAM_TEXEL_OFFSET                      = 0x8904
	MAX_PROGRAM_TEXEL_OFFSET                      = 0x8905
	SAMPLES_PASSED                                = 0x8914
	GEOMETRY_VERTICES_OUT                         = 0x8916
	GEOMETRY_INPUT_TYPE                           = 0x8917
	GEOMETRY_OUTPUT_TYPE                          = 0x8918
	CLAMP_READ_COLOR                              = 0x891C
	FIXED_ONLY                                    = 0x891D
	UNIFORM_BUFFER                                = 0x8A11
	UNIFORM_BUFFER_BINDING                        = 0x8A28
	UNIFORM_BUFFER_START                          = 0x8A29
	UNIFORM_BUFFER_SIZE                           = 0x8A2A
	MAX_VERTEX_UNIFORM_BLOCKS                     = 0x8A2B
	MAX_GEOMETRY_UNIFORM_BLOCKS                   = 0x8A2C
	MAX_FRAGMENT_UNIFORM_BLOCKS                   = 0x8A2D
	MAX_COMBINED_UNIFORM_BLOCKS                   = 0x8A2E
	MAX_UNIFORM_BUFFER_BINDINGS                   = 0x8A2F
	MAX_UNIFORM_BLOCK_SIZE                        = 0x8A30
	MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS        = 0x8A31
	MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS      = 0x8A32
	MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS      = 0x8A33
	UNIFORM_BUFFER_OFFSET_ALIGNMENT               = 0x8A34
	ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH          = 0x8A35
	ACTIVE_UNIFORM_BLOCKS                         = 0x8A36
	UNIFORM_TYPE                                  = 0x8A37
	UNIFORM_SIZE                                  = 0x8A38
	UNIFORM_NAME_LENGTH                           = 0x8A39
	UNIFORM_BLOCK_INDEX                           = 0x8A3A
	UNIFORM_OFFSET                                = 0x8A3B
	UNIFORM_ARRAY_STRIDE                          = 0x8A3C
	UNIFORM_MATRIX_STRIDE                         = 0x8A3D
	UNIFORM_IS_ROW_MAJOR                          = 0x8A3E
	UNIFORM_BLOCK_BINDING                         = 0x8A3F
	UNIFORM_BLOCK_DATA_SIZE                       = 0x8A40
	UNIFORM_BLOCK_NAME_LENGTH                     = 0x8A41
	UNIFORM_BLOCK_ACTIVE_UNIFORMS                 = 0x8A42
	UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES          = 0x8A43
	UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER     = 0x8A44
	UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER   = 0x8A45
	UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER   = 0x8A46
	FRAGMENT_SHADER                               = 0x8B30
	VERTEX_SHADER                                 = 0x8B31
	MAX_FRAGMENT_UNIFORM_COMPONENTS               = 0x8B49
	MAX_VERTEX_UNIFORM_COMPONENTS                 = 0x8B4A
	MAX_VARYING_FLOATS                            = 0x8B4B
	MAX_VARYING_COMPONENTS                        = 0x8B4B
	MAX_VERTEX_TEXTURE_IMAGE_UNITS                = 0x8B4C
	MAX_COMBINED_TEXTURE_IMAGE_UNITS              = 0x8B4D
	SHADER_TYPE                                   = 0x8B4F
	FLOAT_VEC2                                    = 0x8B50
	FLOAT_VEC3                                    = 0x8B51
	FLOAT_VEC4                                    = 0x8B52
	INT_VEC2                                      = 0x8B53
	INT_VEC3                                      = 0x8B54
	INT_VEC4                                      = 0x8B55
	BOOL                                          = 0x8B56
	BOOL_VEC2                                     = 0x8B57
	BOOL_VEC3                                     = 0x8B58
	BOOL_VEC4                                     = 0x8B59
	FLOAT_MAT2                                    = 0x8B5A
	FLOAT_MAT3                                    = 0x8B5B
	FLOAT_MAT4                                    = 0x8B5C
	SAMPLER_1D                                    = 0x8B5D
	SAMPLER_2D                                    = 0x8B5E
	SAMPLER_3D                                    = 0x8B5F
	SAMPLER_CUBE                                  = 0x8B60
	SAMPLER_1D_SHADOW                             = 0x8B61
	SAMPLER_2D_SHADOW                             = 0x8B62
	SAMPLER_2D_RECT                               = 0x8B63
	SAMPLER_2D_RECT_SHADOW                        = 0x8B64
	FLOAT_MAT2x3                                  = 0x8B65
	FLOAT_MAT2x4                                  = 0x8B66
	FLOAT_MAT3x2                                  = 0x8B67
	FLOAT_MAT3x4                                  = 0x8B68
	FLOAT_MAT4x2                                  = 0x8B69
	FLOAT_MAT4x3                                  = 0x8B6A
	DELETE_STATUS                                 = 0x8B80
	COMPILE_STATUS                                = 0x8B81
	LINK_STATUS                                   = 0x8B82
	VALIDATE_STATUS                               = 0x8B83
	INFO_LOG_LENGTH                               = 0x8B84
	ATTACHED_SHADERS                              = 0x8B85
	ACTIVE_UNIFORMS                               = 0x8B86
	ACTIVE_UNIFORM_MAX_LENGTH                     = 0x8B87
	SHADER_SOURCE_LENGTH                          = 0x8B88
	ACTIVE_ATTRIBUTES                             = 0x8B89
	ACTIVE_ATTRIBUTE_MAX_LENGTH                   = 0x8B8A
	SHADING_LANGUAGE_VERSION                      = 0x8B8C
	CURRENT_PROGRAM                               = 0x8B8D
	TEXTURE_RED_TYPE                              = 0x8C10
	TEXTURE_GREEN_TYPE                            = 0x8C11
	TEXTURE_BLUE_TYPE                             = 0x8C12
	TEXTURE_ALPHA_TYPE                            = 0x8C13
	TEXTURE_DEPTH_TYPE                            = 0x8C16
	UNSIGNED_NORMALIZED                           = 0x8C17
	TEXTURE_1D_ARRAY                              = 0x8C18
	PROXY_TEXTURE_1D_ARRAY                        = 0x8C19
	TEXTURE_2D_ARRAY                              = 0x8C1A
	PROXY_TEXTURE_2D_ARRAY                        = 0x8C1B
	TEXTURE_BINDING_1D_ARRAY                      = 0x8C1C
	TEXTURE_BINDING_2D_ARRAY                      = 0x8C1D
	MAX_GEOMETRY_TEXTURE_IMAGE_UNITS              = 0x8C29
	TEXTURE_BUFFER                                = 0x8C2A
	MAX_TEXTURE_BUFFER_SIZE                       = 0x8C2B
	TEXTURE_BINDING_BUFFER                        = 0x8C2C
	TEXTURE_BUFFER_DATA_STORE_BINDING             = 0x8C2D
	R11F_G11F_B10F                                = 0x8C3A
	UNSIGNED_INT_10F_11F_11F_REV                  = 0x8C3B
	RGB9_E5                                       = 0x8C3D
	UNSIGNED_INT_5_9_9_9_REV                      = 0x8C3E
	TEXTURE_SHARED_SIZE                           = 0x8C3F
	SRGB                                          = 0x8C40
	SRGB8                                         = 0x8C41
	SRGB_ALPHA                                    = 0x8C42
	SRGB8_ALPHA8                                  = 0x8C43
	COMPRESSED_SRGB                               = 0x8C48
	COMPRESSED_SRGB_ALPHA                         = 0x8C49
	TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH         = 0x8C76
	TRANSFORM_FEEDBACK_BUFFER_MODE                = 0x8C7F
	MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS    = 0x8C80
	TRANSFORM_FEEDBACK_VARYINGS                   = 0x8C83
	TRANSFORM_FEEDBACK_BUFFER_START               = 0x8C84
	TRANSFORM_FEEDBACK_BUFFER_SIZE                = 0x8C85
	PRIMITIVES_GENERATED                          = 0x8C87
	TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN         = 0x8C88
	RASTERIZER_DISCARD                            = 0x8C89
	MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A
	MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS       = 0x8C8B
	INTERLEAVED_ATTRIBS                           = 0x8C8C
	SEPARATE_ATTRIBS                              = 0x8C8D
	TRANSFORM_FEEDBACK_BUFFER                     = 0x8C8E
	TRANSFORM_FEEDBACK_BUFFER_BINDING             = 0x8C8F
	POINT_SPRITE_COORD_ORIGIN                     = 0x8CA0
	LOWER_LEFT                                    = 0x8CA1
	UPPER_LEFT                                    = 0x8CA2
	STENCIL_BACK_REF                              = 0x8CA3
	STENCIL_BACK_VALUE_MASK                       = 0x8CA4
	STENCIL_BACK_WRITEMASK                        = 0x8CA5
	DRAW_FRAMEBUFFER_BINDING                      = 0x8CA6
	FRAMEBUFFER_BINDING                           = 0x8CA6
	RENDERBUFFER_BINDING                          = 0x8CA7
	READ_FRAMEBUFFER                              = 0x8CA8
	DRAW_FRAMEBUFFER                              = 0x8CA9
	READ_FRAMEBUFFER_BINDING                      = 0x8CAA
	RENDERBUFFER_SAMPLES                          = 0x8CAB
	DEPTH_COMPONENT32F                            = 0x8CAC
	DEPTH32F_STENCIL8                             = 0x8CAD
	FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE            = 0x8CD0
	FRAMEBUFFER_ATTACHMENT_OBJECT_NAME            = 0x8CD1
	FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL          = 0x8CD2
	FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE  = 0x8CD3
	FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER          = 0x8CD4
	FRAMEBUFFER_COMPLETE                          = 0x8CD5
	FRAMEBUFFER_INCOMPLETE_ATTACHMENT             = 0x8CD6
	FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT     = 0x8CD7
	FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER            = 0x8CDB
	FRAMEBUFFER_INCOMPLETE_READ_BUFFER            = 0x8CDC
	FRAMEBUFFER_UNSUPPORTED                       = 0x8CDD
	MAX_COLOR_ATTACHMENTS                         = 0x8CDF
	COLOR_ATTACHMENT0                             = 0x8CE0
	COLOR_ATTACHMENT1                             = 0x8CE1
	COLOR_ATTACHMENT2                             = 0x8CE2
	COLOR_ATTACHMENT3                             = 0x8CE3
	COLOR_ATTACHMENT4                             = 0x8CE4
	COLOR_ATTACHMENT5                             = 0x8CE5
	COLOR_ATTACHMENT6                             = 0x8CE6
	COLOR_ATTACHMENT7                             = 0x8CE7
	COLOR_ATTACHMENT8                             = 0x8CE8
	COLOR_ATTACHMENT9                             = 0x8CE9
	COLOR_ATTACHMENT10                            = 0x8CEA
	COLOR_ATTACHMENT11                            = 0x8CEB
	COLOR_ATTACHMENT12                            = 0x8CEC
	COLOR_ATTACHMENT13                            = 0x8CED
	COLOR_ATTACHMENT14                            = 0x8CEE
	COLOR_ATTACHMENT15                            = 0x8CEF
	DEPTH_ATTACHMENT                              = 0x8D00
	STENCIL_ATTACHMENT                            = 0x8D20
	FRAMEBUFFER                                   = 0x8D40
	RENDERBUFFER                                  = 0x8D41
	RENDERBUFFER_WIDTH                            = 0x8D42
	RENDERBUFFER_HEIGHT                           = 0x8D43
	RENDERBUFFER_INTERNAL_FORMAT                  = 0x8D44
	STENCIL_INDEX1                                = 0x8D46
	STENCIL_INDEX4                                = 0x8D47
	STENCIL_INDEX8                                = 0x8D48
	STENCIL_INDEX16                               = 0x8D49
	RENDERBUFFER_RED_SIZE                         = 0x8D50
	RENDERBUFFER_GREEN_SIZE                       = 0x8D51
	RENDERBUFFER_BLUE_SIZE                        = 0x8D52
	RENDERBUFFER_ALPHA_SIZE                       = 0x8D53
	RENDERBUFFER_DEPTH_SIZE                       = 0x8D54
	RENDERBUFFER_STENCIL_SIZE                     = 0x8D55
	FRAMEBUFFER_INCOMPLETE_MULTISAMPLE            = 0x8D56
	MAX_SAMPLES                                   = 0x8D57
	RGBA32UI                                      = 0x8D70
	RGB32UI                                       = 0x8D71
	RGBA16UI                                      = 0x8D76
	RGB16UI                                       = 0x8D77
	RGBA8UI                                       = 0x8D7C
	RGB8UI                                        = 0x8D7D
	RGBA32I                                       = 0x8D82
	RGB32I                                        = 0x8D83
	RGBA16I                                       = 0x8D88
	RGB16I                                        = 0x8D89
	RGBA8I                                        = 0x8D8E
	RGB8I                                         = 0x8D8F
	RED_INTEGER                                   = 0x8D94
	GREEN_INTEGER                                 = 0x8D95
	BLUE_INTEGER                                  = 0x8D96
	RGB_INTEGER                                   = 0x8D98
	RGBA_INTEGER                                  = 0x8D99
	BGR_INTEGER                                   = 0x8D9A
	BGRA_INTEGER                                  = 0x8D9B
	FRAMEBUFFER_ATTACHMENT_LAYERED                = 0x8DA7
	FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS          = 0x8DA8
	FLOAT_32_UNSIGNED_INT_24_8_REV                = 0x8DAD
	FRAMEBUFFER_SRGB                              = 0x8DB9
	COMPRESSED_RED_RGTC1                          = 0x8DBB
	COMPRESSED_SIGNED_RED_RGTC1                   = 0x8DBC
	COMPRESSED_RG_RGTC2                           = 0x8DBD
	COMPRESSED_SIGNED_RG_RGTC2                    = 0x8DBE
	SAMPLER_1D_ARRAY                              = 0x8DC0
	SAMPLER_2D_ARRAY                              = 0x8DC1
	SAMPLER_BUFFER                                = 0x8DC2
	SAMPLER_1D_ARRAY_SHADOW                       = 0x8DC3
	SAMPLER_2D_ARRAY_SHADOW                       = 0x8DC4
	SAMPLER_CUBE_SHADOW                           = 0x8DC5
	UNSIGNED_INT_VEC2                             = 0x8DC6
	UNSIGNED_INT_VEC3                             = 0x8DC7
	UNSIGNED_INT_VEC4                             = 0x8DC8
	INT_SAMPLER_1D                                = 0x8DC9
	INT_SAMPLER_2D                                = 0x8DCA
	INT_SAMPLER_3D                                = 0x8DCB
	INT_SAMPLER_CUBE                              = 0x8DCC
	INT_SAMPLER_2D_RECT                           = 0x8DCD
	INT_SAMPLER_1D_ARRAY                          = 0x8DCE
	INT_SAMPLER_2D_ARRAY                          = 0x8DCF
	INT_SAMPLER_BUFFER                            = 0x8DD0
	UNSIGNED_INT_SAMPLER_1D                       = 0x8DD1
	UNSIGNED_INT_SAMPLER_2D                       = 0x8DD2
	UNSIGNED_INT_SAMPLER_3D                       = 0x8DD3
	UNSIGNED_INT_SAMPLER_CUBE                     = 0x8DD4
	UNSIGNED_INT_SAMPLER_2D_RECT                  = 0x8DD5
	UNSIGNED_INT_SAMPLER_1D_ARRAY                 = 0x8DD6
	UNSIGNED_INT_SAMPLER_2D_ARRAY                 = 0x8DD7
	UNSIGNED_INT_SAMPLER_BUFFER                   = 0x8DD8
	GEOMETRY_SHADER                               = 0x8DD9
	MAX_GEOMETRY_UNIFORM_COMPONENTS               = 0x8DDF
	MAX_GEOMETRY_OUTPUT_VERTICES                  = 0x8DE0
	MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS          = 0x8DE1
	QUERY_WAIT                                    = 0x8E13
	QUERY_NO_WAIT                                 = 0x8E14
	QUERY_BY_REGION_WAIT                          = 0x8E15
	QUERY_BY_REGION_NO_WAIT                       = 0x8E16
	QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION      = 0x8E4C
	FIRST_VERTEX_CONVENTION                       = 0x8E4D
	LAST_VERTEX_CONVENTION                        = 0x8E4E
	PROVOKING_VERTEX                              = 0x8E4F
	SAMPLE_POSITION                               = 0x8E50
	SAMPLE_MASK                                   = 0x8E51
	SAMPLE_MASK_VALUE                             = 0x8E52
	MAX_SAMPLE_MASK_WORDS                         = 0x8E59
	COPY_READ_BUFFER                              = 0x8F36
	COPY_WRITE_BUFFER                             = 0x8F37
	R8_SNORM                                      = 0x8F94
	RG8_SNORM                                     = 0x8F95
	RGB8_SNORM                                    = 0x8F96
	RGBA8_SNORM                                   = 0x8F97
	R16_SNORM                                     = 0x8F98
	RG16_SNORM                                    = 0x8F99
	RGB16_SNORM                                   = 0x8F9A
	RGBA16_SNORM                                  = 0x8F9B
	SIGNED_NORMALIZED                             = 0x8F9C
	PRIMITIVE_RESTART                             = 0x8F9D
	PRIMITIVE_RESTART_INDEX                       = 0x8F9E
	TEXTURE_2D_MULTISAMPLE                        = 0x9100
	PROXY_TEXTURE_2D_MULTISAMPLE                  = 0x9101
	TEXTURE_2D_MULTISAMPLE_ARRAY                  = 0x9102
	PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY            = 0x9103
	TEXTURE_BINDING_2D_MULTISAMPLE                = 0x9104
	TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY          = 0x9105
	TEXTURE_SAMPLES                               = 0x9106
	TEXTURE_FIXED_SAMPLE_LOCATIONS                = 0x9107
	SAMPLER_2D_MULTISAMPLE                        = 0x9108
	INT_SAMPLER_2D_MULTISAMPLE                    = 0x9109
	UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE           = 0x910A
	SAMPLER_2D_MULTISAMPLE_ARRAY                  = 0x910B
	INT_SAMPLER_2D_MULTISAMPLE_ARRAY              = 0x910C
	UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY     = 0x910D
	MAX_COLOR_TEXTURE_SAMPLES                     = 0x910E
	MAX_DEPTH_TEXTURE_SAMPLES                     = 0x910F
	MAX_INTEGER_SAMPLES                           = 0x9110
	MAX_SERVER_WAIT_TIMEOUT                       = 0x9111
	OBJECT_TYPE                                   = 0x9112
	SYNC_CONDITION                                = 0x9113
	SYNC_STATUS                                   = 0x9114
	SYNC_FLAGS                                    = 0x9115
	SYNC_FENCE                                    = 0x9116
	SYNC_GPU_COMMANDS_COMPLETE                    = 0x9117
	UNSIGNALED                                    = 0x9118
	SIGNALED                                      = 0x9119
	ALREADY_SIGNALED                              = 0x911A
	TIMEOUT_EXPIRED                               = 0x911B
	CONDITION_SATISFIED                           = 0x911C
	WAIT_FAILED                                   = 0x911D
	BUFFER_ACCESS_FLAGS                           = 0x911F
	BUFFER_MAP_LENGTH                             = 0x9120
	BUFFER_MAP_OFFSET                             = 0x9121
	MAX_VERTEX_OUTPUT_COMPONENTS                  = 0x9122
	MAX_GEOMETRY_INPUT_COMPONENTS                 = 0x9123
	MAX_GEOMETRY_OUTPUT_COMPONENTS                = 0x9124
	MAX_FRAGMENT_INPUT_COMPONENTS                 = 0x9125
	CONTEXT_PROFILE_MASK                          = 0x9126
)

// https://www.opengl.org/sdk/docs/man3/xhtml/glViewport.xml
func (gl *GL) Viewport(x, y, width, height int) {
	C.gl3_2core_glViewport(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// DepthRange specifies the mapping of depth values from normalized device
// coordinates to window coordinates.
//
// Parameter nearVal specifies the mapping of the near clipping plane to window
// coordinates (defaults to 0), while farVal specifies the mapping of the far
// clipping plane to window coordinates (defaults to 1).
//
// After clipping and division by w, depth coordinates range from -1 to 1,
// corresponding to the near and far clipping planes. DepthRange specifies a
// linear mapping of the normalized depth coordinates in this range to window
// depth coordinates. Regardless of the actual depth buffer implementation,
// window coordinate depth values are treated as though they range from 0 through 1
// (like color components). Thus, the values accepted by DepthRange are both
// clamped to this range before they are accepted.
//
// The default setting of (0, 1) maps the near plane to 0 and the far plane to 1.
// With this mapping, the depth buffer range is fully utilized.
//
// It is not necessary that nearVal be less than farVal. Reverse mappings such as
// nearVal 1, and farVal 0 are acceptable.
//
// GL.INVALID_OPERATION is generated if DepthRange is executed between the
// execution of Begin and the corresponding execution of End.
func (gl *GL) DepthRange(nearVal, farVal float64) {
	C.gl3_2core_glDepthRange(gl.funcs, C.GLdouble(nearVal), C.GLdouble(farVal))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsEnabled.xml
func (gl *GL) IsEnabled(cap glbase.Enum) bool {
	glresult := C.gl3_2core_glIsEnabled(gl.funcs, C.GLenum(cap))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexLevelParameteriv.xml
func (gl *GL) GetTexLevelParameteriv(target glbase.Enum, level int, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetTexLevelParameteriv(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexLevelParameterfv.xml
func (gl *GL) GetTexLevelParameterfv(target glbase.Enum, level int, pname glbase.Enum, params []float32) {
	C.gl3_2core_glGetTexLevelParameterfv(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameteriv.xml
func (gl *GL) GetTexParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetTexParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameterfv.xml
func (gl *GL) GetTexParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl3_2core_glGetTexParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexImage.xml
func (gl *GL) GetTexImage(target glbase.Enum, level int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glGetTexImage(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetIntegerv.xml
func (gl *GL) GetIntegerv(pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetIntegerv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetFloatv.xml
func (gl *GL) GetFloatv(pname glbase.Enum, params []float32) {
	C.gl3_2core_glGetFloatv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetError.xml
func (gl *GL) GetError() glbase.Enum {
	glresult := C.gl3_2core_glGetError(gl.funcs)
	return glbase.Enum(glresult)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetDoublev.xml
func (gl *GL) GetDoublev(pname glbase.Enum, params []float64) {
	C.gl3_2core_glGetDoublev(gl.funcs, C.GLenum(pname), (*C.GLdouble)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetBooleanv.xml
func (gl *GL) GetBooleanv(pname glbase.Enum, params []bool) {
	C.gl3_2core_glGetBooleanv(gl.funcs, C.GLenum(pname), (*C.GLboolean)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glReadPixels.xml
func (gl *GL) ReadPixels(x, y, width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glReadPixels(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glReadBuffer.xml
func (gl *GL) ReadBuffer(mode glbase.Enum) {
	C.gl3_2core_glReadBuffer(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPixelStorei.xml
func (gl *GL) PixelStorei(pname glbase.Enum, param int32) {
	C.gl3_2core_glPixelStorei(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPixelStoref.xml
func (gl *GL) PixelStoref(pname glbase.Enum, param float32) {
	C.gl3_2core_glPixelStoref(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDepthFunc.xml
func (gl *GL) DepthFunc(glfunc glbase.Enum) {
	C.gl3_2core_glDepthFunc(gl.funcs, C.GLenum(glfunc))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glStencilOp.xml
func (gl *GL) StencilOp(fail, zfail, zpass glbase.Enum) {
	C.gl3_2core_glStencilOp(gl.funcs, C.GLenum(fail), C.GLenum(zfail), C.GLenum(zpass))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glStencilFunc.xml
func (gl *GL) StencilFunc(glfunc glbase.Enum, ref int32, mask uint32) {
	C.gl3_2core_glStencilFunc(gl.funcs, C.GLenum(glfunc), C.GLint(ref), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glLogicOp.xml
func (gl *GL) LogicOp(opcode glbase.Enum) {
	C.gl3_2core_glLogicOp(gl.funcs, C.GLenum(opcode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBlendFunc.xml
func (gl *GL) BlendFunc(sfactor, dfactor glbase.Enum) {
	C.gl3_2core_glBlendFunc(gl.funcs, C.GLenum(sfactor), C.GLenum(dfactor))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFlush.xml
func (gl *GL) Flush() {
	C.gl3_2core_glFlush(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFinish.xml
func (gl *GL) Finish() {
	C.gl3_2core_glFinish(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml
func (gl *GL) Enable(cap glbase.Enum) {
	C.gl3_2core_glEnable(gl.funcs, C.GLenum(cap))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDisable.xml
func (gl *GL) Disable(cap glbase.Enum) {
	C.gl3_2core_glDisable(gl.funcs, C.GLenum(cap))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDepthMask.xml
func (gl *GL) DepthMask(flag bool) {
	C.gl3_2core_glDepthMask(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&flag)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glColorMask.xml
func (gl *GL) ColorMask(red, green, blue, alpha bool) {
	C.gl3_2core_glColorMask(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&red)), *(*C.GLboolean)(unsafe.Pointer(&green)), *(*C.GLboolean)(unsafe.Pointer(&blue)), *(*C.GLboolean)(unsafe.Pointer(&alpha)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glStencilMask.xml
func (gl *GL) StencilMask(mask uint32) {
	C.gl3_2core_glStencilMask(gl.funcs, C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearDepth.xml
func (gl *GL) ClearDepth(depth float64) {
	C.gl3_2core_glClearDepth(gl.funcs, C.GLdouble(depth))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearStencil.xml
func (gl *GL) ClearStencil(s int32) {
	C.gl3_2core_glClearStencil(gl.funcs, C.GLint(s))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearColor.xml
func (gl *GL) ClearColor(red, green, blue, alpha float32) {
	C.gl3_2core_glClearColor(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue), C.GLfloat(alpha))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClear.xml
func (gl *GL) Clear(mask glbase.Bitfield) {
	C.gl3_2core_glClear(gl.funcs, C.GLbitfield(mask))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawBuffer.xml
func (gl *GL) DrawBuffer(mode glbase.Enum) {
	C.gl3_2core_glDrawBuffer(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexImage2D.xml
func (gl *GL) TexImage2D(target glbase.Enum, level int, internalFormat int32, width, height, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexImage1D.xml
func (gl *GL) TexImage1D(target glbase.Enum, level int, internalFormat int32, width, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glTexImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexParameteriv.xml
func (gl *GL) TexParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glTexParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexParameteri.xml
func (gl *GL) TexParameteri(target, pname glbase.Enum, param int32) {
	C.gl3_2core_glTexParameteri(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexParameterfv.xml
func (gl *GL) TexParameterfv(target, pname glbase.Enum, params []float32) {
	C.gl3_2core_glTexParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexParameterf.xml
func (gl *GL) TexParameterf(target, pname glbase.Enum, param float32) {
	C.gl3_2core_glTexParameterf(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glScissor.xml
func (gl *GL) Scissor(x, y, width, height int) {
	C.gl3_2core_glScissor(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPolygonMode.xml
func (gl *GL) PolygonMode(face, mode glbase.Enum) {
	C.gl3_2core_glPolygonMode(gl.funcs, C.GLenum(face), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPointSize.xml
func (gl *GL) PointSize(size float32) {
	C.gl3_2core_glPointSize(gl.funcs, C.GLfloat(size))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glLineWidth.xml
func (gl *GL) LineWidth(width float32) {
	C.gl3_2core_glLineWidth(gl.funcs, C.GLfloat(width))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glHint.xml
func (gl *GL) Hint(target, mode glbase.Enum) {
	C.gl3_2core_glHint(gl.funcs, C.GLenum(target), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFrontFace.xml
func (gl *GL) FrontFace(mode glbase.Enum) {
	C.gl3_2core_glFrontFace(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCullFace.xml
func (gl *GL) CullFace(mode glbase.Enum) {
	C.gl3_2core_glCullFace(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIndexubv.xml
func (gl *GL) Indexubv(c []uint8) {
	C.gl3_2core_glIndexubv(gl.funcs, (*C.GLubyte)(unsafe.Pointer(&c[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIndexub.xml
func (gl *GL) Indexub(c uint8) {
	C.gl3_2core_glIndexub(gl.funcs, C.GLubyte(c))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsTexture.xml
func (gl *GL) IsTexture(texture glbase.Texture) bool {
	glresult := C.gl3_2core_glIsTexture(gl.funcs, C.GLuint(texture))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// GenTextures returns n texture names in textures. There is no guarantee
// that the names form a contiguous set of integers; however, it is
// guaranteed that none of the returned names was in use immediately before
// the call to GenTextures.
//
// The generated textures have no dimensionality; they assume the
// dimensionality of the texture target to which they are first bound (see
// BindTexture).
//
// Texture names returned by a call to GenTextures are not returned by
// subsequent calls, unless they are first deleted with DeleteTextures.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// GenTextures is available in GL version 2.0 or greater.
func (gl *GL) GenTextures(n int) []glbase.Texture {
	if n == 0 {
		return nil
	}
	textures := make([]glbase.Texture, n)
	C.gl3_2core_glGenTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])))
	return textures
}

// DeleteTextures deletes the textures objects whose names are stored
// in the textures slice. After a texture is deleted, it has no contents or
// dimensionality, and its name is free for reuse (for example by
// GenTextures). If a texture that is currently bound is deleted, the binding
// reverts to 0 (the default texture).
//
// DeleteTextures silently ignores 0's and names that do not correspond to
// existing textures.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteTextures is available in GL version 2.0 or greater.
func (gl *GL) DeleteTextures(textures []glbase.Texture) {
	n := len(textures)
	if n == 0 {
		return
	}
	C.gl3_2core_glDeleteTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindTexture.xml
func (gl *GL) BindTexture(target glbase.Enum, texture glbase.Texture) {
	C.gl3_2core_glBindTexture(gl.funcs, C.GLenum(target), C.GLuint(texture))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexSubImage2D.xml
func (gl *GL) TexSubImage2D(target glbase.Enum, level, xoffset, yoffset, width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexSubImage1D.xml
func (gl *GL) TexSubImage1D(target glbase.Enum, level, xoffset, width int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glTexSubImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLsizei(width), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage2D.xml
func (gl *GL) CopyTexSubImage2D(target glbase.Enum, level, xoffset, yoffset, x, y, width, height int) {
	C.gl3_2core_glCopyTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage1D.xml
func (gl *GL) CopyTexSubImage1D(target glbase.Enum, level, xoffset, x, y, width int) {
	C.gl3_2core_glCopyTexSubImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(x), C.GLint(y), C.GLsizei(width))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexImage2D.xml
func (gl *GL) CopyTexImage2D(target glbase.Enum, level int, internalFormat glbase.Enum, x, y, width, height, border int) {
	C.gl3_2core_glCopyTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLint(border))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexImage1D.xml
func (gl *GL) CopyTexImage1D(target glbase.Enum, level int, internalFormat glbase.Enum, x, y, width, border int) {
	C.gl3_2core_glCopyTexImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLint(border))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPolygonOffset.xml
func (gl *GL) PolygonOffset(factor, units float32) {
	C.gl3_2core_glPolygonOffset(gl.funcs, C.GLfloat(factor), C.GLfloat(units))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElements.xml
func (gl *GL) DrawElements(mode glbase.Enum, count int, gltype glbase.Enum, indices interface{}) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glDrawElements(gl.funcs, C.GLenum(mode), C.GLsizei(count), C.GLenum(gltype), indices_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawArrays.xml
func (gl *GL) DrawArrays(mode glbase.Enum, first, count int) {
	C.gl3_2core_glDrawArrays(gl.funcs, C.GLenum(mode), C.GLint(first), C.GLsizei(count))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage3D.xml
func (gl *GL) CopyTexSubImage3D(target glbase.Enum, level, xoffset, yoffset int, zoffset int32, x, y, width, height int) {
	C.gl3_2core_glCopyTexSubImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(zoffset), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexSubImage3D.xml
func (gl *GL) TexSubImage3D(target glbase.Enum, level, xoffset, yoffset int, zoffset int32, width, height int, depth int32, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glTexSubImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(zoffset), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexImage3D.xml
func (gl *GL) TexImage3D(target glbase.Enum, level int, internalFormat int32, width, height int, depth int32, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glTexImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawRangeElements.xml
func (gl *GL) DrawRangeElements(mode glbase.Enum, start, end uint32, count int, gltype glbase.Enum, indices interface{}) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glDrawRangeElements(gl.funcs, C.GLenum(mode), C.GLuint(start), C.GLuint(end), C.GLsizei(count), C.GLenum(gltype), indices_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBlendEquation.xml
func (gl *GL) BlendEquation(mode glbase.Enum) {
	C.gl3_2core_glBlendEquation(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBlendColor.xml
func (gl *GL) BlendColor(red, green, blue, alpha float32) {
	C.gl3_2core_glBlendColor(gl.funcs, C.GLfloat(red), C.GLfloat(green), C.GLfloat(blue), C.GLfloat(alpha))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetCompressedTexImage.xml
func (gl *GL) GetCompressedTexImage(target glbase.Enum, level int, img interface{}) {
	var img_ptr unsafe.Pointer
	var img_v = reflect.ValueOf(img)
	if img != nil && img_v.Kind() != reflect.Slice {
		panic("parameter img must be a slice")
	}
	if img != nil {
		img_ptr = unsafe.Pointer(img_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glGetCompressedTexImage(gl.funcs, C.GLenum(target), C.GLint(level), img_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage1D.xml
func (gl *GL) CompressedTexSubImage1D(target glbase.Enum, level, xoffset, width int, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glCompressedTexSubImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLsizei(width), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage2D.xml
func (gl *GL) CompressedTexSubImage2D(target glbase.Enum, level, xoffset, yoffset, width, height int, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glCompressedTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage3D.xml
func (gl *GL) CompressedTexSubImage3D(target glbase.Enum, level, xoffset, yoffset int, zoffset int32, width, height int, depth int32, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glCompressedTexSubImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(zoffset), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage1D.xml
func (gl *GL) CompressedTexImage1D(target glbase.Enum, level int, internalFormat glbase.Enum, width, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glCompressedTexImage1D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage2D.xml
func (gl *GL) CompressedTexImage2D(target glbase.Enum, level int, internalFormat glbase.Enum, width, height, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glCompressedTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage3D.xml
func (gl *GL) CompressedTexImage3D(target glbase.Enum, level int, internalFormat glbase.Enum, width, height int, depth int32, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glCompressedTexImage3D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glSampleCoverage.xml
func (gl *GL) SampleCoverage(value float32, invert bool) {
	C.gl3_2core_glSampleCoverage(gl.funcs, C.GLfloat(value), *(*C.GLboolean)(unsafe.Pointer(&invert)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glActiveTexture.xml
func (gl *GL) ActiveTexture(texture glbase.Enum) {
	C.gl3_2core_glActiveTexture(gl.funcs, C.GLenum(texture))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPointParameteriv.xml
func (gl *GL) PointParameteriv(pname glbase.Enum, params []int32) {
	C.gl3_2core_glPointParameteriv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPointParameteri.xml
func (gl *GL) PointParameteri(pname glbase.Enum, param int32) {
	C.gl3_2core_glPointParameteri(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPointParameterfv.xml
func (gl *GL) PointParameterfv(pname glbase.Enum, params []float32) {
	C.gl3_2core_glPointParameterfv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPointParameterf.xml
func (gl *GL) PointParameterf(pname glbase.Enum, param float32) {
	C.gl3_2core_glPointParameterf(gl.funcs, C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glMultiDrawArrays.xml
func (gl *GL) MultiDrawArrays(mode glbase.Enum, first, count []int, drawcount int32) {
	C.gl3_2core_glMultiDrawArrays(gl.funcs, C.GLenum(mode), (*C.GLint)(unsafe.Pointer(&first[0])), (*C.GLsizei)(unsafe.Pointer(&count[0])), C.GLsizei(drawcount))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBlendFuncSeparate.xml
func (gl *GL) BlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha glbase.Enum) {
	C.gl3_2core_glBlendFuncSeparate(gl.funcs, C.GLenum(sfactorRGB), C.GLenum(dfactorRGB), C.GLenum(sfactorAlpha), C.GLenum(dfactorAlpha))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferParameteriv.xml
func (gl *GL) GetBufferParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetBufferParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glUnmapBuffer.xml
func (gl *GL) UnmapBuffer(target glbase.Enum) bool {
	glresult := C.gl3_2core_glUnmapBuffer(gl.funcs, C.GLenum(target))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferSubData.xml
func (gl *GL) GetBufferSubData(target glbase.Enum, offset, size int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glGetBufferSubData(gl.funcs, C.GLenum(target), C.GLintptr(offset), C.GLsizeiptr(size), data_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBufferSubData.xml
func (gl *GL) BufferSubData(target glbase.Enum, offset, size int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glBufferSubData(gl.funcs, C.GLenum(target), C.GLintptr(offset), C.GLsizeiptr(size), data_ptr)
}

// BufferData creates a new data store for the buffer object currently
// bound to target. Any pre-existing data store is deleted. The new data
// store is created with the specified size in bytes and usage. If data is
// not nil, it must be a slice that is used to initialize the data store.
// In that case the size parameter is ignored and the store size will match
// the slice data size.
//
// In its initial state, the new data store is not mapped, it has a NULL
// mapped pointer, and its mapped access is GL.READ_WRITE.
//
// The target constant must be one of GL.ARRAY_BUFFER, GL.COPY_READ_BUFFER,
// GL.COPY_WRITE_BUFFER, GL.ELEMENT_ARRAY_BUFFER, GL.PIXEL_PACK_BUFFER,
// GL.PIXEL_UNPACK_BUFFER, GL.TEXTURE_BUFFER, GL.TRANSFORM_FEEDBACK_BUFFER,
// or GL.UNIFORM_BUFFER.
//
// The usage parameter is a hint to the GL implementation as to how a buffer
// object's data store will be accessed. This enables the GL implementation
// to make more intelligent decisions that may significantly impact buffer
// object performance. It does not, however, constrain the actual usage of
// the data store. usage can be broken down into two parts: first, the
// frequency of access (modification and usage), and second, the nature of
// that access.
//
// A usage frequency of STREAM and nature of DRAW is specified via the
// constant GL.STREAM_DRAW, for example.
//
// The usage frequency of access may be one of:
//
//   STREAM
//       The data store contents will be modified once and used at most a few times.
//
//   STATIC
//       The data store contents will be modified once and used many times.
//
//   DYNAMIC
//       The data store contents will be modified repeatedly and used many times.
//
// The usage nature of access may be one of:
//
//   DRAW
//       The data store contents are modified by the application, and used as
//       the source for GL drawing and image specification commands.
//
//   READ
//       The data store contents are modified by reading data from the GL,
//       and used to return that data when queried by the application.
//
//   COPY
//       The data store contents are modified by reading data from the GL,
//       and used as the source for GL drawing and image specification
//       commands.
//
// Clients must align data elements consistent with the requirements of the
// client platform, with an additional base-level requirement that an offset
// within a buffer to a datum comprising N bytes be a multiple of N.
//
// Error GL.INVALID_ENUM is generated if target is not one of the accepted
// buffer targets.  GL.INVALID_ENUM is generated if usage is not
// GL.STREAM_DRAW, GL.STREAM_READ, GL.STREAM_COPY, GL.STATIC_DRAW,
// GL.STATIC_READ, GL.STATIC_COPY, GL.DYNAMIC_DRAW, GL.DYNAMIC_READ, or
// GL.DYNAMIC_COPY.  GL.INVALID_VALUE is generated if size is negative.
// GL.INVALID_OPERATION is generated if the reserved buffer object name 0 is
// bound to target.  GL.OUT_OF_MEMORY is generated if the GL is unable to
// create a data store with the specified size.
func (gl *GL) BufferData(target glbase.Enum, size int, data interface{}, usage glbase.Enum) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	if data != nil {
		size = int(data_v.Type().Size()) * data_v.Len()
	}
	C.gl3_2core_glBufferData(gl.funcs, C.GLenum(target), C.GLsizeiptr(size), data_ptr, C.GLenum(usage))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsBuffer.xml
func (gl *GL) IsBuffer(buffer glbase.Buffer) bool {
	glresult := C.gl3_2core_glIsBuffer(gl.funcs, C.GLuint(buffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// GenBuffers returns n buffer object names. There is no guarantee that
// the names form a contiguous set of integers; however, it is guaranteed
// that none of the returned names was in use immediately before the call to
// GenBuffers.
//
// Buffer object names returned by a call to GenBuffers are not returned by
// subsequent calls, unless they are first deleted with DeleteBuffers.
//
// No buffer objects are associated with the returned buffer object names
// until they are first bound by calling BindBuffer.
//
// Error GL.INVALID_VALUE is generated if n is negative. GL.INVALID_OPERATION
// is generated if GenBuffers is executed between the execution of Begin
// and the corresponding execution of End.
//
// GenBuffers is available in GL version 1.5 or greater.
func (gl *GL) GenBuffers(n int) []glbase.Buffer {
	if n == 0 {
		return nil
	}
	buffers := make([]glbase.Buffer, n)
	C.gl3_2core_glGenBuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&buffers[0])))
	return buffers
}

// DeleteBuffers deletes the buffer objects whose names are stored in the
// buffers slice.
//
// After a buffer object is deleted, it has no contents, and its name is free
// for reuse (for example by GenBuffers). If a buffer object that is
// currently bound is deleted, the binding reverts to 0 (the absence of any
// buffer object, which reverts to client memory usage).
//
// DeleteBuffers silently ignores 0's and names that do not correspond to
// existing buffer objects.
//
// Error GL.INVALID_VALUE is generated if n is negative. GL.INVALID_OPERATION
// is generated if DeleteBuffers is executed between the execution of Begin
// and the corresponding execution of End.
//
// DeleteBuffers is available in GL version 1.5 or greater.
func (gl *GL) DeleteBuffers(buffers []glbase.Buffer) {
	n := len(buffers)
	if n == 0 {
		return
	}
	C.gl3_2core_glDeleteBuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&buffers[0])))
}

// BindBuffer creates or puts in use a named buffer object.
// Calling BindBuffer with target set to GL.ARRAY_BUFFER,
// GL.ELEMENT_ARRAY_BUFFER, GL.PIXEL_PACK_BUFFER or GL.PIXEL_UNPACK_BUFFER
// and buffer set to the name of the new buffer object binds the buffer
// object name to the target. When a buffer object is bound to a target, the
// previous binding for that target is automatically broken.
//
// Buffer object names are unsigned integers. The value zero is reserved, but
// there is no default buffer object for each buffer object target. Instead,
// buffer set to zero effectively unbinds any buffer object previously bound,
// and restores client memory usage for that buffer object target. Buffer
// object names and the corresponding buffer object contents are local to the
// shared display-list space (see XCreateContext) of the current GL rendering
// context; two rendering contexts share buffer object names only if they
// also share display lists.
//
// GenBuffers may be called to generate a set of new buffer object names.
//
// The state of a buffer object immediately after it is first bound is an
// unmapped zero-sized memory buffer with GL.READ_WRITE access and
// GL.STATIC_DRAW usage.
//
// While a non-zero buffer object name is bound, GL operations on the target
// to which it is bound affect the bound buffer object, and queries of the
// target to which it is bound return state from the bound buffer object.
// While buffer object name zero is bound, as in the initial state, attempts
// to modify or query state on the target to which it is bound generates an
// GL.INVALID_OPERATION error.
//
// When vertex array pointer state is changed, for example by a call to
// NormalPointer, the current buffer object binding (GL.ARRAY_BUFFER_BINDING)
// is copied into the corresponding client state for the vertex array type
// being changed, for example GL.NORMAL_ARRAY_BUFFER_BINDING. While a
// non-zero buffer object is bound to the GL.ARRAY_BUFFER target, the vertex
// array pointer parameter that is traditionally interpreted as a pointer to
// client-side memory is instead interpreted as an offset within the buffer
// object measured in basic machine units.
//
// While a non-zero buffer object is bound to the GL.ELEMENT_ARRAY_BUFFER
// target, the indices parameter of DrawElements, DrawRangeElements, or
// MultiDrawElements that is traditionally interpreted as a pointer to
// client-side memory is instead interpreted as an offset within the buffer
// object measured in basic machine units.
//
// While a non-zero buffer object is bound to the GL.PIXEL_PACK_BUFFER
// target, the following commands are affected: GetCompressedTexImage,
// GetConvolutionFilter, GetHistogram, GetMinmax, GetPixelMap,
// GetPolygonStipple, GetSeparableFilter, GetTexImage, and ReadPixels. The
// pointer parameter that is traditionally interpreted as a pointer to
// client-side memory where the pixels are to be packed is instead
// interpreted as an offset within the buffer object measured in basic
// machine units.
//
// While a non-zero buffer object is bound to the GL.PIXEL_UNPACK_BUFFER
// target, the following commands are affected: Bitmap, ColorSubTable,
// ColorTable, CompressedTexImage1D, CompressedTexImage2D,
// CompressedTexImage3D, CompressedTexSubImage1D, CompressedTexSubImage2D,
// CompressedTexSubImage3D, ConvolutionFilter1D, ConvolutionFilter2D,
// DrawPixels, PixelMap, PolygonStipple, SeparableFilter2D, TexImage1D,
// TexImage2D, TexImage3D, TexSubImage1D, TexSubImage2D, and TexSubImage3D.
// The pointer parameter that is traditionally interpreted as a pointer to
// client-side memory from which the pixels are to be unpacked is instead
// interpreted as an offset within the buffer object measured in basic
// machine units.
//
// A buffer object binding created with BindBuffer remains active until a
// different buffer object name is bound to the same target, or until the
// bound buffer object is deleted with DeleteBuffers.
//
// Once created, a named buffer object may be re-bound to any target as often
// as needed. However, the GL implementation may make choices about how to
// optimize the storage of a buffer object based on its initial binding
// target.
//
// Error GL.INVALID_ENUM is generated if target is not one of the allowable
// values.  GL.INVALID_OPERATION is generated if BindBuffer is executed
// between the execution of Begin and the corresponding execution of End.
//
// BindBuffer is available in GL version 1.5 or greater.
func (gl *GL) BindBuffer(target glbase.Enum, buffer glbase.Buffer) {
	C.gl3_2core_glBindBuffer(gl.funcs, C.GLenum(target), C.GLuint(buffer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObjectuiv.xml
func (gl *GL) GetQueryObjectuiv(id uint32, pname glbase.Enum, params []uint32) {
	C.gl3_2core_glGetQueryObjectuiv(gl.funcs, C.GLuint(id), C.GLenum(pname), (*C.GLuint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObjectiv.xml
func (gl *GL) GetQueryObjectiv(id uint32, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetQueryObjectiv(gl.funcs, C.GLuint(id), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryiv.xml
func (gl *GL) GetQueryiv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetQueryiv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glEndQuery.xml
func (gl *GL) EndQuery(target glbase.Enum) {
	C.gl3_2core_glEndQuery(gl.funcs, C.GLenum(target))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBeginQuery.xml
func (gl *GL) BeginQuery(target glbase.Enum, id uint32) {
	C.gl3_2core_glBeginQuery(gl.funcs, C.GLenum(target), C.GLuint(id))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsQuery.xml
func (gl *GL) IsQuery(id uint32) bool {
	glresult := C.gl3_2core_glIsQuery(gl.funcs, C.GLuint(id))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteQueries.xml
func (gl *GL) DeleteQueries(n int, ids []uint32) {
	C.gl3_2core_glDeleteQueries(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&ids[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGenQueries.xml
func (gl *GL) GenQueries(n int, ids []uint32) {
	C.gl3_2core_glGenQueries(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&ids[0])))
}

// VertexAttribPointer specifies the location and data format of the array
// of generic vertex attributes at index to use when rendering. size
// specifies the number of components per attribute and must be 1, 2, 3, or
// 4. type specifies the data type of each component, and stride specifies
// the byte stride from one attribute to the next, allowing vertices and
// attributes to be packed into a single array or stored in separate arrays.
// normalized indicates whether the values stored in an integer format are
// to be mapped to the range [-1,1] (for signed values) or [0,1]
// (for unsigned values) when they are accessed and converted to floating
// point; otherwise, values will be converted to floats directly without
// normalization. offset is a byte offset into the buffer object's data
// store, which must be bound to the GL.ARRAY_BUFFER target with BindBuffer.
//
// The buffer object binding (GL.ARRAY_BUFFER_BINDING) is saved as
// generic vertex attribute array client-side state
// (GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING) for the provided index.
//
// To enable and disable a generic vertex attribute array, call
// EnableVertexAttribArray and DisableVertexAttribArray with index. If
// enabled, the generic vertex attribute array is used when DrawArrays or
// DrawElements is called. Each generic vertex attribute array is initially
// disabled.
//
// VertexAttribPointer is typically implemented on the client side.
//
// Error GL.INVALID_ENUM is generated if type is not an accepted value.
// GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_VALUE is generated if size is not 1, 2,
// 3, or 4. GL.INVALID_VALUE is generated if stride is negative.
func (gl *GL) VertexAttribPointer(index glbase.Attrib, size int, gltype glbase.Enum, normalized bool, stride int, offset uintptr) {
	offset_ptr := unsafe.Pointer(offset)
	C.gl3_2core_glVertexAttribPointer(gl.funcs, C.GLuint(index), C.GLint(size), C.GLenum(gltype), *(*C.GLboolean)(unsafe.Pointer(&normalized)), C.GLsizei(stride), offset_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glValidateProgram.xml
func (gl *GL) ValidateProgram(program glbase.Program) {
	C.gl3_2core_glValidateProgram(gl.funcs, C.GLuint(program))
}

// UniformMatrix4fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix4fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix4fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(4*4) != 0 {
		panic("invalid value length for UniformMatrix4fv")
	}
	count := len(value) / (4 * 4)
	C.gl3_2core_glUniformMatrix4fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix3fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix3fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix3fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(3*3) != 0 {
		panic("invalid value length for UniformMatrix3fv")
	}
	count := len(value) / (3 * 3)
	C.gl3_2core_glUniformMatrix3fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix2fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix2fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix2fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(2*2) != 0 {
		panic("invalid value length for UniformMatrix2fv")
	}
	count := len(value) / (2 * 2)
	C.gl3_2core_glUniformMatrix2fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform4iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform4iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	if len(value)%4 != 0 {
		panic("invalid value length for Uniform4iv")
	}
	count := len(value) / 4
	C.gl3_2core_glUniform4iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform3iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform3iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	if len(value)%3 != 0 {
		panic("invalid value length for Uniform3iv")
	}
	count := len(value) / 3
	C.gl3_2core_glUniform3iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform2iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform2iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	if len(value)%2 != 0 {
		panic("invalid value length for Uniform2iv")
	}
	count := len(value) / 2
	C.gl3_2core_glUniform2iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform1iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform1iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	count := len(value)
	C.gl3_2core_glUniform1iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform4fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform4fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%4 != 0 {
		panic("invalid value length for Uniform4fv")
	}
	count := len(value) / 4
	C.gl3_2core_glUniform4fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform3fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform3fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%3 != 0 {
		panic("invalid value length for Uniform3fv")
	}
	count := len(value) / 3
	C.gl3_2core_glUniform3fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform2fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform2fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%2 != 0 {
		panic("invalid value length for Uniform2fv")
	}
	count := len(value) / 2
	C.gl3_2core_glUniform2fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform1fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform1fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	count := len(value)
	C.gl3_2core_glUniform1fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform4i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform4i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4i(location glbase.Uniform, v0, v1, v2, v3 int32) {
	C.gl3_2core_glUniform4i(gl.funcs, C.GLint(location), C.GLint(v0), C.GLint(v1), C.GLint(v2), C.GLint(v3))
}

// Uniform3i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform3i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3i(location glbase.Uniform, v0, v1, v2 int32) {
	C.gl3_2core_glUniform3i(gl.funcs, C.GLint(location), C.GLint(v0), C.GLint(v1), C.GLint(v2))
}

// Uniform2i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform2i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2i(location glbase.Uniform, v0, v1 int32) {
	C.gl3_2core_glUniform2i(gl.funcs, C.GLint(location), C.GLint(v0), C.GLint(v1))
}

// Uniform1i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform1i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1i(location glbase.Uniform, v0 int32) {
	C.gl3_2core_glUniform1i(gl.funcs, C.GLint(location), C.GLint(v0))
}

// Uniform4f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform4f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4f(location glbase.Uniform, v0, v1, v2, v3 float32) {
	C.gl3_2core_glUniform4f(gl.funcs, C.GLint(location), C.GLfloat(v0), C.GLfloat(v1), C.GLfloat(v2), C.GLfloat(v3))
}

// Uniform3f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform3f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3f(location glbase.Uniform, v0, v1, v2 float32) {
	C.gl3_2core_glUniform3f(gl.funcs, C.GLint(location), C.GLfloat(v0), C.GLfloat(v1), C.GLfloat(v2))
}

// Uniform2f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform2f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2f(location glbase.Uniform, v0, v1 float32) {
	C.gl3_2core_glUniform2f(gl.funcs, C.GLint(location), C.GLfloat(v0), C.GLfloat(v1))
}

// Uniform1f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform1f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1f(location glbase.Uniform, v0 float32) {
	C.gl3_2core_glUniform1f(gl.funcs, C.GLint(location), C.GLfloat(v0))
}

// UseProgram installs the program object specified by program as part of
// current rendering state. One or more executables are created in a program
// object by successfully attaching shader objects to it with AttachShader,
// successfully compiling the shader objects with CompileShader, and
// successfully linking the program object with LinkProgram.
//
// A program object will contain an executable that will run on the vertex
// processor if it contains one or more shader objects of type
// GL.VERTEX_SHADER that have been successfully compiled and linked.
// Similarly, a program object will contain an executable that will run on
// the fragment processor if it contains one or more shader objects of type
// GL.FRAGMENT_SHADER that have been successfully compiled and linked.
//
// Successfully installing an executable on a programmable processor will
// cause the corresponding fixed functionality of OpenGL to be disabled.
// Specifically, if an executable is installed on the vertex processor, the
// OpenGL fixed functionality will be disabled as follows.
//
//   - The modelview matrix is not applied to vertex coordinates.
//
//   - The projection matrix is not applied to vertex coordinates.
//
//   - The texture matrices are not applied to texture coordinates.
//
//   - Normals are not transformed to eye coordinates.
//
//   - Normals are not rescaled or normalized.
//
//   - Normalization of GL.AUTO_NORMAL evaluated normals is not performed.
//
//   - Texture coordinates are not generated automatically.
//
//   - Per-vertex lighting is not performed.
//
//   - Color material computations are not performed.
//
//   - Color index lighting is not performed.
//
//   - This list also applies when setting the current raster position.
//
// The executable that is installed on the vertex processor is expected to
// implement any or all of the desired functionality from the preceding list.
// Similarly, if an executable is installed on the fragment processor, the
// OpenGL fixed functionality will be disabled as follows.
//
//   - Texture environment and texture functions are not applied.
//
//   - Texture application is not applied.
//
//   - Color sum is not applied.
//
//   - Fog is not applied.
//
// Again, the fragment shader that is installed is expected to implement any
// or all of the desired functionality from the preceding list.
//
// While a program object is in use, applications are free to modify attached
// shader objects, compile attached shader objects, attach additional shader
// objects, and detach or delete shader objects. None of these operations
// will affect the executables that are part of the current state. However,
// relinking the program object that is currently in use will install the
// program object as part of the current rendering state if the link
// operation was successful (see LinkProgram). If the program object
// currently in use is relinked unsuccessfully, its link status will be set
// to GL.FALSE, but the executables and associated state will remain part of
// the current state until a subsequent call to UseProgram removes it from
// use. After it is removed from use, it cannot be made part of current state
// until it has been successfully relinked.
//
// If program contains shader objects of type GL.VERTEX_SHADER but it does
// not contain shader objects of type GL.FRAGMENT_SHADER, an executable will
// be installed on the vertex processor, but fixed functionality will be used
// for fragment processing. Similarly, if program contains shader objects of
// type GL.FRAGMENT_SHADER but it does not contain shader objects of type
// GL.VERTEX_SHADER, an executable will be installed on the fragment
// processor, but fixed functionality will be used for vertex processing. If
// program is 0, the programmable processors will be disabled, and fixed
// functionality will be used for both vertex and fragment processing.
//
// While a program object is in use, the state that controls the disabled
// fixed functionality may also be updated using the normal OpenGL calls.
//
// Like display lists and texture objects, the name space for program objects
// may be shared across a set of contexts, as long as the server sides of the
// contexts share the same address space. If the name space is shared across
// contexts, any attached objects and the data associated with those attached
// objects are shared as well.
//
// Applications are responsible for providing the synchronization across API
// calls when objects are accessed from different execution threads.
//
// Error GL.INVALID_VALUE is generated if program is neither 0 nor a value
// generated by OpenGL.  GL.INVALID_OPERATION is generated if program is not
// a program object.  GL.INVALID_OPERATION is generated if program could not
// be made part of current state.  GL.INVALID_OPERATION is generated if
// UseProgram is executed between the execution of Begin and the
// corresponding execution of End.
//
// UseProgram is available in GL version 2.0 or greater.
func (gl *GL) UseProgram(program glbase.Program) {
	C.gl3_2core_glUseProgram(gl.funcs, C.GLuint(program))
}

// ShaderSource sets the source code in shader to the provided source code. Any source
// code previously stored in the shader object is completely replaced.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if shader is not a shader
// object. GL.INVALID_VALUE is generated if count is less than 0.
// GL.INVALID_OPERATION is generated if ShaderSource is executed between the
// execution of Begin and the corresponding execution of End.
//
// ShaderSource is available in GL version 2.0 or greater.
func (gl *GL) ShaderSource(shader glbase.Shader, source ...string) {
	count := len(source)
	length := make([]int32, count)
	source_c := make([]unsafe.Pointer, count)
	for i, src := range source {
		length[i] = int32(len(src))
		if len(src) > 0 {
			source_c[i] = *(*unsafe.Pointer)(unsafe.Pointer(&src))
		} else {
			source_c[i] = unsafe.Pointer(uintptr(0))
		}
	}
	C.gl3_2core_glShaderSource(gl.funcs, C.GLuint(shader), C.GLsizei(count), (**C.GLchar)(unsafe.Pointer(&source_c[0])), (*C.GLint)(unsafe.Pointer(&length[0])))
}

// LinkProgram links the program object specified by program. If any shader
// objects of type GL.VERTEX_SHADER are attached to program, they will be
// used to create an executable that will run on the programmable vertex
// processor. If any shader objects of type GL.FRAGMENT_SHADER are attached
// to program, they will be used to create an executable that will run on the
// programmable fragment processor.
//
// The status of the link operation will be stored as part of the program
// object's state. This value will be set to GL.TRUE if the program object
// was linked without errors and is ready for use, and GL.FALSE otherwise. It
// can be queried by calling GetProgramiv with arguments program and
// GL.LINK_STATUS.
//
// As a result of a successful link operation, all active user-defined
// uniform variables belonging to program will be initialized to 0, and each
// of the program object's active uniform variables will be assigned a
// location that can be queried by calling GetUniformLocation. Also, any
// active user-defined attribute variables that have not been bound to a
// generic vertex attribute index will be bound to one at this time.
//
// Linking of a program object can fail for a number of reasons as specified
// in the OpenGL Shading Language Specification. The following lists some of
// the conditions that will cause a link error.
//
//   - The number of active attribute variables supported by the
//     implementation has been exceeded.
//
//   - The storage limit for uniform variables has been exceeded.
//
//   - The number of active uniform variables supported by the implementation
//     has been exceeded.
//
//   - The main function is missing for the vertex shader or the fragment
//     shader.
//
//   - A varying variable actually used in the fragment shader is not
//     declared in the same way (or is not declared at all) in the vertex
//     shader.
//
//   - A reference to a function or variable name is unresolved.
//
//   - A shared global is declared with two different types or two different
//     initial values.
//
//   - One or more of the attached shader objects has not been successfully
//     compiled.
//
//   - Binding a generic attribute matrix caused some rows of the matrix to
//     fall outside the allowed maximum of GL.MAX_VERTEX_ATTRIBS.
//
//   - Not enough contiguous vertex attribute slots could be found to bind
//     attribute matrices.
//
// When a program object has been successfully linked, the program object can
// be made part of current state by calling UseProgram. Whether or not the
// link operation was successful, the program object's information log will
// be overwritten. The information log can be retrieved by calling
// GetProgramInfoLog.
//
// LinkProgram will also install the generated executables as part of the
// current rendering state if the link operation was successful and the
// specified program object is already currently in use as a result of a
// previous call to UseProgram. If the program object currently in use is
// relinked unsuccessfully, its link status will be set to GL.FALSE , but the
// executables and associated state will remain part of the current state
// until a subsequent call to UseProgram removes it from use. After it is
// removed from use, it cannot be made part of current state until it has
// been successfully relinked.
//
// If program contains shader objects of type GL.VERTEX_SHADER but does not
// contain shader objects of type GL.FRAGMENT_SHADER, the vertex shader will
// be linked against the implicit interface for fixed functionality fragment
// processing. Similarly, if program contains shader objects of type
// GL.FRAGMENT_SHADER but it does not contain shader objects of type
// GL.VERTEX_SHADER, the fragment shader will be linked against the implicit
// interface for fixed functionality vertex processing.
//
// The program object's information log is updated and the program is
// generated at the time of the link operation. After the link operation,
// applications are free to modify attached shader objects, compile attached
// shader objects, detach shader objects, delete shader objects, and attach
// additional shader objects. None of these operations affects the
// information log or the program that is part of the program object.
//
// If the link operation is unsuccessful, any information about a previous
// link operation on program is lost (a failed link does not restore the
// old state of program). Certain information can still be retrieved
// from program even after an unsuccessful link operation. See for instance
// GetActiveAttrib and GetActiveUniform.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program
// object. GL.INVALID_OPERATION is generated if LinkProgram is executed
// between the execution of Begin and the corresponding execution of End.
//
// LinkProgram is available in GL version 2.0 or greater.
func (gl *GL) LinkProgram(program glbase.Program) {
	C.gl3_2core_glLinkProgram(gl.funcs, C.GLuint(program))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsShader.xml
func (gl *GL) IsShader(shader glbase.Shader) bool {
	glresult := C.gl3_2core_glIsShader(gl.funcs, C.GLuint(shader))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsProgram.xml
func (gl *GL) IsProgram(program glbase.Program) bool {
	glresult := C.gl3_2core_glIsProgram(gl.funcs, C.GLuint(program))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// GetVertexAttribiv returns in params the value of a generic vertex attribute
// parameter. The generic vertex attribute to be queried is specified by
// index, and the parameter to be queried is specified by pname.
//
// The accepted parameter names are as follows:
//
//   GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
//       params returns a single value, the name of the buffer object
//       currently bound to the binding point corresponding to generic vertex
//       attribute array index. If no buffer object is bound, 0 is returned.
//       The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_ENABLED
//       params returns a single value that is non-zero (true) if the vertex
//       attribute array for index is enabled and 0 (false) if it is
//       disabled. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_SIZE
//       params returns a single value, the size of the vertex attribute
//       array for index. The size is the number of values for each element
//       of the vertex attribute array, and it will be 1, 2, 3, or 4. The
//       initial value is 4.
//
//   GL.VERTEX_ATTRIB_ARRAY_STRIDE
//       params returns a single value, the array stride for (number of bytes
//       between successive elements in) the vertex attribute array for
//       index. A value of 0 indicates that the array elements are stored
//       sequentially in memory. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_TYPE
//       params returns a single value, a symbolic constant indicating the
//       array type for the vertex attribute array for index. Possible values
//       are GL.BYTE, GL.UNSIGNED_BYTE, GL.SHORT, GL.UNSIGNED_SHORT, GL.INT,
//       GL.UNSIGNED_INT, GL.FLOAT, and GL.DOUBLE. The initial value is
//       GL.FLOAT.
//
//   GL.VERTEX_ATTRIB_ARRAY_NORMALIZED
//       params returns a single value that is non-zero (true) if fixed-point
//       data types for the vertex attribute array indicated by index are
//       normalized when they are converted to floating point, and 0 (false)
//       otherwise. The initial value is 0.
//
//   GL.CURRENT_VERTEX_ATTRIB
//       params returns four values that represent the current value for the
//       generic vertex attribute specified by index. Generic vertex
//       attribute 0 is unique in that it has no current state, so an error
//       will be generated if index is 0. The initial value for all other
//       generic vertex attributes is (0,0,0,1).
//
// All of the parameters except GL.CURRENT_VERTEX_ATTRIB represent
// client-side state.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_ENUM is generated if pname is not an
// accepted value.  GL.INVALID_OPERATION is generated if index is 0 and pname
// is GL.CURRENT_VERTEX_ATTRIB.
//
// GetVertexAttribiv is available in GL version 2.0 or greater.
func (gl *GL) GetVertexAttribiv(index glbase.Attrib, pname glbase.Enum, params []int32) {
	var params_c [4]int32
	C.gl3_2core_glGetVertexAttribiv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetVertexAttribfv returns in params the value of a generic vertex attribute
// parameter. The generic vertex attribute to be queried is specified by
// index, and the parameter to be queried is specified by pname.
//
// The accepted parameter names are as follows:
//
//   GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
//       params returns a single value, the name of the buffer object
//       currently bound to the binding point corresponding to generic vertex
//       attribute array index. If no buffer object is bound, 0 is returned.
//       The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_ENABLED
//       params returns a single value that is non-zero (true) if the vertex
//       attribute array for index is enabled and 0 (false) if it is
//       disabled. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_SIZE
//       params returns a single value, the size of the vertex attribute
//       array for index. The size is the number of values for each element
//       of the vertex attribute array, and it will be 1, 2, 3, or 4. The
//       initial value is 4.
//
//   GL.VERTEX_ATTRIB_ARRAY_STRIDE
//       params returns a single value, the array stride for (number of bytes
//       between successive elements in) the vertex attribute array for
//       index. A value of 0 indicates that the array elements are stored
//       sequentially in memory. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_TYPE
//       params returns a single value, a symbolic constant indicating the
//       array type for the vertex attribute array for index. Possible values
//       are GL.BYTE, GL.UNSIGNED_BYTE, GL.SHORT, GL.UNSIGNED_SHORT, GL.INT,
//       GL.UNSIGNED_INT, GL.FLOAT, and GL.DOUBLE. The initial value is
//       GL.FLOAT.
//
//   GL.VERTEX_ATTRIB_ARRAY_NORMALIZED
//       params returns a single value that is non-zero (true) if fixed-point
//       data types for the vertex attribute array indicated by index are
//       normalized when they are converted to floating point, and 0 (false)
//       otherwise. The initial value is 0.
//
//   GL.CURRENT_VERTEX_ATTRIB
//       params returns four values that represent the current value for the
//       generic vertex attribute specified by index. Generic vertex
//       attribute 0 is unique in that it has no current state, so an error
//       will be generated if index is 0. The initial value for all other
//       generic vertex attributes is (0,0,0,1).
//
// All of the parameters except GL.CURRENT_VERTEX_ATTRIB represent
// client-side state.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_ENUM is generated if pname is not an
// accepted value.  GL.INVALID_OPERATION is generated if index is 0 and pname
// is GL.CURRENT_VERTEX_ATTRIB.
//
// GetVertexAttribfv is available in GL version 2.0 or greater.
func (gl *GL) GetVertexAttribfv(index glbase.Attrib, pname glbase.Enum, params []float32) {
	var params_c [4]float32
	C.gl3_2core_glGetVertexAttribfv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetVertexAttribdv returns in params the value of a generic vertex attribute
// parameter. The generic vertex attribute to be queried is specified by
// index, and the parameter to be queried is specified by pname.
//
// The accepted parameter names are as follows:
//
//   GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
//       params returns a single value, the name of the buffer object
//       currently bound to the binding point corresponding to generic vertex
//       attribute array index. If no buffer object is bound, 0 is returned.
//       The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_ENABLED
//       params returns a single value that is non-zero (true) if the vertex
//       attribute array for index is enabled and 0 (false) if it is
//       disabled. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_SIZE
//       params returns a single value, the size of the vertex attribute
//       array for index. The size is the number of values for each element
//       of the vertex attribute array, and it will be 1, 2, 3, or 4. The
//       initial value is 4.
//
//   GL.VERTEX_ATTRIB_ARRAY_STRIDE
//       params returns a single value, the array stride for (number of bytes
//       between successive elements in) the vertex attribute array for
//       index. A value of 0 indicates that the array elements are stored
//       sequentially in memory. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_TYPE
//       params returns a single value, a symbolic constant indicating the
//       array type for the vertex attribute array for index. Possible values
//       are GL.BYTE, GL.UNSIGNED_BYTE, GL.SHORT, GL.UNSIGNED_SHORT, GL.INT,
//       GL.UNSIGNED_INT, GL.FLOAT, and GL.DOUBLE. The initial value is
//       GL.FLOAT.
//
//   GL.VERTEX_ATTRIB_ARRAY_NORMALIZED
//       params returns a single value that is non-zero (true) if fixed-point
//       data types for the vertex attribute array indicated by index are
//       normalized when they are converted to floating point, and 0 (false)
//       otherwise. The initial value is 0.
//
//   GL.CURRENT_VERTEX_ATTRIB
//       params returns four values that represent the current value for the
//       generic vertex attribute specified by index. Generic vertex
//       attribute 0 is unique in that it has no current state, so an error
//       will be generated if index is 0. The initial value for all other
//       generic vertex attributes is (0,0,0,1).
//
// All of the parameters except GL.CURRENT_VERTEX_ATTRIB represent
// client-side state.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_ENUM is generated if pname is not an
// accepted value.  GL.INVALID_OPERATION is generated if index is 0 and pname
// is GL.CURRENT_VERTEX_ATTRIB.
//
// GetVertexAttribdv is available in GL version 2.0 or greater.
func (gl *GL) GetVertexAttribdv(index glbase.Attrib, pname glbase.Enum, params []float64) {
	var params_c [4]float64
	C.gl3_2core_glGetVertexAttribdv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLdouble)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetUniformiv returns in params the value of the specified uniform
// variable. The type of the uniform variable specified by location
// determines the number of values returned. If the uniform variable is
// defined in the shader as a boolean, int, or float, a single value will be
// returned. If it is defined as a vec2, ivec2, or bvec2, two values will be
// returned. If it is defined as a vec3, ivec3, or bvec3, three values will
// be returned, and so on. To query values stored in uniform variables
// declared as arrays, call GetUniformiv for each element of the array. To
// query values stored in uniform variables declared as structures, call
// GetUniformiv for each field in the structure. The values for uniform
// variables declared as a matrix will be returned in column major order.
//
// The locations assigned to uniform variables are not known until the
// program object is linked. After linking has occurred, the command
// GetUniformLocation can be used to obtain the location of a uniform
// variable. This location value can then be passed to GetUniformiv in order
// to query the current value of the uniform variable. After a program object
// has been linked successfully, the index values for uniform variables
// remain fixed until the next link command occurs. The uniform variable
// values can only be queried after a link if the link was successful.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program
// object. GL.INVALID_OPERATION is generated if program has not been
// successfully linked. GL.INVALID_OPERATION is generated if location does
// not correspond to a valid uniform variable location for the specified
// program object. GL.INVALID_OPERATION is generated if GetUniformiv is
// executed between the execution of Begin and the corresponding execution of
// End.
//
// GetUniformiv is available in GL version 2.0 or greater.
func (gl *GL) GetUniformiv(program glbase.Program, location glbase.Uniform, params []int32) {
	var params_c [4]int32
	C.gl3_2core_glGetUniformiv(gl.funcs, C.GLuint(program), C.GLint(location), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetUniformfv returns in params the value of the specified uniform
// variable. The type of the uniform variable specified by location
// determines the number of values returned. If the uniform variable is
// defined in the shader as a boolean, int, or float, a single value will be
// returned. If it is defined as a vec2, ivec2, or bvec2, two values will be
// returned. If it is defined as a vec3, ivec3, or bvec3, three values will
// be returned, and so on. To query values stored in uniform variables
// declared as arrays, call GetUniformfv for each element of the array. To
// query values stored in uniform variables declared as structures, call
// GetUniformfv for each field in the structure. The values for uniform
// variables declared as a matrix will be returned in column major order.
//
// The locations assigned to uniform variables are not known until the
// program object is linked. After linking has occurred, the command
// GetUniformLocation can be used to obtain the location of a uniform
// variable. This location value can then be passed to GetUniformfv in order
// to query the current value of the uniform variable. After a program object
// has been linked successfully, the index values for uniform variables
// remain fixed until the next link command occurs. The uniform variable
// values can only be queried after a link if the link was successful.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program
// object. GL.INVALID_OPERATION is generated if program has not been
// successfully linked. GL.INVALID_OPERATION is generated if location does
// not correspond to a valid uniform variable location for the specified
// program object. GL.INVALID_OPERATION is generated if GetUniformfv is
// executed between the execution of Begin and the corresponding execution of
// End.
//
// GetUniformfv is available in GL version 2.0 or greater.
func (gl *GL) GetUniformfv(program glbase.Program, location glbase.Uniform, params []float32) {
	var params_c [4]float32
	C.gl3_2core_glGetUniformfv(gl.funcs, C.GLuint(program), C.GLint(location), (*C.GLfloat)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetUniformLocation returns an integer that represents the location of a
// specific uniform variable within a program object. name must be an active
// uniform variable name in program that is not a structure, an array of
// structures, or a subcomponent of a vector or a matrix. This function
// returns -1 if name does not correspond to an active uniform variable in
// program or if name starts with the reserved prefix "gl_".
//
// Uniform variables that are structures or arrays of structures may be
// queried by calling GetUniformLocation for each field within the
// structure. The array element operator "[]" and the structure field
// operator "." may be used in name in order to select elements within an
// array or fields within a structure. The result of using these operators is
// not allowed to be another structure, an array of structures, or a
// subcomponent of a vector or a matrix. Except if the last part of name
// indicates a uniform variable array, the location of the first element of
// an array can be retrieved by using the name of the array, or by using the
// name appended by "[0]".
//
// The actual locations assigned to uniform variables are not known until the
// program object is linked successfully. After linking has occurred, the
// command GetUniformLocation can be used to obtain the location of a
// uniform variable. This location value can then be passed to Uniform to
// set the value of the uniform variable or to GetUniform in order to query
// the current value of the uniform variable. After a program object has been
// linked successfully, the index values for uniform variables remain fixed
// until the next link command occurs. Uniform variable locations and values
// can only be queried after a link if the link was successful.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program object.
// GL.INVALID_OPERATION is generated if program has not been successfully
// linked. GL.INVALID_OPERATION is generated if GetUniformLocation is executed
// between the execution of Begin and the corresponding execution of End.
//
// GetUniformLocation is available in GL version 2.0 or greater.
func (gl *GL) GetUniformLocation(program glbase.Program, name string) glbase.Uniform {
	name_cstr := C.CString(name)
	glresult := C.gl3_2core_glGetUniformLocation(gl.funcs, C.GLuint(program), (*C.GLchar)(name_cstr))
	C.free(unsafe.Pointer(name_cstr))
	return glbase.Uniform(glresult)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetShaderSource.xml
func (gl *GL) GetShaderSource(shader glbase.Shader, bufSize int32, length []int32, source []byte) {
	C.gl3_2core_glGetShaderSource(gl.funcs, C.GLuint(shader), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLchar)(unsafe.Pointer(&source[0])))
}

// GetShaderInfoLog returns the information log for the specified shader
// object. The information log for a shader object is modified when the
// shader is compiled.
//
// The information log for a shader object is a string that may contain
// diagnostic messages, warning messages, and other information about the
// last compile operation. When a shader object is created, its information
// log will be a string of length 0, and the size of the current log can be
// obtained by calling GetShaderiv with the value GL.INFO_LOG_LENGTH.
//
// The information log for a shader object is the OpenGL implementer's
// primary mechanism for conveying information about the compilation process.
// Therefore, the information log can be helpful to application developers
// during the development process, even when compilation is successful.
// Application developers should not expect different OpenGL implementations
// to produce identical information logs.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if shader is not a shader
// object. GL.INVALID_VALUE is generated if maxLength is less than 0.
// GL.INVALID_OPERATION is generated if GetShaderInfoLog is executed
// between the execution of Begin and the corresponding execution of End.
//
// GetShaderInfoLog is available in GL version 2.0 or greater.
func (gl *GL) GetShaderInfoLog(shader glbase.Shader) []byte {
	var params [1]int32
	var length int32
	gl.GetShaderiv(shader, INFO_LOG_LENGTH, params[:])
	bufSize := params[0]
	infoLog := make([]byte, int(bufSize))
	C.gl3_2core_glGetShaderInfoLog(gl.funcs, C.GLuint(shader), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length)), (*C.GLchar)(unsafe.Pointer(&infoLog[0])))
	return infoLog
}

// GetShaderiv GetShader returns in params the value of a parameter for a specific
// shader object. The following parameters are defined:
//
//   GL.SHADER_TYPE
//     params returns GL.VERTEX_SHADER if shader is a vertex shader object,
//     and GL.FRAGMENT_SHADER if shader is a fragment shader object.
//
//   GL.DELETE_STATUS
//     params returns GL.TRUE if shader is currently flagged for deletion,
//     and GL.FALSE otherwise.
//
//   GL.COMPILE_STATUS
//     params returns GL.TRUE if the last compile operation on shader was
//     successful, and GL.FALSE otherwise.
//
//   GL.INFO_LOG_LENGTH
//     params returns the number of characters in the information log for
//     shader including the null termination character (the size of the
//     character buffer required to store the information log). If shader has
//     no information log, a value of 0 is returned.
//
//   GL.SHADER_SOURCE_LENGTH
//     params returns the length of the concatenation of the source strings
//     that make up the shader source for the shader, including the null
//     termination character. (the size of the character buffer
//     required to store the shader source). If no source code exists, 0 is
//     returned.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if shader does not refer to a
// shader object. GL.INVALID_ENUM is generated if pname is not an accepted
// value. GL.INVALID_OPERATION is generated if GetShader is executed
// between the execution of Begin and the corresponding execution of End.
//
// GetShaderiv is available in GL version 2.0 or greater.
func (gl *GL) GetShaderiv(shader glbase.Shader, pname glbase.Enum, params []int32) {
	var params_c [4]int32
	C.gl3_2core_glGetShaderiv(gl.funcs, C.GLuint(shader), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetProgramInfoLog returns the information log for the specified program
// object. The information log for a program object is modified when the
// program object is linked or validated.
//
// The information log for a program object is either an empty string, or a
// string containing information about the last link operation, or a string
// containing information about the last validation operation. It may contain
// diagnostic messages, warning messages, and other information. When a
// program object is created, its information log will be a string of length
// 0, and the size of the current log can be obtained by calling GetProgramiv
// with the value GL.INFO_LOG_LENGTH.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated
// by OpenGL. GL.INVALID_OPERATION is generated if program is not a
// program object.
func (gl *GL) GetProgramInfoLog(program glbase.Program) []byte {
	var params [1]int32
	var length int32
	gl.GetProgramiv(program, INFO_LOG_LENGTH, params[:])
	bufSize := params[0]
	infoLog := make([]byte, int(bufSize))
	C.gl3_2core_glGetProgramInfoLog(gl.funcs, C.GLuint(program), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length)), (*C.GLchar)(unsafe.Pointer(&infoLog[0])))
	return infoLog
}

// GetProgramiv returns in params the value of a parameter for a specific
// program object. The following parameters are defined:
//
//   GL.DELETE_STATUS
//       params returns GL.TRUE if program is currently flagged for deletion,
//       and GL.FALSE otherwise.
//
//   GL.LINK_STATUS
//       params returns GL.TRUE if the last link operation on program was
//       successful, and GL.FALSE otherwise.
//
//   GL.VALIDATE_STATUS
//       params returns GL.TRUE or if the last validation operation on
//       program was successful, and GL.FALSE otherwise.
//
//   GL.INFO_LOG_LENGTH
//       params returns the number of characters in the information log for
//       program including the null termination character (the size of
//       the character buffer required to store the information log). If
//       program has no information log, a value of 0 is returned.
//
//   GL.ATTACHED_SHADERS
//       params returns the number of shader objects attached to program.
//
//   GL.ACTIVE_ATTRIBUTES
//       params returns the number of active attribute variables for program.
//
//   GL.ACTIVE_ATTRIBUTE_MAX_LENGTH
//       params returns the length of the longest active attribute name for
//       program, including the null termination character (the size of
//       the character buffer required to store the longest attribute name).
//       If no active attributes exist, 0 is returned.
//
//   GL.ACTIVE_UNIFORMS
//       params returns the number of active uniform variables for program.
//
//   GL.ACTIVE_UNIFORM_MAX_LENGTH
//       params returns the length of the longest active uniform variable
//       name for program, including the null termination character (i.e.,
//       the size of the character buffer required to store the longest
//       uniform variable name). If no active uniform variables exist, 0 is
//       returned.
//
//   GL.TRANSFORM_FEEDBACK_BUFFER_MODE
//       params returns a symbolic constant indicating the buffer mode used
//       when transform feedback is active. This may be GL.SEPARATE_ATTRIBS
//       or GL.INTERLEAVED_ATTRIBS.
//
//   GL.TRANSFORM_FEEDBACK_VARYINGS
//       params returns the number of varying variables to capture in transform
//       feedback mode for the program.
//
//   GL.TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH
//       params returns the length of the longest variable name to be used for
//       transform feedback, including the null-terminator.
//
//   GL.GEOMETRY_VERTICES_OUT
//       params returns the maximum number of vertices that the geometry shader in
//       program will output.
//
//   GL.GEOMETRY_INPUT_TYPE
//       params returns a symbolic constant indicating the primitive type accepted
//       as input to the geometry shader contained in program.
//
//   GL.GEOMETRY_OUTPUT_TYPE
//       params returns a symbolic constant indicating the primitive type that will
//       be output by the geometry shader contained in program.
//
// GL.ACTIVE_UNIFORM_BLOCKS and GL.ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH are
// available only if the GL version 3.1 or greater.
//
// GL.GEOMETRY_VERTICES_OUT, GL.GEOMETRY_INPUT_TYPE and
// GL.GEOMETRY_OUTPUT_TYPE are accepted only if the GL version is 3.2 or
// greater.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program does not refer to a
// program object.  GL.INVALID_OPERATION is generated if pname is
// GL.GEOMETRY_VERTICES_OUT, GL.GEOMETRY_INPUT_TYPE, or
// GL.GEOMETRY_OUTPUT_TYPE, and program does not contain a geometry shader.
// GL.INVALID_ENUM is generated if pname is not an accepted value.
func (gl *GL) GetProgramiv(program glbase.Program, pname glbase.Enum, params []int32) {
	var params_c [4]int32
	C.gl3_2core_glGetProgramiv(gl.funcs, C.GLuint(program), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetAttribLocation queries the previously linked program object specified
// by program for the attribute variable specified by name and returns the
// index of the generic vertex attribute that is bound to that attribute
// variable. If name is a matrix attribute variable, the index of the first
// column of the matrix is returned. If the named attribute variable is not
// an active attribute in the specified program object or if name starts with
// the reserved prefix "gl_", a value of -1 is returned.
//
// The association between an attribute variable name and a generic attribute
// index can be specified at any time by calling BindAttribLocation.
// Attribute bindings do not go into effect until LinkProgram is called.
// After a program object has been linked successfully, the index values for
// attribute variables remain fixed until the next link command occurs. The
// attribute values can only be queried after a link if the link was
// successful. GetAttribLocation returns the binding that actually went
// into effect the last time LinkProgram was called for the specified
// program object. Attribute bindings that have been specified since the last
// link operation are not returned by GetAttribLocation.
//
// Error GL_INVALID_OPERATION is generated if program is not a value
// generated by OpenGL. GL_INVALID_OPERATION is generated if program is not
// a program object. GL_INVALID_OPERATION is generated if program has not
// been successfully linked.  GL_INVALID_OPERATION is generated if
// GetAttribLocation is executed between the execution of Begin and the
// corresponding execution of End.
//
// GetAttribLocation is available in GL version 2.0 or greater.
func (gl *GL) GetAttribLocation(program glbase.Program, name string) glbase.Attrib {
	name_cstr := C.CString(name)
	glresult := C.gl3_2core_glGetAttribLocation(gl.funcs, C.GLuint(program), (*C.GLchar)(name_cstr))
	C.free(unsafe.Pointer(name_cstr))
	return glbase.Attrib(glresult)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetAttachedShaders.xml
func (gl *GL) GetAttachedShaders(program glbase.Program, maxCount int32, count []int, obj []uint32) {
	C.gl3_2core_glGetAttachedShaders(gl.funcs, C.GLuint(program), C.GLsizei(maxCount), (*C.GLsizei)(unsafe.Pointer(&count[0])), (*C.GLuint)(unsafe.Pointer(&obj[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniform.xml
func (gl *GL) GetActiveUniform(program glbase.Program, index uint32, bufSize int32, length []int32, size []int, gltype []glbase.Enum, name []byte) {
	C.gl3_2core_glGetActiveUniform(gl.funcs, C.GLuint(program), C.GLuint(index), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLint)(unsafe.Pointer(&size[0])), (*C.GLenum)(unsafe.Pointer(&gltype[0])), (*C.GLchar)(unsafe.Pointer(&name[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveAttrib.xml
func (gl *GL) GetActiveAttrib(program glbase.Program, index glbase.Attrib, bufSize int32, length []int32, size []int, gltype []glbase.Enum, name []byte) {
	C.gl3_2core_glGetActiveAttrib(gl.funcs, C.GLuint(program), C.GLuint(index), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLint)(unsafe.Pointer(&size[0])), (*C.GLenum)(unsafe.Pointer(&gltype[0])), (*C.GLchar)(unsafe.Pointer(&name[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glEnableVertexAttribArray.xml
func (gl *GL) EnableVertexAttribArray(index glbase.Attrib) {
	C.gl3_2core_glEnableVertexAttribArray(gl.funcs, C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDisableVertexAttribArray.xml
func (gl *GL) DisableVertexAttribArray(index glbase.Attrib) {
	C.gl3_2core_glDisableVertexAttribArray(gl.funcs, C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDetachShader.xml
func (gl *GL) DetachShader(program glbase.Program, shader glbase.Shader) {
	C.gl3_2core_glDetachShader(gl.funcs, C.GLuint(program), C.GLuint(shader))
}

// DeleteShader frees the memory and invalidates the name associated with
// the shader object specified by shader. This command effectively undoes the
// effects of a call to CreateShader.
//
// If a shader object to be deleted is attached to a program object, it will
// be flagged for deletion, but it will not be deleted until it is no longer
// attached to any program object, for any rendering context (it must
// be detached from wherever it was attached before it will be deleted). A
// value of 0 for shader will be silently ignored.
//
// To determine whether an object has been flagged for deletion, call
// GetShader with arguments shader and GL.DELETE_STATUS.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL.
//
// DeleteShader is available in GL version 2.0 or greater.
func (gl *GL) DeleteShader(shader glbase.Shader) {
	C.gl3_2core_glDeleteShader(gl.funcs, C.GLuint(shader))
}

// DeleteProgram frees the memory and invalidates the name associated with
// the program object specified by program. This command effectively undoes
// the effects of a call to CreateProgram.
//
// If a program object is in use as part of current rendering state, it will
// be flagged for deletion, but it will not be deleted until it is no longer
// part of current state for any rendering context. If a program object to be
// deleted has shader objects attached to it, those shader objects will be
// automatically detached but not deleted unless they have already been
// flagged for deletion by a previous call to DeleteShader. A value of 0
// for program will be silently ignored.
//
// To determine whether a program object has been flagged for deletion, call
// GetProgram with arguments program and GL.DELETE_STATUS.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL.
//
// DeleteProgram is available in GL version 2.0 or greater.
func (gl *GL) DeleteProgram(program glbase.Program) {
	C.gl3_2core_glDeleteProgram(gl.funcs, C.GLuint(program))
}

// CreateShader creates an empty shader object and returns a non-zero value
// by which it can be referenced. A shader object is used to maintain the
// source code strings that define a shader. shaderType indicates the type of
// shader to be created.
//
// Two types of shaders are supported. A shader of type GL.VERTEX_SHADER is a
// shader that is intended to run on the programmable vertex processor and
// replace the fixed functionality vertex processing in OpenGL. A shader of
// type GL.FRAGMENT_SHADER is a shader that is intended to run on the
// programmable fragment processor and replace the fixed functionality
// fragment processing in OpenGL.
//
// When created, a shader object's GL.SHADER_TYPE parameter is set to either
// GL.VERTEX_SHADER or GL.FRAGMENT_SHADER, depending on the value of
// shaderType.
//
// Like display lists and texture objects, the name space for shader objects
// may be shared across a set of contexts, as long as the server sides of the
// contexts share the same address space. If the name space is shared across
// contexts, any attached objects and the data associated with those attached
// objects are shared as well.
//
// This function returns 0 if an error occurs creating the shader object.
//
// Error GL.INVALID_ENUM is generated if shaderType is not an accepted value.
// GL.INVALID_OPERATION is generated if CreateShader is executed between the
// execution of Begin and the corresponding execution of End.
//
// CreateShader is available in GL version 2.0 or greater.
func (gl *GL) CreateShader(gltype glbase.Enum) glbase.Shader {
	glresult := C.gl3_2core_glCreateShader(gl.funcs, C.GLenum(gltype))
	return glbase.Shader(glresult)
}

// CreateProgram creates an empty program object and returns a non-zero
// value by which it can be referenced. A program object is an object to
// which shader objects can be attached. This provides a mechanism to specify
// the shader objects that will be linked to create a program. It also
// provides a means for checking the compatibility of the shaders that will
// be used to create a program (for instance, checking the compatibility
// between a vertex shader and a fragment shader). When no longer needed as
// part of a program object, shader objects can be detached.
//
// One or more executables are created in a program object by successfully
// attaching shader objects to it with AttachShader, successfully compiling
// the shader objects with CompileShader, and successfully linking the
// program object with LinkProgram. These executables are made part of
// current state when UseProgram is called. Program objects can be deleted
// by calling DeleteProgram. The memory associated with the program object
// will be deleted when it is no longer part of current rendering state for
// any context.
//
// Like display lists and texture objects, the name space for program objects
// may be shared across a set of contexts, as long as the server sides of the
// contexts share the same address space. If the name space is shared across
// contexts, any attached objects and the data associated with those attached
// objects are shared as well.
//
// Applications are responsible for providing the synchronization across API
// calls when objects are accessed from different execution threads.
//
// This function returns 0 if an error occurs creating the program object.
//
// Error GL.INVALID_OPERATION is generated if CreateProgram is executed
// between the execution of Begin and the corresponding execution of End.
//
// CreateProgram is available in GL version 2.0 or greater.
func (gl *GL) CreateProgram() glbase.Program {
	glresult := C.gl3_2core_glCreateProgram(gl.funcs)
	return glbase.Program(glresult)
}

// CompileShader compiles the source code strings that have been stored in
// the shader object specified by shader.
//
// The compilation status will be stored as part of the shader object's
// state. This value will be set to GL.TRUE if the shader was compiled without
// errors and is ready for use, and GL.FALSE otherwise. It can be queried by
// calling GetShaderiv with arguments shader and GL.COMPILE_STATUS.
//
// Compilation of a shader can fail for a number of reasons as specified by
// the OpenGL Shading Language Specification. Whether or not the compilation
// was successful, information about the compilation can be obtained from the
// shader object's information log by calling GetShaderInfoLog.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL.  GL.INVALID_OPERATION is generated if shader is not a shader
// object.  GL.INVALID_OPERATION is generated if CompileShader is executed
// between the execution of Begin and the corresponding execution of End.
//
// CompileShader is available in GL version 2.0 or greater.
func (gl *GL) CompileShader(shader glbase.Shader) {
	C.gl3_2core_glCompileShader(gl.funcs, C.GLuint(shader))
}

// BindAttribLocation associates a user-defined attribute variable in the program
// object specified by program with a generic vertex attribute index. The name
// parameter specifies the name of the vertex shader attribute variable to
// which index is to be bound. When program is made part of the current state,
// values provided via the generic vertex attribute index will modify the
// value of the user-defined attribute variable specified by name.
//
// If name refers to a matrix attribute variable, index refers to the first
// column of the matrix. Other matrix columns are then automatically bound to
// locations index+1 for a matrix of type mat2; index+1 and index+2 for a
// matrix of type mat3; and index+1, index+2, and index+3 for a matrix of
// type mat4.
//
// This command makes it possible for vertex shaders to use descriptive names
// for attribute variables rather than generic variables that are numbered
// from 0 to GL.MAX_VERTEX_ATTRIBS-1. The values sent to each generic
// attribute index are part of current state, just like standard vertex
// attributes such as color, normal, and vertex position. If a different
// program object is made current by calling UseProgram, the generic vertex
// attributes are tracked in such a way that the same values will be observed
// by attributes in the new program object that are also bound to index.
//
// Attribute variable name-to-generic attribute index bindings for a program
// object can be explicitly assigned at any time by calling
// BindAttribLocation. Attribute bindings do not go into effect until
// LinkProgram is called. After a program object has been linked
// successfully, the index values for generic attributes remain fixed (and
// their values can be queried) until the next link command occurs.
//
// Applications are not allowed to bind any of the standard OpenGL vertex
// attributes using this command, as they are bound automatically when
// needed. Any attribute binding that occurs after the program object has
// been linked will not take effect until the next time the program object is
// linked.
//
// If name was bound previously, that information is lost. Thus you cannot
// bind one user-defined attribute variable to multiple indices, but you can
// bind multiple user-defined attribute variables to the same index.
//
// Applications are allowed to bind more than one user-defined attribute
// variable to the same generic vertex attribute index. This is called
// aliasing, and it is allowed only if just one of the aliased attributes is
// active in the executable program, or if no path through the shader
// consumes more than one attribute of a set of attributes aliased to the
// same location. The compiler and linker are allowed to assume that no
// aliasing is done and are free to employ optimizations that work only in
// the absence of aliasing. OpenGL implementations are not required to do
// error checking to detect aliasing. Because there is no way to bind
// standard attributes, it is not possible to alias generic attributes with
// conventional ones (except for generic attribute 0).
//
// BindAttribLocation can be called before any vertex shader objects are
// bound to the specified program object. It is also permissible to bind a
// generic attribute index to an attribute variable name that is never used
// in a vertex shader.
//
// Active attributes that are not explicitly bound will be bound by the
// linker when LinkProgram is called. The locations assigned can be queried
// by calling GetAttribLocation.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS.
// GL.INVALID_OPERATION is generated if name starts with the reserved prefix "gl_".
// GL.INVALID_VALUE is generated if program is not a value generated by OpenGL.
// GL.INVALID_OPERATION is generated if program is not a program object.
// GL.INVALID_OPERATION is generated if BindAttribLocation is executed
// between the execution of Begin and the corresponding execution of End.
//
// BindAttribLocation is available in GL version 2.0 or greater.
func (gl *GL) BindAttribLocation(program glbase.Program, index glbase.Attrib, name string) {
	name_cstr := C.CString(name)
	C.gl3_2core_glBindAttribLocation(gl.funcs, C.GLuint(program), C.GLuint(index), (*C.GLchar)(name_cstr))
	C.free(unsafe.Pointer(name_cstr))
}

// AttachShader attaches a shader object to a program object.
//
// In order to create an executable, there must be a way to specify the list
// of things that will be linked together. Program objects provide this
// mechanism. Shaders that are to be linked together in a program object must
// first be attached to that program object. This indicates that shader will
// be included in link operations that will be performed on program.
//
// All operations that can be performed on a shader object are valid whether
// or not the shader object is attached to a program object. It is
// permissible to attach a shader object to a program object before source
// code has been loaded into the shader object or before the shader object
// has been compiled. It is permissible to attach multiple shader objects of
// the same type because each may contain a portion of the complete shader.
// It is also permissible to attach a shader object to more than one program
// object. If a shader object is deleted while it is attached to a program
// object, it will be flagged for deletion, and deletion will not occur until
// DetachShader is called to detach it from all program objects to which it
// is attached.
//
// Error GL.INVALID_VALUE is generated if either program or shader is not a
// value generated by OpenGL. GL.INVALID_OPERATION is generated if program
// is not a program object. GL.INVALID_OPERATION is generated if shader is
// not a shader object. GL.INVALID_OPERATION is generated if shader is
// already attached to program. GL.INVALID_OPERATION is generated if
// AttachShader is executed between the execution of Begin and the
// corresponding execution of End.
//
// AttachShader is available in GL version 2.0 or greater.
func (gl *GL) AttachShader(program glbase.Program, shader glbase.Shader) {
	C.gl3_2core_glAttachShader(gl.funcs, C.GLuint(program), C.GLuint(shader))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glStencilMaskSeparate.xml
func (gl *GL) StencilMaskSeparate(face glbase.Enum, mask uint32) {
	C.gl3_2core_glStencilMaskSeparate(gl.funcs, C.GLenum(face), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glStencilFuncSeparate.xml
func (gl *GL) StencilFuncSeparate(face, glfunc glbase.Enum, ref int32, mask uint32) {
	C.gl3_2core_glStencilFuncSeparate(gl.funcs, C.GLenum(face), C.GLenum(glfunc), C.GLint(ref), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glStencilOpSeparate.xml
func (gl *GL) StencilOpSeparate(face, sfail, dpfail, dppass glbase.Enum) {
	C.gl3_2core_glStencilOpSeparate(gl.funcs, C.GLenum(face), C.GLenum(sfail), C.GLenum(dpfail), C.GLenum(dppass))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawBuffers.xml
func (gl *GL) DrawBuffers(n int, bufs []glbase.Enum) {
	C.gl3_2core_glDrawBuffers(gl.funcs, C.GLsizei(n), (*C.GLenum)(unsafe.Pointer(&bufs[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBlendEquationSeparate.xml
func (gl *GL) BlendEquationSeparate(modeRGB, modeAlpha glbase.Enum) {
	C.gl3_2core_glBlendEquationSeparate(gl.funcs, C.GLenum(modeRGB), C.GLenum(modeAlpha))
}

// UniformMatrix4x3fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix4x3fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix4x3fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(4*3) != 0 {
		panic("invalid value length for UniformMatrix4x3fv")
	}
	count := len(value) / (4 * 3)
	C.gl3_2core_glUniformMatrix4x3fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix3x4fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix3x4fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix3x4fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(3*4) != 0 {
		panic("invalid value length for UniformMatrix3x4fv")
	}
	count := len(value) / (3 * 4)
	C.gl3_2core_glUniformMatrix3x4fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix4x2fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix4x2fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix4x2fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(4*2) != 0 {
		panic("invalid value length for UniformMatrix4x2fv")
	}
	count := len(value) / (4 * 2)
	C.gl3_2core_glUniformMatrix4x2fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix2x4fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix2x4fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix2x4fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(2*4) != 0 {
		panic("invalid value length for UniformMatrix2x4fv")
	}
	count := len(value) / (2 * 4)
	C.gl3_2core_glUniformMatrix2x4fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix3x2fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix3x2fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix3x2fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(3*2) != 0 {
		panic("invalid value length for UniformMatrix3x2fv")
	}
	count := len(value) / (3 * 2)
	C.gl3_2core_glUniformMatrix3x2fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix2x3fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix2x3fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix2x3fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(2*3) != 0 {
		panic("invalid value length for UniformMatrix2x3fv")
	}
	count := len(value) / (2 * 3)
	C.gl3_2core_glUniformMatrix2x3fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsVertexArray.xml
func (gl *GL) IsVertexArray(array uint32) bool {
	glresult := C.gl3_2core_glIsVertexArray(gl.funcs, C.GLuint(array))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGenVertexArrays.xml
func (gl *GL) GenVertexArrays(n int, arrays []uint32) {
	C.gl3_2core_glGenVertexArrays(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&arrays[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteVertexArrays.xml
func (gl *GL) DeleteVertexArrays(n int, arrays []uint32) {
	C.gl3_2core_glDeleteVertexArrays(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&arrays[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindVertexArray.xml
func (gl *GL) BindVertexArray(array uint32) {
	C.gl3_2core_glBindVertexArray(gl.funcs, C.GLuint(array))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFlushMappedBufferRange.xml
func (gl *GL) FlushMappedBufferRange(target glbase.Enum, offset, length int) {
	C.gl3_2core_glFlushMappedBufferRange(gl.funcs, C.GLenum(target), C.GLintptr(offset), C.GLsizeiptr(length))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTextureLayer.xml
func (gl *GL) FramebufferTextureLayer(target, attachment glbase.Enum, texture glbase.Texture, level int, layer int32) {
	C.gl3_2core_glFramebufferTextureLayer(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLuint(texture), C.GLint(level), C.GLint(layer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glRenderbufferStorageMultisample.xml
func (gl *GL) RenderbufferStorageMultisample(target glbase.Enum, samples int32, internalFormat glbase.Enum, width, height int) {
	C.gl3_2core_glRenderbufferStorageMultisample(gl.funcs, C.GLenum(target), C.GLsizei(samples), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBlitFramebuffer.xml
func (gl *GL) BlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1 int32, mask glbase.Bitfield, filter glbase.Enum) {
	C.gl3_2core_glBlitFramebuffer(gl.funcs, C.GLint(srcX0), C.GLint(srcY0), C.GLint(srcX1), C.GLint(srcY1), C.GLint(dstX0), C.GLint(dstY0), C.GLint(dstX1), C.GLint(dstY1), C.GLbitfield(mask), C.GLenum(filter))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGenerateMipmap.xml
func (gl *GL) GenerateMipmap(target glbase.Enum) {
	C.gl3_2core_glGenerateMipmap(gl.funcs, C.GLenum(target))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetFramebufferAttachmentParameteriv.xml
func (gl *GL) GetFramebufferAttachmentParameteriv(target, attachment, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetFramebufferAttachmentParameteriv(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferRenderbuffer.xml
func (gl *GL) FramebufferRenderbuffer(target, attachment, renderbuffertarget glbase.Enum, renderbuffer glbase.Renderbuffer) {
	C.gl3_2core_glFramebufferRenderbuffer(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(renderbuffertarget), C.GLuint(renderbuffer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture3D.xml
func (gl *GL) FramebufferTexture3D(target, attachment, textarget glbase.Enum, texture glbase.Texture, level int, zoffset int32) {
	C.gl3_2core_glFramebufferTexture3D(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(textarget), C.GLuint(texture), C.GLint(level), C.GLint(zoffset))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture2D.xml
func (gl *GL) FramebufferTexture2D(target, attachment, textarget glbase.Enum, texture glbase.Texture, level int) {
	C.gl3_2core_glFramebufferTexture2D(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(textarget), C.GLuint(texture), C.GLint(level))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture1D.xml
func (gl *GL) FramebufferTexture1D(target, attachment, textarget glbase.Enum, texture glbase.Texture, level int) {
	C.gl3_2core_glFramebufferTexture1D(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(textarget), C.GLuint(texture), C.GLint(level))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCheckFramebufferStatus.xml
func (gl *GL) CheckFramebufferStatus(target glbase.Enum) glbase.Enum {
	glresult := C.gl3_2core_glCheckFramebufferStatus(gl.funcs, C.GLenum(target))
	return glbase.Enum(glresult)
}

// GenFramebuffers returns n framebuffer object names in ids. There is no
// guarantee that the names form a contiguous set of integers; however, it is
// guaranteed that none of the returned names was in use immediately before
// the call to GenFramebuffers.
//
// Framebuffer object names returned by a call to GenFramebuffers are not
// returned by subsequent calls, unless they are first deleted with
// DeleteFramebuffers.
//
// The names returned in ids are marked as used, for the purposes of
// GenFramebuffers only, but they acquire state and type only when they are
// first bound.
//
// Error GL.INVALID_VALUE is generated if n is negative.
func (gl *GL) GenFramebuffers(n int) []glbase.Framebuffer {
	if n == 0 {
		return nil
	}
	framebuffers := make([]glbase.Framebuffer, n)
	C.gl3_2core_glGenFramebuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&framebuffers[0])))
	return framebuffers
}

// DeleteFramebuffers deletes the framebuffer objects whose names are
// stored in the framebuffers slice. The name zero is reserved by the GL and
// is silently ignored, should it occur in framebuffers, as are other unused
// names. Once a framebuffer object is deleted, its name is again unused and
// it has no attachments. If a framebuffer that is currently bound to one or
// more of the targets GL.DRAW_FRAMEBUFFER or GL.READ_FRAMEBUFFER is deleted,
// it is as though BindFramebuffer had been executed with the corresponding
// target and framebuffer zero.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteFramebuffers is available in GL version 3.0 or greater.
func (gl *GL) DeleteFramebuffers(framebuffers []glbase.Framebuffer) {
	n := len(framebuffers)
	if n == 0 {
		return
	}
	C.gl3_2core_glDeleteFramebuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&framebuffers[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindFramebuffer.xml
func (gl *GL) BindFramebuffer(target glbase.Enum, framebuffer glbase.Framebuffer) {
	C.gl3_2core_glBindFramebuffer(gl.funcs, C.GLenum(target), C.GLuint(framebuffer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsFramebuffer.xml
func (gl *GL) IsFramebuffer(framebuffer glbase.Framebuffer) bool {
	glresult := C.gl3_2core_glIsFramebuffer(gl.funcs, C.GLuint(framebuffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetRenderbufferParameteriv.xml
func (gl *GL) GetRenderbufferParameteriv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetRenderbufferParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glRenderbufferStorage.xml
func (gl *GL) RenderbufferStorage(target, internalFormat glbase.Enum, width, height int) {
	C.gl3_2core_glRenderbufferStorage(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height))
}

// GenRenderbuffers returns n renderbuffer object names in renderbuffers.
// There is no guarantee that the names form a contiguous set of integers;
// however, it is guaranteed that none of the returned names was in use
// immediately before the call to GenRenderbuffers.
//
// Renderbuffer object names returned by a call to GenRenderbuffers are not
// returned by subsequent calls, unless they are first deleted with
// DeleteRenderbuffers.
//
// The names returned in renderbuffers are marked as used, for the purposes
// of GenRenderbuffers only, but they acquire state and type only when they
// are first bound.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// GenRenderbuffers is available in GL version 3.0 or greater.
func (gl *GL) GenRenderbuffers(n int) []glbase.Renderbuffer {
	if n == 0 {
		return nil
	}
	renderbuffers := make([]glbase.Renderbuffer, n)
	C.gl3_2core_glGenRenderbuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&renderbuffers[0])))
	return renderbuffers
}

// DeleteRenderbuffers deletes the renderbuffer objects whose names are stored
// in the renderbuffers slice. The name zero is reserved by the GL and
// is silently ignored, should it occur in renderbuffers, as are other unused
// names. Once a renderbuffer object is deleted, its name is again unused and
// it has no contents. If a renderbuffer that is currently bound to the
// target GL.RENDERBUFFER is deleted, it is as though BindRenderbuffer had
// been executed with a target of GL.RENDERBUFFER and a name of zero.
//
// If a renderbuffer object is attached to one or more attachment points in
// the currently bound framebuffer, then it as if FramebufferRenderbuffer
// had been called, with a renderbuffer of zero for each attachment point to
// which this image was attached in the currently bound framebuffer. In other
// words, this renderbuffer object is first detached from all attachment
// ponits in the currently bound framebuffer. Note that the renderbuffer
// image is specifically not detached from any non-bound framebuffers.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteRenderbuffers is available in GL version 3.0 or greater.
func (gl *GL) DeleteRenderbuffers(renderbuffers []glbase.Renderbuffer) {
	n := len(renderbuffers)
	if n == 0 {
		return
	}
	C.gl3_2core_glDeleteRenderbuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&renderbuffers[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindRenderbuffer.xml
func (gl *GL) BindRenderbuffer(target glbase.Enum, renderbuffer glbase.Renderbuffer) {
	C.gl3_2core_glBindRenderbuffer(gl.funcs, C.GLenum(target), C.GLuint(renderbuffer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsRenderbuffer.xml
func (gl *GL) IsRenderbuffer(renderbuffer glbase.Renderbuffer) bool {
	glresult := C.gl3_2core_glIsRenderbuffer(gl.funcs, C.GLuint(renderbuffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearBufferfi.xml
func (gl *GL) ClearBufferfi(buffer glbase.Enum, drawbuffer int32, depth float32, stencil int32) {
	C.gl3_2core_glClearBufferfi(gl.funcs, C.GLenum(buffer), C.GLint(drawbuffer), C.GLfloat(depth), C.GLint(stencil))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearBufferfv.xml
func (gl *GL) ClearBufferfv(buffer glbase.Enum, drawbuffer int32, value []float32) {
	C.gl3_2core_glClearBufferfv(gl.funcs, C.GLenum(buffer), C.GLint(drawbuffer), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearBufferuiv.xml
func (gl *GL) ClearBufferuiv(buffer glbase.Enum, drawbuffer int32, value []uint32) {
	C.gl3_2core_glClearBufferuiv(gl.funcs, C.GLenum(buffer), C.GLint(drawbuffer), (*C.GLuint)(unsafe.Pointer(&value[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClearBufferiv.xml
func (gl *GL) ClearBufferiv(buffer glbase.Enum, drawbuffer int32, value []int32) {
	C.gl3_2core_glClearBufferiv(gl.funcs, C.GLenum(buffer), C.GLint(drawbuffer), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameterIuiv.xml
func (gl *GL) GetTexParameterIuiv(target, pname glbase.Enum, params []uint32) {
	C.gl3_2core_glGetTexParameterIuiv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLuint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameterIiv.xml
func (gl *GL) GetTexParameterIiv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetTexParameterIiv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexParameterIuiv.xml
func (gl *GL) TexParameterIuiv(target, pname glbase.Enum, params []uint32) {
	C.gl3_2core_glTexParameterIuiv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLuint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexParameterIiv.xml
func (gl *GL) TexParameterIiv(target, pname glbase.Enum, params []int32) {
	C.gl3_2core_glTexParameterIiv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// Uniform4uiv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform4uiv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4uiv(location glbase.Uniform, value []uint32) {
	if len(value) == 0 {
		return
	}
	if len(value)%4 != 0 {
		panic("invalid value length for Uniform4uiv")
	}
	count := len(value) / 4
	C.gl3_2core_glUniform4uiv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLuint)(unsafe.Pointer(&value[0])))
}

// Uniform3uiv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform3uiv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3uiv(location glbase.Uniform, value []uint32) {
	if len(value) == 0 {
		return
	}
	if len(value)%3 != 0 {
		panic("invalid value length for Uniform3uiv")
	}
	count := len(value) / 3
	C.gl3_2core_glUniform3uiv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLuint)(unsafe.Pointer(&value[0])))
}

// Uniform2uiv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform2uiv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2uiv(location glbase.Uniform, value []uint32) {
	if len(value) == 0 {
		return
	}
	if len(value)%2 != 0 {
		panic("invalid value length for Uniform2uiv")
	}
	count := len(value) / 2
	C.gl3_2core_glUniform2uiv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLuint)(unsafe.Pointer(&value[0])))
}

// Uniform1uiv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform1uiv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1uiv(location glbase.Uniform, value []uint32) {
	if len(value) == 0 {
		return
	}
	count := len(value)
	C.gl3_2core_glUniform1uiv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLuint)(unsafe.Pointer(&value[0])))
}

// Uniform4ui modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform4ui operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4ui(location glbase.Uniform, v0, v1, v2, v3 uint32) {
	C.gl3_2core_glUniform4ui(gl.funcs, C.GLint(location), C.GLuint(v0), C.GLuint(v1), C.GLuint(v2), C.GLuint(v3))
}

// Uniform3ui modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform3ui operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3ui(location glbase.Uniform, v0, v1, v2 uint32) {
	C.gl3_2core_glUniform3ui(gl.funcs, C.GLint(location), C.GLuint(v0), C.GLuint(v1), C.GLuint(v2))
}

// Uniform2ui modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform2ui operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2ui(location glbase.Uniform, v0, v1 uint32) {
	C.gl3_2core_glUniform2ui(gl.funcs, C.GLint(location), C.GLuint(v0), C.GLuint(v1))
}

// Uniform1ui modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform1ui operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1ui(location glbase.Uniform, v0 uint32) {
	C.gl3_2core_glUniform1ui(gl.funcs, C.GLint(location), C.GLuint(v0))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetFragDataLocation.xml
func (gl *GL) GetFragDataLocation(program glbase.Program, name []byte) int32 {
	glresult := C.gl3_2core_glGetFragDataLocation(gl.funcs, C.GLuint(program), (*C.GLchar)(unsafe.Pointer(&name[0])))
	return int32(glresult)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindFragDataLocation.xml
func (gl *GL) BindFragDataLocation(program glbase.Program, color uint32, name []byte) {
	C.gl3_2core_glBindFragDataLocation(gl.funcs, C.GLuint(program), C.GLuint(color), (*C.GLchar)(unsafe.Pointer(&name[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniformuiv.xml
func (gl *GL) GetUniformuiv(program glbase.Program, location glbase.Uniform, params []uint32) {
	C.gl3_2core_glGetUniformuiv(gl.funcs, C.GLuint(program), C.GLint(location), (*C.GLuint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttribIuiv.xml
func (gl *GL) GetVertexAttribIuiv(index glbase.Attrib, pname glbase.Enum, params []uint32) {
	C.gl3_2core_glGetVertexAttribIuiv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLuint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttribIiv.xml
func (gl *GL) GetVertexAttribIiv(index glbase.Attrib, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetVertexAttribIiv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glVertexAttribIPointer.xml
func (gl *GL) VertexAttribIPointer(index glbase.Attrib, size int, gltype glbase.Enum, stride int, pointer interface{}) {
	var pointer_ptr unsafe.Pointer
	var pointer_v = reflect.ValueOf(pointer)
	if pointer != nil && pointer_v.Kind() != reflect.Slice {
		panic("parameter pointer must be a slice")
	}
	if pointer != nil {
		pointer_ptr = unsafe.Pointer(pointer_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glVertexAttribIPointer(gl.funcs, C.GLuint(index), C.GLint(size), C.GLenum(gltype), C.GLsizei(stride), pointer_ptr)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glEndConditionalRender.xml
func (gl *GL) EndConditionalRender() {
	C.gl3_2core_glEndConditionalRender(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBeginConditionalRender.xml
func (gl *GL) BeginConditionalRender(id uint32, mode glbase.Enum) {
	C.gl3_2core_glBeginConditionalRender(gl.funcs, C.GLuint(id), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClampColor.xml
func (gl *GL) ClampColor(target, clamp glbase.Enum) {
	C.gl3_2core_glClampColor(gl.funcs, C.GLenum(target), C.GLenum(clamp))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetTransformFeedbackVarying.xml
func (gl *GL) GetTransformFeedbackVarying(program glbase.Program, index uint32, bufSize int32, length []int32, size []int, gltype []glbase.Enum, name []byte) {
	C.gl3_2core_glGetTransformFeedbackVarying(gl.funcs, C.GLuint(program), C.GLuint(index), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLsizei)(unsafe.Pointer(&size[0])), (*C.GLenum)(unsafe.Pointer(&gltype[0])), (*C.GLchar)(unsafe.Pointer(&name[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindBufferBase.xml
func (gl *GL) BindBufferBase(target glbase.Enum, index uint32, buffer glbase.Buffer) {
	C.gl3_2core_glBindBufferBase(gl.funcs, C.GLenum(target), C.GLuint(index), C.GLuint(buffer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBindBufferRange.xml
func (gl *GL) BindBufferRange(target glbase.Enum, index uint32, buffer glbase.Buffer, offset, size int) {
	C.gl3_2core_glBindBufferRange(gl.funcs, C.GLenum(target), C.GLuint(index), C.GLuint(buffer), C.GLintptr(offset), C.GLsizeiptr(size))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glEndTransformFeedback.xml
func (gl *GL) EndTransformFeedback() {
	C.gl3_2core_glEndTransformFeedback(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glBeginTransformFeedback.xml
func (gl *GL) BeginTransformFeedback(primitiveMode glbase.Enum) {
	C.gl3_2core_glBeginTransformFeedback(gl.funcs, C.GLenum(primitiveMode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsEnabledi.xml
func (gl *GL) IsEnabledi(target glbase.Enum, index uint32) bool {
	glresult := C.gl3_2core_glIsEnabledi(gl.funcs, C.GLenum(target), C.GLuint(index))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDisablei.xml
func (gl *GL) Disablei(target glbase.Enum, index uint32) {
	C.gl3_2core_glDisablei(gl.funcs, C.GLenum(target), C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glEnablei.xml
func (gl *GL) Enablei(target glbase.Enum, index uint32) {
	C.gl3_2core_glEnablei(gl.funcs, C.GLenum(target), C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetIntegeri_v.xml
func (gl *GL) GetIntegeri_v(target glbase.Enum, index uint32, data []int32) {
	C.gl3_2core_glGetIntegeri_v(gl.funcs, C.GLenum(target), C.GLuint(index), (*C.GLint)(unsafe.Pointer(&data[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetBooleani_v.xml
func (gl *GL) GetBooleani_v(target glbase.Enum, index uint32, data []bool) {
	C.gl3_2core_glGetBooleani_v(gl.funcs, C.GLenum(target), C.GLuint(index), (*C.GLboolean)(unsafe.Pointer(&data[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glColorMaski.xml
func (gl *GL) ColorMaski(index uint32, r, g, b, a bool) {
	C.gl3_2core_glColorMaski(gl.funcs, C.GLuint(index), *(*C.GLboolean)(unsafe.Pointer(&r)), *(*C.GLboolean)(unsafe.Pointer(&g)), *(*C.GLboolean)(unsafe.Pointer(&b)), *(*C.GLboolean)(unsafe.Pointer(&a)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glCopyBufferSubData.xml
func (gl *GL) CopyBufferSubData(readTarget, writeTarget glbase.Enum, readOffset, writeOffset, size int) {
	C.gl3_2core_glCopyBufferSubData(gl.funcs, C.GLenum(readTarget), C.GLenum(writeTarget), C.GLintptr(readOffset), C.GLintptr(writeOffset), C.GLsizeiptr(size))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glUniformBlockBinding.xml
func (gl *GL) UniformBlockBinding(program glbase.Program, v0, v1 uint32) {
	C.gl3_2core_glUniformBlockBinding(gl.funcs, C.GLuint(program), C.GLuint(v0), C.GLuint(v1))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformBlockName.xml
func (gl *GL) GetActiveUniformBlockName(program glbase.Program, uniformBlockIndex uint32, bufSize int32, length []int32, uniformBlockName []byte) {
	C.gl3_2core_glGetActiveUniformBlockName(gl.funcs, C.GLuint(program), C.GLuint(uniformBlockIndex), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLchar)(unsafe.Pointer(&uniformBlockName[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformBlockiv.xml
func (gl *GL) GetActiveUniformBlockiv(program glbase.Program, uniformBlockIndex uint32, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetActiveUniformBlockiv(gl.funcs, C.GLuint(program), C.GLuint(uniformBlockIndex), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniformBlockIndex.xml
func (gl *GL) GetUniformBlockIndex(program glbase.Program, uniformBlockName []byte) uint32 {
	glresult := C.gl3_2core_glGetUniformBlockIndex(gl.funcs, C.GLuint(program), (*C.GLchar)(unsafe.Pointer(&uniformBlockName[0])))
	return uint32(glresult)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformName.xml
func (gl *GL) GetActiveUniformName(program glbase.Program, uniformIndex uint32, bufSize int32, length []int32, uniformName []byte) {
	C.gl3_2core_glGetActiveUniformName(gl.funcs, C.GLuint(program), C.GLuint(uniformIndex), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLchar)(unsafe.Pointer(&uniformName[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformsiv.xml
func (gl *GL) GetActiveUniformsiv(program glbase.Program, uniformCount int32, uniformIndices []uint32, pname glbase.Enum, params []int32) {
	C.gl3_2core_glGetActiveUniformsiv(gl.funcs, C.GLuint(program), C.GLsizei(uniformCount), (*C.GLuint)(unsafe.Pointer(&uniformIndices[0])), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glPrimitiveRestartIndex.xml
func (gl *GL) PrimitiveRestartIndex(index uint32) {
	C.gl3_2core_glPrimitiveRestartIndex(gl.funcs, C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexBuffer.xml
func (gl *GL) TexBuffer(target, internalFormat glbase.Enum, buffer glbase.Buffer) {
	C.gl3_2core_glTexBuffer(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLuint(buffer))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsInstanced.xml
func (gl *GL) DrawElementsInstanced(mode glbase.Enum, count int, gltype glbase.Enum, indices interface{}, instancecount int32) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glDrawElementsInstanced(gl.funcs, C.GLenum(mode), C.GLsizei(count), C.GLenum(gltype), indices_ptr, C.GLsizei(instancecount))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawArraysInstanced.xml
func (gl *GL) DrawArraysInstanced(mode glbase.Enum, first, count int, instancecount int32) {
	C.gl3_2core_glDrawArraysInstanced(gl.funcs, C.GLenum(mode), C.GLint(first), C.GLsizei(count), C.GLsizei(instancecount))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glSampleMaski.xml
func (gl *GL) SampleMaski(index uint32, mask glbase.Bitfield) {
	C.gl3_2core_glSampleMaski(gl.funcs, C.GLuint(index), C.GLbitfield(mask))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetMultisamplefv.xml
func (gl *GL) GetMultisamplefv(pname glbase.Enum, index uint32, val []float32) {
	C.gl3_2core_glGetMultisamplefv(gl.funcs, C.GLenum(pname), C.GLuint(index), (*C.GLfloat)(unsafe.Pointer(&val[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexImage3DMultisample.xml
func (gl *GL) TexImage3DMultisample(target glbase.Enum, samples, internalFormat int32, width, height int, depth int32, fixedsamplelocations bool) {
	C.gl3_2core_glTexImage3DMultisample(gl.funcs, C.GLenum(target), C.GLsizei(samples), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLsizei(depth), *(*C.GLboolean)(unsafe.Pointer(&fixedsamplelocations)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glTexImage2DMultisample.xml
func (gl *GL) TexImage2DMultisample(target glbase.Enum, samples, internalFormat int32, width, height int, fixedsamplelocations bool) {
	C.gl3_2core_glTexImage2DMultisample(gl.funcs, C.GLenum(target), C.GLsizei(samples), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), *(*C.GLboolean)(unsafe.Pointer(&fixedsamplelocations)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetSynciv.xml
func (gl *GL) GetSynciv(sync glbase.Sync, pname glbase.Enum, bufSize int32, length, values []int32) {
	C.gl3_2core_glGetSynciv(gl.funcs, C.GLsync(unsafe.Pointer(sync)), C.GLenum(pname), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLint)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetInteger64v.xml
func (gl *GL) GetInteger64v(pname glbase.Enum, params []int64) {
	C.gl3_2core_glGetInteger64v(gl.funcs, C.GLenum(pname), (*C.GLint64)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glWaitSync.xml
func (gl *GL) WaitSync(sync glbase.Sync, flags glbase.Bitfield, timeout uint64) {
	C.gl3_2core_glWaitSync(gl.funcs, C.GLsync(unsafe.Pointer(sync)), C.GLbitfield(flags), C.GLuint64(timeout))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glClientWaitSync.xml
func (gl *GL) ClientWaitSync(sync glbase.Sync, flags glbase.Bitfield, timeout uint64) glbase.Enum {
	glresult := C.gl3_2core_glClientWaitSync(gl.funcs, C.GLsync(unsafe.Pointer(sync)), C.GLbitfield(flags), C.GLuint64(timeout))
	return glbase.Enum(glresult)
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteSync.xml
func (gl *GL) DeleteSync(sync glbase.Sync) {
	C.gl3_2core_glDeleteSync(gl.funcs, C.GLsync(unsafe.Pointer(sync)))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glIsSync.xml
func (gl *GL) IsSync(sync glbase.Sync) bool {
	glresult := C.gl3_2core_glIsSync(gl.funcs, C.GLsync(unsafe.Pointer(sync)))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFenceSync.xml
func (gl *GL) FenceSync(condition glbase.Enum, flags glbase.Bitfield) glbase.Sync {
	glresult := C.gl3_2core_glFenceSync(gl.funcs, C.GLenum(condition), C.GLbitfield(flags))
	return glbase.Sync(unsafe.Pointer(glresult))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glProvokingVertex.xml
func (gl *GL) ProvokingVertex(mode glbase.Enum) {
	C.gl3_2core_glProvokingVertex(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsInstancedBaseVertex.xml
func (gl *GL) DrawElementsInstancedBaseVertex(mode glbase.Enum, count int, gltype glbase.Enum, indices interface{}, instancecount, basevertex int32) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glDrawElementsInstancedBaseVertex(gl.funcs, C.GLenum(mode), C.GLsizei(count), C.GLenum(gltype), indices_ptr, C.GLsizei(instancecount), C.GLint(basevertex))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawRangeElementsBaseVertex.xml
func (gl *GL) DrawRangeElementsBaseVertex(mode glbase.Enum, start, end uint32, count int, gltype glbase.Enum, indices interface{}, basevertex int32) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glDrawRangeElementsBaseVertex(gl.funcs, C.GLenum(mode), C.GLuint(start), C.GLuint(end), C.GLsizei(count), C.GLenum(gltype), indices_ptr, C.GLint(basevertex))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsBaseVertex.xml
func (gl *GL) DrawElementsBaseVertex(mode glbase.Enum, count int, gltype glbase.Enum, indices interface{}, basevertex int32) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gl3_2core_glDrawElementsBaseVertex(gl.funcs, C.GLenum(mode), C.GLsizei(count), C.GLenum(gltype), indices_ptr, C.GLint(basevertex))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml
func (gl *GL) FramebufferTexture(target, attachment glbase.Enum, texture glbase.Texture, level int) {
	C.gl3_2core_glFramebufferTexture(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLuint(texture), C.GLint(level))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferParameteri64v.xml
func (gl *GL) GetBufferParameteri64v(target, pname glbase.Enum, params []int64) {
	C.gl3_2core_glGetBufferParameteri64v(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint64)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man3/xhtml/glGetInteger64i_v.xml
func (gl *GL) GetInteger64i_v(target glbase.Enum, index uint32, data []int64) {
	C.gl3_2core_glGetInteger64i_v(gl.funcs, C.GLenum(target), C.GLuint(index), (*C.GLint64)(unsafe.Pointer(&data[0])))
}
