// ** file automatically generated by glgen -- do not edit manually **

package GL

// #cgo CXXFLAGS: -std=c++0x -pedantic-errors -Wall -fno-strict-aliasing
// #cgo LDFLAGS: -lstdc++
// #cgo !darwin LDFLAGS: -lGL
// #cgo  darwin LDFLAGS: -framework OpenGL
// #cgo pkg-config: Qt5Core Qt5OpenGL
//
// #include "funcs.h"
//
// void free(void*);
//
import "C"

import (
	"fmt"
	"reflect"
	"unsafe"

	"gopkg.in/qml.v1/gl/glbase"
)

// API returns a value that offers methods matching the OpenGL version ES2 API.
//
// The returned API must not be used after the provided OpenGL context becomes invalid.
func API(context glbase.Contexter) *GL {
	gl := &GL{}
	gl.funcs = C.gles2_funcs()
	if gl.funcs == nil {
		panic(fmt.Errorf("OpenGL version ES2 is not available"))
	}
	return gl
}

// GL implements the OpenGL version ES2 API. Values of this
// type must be created via the API function, and it must not be used after
// the associated OpenGL context becomes invalid.
type GL struct {
	funcs unsafe.Pointer
}

const (
	FALSE = 0
	TRUE  = 1
	NONE  = 0

	BYTE           = 0x1400
	UNSIGNED_BYTE  = 0x1401
	SHORT          = 0x1402
	UNSIGNED_SHORT = 0x1403
	INT            = 0x1404
	UNSIGNED_INT   = 0x1405
	FLOAT          = 0x1406
	FIXED          = 0x140C

	COLOR_BUFFER_BIT   = 0x00004000
	DEPTH_BUFFER_BIT   = 0x00000100
	STENCIL_BUFFER_BIT = 0x00000400

	ALWAYS   = 0x0207
	EQUAL    = 0x0202
	GEQUAL   = 0x0206
	GREATER  = 0x0204
	LEQUAL   = 0x0203
	LESS     = 0x0201
	NEVER    = 0x0200
	NOTEQUAL = 0x0205

	DST_ALPHA           = 0x0304
	ONE                 = 1
	ONE_MINUS_DST_ALPHA = 0x0305
	ONE_MINUS_SRC_ALPHA = 0x0303
	ONE_MINUS_SRC_COLOR = 0x0301
	SRC_ALPHA           = 0x0302
	SRC_COLOR           = 0x0300
	ZERO                = 0

	DST_COLOR           = 0x0306
	ONE_MINUS_DST_COLOR = 0x0307
	SRC_ALPHA_SATURATE  = 0x0308

	BACK           = 0x0405
	FRONT          = 0x0404
	FRONT_AND_BACK = 0x0408

	BLEND               = 0x0BE2
	CULL_FACE           = 0x0B44
	DEPTH_TEST          = 0x0B71
	DITHER              = 0x0BD0
	POLYGON_OFFSET_FILL = 0x8037
	SCISSOR_TEST        = 0x0C11
	STENCIL_TEST        = 0x0B90
	TEXTURE_2D          = 0x0DE1

	INVALID_ENUM                  = 0x0500
	INVALID_FRAMEBUFFER_OPERATION = 0x0506
	INVALID_OPERATION             = 0x0502
	INVALID_VALUE                 = 0x0501
	NO_ERROR                      = 0
	OUT_OF_MEMORY                 = 0x0505

	LINEAR = 0x2601

	CCW = 0x0901
	CW  = 0x0900

	ALIASED_LINE_WIDTH_RANGE = 0x846E
	ALIASED_POINT_SIZE_RANGE = 0x846D
	ALPHA_BITS               = 0x0D55
	BLUE_BITS                = 0x0D54
	COLOR_CLEAR_VALUE        = 0x0C22
	COLOR_WRITEMASK          = 0x0C23
	CULL_FACE_MODE           = 0x0B45
	DEPTH_BITS               = 0x0D56
	DEPTH_CLEAR_VALUE        = 0x0B73
	DEPTH_FUNC               = 0x0B74
	DEPTH_RANGE              = 0x0B70
	DEPTH_WRITEMASK          = 0x0B72
	FRONT_FACE               = 0x0B46
	GREEN_BITS               = 0x0D53
	LINE_WIDTH               = 0x0B21
	MAX_TEXTURE_SIZE         = 0x0D33
	MAX_VIEWPORT_DIMS        = 0x0D3A
	PACK_ALIGNMENT           = 0x0D05
	POLYGON_OFFSET_FACTOR    = 0x8038
	POLYGON_OFFSET_UNITS     = 0x2A00
	RED_BITS                 = 0x0D52
	SCISSOR_BOX              = 0x0C10
	STENCIL_BITS             = 0x0D57
	STENCIL_CLEAR_VALUE      = 0x0B91
	STENCIL_FAIL             = 0x0B94
	STENCIL_FUNC             = 0x0B92
	STENCIL_PASS_DEPTH_FAIL  = 0x0B95
	STENCIL_PASS_DEPTH_PASS  = 0x0B96
	STENCIL_REF              = 0x0B97
	STENCIL_VALUE_MASK       = 0x0B93
	STENCIL_WRITEMASK        = 0x0B98
	SUBPIXEL_BITS            = 0x0D50
	TEXTURE_BINDING_2D       = 0x8069
	UNPACK_ALIGNMENT         = 0x0CF5
	VIEWPORT                 = 0x0BA2

	TEXTURE_MAG_FILTER = 0x2800
	TEXTURE_MIN_FILTER = 0x2801
	TEXTURE_WRAP_S     = 0x2802
	TEXTURE_WRAP_T     = 0x2803

	DONT_CARE = 0x1100
	FASTEST   = 0x1101
	NICEST    = 0x1102

	GENERATE_MIPMAP_HINT = 0x8192

	REPLACE = 0x1E01

	INVERT = 0x150A

	TEXTURE = 0x1702

	ALPHA           = 0x1906
	DEPTH_COMPONENT = 0x1902
	LUMINANCE       = 0x1909
	LUMINANCE_ALPHA = 0x190A
	RGB             = 0x1907
	RGBA            = 0x1908

	RGB5_A1 = 0x8057
	RGBA4   = 0x8056

	UNSIGNED_SHORT_4_4_4_4 = 0x8033
	UNSIGNED_SHORT_5_5_5_1 = 0x8034

	LINES          = 0x0001
	LINE_LOOP      = 0x0002
	LINE_STRIP     = 0x0003
	POINTS         = 0x0000
	TRIANGLES      = 0x0004
	TRIANGLE_FAN   = 0x0006
	TRIANGLE_STRIP = 0x0005

	DECR = 0x1E03
	INCR = 0x1E02
	KEEP = 0x1E00

	EXTENSIONS = 0x1F03
	RENDERER   = 0x1F01
	VENDOR     = 0x1F00
	VERSION    = 0x1F02

	NEAREST = 0x2600

	LINEAR_MIPMAP_LINEAR   = 0x2703
	LINEAR_MIPMAP_NEAREST  = 0x2701
	NEAREST_MIPMAP_LINEAR  = 0x2702
	NEAREST_MIPMAP_NEAREST = 0x2700

	CLAMP_TO_EDGE = 0x812F
	REPEAT        = 0x2901

	CONSTANT_COLOR                               = 0x8001
	ONE_MINUS_CONSTANT_COLOR                     = 0x8002
	CONSTANT_ALPHA                               = 0x8003
	ONE_MINUS_CONSTANT_ALPHA                     = 0x8004
	BLEND_COLOR                                  = 0x8005
	FUNC_ADD                                     = 0x8006
	BLEND_EQUATION                               = 0x8009
	BLEND_EQUATION_RGB                           = 0x8009
	FUNC_SUBTRACT                                = 0x800A
	FUNC_REVERSE_SUBTRACT                        = 0x800B
	SAMPLE_ALPHA_TO_COVERAGE                     = 0x809E
	SAMPLE_COVERAGE                              = 0x80A0
	SAMPLE_BUFFERS                               = 0x80A8
	SAMPLES                                      = 0x80A9
	SAMPLE_COVERAGE_VALUE                        = 0x80AA
	SAMPLE_COVERAGE_INVERT                       = 0x80AB
	BLEND_DST_RGB                                = 0x80C8
	BLEND_SRC_RGB                                = 0x80C9
	BLEND_DST_ALPHA                              = 0x80CA
	BLEND_SRC_ALPHA                              = 0x80CB
	DEPTH_COMPONENT16                            = 0x81A5
	UNSIGNED_SHORT_5_6_5                         = 0x8363
	MIRRORED_REPEAT                              = 0x8370
	TEXTURE0                                     = 0x84C0
	TEXTURE1                                     = 0x84C1
	TEXTURE2                                     = 0x84C2
	TEXTURE3                                     = 0x84C3
	TEXTURE4                                     = 0x84C4
	TEXTURE5                                     = 0x84C5
	TEXTURE6                                     = 0x84C6
	TEXTURE7                                     = 0x84C7
	TEXTURE8                                     = 0x84C8
	TEXTURE9                                     = 0x84C9
	TEXTURE10                                    = 0x84CA
	TEXTURE11                                    = 0x84CB
	TEXTURE12                                    = 0x84CC
	TEXTURE13                                    = 0x84CD
	TEXTURE14                                    = 0x84CE
	TEXTURE15                                    = 0x84CF
	TEXTURE16                                    = 0x84D0
	TEXTURE17                                    = 0x84D1
	TEXTURE18                                    = 0x84D2
	TEXTURE19                                    = 0x84D3
	TEXTURE20                                    = 0x84D4
	TEXTURE21                                    = 0x84D5
	TEXTURE22                                    = 0x84D6
	TEXTURE23                                    = 0x84D7
	TEXTURE24                                    = 0x84D8
	TEXTURE25                                    = 0x84D9
	TEXTURE26                                    = 0x84DA
	TEXTURE27                                    = 0x84DB
	TEXTURE28                                    = 0x84DC
	TEXTURE29                                    = 0x84DD
	TEXTURE30                                    = 0x84DE
	TEXTURE31                                    = 0x84DF
	ACTIVE_TEXTURE                               = 0x84E0
	MAX_RENDERBUFFER_SIZE                        = 0x84E8
	INCR_WRAP                                    = 0x8507
	DECR_WRAP                                    = 0x8508
	TEXTURE_CUBE_MAP                             = 0x8513
	TEXTURE_BINDING_CUBE_MAP                     = 0x8514
	TEXTURE_CUBE_MAP_POSITIVE_X                  = 0x8515
	TEXTURE_CUBE_MAP_NEGATIVE_X                  = 0x8516
	TEXTURE_CUBE_MAP_POSITIVE_Y                  = 0x8517
	TEXTURE_CUBE_MAP_NEGATIVE_Y                  = 0x8518
	TEXTURE_CUBE_MAP_POSITIVE_Z                  = 0x8519
	TEXTURE_CUBE_MAP_NEGATIVE_Z                  = 0x851A
	MAX_CUBE_MAP_TEXTURE_SIZE                    = 0x851C
	VERTEX_ATTRIB_ARRAY_ENABLED                  = 0x8622
	VERTEX_ATTRIB_ARRAY_SIZE                     = 0x8623
	VERTEX_ATTRIB_ARRAY_STRIDE                   = 0x8624
	VERTEX_ATTRIB_ARRAY_TYPE                     = 0x8625
	CURRENT_VERTEX_ATTRIB                        = 0x8626
	VERTEX_ATTRIB_ARRAY_POINTER                  = 0x8645
	NUM_COMPRESSED_TEXTURE_FORMATS               = 0x86A2
	COMPRESSED_TEXTURE_FORMATS                   = 0x86A3
	BUFFER_SIZE                                  = 0x8764
	BUFFER_USAGE                                 = 0x8765
	STENCIL_BACK_FUNC                            = 0x8800
	STENCIL_BACK_FAIL                            = 0x8801
	STENCIL_BACK_PASS_DEPTH_FAIL                 = 0x8802
	STENCIL_BACK_PASS_DEPTH_PASS                 = 0x8803
	BLEND_EQUATION_ALPHA                         = 0x883D
	MAX_VERTEX_ATTRIBS                           = 0x8869
	VERTEX_ATTRIB_ARRAY_NORMALIZED               = 0x886A
	MAX_TEXTURE_IMAGE_UNITS                      = 0x8872
	ARRAY_BUFFER                                 = 0x8892
	ELEMENT_ARRAY_BUFFER                         = 0x8893
	ARRAY_BUFFER_BINDING                         = 0x8894
	ELEMENT_ARRAY_BUFFER_BINDING                 = 0x8895
	VERTEX_ATTRIB_ARRAY_BUFFER_BINDING           = 0x889F
	STREAM_DRAW                                  = 0x88E0
	STATIC_DRAW                                  = 0x88E4
	DYNAMIC_DRAW                                 = 0x88E8
	FRAGMENT_SHADER                              = 0x8B30
	VERTEX_SHADER                                = 0x8B31
	MAX_VERTEX_TEXTURE_IMAGE_UNITS               = 0x8B4C
	MAX_COMBINED_TEXTURE_IMAGE_UNITS             = 0x8B4D
	SHADER_TYPE                                  = 0x8B4F
	FLOAT_VEC2                                   = 0x8B50
	FLOAT_VEC3                                   = 0x8B51
	FLOAT_VEC4                                   = 0x8B52
	INT_VEC2                                     = 0x8B53
	INT_VEC3                                     = 0x8B54
	INT_VEC4                                     = 0x8B55
	BOOL                                         = 0x8B56
	BOOL_VEC2                                    = 0x8B57
	BOOL_VEC3                                    = 0x8B58
	BOOL_VEC4                                    = 0x8B59
	FLOAT_MAT2                                   = 0x8B5A
	FLOAT_MAT3                                   = 0x8B5B
	FLOAT_MAT4                                   = 0x8B5C
	SAMPLER_2D                                   = 0x8B5E
	SAMPLER_CUBE                                 = 0x8B60
	DELETE_STATUS                                = 0x8B80
	COMPILE_STATUS                               = 0x8B81
	LINK_STATUS                                  = 0x8B82
	VALIDATE_STATUS                              = 0x8B83
	INFO_LOG_LENGTH                              = 0x8B84
	ATTACHED_SHADERS                             = 0x8B85
	ACTIVE_UNIFORMS                              = 0x8B86
	ACTIVE_UNIFORM_MAX_LENGTH                    = 0x8B87
	SHADER_SOURCE_LENGTH                         = 0x8B88
	ACTIVE_ATTRIBUTES                            = 0x8B89
	ACTIVE_ATTRIBUTE_MAX_LENGTH                  = 0x8B8A
	SHADING_LANGUAGE_VERSION                     = 0x8B8C
	CURRENT_PROGRAM                              = 0x8B8D
	IMPLEMENTATION_COLOR_READ_TYPE               = 0x8B9A
	IMPLEMENTATION_COLOR_READ_FORMAT             = 0x8B9B
	STENCIL_BACK_REF                             = 0x8CA3
	STENCIL_BACK_VALUE_MASK                      = 0x8CA4
	STENCIL_BACK_WRITEMASK                       = 0x8CA5
	FRAMEBUFFER_BINDING                          = 0x8CA6
	RENDERBUFFER_BINDING                         = 0x8CA7
	FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE           = 0x8CD0
	FRAMEBUFFER_ATTACHMENT_OBJECT_NAME           = 0x8CD1
	FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL         = 0x8CD2
	FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3
	FRAMEBUFFER_COMPLETE                         = 0x8CD5
	FRAMEBUFFER_INCOMPLETE_ATTACHMENT            = 0x8CD6
	FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT    = 0x8CD7
	FRAMEBUFFER_INCOMPLETE_DIMENSIONS            = 0x8CD9
	FRAMEBUFFER_UNSUPPORTED                      = 0x8CDD
	COLOR_ATTACHMENT0                            = 0x8CE0
	DEPTH_ATTACHMENT                             = 0x8D00
	STENCIL_ATTACHMENT                           = 0x8D20
	FRAMEBUFFER                                  = 0x8D40
	RENDERBUFFER                                 = 0x8D41
	RENDERBUFFER_WIDTH                           = 0x8D42
	RENDERBUFFER_HEIGHT                          = 0x8D43
	RENDERBUFFER_INTERNAL_FORMAT                 = 0x8D44
	STENCIL_INDEX8                               = 0x8D48
	RENDERBUFFER_RED_SIZE                        = 0x8D50
	RENDERBUFFER_GREEN_SIZE                      = 0x8D51
	RENDERBUFFER_BLUE_SIZE                       = 0x8D52
	RENDERBUFFER_ALPHA_SIZE                      = 0x8D53
	RENDERBUFFER_DEPTH_SIZE                      = 0x8D54
	RENDERBUFFER_STENCIL_SIZE                    = 0x8D55
	RGB565                                       = 0x8D62
	LOW_FLOAT                                    = 0x8DF0
	MEDIUM_FLOAT                                 = 0x8DF1
	HIGH_FLOAT                                   = 0x8DF2
	LOW_INT                                      = 0x8DF3
	MEDIUM_INT                                   = 0x8DF4
	HIGH_INT                                     = 0x8DF5
	SHADER_BINARY_FORMATS                        = 0x8DF8
	NUM_SHADER_BINARY_FORMATS                    = 0x8DF9
	SHADER_COMPILER                              = 0x8DFA
	MAX_VERTEX_UNIFORM_VECTORS                   = 0x8DFB
	MAX_VARYING_VECTORS                          = 0x8DFC
	MAX_FRAGMENT_UNIFORM_VECTORS                 = 0x8DFD
)

// https://www.opengl.org/sdk/docs/man2/xhtml/glActiveTexture.xml
func (gl *GL) ActiveTexture(texture glbase.Enum) {
	C.gles2_glActiveTexture(gl.funcs, C.GLenum(texture))
}

// AttachShader attaches a shader object to a program object.
//
// In order to create an executable, there must be a way to specify the list
// of things that will be linked together. Program objects provide this
// mechanism. Shaders that are to be linked together in a program object must
// first be attached to that program object. This indicates that shader will
// be included in link operations that will be performed on program.
//
// All operations that can be performed on a shader object are valid whether
// or not the shader object is attached to a program object. It is
// permissible to attach a shader object to a program object before source
// code has been loaded into the shader object or before the shader object
// has been compiled. It is permissible to attach multiple shader objects of
// the same type because each may contain a portion of the complete shader.
// It is also permissible to attach a shader object to more than one program
// object. If a shader object is deleted while it is attached to a program
// object, it will be flagged for deletion, and deletion will not occur until
// DetachShader is called to detach it from all program objects to which it
// is attached.
//
// Error GL.INVALID_VALUE is generated if either program or shader is not a
// value generated by OpenGL. GL.INVALID_OPERATION is generated if program
// is not a program object. GL.INVALID_OPERATION is generated if shader is
// not a shader object. GL.INVALID_OPERATION is generated if shader is
// already attached to program. GL.INVALID_OPERATION is generated if
// AttachShader is executed between the execution of Begin and the
// corresponding execution of End.
//
// AttachShader is available in GL version 2.0 or greater.
func (gl *GL) AttachShader(program glbase.Program, shader glbase.Shader) {
	C.gles2_glAttachShader(gl.funcs, C.GLuint(program), C.GLuint(shader))
}

// BindAttribLocation associates a user-defined attribute variable in the program
// object specified by program with a generic vertex attribute index. The name
// parameter specifies the name of the vertex shader attribute variable to
// which index is to be bound. When program is made part of the current state,
// values provided via the generic vertex attribute index will modify the
// value of the user-defined attribute variable specified by name.
//
// If name refers to a matrix attribute variable, index refers to the first
// column of the matrix. Other matrix columns are then automatically bound to
// locations index+1 for a matrix of type mat2; index+1 and index+2 for a
// matrix of type mat3; and index+1, index+2, and index+3 for a matrix of
// type mat4.
//
// This command makes it possible for vertex shaders to use descriptive names
// for attribute variables rather than generic variables that are numbered
// from 0 to GL.MAX_VERTEX_ATTRIBS-1. The values sent to each generic
// attribute index are part of current state, just like standard vertex
// attributes such as color, normal, and vertex position. If a different
// program object is made current by calling UseProgram, the generic vertex
// attributes are tracked in such a way that the same values will be observed
// by attributes in the new program object that are also bound to index.
//
// Attribute variable name-to-generic attribute index bindings for a program
// object can be explicitly assigned at any time by calling
// BindAttribLocation. Attribute bindings do not go into effect until
// LinkProgram is called. After a program object has been linked
// successfully, the index values for generic attributes remain fixed (and
// their values can be queried) until the next link command occurs.
//
// Applications are not allowed to bind any of the standard OpenGL vertex
// attributes using this command, as they are bound automatically when
// needed. Any attribute binding that occurs after the program object has
// been linked will not take effect until the next time the program object is
// linked.
//
// If name was bound previously, that information is lost. Thus you cannot
// bind one user-defined attribute variable to multiple indices, but you can
// bind multiple user-defined attribute variables to the same index.
//
// Applications are allowed to bind more than one user-defined attribute
// variable to the same generic vertex attribute index. This is called
// aliasing, and it is allowed only if just one of the aliased attributes is
// active in the executable program, or if no path through the shader
// consumes more than one attribute of a set of attributes aliased to the
// same location. The compiler and linker are allowed to assume that no
// aliasing is done and are free to employ optimizations that work only in
// the absence of aliasing. OpenGL implementations are not required to do
// error checking to detect aliasing. Because there is no way to bind
// standard attributes, it is not possible to alias generic attributes with
// conventional ones (except for generic attribute 0).
//
// BindAttribLocation can be called before any vertex shader objects are
// bound to the specified program object. It is also permissible to bind a
// generic attribute index to an attribute variable name that is never used
// in a vertex shader.
//
// Active attributes that are not explicitly bound will be bound by the
// linker when LinkProgram is called. The locations assigned can be queried
// by calling GetAttribLocation.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS.
// GL.INVALID_OPERATION is generated if name starts with the reserved prefix "gl_".
// GL.INVALID_VALUE is generated if program is not a value generated by OpenGL.
// GL.INVALID_OPERATION is generated if program is not a program object.
// GL.INVALID_OPERATION is generated if BindAttribLocation is executed
// between the execution of Begin and the corresponding execution of End.
//
// BindAttribLocation is available in GL version 2.0 or greater.
func (gl *GL) BindAttribLocation(program glbase.Program, index glbase.Attrib, name string) {
	name_cstr := C.CString(name)
	C.gles2_glBindAttribLocation(gl.funcs, C.GLuint(program), C.GLuint(index), (*C.GLchar)(name_cstr))
	C.free(unsafe.Pointer(name_cstr))
}

// BindBuffer creates or puts in use a named buffer object.
// Calling BindBuffer with target set to GL.ARRAY_BUFFER,
// GL.ELEMENT_ARRAY_BUFFER, GL.PIXEL_PACK_BUFFER or GL.PIXEL_UNPACK_BUFFER
// and buffer set to the name of the new buffer object binds the buffer
// object name to the target. When a buffer object is bound to a target, the
// previous binding for that target is automatically broken.
//
// Buffer object names are unsigned integers. The value zero is reserved, but
// there is no default buffer object for each buffer object target. Instead,
// buffer set to zero effectively unbinds any buffer object previously bound,
// and restores client memory usage for that buffer object target. Buffer
// object names and the corresponding buffer object contents are local to the
// shared display-list space (see XCreateContext) of the current GL rendering
// context; two rendering contexts share buffer object names only if they
// also share display lists.
//
// GenBuffers may be called to generate a set of new buffer object names.
//
// The state of a buffer object immediately after it is first bound is an
// unmapped zero-sized memory buffer with GL.READ_WRITE access and
// GL.STATIC_DRAW usage.
//
// While a non-zero buffer object name is bound, GL operations on the target
// to which it is bound affect the bound buffer object, and queries of the
// target to which it is bound return state from the bound buffer object.
// While buffer object name zero is bound, as in the initial state, attempts
// to modify or query state on the target to which it is bound generates an
// GL.INVALID_OPERATION error.
//
// When vertex array pointer state is changed, for example by a call to
// NormalPointer, the current buffer object binding (GL.ARRAY_BUFFER_BINDING)
// is copied into the corresponding client state for the vertex array type
// being changed, for example GL.NORMAL_ARRAY_BUFFER_BINDING. While a
// non-zero buffer object is bound to the GL.ARRAY_BUFFER target, the vertex
// array pointer parameter that is traditionally interpreted as a pointer to
// client-side memory is instead interpreted as an offset within the buffer
// object measured in basic machine units.
//
// While a non-zero buffer object is bound to the GL.ELEMENT_ARRAY_BUFFER
// target, the indices parameter of DrawElements, DrawRangeElements, or
// MultiDrawElements that is traditionally interpreted as a pointer to
// client-side memory is instead interpreted as an offset within the buffer
// object measured in basic machine units.
//
// While a non-zero buffer object is bound to the GL.PIXEL_PACK_BUFFER
// target, the following commands are affected: GetCompressedTexImage,
// GetConvolutionFilter, GetHistogram, GetMinmax, GetPixelMap,
// GetPolygonStipple, GetSeparableFilter, GetTexImage, and ReadPixels. The
// pointer parameter that is traditionally interpreted as a pointer to
// client-side memory where the pixels are to be packed is instead
// interpreted as an offset within the buffer object measured in basic
// machine units.
//
// While a non-zero buffer object is bound to the GL.PIXEL_UNPACK_BUFFER
// target, the following commands are affected: Bitmap, ColorSubTable,
// ColorTable, CompressedTexImage1D, CompressedTexImage2D,
// CompressedTexImage3D, CompressedTexSubImage1D, CompressedTexSubImage2D,
// CompressedTexSubImage3D, ConvolutionFilter1D, ConvolutionFilter2D,
// DrawPixels, PixelMap, PolygonStipple, SeparableFilter2D, TexImage1D,
// TexImage2D, TexImage3D, TexSubImage1D, TexSubImage2D, and TexSubImage3D.
// The pointer parameter that is traditionally interpreted as a pointer to
// client-side memory from which the pixels are to be unpacked is instead
// interpreted as an offset within the buffer object measured in basic
// machine units.
//
// A buffer object binding created with BindBuffer remains active until a
// different buffer object name is bound to the same target, or until the
// bound buffer object is deleted with DeleteBuffers.
//
// Once created, a named buffer object may be re-bound to any target as often
// as needed. However, the GL implementation may make choices about how to
// optimize the storage of a buffer object based on its initial binding
// target.
//
// Error GL.INVALID_ENUM is generated if target is not one of the allowable
// values.  GL.INVALID_OPERATION is generated if BindBuffer is executed
// between the execution of Begin and the corresponding execution of End.
//
// BindBuffer is available in GL version 1.5 or greater.
func (gl *GL) BindBuffer(target glbase.Enum, buffer glbase.Buffer) {
	C.gles2_glBindBuffer(gl.funcs, C.GLenum(target), C.GLuint(buffer))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBindFramebuffer.xml
func (gl *GL) BindFramebuffer(target glbase.Enum, framebuffer glbase.Framebuffer) {
	C.gles2_glBindFramebuffer(gl.funcs, C.GLenum(target), C.GLuint(framebuffer))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBindRenderbuffer.xml
func (gl *GL) BindRenderbuffer(target glbase.Enum, renderbuffer glbase.Renderbuffer) {
	C.gles2_glBindRenderbuffer(gl.funcs, C.GLenum(target), C.GLuint(renderbuffer))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendColor.xml
func (gl *GL) BlendColor(red, green, blue, alpha glbase.Clampf) {
	C.gles2_glBlendColor(gl.funcs, C.GLclampf(red), C.GLclampf(green), C.GLclampf(blue), C.GLclampf(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquation.xml
func (gl *GL) BlendEquation(mode glbase.Enum) {
	C.gles2_glBlendEquation(gl.funcs, C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquationSeparate.xml
func (gl *GL) BlendEquationSeparate(modeRGB, modeAlpha glbase.Enum) {
	C.gles2_glBlendEquationSeparate(gl.funcs, C.GLenum(modeRGB), C.GLenum(modeAlpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFuncSeparate.xml
func (gl *GL) BlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha glbase.Enum) {
	C.gles2_glBlendFuncSeparate(gl.funcs, C.GLenum(srcRGB), C.GLenum(dstRGB), C.GLenum(srcAlpha), C.GLenum(dstAlpha))
}

// BufferData creates a new data store for the buffer object currently
// bound to target. Any pre-existing data store is deleted. The new data
// store is created with the specified size in bytes and usage. If data is
// not nil, it must be a slice that is used to initialize the data store.
// In that case the size parameter is ignored and the store size will match
// the slice data size.
//
// In its initial state, the new data store is not mapped, it has a NULL
// mapped pointer, and its mapped access is GL.READ_WRITE.
//
// The target constant must be one of GL.ARRAY_BUFFER, GL.COPY_READ_BUFFER,
// GL.COPY_WRITE_BUFFER, GL.ELEMENT_ARRAY_BUFFER, GL.PIXEL_PACK_BUFFER,
// GL.PIXEL_UNPACK_BUFFER, GL.TEXTURE_BUFFER, GL.TRANSFORM_FEEDBACK_BUFFER,
// or GL.UNIFORM_BUFFER.
//
// The usage parameter is a hint to the GL implementation as to how a buffer
// object's data store will be accessed. This enables the GL implementation
// to make more intelligent decisions that may significantly impact buffer
// object performance. It does not, however, constrain the actual usage of
// the data store. usage can be broken down into two parts: first, the
// frequency of access (modification and usage), and second, the nature of
// that access.
//
// A usage frequency of STREAM and nature of DRAW is specified via the
// constant GL.STREAM_DRAW, for example.
//
// The usage frequency of access may be one of:
//
//   STREAM
//       The data store contents will be modified once and used at most a few times.
//
//   STATIC
//       The data store contents will be modified once and used many times.
//
//   DYNAMIC
//       The data store contents will be modified repeatedly and used many times.
//
// The usage nature of access may be one of:
//
//   DRAW
//       The data store contents are modified by the application, and used as
//       the source for GL drawing and image specification commands.
//
//   READ
//       The data store contents are modified by reading data from the GL,
//       and used to return that data when queried by the application.
//
//   COPY
//       The data store contents are modified by reading data from the GL,
//       and used as the source for GL drawing and image specification
//       commands.
//
// Clients must align data elements consistent with the requirements of the
// client platform, with an additional base-level requirement that an offset
// within a buffer to a datum comprising N bytes be a multiple of N.
//
// Error GL.INVALID_ENUM is generated if target is not one of the accepted
// buffer targets.  GL.INVALID_ENUM is generated if usage is not
// GL.STREAM_DRAW, GL.STREAM_READ, GL.STREAM_COPY, GL.STATIC_DRAW,
// GL.STATIC_READ, GL.STATIC_COPY, GL.DYNAMIC_DRAW, GL.DYNAMIC_READ, or
// GL.DYNAMIC_COPY.  GL.INVALID_VALUE is generated if size is negative.
// GL.INVALID_OPERATION is generated if the reserved buffer object name 0 is
// bound to target.  GL.OUT_OF_MEMORY is generated if the GL is unable to
// create a data store with the specified size.
func (gl *GL) BufferData(target glbase.Enum, size int, data interface{}, usage glbase.Enum) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	if data != nil {
		size = int(data_v.Type().Size()) * data_v.Len()
	}
	C.gles2_glBufferData(gl.funcs, C.GLenum(target), C.GLsizeiptr(size), data_ptr, C.GLenum(usage))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBufferSubData.xml
func (gl *GL) BufferSubData(target glbase.Enum, offset, size int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gles2_glBufferSubData(gl.funcs, C.GLenum(target), C.GLintptr(offset), C.GLsizeiptr(size), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCheckFramebufferStatus.xml
func (gl *GL) CheckFramebufferStatus(target glbase.Enum) glbase.Enum {
	glresult := C.gles2_glCheckFramebufferStatus(gl.funcs, C.GLenum(target))
	return glbase.Enum(glresult)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearDepthf.xml
func (gl *GL) ClearDepthf(depth glbase.Clampf) {
	C.gles2_glClearDepthf(gl.funcs, C.GLclampf(depth))
}

// CompileShader compiles the source code strings that have been stored in
// the shader object specified by shader.
//
// The compilation status will be stored as part of the shader object's
// state. This value will be set to GL.TRUE if the shader was compiled without
// errors and is ready for use, and GL.FALSE otherwise. It can be queried by
// calling GetShaderiv with arguments shader and GL.COMPILE_STATUS.
//
// Compilation of a shader can fail for a number of reasons as specified by
// the OpenGL Shading Language Specification. Whether or not the compilation
// was successful, information about the compilation can be obtained from the
// shader object's information log by calling GetShaderInfoLog.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL.  GL.INVALID_OPERATION is generated if shader is not a shader
// object.  GL.INVALID_OPERATION is generated if CompileShader is executed
// between the execution of Begin and the corresponding execution of End.
//
// CompileShader is available in GL version 2.0 or greater.
func (gl *GL) CompileShader(shader glbase.Shader) {
	C.gles2_glCompileShader(gl.funcs, C.GLuint(shader))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage2D.xml
func (gl *GL) CompressedTexImage2D(target glbase.Enum, level int, internalFormat glbase.Enum, width, height, border, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gles2_glCompressedTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLint(border), C.GLsizei(imageSize), data_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage2D.xml
func (gl *GL) CompressedTexSubImage2D(target glbase.Enum, level, xoffset, yoffset, width, height int, format glbase.Enum, imageSize int, data interface{}) {
	var data_ptr unsafe.Pointer
	var data_v = reflect.ValueOf(data)
	if data != nil && data_v.Kind() != reflect.Slice {
		panic("parameter data must be a slice")
	}
	if data != nil {
		data_ptr = unsafe.Pointer(data_v.Index(0).Addr().Pointer())
	}
	C.gles2_glCompressedTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLsizei(imageSize), data_ptr)
}

// CreateProgram creates an empty program object and returns a non-zero
// value by which it can be referenced. A program object is an object to
// which shader objects can be attached. This provides a mechanism to specify
// the shader objects that will be linked to create a program. It also
// provides a means for checking the compatibility of the shaders that will
// be used to create a program (for instance, checking the compatibility
// between a vertex shader and a fragment shader). When no longer needed as
// part of a program object, shader objects can be detached.
//
// One or more executables are created in a program object by successfully
// attaching shader objects to it with AttachShader, successfully compiling
// the shader objects with CompileShader, and successfully linking the
// program object with LinkProgram. These executables are made part of
// current state when UseProgram is called. Program objects can be deleted
// by calling DeleteProgram. The memory associated with the program object
// will be deleted when it is no longer part of current rendering state for
// any context.
//
// Like display lists and texture objects, the name space for program objects
// may be shared across a set of contexts, as long as the server sides of the
// contexts share the same address space. If the name space is shared across
// contexts, any attached objects and the data associated with those attached
// objects are shared as well.
//
// Applications are responsible for providing the synchronization across API
// calls when objects are accessed from different execution threads.
//
// This function returns 0 if an error occurs creating the program object.
//
// Error GL.INVALID_OPERATION is generated if CreateProgram is executed
// between the execution of Begin and the corresponding execution of End.
//
// CreateProgram is available in GL version 2.0 or greater.
func (gl *GL) CreateProgram() glbase.Program {
	glresult := C.gles2_glCreateProgram(gl.funcs)
	return glbase.Program(glresult)
}

// CreateShader creates an empty shader object and returns a non-zero value
// by which it can be referenced. A shader object is used to maintain the
// source code strings that define a shader. shaderType indicates the type of
// shader to be created.
//
// Two types of shaders are supported. A shader of type GL.VERTEX_SHADER is a
// shader that is intended to run on the programmable vertex processor and
// replace the fixed functionality vertex processing in OpenGL. A shader of
// type GL.FRAGMENT_SHADER is a shader that is intended to run on the
// programmable fragment processor and replace the fixed functionality
// fragment processing in OpenGL.
//
// When created, a shader object's GL.SHADER_TYPE parameter is set to either
// GL.VERTEX_SHADER or GL.FRAGMENT_SHADER, depending on the value of
// shaderType.
//
// Like display lists and texture objects, the name space for shader objects
// may be shared across a set of contexts, as long as the server sides of the
// contexts share the same address space. If the name space is shared across
// contexts, any attached objects and the data associated with those attached
// objects are shared as well.
//
// This function returns 0 if an error occurs creating the shader object.
//
// Error GL.INVALID_ENUM is generated if shaderType is not an accepted value.
// GL.INVALID_OPERATION is generated if CreateShader is executed between the
// execution of Begin and the corresponding execution of End.
//
// CreateShader is available in GL version 2.0 or greater.
func (gl *GL) CreateShader(gltype glbase.Enum) glbase.Shader {
	glresult := C.gles2_glCreateShader(gl.funcs, C.GLenum(gltype))
	return glbase.Shader(glresult)
}

// DeleteBuffers deletes the buffer objects whose names are stored in the
// buffers slice.
//
// After a buffer object is deleted, it has no contents, and its name is free
// for reuse (for example by GenBuffers). If a buffer object that is
// currently bound is deleted, the binding reverts to 0 (the absence of any
// buffer object, which reverts to client memory usage).
//
// DeleteBuffers silently ignores 0's and names that do not correspond to
// existing buffer objects.
//
// Error GL.INVALID_VALUE is generated if n is negative. GL.INVALID_OPERATION
// is generated if DeleteBuffers is executed between the execution of Begin
// and the corresponding execution of End.
//
// DeleteBuffers is available in GL version 1.5 or greater.
func (gl *GL) DeleteBuffers(buffers []glbase.Buffer) {
	n := len(buffers)
	if n == 0 {
		return
	}
	C.gles2_glDeleteBuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&buffers[0])))
}

// DeleteFramebuffers deletes the framebuffer objects whose names are
// stored in the framebuffers slice. The name zero is reserved by the GL and
// is silently ignored, should it occur in framebuffers, as are other unused
// names. Once a framebuffer object is deleted, its name is again unused and
// it has no attachments. If a framebuffer that is currently bound to one or
// more of the targets GL.DRAW_FRAMEBUFFER or GL.READ_FRAMEBUFFER is deleted,
// it is as though BindFramebuffer had been executed with the corresponding
// target and framebuffer zero.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteFramebuffers is available in GL version 3.0 or greater.
func (gl *GL) DeleteFramebuffers(framebuffers []glbase.Framebuffer) {
	n := len(framebuffers)
	if n == 0 {
		return
	}
	C.gles2_glDeleteFramebuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&framebuffers[0])))
}

// DeleteProgram frees the memory and invalidates the name associated with
// the program object specified by program. This command effectively undoes
// the effects of a call to CreateProgram.
//
// If a program object is in use as part of current rendering state, it will
// be flagged for deletion, but it will not be deleted until it is no longer
// part of current state for any rendering context. If a program object to be
// deleted has shader objects attached to it, those shader objects will be
// automatically detached but not deleted unless they have already been
// flagged for deletion by a previous call to DeleteShader. A value of 0
// for program will be silently ignored.
//
// To determine whether a program object has been flagged for deletion, call
// GetProgram with arguments program and GL.DELETE_STATUS.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL.
//
// DeleteProgram is available in GL version 2.0 or greater.
func (gl *GL) DeleteProgram(program glbase.Program) {
	C.gles2_glDeleteProgram(gl.funcs, C.GLuint(program))
}

// DeleteRenderbuffers deletes the renderbuffer objects whose names are stored
// in the renderbuffers slice. The name zero is reserved by the GL and
// is silently ignored, should it occur in renderbuffers, as are other unused
// names. Once a renderbuffer object is deleted, its name is again unused and
// it has no contents. If a renderbuffer that is currently bound to the
// target GL.RENDERBUFFER is deleted, it is as though BindRenderbuffer had
// been executed with a target of GL.RENDERBUFFER and a name of zero.
//
// If a renderbuffer object is attached to one or more attachment points in
// the currently bound framebuffer, then it as if FramebufferRenderbuffer
// had been called, with a renderbuffer of zero for each attachment point to
// which this image was attached in the currently bound framebuffer. In other
// words, this renderbuffer object is first detached from all attachment
// ponits in the currently bound framebuffer. Note that the renderbuffer
// image is specifically not detached from any non-bound framebuffers.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteRenderbuffers is available in GL version 3.0 or greater.
func (gl *GL) DeleteRenderbuffers(renderbuffers []glbase.Renderbuffer) {
	n := len(renderbuffers)
	if n == 0 {
		return
	}
	C.gles2_glDeleteRenderbuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&renderbuffers[0])))
}

// DeleteShader frees the memory and invalidates the name associated with
// the shader object specified by shader. This command effectively undoes the
// effects of a call to CreateShader.
//
// If a shader object to be deleted is attached to a program object, it will
// be flagged for deletion, but it will not be deleted until it is no longer
// attached to any program object, for any rendering context (it must
// be detached from wherever it was attached before it will be deleted). A
// value of 0 for shader will be silently ignored.
//
// To determine whether an object has been flagged for deletion, call
// GetShader with arguments shader and GL.DELETE_STATUS.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL.
//
// DeleteShader is available in GL version 2.0 or greater.
func (gl *GL) DeleteShader(shader glbase.Shader) {
	C.gles2_glDeleteShader(gl.funcs, C.GLuint(shader))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDepthRangef.xml
func (gl *GL) DepthRangef(zNear, zFar glbase.Clampf) {
	C.gles2_glDepthRangef(gl.funcs, C.GLclampf(zNear), C.GLclampf(zFar))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDetachShader.xml
func (gl *GL) DetachShader(program glbase.Program, shader glbase.Shader) {
	C.gles2_glDetachShader(gl.funcs, C.GLuint(program), C.GLuint(shader))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDisableVertexAttribArray.xml
func (gl *GL) DisableVertexAttribArray(index glbase.Attrib) {
	C.gles2_glDisableVertexAttribArray(gl.funcs, C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEnableVertexAttribArray.xml
func (gl *GL) EnableVertexAttribArray(index glbase.Attrib) {
	C.gles2_glEnableVertexAttribArray(gl.funcs, C.GLuint(index))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFramebufferRenderbuffer.xml
func (gl *GL) FramebufferRenderbuffer(target, attachment, renderbuffertarget glbase.Enum, renderbuffer glbase.Renderbuffer) {
	C.gles2_glFramebufferRenderbuffer(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(renderbuffertarget), C.GLuint(renderbuffer))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFramebufferTexture2D.xml
func (gl *GL) FramebufferTexture2D(target, attachment, textarget glbase.Enum, texture glbase.Texture, level int) {
	C.gles2_glFramebufferTexture2D(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(textarget), C.GLuint(texture), C.GLint(level))
}

// GenBuffers returns n buffer object names. There is no guarantee that
// the names form a contiguous set of integers; however, it is guaranteed
// that none of the returned names was in use immediately before the call to
// GenBuffers.
//
// Buffer object names returned by a call to GenBuffers are not returned by
// subsequent calls, unless they are first deleted with DeleteBuffers.
//
// No buffer objects are associated with the returned buffer object names
// until they are first bound by calling BindBuffer.
//
// Error GL.INVALID_VALUE is generated if n is negative. GL.INVALID_OPERATION
// is generated if GenBuffers is executed between the execution of Begin
// and the corresponding execution of End.
//
// GenBuffers is available in GL version 1.5 or greater.
func (gl *GL) GenBuffers(n int) []glbase.Buffer {
	if n == 0 {
		return nil
	}
	buffers := make([]glbase.Buffer, n)
	C.gles2_glGenBuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&buffers[0])))
	return buffers
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGenerateMipmap.xml
func (gl *GL) GenerateMipmap(target glbase.Enum) {
	C.gles2_glGenerateMipmap(gl.funcs, C.GLenum(target))
}

// GenFramebuffers returns n framebuffer object names in ids. There is no
// guarantee that the names form a contiguous set of integers; however, it is
// guaranteed that none of the returned names was in use immediately before
// the call to GenFramebuffers.
//
// Framebuffer object names returned by a call to GenFramebuffers are not
// returned by subsequent calls, unless they are first deleted with
// DeleteFramebuffers.
//
// The names returned in ids are marked as used, for the purposes of
// GenFramebuffers only, but they acquire state and type only when they are
// first bound.
//
// Error GL.INVALID_VALUE is generated if n is negative.
func (gl *GL) GenFramebuffers(n int) []glbase.Framebuffer {
	if n == 0 {
		return nil
	}
	framebuffers := make([]glbase.Framebuffer, n)
	C.gles2_glGenFramebuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&framebuffers[0])))
	return framebuffers
}

// GenRenderbuffers returns n renderbuffer object names in renderbuffers.
// There is no guarantee that the names form a contiguous set of integers;
// however, it is guaranteed that none of the returned names was in use
// immediately before the call to GenRenderbuffers.
//
// Renderbuffer object names returned by a call to GenRenderbuffers are not
// returned by subsequent calls, unless they are first deleted with
// DeleteRenderbuffers.
//
// The names returned in renderbuffers are marked as used, for the purposes
// of GenRenderbuffers only, but they acquire state and type only when they
// are first bound.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// GenRenderbuffers is available in GL version 3.0 or greater.
func (gl *GL) GenRenderbuffers(n int) []glbase.Renderbuffer {
	if n == 0 {
		return nil
	}
	renderbuffers := make([]glbase.Renderbuffer, n)
	C.gles2_glGenRenderbuffers(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&renderbuffers[0])))
	return renderbuffers
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetActiveAttrib.xml
func (gl *GL) GetActiveAttrib(program glbase.Program, index glbase.Attrib, bufSize int32, length []int32, size []int, gltype []glbase.Enum, name []byte) {
	C.gles2_glGetActiveAttrib(gl.funcs, C.GLuint(program), C.GLuint(index), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLint)(unsafe.Pointer(&size[0])), (*C.GLenum)(unsafe.Pointer(&gltype[0])), (*C.GLchar)(unsafe.Pointer(&name[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetActiveUniform.xml
func (gl *GL) GetActiveUniform(program glbase.Program, index uint32, bufSize int32, length []int32, size []int, gltype []glbase.Enum, name []byte) {
	C.gles2_glGetActiveUniform(gl.funcs, C.GLuint(program), C.GLuint(index), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLint)(unsafe.Pointer(&size[0])), (*C.GLenum)(unsafe.Pointer(&gltype[0])), (*C.GLchar)(unsafe.Pointer(&name[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetAttachedShaders.xml
func (gl *GL) GetAttachedShaders(program glbase.Program, maxcount int32, count []int, shaders []glbase.Shader) {
	C.gles2_glGetAttachedShaders(gl.funcs, C.GLuint(program), C.GLsizei(maxcount), (*C.GLsizei)(unsafe.Pointer(&count[0])), (*C.GLuint)(unsafe.Pointer(&shaders[0])))
}

// GetAttribLocation queries the previously linked program object specified
// by program for the attribute variable specified by name and returns the
// index of the generic vertex attribute that is bound to that attribute
// variable. If name is a matrix attribute variable, the index of the first
// column of the matrix is returned. If the named attribute variable is not
// an active attribute in the specified program object or if name starts with
// the reserved prefix "gl_", a value of -1 is returned.
//
// The association between an attribute variable name and a generic attribute
// index can be specified at any time by calling BindAttribLocation.
// Attribute bindings do not go into effect until LinkProgram is called.
// After a program object has been linked successfully, the index values for
// attribute variables remain fixed until the next link command occurs. The
// attribute values can only be queried after a link if the link was
// successful. GetAttribLocation returns the binding that actually went
// into effect the last time LinkProgram was called for the specified
// program object. Attribute bindings that have been specified since the last
// link operation are not returned by GetAttribLocation.
//
// Error GL_INVALID_OPERATION is generated if program is not a value
// generated by OpenGL. GL_INVALID_OPERATION is generated if program is not
// a program object. GL_INVALID_OPERATION is generated if program has not
// been successfully linked.  GL_INVALID_OPERATION is generated if
// GetAttribLocation is executed between the execution of Begin and the
// corresponding execution of End.
//
// GetAttribLocation is available in GL version 2.0 or greater.
func (gl *GL) GetAttribLocation(program glbase.Program, name string) glbase.Attrib {
	name_cstr := C.CString(name)
	glresult := C.gles2_glGetAttribLocation(gl.funcs, C.GLuint(program), (*C.GLchar)(name_cstr))
	C.free(unsafe.Pointer(name_cstr))
	return glbase.Attrib(glresult)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferParameteriv.xml
func (gl *GL) GetBufferParameteriv(target, pname glbase.Enum, params []int32) {
	C.gles2_glGetBufferParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetFramebufferAttachmentParameteriv.xml
func (gl *GL) GetFramebufferAttachmentParameteriv(target, attachment, pname glbase.Enum, params []int32) {
	C.gles2_glGetFramebufferAttachmentParameteriv(gl.funcs, C.GLenum(target), C.GLenum(attachment), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// GetProgramiv returns in params the value of a parameter for a specific
// program object. The following parameters are defined:
//
//   GL.DELETE_STATUS
//       params returns GL.TRUE if program is currently flagged for deletion,
//       and GL.FALSE otherwise.
//
//   GL.LINK_STATUS
//       params returns GL.TRUE if the last link operation on program was
//       successful, and GL.FALSE otherwise.
//
//   GL.VALIDATE_STATUS
//       params returns GL.TRUE or if the last validation operation on
//       program was successful, and GL.FALSE otherwise.
//
//   GL.INFO_LOG_LENGTH
//       params returns the number of characters in the information log for
//       program including the null termination character (the size of
//       the character buffer required to store the information log). If
//       program has no information log, a value of 0 is returned.
//
//   GL.ATTACHED_SHADERS
//       params returns the number of shader objects attached to program.
//
//   GL.ACTIVE_ATTRIBUTES
//       params returns the number of active attribute variables for program.
//
//   GL.ACTIVE_ATTRIBUTE_MAX_LENGTH
//       params returns the length of the longest active attribute name for
//       program, including the null termination character (the size of
//       the character buffer required to store the longest attribute name).
//       If no active attributes exist, 0 is returned.
//
//   GL.ACTIVE_UNIFORMS
//       params returns the number of active uniform variables for program.
//
//   GL.ACTIVE_UNIFORM_MAX_LENGTH
//       params returns the length of the longest active uniform variable
//       name for program, including the null termination character (i.e.,
//       the size of the character buffer required to store the longest
//       uniform variable name). If no active uniform variables exist, 0 is
//       returned.
//
//   GL.TRANSFORM_FEEDBACK_BUFFER_MODE
//       params returns a symbolic constant indicating the buffer mode used
//       when transform feedback is active. This may be GL.SEPARATE_ATTRIBS
//       or GL.INTERLEAVED_ATTRIBS.
//
//   GL.TRANSFORM_FEEDBACK_VARYINGS
//       params returns the number of varying variables to capture in transform
//       feedback mode for the program.
//
//   GL.TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH
//       params returns the length of the longest variable name to be used for
//       transform feedback, including the null-terminator.
//
//   GL.GEOMETRY_VERTICES_OUT
//       params returns the maximum number of vertices that the geometry shader in
//       program will output.
//
//   GL.GEOMETRY_INPUT_TYPE
//       params returns a symbolic constant indicating the primitive type accepted
//       as input to the geometry shader contained in program.
//
//   GL.GEOMETRY_OUTPUT_TYPE
//       params returns a symbolic constant indicating the primitive type that will
//       be output by the geometry shader contained in program.
//
// GL.ACTIVE_UNIFORM_BLOCKS and GL.ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH are
// available only if the GL version 3.1 or greater.
//
// GL.GEOMETRY_VERTICES_OUT, GL.GEOMETRY_INPUT_TYPE and
// GL.GEOMETRY_OUTPUT_TYPE are accepted only if the GL version is 3.2 or
// greater.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program does not refer to a
// program object.  GL.INVALID_OPERATION is generated if pname is
// GL.GEOMETRY_VERTICES_OUT, GL.GEOMETRY_INPUT_TYPE, or
// GL.GEOMETRY_OUTPUT_TYPE, and program does not contain a geometry shader.
// GL.INVALID_ENUM is generated if pname is not an accepted value.
func (gl *GL) GetProgramiv(program glbase.Program, pname glbase.Enum, params []int32) {
	var params_c [4]int32
	C.gles2_glGetProgramiv(gl.funcs, C.GLuint(program), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetProgramInfoLog returns the information log for the specified program
// object. The information log for a program object is modified when the
// program object is linked or validated.
//
// The information log for a program object is either an empty string, or a
// string containing information about the last link operation, or a string
// containing information about the last validation operation. It may contain
// diagnostic messages, warning messages, and other information. When a
// program object is created, its information log will be a string of length
// 0, and the size of the current log can be obtained by calling GetProgramiv
// with the value GL.INFO_LOG_LENGTH.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated
// by OpenGL. GL.INVALID_OPERATION is generated if program is not a
// program object.
func (gl *GL) GetProgramInfoLog(program glbase.Program) []byte {
	var params [1]int32
	var length int32
	gl.GetProgramiv(program, INFO_LOG_LENGTH, params[:])
	bufSize := params[0]
	infoLog := make([]byte, int(bufSize))
	C.gles2_glGetProgramInfoLog(gl.funcs, C.GLuint(program), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length)), (*C.GLchar)(unsafe.Pointer(&infoLog[0])))
	return infoLog
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetRenderbufferParameteriv.xml
func (gl *GL) GetRenderbufferParameteriv(target, pname glbase.Enum, params []int32) {
	C.gles2_glGetRenderbufferParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// GetShaderiv GetShader returns in params the value of a parameter for a specific
// shader object. The following parameters are defined:
//
//   GL.SHADER_TYPE
//     params returns GL.VERTEX_SHADER if shader is a vertex shader object,
//     and GL.FRAGMENT_SHADER if shader is a fragment shader object.
//
//   GL.DELETE_STATUS
//     params returns GL.TRUE if shader is currently flagged for deletion,
//     and GL.FALSE otherwise.
//
//   GL.COMPILE_STATUS
//     params returns GL.TRUE if the last compile operation on shader was
//     successful, and GL.FALSE otherwise.
//
//   GL.INFO_LOG_LENGTH
//     params returns the number of characters in the information log for
//     shader including the null termination character (the size of the
//     character buffer required to store the information log). If shader has
//     no information log, a value of 0 is returned.
//
//   GL.SHADER_SOURCE_LENGTH
//     params returns the length of the concatenation of the source strings
//     that make up the shader source for the shader, including the null
//     termination character. (the size of the character buffer
//     required to store the shader source). If no source code exists, 0 is
//     returned.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if shader does not refer to a
// shader object. GL.INVALID_ENUM is generated if pname is not an accepted
// value. GL.INVALID_OPERATION is generated if GetShader is executed
// between the execution of Begin and the corresponding execution of End.
//
// GetShaderiv is available in GL version 2.0 or greater.
func (gl *GL) GetShaderiv(shader glbase.Shader, pname glbase.Enum, params []int32) {
	var params_c [4]int32
	C.gles2_glGetShaderiv(gl.funcs, C.GLuint(shader), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetShaderInfoLog returns the information log for the specified shader
// object. The information log for a shader object is modified when the
// shader is compiled.
//
// The information log for a shader object is a string that may contain
// diagnostic messages, warning messages, and other information about the
// last compile operation. When a shader object is created, its information
// log will be a string of length 0, and the size of the current log can be
// obtained by calling GetShaderiv with the value GL.INFO_LOG_LENGTH.
//
// The information log for a shader object is the OpenGL implementer's
// primary mechanism for conveying information about the compilation process.
// Therefore, the information log can be helpful to application developers
// during the development process, even when compilation is successful.
// Application developers should not expect different OpenGL implementations
// to produce identical information logs.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if shader is not a shader
// object. GL.INVALID_VALUE is generated if maxLength is less than 0.
// GL.INVALID_OPERATION is generated if GetShaderInfoLog is executed
// between the execution of Begin and the corresponding execution of End.
//
// GetShaderInfoLog is available in GL version 2.0 or greater.
func (gl *GL) GetShaderInfoLog(shader glbase.Shader) []byte {
	var params [1]int32
	var length int32
	gl.GetShaderiv(shader, INFO_LOG_LENGTH, params[:])
	bufSize := params[0]
	infoLog := make([]byte, int(bufSize))
	C.gles2_glGetShaderInfoLog(gl.funcs, C.GLuint(shader), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length)), (*C.GLchar)(unsafe.Pointer(&infoLog[0])))
	return infoLog
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetShaderPrecisionFormat.xml
func (gl *GL) GetShaderPrecisionFormat(shadertype, precisionType glbase.Enum, range_, precision []int32) {
	C.gles2_glGetShaderPrecisionFormat(gl.funcs, C.GLenum(shadertype), C.GLenum(precisionType), (*C.GLint)(unsafe.Pointer(&range_[0])), (*C.GLint)(unsafe.Pointer(&precision[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetShaderSource.xml
func (gl *GL) GetShaderSource(shader glbase.Shader, bufSize int32, length []int32, source []byte) {
	C.gles2_glGetShaderSource(gl.funcs, C.GLuint(shader), C.GLsizei(bufSize), (*C.GLsizei)(unsafe.Pointer(&length[0])), (*C.GLchar)(unsafe.Pointer(&source[0])))
}

// GetUniformfv returns in params the value of the specified uniform
// variable. The type of the uniform variable specified by location
// determines the number of values returned. If the uniform variable is
// defined in the shader as a boolean, int, or float, a single value will be
// returned. If it is defined as a vec2, ivec2, or bvec2, two values will be
// returned. If it is defined as a vec3, ivec3, or bvec3, three values will
// be returned, and so on. To query values stored in uniform variables
// declared as arrays, call GetUniformfv for each element of the array. To
// query values stored in uniform variables declared as structures, call
// GetUniformfv for each field in the structure. The values for uniform
// variables declared as a matrix will be returned in column major order.
//
// The locations assigned to uniform variables are not known until the
// program object is linked. After linking has occurred, the command
// GetUniformLocation can be used to obtain the location of a uniform
// variable. This location value can then be passed to GetUniformfv in order
// to query the current value of the uniform variable. After a program object
// has been linked successfully, the index values for uniform variables
// remain fixed until the next link command occurs. The uniform variable
// values can only be queried after a link if the link was successful.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program
// object. GL.INVALID_OPERATION is generated if program has not been
// successfully linked. GL.INVALID_OPERATION is generated if location does
// not correspond to a valid uniform variable location for the specified
// program object. GL.INVALID_OPERATION is generated if GetUniformfv is
// executed between the execution of Begin and the corresponding execution of
// End.
//
// GetUniformfv is available in GL version 2.0 or greater.
func (gl *GL) GetUniformfv(program glbase.Program, location glbase.Uniform, params []float32) {
	var params_c [4]float32
	C.gles2_glGetUniformfv(gl.funcs, C.GLuint(program), C.GLint(location), (*C.GLfloat)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetUniformiv returns in params the value of the specified uniform
// variable. The type of the uniform variable specified by location
// determines the number of values returned. If the uniform variable is
// defined in the shader as a boolean, int, or float, a single value will be
// returned. If it is defined as a vec2, ivec2, or bvec2, two values will be
// returned. If it is defined as a vec3, ivec3, or bvec3, three values will
// be returned, and so on. To query values stored in uniform variables
// declared as arrays, call GetUniformiv for each element of the array. To
// query values stored in uniform variables declared as structures, call
// GetUniformiv for each field in the structure. The values for uniform
// variables declared as a matrix will be returned in column major order.
//
// The locations assigned to uniform variables are not known until the
// program object is linked. After linking has occurred, the command
// GetUniformLocation can be used to obtain the location of a uniform
// variable. This location value can then be passed to GetUniformiv in order
// to query the current value of the uniform variable. After a program object
// has been linked successfully, the index values for uniform variables
// remain fixed until the next link command occurs. The uniform variable
// values can only be queried after a link if the link was successful.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program
// object. GL.INVALID_OPERATION is generated if program has not been
// successfully linked. GL.INVALID_OPERATION is generated if location does
// not correspond to a valid uniform variable location for the specified
// program object. GL.INVALID_OPERATION is generated if GetUniformiv is
// executed between the execution of Begin and the corresponding execution of
// End.
//
// GetUniformiv is available in GL version 2.0 or greater.
func (gl *GL) GetUniformiv(program glbase.Program, location glbase.Uniform, params []int32) {
	var params_c [4]int32
	C.gles2_glGetUniformiv(gl.funcs, C.GLuint(program), C.GLint(location), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetUniformLocation returns an integer that represents the location of a
// specific uniform variable within a program object. name must be an active
// uniform variable name in program that is not a structure, an array of
// structures, or a subcomponent of a vector or a matrix. This function
// returns -1 if name does not correspond to an active uniform variable in
// program or if name starts with the reserved prefix "gl_".
//
// Uniform variables that are structures or arrays of structures may be
// queried by calling GetUniformLocation for each field within the
// structure. The array element operator "[]" and the structure field
// operator "." may be used in name in order to select elements within an
// array or fields within a structure. The result of using these operators is
// not allowed to be another structure, an array of structures, or a
// subcomponent of a vector or a matrix. Except if the last part of name
// indicates a uniform variable array, the location of the first element of
// an array can be retrieved by using the name of the array, or by using the
// name appended by "[0]".
//
// The actual locations assigned to uniform variables are not known until the
// program object is linked successfully. After linking has occurred, the
// command GetUniformLocation can be used to obtain the location of a
// uniform variable. This location value can then be passed to Uniform to
// set the value of the uniform variable or to GetUniform in order to query
// the current value of the uniform variable. After a program object has been
// linked successfully, the index values for uniform variables remain fixed
// until the next link command occurs. Uniform variable locations and values
// can only be queried after a link if the link was successful.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program object.
// GL.INVALID_OPERATION is generated if program has not been successfully
// linked. GL.INVALID_OPERATION is generated if GetUniformLocation is executed
// between the execution of Begin and the corresponding execution of End.
//
// GetUniformLocation is available in GL version 2.0 or greater.
func (gl *GL) GetUniformLocation(program glbase.Program, name string) glbase.Uniform {
	name_cstr := C.CString(name)
	glresult := C.gles2_glGetUniformLocation(gl.funcs, C.GLuint(program), (*C.GLchar)(name_cstr))
	C.free(unsafe.Pointer(name_cstr))
	return glbase.Uniform(glresult)
}

// GetVertexAttribfv returns in params the value of a generic vertex attribute
// parameter. The generic vertex attribute to be queried is specified by
// index, and the parameter to be queried is specified by pname.
//
// The accepted parameter names are as follows:
//
//   GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
//       params returns a single value, the name of the buffer object
//       currently bound to the binding point corresponding to generic vertex
//       attribute array index. If no buffer object is bound, 0 is returned.
//       The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_ENABLED
//       params returns a single value that is non-zero (true) if the vertex
//       attribute array for index is enabled and 0 (false) if it is
//       disabled. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_SIZE
//       params returns a single value, the size of the vertex attribute
//       array for index. The size is the number of values for each element
//       of the vertex attribute array, and it will be 1, 2, 3, or 4. The
//       initial value is 4.
//
//   GL.VERTEX_ATTRIB_ARRAY_STRIDE
//       params returns a single value, the array stride for (number of bytes
//       between successive elements in) the vertex attribute array for
//       index. A value of 0 indicates that the array elements are stored
//       sequentially in memory. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_TYPE
//       params returns a single value, a symbolic constant indicating the
//       array type for the vertex attribute array for index. Possible values
//       are GL.BYTE, GL.UNSIGNED_BYTE, GL.SHORT, GL.UNSIGNED_SHORT, GL.INT,
//       GL.UNSIGNED_INT, GL.FLOAT, and GL.DOUBLE. The initial value is
//       GL.FLOAT.
//
//   GL.VERTEX_ATTRIB_ARRAY_NORMALIZED
//       params returns a single value that is non-zero (true) if fixed-point
//       data types for the vertex attribute array indicated by index are
//       normalized when they are converted to floating point, and 0 (false)
//       otherwise. The initial value is 0.
//
//   GL.CURRENT_VERTEX_ATTRIB
//       params returns four values that represent the current value for the
//       generic vertex attribute specified by index. Generic vertex
//       attribute 0 is unique in that it has no current state, so an error
//       will be generated if index is 0. The initial value for all other
//       generic vertex attributes is (0,0,0,1).
//
// All of the parameters except GL.CURRENT_VERTEX_ATTRIB represent
// client-side state.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_ENUM is generated if pname is not an
// accepted value.  GL.INVALID_OPERATION is generated if index is 0 and pname
// is GL.CURRENT_VERTEX_ATTRIB.
//
// GetVertexAttribfv is available in GL version 2.0 or greater.
func (gl *GL) GetVertexAttribfv(index glbase.Attrib, pname glbase.Enum, params []float32) {
	var params_c [4]float32
	C.gles2_glGetVertexAttribfv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// GetVertexAttribiv returns in params the value of a generic vertex attribute
// parameter. The generic vertex attribute to be queried is specified by
// index, and the parameter to be queried is specified by pname.
//
// The accepted parameter names are as follows:
//
//   GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING
//       params returns a single value, the name of the buffer object
//       currently bound to the binding point corresponding to generic vertex
//       attribute array index. If no buffer object is bound, 0 is returned.
//       The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_ENABLED
//       params returns a single value that is non-zero (true) if the vertex
//       attribute array for index is enabled and 0 (false) if it is
//       disabled. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_SIZE
//       params returns a single value, the size of the vertex attribute
//       array for index. The size is the number of values for each element
//       of the vertex attribute array, and it will be 1, 2, 3, or 4. The
//       initial value is 4.
//
//   GL.VERTEX_ATTRIB_ARRAY_STRIDE
//       params returns a single value, the array stride for (number of bytes
//       between successive elements in) the vertex attribute array for
//       index. A value of 0 indicates that the array elements are stored
//       sequentially in memory. The initial value is 0.
//
//   GL.VERTEX_ATTRIB_ARRAY_TYPE
//       params returns a single value, a symbolic constant indicating the
//       array type for the vertex attribute array for index. Possible values
//       are GL.BYTE, GL.UNSIGNED_BYTE, GL.SHORT, GL.UNSIGNED_SHORT, GL.INT,
//       GL.UNSIGNED_INT, GL.FLOAT, and GL.DOUBLE. The initial value is
//       GL.FLOAT.
//
//   GL.VERTEX_ATTRIB_ARRAY_NORMALIZED
//       params returns a single value that is non-zero (true) if fixed-point
//       data types for the vertex attribute array indicated by index are
//       normalized when they are converted to floating point, and 0 (false)
//       otherwise. The initial value is 0.
//
//   GL.CURRENT_VERTEX_ATTRIB
//       params returns four values that represent the current value for the
//       generic vertex attribute specified by index. Generic vertex
//       attribute 0 is unique in that it has no current state, so an error
//       will be generated if index is 0. The initial value for all other
//       generic vertex attributes is (0,0,0,1).
//
// All of the parameters except GL.CURRENT_VERTEX_ATTRIB represent
// client-side state.
//
// Error GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_ENUM is generated if pname is not an
// accepted value.  GL.INVALID_OPERATION is generated if index is 0 and pname
// is GL.CURRENT_VERTEX_ATTRIB.
//
// GetVertexAttribiv is available in GL version 2.0 or greater.
func (gl *GL) GetVertexAttribiv(index glbase.Attrib, pname glbase.Enum, params []int32) {
	var params_c [4]int32
	C.gles2_glGetVertexAttribiv(gl.funcs, C.GLuint(index), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params_c[0])))
	copy(params, params_c[:])
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsBuffer.xml
func (gl *GL) IsBuffer(buffer glbase.Buffer) bool {
	glresult := C.gles2_glIsBuffer(gl.funcs, C.GLuint(buffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsFramebuffer.xml
func (gl *GL) IsFramebuffer(framebuffer glbase.Framebuffer) bool {
	glresult := C.gles2_glIsFramebuffer(gl.funcs, C.GLuint(framebuffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsProgram.xml
func (gl *GL) IsProgram(program glbase.Program) bool {
	glresult := C.gles2_glIsProgram(gl.funcs, C.GLuint(program))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsRenderbuffer.xml
func (gl *GL) IsRenderbuffer(renderbuffer glbase.Renderbuffer) bool {
	glresult := C.gles2_glIsRenderbuffer(gl.funcs, C.GLuint(renderbuffer))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsShader.xml
func (gl *GL) IsShader(shader glbase.Shader) bool {
	glresult := C.gles2_glIsShader(gl.funcs, C.GLuint(shader))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// LinkProgram links the program object specified by program. If any shader
// objects of type GL.VERTEX_SHADER are attached to program, they will be
// used to create an executable that will run on the programmable vertex
// processor. If any shader objects of type GL.FRAGMENT_SHADER are attached
// to program, they will be used to create an executable that will run on the
// programmable fragment processor.
//
// The status of the link operation will be stored as part of the program
// object's state. This value will be set to GL.TRUE if the program object
// was linked without errors and is ready for use, and GL.FALSE otherwise. It
// can be queried by calling GetProgramiv with arguments program and
// GL.LINK_STATUS.
//
// As a result of a successful link operation, all active user-defined
// uniform variables belonging to program will be initialized to 0, and each
// of the program object's active uniform variables will be assigned a
// location that can be queried by calling GetUniformLocation. Also, any
// active user-defined attribute variables that have not been bound to a
// generic vertex attribute index will be bound to one at this time.
//
// Linking of a program object can fail for a number of reasons as specified
// in the OpenGL Shading Language Specification. The following lists some of
// the conditions that will cause a link error.
//
//   - The number of active attribute variables supported by the
//     implementation has been exceeded.
//
//   - The storage limit for uniform variables has been exceeded.
//
//   - The number of active uniform variables supported by the implementation
//     has been exceeded.
//
//   - The main function is missing for the vertex shader or the fragment
//     shader.
//
//   - A varying variable actually used in the fragment shader is not
//     declared in the same way (or is not declared at all) in the vertex
//     shader.
//
//   - A reference to a function or variable name is unresolved.
//
//   - A shared global is declared with two different types or two different
//     initial values.
//
//   - One or more of the attached shader objects has not been successfully
//     compiled.
//
//   - Binding a generic attribute matrix caused some rows of the matrix to
//     fall outside the allowed maximum of GL.MAX_VERTEX_ATTRIBS.
//
//   - Not enough contiguous vertex attribute slots could be found to bind
//     attribute matrices.
//
// When a program object has been successfully linked, the program object can
// be made part of current state by calling UseProgram. Whether or not the
// link operation was successful, the program object's information log will
// be overwritten. The information log can be retrieved by calling
// GetProgramInfoLog.
//
// LinkProgram will also install the generated executables as part of the
// current rendering state if the link operation was successful and the
// specified program object is already currently in use as a result of a
// previous call to UseProgram. If the program object currently in use is
// relinked unsuccessfully, its link status will be set to GL.FALSE , but the
// executables and associated state will remain part of the current state
// until a subsequent call to UseProgram removes it from use. After it is
// removed from use, it cannot be made part of current state until it has
// been successfully relinked.
//
// If program contains shader objects of type GL.VERTEX_SHADER but does not
// contain shader objects of type GL.FRAGMENT_SHADER, the vertex shader will
// be linked against the implicit interface for fixed functionality fragment
// processing. Similarly, if program contains shader objects of type
// GL.FRAGMENT_SHADER but it does not contain shader objects of type
// GL.VERTEX_SHADER, the fragment shader will be linked against the implicit
// interface for fixed functionality vertex processing.
//
// The program object's information log is updated and the program is
// generated at the time of the link operation. After the link operation,
// applications are free to modify attached shader objects, compile attached
// shader objects, detach shader objects, delete shader objects, and attach
// additional shader objects. None of these operations affects the
// information log or the program that is part of the program object.
//
// If the link operation is unsuccessful, any information about a previous
// link operation on program is lost (a failed link does not restore the
// old state of program). Certain information can still be retrieved
// from program even after an unsuccessful link operation. See for instance
// GetActiveAttrib and GetActiveUniform.
//
// Error GL.INVALID_VALUE is generated if program is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if program is not a program
// object. GL.INVALID_OPERATION is generated if LinkProgram is executed
// between the execution of Begin and the corresponding execution of End.
//
// LinkProgram is available in GL version 2.0 or greater.
func (gl *GL) LinkProgram(program glbase.Program) {
	C.gles2_glLinkProgram(gl.funcs, C.GLuint(program))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glReleaseShaderCompiler.xml
func (gl *GL) ReleaseShaderCompiler() {
	C.gles2_glReleaseShaderCompiler(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glRenderbufferStorage.xml
func (gl *GL) RenderbufferStorage(target, internalFormat glbase.Enum, width, height int) {
	C.gles2_glRenderbufferStorage(gl.funcs, C.GLenum(target), C.GLenum(internalFormat), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glSampleCoverage.xml
func (gl *GL) SampleCoverage(value glbase.Clampf, invert bool) {
	C.gles2_glSampleCoverage(gl.funcs, C.GLclampf(value), *(*C.GLboolean)(unsafe.Pointer(&invert)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glShaderBinary.xml
func (gl *GL) ShaderBinary(n int, shaders []glbase.Shader, binaryFormat glbase.Enum, binary interface{}, length int32) {
	var binary_ptr unsafe.Pointer
	var binary_v = reflect.ValueOf(binary)
	if binary != nil && binary_v.Kind() != reflect.Slice {
		panic("parameter binary must be a slice")
	}
	if binary != nil {
		binary_ptr = unsafe.Pointer(binary_v.Index(0).Addr().Pointer())
	}
	C.gles2_glShaderBinary(gl.funcs, C.GLint(n), (*C.GLuint)(unsafe.Pointer(&shaders[0])), C.GLenum(binaryFormat), binary_ptr, C.GLint(length))
}

// ShaderSource sets the source code in shader to the provided source code. Any source
// code previously stored in the shader object is completely replaced.
//
// Error GL.INVALID_VALUE is generated if shader is not a value generated by
// OpenGL. GL.INVALID_OPERATION is generated if shader is not a shader
// object. GL.INVALID_VALUE is generated if count is less than 0.
// GL.INVALID_OPERATION is generated if ShaderSource is executed between the
// execution of Begin and the corresponding execution of End.
//
// ShaderSource is available in GL version 2.0 or greater.
func (gl *GL) ShaderSource(shader glbase.Shader, source ...string) {
	count := len(source)
	length := make([]int32, count)
	source_c := make([]unsafe.Pointer, count)
	for i, src := range source {
		length[i] = int32(len(src))
		if len(src) > 0 {
			source_c[i] = *(*unsafe.Pointer)(unsafe.Pointer(&src))
		} else {
			source_c[i] = unsafe.Pointer(uintptr(0))
		}
	}
	C.gles2_glShaderSource(gl.funcs, C.GLuint(shader), C.GLsizei(count), (**C.GLchar)(unsafe.Pointer(&source_c[0])), (*C.GLint)(unsafe.Pointer(&length[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilFuncSeparate.xml
func (gl *GL) StencilFuncSeparate(face, glfunc glbase.Enum, ref int32, mask uint32) {
	C.gles2_glStencilFuncSeparate(gl.funcs, C.GLenum(face), C.GLenum(glfunc), C.GLint(ref), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilMaskSeparate.xml
func (gl *GL) StencilMaskSeparate(face glbase.Enum, mask uint32) {
	C.gles2_glStencilMaskSeparate(gl.funcs, C.GLenum(face), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilOpSeparate.xml
func (gl *GL) StencilOpSeparate(face, fail, zfail, zpass glbase.Enum) {
	C.gles2_glStencilOpSeparate(gl.funcs, C.GLenum(face), C.GLenum(fail), C.GLenum(zfail), C.GLenum(zpass))
}

// Uniform1f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform1f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1f(location glbase.Uniform, v0 float32) {
	C.gles2_glUniform1f(gl.funcs, C.GLint(location), C.GLfloat(v0))
}

// Uniform1fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform1fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	count := len(value)
	C.gles2_glUniform1fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform1i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform1i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1i(location glbase.Uniform, v0 int32) {
	C.gles2_glUniform1i(gl.funcs, C.GLint(location), C.GLint(v0))
}

// Uniform1iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform1iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform1iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	count := len(value)
	C.gles2_glUniform1iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform2f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform2f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2f(location glbase.Uniform, v0, v1 float32) {
	C.gles2_glUniform2f(gl.funcs, C.GLint(location), C.GLfloat(v0), C.GLfloat(v1))
}

// Uniform2fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform2fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%2 != 0 {
		panic("invalid value length for Uniform2fv")
	}
	count := len(value) / 2
	C.gles2_glUniform2fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform2i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform2i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2i(location glbase.Uniform, v0, v1 int32) {
	C.gles2_glUniform2i(gl.funcs, C.GLint(location), C.GLint(v0), C.GLint(v1))
}

// Uniform2iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform2iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform2iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	if len(value)%2 != 0 {
		panic("invalid value length for Uniform2iv")
	}
	count := len(value) / 2
	C.gles2_glUniform2iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform3f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform3f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3f(location glbase.Uniform, v0, v1, v2 float32) {
	C.gles2_glUniform3f(gl.funcs, C.GLint(location), C.GLfloat(v0), C.GLfloat(v1), C.GLfloat(v2))
}

// Uniform3fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform3fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%3 != 0 {
		panic("invalid value length for Uniform3fv")
	}
	count := len(value) / 3
	C.gles2_glUniform3fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform3i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform3i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3i(location glbase.Uniform, v0, v1, v2 int32) {
	C.gles2_glUniform3i(gl.funcs, C.GLint(location), C.GLint(v0), C.GLint(v1), C.GLint(v2))
}

// Uniform3iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform3iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform3iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	if len(value)%3 != 0 {
		panic("invalid value length for Uniform3iv")
	}
	count := len(value) / 3
	C.gles2_glUniform3iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// Uniform4f modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform4f operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4f(location glbase.Uniform, v0, v1, v2, v3 float32) {
	C.gles2_glUniform4f(gl.funcs, C.GLint(location), C.GLfloat(v0), C.GLfloat(v1), C.GLfloat(v2), C.GLfloat(v3))
}

// Uniform4fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform4fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4fv(location glbase.Uniform, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%4 != 0 {
		panic("invalid value length for Uniform4fv")
	}
	count := len(value) / 4
	C.gles2_glUniform4fv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// Uniform4i modifies the value of a single uniform variable.
// The location of the uniform variable to be modified is specified by
// location, which should be a value returned by GetUniformLocation.
// Uniform4i operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui} are used to change the value of the
// uniform variable specified by location using the values passed as
// arguments. The number specified in the function should match the number of
// components in the data type of the specified uniform variable (1 for
// float, int, unsigned int, bool; 2 for vec2, ivec2, uvec2, bvec2, etc.).
// The suffix f indicates that floating-point values are being passed; the
// suffix i indicates that integer values are being passed; the suffix ui
// indicates that unsigned integer values are being passed, and this type
// should also match the data type of the specified uniform variable. The i
// variants of this function should be used to provide values for uniform
// variables defined as int, ivec2, ivec3, ivec4, or arrays of these. The ui
// variants of this function should be used to provide values for uniform
// variables defined as unsigned int, uvec2, uvec3, uvec4, or arrays of
// these. The f variants should be used to provide values for uniform
// variables of type float, vec2, vec3, vec4, or arrays of these. Either the
// i, ui or f variants may be used to provide values for uniform variables of
// type bool, bvec2, bvec3, bvec4, or arrays of these. The uniform variable
// will be set to false if the input value is 0 or 0.0f, and it will be set
// to true otherwise.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4i(location glbase.Uniform, v0, v1, v2, v3 int32) {
	C.gles2_glUniform4i(gl.funcs, C.GLint(location), C.GLint(v0), C.GLint(v1), C.GLint(v2), C.GLint(v3))
}

// Uniform4iv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// Uniform4iv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions Uniform{1|2|3|4}{f|i|ui}v can be used to modify a single
// uniform variable or a uniform variable array. These functions receive a
// slice with the values to be loaded into a uniform variable or a uniform
// variable array. A slice with length 1 should be used if modifying the value
// of a single uniform variable, and a length of 1 or greater can be used to
// modify an entire array or part of an array. When loading n elements
// starting at an arbitrary position m in a uniform variable array, elements
// m + n - 1 in the array will be replaced with the new values. If m + n - 1
// is larger than the size of the uniform variable array, values for all
// array elements beyond the end of the array will be ignored. The number
// specified in the name of the command indicates the number of components
// for each element in value, and it should match the number of components in
// the data type of the specified uniform variable (1 for float, int, bool;
// 2 for vec2, ivec2, bvec2, etc.). The data type specified in the name
// of the command must match the data type for the specified uniform variable
// as described for Uniform{1|2|3|4}{f|i|ui}.
//
// Uniform1i and Uniform1iv are the only two functions that may be used to
// load uniform variables defined as sampler types. Loading samplers with any
// other function will result in a GL.INVALID_OPERATION error.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) Uniform4iv(location glbase.Uniform, value []int32) {
	if len(value) == 0 {
		return
	}
	if len(value)%4 != 0 {
		panic("invalid value length for Uniform4iv")
	}
	count := len(value) / 4
	C.gles2_glUniform4iv(gl.funcs, C.GLint(location), C.GLsizei(count), (*C.GLint)(unsafe.Pointer(&value[0])))
}

// UniformMatrix2fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix2fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix2fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(2*2) != 0 {
		panic("invalid value length for UniformMatrix2fv")
	}
	count := len(value) / (2 * 2)
	C.gles2_glUniformMatrix2fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix3fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix3fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix3fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(3*3) != 0 {
		panic("invalid value length for UniformMatrix3fv")
	}
	count := len(value) / (3 * 3)
	C.gles2_glUniformMatrix3fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UniformMatrix4fv modifies the value of a uniform variable or a uniform
// variable array. The location of the uniform variable to be modified is
// specified by location, which should be a value returned by GetUniformLocation.
// UniformMatrix4fv operates on the program object that was made part of
// current state by calling UseProgram.
//
// The functions UniformMatrix{2|3|4|2x3|3x2|2x4|4x2|3x4|4x3}fv are used to
// modify a matrix or an array of matrices. The numbers in the function name
// are interpreted as the dimensionality of the matrix. The number 2
// indicates a 2x2 matrix (4 values), the number 3 indicates a 3x3 matrix (9
// values), and the number 4 indicates a 4x4 matrix (16 values). Non-square
// matrix dimensionality is explicit, with the first number representing the
// number of columns and the second number representing the number of rows.
// For example, 2x4 indicates a 2x4 matrix with 2 columns and 4 rows (8
// values). The length of the provided slice must be a multiple of the number
// of values per matrix, to update one or more consecutive matrices.
//
// If transpose is false, each matrix is assumed to be supplied in column
// major order. If transpose is true, each matrix is assumed to be supplied
// in row major order.
//
// All active uniform variables defined in a program object are initialized
// to 0 when the program object is linked successfully. They retain the
// values assigned to them by a call to Uniform* until the next successful
// link operation occurs on the program object, when they are once again
// initialized to 0.
func (gl *GL) UniformMatrix4fv(location glbase.Uniform, transpose bool, value []float32) {
	if len(value) == 0 {
		return
	}
	if len(value)%(4*4) != 0 {
		panic("invalid value length for UniformMatrix4fv")
	}
	count := len(value) / (4 * 4)
	C.gles2_glUniformMatrix4fv(gl.funcs, C.GLint(location), C.GLsizei(count), *(*C.GLboolean)(unsafe.Pointer(&transpose)), (*C.GLfloat)(unsafe.Pointer(&value[0])))
}

// UseProgram installs the program object specified by program as part of
// current rendering state. One or more executables are created in a program
// object by successfully attaching shader objects to it with AttachShader,
// successfully compiling the shader objects with CompileShader, and
// successfully linking the program object with LinkProgram.
//
// A program object will contain an executable that will run on the vertex
// processor if it contains one or more shader objects of type
// GL.VERTEX_SHADER that have been successfully compiled and linked.
// Similarly, a program object will contain an executable that will run on
// the fragment processor if it contains one or more shader objects of type
// GL.FRAGMENT_SHADER that have been successfully compiled and linked.
//
// Successfully installing an executable on a programmable processor will
// cause the corresponding fixed functionality of OpenGL to be disabled.
// Specifically, if an executable is installed on the vertex processor, the
// OpenGL fixed functionality will be disabled as follows.
//
//   - The modelview matrix is not applied to vertex coordinates.
//
//   - The projection matrix is not applied to vertex coordinates.
//
//   - The texture matrices are not applied to texture coordinates.
//
//   - Normals are not transformed to eye coordinates.
//
//   - Normals are not rescaled or normalized.
//
//   - Normalization of GL.AUTO_NORMAL evaluated normals is not performed.
//
//   - Texture coordinates are not generated automatically.
//
//   - Per-vertex lighting is not performed.
//
//   - Color material computations are not performed.
//
//   - Color index lighting is not performed.
//
//   - This list also applies when setting the current raster position.
//
// The executable that is installed on the vertex processor is expected to
// implement any or all of the desired functionality from the preceding list.
// Similarly, if an executable is installed on the fragment processor, the
// OpenGL fixed functionality will be disabled as follows.
//
//   - Texture environment and texture functions are not applied.
//
//   - Texture application is not applied.
//
//   - Color sum is not applied.
//
//   - Fog is not applied.
//
// Again, the fragment shader that is installed is expected to implement any
// or all of the desired functionality from the preceding list.
//
// While a program object is in use, applications are free to modify attached
// shader objects, compile attached shader objects, attach additional shader
// objects, and detach or delete shader objects. None of these operations
// will affect the executables that are part of the current state. However,
// relinking the program object that is currently in use will install the
// program object as part of the current rendering state if the link
// operation was successful (see LinkProgram). If the program object
// currently in use is relinked unsuccessfully, its link status will be set
// to GL.FALSE, but the executables and associated state will remain part of
// the current state until a subsequent call to UseProgram removes it from
// use. After it is removed from use, it cannot be made part of current state
// until it has been successfully relinked.
//
// If program contains shader objects of type GL.VERTEX_SHADER but it does
// not contain shader objects of type GL.FRAGMENT_SHADER, an executable will
// be installed on the vertex processor, but fixed functionality will be used
// for fragment processing. Similarly, if program contains shader objects of
// type GL.FRAGMENT_SHADER but it does not contain shader objects of type
// GL.VERTEX_SHADER, an executable will be installed on the fragment
// processor, but fixed functionality will be used for vertex processing. If
// program is 0, the programmable processors will be disabled, and fixed
// functionality will be used for both vertex and fragment processing.
//
// While a program object is in use, the state that controls the disabled
// fixed functionality may also be updated using the normal OpenGL calls.
//
// Like display lists and texture objects, the name space for program objects
// may be shared across a set of contexts, as long as the server sides of the
// contexts share the same address space. If the name space is shared across
// contexts, any attached objects and the data associated with those attached
// objects are shared as well.
//
// Applications are responsible for providing the synchronization across API
// calls when objects are accessed from different execution threads.
//
// Error GL.INVALID_VALUE is generated if program is neither 0 nor a value
// generated by OpenGL.  GL.INVALID_OPERATION is generated if program is not
// a program object.  GL.INVALID_OPERATION is generated if program could not
// be made part of current state.  GL.INVALID_OPERATION is generated if
// UseProgram is executed between the execution of Begin and the
// corresponding execution of End.
//
// UseProgram is available in GL version 2.0 or greater.
func (gl *GL) UseProgram(program glbase.Program) {
	C.gles2_glUseProgram(gl.funcs, C.GLuint(program))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glValidateProgram.xml
func (gl *GL) ValidateProgram(program glbase.Program) {
	C.gles2_glValidateProgram(gl.funcs, C.GLuint(program))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib1f.xml
func (gl *GL) VertexAttrib1f(index glbase.Attrib, x float32) {
	C.gles2_glVertexAttrib1f(gl.funcs, C.GLuint(index), C.GLfloat(x))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib1fv.xml
func (gl *GL) VertexAttrib1fv(index glbase.Attrib, values []float32) {
	C.gles2_glVertexAttrib1fv(gl.funcs, C.GLuint(index), (*C.GLfloat)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib2f.xml
func (gl *GL) VertexAttrib2f(index glbase.Attrib, x, y float32) {
	C.gles2_glVertexAttrib2f(gl.funcs, C.GLuint(index), C.GLfloat(x), C.GLfloat(y))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib2fv.xml
func (gl *GL) VertexAttrib2fv(index glbase.Attrib, values []float32) {
	if len(values) != 2 {
		panic("parameter values has incorrect length")
	}
	C.gles2_glVertexAttrib2fv(gl.funcs, C.GLuint(index), (*C.GLfloat)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib3f.xml
func (gl *GL) VertexAttrib3f(index glbase.Attrib, x, y, z float32) {
	C.gles2_glVertexAttrib3f(gl.funcs, C.GLuint(index), C.GLfloat(x), C.GLfloat(y), C.GLfloat(z))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib3fv.xml
func (gl *GL) VertexAttrib3fv(index glbase.Attrib, values []float32) {
	if len(values) != 3 {
		panic("parameter values has incorrect length")
	}
	C.gles2_glVertexAttrib3fv(gl.funcs, C.GLuint(index), (*C.GLfloat)(unsafe.Pointer(&values[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib4f.xml
func (gl *GL) VertexAttrib4f(index glbase.Attrib, x, y, z, w float32) {
	C.gles2_glVertexAttrib4f(gl.funcs, C.GLuint(index), C.GLfloat(x), C.GLfloat(y), C.GLfloat(z), C.GLfloat(w))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glVertexAttrib4fv.xml
func (gl *GL) VertexAttrib4fv(index glbase.Attrib, values []float32) {
	if len(values) != 4 {
		panic("parameter values has incorrect length")
	}
	C.gles2_glVertexAttrib4fv(gl.funcs, C.GLuint(index), (*C.GLfloat)(unsafe.Pointer(&values[0])))
}

// VertexAttribPointer specifies the location and data format of the array
// of generic vertex attributes at index to use when rendering. size
// specifies the number of components per attribute and must be 1, 2, 3, or
// 4. type specifies the data type of each component, and stride specifies
// the byte stride from one attribute to the next, allowing vertices and
// attributes to be packed into a single array or stored in separate arrays.
// normalized indicates whether the values stored in an integer format are
// to be mapped to the range [-1,1] (for signed values) or [0,1]
// (for unsigned values) when they are accessed and converted to floating
// point; otherwise, values will be converted to floats directly without
// normalization. offset is a byte offset into the buffer object's data
// store, which must be bound to the GL.ARRAY_BUFFER target with BindBuffer.
//
// The buffer object binding (GL.ARRAY_BUFFER_BINDING) is saved as
// generic vertex attribute array client-side state
// (GL.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING) for the provided index.
//
// To enable and disable a generic vertex attribute array, call
// EnableVertexAttribArray and DisableVertexAttribArray with index. If
// enabled, the generic vertex attribute array is used when DrawArrays or
// DrawElements is called. Each generic vertex attribute array is initially
// disabled.
//
// VertexAttribPointer is typically implemented on the client side.
//
// Error GL.INVALID_ENUM is generated if type is not an accepted value.
// GL.INVALID_VALUE is generated if index is greater than or equal to
// GL.MAX_VERTEX_ATTRIBS. GL.INVALID_VALUE is generated if size is not 1, 2,
// 3, or 4. GL.INVALID_VALUE is generated if stride is negative.
func (gl *GL) VertexAttribPointer(index glbase.Attrib, size int, gltype glbase.Enum, normalized bool, stride int, offset uintptr) {
	offset_ptr := unsafe.Pointer(offset)
	C.gles2_glVertexAttribPointer(gl.funcs, C.GLuint(index), C.GLint(size), C.GLenum(gltype), *(*C.GLboolean)(unsafe.Pointer(&normalized)), C.GLsizei(stride), offset_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBindTexture.xml
func (gl *GL) BindTexture(target glbase.Enum, texture glbase.Texture) {
	C.gles2_glBindTexture(gl.funcs, C.GLenum(target), C.GLuint(texture))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFunc.xml
func (gl *GL) BlendFunc(sfactor, dfactor glbase.Enum) {
	C.gles2_glBlendFunc(gl.funcs, C.GLenum(sfactor), C.GLenum(dfactor))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClear.xml
func (gl *GL) Clear(mask glbase.Bitfield) {
	C.gles2_glClear(gl.funcs, C.GLbitfield(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearColor.xml
func (gl *GL) ClearColor(red, green, blue, alpha glbase.Clampf) {
	C.gles2_glClearColor(gl.funcs, C.GLclampf(red), C.GLclampf(green), C.GLclampf(blue), C.GLclampf(alpha))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glClearStencil.xml
func (gl *GL) ClearStencil(s int32) {
	C.gles2_glClearStencil(gl.funcs, C.GLint(s))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glColorMask.xml
func (gl *GL) ColorMask(red, green, blue, alpha bool) {
	C.gles2_glColorMask(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&red)), *(*C.GLboolean)(unsafe.Pointer(&green)), *(*C.GLboolean)(unsafe.Pointer(&blue)), *(*C.GLboolean)(unsafe.Pointer(&alpha)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage2D.xml
func (gl *GL) CopyTexImage2D(target glbase.Enum, level int, internalFormat glbase.Enum, x, y, width, height, border int) {
	C.gles2_glCopyTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLenum(internalFormat), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLint(border))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage2D.xml
func (gl *GL) CopyTexSubImage2D(target glbase.Enum, level, xoffset, yoffset, x, y, width, height int) {
	C.gles2_glCopyTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glCullFace.xml
func (gl *GL) CullFace(mode glbase.Enum) {
	C.gles2_glCullFace(gl.funcs, C.GLenum(mode))
}

// DeleteTextures deletes the textures objects whose names are stored
// in the textures slice. After a texture is deleted, it has no contents or
// dimensionality, and its name is free for reuse (for example by
// GenTextures). If a texture that is currently bound is deleted, the binding
// reverts to 0 (the default texture).
//
// DeleteTextures silently ignores 0's and names that do not correspond to
// existing textures.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// DeleteTextures is available in GL version 2.0 or greater.
func (gl *GL) DeleteTextures(textures []glbase.Texture) {
	n := len(textures)
	if n == 0 {
		return
	}
	C.gles2_glDeleteTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDepthFunc.xml
func (gl *GL) DepthFunc(glfunc glbase.Enum) {
	C.gles2_glDepthFunc(gl.funcs, C.GLenum(glfunc))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDepthMask.xml
func (gl *GL) DepthMask(flag bool) {
	C.gles2_glDepthMask(gl.funcs, *(*C.GLboolean)(unsafe.Pointer(&flag)))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDisable.xml
func (gl *GL) Disable(cap glbase.Enum) {
	C.gles2_glDisable(gl.funcs, C.GLenum(cap))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawArrays.xml
func (gl *GL) DrawArrays(mode glbase.Enum, first, count int) {
	C.gles2_glDrawArrays(gl.funcs, C.GLenum(mode), C.GLint(first), C.GLsizei(count))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glDrawElements.xml
func (gl *GL) DrawElements(mode glbase.Enum, count int, gltype glbase.Enum, indices interface{}) {
	var indices_ptr unsafe.Pointer
	var indices_v = reflect.ValueOf(indices)
	if indices != nil && indices_v.Kind() != reflect.Slice {
		panic("parameter indices must be a slice")
	}
	if indices != nil {
		indices_ptr = unsafe.Pointer(indices_v.Index(0).Addr().Pointer())
	}
	C.gles2_glDrawElements(gl.funcs, C.GLenum(mode), C.GLsizei(count), C.GLenum(gltype), indices_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glEnable.xml
func (gl *GL) Enable(cap glbase.Enum) {
	C.gles2_glEnable(gl.funcs, C.GLenum(cap))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFinish.xml
func (gl *GL) Finish() {
	C.gles2_glFinish(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFlush.xml
func (gl *GL) Flush() {
	C.gles2_glFlush(gl.funcs)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glFrontFace.xml
func (gl *GL) FrontFace(mode glbase.Enum) {
	C.gles2_glFrontFace(gl.funcs, C.GLenum(mode))
}

// GenTextures returns n texture names in textures. There is no guarantee
// that the names form a contiguous set of integers; however, it is
// guaranteed that none of the returned names was in use immediately before
// the call to GenTextures.
//
// The generated textures have no dimensionality; they assume the
// dimensionality of the texture target to which they are first bound (see
// BindTexture).
//
// Texture names returned by a call to GenTextures are not returned by
// subsequent calls, unless they are first deleted with DeleteTextures.
//
// Error GL.INVALID_VALUE is generated if n is negative.
//
// GenTextures is available in GL version 2.0 or greater.
func (gl *GL) GenTextures(n int) []glbase.Texture {
	if n == 0 {
		return nil
	}
	textures := make([]glbase.Texture, n)
	C.gles2_glGenTextures(gl.funcs, C.GLsizei(n), (*C.GLuint)(unsafe.Pointer(&textures[0])))
	return textures
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetBooleanv.xml
func (gl *GL) GetBooleanv(pname glbase.Enum, params []bool) {
	C.gles2_glGetBooleanv(gl.funcs, C.GLenum(pname), (*C.GLboolean)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetError.xml
func (gl *GL) GetError() glbase.Enum {
	glresult := C.gles2_glGetError(gl.funcs)
	return glbase.Enum(glresult)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetFloatv.xml
func (gl *GL) GetFloatv(pname glbase.Enum, params []float32) {
	C.gles2_glGetFloatv(gl.funcs, C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetIntegerv.xml
func (gl *GL) GetIntegerv(pname glbase.Enum, params []int32) {
	C.gles2_glGetIntegerv(gl.funcs, C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameterfv.xml
func (gl *GL) GetTexParameterfv(target, pname glbase.Enum, params []float32) {
	C.gles2_glGetTexParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameteriv.xml
func (gl *GL) GetTexParameteriv(target, pname glbase.Enum, params []int32) {
	C.gles2_glGetTexParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glHint.xml
func (gl *GL) Hint(target, mode glbase.Enum) {
	C.gles2_glHint(gl.funcs, C.GLenum(target), C.GLenum(mode))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsEnabled.xml
func (gl *GL) IsEnabled(cap glbase.Enum) bool {
	glresult := C.gles2_glIsEnabled(gl.funcs, C.GLenum(cap))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glIsTexture.xml
func (gl *GL) IsTexture(texture glbase.Texture) bool {
	glresult := C.gles2_glIsTexture(gl.funcs, C.GLuint(texture))
	return *(*bool)(unsafe.Pointer(&glresult))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glLineWidth.xml
func (gl *GL) LineWidth(width float32) {
	C.gles2_glLineWidth(gl.funcs, C.GLfloat(width))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPixelStorei.xml
func (gl *GL) PixelStorei(pname glbase.Enum, param int32) {
	C.gles2_glPixelStorei(gl.funcs, C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glPolygonOffset.xml
func (gl *GL) PolygonOffset(factor, units float32) {
	C.gles2_glPolygonOffset(gl.funcs, C.GLfloat(factor), C.GLfloat(units))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glReadPixels.xml
func (gl *GL) ReadPixels(x, y, width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gles2_glReadPixels(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glScissor.xml
func (gl *GL) Scissor(x, y, width, height int) {
	C.gles2_glScissor(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilFunc.xml
func (gl *GL) StencilFunc(glfunc glbase.Enum, ref int32, mask uint32) {
	C.gles2_glStencilFunc(gl.funcs, C.GLenum(glfunc), C.GLint(ref), C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilMask.xml
func (gl *GL) StencilMask(mask uint32) {
	C.gles2_glStencilMask(gl.funcs, C.GLuint(mask))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glStencilOp.xml
func (gl *GL) StencilOp(fail, zfail, zpass glbase.Enum) {
	C.gles2_glStencilOp(gl.funcs, C.GLenum(fail), C.GLenum(zfail), C.GLenum(zpass))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexImage2D.xml
func (gl *GL) TexImage2D(target glbase.Enum, level int, internalFormat int32, width, height, border int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gles2_glTexImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(internalFormat), C.GLsizei(width), C.GLsizei(height), C.GLint(border), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameterf.xml
func (gl *GL) TexParameterf(target, pname glbase.Enum, param float32) {
	C.gles2_glTexParameterf(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLfloat(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameterfv.xml
func (gl *GL) TexParameterfv(target, pname glbase.Enum, params []float32) {
	C.gles2_glTexParameterfv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLfloat)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameteri.xml
func (gl *GL) TexParameteri(target, pname glbase.Enum, param int32) {
	C.gles2_glTexParameteri(gl.funcs, C.GLenum(target), C.GLenum(pname), C.GLint(param))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexParameteriv.xml
func (gl *GL) TexParameteriv(target, pname glbase.Enum, params []int32) {
	C.gles2_glTexParameteriv(gl.funcs, C.GLenum(target), C.GLenum(pname), (*C.GLint)(unsafe.Pointer(&params[0])))
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glTexSubImage2D.xml
func (gl *GL) TexSubImage2D(target glbase.Enum, level, xoffset, yoffset, width, height int, format, gltype glbase.Enum, pixels interface{}) {
	var pixels_ptr unsafe.Pointer
	var pixels_v = reflect.ValueOf(pixels)
	if pixels != nil && pixels_v.Kind() != reflect.Slice {
		panic("parameter pixels must be a slice")
	}
	if pixels != nil {
		pixels_ptr = unsafe.Pointer(pixels_v.Index(0).Addr().Pointer())
	}
	C.gles2_glTexSubImage2D(gl.funcs, C.GLenum(target), C.GLint(level), C.GLint(xoffset), C.GLint(yoffset), C.GLsizei(width), C.GLsizei(height), C.GLenum(format), C.GLenum(gltype), pixels_ptr)
}

// https://www.opengl.org/sdk/docs/man2/xhtml/glViewport.xml
func (gl *GL) Viewport(x, y, width, height int) {
	C.gles2_glViewport(gl.funcs, C.GLint(x), C.GLint(y), C.GLsizei(width), C.GLsizei(height))
}
