/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.react.bridge;

import com.facebook.jni.Countable;
import com.facebook.proguard.annotations.DoNotStrip;

@DoNotStrip
public abstract class JavaScriptExecutor extends Countable {
  public interface Factory {
    JavaScriptExecutor create(WritableNativeMap jscConfig) throws Exception;
  }

  /**
   * Close this executor and cleanup any resources that it was using. No further calls are
   * expected after this.
   */
  public void close() {
  }

}
