/**
 * Copyright (c) 2015-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.react.bridge;

import com.facebook.proguard.annotations.DoNotStrip;

@DoNotStrip
public interface ReactCallback {

  @DoNotStrip
  void call(ExecutorToken executorToken, int moduleId, int methodId, ReadableNativeArray parameters);

  @DoNotStrip
  void onBatchComplete();

  @DoNotStrip
  void onExecutorUnregistered(ExecutorToken executorToken);
}
