// Copyright 2004-present Facebook. All Rights Reserved.

#pragma once

#include <fb/fbjni.h>
#include <folly/dynamic.h>

namespace facebook {
namespace react {

struct ReadableType : public jni::JavaClass<ReadableType> {
  static auto constexpr kJavaDescriptor = "Lcom/facebook/react/bridge/ReadableType;";

  static jni::local_ref<ReadableType> getType(folly::dynamic::Type type);
};

namespace exceptions {

extern const char *gUnexpectedNativeTypeExceptionClass;

template <typename T>
void throwIfObjectAlreadyConsumed(const T& t, const char* msg) {
  if (t->isConsumed) {
    jni::throwNewJavaException("com/facebook/react/bridge/ObjectAlreadyConsumedException", msg);
  }
}

} // namespace exceptions

} // namespace react
} // namespace facebook
