/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.buck.android.support.exopackage;

import android.annotation.TargetApi;
import dalvik.system.BaseDexClassLoader;
import dalvik.system.DexClassLoader;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;

class SystemClassLoaderAdder {
    private SystemClassLoaderAdder() {
    }

    static void installDexJars(ClassLoader appClassLoader, File optimizedDirectory, List<File> dexJars) {
        SystemClassLoaderAdder classLoaderAdder = new SystemClassLoaderAdder();
        for (File dexJar : dexJars) {
            DexClassLoader newClassLoader = new DexClassLoader(dexJar.getAbsolutePath(), optimizedDirectory.getAbsolutePath(), null, appClassLoader);
            classLoaderAdder.addPathsOfClassLoaderToSystemClassLoader(newClassLoader, (PathClassLoader)appClassLoader);
        }
    }

    private void addPathsOfClassLoaderToSystemClassLoader(DexClassLoader newClassLoader, PathClassLoader systemClassLoader) {
        try {
            if (this.existsBaseDexClassLoader()) {
                this.addNewClassLoaderToSystemClassLoaderWithBaseDex(newClassLoader, systemClassLoader);
            } else {
                this.addNewClassLoaderToSystemClassLoaderPreBaseDex(newClassLoader, systemClassLoader);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean existsBaseDexClassLoader() {
        try {
            Class.forName("dalvik.system.BaseDexClassLoader");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void addNewClassLoaderToSystemClassLoaderWithBaseDex(DexClassLoader newClassLoader, PathClassLoader systemClassLoader) throws NoSuchFieldException, IllegalAccessException {
        Object currentElementsArray = this.getDexElementsArray(this.getDexPathList((BaseDexClassLoader)systemClassLoader));
        Object newElementsArray = this.getDexElementsArray(this.getDexPathList((BaseDexClassLoader)newClassLoader));
        Object mergedElementsArray = this.mergeArrays(currentElementsArray, newElementsArray);
        this.setDexElementsArray(this.getDexPathList((BaseDexClassLoader)systemClassLoader), mergedElementsArray);
    }

    private void addNewClassLoaderToSystemClassLoaderPreBaseDex(DexClassLoader newClassLoader, PathClassLoader systemClassLoader) throws NoSuchFieldException, IllegalAccessException {
        try {
            newClassLoader.loadClass("foo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.setField(systemClassLoader, PathClassLoader.class, "mPaths", this.mergeArrayAndScalar(this.getField(systemClassLoader, PathClassLoader.class, "mPaths"), this.getField(newClassLoader, DexClassLoader.class, "mRawDexPath")));
        this.setField(systemClassLoader, PathClassLoader.class, "mFiles", this.mergeArrays(this.getField(systemClassLoader, PathClassLoader.class, "mFiles"), this.getField(newClassLoader, DexClassLoader.class, "mFiles")));
        this.setField(systemClassLoader, PathClassLoader.class, "mZips", this.mergeArrays(this.getField(systemClassLoader, PathClassLoader.class, "mZips"), this.getField(newClassLoader, DexClassLoader.class, "mZips")));
        this.setField(systemClassLoader, PathClassLoader.class, "mDexs", this.mergeArrays(this.getField(systemClassLoader, PathClassLoader.class, "mDexs"), this.getField(newClassLoader, DexClassLoader.class, "mDexs")));
    }

    @TargetApi(value=14)
    private Object getDexPathList(BaseDexClassLoader classLoader) throws NoSuchFieldException, IllegalAccessException {
        return this.getField(classLoader, BaseDexClassLoader.class, "pathList");
    }

    private Object getDexElementsArray(Object dexPathList) throws NoSuchFieldException, IllegalAccessException {
        return this.getField(dexPathList, dexPathList.getClass(), "dexElements");
    }

    private void setDexElementsArray(Object dexPathList, Object newElementArray) throws NoSuchFieldException, IllegalAccessException {
        this.setField(dexPathList, dexPathList.getClass(), "dexElements", newElementArray);
    }

    private Object mergeArrays(Object array1, Object array2) {
        Class<?> arrayClass = array1.getClass();
        Class<?> itemClass = arrayClass.getComponentType();
        int array1Size = Array.getLength(array1);
        int array2Size = Array.getLength(array2);
        int newSize = array1Size + array2Size;
        Object newArray = Array.newInstance(itemClass, newSize);
        for (int i = 0; i < newSize; ++i) {
            if (i < array1Size) {
                Array.set(newArray, i, Array.get(array1, i));
                continue;
            }
            Array.set(newArray, i, Array.get(array2, i - array1Size));
        }
        return newArray;
    }

    private Object mergeArrayAndScalar(Object array, Object scalar) {
        Class<?> arrayClass = array.getClass();
        Class<?> itemClass = arrayClass.getComponentType();
        int array1Size = Array.getLength(array);
        int newSize = array1Size + 1;
        Object newArray = Array.newInstance(itemClass, newSize);
        for (int i = 0; i < newSize; ++i) {
            if (i < array1Size) {
                Array.set(newArray, i, Array.get(array, i));
                continue;
            }
            Array.set(newArray, i, scalar);
        }
        return newArray;
    }

    private Object getField(Object object, Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(object);
    }

    private void setField(Object object, Class<?> clazz, String fieldName, Object fieldValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, fieldValue);
    }
}

