/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

#import <ReactCommon/RCTTurboModule.h>

namespace facebook {
namespace react {

/**
 * Provide the TurboModule class for the given name.
 */
Class RNTesterTurboModuleClassProvider(const char *name);

/**
 * Provide a pure C++ instance of a TurboModule, specific to this app.
 */
std::shared_ptr<TurboModule> RNTesterTurboModuleProvider(const std::string &name, std::shared_ptr<CallInvoker> jsInvoker);

/**
 * Provide an instance of a ObjCTurboModule, given the ObjC instance, specific to this app.
 */
std::shared_ptr<TurboModule> RNTesterTurboModuleProvider(const std::string &name,
                                                         id<RCTTurboModule> instance,
                                                         std::shared_ptr<CallInvoker> jsInvoker,
                                                         std::shared_ptr<CallInvoker> nativeInvoker,
                                                         id<RCTTurboModulePerformanceLogger> perfLogger);

} // namespace react
} // namespace facebook
