<!--
order: 3
-->

# Delegator Security

The launch of any public blockchain is an incredibly exciting time, and it's definitely one that malicious actors may try to take advantage of for their own personal gain. Owning and having access to cryptocurrency can make you a valuable target for an attacker, but there are many things you can do to improve your personal security and reduce or eliminate security risks.

## Social Engineering

_[Social engineering](https://en.wikipedia.org/wiki/Social_engineering_(security))_ has existed for about as long as human beings have been on the planet, and in the technical era, it usually takes in the form of  [phishing](https://ssd.eff.org/en/module/how-avoid-phishing-attacks)  or  [spearphishing](https://en.wikipedia.org/wiki/Phishing#Spear_phishing) . Both of these attacks are wildly successful forms of trickery that are responsible for over 95% of account security breaches, and they don't just happen via email: these days, opportunistic and targeted phishing attempts take place  [anywhere that you have an inbox](https://www.umass.edu/it/security/phishing-fraudulent-emails-text-messages-phone-calls) . It doesn't matter if you're using Signal, Telegram, SMS, Twitter, or just checking your DMs on forums or social networks, attackers have a  [plethora of opportunities](https://jia.sipa.columbia.edu/weaponization-social-media-spear-phishing-and-cyberattacks-democracy)  to gain foothold in your digital life in effort to separate you from valuable information and assets that you most definitely don't want to lose. If a deal pops up that  [sounds too good to be true](https://www.psychologytoday.com/us/blog/mind-in-the-machine/201712/how-fear-is-being-used-manipulate-cryptocurrency-markets) , or a message shows up asking for information that should never, ever be shared with someone else, you can always verify it before engaging with it by navigating to our official website or an official Cosmos communication channel on your own. 

* **Be skeptical of unexpected attachments, or emails that ask you to visit a suspicious or unfamiliar website in the context of blockchains or cryptocurrency.** An attacker may attempt to lure you to a  [compromised site](https://blog.malwarebytes.com/cybercrime/2013/02/tools-of-the-trade-exploit-kits/)  designed to steal sensitive information from your computer. If you're a Gmail user, test your resilience against the latest email-based phishing tactics  [here](https://phishingquiz.withgoogle.com/) . 

* **Do your due diligence before purchasing ATOM. Neither the Tendermint team nor the Interchain Foundation will be selling ATOM at launch**, so if you see social media posts or emails advertising a token sale from us, they're not real and should be dismissed immediately. If you're on the hunt for ATOM, make sure that you've researched the seller or exchange to confirm that the tokens are coming from a trustworthy source. 

* **No one from Cosmos, the Tendermint team or the Interchain Foundation will ever send an email that asks for you to share any kind of account credentials or your 12 words with us**, and we will always use our official Twitter, Medium, and Github accounts to communicate important news directly to the Cosmos community.

If you receive an email or tweet that sounds too good to be true, is likely to be a scam.  


## Key Management 
The best way to minimize the risk of theft or loss of ATOM is to have a strong storage and backup strategy for your private keys.  The safest way to store your keys is offline,  either in a cryptocurrency wallet or on a device that you never connect to the internet. The best backup strategy for your k yes is to ensure that you have multiple copies of them stored in safe places, and to take specific measures to protect at least one copy of your keys from any kind of natural disaster that is a likely possibility in your part of the world. 

**To protect your ATOM, do not share your 12 words with anyone.** The only person who should ever need to know them is you. You do not need to share your private keys if you're delegating ATOM to a validator on the network or to use custodial services. If anyone asks for your key material, 


## Software Vulnerabilities
To protect yourself and ensure you're using the safest code is to use the latest version of software available, and to update immediately (or as soon as you can) after a security advisory is released. This is important for your laptops, mobile devices, cryptocurrency wallets, and anything else that may be linked to your identity or your cryptocurrency. 

*To protect your ATOM, you should only download software directly from official sources, and make sure that you're always using the latest, most secure version of `gaiacli` when you're doing anything that involves your 12 words*. The latest versions of `Tendermint`, the `Cosmos-SDK`, and `gaiacli` will always be available from our official Github repositories.

No one from Cosmos, the Tendermint team or the Interchain Foundation will ever send an email that asks for you to download a software attachment  after sending out a security advisory or making a patch available. 


## Verifying Transactions
Be skeptical of technical advice, especially advice that comes from people you do not know in forums and on group chat channels. Familiarize yourself with important commands, especially those that will help you carry out high-risk actions, and consult our official documentation to make sure that you're not being tricked into doing something that will harm you or your validator. 

**When sending transactions or doing anything that may spend coins, you should always verify those transactions before hitting send**. While address strings are long, it is important to visually comparing them in blocks of 4 characters at a time to ensure that you are sending them to the right place rather than into oblivion. 

## Account Security
One of the most important things  you can do to protect your cryptocurrency and eliminate risk is to harden all of your critical online accounts. Attackers will try to gain foothold wherever they can, and will use that foothold to pivot from one place to another. Unprotected accounts like email, social media, your Github account, the Cosmos Forum and anything in between could give an attacker an opportunities to gain foothold in your online life. 

For people who hold cryptocurrency, there are two specific account  security actions that can be taken to eliminate specific risks that come with being part of the blockchain world. 

*  First, it is important to enable 2-factor authentication everywhere you can, and to make sure that you are using a code generator or [U2F hardware key](https://en.wikipedia.org/wiki/Universal_2nd_Factor) as a second factor. 

* Second,  be mindful of account recovery methods used to regain access to your most important accounts and make sure that you do not use SMS as a recovery method. If you haven't done so yet, start using an authenticator app or a hardware key immediately for your personal email account and wherever else you manage your tokens, especially if you use online exchanges.


## Supply Chain Attacks
Whether you're buying a hardware or a hardware wallet, it is important  to purchase whatever you need directly from the supplier or from a trusted source. This is the only way to completely eliminate the risk of a compromised device or chip from stealing your private keys, especially since there are reports of compromised wallets being sold on Amazon and through other popular online marketplaces. 

## Disclaimer

Please note that this is highly experimental software. In these early days, we can expect to have issues, updates, and bugs. The existing tools require advanced technical skills and involve risks which are outside of the control of the Interchain Foundation and/or the Tendermint team (see also the risk section in the Interchain Cosmos Contribution Terms). Any use of this open source Apache 2.0 licensed software is done at your own risk and on a "AS IS" basis, without warranties or conditions of any kind, and any and all liability of the Interchain Foundation and/or the Tendermint team for damages arising in connection to the software is excluded. Please exercise extreme caution!`