<!--
order: 1
-->

![Welcome to the Cosmos Hub](../images/cosmos-hub-image.jpg)

# Introduction

The Cosmos Hub is the first of [thousands of interconnected blockchains](https://cosmos.network) that will eventually comprise the **Cosmos Network**. The primary token of the Cosmos Hub is the **ATOM**, but the Hub will support many tokens in the future.

## The ATOM

Do you have ATOM tokens? With ATOM, you have the superpower to contribute to the security and governance of the Cosmos Hub. Delegate your ATOM to one or more of the 100 validators on the Cosmos Hub blockchain to earn more ATOM through Proof-of-Stake. You can also vote with your ATOM to influence the future of the Cosmos Hub through on-chain governance proposals.

Learn more about [being a delegator](../delegators/delegator-faq.md), learn about [the security risks](../delegators/delegator-security.md), and start participating with one of the following wallets.

## Cosmos Hub Wallets

::: warning
Do your own research and take precautions in regards to wallet security. Neither Tendermint Inc nor the Interchain Foundation is liable if you lose your funds using these third party wallets.
:::

These community-maintained web and mobile wallets allow you to store & transfer ATOM, delegate ATOM to validators, and vote on on-chain governance proposals. Note that we do not endorse any of the wallets, they are listed for your convenience.

* [Atomic Wallet](https://atomicwallet.io/) - Android, Linux, macOS, Windows
* [Cobo](https://cobo.com/) - Android, iOS
* [Cosmostation](https://www.cosmostation.io/) - Android, iOS
* [Huobi Wallet](https://www.huobiwallet.com/) - Android, iOS
* [imToken](https://token.im/) - Android, iOS
* [Lunagram](https://lunamint.com/) - Android, iOS
* [Lunie](https://lunie.io) - Web
* [Math Wallet](https://www.mathwallet.org/en/) - Android, iOS, Web
* [Rainbow Wallet](https://www.rainbow.one) - Android, iOS
* [Qbao Wallet](https://qbao.fund/) - Android, iOS
* [Trust Wallet](https://trustwallet.com/) Android, iOS
* [Wetez](https://www.wetez.io/pc/homepage) - Android, iOS


## Cosmos Hub Explorers

These block explorers allow you to search, view and analyze Cosmos Hub data&mdash;like blocks, transactions, validators, etc.

* [Big Dipper](https://cosmos.bigdipper.live)
* [Cosmos Overview](https://genesislab.net)
* [Coris](http://coris.network)
* [Cosmos Visualizer](https://nylira.net/3d)
* [Hubble](https://hubble.figment.network)
* [Mintscan](https://mintscan.io)
* [Stargazer](https://stargazer.certus.one)

## Cosmos Hub CLI

`gaiacli` is a command-line interface that lets you interact with the Cosmos Hub. `gaiacli` is the only tool that supports 100% of the Cosmos Hub features, including accounts, transfers, delegation, and governance. Learn more about `gaiacli` with the [delegator's CLI guide](../delegators/delegator-guide-cli.md).

## Running a full-node on the Cosmos Hub Mainnet

In order to run a full-node for the Cosmos Hub mainnet, you must first [install `gaiad`](../gaia-tutorials/installation.md). Then, follow [the guide](../gaia-tutorials/join-mainnet.md).

If you are looking to run a validator node, follow the [validator setup guide](../validators/validator-setup.md).

## Join the Community

Have questions, comments, or new ideas? Participate in the Cosmos community through one of the following channels. Also check out the [latest events](https://cosmos.network/community).

* [Cosmos Community Chat](https://t.me/cosmosproject)
* [Cosmos Developer Chat](https://riot.im/app/#/room/#cosmos:matrix.org)
* [Cosmos Forum](https://forum.cosmos.network)
* [Cosmos on Reddit](https://reddit.com/r/cosmosnetwork)

To learn more about the Cosmos Hub and how it fits within the Cosmos Network, visit [cosmos.network](https://cosmos.network).