# 코스모스 허브 메인넷의 시작

#### 런칭 준비 체크리스트 & 안전하게 아톰 수령하기

2016년 여름, 코스모스 [백서가](https://cosmos.network/resources/whitepaper) 세상에 공개되었습니다. 이후 2017년 봄, 코스모스의 [펀드레이저가](펀드레이저가) 성공적으로 완료되었습니다. 그리고 2019년 2월, 코스모스의 소프트웨어[가 기능 완성](https://github.com/cosmos/cosmos-sdk/releases/tag/v0.31.0)(feature complete)단계에 도달했습니다. 이제 코스모스 허브의 런칭을 앞두고 있는 이 시점에서, 아톰 보유자들은 무엇을 해야될까요?

아톰 보유자는 메인넷에서 본인의 아톰을 검증인에게 위임하고 거버넌스 프로포절에 투표를 할 수 있는 권리를 가질 수 있게 됩니다. 어떻게 보면 위임자들의 선택이 코스모스 네트워크의 성공을 좌우할 수 있다고 볼 수 있습니다. 단, 런칭 초기 아톰 송금 기능은 프로토콜 레벨에서 비활성화될 계획이며, 추후 하드포크를 통해 활성화될 것입니다.

**📒 안전하게 아톰을 위임하기 원하는 아톰 보유자들은 다음 가이드라인을 숙지하시고 따르시기 바랍니다. 본인의 안전을 위해서 [CLI 사용법](https://github.com/cosmos/gaia/blob/develop/docs/delegators/delegator-guide-cli.md)을 충분히 숙지하기 전에는 별도의 행동을 하시지 않는 것을 추천해 드립니다.**

안전하게 아톰을 위임하는 방법은 이 가이드에 설명된 것 외에는 없습니다. 현재로써 `wasmcli` 외 보안 감사를 거친 월렛 소프트웨어는 없습니다. 다른 월렛은 보안 감사를 시작하지 않은 상태입니다.

추가로 아톰을 위임하는 행위에는 매우 큰 리스크가 존재한다는 점을 인지하셔야 합니다. 한번 검증인에게 위임된 아톰은 일정 기간동안 묶이게 되며, 이 스테이킹 기간 동안 검증인의 실수로 슬래싱(아톰 삭감)이 발생하는 경우 위임자의 아톰 또한 함께 삭감될 수 있습니다. 검증인들에 대한 충분한 정보를 미리 확인하고 위임을 진행하는 것은 각 위임자의 책임입니다.

**코스모스 허브는 매우 실험적인 소프트웨어입니다. 메인넷 초기에는 다수의 문제, 업데이트 그리고 버그가 존재할 수 있습니다. 현재 제공되는 도구를 사용하는데에는 상당한 기술적 실력이 필요하며, 인터체인 재단과 텐더민트 팀의 컨트롤 밖에 있는 리스크가 존재합니다 (관련 리스크에 대한 자세한 정보는 인터체인 [코스모스 펀드레이저 약관](https://github.com/cosmos/cosmos/blob/master/fundraiser/Interchain%20Cosmos%20Contribution%20Terms%20-%20FINAL.pdf)을 참고하세요). [아파치 2.0 라이선스](https://www.apache.org/licenses/LICENSE-2.0) 기반의 오픈 소스 소프트웨어를 사용함으로 발생하는 리스크는 본인의 책임이며, 어떠한 보증과 조건이 따르지 않습니다. 소프트웨어 사용으로 발생하는 문제에 대해서 인터체인 재단과 텐더민트는 책임을 지지 않습니다. 상당한 주의를 기울이며 신중하게 진행하시기 바랍니다.**

만약 위임 절차에 대한 질문이 있거나, 코스모스 개발자들과 대화를 나누고 싶으시다면 2월 14일에 열리는 온라인 밋업에 참가해주세요. 해당 밋업에서 런칭 때 아톰을 위임하는 절차를 한 단계씩 설명해 드릴 예정입니다.

등록 링크: [gotowebinar.com/register/](https://register.gotowebinar.com/register/5028753165739687691)

## 런칭을 위해 남은 마일스톤

🚦메인넷 런칭 프로세스를 확인하기 위해서는 다음 링크를 참고하세요: [cosmos.network/launch](https://cosmos.network/launch)

### 5: 코스모스 SDK 보안 감사 ✔
지난 1월, 코스모스 SDK는 다수의 외부 보안 감사 절차의 첫 단계를 진행했습니다. 보안 감사는 약 2주 반 기간에 걸려 진행되었습니다. 현재 두 개의 기관이 코스모스 SDK 코드를 검증한 상태이며, 다른 한 개 기관의 보안 감사가 진행 중입니다.

### 4: 코스모스 SDK 기능 동결 (feature freeze)
코스모스 SDK의 최종 주요 수정 사항은 [SDK v0.31.0 RC에](https://github.com/cosmos/cosmos-sdk/projects/27) 반영되었습니다. 해당 RC(Release candidate)가 완료된 후, 코스모스 SDK 팀은 추가적인 디버깅을 진행하여 런칭 전 보안성 확보를 위해 노력을 기울일 예정입니다.

코스모스 SDK v0.31.0이 릴리즈된 후, 혹시라도 발견되지 않은 버그를 검증하기 위해 Gaia 테스트넷을 추가로 진행할 계획입니다.

### 3: 게임 오브 스테이크 완료
지난 2018년 12월, 사상 최초의 경쟁적 테스트넷인 게임 오브 스테이크(GoS, Game of Stakes)가 시작되었습니다. GoS의 목표는 경제적 인센티브 검증, 지분증명으로 보안이 유지되는 블록체인의 사회적 요소를 검증하기 위해 진행되었습니다. 이후, GoS는 무려 3번의 하드 포크를 성공적으로 진행했습니다. GoS가 완료된 후, 점수 측정 기준을 기반으로 우승자를 발표하게 될 계획입니다.

### 2: 제네시스 트랜잭션 모으기
제네시스 시점에서 인터체인 재단은 아톰 분배 권고를 작성합니다. 여기에는 코스모스 펀드레이저 참가자, 초기 기여자, 게임 오브 스테이크 우승자 등이 포함됩니다. 아톰 분배 권고 목록에 포함된 인원은 `gentx`를 제출할 수 있으며, 제네시스 검증인이 되기 위해서 `gentx` 제출은 필수입니다. 이후 모든 `gentx` 파일이 모이게 되면 최종 제네시스 파일이 만들어집니다.

### 1: 코스모스 허브 메인넷 런칭 🔥 🚀 🌔🔥
+⅔의 보팅 파워가 온라인 상태가 되고, 커뮤니티가 제네시스 파일을 승인하게 된다면 코스모스 메인넷이 시작됩니다.

## 공식 코스모스 소통 채널
런칭 관련 소식을 전하는 공식 소통 채널은 다음과 같습니다:

* 코스모스 트위터 (twitter.com/cosmos)
* 코스모스 깃허브 (github.com/cosmos)
* 코스모스 블로그 (blog.cosmos.network)

또한 [코스모스 포럼](https://forum.cosmos.network/), [라이엇 그룹 채팅](https://riot.im/app/#/group/+cosmos:matrix.org) 그리고 [텔레그램 방](http://t.me/cosmosproject)은 코스모스의 공식적인 소식을 전달하는 채널이 아니라는 것을 인지하시기 바랍니다.

만약 앞으로 진행해야 하는 절차가 어렵거나 특정 정보의 소스를 확인할 수 없는 경우, 초기 시점에서 아무 행동을 하지 않고 위 3개의 공식 채널로 전달되는 업데이트를 확인하시기 바랍니다. 12개의 시드 단어를 그 어떤 단톡방 관리자, 웹사이트, 비공식 소프트웨어에 제공하지 마십시오.

**코스모스 팀은 절대로 개인적인 채널을 통해 프라이빗 키 또는 시드 단어를 요청하지 않습니다.**

## 메인넷 런칭때 안전할 수 있는 방법은?

런칭 시기가 다가오며 코스모스 허브 메인넷에 대한 기대감 또한 커지고 있습니다. 하지만 이런 시기를 틈타 일부는 본인의 이득을 위해 악의적이 행동을 할 확률 또한 높습니다. [사회 공학](https://terms.naver.com/entry.nhn?docId=863068&cid=42346&categoryId=42346) (social engineering)을 이용한 범죄는 인류 역사에서 꾸준히 있었으며, 오늘까지 [스피어피싱](https://terms.naver.com/entry.nhn?docId=3434661&cid=40942&categoryId=32828)과 [피싱 공격](https://terms.naver.com/entry.nhn?docId=3432525&cid=58445&categoryId=58445) 같은 일종의 범죄 수단으로 이어지고 있습니다.

약 성공한 공격의 95%는 스피어피싱과 피싱 공격으로 이루어졌으며, 이메일 외의 다수의 수단을 통해서도 일어나고 있습니다. 카카오톡, 텔레그램, 문자 메시지, 트위터 등 해커들의 공격 수단은 매우 다양하며, 개인의 자산과 개인 정보를 탈취하고 있습니다.

이런 공격을 대비하는 것은 벅차게 느껴질 수 있지만 몇 가지 유의 사항을 참고하신다면 공격의 위험을 크게 낮출 수 있습니다. 메인넷 런칭 준비에 관련해서는 다음 가이드라인이 보안적 리스크를 줄이고 정보를 검증하는데 도움이 될 수 있을 것입니다.

## 다음은 코스모스 메인넷 런칭 준비 유의사항입니다:

* 모든 소프트웨어는 공식 채널을 통해서만 다운로드를 하십시오. 또한, 12개 시드키가 입력될 수 있는 모든 작업은 최신 `wasmcli` 버전만을 사용하시기 바랍니다. 텐더민트, 코스모스 SDK 그리고 `wasmcli` 최신 버전은 공식 코스모스 깃허브를 통해서 배포됩니다. 공식 깃허브를 통해서 소프트웨어를 다운로드 함으로써 악의적으로 수정된 소프트웨어를 사용하는 것을 방지할 수 있습니다.
* 12개 시드 단어(시드 키)를 그 누구에게도 알려주지 마십시오. 시드 키는 오직 본인만이 관리해야 합니다. 특히 아톰 보관, 거래 등을 대행해주는 행위를 사칭하여 접근하는 사람들을 유의하십시오. 시드키를 안전하게 관리하기 위해서는 도난으로부터 안전한 오프라인 장소에 보관하시고, 혹시 모를 상황을 대비한 백업 수단을 유지하십시오. *시드키를 절대로 제삼자와 공유하지 마십시오.*
* 블록체인 또는 암호화폐 관련된 이메일과 웹사이트에서 다운로드를 유도하는 첨부 파일을 유의하십시오. 해커는 악의적으로 수정된 웹사이트를 통해서 컴퓨터 내에 있는 파일을 탈취할 수 있습니다. Gmail을 사용하신다면 흔히 사용되는 이메일 기반 피싱 공격을 다음 링크에서 확인하세요.
* 아톰 구매 시 충분한 검증을 진행하세요. 메인넷 런칭 초기에는 아톰 송금이 불가능 하므로, 송금 활성화가 되기 전에는 아톰 매수/매도가 불가능합니다. 또한 송금이 활성화된 후에도 매수/매도를 진행하는 거래소가 안전한지 확인을 하십시오.
* 텐더민트 팀 또는 인터체인 재단은 **절대로** 아톰을 팔지 않습니다. 만약 소셜 미디어 또는 이메일을 통한 토큰 세일 제안이 있다면, 해당 정보는 허위 정보입니다.
* 2단계 인증(2-factor authentication)을 활성화 하시고 주요 계정 복구 수단을 확인하십시오. 이메일, 소셜 미디어 계정, 깃허브 계정, 코스모스 포럼 계정 등은 공격자가 본인의 온라인 계정을 탈취할 수 있는 플랫폼을 제공합니다. 현재 2단계 인증을 사용하고 계시지 않는다면 활성화하시고 추가로 토큰 관리에 하드웨어 기반 키를 사용하시는 방법을 추천해 드립니다. 위 방법은 간단하지만 효율적으로 계정 탈취 가능성을 줄여줍니다.
* 포럼 또는 단톡방을 통해서 모르는 사람이 기술적 조언을 제공하는 것에 주의를 기울이십시오. 리스크가 높은 행동(토큰 전송, 키 입력 등)들의 명령어에 익숙해지시고 공식 문서를 참고하셔서 본인의 자산을 위험에 취할 수 있는 행동을 숙지하십시오. 코스모스 포럼, 라이엇 채팅 그리고 텔레그램 방은 공식 뉴스 제공 채널이 아니라는 점을 인지하십시오.
* 모든 송금 트랜잭션을 발생하기 전에 관련 정보를 확인하세요. 코스모스 주소는 길 수 있지만 4개 단어로 묶어서 확인하는 습관이 실수로 토큰을 소각하는 것을 방지할 수 있습니다.

만약 누군가 과도하게 좋은 조건으로 코스모스 관련 서비스를 제공한다면 우선 의심을 하시는 것을 추천합니다. 주요 정보는 그 어떤 상황에서도 외부인과 공유하면 안 됩니다. 또한 모든 정보를 공식 채널들을 통해 확인하십시오.

코스모스 팀, 텐더민트 팀 그리고 인터체인 팀은 개인 정보를 요청하거나 12개 시드키를 요구하는 이메일을 보내지 않습니다. 코스모스 팀은 언제나 공식 블로그, 트위터 그리고 깃허브를 통해서만 소통을 진행합니다.

#### Thank you to Cosmos Korea!
* 텔레그램: https://t.me/cosmoskr
* 페이스북 : https://facebook.com/groups/cosmoskorea

참고: 이 글은 정보 제공을 위하여 번역된 글입니다. 내용/해석에 차이가 있을 수 있으며, 이 경우 영문 원문이 상위 권한을 가집니다.
