# 코스모스 허브 메인넷의 세 가지 단계
## 메인넷 후 개발 로드맵과 유저들을 위한 필수 정보

코스모스 허브의 런칭은 단계별로 나뉘어 진행될 계획입니다. 다음은 각 단계별로 어떤 사항들이 진행될지에 대한 요약입니다.

# 🚨1단계: 네트워크 안정성 확보 🚨

메인넷의 최초 단계인 1단계에서 코스모스 네트워크는 다소 불안정할 수 있습니다. 메인넷 초기에는 네트워크 중단 같은 문제들이 발생할 확률이 존재합니다.

혹시라도 발생할 수 있는 문제들을 해결하기 위해서는 코스모스 허브 검증인 간, 풀노드 운영자 등 참여자들 간의 긴밀한 협업이 필요합니다.

유저는 충분한 네트워크 안정성이 확보될 때까지 문제들이 발생할 수 있다는 것을 인지해야 합니다.

**블록체인 롤백과 메인넷 런칭**

블록체인 기술의 핵심 이념 중 하나는 불가역성(immutability)입니다.

불가역성이란 이미 진행된 블록체인의 기록을 되돌아가 바꾸지 않는다는 것입니다. 블록체인의 불가역성은 소프트웨어 계층에서 합의 프로토콜의 형태로 전개되지만, 궁극적으로 네트워크 참여자들의 사회적 계약(social contract) 형태로 유지됩니다.

여기서 참고할 것은 코스모스 허브는 의도적으로 포크와 롤백 절차를 간소화할 수 있도록 설계되었다는 것입니다. 코스모스 커뮤니티는 테스트넷 단계에서 이런 기능을 실제 사용했으며, 메인넷에서 또한 사용될 수 있습니다. 포크와 롤백 기능은 특정 카르텔 집단이 네트워크를 점령하는 것에 대한 대응 도구로 사용될 수 있습니다.

대다수의 블록체인 커뮤니티는 롤백을 부정적으로 인식하고 있으며 매우 신중하게 결정되어야 합니다. 블록체인의 상태를 되돌린다는 것은 블록체인 네트워크의 경제적 완결성(economic finality)을 깨트리는 행동입니다. 그렇기 때문에 블록체인 롤백은 이더리움의 The DAO 하드포크 같은 극한 상황 상황에서만 사용되어야 합니다.

단, 코스모스 허브 네트워크의 초기 단계에서는 토큰 전송 기능이 비활성화된 상태로 시작됩니다. 이런 특성은 블록체인 롤백의 중대성을 줄이게 되며 블록체인 상태의 변경의 ‘경제적 완결성’을 낮추게 됩니다. 버그 등 문제 발생으로 블록체인 롤백이 필요하다는 판단이 내려지는 경우, 테스트넷과 같이 블록체인 상태 롤백이 제네시스 블록까지도 진행될 수 있습니다.

거버넌스에 의하여 토큰 전송이 활성화되는 경우, 코스모스 네트워크는 경제적 완결성을 따르게 됩니다.

위 내용을 요약하자면, 토큰 전송이 활성화되기 전 코스모스 허브에 에러 또는 취약점이 발견되는 경우, 블록체인의 (제네시스 상태까지) 롤백이 진행될 수 있습니다.

하지만 토큰 전송이 활성화된 뒤라면 블록체인 롤백을 정당화하는 것은 상당히 어렵게 됩니다.

**개발자 참고 사항**: 코스모스 메인넷 런칭은 펀드레이저 참가자들이 협동하여 코스모스 허브 소프트웨어를 운영하는 첫 단계입니다. 생태계 내 대다수의 탈중앙화 애플리케이션 개발자는 [코스모스 SDK](https://cosmos.network/docs/) 또는 [텐더민트 코어](https://tendermint.com/docs/)를 사용하고 있는 것으로 예상됩니다. 각 코스모스 SDK/텐더민트 기반 애플리케이션의 개발 진행은 코스모스 허브와 별도로 진행되어도 무관합니다. 다만, [IBC](https://blog.cosmos.network/developer-deep-dive-cosmos-ibc-5855aaf183fe)(Inter-Blockchain Communication)을 사용하기 위해서는 메인넷 3단계까지 기다리거나 IBC 테스트넷에서 시범운영을 하실 수 있습니다.

**유저 참고 사항**: 메인넷 최초 단계에서는 코스모스 아톰을 거래하지 **않는** 것을 강력하게 권고합니다 (예, 법적 계약을 통한 거래). 1단계에서는 제네시스 블록까지 긴급 롤백이 진행될 수 있으므로 트랜잭션이 번복될 수 있는 위험이 존재합니다.

다만, 유저는 CLI 가이드 또는 하단의 영상 투토리얼을 참고하여 안전하게 아톰 위임을 진행하실 수는 있습니다. 다만 만약 블록체인 롤백이 진행되는 경우, 스테이킹으로 받은 리워드와 인플레이션 리워드의 손실이 있습니다.

첫 단계에서 오직 CLI를 사용해서 트랜잭션을 발생하는 것을 코스모스 허브와 소통할 때 사용될 보이저(Voyager) 지갑은 현재 알파 단계에 있기 때문에 안전하게 사용할 수 있는 프로그램은 CLI 뿐이라는 것을 강조합니다. 보이저 지갑이 안전하다는 판단이 내려지고 베타가 시작될때 별도의 공지가 있겠습니다.

CLI 가이드 🔗: [https://github.com/cosmos/cosmos-sdk/blob/develop/docs/translations/kr/gaia/delegator-guide-cli.md](https://github.com/cosmos/cosmos-sdk/blob/develop/docs/translations/kr/gaia/delegator-guide-cli.md)

CLI 위임 투토리얼 (영어): [https://www.youtube.com/watch?v=ydZw6o6Mzy0](https://www.youtube.com/watch?v=ydZw6o6Mzy0)

# 2단계: 토큰 전송 활성화

**요약**: 메인넷이 충분히 안정성을 확보했다는 판단이 내려진 후, 위임된 아톰을 보유한 홀더들은 아톰 토큰 전송 활성화에 대한 프로포절에 투표를 할 수 있습니다. 해당 절차는 블록체인 상의 거버넌스 절차를 통해 진행됩니다.

거버넌스 프로포절 현황에 대한 정보는 다양한 코스모스 익스플로러를 통해 확인하실 수 있습니다. 코스모스 익스플로러 목록은 [여기](https://cosmos.network/launch)를 참고하세요.

**유저 참고 사항**: 토큰 전송 활성화 프로포절이 통과하고 전송이 활성화된 후 아톰 이동이 가능해집니다.

# 3단계: IBC 활성화

**요약**: 3단계에서는 IBC 프로토콜이 공개됩니다. 토큰 홀더는 IBC 기능을 코스모스 SDK의 코어 모듈 라이브러리로 활성화할지에 대한 거버넌스 투표를 하게됩니다.

**개발자 참고 사항**: 이 단계에서 코스모스 SDK/텐더민트 BFT를 기반으로 만들어진 애플리케이션 특화 블록체인(application-specific blockchain)은 IBC를 통해 중앙화된 제삼자 없이 코스모스 허브와 소통할 수 있게 됩니다. IBC를 이용해 블록체인 간 다양한 토큰과 NFT(Non-fungible token)들의 이동이 가능해집니다.

# 메인넷 검증인 준비 사항

1. 메인넷에서 사용할 검증인 컨센서스 키(validator consensus key)를 생성하고 안전한 형태로 보관하십시오.
2. 게임 오브 스테이크 상금 / 펀드레이저 계정에서 트랜잭션 생성 및 서명을 할 수 있도록 준비하십시오
3. ICF의 제네시스 토큰 분배 제안이 공개된 후 메인넷 Gentx 수집 작업을 시작합니다.

# 글을 마무리 하며

코스모스의 목적은 모든 블록체인을 연결하여 ‘블록체인의 인터넷’을 만드는 것입니다.

앞으로 가야 할 길이 멀다는 것을 알고 있습니다.

메인넷이 런칭된 후, 토큰 이코노미 기반의 세상을 설계하는 본격적인 일이 본격적으로 시작돼야 할 것입니다.

하지만 미국 전 대통령 존 케네디의 말을 인용하자면, “우리는 달에 가기로 결정하였습니다. 그것이 쉽기 때문이 아니라 어렵기 때문에 이렇게 결정한 것입니다.”

달에 도착하는 그 날까지… 🚀
