# Cosmos Hub主网上线计划

* 2016年夏天，Cosmos首次发表了项目白皮书。
* 2017年春天，Cosmos完成了首次募资。
* 2019年一月，Cosmos Hub软件完成功能开发。
* 至此，Cosmos Hub主网即将启动。
* 那么，Cosmos 主网上线将为Cosmos通证（Atom）的持有者带来什么呢？

如果你是一个Atom通证的持有者，你可以将通证委托给主网的验证人并参加对链上治理提案的投票。 实际上，通证持有者的委托和参与治理对于未来网络的成功具有决定性的意义。 然而，通证持有者暂时还不能在网络上实现交易。 在下一个允许交易的硬分叉启动之前，交易协议是关闭的。

**Atom通证持有人务必仔细阅读以下内容，以保障您的通证能够安全委托给验证人。在您开始实际操作前，请先仔细阅读整个CLI指南并熟悉所有命令**

* [CLI指南](https://github.com/cosmos/cosmos-sdk/blob/develop/docs/gaia/delegator-guide-cli.md)

CLI指南中所介绍的流程是至今为止唯一经过验证的在主网实现通证委托的安全途径。这是因为指南中用到的wasmcli工具是唯一正在进行第三方安全审计的数字钱包软件，目前尚没有其他数字钱包供应商通过类似的安全审计。

请记住，通证委托有一定风险。 一旦您将通证委托给了一个验证人，通证将在委托期内锁定，无法回收。 如果在这段时间内，被委托的验证人有任何违规行为，您的部分或者全部通证将被罚没焚毁。因此，在委托前，您有责任对验证人进行尽职调查。

**Cosmos Hub主网仍然是个实验型的网络。在主网的早期，估计仍会出现一些问题，比如软件升级，或发现新的漏洞。现有的工具要求使用者具有很高的专业技术能力，并且可能还会存在我们跨链基金会或者Tendermint团队无法控制的风险（请见跨链 Cosmos 贡献条款中的风险部分条款）。使用Cosmos Hub开源软件需要遵守Apache 2.0授权协议，使用者需要自己承担所有风险，而且软件将依照“现状”提供，不提供任何形式的保证或条件，并且跨链基金会和/或Tendermint团队不对因软件引起的损失承担任何责任。所以，务必请谨慎行事！**

* [跨链 Cosmos 贡献条款](https://github.com/cosmos/cosmos/blob/master/fundraiser/Interchain%20Cosmos%20Contribution%20Terms%20-%20FINAL.pdf)
* [Apache 2.0授权协议](https://www.apache.org/licenses/LICENSE-2.0)

如果您希望获得更多关于通证委托的介绍并且愿意和Cosmos的开发者做直接的交流，您可以参加我们2月14日的线上直播，在直播中我们将介绍主网启动后通证委托的整个流程。

注册链接：[gotowebinar.com/register/](https://register.gotowebinar.com/register/5028753165739687691)

## 主网启动的里程碑

欢迎收藏[cosmos.network/launch](https://cosmos.network/launch)，跟踪主网启动全过程。

* Cosmos-SDK 安全审计✔: 在1月初，Cosmos-SDK启动了2019年一季度计划进行的一系列第三方安全评估的第一个评估项目。此次安全评估审计持续2周半的时间，2个不同的安全审计公司对Cosmos-SDK各部分做了安全评估，而第三家安全审计公司的评估工作也正在进行中。
* Cosmos-SDK正式发布版本: RC版本一旦完成，Cosmos-SDK的功能在主网上线前将不再变更，此后Cosmos-SDK团队将开始一轮内部漏洞检测，以便进一步确保在发布前完成最终的安全性检查。Cosmos-SDK v0.31.0 一发布，我们将启动一个新的Gaia测试网，以便在实际运行环境中找到那些在测试中难以被发现的漏洞。
* 权益争夺赛结束: 2018年12月启动的权益争夺赛（GoS）是同类区块链网络的第一个对抗性的测试网络。GoS旨在对纯PoS网络中的经济激励和社区协作进行压力测试。到目前为止，GoS区块链网络已经完成了3次硬分叉。GoS任务结束后，我们将通过记分准则来判断获胜者，并且在整个活动结束时宣布对获胜者的奖励。[GoS记分准则](https://github.com/cosmos/game-of-stakes/blob/master/README.md#scoring)
* 创世交易的收集: 跨链基金会将对创世时Atom通证的分配情况发布一个议案，提出了对Cosmos投资者，参与者，早期贡献者和权益争夺赛的获胜者的通证分配方案。任何被推荐获得通证分配的个人（或机构）都可以提交一个gentx文件，只有提交了该文件才有可能在主网启动创世时成为Cosmos验证人。推荐分配数量和gentx收集的最终结果将保存在创世genesis文件中
* Cosmos Hub 主网启动🔥 🚀 🌔🔥: 一旦社区接受了genesis文件， 并且占有2/3以上投票权的验证人们上线，Cosmos主网就可以启动了。

## Cosmos官方交流渠道

**以下是Cosmos有关主网启动的官方渠道**
* Cosmos Network (twitter.com/cosmos)
* Cosmos GitHub (github.com/cosmos)
* Cosmos Blog (blog.cosmos.network)
**请注意Cosmos forum，Riot群，和Telegram群将不被视为官方信息发布渠道。**
* [Cosmos forum](https://forum.cosmos.network)
* [Riot群](https://riot.im/app/#/group/+cosmos:matrix.org)
* [Telegram群](http://t.me/cosmosproject)

如果你对下一步应该做什么或者消息来源的可信度还有什么疑虑，那么在启动时请先不要有任何行动，您可以关注以上三个Cosmos官方渠道发布的最新情况，另外不要向任何管理员、网站或者非官方软件提供您的助记词。

切记，我们绝不会要求您提供您的私钥或者助记词。

## 在主网启动期间确保资产安全可靠

任何公链启动都会令人十分激动，但同时也会有一些唯利是图的人趁机作恶。自人类起源，社会工程学就已经存在了，在当今技术时代，网络钓鱼和鱼叉式网钓是利用社会工程学原理实行欺诈的主要形式。这两种攻击方式都非常有效，95%以上的账户安全漏洞都是由这两种攻击造成的，而且现在也不仅是通过电子邮件来发动攻击这么简单了。今天，网络钓鱼可能会随机或有针对性地发生在您所有的信息接收渠道，无论您是使用Signal，Telegram，SMS，Twitter或只是在论坛、社交媒体上接收信息，都有可能受到网络攻击，盗取您的重要信息和资产。

虽然作恶者的攻击听起来很可怕，但我们仍可以做很多事情来保护自己免受各种攻击。在准备主网启动期间，我们有必要为您提供一些培训来提高您发现和规避安全风险的能力，提供验证信息的可靠渠道，并通过一些技术手段来减少或避免关键风险和证件被窃风险。

## 安全规则

#### 参与Cosmos主网启动，您需要熟记以下规则:

* 直接从官方来源下载软件，并确保在您进行助记词相关的任何操作时始终使用最新、最安全的wasmcli版本。最新版的Tendermint，Cosmos-SDK和wasmcli只能从我们官方GitHub仓库中获取，从这些渠道下载可避免上当受骗，避免使用恶意修改的软件版本。
* 不要将助记词告诉给任何人，你是助记词的唯一保管人。如果有人试图为您的Atom提供托管服务，那么就要警惕了：为了避免对通证失去控制，您应该将其离线存储，最大限度降低被盗风险，并制定安全的备份策略，永远不要与任何人分享。
* 对于在区块链或加密货币环境中要求您访问来自可疑或不熟悉网站的附件或电子邮件要保持警惕。攻击者可能会试图引诱您访问虚假网站，以从您的计算机窃取敏感信息。如果您是Gmail用户，[请在此处对钓鱼邮件进行测试](https://phishingquiz.withgoogle.com)。
* 在购买Atoms之前，请做好充分的信息调研。通证在主网启动时是不允许交易的，所以它们不能进行买卖。只有到实现交易功能的硬叉发布后才能实现通证的在线交易。通证的在线交易功能实现后，请首先对卖方和交易所进行全面调研，确保Atom通证的来源可信。
* Tendermint团队和跨链基金会都不会出售Atom通证，所以，如果您在社交媒体或者电子邮件中看到我们发出的通证销售广告，请不要相信，一定是假的。
* 对于来自论坛或者技术交流群中的陌生人提供的技术建议必须保持警惕！您需要熟悉所有重要的指令，特别是那些可能存在高风险的操作指令。您可以查阅我们的官方文档，以避免上当受骗，损害自身及他人的利益。请牢记：Cosmos论坛，Riot群，和Telegram群都不是Cosmos官方信息或者新闻的发布渠道。
* 在发送交易前再次确认交易。链上地址的确很长，但请仔细检查，确保交易发送到正确的地址，防止错误发送。

如果突然出现的交易极具诱惑，或显示的消息要求您提供永远不应该与其他人分享的信息，您就应该立刻通过Cosmos网站或者其他官方渠道来验证这些信息。请再次牢记，来自Cosmos，Tendermint团队或跨链基金会的任何人都不会发送电子邮件要求您提供任何类型的帐户凭据或您的助记词，我们仅会通过我们的官方博客，Twitter和GitHub帐户与Cosmos社区沟通重要新闻和进展。
