# 검증인 FAQ

::: warning 경고
코스모스 프로젝트는 현재 진행형입니다. 메커니즘과 값은 추후 변경될 수 있다는 점을 확인하십시오.
:::

## 기본 개념

### 검증인이란 무엇인가?

[코스모스 허브](/introduction/cosmos-hub.md)는 [텐더민트](/introduction/tendermint.md) 기반으로 특정 [검증인](/validators/overview.md) 들이 네트워크의 보안을 지키는 허브입니다. 검증인들은 풀노드를 운영하며 본인의 프라이빗키로 서명된 암호화된 서명으로 투표를 하며, 이 표를 네트워크에 전파하여 합의 절차에 참여하게 됩니다. 검증인들은 새로운 블록은 블록체인에 기록하고, 이런 역할에 대한 보상을 받게됩니다. 또한 검증인은 프로포절에 대한 투표를 하며 거버넌스 절차에 참여합니다. 검증인들의 순위는 위임 받은 코인 수량에 따라서 정해집니다.

### '스테이킹'은 무엇인가?

코스모스 허브는 퍼블릭 지분증명 블록체인입니다. 이는 각 검증인들의 순위가 각자가 위임받아 본딩된 스테이킹 토큰(아톰)의 수량에 따라 순위가 정해진다는 것입니다. 검증인은 스테이킹은 검증인 자체 물량 또는 위임자가 위임한 토큰이 될 수 있습니다.

검증인이 될 의사가 있는 유저는 누구나 `create-validator` 트랜잭션을 발생시켜 의사를 표시하고 검증인이 될 수 있습니다.

(스테이킹 수량으로 결정되는) 검증인의 가중치(weight)는 해당 검증인이 실제 블록 생성에 참여할 수 있는지를 결정하며, 얼마나 자주 블록은 제안할 수 있는지와 얼마나 많은 보상을 가저가는지에 영향을 끼칩니다. 초기에는 가중치가 높은 100개의 검증인들이 실제 블록생성에 참여합니다. 만약 검증인이 이중서명을 하거나, 자주 오프라인 상태로 전환되거나, 거버넌스 절차에 참여하지 않을경우 위임된 모든 아톰(자체물량과 위임 받은 물량 포함)은 '슬래싱'되어 사라지게 됩니다.

### 풀노드는 무엇인가?

풀노드는 블록의 블록과 트랜잭션을 검증하는 프로그램입니다. 라이트노드와의 차이점은 라이트노드의 경우 블록헤더와 일부 소량의 트랜잭션을 처리하지만, 풀노드는 모든 거래와 모든 기록을 저장하고 검증합니다. 풀노드를 운영하기 위해서는 라이트노드보다 많은 리소스가 필요하지만, 검증인을 운영하기 위해서는 필수적입니다. 실질적으로 풀노드를 운영한다는 것은 최신 버전과 안전성이 확보된 소프트웨어를 다운타임과 네트워크 지연없이 운영하는 것입니다.

검증인을 운영할 의사가 없는 유저들도 풀노드를 운영할 수 있습니다.

### 위임인은 무엇인가?

위임자/위임인은 아톰을 보유하고 있지만 검증인을 운영할 수 없거나, 운영할 의사가 없는 유저입니다. 위임인은 [코스모스 보이저][Cosmos Voyager](/getting-started/voyager.md) 또는 다른 지갑을 통해 본인의 아톰을 검증인에게 위임하여 검증인 보상의 일부를 돌려받을 수 있습니다(보상 분배에 대한 자세한 정보는 **스테이킹의 인센티브**와 **검증인 커미션은 무엇인가?** 항목을 확인하십시오).

위임인은 검증인들과 보상을 나누기 때문에, 위임인에게도 책임이 주어집니다. 만약 검증인이 악의적인 행동을 한다면 위임인들의 토큰 또한 함께 슬래싱될 수 있습니다. 그렇기 때문에 위임인들은 위임을 하기 전 충분한 검토와 조사를 실시한 후 위임을 해야하며, 다수의 검증인에게 분산위임하는 방법을 추천합니다.

위임인들은 코스모스 네트워크를 운영하는 검증인들을 선택하는 역할을 하기 때문에네 네트워크의 핵심적인 역할을 하는 유저입니다. 위임인은 수동적인 역할을 하는 유저가 아닙니다. 활발하게 검증인들의 활동과 행동을 모니터링하고 그들의 거버넌스 참여 투표 등을 자주 확인해야할 필요가 있습니다.

## 검증인 되기

### 어떻게 검증인이 되는가?

네트워크에 참여하는 모든 유저는 `create-validator` 트랜잭션을 통해 본인이 검증인이 될 의사를 표시할 수 있습니다. 해당 트랜잭션에는 다음과 같은 값이 포함되어야 합니다:

* 검증인의 PubKey: PubKey와 연관된 프라이빗키는 _prevote_ 와 _precommit_ 을 서명하는데 사용됩니다. 이런 방식을 통해서 검증인은 유동적 자금이 있는 계정과 검증용 계정을 따로 관리할 수 있습니다.
* 검증인 주소: 애플리케이션 단 주소입니다. 이 주소는 공개적으로 검증인의 신원을 확인할때 이용됩니다. 해당 주소와 연관되어있는 프라이빗키는 본딩, 언본딩, 보상 수령, 거버넌스 참여 등에서 이용됩니다.
* 검증인 이름(moniker)
* 검증인 웹사이트(선택 사항)
* 검증인 설명(선택 사항)
* 최초 커미션: 블록 검증으로 받는 보상에서 위임인들 지불되기 전 삭감되는 수수료
* 최대 커미션: 해당 검증인이 설정한 최대 수수료
* 최소 셀프본딩 수량: 검증인이 최소로 본딩해야 하는 아톰의 수량. 만약 해당 검증인의 총 위임 수량이 이 값보다 떨어지는 경우, 스테이킹 풀 전체는 언본딩 됩니다.
* 최초 셀프본딩 수량: 최초로 검증인이 자체 스테이킹 하는 수량.

이제 검증인이 만들어지면, 위임인들은 해당 검증인에게 아톰을 위임하며 해당 스테이킹 풀의 수량을 늘려갈 수 있습니다. 특정 주소의 총 스테이크는 자체 스테이킹 물량 + 위임 받은 스테이킹 물량입니다.

검증인으로 참가할 의사를 밝힌 모든 검증인 중 스테이킹 수량이 가장 많은 상위 100개의 검증인은 '활성화된 검증인'으로 블록생성에 참여할 수 있게 됩니다. 상위 100 순위 밖으로 나가게 되는 검증인은 **bonded 검증인**이 되며 검증인 권한을 일게됩니다. 이때 해당 검증인의 물량은 **언본딩 모드**로 들어가면서 서서히 **언본딩** 됩니다.

코스모스 허브의 검증인 수는 시간이 지날수록 다음과 같이 인상될 예정입니다:

* **0년차:** 100
* **1년차:** 113
* **2년차:** 127
* **3년차:** 144
* **4년차:** 163
* **5년차:** 184
* **6년차:** 208
* **7년차:** 235
* **8년차:** 265
* **9년차:** 300
* **10년차:** 300

## 테스트넷

### 어떻게 테스트넷에 참여할 수 있나요?

테스트넷은 로치 전에 검증인 세팅을 확인할 수 있는 좋은 환경입니다. 테스트넷에 참가함으로 본인이 검증인 운영을 위해 준비해왔다는 것을 보여주는 기회가 될 수도 있습니다. 테스트넷에 관련된 정보는 [여기](https://github.com/cosmos/cosmos-sdk/tree/develop/cmd/gaia/testnets) 와 [여기](https://github.com/cosmos/testnets)에서 확인하실 수 있습니다.

### 어떤 종류들의 '키'가 있나요?

간략하게 설명하면 두가지 종류의 키가 있습니다:

* **텐더민트 키**: 이 키는 블록 해시를 서명할때 이용되는 고유 키입니다. 해당 키는 `cosmosvalconspub` 퍼블릭키와 연관되어 있습니다.
  * wasmd init으로 노드가 생성될때 키가 생성되며
  * 해당 키 정보는 `wasmd tendermint show-validator` 명령어로 확인하실 수 있습니다. 예) `cosmosvalconspub1zcjduc3qcyj09qc03elte23zwshdx92jm6ce88fgc90rtqhjx8v0608qh5ssp0w94c`

* **애플리케이션 키**: 이 키는 애플리케이션에 의하여 생성되고 트랜잭션을 서명할때 이용됩니다. 검증인으로써는 이 키를 스테이킹 관련 트랜잭션과 거버넌스 관련 트랜잭션을 서명할때 이용하시게 됩니다. 애플리케이션 키는 `cosmospub` 퍼블릭키와 `cosmos` 주소와 연관되어있습니다. 두 키 모두 `wasmcli keys add` 명령으로 생성됩니다.
  * 참고: 특정 검증인의 운영키는 애플리케이션키와 연관이 있으나 `cosmosvaloper`와 `cosmosvaloperpub`같은 특정 용도에만 맞는 사전 정의된 prefix를 이용합니다.

### 밸리데이터들의 '상태(state)'에는 어떤 것들이 있나요?

`create-validator` 트랜잭션을 통해 만들어진 검증인은 총 3개의 상태가 있을 수 있습니다:

- `bonded`: 검증인은 현재 합의에 참가하고 있는 활성화된 검증인입니다. 이 검증인은 블록 보상을 받을 수 있으며, 악의적인 행동에 대한 슬래싱 페널티를 받을 수도 있습니다.
- `unbonding`: 검증인은 현재 합의에 참가하고 있지 않으면 활성화된 검증인 세트에 포함되어있지 않습니다. 검증인은 블록 생성을 받지 않지만 악의적인 행동에 대한 슬래싱 페널티는 적용될 수 있습니다. 이 상태는 `bonded` 상태인 검증인이 `unbonded`으로 전환되는 중간 상태이며, 만약 `unbonding` 상태에서 `rebond` 트랜잭션을 발생하지 않으면 최대 3주간 중간 단계에 머무를 수 있습니다.
- `unbonded`: 검증인은 합의에 참가하고 있지 않은 검증인이며, 활성화된 검증인 세트에 포함되어있지 않습니다. 이 검증인은 블록 생성 보상을 받지 않으며 슬래싱 페널티도 적용되지도 않습니다. 이 검증인에게 아톰을 위임하는 것은 가능합니다. `unbonded` 상태인 검증인으로 부터의 언본딩은 바로 처리 됩니다.

위임인들은 관련 검증인들과 동일한 상태를 가지게 됩니다.

*Note that delegation are not necessarily bonded. Atoms can be delegated and bonded, delegated and unbonding, delegated and unbonded, or liquid*


### 셀프본딩은 무엇이며 어떻게 셀프본딩을 늘릴 수 있나요?

### 테스트넷 토큰은 어떻게 받을 수 있나요?

테스트넷 토큰을 받고 싶으시다면 [faucet](https://gaia.faucetcosmos.network/)을 통해서 받으실 수 있습니다.

### 활성화된 검증인이 되기 위해서 최소 필요한 아톰 수량이 있나요?

합의 프로세스에 참여하며 블록을 생성하는 검증인이 되기 위해서 특정 수량의 아톰이 필요하지는 않습니다. 다만, 셀프본딩 수량과 위임 받은 수량의 합이 사우이 100위에 들어야 활성화된 검증인이 되실 수 있습니다.

### 위임인들은 어떻게 검증인들을 선택하나요?

위임인들은 본인들이 설정한 기준에 따라 검증인을 선택할 자유가 있습니다. 검증인을 선택할때 고려해야하는 주요 사항은 다음과 같습니다:

* **셀프본딩 수랑:** 특정 검증인이 자체 본딩한 아톰의 수량입니다. 셀프본딩 수량이 높은 검증인은 본인의 행동에 따라 잃을 수 있는 것이 많기 때문에 더 많은 책임감이 부여될 수 있습니다.
* **위임된 아톰 수량:** 해당 검증인이 위임받은 아톰의 총 수량. 높은 위임 수량은 해당 검증인에 대한 신뢰도가 높다는 것을 뜻할 수 있습니다. 다만, 대형 검증인은 책임지고 있는 물량이 많기 때문에 해커들의 타겟이 될 수 있다는 위험이 존재할 수 있습니다. 해커들은 특정 검증인이 위임하고 있는 물량의 일정 %를 보상으로 받기 때문에 해커는 대형 검증인을 타겟할 확률이 높습니다. 검증인이 위임받고 있는 아톰이 과도할 경우, 높은 위임 수량은 단점으로 적용될 수 있습니다.
* **커미션:** 해당 검증인이 생성하는 보상에 대하여 위임인들에게 청구하는 수수료입니다.
* **검증인 활동 기록:** 위임인들은 본인들의 아톰을 위임하기 전 검증인들의 활동 기록을 먼저 살펴볼 수 있습니다. 이 항목에는 활동 기간, 과거 투표 현황, 업타임 기록, 노드 공격 기록 등이 포함될 수 있습니다.

위에 표기된 항목 외에도 검증인 정보에 포함되어있는 웹사이트를 통해서 검증인에 대한 정보를 받을 수 있습니다. 검증인 세팅에 대해 외부 감사를 받은 경우 이를 표기하는 것도 좋은 기록이 될 수 있습니다. 참고로 텐더민트 팀은 특정 검증인에 대한 감사를 진행하지 않습니다. 검증인 선택 기준에 대한 더 많은 정보는 [이 블로그 글](https://medium.com/@interchain_io/3d0faf10ce6f)에서 확인하실 수 있습니다.

## 검증인들의 책임

### 검증인을 하기 위해서는 신원을 밝혀야 하나요?

아닙니다. 각 위임인들은 본인들이 설정한 기준으로 각자 투표를 합니다. 검증인들은 홍보 용도를 위해서 본인들에 대한 정보가 표기된 웹사이트를 공개하는 것을 추천합니다. 해당 웹사이트에서 본인들의 정보를 공개할 것인지 또는 익명으로 본인들의 활동 기록만을 공개할 것인지는 검증인의 선택입니다. 코스모스 허브에는 익명의 팀과 팀 정보를 공개하는 팀이 공존할 확률이 높습니다.

### 검증인들이 되기 위해서는 어떤 책임이 있나요?

검증인들은 다음과 같은 책임이 있습니다:

* **언제나 올바른 소프트웨어로 노드를 운영하기:** 검증인들은 본인들의 서버가 언제나 온라인 상태며 프라이빗키가 탈취당하지 않게 관리를 해야합니다.
* **활발하게 거버넌스에 참가하기:** 검증인들은 모든 프로포절에 투표를 해야 합니다.

추가적으로 검증인들은 코스모스 커뮤니티에서 활동을 해야합니다. 검증인들은 생태계의 현재 상황에 대해 언제나 인지하며 혹시 있을 변화에 유연하게 대처할 수 있어야 합니다.

### '거버넌스에 참여'한다는 것은 무슨 뜻인가요?

코스모스 허브의 검증인들과 위임인들은 블록 가스 제한 같은 운영적 파라미터(operational parameters) 변경을 요청하거나, 소프트웨어 업그레이드를 조율하거나, 코스모스 허브에 대한 헌법을 제안할 수 있습니다.

검증인들은 거버넌스 시스템에서 특별한 역할을 합니다. 검증인들은 코스모스 허브의 기둥으로써 모든 프로포절에 투표를 해야합니다. 이는 투표에 참가하지 않는 위임인들이 검증인들의 투표를 따르기 때문에 특히 중요합니다. 프로포절에 투표를 하지 않는 검증인에게는 슬래싱 페널티가 부여됩니다.

### 스테이킹은 어떤 의미를 가지나요?

아톰을 스테이킹하는 것은 검증 활동에 대한 보증금이라고 생각하시면 됩니다. 만약 특정 검증인 또는 위임인이 본인의 아톰의 전체(또는 일부)를 언본딩 하기 위해서는 언본딩 트랜잭션을 발생해야 합니다. 이후, 해당 아톰은 _3주 간의_ 언본딩 기간을 두며 검증인들의 악의적인 행동에 대해 함께 책임을 지게 됩니다.

검증인과 해당 검증인에 위임을 한 위임인들은 블록 생성에 대한 보상, 수수료 보상, 그리고 거버넌스에 참여할 권한을 부여받습니다. 만약 특정 검증인이 악의적인 행동을 한다면 해당 검증인의 검증 권한에 있는 아톰은 슬래싱 페널티를 받을 수 있습니다. 그렇기 때문에, 위임인들은 검증인이 안정적이고 안전성을 보장할 수 있는 여부를 확인할 필요가 있습니다.

### 검증인은 위임인들의 위임된 아톰을 탈취할 수 있나요?

검증인에게 위임을 하는 위임인은 '스테이킹 파워(staking power)'를 위임하는 것입니다. 검증인의 스테이킹 파워가 많을수록 해당 검증인은 합의 절차와 거버넌스 절차에서 가지는 힘이 커집니다. 하지만 검증인은 위임인의 아톰의 소유권을 가지지는 앖습니다. 코스모스 허브의 설계는 검증인이 위임인들의 아톰을 탈취할 수 없게 설계되었습니다.

검증인들은 위임인들의 자산을 직접적으로 탈취할 수 없지만, 검증인들의 악의적인 행동으로 발생하는 페널티에 대한 슬래싱은 검증인과 위임인들에게 동일하게 적용됩니다. 

### 검증인들은 얼마나 자주 블록 생성 제안을 할 수 있는건가요? 확률은 스테이킹된 아톰에 비례해서 올라가나요?

블록체인의 다음 블록을 제안하는 검증인은 '제안자(proposer)'라고 불립니다. 각 제안자는 결정론적이게 선택되며, 제안자로 선택될 확률은 총 스테이킹 물량(셀프 본딩 스테이크 + 위임받은 스테이크)에 비례합니다. 예를들어, 모든 검증인들의 시스템상의 모든 스테이킹 수량이 100 아톰이고, 특정 검증인의 스테이킹 수량이 10아톰일 경우, 해당 검증인이 제안자로 선택될 확률은 10% 입니다.

### 코스모스 허브의 검증인은 코스모스 생태계 내 다른 존을 검증해야될 수도 있나요?

네, 그렇습니다. 초기에는 코스모스 허브의 검증인은 최초 이더민트 존을 검증해야합니다. 거버넌스에 의하여 결정된 경우, 코스모스 허브의 검증인은 코스모스 생태계 내의 다른 존 또한 검증해야 합니다. 검증인들은 이더민트 존과 동일하게 다른 존을 검증하는 것에 대한 블록 생성 보상과 트랜잭션 수수료를 보상으로 받을 수 있습니다.

## 인센티브

### 스테이킹을 할 인센티브는 무엇이 있나요?

특정 검증인의 스테이킹 풀의 참여자는 다수의 형태로 수익을 받을 수 있습니다:

* **블록 생성 보상:** 검증인들이 운영하는 특정 블록체인 애플리케이션의 고유 스테이킹 토큰(예, 코스모스 허브의 아톰)은 블록 생성을 통한 인플레이션이 있습니다. 인플레이션은 아톰 부유자들이 스테이킹을 할 인센티브를 부여하기 위한 목적이 있으며, 스테이킹을 하지 않는 아톰의 가치는 시간이 지날수록 희석됩니다.
* **블록 리워드:**: 이더민트 존의 경우, 블록 생성 보상은 포톤(photon) 토큰으로 지급됩니다. 포톤은 초기에 이더리움에서 '하드 스푼(hard spoon)'을 통해 분배되며 이더리움 수량의 1:1 비율로 지급될 예정입니다(거버넌스에 따라 해당 사항은 변경될 수 있습니다).
* **트랜잭션 수수료:** 코스모스 허브는 트랜잭션 수수료로 지불이 가능한 토큰들의 화이트리스트를 관리합니다.

위에 나열된 보상과 수수료로 발생하는 수익은 각 검증인의 총 스테이킹 물량에 비례하여 지급되며, 각 검증인 풀에 위임한 위임인들은 이 수익을 분배받습니다. 보상 수익은 각 검증인의 커미션을 차감한 후 지급된다는 점을 참고하시기 바랍니다. 

### 검증인을 운영할 인센티브는 무엇이 있나요?

검증인은 커미션을 통해서 위임인들 보다 많은 보상을 받을 수 있습니다.

또한, 검증인들은 거버넌스 절차에서 더 큰 권한을 보유합니다. 예를 들어, 거버넌스 투표를 하지 않는 위임인은 본인이 스테이킹 한 검증인들의 표를 따르게 됩니다. 이런 이유로 검증인들은 생태계 내에서 중대한 책임감을 지게 됩니다.

### 검증인 커미션은 무엇인가요?

검증인 풀에게 지급되는 수익은 검증인과 위임인들 사이에서 나눠어집니다. 각 검증인은 위임인들에게 지급하는 수익에서 일정의 수수료를 '커미션'의 형태로 차감할 수 있습니다. 커미션은 퍼센트 값으로 설정됩니다. 각 검증인은 본인 정책에 따라 최초 커미션을 설정할 수 있으며, 일일 최대 변경값 또한 정할 수 있습니다. 코스모스 허브는 해당 검증인이 설정한 파라미터를 따릅니다. 이런 값은 검증인이 초기에 검증인 참여 의사를 밝힐때 설정할 수만 있으며, 검증인으로 선택된 이후 변경될 수 없습니다.

### 블록 생성 보상은 어떻게 나누어지나요?

블록 생성 보상은 검증인의 총 위임 물량에 비례하여 분배됩니다. 코스모스 허브는 블록을 생성한 검증인만 보상을 받지만 확률적으로 특정 기간 안에서 검증인들의 전체적인 블록 보상률은 스테이킹 수량에 비례하게 설계되었습니다.

10명의 검증인이 동일한 스테이킹 물량과 동일한 1%의 커미션을 가진 경우를 예시롤 들겠습니다. 만약 블록 생성에 대한 보상이 1,000 아톰이며 검증인들은 각자 20%의 스테이킹 물량을 자체 위임(셀프본딩) 했다고 보겠습니다. 1,000개의 블록생성 보상은 제안자에게 바로 지급되지 않으며, 검증인들 사이에서 스테이킹 수량에 비례하여 분배됩니다. 즉, 10명의 검증인들은 각자 100 아톰의 보상을 받게되는 것입니다. 이후 이 100 아톰은 다음과 같이 위임인들과 검증인들 사이에서 분배됩니다:

* 커미션: `100*80%*1% = 0.8아톰`
* 밸리데이터가 가지는 보상: `100\*20% + 커미션 = 20.8 아톰`
* 모든 위임인들이 나누는 보상: `100\*80% - 커시면 = 79.2 아톰`

이후 각 위임인은 79.2 아톰 중에서 각자 위임한 물량에 비례하는 보상을 수령할 수 있습니다. 포톤(photon) 또한 이와 동일한 메커니즘을 통해 분배됩니다.

### 수수료는 어떻게 나누어지나요?

수수료는 위와 비슷하게 분배되지만, 제안자가 최소 프리커밋(precommit) 보다 많은 프리커밋을 받을 경우 수수료에 대한 보너스를 지급 받습니다.

블록 제안자로 선택된 검증인은 다른 검증인 2/3 이상의 서명을 통해 프리커밋을 받아야 블록을 생성할 수 있습니다. 추가적으로, 제안자는 특정 블록에서 검증인 2/3 이상의 서명을 받는 것에 대한 인센티브가 존재합니다. 보너스는 선형적으로 증가합니다: 2/3의 프리커밋을 받은 경우 1% 보너스로 시작하여 100% 프리커밋을 받은 경우 5% 보너스로 증가합니다. 하지만 제안자는 프리커밋을 과도하게 기다릴 경우 블록 제안 시간을 초과하여 제안자 순서가 다른 검증인으로 넘어갈 수 있다는 점을 유의해야 합니다. 이런 이유로 검증인들은 시간을 초과하지 않되 최대한 많은 프리커밋을 받을 수 있는 기간의 균형을 찾아야 합니다. 이 메커니즘은 검증인이 빈 블록을 생성하는 것을 방지하고 검증인 간 네트워킹 향상하며 검증인 검열을 방지하기 위해 도입되었습니다.

이 개념에 대한 예시를 들겠습니다. 10명의 동일한 스테이킹 물량을 가진 검증인들이 각자 1% 커미션과 20% 자체 본딩을 하고 있는 상황을 가정합니다. 새로운 총 1025.51020408 아톰의 보상이 있는 새로운 블록이 생성됩니다.

우선 2% 수수료가 삭감되고 예비 풀(reserve pool)로 이동합니다. 이 예비 풀은 거버넌스를 통해 업그레이드와 버그 바운티를 지급하는데 이용됩니다.

* `2% \* 1025.51020408 = 20.51020408` 아톰이 예비 풀로 이동합니다.

이제 1005 아톰이 남아있습니다. 만약 블록 제안자가 해당 블록에 100% 프리커밋 서명을 포함했다면 최대 보너스인 5%를 지급받습니다.

각 검증인들에 대한 보상인 R을 찾기 위해서는 다음의 공식을 적용합니다:

`9*R + R R*5% = 1005 ⇔ R = 1005/10.05 = 100`

* 제안자 검증인:
  * 풀(pool)이 `R + R * 5%`를 얻음: 105 아톰
  * 커미션: `105 * 80% * 1%` = 0.84 아톰
  * 검증인 보상: `105 * 20% + 커미션` = 21.84 아톰
  * 위임인 보상: `105 * 80% - 커미션` = 83.16 아톰 (각 위임인은 본인의 위임 수량에 비례하는 보상을 받음)
  
* 제안을 하지 않은 검증인:
  * 풀이 R 아톰을 얻음: 100 아톰
  * 커미션: `100 * 80% * 1%` = 0.8 아톰
  * 검증인 보상: `105 * 20% + 커미션` = 20.8 아톰
  * 위임인 보상: `100 * 80% - 커미션` = 79.2 아톰 (각 위임인은 본인의 위임 수량에 비례하는 보상을 받음)

### 슬래싱 페널티를 발생하는 경우는 무엇이 있나요?

특정 검증인이 악의적으로 행동할 경우, 검증인에게 본딩된 아톰(위임인들의 아톰 포함)은 슬래싱이 됩니다. 슬래싱 페널티는 악의적인 행동에 비례한 가중치가 적용됩니다. 검증인과 위임인들의 스테이크가 슬래싱 되는 경우는 3개가 있습니다:

* **이중 서명(더블 사이닝):** 누군가 체인A에서 특정 검증인이 동일한 높이의 두개의 블록을 체인A와 체인B에서 서명한 경우 (체인A 와 체인B 가 동일한 ancestor에서 유례한 경우) 해당 검증인은 체인A에서 슬래싱될 수 있습니다.
* **오프라인(unavailability):** 특정 검증인의 서명이 X 블록동안 포함되지 않았을 경우, 해당 검증인은 X 에 비례한 소량의 아톰이 슬래싱됩니다. 만약 X가 사전에 설정된 Y 한도보다 높을 경우, 해당 검증인은 언본딩 됩니다.
* **미투표(non-voting):** 특정 검증인이 거버넌스 프로포절에 투표를 하지 않는 경우 소량의 스테이크가 슬래싱될 수 있습니다.

검증인의 행동의 의도적으로 악의적이지 않아도(예시: 노드 에러, 인터넷 연결 문제, DDoS, 프라이빗 탈취) 검증인은 슬래싱될 수 있다는 점을 참고하시기 바랍니다.

### 검증인은 꼭 자체 위임(셀프본딩)을 해야하나요?

검증인은 자체 위임을 하지 않아도 검증인을 할 수 있습니다. 검증인의 총 스테이킹 수량은 셀프본딩 수량과 위임 수량의 합입니다. 셀프본딩이 낮은 검증인은 많은 위임인들의 스테이크를 통해 총 스테이킹 수량을 늘릴수 있습니다. 이런 이유로 검증인의 평판은 중요한 요소로 적용합니다. 

검증인이 셀프본딩 할 의무는 없을 수 있지만, 위임인들의 대다수는 검증인들이 셀프본딩을 하는 것을 선호할 수 있습니다. 본인에 행동에 대한 책임감을 보여줄 수 있기 때문입니다.

검증인들은 본인의 책임감을 표기하기 위해서 자체적인 최소 셀프본딩 수량을 설정할 수 있습니다. 만약 해당 검증인의 셀프본딩률이 해당 수치보다 낮아질 경우, 해당 검증인들과 모든 위임인들의 아톰은 언본딩 됩니다.

### 상위 검증인에게 스테이킹이 몰리는 현상은 어떻게 막을 수 있나요?

현재로써는 커뮤니티가 자체적으로 이런 위험성을 인지하고 위임하는 것을 예상하고 있습니다. 비트코인의 경우, 특정 채굴풀이 과도한 해시파워를 확보한 경우 커뮤니티는 자체적으로 해당 채굴풀에 대한 위임을 멈춥니다. 코스모스는 초기에 이와 비슷한 형태로 채굴풀의 중앙화를 조절할 수 있을 것으로 기대하고 있습니다. 추후에는 이런 현상을 막을 수 있는 장치들이 소개될 예정입니다:

* **무-페널티 재위임(penalty-free re-delegation):** 특정 검증인에 과도하게 묶여있는 현상을 줄이기 위해서 한 검증인에서 다른 검증인으로 위임을 쉽게 바꿀 수 있는 방식.
* **해킹 바운티:** 커뮤니티가 검증인을 해킹하는 것을 장려하는 정책. 바운티 보상은 검증인이 스테이킹 하고 있는 물량의 크기에 비례.
* **UI 경고:** 코스모스 보이저(Cosmos Voyager) 지갑을 이용하는 유저는 이미 과도한 스테이킹 물량을 보유하고 있는 검증인에게 위임을 하려고 할때 경고를 받는다.

## 기술적 요건

### 필요한 하드웨어 장비는 무엇인가요?

검증인은 전력, 네트워킹, 방화벽, 하드웨어 보안 모듈과 서버 백업이 있는 하나 이상의 데이터 센터를 제공할 것을 추천합니다.

네트워크 초기의 하드웨어 요건은 그리 고성능이 아닐 것으로 예상하고 있지만, 네트워크 사용량이 증가하면서 하드웨어 스펙 또한 증가할 것을 예상하고 있습니다. 테스트넷에 참가해서 하드웨어 세팅을 실험해보는 것을 추천드립니다.

### 필요한 소프트웨어는 무엇인가요?

코스모스 허브 노드 외에도 모니터링, 알림, 관리 솔루션을 준비해야할 것으로 예상하고 있습니다.

### 필요한 대역폭은 어느 정도 인가요?

코스모스 네트워크는 이더리움과 비트코인에 비교해서 많은 대역폭과 쓰루풋(throughput)을 필요로 합니다.

데이터 센터 노드는 신뢰할 수 있는 클라우드 풀노드와 사회적으로 신뢰할 수 있는 다른 검증인들에게만 연결하는 것을 추천드립니다. 이는 데이터 센터의 노드과 DDoS 공격의 피해를 입는 것을 방지할 수 있습니다.

네트워크가 성장하면서 매일 몇 기가바이트 이상의 대역폭을 사용하는 것은 현실적인 것으로 판단됩니다.

### 검증인을 하는 것은 운영 측면에서 어떤가요?

성공적인 검증인은 다수의 실력있는 운영 인력이 확보되어야 할 것으로 예측됩니다. 코스모스 검증인 운영은 비트코인 채굴에 비해서 높은 난이도에 속합니다.

### 키 관리는 어떻게 하는 것이 바람직한가요?

검증인은 ed25519 키를 지원하는 하드웨어 보안 모듈(HSM, Hardware Security Module)을 이용하는 것을 추천드립니다. 다음은 추천이 가능한 HSM들의 일부입니다:

* YubiHSM 2
* Ledger Nano S
* Ledger BOLOS SGX enclave
* Thales nShield support

텐더민트 팀은 특정 회사의 솔루션을 지목하여 추천하지 않습니다. 검증인 커뮤니티는 자체적으로 HSM을 이용한 보안 솔루션을 연구하여 향상시킬 것을 권장합니다.

### 운영 측면에서 어떤 요소들이 있나요?

효율적으로 검증인을 운영하는 것은 예측 할 수 없는 언본딩과 슬래싱을 막는 것입니다. 이는 공격에 대한 대응, 전력 단절, 네트워크 단절, 보안 등에 대한 모든 위험 요소를 차단하고 준비하는 것입니다.

### 보수 측면에서 어떤 것들이 요구되나요?

검증인은 정기적으로 소프트웨어 업그레이드와 버그 패치를 적용해야합니다. 네트워크 초기에는 다수의 문제들이 발생할 수 있을 것으로 예상되기 때문에 검증인들은 유심히 네트워크 상태를 모니터링 해야 합니다.

### 검증인은 어떻게 DDoS 공격에 방어를 할 수 있을까요?

DDoS 공격은 공격자가 특정 IP의 서버에게 인터넷 트래픽을 과도하게 발생시켜 인터넷에 연결되는 것을 막는 공격입니다.

공격자는 네트워크를 스캔하여 특정 IP 주소를 지목하고 엄청난 트래픽을 발생시켜 공격을 하여 해당 노드의 정상적인 운영을 막습니다.

이런 공격을 막을 수 있는 하나의 방법은 노드에 센트리노드 아키텍쳐를 도입하여 방어율을 높이는 것입니다.

검증인 노드는 본인이 직접 운영하는 풀노드 또는 사회적으로 신뢰가 가능한 다른 검증인이 운영하는 풀노드에만 연결해야 합니다. 검증인 노드의 대다수는 데이터 센터에서 운영이 되며, 대다수의 데이터 센터는 다른 클라우드 서비스 제공자와 직접적인 연결을 제공합니다. 검증이는 이런 직접 연결을 통해서 클라우드에 있는 센트리노드를 연결할 수 있습니다. 이런 형태의 아키텍처는 DDoS 공격의 부담을 검증 노드에서 센트리 노드로 우회합니다. 공격 상황에서 새로운 센트리노드를 생성하는 것은 다소 쉽기 때문에 공격의 위험성을 줄일 수 있습니다.

센트리노드는 새로 생성되거나 IP 주소를 변경할 수 있습니다. 센트리노드와 검증노드 간의 연결은 프라이빗 IP를 통해서 이루어지기 떄문에 공격자는 직접적으로 공격을 할 수 없습니다. 이는 검증 노드가 언제나 블록 제안과 블록 투표에 참여할 수 있게 합니다.

올바른 운영과 아키텍쳐를 이용하는 검증이는 이런 공격 가능성을 막을 수 있을 것으로 기대됩니다.

센트리노드에 대한 추가적인 정보는 [여기](https://forum.cosmos.network/t/sentry-node-architecture-overview/454)에서 확인 가능합니다.
