package main

import (
	"fmt"
	"os"

	"github.com/Files-com/files-cli/cmd"
	files "github.com/Files-com/files-sdk-go"
	"github.com/spf13/cobra"
)

var VERSION = "_VERSION"

func main() {
	var rootCmd = &cobra.Command{
		Use:     "files-cli [resource]",
		Version: VERSION,
		PersistentPreRun: func(cmd *cobra.Command, args []string) {
			setting := files.Config{}
			if setting.GetAPIKey() == "" {
				fmt.Println("No API Key found")
				os.Exit(1)
			}
		},
	}
	rootCmd.PersistentFlags().StringVar(&files.APIKey, "api-key", "", "API Key")
	rootCmd.AddCommand(cmd.UploadCmd())
	rootCmd.AddCommand(cmd.DownloadCmd())
	rootCmd.AddCommand(cmd.VersionCmd(VERSION))
	cmd.AccountLineItemsInit()
	rootCmd.AddCommand(cmd.AccountLineItems)
	cmd.ActionsInit()
	rootCmd.AddCommand(cmd.Actions)
	cmd.ApiKeysInit()
	rootCmd.AddCommand(cmd.ApiKeys)
	cmd.AppsInit()
	rootCmd.AddCommand(cmd.Apps)
	cmd.As2KeysInit()
	rootCmd.AddCommand(cmd.As2Keys)
	cmd.AutosInit()
	rootCmd.AddCommand(cmd.Autos)
	cmd.AutomationsInit()
	rootCmd.AddCommand(cmd.Automations)
	cmd.BandwidthSnapshotsInit()
	rootCmd.AddCommand(cmd.BandwidthSnapshots)
	cmd.BehaviorsInit()
	rootCmd.AddCommand(cmd.Behaviors)
	cmd.BundlesInit()
	rootCmd.AddCommand(cmd.Bundles)
	cmd.BundleDownloadsInit()
	rootCmd.AddCommand(cmd.BundleDownloads)
	cmd.BundleRecipientsInit()
	rootCmd.AddCommand(cmd.BundleRecipients)
	cmd.BundleRegistrationsInit()
	rootCmd.AddCommand(cmd.BundleRegistrations)
	cmd.ClickwrapsInit()
	rootCmd.AddCommand(cmd.Clickwraps)
	cmd.DnsRecordsInit()
	rootCmd.AddCommand(cmd.DnsRecords)
	cmd.ErrorsInit()
	rootCmd.AddCommand(cmd.Errors)
	cmd.ExternalEventsInit()
	rootCmd.AddCommand(cmd.ExternalEvents)
	cmd.FilesInit()
	rootCmd.AddCommand(cmd.Files)
	cmd.FileActionsInit()
	rootCmd.AddCommand(cmd.FileActions)
	cmd.FileCommentsInit()
	rootCmd.AddCommand(cmd.FileComments)
	cmd.FileCommentReactionsInit()
	rootCmd.AddCommand(cmd.FileCommentReactions)
	cmd.FileUploadPartsInit()
	rootCmd.AddCommand(cmd.FileUploadParts)
	cmd.FoldersInit()
	rootCmd.AddCommand(cmd.Folders)
	cmd.FormFieldsInit()
	rootCmd.AddCommand(cmd.FormFields)
	cmd.FormFieldSetsInit()
	rootCmd.AddCommand(cmd.FormFieldSets)
	cmd.GroupsInit()
	rootCmd.AddCommand(cmd.Groups)
	cmd.GroupUsersInit()
	rootCmd.AddCommand(cmd.GroupUsers)
	cmd.HistoriesInit()
	rootCmd.AddCommand(cmd.Histories)
	cmd.HistoryExportsInit()
	rootCmd.AddCommand(cmd.HistoryExports)
	cmd.HistoryExportResultsInit()
	rootCmd.AddCommand(cmd.HistoryExportResults)
	cmd.ImagesInit()
	rootCmd.AddCommand(cmd.Images)
	cmd.InboxRecipientsInit()
	rootCmd.AddCommand(cmd.InboxRecipients)
	cmd.InboxRegistrationsInit()
	rootCmd.AddCommand(cmd.InboxRegistrations)
	cmd.InboxUploadsInit()
	rootCmd.AddCommand(cmd.InboxUploads)
	cmd.InvoicesInit()
	rootCmd.AddCommand(cmd.Invoices)
	cmd.InvoiceLineItemsInit()
	rootCmd.AddCommand(cmd.InvoiceLineItems)
	cmd.IpAddressesInit()
	rootCmd.AddCommand(cmd.IpAddresses)
	cmd.LocksInit()
	rootCmd.AddCommand(cmd.Locks)
	cmd.MessagesInit()
	rootCmd.AddCommand(cmd.Messages)
	cmd.MessageCommentsInit()
	rootCmd.AddCommand(cmd.MessageComments)
	cmd.MessageCommentReactionsInit()
	rootCmd.AddCommand(cmd.MessageCommentReactions)
	cmd.MessageReactionsInit()
	rootCmd.AddCommand(cmd.MessageReactions)
	cmd.NotificationsInit()
	rootCmd.AddCommand(cmd.Notifications)
	cmd.PaymentsInit()
	rootCmd.AddCommand(cmd.Payments)
	cmd.PaymentLineItemsInit()
	rootCmd.AddCommand(cmd.PaymentLineItems)
	cmd.PermissionsInit()
	rootCmd.AddCommand(cmd.Permissions)
	cmd.PreviewsInit()
	rootCmd.AddCommand(cmd.Previews)
	cmd.ProjectsInit()
	rootCmd.AddCommand(cmd.Projects)
	cmd.PublicIpAddressesInit()
	rootCmd.AddCommand(cmd.PublicIpAddresses)
	cmd.PublicKeysInit()
	rootCmd.AddCommand(cmd.PublicKeys)
	cmd.RemoteServersInit()
	rootCmd.AddCommand(cmd.RemoteServers)
	cmd.RequestsInit()
	rootCmd.AddCommand(cmd.Requests)
	cmd.SessionsInit()
	rootCmd.AddCommand(cmd.Sessions)
	cmd.SettingsChangesInit()
	rootCmd.AddCommand(cmd.SettingsChanges)
	cmd.SitesInit()
	rootCmd.AddCommand(cmd.Sites)
	cmd.SsoStrategiesInit()
	rootCmd.AddCommand(cmd.SsoStrategies)
	cmd.StatusesInit()
	rootCmd.AddCommand(cmd.Statuses)
	cmd.StylesInit()
	rootCmd.AddCommand(cmd.Styles)
	cmd.UsageDailySnapshotsInit()
	rootCmd.AddCommand(cmd.UsageDailySnapshots)
	cmd.UsageSnapshotsInit()
	rootCmd.AddCommand(cmd.UsageSnapshots)
	cmd.UsersInit()
	rootCmd.AddCommand(cmd.Users)
	cmd.UserCipherUsesInit()
	rootCmd.AddCommand(cmd.UserCipherUses)
	cmd.UserRequestsInit()
	rootCmd.AddCommand(cmd.UserRequests)

	rootCmd.Execute()
}
