# Rust API for firecracker

Firecraker MVP - RESTful public-facing API.  The API is accessible through HTTP calls on specific URLs carrying JSON modeled data. The transport medium is a Unix Domain Socket.

## Overview
This client/server was generated by the [swagger-codegen]
(https://github.com/swagger-api/swagger-codegen) project.
By using the [OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote server, you can easily generate a server stub.
-

To see how to make this your own, look here:

[README](https://github.com/swagger-api/swagger-codegen/blob/master/README.md)

- API version: experimental.0.0
- Build date: 2017-11-22T12:43:37.219+02:00

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running a client
To run a client, follow one of the following simple steps:

```
cargo run --example client ApplyLimiterToDrive
cargo run --example client ApplyLimiterToNetworkInterface
cargo run --example client ApplyLimiterToVsock
cargo run --example client CreateInstanceAction
cargo run --example client DeleteGuestDriveByID
cargo run --example client DeleteGuestNetworkInterfaceByID
cargo run --example client DeleteGuestVsockByID
cargo run --example client DeleteLimiter
cargo run --example client DescribeInstance
cargo run --example client DescribeInstanceAction
cargo run --example client DescribeLimiter
cargo run --example client GetGuestBootSource
cargo run --example client GetGuestDriveByID
cargo run --example client GetGuestDrives
cargo run --example client GetGuestNetworkInterfaceByID
cargo run --example client GetGuestNetworkInterfaces
cargo run --example client GetGuestVsockByID
cargo run --example client GetGuestVsocks
cargo run --example client GetLimitersForGuestDrive
cargo run --example client GetLimitersForGuestNetworkInterface
cargo run --example client GetLimitersForGuestVsock
cargo run --example client GetMetadata
cargo run --example client ListInstanceActions
cargo run --example client ListLimiters
cargo run --example client PutGuestBootSource
cargo run --example client PutGuestDriveByID
cargo run --example client PutGuestNetworkInterfaceByID
cargo run --example client PutGuestVsockByID
cargo run --example client UpdateLimiter
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the server chain is signed with
`CN=localhost`.
