/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    storage: Storage,
    align: [Align; 0],
}

impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }

    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        byte & mask == mask
    }

    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }

    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        let mut val = 0;

        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                val |= 1 << i;
            }
        }

        val
    }

    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            self.set_bit(i + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ptr(&self) -> *const T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut_ptr(&mut self) -> *mut T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
impl<T> ::std::clone::Clone for __IncompleteArrayField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __IncompleteArrayField<T> {}
pub const __BITS_PER_LONG: ::std::os::raw::c_uint = 64;
pub const BITS_PER_LONG: ::std::os::raw::c_uint = 32;
pub const BITS_PER_LONG_LONG: ::std::os::raw::c_uint = 64;
pub const __FD_SETSIZE: ::std::os::raw::c_uint = 1024;
pub const _IOC_NRBITS: ::std::os::raw::c_uint = 8;
pub const _IOC_TYPEBITS: ::std::os::raw::c_uint = 8;
pub const _IOC_SIZEBITS: ::std::os::raw::c_uint = 14;
pub const _IOC_DIRBITS: ::std::os::raw::c_uint = 2;
pub const _IOC_NRMASK: ::std::os::raw::c_uint = 255;
pub const _IOC_TYPEMASK: ::std::os::raw::c_uint = 255;
pub const _IOC_SIZEMASK: ::std::os::raw::c_uint = 16383;
pub const _IOC_DIRMASK: ::std::os::raw::c_uint = 3;
pub const _IOC_NRSHIFT: ::std::os::raw::c_uint = 0;
pub const _IOC_TYPESHIFT: ::std::os::raw::c_uint = 8;
pub const _IOC_SIZESHIFT: ::std::os::raw::c_uint = 16;
pub const _IOC_DIRSHIFT: ::std::os::raw::c_uint = 30;
pub const _IOC_NONE: ::std::os::raw::c_uint = 0;
pub const _IOC_WRITE: ::std::os::raw::c_uint = 1;
pub const _IOC_READ: ::std::os::raw::c_uint = 2;
pub const IOC_IN: ::std::os::raw::c_uint = 1073741824;
pub const IOC_OUT: ::std::os::raw::c_uint = 2147483648;
pub const IOC_INOUT: ::std::os::raw::c_uint = 3221225472;
pub const IOCSIZE_MASK: ::std::os::raw::c_uint = 1073676288;
pub const IOCSIZE_SHIFT: ::std::os::raw::c_uint = 16;
pub const DE_VECTOR: ::std::os::raw::c_uint = 0;
pub const DB_VECTOR: ::std::os::raw::c_uint = 1;
pub const BP_VECTOR: ::std::os::raw::c_uint = 3;
pub const OF_VECTOR: ::std::os::raw::c_uint = 4;
pub const BR_VECTOR: ::std::os::raw::c_uint = 5;
pub const UD_VECTOR: ::std::os::raw::c_uint = 6;
pub const NM_VECTOR: ::std::os::raw::c_uint = 7;
pub const DF_VECTOR: ::std::os::raw::c_uint = 8;
pub const TS_VECTOR: ::std::os::raw::c_uint = 10;
pub const NP_VECTOR: ::std::os::raw::c_uint = 11;
pub const SS_VECTOR: ::std::os::raw::c_uint = 12;
pub const GP_VECTOR: ::std::os::raw::c_uint = 13;
pub const PF_VECTOR: ::std::os::raw::c_uint = 14;
pub const MF_VECTOR: ::std::os::raw::c_uint = 16;
pub const AC_VECTOR: ::std::os::raw::c_uint = 17;
pub const MC_VECTOR: ::std::os::raw::c_uint = 18;
pub const XM_VECTOR: ::std::os::raw::c_uint = 19;
pub const VE_VECTOR: ::std::os::raw::c_uint = 20;
pub const KVM_NR_INTERRUPTS: ::std::os::raw::c_uint = 256;
pub const KVM_IOAPIC_NUM_PINS: ::std::os::raw::c_uint = 24;
pub const KVM_IRQCHIP_PIC_MASTER: ::std::os::raw::c_uint = 0;
pub const KVM_IRQCHIP_PIC_SLAVE: ::std::os::raw::c_uint = 1;
pub const KVM_IRQCHIP_IOAPIC: ::std::os::raw::c_uint = 2;
pub const KVM_NR_IRQCHIPS: ::std::os::raw::c_uint = 3;
pub const KVM_RUN_X86_SMM: ::std::os::raw::c_uint = 1;
pub const KVM_APIC_REG_SIZE: ::std::os::raw::c_uint = 1024;
pub const KVM_GUESTDBG_USE_SW_BP: ::std::os::raw::c_uint = 65536;
pub const KVM_GUESTDBG_USE_HW_BP: ::std::os::raw::c_uint = 131072;
pub const KVM_GUESTDBG_INJECT_DB: ::std::os::raw::c_uint = 262144;
pub const KVM_GUESTDBG_INJECT_BP: ::std::os::raw::c_uint = 524288;
pub const KVM_PIT_FLAGS_HPET_LEGACY: ::std::os::raw::c_uint = 1;
pub const KVM_VCPUEVENT_VALID_NMI_PENDING: ::std::os::raw::c_uint = 1;
pub const KVM_VCPUEVENT_VALID_SIPI_VECTOR: ::std::os::raw::c_uint = 2;
pub const KVM_VCPUEVENT_VALID_SHADOW: ::std::os::raw::c_uint = 4;
pub const KVM_VCPUEVENT_VALID_SMM: ::std::os::raw::c_uint = 8;
pub const KVM_X86_SHADOW_INT_MOV_SS: ::std::os::raw::c_uint = 1;
pub const KVM_X86_SHADOW_INT_STI: ::std::os::raw::c_uint = 2;
pub const KVM_MAX_XCRS: ::std::os::raw::c_uint = 16;
pub const KVM_X86_QUIRK_LINT0_REENABLED: ::std::os::raw::c_uint = 1;
pub const KVM_X86_QUIRK_CD_NW_CLEARED: ::std::os::raw::c_uint = 2;
pub const KVM_API_VERSION: ::std::os::raw::c_uint = 12;
pub const KVM_TRC_SHIFT: ::std::os::raw::c_uint = 16;
pub const KVM_TRC_ENTRYEXIT: ::std::os::raw::c_uint = 65536;
pub const KVM_TRC_HANDLER: ::std::os::raw::c_uint = 131072;
pub const KVM_TRC_VMENTRY: ::std::os::raw::c_uint = 65537;
pub const KVM_TRC_VMEXIT: ::std::os::raw::c_uint = 65538;
pub const KVM_TRC_PAGE_FAULT: ::std::os::raw::c_uint = 131073;
pub const KVM_TRC_HEAD_SIZE: ::std::os::raw::c_uint = 12;
pub const KVM_TRC_CYCLE_SIZE: ::std::os::raw::c_uint = 8;
pub const KVM_TRC_EXTRA_MAX: ::std::os::raw::c_uint = 7;
pub const KVM_TRC_INJ_VIRQ: ::std::os::raw::c_uint = 131074;
pub const KVM_TRC_REDELIVER_EVT: ::std::os::raw::c_uint = 131075;
pub const KVM_TRC_PEND_INTR: ::std::os::raw::c_uint = 131076;
pub const KVM_TRC_IO_READ: ::std::os::raw::c_uint = 131077;
pub const KVM_TRC_IO_WRITE: ::std::os::raw::c_uint = 131078;
pub const KVM_TRC_CR_READ: ::std::os::raw::c_uint = 131079;
pub const KVM_TRC_CR_WRITE: ::std::os::raw::c_uint = 131080;
pub const KVM_TRC_DR_READ: ::std::os::raw::c_uint = 131081;
pub const KVM_TRC_DR_WRITE: ::std::os::raw::c_uint = 131082;
pub const KVM_TRC_MSR_READ: ::std::os::raw::c_uint = 131083;
pub const KVM_TRC_MSR_WRITE: ::std::os::raw::c_uint = 131084;
pub const KVM_TRC_CPUID: ::std::os::raw::c_uint = 131085;
pub const KVM_TRC_INTR: ::std::os::raw::c_uint = 131086;
pub const KVM_TRC_NMI: ::std::os::raw::c_uint = 131087;
pub const KVM_TRC_VMMCALL: ::std::os::raw::c_uint = 131088;
pub const KVM_TRC_HLT: ::std::os::raw::c_uint = 131089;
pub const KVM_TRC_CLTS: ::std::os::raw::c_uint = 131090;
pub const KVM_TRC_LMSW: ::std::os::raw::c_uint = 131091;
pub const KVM_TRC_APIC_ACCESS: ::std::os::raw::c_uint = 131092;
pub const KVM_TRC_TDP_FAULT: ::std::os::raw::c_uint = 131093;
pub const KVM_TRC_GTLB_WRITE: ::std::os::raw::c_uint = 131094;
pub const KVM_TRC_STLB_WRITE: ::std::os::raw::c_uint = 131095;
pub const KVM_TRC_STLB_INVAL: ::std::os::raw::c_uint = 131096;
pub const KVM_TRC_PPC_INSTR: ::std::os::raw::c_uint = 131097;
pub const KVM_MEM_LOG_DIRTY_PAGES: ::std::os::raw::c_uint = 1;
pub const KVM_MEM_READONLY: ::std::os::raw::c_uint = 2;
pub const KVM_PIT_SPEAKER_DUMMY: ::std::os::raw::c_uint = 1;
pub const KVM_S390_CMMA_PEEK: ::std::os::raw::c_uint = 1;
pub const KVM_EXIT_HYPERV_SYNIC: ::std::os::raw::c_uint = 1;
pub const KVM_EXIT_HYPERV_HCALL: ::std::os::raw::c_uint = 2;
pub const KVM_S390_GET_SKEYS_NONE: ::std::os::raw::c_uint = 1;
pub const KVM_S390_SKEYS_MAX: ::std::os::raw::c_uint = 1048576;
pub const KVM_EXIT_UNKNOWN: ::std::os::raw::c_uint = 0;
pub const KVM_EXIT_EXCEPTION: ::std::os::raw::c_uint = 1;
pub const KVM_EXIT_IO: ::std::os::raw::c_uint = 2;
pub const KVM_EXIT_HYPERCALL: ::std::os::raw::c_uint = 3;
pub const KVM_EXIT_DEBUG: ::std::os::raw::c_uint = 4;
pub const KVM_EXIT_HLT: ::std::os::raw::c_uint = 5;
pub const KVM_EXIT_MMIO: ::std::os::raw::c_uint = 6;
pub const KVM_EXIT_IRQ_WINDOW_OPEN: ::std::os::raw::c_uint = 7;
pub const KVM_EXIT_SHUTDOWN: ::std::os::raw::c_uint = 8;
pub const KVM_EXIT_FAIL_ENTRY: ::std::os::raw::c_uint = 9;
pub const KVM_EXIT_INTR: ::std::os::raw::c_uint = 10;
pub const KVM_EXIT_SET_TPR: ::std::os::raw::c_uint = 11;
pub const KVM_EXIT_TPR_ACCESS: ::std::os::raw::c_uint = 12;
pub const KVM_EXIT_S390_SIEIC: ::std::os::raw::c_uint = 13;
pub const KVM_EXIT_S390_RESET: ::std::os::raw::c_uint = 14;
pub const KVM_EXIT_DCR: ::std::os::raw::c_uint = 15;
pub const KVM_EXIT_NMI: ::std::os::raw::c_uint = 16;
pub const KVM_EXIT_INTERNAL_ERROR: ::std::os::raw::c_uint = 17;
pub const KVM_EXIT_OSI: ::std::os::raw::c_uint = 18;
pub const KVM_EXIT_PAPR_HCALL: ::std::os::raw::c_uint = 19;
pub const KVM_EXIT_S390_UCONTROL: ::std::os::raw::c_uint = 20;
pub const KVM_EXIT_WATCHDOG: ::std::os::raw::c_uint = 21;
pub const KVM_EXIT_S390_TSCH: ::std::os::raw::c_uint = 22;
pub const KVM_EXIT_EPR: ::std::os::raw::c_uint = 23;
pub const KVM_EXIT_SYSTEM_EVENT: ::std::os::raw::c_uint = 24;
pub const KVM_EXIT_S390_STSI: ::std::os::raw::c_uint = 25;
pub const KVM_EXIT_IOAPIC_EOI: ::std::os::raw::c_uint = 26;
pub const KVM_EXIT_HYPERV: ::std::os::raw::c_uint = 27;
pub const KVM_INTERNAL_ERROR_EMULATION: ::std::os::raw::c_uint = 1;
pub const KVM_INTERNAL_ERROR_SIMUL_EX: ::std::os::raw::c_uint = 2;
pub const KVM_INTERNAL_ERROR_DELIVERY_EV: ::std::os::raw::c_uint = 3;
pub const KVM_EXIT_IO_IN: ::std::os::raw::c_uint = 0;
pub const KVM_EXIT_IO_OUT: ::std::os::raw::c_uint = 1;
pub const KVM_S390_RESET_POR: ::std::os::raw::c_uint = 1;
pub const KVM_S390_RESET_CLEAR: ::std::os::raw::c_uint = 2;
pub const KVM_S390_RESET_SUBSYSTEM: ::std::os::raw::c_uint = 4;
pub const KVM_S390_RESET_CPU_INIT: ::std::os::raw::c_uint = 8;
pub const KVM_S390_RESET_IPL: ::std::os::raw::c_uint = 16;
pub const KVM_SYSTEM_EVENT_SHUTDOWN: ::std::os::raw::c_uint = 1;
pub const KVM_SYSTEM_EVENT_RESET: ::std::os::raw::c_uint = 2;
pub const KVM_SYSTEM_EVENT_CRASH: ::std::os::raw::c_uint = 3;
pub const KVM_S390_MEMOP_LOGICAL_READ: ::std::os::raw::c_uint = 0;
pub const KVM_S390_MEMOP_LOGICAL_WRITE: ::std::os::raw::c_uint = 1;
pub const KVM_S390_MEMOP_F_CHECK_ONLY: ::std::os::raw::c_uint = 1;
pub const KVM_S390_MEMOP_F_INJECT_EXCEPTION: ::std::os::raw::c_uint = 2;
pub const KVM_MP_STATE_RUNNABLE: ::std::os::raw::c_uint = 0;
pub const KVM_MP_STATE_UNINITIALIZED: ::std::os::raw::c_uint = 1;
pub const KVM_MP_STATE_INIT_RECEIVED: ::std::os::raw::c_uint = 2;
pub const KVM_MP_STATE_HALTED: ::std::os::raw::c_uint = 3;
pub const KVM_MP_STATE_SIPI_RECEIVED: ::std::os::raw::c_uint = 4;
pub const KVM_MP_STATE_STOPPED: ::std::os::raw::c_uint = 5;
pub const KVM_MP_STATE_CHECK_STOP: ::std::os::raw::c_uint = 6;
pub const KVM_MP_STATE_OPERATING: ::std::os::raw::c_uint = 7;
pub const KVM_MP_STATE_LOAD: ::std::os::raw::c_uint = 8;
pub const KVM_S390_SIGP_STOP: ::std::os::raw::c_uint = 4294836224;
pub const KVM_S390_PROGRAM_INT: ::std::os::raw::c_uint = 4294836225;
pub const KVM_S390_SIGP_SET_PREFIX: ::std::os::raw::c_uint = 4294836226;
pub const KVM_S390_RESTART: ::std::os::raw::c_uint = 4294836227;
pub const KVM_S390_INT_PFAULT_INIT: ::std::os::raw::c_uint = 4294836228;
pub const KVM_S390_INT_PFAULT_DONE: ::std::os::raw::c_uint = 4294836229;
pub const KVM_S390_MCHK: ::std::os::raw::c_uint = 4294840320;
pub const KVM_S390_INT_CLOCK_COMP: ::std::os::raw::c_uint = 4294905860;
pub const KVM_S390_INT_CPU_TIMER: ::std::os::raw::c_uint = 4294905861;
pub const KVM_S390_INT_VIRTIO: ::std::os::raw::c_uint = 4294911491;
pub const KVM_S390_INT_SERVICE: ::std::os::raw::c_uint = 4294910977;
pub const KVM_S390_INT_EMERGENCY: ::std::os::raw::c_uint = 4294906369;
pub const KVM_S390_INT_EXTERNAL_CALL: ::std::os::raw::c_uint = 4294906370;
pub const KVM_S390_INT_IO_MIN: ::std::os::raw::c_uint = 0;
pub const KVM_S390_INT_IO_MAX: ::std::os::raw::c_uint = 4294836223;
pub const KVM_S390_INT_IO_AI_MASK: ::std::os::raw::c_uint = 67108864;
pub const KVM_S390_PGM_FLAGS_ILC_VALID: ::std::os::raw::c_uint = 1;
pub const KVM_S390_PGM_FLAGS_ILC_0: ::std::os::raw::c_uint = 2;
pub const KVM_S390_PGM_FLAGS_ILC_1: ::std::os::raw::c_uint = 4;
pub const KVM_S390_PGM_FLAGS_ILC_MASK: ::std::os::raw::c_uint = 6;
pub const KVM_S390_PGM_FLAGS_NO_REWIND: ::std::os::raw::c_uint = 8;
pub const KVM_S390_STOP_FLAG_STORE_STATUS: ::std::os::raw::c_uint = 1;
pub const KVM_GUESTDBG_ENABLE: ::std::os::raw::c_uint = 1;
pub const KVM_GUESTDBG_SINGLESTEP: ::std::os::raw::c_uint = 2;
pub const KVM_PPC_PVINFO_FLAGS_EV_IDLE: ::std::os::raw::c_uint = 1;
pub const KVM_PPC_PAGE_SIZES_MAX_SZ: ::std::os::raw::c_uint = 8;
pub const KVM_PPC_PAGE_SIZES_REAL: ::std::os::raw::c_uint = 1;
pub const KVM_PPC_1T_SEGMENTS: ::std::os::raw::c_uint = 2;
pub const KVMIO: ::std::os::raw::c_uint = 174;
pub const KVM_VM_S390_UCONTROL: ::std::os::raw::c_uint = 1;
pub const KVM_VM_PPC_HV: ::std::os::raw::c_uint = 1;
pub const KVM_VM_PPC_PR: ::std::os::raw::c_uint = 2;
pub const KVM_VM_MIPS_TE: ::std::os::raw::c_uint = 0;
pub const KVM_VM_MIPS_VZ: ::std::os::raw::c_uint = 1;
pub const KVM_S390_SIE_PAGE_OFFSET: ::std::os::raw::c_uint = 1;
pub const KVM_CAP_IRQCHIP: ::std::os::raw::c_uint = 0;
pub const KVM_CAP_HLT: ::std::os::raw::c_uint = 1;
pub const KVM_CAP_MMU_SHADOW_CACHE_CONTROL: ::std::os::raw::c_uint = 2;
pub const KVM_CAP_USER_MEMORY: ::std::os::raw::c_uint = 3;
pub const KVM_CAP_SET_TSS_ADDR: ::std::os::raw::c_uint = 4;
pub const KVM_CAP_VAPIC: ::std::os::raw::c_uint = 6;
pub const KVM_CAP_EXT_CPUID: ::std::os::raw::c_uint = 7;
pub const KVM_CAP_CLOCKSOURCE: ::std::os::raw::c_uint = 8;
pub const KVM_CAP_NR_VCPUS: ::std::os::raw::c_uint = 9;
pub const KVM_CAP_NR_MEMSLOTS: ::std::os::raw::c_uint = 10;
pub const KVM_CAP_PIT: ::std::os::raw::c_uint = 11;
pub const KVM_CAP_NOP_IO_DELAY: ::std::os::raw::c_uint = 12;
pub const KVM_CAP_PV_MMU: ::std::os::raw::c_uint = 13;
pub const KVM_CAP_MP_STATE: ::std::os::raw::c_uint = 14;
pub const KVM_CAP_COALESCED_MMIO: ::std::os::raw::c_uint = 15;
pub const KVM_CAP_SYNC_MMU: ::std::os::raw::c_uint = 16;
pub const KVM_CAP_IOMMU: ::std::os::raw::c_uint = 18;
pub const KVM_CAP_DESTROY_MEMORY_REGION_WORKS: ::std::os::raw::c_uint = 21;
pub const KVM_CAP_USER_NMI: ::std::os::raw::c_uint = 22;
pub const KVM_CAP_SET_GUEST_DEBUG: ::std::os::raw::c_uint = 23;
pub const KVM_CAP_REINJECT_CONTROL: ::std::os::raw::c_uint = 24;
pub const KVM_CAP_IRQ_ROUTING: ::std::os::raw::c_uint = 25;
pub const KVM_CAP_IRQ_INJECT_STATUS: ::std::os::raw::c_uint = 26;
pub const KVM_CAP_ASSIGN_DEV_IRQ: ::std::os::raw::c_uint = 29;
pub const KVM_CAP_JOIN_MEMORY_REGIONS_WORKS: ::std::os::raw::c_uint = 30;
pub const KVM_CAP_MCE: ::std::os::raw::c_uint = 31;
pub const KVM_CAP_IRQFD: ::std::os::raw::c_uint = 32;
pub const KVM_CAP_PIT2: ::std::os::raw::c_uint = 33;
pub const KVM_CAP_SET_BOOT_CPU_ID: ::std::os::raw::c_uint = 34;
pub const KVM_CAP_PIT_STATE2: ::std::os::raw::c_uint = 35;
pub const KVM_CAP_IOEVENTFD: ::std::os::raw::c_uint = 36;
pub const KVM_CAP_SET_IDENTITY_MAP_ADDR: ::std::os::raw::c_uint = 37;
pub const KVM_CAP_XEN_HVM: ::std::os::raw::c_uint = 38;
pub const KVM_CAP_ADJUST_CLOCK: ::std::os::raw::c_uint = 39;
pub const KVM_CAP_INTERNAL_ERROR_DATA: ::std::os::raw::c_uint = 40;
pub const KVM_CAP_VCPU_EVENTS: ::std::os::raw::c_uint = 41;
pub const KVM_CAP_S390_PSW: ::std::os::raw::c_uint = 42;
pub const KVM_CAP_PPC_SEGSTATE: ::std::os::raw::c_uint = 43;
pub const KVM_CAP_HYPERV: ::std::os::raw::c_uint = 44;
pub const KVM_CAP_HYPERV_VAPIC: ::std::os::raw::c_uint = 45;
pub const KVM_CAP_HYPERV_SPIN: ::std::os::raw::c_uint = 46;
pub const KVM_CAP_PCI_SEGMENT: ::std::os::raw::c_uint = 47;
pub const KVM_CAP_PPC_PAIRED_SINGLES: ::std::os::raw::c_uint = 48;
pub const KVM_CAP_INTR_SHADOW: ::std::os::raw::c_uint = 49;
pub const KVM_CAP_DEBUGREGS: ::std::os::raw::c_uint = 50;
pub const KVM_CAP_X86_ROBUST_SINGLESTEP: ::std::os::raw::c_uint = 51;
pub const KVM_CAP_PPC_OSI: ::std::os::raw::c_uint = 52;
pub const KVM_CAP_PPC_UNSET_IRQ: ::std::os::raw::c_uint = 53;
pub const KVM_CAP_ENABLE_CAP: ::std::os::raw::c_uint = 54;
pub const KVM_CAP_XSAVE: ::std::os::raw::c_uint = 55;
pub const KVM_CAP_XCRS: ::std::os::raw::c_uint = 56;
pub const KVM_CAP_PPC_GET_PVINFO: ::std::os::raw::c_uint = 57;
pub const KVM_CAP_PPC_IRQ_LEVEL: ::std::os::raw::c_uint = 58;
pub const KVM_CAP_ASYNC_PF: ::std::os::raw::c_uint = 59;
pub const KVM_CAP_TSC_CONTROL: ::std::os::raw::c_uint = 60;
pub const KVM_CAP_GET_TSC_KHZ: ::std::os::raw::c_uint = 61;
pub const KVM_CAP_PPC_BOOKE_SREGS: ::std::os::raw::c_uint = 62;
pub const KVM_CAP_SPAPR_TCE: ::std::os::raw::c_uint = 63;
pub const KVM_CAP_PPC_SMT: ::std::os::raw::c_uint = 64;
pub const KVM_CAP_PPC_RMA: ::std::os::raw::c_uint = 65;
pub const KVM_CAP_MAX_VCPUS: ::std::os::raw::c_uint = 66;
pub const KVM_CAP_PPC_HIOR: ::std::os::raw::c_uint = 67;
pub const KVM_CAP_PPC_PAPR: ::std::os::raw::c_uint = 68;
pub const KVM_CAP_SW_TLB: ::std::os::raw::c_uint = 69;
pub const KVM_CAP_ONE_REG: ::std::os::raw::c_uint = 70;
pub const KVM_CAP_S390_GMAP: ::std::os::raw::c_uint = 71;
pub const KVM_CAP_TSC_DEADLINE_TIMER: ::std::os::raw::c_uint = 72;
pub const KVM_CAP_S390_UCONTROL: ::std::os::raw::c_uint = 73;
pub const KVM_CAP_SYNC_REGS: ::std::os::raw::c_uint = 74;
pub const KVM_CAP_PCI_2_3: ::std::os::raw::c_uint = 75;
pub const KVM_CAP_KVMCLOCK_CTRL: ::std::os::raw::c_uint = 76;
pub const KVM_CAP_SIGNAL_MSI: ::std::os::raw::c_uint = 77;
pub const KVM_CAP_PPC_GET_SMMU_INFO: ::std::os::raw::c_uint = 78;
pub const KVM_CAP_S390_COW: ::std::os::raw::c_uint = 79;
pub const KVM_CAP_PPC_ALLOC_HTAB: ::std::os::raw::c_uint = 80;
pub const KVM_CAP_READONLY_MEM: ::std::os::raw::c_uint = 81;
pub const KVM_CAP_IRQFD_RESAMPLE: ::std::os::raw::c_uint = 82;
pub const KVM_CAP_PPC_BOOKE_WATCHDOG: ::std::os::raw::c_uint = 83;
pub const KVM_CAP_PPC_HTAB_FD: ::std::os::raw::c_uint = 84;
pub const KVM_CAP_S390_CSS_SUPPORT: ::std::os::raw::c_uint = 85;
pub const KVM_CAP_PPC_EPR: ::std::os::raw::c_uint = 86;
pub const KVM_CAP_ARM_PSCI: ::std::os::raw::c_uint = 87;
pub const KVM_CAP_ARM_SET_DEVICE_ADDR: ::std::os::raw::c_uint = 88;
pub const KVM_CAP_DEVICE_CTRL: ::std::os::raw::c_uint = 89;
pub const KVM_CAP_IRQ_MPIC: ::std::os::raw::c_uint = 90;
pub const KVM_CAP_PPC_RTAS: ::std::os::raw::c_uint = 91;
pub const KVM_CAP_IRQ_XICS: ::std::os::raw::c_uint = 92;
pub const KVM_CAP_ARM_EL1_32BIT: ::std::os::raw::c_uint = 93;
pub const KVM_CAP_SPAPR_MULTITCE: ::std::os::raw::c_uint = 94;
pub const KVM_CAP_EXT_EMUL_CPUID: ::std::os::raw::c_uint = 95;
pub const KVM_CAP_HYPERV_TIME: ::std::os::raw::c_uint = 96;
pub const KVM_CAP_IOAPIC_POLARITY_IGNORED: ::std::os::raw::c_uint = 97;
pub const KVM_CAP_ENABLE_CAP_VM: ::std::os::raw::c_uint = 98;
pub const KVM_CAP_S390_IRQCHIP: ::std::os::raw::c_uint = 99;
pub const KVM_CAP_IOEVENTFD_NO_LENGTH: ::std::os::raw::c_uint = 100;
pub const KVM_CAP_VM_ATTRIBUTES: ::std::os::raw::c_uint = 101;
pub const KVM_CAP_ARM_PSCI_0_2: ::std::os::raw::c_uint = 102;
pub const KVM_CAP_PPC_FIXUP_HCALL: ::std::os::raw::c_uint = 103;
pub const KVM_CAP_PPC_ENABLE_HCALL: ::std::os::raw::c_uint = 104;
pub const KVM_CAP_CHECK_EXTENSION_VM: ::std::os::raw::c_uint = 105;
pub const KVM_CAP_S390_USER_SIGP: ::std::os::raw::c_uint = 106;
pub const KVM_CAP_S390_VECTOR_REGISTERS: ::std::os::raw::c_uint = 107;
pub const KVM_CAP_S390_MEM_OP: ::std::os::raw::c_uint = 108;
pub const KVM_CAP_S390_USER_STSI: ::std::os::raw::c_uint = 109;
pub const KVM_CAP_S390_SKEYS: ::std::os::raw::c_uint = 110;
pub const KVM_CAP_MIPS_FPU: ::std::os::raw::c_uint = 111;
pub const KVM_CAP_MIPS_MSA: ::std::os::raw::c_uint = 112;
pub const KVM_CAP_S390_INJECT_IRQ: ::std::os::raw::c_uint = 113;
pub const KVM_CAP_S390_IRQ_STATE: ::std::os::raw::c_uint = 114;
pub const KVM_CAP_PPC_HWRNG: ::std::os::raw::c_uint = 115;
pub const KVM_CAP_DISABLE_QUIRKS: ::std::os::raw::c_uint = 116;
pub const KVM_CAP_X86_SMM: ::std::os::raw::c_uint = 117;
pub const KVM_CAP_MULTI_ADDRESS_SPACE: ::std::os::raw::c_uint = 118;
pub const KVM_CAP_GUEST_DEBUG_HW_BPS: ::std::os::raw::c_uint = 119;
pub const KVM_CAP_GUEST_DEBUG_HW_WPS: ::std::os::raw::c_uint = 120;
pub const KVM_CAP_SPLIT_IRQCHIP: ::std::os::raw::c_uint = 121;
pub const KVM_CAP_IOEVENTFD_ANY_LENGTH: ::std::os::raw::c_uint = 122;
pub const KVM_CAP_HYPERV_SYNIC: ::std::os::raw::c_uint = 123;
pub const KVM_CAP_S390_RI: ::std::os::raw::c_uint = 124;
pub const KVM_CAP_SPAPR_TCE_64: ::std::os::raw::c_uint = 125;
pub const KVM_CAP_ARM_PMU_V3: ::std::os::raw::c_uint = 126;
pub const KVM_CAP_VCPU_ATTRIBUTES: ::std::os::raw::c_uint = 127;
pub const KVM_CAP_MAX_VCPU_ID: ::std::os::raw::c_uint = 128;
pub const KVM_CAP_X2APIC_API: ::std::os::raw::c_uint = 129;
pub const KVM_CAP_S390_USER_INSTR0: ::std::os::raw::c_uint = 130;
pub const KVM_CAP_MSI_DEVID: ::std::os::raw::c_uint = 131;
pub const KVM_CAP_PPC_HTM: ::std::os::raw::c_uint = 132;
pub const KVM_CAP_SPAPR_RESIZE_HPT: ::std::os::raw::c_uint = 133;
pub const KVM_CAP_PPC_MMU_RADIX: ::std::os::raw::c_uint = 134;
pub const KVM_CAP_PPC_MMU_HASH_V3: ::std::os::raw::c_uint = 135;
pub const KVM_CAP_IMMEDIATE_EXIT: ::std::os::raw::c_uint = 136;
pub const KVM_CAP_MIPS_VZ: ::std::os::raw::c_uint = 137;
pub const KVM_CAP_MIPS_TE: ::std::os::raw::c_uint = 138;
pub const KVM_CAP_MIPS_64BIT: ::std::os::raw::c_uint = 139;
pub const KVM_CAP_S390_GS: ::std::os::raw::c_uint = 140;
pub const KVM_CAP_S390_AIS: ::std::os::raw::c_uint = 141;
pub const KVM_CAP_SPAPR_TCE_VFIO: ::std::os::raw::c_uint = 142;
pub const KVM_CAP_X86_GUEST_MWAIT: ::std::os::raw::c_uint = 143;
pub const KVM_CAP_ARM_USER_IRQ: ::std::os::raw::c_uint = 144;
pub const KVM_CAP_S390_CMMA_MIGRATION: ::std::os::raw::c_uint = 145;
pub const KVM_CAP_PPC_FWNMI: ::std::os::raw::c_uint = 146;
pub const KVM_CAP_PPC_SMT_POSSIBLE: ::std::os::raw::c_uint = 147;
pub const KVM_CAP_HYPERV_SYNIC2: ::std::os::raw::c_uint = 148;
pub const KVM_CAP_HYPERV_VP_INDEX: ::std::os::raw::c_uint = 149;
pub const KVM_IRQ_ROUTING_IRQCHIP: ::std::os::raw::c_uint = 1;
pub const KVM_IRQ_ROUTING_MSI: ::std::os::raw::c_uint = 2;
pub const KVM_IRQ_ROUTING_S390_ADAPTER: ::std::os::raw::c_uint = 3;
pub const KVM_IRQ_ROUTING_HV_SINT: ::std::os::raw::c_uint = 4;
pub const KVM_IRQFD_FLAG_DEASSIGN: ::std::os::raw::c_uint = 1;
pub const KVM_IRQFD_FLAG_RESAMPLE: ::std::os::raw::c_uint = 2;
pub const KVM_CLOCK_TSC_STABLE: ::std::os::raw::c_uint = 2;
pub const KVM_MMU_FSL_BOOKE_NOHV: ::std::os::raw::c_uint = 0;
pub const KVM_MMU_FSL_BOOKE_HV: ::std::os::raw::c_uint = 1;
pub const KVM_REG_ARCH_MASK: ::std::os::raw::c_longlong = -72057594037927936;
pub const KVM_REG_GENERIC: ::std::os::raw::c_uint = 0;
pub const KVM_REG_PPC: ::std::os::raw::c_ulonglong = 1152921504606846976;
pub const KVM_REG_X86: ::std::os::raw::c_ulonglong = 2305843009213693952;
pub const KVM_REG_IA64: ::std::os::raw::c_ulonglong = 3458764513820540928;
pub const KVM_REG_ARM: ::std::os::raw::c_ulonglong = 4611686018427387904;
pub const KVM_REG_S390: ::std::os::raw::c_ulonglong = 5764607523034234880;
pub const KVM_REG_ARM64: ::std::os::raw::c_ulonglong = 6917529027641081856;
pub const KVM_REG_MIPS: ::std::os::raw::c_ulonglong = 8070450532247928832;
pub const KVM_REG_SIZE_SHIFT: ::std::os::raw::c_uint = 52;
pub const KVM_REG_SIZE_MASK: ::std::os::raw::c_ulonglong = 67553994410557440;
pub const KVM_REG_SIZE_U8: ::std::os::raw::c_uint = 0;
pub const KVM_REG_SIZE_U16: ::std::os::raw::c_ulonglong = 4503599627370496;
pub const KVM_REG_SIZE_U32: ::std::os::raw::c_ulonglong = 9007199254740992;
pub const KVM_REG_SIZE_U64: ::std::os::raw::c_ulonglong = 13510798882111488;
pub const KVM_REG_SIZE_U128: ::std::os::raw::c_ulonglong = 18014398509481984;
pub const KVM_REG_SIZE_U256: ::std::os::raw::c_ulonglong = 22517998136852480;
pub const KVM_REG_SIZE_U512: ::std::os::raw::c_ulonglong = 27021597764222976;
pub const KVM_REG_SIZE_U1024: ::std::os::raw::c_ulonglong = 31525197391593472;
pub const KVM_MSI_VALID_DEVID: ::std::os::raw::c_uint = 1;
pub const KVM_CREATE_DEVICE_TEST: ::std::os::raw::c_uint = 1;
pub const KVM_DEV_VFIO_GROUP: ::std::os::raw::c_uint = 1;
pub const KVM_DEV_VFIO_GROUP_ADD: ::std::os::raw::c_uint = 1;
pub const KVM_DEV_VFIO_GROUP_DEL: ::std::os::raw::c_uint = 2;
pub const KVM_DEV_VFIO_GROUP_SET_SPAPR_TCE: ::std::os::raw::c_uint = 3;
pub const KVM_S390_STORE_STATUS_NOADDR: ::std::os::raw::c_int = -1;
pub const KVM_S390_STORE_STATUS_PREFIXED: ::std::os::raw::c_int = -2;
pub const KVM_DEV_ASSIGN_ENABLE_IOMMU: ::std::os::raw::c_uint = 1;
pub const KVM_DEV_ASSIGN_PCI_2_3: ::std::os::raw::c_uint = 2;
pub const KVM_DEV_ASSIGN_MASK_INTX: ::std::os::raw::c_uint = 4;
pub const KVM_DEV_IRQ_HOST_INTX: ::std::os::raw::c_uint = 1;
pub const KVM_DEV_IRQ_HOST_MSI: ::std::os::raw::c_uint = 2;
pub const KVM_DEV_IRQ_HOST_MSIX: ::std::os::raw::c_uint = 4;
pub const KVM_DEV_IRQ_GUEST_INTX: ::std::os::raw::c_uint = 256;
pub const KVM_DEV_IRQ_GUEST_MSI: ::std::os::raw::c_uint = 512;
pub const KVM_DEV_IRQ_GUEST_MSIX: ::std::os::raw::c_uint = 1024;
pub const KVM_DEV_IRQ_HOST_MASK: ::std::os::raw::c_uint = 255;
pub const KVM_DEV_IRQ_GUEST_MASK: ::std::os::raw::c_uint = 65280;
pub const KVM_MAX_MSIX_PER_DEV: ::std::os::raw::c_uint = 256;
pub const KVM_X2APIC_API_USE_32BIT_IDS: ::std::os::raw::c_uint = 1;
pub const KVM_X2APIC_API_DISABLE_BROADCAST_QUIRK: ::std::os::raw::c_uint = 2;
pub const KVM_ARM_DEV_EL1_VTIMER: ::std::os::raw::c_uint = 1;
pub const KVM_ARM_DEV_EL1_PTIMER: ::std::os::raw::c_uint = 2;
pub const KVM_ARM_DEV_PMU: ::std::os::raw::c_uint = 4;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
pub type s8 = ::std::os::raw::c_schar;
pub type u8 = ::std::os::raw::c_uchar;
pub type s16 = ::std::os::raw::c_short;
pub type u16 = ::std::os::raw::c_ushort;
pub type s32 = ::std::os::raw::c_int;
pub type u32 = ::std::os::raw::c_uint;
pub type s64 = ::std::os::raw::c_longlong;
pub type u64 = ::std::os::raw::c_ulonglong;
pub const false_: _bindgen_ty_1 = 0;
pub const true_: _bindgen_ty_1 = 1;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __kernel_dev_t = __u32;
pub type fd_set = __kernel_fd_set;
pub type dev_t = __kernel_dev_t;
pub type ino_t = __kernel_ino_t;
pub type mode_t = __kernel_mode_t;
pub type umode_t = ::std::os::raw::c_ushort;
pub type nlink_t = __u32;
pub type off_t = __kernel_off_t;
pub type pid_t = __kernel_pid_t;
pub type daddr_t = __kernel_daddr_t;
pub type key_t = __kernel_key_t;
pub type suseconds_t = __kernel_suseconds_t;
pub type timer_t = __kernel_timer_t;
pub type clockid_t = __kernel_clockid_t;
pub type mqd_t = __kernel_mqd_t;
pub type bool_ = bool;
pub type uid_t = __kernel_uid32_t;
pub type gid_t = __kernel_gid32_t;
pub type uid16_t = __kernel_uid16_t;
pub type gid16_t = __kernel_gid16_t;
pub type loff_t = __kernel_loff_t;
pub type time_t = __kernel_time_t;
pub type clock_t = __kernel_clock_t;
pub type caddr_t = __kernel_caddr_t;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type unchar = ::std::os::raw::c_uchar;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type ulong = ::std::os::raw::c_ulong;
pub type u_int8_t = __u8;
pub type u_int16_t = __u16;
pub type u_int32_t = __u32;
pub type u_int64_t = __u64;
pub type sector_t = ::std::os::raw::c_ulong;
pub type blkcnt_t = ::std::os::raw::c_ulong;
pub type dma_addr_t = u32;
pub type gfp_t = ::std::os::raw::c_uint;
pub type fmode_t = ::std::os::raw::c_uint;
pub type phys_addr_t = u32;
pub type resource_size_t = phys_addr_t;
pub type irq_hw_number_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct atomic_t {
    pub counter: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_atomic_t() {
    assert_eq!(
        ::std::mem::size_of::<atomic_t>(),
        4usize,
        concat!("Size of: ", stringify!(atomic_t))
    );
    assert_eq!(
        ::std::mem::align_of::<atomic_t>(),
        4usize,
        concat!("Alignment of ", stringify!(atomic_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct list_head {
    pub next: *mut list_head,
    pub prev: *mut list_head,
}
#[test]
fn bindgen_test_layout_list_head() {
    assert_eq!(
        ::std::mem::size_of::<list_head>(),
        16usize,
        concat!("Size of: ", stringify!(list_head))
    );
    assert_eq!(
        ::std::mem::align_of::<list_head>(),
        8usize,
        concat!("Alignment of ", stringify!(list_head))
    );
}
impl Default for list_head {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hlist_head {
    pub first: *mut hlist_node,
}
#[test]
fn bindgen_test_layout_hlist_head() {
    assert_eq!(
        ::std::mem::size_of::<hlist_head>(),
        8usize,
        concat!("Size of: ", stringify!(hlist_head))
    );
    assert_eq!(
        ::std::mem::align_of::<hlist_head>(),
        8usize,
        concat!("Alignment of ", stringify!(hlist_head))
    );
}
impl Default for hlist_head {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hlist_node {
    pub next: *mut hlist_node,
    pub pprev: *mut *mut hlist_node,
}
#[test]
fn bindgen_test_layout_hlist_node() {
    assert_eq!(
        ::std::mem::size_of::<hlist_node>(),
        16usize,
        concat!("Size of: ", stringify!(hlist_node))
    );
    assert_eq!(
        ::std::mem::align_of::<hlist_node>(),
        8usize,
        concat!("Alignment of ", stringify!(hlist_node))
    );
}
impl Default for hlist_node {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ustat {
    pub f_tfree: __kernel_daddr_t,
    pub f_tinode: __kernel_ino_t,
    pub f_fname: [::std::os::raw::c_char; 6usize],
    pub f_fpack: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout_ustat() {
    assert_eq!(
        ::std::mem::size_of::<ustat>(),
        32usize,
        concat!("Size of: ", stringify!(ustat))
    );
    assert_eq!(
        ::std::mem::align_of::<ustat>(),
        8usize,
        concat!("Alignment of ", stringify!(ustat))
    );
}
/// struct callback_head - callback structure for use with RCU and task_work
/// @next: next update requests in a list
/// @func: actual update function to call after the grace period.
///
/// The struct is aligned to size of pointer. On most architectures it happens
/// naturally due ABI requirements, but some architectures (like CRIS) have
/// weird ABI and we need to ask it explicitly.
///
/// The alignment is required to guarantee that bit 0 of @next will be
/// clear under normal conditions -- as long as we use call_rcu(),
/// call_rcu_bh(), call_rcu_sched(), or call_srcu() to queue callback.
///
/// This guarantee is important for few reasons:
/// - future call_rcu_lazy() will make use of lower bits in the pointer;
/// - the structure shares storage spacer in struct page with @compound_head,
/// which encode PageTail() in bit 0. The guarantee is needed to avoid
/// false-positive PageTail().
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct callback_head {
    pub next: *mut callback_head,
    pub func: ::std::option::Option<unsafe extern "C" fn(head: *mut callback_head)>,
}
#[test]
fn bindgen_test_layout_callback_head() {
    assert_eq!(
        ::std::mem::size_of::<callback_head>(),
        16usize,
        concat!("Size of: ", stringify!(callback_head))
    );
    assert_eq!(
        ::std::mem::align_of::<callback_head>(),
        8usize,
        concat!("Alignment of ", stringify!(callback_head))
    );
}
impl Default for callback_head {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type rcu_callback_t = ::std::option::Option<unsafe extern "C" fn(head: *mut callback_head)>;
pub type call_rcu_func_t =
    ::std::option::Option<unsafe extern "C" fn(head: *mut callback_head, func: rcu_callback_t)>;
extern "C" {
    #[link_name = "\u{1}_Z31__invalid_size_argument_for_IOC"]
    pub static mut __invalid_size_argument_for_IOC: ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_memory_alias {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub target_phys_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_memory_alias() {
    assert_eq!(
        ::std::mem::size_of::<kvm_memory_alias>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_memory_alias))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_memory_alias>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_memory_alias))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_pic_state {
    pub last_irr: __u8,
    pub irr: __u8,
    pub imr: __u8,
    pub isr: __u8,
    pub priority_add: __u8,
    pub irq_base: __u8,
    pub read_reg_select: __u8,
    pub poll: __u8,
    pub special_mask: __u8,
    pub init_state: __u8,
    pub auto_eoi: __u8,
    pub rotate_on_auto_eoi: __u8,
    pub special_fully_nested_mode: __u8,
    pub init4: __u8,
    pub elcr: __u8,
    pub elcr_mask: __u8,
}
#[test]
fn bindgen_test_layout_kvm_pic_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_pic_state>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_pic_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pic_state>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_pic_state))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_ioapic_state {
    pub base_address: __u64,
    pub ioregsel: __u32,
    pub id: __u32,
    pub irr: __u32,
    pub pad: __u32,
    pub redirtbl: [kvm_ioapic_state__bindgen_ty_1; 24usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_ioapic_state__bindgen_ty_1 {
    pub bits: __u64,
    pub fields: kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1 {
    pub vector: __u8,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize], u8>,
    pub reserved: [__u8; 4usize],
    pub dest_id: __u8,
}
#[test]
fn bindgen_test_layout_kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
impl kvm_ioapic_state__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn delivery_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn dest_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_dest_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delivery_status(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_delivery_status(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn polarity(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_polarity(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn remote_irr(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_remote_irr(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn trig_mode(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_trig_mode(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserve(&self) -> __u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_reserve(&mut self, val: __u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        delivery_mode: __u8,
        dest_mode: __u8,
        delivery_status: __u8,
        polarity: __u8,
        remote_irr: __u8,
        trig_mode: __u8,
        mask: __u8,
        reserve: __u8,
    ) -> __BindgenBitfieldUnit<[u8; 2usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let delivery_mode: u8 = unsafe { ::std::mem::transmute(delivery_mode) };
            delivery_mode as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let dest_mode: u8 = unsafe { ::std::mem::transmute(dest_mode) };
            dest_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let delivery_status: u8 = unsafe { ::std::mem::transmute(delivery_status) };
            delivery_status as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let polarity: u8 = unsafe { ::std::mem::transmute(polarity) };
            polarity as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let remote_irr: u8 = unsafe { ::std::mem::transmute(remote_irr) };
            remote_irr as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let trig_mode: u8 = unsafe { ::std::mem::transmute(trig_mode) };
            trig_mode as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let mask: u8 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(9usize, 7u8, {
            let reserve: u8 = unsafe { ::std::mem::transmute(reserve) };
            reserve as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_kvm_ioapic_state__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ioapic_state__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_ioapic_state__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioapic_state__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioapic_state__bindgen_ty_1))
    );
}
impl Default for kvm_ioapic_state__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_ioapic_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ioapic_state>(),
        216usize,
        concat!("Size of: ", stringify!(kvm_ioapic_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioapic_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioapic_state))
    );
}
impl Default for kvm_ioapic_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_regs {
    pub rax: __u64,
    pub rbx: __u64,
    pub rcx: __u64,
    pub rdx: __u64,
    pub rsi: __u64,
    pub rdi: __u64,
    pub rsp: __u64,
    pub rbp: __u64,
    pub r8: __u64,
    pub r9: __u64,
    pub r10: __u64,
    pub r11: __u64,
    pub r12: __u64,
    pub r13: __u64,
    pub r14: __u64,
    pub r15: __u64,
    pub rip: __u64,
    pub rflags: __u64,
}
#[test]
fn bindgen_test_layout_kvm_regs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_regs>(),
        144usize,
        concat!("Size of: ", stringify!(kvm_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_regs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_regs))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_lapic_state {
    pub regs: [::std::os::raw::c_char; 1024usize],
}

impl ::std::fmt::Debug for kvm_lapic_state {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        self.regs[..].fmt(fmt)
    }
}

#[test]
fn bindgen_test_layout_kvm_lapic_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_lapic_state>(),
        1024usize,
        concat!("Size of: ", stringify!(kvm_lapic_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_lapic_state>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_lapic_state))
    );
}
impl Default for kvm_lapic_state {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_segment {
    pub base: __u64,
    pub limit: __u32,
    pub selector: __u16,
    pub type_: __u8,
    pub present: __u8,
    pub dpl: __u8,
    pub db: __u8,
    pub s: __u8,
    pub l: __u8,
    pub g: __u8,
    pub avl: __u8,
    pub unusable: __u8,
    pub padding: __u8,
}
#[test]
fn bindgen_test_layout_kvm_segment() {
    assert_eq!(
        ::std::mem::size_of::<kvm_segment>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_segment))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_segment>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_segment))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_dtable {
    pub base: __u64,
    pub limit: __u16,
    pub padding: [__u16; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_dtable() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dtable>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dtable))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dtable>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dtable))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_sregs {
    pub cs: kvm_segment,
    pub ds: kvm_segment,
    pub es: kvm_segment,
    pub fs: kvm_segment,
    pub gs: kvm_segment,
    pub ss: kvm_segment,
    pub tr: kvm_segment,
    pub ldt: kvm_segment,
    pub gdt: kvm_dtable,
    pub idt: kvm_dtable,
    pub cr0: __u64,
    pub cr2: __u64,
    pub cr3: __u64,
    pub cr4: __u64,
    pub cr8: __u64,
    pub efer: __u64,
    pub apic_base: __u64,
    pub interrupt_bitmap: [__u64; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_sregs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sregs>(),
        312usize,
        concat!("Size of: ", stringify!(kvm_sregs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sregs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_sregs))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_fpu {
    pub fpr: [[__u8; 16usize]; 8usize],
    pub fcw: __u16,
    pub fsw: __u16,
    pub ftwx: __u8,
    pub pad1: __u8,
    pub last_opcode: __u16,
    pub last_ip: __u64,
    pub last_dp: __u64,
    pub xmm: [[__u8; 16usize]; 16usize],
    pub mxcsr: __u32,
    pub pad2: __u32,
}
#[test]
fn bindgen_test_layout_kvm_fpu() {
    assert_eq!(
        ::std::mem::size_of::<kvm_fpu>(),
        416usize,
        concat!("Size of: ", stringify!(kvm_fpu))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_fpu>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_fpu))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct kvm_msr_entry {
    pub index: __u32,
    pub reserved: __u32,
    pub data: __u64,
}
#[test]
fn bindgen_test_layout_kvm_msr_entry() {
    assert_eq!(
        ::std::mem::size_of::<kvm_msr_entry>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_msr_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msr_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_msr_entry))
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_msrs {
    pub nmsrs: __u32,
    pub pad: __u32,
    pub entries: __IncompleteArrayField<kvm_msr_entry>,
    __force_alignment: [u64; 0],
}
#[test]
fn bindgen_test_layout_kvm_msrs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_msrs>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_msrs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msrs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_msrs))
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_msr_list {
    pub nmsrs: __u32,
    pub indices: __IncompleteArrayField<__u32>,
}
#[test]
fn bindgen_test_layout_kvm_msr_list() {
    assert_eq!(
        ::std::mem::size_of::<kvm_msr_list>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_msr_list))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msr_list>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_msr_list))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_cpuid_entry {
    pub function: __u32,
    pub eax: __u32,
    pub ebx: __u32,
    pub ecx: __u32,
    pub edx: __u32,
    pub padding: __u32,
}
#[test]
fn bindgen_test_layout_kvm_cpuid_entry() {
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid_entry>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_cpuid_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid_entry))
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_cpuid {
    pub nent: __u32,
    pub padding: __u32,
    pub entries: __IncompleteArrayField<kvm_cpuid_entry>,
}
#[test]
fn bindgen_test_layout_kvm_cpuid() {
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_cpuid))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_cpuid_entry2 {
    pub function: __u32,
    pub index: __u32,
    pub flags: __u32,
    pub eax: __u32,
    pub ebx: __u32,
    pub ecx: __u32,
    pub edx: __u32,
    pub padding: [__u32; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_cpuid_entry2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid_entry2>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_cpuid_entry2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid_entry2>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid_entry2))
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_cpuid2 {
    pub nent: __u32,
    pub padding: __u32,
    pub entries: __IncompleteArrayField<kvm_cpuid_entry2>,
}
#[test]
fn bindgen_test_layout_kvm_cpuid2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_cpuid2>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_cpuid2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_cpuid2>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_cpuid2))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_pit_channel_state {
    pub count: __u32,
    pub latched_count: __u16,
    pub count_latched: __u8,
    pub status_latched: __u8,
    pub status: __u8,
    pub read_state: __u8,
    pub write_state: __u8,
    pub write_latch: __u8,
    pub rw_mode: __u8,
    pub mode: __u8,
    pub bcd: __u8,
    pub gate: __u8,
    pub count_load_time: __s64,
}
#[test]
fn bindgen_test_layout_kvm_pit_channel_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_channel_state>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_pit_channel_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_channel_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pit_channel_state))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_debug_exit_arch {
    pub exception: __u32,
    pub pad: __u32,
    pub pc: __u64,
    pub dr6: __u64,
    pub dr7: __u64,
}
#[test]
fn bindgen_test_layout_kvm_debug_exit_arch() {
    assert_eq!(
        ::std::mem::size_of::<kvm_debug_exit_arch>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_debug_exit_arch))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debug_exit_arch>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_debug_exit_arch))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_guest_debug_arch {
    pub debugreg: [__u64; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_guest_debug_arch() {
    assert_eq!(
        ::std::mem::size_of::<kvm_guest_debug_arch>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_guest_debug_arch))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_guest_debug_arch>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_guest_debug_arch))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_pit_state {
    pub channels: [kvm_pit_channel_state; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_state>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_pit_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pit_state))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_pit_state2 {
    pub channels: [kvm_pit_channel_state; 3usize],
    pub flags: __u32,
    pub reserved: [__u32; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_state2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_state2>(),
        112usize,
        concat!("Size of: ", stringify!(kvm_pit_state2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_state2>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_pit_state2))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_reinject_control {
    pub pit_reinject: __u8,
    pub reserved: [__u8; 31usize],
}
#[test]
fn bindgen_test_layout_kvm_reinject_control() {
    assert_eq!(
        ::std::mem::size_of::<kvm_reinject_control>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_reinject_control))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_reinject_control>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_reinject_control))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vcpu_events {
    pub exception: kvm_vcpu_events__bindgen_ty_1,
    pub interrupt: kvm_vcpu_events__bindgen_ty_2,
    pub nmi: kvm_vcpu_events__bindgen_ty_3,
    pub sipi_vector: __u32,
    pub flags: __u32,
    pub smi: kvm_vcpu_events__bindgen_ty_4,
    pub reserved: [__u32; 9usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vcpu_events__bindgen_ty_1 {
    pub injected: __u8,
    pub nr: __u8,
    pub has_error_code: __u8,
    pub pad: __u8,
    pub error_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_1))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vcpu_events__bindgen_ty_2 {
    pub injected: __u8,
    pub nr: __u8,
    pub soft: __u8,
    pub shadow: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_2))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vcpu_events__bindgen_ty_3 {
    pub injected: __u8,
    pub pending: __u8,
    pub masked: __u8,
    pub pad: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_3>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_3>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_3))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vcpu_events__bindgen_ty_4 {
    pub smm: __u8,
    pub pending: __u8,
    pub smm_inside_nmi: __u8,
    pub latched_init: __u8,
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events__bindgen_ty_4>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events__bindgen_ty_4>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events__bindgen_ty_4))
    );
}
#[test]
fn bindgen_test_layout_kvm_vcpu_events() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vcpu_events>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_vcpu_events))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vcpu_events>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vcpu_events))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_debugregs {
    pub db: [__u64; 4usize],
    pub dr6: __u64,
    pub dr7: __u64,
    pub flags: __u64,
    pub reserved: [__u64; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_debugregs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_debugregs>(),
        128usize,
        concat!("Size of: ", stringify!(kvm_debugregs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debugregs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_debugregs))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_xsave {
    pub region: [__u32; 1024usize],
}
#[test]
fn bindgen_test_layout_kvm_xsave() {
    assert_eq!(
        ::std::mem::size_of::<kvm_xsave>(),
        4096usize,
        concat!("Size of: ", stringify!(kvm_xsave))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xsave>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_xsave))
    );
}
impl Default for kvm_xsave {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_xcr {
    pub xcr: __u32,
    pub reserved: __u32,
    pub value: __u64,
}
#[test]
fn bindgen_test_layout_kvm_xcr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_xcr>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_xcr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xcr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xcr))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_xcrs {
    pub nr_xcrs: __u32,
    pub flags: __u32,
    pub xcrs: [kvm_xcr; 16usize],
    pub padding: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_xcrs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_xcrs>(),
        392usize,
        concat!("Size of: ", stringify!(kvm_xcrs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xcrs>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xcrs))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_sync_regs {}
#[test]
fn bindgen_test_layout_kvm_sync_regs() {
    assert_eq!(
        ::std::mem::size_of::<kvm_sync_regs>(),
        0usize,
        concat!("Size of: ", stringify!(kvm_sync_regs))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_sync_regs>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_sync_regs))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_user_trace_setup {
    pub buf_size: __u32,
    pub buf_nr: __u32,
}
#[test]
fn bindgen_test_layout_kvm_user_trace_setup() {
    assert_eq!(
        ::std::mem::size_of::<kvm_user_trace_setup>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_user_trace_setup))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_user_trace_setup>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_user_trace_setup))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_breakpoint {
    pub enabled: __u32,
    pub padding: __u32,
    pub address: __u64,
}
#[test]
fn bindgen_test_layout_kvm_breakpoint() {
    assert_eq!(
        ::std::mem::size_of::<kvm_breakpoint>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_breakpoint))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_breakpoint>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_breakpoint))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_debug_guest {
    pub enabled: __u32,
    pub pad: __u32,
    pub breakpoints: [kvm_breakpoint; 4usize],
    pub singlestep: __u32,
}
#[test]
fn bindgen_test_layout_kvm_debug_guest() {
    assert_eq!(
        ::std::mem::size_of::<kvm_debug_guest>(),
        80usize,
        concat!("Size of: ", stringify!(kvm_debug_guest))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_debug_guest>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_debug_guest))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_memory_region {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
}
#[test]
fn bindgen_test_layout_kvm_memory_region() {
    assert_eq!(
        ::std::mem::size_of::<kvm_memory_region>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_memory_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_memory_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_memory_region))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_userspace_memory_region {
    pub slot: __u32,
    pub flags: __u32,
    pub guest_phys_addr: __u64,
    pub memory_size: __u64,
    pub userspace_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_userspace_memory_region() {
    assert_eq!(
        ::std::mem::size_of::<kvm_userspace_memory_region>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_userspace_memory_region))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_userspace_memory_region>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_userspace_memory_region))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_level {
    pub __bindgen_anon_1: kvm_irq_level__bindgen_ty_1,
    pub level: __u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_level__bindgen_ty_1 {
    pub irq: __u32,
    pub status: __s32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_level__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_level__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_irq_level__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_level__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_level__bindgen_ty_1))
    );
}
impl Default for kvm_irq_level__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_level() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_level>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_level))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_level>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_level))
    );
}
impl Default for kvm_irq_level {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irqchip {
    pub chip_id: __u32,
    pub pad: __u32,
    pub chip: kvm_irqchip__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irqchip__bindgen_ty_1 {
    pub dummy: [::std::os::raw::c_char; 512usize],
    pub pic: kvm_pic_state,
    pub ioapic: kvm_ioapic_state,
    _bindgen_union_align: [u64; 64usize],
}
#[test]
fn bindgen_test_layout_kvm_irqchip__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irqchip__bindgen_ty_1>(),
        512usize,
        concat!("Size of: ", stringify!(kvm_irqchip__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqchip__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irqchip__bindgen_ty_1))
    );
}
impl Default for kvm_irqchip__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irqchip() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irqchip>(),
        520usize,
        concat!("Size of: ", stringify!(kvm_irqchip))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqchip>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irqchip))
    );
}
impl Default for kvm_irqchip {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_pit_config {
    pub flags: __u32,
    pub pad: [__u32; 15usize],
}
#[test]
fn bindgen_test_layout_kvm_pit_config() {
    assert_eq!(
        ::std::mem::size_of::<kvm_pit_config>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_pit_config))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_pit_config>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_pit_config))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_skeys {
    pub start_gfn: __u64,
    pub count: __u64,
    pub skeydata_addr: __u64,
    pub flags: __u32,
    pub reserved: [__u32; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_skeys() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_skeys>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_s390_skeys))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_skeys>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_skeys))
    );
}
/// kvm_s390_cmma_log - Used for CMMA migration.
///
/// Used both for input and output.
///
/// @start_gfn: Guest page number to start from.
/// @count: Size of the result buffer.
/// @flags: Control operation mode via KVM_S390_CMMA_* flags
/// @remaining: Used with KVM_S390_GET_CMMA_BITS. Indicates how many dirty
/// pages are still remaining.
/// @mask: Used with KVM_S390_SET_CMMA_BITS. Bitmap of bits to actually set
/// in the PGSTE.
/// @values: Pointer to the values buffer.
///
/// Used in KVM_S390_{G,S}ET_CMMA_BITS ioctls.
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_s390_cmma_log {
    pub start_gfn: __u64,
    pub count: __u32,
    pub flags: __u32,
    pub __bindgen_anon_1: kvm_s390_cmma_log__bindgen_ty_1,
    pub values: __u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_s390_cmma_log__bindgen_ty_1 {
    pub remaining: __u64,
    pub mask: __u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_cmma_log__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_cmma_log__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_s390_cmma_log__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_cmma_log__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_cmma_log__bindgen_ty_1))
    );
}
impl Default for kvm_s390_cmma_log__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_s390_cmma_log() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_cmma_log>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_s390_cmma_log))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_cmma_log>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_cmma_log))
    );
}
impl Default for kvm_s390_cmma_log {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_hyperv_exit {
    pub type_: __u32,
    pub u: kvm_hyperv_exit__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_hyperv_exit__bindgen_ty_1 {
    pub synic: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1,
    pub hcall: kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2,
    _bindgen_union_align: [u64; 4usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1 {
    pub msr: __u32,
    pub control: __u64,
    pub evt_page: __u64,
    pub msg_page: __u64,
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2 {
    pub input: __u64,
    pub result: __u64,
    pub params: [__u64; 2usize],
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_hyperv_exit__bindgen_ty_1__bindgen_ty_2)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_hyperv_exit__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_exit__bindgen_ty_1))
    );
}
impl Default for kvm_hyperv_exit__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_hyperv_exit() {
    assert_eq!(
        ::std::mem::size_of::<kvm_hyperv_exit>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_hyperv_exit))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_hyperv_exit>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_hyperv_exit))
    );
}
impl Default for kvm_hyperv_exit {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_run {
    pub request_interrupt_window: __u8,
    pub immediate_exit: __u8,
    pub padding1: [__u8; 6usize],
    pub exit_reason: __u32,
    pub ready_for_interrupt_injection: __u8,
    pub if_flag: __u8,
    pub flags: __u16,
    pub cr8: __u64,
    pub apic_base: __u64,
    pub __bindgen_anon_1: kvm_run__bindgen_ty_1,
    pub kvm_valid_regs: __u64,
    pub kvm_dirty_regs: __u64,
    pub s: kvm_run__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_1 {
    pub hw: kvm_run__bindgen_ty_1__bindgen_ty_1,
    pub fail_entry: kvm_run__bindgen_ty_1__bindgen_ty_2,
    pub ex: kvm_run__bindgen_ty_1__bindgen_ty_3,
    pub io: kvm_run__bindgen_ty_1__bindgen_ty_4,
    pub debug: kvm_run__bindgen_ty_1__bindgen_ty_5,
    pub mmio: kvm_run__bindgen_ty_1__bindgen_ty_6,
    pub hypercall: kvm_run__bindgen_ty_1__bindgen_ty_7,
    pub tpr_access: kvm_run__bindgen_ty_1__bindgen_ty_8,
    pub s390_sieic: kvm_run__bindgen_ty_1__bindgen_ty_9,
    pub s390_reset_flags: __u64,
    pub s390_ucontrol: kvm_run__bindgen_ty_1__bindgen_ty_10,
    pub dcr: kvm_run__bindgen_ty_1__bindgen_ty_11,
    pub internal: kvm_run__bindgen_ty_1__bindgen_ty_12,
    pub osi: kvm_run__bindgen_ty_1__bindgen_ty_13,
    pub papr_hcall: kvm_run__bindgen_ty_1__bindgen_ty_14,
    pub s390_tsch: kvm_run__bindgen_ty_1__bindgen_ty_15,
    pub epr: kvm_run__bindgen_ty_1__bindgen_ty_16,
    pub system_event: kvm_run__bindgen_ty_1__bindgen_ty_17,
    pub s390_stsi: kvm_run__bindgen_ty_1__bindgen_ty_18,
    pub eoi: kvm_run__bindgen_ty_1__bindgen_ty_19,
    pub hyperv: kvm_hyperv_exit,
    pub padding: [::std::os::raw::c_char; 256usize],
    _bindgen_union_align: [u64; 32usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_1 {
    pub hardware_exit_reason: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_2 {
    pub hardware_entry_failure_reason: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_2)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_3 {
    pub exception: __u32,
    pub error_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_3>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_3)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_4 {
    pub direction: __u8,
    pub size: __u8,
    pub port: __u16,
    pub count: __u32,
    pub data_offset: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_4)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_5 {
    pub arch: kvm_debug_exit_arch,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_5>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_5)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_6 {
    pub phys_addr: __u64,
    pub data: [__u8; 8usize],
    pub len: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_6>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_6)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_7 {
    pub nr: __u64,
    pub args: [__u64; 6usize],
    pub ret: __u64,
    pub longmode: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_7>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_8 {
    pub rip: __u64,
    pub is_write: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_8() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_8>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_8)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_9 {
    pub icptcode: __u8,
    pub ipa: __u16,
    pub ipb: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_9() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_9>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_9)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_10 {
    pub trans_exc_code: __u64,
    pub pgm_code: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_10() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_10>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_10)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_11 {
    pub dcrn: __u32,
    pub data: __u32,
    pub is_write: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_11() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_11>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_11)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_12 {
    pub suberror: __u32,
    pub ndata: __u32,
    pub data: [__u64; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_12() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>(),
        136usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_12>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_12)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_13 {
    pub gprs: [__u64; 32usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_13() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>(),
        256usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_13>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_13)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_14 {
    pub nr: __u64,
    pub ret: __u64,
    pub args: [__u64; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_14() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_14>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_14)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_15 {
    pub subchannel_id: __u16,
    pub subchannel_nr: __u16,
    pub io_int_parm: __u32,
    pub io_int_word: __u32,
    pub ipb: __u32,
    pub dequeued: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_15() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>(),
        20usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_15>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_15)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_16 {
    pub epr: __u32,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_16() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_16>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_16)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_17 {
    pub type_: __u32,
    pub flags: __u64,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_17() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_17>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_17)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_18 {
    pub addr: __u64,
    pub ar: __u8,
    pub reserved: __u8,
    pub fc: __u8,
    pub sel1: __u8,
    pub sel2: __u16,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_18() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_18>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_18)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_run__bindgen_ty_1__bindgen_ty_19 {
    pub vector: __u8,
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1__bindgen_ty_19() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>(),
        1usize,
        concat!(
            "Size of: ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1__bindgen_ty_19>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_run__bindgen_ty_1__bindgen_ty_19)
        )
    );
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_1>(),
        256usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run__bindgen_ty_1))
    );
}
impl Default for kvm_run__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_run__bindgen_ty_2 {
    pub regs: kvm_sync_regs,
    pub padding: [::std::os::raw::c_char; 2048usize],
    _bindgen_union_align: [u8; 2048usize],
}
#[test]
fn bindgen_test_layout_kvm_run__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run__bindgen_ty_2>(),
        2048usize,
        concat!("Size of: ", stringify!(kvm_run__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run__bindgen_ty_2>(),
        1usize,
        concat!("Alignment of ", stringify!(kvm_run__bindgen_ty_2))
    );
}
impl Default for kvm_run__bindgen_ty_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_run() {
    assert_eq!(
        ::std::mem::size_of::<kvm_run>(),
        2352usize,
        concat!("Size of: ", stringify!(kvm_run))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_run>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_run))
    );
}
impl Default for kvm_run {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_coalesced_mmio_zone {
    pub addr: __u64,
    pub size: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_zone() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_zone>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio_zone))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_zone>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio_zone))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_coalesced_mmio {
    pub phys_addr: __u64,
    pub len: __u32,
    pub pad: __u32,
    pub data: [__u8; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio))
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_coalesced_mmio_ring {
    pub first: __u32,
    pub last: __u32,
    pub coalesced_mmio: __IncompleteArrayField<kvm_coalesced_mmio>,
    __force_alignment: [u64; 0],
}
#[test]
fn bindgen_test_layout_kvm_coalesced_mmio_ring() {
    assert_eq!(
        ::std::mem::size_of::<kvm_coalesced_mmio_ring>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_coalesced_mmio_ring))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_coalesced_mmio_ring>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_coalesced_mmio_ring))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_translation {
    pub linear_address: __u64,
    pub physical_address: __u64,
    pub valid: __u8,
    pub writeable: __u8,
    pub usermode: __u8,
    pub pad: [__u8; 5usize],
}
#[test]
fn bindgen_test_layout_kvm_translation() {
    assert_eq!(
        ::std::mem::size_of::<kvm_translation>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_translation))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_translation>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_translation))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_mem_op {
    pub gaddr: __u64,
    pub flags: __u64,
    pub size: __u32,
    pub op: __u32,
    pub buf: __u64,
    pub ar: __u8,
    pub reserved: [__u8; 31usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_mem_op() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_mem_op>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_s390_mem_op))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_mem_op>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_mem_op))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_interrupt {
    pub irq: __u32,
}
#[test]
fn bindgen_test_layout_kvm_interrupt() {
    assert_eq!(
        ::std::mem::size_of::<kvm_interrupt>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_interrupt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_interrupt>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_interrupt))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_dirty_log {
    pub slot: __u32,
    pub padding1: __u32,
    pub __bindgen_anon_1: kvm_dirty_log__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_dirty_log__bindgen_ty_1 {
    pub dirty_bitmap: *mut ::std::os::raw::c_void,
    pub padding2: __u64,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_kvm_dirty_log__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_dirty_log__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_log__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_log__bindgen_ty_1))
    );
}
impl Default for kvm_dirty_log__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_dirty_log() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_log>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_log))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_log>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_log))
    );
}
impl Default for kvm_dirty_log {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_signal_mask {
    pub len: __u32,
    pub sigset: __IncompleteArrayField<__u8>,
}
#[test]
fn bindgen_test_layout_kvm_signal_mask() {
    assert_eq!(
        ::std::mem::size_of::<kvm_signal_mask>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_signal_mask))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_signal_mask>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_signal_mask))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_tpr_access_ctl {
    pub enabled: __u32,
    pub flags: __u32,
    pub reserved: [__u32; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_tpr_access_ctl() {
    assert_eq!(
        ::std::mem::size_of::<kvm_tpr_access_ctl>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_tpr_access_ctl))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_tpr_access_ctl>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_tpr_access_ctl))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vapic_addr {
    pub vapic_addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_vapic_addr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vapic_addr>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vapic_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vapic_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_vapic_addr))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_mp_state {
    pub mp_state: __u32,
}
#[test]
fn bindgen_test_layout_kvm_mp_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_mp_state>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_mp_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_mp_state>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_mp_state))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_psw {
    pub mask: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_psw() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_psw>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_s390_psw))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_psw>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_psw))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_interrupt {
    pub type_: __u32,
    pub parm: __u32,
    pub parm64: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_interrupt() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_interrupt>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_s390_interrupt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_interrupt>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_interrupt))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_io_info {
    pub subchannel_id: __u16,
    pub subchannel_nr: __u16,
    pub io_int_parm: __u32,
    pub io_int_word: __u32,
}
#[test]
fn bindgen_test_layout_kvm_s390_io_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_io_info>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_s390_io_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_io_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_s390_io_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_ext_info {
    pub ext_params: __u32,
    pub pad: __u32,
    pub ext_params2: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_ext_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_ext_info>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_s390_ext_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_ext_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_ext_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_pgm_info {
    pub trans_exc_code: __u64,
    pub mon_code: __u64,
    pub per_address: __u64,
    pub data_exc_code: __u32,
    pub code: __u16,
    pub mon_class_nr: __u16,
    pub per_code: __u8,
    pub per_atmid: __u8,
    pub exc_access_id: __u8,
    pub per_access_id: __u8,
    pub op_access_id: __u8,
    pub flags: __u8,
    pub pad: [__u8; 2usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_pgm_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_pgm_info>(),
        40usize,
        concat!("Size of: ", stringify!(kvm_s390_pgm_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_pgm_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_pgm_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_prefix_info {
    pub address: __u32,
}
#[test]
fn bindgen_test_layout_kvm_s390_prefix_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_prefix_info>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_s390_prefix_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_prefix_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_s390_prefix_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_extcall_info {
    pub code: __u16,
}
#[test]
fn bindgen_test_layout_kvm_s390_extcall_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_extcall_info>(),
        2usize,
        concat!("Size of: ", stringify!(kvm_s390_extcall_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_extcall_info>(),
        2usize,
        concat!("Alignment of ", stringify!(kvm_s390_extcall_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_emerg_info {
    pub code: __u16,
}
#[test]
fn bindgen_test_layout_kvm_s390_emerg_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_emerg_info>(),
        2usize,
        concat!("Size of: ", stringify!(kvm_s390_emerg_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_emerg_info>(),
        2usize,
        concat!("Alignment of ", stringify!(kvm_s390_emerg_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_stop_info {
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_kvm_s390_stop_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_stop_info>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_s390_stop_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_stop_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_s390_stop_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_mchk_info {
    pub cr14: __u64,
    pub mcic: __u64,
    pub failing_storage_address: __u64,
    pub ext_damage_code: __u32,
    pub pad: __u32,
    pub fixed_logout: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_mchk_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_mchk_info>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_s390_mchk_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_mchk_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_mchk_info))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_s390_irq {
    pub type_: __u64,
    pub u: kvm_s390_irq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_s390_irq__bindgen_ty_1 {
    pub io: kvm_s390_io_info,
    pub ext: kvm_s390_ext_info,
    pub pgm: kvm_s390_pgm_info,
    pub emerg: kvm_s390_emerg_info,
    pub extcall: kvm_s390_extcall_info,
    pub prefix: kvm_s390_prefix_info,
    pub stop: kvm_s390_stop_info,
    pub mchk: kvm_s390_mchk_info,
    pub reserved: [::std::os::raw::c_char; 64usize],
    _bindgen_union_align: [u64; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_irq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_irq__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_s390_irq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_irq__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_irq__bindgen_ty_1))
    );
}
impl Default for kvm_s390_irq__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_s390_irq() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_irq>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_s390_irq))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_irq>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_irq))
    );
}
impl Default for kvm_s390_irq {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_irq_state {
    pub buf: __u64,
    pub flags: __u32,
    pub len: __u32,
    pub reserved: [__u32; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_s390_irq_state() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_irq_state>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_s390_irq_state))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_irq_state>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_irq_state))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_guest_debug {
    pub control: __u32,
    pub pad: __u32,
    pub arch: kvm_guest_debug_arch,
}
#[test]
fn bindgen_test_layout_kvm_guest_debug() {
    assert_eq!(
        ::std::mem::size_of::<kvm_guest_debug>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_guest_debug))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_guest_debug>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_guest_debug))
    );
}
pub const kvm_ioeventfd_flag_nr_datamatch: _bindgen_ty_2 = 0;
pub const kvm_ioeventfd_flag_nr_pio: _bindgen_ty_2 = 1;
pub const kvm_ioeventfd_flag_nr_deassign: _bindgen_ty_2 = 2;
pub const kvm_ioeventfd_flag_nr_virtio_ccw_notify: _bindgen_ty_2 = 3;
pub const kvm_ioeventfd_flag_nr_fast_mmio: _bindgen_ty_2 = 4;
pub const kvm_ioeventfd_flag_nr_max: _bindgen_ty_2 = 5;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_ioeventfd {
    pub datamatch: __u64,
    pub addr: __u64,
    pub len: __u32,
    pub fd: __s32,
    pub flags: __u32,
    pub pad: [__u8; 36usize],
}
#[test]
fn bindgen_test_layout_kvm_ioeventfd() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ioeventfd>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_ioeventfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ioeventfd>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ioeventfd))
    );
}
impl Default for kvm_ioeventfd {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_enable_cap {
    pub cap: __u32,
    pub flags: __u32,
    pub args: [__u64; 4usize],
    pub pad: [__u8; 64usize],
}
#[test]
fn bindgen_test_layout_kvm_enable_cap() {
    assert_eq!(
        ::std::mem::size_of::<kvm_enable_cap>(),
        104usize,
        concat!("Size of: ", stringify!(kvm_enable_cap))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_enable_cap>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_enable_cap))
    );
}
impl Default for kvm_enable_cap {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_ppc_pvinfo {
    pub flags: __u32,
    pub hcall: [__u32; 4usize],
    pub pad: [__u8; 108usize],
}
#[test]
fn bindgen_test_layout_kvm_ppc_pvinfo() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_pvinfo>(),
        128usize,
        concat!("Size of: ", stringify!(kvm_ppc_pvinfo))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_pvinfo>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_ppc_pvinfo))
    );
}
impl Default for kvm_ppc_pvinfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_ppc_one_page_size {
    pub page_shift: __u32,
    pub pte_enc: __u32,
}
#[test]
fn bindgen_test_layout_kvm_ppc_one_page_size() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_one_page_size>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_ppc_one_page_size))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_one_page_size>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_ppc_one_page_size))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_ppc_one_seg_page_size {
    pub page_shift: __u32,
    pub slb_enc: __u32,
    pub enc: [kvm_ppc_one_page_size; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_ppc_one_seg_page_size() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_one_seg_page_size>(),
        72usize,
        concat!("Size of: ", stringify!(kvm_ppc_one_seg_page_size))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_one_seg_page_size>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_ppc_one_seg_page_size))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_ppc_smmu_info {
    pub flags: __u64,
    pub slb_size: __u32,
    pub pad: __u32,
    pub sps: [kvm_ppc_one_seg_page_size; 8usize],
}
#[test]
fn bindgen_test_layout_kvm_ppc_smmu_info() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_smmu_info>(),
        592usize,
        concat!("Size of: ", stringify!(kvm_ppc_smmu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_smmu_info>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ppc_smmu_info))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_ppc_resize_hpt {
    pub flags: __u64,
    pub shift: __u32,
    pub pad: __u32,
}
#[test]
fn bindgen_test_layout_kvm_ppc_resize_hpt() {
    assert_eq!(
        ::std::mem::size_of::<kvm_ppc_resize_hpt>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_ppc_resize_hpt))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_ppc_resize_hpt>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_ppc_resize_hpt))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_irq_routing_irqchip {
    pub irqchip: __u32,
    pub pin: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_irqchip() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_irqchip>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_irqchip))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_irqchip>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_irqchip))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub __bindgen_anon_1: kvm_irq_routing_msi__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_msi__bindgen_ty_1 {
    pub pad: __u32,
    pub devid: __u32,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_msi__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_msi__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_msi__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_msi__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_irq_routing_msi__bindgen_ty_1)
        )
    );
}
impl Default for kvm_irq_routing_msi__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_msi() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_msi>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_msi>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_msi))
    );
}
impl Default for kvm_irq_routing_msi {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_irq_routing_s390_adapter {
    pub ind_addr: __u64,
    pub summary_addr: __u64,
    pub ind_offset: __u64,
    pub summary_offset: __u32,
    pub adapter_id: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_s390_adapter() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_s390_adapter>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_s390_adapter))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_s390_adapter>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_s390_adapter))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_irq_routing_hv_sint {
    pub vcpu: __u32,
    pub sint: __u32,
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_hv_sint() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_hv_sint>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_hv_sint))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_hv_sint>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_hv_sint))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_irq_routing_entry {
    pub gsi: __u32,
    pub type_: __u32,
    pub flags: __u32,
    pub pad: __u32,
    pub u: kvm_irq_routing_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_irq_routing_entry__bindgen_ty_1 {
    pub irqchip: kvm_irq_routing_irqchip,
    pub msi: kvm_irq_routing_msi,
    pub adapter: kvm_irq_routing_s390_adapter,
    pub hv_sint: kvm_irq_routing_hv_sint,
    pub pad: [__u32; 8usize],
    _bindgen_union_align: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_entry__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_entry__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_entry__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_entry__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_irq_routing_entry__bindgen_ty_1)
        )
    );
}
impl Default for kvm_irq_routing_entry__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_irq_routing_entry() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing_entry>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_irq_routing_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing_entry))
    );
}
impl Default for kvm_irq_routing_entry {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
pub struct kvm_irq_routing {
    pub nr: __u32,
    pub flags: __u32,
    pub entries: __IncompleteArrayField<kvm_irq_routing_entry>,
    __force_alignment: [u64; 0],
}
#[test]
fn bindgen_test_layout_kvm_irq_routing() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irq_routing>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_irq_routing))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irq_routing>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_irq_routing))
    );
}
impl Default for kvm_irq_routing {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_x86_mce {
    pub status: __u64,
    pub addr: __u64,
    pub misc: __u64,
    pub mcg_status: __u64,
    pub bank: __u8,
    pub pad1: [__u8; 7usize],
    pub pad2: [__u64; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_x86_mce() {
    assert_eq!(
        ::std::mem::size_of::<kvm_x86_mce>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_x86_mce))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_x86_mce>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_x86_mce))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_xen_hvm_config {
    pub flags: __u32,
    pub msr: __u32,
    pub blob_addr_32: __u64,
    pub blob_addr_64: __u64,
    pub blob_size_32: __u8,
    pub blob_size_64: __u8,
    pub pad2: [__u8; 30usize],
}
#[test]
fn bindgen_test_layout_kvm_xen_hvm_config() {
    assert_eq!(
        ::std::mem::size_of::<kvm_xen_hvm_config>(),
        56usize,
        concat!("Size of: ", stringify!(kvm_xen_hvm_config))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_xen_hvm_config>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_xen_hvm_config))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_irqfd {
    pub fd: __u32,
    pub gsi: __u32,
    pub flags: __u32,
    pub resamplefd: __u32,
    pub pad: [__u8; 16usize],
}
#[test]
fn bindgen_test_layout_kvm_irqfd() {
    assert_eq!(
        ::std::mem::size_of::<kvm_irqfd>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_irqfd))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_irqfd>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_irqfd))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_clock_data {
    pub clock: __u64,
    pub flags: __u32,
    pub pad: [__u32; 9usize],
}
#[test]
fn bindgen_test_layout_kvm_clock_data() {
    assert_eq!(
        ::std::mem::size_of::<kvm_clock_data>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_clock_data))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_clock_data>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_clock_data))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_config_tlb {
    pub params: __u64,
    pub array: __u64,
    pub mmu_type: __u32,
    pub array_len: __u32,
}
#[test]
fn bindgen_test_layout_kvm_config_tlb() {
    assert_eq!(
        ::std::mem::size_of::<kvm_config_tlb>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_config_tlb))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_config_tlb>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_config_tlb))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_dirty_tlb {
    pub bitmap: __u64,
    pub num_dirty: __u32,
}
#[test]
fn bindgen_test_layout_kvm_dirty_tlb() {
    assert_eq!(
        ::std::mem::size_of::<kvm_dirty_tlb>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_dirty_tlb))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_dirty_tlb>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_dirty_tlb))
    );
}
#[repr(C)]
#[derive(Debug, Default)]
pub struct kvm_reg_list {
    pub n: __u64,
    pub reg: __IncompleteArrayField<__u64>,
}
#[test]
fn bindgen_test_layout_kvm_reg_list() {
    assert_eq!(
        ::std::mem::size_of::<kvm_reg_list>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_reg_list))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_reg_list>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_reg_list))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_one_reg {
    pub id: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_one_reg() {
    assert_eq!(
        ::std::mem::size_of::<kvm_one_reg>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_one_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_one_reg>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_one_reg))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_msi {
    pub address_lo: __u32,
    pub address_hi: __u32,
    pub data: __u32,
    pub flags: __u32,
    pub devid: __u32,
    pub pad: [__u8; 12usize],
}
#[test]
fn bindgen_test_layout_kvm_msi() {
    assert_eq!(
        ::std::mem::size_of::<kvm_msi>(),
        32usize,
        concat!("Size of: ", stringify!(kvm_msi))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_msi>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_msi))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_arm_device_addr {
    pub id: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_arm_device_addr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_arm_device_addr>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_arm_device_addr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_arm_device_addr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_arm_device_addr))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_create_device {
    pub type_: __u32,
    pub fd: __u32,
    pub flags: __u32,
}
#[test]
fn bindgen_test_layout_kvm_create_device() {
    assert_eq!(
        ::std::mem::size_of::<kvm_create_device>(),
        12usize,
        concat!("Size of: ", stringify!(kvm_create_device))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_create_device>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_create_device))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_device_attr {
    pub flags: __u32,
    pub group: __u32,
    pub attr: __u64,
    pub addr: __u64,
}
#[test]
fn bindgen_test_layout_kvm_device_attr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_device_attr>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_device_attr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_device_attr>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_device_attr))
    );
}
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_20: kvm_device_type = 1;
pub const kvm_device_type_KVM_DEV_TYPE_FSL_MPIC_42: kvm_device_type = 2;
pub const kvm_device_type_KVM_DEV_TYPE_XICS: kvm_device_type = 3;
pub const kvm_device_type_KVM_DEV_TYPE_VFIO: kvm_device_type = 4;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V2: kvm_device_type = 5;
pub const kvm_device_type_KVM_DEV_TYPE_FLIC: kvm_device_type = 6;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_V3: kvm_device_type = 7;
pub const kvm_device_type_KVM_DEV_TYPE_ARM_VGIC_ITS: kvm_device_type = 8;
pub const kvm_device_type_KVM_DEV_TYPE_MAX: kvm_device_type = 9;
pub type kvm_device_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_vfio_spapr_tce {
    pub groupfd: __s32,
    pub tablefd: __s32,
}
#[test]
fn bindgen_test_layout_kvm_vfio_spapr_tce() {
    assert_eq!(
        ::std::mem::size_of::<kvm_vfio_spapr_tce>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_vfio_spapr_tce))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_vfio_spapr_tce>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_vfio_spapr_tce))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_s390_ucas_mapping {
    pub user_addr: __u64,
    pub vcpu_addr: __u64,
    pub length: __u64,
}
#[test]
fn bindgen_test_layout_kvm_s390_ucas_mapping() {
    assert_eq!(
        ::std::mem::size_of::<kvm_s390_ucas_mapping>(),
        24usize,
        concat!("Size of: ", stringify!(kvm_s390_ucas_mapping))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_s390_ucas_mapping>(),
        8usize,
        concat!("Alignment of ", stringify!(kvm_s390_ucas_mapping))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_assigned_pci_dev {
    pub assigned_dev_id: __u32,
    pub busnr: __u32,
    pub devfn: __u32,
    pub flags: __u32,
    pub segnr: __u32,
    pub __bindgen_anon_1: kvm_assigned_pci_dev__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_assigned_pci_dev__bindgen_ty_1 {
    pub reserved: [__u32; 11usize],
    _bindgen_union_align: [u32; 11usize],
}
#[test]
fn bindgen_test_layout_kvm_assigned_pci_dev__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_pci_dev__bindgen_ty_1>(),
        44usize,
        concat!("Size of: ", stringify!(kvm_assigned_pci_dev__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_pci_dev__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(kvm_assigned_pci_dev__bindgen_ty_1)
        )
    );
}
impl Default for kvm_assigned_pci_dev__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_assigned_pci_dev() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_pci_dev>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_assigned_pci_dev))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_pci_dev>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_pci_dev))
    );
}
impl Default for kvm_assigned_pci_dev {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kvm_assigned_irq {
    pub assigned_dev_id: __u32,
    pub host_irq: __u32,
    pub guest_irq: __u32,
    pub flags: __u32,
    pub __bindgen_anon_1: kvm_assigned_irq__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union kvm_assigned_irq__bindgen_ty_1 {
    pub reserved: [__u32; 12usize],
    _bindgen_union_align: [u32; 12usize],
}
#[test]
fn bindgen_test_layout_kvm_assigned_irq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_irq__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(kvm_assigned_irq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_irq__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_irq__bindgen_ty_1))
    );
}
impl Default for kvm_assigned_irq__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_kvm_assigned_irq() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_irq>(),
        64usize,
        concat!("Size of: ", stringify!(kvm_assigned_irq))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_irq>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_irq))
    );
}
impl Default for kvm_assigned_irq {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_assigned_msix_nr {
    pub assigned_dev_id: __u32,
    pub entry_nr: __u16,
    pub padding: __u16,
}
#[test]
fn bindgen_test_layout_kvm_assigned_msix_nr() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_msix_nr>(),
        8usize,
        concat!("Size of: ", stringify!(kvm_assigned_msix_nr))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_msix_nr>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_msix_nr))
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct kvm_assigned_msix_entry {
    pub assigned_dev_id: __u32,
    pub gsi: __u32,
    pub entry: __u16,
    pub padding: [__u16; 3usize],
}
#[test]
fn bindgen_test_layout_kvm_assigned_msix_entry() {
    assert_eq!(
        ::std::mem::size_of::<kvm_assigned_msix_entry>(),
        16usize,
        concat!("Size of: ", stringify!(kvm_assigned_msix_entry))
    );
    assert_eq!(
        ::std::mem::align_of::<kvm_assigned_msix_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(kvm_assigned_msix_entry))
    );
}
