// Copyright 2017 The Chromium OS Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the THIRD-PARTY file.

/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ptr(&self) -> *const T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut_ptr(&mut self) -> *mut T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
impl<T> ::std::clone::Clone for __IncompleteArrayField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __IncompleteArrayField<T> {}
#[repr(C)]
pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
impl<T> __BindgenUnionField<T> {
    #[inline]
    pub fn new() -> Self {
        __BindgenUnionField(::std::marker::PhantomData)
    }
    #[inline]
    pub unsafe fn as_ref(&self) -> &T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut(&mut self) -> &mut T {
        ::std::mem::transmute(self)
    }
}
impl<T> ::std::default::Default for __BindgenUnionField<T> {
    #[inline]
    fn default() -> Self {
        Self::new()
    }
}
impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        fmt.write_str("__BindgenUnionField")
    }
}
pub const __UAPI_DEF_IN_ADDR: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IN_IPPROTO: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IN_PKTINFO: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IP_MREQ: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_SOCKADDR_IN: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IN_CLASS: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IN6_ADDR: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IN6_ADDR_ALT: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_SOCKADDR_IN6: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IPV6_MREQ: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IPPROTO_V6: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IPV6_OPTIONS: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IN6_PKTINFO: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_IP6_MTUINFO: ::std::os::raw::c_uint = 1;
pub const __UAPI_DEF_XATTR: ::std::os::raw::c_uint = 1;
pub const __BITS_PER_LONG: ::std::os::raw::c_uint = 64;
pub const __FD_SETSIZE: ::std::os::raw::c_uint = 1024;
pub const _K_SS_MAXSIZE: ::std::os::raw::c_uint = 128;
pub const _SYS_SOCKET_H: ::std::os::raw::c_uint = 1;
pub const _FEATURES_H: ::std::os::raw::c_uint = 1;
pub const _DEFAULT_SOURCE: ::std::os::raw::c_uint = 1;
pub const __USE_ISOC11: ::std::os::raw::c_uint = 1;
pub const __USE_ISOC99: ::std::os::raw::c_uint = 1;
pub const __USE_ISOC95: ::std::os::raw::c_uint = 1;
pub const __USE_POSIX_IMPLICITLY: ::std::os::raw::c_uint = 1;
pub const _POSIX_SOURCE: ::std::os::raw::c_uint = 1;
pub const _POSIX_C_SOURCE: ::std::os::raw::c_uint = 200809;
pub const __USE_POSIX: ::std::os::raw::c_uint = 1;
pub const __USE_POSIX2: ::std::os::raw::c_uint = 1;
pub const __USE_POSIX199309: ::std::os::raw::c_uint = 1;
pub const __USE_POSIX199506: ::std::os::raw::c_uint = 1;
pub const __USE_XOPEN2K: ::std::os::raw::c_uint = 1;
pub const __USE_XOPEN2K8: ::std::os::raw::c_uint = 1;
pub const _ATFILE_SOURCE: ::std::os::raw::c_uint = 1;
pub const __USE_MISC: ::std::os::raw::c_uint = 1;
pub const __USE_ATFILE: ::std::os::raw::c_uint = 1;
pub const __USE_FORTIFY_LEVEL: ::std::os::raw::c_uint = 0;
pub const _STDC_PREDEF_H: ::std::os::raw::c_uint = 1;
pub const __STDC_IEC_559__: ::std::os::raw::c_uint = 1;
pub const __STDC_IEC_559_COMPLEX__: ::std::os::raw::c_uint = 1;
pub const __STDC_ISO_10646__: ::std::os::raw::c_uint = 201505;
pub const __STDC_NO_THREADS__: ::std::os::raw::c_uint = 1;
pub const __GNU_LIBRARY__: ::std::os::raw::c_uint = 6;
pub const __GLIBC__: ::std::os::raw::c_uint = 2;
pub const __GLIBC_MINOR__: ::std::os::raw::c_uint = 23;
pub const _SYS_CDEFS_H: ::std::os::raw::c_uint = 1;
pub const __WORDSIZE: ::std::os::raw::c_uint = 64;
pub const __WORDSIZE_TIME64_COMPAT32: ::std::os::raw::c_uint = 1;
pub const __SYSCALL_WORDSIZE: ::std::os::raw::c_uint = 64;
pub const _SYS_UIO_H: ::std::os::raw::c_uint = 1;
pub const _SYS_TYPES_H: ::std::os::raw::c_uint = 1;
pub const _BITS_TYPES_H: ::std::os::raw::c_uint = 1;
pub const _BITS_TYPESIZES_H: ::std::os::raw::c_uint = 1;
pub const __OFF_T_MATCHES_OFF64_T: ::std::os::raw::c_uint = 1;
pub const __INO_T_MATCHES_INO64_T: ::std::os::raw::c_uint = 1;
pub const __clock_t_defined: ::std::os::raw::c_uint = 1;
pub const __time_t_defined: ::std::os::raw::c_uint = 1;
pub const __clockid_t_defined: ::std::os::raw::c_uint = 1;
pub const __timer_t_defined: ::std::os::raw::c_uint = 1;
pub const __BIT_TYPES_DEFINED__: ::std::os::raw::c_uint = 1;
pub const _ENDIAN_H: ::std::os::raw::c_uint = 1;
pub const __LITTLE_ENDIAN: ::std::os::raw::c_uint = 1234;
pub const __BIG_ENDIAN: ::std::os::raw::c_uint = 4321;
pub const __PDP_ENDIAN: ::std::os::raw::c_uint = 3412;
pub const __BYTE_ORDER: ::std::os::raw::c_uint = 1234;
pub const __FLOAT_WORD_ORDER: ::std::os::raw::c_uint = 1234;
pub const LITTLE_ENDIAN: ::std::os::raw::c_uint = 1234;
pub const BIG_ENDIAN: ::std::os::raw::c_uint = 4321;
pub const PDP_ENDIAN: ::std::os::raw::c_uint = 3412;
pub const BYTE_ORDER: ::std::os::raw::c_uint = 1234;
pub const _BITS_BYTESWAP_H: ::std::os::raw::c_uint = 1;
pub const _SYS_SELECT_H: ::std::os::raw::c_uint = 1;
pub const __FD_ZERO_STOS: &'static [u8; 6usize] = b"stosq\x00";
pub const _SIGSET_H_types: ::std::os::raw::c_uint = 1;
pub const __timespec_defined: ::std::os::raw::c_uint = 1;
pub const _STRUCT_TIMEVAL: ::std::os::raw::c_uint = 1;
pub const FD_SETSIZE: ::std::os::raw::c_uint = 1024;
pub const _SYS_SYSMACROS_H: ::std::os::raw::c_uint = 1;
pub const _BITS_PTHREADTYPES_H: ::std::os::raw::c_uint = 1;
pub const __SIZEOF_PTHREAD_ATTR_T: ::std::os::raw::c_uint = 56;
pub const __SIZEOF_PTHREAD_MUTEX_T: ::std::os::raw::c_uint = 40;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: ::std::os::raw::c_uint = 4;
pub const __SIZEOF_PTHREAD_COND_T: ::std::os::raw::c_uint = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: ::std::os::raw::c_uint = 4;
pub const __SIZEOF_PTHREAD_RWLOCK_T: ::std::os::raw::c_uint = 56;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: ::std::os::raw::c_uint = 8;
pub const __SIZEOF_PTHREAD_BARRIER_T: ::std::os::raw::c_uint = 32;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: ::std::os::raw::c_uint = 4;
pub const __have_pthread_attr_t: ::std::os::raw::c_uint = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: ::std::os::raw::c_uint = 1;
pub const __PTHREAD_RWLOCK_INT_FLAGS_SHARED: ::std::os::raw::c_uint = 1;
pub const _BITS_UIO_H: ::std::os::raw::c_uint = 1;
pub const UIO_MAXIOV: ::std::os::raw::c_uint = 1024;
pub const PF_UNSPEC: ::std::os::raw::c_uint = 0;
pub const PF_LOCAL: ::std::os::raw::c_uint = 1;
pub const PF_UNIX: ::std::os::raw::c_uint = 1;
pub const PF_FILE: ::std::os::raw::c_uint = 1;
pub const PF_INET: ::std::os::raw::c_uint = 2;
pub const PF_AX25: ::std::os::raw::c_uint = 3;
pub const PF_IPX: ::std::os::raw::c_uint = 4;
pub const PF_APPLETALK: ::std::os::raw::c_uint = 5;
pub const PF_NETROM: ::std::os::raw::c_uint = 6;
pub const PF_BRIDGE: ::std::os::raw::c_uint = 7;
pub const PF_ATMPVC: ::std::os::raw::c_uint = 8;
pub const PF_X25: ::std::os::raw::c_uint = 9;
pub const PF_INET6: ::std::os::raw::c_uint = 10;
pub const PF_ROSE: ::std::os::raw::c_uint = 11;
pub const PF_DECnet: ::std::os::raw::c_uint = 12;
pub const PF_NETBEUI: ::std::os::raw::c_uint = 13;
pub const PF_SECURITY: ::std::os::raw::c_uint = 14;
pub const PF_KEY: ::std::os::raw::c_uint = 15;
pub const PF_NETLINK: ::std::os::raw::c_uint = 16;
pub const PF_ROUTE: ::std::os::raw::c_uint = 16;
pub const PF_PACKET: ::std::os::raw::c_uint = 17;
pub const PF_ASH: ::std::os::raw::c_uint = 18;
pub const PF_ECONET: ::std::os::raw::c_uint = 19;
pub const PF_ATMSVC: ::std::os::raw::c_uint = 20;
pub const PF_RDS: ::std::os::raw::c_uint = 21;
pub const PF_SNA: ::std::os::raw::c_uint = 22;
pub const PF_IRDA: ::std::os::raw::c_uint = 23;
pub const PF_PPPOX: ::std::os::raw::c_uint = 24;
pub const PF_WANPIPE: ::std::os::raw::c_uint = 25;
pub const PF_LLC: ::std::os::raw::c_uint = 26;
pub const PF_IB: ::std::os::raw::c_uint = 27;
pub const PF_MPLS: ::std::os::raw::c_uint = 28;
pub const PF_CAN: ::std::os::raw::c_uint = 29;
pub const PF_TIPC: ::std::os::raw::c_uint = 30;
pub const PF_BLUETOOTH: ::std::os::raw::c_uint = 31;
pub const PF_IUCV: ::std::os::raw::c_uint = 32;
pub const PF_RXRPC: ::std::os::raw::c_uint = 33;
pub const PF_ISDN: ::std::os::raw::c_uint = 34;
pub const PF_PHONET: ::std::os::raw::c_uint = 35;
pub const PF_IEEE802154: ::std::os::raw::c_uint = 36;
pub const PF_CAIF: ::std::os::raw::c_uint = 37;
pub const PF_ALG: ::std::os::raw::c_uint = 38;
pub const PF_NFC: ::std::os::raw::c_uint = 39;
pub const PF_VSOCK: ::std::os::raw::c_uint = 40;
pub const PF_MAX: ::std::os::raw::c_uint = 41;
pub const AF_UNSPEC: ::std::os::raw::c_uint = 0;
pub const AF_LOCAL: ::std::os::raw::c_uint = 1;
pub const AF_UNIX: ::std::os::raw::c_uint = 1;
pub const AF_FILE: ::std::os::raw::c_uint = 1;
pub const AF_INET: ::std::os::raw::c_uint = 2;
pub const AF_AX25: ::std::os::raw::c_uint = 3;
pub const AF_IPX: ::std::os::raw::c_uint = 4;
pub const AF_APPLETALK: ::std::os::raw::c_uint = 5;
pub const AF_NETROM: ::std::os::raw::c_uint = 6;
pub const AF_BRIDGE: ::std::os::raw::c_uint = 7;
pub const AF_ATMPVC: ::std::os::raw::c_uint = 8;
pub const AF_X25: ::std::os::raw::c_uint = 9;
pub const AF_INET6: ::std::os::raw::c_uint = 10;
pub const AF_ROSE: ::std::os::raw::c_uint = 11;
pub const AF_DECnet: ::std::os::raw::c_uint = 12;
pub const AF_NETBEUI: ::std::os::raw::c_uint = 13;
pub const AF_SECURITY: ::std::os::raw::c_uint = 14;
pub const AF_KEY: ::std::os::raw::c_uint = 15;
pub const AF_NETLINK: ::std::os::raw::c_uint = 16;
pub const AF_ROUTE: ::std::os::raw::c_uint = 16;
pub const AF_PACKET: ::std::os::raw::c_uint = 17;
pub const AF_ASH: ::std::os::raw::c_uint = 18;
pub const AF_ECONET: ::std::os::raw::c_uint = 19;
pub const AF_ATMSVC: ::std::os::raw::c_uint = 20;
pub const AF_RDS: ::std::os::raw::c_uint = 21;
pub const AF_SNA: ::std::os::raw::c_uint = 22;
pub const AF_IRDA: ::std::os::raw::c_uint = 23;
pub const AF_PPPOX: ::std::os::raw::c_uint = 24;
pub const AF_WANPIPE: ::std::os::raw::c_uint = 25;
pub const AF_LLC: ::std::os::raw::c_uint = 26;
pub const AF_IB: ::std::os::raw::c_uint = 27;
pub const AF_MPLS: ::std::os::raw::c_uint = 28;
pub const AF_CAN: ::std::os::raw::c_uint = 29;
pub const AF_TIPC: ::std::os::raw::c_uint = 30;
pub const AF_BLUETOOTH: ::std::os::raw::c_uint = 31;
pub const AF_IUCV: ::std::os::raw::c_uint = 32;
pub const AF_RXRPC: ::std::os::raw::c_uint = 33;
pub const AF_ISDN: ::std::os::raw::c_uint = 34;
pub const AF_PHONET: ::std::os::raw::c_uint = 35;
pub const AF_IEEE802154: ::std::os::raw::c_uint = 36;
pub const AF_CAIF: ::std::os::raw::c_uint = 37;
pub const AF_ALG: ::std::os::raw::c_uint = 38;
pub const AF_NFC: ::std::os::raw::c_uint = 39;
pub const AF_VSOCK: ::std::os::raw::c_uint = 40;
pub const AF_MAX: ::std::os::raw::c_uint = 41;
pub const SOL_RAW: ::std::os::raw::c_uint = 255;
pub const SOL_DECNET: ::std::os::raw::c_uint = 261;
pub const SOL_X25: ::std::os::raw::c_uint = 262;
pub const SOL_PACKET: ::std::os::raw::c_uint = 263;
pub const SOL_ATM: ::std::os::raw::c_uint = 264;
pub const SOL_AAL: ::std::os::raw::c_uint = 265;
pub const SOL_IRDA: ::std::os::raw::c_uint = 266;
pub const SOMAXCONN: ::std::os::raw::c_uint = 128;
pub const _BITS_SOCKADDR_H: ::std::os::raw::c_uint = 1;
pub const _SS_SIZE: ::std::os::raw::c_uint = 128;
pub const FIOSETOWN: ::std::os::raw::c_uint = 35073;
pub const SIOCSPGRP: ::std::os::raw::c_uint = 35074;
pub const FIOGETOWN: ::std::os::raw::c_uint = 35075;
pub const SIOCGPGRP: ::std::os::raw::c_uint = 35076;
pub const SIOCATMARK: ::std::os::raw::c_uint = 35077;
pub const SIOCGSTAMP: ::std::os::raw::c_uint = 35078;
pub const SIOCGSTAMPNS: ::std::os::raw::c_uint = 35079;
pub const SOL_SOCKET: ::std::os::raw::c_uint = 1;
pub const SO_DEBUG: ::std::os::raw::c_uint = 1;
pub const SO_REUSEADDR: ::std::os::raw::c_uint = 2;
pub const SO_TYPE: ::std::os::raw::c_uint = 3;
pub const SO_ERROR: ::std::os::raw::c_uint = 4;
pub const SO_DONTROUTE: ::std::os::raw::c_uint = 5;
pub const SO_BROADCAST: ::std::os::raw::c_uint = 6;
pub const SO_SNDBUF: ::std::os::raw::c_uint = 7;
pub const SO_RCVBUF: ::std::os::raw::c_uint = 8;
pub const SO_SNDBUFFORCE: ::std::os::raw::c_uint = 32;
pub const SO_RCVBUFFORCE: ::std::os::raw::c_uint = 33;
pub const SO_KEEPALIVE: ::std::os::raw::c_uint = 9;
pub const SO_OOBINLINE: ::std::os::raw::c_uint = 10;
pub const SO_NO_CHECK: ::std::os::raw::c_uint = 11;
pub const SO_PRIORITY: ::std::os::raw::c_uint = 12;
pub const SO_LINGER: ::std::os::raw::c_uint = 13;
pub const SO_BSDCOMPAT: ::std::os::raw::c_uint = 14;
pub const SO_REUSEPORT: ::std::os::raw::c_uint = 15;
pub const SO_PASSCRED: ::std::os::raw::c_uint = 16;
pub const SO_PEERCRED: ::std::os::raw::c_uint = 17;
pub const SO_RCVLOWAT: ::std::os::raw::c_uint = 18;
pub const SO_SNDLOWAT: ::std::os::raw::c_uint = 19;
pub const SO_RCVTIMEO: ::std::os::raw::c_uint = 20;
pub const SO_SNDTIMEO: ::std::os::raw::c_uint = 21;
pub const SO_SECURITY_AUTHENTICATION: ::std::os::raw::c_uint = 22;
pub const SO_SECURITY_ENCRYPTION_TRANSPORT: ::std::os::raw::c_uint = 23;
pub const SO_SECURITY_ENCRYPTION_NETWORK: ::std::os::raw::c_uint = 24;
pub const SO_BINDTODEVICE: ::std::os::raw::c_uint = 25;
pub const SO_ATTACH_FILTER: ::std::os::raw::c_uint = 26;
pub const SO_DETACH_FILTER: ::std::os::raw::c_uint = 27;
pub const SO_GET_FILTER: ::std::os::raw::c_uint = 26;
pub const SO_PEERNAME: ::std::os::raw::c_uint = 28;
pub const SO_TIMESTAMP: ::std::os::raw::c_uint = 29;
pub const SCM_TIMESTAMP: ::std::os::raw::c_uint = 29;
pub const SO_ACCEPTCONN: ::std::os::raw::c_uint = 30;
pub const SO_PEERSEC: ::std::os::raw::c_uint = 31;
pub const SO_PASSSEC: ::std::os::raw::c_uint = 34;
pub const SO_TIMESTAMPNS: ::std::os::raw::c_uint = 35;
pub const SCM_TIMESTAMPNS: ::std::os::raw::c_uint = 35;
pub const SO_MARK: ::std::os::raw::c_uint = 36;
pub const SO_TIMESTAMPING: ::std::os::raw::c_uint = 37;
pub const SCM_TIMESTAMPING: ::std::os::raw::c_uint = 37;
pub const SO_PROTOCOL: ::std::os::raw::c_uint = 38;
pub const SO_DOMAIN: ::std::os::raw::c_uint = 39;
pub const SO_RXQ_OVFL: ::std::os::raw::c_uint = 40;
pub const SO_WIFI_STATUS: ::std::os::raw::c_uint = 41;
pub const SCM_WIFI_STATUS: ::std::os::raw::c_uint = 41;
pub const SO_PEEK_OFF: ::std::os::raw::c_uint = 42;
pub const SO_NOFCS: ::std::os::raw::c_uint = 43;
pub const SO_LOCK_FILTER: ::std::os::raw::c_uint = 44;
pub const SO_SELECT_ERR_QUEUE: ::std::os::raw::c_uint = 45;
pub const SO_BUSY_POLL: ::std::os::raw::c_uint = 46;
pub const SO_MAX_PACING_RATE: ::std::os::raw::c_uint = 47;
pub const SO_BPF_EXTENSIONS: ::std::os::raw::c_uint = 48;
pub const SO_INCOMING_CPU: ::std::os::raw::c_uint = 49;
pub const SO_ATTACH_BPF: ::std::os::raw::c_uint = 50;
pub const SO_DETACH_BPF: ::std::os::raw::c_uint = 27;
pub const IFNAMSIZ: ::std::os::raw::c_uint = 16;
pub const IFALIASZ: ::std::os::raw::c_uint = 256;
pub const GENERIC_HDLC_VERSION: ::std::os::raw::c_uint = 4;
pub const CLOCK_DEFAULT: ::std::os::raw::c_uint = 0;
pub const CLOCK_EXT: ::std::os::raw::c_uint = 1;
pub const CLOCK_INT: ::std::os::raw::c_uint = 2;
pub const CLOCK_TXINT: ::std::os::raw::c_uint = 3;
pub const CLOCK_TXFROMRX: ::std::os::raw::c_uint = 4;
pub const ENCODING_DEFAULT: ::std::os::raw::c_uint = 0;
pub const ENCODING_NRZ: ::std::os::raw::c_uint = 1;
pub const ENCODING_NRZI: ::std::os::raw::c_uint = 2;
pub const ENCODING_FM_MARK: ::std::os::raw::c_uint = 3;
pub const ENCODING_FM_SPACE: ::std::os::raw::c_uint = 4;
pub const ENCODING_MANCHESTER: ::std::os::raw::c_uint = 5;
pub const PARITY_DEFAULT: ::std::os::raw::c_uint = 0;
pub const PARITY_NONE: ::std::os::raw::c_uint = 1;
pub const PARITY_CRC16_PR0: ::std::os::raw::c_uint = 2;
pub const PARITY_CRC16_PR1: ::std::os::raw::c_uint = 3;
pub const PARITY_CRC16_PR0_CCITT: ::std::os::raw::c_uint = 4;
pub const PARITY_CRC16_PR1_CCITT: ::std::os::raw::c_uint = 5;
pub const PARITY_CRC32_PR0_CCITT: ::std::os::raw::c_uint = 6;
pub const PARITY_CRC32_PR1_CCITT: ::std::os::raw::c_uint = 7;
pub const LMI_DEFAULT: ::std::os::raw::c_uint = 0;
pub const LMI_NONE: ::std::os::raw::c_uint = 1;
pub const LMI_ANSI: ::std::os::raw::c_uint = 2;
pub const LMI_CCITT: ::std::os::raw::c_uint = 3;
pub const LMI_CISCO: ::std::os::raw::c_uint = 4;
pub const IF_GET_IFACE: ::std::os::raw::c_uint = 1;
pub const IF_GET_PROTO: ::std::os::raw::c_uint = 2;
pub const IF_IFACE_V35: ::std::os::raw::c_uint = 4096;
pub const IF_IFACE_V24: ::std::os::raw::c_uint = 4097;
pub const IF_IFACE_X21: ::std::os::raw::c_uint = 4098;
pub const IF_IFACE_T1: ::std::os::raw::c_uint = 4099;
pub const IF_IFACE_E1: ::std::os::raw::c_uint = 4100;
pub const IF_IFACE_SYNC_SERIAL: ::std::os::raw::c_uint = 4101;
pub const IF_IFACE_X21D: ::std::os::raw::c_uint = 4102;
pub const IF_PROTO_HDLC: ::std::os::raw::c_uint = 8192;
pub const IF_PROTO_PPP: ::std::os::raw::c_uint = 8193;
pub const IF_PROTO_CISCO: ::std::os::raw::c_uint = 8194;
pub const IF_PROTO_FR: ::std::os::raw::c_uint = 8195;
pub const IF_PROTO_FR_ADD_PVC: ::std::os::raw::c_uint = 8196;
pub const IF_PROTO_FR_DEL_PVC: ::std::os::raw::c_uint = 8197;
pub const IF_PROTO_X25: ::std::os::raw::c_uint = 8198;
pub const IF_PROTO_HDLC_ETH: ::std::os::raw::c_uint = 8199;
pub const IF_PROTO_FR_ADD_ETH_PVC: ::std::os::raw::c_uint = 8200;
pub const IF_PROTO_FR_DEL_ETH_PVC: ::std::os::raw::c_uint = 8201;
pub const IF_PROTO_FR_PVC: ::std::os::raw::c_uint = 8202;
pub const IF_PROTO_FR_ETH_PVC: ::std::os::raw::c_uint = 8203;
pub const IF_PROTO_RAW: ::std::os::raw::c_uint = 8204;
pub const IFHWADDRLEN: ::std::os::raw::c_uint = 6;
pub type __s8 = ::std::os::raw::c_schar;
pub type __u8 = ::std::os::raw::c_uchar;
pub type __s16 = ::std::os::raw::c_short;
pub type __u16 = ::std::os::raw::c_ushort;
pub type __s32 = ::std::os::raw::c_int;
pub type __u32 = ::std::os::raw::c_uint;
pub type __s64 = ::std::os::raw::c_longlong;
pub type __u64 = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct __kernel_fd_set {
    pub fds_bits: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___kernel_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_fd_set))
    );
    assert_eq!(
        unsafe { &(*(0 as *const __kernel_fd_set)).fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(__kernel_fd_set),
            "::",
            stringify!(fds_bits)
        )
    );
}
impl Clone for __kernel_fd_set {
    fn clone(&self) -> Self {
        *self
    }
}
pub type __kernel_sighandler_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
pub type __kernel_key_t = ::std::os::raw::c_int;
pub type __kernel_mqd_t = ::std::os::raw::c_int;
pub type __kernel_old_uid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_gid_t = ::std::os::raw::c_ushort;
pub type __kernel_old_dev_t = ::std::os::raw::c_ulong;
pub type __kernel_long_t = ::std::os::raw::c_long;
pub type __kernel_ulong_t = ::std::os::raw::c_ulong;
pub type __kernel_ino_t = __kernel_ulong_t;
pub type __kernel_mode_t = ::std::os::raw::c_uint;
pub type __kernel_pid_t = ::std::os::raw::c_int;
pub type __kernel_ipc_pid_t = ::std::os::raw::c_int;
pub type __kernel_uid_t = ::std::os::raw::c_uint;
pub type __kernel_gid_t = ::std::os::raw::c_uint;
pub type __kernel_suseconds_t = __kernel_long_t;
pub type __kernel_daddr_t = ::std::os::raw::c_int;
pub type __kernel_uid32_t = ::std::os::raw::c_uint;
pub type __kernel_gid32_t = ::std::os::raw::c_uint;
pub type __kernel_size_t = __kernel_ulong_t;
pub type __kernel_ssize_t = __kernel_long_t;
pub type __kernel_ptrdiff_t = __kernel_long_t;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct __kernel_fsid_t {
    pub val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___kernel_fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__kernel_fsid_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const __kernel_fsid_t)).val as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(__kernel_fsid_t),
            "::",
            stringify!(val)
        )
    );
}
impl Clone for __kernel_fsid_t {
    fn clone(&self) -> Self {
        *self
    }
}
pub type __kernel_off_t = __kernel_long_t;
pub type __kernel_loff_t = ::std::os::raw::c_longlong;
pub type __kernel_time_t = __kernel_long_t;
pub type __kernel_clock_t = __kernel_long_t;
pub type __kernel_timer_t = ::std::os::raw::c_int;
pub type __kernel_clockid_t = ::std::os::raw::c_int;
pub type __kernel_caddr_t = *mut ::std::os::raw::c_char;
pub type __kernel_uid16_t = ::std::os::raw::c_ushort;
pub type __kernel_gid16_t = ::std::os::raw::c_ushort;
pub type __le16 = __u16;
pub type __be16 = __u16;
pub type __le32 = __u32;
pub type __be32 = __u32;
pub type __le64 = __u64;
pub type __be64 = __u64;
pub type __sum16 = __u16;
pub type __wsum = __u32;
pub type __kernel_sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
pub struct __kernel_sockaddr_storage {
    pub ss_family: __kernel_sa_family_t,
    pub __data: [::std::os::raw::c_char; 126usize],
    pub __bindgen_align: [u64; 0usize],
}
#[test]
fn bindgen_test_layout___kernel_sockaddr_storage() {
    assert_eq!(
        ::std::mem::size_of::<__kernel_sockaddr_storage>(),
        128usize,
        concat!("Size of: ", stringify!(__kernel_sockaddr_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<__kernel_sockaddr_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(__kernel_sockaddr_storage))
    );
    assert_eq!(
        unsafe { &(*(0 as *const __kernel_sockaddr_storage)).ss_family as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(__kernel_sockaddr_storage),
            "::",
            stringify!(ss_family)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const __kernel_sockaddr_storage)).__data as *const _ as usize },
        2usize,
        concat!(
            "Alignment of field: ",
            stringify!(__kernel_sockaddr_storage),
            "::",
            stringify!(__data)
        )
    );
}
impl Default for __kernel_sockaddr_storage {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const __fsid_t)).__val as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
impl Clone for __fsid_t {
    fn clone(&self) -> Self {
        *self
    }
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __qaddr_t = *mut __quad_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type time_t = __time_t;
pub type clockid_t = __clockid_t;
pub type timer_t = __timer_t;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulong;
pub type register_t = ::std::os::raw::c_long;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const __sigset_t)).__val as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
impl Clone for __sigset_t {
    fn clone(&self) -> Self {
        *self
    }
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(0 as *const timespec)).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const timespec)).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
impl Clone for timespec {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(0 as *const timeval)).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const timeval)).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
impl Clone for timeval {
    fn clone(&self) -> Self {
        *self
    }
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(0 as *const fd_set)).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
impl Clone for fd_set {
    fn clone(&self) -> Self {
        *self
    }
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gnu_dev_major(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_minor(__dev: ::std::os::raw::c_ulonglong) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gnu_dev_makedev(
        __major: ::std::os::raw::c_uint,
        __minor: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_ulonglong;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_attr_t {
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 56usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_long>,
    pub bindgen_union_field: [u64; 7usize],
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_attr_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_attr_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_attr_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(0 as *const __pthread_internal_list)).__prev as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const __pthread_internal_list)).__next as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
impl Clone for __pthread_internal_list {
    fn clone(&self) -> Self {
        *self
    }
}
impl Default for __pthread_internal_list {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_mutex_t {
    pub __data: __BindgenUnionField<pthread_mutex_t___pthread_mutex_s>,
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 40usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_long>,
    pub bindgen_union_field: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct pthread_mutex_t___pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t___pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t___pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t___pthread_mutex_s>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(pthread_mutex_t___pthread_mutex_s)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__lock as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__count as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__owner as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__nusers as *const _ as usize
        },
        12usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__kind as *const _ as usize },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__spins as *const _ as usize },
        20usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__elision as *const _ as usize
        },
        22usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t___pthread_mutex_s)).__list as *const _ as usize },
        24usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t___pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
impl Clone for pthread_mutex_t___pthread_mutex_s {
    fn clone(&self) -> Self {
        *self
    }
}
impl Default for pthread_mutex_t___pthread_mutex_s {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t)).__data as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutex_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_mutex_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_mutexattr_t {
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 4usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_int>,
    pub bindgen_union_field: u32,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutexattr_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_mutexattr_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_mutexattr_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_cond_t {
    pub __data: __BindgenUnionField<pthread_cond_t__bindgen_ty_1>,
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 48usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_longlong>,
    pub bindgen_union_field: [u64; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct pthread_cond_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __futex: ::std::os::raw::c_uint,
    pub __total_seq: ::std::os::raw::c_ulonglong,
    pub __wakeup_seq: ::std::os::raw::c_ulonglong,
    pub __woken_seq: ::std::os::raw::c_ulonglong,
    pub __mutex: *mut ::std::os::raw::c_void,
    pub __nwaiters: ::std::os::raw::c_uint,
    pub __broadcast_seq: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_cond_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__lock as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__futex as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__futex)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__total_seq as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__total_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__wakeup_seq as *const _ as usize },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__wakeup_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__woken_seq as *const _ as usize },
        24usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__woken_seq)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__mutex as *const _ as usize },
        32usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__mutex)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__nwaiters as *const _ as usize },
        40usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__nwaiters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_cond_t__bindgen_ty_1)).__broadcast_seq as *const _ as usize
        },
        44usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t__bindgen_ty_1),
            "::",
            stringify!(__broadcast_seq)
        )
    );
}
impl Clone for pthread_cond_t__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl Default for pthread_cond_t__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t)).__data as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_cond_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_cond_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_condattr_t {
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 4usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_int>,
    pub bindgen_union_field: u32,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_condattr_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_condattr_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_condattr_t {
    fn clone(&self) -> Self {
        *self
    }
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_rwlock_t {
    pub __data: __BindgenUnionField<pthread_rwlock_t__bindgen_ty_1>,
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 56usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_long>,
    pub bindgen_union_field: [u64; 7usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_rwlock_t__bindgen_ty_1 {
    pub __lock: ::std::os::raw::c_int,
    pub __nr_readers: ::std::os::raw::c_uint,
    pub __readers_wakeup: ::std::os::raw::c_uint,
    pub __writer_wakeup: ::std::os::raw::c_uint,
    pub __nr_readers_queued: ::std::os::raw::c_uint,
    pub __nr_writers_queued: ::std::os::raw::c_uint,
    pub __writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t__bindgen_ty_1>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__lock as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__nr_readers as *const _ as usize
        },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__readers_wakeup as *const _ as usize
        },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__readers_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__writer_wakeup as *const _ as usize
        },
        12usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer_wakeup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__nr_readers_queued as *const _
                as usize
        },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_readers_queued)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__nr_writers_queued as *const _
                as usize
        },
        20usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__nr_writers_queued)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__writer as *const _ as usize },
        24usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__writer)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__shared as *const _ as usize },
        28usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__rwelision as *const _ as usize
        },
        32usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__pad1 as *const _ as usize },
        33usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__pad2 as *const _ as usize },
        40usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t__bindgen_ty_1)).__flags as *const _ as usize },
        48usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t__bindgen_ty_1),
            "::",
            stringify!(__flags)
        )
    );
}
impl Clone for pthread_rwlock_t__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t)).__data as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlock_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_rwlock_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_rwlockattr_t {
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 8usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_long>,
    pub bindgen_union_field: u64,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlockattr_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_rwlockattr_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_rwlockattr_t {
    fn clone(&self) -> Self {
        *self
    }
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_barrier_t {
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 32usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_long>,
    pub bindgen_union_field: [u64; 4usize],
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_barrier_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_barrier_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_barrier_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct pthread_barrierattr_t {
    pub __size: __BindgenUnionField<[::std::os::raw::c_char; 4usize]>,
    pub __align: __BindgenUnionField<::std::os::raw::c_int>,
    pub bindgen_union_field: u32,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_barrierattr_t)).__size as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const pthread_barrierattr_t)).__align as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
impl Clone for pthread_barrierattr_t {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct iovec {
    pub iov_base: *mut ::std::os::raw::c_void,
    pub iov_len: usize,
}
#[test]
fn bindgen_test_layout_iovec() {
    assert_eq!(
        ::std::mem::size_of::<iovec>(),
        16usize,
        concat!("Size of: ", stringify!(iovec))
    );
    assert_eq!(
        ::std::mem::align_of::<iovec>(),
        8usize,
        concat!("Alignment of ", stringify!(iovec))
    );
    assert_eq!(
        unsafe { &(*(0 as *const iovec)).iov_base as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(iovec),
            "::",
            stringify!(iov_base)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const iovec)).iov_len as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(iovec),
            "::",
            stringify!(iov_len)
        )
    );
}
impl Clone for iovec {
    fn clone(&self) -> Self {
        *self
    }
}
impl Default for iovec {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
extern "C" {
    pub fn readv(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn writev(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn preadv(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
        __offset: __off_t,
    ) -> isize;
}
extern "C" {
    pub fn pwritev(
        __fd: ::std::os::raw::c_int,
        __iovec: *const iovec,
        __count: ::std::os::raw::c_int,
        __offset: __off_t,
    ) -> isize;
}
pub type socklen_t = __socklen_t;
pub const __socket_type_SOCK_STREAM: __socket_type = 1;
pub const __socket_type_SOCK_DGRAM: __socket_type = 2;
pub const __socket_type_SOCK_RAW: __socket_type = 3;
pub const __socket_type_SOCK_RDM: __socket_type = 4;
pub const __socket_type_SOCK_SEQPACKET: __socket_type = 5;
pub const __socket_type_SOCK_DCCP: __socket_type = 6;
pub const __socket_type_SOCK_PACKET: __socket_type = 10;
pub const __socket_type_SOCK_CLOEXEC: __socket_type = 524288;
pub const __socket_type_SOCK_NONBLOCK: __socket_type = 2048;
pub type __socket_type = ::std::os::raw::c_uint;
pub type sa_family_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct sockaddr {
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[test]
fn bindgen_test_layout_sockaddr() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr>(),
        16usize,
        concat!("Size of: ", stringify!(sockaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr>(),
        2usize,
        concat!("Alignment of ", stringify!(sockaddr))
    );
    assert_eq!(
        unsafe { &(*(0 as *const sockaddr)).sa_family as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_family)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const sockaddr)).sa_data as *const _ as usize },
        2usize,
        concat!(
            "Alignment of field: ",
            stringify!(sockaddr),
            "::",
            stringify!(sa_data)
        )
    );
}
impl Clone for sockaddr {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
pub struct sockaddr_storage {
    pub ss_family: sa_family_t,
    pub __ss_padding: [::std::os::raw::c_char; 118usize],
    pub __ss_align: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_sockaddr_storage() {
    assert_eq!(
        ::std::mem::size_of::<sockaddr_storage>(),
        128usize,
        concat!("Size of: ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<sockaddr_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(sockaddr_storage))
    );
    assert_eq!(
        unsafe { &(*(0 as *const sockaddr_storage)).ss_family as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(ss_family)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const sockaddr_storage)).__ss_padding as *const _ as usize },
        2usize,
        concat!(
            "Alignment of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_padding)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const sockaddr_storage)).__ss_align as *const _ as usize },
        120usize,
        concat!(
            "Alignment of field: ",
            stringify!(sockaddr_storage),
            "::",
            stringify!(__ss_align)
        )
    );
}
impl Default for sockaddr_storage {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub const MSG_OOB: _bindgen_ty_1 = 1;
pub const MSG_PEEK: _bindgen_ty_1 = 2;
pub const MSG_DONTROUTE: _bindgen_ty_1 = 4;
pub const MSG_CTRUNC: _bindgen_ty_1 = 8;
pub const MSG_PROXY: _bindgen_ty_1 = 16;
pub const MSG_TRUNC: _bindgen_ty_1 = 32;
pub const MSG_DONTWAIT: _bindgen_ty_1 = 64;
pub const MSG_EOR: _bindgen_ty_1 = 128;
pub const MSG_WAITALL: _bindgen_ty_1 = 256;
pub const MSG_FIN: _bindgen_ty_1 = 512;
pub const MSG_SYN: _bindgen_ty_1 = 1024;
pub const MSG_CONFIRM: _bindgen_ty_1 = 2048;
pub const MSG_RST: _bindgen_ty_1 = 4096;
pub const MSG_ERRQUEUE: _bindgen_ty_1 = 8192;
pub const MSG_NOSIGNAL: _bindgen_ty_1 = 16384;
pub const MSG_MORE: _bindgen_ty_1 = 32768;
pub const MSG_WAITFORONE: _bindgen_ty_1 = 65536;
pub const MSG_FASTOPEN: _bindgen_ty_1 = 536870912;
pub const MSG_CMSG_CLOEXEC: _bindgen_ty_1 = 1073741824;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy)]
pub struct msghdr {
    pub msg_name: *mut ::std::os::raw::c_void,
    pub msg_namelen: socklen_t,
    pub msg_iov: *mut iovec,
    pub msg_iovlen: usize,
    pub msg_control: *mut ::std::os::raw::c_void,
    pub msg_controllen: usize,
    pub msg_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_msghdr() {
    assert_eq!(
        ::std::mem::size_of::<msghdr>(),
        56usize,
        concat!("Size of: ", stringify!(msghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<msghdr>(),
        8usize,
        concat!("Alignment of ", stringify!(msghdr))
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_name as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_name)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_namelen as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_namelen)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_iov as *const _ as usize },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_iov)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_iovlen as *const _ as usize },
        24usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_iovlen)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_control as *const _ as usize },
        32usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_control)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_controllen as *const _ as usize },
        40usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_controllen)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const msghdr)).msg_flags as *const _ as usize },
        48usize,
        concat!(
            "Alignment of field: ",
            stringify!(msghdr),
            "::",
            stringify!(msg_flags)
        )
    );
}
impl Clone for msghdr {
    fn clone(&self) -> Self {
        *self
    }
}
impl Default for msghdr {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct cmsghdr {
    pub cmsg_len: usize,
    pub cmsg_level: ::std::os::raw::c_int,
    pub cmsg_type: ::std::os::raw::c_int,
    pub __cmsg_data: __IncompleteArrayField<::std::os::raw::c_uchar>,
}
#[test]
fn bindgen_test_layout_cmsghdr() {
    assert_eq!(
        ::std::mem::size_of::<cmsghdr>(),
        16usize,
        concat!("Size of: ", stringify!(cmsghdr))
    );
    assert_eq!(
        ::std::mem::align_of::<cmsghdr>(),
        8usize,
        concat!("Alignment of ", stringify!(cmsghdr))
    );
}
impl Clone for cmsghdr {
    fn clone(&self) -> Self {
        *self
    }
}
extern "C" {
    pub fn __cmsg_nxthdr(__mhdr: *mut msghdr, __cmsg: *mut cmsghdr) -> *mut cmsghdr;
}
pub const SCM_RIGHTS: _bindgen_ty_2 = 1;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct linger {
    pub l_onoff: ::std::os::raw::c_int,
    pub l_linger: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_linger() {
    assert_eq!(
        ::std::mem::size_of::<linger>(),
        8usize,
        concat!("Size of: ", stringify!(linger))
    );
    assert_eq!(
        ::std::mem::align_of::<linger>(),
        4usize,
        concat!("Alignment of ", stringify!(linger))
    );
    assert_eq!(
        unsafe { &(*(0 as *const linger)).l_onoff as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(linger),
            "::",
            stringify!(l_onoff)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const linger)).l_linger as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(linger),
            "::",
            stringify!(l_linger)
        )
    );
}
impl Clone for linger {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct osockaddr {
    pub sa_family: ::std::os::raw::c_ushort,
    pub sa_data: [::std::os::raw::c_uchar; 14usize],
}
#[test]
fn bindgen_test_layout_osockaddr() {
    assert_eq!(
        ::std::mem::size_of::<osockaddr>(),
        16usize,
        concat!("Size of: ", stringify!(osockaddr))
    );
    assert_eq!(
        ::std::mem::align_of::<osockaddr>(),
        2usize,
        concat!("Alignment of ", stringify!(osockaddr))
    );
    assert_eq!(
        unsafe { &(*(0 as *const osockaddr)).sa_family as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(osockaddr),
            "::",
            stringify!(sa_family)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const osockaddr)).sa_data as *const _ as usize },
        2usize,
        concat!(
            "Alignment of field: ",
            stringify!(osockaddr),
            "::",
            stringify!(sa_data)
        )
    );
}
impl Clone for osockaddr {
    fn clone(&self) -> Self {
        *self
    }
}
pub const SHUT_RD: _bindgen_ty_3 = 0;
pub const SHUT_WR: _bindgen_ty_3 = 1;
pub const SHUT_RDWR: _bindgen_ty_3 = 2;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
extern "C" {
    pub fn socket(
        __domain: ::std::os::raw::c_int,
        __type: ::std::os::raw::c_int,
        __protocol: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn socketpair(
        __domain: ::std::os::raw::c_int,
        __type: ::std::os::raw::c_int,
        __protocol: ::std::os::raw::c_int,
        __fds: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bind(
        __fd: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __len: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getsockname(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn connect(
        __fd: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __len: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getpeername(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn send(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: usize,
        __flags: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn recv(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __n: usize,
        __flags: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn sendto(
        __fd: ::std::os::raw::c_int,
        __buf: *const ::std::os::raw::c_void,
        __n: usize,
        __flags: ::std::os::raw::c_int,
        __addr: *const sockaddr,
        __addr_len: socklen_t,
    ) -> isize;
}
extern "C" {
    pub fn recvfrom(
        __fd: ::std::os::raw::c_int,
        __buf: *mut ::std::os::raw::c_void,
        __n: usize,
        __flags: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __addr_len: *mut socklen_t,
    ) -> isize;
}
extern "C" {
    pub fn sendmsg(
        __fd: ::std::os::raw::c_int,
        __message: *const msghdr,
        __flags: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn recvmsg(
        __fd: ::std::os::raw::c_int,
        __message: *mut msghdr,
        __flags: ::std::os::raw::c_int,
    ) -> isize;
}
extern "C" {
    pub fn getsockopt(
        __fd: ::std::os::raw::c_int,
        __level: ::std::os::raw::c_int,
        __optname: ::std::os::raw::c_int,
        __optval: *mut ::std::os::raw::c_void,
        __optlen: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setsockopt(
        __fd: ::std::os::raw::c_int,
        __level: ::std::os::raw::c_int,
        __optname: ::std::os::raw::c_int,
        __optval: *const ::std::os::raw::c_void,
        __optlen: socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn listen(__fd: ::std::os::raw::c_int, __n: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn accept(
        __fd: ::std::os::raw::c_int,
        __addr: *mut sockaddr,
        __addr_len: *mut socklen_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn shutdown(
        __fd: ::std::os::raw::c_int,
        __how: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sockatmark(__fd: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn isfdtype(
        __fd: ::std::os::raw::c_int,
        __fdtype: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct sync_serial_settings {
    pub clock_rate: ::std::os::raw::c_uint,
    pub clock_type: ::std::os::raw::c_uint,
    pub loopback: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_sync_serial_settings() {
    assert_eq!(
        ::std::mem::size_of::<sync_serial_settings>(),
        12usize,
        concat!("Size of: ", stringify!(sync_serial_settings))
    );
    assert_eq!(
        ::std::mem::align_of::<sync_serial_settings>(),
        4usize,
        concat!("Alignment of ", stringify!(sync_serial_settings))
    );
    assert_eq!(
        unsafe { &(*(0 as *const sync_serial_settings)).clock_rate as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(sync_serial_settings),
            "::",
            stringify!(clock_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const sync_serial_settings)).clock_type as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(sync_serial_settings),
            "::",
            stringify!(clock_type)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const sync_serial_settings)).loopback as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(sync_serial_settings),
            "::",
            stringify!(loopback)
        )
    );
}
impl Clone for sync_serial_settings {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct te1_settings {
    pub clock_rate: ::std::os::raw::c_uint,
    pub clock_type: ::std::os::raw::c_uint,
    pub loopback: ::std::os::raw::c_ushort,
    pub slot_map: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_te1_settings() {
    assert_eq!(
        ::std::mem::size_of::<te1_settings>(),
        16usize,
        concat!("Size of: ", stringify!(te1_settings))
    );
    assert_eq!(
        ::std::mem::align_of::<te1_settings>(),
        4usize,
        concat!("Alignment of ", stringify!(te1_settings))
    );
    assert_eq!(
        unsafe { &(*(0 as *const te1_settings)).clock_rate as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(te1_settings),
            "::",
            stringify!(clock_rate)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const te1_settings)).clock_type as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(te1_settings),
            "::",
            stringify!(clock_type)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const te1_settings)).loopback as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(te1_settings),
            "::",
            stringify!(loopback)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const te1_settings)).slot_map as *const _ as usize },
        12usize,
        concat!(
            "Alignment of field: ",
            stringify!(te1_settings),
            "::",
            stringify!(slot_map)
        )
    );
}
impl Clone for te1_settings {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct raw_hdlc_proto {
    pub encoding: ::std::os::raw::c_ushort,
    pub parity: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_raw_hdlc_proto() {
    assert_eq!(
        ::std::mem::size_of::<raw_hdlc_proto>(),
        4usize,
        concat!("Size of: ", stringify!(raw_hdlc_proto))
    );
    assert_eq!(
        ::std::mem::align_of::<raw_hdlc_proto>(),
        2usize,
        concat!("Alignment of ", stringify!(raw_hdlc_proto))
    );
    assert_eq!(
        unsafe { &(*(0 as *const raw_hdlc_proto)).encoding as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(raw_hdlc_proto),
            "::",
            stringify!(encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const raw_hdlc_proto)).parity as *const _ as usize },
        2usize,
        concat!(
            "Alignment of field: ",
            stringify!(raw_hdlc_proto),
            "::",
            stringify!(parity)
        )
    );
}
impl Clone for raw_hdlc_proto {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct fr_proto {
    pub t391: ::std::os::raw::c_uint,
    pub t392: ::std::os::raw::c_uint,
    pub n391: ::std::os::raw::c_uint,
    pub n392: ::std::os::raw::c_uint,
    pub n393: ::std::os::raw::c_uint,
    pub lmi: ::std::os::raw::c_ushort,
    pub dce: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_fr_proto() {
    assert_eq!(
        ::std::mem::size_of::<fr_proto>(),
        24usize,
        concat!("Size of: ", stringify!(fr_proto))
    );
    assert_eq!(
        ::std::mem::align_of::<fr_proto>(),
        4usize,
        concat!("Alignment of ", stringify!(fr_proto))
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).t391 as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(t391)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).t392 as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(t392)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).n391 as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(n391)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).n392 as *const _ as usize },
        12usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(n392)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).n393 as *const _ as usize },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(n393)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).lmi as *const _ as usize },
        20usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(lmi)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto)).dce as *const _ as usize },
        22usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto),
            "::",
            stringify!(dce)
        )
    );
}
impl Clone for fr_proto {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct fr_proto_pvc {
    pub dlci: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_fr_proto_pvc() {
    assert_eq!(
        ::std::mem::size_of::<fr_proto_pvc>(),
        4usize,
        concat!("Size of: ", stringify!(fr_proto_pvc))
    );
    assert_eq!(
        ::std::mem::align_of::<fr_proto_pvc>(),
        4usize,
        concat!("Alignment of ", stringify!(fr_proto_pvc))
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto_pvc)).dlci as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto_pvc),
            "::",
            stringify!(dlci)
        )
    );
}
impl Clone for fr_proto_pvc {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct fr_proto_pvc_info {
    pub dlci: ::std::os::raw::c_uint,
    pub master: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_fr_proto_pvc_info() {
    assert_eq!(
        ::std::mem::size_of::<fr_proto_pvc_info>(),
        20usize,
        concat!("Size of: ", stringify!(fr_proto_pvc_info))
    );
    assert_eq!(
        ::std::mem::align_of::<fr_proto_pvc_info>(),
        4usize,
        concat!("Alignment of ", stringify!(fr_proto_pvc_info))
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto_pvc_info)).dlci as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto_pvc_info),
            "::",
            stringify!(dlci)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const fr_proto_pvc_info)).master as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(fr_proto_pvc_info),
            "::",
            stringify!(master)
        )
    );
}
impl Clone for fr_proto_pvc_info {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct cisco_proto {
    pub interval: ::std::os::raw::c_uint,
    pub timeout: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_cisco_proto() {
    assert_eq!(
        ::std::mem::size_of::<cisco_proto>(),
        8usize,
        concat!("Size of: ", stringify!(cisco_proto))
    );
    assert_eq!(
        ::std::mem::align_of::<cisco_proto>(),
        4usize,
        concat!("Alignment of ", stringify!(cisco_proto))
    );
    assert_eq!(
        unsafe { &(*(0 as *const cisco_proto)).interval as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(cisco_proto),
            "::",
            stringify!(interval)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const cisco_proto)).timeout as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(cisco_proto),
            "::",
            stringify!(timeout)
        )
    );
}
impl Clone for cisco_proto {
    fn clone(&self) -> Self {
        *self
    }
}
pub const net_device_flags_IFF_UP: net_device_flags = 1;
pub const net_device_flags_IFF_BROADCAST: net_device_flags = 2;
pub const net_device_flags_IFF_DEBUG: net_device_flags = 4;
pub const net_device_flags_IFF_LOOPBACK: net_device_flags = 8;
pub const net_device_flags_IFF_POINTOPOINT: net_device_flags = 16;
pub const net_device_flags_IFF_NOTRAILERS: net_device_flags = 32;
pub const net_device_flags_IFF_RUNNING: net_device_flags = 64;
pub const net_device_flags_IFF_NOARP: net_device_flags = 128;
pub const net_device_flags_IFF_PROMISC: net_device_flags = 256;
pub const net_device_flags_IFF_ALLMULTI: net_device_flags = 512;
pub const net_device_flags_IFF_MASTER: net_device_flags = 1024;
pub const net_device_flags_IFF_SLAVE: net_device_flags = 2048;
pub const net_device_flags_IFF_MULTICAST: net_device_flags = 4096;
pub const net_device_flags_IFF_PORTSEL: net_device_flags = 8192;
pub const net_device_flags_IFF_AUTOMEDIA: net_device_flags = 16384;
pub const net_device_flags_IFF_DYNAMIC: net_device_flags = 32768;
/**
 ** enum net_device_flags - &struct net_device flags
 **
 ** These are the &struct net_device flags, they can be set by drivers, the
 ** kernel and some can be triggered by userspace. Userspace can query and
 ** set these flags using userspace utilities but there is also a sysfs
 ** entry available for all dev flags which can be queried and set. These flags
 ** are shared for all types of net_devices. The sysfs entries are available
 ** via /sys/class/net/<dev>/flags. Flags which can be toggled through sysfs
 ** are annotated below, note that only a few flags can be toggled and some
 ** other flags are always preserved from the original net_device flags
 ** even if you try to set them via sysfs. Flags which are always preserved
 ** are kept under the flag grouping @IFF_VOLATILE. Flags which are __volatile__
 ** are annotated below as such.
 **
 ** You should have a pretty good reason to be extending these flags.
 **
 ** @IFF_UP: interface is up. Can be toggled through sysfs.
 ** @IFF_BROADCAST: broadcast address valid. Volatile.
 ** @IFF_DEBUG: turn on debugging. Can be toggled through sysfs.
 ** @IFF_LOOPBACK: is a loopback net. Volatile.
 ** @IFF_POINTOPOINT: interface is has p-p link. Volatile.
 ** @IFF_NOTRAILERS: avoid use of trailers. Can be toggled through sysfs.
 **	Volatile.
 ** @IFF_RUNNING: interface RFC2863 OPER_UP. Volatile.
 ** @IFF_NOARP: no ARP protocol. Can be toggled through sysfs. Volatile.
 ** @IFF_PROMISC: receive all packets. Can be toggled through sysfs.
 ** @IFF_ALLMULTI: receive all multicast packets. Can be toggled through
 **	sysfs.
 ** @IFF_MASTER: master of a load balancer. Volatile.
 ** @IFF_SLAVE: slave of a load balancer. Volatile.
 ** @IFF_MULTICAST: Supports multicast. Can be toggled through sysfs.
 ** @IFF_PORTSEL: can set media type. Can be toggled through sysfs.
 ** @IFF_AUTOMEDIA: auto media select active. Can be toggled through sysfs.
 ** @IFF_DYNAMIC: dialup device with changing addresses. Can be toggled
 **	through sysfs.
 ** @IFF_LOWER_UP: driver signals L1 up. Volatile.
 ** @IFF_DORMANT: driver signals dormant. Volatile.
 ** @IFF_ECHO: echo sent packets. Volatile.
 **/
pub type net_device_flags = ::std::os::raw::c_uint;
pub const IF_OPER_UNKNOWN: _bindgen_ty_4 = 0;
pub const IF_OPER_NOTPRESENT: _bindgen_ty_4 = 1;
pub const IF_OPER_DOWN: _bindgen_ty_4 = 2;
pub const IF_OPER_LOWERLAYERDOWN: _bindgen_ty_4 = 3;
pub const IF_OPER_TESTING: _bindgen_ty_4 = 4;
pub const IF_OPER_DORMANT: _bindgen_ty_4 = 5;
pub const IF_OPER_UP: _bindgen_ty_4 = 6;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub const IF_LINK_MODE_DEFAULT: _bindgen_ty_5 = 0;
pub const IF_LINK_MODE_DORMANT: _bindgen_ty_5 = 1;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct ifmap {
    pub mem_start: ::std::os::raw::c_ulong,
    pub mem_end: ::std::os::raw::c_ulong,
    pub base_addr: ::std::os::raw::c_ushort,
    pub irq: ::std::os::raw::c_uchar,
    pub dma: ::std::os::raw::c_uchar,
    pub port: ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout_ifmap() {
    assert_eq!(
        ::std::mem::size_of::<ifmap>(),
        24usize,
        concat!("Size of: ", stringify!(ifmap))
    );
    assert_eq!(
        ::std::mem::align_of::<ifmap>(),
        8usize,
        concat!("Alignment of ", stringify!(ifmap))
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifmap)).mem_start as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifmap),
            "::",
            stringify!(mem_start)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifmap)).mem_end as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifmap),
            "::",
            stringify!(mem_end)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifmap)).base_addr as *const _ as usize },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifmap),
            "::",
            stringify!(base_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifmap)).irq as *const _ as usize },
        18usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifmap),
            "::",
            stringify!(irq)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifmap)).dma as *const _ as usize },
        19usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifmap),
            "::",
            stringify!(dma)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifmap)).port as *const _ as usize },
        20usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifmap),
            "::",
            stringify!(port)
        )
    );
}
impl Clone for ifmap {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct if_settings {
    pub type_: ::std::os::raw::c_uint,
    pub size: ::std::os::raw::c_uint,
    pub ifs_ifsu: if_settings__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct if_settings__bindgen_ty_1 {
    pub raw_hdlc: __BindgenUnionField<*mut raw_hdlc_proto>,
    pub cisco: __BindgenUnionField<*mut cisco_proto>,
    pub fr: __BindgenUnionField<*mut fr_proto>,
    pub fr_pvc: __BindgenUnionField<*mut fr_proto_pvc>,
    pub fr_pvc_info: __BindgenUnionField<*mut fr_proto_pvc_info>,
    pub sync: __BindgenUnionField<*mut sync_serial_settings>,
    pub te1: __BindgenUnionField<*mut te1_settings>,
    pub bindgen_union_field: u64,
}
#[test]
fn bindgen_test_layout_if_settings__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<if_settings__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(if_settings__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<if_settings__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(if_settings__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).raw_hdlc as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(raw_hdlc)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).cisco as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(cisco)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).fr as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(fr)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).fr_pvc as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(fr_pvc)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).fr_pvc_info as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(fr_pvc_info)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).sync as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(sync)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings__bindgen_ty_1)).te1 as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings__bindgen_ty_1),
            "::",
            stringify!(te1)
        )
    );
}
impl Clone for if_settings__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[test]
fn bindgen_test_layout_if_settings() {
    assert_eq!(
        ::std::mem::size_of::<if_settings>(),
        16usize,
        concat!("Size of: ", stringify!(if_settings))
    );
    assert_eq!(
        ::std::mem::align_of::<if_settings>(),
        8usize,
        concat!("Alignment of ", stringify!(if_settings))
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings)).type_ as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings)).size as *const _ as usize },
        4usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const if_settings)).ifs_ifsu as *const _ as usize },
        8usize,
        concat!(
            "Alignment of field: ",
            stringify!(if_settings),
            "::",
            stringify!(ifs_ifsu)
        )
    );
}
impl Clone for if_settings {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct ifreq {
    pub ifr_ifrn: ifreq__bindgen_ty_1,
    pub ifr_ifru: ifreq__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct ifreq__bindgen_ty_1 {
    pub ifrn_name: __BindgenUnionField<[::std::os::raw::c_uchar; 16usize]>,
    pub bindgen_union_field: [u8; 16usize],
}
#[test]
fn bindgen_test_layout_ifreq__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<ifreq__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(ifreq__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<ifreq__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(ifreq__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_1)).ifrn_name as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_1),
            "::",
            stringify!(ifrn_name)
        )
    );
}
impl Clone for ifreq__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy)]
pub struct ifreq__bindgen_ty_2 {
    pub ifru_addr: __BindgenUnionField<sockaddr>,
    pub ifru_dstaddr: __BindgenUnionField<sockaddr>,
    pub ifru_broadaddr: __BindgenUnionField<sockaddr>,
    pub ifru_netmask: __BindgenUnionField<sockaddr>,
    pub ifru_hwaddr: __BindgenUnionField<sockaddr>,
    pub ifru_flags: __BindgenUnionField<::std::os::raw::c_short>,
    pub ifru_ivalue: __BindgenUnionField<::std::os::raw::c_int>,
    pub ifru_mtu: __BindgenUnionField<::std::os::raw::c_int>,
    pub ifru_map: __BindgenUnionField<ifmap>,
    pub ifru_slave: __BindgenUnionField<[::std::os::raw::c_char; 16usize]>,
    pub ifru_newname: __BindgenUnionField<[::std::os::raw::c_char; 16usize]>,
    pub ifru_data: __BindgenUnionField<*mut ::std::os::raw::c_void>,
    pub ifru_settings: __BindgenUnionField<if_settings>,
    pub bindgen_union_field: [u64; 3usize],
}
#[test]
fn bindgen_test_layout_ifreq__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<ifreq__bindgen_ty_2>(),
        24usize,
        concat!("Size of: ", stringify!(ifreq__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<ifreq__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(ifreq__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_addr as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_dstaddr as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_dstaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_broadaddr as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_broadaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_netmask as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_netmask)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_hwaddr as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_hwaddr)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_flags as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_ivalue as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_ivalue)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_mtu as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_mtu)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_map as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_map)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_slave as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_slave)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_newname as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_newname)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_data as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_data)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq__bindgen_ty_2)).ifru_settings as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq__bindgen_ty_2),
            "::",
            stringify!(ifru_settings)
        )
    );
}
impl Clone for ifreq__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
#[test]
fn bindgen_test_layout_ifreq() {
    assert_eq!(
        ::std::mem::size_of::<ifreq>(),
        40usize,
        concat!("Size of: ", stringify!(ifreq))
    );
    assert_eq!(
        ::std::mem::align_of::<ifreq>(),
        8usize,
        concat!("Alignment of ", stringify!(ifreq))
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq)).ifr_ifrn as *const _ as usize },
        0usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq),
            "::",
            stringify!(ifr_ifrn)
        )
    );
    assert_eq!(
        unsafe { &(*(0 as *const ifreq)).ifr_ifru as *const _ as usize },
        16usize,
        concat!(
            "Alignment of field: ",
            stringify!(ifreq),
            "::",
            stringify!(ifr_ifru)
        )
    );
}
impl Clone for ifreq {
    fn clone(&self) -> Self {
        *self
    }
}
