# Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
# SPDX-License-Identifier: Apache-2.0
"""Configuration file for the network TCP throughput test."""

# pylint: disable=C0302
DEBUG = False

IPERF3 = "iperf3"
THROUGHPUT = "throughput"
THROUGHPUT_TOTAL = "total"
DURATION = "duration"
DURATION_TOTAL = "total"
RETRANSMITS = "retransmits"
RETRANSMITS_TOTAL = "total"
CPU_UTILIZATION_HOST = "cpu_utilization_host"
CPU_UTILIZATION_GUEST = "cpu_utilization_guest"
BASE_PORT = 5000
CPU_UTILIZATION_VMM_TAG = "vmm"
CPU_UTILIZATION_VCPUS_TOTAL_TAG = "vcpus_total"
IPERF3_CPU_UTILIZATION_PERCENT_OUT_TAG = "cpu_utilization_percent"
IPERF3_END_RESULTS_TAG = "end"
DEBUG_CPU_UTILIZATION_VMM_SAMPLES_TAG = "cpu_utilization_vmm_samples"
DELTA_PERCENTAGE_TAG = "delta_percentage"
TARGET_TAG = "target"

CONFIG = {
    "time": 20,  # seconds
    "load_factor": 1,
    "modes": {
        "g2h": [""],
        "h2g": ["-R"],
        "bd": ["", "-R"]
    },
    "protocols": [
        {
            "name": "tcp",
            "omit": 5,
            "window_size": ["16K", "256K", None],
            "payload_length": ["1024K", None],
        }
    ],
    "hosts": {
        "instances": {
            "m5d.metal": {
                "cpus": [
                    {
                        "model": "Intel(R) Xeon(R) Platinum 8259CL CPU @ "
                                 "2.50GHz",
                        'baseline_bw': {
                            'vmlinux-4.14.bin/ubuntu-18.04.ext4': {
                                'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 3359, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 25813,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 28051,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 3363, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 25835,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 28806,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 4144, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 23533,
                                    DELTA_PERCENTAGE_TAG: 9},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 30387,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 4147, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 25834,
                                    DELTA_PERCENTAGE_TAG: 15},
                                'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 33251,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 4164, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 26737,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 30161,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 4164,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 27379,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 31033,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2976, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 20375,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 27174,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2973, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 20379,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 28513,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2619, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 14510,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 31480,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2620, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 16999,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 33932,
                                    DELTA_PERCENTAGE_TAG: 5}},
                            'vmlinux-4.9.bin/ubuntu-18.04.ext4': {
                                'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 3114, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 25659,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 27725,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 3114, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 25661,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 28344,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 4202, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 23208,
                                    DELTA_PERCENTAGE_TAG: 9},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 26071,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 4201, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 25986,
                                    DELTA_PERCENTAGE_TAG: 14},
                                'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 32578,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 3955, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 26075,
                                    DELTA_PERCENTAGE_TAG: 8},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 29308,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 3945,
                                    DELTA_PERCENTAGE_TAG: 13},
                                'tcp-p1024K-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 26777,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 30801,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2857, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 20169,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 27132,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2858, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 20180,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 27699,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2563, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 14245,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 24591,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2564, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 16910,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 33405,
                                    DELTA_PERCENTAGE_TAG: 5}}},
                        'baseline_cpu_utilization': {
                            'vmlinux-4.14.bin/ubuntu-18.04.ext4': {
                                'vmm': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 57,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 94,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 57,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 94,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 83,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 83,
                                        DELTA_PERCENTAGE_TAG: 13},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 58,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 91,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 94,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 58,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 91,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 93,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 49,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 75,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 90,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 49,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 75,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 92,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 39,
                                        DELTA_PERCENTAGE_TAG: 11},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 56,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 87,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 39,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 54,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 88,
                                        DELTA_PERCENTAGE_TAG: 6}},
                                'vcpus_total': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 114,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 114,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 190,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 186,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 197,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 176,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 164,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5}}},
                            'vmlinux-4.9.bin/ubuntu-18.04.ext4': {
                                'vmm': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 88,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 93,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 93,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 51,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 82,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 84,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 84,
                                        DELTA_PERCENTAGE_TAG: 11},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 88,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 55,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 90,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 94,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 55,
                                        DELTA_PERCENTAGE_TAG: 14},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 92,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 47,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 74,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 90,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 47,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 74,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 90,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 38,
                                        DELTA_PERCENTAGE_TAG: 11},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 55,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 78,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 38,
                                        DELTA_PERCENTAGE_TAG: 11},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 54,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 87,
                                        DELTA_PERCENTAGE_TAG: 7}},
                                'vcpus_total': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 114,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 118,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 197,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 181,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 184,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 175,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 164,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5}}}}
                    },
                    {
                        "model": "Intel(R) Xeon(R) Platinum 8175M CPU @ "
                                 "2.50GHz",
                        'baseline_bw': {
                            'vmlinux-4.14.bin/ubuntu-18.04.ext4': {
                                'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 2749, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 24153,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 26827,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 2756, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 24139,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 27491,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 3434, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 20573,
                                    DELTA_PERCENTAGE_TAG: 8},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 27994,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 3439, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 24089,
                                    DELTA_PERCENTAGE_TAG: 15},
                                'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 31885,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 3236, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 23782,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 29144,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 3246,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 24308,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 29493,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2521, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 18606,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 25446,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2519, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 18638,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 26616,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2207, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 13812,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 29579,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-p1024K-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2209, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 14839,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 31913,
                                    DELTA_PERCENTAGE_TAG: 7}},
                            'vmlinux-4.9.bin/ubuntu-18.04.ext4': {
                                'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 2946, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 26944,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 27140,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-2vcpu-g2h': {
                                    TARGET_TAG: 2948, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws256K-2vcpu-g2h': {
                                    TARGET_TAG: 26949,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                    TARGET_TAG: 27722,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 4040, DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 21646,
                                    DELTA_PERCENTAGE_TAG: 8},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 26125,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-p1024K-ws16K-2vcpu-h2g': {
                                    TARGET_TAG: 4046, DELTA_PERCENTAGE_TAG: 7},
                                'tcp-p1024K-ws256K-2vcpu-h2g': {
                                    TARGET_TAG: 23994,
                                    DELTA_PERCENTAGE_TAG: 11},
                                'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                    TARGET_TAG: 33624,
                                    DELTA_PERCENTAGE_TAG: 8},
                                'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 3723, DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 25134,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 28180,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws16K-2vcpu-bd': {
                                    TARGET_TAG: 3720,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-ws256K-2vcpu-bd': {
                                    TARGET_TAG: 25933,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                    TARGET_TAG: 29736,
                                    DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2582, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 19537,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 26151,
                                    DELTA_PERCENTAGE_TAG: 27},
                                'tcp-p1024K-ws16K-1vcpu-g2h': {
                                    TARGET_TAG: 2580, DELTA_PERCENTAGE_TAG: 5},
                                'tcp-p1024K-ws256K-1vcpu-g2h': {
                                    TARGET_TAG: 19529,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                    TARGET_TAG: 27303,
                                    DELTA_PERCENTAGE_TAG: 6},
                                'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2439, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 14706,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 24763,
                                    DELTA_PERCENTAGE_TAG: 7},
                                'tcp-p1024K-ws16K-1vcpu-h2g': {
                                    TARGET_TAG: 2439, DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-ws256K-1vcpu-h2g': {
                                    TARGET_TAG: 15958,
                                    DELTA_PERCENTAGE_TAG: 4},
                                'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                    TARGET_TAG: 34569,
                                    DELTA_PERCENTAGE_TAG: 6}}},
                        'baseline_cpu_utilization': {
                            'vmlinux-4.14.bin/ubuntu-18.04.ext4': {
                                'vmm': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 56,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 94,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 56,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 94,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 80,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 87,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 84,
                                        DELTA_PERCENTAGE_TAG: 13},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 57,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 95,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 57,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 89,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 93,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 51,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 74,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 90,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 51,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 74,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 91,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 40,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 59,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 86,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 40,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 52,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 86,
                                        DELTA_PERCENTAGE_TAG: 7}},
                                'vcpus_total': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 197,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 121,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 119,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 185,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 184,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 181,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 197,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 165,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5}}},
                            'vmlinux-4.9.bin/ubuntu-18.04.ext4': {
                                'vmm': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 57,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 97,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 95,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 57,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 97,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 95,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 60,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 84,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 88,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 61,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 84,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 92,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 62,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 92,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 95,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 62,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 92,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 93,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 51,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 78,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 91,
                                        DELTA_PERCENTAGE_TAG: 26},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 51,
                                        DELTA_PERCENTAGE_TAG: 9},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 78,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 93,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 44,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 60,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 82,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 44,
                                        DELTA_PERCENTAGE_TAG: 10},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 56,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 90,
                                        DELTA_PERCENTAGE_TAG: 7}},
                                'vcpus_total': {
                                    'tcp-pDEFAULT-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 117,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-p1024K-ws16K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-g2h': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-g2h': {
                                        TARGET_TAG: 112,
                                        DELTA_PERCENTAGE_TAG: 8},
                                    'tcp-pDEFAULT-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 197,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 182,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-h2g': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-h2g': {
                                        TARGET_TAG: 187,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-pDEFAULT-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 174,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-p1024K-ws16K-2vcpu-bd': {
                                        TARGET_TAG: 198,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-2vcpu-bd': {
                                        TARGET_TAG: 197,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-2vcpu-bd': {
                                        TARGET_TAG: 163,
                                        DELTA_PERCENTAGE_TAG: 6},
                                    'tcp-pDEFAULT-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 7},
                                    'tcp-p1024K-ws16K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-g2h': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-pDEFAULT-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws16K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-ws256K-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5},
                                    'tcp-p1024K-wsDEFAULT-1vcpu-h2g': {
                                        TARGET_TAG: 99,
                                        DELTA_PERCENTAGE_TAG: 5}}}}
                    }
                ]
            }
        }
    }
}
