# Changelog

## [0.4.0]

### Added

* The CPU Template can be set with an API call on PUT /machine-config. The only available template is T2.
* Hyperthreading can be enabled/disabled with an API call on PUT /machine-config. By default, hyperthreading is disabled.
* Added boot time performance test (tests/performance/test_boottime.py).
* Added Rate Limiter for Virtio block and net devices. The Rate Limiter uses two token buckets to limit rate on bytes/s
  and ops/s. The rate limiter can be (optionally) configured per drive with a PUT on /drives/{drive_id} and per network
  interface with a PUT on /network-interface/{iface_id}.
* Implemented pre-boot PUT updates for /boot-source, /drives, /network-interfaces and /vsock.
* Added integration tests for PUT updates.

### Changed

* Moved the API definition (swagger/firecracker-beta.yaml) to the api_server crate.
* Removed "console=ttyS0" and added "8250.nr_uarts=0" to the default kernel command line to decrease the boot time.
* Changed the CPU topology to have all logical CPUs on a single socket.
* Removed the upper bound on CPU count as with musl there is no good way to get the total number of logical processors
  on a host.
* Build time tests now print the full output of commands.
* Disabled the Performance Monitor Unit and the Turbo Boost.
* Check the expected KVM capabilities before starting the VM.
* Logs now have timestamps.

### Fixed

* testrun.sh can run on platforms with more than one package manager by setting the package manager via a command
  line parameter (-p).
* Allow correct set up of multiple network-interfaces with autogenerated MAC.
* Fixed sporadic bug in virtio which was causing lost packages.
* Don't allow PUT requests with empty body on /machine-config.
* Deny PUT operations after the microvm boots (exception: the temporarily fix for live resize of block devices).

### Removed
* Removed examples crate. This used to have a Python example of starting Firecracker. This is replaced by test_api.py
  integration tests.
* Removed helper scripts for getting coverage and coding style errors. These were replaced by test_coverage.py and
  test_style.py test integration tests.
* Removed --vmm-no-api command line option. Firecracker can only be started via the API.

## [0.3.0]

### Added

* Users can interrogate the Machine Configuration (i.e. vcpu count and memory size) using a GET request on /machine-config.
* The logging system can be configured through the API using a PUT on /logger.
* Block devices support live resize by calling PUT with the same parameters as when the block was created.
* Release builds have Link Time Optimization (LTO) enabled.
* Firecracker is built with musl, resulting in a statically linked binary.
* More in-tree integration tests were added as part of the continuous integration system.

### Changed

* The vcpu count is enforced to 1 or an even number.
* The Swagger definition of rate limiters was updated.
* Syslog-enabled logs were replaced with a hostfile backed mechanism.

### Fixed

* The host topology of the CPU and the caches is not leaked into the microvm anymore.
* Boot time was improved by advertising the availability of the TSC deadline timer.
* Fixed an issue which prevented Firecracker from working on 4.14 (or newer) host kernels.
* Specifying the MAC address for an interface through the API is optional.

### Removed

* Removed support for attaching vsock devices.
* Removed support for building Firecracker with glibc.


## [0.2.0]

### Added

* Users can now interrogate Instance Information (currently just instance state) through the API.

### Changed

* Renamed `api/swagger/all.yaml` to `api/swagger/firecracker-v1.0.yaml` which specifies targeted API support for Firecracker v1.0.
* Renamed `api/swagger/firecracker-v0.1.yaml` to `api/swagger/firecracker-beta.yaml` which specifies the currently supported API.
* Users can now enforce that an emulated block device is read-only via the API. To specify whether a block device is read-only or read-write, an extra "permissions" field was added to the Drive definition in the API. The root filesystem is automatically mounted in the guest OS as ro/rw according to the specified "permissions". It's the responsibility of the user to mount any other read-only block device as such within the guest OS.
* Users can now stop the guest VM using the API. Actions of type 'InstanceHalt' are now supported via the API.

### Fixed

* Added support for getDeviceID() in virtIO-block. Without this, the guest Linux kernel would complain at boot time that the operation is unsupported.
* STDIN control is returned to the Firecracker process when guest VM is inactive. Raw mode STDIN is forwarded to the guest OS when guest VM is running.

### Removed

* Removed `api/swagger/actions.yaml`.
* Removed `api/swagger/devices.yaml`.
* Removed `api/swagger/firecracker-mvp.yaml`.
* Removed `api/swagger/limiters.yaml`.


## [0.1.1]

### Changed

* Users can now specify the MAC address of a guest network interface via the PUT network interface API request. Previously, the guest MAC address parameter was ignored.

### Fixed

* Fixed a guest memory allocation issue, which previously led to a potentially significant memory chunk being wasted.
* Fixed an issue which caused compilation problems, due to a compatibility breaking transitive dependency in the tokio suite of crates.


## [0.1.0]

### Added

* One-process virtual machine manager (one Firecracker per microVM).
* RESTful API running on a unix socket. The API supported by v0.1 can be found at `api/swagger/firecracker-v0.1.yaml`.
* Emulated keyboard (i8042) and serial console (UART). The microVM serial console input and output are connected to those of the Firecracker process (this allows direct console access to the guest OS).
* The capability of mapping an existing host tun-tap device as a virtIO/net device into the microVM.
* The capability of mapping an existing host file as a virtIO/block device into the microVM.
* The capability of creating a virtIO/vsock between the host and the microVM.
* Default demand fault paging & CPU oversubscription.
