/*
 * Decompiled with CFR 0.152.
 */
package ai.lucidtech.las.sdk;

import ai.lucidtech.las.sdk.APIException;
import ai.lucidtech.las.sdk.ContentType;
import ai.lucidtech.las.sdk.CreateAssetOptions;
import ai.lucidtech.las.sdk.CreateBatchOptions;
import ai.lucidtech.las.sdk.CreateDocumentOptions;
import ai.lucidtech.las.sdk.CreatePredictionOptions;
import ai.lucidtech.las.sdk.CreateSecretOptions;
import ai.lucidtech.las.sdk.CreateTransitionOptions;
import ai.lucidtech.las.sdk.CreateUserOptions;
import ai.lucidtech.las.sdk.CreateWorkflowOptions;
import ai.lucidtech.las.sdk.Credentials;
import ai.lucidtech.las.sdk.ListAssetsOptions;
import ai.lucidtech.las.sdk.ListDocumentsOptions;
import ai.lucidtech.las.sdk.ListModelsOptions;
import ai.lucidtech.las.sdk.ListPredictionsOptions;
import ai.lucidtech.las.sdk.ListResourcesOptions;
import ai.lucidtech.las.sdk.ListSecretsOptions;
import ai.lucidtech.las.sdk.ListTransitionExecutionsOptions;
import ai.lucidtech.las.sdk.ListTransitionsOptions;
import ai.lucidtech.las.sdk.ListUsersOptions;
import ai.lucidtech.las.sdk.ListWorkflowExecutionsOptions;
import ai.lucidtech.las.sdk.ListWorkflowsOptions;
import ai.lucidtech.las.sdk.MissingAccessTokenException;
import ai.lucidtech.las.sdk.TransitionExecutionStatus;
import ai.lucidtech.las.sdk.TransitionType;
import ai.lucidtech.las.sdk.UpdateAssetOptions;
import ai.lucidtech.las.sdk.UpdateSecretOptions;
import ai.lucidtech.las.sdk.UpdateTransitionExecutionOptions;
import ai.lucidtech.las.sdk.UpdateTransitionOptions;
import ai.lucidtech.las.sdk.UpdateUserOptions;
import ai.lucidtech.las.sdk.UpdateWorkflowOptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Client {
    private HttpClient httpClient;
    private Credentials credentials;

    public Client(Credentials credentials) {
        this.credentials = credentials;
        this.httpClient = HttpClientBuilder.create().build();
    }

    public JSONObject createAsset(byte[] content, CreateAssetOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("content", (Object)Base64.getEncoder().encodeToString(content));
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/assets", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createAsset(InputStream content, CreateAssetOptions options) throws IOException, APIException, MissingAccessTokenException {
        return this.createAsset(IOUtils.toByteArray((InputStream)content), options);
    }

    public JSONObject createAsset(byte[] content) throws IOException, APIException, MissingAccessTokenException {
        return this.createAsset(content, null);
    }

    public JSONObject createAsset(InputStream content) throws IOException, APIException, MissingAccessTokenException {
        return this.createAsset(IOUtils.toByteArray((InputStream)content), null);
    }

    public JSONObject listAssets(ListAssetsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/assets", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listAssets() throws IOException, APIException, MissingAccessTokenException {
        return this.listAssets(new ListAssetsOptions());
    }

    public JSONObject getAsset(String assetId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/assets/" + assetId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject updateAsset(String assetId, UpdateAssetOptions options) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", "/assets/" + assetId, options.toJson());
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createBatch(CreateBatchOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/batches", body);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject createBatch() throws IOException, APIException, MissingAccessTokenException {
        return this.createBatch(null);
    }

    public JSONObject createDocument(byte[] content, ContentType contentType, CreateDocumentOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("content", (Object)Base64.getEncoder().encodeToString(content));
        body.put("contentType", (Object)contentType.getMimeType());
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/documents", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createDocument(InputStream content, ContentType contentType, CreateDocumentOptions options) throws IOException, APIException, MissingAccessTokenException {
        byte[] byteArrayContent = IOUtils.toByteArray((InputStream)content);
        return this.createDocument(byteArrayContent, contentType, options);
    }

    public JSONObject createDocument(InputStream content, ContentType contentType) throws IOException, APIException, MissingAccessTokenException {
        byte[] byteArrayContent = IOUtils.toByteArray((InputStream)content);
        return this.createDocument(byteArrayContent, contentType, null);
    }

    public JSONObject createDocument(byte[] content, ContentType contentType) throws IOException, APIException, MissingAccessTokenException {
        return this.createDocument(content, contentType, null);
    }

    public JSONObject listDocuments(ListDocumentsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/documents", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listDocuments() throws IOException, APIException, MissingAccessTokenException {
        return this.listDocuments(new ListDocumentsOptions());
    }

    public JSONObject deleteDocuments() throws IOException, APIException, MissingAccessTokenException {
        return this.deleteDocuments(null);
    }

    public JSONObject deleteDocuments(String consentId) throws IOException, APIException, MissingAccessTokenException {
        ArrayList<NameValuePair> consent = new ArrayList<NameValuePair>();
        if (consentId != null) {
            consent.add((NameValuePair)new BasicNameValuePair("consentId", consentId));
        }
        HttpUriRequest request = this.createAuthorizedRequest("DELETE", "/documents", consent);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject getDocument(String documentId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/documents/" + documentId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject updateDocument(String documentId, JSONArray groundTruth) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("groundTruth", (Object)groundTruth);
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", "/documents/" + documentId, body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject getLog(String logId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/logs/" + logId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listModels(ListModelsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/models", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listModels() throws IOException, APIException, MissingAccessTokenException {
        return this.listModels(new ListModelsOptions());
    }

    public JSONObject createPrediction(String documentId, String modelId, CreatePredictionOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("documentId", (Object)documentId);
        body.put("modelId", (Object)modelId);
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/predictions", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createPrediction(String documentId, String modelId) throws IOException, APIException, MissingAccessTokenException {
        return this.createPrediction(documentId, modelId, null);
    }

    public JSONObject listPredictions(ListPredictionsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/predictions", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listPredictions() throws IOException, APIException, MissingAccessTokenException {
        return this.listPredictions(new ListPredictionsOptions());
    }

    public JSONObject createSecret(final JSONObject data, CreateSecretOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject(){
            {
                this.put("data", data);
            }
        };
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/secrets", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createSecret(Map<String, String> data, CreateSecretOptions options) throws IOException, APIException, MissingAccessTokenException {
        return this.createSecret(new JSONObject(data), options);
    }

    public JSONObject createSecret(Map<String, String> data) throws IOException, APIException, MissingAccessTokenException {
        return this.createSecret(data, null);
    }

    public JSONObject createSecret(JSONObject data) throws IOException, APIException, MissingAccessTokenException {
        return this.createSecret(data, null);
    }

    public JSONObject listSecrets(ListSecretsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/secrets", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listSecrets() throws IOException, APIException, MissingAccessTokenException {
        return this.listSecrets(new ListSecretsOptions());
    }

    public JSONObject updateSecret(String secretId, UpdateSecretOptions options) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", "/secrets/" + secretId, options.toJson());
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createTransition(TransitionType transitionType, CreateTransitionOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("transitionType", (Object)transitionType.value);
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/transitions", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createTransition(TransitionType transitionType) throws IOException, APIException, MissingAccessTokenException {
        return this.createTransition(transitionType, null);
    }

    public JSONObject listTransitions(ListTransitionsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/transitions", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listTransitions() throws IOException, APIException, MissingAccessTokenException {
        return this.listTransitions(new ListTransitionsOptions());
    }

    public JSONObject getTransition(String transitionId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/transitions/" + transitionId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject updateTransition(String transitionId, UpdateTransitionOptions options) throws IOException, APIException, MissingAccessTokenException {
        String path = "/transitions/" + transitionId;
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", path, options.toJson());
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject executeTransition(String transitionId) throws IOException, APIException, MissingAccessTokenException {
        String path = "/transitions/" + transitionId + "/executions";
        HttpUriRequest request = this.createAuthorizedRequest("POST", path, new JSONObject());
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject deleteTransition(String transitionId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("DELETE", "/transitions/" + transitionId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listTransitionExecutions(String transitionId, ListTransitionExecutionsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        String path = "/transitions/" + transitionId + "/executions";
        HttpUriRequest request = this.createAuthorizedRequest("GET", path, queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listTransitionExecutions(String transitionId) throws IOException, APIException, MissingAccessTokenException {
        return this.listTransitionExecutions(transitionId, new ListTransitionExecutionsOptions());
    }

    public JSONObject getTransitionExecution(String transitionId, String executionId) throws IOException, APIException, MissingAccessTokenException {
        String path = "/transitions/" + transitionId + "/executions/" + executionId;
        HttpUriRequest request = this.createAuthorizedRequest("GET", path);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject updateTransitionExecution(String transitionId, String executionId, TransitionExecutionStatus status, UpdateTransitionExecutionOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("status", (Object)status.value);
        body = options.addOptions(body);
        String path = "/transitions/" + transitionId + "/executions/" + executionId;
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", path, body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createUser(String email, CreateUserOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("email", (Object)email);
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/users", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createUser(String email) throws IOException, APIException, MissingAccessTokenException {
        return this.createUser(email, null);
    }

    public JSONObject listUsers(ListUsersOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/users", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listUsers() throws IOException, APIException, MissingAccessTokenException {
        return this.listUsers(null);
    }

    public JSONObject getUser(String userId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/users/" + userId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject updateUser(String userId, UpdateUserOptions options) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", "/users/" + userId, options.toJson());
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject deleteUser(String userId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("DELETE", "/users/" + userId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject createWorkflow(JSONObject specification, CreateWorkflowOptions options) throws IOException, APIException, MissingAccessTokenException {
        JSONObject body = new JSONObject();
        body.put("specification", (Object)specification);
        if (options != null) {
            body = options.addOptions(body);
        }
        HttpUriRequest request = this.createAuthorizedRequest("POST", "/workflows", body);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject createWorkflow(JSONObject specification) throws IOException, APIException, MissingAccessTokenException {
        return this.createWorkflow(specification, null);
    }

    public JSONObject listWorkflows(ListWorkflowsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/workflows", queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listWorkflows() throws IOException, APIException, MissingAccessTokenException {
        return this.listWorkflows(new ListWorkflowsOptions());
    }

    public JSONObject getWorkflow(String workflowId) throws IOException, APIException, MissingAccessTokenException {
        HttpUriRequest request = this.createAuthorizedRequest("GET", "/workflows/" + workflowId);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject updateWorkflow(String workflowId, UpdateWorkflowOptions options) throws IOException, APIException, MissingAccessTokenException {
        String path = "/workflows/" + workflowId;
        HttpUriRequest request = this.createAuthorizedRequest("PATCH", path, options.toJson());
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject deleteWorkflow(String workflowId) throws IOException, APIException, MissingAccessTokenException {
        String path = "/workflows/" + workflowId;
        HttpUriRequest request = this.createAuthorizedRequest("DELETE", path);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject executeWorkflow(String workflowId, JSONObject content) throws IOException, APIException, MissingAccessTokenException {
        String path = "/workflows/" + workflowId + "/executions";
        HttpUriRequest request = this.createAuthorizedRequest("POST", path, content);
        String jsonResponse = this.executeRequest(request);
        return new JSONObject(jsonResponse);
    }

    public JSONObject listWorkflowExecutions(String workflowId, ListWorkflowExecutionsOptions options) throws IOException, APIException, MissingAccessTokenException {
        List<NameValuePair> queryParameters = this.getQueryParameters(options);
        String path = "/workflows/" + workflowId + "/executions";
        HttpUriRequest request = this.createAuthorizedRequest("GET", path, queryParameters);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    public JSONObject listWorkflowExecutions(String workflowId) throws IOException, APIException, MissingAccessTokenException {
        return this.listWorkflowExecutions(workflowId, new ListWorkflowExecutionsOptions());
    }

    public JSONObject deleteWorkflowExecution(String workflowId, String executionId) throws IOException, APIException, MissingAccessTokenException {
        String path = "/workflows/" + workflowId + "/executions/" + executionId;
        HttpUriRequest request = this.createAuthorizedRequest("DELETE", path);
        String response = this.executeRequest(request);
        return new JSONObject(response);
    }

    private String executeRequest(HttpUriRequest request) throws IOException, APIException {
        HttpResponse httpResponse = this.httpClient.execute(request);
        HttpEntity responseEntity = httpResponse.getEntity();
        StatusLine statusLine = httpResponse.getStatusLine();
        int status = statusLine.getStatusCode();
        if (status == 403) {
            throw new APIException("Credentials provided are not valid");
        }
        if (status == 429) {
            throw new APIException("You have reached the limit of requests per second");
        }
        if (status > 299) {
            throw new APIException(status, statusLine.getReasonPhrase());
        }
        return EntityUtils.toString((HttpEntity)responseEntity);
    }

    private URI createUri(String path) throws URISyntaxException {
        String apiEndpoint = this.credentials.getApiEndpoint();
        return new URI(apiEndpoint + path);
    }

    private URI createUri(String path, List<NameValuePair> queryParams) throws URISyntaxException {
        String apiEndpoint = this.credentials.getApiEndpoint();
        URI uri = new URI(apiEndpoint + path);
        URIBuilder builder = new URIBuilder(uri);
        builder.addParameters(queryParams);
        return builder.build();
    }

    private HttpUriRequest createAuthorizedRequest(String method, String path) throws MissingAccessTokenException {
        HttpGet request;
        URI uri;
        try {
            uri = this.createUri(path);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Failed to create url");
        }
        switch (method) {
            case "GET": {
                request = new HttpGet(uri);
                break;
            }
            case "DELETE": {
                request = new HttpDelete(uri);
                break;
            }
            default: {
                throw new IllegalArgumentException("HTTP verb not supported: " + method);
            }
        }
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Authorization", "Bearer " + this.credentials.getAccessToken(this.httpClient));
        request.addHeader("X-Api-Key", this.credentials.getApiKey());
        return request;
    }

    private HttpUriRequest createAuthorizedRequest(String method, String path, List<NameValuePair> queryParams) throws MissingAccessTokenException {
        HttpGet request;
        URI uri;
        try {
            uri = this.createUri(path, queryParams);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Failed to create url");
        }
        switch (method) {
            case "GET": {
                request = new HttpGet(uri);
                break;
            }
            case "DELETE": {
                request = new HttpDelete(uri);
                break;
            }
            default: {
                throw new IllegalArgumentException("HTTP verb not supported: " + method);
            }
        }
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Authorization", "Bearer " + this.credentials.getAccessToken(this.httpClient));
        request.addHeader("X-Api-Key", this.credentials.getApiKey());
        return request;
    }

    private HttpUriRequest createAuthorizedRequest(String method, String path, JSONObject jsonBody) throws MissingAccessTokenException {
        HttpGet request;
        URI uri;
        try {
            uri = this.createUri(path);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Failed to create url");
        }
        byte[] body = null;
        switch (method) {
            case "GET": {
                request = new HttpGet(uri);
                break;
            }
            case "DELETE": {
                request = new HttpDelete(uri);
                break;
            }
            case "PATCH": {
                request = new HttpPatch(uri);
                body = jsonBody.toString().getBytes();
                ByteArrayEntity entity = new ByteArrayEntity(body);
                ((HttpPatch)request).setEntity((HttpEntity)entity);
                break;
            }
            case "POST": {
                request = new HttpPost(uri);
                body = jsonBody.toString().getBytes();
                ByteArrayEntity entity = new ByteArrayEntity(body);
                ((HttpPost)request).setEntity((HttpEntity)entity);
                break;
            }
            default: {
                throw new IllegalArgumentException("HTTP verb not supported: " + method);
            }
        }
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Authorization", "Bearer " + this.credentials.getAccessToken(this.httpClient));
        request.addHeader("X-Api-Key", this.credentials.getApiKey());
        return request;
    }

    private List<NameValuePair> getQueryParameters(ListResourcesOptions options) {
        List<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (options != null) {
            parameters = options.addOptions(parameters);
        }
        return parameters;
    }
}

