/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common;

import ai.platon.pulsar.common.ObjectCache;
import ai.platon.pulsar.common.config.ImmutableConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MimeTypeResolver {
    private static final String SEPARATOR = ";";
    private static final Logger LOG = LoggerFactory.getLogger((String)MimeTypeResolver.class.getName());
    private MimeTypes mimeTypes;
    private TikaConfig tikaConfig = TikaConfig.getDefaultConfig();
    private Tika tika = new Tika(this.tikaConfig);
    private boolean mimeMagic;

    public MimeTypeResolver(ImmutableConfig conf) {
        ObjectCache objectCache = ObjectCache.get((ImmutableConfig)conf);
        MimeTypes mt = (MimeTypes)objectCache.getBean(MimeTypes.class);
        if (mt == null) {
            try {
                String customMimeTypeFile = conf.get("mime.types.file");
                if (customMimeTypeFile != null && !customMimeTypeFile.isEmpty()) {
                    try {
                        mt = MimeTypesFactory.create((InputStream)conf.getConfResourceAsInputStream(customMimeTypeFile));
                    }
                    catch (Exception e) {
                        LOG.error("Can't load mime.types.file : " + customMimeTypeFile + " using Tika's default");
                    }
                }
                if (mt == null) {
                    mt = MimeTypes.getDefaultMimeTypes();
                }
            }
            catch (Exception e) {
                LOG.error("Exception in MimeUtil " + e.getMessage());
                throw new RuntimeException(e);
            }
            objectCache.put((Object)mt);
        }
        this.mimeTypes = mt;
        this.mimeMagic = conf.getBoolean("mime.type.magic", true);
    }

    public static String cleanMimeType(String origType) {
        if (origType == null) {
            return null;
        }
        String[] tokenizedMimeType = origType.split(SEPARATOR);
        if (tokenizedMimeType.length > 1) {
            return tokenizedMimeType[0];
        }
        return origType;
    }

    public void reload(ImmutableConfig conf) {
    }

    public String autoResolveContentType(String typeName, @NotNull String url, @Nullable byte[] data) {
        String retType = null;
        MimeType type = null;
        String cleanedMimeType = null;
        cleanedMimeType = MimeTypeResolver.cleanMimeType(typeName);
        if (cleanedMimeType != null) {
            try {
                type = this.mimeTypes.forName(cleanedMimeType);
                cleanedMimeType = type.getName();
            }
            catch (MimeTypeException mte) {
                cleanedMimeType = null;
            }
        }
        if (type == null || type.getName().equals("application/octet-stream")) {
            try {
                retType = this.tika.detect(url);
            }
            catch (Exception e) {
                String message = "Problem loading default Tika configuration";
                LOG.error(message, (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            retType = type.getName();
        }
        if (this.mimeMagic && data != null) {
            String magicType = null;
            Metadata tikaMeta = new Metadata();
            tikaMeta.add("Content-Type", cleanedMimeType != null ? cleanedMimeType : typeName);
            try (TikaInputStream stream = TikaInputStream.get((byte[])data);){
                magicType = this.tika.detect((InputStream)stream, tikaMeta);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(magicType == null || magicType.equals("application/octet-stream") || magicType.equals("text/plain") || retType == null || retType.equals(magicType))) {
                retType = magicType;
            }
            if (retType == null) {
                try {
                    retType = "application/octet-stream";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return retType;
    }

    public String getMimeType(String url) {
        return this.tika.detect(url);
    }

    public String forName(String name) {
        try {
            return this.mimeTypes.forName(name).toString();
        }
        catch (MimeTypeException e) {
            LOG.error("Exception getting mime type by name: [" + name + "]: Message: " + e.getMessage());
            return null;
        }
    }

    public String getMimeType(File f) {
        try {
            return this.tika.detect(f);
        }
        catch (Exception e) {
            LOG.error("Exception getting mime type for file: [" + f.getPath() + "]: Message: " + e.getMessage());
            return null;
        }
    }
}

