/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ObjectConverter;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.collect.FatLinkExtractor;
import ai.platon.pulsar.common.collect.HyperlinkExtractor;
import ai.platon.pulsar.common.collect.PageFatLink;
import ai.platon.pulsar.common.message.LoadStatusFormatter;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.urls.CrawlableFatLink;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.common.urls.StatefulHyperlink;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.preprocess.UrlNormalizer;
import ai.platon.pulsar.common.urls.preprocess.UrlNormalizerPipeline;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.session.AbstractPulsarSession;
import ai.platon.pulsar.session.PulsarSession;
import com.codahale.metrics.Gauge;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ2\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J&\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J \u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$J,\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020)H\u0002J\u001e\u0010+\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$J4\u0010-\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lai/platon/pulsar/common/collect/FatLinkExtractor;", "", "session", "Lai/platon/pulsar/session/PulsarSession;", "normalizer", "Lai/platon/pulsar/common/urls/preprocess/UrlNormalizerPipeline;", "(Lai/platon/pulsar/session/PulsarSession;Lai/platon/pulsar/common/urls/preprocess/UrlNormalizerPipeline;)V", "abstractSession", "Lai/platon/pulsar/session/AbstractPulsarSession;", "getAbstractSession", "()Lai/platon/pulsar/session/AbstractPulsarSession;", "counters", "Lai/platon/pulsar/common/collect/FatLinkExtractor$Companion$Counters;", "getCounters", "()Lai/platon/pulsar/common/collect/FatLinkExtractor$Companion$Counters;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNormalizer", "()Lai/platon/pulsar/common/urls/preprocess/UrlNormalizerPipeline;", "getSession", "()Lai/platon/pulsar/session/PulsarSession;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "createFatLink", "Lai/platon/pulsar/common/collect/PageFatLink;", "seed", "Lai/platon/pulsar/common/urls/NormUrl;", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "denyList", "", "Lai/platon/pulsar/common/urls/UrlAware;", "options", "Lai/platon/pulsar/common/options/LoadOptions;", "loadVividLinks", "", "Lai/platon/pulsar/common/urls/StatefulHyperlink;", "normalizeOrNull", "Lai/platon/pulsar/common/urls/Hyperlink;", "hyperlink", "parse", "", "parseVividLinks", "shouldFetchVividPage", "", "url", "", "expires", "Ljava/time/Duration;", "now", "Ljava/time/Instant;", "Companion", "pulsar-skeleton"})
public final class FatLinkExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final UrlNormalizerPipeline normalizer;
    private final Logger log;
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final Companion.Counters counters;
    @NotNull
    private static final Companion.Counters globalCounters = new Companion.Counters(0, 0, 0, 0, 0, 0, 0, 0, 0, 511, null);
    @NotNull
    private static final Map<String, Gauge<Integer>> gauges;

    public FatLinkExtractor(@NotNull PulsarSession session, @NotNull UrlNormalizerPipeline normalizer) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)normalizer, (String)"normalizer");
        this.session = session;
        this.normalizer = normalizer;
        this.log = LoggerFactory.getLogger(FatLinkExtractor.class);
        this.webDb = this.getAbstractSession().getContext().getWebDb();
        this.counters = new Companion.Counters(0, 0, 0, 0, 0, 0, 0, 0, 0, 511, null);
    }

    public /* synthetic */ FatLinkExtractor(PulsarSession pulsarSession, UrlNormalizerPipeline urlNormalizerPipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            urlNormalizerPipeline = new UrlNormalizerPipeline(null, 1, null);
        }
        this(pulsarSession, urlNormalizerPipeline);
    }

    @NotNull
    public final PulsarSession getSession() {
        return this.session;
    }

    @NotNull
    public final UrlNormalizerPipeline getNormalizer() {
        return this.normalizer;
    }

    private final AbstractPulsarSession getAbstractSession() {
        return (AbstractPulsarSession)this.session;
    }

    @NotNull
    public final Companion.Counters getCounters() {
        return this.counters;
    }

    public final void parse(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.createFatLink(page, document, options);
    }

    @Nullable
    public final PageFatLink createFatLink(@NotNull NormUrl seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        boolean bl = false;
        return this.createFatLink(seed, CollectionsKt.emptyList());
    }

    @Nullable
    public final PageFatLink createFatLink(@NotNull NormUrl seed, @NotNull WebPage page, @NotNull Collection<? extends UrlAware> denyList) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter(denyList, (String)"denyList");
        Companion.Counters counters = this.counters;
        counters.setLoadedSeeds(counters.getLoadedSeeds() + 1);
        counters.getLoadedSeeds();
        counters = globalCounters;
        counters.setLoadedSeeds(counters.getLoadedSeeds() + 1);
        counters.getLoadedSeeds();
        if (page.getContent() == null) {
            return null;
        }
        FeaturedDocument document = PulsarSession.DefaultImpls.parse$default(this.session, page, false, 2, null);
        return this.createFatLink(seed, page, document, denyList);
    }

    @Nullable
    public final PageFatLink createFatLink(@NotNull NormUrl seed, @NotNull Collection<? extends UrlAware> denyList) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter(denyList, (String)"denyList");
        WebPage page = this.session.load(seed);
        if (!page.getProtocolStatus().isSuccess()) {
            Object object = this.counters;
            ((Companion.Counters)object).setBadSeeds(((Companion.Counters)object).getBadSeeds() + 1);
            ((Companion.Counters)object).getBadSeeds();
            object = globalCounters;
            ((Companion.Counters)object).setBadSeeds(((Companion.Counters)object).getBadSeeds() + 1);
            ((Companion.Counters)object).getBadSeeds();
            object = new LoadStatusFormatter(page, "Bad seed", true, false, false, false, 56, null);
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.log.warn(((LoadStatusFormatter)it).toString());
            return null;
        }
        return this.createFatLink(seed, page, denyList);
    }

    @Nullable
    public final PageFatLink createFatLink(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull LoadOptions options) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        return this.createFatLink(new NormUrl(string, options, null, null, 12, null), page, document);
    }

    @Nullable
    public final PageFatLink createFatLink(@NotNull NormUrl seed, @NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        boolean bl = false;
        return this.createFatLink(seed, page, document, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PageFatLink createFatLink(@NotNull NormUrl seed, @NotNull WebPage page, @Nullable FeaturedDocument document, @NotNull Collection<? extends UrlAware> denyList) {
        CrawlableFatLink fatLink;
        Iterable $this$associateWith$iv$iv;
        Object object;
        ObjectConverter objectConverter;
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter(denyList, (String)"denyList");
        String fatLinkSpec = seed.getSpec();
        String string = this.normalizer.invoke(fatLinkSpec);
        String normalizedFatLink = string == null ? fatLinkSpec : string;
        LoadOptions options = seed.getOptions();
        CharSequence charSequence = options.getLabel();
        boolean bl = false;
        String args = !StringsKt.isBlank((CharSequence)charSequence) ? "-label " + options.getLabel() : "";
        String selector = options.getOutLinkSelector();
        Instant now = Instant.now();
        if (document != null) {
            objectConverter = this.parseVividLinks(seed, page, document, denyList);
            boolean bl2 = false;
            boolean bl3 = false;
            List<StatefulHyperlink> it = objectConverter;
            boolean bl4 = false;
            page.setFetchedLinkCount(0);
            object = objectConverter;
        } else {
            object = this.loadVividLinks(page, options, denyList);
        }
        List<StatefulHyperlink> vividLinks = object;
        this.counters.setFetchLinks(vividLinks.size());
        objectConverter = globalCounters;
        objectConverter.setFetchLinks(objectConverter.getFetchLinks() + vividLinks.size());
        if (vividLinks.isEmpty()) {
            String string2;
            Map map2;
            void $this$associateByTo$iv$iv$iv;
            objectConverter = new Object[5];
            objectConverter[0] = page.getId();
            objectConverter[1] = Strings.readableBytes((long)page.getContentLength());
            Object object2 = Duration.between(page.getPrevFetchTime(), now);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"between(page.prevFetchTime, now)");
            objectConverter[2] = DateTimesKt.readable((Duration)object2);
            objectConverter[3] = selector;
            objectConverter[4] = seed;
            this.log.info("{}. No new link in portal page({}), latest fetch at: {} | <{}> | {}", (Object[])objectConverter);
            objectConverter = ObjectConverter.INSTANCE;
            object2 = this.counters;
            Integer n = page.getId();
            String string3 = "{}. {}";
            Logger logger = this.log;
            boolean $i$f$asMap = false;
            Iterable $this$associateBy$iv$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(Companion.Counters.class));
            boolean $i$f$associateBy = false;
            int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv$iv;
            Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
                void it$iv;
                KProperty1 kProperty1 = (KProperty1)element$iv$iv$iv2;
                map2 = destination$iv$iv$iv;
                boolean bl5 = false;
                string2 = it$iv.getName();
                map2.put(string2, element$iv$iv$iv2);
            }
            Map props$iv = destination$iv$iv$iv;
            $this$associateWith$iv$iv = props$iv.keySet();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv$iv = $this$associateWith$iv$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv$iv : $this$associateWithTo$iv$iv$iv) {
                void t$iv;
                void it$iv;
                Object element$iv$iv$iv2;
                element$iv$iv$iv2 = (String)element$iv$iv$iv;
                string2 = element$iv$iv$iv;
                map2 = result$iv$iv;
                boolean bl6 = false;
                KProperty1 kProperty1 = (KProperty1)props$iv.get(it$iv);
                Object object3 = kProperty1 == null ? null : kProperty1.get((Object)t$iv);
                map2.put(string2, object3);
            }
            Map map3 = result$iv$iv;
            logger.info(string3, (Object)n, (Object)CollectionsKt.joinToString$default((Iterable)map3.entrySet(), null, null, null, (int)0, null, null, (int)63, null));
            if (document != null && this.counters.getUnfilteredLinks() == 0) {
                Path path = PulsarSession.DefaultImpls.export$default(this.session, page, null, 2, null);
                this.log.info("{}. No any link in the page, exported to {}", (Object)page.getId(), (Object)path);
            }
            fatLink = new CrawlableFatLink(normalizedFatLink, null, 0, null, null, fatLinkSpec, null, 94, null);
            return new PageFatLink(page, fatLink);
        }
        if (document != null) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Object object4;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = vividLinks;
            boolean $i$f$map = false;
            $this$associateWith$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StatefulHyperlink $i$f$associateByTo = (StatefulHyperlink)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                object4 = new HyperlinkPersistable(it.getUrl(), it.getText(), it.getOrder());
                collection.add(object4);
            }
            List hyperlinks = (List)destination$iv$iv;
            $this$map$iv = hyperlinks;
            collection = page;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map4 = destination$iv$iv2;
                HyperlinkPersistable it = (HyperlinkPersistable)element$iv$iv;
                boolean bl8 = false;
                Pair pair = TuplesKt.to((Object)it.getUrl(), (Object)(it.getText() + " createdAt: " + now));
                boolean bl9 = false;
                map4.put(pair.getFirst(), pair.getSecond());
            }
            object4 = destination$iv$iv2;
            collection.setVividLinks((Map)object4);
        }
        fatLink = new CrawlableFatLink(normalizedFatLink, null, 0, null, args, fatLinkSpec, vividLinks, 14, null);
        return new PageFatLink(page, fatLink);
    }

    public static /* synthetic */ PageFatLink createFatLink$default(FatLinkExtractor fatLinkExtractor, NormUrl normUrl, WebPage webPage, FeaturedDocument featuredDocument, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            featuredDocument = null;
        }
        return fatLinkExtractor.createFatLink(normUrl, webPage, featuredDocument, collection);
    }

    private final List<StatefulHyperlink> parseVividLinks(NormUrl seed, WebPage page, FeaturedDocument document, Collection<? extends UrlAware> denyList) {
        Instant now = Instant.now();
        String fatLinkSpec = seed.getSpec();
        LoadOptions options = seed.getOptions();
        String selector = options.getOutLinkSelector();
        String string = options.getOutLinkPattern();
        boolean bl = false;
        Regex urlRegex = new Regex(string);
        if (StringsKt.isBlank((CharSequence)selector)) {
            boolean bl2 = false;
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)new HyperlinkExtractor(page, document, selector, (UrlNormalizer)this.normalizer).extract()), (Function1)((Function1)new Function1<Hyperlink, Unit>(this){
            final /* synthetic */ FatLinkExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Companion.Counters counters = this.this$0.getCounters();
                counters.setUnfilteredLinks(counters.getUnfilteredLinks() + 1);
                counters.getUnfilteredLinks();
                counters = FatLinkExtractor.Companion.getGlobalCounters();
                counters.setUnfilteredLinks(counters.getUnfilteredLinks() + 1);
                counters.getUnfilteredLinks();
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Boolean>(urlRegex){
            final /* synthetic */ Regex $urlRegex;
            {
                this.$urlRegex = $urlRegex;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CharSequence charSequence = it.getUrl();
                Regex regex = this.$urlRegex;
                boolean bl = false;
                return regex.matches(charSequence);
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Unit>(this){
            final /* synthetic */ FatLinkExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Companion.Counters counters = this.this$0.getCounters();
                counters.setRegexMatchedLinks(counters.getRegexMatchedLinks() + 1);
                counters.getRegexMatchedLinks();
                counters = FatLinkExtractor.Companion.getGlobalCounters();
                counters.setRegexMatchedLinks(counters.getRegexMatchedLinks() + 1);
                counters.getRegexMatchedLinks();
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Boolean>(denyList){
            final /* synthetic */ Collection<UrlAware> $denyList;
            {
                this.$denyList = $denyList;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$denyList.contains(it);
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Unit>(this){
            final /* synthetic */ FatLinkExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Companion.Counters counters = this.this$0.getCounters();
                counters.setAllowLinks(counters.getAllowLinks() + 1);
                counters.getAllowLinks();
                counters = FatLinkExtractor.Companion.getGlobalCounters();
                counters.setAllowLinks(counters.getAllowLinks() + 1);
                counters.getAllowLinks();
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Hyperlink>(this){
            final /* synthetic */ FatLinkExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Hyperlink invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FatLinkExtractor.access$normalizeOrNull(this.this$0, it);
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Boolean>(this, options, now){
            final /* synthetic */ FatLinkExtractor this$0;
            final /* synthetic */ LoadOptions $options;
            final /* synthetic */ Instant $now;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$now = $now;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getUrl();
                Comparable<Duration> comparable = this.$options.getItemExpires();
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"options.itemExpires");
                Duration duration = comparable;
                comparable = this.$now;
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"now");
                return this.this$0.shouldFetchVividPage(string, duration, (Instant)comparable);
            }
        })), (Function1)((Function1)new Function1<Hyperlink, StatefulHyperlink>(fatLinkSpec){
            final /* synthetic */ String $fatLinkSpec;
            {
                this.$fatLinkSpec = $fatLinkSpec;
                super(1);
            }

            @NotNull
            public final StatefulHyperlink invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new StatefulHyperlink(it.getUrl(), it.getText(), it.getOrder(), this.$fatLinkSpec, null, null, 48, null);
            }
        })), (Function1)parseVividLinks.9.INSTANCE));
    }

    private final Hyperlink normalizeOrNull(Hyperlink hyperlink) {
        Hyperlink hyperlink2;
        String normUrl = this.normalizer.invoke(hyperlink.getUrl());
        if (normUrl != null) {
            Hyperlink hyperlink3 = hyperlink;
            boolean bl = false;
            boolean bl2 = false;
            Hyperlink it = hyperlink3;
            boolean bl3 = false;
            it.setUrl(normUrl);
            hyperlink2 = hyperlink3;
        } else {
            hyperlink2 = null;
        }
        return hyperlink2;
    }

    private final List<StatefulHyperlink> loadVividLinks(WebPage page, LoadOptions options, Collection<? extends UrlAware> denyList) {
        Instant now = Instant.now();
        Object object = options.getOutLinkPattern();
        boolean bl = false;
        Regex urlRegex = new Regex((String)object);
        object = page.getVividLinks();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.vividLinks");
        return SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)MapsKt.asSequence((Map)object), (Function1)((Function1)new Function1<Map.Entry<? extends CharSequence, ? extends CharSequence>, Pair<? extends String, ? extends String>>(this){
            final /* synthetic */ FatLinkExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<String, String> invoke(@NotNull Map.Entry<? extends CharSequence, ? extends CharSequence> it) {
                Pair pair;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                String string = this.this$0.getNormalizer().invoke(((Object)it.getKey()).toString());
                if (string == null) {
                    pair = null;
                } else {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String u = string2;
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)u, (Object)((Object)it.getValue()).toString());
                }
                return pair;
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, StatefulHyperlink>(page){
            final /* synthetic */ WebPage $page;
            {
                this.$page = $page;
                super(1);
            }

            @NotNull
            public final StatefulHyperlink invoke(@NotNull Pair<String, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return new StatefulHyperlink((String)it.getFirst(), (String)it.getSecond(), 0, this.$page.getUrl(), null, null, 48, null);
            }
        })), (Function1)((Function1)new Function1<StatefulHyperlink, Boolean>(denyList){
            final /* synthetic */ Collection<UrlAware> $denyList;
            {
                this.$denyList = $denyList;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StatefulHyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$denyList.contains(it);
            }
        })), (Function1)((Function1)new Function1<StatefulHyperlink, Boolean>(urlRegex){
            final /* synthetic */ Regex $urlRegex;
            {
                this.$urlRegex = $urlRegex;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StatefulHyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CharSequence charSequence = it.getUrl();
                Regex regex = this.$urlRegex;
                boolean bl = false;
                return regex.matches(charSequence);
            }
        })), (Function1)((Function1)new Function1<StatefulHyperlink, Boolean>(this, options, now){
            final /* synthetic */ FatLinkExtractor this$0;
            final /* synthetic */ LoadOptions $options;
            final /* synthetic */ Instant $now;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$now = $now;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StatefulHyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getUrl();
                Comparable<Duration> comparable = this.$options.getItemExpires();
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"options.itemExpires");
                Duration duration = comparable;
                comparable = this.$now;
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"now");
                return this.this$0.shouldFetchVividPage(string, duration, (Instant)comparable);
            }
        })), (Function1)loadVividLinks.6.INSTANCE));
    }

    public final boolean shouldFetchVividPage(@NotNull String url, @NotNull Duration expires, @NotNull Instant now) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        WebPage p = WebDb.getOrNull$default((WebDb)this.webDb, (String)url, (boolean)false, null, (int)6, null);
        if (p == null) {
            Companion.Counters counters = this.counters;
            counters.setFreshLinks(counters.getFreshLinks() + 1);
            counters.getFreshLinks();
            counters = globalCounters;
            counters.setFreshLinks(counters.getFreshLinks() + 1);
            counters.getFreshLinks();
            bl = true;
        } else if (!p.getProtocolStatus().isSuccess()) {
            Companion.Counters counters = this.counters;
            counters.setLastFailedLinks(counters.getLastFailedLinks() + 1);
            counters.getLastFailedLinks();
            counters = globalCounters;
            counters.setLastFailedLinks(counters.getLastFailedLinks() + 1);
            counters.getLastFailedLinks();
            bl = true;
        } else if (p.getPrevFetchTime().plus(expires).compareTo(now) < 0) {
            Companion.Counters counters = this.counters;
            counters.setExpiredLinks(counters.getExpiredLinks() + 1);
            counters.getExpiredLinks();
            counters = globalCounters;
            counters.setExpiredLinks(counters.getExpiredLinks() + 1);
            counters.getExpiredLinks();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Integer gauges$lambda-5() {
        return globalCounters.getUnfilteredLinks();
    }

    private static final Integer gauges$lambda-6() {
        return globalCounters.getRegexMatchedLinks();
    }

    private static final Integer gauges$lambda-7() {
        return globalCounters.getFreshLinks();
    }

    private static final Integer gauges$lambda-8() {
        return globalCounters.getLastFailedLinks();
    }

    private static final Integer gauges$lambda-9() {
        return globalCounters.getExpiredLinks();
    }

    private static final Integer gauges$lambda-10() {
        return globalCounters.getFetchLinks();
    }

    private static final Integer gauges$lambda-11() {
        return globalCounters.getLoadedSeeds();
    }

    public static final /* synthetic */ Hyperlink access$normalizeOrNull(FatLinkExtractor $this, Hyperlink hyperlink) {
        return $this.normalizeOrNull(hyperlink);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"unfilteredLinks", FatLinkExtractor::gauges$lambda-5), TuplesKt.to((Object)"regexMatchedLinks", FatLinkExtractor::gauges$lambda-6), TuplesKt.to((Object)"freshLinks", FatLinkExtractor::gauges$lambda-7), TuplesKt.to((Object)"lastFailedLinks", FatLinkExtractor::gauges$lambda-8), TuplesKt.to((Object)"expiredLinks", FatLinkExtractor::gauges$lambda-9), TuplesKt.to((Object)"fetchLinks", FatLinkExtractor::gauges$lambda-10), TuplesKt.to((Object)"loadedSeeds", FatLinkExtractor::gauges$lambda-11)};
        gauges = MapsKt.mapOf((Pair[])pairArray);
        AppMetrics.Companion.getReg().registerAll(Companion, gauges);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lai/platon/pulsar/common/collect/FatLinkExtractor$Companion;", "", "()V", "gauges", "", "", "Lcom/codahale/metrics/Gauge;", "", "kotlin.jvm.PlatformType", "globalCounters", "Lai/platon/pulsar/common/collect/FatLinkExtractor$Companion$Counters;", "getGlobalCounters", "()Lai/platon/pulsar/common/collect/FatLinkExtractor$Companion$Counters;", "Counters", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Counters getGlobalCounters() {
            return globalCounters;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b(\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003Jc\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010\u00a8\u00061"}, d2={"Lai/platon/pulsar/common/collect/FatLinkExtractor$Companion$Counters;", "", "unfilteredLinks", "", "regexMatchedLinks", "allowLinks", "freshLinks", "lastFailedLinks", "expiredLinks", "fetchLinks", "badSeeds", "loadedSeeds", "(IIIIIIIII)V", "getAllowLinks", "()I", "setAllowLinks", "(I)V", "getBadSeeds", "setBadSeeds", "getExpiredLinks", "setExpiredLinks", "getFetchLinks", "setFetchLinks", "getFreshLinks", "setFreshLinks", "getLastFailedLinks", "setLastFailedLinks", "getLoadedSeeds", "setLoadedSeeds", "getRegexMatchedLinks", "setRegexMatchedLinks", "getUnfilteredLinks", "setUnfilteredLinks", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "pulsar-skeleton"})
        public static final class Counters {
            private int unfilteredLinks;
            private int regexMatchedLinks;
            private int allowLinks;
            private int freshLinks;
            private int lastFailedLinks;
            private int expiredLinks;
            private int fetchLinks;
            private int badSeeds;
            private int loadedSeeds;

            public Counters(int unfilteredLinks, int regexMatchedLinks, int allowLinks, int freshLinks, int lastFailedLinks, int expiredLinks, int fetchLinks, int badSeeds, int loadedSeeds) {
                this.unfilteredLinks = unfilteredLinks;
                this.regexMatchedLinks = regexMatchedLinks;
                this.allowLinks = allowLinks;
                this.freshLinks = freshLinks;
                this.lastFailedLinks = lastFailedLinks;
                this.expiredLinks = expiredLinks;
                this.fetchLinks = fetchLinks;
                this.badSeeds = badSeeds;
                this.loadedSeeds = loadedSeeds;
            }

            public /* synthetic */ Counters(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n10 & 1) != 0) {
                    n = 0;
                }
                if ((n10 & 2) != 0) {
                    n2 = 0;
                }
                if ((n10 & 4) != 0) {
                    n3 = 0;
                }
                if ((n10 & 8) != 0) {
                    n4 = 0;
                }
                if ((n10 & 0x10) != 0) {
                    n5 = 0;
                }
                if ((n10 & 0x20) != 0) {
                    n6 = 0;
                }
                if ((n10 & 0x40) != 0) {
                    n7 = 0;
                }
                if ((n10 & 0x80) != 0) {
                    n8 = 0;
                }
                if ((n10 & 0x100) != 0) {
                    n9 = 0;
                }
                this(n, n2, n3, n4, n5, n6, n7, n8, n9);
            }

            public final int getUnfilteredLinks() {
                return this.unfilteredLinks;
            }

            public final void setUnfilteredLinks(int n) {
                this.unfilteredLinks = n;
            }

            public final int getRegexMatchedLinks() {
                return this.regexMatchedLinks;
            }

            public final void setRegexMatchedLinks(int n) {
                this.regexMatchedLinks = n;
            }

            public final int getAllowLinks() {
                return this.allowLinks;
            }

            public final void setAllowLinks(int n) {
                this.allowLinks = n;
            }

            public final int getFreshLinks() {
                return this.freshLinks;
            }

            public final void setFreshLinks(int n) {
                this.freshLinks = n;
            }

            public final int getLastFailedLinks() {
                return this.lastFailedLinks;
            }

            public final void setLastFailedLinks(int n) {
                this.lastFailedLinks = n;
            }

            public final int getExpiredLinks() {
                return this.expiredLinks;
            }

            public final void setExpiredLinks(int n) {
                this.expiredLinks = n;
            }

            public final int getFetchLinks() {
                return this.fetchLinks;
            }

            public final void setFetchLinks(int n) {
                this.fetchLinks = n;
            }

            public final int getBadSeeds() {
                return this.badSeeds;
            }

            public final void setBadSeeds(int n) {
                this.badSeeds = n;
            }

            public final int getLoadedSeeds() {
                return this.loadedSeeds;
            }

            public final void setLoadedSeeds(int n) {
                this.loadedSeeds = n;
            }

            public final int component1() {
                return this.unfilteredLinks;
            }

            public final int component2() {
                return this.regexMatchedLinks;
            }

            public final int component3() {
                return this.allowLinks;
            }

            public final int component4() {
                return this.freshLinks;
            }

            public final int component5() {
                return this.lastFailedLinks;
            }

            public final int component6() {
                return this.expiredLinks;
            }

            public final int component7() {
                return this.fetchLinks;
            }

            public final int component8() {
                return this.badSeeds;
            }

            public final int component9() {
                return this.loadedSeeds;
            }

            @NotNull
            public final Counters copy(int unfilteredLinks, int regexMatchedLinks, int allowLinks, int freshLinks, int lastFailedLinks, int expiredLinks, int fetchLinks, int badSeeds, int loadedSeeds) {
                return new Counters(unfilteredLinks, regexMatchedLinks, allowLinks, freshLinks, lastFailedLinks, expiredLinks, fetchLinks, badSeeds, loadedSeeds);
            }

            public static /* synthetic */ Counters copy$default(Counters counters, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
                if ((n10 & 1) != 0) {
                    n = counters.unfilteredLinks;
                }
                if ((n10 & 2) != 0) {
                    n2 = counters.regexMatchedLinks;
                }
                if ((n10 & 4) != 0) {
                    n3 = counters.allowLinks;
                }
                if ((n10 & 8) != 0) {
                    n4 = counters.freshLinks;
                }
                if ((n10 & 0x10) != 0) {
                    n5 = counters.lastFailedLinks;
                }
                if ((n10 & 0x20) != 0) {
                    n6 = counters.expiredLinks;
                }
                if ((n10 & 0x40) != 0) {
                    n7 = counters.fetchLinks;
                }
                if ((n10 & 0x80) != 0) {
                    n8 = counters.badSeeds;
                }
                if ((n10 & 0x100) != 0) {
                    n9 = counters.loadedSeeds;
                }
                return counters.copy(n, n2, n3, n4, n5, n6, n7, n8, n9);
            }

            @NotNull
            public String toString() {
                return "Counters(unfilteredLinks=" + this.unfilteredLinks + ", regexMatchedLinks=" + this.regexMatchedLinks + ", allowLinks=" + this.allowLinks + ", freshLinks=" + this.freshLinks + ", lastFailedLinks=" + this.lastFailedLinks + ", expiredLinks=" + this.expiredLinks + ", fetchLinks=" + this.fetchLinks + ", badSeeds=" + this.badSeeds + ", loadedSeeds=" + this.loadedSeeds + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.unfilteredLinks);
                result = result * 31 + Integer.hashCode(this.regexMatchedLinks);
                result = result * 31 + Integer.hashCode(this.allowLinks);
                result = result * 31 + Integer.hashCode(this.freshLinks);
                result = result * 31 + Integer.hashCode(this.lastFailedLinks);
                result = result * 31 + Integer.hashCode(this.expiredLinks);
                result = result * 31 + Integer.hashCode(this.fetchLinks);
                result = result * 31 + Integer.hashCode(this.badSeeds);
                result = result * 31 + Integer.hashCode(this.loadedSeeds);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Counters)) {
                    return false;
                }
                Counters counters = (Counters)other;
                if (this.unfilteredLinks != counters.unfilteredLinks) {
                    return false;
                }
                if (this.regexMatchedLinks != counters.regexMatchedLinks) {
                    return false;
                }
                if (this.allowLinks != counters.allowLinks) {
                    return false;
                }
                if (this.freshLinks != counters.freshLinks) {
                    return false;
                }
                if (this.lastFailedLinks != counters.lastFailedLinks) {
                    return false;
                }
                if (this.expiredLinks != counters.expiredLinks) {
                    return false;
                }
                if (this.fetchLinks != counters.fetchLinks) {
                    return false;
                }
                if (this.badSeeds != counters.badSeeds) {
                    return false;
                }
                return this.loadedSeeds == counters.loadedSeeds;
            }

            public Counters() {
                this(0, 0, 0, 0, 0, 0, 0, 0, 0, 511, null);
            }
        }
    }
}

