/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.CrawlableFatLinkCollector;
import ai.platon.pulsar.common.collect.FatLinkExtractor;
import ai.platon.pulsar.common.collect.PageFatLink;
import ai.platon.pulsar.common.collect.collector.AbstractPriorityDataCollector;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.urls.CrawlableFatLink;
import ai.platon.pulsar.common.urls.FatLink;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.common.urls.StatefulHyperlink;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.preprocess.UrlNormalizerPipeline;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.session.PulsarSession;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010/\u001a\u000200H\u0016J\u0016\u00101\u001a\u00020\r2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000203H\u0016J\u0016\u00104\u001a\u00020\r2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000205H\u0002J&\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u0002092\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000205H\u0002J\u001e\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000205H\u0004J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00160;H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010?\u001a\u00020@H\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010A\u001a\u00020\u0016H\u0016R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006B"}, d2={"Lai/platon/pulsar/common/collect/HyperlinkCollector;", "Lai/platon/pulsar/common/collect/collector/AbstractPriorityDataCollector;", "Lai/platon/pulsar/common/urls/UrlAware;", "Lai/platon/pulsar/common/collect/CrawlableFatLinkCollector;", "session", "Lai/platon/pulsar/session/PulsarSession;", "seeds", "Ljava/util/Queue;", "Lai/platon/pulsar/common/urls/NormUrl;", "priority", "Lai/platon/pulsar/common/Priority13;", "(Lai/platon/pulsar/session/PulsarSession;Ljava/util/Queue;Lai/platon/pulsar/common/Priority13;)V", "averageLinkCount", "", "getAverageLinkCount", "()I", "estimatedSize", "getEstimatedSize", "fatLinkExtractor", "Lai/platon/pulsar/common/collect/FatLinkExtractor;", "fatLinks", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lai/platon/pulsar/common/urls/CrawlableFatLink;", "getFatLinks", "()Ljava/util/concurrent/ConcurrentSkipListMap;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "parsedSeedCount", "getSeeds", "()Ljava/util/Queue;", "getSession", "()Lai/platon/pulsar/session/PulsarSession;", "size", "getSize", "urlNormalizer", "Lai/platon/pulsar/common/urls/preprocess/UrlNormalizerPipeline;", "getUrlNormalizer", "()Lai/platon/pulsar/common/urls/preprocess/UrlNormalizerPipeline;", "setUrlNormalizer", "(Lai/platon/pulsar/common/urls/preprocess/UrlNormalizerPipeline;)V", "clear", "", "collectTo", "sink", "", "collectTo0", "", "collectToUnsafe", "seed", "pageFatLink", "Lai/platon/pulsar/common/collect/PageFatLink;", "dump", "", "hasMore", "", "remove", "fatLink", "Lai/platon/pulsar/common/urls/FatLink;", "url", "pulsar-skeleton"})
public class HyperlinkCollector
extends AbstractPriorityDataCollector<UrlAware>
implements CrawlableFatLinkCollector {
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final Queue<NormUrl> seeds;
    private final Logger log;
    @NotNull
    private UrlNormalizerPipeline urlNormalizer;
    @NotNull
    private final FatLinkExtractor fatLinkExtractor;
    private int parsedSeedCount;
    @NotNull
    private String name;
    @NotNull
    private final ConcurrentSkipListMap<String, CrawlableFatLink> fatLinks;

    public HyperlinkCollector(@NotNull PulsarSession session, @NotNull Queue<NormUrl> seeds, @NotNull Priority13 priority) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(seeds, (String)"seeds");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        super(priority);
        this.session = session;
        this.seeds = seeds;
        this.log = LoggerFactory.getLogger(HyperlinkCollector.class);
        this.urlNormalizer = new UrlNormalizerPipeline(null, 1, null);
        this.fatLinkExtractor = new FatLinkExtractor(this.session, this.urlNormalizer);
        this.name = "HC";
        this.fatLinks = new ConcurrentSkipListMap();
    }

    public /* synthetic */ HyperlinkCollector(PulsarSession pulsarSession, Queue queue, Priority13 priority13, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            priority13 = Priority13.NORMAL;
        }
        this(pulsarSession, queue, priority13);
    }

    @NotNull
    public final PulsarSession getSession() {
        return this.session;
    }

    @NotNull
    public final Queue<NormUrl> getSeeds() {
        return this.seeds;
    }

    @NotNull
    public final UrlNormalizerPipeline getUrlNormalizer() {
        return this.urlNormalizer;
    }

    public final void setUrlNormalizer(@NotNull UrlNormalizerPipeline urlNormalizerPipeline) {
        Intrinsics.checkNotNullParameter((Object)urlNormalizerPipeline, (String)"<set-?>");
        this.urlNormalizer = urlNormalizerPipeline;
    }

    private final int getAverageLinkCount() {
        return this.getCollectedCount() / RangesKt.coerceAtLeast((int)this.parsedSeedCount, (int)1);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public int getSize() {
        return RangesKt.coerceAtLeast((int)this.getAverageLinkCount(), (int)1) * this.seeds.size();
    }

    public int getEstimatedSize() {
        return RangesKt.coerceAtLeast((int)this.getAverageLinkCount(), (int)1) * this.seeds.size();
    }

    @NotNull
    public ConcurrentSkipListMap<String, CrawlableFatLink> getFatLinks() {
        return this.fatLinks;
    }

    @Nullable
    public CrawlableFatLink remove(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (CrawlableFatLink)((ConcurrentSkipListMap)this.getFatLinks()).remove(url);
    }

    @Nullable
    public CrawlableFatLink remove(@NotNull FatLink fatLink) {
        Intrinsics.checkNotNullParameter((Object)fatLink, (String)"fatLink");
        return (CrawlableFatLink)((ConcurrentSkipListMap)this.getFatLinks()).remove(fatLink.getUrl());
    }

    public boolean hasMore() {
        Collection collection = this.seeds;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public int collectTo(@NotNull List<UrlAware> sink) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        this.beforeCollect();
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            Integer n = this.collectTo0((Collection<UrlAware>)sink);
            bl2 = false;
            object = Result.constructor-impl((Object)n);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.log.warn("Collect failed", it);
        }
        Integer n = 0;
        boolean bl9 = false;
        int count = ((Number)(Result.isFailure-impl((Object)object2) ? n : object2)).intValue();
        return this.afterCollect(count);
    }

    private final int collectTo0(Collection<UrlAware> sink) throws Exception {
        NormUrl normUrl = this.seeds.poll();
        if (normUrl == null) {
            return 0;
        }
        NormUrl seed = normUrl;
        CrawlableFatLink knownFatLink = (CrawlableFatLink)((ConcurrentSkipListMap)this.getFatLinks()).get(seed.getSpec());
        if (knownFatLink != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = knownFatLink.getNumActive();
            Duration duration = knownFatLink.getIdleTime();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"knownFatLink.idleTime");
            objectArray[1] = DateTimesKt.readable((Duration)duration);
            objectArray[2] = seed;
            this.log.warn("Still has {} active tasks | idle: {} | {}", objectArray);
            return 0;
        }
        return this.collectToUnsafe(seed, sink);
    }

    protected final int collectToUnsafe(@NotNull NormUrl seed, @NotNull Collection<UrlAware> sink) throws Exception {
        WebPage webPage;
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        HyperlinkCollector hyperlinkCollector = this;
        ++hyperlinkCollector.parsedSeedCount;
        int cfr_ignored_0 = hyperlinkCollector.parsedSeedCount;
        Object object = this.session.load(seed);
        boolean bl = false;
        boolean bl2 = false;
        WebPage it = object;
        boolean bl3 = false;
        Object object2 = webPage = it.getProtocolStatus().isSuccess() ? object : null;
        if (webPage == null) {
            return 0;
        }
        WebPage p = webPage;
        object = this.fatLinkExtractor.createFatLink(seed, p, sink);
        if (object == null) {
            return 0;
        }
        Object pageFatLink = object;
        return this.collectToUnsafe(seed, (PageFatLink)pageFatLink, sink);
    }

    private final int collectToUnsafe(NormUrl seed, PageFatLink pageFatLink, Collection<UrlAware> sink) {
        PageFatLink pageFatLink2 = pageFatLink;
        WebPage page = pageFatLink2.component1();
        CrawlableFatLink fatLink = pageFatLink2.component2();
        page.setPrevCrawlTime1(Instant.now());
        Object object = this.getFatLinks();
        String string = fatLink.getUrl();
        boolean bl = false;
        object.put(string, fatLink);
        object = fatLink.getHref();
        boolean bl2 = false;
        bl = false;
        bl = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        boolean bl5 = Intrinsics.areEqual((Object)fatLink.getHref(), (Object)seed.getSpec());
        bl2 = false;
        bl = false;
        bl = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        LoadOptions options = seed.getOptions();
        Object[] $this$onEach$iv = (Object[])CollectionsKt.distinct((Iterable)fatLink.getTailLinks());
        boolean $i$f$onEach = false;
        Object[] objectArray = $this$onEach$iv;
        boolean bl7 = false;
        boolean bl8 = false;
        Object[] $this$apply$iv = objectArray;
        boolean bl9 = false;
        for (Object t : $this$apply$iv) {
            StatefulHyperlink it = (StatefulHyperlink)t;
            boolean bl10 = false;
            StatefulHyperlink statefulHyperlink = it;
            statefulHyperlink.setArgs(statefulHyperlink.getArgs() + " -taskId " + options.getTaskId() + " -taskTime " + options.getTaskTime());
        }
        List tailLinks = (List)objectArray;
        int size = sink.size();
        CollectionsKt.toCollection((Iterable)tailLinks, sink);
        int size2 = sink.size();
        objectArray = new Object[]{page.getId(), fatLink.getLabel(), fatLink.getSize(), tailLinks.size(), size, size2, this.parsedSeedCount, seed};
        this.log.info("{}. Added fat link <{}>({}), added {}({} -> {}) fetch urls | {}. {}", objectArray);
        return tailLinks.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> dump() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.seeds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NormUrl normUrl = (NormUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public void clear() {
        this.seeds.clear();
    }

    public int removeAll(@NotNull List<? extends FatLink> fatLinks) {
        return CrawlableFatLinkCollector.DefaultImpls.removeAll((CrawlableFatLinkCollector)this, fatLinks);
    }

    public int removeAll(@NotNull Iterable<String> urls) {
        return CrawlableFatLinkCollector.DefaultImpls.removeAll((CrawlableFatLinkCollector)this, urls);
    }
}

