/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.collect.HyperlinkExtractorsKt;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.common.urls.preprocess.UrlNormalizer;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.pulsar.persist.WebPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lai/platon/pulsar/common/collect/HyperlinkExtractor;", "", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "selector", "", "normalizer", "Lai/platon/pulsar/common/urls/preprocess/UrlNormalizer;", "(Lai/platon/pulsar/persist/WebPage;Lai/platon/pulsar/dom/FeaturedDocument;Ljava/lang/String;Lai/platon/pulsar/common/urls/preprocess/UrlNormalizer;)V", "getDocument", "()Lai/platon/pulsar/dom/FeaturedDocument;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNormalizer", "()Lai/platon/pulsar/common/urls/preprocess/UrlNormalizer;", "getPage", "()Lai/platon/pulsar/persist/WebPage;", "getSelector", "()Ljava/lang/String;", "extract", "", "Lai/platon/pulsar/common/urls/Hyperlink;", "extractTo", "fetchUrls", "pulsar-skeleton"})
public class HyperlinkExtractor {
    @NotNull
    private final WebPage page;
    @NotNull
    private final FeaturedDocument document;
    @NotNull
    private final String selector;
    @Nullable
    private final UrlNormalizer normalizer;
    private final Logger log;

    public HyperlinkExtractor(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull String selector, @Nullable UrlNormalizer normalizer) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this.page = page;
        this.document = document;
        this.selector = selector;
        this.normalizer = normalizer;
        this.log = LoggerFactory.getLogger(HyperlinkExtractor.class);
    }

    public /* synthetic */ HyperlinkExtractor(WebPage webPage, FeaturedDocument featuredDocument, String string, UrlNormalizer urlNormalizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            urlNormalizer = null;
        }
        this(webPage, featuredDocument, string, urlNormalizer);
    }

    @NotNull
    public final WebPage getPage() {
        return this.page;
    }

    @NotNull
    public final FeaturedDocument getDocument() {
        return this.document;
    }

    @NotNull
    public final String getSelector() {
        return this.selector;
    }

    @Nullable
    public final UrlNormalizer getNormalizer() {
        return this.normalizer;
    }

    @NotNull
    public final Collection<Hyperlink> extract() {
        return this.extractTo(new LinkedHashSet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Hyperlink> extractTo(@NotNull Collection<Hyperlink> fetchUrls) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(fetchUrls, (String)"fetchUrls");
        String selector0 = QueriesKt.appendSelectorIfMissing((String)this.selector, (String)"a");
        int i = 0;
        Iterable $this$mapNotNull$iv = (Iterable)FeaturedDocument.select$default((FeaturedDocument)this.document, (String)selector0, (int)0, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Hyperlink hyperlink;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element element = (Element)element$iv$iv;
            boolean bl2 = false;
            String string2 = element.attr("abs:href");
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string2;
            boolean bl5 = false;
            String string3 = string = UrlUtils.isValidUrl((String)it) ? string2 : null;
            if (string == null) {
                hyperlink = null;
            } else {
                String string4 = string;
                bl4 = false;
                boolean bl6 = false;
                String it2 = string4;
                boolean bl7 = false;
                Object object = this.getNormalizer();
                String string5 = object == null ? null : (String)object.invoke((Object)it2);
                string4 = string2 = new Pair((Object)it2, (Object)(string5 == null ? it2 : string5));
                bl4 = false;
                bl6 = false;
                it2 = string4;
                boolean bl8 = false;
                String string6 = (String)it2.getSecond();
                object = element.text();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.text()");
                int n = i;
                i = n + 1;
                Hyperlink hyperlink2 = new Hyperlink(string6, (String)object, n, this.getPage().getUrl(), null, (String)it2.getFirst(), 16, null);
                hyperlink = hyperlink2;
            }
            if (hyperlink == null) continue;
            Hyperlink hyperlink3 = hyperlink;
            boolean bl9 = false;
            boolean bl10 = false;
            Hyperlink it$iv$iv = hyperlink3;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List parsedUrls = (List)destination$iv$iv;
        CollectionsKt.toCollection((Iterable)parsedUrls, fetchUrls);
        Collection collection = parsedUrls;
        Logger logger = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        HyperlinkExtractorsKt.access$reportHyperlink(this.page, collection, fetchUrls, logger);
        return fetchUrls;
    }
}

