/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.common.collect;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.persist.WebPage;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"reportHyperlink", "", "page", "Lai/platon/pulsar/persist/WebPage;", "links", "", "Lai/platon/pulsar/common/urls/Hyperlink;", "fetchUrls", "log", "Lorg/slf4j/Logger;", "pulsar-skeleton"})
public final class HyperlinkExtractorsKt {
    private static final void reportHyperlink(WebPage page, Collection<? extends Hyperlink> links2, Collection<? extends Hyperlink> fetchUrls, Logger log) {
        if (page.getContentLength() < 100L) {
            log.info("Portal page is illegal (too small) | {}", (Object)page.getUrl());
        } else {
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            Path exportLink = AppPaths.uniqueSymbolicLinkForUri$default((AppPaths)AppPaths.INSTANCE, (String)string, null, (int)2, null);
            String readableBytes = Strings.readableBytes((long)page.getContentLength());
            Object[] objectArray = new Object[]{page.getId(), links2.size(), readableBytes, fetchUrls.size(), exportLink, page.getUrl()};
            log.info("{}. There are {} links in portal page ({}), total {} fetch urls | file://{} | {}", objectArray);
        }
    }

    public static final /* synthetic */ void access$reportHyperlink(WebPage page, Collection links2, Collection fetchUrls, Logger log) {
        HyperlinkExtractorsKt.reportHyperlink(page, links2, fetchUrls, log);
    }
}

